//$Id: driver.h,v 1.14 2001/02/07 17:05:08 cactus Exp $ -*- c++ -*-

// RadioActive Copyright (C) 1999-2000 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef RADIO_DRIVER_H
#define RADIO_DRIVER_H

#include "radioactive.h"
#include <string>
#include <sigc++/object.h>
#include <sigc++/signal_system.h>
#include <linux/videodev.h>

class Radio: public SigC::Object
{
    int fd;
    int vol;
    bool muted;
    double fq;
    string filename;
public:
    Radio(const string& devicefile);
    void open_dev(const string& devicefile);
    string get_filename(){
	return filename;
    }
    
    void set(double freq);
    double get() {return fq;};
    void set_vol(int lvl);
    int get_vol() {return vol;};

    bool get_mute() {return muted;};
    void toggle_mute();
    SigC::Signal1<void, bool> mute;

    double get_freq_min();
    double get_freq_max();
private:
    void mute_impl(bool mute);

    double get_freq_fact();
    struct video_audio va;
    struct video_tuner tuner;
};

#endif
