// $Id: speedtuner.h,v 1.8 1999/12/17 23:47:10 cactus Exp $ -*- c++ -*-

// RadioActive Copyright (C) 1999 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef RADIO_speedtune
#define RADIO_speedtune

#include <gtk--.h>
#include <vector>

class SpeedTuner: public Gtk::Table
{
    vector<Gtk::Button*> btnProg;
    Gtk::Tooltips tips;
public:
    SpeedTuner(int row, int col);

    // A button was clicked
    SigC::Signal1<void, int> clicked;
    // The user wants to set a button's value
    SigC::Signal1<void, int> rclicked;
    
    // Setting the tooltips
    void set(const vector<string>& values);
    void set(int index, const string& value);
private:
    void btnProg_clicked(int btn);
    int btnProg_mouse(GdkEventButton *e, int btn);
};

#endif
