// $Id: wndMain.cc,v 1.54 2001/02/07 17:05:08 cactus Exp $

// RadioActive Copyright (C) 1999 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#include "common/wndMain.h"

#include "radioactive.h"
#include <stdexcept>
#include "common/file.h"
#include "common/repeat-button.h"

#include "common/arrow_left.xpm"
#include "common/arrow_right.xpm"
#include "common/tune_left.xpm"
#include "common/tune_right.xpm"

using namespace Gtk;
using namespace Gnome;
using namespace SigC;

wndMain::wndMain(Radio& radiodev):
    Window(GTK_WINDOW_TOPLEVEL),
    radio(radiodev),
    tuner(radiodev.get_freq_min(), radiodev.get_freq_max()),
    buttons(arg::progbutton_row, arg::progbutton_col),
    volume(),

    prog_vals(arg::progbutton_row * arg::progbutton_col,
	      pair<float, string>((float)0, "")),
    radio_file(radio.get_filename())
{
    set_title(PROGNAME " " VERSION);
    set_border_width(5);
    set_policy(false, false, false);
    button_press_event.connect(slot(this, &wndMain::mouse_clicked));
//    delete_event.connect(slot(this, &wndMain::cache_pos));
    Gtk::Main::quit.connect(slot(this, &wndMain::cache_pos));
    
    // Tuner
    tuner.set_value(curr_val = radio.get());
    tuner.tune.connect(slot(this, &wndMain::tuner_changed));

    // Tuner controls
    RepeatButton* button = 0;
    Gnome::Pixmap* pixmap = 0;
    
    Table* table = new Table(3, 3);
    table->set_usize(180, 0);
    table->set_border_width(2);
    table->attach(tuner, 0, 3, 0, 1);

    // >
    pixmap = new Gnome::Pixmap(arrow_right_xpm);
    button = new RepeatButton (RADIO_TUNER_TIMEOUT_FINE);
    button->add(*manage(pixmap));
    button->hold.connect(
	bind(slot(this, &wndMain::tuner_fine_tune), +1));
    table->attach(*manage(button), 2, 3, 1, 2);

    // <
    pixmap = new Gnome::Pixmap(arrow_left_xpm);
    button = new RepeatButton (RADIO_TUNER_TIMEOUT_FINE);
    button->add(*manage(pixmap));
    button->hold.connect(
	bind(slot(this, &wndMain::tuner_fine_tune), -1));
    table->attach(*manage(button), 1, 2, 1, 2);

    // >>
    pixmap = new Gnome::Pixmap(tune_right_xpm);
    button = new RepeatButton (RADIO_TUNER_TIMEOUT);
    button->add(*manage(pixmap));
    button->hold.connect(
	bind(slot(this, &wndMain::tuner_fine_tune), +5));
    table->attach(*manage(button), 2, 3, 2, 3);

    // <<
    pixmap = new Gnome::Pixmap(tune_left_xpm);
    button = new RepeatButton (RADIO_TUNER_TIMEOUT);
    button->add(*manage(pixmap));
    button->hold.connect(
	bind(slot(this, &wndMain::tuner_fine_tune), -5));
    table->attach(*manage(button), 1, 2, 2, 3);

    // Speedtuner
    buttons.clicked.connect(slot(this, &wndMain::speed_click));
    buttons.rclicked.connect(slot(this, &wndMain::speed_change));

    // Volume
    volume.set (radio.get_vol ());
    volume.set_mute (radio.get_mute ());
    volume.mute.connect (radio.mute.slot ());
    radio.mute.connect (slot (&volume, &Volume::set_mute));
    volume.change.connect (slot (&radio, &Radio::set_vol));

    // Key Events
    key_press_event.connect(slot(*this, &wndMain::key_press));
    
    // Main container
    HBox* box = new HBox(false, 5);
    box->pack_start(*manage(table));
    box->pack_start(buttons, false, false);
    box->pack_start(volume, false, false);
    box->show_all();
    add(*manage(box));
    
    set_events(GDK_BUTTON_PRESS_MASK|GDK_KEY_PRESS_MASK);

    // Properties dialog
    properties.device_change.connect(slot(this, &wndMain::dev_change));
    properties.station_change.connect(slot(this, &wndMain::set_speedtuner));

    // Popup menu
    MenuItem* m_item;

    m_item = wrap(GTK_MENU_ITEM(gnome_stock_menu_item(
	GNOME_STOCK_MENU_ABOUT, _("About"))));
    m_item->activate.connect(slot(&wndMain::about));
    menu.append(*manage(m_item));

    m_item = wrap(GTK_MENU_ITEM(gnome_stock_menu_item(
	GNOME_STOCK_MENU_PROP, _("Properties"))));
    m_item->activate.connect(slot(this, &wndMain::show_properties));
    menu.append(*manage(m_item));
}

gint wndMain::key_press(GdkEventKey *k)
{
    if (k) switch (k->keyval) {
    case GDK_q:
	delete_event ((GdkEventAny*)0);
	break;

    case GDK_m:
	radio.toggle_mute ();
	break;

    case GDK_1:
	speed_click(0);
	break;
    case GDK_2:
	speed_click(1);
	break;
    case GDK_3:
	speed_click(2);
	break;
    case GDK_4:
	speed_click(3);
	break;
    case GDK_5:
	speed_click(4);
	break;
    case GDK_6:
	speed_click(5);
	break;
    case GDK_7:
	speed_click(6);
	break;
    case GDK_8:
	speed_click(7);
	break;
    case GDK_9:
	speed_click(8);
	break;
    case GDK_0:
	speed_click(9);
	break;
    }
    
    return false;
}

void wndMain::dev_change(const string& dev)
{
    if (dev == arg::devfile)
	return;
    try
    {
	radio.open_dev(dev);
	arg::devfile = dev;
    }
    catch (runtime_error e)
    {
	Gnome::Dialogs::error(e.what());
	cerr << e.what() << endl;
    }
}

void wndMain::tuner_fine_tune(int weight)
{
    float delta = weight * arg::tune_step;
    tuner.set_value(curr_val + delta);
}

void wndMain::set()
{
    volume.set(radio.get_vol());
    tuner.set_value(curr_val = radio.get());
    volume.set_mute(radio.get_mute());
}

void wndMain::tuner_changed(float val)
{
    radio.set(curr_val = val);
}

void wndMain::speed_change(int btn)
{
    prog_vals[btn].first = curr_val;
    speedtuner_changed(btn, prog_vals[btn]);
}

void wndMain::speed_click(int btn)
{
    tuner.set_value(prog_vals[btn].first);
    program_changed(btn);
}

void wndMain::about()
{
    string info = _("Radio tuner for Video4Linux-compatible devices");
    info += "\n";
    info += _("Visit http://cactus.rulez.org/projects/radioactive/ for more information");

    vector<string> authors;

    authors.push_back ("RDI Gerg <cactus@cactus.rulez.org>");
    
    About* about = new About(PROGNAME, VERSION,
			     "(C) 1999-2001 RDI Gerg",
			     authors, info);
    about->run();
}

int wndMain::delete_event_impl(GdkEventAny* e)
{
    cache_pos();
    hide();
    set_uposition(x, y);
    return 1;
}

void wndMain::set_speedtuner(const vector<pair<float, string> >&
			     values)
{
    prog_vals = values;
    vector<pair<float, string> >::iterator i;
    int j = 0;
    for (i = prog_vals.begin();
	 i != prog_vals.end(); i++, j++)
    {
	buttons.set(j, i->second);
	speedtuner_changed(j, *i);
    }
}

vector<pair<float, string> > wndMain::get_speedtuner()
{
    return prog_vals;
}

void wndMain::show_properties()
{
    properties.set_stations(prog_vals);
    properties.show();
}    

int wndMain::mouse_clicked(GdkEventButton* e)
{
    if (e->button == 3)
    {
	menu.show_all();
	menu.popup(e->button, e->time);
    }
	
    return 0;
}

int wndMain::cache_pos()
{
    if (is_mapped())
	get_window().get_root_origin(x, y);
    return 0;
}

void wndMain::get_position(int& pos_x, int& pos_y)
{
    if (is_mapped())   
	get_window().get_root_origin(x, y);
    pos_x = x;
    pos_y = y;
}
