// $Id: applet.cc,v 1.27 2001/11/06 17:45:39 cactus Exp $ -*- c++ -*-

// RadioActive Copyright (C) 1999-2000 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "applet/applet.h"
#include "common/repeat-button.h"
#include "common/file.h"

#include <gtk--/table.h>
#include <gtk--/frame.h>
#include <gtk--/togglebutton.h>

RApplet::RApplet (Radio& radiodev, wndMain& wnd):
    Gnome::Applet ("radioactive_applet"),
    radio (radiodev),
    label ("1"),
    w (wnd),
    button (0),
    in_cycle (false),
    prog_vals (arg::progbutton_col * arg::progbutton_row,
	       StationData (0, ""))
{
    using namespace SigC;
    
    Gtk::ToggleButton* btnMute = new Gtk::ToggleButton(_("Mute"));
    RepeatButton* btnPrev = new RepeatButton("<", RADIO_APPLET_TIMEOUT);
    RepeatButton* btnNext = new RepeatButton(">", RADIO_APPLET_TIMEOUT);

    btnMute->set_active (radio.get_mute ());

    btnMute->clicked.connect (slot (this, &RApplet::mute_btn_impl));
    radio.set_mute.connect (slot (btnMute, &Gtk::ToggleButton::set_active));

    btnPrev->hold.connect (slot (this, &RApplet::prev));
    btnNext->hold.connect (slot (this, &RApplet::next));

    w.program_changed.connect (slot (this, &RApplet::set_num));
    w.speedtuner_changed.connect (slot (this, &RApplet::set_val));
    w.set_speedtuner (prog_vals);

    Gtk::Table* table = new Gtk::Table (3, 2);
    table->set_col_spacings (5);
//    table.set_row_spacings(2);
    table->set_border_width(1);
    label.set_justify(GTK_JUSTIFY_LEFT);
    label.set_alignment(0, 0.5);

    eventbox.add(label);
    
    table->attach(eventbox, 1, 2, 0, 1);
    table->attach(*manage(btnPrev), 0, 1, 0, 1);
    table->attach(*manage(btnNext), 2, 3, 0, 1);
    table->attach(*manage(btnMute), 0, 3, 1, 2);
    Gtk::Frame* frame = new Gtk::Frame;
    frame->add(*manage(table));
    frame->show_all();
    
    add(*manage(frame));
    set_tooltip(PROGNAME " " VERSION);
    set_widget_tooltip(*btnPrev, _("Previous station"));
    set_widget_tooltip(*btnNext, _("Next station"));

    // C functions for accessing the panel applet itself
    add_menuitem_stock ("properties", GNOME_STOCK_MENU_PROP,
			_("Properties..."),
			slot (w, &wndMain::show_properties));
    add_menuitem_stock ("window", GNOME_STOCK_MENU_VOLUME,
			_("Open window"),
			slot (this, &RApplet::show_wnd));
    add_menuitem_stock ("about", GNOME_STOCK_MENU_ABOUT,
			_("About"),
			slot (&wndMain::about));
}

void RApplet::mute_btn_impl ()
{
    radio.set_mute (!radio.get_mute ());
}

int RApplet::get_num()
{
    return button;
}

void RApplet::set_num(int val)
{
    button = val;
    update_channel();
}

void RApplet::update_channel()
{
    gchar* tmp = g_strdup_printf("%d", (button + 1));
    label.set(tmp);
    g_free(tmp);

    tmp = g_strdup_printf("%s (%.1f)",
			  prog_vals[button].second.c_str(),
			  prog_vals[button].first);
    set_widget_tooltip(eventbox, tmp);
    g_free(tmp);
}

void RApplet::set_vals(const SpeedButtonData &vals)
{
    prog_vals = vals;
}

void RApplet::set_val(int num, const StationData &val)
{
    prog_vals[num] = val;
}

void RApplet::next()
{
    if (++button > (arg::progbutton_col * arg::progbutton_row - 1))
	button = 0;
    
    if (prog_vals[button].first == 0)
    {
	if (!in_cycle)
	{
	    in_cycle = true;
	    cycle_start = button;

	    next ();
	    return;
	} else {
	    if (cycle_start != button)
	    {
		next ();
		return;
	    }
	}
    }

    in_cycle = false;
    
    radio.set_freq (prog_vals[button].first);
    update_channel();
}

void RApplet::prev()
{
    if (--button < 0)
	button =  (arg::progbutton_col * arg::progbutton_row) - 1;

    if (prog_vals[button].first == 0)
    {
	if (!in_cycle)
	{
	    in_cycle = true;
	    cycle_start = button;

	    prev ();
	    return;
	} else {
	    if (cycle_start != button)
	    {
		prev ();
		return;
	    }
	}
    }

    in_cycle = false;

    radio.set_freq (prog_vals[button].first);
    update_channel();
}

void RApplet::show_wnd()
{
    w.show();
}
