//$Id: driver.h,v 1.16 2001/11/06 17:45:39 cactus Exp $ -*- c++ -*-

// RadioActive Copyright (C) 1999-2000 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef RADIOACTIVE_DRIVER_H
#define RADIOACTIVE_DRIVER_H

#include "radioactive.h"
#include <string>
#include <sigc++/object.h>
#include <sigc++/signal_system.h>
#include <linux/videodev.h>

class Radio: public SigC::Object
{
    int         fd;
    int         vol;
    bool        mute;
    double      freq;
    std::string filename;

public:
    Radio (const std::string &devicefile);

    void open_dev (const std::string &devicefile);

    std::string get_filename () { return filename; };
    
    double get_freq_min ();
    double get_freq_max ();
    
    double get_freq () { return freq; };
    SigC::Signal1<void, double> set_freq;
    
    int get_volume () {return vol;};
    SigC::Signal1<void, int> set_volume;
    
    bool get_mute () {return mute;};
    SigC::Signal1<void, bool> set_mute;
    
private:
    void set_freq_impl (double fq);
    void set_volume_impl (int vol);
    void set_mute_impl (bool mute);

    double get_freq_fact ();
    struct video_audio va;
    struct video_tuner tuner;
};

#endif /* !RADIOACTIVE_DRIVER_H */
