/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 *  arch-tag: Implementation of Rhythmbox icon loading
 *
 *  Copyright (C) 2002 Jorn Baayen
 *  Copyright (C) 2003,2004 Colin Walters <walters@verbum.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 */

#include "config.h"

#include <gtk/gtk.h>
#include <glib.h>
#include <stdio.h>
#include <string.h>

#include "rb-file-helpers.h"
#include "rb-stock-icons.h"

/* inline pixbuf data */
#include "rhythmbox-set-star-inline.h"
#include "rhythmbox-unset-star-inline.h"
#include "rhythmbox-no-star-inline.h"

typedef struct {
	const guint8 *data;
	const char *name;
} RBInlineIconData;

const char RB_APP_ICON[] = "rhythmbox";
const char RB_STOCK_TRAY_ICON_PLAYING[] = "rhythmbox";
const char RB_STOCK_TRAY_ICON_NOT_PLAYING[] = "rhythmbox-notplaying";
const char RB_STOCK_SET_STAR[] = "rhythmbox-set-star";
const char RB_STOCK_UNSET_STAR[] = "rhythmbox-unset-star";
const char RB_STOCK_NO_STAR[] = "rhythmbox-no-star";
const char RB_STOCK_PODCAST[] = "library-podcast";
const char RB_STOCK_BROWSER[] = "stock_music-library";
const char RB_STOCK_PLAYLIST[] = "playlist";
const char RB_STOCK_AUTO_PLAYLIST[] = "playlist-automatic";
const char GNOME_MEDIA_SHUFFLE[] = "stock_shuffle";
const char GNOME_MEDIA_REPEAT[] = "stock_repeat";
const char GNOME_MEDIA_EJECT[] = "media-eject";

static RBInlineIconData inline_icons[] = {
	{ rhythmbox_set_star_inline, RB_STOCK_SET_STAR },
	{ rhythmbox_unset_star_inline, RB_STOCK_UNSET_STAR },
	{ rhythmbox_no_star_inline, RB_STOCK_NO_STAR }
};

void
rb_stock_icons_init (void)
{
	GtkIconTheme *theme = gtk_icon_theme_get_default ();
	int i;
	int icon_size;
	char *dot_icon_dir;

	/* add our icon search paths */
	dot_icon_dir = g_build_filename (rb_dot_dir (), "icons", NULL);
	gtk_icon_theme_append_search_path (theme, dot_icon_dir);
	g_free (dot_icon_dir);

	gtk_icon_theme_append_search_path (theme, SHARE_DIR G_DIR_SEPARATOR_S "icons");
#ifdef SHARE_UNINSTALLED_DIR
	gtk_icon_theme_append_search_path (theme, SHARE_UNINSTALLED_DIR G_DIR_SEPARATOR_S "icons");
#endif

	/* add inline icons */
	gtk_icon_size_lookup (GTK_ICON_SIZE_LARGE_TOOLBAR, &icon_size, NULL);
	for (i = 0; i < (int) G_N_ELEMENTS (inline_icons); i++) {
		GdkPixbuf *pixbuf;

		pixbuf = gdk_pixbuf_new_from_inline (-1,
						     inline_icons[i].data,
						     FALSE,
						     NULL);
		g_assert (pixbuf);

		gtk_icon_theme_add_builtin_icon (inline_icons[i].name,
						 icon_size,
						 pixbuf);
	}
}

void
rb_stock_icons_shutdown (void)
{
	/* do nothing */
}

