/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-dvb-root-container.h"
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <rygel-simple-async-result.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include "rygel-dvb-channel-group.h"




struct _RygelDVBRootContainerPrivate {
	GeeArrayList* groups;
};

#define RYGEL_DVB_ROOT_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DVB_ROOT_CONTAINER, RygelDVBRootContainerPrivate))
enum  {
	RYGEL_DVB_ROOT_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_DVB_ROOT_CONTAINER_DVB_SERVICE "org.gnome.DVB"
#define RYGEL_DVB_ROOT_CONTAINER_MANAGER_PATH "/org/gnome/DVB/Manager"
#define RYGEL_DVB_ROOT_CONTAINER_MANAGER_IFACE "org.gnome.DVB.Manager"
#define RYGEL_DVB_ROOT_CONTAINER_CHANNEL_LIST_IFACE "org.gnome.DVB.ChannelList"
static void rygel_dvb_root_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target);
static GeeList* rygel_dvb_root_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error);
static void rygel_dvb_root_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target);
static RygelMediaObject* rygel_dvb_root_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error);
guint* _dynamic_GetRegisteredDeviceGroups0 (DBusGProxy* self, int* result_length1, GError** error);
char* _dynamic_GetChannelList1 (DBusGProxy* self, guint param1, GError** error);
char* _dynamic_GetDeviceGroupName2 (DBusGProxy* self, guint param1, GError** error);
static void rygel_dvb_root_container_fetch_device_groups (RygelDVBRootContainer* self, DBusGConnection* connection, GError** error);
static RygelDVBChannelGroup* rygel_dvb_root_container_find_group_by_id (RygelDVBRootContainer* self, const char* id);
static RygelMediaObject* rygel_dvb_root_container_find_channel_by_id (RygelDVBRootContainer* self, const char* id, GError** error);
static gpointer rygel_dvb_root_container_parent_class = NULL;
static void rygel_dvb_root_container_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



RygelDVBRootContainer* rygel_dvb_root_container_construct (GType object_type, const char* title) {
	GError * inner_error;
	RygelDVBRootContainer * self;
	GeeArrayList* _tmp0;
	g_return_val_if_fail (title != NULL, NULL);
	inner_error = NULL;
	self = (RygelDVBRootContainer*) rygel_media_container_construct_root (object_type, title, (guint) 0);
	_tmp0 = NULL;
	self->priv->groups = (_tmp0 = gee_array_list_new (RYGEL_TYPE_DVB_CHANNEL_GROUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal), (self->priv->groups == NULL) ? NULL : (self->priv->groups = (g_object_unref (self->priv->groups), NULL)), _tmp0);
	{
		DBusGConnection* connection;
		DBusGProxy* _tmp1;
		connection = dbus_g_bus_get (DBUS_BUS_SESSION, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			goto __finally0;
		}
		/* Get a proxy to DVB Manager object*/
		_tmp1 = NULL;
		self->manager = (_tmp1 = dbus_g_proxy_new_for_name (connection, RYGEL_DVB_ROOT_CONTAINER_DVB_SERVICE, RYGEL_DVB_ROOT_CONTAINER_MANAGER_PATH, RYGEL_DVB_ROOT_CONTAINER_MANAGER_IFACE), (self->manager == NULL) ? NULL : (self->manager = (g_object_unref (self->manager), NULL)), _tmp1);
		rygel_dvb_root_container_fetch_device_groups (self, connection, &inner_error);
		if (inner_error != NULL) {
			(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
			if (inner_error->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			goto __finally0;
		}
		(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
	}
	goto __finally0;
	__catch0_dbus_gerror:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			g_critical ("rygel-dvb-root-container.vala:60: Failed to fetch device groups: %s\n", error->message);
			(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
		}
	}
	__finally0:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	return self;
}


RygelDVBRootContainer* rygel_dvb_root_container_new (const char* title) {
	return rygel_dvb_root_container_construct (RYGEL_TYPE_DVB_ROOT_CONTAINER, title);
}


static void rygel_dvb_root_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target) {
	RygelDVBRootContainer * self;
	guint stop;
	GeeList* groups;
	RygelSimpleAsyncResult* res;
	GeeList* _tmp1;
	GeeList* _tmp0;
	self = (RygelDVBRootContainer*) base;
	stop = offset + max_count;
	stop = CLAMP (stop, (guint) 0, ((RygelMediaContainer*) self)->child_count);
	groups = gee_list_slice ((GeeList*) self->priv->groups, (gint) offset, (gint) stop);
	res = rygel_simple_async_result_new (GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GObject*) self, callback, callback_target);
	_tmp1 = NULL;
	_tmp0 = NULL;
	res->data = (_tmp1 = (_tmp0 = groups, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (res->data == NULL) ? NULL : (res->data = (g_object_unref (res->data), NULL)), _tmp1);
	rygel_simple_async_result_complete_in_idle (res);
	(groups == NULL) ? NULL : (groups = (g_object_unref (groups), NULL));
	(res == NULL) ? NULL : (res = (g_object_unref (res), NULL));
}


static GeeList* rygel_dvb_root_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error) {
	RygelDVBRootContainer * self;
	RygelSimpleAsyncResult* _tmp0;
	RygelSimpleAsyncResult* simple_res;
	GeeList* _tmp1;
	GeeList* _tmp2;
	self = (RygelDVBRootContainer*) base;
	g_return_val_if_fail (res != NULL, NULL);
	_tmp0 = NULL;
	simple_res = (_tmp0 = RYGEL_SIMPLE_ASYNC_RESULT (res), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = (GeeList*) simple_res->data, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (simple_res == NULL) ? NULL : (simple_res = (g_object_unref (simple_res), NULL)), _tmp2);
}


static void rygel_dvb_root_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target) {
	RygelDVBRootContainer * self;
	GError * inner_error;
	RygelMediaObject* media_object;
	RygelSimpleAsyncResult* res;
	RygelMediaObject* _tmp3;
	RygelMediaObject* _tmp2;
	self = (RygelDVBRootContainer*) base;
	g_return_if_fail (id != NULL);
	inner_error = NULL;
	/* First try groups*/
	media_object = (RygelMediaObject*) rygel_dvb_root_container_find_group_by_id (self, id);
	if (media_object == NULL) {
		RygelMediaObject* _tmp0;
		RygelMediaObject* _tmp1;
		_tmp0 = rygel_dvb_root_container_find_channel_by_id (self, id, &inner_error);
		if (inner_error != NULL) {
			(media_object == NULL) ? NULL : (media_object = (g_object_unref (media_object), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
		_tmp1 = NULL;
		media_object = (_tmp1 = _tmp0, (media_object == NULL) ? NULL : (media_object = (g_object_unref (media_object), NULL)), _tmp1);
	}
	res = rygel_simple_async_result_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GObject*) self, callback, callback_target);
	_tmp3 = NULL;
	_tmp2 = NULL;
	res->data = (_tmp3 = (_tmp2 = media_object, (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (res->data == NULL) ? NULL : (res->data = (g_object_unref (res->data), NULL)), _tmp3);
	rygel_simple_async_result_complete_in_idle (res);
	(media_object == NULL) ? NULL : (media_object = (g_object_unref (media_object), NULL));
	(res == NULL) ? NULL : (res = (g_object_unref (res), NULL));
}


static RygelMediaObject* rygel_dvb_root_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error) {
	RygelDVBRootContainer * self;
	RygelSimpleAsyncResult* _tmp0;
	RygelSimpleAsyncResult* simple_res;
	RygelMediaObject* _tmp1;
	RygelMediaObject* _tmp2;
	self = (RygelDVBRootContainer*) base;
	g_return_val_if_fail (res != NULL, NULL);
	_tmp0 = NULL;
	simple_res = (_tmp0 = RYGEL_SIMPLE_ASYNC_RESULT (res), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = (RygelMediaObject*) simple_res->data, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (simple_res == NULL) ? NULL : (simple_res = (g_object_unref (simple_res), NULL)), _tmp2);
}


guint* _dynamic_GetRegisteredDeviceGroups0 (DBusGProxy* self, int* result_length1, GError** error) {
	GArray* result;
	dbus_g_proxy_call (self, "GetRegisteredDeviceGroups", error, G_TYPE_INVALID, dbus_g_type_get_collection ("GArray", G_TYPE_UINT), &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	*result_length1 = result->len;
	return (guint*) result->data;
}


char* _dynamic_GetChannelList1 (DBusGProxy* self, guint param1, GError** error) {
	char* result;
	dbus_g_proxy_call (self, "GetChannelList", error, G_TYPE_UINT, param1, G_TYPE_INVALID, G_TYPE_STRING, &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	return result;
}


char* _dynamic_GetDeviceGroupName2 (DBusGProxy* self, guint param1, GError** error) {
	char* result;
	dbus_g_proxy_call (self, "GetDeviceGroupName", error, G_TYPE_UINT, param1, G_TYPE_INVALID, G_TYPE_STRING, &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	return result;
}


/* Private methods*/
static void rygel_dvb_root_container_fetch_device_groups (RygelDVBRootContainer* self, DBusGConnection* connection, GError** error) {
	GError * inner_error;
	guint* _tmp0;
	gint dev_groups_size;
	gint dev_groups_length1;
	guint* dev_groups;
	guint* _tmp3;
	gint _tmp2_size;
	gint _tmp2_length1;
	gint _tmp1;
	guint* _tmp2;
	guint* _tmp4;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	dev_groups = (_tmp0 = NULL, dev_groups_length1 = 0, dev_groups_size = dev_groups_length1, _tmp0);
	_tmp3 = NULL;
	_tmp2 = (_tmp3 = _dynamic_GetRegisteredDeviceGroups0 (self->manager, &_tmp1, &inner_error), _tmp2_length1 = _tmp1, _tmp2_size = _tmp2_length1, _tmp3);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		dev_groups = (g_free (dev_groups), NULL);
		return;
	}
	_tmp4 = NULL;
	dev_groups = (_tmp4 = _tmp2, dev_groups = (g_free (dev_groups), NULL), dev_groups_length1 = _tmp2_length1, dev_groups_size = dev_groups_length1, _tmp4);
	{
		guint* group_id_collection;
		int group_id_collection_length1;
		int group_id_it;
		group_id_collection = dev_groups;
		group_id_collection_length1 = dev_groups_length1;
		for (group_id_it = 0; group_id_it < dev_groups_length1; group_id_it = group_id_it + 1) {
			guint group_id;
			group_id = group_id_collection[group_id_it];
			{
				char* channel_list_path;
				char* group_name;
				char* _tmp5;
				char* _tmp6;
				char* _tmp7;
				char* _tmp8;
				DBusGProxy* channel_list;
				RygelDVBChannelGroup* _tmp9;
				channel_list_path = NULL;
				group_name = NULL;
				_tmp5 = _dynamic_GetChannelList1 (self->manager, group_id, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					channel_list_path = (g_free (channel_list_path), NULL);
					group_name = (g_free (group_name), NULL);
					dev_groups = (g_free (dev_groups), NULL);
					return;
				}
				_tmp6 = NULL;
				channel_list_path = (_tmp6 = _tmp5, channel_list_path = (g_free (channel_list_path), NULL), _tmp6);
				_tmp7 = _dynamic_GetDeviceGroupName2 (self->manager, group_id, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					channel_list_path = (g_free (channel_list_path), NULL);
					group_name = (g_free (group_name), NULL);
					dev_groups = (g_free (dev_groups), NULL);
					return;
				}
				/* Get the name of the group*/
				_tmp8 = NULL;
				group_name = (_tmp8 = _tmp7, group_name = (g_free (group_name), NULL), _tmp8);
				/* Get a proxy to DVB ChannelList object*/
				channel_list = dbus_g_proxy_new_for_name (connection, RYGEL_DVB_ROOT_CONTAINER_DVB_SERVICE, channel_list_path, RYGEL_DVB_ROOT_CONTAINER_CHANNEL_LIST_IFACE);
				/* Create ChannelGroup for each registered device group*/
				_tmp9 = NULL;
				gee_collection_add ((GeeCollection*) self->priv->groups, _tmp9 = rygel_dvb_channel_group_new (group_id, group_name, (RygelMediaContainer*) self, channel_list));
				(_tmp9 == NULL) ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL));
				channel_list_path = (g_free (channel_list_path), NULL);
				group_name = (g_free (group_name), NULL);
				(channel_list == NULL) ? NULL : (channel_list = (g_object_unref (channel_list), NULL));
			}
		}
	}
	((RygelMediaContainer*) self)->child_count = (guint) gee_collection_get_size ((GeeCollection*) self->priv->groups);
	dev_groups = (g_free (dev_groups), NULL);
}


static RygelDVBChannelGroup* rygel_dvb_root_container_find_group_by_id (RygelDVBRootContainer* self, const char* id) {
	RygelDVBChannelGroup* group;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	group = NULL;
	{
		GeeIterator* _tmp_it;
		_tmp_it = gee_iterable_iterator ((GeeIterable*) self->priv->groups);
		while (gee_iterator_next (_tmp_it)) {
			RygelDVBChannelGroup* tmp;
			tmp = (RygelDVBChannelGroup*) gee_iterator_get (_tmp_it);
			if (_vala_strcmp0 (id, ((RygelMediaObject*) tmp)->id) == 0) {
				RygelDVBChannelGroup* _tmp1;
				RygelDVBChannelGroup* _tmp0;
				_tmp1 = NULL;
				_tmp0 = NULL;
				group = (_tmp1 = (_tmp0 = tmp, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (group == NULL) ? NULL : (group = (g_object_unref (group), NULL)), _tmp1);
				(tmp == NULL) ? NULL : (tmp = (g_object_unref (tmp), NULL));
				break;
			}
			(tmp == NULL) ? NULL : (tmp = (g_object_unref (tmp), NULL));
		}
		(_tmp_it == NULL) ? NULL : (_tmp_it = (g_object_unref (_tmp_it), NULL));
	}
	return group;
}


static RygelMediaObject* rygel_dvb_root_container_find_channel_by_id (RygelDVBRootContainer* self, const char* id, GError** error) {
	RygelMediaObject* channel;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	channel = NULL;
	{
		GeeIterator* _group_it;
		_group_it = gee_iterable_iterator ((GeeIterable*) self->priv->groups);
		while (gee_iterator_next (_group_it)) {
			RygelDVBChannelGroup* group;
			RygelMediaObject* _tmp0;
			group = (RygelDVBChannelGroup*) gee_iterator_get (_group_it);
			_tmp0 = NULL;
			channel = (_tmp0 = rygel_dvb_channel_group_find_object_sync (group, id), (channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL)), _tmp0);
			if (channel != NULL) {
				(group == NULL) ? NULL : (group = (g_object_unref (group), NULL));
				break;
			}
			(group == NULL) ? NULL : (group = (g_object_unref (group), NULL));
		}
		(_group_it == NULL) ? NULL : (_group_it = (g_object_unref (_group_it), NULL));
	}
	return channel;
}


static void rygel_dvb_root_container_class_init (RygelDVBRootContainerClass * klass) {
	rygel_dvb_root_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelDVBRootContainerPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_dvb_root_container_finalize;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_dvb_root_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_dvb_root_container_real_get_children_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_dvb_root_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_dvb_root_container_real_find_object_finish;
}


static void rygel_dvb_root_container_instance_init (RygelDVBRootContainer * self) {
	self->priv = RYGEL_DVB_ROOT_CONTAINER_GET_PRIVATE (self);
}


static void rygel_dvb_root_container_finalize (GObject* obj) {
	RygelDVBRootContainer * self;
	self = RYGEL_DVB_ROOT_CONTAINER (obj);
	(self->manager == NULL) ? NULL : (self->manager = (g_object_unref (self->manager), NULL));
	(self->priv->groups == NULL) ? NULL : (self->priv->groups = (g_object_unref (self->priv->groups), NULL));
	G_OBJECT_CLASS (rygel_dvb_root_container_parent_class)->finalize (obj);
}


GType rygel_dvb_root_container_get_type (void) {
	static GType rygel_dvb_root_container_type_id = 0;
	if (rygel_dvb_root_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDVBRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dvb_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDVBRootContainer), 0, (GInstanceInitFunc) rygel_dvb_root_container_instance_init, NULL };
		rygel_dvb_root_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelDVBRootContainer", &g_define_type_info, 0);
	}
	return rygel_dvb_root_container_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




