/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-media-receiver-registrar.h"
#include <stdlib.h>
#include <string.h>




enum  {
	RYGEL_MEDIA_RECEIVER_REGISTRAR_DUMMY_PROPERTY
};
static void _rygel_media_receiver_registrar_is_authorized_cb_gupnp_service_action_invoked (RygelMediaReceiverRegistrar* _sender, GUPnPServiceAction* action, gpointer self);
static void _rygel_media_receiver_registrar_register_device_cb_gupnp_service_action_invoked (RygelMediaReceiverRegistrar* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_media_receiver_registrar_real_constructed (GObject* base);
static void rygel_media_receiver_registrar_is_authorized_cb (RygelMediaReceiverRegistrar* self, RygelMediaReceiverRegistrar* registrar, GUPnPServiceAction* action);
static void rygel_media_receiver_registrar_register_device_cb (RygelMediaReceiverRegistrar* self, RygelMediaReceiverRegistrar* registrar, GUPnPServiceAction* action);
static gpointer rygel_media_receiver_registrar_parent_class = NULL;



static void _rygel_media_receiver_registrar_is_authorized_cb_gupnp_service_action_invoked (RygelMediaReceiverRegistrar* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_media_receiver_registrar_is_authorized_cb (self, _sender, action);
}


static void _rygel_media_receiver_registrar_register_device_cb_gupnp_service_action_invoked (RygelMediaReceiverRegistrar* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_media_receiver_registrar_register_device_cb (self, _sender, action);
}


static void rygel_media_receiver_registrar_real_constructed (GObject* base) {
	RygelMediaReceiverRegistrar * self;
	self = (RygelMediaReceiverRegistrar*) base;
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::IsAuthorized", (GCallback) _rygel_media_receiver_registrar_is_authorized_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::IsValidated", (GCallback) _rygel_media_receiver_registrar_is_authorized_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::RegisterDevice", (GCallback) _rygel_media_receiver_registrar_register_device_cb_gupnp_service_action_invoked, self, 0);
}


/* IsAuthorized and IsValided action implementations (fake) */
static void rygel_media_receiver_registrar_is_authorized_cb (RygelMediaReceiverRegistrar* self, RygelMediaReceiverRegistrar* registrar, GUPnPServiceAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (registrar != NULL);
	g_return_if_fail (action != NULL);
	gupnp_service_action_set (action, "Result", G_TYPE_INT, 1, NULL);
	gupnp_service_action_return (action);
}


static void rygel_media_receiver_registrar_register_device_cb (RygelMediaReceiverRegistrar* self, RygelMediaReceiverRegistrar* registrar, GUPnPServiceAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (registrar != NULL);
	g_return_if_fail (action != NULL);
	gupnp_service_action_set (action, "RegistrationRespMsg", G_TYPE_STRING, "WhatisSupposedToBeHere", NULL);
	gupnp_service_action_return (action);
}


/**
 * Basic implementation of MS MediaReceiverRegistrar service version 1.
 */
RygelMediaReceiverRegistrar* rygel_media_receiver_registrar_construct (GType object_type) {
	RygelMediaReceiverRegistrar * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


RygelMediaReceiverRegistrar* rygel_media_receiver_registrar_new (void) {
	return rygel_media_receiver_registrar_construct (RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR);
}


static void rygel_media_receiver_registrar_class_init (RygelMediaReceiverRegistrarClass * klass) {
	rygel_media_receiver_registrar_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructed = rygel_media_receiver_registrar_real_constructed;
}


static void rygel_media_receiver_registrar_instance_init (RygelMediaReceiverRegistrar * self) {
}


GType rygel_media_receiver_registrar_get_type (void) {
	static GType rygel_media_receiver_registrar_type_id = 0;
	if (rygel_media_receiver_registrar_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaReceiverRegistrarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_receiver_registrar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaReceiverRegistrar), 0, (GInstanceInitFunc) rygel_media_receiver_registrar_instance_init, NULL };
		rygel_media_receiver_registrar_type_id = g_type_register_static (GUPNP_TYPE_SERVICE, "RygelMediaReceiverRegistrar", &g_define_type_info, 0);
	}
	return rygel_media_receiver_registrar_type_id;
}




