/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-seekable-response.h"




struct _RygelSeekableResponsePrivate {
	RygelSeek* seek;
	GFile* file;
	GFileInputStream* input_stream;
	gchar* buffer;
	gint buffer_length1;
	gint buffer_size;
	gsize total_length;
	gint priority;
};

#define RYGEL_SEEKABLE_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SEEKABLE_RESPONSE, RygelSeekableResponsePrivate))
enum  {
	RYGEL_SEEKABLE_RESPONSE_DUMMY_PROPERTY
};
#define RYGEL_SEEKABLE_RESPONSE_BUFFER_LENGTH (gsize) 4096
static void _rygel_seekable_response_on_wrote_chunk_soup_message_wrote_chunk (SoupMessage* _sender, gpointer self);
static void _rygel_seekable_response_on_file_read_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void rygel_seekable_response_real_run (RygelHTTPResponse* base, GCancellable* cancellable);
static void _rygel_seekable_response_on_contents_read_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void rygel_seekable_response_on_file_read (RygelSeekableResponse* self, GObject* source_object, GAsyncResult* result);
static void _rygel_seekable_response_on_input_stream_closed_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void rygel_seekable_response_on_contents_read (RygelSeekableResponse* self, GObject* source_object, GAsyncResult* result);
static void rygel_seekable_response_on_input_stream_closed (RygelSeekableResponse* self, GObject* source_object, GAsyncResult* result);
static void rygel_seekable_response_on_wrote_chunk (RygelSeekableResponse* self, SoupMessage* msg);
static gint rygel_seekable_response_get_requested_priority (RygelSeekableResponse* self);
static gpointer rygel_seekable_response_parent_class = NULL;
static void rygel_seekable_response_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _rygel_seekable_response_on_wrote_chunk_soup_message_wrote_chunk (SoupMessage* _sender, gpointer self) {
	rygel_seekable_response_on_wrote_chunk (self, _sender);
}


RygelSeekableResponse* rygel_seekable_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, const char* uri, RygelSeek* seek, gsize file_length) {
	RygelSeekableResponse * self;
	RygelSeek* _tmp1;
	RygelSeek* _tmp0;
	gchar* _tmp2;
	GFile* _tmp3;
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	self = (RygelSeekableResponse*) rygel_http_response_construct (object_type, server, msg, seek != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->seek = (_tmp1 = (_tmp0 = seek, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->seek == NULL) ? NULL : (self->priv->seek = (g_object_unref (self->priv->seek), NULL)), _tmp1);
	self->priv->total_length = file_length;
	self->priv->priority = rygel_seekable_response_get_requested_priority (self);
	if (seek != NULL) {
		self->priv->total_length = (gsize) rygel_seek_get_length (seek);
	} else {
		self->priv->total_length = file_length;
	}
	g_signal_connect_object (msg, "wrote-chunk", (GCallback) _rygel_seekable_response_on_wrote_chunk_soup_message_wrote_chunk, self, 0);
	_tmp2 = NULL;
	self->priv->buffer = (_tmp2 = g_new0 (gchar, RYGEL_SEEKABLE_RESPONSE_BUFFER_LENGTH), self->priv->buffer = (g_free (self->priv->buffer), NULL), self->priv->buffer_length1 = RYGEL_SEEKABLE_RESPONSE_BUFFER_LENGTH, self->priv->buffer_size = self->priv->buffer_length1, _tmp2);
	_tmp3 = NULL;
	self->priv->file = (_tmp3 = g_file_new_for_uri (uri), (self->priv->file == NULL) ? NULL : (self->priv->file = (g_object_unref (self->priv->file), NULL)), _tmp3);
	return self;
}


RygelSeekableResponse* rygel_seekable_response_new (SoupServer* server, SoupMessage* msg, const char* uri, RygelSeek* seek, gsize file_length) {
	return rygel_seekable_response_construct (RYGEL_TYPE_SEEKABLE_RESPONSE, server, msg, uri, seek, file_length);
}


static void _rygel_seekable_response_on_file_read_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	rygel_seekable_response_on_file_read (self, source_object, res);
}


static void rygel_seekable_response_real_run (RygelHTTPResponse* base, GCancellable* cancellable) {
	RygelSeekableResponse * self;
	GCancellable* _tmp1;
	GCancellable* _tmp0;
	self = (RygelSeekableResponse*) base;
	_tmp1 = NULL;
	_tmp0 = NULL;
	((RygelHTTPResponse*) self)->cancellable = (_tmp1 = (_tmp0 = cancellable, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (((RygelHTTPResponse*) self)->cancellable == NULL) ? NULL : (((RygelHTTPResponse*) self)->cancellable = (g_object_unref (((RygelHTTPResponse*) self)->cancellable), NULL)), _tmp1);
	g_file_read_async (self->priv->file, self->priv->priority, cancellable, _rygel_seekable_response_on_file_read_gasync_ready_callback, self);
}


static void _rygel_seekable_response_on_contents_read_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	rygel_seekable_response_on_contents_read (self, source_object, res);
}


static void rygel_seekable_response_on_file_read (RygelSeekableResponse* self, GObject* source_object, GAsyncResult* result) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_object != NULL);
	g_return_if_fail (result != NULL);
	inner_error = NULL;
	{
		GFileInputStream* _tmp0;
		GFileInputStream* _tmp1;
		_tmp0 = g_file_read_finish (self->priv->file, result, &inner_error);
		if (inner_error != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
		_tmp1 = NULL;
		self->priv->input_stream = (_tmp1 = _tmp0, (self->priv->input_stream == NULL) ? NULL : (self->priv->input_stream = (g_object_unref (self->priv->input_stream), NULL)), _tmp1);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * err;
		err = inner_error;
		inner_error = NULL;
		{
			char* _tmp2;
			_tmp2 = NULL;
			g_warning ("rygel-seekable-response.vala:74: Failed to read from URI: %s: %s\n", _tmp2 = g_file_get_uri (self->priv->file), err->message);
			_tmp2 = (g_free (_tmp2), NULL);
			rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NOT_FOUND);
			(err == NULL) ? NULL : (err = (g_error_free (err), NULL));
			return;
		}
	}
	__finally3:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	if (self->priv->seek != NULL) {
		{
			G_FILE_INPUT_STREAM_GET_CLASS (self->priv->input_stream)->seek (self->priv->input_stream, rygel_seek_get_start (self->priv->seek), G_SEEK_SET, ((RygelHTTPResponse*) self)->cancellable, &inner_error);
			if (inner_error != NULL) {
				goto __catch4_g_error;
				goto __finally4;
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError * err;
			err = inner_error;
			inner_error = NULL;
			{
				char* _tmp5;
				char* _tmp4;
				char* _tmp3;
				_tmp5 = NULL;
				_tmp4 = NULL;
				_tmp3 = NULL;
				g_warning ("rygel-seekable-response.vala:87: Failed to seek to %s-%s on URI %s: %s\n", _tmp3 = g_strdup_printf ("%lli", rygel_seek_get_start (self->priv->seek)), _tmp4 = g_strdup_printf ("%lli", rygel_seek_get_stop (self->priv->seek)), _tmp5 = g_file_get_uri (self->priv->file), err->message);
				_tmp5 = (g_free (_tmp5), NULL);
				_tmp4 = (g_free (_tmp4), NULL);
				_tmp3 = (g_free (_tmp3), NULL);
				rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
				(err == NULL) ? NULL : (err = (g_error_free (err), NULL));
				return;
			}
		}
		__finally4:
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
	}
	g_input_stream_read_async ((GInputStream*) self->priv->input_stream, self->priv->buffer, RYGEL_SEEKABLE_RESPONSE_BUFFER_LENGTH, self->priv->priority, ((RygelHTTPResponse*) self)->cancellable, _rygel_seekable_response_on_contents_read_gasync_ready_callback, self);
}


static void _rygel_seekable_response_on_input_stream_closed_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	rygel_seekable_response_on_input_stream_closed (self, source_object, res);
}


static void rygel_seekable_response_on_contents_read (RygelSeekableResponse* self, GObject* source_object, GAsyncResult* result) {
	GError * inner_error;
	GFileInputStream* _tmp0;
	GFileInputStream* input_stream;
	gssize bytes_read;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_object != NULL);
	g_return_if_fail (result != NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	input_stream = (_tmp0 = G_FILE_INPUT_STREAM (source_object), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	bytes_read = 0L;
	{
		gssize _tmp1;
		_tmp1 = g_input_stream_read_finish ((GInputStream*) input_stream, result, &inner_error);
		if (inner_error != NULL) {
			goto __catch5_g_error;
			goto __finally5;
		}
		bytes_read = _tmp1;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * err;
		err = inner_error;
		inner_error = NULL;
		{
			char* _tmp2;
			_tmp2 = NULL;
			g_warning ("rygel-seekable-response.vala:113: Failed to read contents from URI: %s: %s\n", _tmp2 = g_file_get_uri (self->priv->file), err->message);
			_tmp2 = (g_free (_tmp2), NULL);
			rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NOT_FOUND);
			(err == NULL) ? NULL : (err = (g_error_free (err), NULL));
			(input_stream == NULL) ? NULL : (input_stream = (g_object_unref (input_stream), NULL));
			return;
		}
	}
	__finally5:
	if (inner_error != NULL) {
		(input_stream == NULL) ? NULL : (input_stream = (g_object_unref (input_stream), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	if (bytes_read > 0) {
		rygel_http_response_push_data ((RygelHTTPResponse*) self, self->priv->buffer, (gsize) bytes_read);
	} else {
		g_input_stream_close_async ((GInputStream*) input_stream, self->priv->priority, ((RygelHTTPResponse*) self)->cancellable, _rygel_seekable_response_on_input_stream_closed_gasync_ready_callback, self);
	}
	(input_stream == NULL) ? NULL : (input_stream = (g_object_unref (input_stream), NULL));
}


static void rygel_seekable_response_on_input_stream_closed (RygelSeekableResponse* self, GObject* source_object, GAsyncResult* result) {
	GError * inner_error;
	GFileInputStream* _tmp0;
	GFileInputStream* input_stream;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_object != NULL);
	g_return_if_fail (result != NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	input_stream = (_tmp0 = G_FILE_INPUT_STREAM (source_object), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	{
		g_input_stream_close_finish ((GInputStream*) input_stream, result, &inner_error);
		if (inner_error != NULL) {
			goto __catch6_g_error;
			goto __finally6;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * err;
		err = inner_error;
		inner_error = NULL;
		{
			char* _tmp1;
			_tmp1 = NULL;
			g_warning ("rygel-seekable-response.vala:136: Failed to close stream to URI %s: %s\n", _tmp1 = g_file_get_uri (self->priv->file), err->message);
			_tmp1 = (g_free (_tmp1), NULL);
			(err == NULL) ? NULL : (err = (g_error_free (err), NULL));
		}
	}
	__finally6:
	if (inner_error != NULL) {
		(input_stream == NULL) ? NULL : (input_stream = (g_object_unref (input_stream), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NONE);
	(input_stream == NULL) ? NULL : (input_stream = (g_object_unref (input_stream), NULL));
}


static void rygel_seekable_response_on_wrote_chunk (RygelSeekableResponse* self, SoupMessage* msg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	g_input_stream_read_async ((GInputStream*) self->priv->input_stream, self->priv->buffer, RYGEL_SEEKABLE_RESPONSE_BUFFER_LENGTH, self->priv->priority, ((RygelHTTPResponse*) self)->cancellable, _rygel_seekable_response_on_contents_read_gasync_ready_callback, self);
}


static gint rygel_seekable_response_get_requested_priority (RygelSeekableResponse* self) {
	const char* _tmp0;
	char* mode;
	gboolean _tmp1;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0 = NULL;
	mode = (_tmp0 = soup_message_headers_get (((RygelHTTPResponse*) self)->msg->request_headers, "transferMode.dlna.org"), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	_tmp1 = FALSE;
	if (mode == NULL) {
		_tmp1 = TRUE;
	} else {
		_tmp1 = _vala_strcmp0 (mode, "Interactive") == 0;
	}
	if (_tmp1) {
		gint _tmp2;
		return (_tmp2 = G_PRIORITY_DEFAULT, mode = (g_free (mode), NULL), _tmp2);
	} else {
		if (_vala_strcmp0 (mode, "Streaming") == 0) {
			gint _tmp3;
			return (_tmp3 = G_PRIORITY_HIGH, mode = (g_free (mode), NULL), _tmp3);
		} else {
			if (_vala_strcmp0 (mode, "Background") == 0) {
				gint _tmp4;
				return (_tmp4 = G_PRIORITY_LOW, mode = (g_free (mode), NULL), _tmp4);
			} else {
				gint _tmp5;
				return (_tmp5 = G_PRIORITY_DEFAULT, mode = (g_free (mode), NULL), _tmp5);
			}
		}
	}
	mode = (g_free (mode), NULL);
}


static void rygel_seekable_response_class_init (RygelSeekableResponseClass * klass) {
	rygel_seekable_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelSeekableResponsePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_seekable_response_finalize;
	RYGEL_HTTP_RESPONSE_CLASS (klass)->run = rygel_seekable_response_real_run;
}


static void rygel_seekable_response_instance_init (RygelSeekableResponse * self) {
	self->priv = RYGEL_SEEKABLE_RESPONSE_GET_PRIVATE (self);
}


static void rygel_seekable_response_finalize (GObject* obj) {
	RygelSeekableResponse * self;
	self = RYGEL_SEEKABLE_RESPONSE (obj);
	(self->priv->seek == NULL) ? NULL : (self->priv->seek = (g_object_unref (self->priv->seek), NULL));
	(self->priv->file == NULL) ? NULL : (self->priv->file = (g_object_unref (self->priv->file), NULL));
	(self->priv->input_stream == NULL) ? NULL : (self->priv->input_stream = (g_object_unref (self->priv->input_stream), NULL));
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	G_OBJECT_CLASS (rygel_seekable_response_parent_class)->finalize (obj);
}


GType rygel_seekable_response_get_type (void) {
	static GType rygel_seekable_response_type_id = 0;
	if (rygel_seekable_response_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSeekableResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_seekable_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSeekableResponse), 0, (GInstanceInitFunc) rygel_seekable_response_instance_init, NULL };
		rygel_seekable_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE, "RygelSeekableResponse", &g_define_type_info, 0);
	}
	return rygel_seekable_response_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




