/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-dvb-channel-group.h"
#include <gee/hashmap.h>
#include <rygel-media-object.h>
#include <gee/map.h>
#include <rygel-media-item.h>
#include <gee/iterable.h>
#include <gee/iterator.h>




struct _RygelDVBChannelGroupPrivate {
	GeeHashMap* channels;
	guint gid;
};

#define RYGEL_DVB_CHANNEL_GROUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DVB_CHANNEL_GROUP, RygelDVBChannelGroupPrivate))
enum  {
	RYGEL_DVB_CHANNEL_GROUP_DUMMY_PROPERTY
};
DBusGProxy* rygel_dvb_channel_group_channel_list = NULL;
#define RYGEL_DVB_CHANNEL_GROUP_DVB_SERVICE "org.gnome.DVB"
#define RYGEL_DVB_CHANNEL_GROUP_GID_PREFIX "GroupID:"
static void _rygel_dvb_channel_group_on_item_requested_rygel_http_server_item_requested (RygelHTTPServer* _sender, const char* item_id, RygelMediaItem* item, gpointer self);
guint* _dynamic_GetChannels3 (DBusGProxy* self, int* result_length1, GError** error);
static void rygel_dvb_channel_group_fetch_channels (RygelDVBChannelGroup* self);
static void rygel_dvb_channel_group_on_item_requested (RygelDVBChannelGroup* self, RygelHTTPServer* http_server, const char* item_id, RygelMediaItem** item);
static gpointer rygel_dvb_channel_group_parent_class = NULL;
static void rygel_dvb_channel_group_finalize (RygelMediaObject* obj);



static void _rygel_dvb_channel_group_on_item_requested_rygel_http_server_item_requested (RygelHTTPServer* _sender, const char* item_id, RygelMediaItem* item, gpointer self) {
	rygel_dvb_channel_group_on_item_requested (self, _sender, item_id, item);
}


/* The DVB Daemon Device Group ID */
RygelDVBChannelGroup* rygel_dvb_channel_group_construct (GType object_type, guint gid, const char* title, const char* parent_id, DBusGProxy* channel_list, RygelHTTPServer* http_server) {
	RygelDVBChannelGroup* self;
	char* _tmp1;
	char* _tmp0;
	DBusGProxy* _tmp3;
	DBusGProxy* _tmp2;
	RygelHTTPServer* _tmp5;
	RygelHTTPServer* _tmp4;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (parent_id != NULL, NULL);
	g_return_val_if_fail (channel_list != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self = (RygelDVBChannelGroup*) rygel_media_container_construct (object_type, _tmp1 = g_strconcat (RYGEL_DVB_CHANNEL_GROUP_GID_PREFIX, _tmp0 = g_strdup_printf ("%u", gid), NULL), parent_id, title, (guint) 0);
	_tmp1 = (g_free (_tmp1), NULL);
	_tmp0 = (g_free (_tmp0), NULL);
	/* UPnP ID*/
	self->priv->gid = gid;
	/*this.upnp_class = "object.container.channelGroup";*/
	_tmp3 = NULL;
	_tmp2 = NULL;
	rygel_dvb_channel_group_channel_list = (_tmp3 = (_tmp2 = channel_list, (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (rygel_dvb_channel_group_channel_list == NULL) ? NULL : (rygel_dvb_channel_group_channel_list = (g_object_unref (rygel_dvb_channel_group_channel_list), NULL)), _tmp3);
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->http_server = (_tmp5 = (_tmp4 = http_server, (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4)), (self->http_server == NULL) ? NULL : (self->http_server = (g_object_unref (self->http_server), NULL)), _tmp5);
	rygel_dvb_channel_group_fetch_channels (self);
	g_signal_connect (self->http_server, "item-requested", (GCallback) _rygel_dvb_channel_group_on_item_requested_rygel_http_server_item_requested, self);
	return self;
}


RygelDVBChannelGroup* rygel_dvb_channel_group_new (guint gid, const char* title, const char* parent_id, DBusGProxy* channel_list, RygelHTTPServer* http_server) {
	return rygel_dvb_channel_group_construct (RYGEL_TYPE_DVB_CHANNEL_GROUP, gid, title, parent_id, channel_list, http_server);
}


guint rygel_dvb_channel_group_add_channels (RygelDVBChannelGroup* self, GUPnPDIDLLiteWriter* didl_writer, guint index, guint requested_count, guint* total_matches, GError** error) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (didl_writer != NULL, 0U);
	inner_error = NULL;
	{
		GeeCollection* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _channel_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_channel_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = gee_map_get_values ((GeeMap*) self->priv->channels))), (_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_channel_it)) {
			RygelDVBChannel* channel;
			channel = (RygelDVBChannel*) gee_iterator_get (_channel_it);
			rygel_media_object_serialize ((RygelMediaObject*) channel, didl_writer, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				(channel == NULL) ? NULL : (channel = (rygel_media_object_unref (channel), NULL));
				(_channel_it == NULL) ? NULL : (_channel_it = (g_object_unref (_channel_it), NULL));
				return 0U;
			}
			(channel == NULL) ? NULL : (channel = (rygel_media_object_unref (channel), NULL));
		}
		(_channel_it == NULL) ? NULL : (_channel_it = (g_object_unref (_channel_it), NULL));
	}
	(*total_matches) = (guint) gee_map_get_size ((GeeMap*) self->priv->channels);
	return (*total_matches);
}


RygelDVBChannel* rygel_dvb_channel_group_find_channel (RygelDVBChannelGroup* self, const char* id) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	return (RygelDVBChannel*) gee_map_get ((GeeMap*) self->priv->channels, id);
}


guint* _dynamic_GetChannels3 (DBusGProxy* self, int* result_length1, GError** error) {
	GArray* result;
	dbus_g_proxy_call (self, "GetChannels", error, G_TYPE_INVALID, dbus_g_type_get_collection ("GArray", G_TYPE_UINT), &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	*result_length1 = result->len;
	return (guint*) result->data;
}


static void rygel_dvb_channel_group_fetch_channels (RygelDVBChannelGroup* self) {
	GError * inner_error;
	GeeHashMap* _tmp0;
	DBusGConnection* connection;
	guint* _tmp3;
	gint channel_ids_size;
	gint channel_ids_length1;
	guint* channel_ids;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	self->priv->channels = (_tmp0 = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_TYPE_DVB_CHANNEL, (GBoxedCopyFunc) rygel_media_object_ref, rygel_media_object_unref, g_str_hash, g_str_equal, g_direct_equal), (self->priv->channels == NULL) ? NULL : (self->priv->channels = (g_object_unref (self->priv->channels), NULL)), _tmp0);
	connection = NULL;
	{
		DBusGConnection* _tmp1;
		DBusGConnection* _tmp2;
		_tmp1 = dbus_g_bus_get (DBUS_BUS_SESSION, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == DBUS_GERROR) {
				goto __catch3_dbus_gerror;
			}
			goto __finally3;
		}
		_tmp2 = NULL;
		connection = (_tmp2 = _tmp1, (connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL)), _tmp2);
	}
	goto __finally3;
	__catch3_dbus_gerror:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			g_critical ("rygel-dvb-channel-group.vala:91: Failed to connect to Session bus: %s\n", error->message);
			(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
			(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
			return;
		}
	}
	__finally3:
	if (inner_error != NULL) {
		(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	_tmp3 = NULL;
	channel_ids = (_tmp3 = NULL, channel_ids_length1 = 0, channel_ids_size = channel_ids_length1, _tmp3);
	{
		guint* _tmp6;
		gint _tmp5_size;
		gint _tmp5_length1;
		gint _tmp4;
		guint* _tmp5;
		guint* _tmp7;
		_tmp6 = NULL;
		_tmp5 = (_tmp6 = _dynamic_GetChannels3 (rygel_dvb_channel_group_channel_list, &_tmp4, &inner_error), _tmp5_length1 = _tmp4, _tmp5_size = _tmp5_length1, _tmp6);
		if (inner_error != NULL) {
			goto __catch4_g_error;
			goto __finally4;
		}
		_tmp7 = NULL;
		channel_ids = (_tmp7 = _tmp5, channel_ids = (g_free (channel_ids), NULL), channel_ids_length1 = _tmp5_length1, channel_ids_size = channel_ids_length1, _tmp7);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			g_critical ("rygel-dvb-channel-group.vala:101: error: %s", error->message);
			(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
			(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
			channel_ids = (g_free (channel_ids), NULL);
			return;
		}
	}
	__finally4:
	if (inner_error != NULL) {
		(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
		channel_ids = (g_free (channel_ids), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	{
		guint* channel_id_collection;
		int channel_id_collection_length1;
		int channel_id_it;
		channel_id_collection = channel_ids;
		channel_id_collection_length1 = channel_ids_length1;
		for (channel_id_it = 0; channel_id_it < channel_ids_length1; channel_id_it = channel_id_it + 1) {
			guint channel_id;
			channel_id = channel_id_collection[channel_id_it];
			{
				{
					RygelDVBChannel* channel;
					channel = rygel_dvb_channel_new (channel_id, ((RygelMediaObject*) self)->id, rygel_dvb_channel_group_channel_list, self->http_server, &inner_error);
					if (inner_error != NULL) {
						goto __catch5_g_error;
						goto __finally5;
					}
					gee_map_set ((GeeMap*) self->priv->channels, ((RygelMediaObject*) channel)->id, channel);
					(channel == NULL) ? NULL : (channel = (rygel_media_object_unref (channel), NULL));
				}
				goto __finally5;
				__catch5_g_error:
				{
					GError * error;
					error = inner_error;
					inner_error = NULL;
					{
						g_critical ("rygel-dvb-channel-group.vala:114: Failed to create DVB Channel object: %s", error->message);
						(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
					}
				}
				__finally5:
				if (inner_error != NULL) {
					(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
					channel_ids = (g_free (channel_ids), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
					return;
				}
			}
		}
	}
	((RygelMediaContainer*) self)->child_count = (guint) gee_map_get_size ((GeeMap*) self->priv->channels);
	(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
	channel_ids = (g_free (channel_ids), NULL);
}


static void rygel_dvb_channel_group_on_item_requested (RygelDVBChannelGroup* self, RygelHTTPServer* http_server, const char* item_id, RygelMediaItem** item) {
	RygelDVBChannel* channel;
	g_return_if_fail (self != NULL);
	g_return_if_fail (http_server != NULL);
	g_return_if_fail (item_id != NULL);
	*item = NULL;
	channel = rygel_dvb_channel_group_find_channel (self, item_id);
	if (channel != NULL) {
		RygelMediaItem* _tmp1;
		RygelMediaItem* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		(*item) = (_tmp1 = (_tmp0 = (RygelMediaItem*) channel, (_tmp0 == NULL) ? NULL : rygel_media_object_ref (_tmp0)), ((*item) == NULL) ? NULL : ((*item) = (rygel_media_object_unref ((*item)), NULL)), _tmp1);
	}
	(channel == NULL) ? NULL : (channel = (rygel_media_object_unref (channel), NULL));
}


static void rygel_dvb_channel_group_class_init (RygelDVBChannelGroupClass * klass) {
	rygel_dvb_channel_group_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_dvb_channel_group_finalize;
	g_type_class_add_private (klass, sizeof (RygelDVBChannelGroupPrivate));
}


static void rygel_dvb_channel_group_instance_init (RygelDVBChannelGroup * self) {
	self->priv = RYGEL_DVB_CHANNEL_GROUP_GET_PRIVATE (self);
}


static void rygel_dvb_channel_group_finalize (RygelMediaObject* obj) {
	RygelDVBChannelGroup * self;
	self = RYGEL_DVB_CHANNEL_GROUP (obj);
	(self->priv->channels == NULL) ? NULL : (self->priv->channels = (g_object_unref (self->priv->channels), NULL));
	(self->http_server == NULL) ? NULL : (self->http_server = (g_object_unref (self->http_server), NULL));
	RYGEL_MEDIA_OBJECT_CLASS (rygel_dvb_channel_group_parent_class)->finalize (obj);
}


GType rygel_dvb_channel_group_get_type (void) {
	static GType rygel_dvb_channel_group_type_id = 0;
	if (rygel_dvb_channel_group_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDVBChannelGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dvb_channel_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDVBChannelGroup), 0, (GInstanceInitFunc) rygel_dvb_channel_group_instance_init, NULL };
		rygel_dvb_channel_group_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelDVBChannelGroup", &g_define_type_info, 0);
	}
	return rygel_dvb_channel_group_type_id;
}




