/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-test-content-dir.h"
#include <gee/arraylist.h>
#include <rygel-http-server.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-media-item.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <rygel-media-object.h>
#include <gst/gst.h>
#include <gee/collection.h>
#include <rygel-media-container.h>
#include "rygel-test-item.h"
#include "rygel-test-audio-item.h"
#include "rygel-test-video-item.h"




struct _RygelTestContentDirPrivate {
	GeeArrayList* items;
};

#define RYGEL_TEST_CONTENT_DIR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TEST_CONTENT_DIR, RygelTestContentDirPrivate))
enum  {
	RYGEL_TEST_CONTENT_DIR_DUMMY_PROPERTY
};
static void _rygel_test_content_dir_on_item_requested_rygel_http_server_item_requested (RygelHTTPServer* _sender, const char* item_id, RygelMediaItem* item, gpointer self);
static void _rygel_test_content_dir_on_need_stream_source_rygel_http_server_need_stream_source (RygelHTTPServer* _sender, RygelMediaItem* item, GstElement* src, gpointer self);
static void rygel_test_content_dir_real_constructed (GObject* base);
static void rygel_test_content_dir_real_add_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
static void rygel_test_content_dir_real_add_root_children_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
static RygelMediaItem* rygel_test_content_dir_find_item_by_id (RygelTestContentDir* self, const char* item_id);
static void rygel_test_content_dir_on_item_requested (RygelTestContentDir* self, RygelHTTPServer* http_server, const char* item_id, RygelMediaItem** item);
static void rygel_test_content_dir_on_need_stream_source (RygelTestContentDir* self, RygelHTTPServer* http_server, RygelMediaItem* item, GstElement** src);
static gpointer rygel_test_content_dir_parent_class = NULL;
static void rygel_test_content_dir_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _rygel_test_content_dir_on_item_requested_rygel_http_server_item_requested (RygelHTTPServer* _sender, const char* item_id, RygelMediaItem* item, gpointer self) {
	rygel_test_content_dir_on_item_requested (self, _sender, item_id, item);
}


static void _rygel_test_content_dir_on_need_stream_source_rygel_http_server_need_stream_source (RygelHTTPServer* _sender, RygelMediaItem* item, GstElement* src, gpointer self) {
	rygel_test_content_dir_on_need_stream_source (self, _sender, item, src);
}


/* Pubic methods */
static void rygel_test_content_dir_real_constructed (GObject* base) {
	RygelTestContentDir * self;
	GeeArrayList* _tmp0;
	RygelTestAudioItem* _tmp1;
	RygelTestVideoItem* _tmp2;
	self = (RygelTestContentDir*) base;
	/* Chain-up to base first*/
	G_OBJECT_CLASS (rygel_test_content_dir_parent_class)->constructed ((GObject*) RYGEL_CONTENT_DIRECTORY (self));
	g_signal_connect_object (((RygelContentDirectory*) self)->http_server, "item-requested", (GCallback) _rygel_test_content_dir_on_item_requested_rygel_http_server_item_requested, self, 0);
	g_signal_connect_object (((RygelContentDirectory*) self)->http_server, "need-stream-source", (GCallback) _rygel_test_content_dir_on_need_stream_source_rygel_http_server_need_stream_source, self, 0);
	_tmp0 = NULL;
	self->priv->items = (_tmp0 = gee_array_list_new (RYGEL_TYPE_MEDIA_ITEM, (GBoxedCopyFunc) rygel_media_object_ref, rygel_media_object_unref, g_direct_equal), (self->priv->items == NULL) ? NULL : (self->priv->items = (g_object_unref (self->priv->items), NULL)), _tmp0);
	_tmp1 = NULL;
	gee_collection_add ((GeeCollection*) self->priv->items, (RygelMediaItem*) (_tmp1 = rygel_test_audio_item_new ("sinewave", ((RygelMediaObject*) ((RygelContentDirectory*) self)->root_container)->id, "Sine Wave", ((RygelContentDirectory*) self)->http_server)));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (rygel_media_object_unref (_tmp1), NULL));
	_tmp2 = NULL;
	gee_collection_add ((GeeCollection*) self->priv->items, (RygelMediaItem*) (_tmp2 = rygel_test_video_item_new ("smtpe", ((RygelMediaObject*) ((RygelContentDirectory*) self)->root_container)->id, "SMTPE", ((RygelContentDirectory*) self)->http_server)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (rygel_media_object_unref (_tmp2), NULL));
	/* Now we know how many top-level items we have*/
	((RygelContentDirectory*) self)->root_container->child_count = (guint) gee_collection_get_size ((GeeCollection*) self->priv->items);
}


static void rygel_test_content_dir_real_add_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error) {
	RygelTestContentDir * self;
	GError * inner_error;
	RygelMediaItem* item;
	self = (RygelTestContentDir*) base;
	g_return_if_fail (didl_writer != NULL);
	g_return_if_fail (args != NULL);
	inner_error = NULL;
	item = rygel_test_content_dir_find_item_by_id (self, args->object_id);
	if (item == NULL) {
		inner_error = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, "No such object");
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL));
			return;
		}
	}
	rygel_media_object_serialize ((RygelMediaObject*) item, didl_writer, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL));
		return;
	}
	args->update_id = (guint) G_MAXUINT32;
	(item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL));
}


static void rygel_test_content_dir_real_add_root_children_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error) {
	RygelTestContentDir * self;
	GError * inner_error;
	self = (RygelTestContentDir*) base;
	g_return_if_fail (didl_writer != NULL);
	g_return_if_fail (args != NULL);
	inner_error = NULL;
	{
		GeeIterator* _item_it;
		_item_it = gee_iterable_iterator ((GeeIterable*) self->priv->items);
		while (gee_iterator_next (_item_it)) {
			RygelMediaItem* item;
			item = (RygelMediaItem*) gee_iterator_get (_item_it);
			rygel_media_object_serialize ((RygelMediaObject*) item, didl_writer, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				(item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL));
				(_item_it == NULL) ? NULL : (_item_it = (g_object_unref (_item_it), NULL));
				return;
			}
			(item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL));
		}
		(_item_it == NULL) ? NULL : (_item_it = (g_object_unref (_item_it), NULL));
	}
	args->total_matches = args->number_returned = (guint) gee_collection_get_size ((GeeCollection*) self->priv->items);
	args->update_id = (guint) G_MAXUINT32;
}


/* Private methods */
static RygelMediaItem* rygel_test_content_dir_find_item_by_id (RygelTestContentDir* self, const char* item_id) {
	RygelMediaItem* item;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_id != NULL, NULL);
	item = NULL;
	{
		GeeIterator* _tmp_it;
		_tmp_it = gee_iterable_iterator ((GeeIterable*) self->priv->items);
		while (gee_iterator_next (_tmp_it)) {
			RygelMediaItem* tmp;
			tmp = (RygelMediaItem*) gee_iterator_get (_tmp_it);
			if (_vala_strcmp0 (item_id, ((RygelMediaObject*) tmp)->id) == 0) {
				RygelMediaItem* _tmp1;
				RygelMediaItem* _tmp0;
				_tmp1 = NULL;
				_tmp0 = NULL;
				item = (_tmp1 = (_tmp0 = tmp, (_tmp0 == NULL) ? NULL : rygel_media_object_ref (_tmp0)), (item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL)), _tmp1);
				(tmp == NULL) ? NULL : (tmp = (rygel_media_object_unref (tmp), NULL));
				break;
			}
			(tmp == NULL) ? NULL : (tmp = (rygel_media_object_unref (tmp), NULL));
		}
		(_tmp_it == NULL) ? NULL : (_tmp_it = (g_object_unref (_tmp_it), NULL));
	}
	return item;
}


static void rygel_test_content_dir_on_item_requested (RygelTestContentDir* self, RygelHTTPServer* http_server, const char* item_id, RygelMediaItem** item) {
	RygelMediaItem* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (http_server != NULL);
	g_return_if_fail (item_id != NULL);
	*item = NULL;
	_tmp0 = NULL;
	(*item) = (_tmp0 = rygel_test_content_dir_find_item_by_id (self, item_id), ((*item) == NULL) ? NULL : ((*item) = (rygel_media_object_unref ((*item)), NULL)), _tmp0);
}


static void rygel_test_content_dir_on_need_stream_source (RygelTestContentDir* self, RygelHTTPServer* http_server, RygelMediaItem* item, GstElement** src) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (http_server != NULL);
	g_return_if_fail (item != NULL);
	*src = NULL;
	inner_error = NULL;
	{
		GstElement* _tmp0;
		GstElement* _tmp1;
		_tmp0 = rygel_test_item_create_gst_source ((RYGEL_TEST_ITEM (item)), &inner_error);
		if (inner_error != NULL) {
			goto __catch0_g_error;
			goto __finally0;
		}
		_tmp1 = NULL;
		(*src) = (_tmp1 = _tmp0, ((*src) == NULL) ? NULL : ((*src) = (gst_object_unref ((*src)), NULL)), _tmp1);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			g_critical ("rygel-test-content-dir.vala:106: Error creating Gst source element for item %s: %s", ((RygelMediaObject*) item)->id, error->message);
			(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
			return;
		}
	}
	__finally0:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


/**
 * Implementation of ContentDirectory service, meant for testing purposes only.
 */
RygelTestContentDir* rygel_test_content_dir_construct (GType object_type) {
	RygelTestContentDir * self;
	self = (RygelTestContentDir*) rygel_content_directory_construct (object_type);
	return self;
}


RygelTestContentDir* rygel_test_content_dir_new (void) {
	return rygel_test_content_dir_construct (RYGEL_TYPE_TEST_CONTENT_DIR);
}


static void rygel_test_content_dir_class_init (RygelTestContentDirClass * klass) {
	rygel_test_content_dir_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTestContentDirPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_test_content_dir_finalize;
	G_OBJECT_CLASS (klass)->constructed = rygel_test_content_dir_real_constructed;
	RYGEL_CONTENT_DIRECTORY_CLASS (klass)->add_metadata = rygel_test_content_dir_real_add_metadata;
	RYGEL_CONTENT_DIRECTORY_CLASS (klass)->add_root_children_metadata = rygel_test_content_dir_real_add_root_children_metadata;
}


static void rygel_test_content_dir_instance_init (RygelTestContentDir * self) {
	self->priv = RYGEL_TEST_CONTENT_DIR_GET_PRIVATE (self);
}


static void rygel_test_content_dir_finalize (GObject* obj) {
	RygelTestContentDir * self;
	self = RYGEL_TEST_CONTENT_DIR (obj);
	(self->priv->items == NULL) ? NULL : (self->priv->items = (g_object_unref (self->priv->items), NULL));
	G_OBJECT_CLASS (rygel_test_content_dir_parent_class)->finalize (obj);
}


GType rygel_test_content_dir_get_type (void) {
	static GType rygel_test_content_dir_type_id = 0;
	if (rygel_test_content_dir_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTestContentDirClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_test_content_dir_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTestContentDir), 0, (GInstanceInitFunc) rygel_test_content_dir_instance_init, NULL };
		rygel_test_content_dir_type_id = g_type_register_static (RYGEL_TYPE_CONTENT_DIRECTORY, "RygelTestContentDir", &g_define_type_info, 0);
	}
	return rygel_test_content_dir_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




