/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __RYGEL_MEDIA_TRACKER_H__
#define __RYGEL_MEDIA_TRACKER_H__

#include <glib.h>
#include <glib-object.h>
#include <rygel-content-directory.h>
#include <libgupnp-av/gupnp-av.h>

G_BEGIN_DECLS


#define RYGEL_TYPE_MEDIA_TRACKER (rygel_media_tracker_get_type ())
#define RYGEL_MEDIA_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_TRACKER, RygelMediaTracker))
#define RYGEL_MEDIA_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_TRACKER, RygelMediaTrackerClass))
#define RYGEL_IS_MEDIA_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_TRACKER))
#define RYGEL_IS_MEDIA_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_TRACKER))
#define RYGEL_MEDIA_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_TRACKER, RygelMediaTrackerClass))

typedef struct _RygelMediaTracker RygelMediaTracker;
typedef struct _RygelMediaTrackerClass RygelMediaTrackerClass;
typedef struct _RygelMediaTrackerPrivate RygelMediaTrackerPrivate;

/**
 * Implementation of Tracker-based ContentDirectory service.
 */
struct _RygelMediaTracker {
	RygelContentDirectory parent_instance;
	RygelMediaTrackerPrivate * priv;
};

struct _RygelMediaTrackerClass {
	RygelContentDirectoryClass parent_class;
};


#define RYGEL_MEDIA_TRACKER_MAX_REQUESTED_COUNT 128
RygelMediaTracker* rygel_media_tracker_construct (GType object_type);
RygelMediaTracker* rygel_media_tracker_new (void);
GType rygel_media_tracker_get_type (void);


G_END_DECLS

#endif
