/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __RYGEL_TRACKER_CONTAINER_H__
#define __RYGEL_TRACKER_CONTAINER_H__

#include <glib.h>
#include <glib-object.h>
#include <rygel-media-container.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <rygel-http-server.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-media-item.h>

G_BEGIN_DECLS


#define RYGEL_TYPE_TRACKER_CONTAINER (rygel_tracker_container_get_type ())
#define RYGEL_TRACKER_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_CONTAINER, RygelTrackerContainer))
#define RYGEL_TRACKER_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_CONTAINER, RygelTrackerContainerClass))
#define RYGEL_IS_TRACKER_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_CONTAINER))
#define RYGEL_IS_TRACKER_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_CONTAINER))
#define RYGEL_TRACKER_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_CONTAINER, RygelTrackerContainerClass))

typedef struct _RygelTrackerContainer RygelTrackerContainer;
typedef struct _RygelTrackerContainerClass RygelTrackerContainerClass;
typedef struct _RygelTrackerContainerPrivate RygelTrackerContainerPrivate;

/**
 * Represents Tracker category.
 */
struct _RygelTrackerContainer {
	RygelMediaContainer parent_instance;
	RygelTrackerContainerPrivate * priv;
	RygelHTTPServer* http_server;
	char* category;
	char* child_class;
};

struct _RygelTrackerContainerClass {
	RygelMediaContainerClass parent_class;
};


extern DBusGProxy* rygel_tracker_container_metadata;
extern DBusGProxy* rygel_tracker_container_files;
extern DBusGProxy* rygel_tracker_container_tracker;
RygelTrackerContainer* rygel_tracker_container_construct (GType object_type, const char* id, const char* parent_id, const char* title, const char* category, const char* child_class, RygelHTTPServer* http_server);
RygelTrackerContainer* rygel_tracker_container_new (const char* id, const char* parent_id, const char* title, const char* category, const char* child_class, RygelHTTPServer* http_server);
guint rygel_tracker_container_add_children_from_db (RygelTrackerContainer* self, GUPnPDIDLLiteWriter* didl_writer, guint offset, guint max_count, guint* child_count);
gboolean rygel_tracker_container_add_item_from_db (RygelTrackerContainer* self, GUPnPDIDLLiteWriter* didl_writer, const char* path);
char* rygel_tracker_container_get_file_category (const char* uri, GError** error);
RygelMediaItem* rygel_tracker_container_get_item_from_db (RygelTrackerContainer* self, const char* path, GError** error);
GType rygel_tracker_container_get_type (void);


G_END_DECLS

#endif
