/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <rygel-media-item.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <string.h>




enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
static void rygel_media_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* didl_writer, GError** error);
static char* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const char* uri, GError** error);
static GUPnPDIDLLiteResource* _gupnp_didl_lite_resource_dup (GUPnPDIDLLiteResource* self);
static GeeArrayList* rygel_media_item_get_transcoded_resources (RygelMediaItem* self, const GUPnPDIDLLiteResource* orig_res);
static gpointer rygel_media_item_parent_class = NULL;
static void rygel_media_item_finalize (RygelMediaObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_media_item_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_item_error-quark");
}


RygelMediaItem* rygel_media_item_construct (GType object_type, const char* id, const char* parent_id, const char* title, const char* upnp_class, RygelHTTPServer* http_server) {
	RygelMediaItem* self;
	char* _tmp1;
	const char* _tmp0;
	char* _tmp3;
	const char* _tmp2;
	char* _tmp5;
	const char* _tmp4;
	char* _tmp7;
	const char* _tmp6;
	RygelHTTPServer* _tmp9;
	RygelHTTPServer* _tmp8;
	GUPnPDIDLLiteResource _tmp11 = {0};
	GUPnPDIDLLiteResource _tmp10 = {0};
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent_id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	self = (RygelMediaItem*) g_type_create_instance (object_type);
	_tmp1 = NULL;
	_tmp0 = NULL;
	((RygelMediaObject*) self)->id = (_tmp1 = (_tmp0 = id, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), ((RygelMediaObject*) self)->id = (g_free (((RygelMediaObject*) self)->id), NULL), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	((RygelMediaObject*) self)->parent_id = (_tmp3 = (_tmp2 = parent_id, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), ((RygelMediaObject*) self)->parent_id = (g_free (((RygelMediaObject*) self)->parent_id), NULL), _tmp3);
	_tmp5 = NULL;
	_tmp4 = NULL;
	((RygelMediaObject*) self)->title = (_tmp5 = (_tmp4 = title, (_tmp4 == NULL) ? NULL : g_strdup (_tmp4)), ((RygelMediaObject*) self)->title = (g_free (((RygelMediaObject*) self)->title), NULL), _tmp5);
	_tmp7 = NULL;
	_tmp6 = NULL;
	self->upnp_class = (_tmp7 = (_tmp6 = upnp_class, (_tmp6 == NULL) ? NULL : g_strdup (_tmp6)), self->upnp_class = (g_free (self->upnp_class), NULL), _tmp7);
	_tmp9 = NULL;
	_tmp8 = NULL;
	self->http_server = (_tmp9 = (_tmp8 = http_server, (_tmp8 == NULL) ? NULL : g_object_ref (_tmp8)), (self->http_server == NULL) ? NULL : (self->http_server = (g_object_unref (self->http_server), NULL)), _tmp9);
	self->res = (_tmp11 = (memset (&_tmp10, 0, sizeof (GUPnPDIDLLiteResource)), _tmp10), gupnp_didl_lite_resource_destroy (&self->res), _tmp11);
	gupnp_didl_lite_resource_reset (&self->res);
	return self;
}


RygelMediaItem* rygel_media_item_new (const char* id, const char* parent_id, const char* title, const char* upnp_class, RygelHTTPServer* http_server) {
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM, id, parent_id, title, upnp_class, http_server);
}


static void rygel_media_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* didl_writer, GError** error) {
	RygelMediaItem * self;
	GError * inner_error;
	gboolean _tmp0;
	gboolean _tmp1;
	gboolean _tmp2;
	char* _tmp5;
	GeeArrayList* res_list;
	self = (RygelMediaItem*) base;
	g_return_if_fail (didl_writer != NULL);
	inner_error = NULL;
	gupnp_didl_lite_writer_start_item (didl_writer, ((RygelMediaObject*) self)->id, ((RygelMediaObject*) self)->parent_id, NULL, FALSE);
	/* Add fields */
	gupnp_didl_lite_writer_add_string (didl_writer, "title", GUPNP_DIDL_LITE_WRITER_NAMESPACE_DC, NULL, ((RygelMediaObject*) self)->title);
	gupnp_didl_lite_writer_add_string (didl_writer, "class", GUPNP_DIDL_LITE_WRITER_NAMESPACE_UPNP, NULL, self->upnp_class);
	_tmp0 = FALSE;
	if (self->author != NULL) {
		_tmp0 = _vala_strcmp0 (self->author, "") != 0;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		gupnp_didl_lite_writer_add_string (didl_writer, "creator", GUPNP_DIDL_LITE_WRITER_NAMESPACE_DC, NULL, self->author);
		if (g_str_has_prefix (self->upnp_class, RYGEL_MEDIA_ITEM_VIDEO_CLASS)) {
			gupnp_didl_lite_writer_add_string (didl_writer, "author", GUPNP_DIDL_LITE_WRITER_NAMESPACE_UPNP, NULL, self->author);
		} else {
			if (g_str_has_prefix (self->upnp_class, RYGEL_MEDIA_ITEM_MUSIC_CLASS)) {
				gupnp_didl_lite_writer_add_string (didl_writer, "artist", GUPNP_DIDL_LITE_WRITER_NAMESPACE_UPNP, NULL, self->author);
			}
		}
	}
	if (self->track_number >= 0) {
		gupnp_didl_lite_writer_add_int (didl_writer, "originalTrackNumber", GUPNP_DIDL_LITE_WRITER_NAMESPACE_UPNP, NULL, self->track_number);
	}
	_tmp1 = FALSE;
	if (self->album != NULL) {
		_tmp1 = _vala_strcmp0 (self->album, "") != 0;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		gupnp_didl_lite_writer_add_string (didl_writer, "album", GUPNP_DIDL_LITE_WRITER_NAMESPACE_UPNP, NULL, self->album);
	}
	_tmp2 = FALSE;
	if (self->date != NULL) {
		_tmp2 = _vala_strcmp0 (self->date, "") != 0;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		gupnp_didl_lite_writer_add_string (didl_writer, "date", GUPNP_DIDL_LITE_WRITER_NAMESPACE_DC, NULL, self->date);
	}
	/* Add resource data 
	 Protocol info */
	if (self->res.uri != NULL) {
		char* protocol;
		char* _tmp4;
		const char* _tmp3;
		protocol = rygel_media_item_get_protocol_for_uri (self, self->res.uri, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return;
		}
		_tmp4 = NULL;
		_tmp3 = NULL;
		self->res.protocol = (_tmp4 = (_tmp3 = protocol, (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)), self->res.protocol = (g_free (self->res.protocol), NULL), _tmp4);
		protocol = (g_free (protocol), NULL);
	}
	_tmp5 = NULL;
	self->res.dlna_profile = (_tmp5 = g_strdup ("MP3"), self->res.dlna_profile = (g_free (self->res.dlna_profile), NULL), _tmp5);
	/* FIXME */
	if (g_str_has_prefix (self->upnp_class, RYGEL_MEDIA_ITEM_IMAGE_CLASS)) {
		self->res.dlna_flags = self->res.dlna_flags | (GUPNP_DLNA_FLAG_INTERACTIVE_TRANSFER_MODE);
	} else {
		self->res.dlna_flags = self->res.dlna_flags | (GUPNP_DLNA_FLAG_STREAMING_TRANSFER_MODE);
	}
	if (self->res.size > 0) {
		self->res.dlna_operation = GUPNP_DLNA_OPERATION_RANGE;
		self->res.dlna_flags = self->res.dlna_flags | (GUPNP_DLNA_FLAG_BACKGROUND_TRANSFER_MODE);
	}
	/* Now get the transcoded/proxy URIs */
	res_list = rygel_media_item_get_transcoded_resources (self, &self->res);
	{
		GeeIterator* _trans_res_it;
		_trans_res_it = gee_iterable_iterator ((GeeIterable*) res_list);
		while (gee_iterator_next (_trans_res_it)) {
			GUPnPDIDLLiteResource _tmp7 = {0};
			GUPnPDIDLLiteResource* _tmp6 = {0};
			GUPnPDIDLLiteResource _tmp8 = {0};
			GUPnPDIDLLiteResource trans_res;
			trans_res = (_tmp8 = (gupnp_didl_lite_resource_copy (&(*(_tmp6 = (GUPnPDIDLLiteResource*) gee_iterator_get (_trans_res_it))), &_tmp7), _tmp7), (_tmp6 == NULL) ? NULL : (_tmp6 = (g_free (_tmp6), NULL)), _tmp8);
			gupnp_didl_lite_writer_add_res (didl_writer, &trans_res);
			gupnp_didl_lite_resource_destroy (&trans_res);
		}
		(_trans_res_it == NULL) ? NULL : (_trans_res_it = (g_object_unref (_trans_res_it), NULL));
	}
	/* Add the original res in the end */
	if (self->res.uri != NULL) {
		gupnp_didl_lite_writer_add_res (didl_writer, &self->res);
	}
	/* End of item */
	gupnp_didl_lite_writer_end_item (didl_writer);
	(res_list == NULL) ? NULL : (res_list = (g_object_unref (res_list), NULL));
}


static char* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const char* uri, GError** error) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	inner_error = NULL;
	if (g_str_has_prefix (uri, "http")) {
		return g_strdup ("http-get");
	} else {
		if (g_str_has_prefix (uri, "file")) {
			return g_strdup ("internal");
		} else {
			if (g_str_has_prefix (uri, "rtsp")) {
				/* FIXME: Assuming that RTSP is always accompanied with RTP over UDP*/
				return g_strdup ("rtsp-rtp-udp");
			} else {
				inner_error = g_error_new (RYGEL_MEDIA_ITEM_ERROR, RYGEL_MEDIA_ITEM_ERROR_UNKNOWN_URI_TYPE, "Failed to probe protocol for URI %s", uri);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return NULL;
				}
			}
		}
	}
}


static GUPnPDIDLLiteResource* _gupnp_didl_lite_resource_dup (GUPnPDIDLLiteResource* self) {
	GUPnPDIDLLiteResource* dup;
	dup = g_new0 (GUPnPDIDLLiteResource, 1);
	gupnp_didl_lite_resource_copy (self, dup);
	return dup;
}


/* FIXME: We only proxy URIs through our HTTP server for now*/
static GeeArrayList* rygel_media_item_get_transcoded_resources (RygelMediaItem* self, const GUPnPDIDLLiteResource* orig_res) {
	GeeArrayList* resources;
	GUPnPDIDLLiteResource _tmp1 = {0};
	GUPnPDIDLLiteResource res;
	char* _tmp2;
	char* _tmp3;
	GeeArrayList* _tmp4;
	g_return_val_if_fail (self != NULL, NULL);
	if (_vala_strcmp0 ((*orig_res).protocol, "http-get") == 0) {
		return NULL;
	}
	resources = gee_array_list_new (GUPNP_TYPE_DIDL_LITE_RESOURCE, (GBoxedCopyFunc) _gupnp_didl_lite_resource_dup, g_free, g_direct_equal);
	/* Copy the original res first*/
	res = (gupnp_didl_lite_resource_copy (&(*orig_res), &_tmp1), _tmp1);
	/* Then modify the URI and protocol*/
	_tmp2 = NULL;
	res.uri = (_tmp2 = rygel_http_server_create_http_uri_for_item (self->http_server, self), res.uri = (g_free (res.uri), NULL), _tmp2);
	_tmp3 = NULL;
	res.protocol = (_tmp3 = g_strdup ("http-get"), res.protocol = (g_free (res.protocol), NULL), _tmp3);
	gee_collection_add ((GeeCollection*) resources, &res);
	_tmp4 = NULL;
	return (_tmp4 = resources, gupnp_didl_lite_resource_destroy (&res), _tmp4);
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_item_real_serialize;
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	self->track_number = -1;
}


static void rygel_media_item_finalize (RygelMediaObject* obj) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (obj);
	self->author = (g_free (self->author), NULL);
	self->album = (g_free (self->album), NULL);
	self->date = (g_free (self->date), NULL);
	self->upnp_class = (g_free (self->upnp_class), NULL);
	gupnp_didl_lite_resource_destroy (&self->res);
	(self->http_server == NULL) ? NULL : (self->http_server = (g_object_unref (self->http_server), NULL));
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


GType rygel_media_item_get_type (void) {
	static GType rygel_media_item_type_id = 0;
	if (rygel_media_item_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
	}
	return rygel_media_item_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




