/* scanner.c generated by valac 0.13.0, the Vala compiler
 * generated from scanner.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* TODO: Could indicate the start of the next page immediately after the last page is received (i.e. before the sane_cancel()) */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <sane/sane.h>
#include <glib/gi18n-lib.h>
#include <sane/saneopts.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecScanDevice ParamSpecScanDevice;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ParamSpecScanPageInfo ParamSpecScanPageInfo;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanLinePrivate ScanLinePrivate;
typedef struct _ParamSpecScanLine ParamSpecScanLine;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
typedef struct _ParamSpecScanOptions ParamSpecScanOptions;

#define TYPE_SCAN_JOB (scan_job_get_type ())
#define SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_JOB, ScanJob))
#define SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_JOB, ScanJobClass))
#define IS_SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_JOB))
#define IS_SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_JOB))
#define SCAN_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_JOB, ScanJobClass))

typedef struct _ScanJob ScanJob;
typedef struct _ScanJobClass ScanJobClass;
typedef struct _ScanJobPrivate ScanJobPrivate;
typedef struct _ParamSpecScanJob ParamSpecScanJob;

#define TYPE_REQUEST (request_get_type ())
#define REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST, Request))
#define REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST, RequestClass))
#define IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST))
#define IS_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST))
#define REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST, RequestClass))

typedef struct _Request Request;
typedef struct _RequestClass RequestClass;
typedef struct _RequestPrivate RequestPrivate;
typedef struct _ParamSpecRequest ParamSpecRequest;

#define TYPE_REQUEST_REDETECT (request_redetect_get_type ())
#define REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_REDETECT, RequestRedetect))
#define REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_REDETECT, RequestRedetectClass))
#define IS_REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_REDETECT))
#define IS_REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_REDETECT))
#define REQUEST_REDETECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_REDETECT, RequestRedetectClass))

typedef struct _RequestRedetect RequestRedetect;
typedef struct _RequestRedetectClass RequestRedetectClass;
typedef struct _RequestRedetectPrivate RequestRedetectPrivate;

#define TYPE_REQUEST_CANCEL (request_cancel_get_type ())
#define REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_CANCEL, RequestCancel))
#define REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_CANCEL, RequestCancelClass))
#define IS_REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_CANCEL))
#define IS_REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_CANCEL))
#define REQUEST_CANCEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_CANCEL, RequestCancelClass))

typedef struct _RequestCancel RequestCancel;
typedef struct _RequestCancelClass RequestCancelClass;
typedef struct _RequestCancelPrivate RequestCancelPrivate;

#define TYPE_REQUEST_START_SCAN (request_start_scan_get_type ())
#define REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_START_SCAN, RequestStartScan))
#define REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_START_SCAN, RequestStartScanClass))
#define IS_REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_START_SCAN))
#define IS_REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_START_SCAN))
#define REQUEST_START_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_START_SCAN, RequestStartScanClass))

typedef struct _RequestStartScan RequestStartScan;
typedef struct _RequestStartScanClass RequestStartScanClass;
typedef struct _RequestStartScanPrivate RequestStartScanPrivate;
#define _scan_job_unref0(var) ((var == NULL) ? NULL : (var = (scan_job_unref (var), NULL)))

#define TYPE_REQUEST_QUIT (request_quit_get_type ())
#define REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_QUIT, RequestQuit))
#define REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_QUIT, RequestQuitClass))
#define IS_REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_QUIT))
#define IS_REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_QUIT))
#define REQUEST_QUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_QUIT, RequestQuitClass))

typedef struct _RequestQuit RequestQuit;
typedef struct _RequestQuitClass RequestQuitClass;
typedef struct _RequestQuitPrivate RequestQuitPrivate;

#define TYPE_CREDENTIALS (credentials_get_type ())
#define CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CREDENTIALS, Credentials))
#define CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CREDENTIALS, CredentialsClass))
#define IS_CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CREDENTIALS))
#define IS_CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CREDENTIALS))
#define CREDENTIALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CREDENTIALS, CredentialsClass))

typedef struct _Credentials Credentials;
typedef struct _CredentialsClass CredentialsClass;
typedef struct _CredentialsPrivate CredentialsPrivate;
typedef struct _ParamSpecCredentials ParamSpecCredentials;

#define TYPE_SCAN_STATE (scan_state_get_type ())

#define TYPE_NOTIFY (notify_get_type ())
#define NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY, Notify))
#define NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY, NotifyClass))
#define IS_NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY))
#define IS_NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY))
#define NOTIFY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY, NotifyClass))

typedef struct _Notify Notify;
typedef struct _NotifyClass NotifyClass;
typedef struct _NotifyPrivate NotifyPrivate;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;
typedef struct _ParamSpecNotify ParamSpecNotify;

#define TYPE_NOTIFY_SCANNING_CHANGED (notify_scanning_changed_get_type ())
#define NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChanged))
#define NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))
#define IS_NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCANNING_CHANGED))
#define IS_NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCANNING_CHANGED))
#define NOTIFY_SCANNING_CHANGED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))

typedef struct _NotifyScanningChanged NotifyScanningChanged;
typedef struct _NotifyScanningChangedClass NotifyScanningChangedClass;
typedef struct _NotifyScanningChangedPrivate NotifyScanningChangedPrivate;

#define TYPE_NOTIFY_UPDATE_DEVICES (notify_update_devices_get_type ())
#define NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevices))
#define NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))
#define IS_NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_UPDATE_DEVICES))
#define IS_NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_UPDATE_DEVICES))
#define NOTIFY_UPDATE_DEVICES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))

typedef struct _NotifyUpdateDevices NotifyUpdateDevices;
typedef struct _NotifyUpdateDevicesClass NotifyUpdateDevicesClass;
typedef struct _NotifyUpdateDevicesPrivate NotifyUpdateDevicesPrivate;
#define __g_list_free__scan_device_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_device_unref0_ (var), NULL)))

#define TYPE_NOTIFY_REQUEST_AUTHORIZATION (notify_request_authorization_get_type ())
#define NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorization))
#define NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))
#define IS_NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define IS_NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define NOTIFY_REQUEST_AUTHORIZATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))

typedef struct _NotifyRequestAuthorization NotifyRequestAuthorization;
typedef struct _NotifyRequestAuthorizationClass NotifyRequestAuthorizationClass;
typedef struct _NotifyRequestAuthorizationPrivate NotifyRequestAuthorizationPrivate;

#define TYPE_NOTIFY_SCAN_FAILED (notify_scan_failed_get_type ())
#define NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailed))
#define NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))
#define IS_NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCAN_FAILED))
#define IS_NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCAN_FAILED))
#define NOTIFY_SCAN_FAILED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))

typedef struct _NotifyScanFailed NotifyScanFailed;
typedef struct _NotifyScanFailedClass NotifyScanFailedClass;
typedef struct _NotifyScanFailedPrivate NotifyScanFailedPrivate;

#define TYPE_NOTIFY_DOCUMENT_DONE (notify_document_done_get_type ())
#define NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDone))
#define NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))
#define IS_NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_DOCUMENT_DONE))
#define IS_NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_DOCUMENT_DONE))
#define NOTIFY_DOCUMENT_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))

typedef struct _NotifyDocumentDone NotifyDocumentDone;
typedef struct _NotifyDocumentDoneClass NotifyDocumentDoneClass;
typedef struct _NotifyDocumentDonePrivate NotifyDocumentDonePrivate;

#define TYPE_NOTIFY_EXPECT_PAGE (notify_expect_page_get_type ())
#define NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPage))
#define NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))
#define IS_NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_EXPECT_PAGE))
#define IS_NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_EXPECT_PAGE))
#define NOTIFY_EXPECT_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))

typedef struct _NotifyExpectPage NotifyExpectPage;
typedef struct _NotifyExpectPageClass NotifyExpectPageClass;
typedef struct _NotifyExpectPagePrivate NotifyExpectPagePrivate;

#define TYPE_NOTIFY_GOT_PAGE_INFO (notify_got_page_info_get_type ())
#define NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfo))
#define NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))
#define IS_NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_PAGE_INFO))
#define IS_NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_PAGE_INFO))
#define NOTIFY_GOT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))

typedef struct _NotifyGotPageInfo NotifyGotPageInfo;
typedef struct _NotifyGotPageInfoClass NotifyGotPageInfoClass;
typedef struct _NotifyGotPageInfoPrivate NotifyGotPageInfoPrivate;
#define _scan_page_info_unref0(var) ((var == NULL) ? NULL : (var = (scan_page_info_unref (var), NULL)))

#define TYPE_NOTIFY_PAGE_DONE (notify_page_done_get_type ())
#define NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDone))
#define NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))
#define IS_NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_PAGE_DONE))
#define IS_NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_PAGE_DONE))
#define NOTIFY_PAGE_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))

typedef struct _NotifyPageDone NotifyPageDone;
typedef struct _NotifyPageDoneClass NotifyPageDoneClass;
typedef struct _NotifyPageDonePrivate NotifyPageDonePrivate;

#define TYPE_NOTIFY_GOT_LINE (notify_got_line_get_type ())
#define NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLine))
#define NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))
#define IS_NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_LINE))
#define IS_NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_LINE))
#define NOTIFY_GOT_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))

typedef struct _NotifyGotLine NotifyGotLine;
typedef struct _NotifyGotLineClass NotifyGotLineClass;
typedef struct _NotifyGotLinePrivate NotifyGotLinePrivate;
#define _scan_line_unref0(var) ((var == NULL) ? NULL : (var = (scan_line_unref (var), NULL)))
typedef struct _ScannerPrivate ScannerPrivate;
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define __g_list_free__scan_job_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_job_unref0_ (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _notify_unref0(var) ((var == NULL) ? NULL : (var = (notify_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _credentials_unref0(var) ((var == NULL) ? NULL : (var = (credentials_unref (var), NULL)))
#define _request_unref0(var) ((var == NULL) ? NULL : (var = (request_unref (var), NULL)))
typedef struct _ParamSpecScanner ParamSpecScanner;

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

struct _ParamSpecScanDevice {
	GParamSpec parent_instance;
};

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

struct _ParamSpecScanPageInfo {
	GParamSpec parent_instance;
};

struct _ScanLine {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanLinePrivate * priv;
	gint number;
	gint n_lines;
	gint width;
	gint depth;
	gint channel;
	guchar* data;
	gint data_length1;
	gint data_length;
};

struct _ScanLineClass {
	GTypeClass parent_class;
	void (*finalize) (ScanLine *self);
};

struct _ParamSpecScanLine {
	GParamSpec parent_instance;
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecScanOptions {
	GParamSpec parent_instance;
};

struct _ScanJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanJobPrivate * priv;
	gchar* device;
	gdouble dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint page_width;
	gint page_height;
};

struct _ScanJobClass {
	GTypeClass parent_class;
	void (*finalize) (ScanJob *self);
};

struct _ParamSpecScanJob {
	GParamSpec parent_instance;
};

struct _Request {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RequestPrivate * priv;
};

struct _RequestClass {
	GTypeClass parent_class;
	void (*finalize) (Request *self);
};

struct _ParamSpecRequest {
	GParamSpec parent_instance;
};

struct _RequestRedetect {
	Request parent_instance;
	RequestRedetectPrivate * priv;
};

struct _RequestRedetectClass {
	RequestClass parent_class;
};

struct _RequestCancel {
	Request parent_instance;
	RequestCancelPrivate * priv;
};

struct _RequestCancelClass {
	RequestClass parent_class;
};

struct _RequestStartScan {
	Request parent_instance;
	RequestStartScanPrivate * priv;
	ScanJob* job;
};

struct _RequestStartScanClass {
	RequestClass parent_class;
};

struct _RequestQuit {
	Request parent_instance;
	RequestQuitPrivate * priv;
};

struct _RequestQuitClass {
	RequestClass parent_class;
};

struct _Credentials {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CredentialsPrivate * priv;
	gchar* username;
	gchar* password;
};

struct _CredentialsClass {
	GTypeClass parent_class;
	void (*finalize) (Credentials *self);
};

struct _ParamSpecCredentials {
	GParamSpec parent_instance;
};

typedef enum  {
	SCAN_STATE_IDLE = 0,
	SCAN_STATE_REDETECT,
	SCAN_STATE_OPEN,
	SCAN_STATE_GET_OPTION,
	SCAN_STATE_START,
	SCAN_STATE_GET_PARAMETERS,
	SCAN_STATE_READ
} ScanState;

struct _Notify {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NotifyPrivate * priv;
};

struct _NotifyClass {
	GTypeClass parent_class;
	void (*finalize) (Notify *self);
	void (*run) (Notify* self, Scanner* scanner);
};

struct _ParamSpecNotify {
	GParamSpec parent_instance;
};

struct _NotifyScanningChanged {
	Notify parent_instance;
	NotifyScanningChangedPrivate * priv;
};

struct _NotifyScanningChangedClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevices {
	Notify parent_instance;
	NotifyUpdateDevicesPrivate * priv;
};

struct _NotifyUpdateDevicesClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevicesPrivate {
	GList* devices;
};

struct _NotifyRequestAuthorization {
	Notify parent_instance;
	NotifyRequestAuthorizationPrivate * priv;
};

struct _NotifyRequestAuthorizationClass {
	NotifyClass parent_class;
};

struct _NotifyRequestAuthorizationPrivate {
	gchar* resource;
};

struct _NotifyScanFailed {
	Notify parent_instance;
	NotifyScanFailedPrivate * priv;
};

struct _NotifyScanFailedClass {
	NotifyClass parent_class;
};

struct _NotifyScanFailedPrivate {
	gint error_code;
	gchar* error_string;
};

struct _NotifyDocumentDone {
	Notify parent_instance;
	NotifyDocumentDonePrivate * priv;
};

struct _NotifyDocumentDoneClass {
	NotifyClass parent_class;
};

struct _NotifyExpectPage {
	Notify parent_instance;
	NotifyExpectPagePrivate * priv;
};

struct _NotifyExpectPageClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfo {
	Notify parent_instance;
	NotifyGotPageInfoPrivate * priv;
};

struct _NotifyGotPageInfoClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfoPrivate {
	ScanPageInfo* info;
};

struct _NotifyPageDone {
	Notify parent_instance;
	NotifyPageDonePrivate * priv;
};

struct _NotifyPageDoneClass {
	NotifyClass parent_class;
};

struct _NotifyGotLine {
	Notify parent_instance;
	NotifyGotLinePrivate * priv;
};

struct _NotifyGotLineClass {
	NotifyClass parent_class;
};

struct _NotifyGotLinePrivate {
	ScanLine* line;
};

struct _Scanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScannerPrivate * priv;
};

struct _ScannerClass {
	GTypeClass parent_class;
	void (*finalize) (Scanner *self);
};

struct _ScannerPrivate {
	GThread* thread;
	GAsyncQueue* request_queue;
	GAsyncQueue* notify_queue;
	GAsyncQueue* authorize_queue;
	gchar* default_device;
	ScanState state;
	gboolean need_redetect;
	GList* job_queue;
	SANE_Handle handle;
	gboolean have_handle;
	gchar* current_device;
	SANE_Parameters parameters;
	SANE_Int option_index;
	SANE_Int br_x_option_index;
	SANE_Int br_y_option_index;
	guchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gint n_used;
	gint line_count;
	gint pass_number;
	gint page_number;
	gint notified_page;
	gboolean scanning;
};

struct _ParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer scan_device_parent_class = NULL;
static gpointer scan_page_info_parent_class = NULL;
static gpointer scan_line_parent_class = NULL;
static gpointer scan_options_parent_class = NULL;
static gpointer scan_job_parent_class = NULL;
static gpointer request_parent_class = NULL;
static gpointer request_redetect_parent_class = NULL;
static gpointer request_cancel_parent_class = NULL;
static gpointer request_start_scan_parent_class = NULL;
static gpointer request_quit_parent_class = NULL;
static gpointer credentials_parent_class = NULL;
static gpointer notify_parent_class = NULL;
static gpointer notify_scanning_changed_parent_class = NULL;
static gpointer notify_update_devices_parent_class = NULL;
static gpointer notify_request_authorization_parent_class = NULL;
static gpointer notify_scan_failed_parent_class = NULL;
static gpointer notify_document_done_parent_class = NULL;
static gpointer notify_expect_page_parent_class = NULL;
static gpointer notify_got_page_info_parent_class = NULL;
static gpointer notify_page_done_parent_class = NULL;
static gpointer notify_got_line_parent_class = NULL;
static gpointer scanner_parent_class = NULL;
static Scanner* scanner_scanner_object;
static Scanner* scanner_scanner_object = NULL;

gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_DEVICE_DUMMY_PROPERTY
};
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void scan_device_finalize (ScanDevice* obj);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_PAGE_INFO_DUMMY_PROPERTY
};
ScanPageInfo* scan_page_info_new (void);
ScanPageInfo* scan_page_info_construct (GType object_type);
static void scan_page_info_finalize (ScanPageInfo* obj);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_LINE_DUMMY_PROPERTY
};
ScanLine* scan_line_new (void);
ScanLine* scan_line_construct (GType object_type);
static void scan_line_finalize (ScanLine* obj);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_OPTIONS_DUMMY_PROPERTY
};
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
static void scan_options_finalize (ScanOptions* obj);
gpointer scan_job_ref (gpointer instance);
void scan_job_unref (gpointer instance);
GParamSpec* param_spec_scan_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_job (GValue* value, gpointer v_object);
void value_take_scan_job (GValue* value, gpointer v_object);
gpointer value_get_scan_job (const GValue* value);
GType scan_job_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_JOB_DUMMY_PROPERTY
};
ScanJob* scan_job_new (void);
ScanJob* scan_job_construct (GType object_type);
static void scan_job_finalize (ScanJob* obj);
gpointer request_ref (gpointer instance);
void request_unref (gpointer instance);
GParamSpec* param_spec_request (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_request (GValue* value, gpointer v_object);
void value_take_request (GValue* value, gpointer v_object);
gpointer value_get_request (const GValue* value);
GType request_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_DUMMY_PROPERTY
};
Request* request_new (void);
Request* request_construct (GType object_type);
static void request_finalize (Request* obj);
GType request_redetect_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_REDETECT_DUMMY_PROPERTY
};
RequestRedetect* request_redetect_new (void);
RequestRedetect* request_redetect_construct (GType object_type);
GType request_cancel_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_CANCEL_DUMMY_PROPERTY
};
RequestCancel* request_cancel_new (void);
RequestCancel* request_cancel_construct (GType object_type);
GType request_start_scan_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_START_SCAN_DUMMY_PROPERTY
};
RequestStartScan* request_start_scan_new (void);
RequestStartScan* request_start_scan_construct (GType object_type);
static void request_start_scan_finalize (Request* obj);
GType request_quit_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_QUIT_DUMMY_PROPERTY
};
RequestQuit* request_quit_new (void);
RequestQuit* request_quit_construct (GType object_type);
gpointer credentials_ref (gpointer instance);
void credentials_unref (gpointer instance);
GParamSpec* param_spec_credentials (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_credentials (GValue* value, gpointer v_object);
void value_take_credentials (GValue* value, gpointer v_object);
gpointer value_get_credentials (const GValue* value);
GType credentials_get_type (void) G_GNUC_CONST;
enum  {
	CREDENTIALS_DUMMY_PROPERTY
};
Credentials* credentials_new (void);
Credentials* credentials_construct (GType object_type);
static void credentials_finalize (Credentials* obj);
GType scan_state_get_type (void) G_GNUC_CONST;
gpointer notify_ref (gpointer instance);
void notify_unref (gpointer instance);
GParamSpec* param_spec_notify (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_notify (GValue* value, gpointer v_object);
void value_take_notify (GValue* value, gpointer v_object);
gpointer value_get_notify (const GValue* value);
GType notify_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scanner (GValue* value, gpointer v_object);
void value_take_scanner (GValue* value, gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_DUMMY_PROPERTY
};
void notify_run (Notify* self, Scanner* scanner);
static void notify_real_run (Notify* self, Scanner* scanner);
Notify* notify_new (void);
Notify* notify_construct (GType object_type);
static void notify_finalize (Notify* obj);
GType notify_scanning_changed_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_SCANNING_CHANGED_DUMMY_PROPERTY
};
static void notify_scanning_changed_real_run (Notify* base, Scanner* scanner);
NotifyScanningChanged* notify_scanning_changed_new (void);
NotifyScanningChanged* notify_scanning_changed_construct (GType object_type);
GType notify_update_devices_get_type (void) G_GNUC_CONST;
#define NOTIFY_UPDATE_DEVICES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesPrivate))
enum  {
	NOTIFY_UPDATE_DEVICES_DUMMY_PROPERTY
};
static void _scan_device_unref0_ (gpointer var);
static void _g_list_free__scan_device_unref0_ (GList* self);
NotifyUpdateDevices* notify_update_devices_new (GList* devices);
NotifyUpdateDevices* notify_update_devices_construct (GType object_type, GList* devices);
static void notify_update_devices_real_run (Notify* base, Scanner* scanner);
static void notify_update_devices_finalize (Notify* obj);
GType notify_request_authorization_get_type (void) G_GNUC_CONST;
#define NOTIFY_REQUEST_AUTHORIZATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationPrivate))
enum  {
	NOTIFY_REQUEST_AUTHORIZATION_DUMMY_PROPERTY
};
NotifyRequestAuthorization* notify_request_authorization_new (const gchar* resource);
NotifyRequestAuthorization* notify_request_authorization_construct (GType object_type, const gchar* resource);
static void notify_request_authorization_real_run (Notify* base, Scanner* scanner);
static void notify_request_authorization_finalize (Notify* obj);
GType notify_scan_failed_get_type (void) G_GNUC_CONST;
#define NOTIFY_SCAN_FAILED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedPrivate))
enum  {
	NOTIFY_SCAN_FAILED_DUMMY_PROPERTY
};
NotifyScanFailed* notify_scan_failed_new (gint error_code, const gchar* error_string);
NotifyScanFailed* notify_scan_failed_construct (GType object_type, gint error_code, const gchar* error_string);
static void notify_scan_failed_real_run (Notify* base, Scanner* scanner);
static void notify_scan_failed_finalize (Notify* obj);
GType notify_document_done_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_DOCUMENT_DONE_DUMMY_PROPERTY
};
static void notify_document_done_real_run (Notify* base, Scanner* scanner);
NotifyDocumentDone* notify_document_done_new (void);
NotifyDocumentDone* notify_document_done_construct (GType object_type);
GType notify_expect_page_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_EXPECT_PAGE_DUMMY_PROPERTY
};
static void notify_expect_page_real_run (Notify* base, Scanner* scanner);
NotifyExpectPage* notify_expect_page_new (void);
NotifyExpectPage* notify_expect_page_construct (GType object_type);
GType notify_got_page_info_get_type (void) G_GNUC_CONST;
#define NOTIFY_GOT_PAGE_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoPrivate))
enum  {
	NOTIFY_GOT_PAGE_INFO_DUMMY_PROPERTY
};
NotifyGotPageInfo* notify_got_page_info_new (ScanPageInfo* info);
NotifyGotPageInfo* notify_got_page_info_construct (GType object_type, ScanPageInfo* info);
static void notify_got_page_info_real_run (Notify* base, Scanner* scanner);
static void notify_got_page_info_finalize (Notify* obj);
GType notify_page_done_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_PAGE_DONE_DUMMY_PROPERTY
};
static void notify_page_done_real_run (Notify* base, Scanner* scanner);
NotifyPageDone* notify_page_done_new (void);
NotifyPageDone* notify_page_done_construct (GType object_type);
GType notify_got_line_get_type (void) G_GNUC_CONST;
#define NOTIFY_GOT_LINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_GOT_LINE, NotifyGotLinePrivate))
enum  {
	NOTIFY_GOT_LINE_DUMMY_PROPERTY
};
NotifyGotLine* notify_got_line_new (ScanLine* line);
NotifyGotLine* notify_got_line_construct (GType object_type, ScanLine* line);
static void notify_got_line_real_run (Notify* base, Scanner* scanner);
static void notify_got_line_finalize (Notify* obj);
#define SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCANNER, ScannerPrivate))
enum  {
	SCANNER_DUMMY_PROPERTY
};
static void _scan_job_unref0_ (gpointer var);
static void _g_list_free__scan_job_unref0_ (GList* self);
static Scanner* scanner_new (void);
static Scanner* scanner_construct (GType object_type);
Scanner* scanner_get_instance (void);
static gboolean scanner_notify_idle_cb (Scanner* self);
static void scanner_notify (Scanner* self, Notify* notification);
static gboolean _scanner_notify_idle_cb_gsource_func (gpointer self);
static void scanner_set_scanning (Scanner* self, gboolean is_scanning);
static gint scanner_get_device_weight (const gchar* device);
static gint scanner_compare_devices (ScanDevice* device1, ScanDevice* device2);
static void scanner_do_redetect (Scanner* self);
static gint _scanner_compare_devices_gcompare_func (gconstpointer a, gconstpointer b);
static gboolean scanner_set_default_option (Scanner* self, SANE_Handle handle, const SANE_Option_Descriptor* option, SANE_Int option_index);
static void scanner_set_bool_option (Scanner* self, SANE_Handle handle, const SANE_Option_Descriptor* option, SANE_Int option_index, gboolean value, gboolean* _result_);
static void scanner_set_int_option (Scanner* self, SANE_Handle handle, const SANE_Option_Descriptor* option, SANE_Int option_index, gint value, gint* _result_);
static void scanner_set_fixed_option (Scanner* self, SANE_Handle handle, const SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_);
static gboolean scanner_set_string_option (Scanner* self, SANE_Handle handle, const SANE_Option_Descriptor* option, SANE_Int option_index, const gchar* value, gchar** _result_);
static gboolean scanner_set_constrained_string_option (Scanner* self, SANE_Handle handle, const SANE_Option_Descriptor* option, SANE_Int option_index, gchar** values, int values_length1, gchar** _result_);
static void scanner_log_option (Scanner* self, SANE_Int index, const SANE_Option_Descriptor* option);
static void scanner_authorization_cb (const gchar* resource, gchar* username, int username_length1, gchar* password, int password_length1);
void scanner_authorize (Scanner* self, const gchar* username, const gchar* password);
static void scanner_close_device (Scanner* self);
static void scanner_fail_scan (Scanner* self, gint error_code, const gchar* error_string);
static gboolean scanner_handle_requests (Scanner* self);
static void scanner_do_open (Scanner* self);
static void scanner_do_get_option (Scanner* self);
static void scanner_do_complete_document (Scanner* self);
static void scanner_do_start (Scanner* self);
static void scanner_do_get_parameters (Scanner* self);
static void scanner_do_complete_page (Scanner* self);
static void scanner_do_read (Scanner* self);
static gboolean scanner_scan_thread (Scanner* self);
static void _scanner_authorization_cb_sane_authcallback (const gchar* resource, gchar* username, gchar* password);
void scanner_redetect (Scanner* self);
void scanner_start (Scanner* self);
static gpointer _scanner_scan_thread_gthread_func (gpointer self);
gboolean scanner_is_scanning (Scanner* self);
static gchar* scanner_get_scan_mode_string (Scanner* self, ScanMode mode);
static gchar* scanner_get_scan_type_string (Scanner* self, ScanType type);
void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options);
void scanner_cancel (Scanner* self);
void scanner_free (Scanner* self);
static void g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__SCAN_LINE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void scanner_finalize (Scanner* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ScanDevice* scan_device_construct (GType object_type) {
	ScanDevice* self = NULL;
	self = (ScanDevice*) g_type_create_instance (object_type);
	return self;
}


ScanDevice* scan_device_new (void) {
	return scan_device_construct (TYPE_SCAN_DEVICE);
}


static void value_scan_device_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_scan_device_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		scan_device_unref (value->data[0].v_pointer);
	}
}


static void value_scan_device_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = scan_device_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_scan_device_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_scan_device_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ScanDevice* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = scan_device_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_scan_device_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanDevice** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = scan_device_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanDevice* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_DEVICE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_scan_device (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE), NULL);
	return value->data[0].v_pointer;
}


void value_set_scan_device (GValue* value, gpointer v_object) {
	ScanDevice* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_DEVICE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		scan_device_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_device_unref (old);
	}
}


void value_take_scan_device (GValue* value, gpointer v_object) {
	ScanDevice* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_DEVICE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_device_unref (old);
	}
}


static void scan_device_class_init (ScanDeviceClass * klass) {
	scan_device_parent_class = g_type_class_peek_parent (klass);
	SCAN_DEVICE_CLASS (klass)->finalize = scan_device_finalize;
}


static void scan_device_instance_init (ScanDevice * self) {
	self->ref_count = 1;
}


static void scan_device_finalize (ScanDevice* obj) {
	ScanDevice * self;
	self = SCAN_DEVICE (obj);
	_g_free0 (self->name);
	_g_free0 (self->label);
}


GType scan_device_get_type (void) {
	static volatile gsize scan_device_type_id__volatile = 0;
	if (g_once_init_enter (&scan_device_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_device_init, value_scan_device_free_value, value_scan_device_copy_value, value_scan_device_peek_pointer, "p", value_scan_device_collect_value, "p", value_scan_device_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanDevice), 0, (GInstanceInitFunc) scan_device_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_device_type_id;
		scan_device_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanDevice", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_device_type_id__volatile, scan_device_type_id);
	}
	return scan_device_type_id__volatile;
}


gpointer scan_device_ref (gpointer instance) {
	ScanDevice* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void scan_device_unref (gpointer instance) {
	ScanDevice* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCAN_DEVICE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


ScanPageInfo* scan_page_info_construct (GType object_type) {
	ScanPageInfo* self = NULL;
	self = (ScanPageInfo*) g_type_create_instance (object_type);
	return self;
}


ScanPageInfo* scan_page_info_new (void) {
	return scan_page_info_construct (TYPE_SCAN_PAGE_INFO);
}


static void value_scan_page_info_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_scan_page_info_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		scan_page_info_unref (value->data[0].v_pointer);
	}
}


static void value_scan_page_info_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = scan_page_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_scan_page_info_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_scan_page_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ScanPageInfo* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = scan_page_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_scan_page_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanPageInfo** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = scan_page_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanPageInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_PAGE_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_scan_page_info (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO), NULL);
	return value->data[0].v_pointer;
}


void value_set_scan_page_info (GValue* value, gpointer v_object) {
	ScanPageInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_PAGE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		scan_page_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_page_info_unref (old);
	}
}


void value_take_scan_page_info (GValue* value, gpointer v_object) {
	ScanPageInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_PAGE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_page_info_unref (old);
	}
}


static void scan_page_info_class_init (ScanPageInfoClass * klass) {
	scan_page_info_parent_class = g_type_class_peek_parent (klass);
	SCAN_PAGE_INFO_CLASS (klass)->finalize = scan_page_info_finalize;
}


static void scan_page_info_instance_init (ScanPageInfo * self) {
	self->ref_count = 1;
}


static void scan_page_info_finalize (ScanPageInfo* obj) {
	ScanPageInfo * self;
	self = SCAN_PAGE_INFO (obj);
	_g_free0 (self->device);
}


GType scan_page_info_get_type (void) {
	static volatile gsize scan_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&scan_page_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_page_info_init, value_scan_page_info_free_value, value_scan_page_info_copy_value, value_scan_page_info_peek_pointer, "p", value_scan_page_info_collect_value, "p", value_scan_page_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanPageInfo), 0, (GInstanceInitFunc) scan_page_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_page_info_type_id;
		scan_page_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanPageInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_page_info_type_id__volatile, scan_page_info_type_id);
	}
	return scan_page_info_type_id__volatile;
}


gpointer scan_page_info_ref (gpointer instance) {
	ScanPageInfo* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void scan_page_info_unref (gpointer instance) {
	ScanPageInfo* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCAN_PAGE_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


ScanLine* scan_line_construct (GType object_type) {
	ScanLine* self = NULL;
	self = (ScanLine*) g_type_create_instance (object_type);
	return self;
}


ScanLine* scan_line_new (void) {
	return scan_line_construct (TYPE_SCAN_LINE);
}


static void value_scan_line_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_scan_line_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		scan_line_unref (value->data[0].v_pointer);
	}
}


static void value_scan_line_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = scan_line_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_scan_line_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_scan_line_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ScanLine* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = scan_line_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_scan_line_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanLine** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = scan_line_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanLine* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_LINE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_scan_line (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE), NULL);
	return value->data[0].v_pointer;
}


void value_set_scan_line (GValue* value, gpointer v_object) {
	ScanLine* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_LINE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		scan_line_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_line_unref (old);
	}
}


void value_take_scan_line (GValue* value, gpointer v_object) {
	ScanLine* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_LINE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_line_unref (old);
	}
}


static void scan_line_class_init (ScanLineClass * klass) {
	scan_line_parent_class = g_type_class_peek_parent (klass);
	SCAN_LINE_CLASS (klass)->finalize = scan_line_finalize;
}


static void scan_line_instance_init (ScanLine * self) {
	self->ref_count = 1;
}


static void scan_line_finalize (ScanLine* obj) {
	ScanLine * self;
	self = SCAN_LINE (obj);
	self->data = (g_free (self->data), NULL);
}


GType scan_line_get_type (void) {
	static volatile gsize scan_line_type_id__volatile = 0;
	if (g_once_init_enter (&scan_line_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_line_init, value_scan_line_free_value, value_scan_line_copy_value, value_scan_line_peek_pointer, "p", value_scan_line_collect_value, "p", value_scan_line_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanLine), 0, (GInstanceInitFunc) scan_line_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_line_type_id;
		scan_line_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanLine", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_line_type_id__volatile, scan_line_type_id);
	}
	return scan_line_type_id__volatile;
}


gpointer scan_line_ref (gpointer instance) {
	ScanLine* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void scan_line_unref (gpointer instance) {
	ScanLine* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCAN_LINE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType scan_mode_get_type (void) {
	static volatile gsize scan_mode_type_id__volatile = 0;
	if (g_once_init_enter (&scan_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_MODE_DEFAULT, "SCAN_MODE_DEFAULT", "default"}, {SCAN_MODE_COLOR, "SCAN_MODE_COLOR", "color"}, {SCAN_MODE_GRAY, "SCAN_MODE_GRAY", "gray"}, {SCAN_MODE_LINEART, "SCAN_MODE_LINEART", "lineart"}, {0, NULL, NULL}};
		GType scan_mode_type_id;
		scan_mode_type_id = g_enum_register_static ("ScanMode", values);
		g_once_init_leave (&scan_mode_type_id__volatile, scan_mode_type_id);
	}
	return scan_mode_type_id__volatile;
}


GType scan_type_get_type (void) {
	static volatile gsize scan_type_type_id__volatile = 0;
	if (g_once_init_enter (&scan_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_TYPE_SINGLE, "SCAN_TYPE_SINGLE", "single"}, {SCAN_TYPE_ADF_FRONT, "SCAN_TYPE_ADF_FRONT", "adf-front"}, {SCAN_TYPE_ADF_BACK, "SCAN_TYPE_ADF_BACK", "adf-back"}, {SCAN_TYPE_ADF_BOTH, "SCAN_TYPE_ADF_BOTH", "adf-both"}, {0, NULL, NULL}};
		GType scan_type_type_id;
		scan_type_type_id = g_enum_register_static ("ScanType", values);
		g_once_init_leave (&scan_type_type_id__volatile, scan_type_type_id);
	}
	return scan_type_type_id__volatile;
}


ScanOptions* scan_options_construct (GType object_type) {
	ScanOptions* self = NULL;
	self = (ScanOptions*) g_type_create_instance (object_type);
	return self;
}


ScanOptions* scan_options_new (void) {
	return scan_options_construct (TYPE_SCAN_OPTIONS);
}


static void value_scan_options_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_scan_options_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		scan_options_unref (value->data[0].v_pointer);
	}
}


static void value_scan_options_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = scan_options_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_scan_options_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_scan_options_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ScanOptions* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = scan_options_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_scan_options_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanOptions** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = scan_options_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanOptions* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_OPTIONS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_scan_options (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS), NULL);
	return value->data[0].v_pointer;
}


void value_set_scan_options (GValue* value, gpointer v_object) {
	ScanOptions* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_OPTIONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		scan_options_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_options_unref (old);
	}
}


void value_take_scan_options (GValue* value, gpointer v_object) {
	ScanOptions* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_OPTIONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_options_unref (old);
	}
}


static void scan_options_class_init (ScanOptionsClass * klass) {
	scan_options_parent_class = g_type_class_peek_parent (klass);
	SCAN_OPTIONS_CLASS (klass)->finalize = scan_options_finalize;
}


static void scan_options_instance_init (ScanOptions * self) {
	self->ref_count = 1;
}


static void scan_options_finalize (ScanOptions* obj) {
	ScanOptions * self;
	self = SCAN_OPTIONS (obj);
}


GType scan_options_get_type (void) {
	static volatile gsize scan_options_type_id__volatile = 0;
	if (g_once_init_enter (&scan_options_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_options_init, value_scan_options_free_value, value_scan_options_copy_value, value_scan_options_peek_pointer, "p", value_scan_options_collect_value, "p", value_scan_options_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanOptionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_options_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanOptions), 0, (GInstanceInitFunc) scan_options_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_options_type_id;
		scan_options_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanOptions", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_options_type_id__volatile, scan_options_type_id);
	}
	return scan_options_type_id__volatile;
}


gpointer scan_options_ref (gpointer instance) {
	ScanOptions* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void scan_options_unref (gpointer instance) {
	ScanOptions* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCAN_OPTIONS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


ScanJob* scan_job_construct (GType object_type) {
	ScanJob* self = NULL;
	self = (ScanJob*) g_type_create_instance (object_type);
	return self;
}


ScanJob* scan_job_new (void) {
	return scan_job_construct (TYPE_SCAN_JOB);
}


static void value_scan_job_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_scan_job_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		scan_job_unref (value->data[0].v_pointer);
	}
}


static void value_scan_job_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = scan_job_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_scan_job_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_scan_job_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ScanJob* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = scan_job_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_scan_job_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanJob** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = scan_job_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_scan_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanJob* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_JOB), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_scan_job (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB), NULL);
	return value->data[0].v_pointer;
}


void value_set_scan_job (GValue* value, gpointer v_object) {
	ScanJob* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_JOB));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		scan_job_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_job_unref (old);
	}
}


void value_take_scan_job (GValue* value, gpointer v_object) {
	ScanJob* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_JOB));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_job_unref (old);
	}
}


static void scan_job_class_init (ScanJobClass * klass) {
	scan_job_parent_class = g_type_class_peek_parent (klass);
	SCAN_JOB_CLASS (klass)->finalize = scan_job_finalize;
}


static void scan_job_instance_init (ScanJob * self) {
	self->ref_count = 1;
}


static void scan_job_finalize (ScanJob* obj) {
	ScanJob * self;
	self = SCAN_JOB (obj);
	_g_free0 (self->device);
}


GType scan_job_get_type (void) {
	static volatile gsize scan_job_type_id__volatile = 0;
	if (g_once_init_enter (&scan_job_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_job_init, value_scan_job_free_value, value_scan_job_copy_value, value_scan_job_peek_pointer, "p", value_scan_job_collect_value, "p", value_scan_job_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanJob), 0, (GInstanceInitFunc) scan_job_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_job_type_id;
		scan_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanJob", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_job_type_id__volatile, scan_job_type_id);
	}
	return scan_job_type_id__volatile;
}


gpointer scan_job_ref (gpointer instance) {
	ScanJob* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void scan_job_unref (gpointer instance) {
	ScanJob* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCAN_JOB_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


Request* request_construct (GType object_type) {
	Request* self = NULL;
	self = (Request*) g_type_create_instance (object_type);
	return self;
}


Request* request_new (void) {
	return request_construct (TYPE_REQUEST);
}


static void value_request_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_request_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		request_unref (value->data[0].v_pointer);
	}
}


static void value_request_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = request_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_request_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_request_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Request* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = request_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_request_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Request** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = request_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_request (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecRequest* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_REQUEST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_request (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST), NULL);
	return value->data[0].v_pointer;
}


void value_set_request (GValue* value, gpointer v_object) {
	Request* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		request_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		request_unref (old);
	}
}


void value_take_request (GValue* value, gpointer v_object) {
	Request* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		request_unref (old);
	}
}


static void request_class_init (RequestClass * klass) {
	request_parent_class = g_type_class_peek_parent (klass);
	REQUEST_CLASS (klass)->finalize = request_finalize;
}


static void request_instance_init (Request * self) {
	self->ref_count = 1;
}


static void request_finalize (Request* obj) {
	Request * self;
	self = REQUEST (obj);
}


GType request_get_type (void) {
	static volatile gsize request_type_id__volatile = 0;
	if (g_once_init_enter (&request_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_request_init, value_request_free_value, value_request_copy_value, value_request_peek_pointer, "p", value_request_collect_value, "p", value_request_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Request), 0, (GInstanceInitFunc) request_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType request_type_id;
		request_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Request", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&request_type_id__volatile, request_type_id);
	}
	return request_type_id__volatile;
}


gpointer request_ref (gpointer instance) {
	Request* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void request_unref (gpointer instance) {
	Request* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		REQUEST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


RequestRedetect* request_redetect_construct (GType object_type) {
	RequestRedetect* self = NULL;
	self = (RequestRedetect*) request_construct (object_type);
	return self;
}


RequestRedetect* request_redetect_new (void) {
	return request_redetect_construct (TYPE_REQUEST_REDETECT);
}


static void request_redetect_class_init (RequestRedetectClass * klass) {
	request_redetect_parent_class = g_type_class_peek_parent (klass);
}


static void request_redetect_instance_init (RequestRedetect * self) {
}


GType request_redetect_get_type (void) {
	static volatile gsize request_redetect_type_id__volatile = 0;
	if (g_once_init_enter (&request_redetect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestRedetectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_redetect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestRedetect), 0, (GInstanceInitFunc) request_redetect_instance_init, NULL };
		GType request_redetect_type_id;
		request_redetect_type_id = g_type_register_static (TYPE_REQUEST, "RequestRedetect", &g_define_type_info, 0);
		g_once_init_leave (&request_redetect_type_id__volatile, request_redetect_type_id);
	}
	return request_redetect_type_id__volatile;
}


RequestCancel* request_cancel_construct (GType object_type) {
	RequestCancel* self = NULL;
	self = (RequestCancel*) request_construct (object_type);
	return self;
}


RequestCancel* request_cancel_new (void) {
	return request_cancel_construct (TYPE_REQUEST_CANCEL);
}


static void request_cancel_class_init (RequestCancelClass * klass) {
	request_cancel_parent_class = g_type_class_peek_parent (klass);
}


static void request_cancel_instance_init (RequestCancel * self) {
}


GType request_cancel_get_type (void) {
	static volatile gsize request_cancel_type_id__volatile = 0;
	if (g_once_init_enter (&request_cancel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestCancelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_cancel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestCancel), 0, (GInstanceInitFunc) request_cancel_instance_init, NULL };
		GType request_cancel_type_id;
		request_cancel_type_id = g_type_register_static (TYPE_REQUEST, "RequestCancel", &g_define_type_info, 0);
		g_once_init_leave (&request_cancel_type_id__volatile, request_cancel_type_id);
	}
	return request_cancel_type_id__volatile;
}


RequestStartScan* request_start_scan_construct (GType object_type) {
	RequestStartScan* self = NULL;
	self = (RequestStartScan*) request_construct (object_type);
	return self;
}


RequestStartScan* request_start_scan_new (void) {
	return request_start_scan_construct (TYPE_REQUEST_START_SCAN);
}


static void request_start_scan_class_init (RequestStartScanClass * klass) {
	request_start_scan_parent_class = g_type_class_peek_parent (klass);
	REQUEST_CLASS (klass)->finalize = request_start_scan_finalize;
}


static void request_start_scan_instance_init (RequestStartScan * self) {
}


static void request_start_scan_finalize (Request* obj) {
	RequestStartScan * self;
	self = REQUEST_START_SCAN (obj);
	_scan_job_unref0 (self->job);
	REQUEST_CLASS (request_start_scan_parent_class)->finalize (obj);
}


GType request_start_scan_get_type (void) {
	static volatile gsize request_start_scan_type_id__volatile = 0;
	if (g_once_init_enter (&request_start_scan_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestStartScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_start_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestStartScan), 0, (GInstanceInitFunc) request_start_scan_instance_init, NULL };
		GType request_start_scan_type_id;
		request_start_scan_type_id = g_type_register_static (TYPE_REQUEST, "RequestStartScan", &g_define_type_info, 0);
		g_once_init_leave (&request_start_scan_type_id__volatile, request_start_scan_type_id);
	}
	return request_start_scan_type_id__volatile;
}


RequestQuit* request_quit_construct (GType object_type) {
	RequestQuit* self = NULL;
	self = (RequestQuit*) request_construct (object_type);
	return self;
}


RequestQuit* request_quit_new (void) {
	return request_quit_construct (TYPE_REQUEST_QUIT);
}


static void request_quit_class_init (RequestQuitClass * klass) {
	request_quit_parent_class = g_type_class_peek_parent (klass);
}


static void request_quit_instance_init (RequestQuit * self) {
}


GType request_quit_get_type (void) {
	static volatile gsize request_quit_type_id__volatile = 0;
	if (g_once_init_enter (&request_quit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestQuitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_quit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestQuit), 0, (GInstanceInitFunc) request_quit_instance_init, NULL };
		GType request_quit_type_id;
		request_quit_type_id = g_type_register_static (TYPE_REQUEST, "RequestQuit", &g_define_type_info, 0);
		g_once_init_leave (&request_quit_type_id__volatile, request_quit_type_id);
	}
	return request_quit_type_id__volatile;
}


Credentials* credentials_construct (GType object_type) {
	Credentials* self = NULL;
	self = (Credentials*) g_type_create_instance (object_type);
	return self;
}


Credentials* credentials_new (void) {
	return credentials_construct (TYPE_CREDENTIALS);
}


static void value_credentials_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_credentials_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		credentials_unref (value->data[0].v_pointer);
	}
}


static void value_credentials_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = credentials_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_credentials_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_credentials_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Credentials* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = credentials_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_credentials_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Credentials** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = credentials_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_credentials (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecCredentials* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CREDENTIALS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_credentials (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS), NULL);
	return value->data[0].v_pointer;
}


void value_set_credentials (GValue* value, gpointer v_object) {
	Credentials* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		credentials_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		credentials_unref (old);
	}
}


void value_take_credentials (GValue* value, gpointer v_object) {
	Credentials* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		credentials_unref (old);
	}
}


static void credentials_class_init (CredentialsClass * klass) {
	credentials_parent_class = g_type_class_peek_parent (klass);
	CREDENTIALS_CLASS (klass)->finalize = credentials_finalize;
}


static void credentials_instance_init (Credentials * self) {
	self->ref_count = 1;
}


static void credentials_finalize (Credentials* obj) {
	Credentials * self;
	self = CREDENTIALS (obj);
	_g_free0 (self->username);
	_g_free0 (self->password);
}


GType credentials_get_type (void) {
	static volatile gsize credentials_type_id__volatile = 0;
	if (g_once_init_enter (&credentials_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_credentials_init, value_credentials_free_value, value_credentials_copy_value, value_credentials_peek_pointer, "p", value_credentials_collect_value, "p", value_credentials_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CredentialsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) credentials_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Credentials), 0, (GInstanceInitFunc) credentials_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType credentials_type_id;
		credentials_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Credentials", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&credentials_type_id__volatile, credentials_type_id);
	}
	return credentials_type_id__volatile;
}


gpointer credentials_ref (gpointer instance) {
	Credentials* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void credentials_unref (gpointer instance) {
	Credentials* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CREDENTIALS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType scan_state_get_type (void) {
	static volatile gsize scan_state_type_id__volatile = 0;
	if (g_once_init_enter (&scan_state_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_STATE_IDLE, "SCAN_STATE_IDLE", "idle"}, {SCAN_STATE_REDETECT, "SCAN_STATE_REDETECT", "redetect"}, {SCAN_STATE_OPEN, "SCAN_STATE_OPEN", "open"}, {SCAN_STATE_GET_OPTION, "SCAN_STATE_GET_OPTION", "get-option"}, {SCAN_STATE_START, "SCAN_STATE_START", "start"}, {SCAN_STATE_GET_PARAMETERS, "SCAN_STATE_GET_PARAMETERS", "get-parameters"}, {SCAN_STATE_READ, "SCAN_STATE_READ", "read"}, {0, NULL, NULL}};
		GType scan_state_type_id;
		scan_state_type_id = g_enum_register_static ("ScanState", values);
		g_once_init_leave (&scan_state_type_id__volatile, scan_state_type_id);
	}
	return scan_state_type_id__volatile;
}


static void notify_real_run (Notify* self, Scanner* scanner) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
}


void notify_run (Notify* self, Scanner* scanner) {
	NOTIFY_GET_CLASS (self)->run (self, scanner);
}


Notify* notify_construct (GType object_type) {
	Notify* self = NULL;
	self = (Notify*) g_type_create_instance (object_type);
	return self;
}


Notify* notify_new (void) {
	return notify_construct (TYPE_NOTIFY);
}


static void value_notify_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_notify_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		notify_unref (value->data[0].v_pointer);
	}
}


static void value_notify_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = notify_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_notify_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_notify_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Notify* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = notify_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_notify_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Notify** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = notify_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_notify (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecNotify* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NOTIFY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_notify (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY), NULL);
	return value->data[0].v_pointer;
}


void value_set_notify (GValue* value, gpointer v_object) {
	Notify* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		notify_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		notify_unref (old);
	}
}


void value_take_notify (GValue* value, gpointer v_object) {
	Notify* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		notify_unref (old);
	}
}


static void notify_class_init (NotifyClass * klass) {
	notify_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->finalize = notify_finalize;
	NOTIFY_CLASS (klass)->run = notify_real_run;
}


static void notify_instance_init (Notify * self) {
	self->ref_count = 1;
}


static void notify_finalize (Notify* obj) {
	Notify * self;
	self = NOTIFY (obj);
}


GType notify_get_type (void) {
	static volatile gsize notify_type_id__volatile = 0;
	if (g_once_init_enter (&notify_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_notify_init, value_notify_free_value, value_notify_copy_value, value_notify_peek_pointer, "p", value_notify_collect_value, "p", value_notify_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (NotifyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Notify), 0, (GInstanceInitFunc) notify_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType notify_type_id;
		notify_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Notify", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&notify_type_id__volatile, notify_type_id);
	}
	return notify_type_id__volatile;
}


gpointer notify_ref (gpointer instance) {
	Notify* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void notify_unref (gpointer instance) {
	Notify* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NOTIFY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void notify_scanning_changed_real_run (Notify* base, Scanner* scanner) {
	NotifyScanningChanged * self;
	self = (NotifyScanningChanged*) base;
	g_return_if_fail (scanner != NULL);
	g_signal_emit_by_name (scanner, "scanning-changed");
}


NotifyScanningChanged* notify_scanning_changed_construct (GType object_type) {
	NotifyScanningChanged* self = NULL;
	self = (NotifyScanningChanged*) notify_construct (object_type);
	return self;
}


NotifyScanningChanged* notify_scanning_changed_new (void) {
	return notify_scanning_changed_construct (TYPE_NOTIFY_SCANNING_CHANGED);
}


static void notify_scanning_changed_class_init (NotifyScanningChangedClass * klass) {
	notify_scanning_changed_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->run = notify_scanning_changed_real_run;
}


static void notify_scanning_changed_instance_init (NotifyScanningChanged * self) {
}


GType notify_scanning_changed_get_type (void) {
	static volatile gsize notify_scanning_changed_type_id__volatile = 0;
	if (g_once_init_enter (&notify_scanning_changed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyScanningChangedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scanning_changed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanningChanged), 0, (GInstanceInitFunc) notify_scanning_changed_instance_init, NULL };
		GType notify_scanning_changed_type_id;
		notify_scanning_changed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanningChanged", &g_define_type_info, 0);
		g_once_init_leave (&notify_scanning_changed_type_id__volatile, notify_scanning_changed_type_id);
	}
	return notify_scanning_changed_type_id__volatile;
}


static void _scan_device_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
}


static void _g_list_free__scan_device_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _scan_device_unref0_, NULL);
	g_list_free (self);
}


NotifyUpdateDevices* notify_update_devices_construct (GType object_type, GList* devices) {
	NotifyUpdateDevices* self = NULL;
	GList* _tmp0_;
	self = (NotifyUpdateDevices*) notify_construct (object_type);
	_tmp0_ = devices;
	devices = NULL;
	__g_list_free__scan_device_unref0_0 (self->priv->devices);
	self->priv->devices = _tmp0_;
	__g_list_free__scan_device_unref0_0 (devices);
	return self;
}


NotifyUpdateDevices* notify_update_devices_new (GList* devices) {
	return notify_update_devices_construct (TYPE_NOTIFY_UPDATE_DEVICES, devices);
}


static void notify_update_devices_real_run (Notify* base, Scanner* scanner) {
	NotifyUpdateDevices * self;
	self = (NotifyUpdateDevices*) base;
	g_return_if_fail (scanner != NULL);
	g_signal_emit_by_name (scanner, "update-devices", self->priv->devices);
}


static void notify_update_devices_class_init (NotifyUpdateDevicesClass * klass) {
	notify_update_devices_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->finalize = notify_update_devices_finalize;
	g_type_class_add_private (klass, sizeof (NotifyUpdateDevicesPrivate));
	NOTIFY_CLASS (klass)->run = notify_update_devices_real_run;
}


static void notify_update_devices_instance_init (NotifyUpdateDevices * self) {
	self->priv = NOTIFY_UPDATE_DEVICES_GET_PRIVATE (self);
}


static void notify_update_devices_finalize (Notify* obj) {
	NotifyUpdateDevices * self;
	self = NOTIFY_UPDATE_DEVICES (obj);
	__g_list_free__scan_device_unref0_0 (self->priv->devices);
	NOTIFY_CLASS (notify_update_devices_parent_class)->finalize (obj);
}


GType notify_update_devices_get_type (void) {
	static volatile gsize notify_update_devices_type_id__volatile = 0;
	if (g_once_init_enter (&notify_update_devices_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyUpdateDevicesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_update_devices_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyUpdateDevices), 0, (GInstanceInitFunc) notify_update_devices_instance_init, NULL };
		GType notify_update_devices_type_id;
		notify_update_devices_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyUpdateDevices", &g_define_type_info, 0);
		g_once_init_leave (&notify_update_devices_type_id__volatile, notify_update_devices_type_id);
	}
	return notify_update_devices_type_id__volatile;
}


NotifyRequestAuthorization* notify_request_authorization_construct (GType object_type, const gchar* resource) {
	NotifyRequestAuthorization* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (resource != NULL, NULL);
	self = (NotifyRequestAuthorization*) notify_construct (object_type);
	_tmp0_ = g_strdup (resource);
	_g_free0 (self->priv->resource);
	self->priv->resource = _tmp0_;
	return self;
}


NotifyRequestAuthorization* notify_request_authorization_new (const gchar* resource) {
	return notify_request_authorization_construct (TYPE_NOTIFY_REQUEST_AUTHORIZATION, resource);
}


static void notify_request_authorization_real_run (Notify* base, Scanner* scanner) {
	NotifyRequestAuthorization * self;
	self = (NotifyRequestAuthorization*) base;
	g_return_if_fail (scanner != NULL);
	g_signal_emit_by_name (scanner, "request-authorization", self->priv->resource);
}


static void notify_request_authorization_class_init (NotifyRequestAuthorizationClass * klass) {
	notify_request_authorization_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->finalize = notify_request_authorization_finalize;
	g_type_class_add_private (klass, sizeof (NotifyRequestAuthorizationPrivate));
	NOTIFY_CLASS (klass)->run = notify_request_authorization_real_run;
}


static void notify_request_authorization_instance_init (NotifyRequestAuthorization * self) {
	self->priv = NOTIFY_REQUEST_AUTHORIZATION_GET_PRIVATE (self);
}


static void notify_request_authorization_finalize (Notify* obj) {
	NotifyRequestAuthorization * self;
	self = NOTIFY_REQUEST_AUTHORIZATION (obj);
	_g_free0 (self->priv->resource);
	NOTIFY_CLASS (notify_request_authorization_parent_class)->finalize (obj);
}


GType notify_request_authorization_get_type (void) {
	static volatile gsize notify_request_authorization_type_id__volatile = 0;
	if (g_once_init_enter (&notify_request_authorization_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyRequestAuthorizationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_request_authorization_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyRequestAuthorization), 0, (GInstanceInitFunc) notify_request_authorization_instance_init, NULL };
		GType notify_request_authorization_type_id;
		notify_request_authorization_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyRequestAuthorization", &g_define_type_info, 0);
		g_once_init_leave (&notify_request_authorization_type_id__volatile, notify_request_authorization_type_id);
	}
	return notify_request_authorization_type_id__volatile;
}


NotifyScanFailed* notify_scan_failed_construct (GType object_type, gint error_code, const gchar* error_string) {
	NotifyScanFailed* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (error_string != NULL, NULL);
	self = (NotifyScanFailed*) notify_construct (object_type);
	self->priv->error_code = error_code;
	_tmp0_ = g_strdup (error_string);
	_g_free0 (self->priv->error_string);
	self->priv->error_string = _tmp0_;
	return self;
}


NotifyScanFailed* notify_scan_failed_new (gint error_code, const gchar* error_string) {
	return notify_scan_failed_construct (TYPE_NOTIFY_SCAN_FAILED, error_code, error_string);
}


static void notify_scan_failed_real_run (Notify* base, Scanner* scanner) {
	NotifyScanFailed * self;
	self = (NotifyScanFailed*) base;
	g_return_if_fail (scanner != NULL);
	g_signal_emit_by_name (scanner, "scan-failed", self->priv->error_code, self->priv->error_string);
}


static void notify_scan_failed_class_init (NotifyScanFailedClass * klass) {
	notify_scan_failed_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->finalize = notify_scan_failed_finalize;
	g_type_class_add_private (klass, sizeof (NotifyScanFailedPrivate));
	NOTIFY_CLASS (klass)->run = notify_scan_failed_real_run;
}


static void notify_scan_failed_instance_init (NotifyScanFailed * self) {
	self->priv = NOTIFY_SCAN_FAILED_GET_PRIVATE (self);
}


static void notify_scan_failed_finalize (Notify* obj) {
	NotifyScanFailed * self;
	self = NOTIFY_SCAN_FAILED (obj);
	_g_free0 (self->priv->error_string);
	NOTIFY_CLASS (notify_scan_failed_parent_class)->finalize (obj);
}


GType notify_scan_failed_get_type (void) {
	static volatile gsize notify_scan_failed_type_id__volatile = 0;
	if (g_once_init_enter (&notify_scan_failed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyScanFailedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scan_failed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanFailed), 0, (GInstanceInitFunc) notify_scan_failed_instance_init, NULL };
		GType notify_scan_failed_type_id;
		notify_scan_failed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanFailed", &g_define_type_info, 0);
		g_once_init_leave (&notify_scan_failed_type_id__volatile, notify_scan_failed_type_id);
	}
	return notify_scan_failed_type_id__volatile;
}


static void notify_document_done_real_run (Notify* base, Scanner* scanner) {
	NotifyDocumentDone * self;
	self = (NotifyDocumentDone*) base;
	g_return_if_fail (scanner != NULL);
	g_signal_emit_by_name (scanner, "document-done");
}


NotifyDocumentDone* notify_document_done_construct (GType object_type) {
	NotifyDocumentDone* self = NULL;
	self = (NotifyDocumentDone*) notify_construct (object_type);
	return self;
}


NotifyDocumentDone* notify_document_done_new (void) {
	return notify_document_done_construct (TYPE_NOTIFY_DOCUMENT_DONE);
}


static void notify_document_done_class_init (NotifyDocumentDoneClass * klass) {
	notify_document_done_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->run = notify_document_done_real_run;
}


static void notify_document_done_instance_init (NotifyDocumentDone * self) {
}


GType notify_document_done_get_type (void) {
	static volatile gsize notify_document_done_type_id__volatile = 0;
	if (g_once_init_enter (&notify_document_done_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyDocumentDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_document_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyDocumentDone), 0, (GInstanceInitFunc) notify_document_done_instance_init, NULL };
		GType notify_document_done_type_id;
		notify_document_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyDocumentDone", &g_define_type_info, 0);
		g_once_init_leave (&notify_document_done_type_id__volatile, notify_document_done_type_id);
	}
	return notify_document_done_type_id__volatile;
}


static void notify_expect_page_real_run (Notify* base, Scanner* scanner) {
	NotifyExpectPage * self;
	self = (NotifyExpectPage*) base;
	g_return_if_fail (scanner != NULL);
	g_signal_emit_by_name (scanner, "expect-page");
}


NotifyExpectPage* notify_expect_page_construct (GType object_type) {
	NotifyExpectPage* self = NULL;
	self = (NotifyExpectPage*) notify_construct (object_type);
	return self;
}


NotifyExpectPage* notify_expect_page_new (void) {
	return notify_expect_page_construct (TYPE_NOTIFY_EXPECT_PAGE);
}


static void notify_expect_page_class_init (NotifyExpectPageClass * klass) {
	notify_expect_page_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->run = notify_expect_page_real_run;
}


static void notify_expect_page_instance_init (NotifyExpectPage * self) {
}


GType notify_expect_page_get_type (void) {
	static volatile gsize notify_expect_page_type_id__volatile = 0;
	if (g_once_init_enter (&notify_expect_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyExpectPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_expect_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyExpectPage), 0, (GInstanceInitFunc) notify_expect_page_instance_init, NULL };
		GType notify_expect_page_type_id;
		notify_expect_page_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyExpectPage", &g_define_type_info, 0);
		g_once_init_leave (&notify_expect_page_type_id__volatile, notify_expect_page_type_id);
	}
	return notify_expect_page_type_id__volatile;
}


static gpointer _scan_page_info_ref0 (gpointer self) {
	return self ? scan_page_info_ref (self) : NULL;
}


NotifyGotPageInfo* notify_got_page_info_construct (GType object_type, ScanPageInfo* info) {
	NotifyGotPageInfo* self = NULL;
	ScanPageInfo* _tmp0_;
	g_return_val_if_fail (info != NULL, NULL);
	self = (NotifyGotPageInfo*) notify_construct (object_type);
	_tmp0_ = _scan_page_info_ref0 (info);
	_scan_page_info_unref0 (self->priv->info);
	self->priv->info = _tmp0_;
	return self;
}


NotifyGotPageInfo* notify_got_page_info_new (ScanPageInfo* info) {
	return notify_got_page_info_construct (TYPE_NOTIFY_GOT_PAGE_INFO, info);
}


static void notify_got_page_info_real_run (Notify* base, Scanner* scanner) {
	NotifyGotPageInfo * self;
	self = (NotifyGotPageInfo*) base;
	g_return_if_fail (scanner != NULL);
	g_signal_emit_by_name (scanner, "got-page-info", self->priv->info);
}


static void notify_got_page_info_class_init (NotifyGotPageInfoClass * klass) {
	notify_got_page_info_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->finalize = notify_got_page_info_finalize;
	g_type_class_add_private (klass, sizeof (NotifyGotPageInfoPrivate));
	NOTIFY_CLASS (klass)->run = notify_got_page_info_real_run;
}


static void notify_got_page_info_instance_init (NotifyGotPageInfo * self) {
	self->priv = NOTIFY_GOT_PAGE_INFO_GET_PRIVATE (self);
}


static void notify_got_page_info_finalize (Notify* obj) {
	NotifyGotPageInfo * self;
	self = NOTIFY_GOT_PAGE_INFO (obj);
	_scan_page_info_unref0 (self->priv->info);
	NOTIFY_CLASS (notify_got_page_info_parent_class)->finalize (obj);
}


GType notify_got_page_info_get_type (void) {
	static volatile gsize notify_got_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&notify_got_page_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyGotPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotPageInfo), 0, (GInstanceInitFunc) notify_got_page_info_instance_init, NULL };
		GType notify_got_page_info_type_id;
		notify_got_page_info_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotPageInfo", &g_define_type_info, 0);
		g_once_init_leave (&notify_got_page_info_type_id__volatile, notify_got_page_info_type_id);
	}
	return notify_got_page_info_type_id__volatile;
}


static void notify_page_done_real_run (Notify* base, Scanner* scanner) {
	NotifyPageDone * self;
	self = (NotifyPageDone*) base;
	g_return_if_fail (scanner != NULL);
	g_signal_emit_by_name (scanner, "page-done");
}


NotifyPageDone* notify_page_done_construct (GType object_type) {
	NotifyPageDone* self = NULL;
	self = (NotifyPageDone*) notify_construct (object_type);
	return self;
}


NotifyPageDone* notify_page_done_new (void) {
	return notify_page_done_construct (TYPE_NOTIFY_PAGE_DONE);
}


static void notify_page_done_class_init (NotifyPageDoneClass * klass) {
	notify_page_done_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->run = notify_page_done_real_run;
}


static void notify_page_done_instance_init (NotifyPageDone * self) {
}


GType notify_page_done_get_type (void) {
	static volatile gsize notify_page_done_type_id__volatile = 0;
	if (g_once_init_enter (&notify_page_done_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyPageDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_page_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyPageDone), 0, (GInstanceInitFunc) notify_page_done_instance_init, NULL };
		GType notify_page_done_type_id;
		notify_page_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyPageDone", &g_define_type_info, 0);
		g_once_init_leave (&notify_page_done_type_id__volatile, notify_page_done_type_id);
	}
	return notify_page_done_type_id__volatile;
}


static gpointer _scan_line_ref0 (gpointer self) {
	return self ? scan_line_ref (self) : NULL;
}


NotifyGotLine* notify_got_line_construct (GType object_type, ScanLine* line) {
	NotifyGotLine* self = NULL;
	ScanLine* _tmp0_;
	g_return_val_if_fail (line != NULL, NULL);
	self = (NotifyGotLine*) notify_construct (object_type);
	_tmp0_ = _scan_line_ref0 (line);
	_scan_line_unref0 (self->priv->line);
	self->priv->line = _tmp0_;
	return self;
}


NotifyGotLine* notify_got_line_new (ScanLine* line) {
	return notify_got_line_construct (TYPE_NOTIFY_GOT_LINE, line);
}


static void notify_got_line_real_run (Notify* base, Scanner* scanner) {
	NotifyGotLine * self;
	self = (NotifyGotLine*) base;
	g_return_if_fail (scanner != NULL);
	g_signal_emit_by_name (scanner, "got-line", self->priv->line);
}


static void notify_got_line_class_init (NotifyGotLineClass * klass) {
	notify_got_line_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->finalize = notify_got_line_finalize;
	g_type_class_add_private (klass, sizeof (NotifyGotLinePrivate));
	NOTIFY_CLASS (klass)->run = notify_got_line_real_run;
}


static void notify_got_line_instance_init (NotifyGotLine * self) {
	self->priv = NOTIFY_GOT_LINE_GET_PRIVATE (self);
}


static void notify_got_line_finalize (Notify* obj) {
	NotifyGotLine * self;
	self = NOTIFY_GOT_LINE (obj);
	_scan_line_unref0 (self->priv->line);
	NOTIFY_CLASS (notify_got_line_parent_class)->finalize (obj);
}


GType notify_got_line_get_type (void) {
	static volatile gsize notify_got_line_type_id__volatile = 0;
	if (g_once_init_enter (&notify_got_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyGotLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotLine), 0, (GInstanceInitFunc) notify_got_line_instance_init, NULL };
		GType notify_got_line_type_id;
		notify_got_line_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotLine", &g_define_type_info, 0);
		g_once_init_leave (&notify_got_line_type_id__volatile, notify_got_line_type_id);
	}
	return notify_got_line_type_id__volatile;
}


static void _scan_job_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (scan_job_unref (var), NULL));
}


static void _g_list_free__scan_job_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _scan_job_unref0_, NULL);
	g_list_free (self);
}


static Scanner* scanner_construct (GType object_type) {
	Scanner* self = NULL;
	GAsyncQueue* _tmp0_ = NULL;
	GAsyncQueue* _tmp1_ = NULL;
	GAsyncQueue* _tmp2_ = NULL;
	self = (Scanner*) g_type_create_instance (object_type);
	_tmp0_ = g_async_queue_new ();
	_g_async_queue_unref0 (self->priv->request_queue);
	self->priv->request_queue = _tmp0_;
	_tmp1_ = g_async_queue_new ();
	_g_async_queue_unref0 (self->priv->notify_queue);
	self->priv->notify_queue = _tmp1_;
	_tmp2_ = g_async_queue_new ();
	_g_async_queue_unref0 (self->priv->authorize_queue);
	self->priv->authorize_queue = _tmp2_;
	return self;
}


static Scanner* scanner_new (void) {
	return scanner_construct (TYPE_SCANNER);
}


static gpointer _scanner_ref0 (gpointer self) {
	return self ? scanner_ref (self) : NULL;
}


Scanner* scanner_get_instance (void) {
	Scanner* result = NULL;
	Scanner* _tmp1_;
	if (scanner_scanner_object == NULL) {
		Scanner* _tmp0_ = NULL;
		_tmp0_ = scanner_new ();
		_scanner_unref0 (scanner_scanner_object);
		scanner_scanner_object = _tmp0_;
	}
	_tmp1_ = _scanner_ref0 (scanner_scanner_object);
	result = _tmp1_;
	return result;
}


static gboolean scanner_notify_idle_cb (Scanner* self) {
	gboolean result = FALSE;
	gpointer _tmp0_ = NULL;
	Notify* notification;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_async_queue_pop (self->priv->notify_queue);
	notification = (Notify*) _tmp0_;
	notify_run (notification, self);
	result = FALSE;
	_notify_unref0 (notification);
	return result;
}


static gpointer _notify_ref0 (gpointer self) {
	return self ? notify_ref (self) : NULL;
}


static gboolean _scanner_notify_idle_cb_gsource_func (gpointer self) {
	gboolean result;
	result = scanner_notify_idle_cb (self);
	return result;
}


static void scanner_notify (Scanner* self, Notify* notification) {
	Notify* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	_tmp0_ = _notify_ref0 (notification);
	g_async_queue_push (self->priv->notify_queue, _tmp0_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _scanner_notify_idle_cb_gsource_func, scanner_ref (self), scanner_unref);
}


static void scanner_set_scanning (Scanner* self, gboolean is_scanning) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->scanning) {
		_tmp1_ = !is_scanning;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (!self->priv->scanning) {
			_tmp2_ = is_scanning;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		NotifyScanningChanged* _tmp3_ = NULL;
		NotifyScanningChanged* _tmp4_;
		self->priv->scanning = is_scanning;
		g_signal_emit_by_name (self, "scanning-changed");
		_tmp3_ = notify_scanning_changed_new ();
		_tmp4_ = _tmp3_;
		scanner_notify (self, (Notify*) _tmp4_);
		_notify_unref0 (_tmp4_);
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gint scanner_get_device_weight (const gchar* device) {
	gint result = 0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (device != NULL, 0);
	_tmp0_ = g_str_has_prefix (device, "vfl:");
	if (_tmp0_) {
		result = 2;
		return result;
	}
	_tmp1_ = string_contains (device, "usb");
	if (_tmp1_) {
		result = 0;
		return result;
	}
	result = 1;
	return result;
}


static gint scanner_compare_devices (ScanDevice* device1, ScanDevice* device2) {
	gint result = 0;
	gint _tmp0_;
	gint weight1;
	gint _tmp1_;
	gint weight2;
	gint _tmp2_;
	g_return_val_if_fail (device1 != NULL, 0);
	g_return_val_if_fail (device2 != NULL, 0);
	_tmp0_ = scanner_get_device_weight (device1->name);
	weight1 = _tmp0_;
	_tmp1_ = scanner_get_device_weight (device2->name);
	weight2 = _tmp1_;
	if (weight1 != weight2) {
		result = weight1 - weight2;
		return result;
	}
	_tmp2_ = g_strcmp0 (device1->label, device2->label);
	result = _tmp2_;
	return result;
}


static gchar* sane_status_to_string (SANE_Status status) {
	gchar* result = NULL;
	switch (status) {
		case SANE_STATUS_GOOD:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("SANE_STATUS_GOOD");
			result = _tmp0_;
			return result;
		}
		case SANE_STATUS_UNSUPPORTED:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("SANE_STATUS_UNSUPPORTED");
			result = _tmp1_;
			return result;
		}
		case SANE_STATUS_CANCELLED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("SANE_STATUS_CANCELLED");
			result = _tmp2_;
			return result;
		}
		case SANE_STATUS_DEVICE_BUSY:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("SANE_STATUS_DEVICE_BUSY");
			result = _tmp3_;
			return result;
		}
		case SANE_STATUS_INVAL:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("SANE_STATUS_INVAL");
			result = _tmp4_;
			return result;
		}
		case SANE_STATUS_EOF:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("SANE_STATUS_EOF");
			result = _tmp5_;
			return result;
		}
		case SANE_STATUS_JAMMED:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("SANE_STATUS_JAMMED");
			result = _tmp6_;
			return result;
		}
		case SANE_STATUS_NO_DOCS:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("SANE_STATUS_NO_DOCS");
			result = _tmp7_;
			return result;
		}
		case SANE_STATUS_COVER_OPEN:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("SANE_STATUS_COVER_OPEN");
			result = _tmp8_;
			return result;
		}
		case SANE_STATUS_IO_ERROR:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("SANE_STATUS_IO_ERROR");
			result = _tmp9_;
			return result;
		}
		case SANE_STATUS_NO_MEM:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("SANE_STATUS_NO_MEM");
			result = _tmp10_;
			return result;
		}
		case SANE_STATUS_ACCESS_DENIED:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("SANE_STATUS_ACCESS_DENIED");
			result = _tmp11_;
			return result;
		}
		default:
		{
			gchar* _tmp12_ = NULL;
			_tmp12_ = g_strdup_printf ("SANE_STATUS(%d)", (gint) status);
			result = _tmp12_;
			return result;
		}
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_;
		GRegex* regex;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp0_ = g_regex_escape_string (old, -1);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		regex = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp5_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally8;
	__catch8_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer _scan_device_ref0 (gpointer self) {
	return self ? scan_device_ref (self) : NULL;
}


static gint _scanner_compare_devices_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = scanner_compare_devices (a, b);
	return result;
}


static void scanner_do_redetect (Scanner* self) {
	SANE_Device** device_list;
	gint device_list_length1;
	gint _device_list_size_;
	SANE_Device** _tmp0_ = NULL;
	SANE_Status _tmp1_;
	SANE_Status status;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GList* devices;
	GList* _tmp17_;
	NotifyUpdateDevices* _tmp18_ = NULL;
	NotifyUpdateDevices* _tmp19_;
	g_return_if_fail (self != NULL);
	device_list = NULL;
	device_list_length1 = 0;
	_device_list_size_ = device_list_length1;
	_tmp1_ = sane_get_devices (&_tmp0_, FALSE);
	device_list = _tmp0_;
	device_list_length1 = -1;
	_device_list_size_ = device_list_length1;
	status = _tmp1_;
	_tmp2_ = sane_status_to_string (status);
	_tmp3_ = _tmp2_;
	g_debug ("scanner.vala:318: sane_get_devices () -> %s", _tmp3_);
	_g_free0 (_tmp3_);
	if (status != SANE_STATUS_GOOD) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = sane_strstatus (status);
		g_warning ("scanner.vala:321: Unable to get SANE devices: %s", _tmp4_);
		self->priv->need_redetect = FALSE;
		self->priv->state = SCAN_STATE_IDLE;
		return;
	}
	devices = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				ScanDevice* _tmp6_ = NULL;
				ScanDevice* scan_device;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* vendor;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				ScanDevice* _tmp13_;
				if (!_tmp5_) {
					i++;
				}
				_tmp5_ = FALSE;
				if (!(device_list[i] != NULL)) {
					break;
				}
				g_debug ("scanner.vala:330: Device: name=\"%s\" vendor=\"%s\" model=\"%s\" type=" \
"\"%s\"", device_list[i]->name, device_list[i]->vendor, device_list[i]->model, device_list[i]->type);
				_tmp6_ = scan_device_new ();
				scan_device = _tmp6_;
				_tmp7_ = g_strdup (device_list[i]->name);
				_g_free0 (scan_device->name);
				scan_device->name = _tmp7_;
				_tmp8_ = g_strdup (device_list[i]->vendor);
				vendor = _tmp8_;
				if (g_strcmp0 (vendor, "Hewlett-Packard") == 0) {
					gchar* _tmp9_;
					_tmp9_ = g_strdup ("HP");
					_g_free0 (vendor);
					vendor = _tmp9_;
				}
				_tmp10_ = g_strdup_printf ("%s %s", vendor, device_list[i]->model);
				_g_free0 (scan_device->label);
				scan_device->label = _tmp10_;
				_tmp11_ = string_replace (scan_device->label, "_", " ");
				_tmp12_ = _tmp11_;
				_g_free0 (_tmp12_);
				_tmp13_ = _scan_device_ref0 (scan_device);
				devices = g_list_append (devices, _tmp13_);
				_g_free0 (vendor);
				_scan_device_unref0 (scan_device);
			}
		}
	}
	devices = g_list_sort (devices, _scanner_compare_devices_gcompare_func);
	self->priv->need_redetect = FALSE;
	self->priv->state = SCAN_STATE_IDLE;
	if (devices != NULL) {
		gconstpointer _tmp14_ = NULL;
		ScanDevice* _tmp15_;
		ScanDevice* device;
		gchar* _tmp16_;
		_tmp14_ = g_list_nth_data (devices, (guint) 0);
		_tmp15_ = _scan_device_ref0 ((ScanDevice*) _tmp14_);
		device = _tmp15_;
		_tmp16_ = g_strdup (device->name);
		_g_free0 (self->priv->default_device);
		self->priv->default_device = _tmp16_;
		_scan_device_unref0 (device);
	} else {
		_g_free0 (self->priv->default_device);
		self->priv->default_device = NULL;
	}
	_tmp17_ = devices;
	devices = NULL;
	_tmp18_ = notify_update_devices_new (_tmp17_);
	_tmp19_ = _tmp18_;
	scanner_notify (self, (Notify*) _tmp19_);
	_notify_unref0 (_tmp19_);
	__g_list_free__scan_device_unref0_0 (devices);
}


static gboolean scanner_set_default_option (Scanner* self, SANE_Handle handle, const SANE_Option_Descriptor* option, SANE_Int option_index) {
	gboolean result = FALSE;
	SANE_Status _tmp0_;
	SANE_Status status;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (option != NULL, FALSE);
	if ((option->cap & SANE_CAP_AUTOMATIC) == 0) {
		result = FALSE;
		return result;
	}
	_tmp0_ = sane_control_option (handle, option_index, SANE_ACTION_SET_AUTO, NULL, NULL);
	status = _tmp0_;
	_tmp1_ = sane_status_to_string (status);
	_tmp2_ = _tmp1_;
	g_debug ("scanner.vala:372: sane_control_option (%d, SANE_ACTION_SET_AUTO) -> %s", (gint) option_index, _tmp2_);
	_g_free0 (_tmp2_);
	if (status != SANE_STATUS_GOOD) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = sane_strstatus (status);
		g_warning ("scanner.vala:374: Error setting default option %s: %s", option->name, _tmp3_);
	}
	result = status == SANE_STATUS_GOOD;
	return result;
}


static void scanner_set_bool_option (Scanner* self, SANE_Handle handle, const SANE_Option_Descriptor* option, SANE_Int option_index, gboolean value, gboolean* _result_) {
	gboolean _result = FALSE;
	SANE_Bool v;
	SANE_Status _tmp0_;
	SANE_Status status;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	g_return_if_fail (option->type == SANE_TYPE_BOOL);
	v = (SANE_Bool) value;
	_tmp0_ = sane_control_option (handle, option_index, SANE_ACTION_SET_VALUE, &v, NULL);
	status = _tmp0_;
	_result = (gboolean) v;
	if (value) {
		_tmp1_ = "SANE_TRUE";
	} else {
		_tmp1_ = "SANE_FALSE";
	}
	if (_result) {
		_tmp2_ = "SANE_TRUE";
	} else {
		_tmp2_ = "SANE_FALSE";
	}
	_tmp3_ = sane_status_to_string (status);
	_tmp4_ = _tmp3_;
	g_debug ("scanner.vala:386: sane_control_option (%d, SANE_ACTION_SET_VALUE, %s) " \
"-> (%s, %s)", (gint) option_index, _tmp1_, _tmp4_, _tmp2_);
	_g_free0 (_tmp4_);
	if (_result_) {
		*_result_ = _result;
	}
}


static void scanner_set_int_option (Scanner* self, SANE_Handle handle, const SANE_Option_Descriptor* option, SANE_Int option_index, gint value, gint* _result_) {
	gint _result = 0;
	SANE_Int v;
	SANE_Status _tmp2_;
	SANE_Status status;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	g_return_if_fail (option->type == SANE_TYPE_INT);
	v = (SANE_Int) value;
	if (option->constraint_type == SANE_CONSTRAINT_RANGE) {
		if (option->constraint.range->quant != 0) {
			v = v * option->constraint.range->quant;
		}
		if (v < option->constraint.range->min) {
			v = (SANE_Int) option->constraint.range->min;
		}
		if (v > option->constraint.range->max) {
			v = (SANE_Int) option->constraint.range->max;
		}
	} else {
		if (option->constraint_type == SANE_CONSTRAINT_WORD_LIST) {
			gint distance;
			gint nearest;
			distance = G_MAXINT;
			nearest = 0;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp0_;
					_tmp0_ = TRUE;
					while (TRUE) {
						gint x;
						gint _tmp1_;
						gint d;
						if (!_tmp0_) {
							i++;
						}
						_tmp0_ = FALSE;
						if (!(i < option->constraint.word_list[0])) {
							break;
						}
						x = (gint) option->constraint.word_list[i + 1];
						_tmp1_ = abs (x - v);
						d = _tmp1_;
						if (d < distance) {
							distance = d;
							nearest = x;
						}
					}
				}
			}
			v = (SANE_Int) nearest;
		}
	}
	_tmp2_ = sane_control_option (handle, option_index, SANE_ACTION_SET_VALUE, &v, NULL);
	status = _tmp2_;
	_tmp3_ = sane_status_to_string (status);
	_tmp4_ = _tmp3_;
	g_debug ("scanner.vala:422: sane_control_option (%d, SANE_ACTION_SET_VALUE, %d) " \
"-> (%s, %d)", (gint) option_index, value, _tmp4_, (gint) v);
	_g_free0 (_tmp4_);
	_result = (gint) v;
	if (_result_) {
		*_result_ = _result;
	}
}


static void scanner_set_fixed_option (Scanner* self, SANE_Handle handle, const SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_) {
	gdouble _result = 0.0;
	gdouble v;
	SANE_Fixed v_fixed;
	SANE_Fixed _tmp6_;
	SANE_Status _tmp7_;
	SANE_Status status;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	v = value;
	g_return_if_fail (option->type == SANE_TYPE_FIXED);
	if (option->constraint_type == SANE_CONSTRAINT_RANGE) {
		gdouble _tmp0_;
		gdouble min;
		gdouble _tmp1_;
		gdouble max;
		_tmp0_ = SANE_UNFIX ((SANE_Fixed) option->constraint.range->min);
		min = _tmp0_;
		_tmp1_ = SANE_UNFIX ((SANE_Fixed) option->constraint.range->max);
		max = _tmp1_;
		if (v < min) {
			v = min;
		}
		if (v > max) {
			v = max;
		}
	} else {
		if (option->constraint_type == SANE_CONSTRAINT_WORD_LIST) {
			gdouble distance;
			gdouble nearest;
			distance = DBL_MAX;
			nearest = 0.0;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp2_;
					_tmp2_ = TRUE;
					while (TRUE) {
						gdouble _tmp3_;
						gdouble x;
						gdouble _tmp4_;
						if (!_tmp2_) {
							i++;
						}
						_tmp2_ = FALSE;
						if (!(i < option->constraint.word_list[0])) {
							break;
						}
						_tmp3_ = SANE_UNFIX ((SANE_Fixed) option->constraint.word_list[i + 1]);
						x = _tmp3_;
						_tmp4_ = fabs (x - v);
						if (_tmp4_ < distance) {
							gdouble _tmp5_;
							_tmp5_ = fabs (x - v);
							distance = _tmp5_;
							nearest = x;
						}
					}
				}
			}
			v = nearest;
		}
	}
	_tmp6_ = SANE_FIX (v);
	v_fixed = _tmp6_;
	_tmp7_ = sane_control_option (handle, option_index, SANE_ACTION_SET_VALUE, &v_fixed, NULL);
	status = _tmp7_;
	_tmp8_ = sane_status_to_string (status);
	_tmp9_ = _tmp8_;
	_tmp10_ = SANE_UNFIX (v_fixed);
	g_debug ("scanner.vala:462: sane_control_option (%d, SANE_ACTION_SET_VALUE, %f) " \
"-> (%s, %f)", (gint) option_index, value, _tmp9_, _tmp10_);
	_g_free0 (_tmp9_);
	_tmp11_ = SANE_UNFIX (v_fixed);
	_result = _tmp11_;
	if (_result_) {
		*_result_ = _result;
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gboolean scanner_set_string_option (Scanner* self, SANE_Handle handle, const SANE_Option_Descriptor* option, SANE_Int option_index, const gchar* value, gchar** _result_) {
	gchar* _result = NULL;
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* s;
	gint s_length1;
	gint _s_size_;
	gint i;
	SANE_Status _tmp5_;
	SANE_Status status;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (option != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (option->type == SANE_TYPE_STRING, FALSE);
	_tmp0_ = g_new0 (gchar, option->size);
	s = _tmp0_;
	s_length1 = option->size;
	_s_size_ = s_length1;
	i = 0;
	{
		gboolean _tmp1_;
		_tmp1_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gchar _tmp4_;
			if (!_tmp1_) {
				i++;
			}
			_tmp1_ = FALSE;
			if (i < (option->size - 1)) {
				gchar _tmp3_;
				_tmp3_ = string_get (value, (glong) i);
				_tmp2_ = _tmp3_ != '\0';
			} else {
				_tmp2_ = FALSE;
			}
			if (!_tmp2_) {
				break;
			}
			_tmp4_ = string_get (value, (glong) i);
			s[i] = _tmp4_;
		}
	}
	s[i] = '\0';
	_tmp5_ = sane_control_option (handle, option_index, SANE_ACTION_SET_VALUE, s, NULL);
	status = _tmp5_;
	_tmp6_ = g_strdup ((const gchar*) s);
	_g_free0 (_result);
	_result = _tmp6_;
	_tmp7_ = sane_status_to_string (status);
	_tmp8_ = _tmp7_;
	g_debug ("scanner.vala:478: sane_control_option (%d, SANE_ACTION_SET_VALUE, \"%s" \
"\") -> (%s, \"%s\")", (gint) option_index, value, _tmp8_, _result);
	_g_free0 (_tmp8_);
	result = status == SANE_STATUS_GOOD;
	s = (g_free (s), NULL);
	if (_result_) {
		*_result_ = _result;
	} else {
		_g_free0 (_result);
	}
	return result;
}


static gboolean scanner_set_constrained_string_option (Scanner* self, SANE_Handle handle, const SANE_Option_Descriptor* option, SANE_Int option_index, gchar** values, int values_length1, gchar** _result_) {
	gchar* _result = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (option != NULL, FALSE);
	g_return_val_if_fail (option->type == SANE_TYPE_STRING, FALSE);
	g_return_val_if_fail (option->constraint_type == SANE_CONSTRAINT_STRING_LIST, FALSE);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint j;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(values[i] != NULL)) {
					break;
				}
				j = 0;
				{
					gboolean _tmp1_;
					_tmp1_ = TRUE;
					while (TRUE) {
						if (!_tmp1_) {
							j++;
						}
						_tmp1_ = FALSE;
						if (!(option->constraint.string_list[j] != NULL)) {
							break;
						}
						if (g_strcmp0 (values[i], option->constraint.string_list[j]) == 0) {
							break;
						}
					}
				}
				if (option->constraint.string_list[j] != NULL) {
					gchar* _tmp2_ = NULL;
					gboolean _tmp3_;
					_tmp3_ = scanner_set_string_option (self, handle, option, option_index, values[i], &_tmp2_);
					_g_free0 (_result);
					_result = _tmp2_;
					result = _tmp3_;
					if (_result_) {
						*_result_ = _result;
					} else {
						_g_free0 (_result);
					}
					return result;
				}
			}
		}
	}
	result = FALSE;
	if (_result_) {
		*_result_ = _result;
	} else {
		_g_free0 (_result);
	}
	return result;
}


static void scanner_log_option (Scanner* self, SANE_Int index, const SANE_Option_Descriptor* option) {
	gchar* _tmp0_ = NULL;
	gchar* s;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_;
	SANE_Int cap;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	_tmp0_ = g_strdup_printf ("Option %d:", (gint) index);
	s = _tmp0_;
	if (g_strcmp0 (option->name, "") != 0) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = g_strdup_printf (" name='%s'", option->name);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat (s, _tmp2_, NULL);
		_g_free0 (s);
		s = _tmp3_;
		_g_free0 (_tmp2_);
	}
	if (g_strcmp0 (option->title, "") != 0) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = g_strdup_printf (" title='%s'", option->title);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (s, _tmp5_, NULL);
		_g_free0 (s);
		s = _tmp6_;
		_g_free0 (_tmp5_);
	}
	switch (option->type) {
		case SANE_TYPE_BOOL:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strconcat (s, " type=bool", NULL);
			_g_free0 (s);
			s = _tmp7_;
			break;
		}
		case SANE_TYPE_INT:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strconcat (s, " type=int", NULL);
			_g_free0 (s);
			s = _tmp8_;
			break;
		}
		case SANE_TYPE_FIXED:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strconcat (s, " type=fixed", NULL);
			_g_free0 (s);
			s = _tmp9_;
			break;
		}
		case SANE_TYPE_STRING:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strconcat (s, " type=string", NULL);
			_g_free0 (s);
			s = _tmp10_;
			break;
		}
		case SANE_TYPE_BUTTON:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strconcat (s, " type=button", NULL);
			_g_free0 (s);
			s = _tmp11_;
			break;
		}
		case SANE_TYPE_GROUP:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strconcat (s, " type=group", NULL);
			_g_free0 (s);
			s = _tmp12_;
			break;
		}
		default:
		{
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp13_ = g_strdup_printf (" type=%d", (gint) option->type);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat (s, _tmp14_, NULL);
			_g_free0 (s);
			s = _tmp15_;
			_g_free0 (_tmp14_);
			break;
		}
	}
	_tmp16_ = g_strdup_printf (" size=%d", (gint) option->size);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (s, _tmp17_, NULL);
	_g_free0 (s);
	s = _tmp18_;
	_g_free0 (_tmp17_);
	switch (option->unit) {
		case SANE_UNIT_NONE:
		{
			break;
		}
		case SANE_UNIT_PIXEL:
		{
			gchar* _tmp19_;
			_tmp19_ = g_strconcat (s, " unit=pixels", NULL);
			_g_free0 (s);
			s = _tmp19_;
			break;
		}
		case SANE_UNIT_BIT:
		{
			gchar* _tmp20_;
			_tmp20_ = g_strconcat (s, " unit=bits", NULL);
			_g_free0 (s);
			s = _tmp20_;
			break;
		}
		case SANE_UNIT_MM:
		{
			gchar* _tmp21_;
			_tmp21_ = g_strconcat (s, " unit=mm", NULL);
			_g_free0 (s);
			s = _tmp21_;
			break;
		}
		case SANE_UNIT_DPI:
		{
			gchar* _tmp22_;
			_tmp22_ = g_strconcat (s, " unit=dpi", NULL);
			_g_free0 (s);
			s = _tmp22_;
			break;
		}
		case SANE_UNIT_PERCENT:
		{
			gchar* _tmp23_;
			_tmp23_ = g_strconcat (s, " unit=percent", NULL);
			_g_free0 (s);
			s = _tmp23_;
			break;
		}
		case SANE_UNIT_MICROSECOND:
		{
			gchar* _tmp24_;
			_tmp24_ = g_strconcat (s, " unit=microseconds", NULL);
			_g_free0 (s);
			s = _tmp24_;
			break;
		}
		default:
		{
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp25_ = g_strdup_printf (" unit=%d", (gint) option->unit);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strconcat (s, _tmp26_, NULL);
			_g_free0 (s);
			s = _tmp27_;
			_g_free0 (_tmp26_);
			break;
		}
	}
	switch (option->constraint_type) {
		case SANE_CONSTRAINT_RANGE:
		{
			if (option->type == SANE_TYPE_FIXED) {
				gdouble _tmp28_;
				gdouble _tmp29_;
				gchar* _tmp30_ = NULL;
				gchar* _tmp31_;
				gchar* _tmp32_;
				_tmp28_ = SANE_UNFIX ((SANE_Fixed) option->constraint.range->min);
				_tmp29_ = SANE_UNFIX ((SANE_Fixed) option->constraint.range->max);
				_tmp30_ = g_strdup_printf (" min=%f, max=%f, quant=%d", _tmp28_, _tmp29_, (gint) option->constraint.range->quant);
				_tmp31_ = _tmp30_;
				_tmp32_ = g_strconcat (s, _tmp31_, NULL);
				_g_free0 (s);
				s = _tmp32_;
				_g_free0 (_tmp31_);
			} else {
				gchar* _tmp33_ = NULL;
				gchar* _tmp34_;
				gchar* _tmp35_;
				_tmp33_ = g_strdup_printf (" min=%d, max=%d, quant=%d", (gint) option->constraint.range->min, (gint) option->constraint.range->max, (gint) option->constraint.range->quant);
				_tmp34_ = _tmp33_;
				_tmp35_ = g_strconcat (s, _tmp34_, NULL);
				_g_free0 (s);
				s = _tmp35_;
				_g_free0 (_tmp34_);
			}
			break;
		}
		case SANE_CONSTRAINT_WORD_LIST:
		{
			gchar* _tmp36_;
			gchar* _tmp46_;
			_tmp36_ = g_strconcat (s, " values=[", NULL);
			_g_free0 (s);
			s = _tmp36_;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp37_;
					_tmp37_ = TRUE;
					while (TRUE) {
						if (!_tmp37_) {
							i++;
						}
						_tmp37_ = FALSE;
						if (!(i < option->constraint.word_list[0])) {
							break;
						}
						if (i != 0) {
							gchar* _tmp38_;
							_tmp38_ = g_strconcat (s, ", ", NULL);
							_g_free0 (s);
							s = _tmp38_;
						}
						if (option->type == SANE_TYPE_INT) {
							gchar* _tmp39_ = NULL;
							gchar* _tmp40_;
							gchar* _tmp41_;
							_tmp39_ = g_strdup_printf ("%d", (gint) option->constraint.word_list[i + 1]);
							_tmp40_ = _tmp39_;
							_tmp41_ = g_strconcat (s, _tmp40_, NULL);
							_g_free0 (s);
							s = _tmp41_;
							_g_free0 (_tmp40_);
						} else {
							gdouble _tmp42_;
							gchar* _tmp43_ = NULL;
							gchar* _tmp44_;
							gchar* _tmp45_;
							_tmp42_ = SANE_UNFIX ((SANE_Fixed) option->constraint.word_list[i + 1]);
							_tmp43_ = g_strdup_printf ("%f", _tmp42_);
							_tmp44_ = _tmp43_;
							_tmp45_ = g_strconcat (s, _tmp44_, NULL);
							_g_free0 (s);
							s = _tmp45_;
							_g_free0 (_tmp44_);
						}
					}
				}
			}
			_tmp46_ = g_strconcat (s, "]", NULL);
			_g_free0 (s);
			s = _tmp46_;
			break;
		}
		case SANE_CONSTRAINT_STRING_LIST:
		{
			gchar* _tmp47_;
			gchar* _tmp53_;
			_tmp47_ = g_strconcat (s, " values=[", NULL);
			_g_free0 (s);
			s = _tmp47_;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp48_;
					_tmp48_ = TRUE;
					while (TRUE) {
						gchar* _tmp50_ = NULL;
						gchar* _tmp51_;
						gchar* _tmp52_;
						if (!_tmp48_) {
							i++;
						}
						_tmp48_ = FALSE;
						if (!(option->constraint.string_list[i] != NULL)) {
							break;
						}
						if (i != 0) {
							gchar* _tmp49_;
							_tmp49_ = g_strconcat (s, ", ", NULL);
							_g_free0 (s);
							s = _tmp49_;
						}
						_tmp50_ = g_strdup_printf ("\"%s\"", option->constraint.string_list[i]);
						_tmp51_ = _tmp50_;
						_tmp52_ = g_strconcat (s, _tmp51_, NULL);
						_g_free0 (s);
						s = _tmp52_;
						_g_free0 (_tmp51_);
					}
				}
			}
			_tmp53_ = g_strconcat (s, "]", NULL);
			_g_free0 (s);
			s = _tmp53_;
			break;
		}
		default:
		{
			break;
		}
	}
	cap = option->cap;
	if (cap != 0) {
		gchar* _tmp54_;
		_tmp54_ = g_strconcat (s, " cap=", NULL);
		_g_free0 (s);
		s = _tmp54_;
		if ((cap & SANE_CAP_SOFT_SELECT) != 0) {
			gchar* _tmp56_;
			if (g_strcmp0 (s, "") != 0) {
				gchar* _tmp55_;
				_tmp55_ = g_strconcat (s, ",", NULL);
				_g_free0 (s);
				s = _tmp55_;
			}
			_tmp56_ = g_strconcat (s, "soft-select", NULL);
			_g_free0 (s);
			s = _tmp56_;
			cap = cap & (~SANE_CAP_SOFT_SELECT);
		}
		if ((cap & SANE_CAP_HARD_SELECT) != 0) {
			gchar* _tmp58_;
			if (g_strcmp0 (s, "") != 0) {
				gchar* _tmp57_;
				_tmp57_ = g_strconcat (s, ",", NULL);
				_g_free0 (s);
				s = _tmp57_;
			}
			_tmp58_ = g_strconcat (s, "hard-select", NULL);
			_g_free0 (s);
			s = _tmp58_;
			cap = cap & (~SANE_CAP_HARD_SELECT);
		}
		if ((cap & SANE_CAP_SOFT_DETECT) != 0) {
			gchar* _tmp60_;
			if (g_strcmp0 (s, "") != 0) {
				gchar* _tmp59_;
				_tmp59_ = g_strconcat (s, ",", NULL);
				_g_free0 (s);
				s = _tmp59_;
			}
			_tmp60_ = g_strconcat (s, "soft-detect", NULL);
			_g_free0 (s);
			s = _tmp60_;
			cap = cap & (~SANE_CAP_SOFT_DETECT);
		}
		if ((cap & SANE_CAP_EMULATED) != 0) {
			gchar* _tmp62_;
			if (g_strcmp0 (s, "") != 0) {
				gchar* _tmp61_;
				_tmp61_ = g_strconcat (s, ",", NULL);
				_g_free0 (s);
				s = _tmp61_;
			}
			_tmp62_ = g_strconcat (s, "emulated", NULL);
			_g_free0 (s);
			s = _tmp62_;
			cap = cap & (~SANE_CAP_EMULATED);
		}
		if ((cap & SANE_CAP_AUTOMATIC) != 0) {
			gchar* _tmp64_;
			if (g_strcmp0 (s, "") != 0) {
				gchar* _tmp63_;
				_tmp63_ = g_strconcat (s, ",", NULL);
				_g_free0 (s);
				s = _tmp63_;
			}
			_tmp64_ = g_strconcat (s, "automatic", NULL);
			_g_free0 (s);
			s = _tmp64_;
			cap = cap & (~SANE_CAP_AUTOMATIC);
		}
		if ((cap & SANE_CAP_INACTIVE) != 0) {
			gchar* _tmp66_;
			if (g_strcmp0 (s, "") != 0) {
				gchar* _tmp65_;
				_tmp65_ = g_strconcat (s, ",", NULL);
				_g_free0 (s);
				s = _tmp65_;
			}
			_tmp66_ = g_strconcat (s, "inactive", NULL);
			_g_free0 (s);
			s = _tmp66_;
			cap = cap & (~SANE_CAP_INACTIVE);
		}
		if ((cap & SANE_CAP_ADVANCED) != 0) {
			gchar* _tmp68_;
			if (g_strcmp0 (s, "") != 0) {
				gchar* _tmp67_;
				_tmp67_ = g_strconcat (s, ",", NULL);
				_g_free0 (s);
				s = _tmp67_;
			}
			_tmp68_ = g_strconcat (s, "advanced", NULL);
			_g_free0 (s);
			s = _tmp68_;
			cap = cap & (~SANE_CAP_ADVANCED);
		}
		if (cap != 0) {
			gchar* _tmp70_ = NULL;
			gchar* _tmp71_;
			gchar* _tmp72_;
			if (g_strcmp0 (s, "") != 0) {
				gchar* _tmp69_;
				_tmp69_ = g_strconcat (s, ",", NULL);
				_g_free0 (s);
				s = _tmp69_;
			}
			_tmp70_ = g_strdup_printf ("%x", (guint) cap);
			_tmp71_ = _tmp70_;
			_tmp72_ = g_strconcat (s, _tmp71_, NULL);
			_g_free0 (s);
			s = _tmp72_;
			_g_free0 (_tmp71_);
		}
	}
	g_debug ("scanner.vala:665: %s", s);
	if (option->desc != NULL) {
		g_debug ("scanner.vala:668:   Description: %s", option->desc);
	}
	_g_free0 (s);
}


static void scanner_authorization_cb (const gchar* resource, gchar* username, int username_length1, gchar* password, int password_length1) {
	NotifyRequestAuthorization* _tmp0_ = NULL;
	NotifyRequestAuthorization* _tmp1_;
	gpointer _tmp2_ = NULL;
	Credentials* credentials;
	g_return_if_fail (resource != NULL);
	_tmp0_ = notify_request_authorization_new (resource);
	_tmp1_ = _tmp0_;
	scanner_notify (scanner_scanner_object, (Notify*) _tmp1_);
	_notify_unref0 (_tmp1_);
	_tmp2_ = g_async_queue_pop (scanner_scanner_object->priv->authorize_queue);
	credentials = (Credentials*) _tmp2_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gchar _tmp5_;
				gchar _tmp6_;
				if (!_tmp3_) {
					i++;
				}
				_tmp3_ = FALSE;
				_tmp5_ = string_get (credentials->username, (glong) i);
				if (_tmp5_ != '\0') {
					_tmp4_ = i < SANE_MAX_USERNAME_LEN;
				} else {
					_tmp4_ = FALSE;
				}
				if (!_tmp4_) {
					break;
				}
				_tmp6_ = string_get (credentials->username, (glong) i);
				username[i] = _tmp6_;
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_ = FALSE;
				gchar _tmp9_;
				gchar _tmp10_;
				if (!_tmp7_) {
					i++;
				}
				_tmp7_ = FALSE;
				_tmp9_ = string_get (credentials->password, (glong) i);
				if (_tmp9_ != '\0') {
					_tmp8_ = i < SANE_MAX_USERNAME_LEN;
				} else {
					_tmp8_ = FALSE;
				}
				if (!_tmp8_) {
					break;
				}
				_tmp10_ = string_get (credentials->password, (glong) i);
				password[i] = _tmp10_;
			}
		}
	}
	_credentials_unref0 (credentials);
}


static gpointer _credentials_ref0 (gpointer self) {
	return self ? credentials_ref (self) : NULL;
}


void scanner_authorize (Scanner* self, const gchar* username, const gchar* password) {
	Credentials* _tmp0_ = NULL;
	Credentials* credentials;
	gchar* _tmp1_;
	gchar* _tmp2_;
	Credentials* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	g_return_if_fail (password != NULL);
	_tmp0_ = credentials_new ();
	credentials = _tmp0_;
	_tmp1_ = g_strdup (username);
	_g_free0 (credentials->username);
	credentials->username = _tmp1_;
	_tmp2_ = g_strdup (password);
	_g_free0 (credentials->password);
	credentials->password = _tmp2_;
	_tmp3_ = _credentials_ref0 (credentials);
	g_async_queue_push (self->priv->authorize_queue, _tmp3_);
	_credentials_unref0 (credentials);
}


static void scanner_close_device (Scanner* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->have_handle) {
		sane_cancel (self->priv->handle);
		g_debug ("scanner.vala:695: sane_cancel ()");
		sane_close (self->priv->handle);
		g_debug ("scanner.vala:698: sane_close ()");
		self->priv->have_handle = FALSE;
	}
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->buffer = NULL;
	self->priv->buffer_length1 = 0;
	self->priv->_buffer_size_ = self->priv->buffer_length1;
	__g_list_free__scan_job_unref0_0 (self->priv->job_queue);
	self->priv->job_queue = NULL;
	scanner_set_scanning (self, FALSE);
}


static void scanner_fail_scan (Scanner* self, gint error_code, const gchar* error_string) {
	NotifyScanFailed* _tmp0_ = NULL;
	NotifyScanFailed* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_string != NULL);
	scanner_close_device (self);
	self->priv->state = SCAN_STATE_IDLE;
	_tmp0_ = notify_scan_failed_new (error_code, error_string);
	_tmp1_ = _tmp0_;
	scanner_notify (self, (Notify*) _tmp1_);
	_notify_unref0 (_tmp1_);
}


static gpointer _request_ref0 (gpointer self) {
	return self ? request_ref (self) : NULL;
}


static gpointer _scan_job_ref0 (gpointer self) {
	return self ? scan_job_ref (self) : NULL;
}


static gboolean scanner_handle_requests (Scanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint request_count;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->state == SCAN_STATE_IDLE) {
		_tmp0_ = self->priv->need_redetect;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->state = SCAN_STATE_REDETECT;
	}
	request_count = 0;
	while (TRUE) {
		Request* request = NULL;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		if (self->priv->state == SCAN_STATE_IDLE) {
			_tmp2_ = request_count == 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			gint _tmp3_;
			_tmp3_ = g_async_queue_length (self->priv->request_queue);
			_tmp1_ = _tmp3_ > 0;
		}
		if (_tmp1_) {
			gpointer _tmp4_ = NULL;
			_tmp4_ = g_async_queue_pop (self->priv->request_queue);
			_request_unref0 (request);
			request = (Request*) _tmp4_;
		} else {
			result = TRUE;
			_request_unref0 (request);
			return result;
		}
		g_debug ("scanner.vala:732: Processing request");
		request_count++;
		if (IS_REQUEST_START_SCAN (request)) {
			RequestStartScan* _tmp5_;
			RequestStartScan* r;
			ScanJob* _tmp6_;
			_tmp5_ = _request_ref0 (REQUEST_START_SCAN (request));
			r = _tmp5_;
			_tmp6_ = _scan_job_ref0 (r->job);
			self->priv->job_queue = g_list_append (self->priv->job_queue, _tmp6_);
			_request_unref0 (r);
		} else {
			if (IS_REQUEST_CANCEL (request)) {
				scanner_fail_scan (self, (gint) SANE_STATUS_CANCELLED, "Scan cancelled - do not report this error");
			} else {
				if (IS_REQUEST_QUIT (request)) {
					scanner_close_device (self);
					result = FALSE;
					_request_unref0 (request);
					return result;
				}
			}
		}
		_request_unref0 (request);
	}
}


static void scanner_do_open (Scanner* self) {
	ScanJob* _tmp0_;
	ScanJob* job;
	gboolean _tmp1_ = FALSE;
	SANE_Handle _tmp4_;
	SANE_Status _tmp5_;
	SANE_Status status;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _scan_job_ref0 (SCAN_JOB ((ScanJob*) self->priv->job_queue->data));
	job = _tmp0_;
	self->priv->line_count = 0;
	self->priv->pass_number = 0;
	self->priv->page_number = 0;
	self->priv->notified_page = -1;
	self->priv->option_index = (SANE_Int) 0;
	self->priv->br_x_option_index = (SANE_Int) 0;
	self->priv->br_y_option_index = (SANE_Int) 0;
	if (job->device == NULL) {
		_tmp1_ = self->priv->default_device != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self->priv->default_device);
		_g_free0 (job->device);
		job->device = _tmp2_;
	}
	if (job->device == NULL) {
		const gchar* _tmp3_ = NULL;
		g_warning ("scanner.vala:769: No scan device available");
		_tmp3_ = _ ("No scanners available.  Please connect a scanner.");
		scanner_fail_scan (self, 0, _tmp3_);
		_scan_job_unref0 (job);
		return;
	}
	if (self->priv->have_handle) {
		if (g_strcmp0 (self->priv->current_device, job->device) == 0) {
			self->priv->state = SCAN_STATE_GET_OPTION;
			_scan_job_unref0 (job);
			return;
		}
		sane_close (self->priv->handle);
		g_debug ("scanner.vala:786: sane_close ()");
		self->priv->have_handle = FALSE;
	}
	_g_free0 (self->priv->current_device);
	self->priv->current_device = NULL;
	self->priv->have_handle = FALSE;
	_tmp5_ = sane_open (job->device, &_tmp4_);
	self->priv->handle = _tmp4_;
	status = _tmp5_;
	_tmp6_ = sane_status_to_string (status);
	_tmp7_ = _tmp6_;
	g_debug ("scanner.vala:794: sane_open (\"%s\") -> %s", job->device, _tmp7_);
	_g_free0 (_tmp7_);
	if (status != SANE_STATUS_GOOD) {
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = sane_strstatus (status);
		g_warning ("scanner.vala:798: Unable to get open device: %s", _tmp8_);
		_tmp9_ = _ ("Unable to connect to scanner");
		scanner_fail_scan (self, (gint) status, _tmp9_);
		_scan_job_unref0 (job);
		return;
	}
	self->priv->have_handle = TRUE;
	_tmp10_ = g_strdup (job->device);
	_g_free0 (self->priv->current_device);
	self->priv->current_device = _tmp10_;
	self->priv->state = SCAN_STATE_GET_OPTION;
	_scan_job_unref0 (job);
}


static void scanner_do_get_option (Scanner* self) {
	ScanJob* _tmp0_;
	ScanJob* job;
	const SANE_Option_Descriptor* _tmp1_ = NULL;
	const SANE_Option_Descriptor* option;
	SANE_Int index;
	g_return_if_fail (self != NULL);
	_tmp0_ = _scan_job_ref0 (SCAN_JOB ((ScanJob*) self->priv->job_queue->data));
	job = _tmp0_;
	_tmp1_ = sane_get_option_descriptor (self->priv->handle, self->priv->option_index);
	option = _tmp1_;
	g_debug ("scanner.vala:815: sane_get_option_descriptor (%d)", (gint) self->priv->option_index);
	index = self->priv->option_index;
	self->priv->option_index++;
	if (option == NULL) {
		if (self->priv->br_x_option_index != 0) {
			const SANE_Option_Descriptor* _tmp2_ = NULL;
			_tmp2_ = sane_get_option_descriptor (self->priv->handle, self->priv->br_x_option_index);
			option = _tmp2_;
			g_debug ("scanner.vala:825: sane_get_option_descriptor (%d)", (gint) self->priv->br_x_option_index);
			if (option->constraint_type == SANE_CONSTRAINT_RANGE) {
				if (option->type == SANE_TYPE_FIXED) {
					gdouble _tmp3_;
					_tmp3_ = SANE_UNFIX ((SANE_Fixed) option->constraint.range->max);
					scanner_set_fixed_option (self, self->priv->handle, option, self->priv->br_x_option_index, _tmp3_, NULL);
				} else {
					scanner_set_int_option (self, self->priv->handle, option, self->priv->br_x_option_index, (gint) option->constraint.range->max, NULL);
				}
			}
		}
		if (self->priv->br_y_option_index != 0) {
			const SANE_Option_Descriptor* _tmp4_ = NULL;
			_tmp4_ = sane_get_option_descriptor (self->priv->handle, self->priv->br_y_option_index);
			option = _tmp4_;
			g_debug ("scanner.vala:837: sane_get_option_descriptor (%d)", (gint) self->priv->br_y_option_index);
			if (option->constraint_type == SANE_CONSTRAINT_RANGE) {
				if (option->type == SANE_TYPE_FIXED) {
					gdouble _tmp5_;
					_tmp5_ = SANE_UNFIX ((SANE_Fixed) option->constraint.range->max);
					scanner_set_fixed_option (self, self->priv->handle, option, self->priv->br_y_option_index, _tmp5_, NULL);
				} else {
					scanner_set_int_option (self, self->priv->handle, option, self->priv->br_y_option_index, (gint) option->constraint.range->max, NULL);
				}
			}
		}
		self->priv->state = SCAN_STATE_START;
		_scan_job_unref0 (job);
		return;
	}
	scanner_log_option (self, index, option);
	if (option->type == SANE_TYPE_GROUP) {
		_scan_job_unref0 (job);
		return;
	}
	if ((option->cap & SANE_CAP_INACTIVE) != 0) {
		_scan_job_unref0 (job);
		return;
	}
	if (option->name == NULL) {
		_scan_job_unref0 (job);
		return;
	}
	if (g_strcmp0 (option->name, SANE_NAME_SCAN_RESOLUTION) == 0) {
		if (option->type == SANE_TYPE_FIXED) {
			gdouble _tmp6_;
			scanner_set_fixed_option (self, self->priv->handle, option, index, job->dpi, &_tmp6_);
			job->dpi = _tmp6_;
		} else {
			gint dpi = 0;
			gint _tmp7_;
			scanner_set_int_option (self, self->priv->handle, option, index, (gint) job->dpi, &_tmp7_);
			dpi = _tmp7_;
			job->dpi = (gdouble) dpi;
		}
	} else {
		if (g_strcmp0 (option->name, SANE_NAME_SCAN_SOURCE) == 0) {
			gchar* _tmp8_;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			gchar** _tmp18_ = NULL;
			gchar** flatbed_sources;
			gint flatbed_sources_length1;
			gint _flatbed_sources_size_;
			gchar* _tmp19_;
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar** _tmp25_ = NULL;
			gchar** adf_sources;
			gint adf_sources_length1;
			gint _adf_sources_size_;
			gchar* _tmp26_;
			const gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			gchar** _tmp29_ = NULL;
			gchar** adf_front_sources;
			gint adf_front_sources_length1;
			gint _adf_front_sources_size_;
			gchar* _tmp30_;
			const gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			gchar** _tmp33_ = NULL;
			gchar** adf_back_sources;
			gint adf_back_sources_length1;
			gint _adf_back_sources_size_;
			gchar* _tmp34_;
			const gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			gchar** _tmp37_ = NULL;
			gchar** adf_duplex_sources;
			gint adf_duplex_sources_length1;
			gint _adf_duplex_sources_size_;
			_tmp8_ = g_strdup ("Auto");
			_tmp9_ = SANE_I18N ("Auto");
			_tmp10_ = g_strdup (_tmp9_);
			_tmp11_ = g_strdup ("Flatbed");
			_tmp12_ = SANE_I18N ("Flatbed");
			_tmp13_ = g_strdup (_tmp12_);
			_tmp14_ = g_strdup ("FlatBed");
			_tmp15_ = g_strdup ("Normal");
			_tmp16_ = SANE_I18N ("Normal");
			_tmp17_ = g_strdup (_tmp16_);
			_tmp18_ = g_new0 (gchar*, 7 + 1);
			_tmp18_[0] = _tmp8_;
			_tmp18_[1] = _tmp10_;
			_tmp18_[2] = _tmp11_;
			_tmp18_[3] = _tmp13_;
			_tmp18_[4] = _tmp14_;
			_tmp18_[5] = _tmp15_;
			_tmp18_[6] = _tmp17_;
			flatbed_sources = _tmp18_;
			flatbed_sources_length1 = 7;
			_flatbed_sources_size_ = flatbed_sources_length1;
			_tmp19_ = g_strdup ("Automatic Document Feeder");
			_tmp20_ = SANE_I18N ("Automatic Document Feeder");
			_tmp21_ = g_strdup (_tmp20_);
			_tmp22_ = g_strdup ("ADF");
			_tmp23_ = g_strdup ("Automatic Document Feeder(left aligned)");
			_tmp24_ = g_strdup ("Automatic Document Feeder(centrally aligned)");
			_tmp25_ = g_new0 (gchar*, 5 + 1);
			_tmp25_[0] = _tmp19_;
			_tmp25_[1] = _tmp21_;
			_tmp25_[2] = _tmp22_;
			_tmp25_[3] = _tmp23_;
			_tmp25_[4] = _tmp24_;
			adf_sources = _tmp25_;
			adf_sources_length1 = 5;
			_adf_sources_size_ = adf_sources_length1;
			_tmp26_ = g_strdup ("ADF Front");
			_tmp27_ = SANE_I18N ("ADF Front");
			_tmp28_ = g_strdup (_tmp27_);
			_tmp29_ = g_new0 (gchar*, 2 + 1);
			_tmp29_[0] = _tmp26_;
			_tmp29_[1] = _tmp28_;
			adf_front_sources = _tmp29_;
			adf_front_sources_length1 = 2;
			_adf_front_sources_size_ = adf_front_sources_length1;
			_tmp30_ = g_strdup ("ADF Back");
			_tmp31_ = SANE_I18N ("ADF Back");
			_tmp32_ = g_strdup (_tmp31_);
			_tmp33_ = g_new0 (gchar*, 2 + 1);
			_tmp33_[0] = _tmp30_;
			_tmp33_[1] = _tmp32_;
			adf_back_sources = _tmp33_;
			adf_back_sources_length1 = 2;
			_adf_back_sources_size_ = adf_back_sources_length1;
			_tmp34_ = g_strdup ("ADF Duplex");
			_tmp35_ = SANE_I18N ("ADF Duplex");
			_tmp36_ = g_strdup (_tmp35_);
			_tmp37_ = g_new0 (gchar*, 2 + 1);
			_tmp37_[0] = _tmp34_;
			_tmp37_[1] = _tmp36_;
			adf_duplex_sources = _tmp37_;
			adf_duplex_sources_length1 = 2;
			_adf_duplex_sources_size_ = adf_duplex_sources_length1;
			switch (job->type) {
				case SCAN_TYPE_SINGLE:
				{
					gboolean _tmp38_;
					_tmp38_ = scanner_set_default_option (self, self->priv->handle, option, index);
					if (!_tmp38_) {
						gboolean _tmp39_;
						_tmp39_ = scanner_set_constrained_string_option (self, self->priv->handle, option, index, flatbed_sources, flatbed_sources_length1, NULL);
						if (!_tmp39_) {
							g_warning ("scanner.vala:921: Unable to set single page source, please file a bug");
						}
					}
					break;
				}
				case SCAN_TYPE_ADF_FRONT:
				{
					gboolean _tmp40_;
					_tmp40_ = scanner_set_constrained_string_option (self, self->priv->handle, option, index, adf_front_sources, adf_front_sources_length1, NULL);
					if (!_tmp40_) {
						gboolean _tmp41_;
						_tmp41_ = scanner_set_constrained_string_option (self, self->priv->handle, option, index, adf_sources, adf_sources_length1, NULL);
						if (!(!_tmp41_)) {
							g_warning ("scanner.vala:926: Unable to set front ADF source, please file a bug");
						}
					}
					break;
				}
				case SCAN_TYPE_ADF_BACK:
				{
					gboolean _tmp42_;
					_tmp42_ = scanner_set_constrained_string_option (self, self->priv->handle, option, index, adf_back_sources, adf_back_sources_length1, NULL);
					if (!_tmp42_) {
						gboolean _tmp43_;
						_tmp43_ = scanner_set_constrained_string_option (self, self->priv->handle, option, index, adf_sources, adf_sources_length1, NULL);
						if (!_tmp43_) {
							g_warning ("scanner.vala:931: Unable to set back ADF source, please file a bug");
						}
					}
					break;
				}
				case SCAN_TYPE_ADF_BOTH:
				{
					gboolean _tmp44_;
					_tmp44_ = scanner_set_constrained_string_option (self, self->priv->handle, option, index, adf_duplex_sources, adf_duplex_sources_length1, NULL);
					if (!_tmp44_) {
						gboolean _tmp45_;
						_tmp45_ = scanner_set_constrained_string_option (self, self->priv->handle, option, index, adf_sources, adf_sources_length1, NULL);
						if (!_tmp45_) {
							g_warning ("scanner.vala:936: Unable to set duplex ADF source, please file a bug");
						}
					}
					break;
				}
				default:
				break;
			}
			adf_duplex_sources = (_vala_array_free (adf_duplex_sources, adf_duplex_sources_length1, (GDestroyNotify) g_free), NULL);
			adf_back_sources = (_vala_array_free (adf_back_sources, adf_back_sources_length1, (GDestroyNotify) g_free), NULL);
			adf_front_sources = (_vala_array_free (adf_front_sources, adf_front_sources_length1, (GDestroyNotify) g_free), NULL);
			adf_sources = (_vala_array_free (adf_sources, adf_sources_length1, (GDestroyNotify) g_free), NULL);
			flatbed_sources = (_vala_array_free (flatbed_sources, flatbed_sources_length1, (GDestroyNotify) g_free), NULL);
		} else {
			if (g_strcmp0 (option->name, "duplex") == 0) {
				if (option->type == SANE_TYPE_BOOL) {
					scanner_set_bool_option (self, self->priv->handle, option, index, job->type == SCAN_TYPE_ADF_BOTH, NULL);
				}
			} else {
				if (g_strcmp0 (option->name, "batch-scan") == 0) {
					if (option->type == SANE_TYPE_BOOL) {
						scanner_set_bool_option (self, self->priv->handle, option, index, job->type != SCAN_TYPE_SINGLE, NULL);
					}
				} else {
					if (g_strcmp0 (option->name, SANE_NAME_BIT_DEPTH) == 0) {
						if (job->depth > 0) {
							scanner_set_int_option (self, self->priv->handle, option, index, job->depth, NULL);
						}
					} else {
						if (g_strcmp0 (option->name, SANE_NAME_SCAN_MODE) == 0) {
							gchar* _tmp46_;
							gchar* _tmp47_;
							gchar* _tmp48_;
							gchar** _tmp49_ = NULL;
							gchar** color_scan_modes;
							gint color_scan_modes_length1;
							gint _color_scan_modes_size_;
							gchar* _tmp50_;
							gchar* _tmp51_;
							gchar* _tmp52_;
							const gchar* _tmp53_ = NULL;
							gchar* _tmp54_;
							gchar* _tmp55_;
							gchar** _tmp56_ = NULL;
							gchar** gray_scan_modes;
							gint gray_scan_modes_length1;
							gint _gray_scan_modes_size_;
							gchar* _tmp57_;
							gchar* _tmp58_;
							gchar* _tmp59_;
							const gchar* _tmp60_ = NULL;
							gchar* _tmp61_;
							gchar* _tmp62_;
							const gchar* _tmp63_ = NULL;
							gchar* _tmp64_;
							gchar* _tmp65_;
							const gchar* _tmp66_ = NULL;
							gchar* _tmp67_;
							gchar* _tmp68_;
							gchar* _tmp69_;
							gchar* _tmp70_;
							gchar* _tmp71_;
							const gchar* _tmp72_ = NULL;
							gchar* _tmp73_;
							gchar* _tmp74_;
							gchar** _tmp75_ = NULL;
							gchar** lineart_scan_modes;
							gint lineart_scan_modes_length1;
							gint _lineart_scan_modes_size_;
							_tmp46_ = g_strdup (SANE_VALUE_SCAN_MODE_COLOR);
							_tmp47_ = g_strdup ("Color");
							_tmp48_ = g_strdup ("24bit Color");
							_tmp49_ = g_new0 (gchar*, 3 + 1);
							_tmp49_[0] = _tmp46_;
							_tmp49_[1] = _tmp47_;
							_tmp49_[2] = _tmp48_;
							color_scan_modes = _tmp49_;
							color_scan_modes_length1 = 3;
							_color_scan_modes_size_ = color_scan_modes_length1;
							_tmp50_ = g_strdup (SANE_VALUE_SCAN_MODE_GRAY);
							_tmp51_ = g_strdup ("Gray");
							_tmp52_ = g_strdup ("Grayscale");
							_tmp53_ = SANE_I18N ("Grayscale");
							_tmp54_ = g_strdup (_tmp53_);
							_tmp55_ = g_strdup ("True Gray");
							_tmp56_ = g_new0 (gchar*, 5 + 1);
							_tmp56_[0] = _tmp50_;
							_tmp56_[1] = _tmp51_;
							_tmp56_[2] = _tmp52_;
							_tmp56_[3] = _tmp54_;
							_tmp56_[4] = _tmp55_;
							gray_scan_modes = _tmp56_;
							gray_scan_modes_length1 = 5;
							_gray_scan_modes_size_ = gray_scan_modes_length1;
							_tmp57_ = g_strdup (SANE_VALUE_SCAN_MODE_LINEART);
							_tmp58_ = g_strdup ("Lineart");
							_tmp59_ = g_strdup ("LineArt");
							_tmp60_ = SANE_I18N ("LineArt");
							_tmp61_ = g_strdup (_tmp60_);
							_tmp62_ = g_strdup ("Black & White");
							_tmp63_ = SANE_I18N ("Black & White");
							_tmp64_ = g_strdup (_tmp63_);
							_tmp65_ = g_strdup ("Binary");
							_tmp66_ = SANE_I18N ("Binary");
							_tmp67_ = g_strdup (_tmp66_);
							_tmp68_ = g_strdup ("Thresholded");
							_tmp69_ = g_strdup (SANE_VALUE_SCAN_MODE_GRAY);
							_tmp70_ = g_strdup ("Gray");
							_tmp71_ = g_strdup ("Grayscale");
							_tmp72_ = SANE_I18N ("Grayscale");
							_tmp73_ = g_strdup (_tmp72_);
							_tmp74_ = g_strdup ("True Gray");
							_tmp75_ = g_new0 (gchar*, 14 + 1);
							_tmp75_[0] = _tmp57_;
							_tmp75_[1] = _tmp58_;
							_tmp75_[2] = _tmp59_;
							_tmp75_[3] = _tmp61_;
							_tmp75_[4] = _tmp62_;
							_tmp75_[5] = _tmp64_;
							_tmp75_[6] = _tmp65_;
							_tmp75_[7] = _tmp67_;
							_tmp75_[8] = _tmp68_;
							_tmp75_[9] = _tmp69_;
							_tmp75_[10] = _tmp70_;
							_tmp75_[11] = _tmp71_;
							_tmp75_[12] = _tmp73_;
							_tmp75_[13] = _tmp74_;
							lineart_scan_modes = _tmp75_;
							lineart_scan_modes_length1 = 14;
							_lineart_scan_modes_size_ = lineart_scan_modes_length1;
							switch (job->scan_mode) {
								case SCAN_MODE_COLOR:
								{
									gboolean _tmp76_;
									_tmp76_ = scanner_set_constrained_string_option (self, self->priv->handle, option, index, color_scan_modes, color_scan_modes_length1, NULL);
									if (!_tmp76_) {
										g_warning ("scanner.vala:994: Unable to set Color mode, please file a bug");
									}
									break;
								}
								case SCAN_MODE_GRAY:
								{
									gboolean _tmp77_;
									_tmp77_ = scanner_set_constrained_string_option (self, self->priv->handle, option, index, gray_scan_modes, gray_scan_modes_length1, NULL);
									if (!_tmp77_) {
										g_warning ("scanner.vala:998: Unable to set Gray mode, please file a bug");
									}
									break;
								}
								case SCAN_MODE_LINEART:
								{
									gboolean _tmp78_;
									_tmp78_ = scanner_set_constrained_string_option (self, self->priv->handle, option, index, lineart_scan_modes, lineart_scan_modes_length1, NULL);
									if (!_tmp78_) {
										g_warning ("scanner.vala:1002: Unable to set Lineart mode, please file a bug");
									}
									break;
								}
								default:
								{
									break;
								}
							}
							lineart_scan_modes = (_vala_array_free (lineart_scan_modes, lineart_scan_modes_length1, (GDestroyNotify) g_free), NULL);
							gray_scan_modes = (_vala_array_free (gray_scan_modes, gray_scan_modes_length1, (GDestroyNotify) g_free), NULL);
							color_scan_modes = (_vala_array_free (color_scan_modes, color_scan_modes_length1, (GDestroyNotify) g_free), NULL);
						} else {
							if (g_strcmp0 (option->name, "compression") == 0) {
								const gchar* _tmp79_ = NULL;
								gchar* _tmp80_;
								const gchar* _tmp81_ = NULL;
								gchar* _tmp82_;
								gchar* _tmp83_;
								gchar* _tmp84_;
								gchar** _tmp85_ = NULL;
								gchar** disable_compression_names;
								gint disable_compression_names_length1;
								gint _disable_compression_names_size_;
								gboolean _tmp86_;
								_tmp79_ = SANE_I18N ("None");
								_tmp80_ = g_strdup (_tmp79_);
								_tmp81_ = SANE_I18N ("none");
								_tmp82_ = g_strdup (_tmp81_);
								_tmp83_ = g_strdup ("None");
								_tmp84_ = g_strdup ("none");
								_tmp85_ = g_new0 (gchar*, 4 + 1);
								_tmp85_[0] = _tmp80_;
								_tmp85_[1] = _tmp82_;
								_tmp85_[2] = _tmp83_;
								_tmp85_[3] = _tmp84_;
								disable_compression_names = _tmp85_;
								disable_compression_names_length1 = 4;
								_disable_compression_names_size_ = disable_compression_names_length1;
								_tmp86_ = scanner_set_constrained_string_option (self, self->priv->handle, option, index, disable_compression_names, disable_compression_names_length1, NULL);
								if (!_tmp86_) {
									g_warning ("scanner.vala:1020: Unable to disable compression, please file a bug");
								}
								disable_compression_names = (_vala_array_free (disable_compression_names, disable_compression_names_length1, (GDestroyNotify) g_free), NULL);
							} else {
								if (g_strcmp0 (option->name, SANE_NAME_SCAN_BR_X) == 0) {
									self->priv->br_x_option_index = index;
								} else {
									if (g_strcmp0 (option->name, SANE_NAME_SCAN_BR_Y) == 0) {
										self->priv->br_y_option_index = index;
									} else {
										if (g_strcmp0 (option->name, SANE_NAME_PAGE_WIDTH) == 0) {
											if (job->page_width > 0.0) {
												if (option->type == SANE_TYPE_FIXED) {
													scanner_set_fixed_option (self, self->priv->handle, option, index, job->page_width / 10.0, NULL);
												} else {
													scanner_set_int_option (self, self->priv->handle, option, index, job->page_width / 10, NULL);
												}
											}
										} else {
											if (g_strcmp0 (option->name, SANE_NAME_PAGE_HEIGHT) == 0) {
												if (job->page_height > 0.0) {
													if (option->type == SANE_TYPE_FIXED) {
														scanner_set_fixed_option (self, self->priv->handle, option, index, job->page_height / 10.0, NULL);
													} else {
														scanner_set_int_option (self, self->priv->handle, option, index, job->page_height / 10, NULL);
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if (g_strcmp0 (self->priv->current_device, "test") == 0) {
		if (g_strcmp0 (option->name, "hand-scanner") == 0) {
			scanner_set_bool_option (self, self->priv->handle, option, index, FALSE, NULL);
		} else {
			if (g_strcmp0 (option->name, "three-pass") == 0) {
				scanner_set_bool_option (self, self->priv->handle, option, index, FALSE, NULL);
			} else {
				if (g_strcmp0 (option->name, "test-picture") == 0) {
					scanner_set_string_option (self, self->priv->handle, option, index, "Color pattern", NULL);
				} else {
					if (g_strcmp0 (option->name, "read-delay") == 0) {
						scanner_set_bool_option (self, self->priv->handle, option, index, TRUE, NULL);
					} else {
						if (g_strcmp0 (option->name, "read-delay-duration") == 0) {
							scanner_set_int_option (self, self->priv->handle, option, index, 200000, NULL);
						}
					}
				}
			}
		}
	}
	_scan_job_unref0 (job);
}


static void scanner_do_complete_document (Scanner* self) {
	NotifyDocumentDone* _tmp0_ = NULL;
	NotifyDocumentDone* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->job_queue = g_list_remove_link (self->priv->job_queue, self->priv->job_queue);
	self->priv->state = SCAN_STATE_IDLE;
	if (self->priv->job_queue != NULL) {
		self->priv->state = SCAN_STATE_OPEN;
		return;
	}
	_tmp0_ = notify_document_done_new ();
	_tmp1_ = _tmp0_;
	scanner_notify (self, (Notify*) _tmp1_);
	_notify_unref0 (_tmp1_);
	scanner_set_scanning (self, FALSE);
}


static void scanner_do_start (Scanner* self) {
	SANE_Status status = 0;
	NotifyExpectPage* _tmp0_ = NULL;
	NotifyExpectPage* _tmp1_;
	SANE_Status _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = notify_expect_page_new ();
	_tmp1_ = _tmp0_;
	scanner_notify (self, (Notify*) _tmp1_);
	_notify_unref0 (_tmp1_);
	_tmp2_ = sane_start (self->priv->handle);
	status = _tmp2_;
	_tmp3_ = sane_status_to_string (status);
	_tmp4_ = _tmp3_;
	g_debug ("scanner.vala:1090: sane_start (page=%d, pass=%d) -> %s", self->priv->page_number, self->priv->pass_number, _tmp4_);
	_g_free0 (_tmp4_);
	if (status == SANE_STATUS_GOOD) {
		self->priv->state = SCAN_STATE_GET_PARAMETERS;
	} else {
		if (status == SANE_STATUS_NO_DOCS) {
			scanner_do_complete_document (self);
		} else {
			const gchar* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			_tmp5_ = sane_strstatus (status);
			g_warning ("scanner.vala:1097: Unable to start device: %s", _tmp5_);
			_tmp6_ = _ ("Unable to start scan");
			scanner_fail_scan (self, (gint) status, _tmp6_);
		}
	}
}


static gchar* sane_frame_to_string (SANE_Frame frame) {
	gchar* result = NULL;
	switch (frame) {
		case SANE_FRAME_GRAY:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("SANE_FRAME_GRAY");
			result = _tmp0_;
			return result;
		}
		case SANE_FRAME_RGB:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("SANE_FRAME_RGB");
			result = _tmp1_;
			return result;
		}
		case SANE_FRAME_RED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("SANE_FRAME_RED");
			result = _tmp2_;
			return result;
		}
		case SANE_FRAME_GREEN:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("SANE_FRAME_GREEN");
			result = _tmp3_;
			return result;
		}
		case SANE_FRAME_BLUE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("SANE_FRAME_BLUE");
			result = _tmp4_;
			return result;
		}
		default:
		{
			gchar* _tmp5_ = NULL;
			_tmp5_ = g_strdup_printf ("SANE_FRAME(%d)", (gint) frame);
			result = _tmp5_;
			return result;
		}
	}
}


static void scanner_do_get_parameters (Scanner* self) {
	SANE_Parameters _tmp0_ = {0};
	SANE_Status _tmp1_;
	SANE_Status status;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	ScanJob* _tmp6_;
	ScanJob* job;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	ScanPageInfo* _tmp10_ = NULL;
	ScanPageInfo* info;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gint _tmp14_ = 0;
	gchar* _tmp15_;
	gint buffer_size;
	guchar* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = sane_get_parameters (self->priv->handle, &_tmp0_);
	self->priv->parameters = _tmp0_;
	status = _tmp1_;
	_tmp2_ = sane_status_to_string (status);
	_tmp3_ = _tmp2_;
	g_debug ("scanner.vala:1107: sane_get_parameters () -> %s", _tmp3_);
	_g_free0 (_tmp3_);
	if (status != SANE_STATUS_GOOD) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = sane_strstatus (status);
		g_warning ("scanner.vala:1110: Unable to get device parameters: %s", _tmp4_);
		_tmp5_ = _ ("Error communicating with scanner");
		scanner_fail_scan (self, (gint) status, _tmp5_);
		return;
	}
	_tmp6_ = _scan_job_ref0 (SCAN_JOB ((ScanJob*) self->priv->job_queue->data));
	job = _tmp6_;
	if (self->priv->parameters.last_frame) {
		_tmp7_ = "SANE_TRUE";
	} else {
		_tmp7_ = "SANE_FALSE";
	}
	_tmp8_ = sane_frame_to_string (self->priv->parameters.format);
	_tmp9_ = _tmp8_;
	g_debug ("scanner.vala:1119: Parameters: format=%s last_frame=%s bytes_per_line=" \
"%d pixels_per_line=%d lines=%d depth=%d", _tmp9_, _tmp7_, self->priv->parameters.bytes_per_line, self->priv->parameters.pixels_per_line, self->priv->parameters.lines, self->priv->parameters.depth);
	_g_free0 (_tmp9_);
	_tmp10_ = scan_page_info_new ();
	info = _tmp10_;
	info->width = self->priv->parameters.pixels_per_line;
	info->height = self->priv->parameters.lines;
	info->depth = self->priv->parameters.depth;
	if (self->priv->parameters.depth == 8) {
		_tmp13_ = self->priv->parameters.format == SANE_FRAME_GRAY;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		_tmp12_ = job->depth == 2;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		_tmp11_ = job->scan_mode == SCAN_MODE_GRAY;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		info->depth = job->depth;
	}
	if (self->priv->parameters.format == SANE_FRAME_GRAY) {
		_tmp14_ = 1;
	} else {
		_tmp14_ = 3;
	}
	info->n_channels = _tmp14_;
	info->dpi = job->dpi;
	_tmp15_ = g_strdup (self->priv->current_device);
	_g_free0 (info->device);
	info->device = _tmp15_;
	if (self->priv->page_number != self->priv->notified_page) {
		NotifyGotPageInfo* _tmp16_ = NULL;
		NotifyGotPageInfo* _tmp17_;
		_tmp16_ = notify_got_page_info_new (info);
		_tmp17_ = _tmp16_;
		scanner_notify (self, (Notify*) _tmp17_);
		_notify_unref0 (_tmp17_);
		self->priv->notified_page = self->priv->page_number;
	}
	buffer_size = self->priv->parameters.bytes_per_line + 1;
	_tmp18_ = g_new0 (guchar, buffer_size);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->buffer = _tmp18_;
	self->priv->buffer_length1 = buffer_size;
	self->priv->_buffer_size_ = self->priv->buffer_length1;
	self->priv->n_used = 0;
	self->priv->line_count = 0;
	self->priv->pass_number = 0;
	self->priv->state = SCAN_STATE_READ;
	_scan_page_info_unref0 (info);
	_scan_job_unref0 (job);
}


static void scanner_do_complete_page (Scanner* self) {
	NotifyPageDone* _tmp0_ = NULL;
	NotifyPageDone* _tmp1_;
	ScanJob* _tmp2_;
	ScanJob* job;
	g_return_if_fail (self != NULL);
	_tmp0_ = notify_page_done_new ();
	_tmp1_ = _tmp0_;
	scanner_notify (self, (Notify*) _tmp1_);
	_notify_unref0 (_tmp1_);
	_tmp2_ = _scan_job_ref0 (SCAN_JOB ((ScanJob*) self->priv->job_queue->data));
	job = _tmp2_;
	if (!self->priv->parameters.last_frame) {
		self->priv->pass_number++;
		self->priv->state = SCAN_STATE_START;
		_scan_job_unref0 (job);
		return;
	}
	if (job->type != SCAN_TYPE_SINGLE) {
		NotifyPageDone* _tmp3_ = NULL;
		NotifyPageDone* _tmp4_;
		self->priv->page_number++;
		self->priv->pass_number = 0;
		_tmp3_ = notify_page_done_new ();
		_tmp4_ = _tmp3_;
		scanner_notify (self, (Notify*) _tmp4_);
		_notify_unref0 (_tmp4_);
		self->priv->state = SCAN_STATE_START;
		_scan_job_unref0 (job);
		return;
	}
	sane_cancel (self->priv->handle);
	g_debug ("scanner.vala:1179: sane_cancel ()");
	scanner_do_complete_document (self);
	_scan_job_unref0 (job);
}


static void scanner_do_read (Scanner* self) {
	ScanJob* _tmp0_;
	ScanJob* job;
	gint n_to_read;
	SANE_Int n_read;
	guchar* b;
	SANE_Int _tmp1_;
	SANE_Status _tmp2_;
	SANE_Status status;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean full_read;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = _scan_job_ref0 (SCAN_JOB ((ScanJob*) self->priv->job_queue->data));
	job = _tmp0_;
	n_to_read = self->priv->buffer_length1 - self->priv->n_used;
	b = (guchar*) self->priv->buffer;
	_tmp2_ = sane_read (self->priv->handle, (guint8*) (b + self->priv->n_used), (SANE_Int) n_to_read, &_tmp1_);
	n_read = _tmp1_;
	status = _tmp2_;
	_tmp3_ = sane_status_to_string (status);
	_tmp4_ = _tmp3_;
	g_debug ("scanner.vala:1194: sane_read (%d) -> (%s, %d)", n_to_read, _tmp4_, (gint) n_read);
	_g_free0 (_tmp4_);
	if (status == SANE_STATUS_EOF) {
		gboolean _tmp5_ = FALSE;
		if (self->priv->parameters.lines > 0) {
			_tmp5_ = self->priv->line_count != self->priv->parameters.lines;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			g_warning ("scanner.vala:1200: Scan completed with %d lines, expected %d lines", self->priv->parameters.lines, self->priv->parameters.lines);
		}
		if (self->priv->n_used > 0) {
			g_warning ("scanner.vala:1202: Scan complete with %d bytes of unused data", self->priv->n_used);
		}
		scanner_do_complete_page (self);
		_scan_job_unref0 (job);
		return;
	}
	if (status != SANE_STATUS_GOOD) {
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = sane_strstatus (status);
		g_warning ("scanner.vala:1210: Unable to read frame from device: %s", _tmp6_);
		_tmp7_ = _ ("Error communicating with scanner");
		scanner_fail_scan (self, (gint) status, _tmp7_);
		_scan_job_unref0 (job);
		return;
	}
	full_read = FALSE;
	if (self->priv->n_used == 0) {
		_tmp8_ = n_read == self->priv->buffer_length1;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		full_read = TRUE;
	}
	self->priv->n_used = self->priv->n_used + n_read;
	if (self->priv->n_used >= self->priv->parameters.bytes_per_line) {
		ScanLine* _tmp9_ = NULL;
		ScanLine* line;
		guchar* _tmp10_;
		gint _tmp11_;
		gint buffer_size;
		guchar* _tmp12_ = NULL;
		gint n_remaining;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		NotifyGotLine* _tmp19_ = NULL;
		NotifyGotLine* _tmp20_;
		_tmp9_ = scan_line_new ();
		line = _tmp9_;
		switch (self->priv->parameters.format) {
			case SANE_FRAME_GRAY:
			{
				line->channel = 0;
				break;
			}
			case SANE_FRAME_RGB:
			{
				line->channel = -1;
				break;
			}
			case SANE_FRAME_RED:
			{
				line->channel = 0;
				break;
			}
			case SANE_FRAME_GREEN:
			{
				line->channel = 1;
				break;
			}
			case SANE_FRAME_BLUE:
			{
				line->channel = 2;
				break;
			}
			default:
			break;
		}
		line->width = self->priv->parameters.pixels_per_line;
		line->depth = self->priv->parameters.depth;
		_tmp10_ = self->priv->buffer;
		_tmp11_ = self->priv->buffer_length1;
		self->priv->buffer = NULL;
		line->data = (g_free (line->data), NULL);
		line->data = _tmp10_;
		line->data_length1 = _tmp11_;
		line->data_length = self->priv->parameters.bytes_per_line;
		line->number = self->priv->line_count;
		line->n_lines = self->priv->n_used / line->data_length;
		self->priv->line_count = self->priv->line_count + line->n_lines;
		buffer_size = self->priv->buffer_length1;
		if (full_read) {
			buffer_size = buffer_size + self->priv->parameters.bytes_per_line;
		}
		_tmp12_ = g_new0 (guchar, buffer_size);
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
		self->priv->buffer = _tmp12_;
		self->priv->buffer_length1 = buffer_size;
		self->priv->_buffer_size_ = self->priv->buffer_length1;
		n_remaining = self->priv->n_used - (line->n_lines * line->data_length);
		self->priv->n_used = 0;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp13_;
				_tmp13_ = TRUE;
				while (TRUE) {
					if (!_tmp13_) {
						i++;
					}
					_tmp13_ = FALSE;
					if (!(i < n_remaining)) {
						break;
					}
					self->priv->buffer[i] = line->data[i + (line->n_lines * line->data_length)];
					self->priv->n_used++;
				}
			}
		}
		if (self->priv->parameters.depth == 8) {
			_tmp16_ = self->priv->parameters.format == SANE_FRAME_GRAY;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			_tmp15_ = job->depth == 2;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			_tmp14_ = job->scan_mode == SCAN_MODE_GRAY;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			guchar block;
			gint write_offset;
			gint block_shift;
			block = (guchar) 0;
			write_offset = 0;
			block_shift = 6;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp17_;
					_tmp17_ = TRUE;
					while (TRUE) {
						gint offset;
						if (!_tmp17_) {
							i++;
						}
						_tmp17_ = FALSE;
						if (!(i < line->n_lines)) {
							break;
						}
						offset = i * line->data_length;
						{
							gint x;
							x = 0;
							{
								gboolean _tmp18_;
								_tmp18_ = TRUE;
								while (TRUE) {
									guchar p;
									guchar sample = '\0';
									if (!_tmp18_) {
										x++;
									}
									_tmp18_ = FALSE;
									if (!(x < line->width)) {
										break;
									}
									p = line->data[offset + x];
									if (p >= 192) {
										sample = (guchar) 3;
									} else {
										if (p >= 128) {
											sample = (guchar) 2;
										} else {
											if (p >= 64) {
												sample = (guchar) 1;
											} else {
												sample = (guchar) 0;
											}
										}
									}
									block = block | (sample << block_shift);
									if (block_shift == 0) {
										line->data[write_offset] = block;
										write_offset++;
										block = (guchar) 0;
										block_shift = 6;
									} else {
										block_shift = block_shift - 2;
									}
								}
							}
						}
						if (block_shift != 6) {
							line->data[write_offset] = block;
							write_offset++;
							block = (guchar) 0;
							block_shift = 6;
						}
					}
				}
			}
			line->data_length = ((line->width * 2) + 7) / 8;
		}
		_tmp19_ = notify_got_line_new (line);
		_tmp20_ = _tmp19_;
		scanner_notify (self, (Notify*) _tmp20_);
		_notify_unref0 (_tmp20_);
		_scan_line_unref0 (line);
	}
	_scan_job_unref0 (job);
}


static void _scanner_authorization_cb_sane_authcallback (const gchar* resource, gchar* username, gchar* password) {
	scanner_authorization_cb (resource, username, -1, password, -1);
}


static gboolean scanner_scan_thread (Scanner* self) {
	gboolean result = FALSE;
	SANE_Int version_code;
	SANE_Int _tmp0_;
	SANE_Status _tmp1_;
	SANE_Status status;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->state = SCAN_STATE_IDLE;
	_tmp1_ = sane_init (&_tmp0_, _scanner_authorization_cb_sane_authcallback);
	version_code = _tmp0_;
	status = _tmp1_;
	_tmp2_ = sane_status_to_string (status);
	_tmp3_ = _tmp2_;
	g_debug ("scanner.vala:1327: sane_init () -> %s", _tmp3_);
	_g_free0 (_tmp3_);
	if (status != SANE_STATUS_GOOD) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = sane_strstatus (status);
		g_warning ("scanner.vala:1330: Unable to initialize SANE backend: %s", _tmp4_);
		result = FALSE;
		return result;
	}
	_tmp5_ = SANE_VERSION_MAJOR (version_code);
	_tmp6_ = SANE_VERSION_MINOR (version_code);
	_tmp7_ = SANE_VERSION_BUILD (version_code);
	g_debug ("scanner.vala:1333: SANE version %d.%d.%d", _tmp5_, _tmp6_, _tmp7_);
	scanner_redetect (self);
	while (TRUE) {
		gboolean _tmp8_;
		_tmp8_ = scanner_handle_requests (self);
		if (!_tmp8_) {
			break;
		}
		switch (self->priv->state) {
			case SCAN_STATE_IDLE:
			{
				if (self->priv->job_queue != NULL) {
					scanner_set_scanning (self, TRUE);
					self->priv->state = SCAN_STATE_OPEN;
				}
				break;
			}
			case SCAN_STATE_REDETECT:
			{
				scanner_do_redetect (self);
				break;
			}
			case SCAN_STATE_OPEN:
			{
				scanner_do_open (self);
				break;
			}
			case SCAN_STATE_GET_OPTION:
			{
				scanner_do_get_option (self);
				break;
			}
			case SCAN_STATE_START:
			{
				scanner_do_start (self);
				break;
			}
			case SCAN_STATE_GET_PARAMETERS:
			{
				scanner_do_get_parameters (self);
				break;
			}
			case SCAN_STATE_READ:
			{
				scanner_do_read (self);
				break;
			}
			default:
			break;
		}
	}
	result = TRUE;
	return result;
}


static gpointer _scanner_scan_thread_gthread_func (gpointer self) {
	gpointer result;
	result = scanner_scan_thread (self);
	return result;
}


void scanner_start (Scanner* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GThread* _tmp0_ = NULL;
		GThread* _tmp1_;
		_tmp0_ = g_thread_create (_scanner_scan_thread_gthread_func, self, TRUE, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		self->priv->thread = _tmp1_;
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("scanner.vala:1384: Unable to create thread: %s", e->message);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void scanner_redetect (Scanner* self) {
	RequestRedetect* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->need_redetect) {
		return;
	}
	self->priv->need_redetect = TRUE;
	g_debug ("scanner.vala:1394: Requesting redetection of scan devices");
	_tmp0_ = request_redetect_new ();
	g_async_queue_push (self->priv->request_queue, (Request*) _tmp0_);
}


gboolean scanner_is_scanning (Scanner* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->scanning;
	return result;
}


static gchar* scanner_get_scan_mode_string (Scanner* self, ScanMode mode) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (mode) {
		case SCAN_MODE_DEFAULT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("ScanMode.DEFAULT");
			result = _tmp0_;
			return result;
		}
		case SCAN_MODE_COLOR:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ScanMode.COLOR");
			result = _tmp1_;
			return result;
		}
		case SCAN_MODE_GRAY:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("ScanMode.GRAY");
			result = _tmp2_;
			return result;
		}
		case SCAN_MODE_LINEART:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("ScanMode.LINEART");
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup_printf ("%d", (gint) mode);
			result = _tmp4_;
			return result;
		}
	}
}


static gchar* scanner_get_scan_type_string (Scanner* self, ScanType type) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (type) {
		case SCAN_TYPE_SINGLE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("ScanType.SINGLE");
			result = _tmp0_;
			return result;
		}
		case SCAN_TYPE_ADF_FRONT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ScanType.ADF_FRONT");
			result = _tmp1_;
			return result;
		}
		case SCAN_TYPE_ADF_BACK:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("ScanType.ADF_BACK");
			result = _tmp2_;
			return result;
		}
		case SCAN_TYPE_ADF_BOTH:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("ScanType.ADF_BOTH");
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup_printf ("%d", (gint) type);
			result = _tmp4_;
			return result;
		}
	}
}


void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	RequestStartScan* _tmp5_ = NULL;
	RequestStartScan* request;
	ScanJob* _tmp6_ = NULL;
	gchar* _tmp7_;
	Request* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (options != NULL);
	if (device != NULL) {
		_tmp0_ = device;
	} else {
		_tmp0_ = "(null)";
	}
	_tmp1_ = scanner_get_scan_mode_string (self, options->scan_mode);
	_tmp2_ = _tmp1_;
	_tmp3_ = scanner_get_scan_type_string (self, options->type);
	_tmp4_ = _tmp3_;
	g_debug ("scanner.vala:1440: Scanner.scan (\"%s\", dpi=%d, scan_mode=%s, depth=%" \
"d, type=%s, paper_width=%d, paper_height=%d)", _tmp0_, options->dpi, _tmp2_, options->depth, _tmp4_, options->paper_width, options->paper_height);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = request_start_scan_new ();
	request = _tmp5_;
	_tmp6_ = scan_job_new ();
	_scan_job_unref0 (request->job);
	request->job = _tmp6_;
	_tmp7_ = g_strdup (device);
	_g_free0 (request->job->device);
	request->job->device = _tmp7_;
	request->job->dpi = (gdouble) options->dpi;
	request->job->scan_mode = options->scan_mode;
	request->job->depth = options->depth;
	request->job->type = options->type;
	request->job->page_width = options->paper_width;
	request->job->page_height = options->paper_height;
	_tmp8_ = _request_ref0 ((Request*) request);
	g_async_queue_push (self->priv->request_queue, _tmp8_);
	_request_unref0 (request);
}


void scanner_cancel (Scanner* self) {
	RequestCancel* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = request_cancel_new ();
	g_async_queue_push (self->priv->request_queue, (Request*) _tmp0_);
}


void scanner_free (Scanner* self) {
	RequestQuit* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("scanner.vala:1462: Stopping scan thread");
	_tmp0_ = request_quit_new ();
	g_async_queue_push (self->priv->request_queue, (Request*) _tmp0_);
	if (self->priv->thread != NULL) {
		g_thread_join (self->priv->thread);
	}
	sane_exit ();
	g_debug ("scanner.vala:1470: sane_exit ()");
}


static void g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__SCAN_PAGE_INFO) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__SCAN_PAGE_INFO callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__SCAN_PAGE_INFO) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_scan_page_info (param_values + 1), data2);
}


static void g_cclosure_user_marshal_VOID__SCAN_LINE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__SCAN_LINE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__SCAN_LINE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__SCAN_LINE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_scan_line (param_values + 1), data2);
}


static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void value_scanner_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_scanner_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		scanner_unref (value->data[0].v_pointer);
	}
}


static void value_scanner_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_scanner_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_scanner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Scanner* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_scanner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Scanner** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_scanner (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}


void value_set_scanner (GValue* value, gpointer v_object) {
	Scanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scanner_unref (old);
	}
}


void value_take_scanner (GValue* value, gpointer v_object) {
	Scanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scanner_unref (old);
	}
}


static void scanner_class_init (ScannerClass * klass) {
	scanner_parent_class = g_type_class_peek_parent (klass);
	SCANNER_CLASS (klass)->finalize = scanner_finalize;
	g_type_class_add_private (klass, sizeof (ScannerPrivate));
	g_signal_new ("update_devices", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	g_signal_new ("request_authorization", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("expect_page", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("got_page_info", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO, G_TYPE_NONE, 1, TYPE_SCAN_PAGE_INFO);
	g_signal_new ("got_line", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__SCAN_LINE, G_TYPE_NONE, 1, TYPE_SCAN_LINE);
	g_signal_new ("scan_failed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_STRING, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_STRING);
	g_signal_new ("page_done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("document_done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("scanning_changed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void scanner_instance_init (Scanner * self) {
	self->priv = SCANNER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void scanner_finalize (Scanner* obj) {
	Scanner * self;
	self = SCANNER (obj);
	_g_async_queue_unref0 (self->priv->request_queue);
	_g_async_queue_unref0 (self->priv->notify_queue);
	_g_async_queue_unref0 (self->priv->authorize_queue);
	_g_free0 (self->priv->default_device);
	__g_list_free__scan_job_unref0_0 (self->priv->job_queue);
	_g_free0 (self->priv->current_device);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
}


GType scanner_get_type (void) {
	static volatile gsize scanner_type_id__volatile = 0;
	if (g_once_init_enter (&scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scanner_init, value_scanner_free_value, value_scanner_copy_value, value_scanner_peek_pointer, "p", value_scanner_collect_value, "p", value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scanner), 0, (GInstanceInitFunc) scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scanner_type_id;
		scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Scanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scanner_type_id__volatile, scanner_type_id);
	}
	return scanner_type_id__volatile;
}


gpointer scanner_ref (gpointer instance) {
	Scanner* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void scanner_unref (gpointer instance) {
	Scanner* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



