/* page-view.c generated by valac 0.20.1, the Vala compiler
 * generated from page-view.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <string.h>
#include <stdlib.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CROP_LOCATION (crop_location_get_type ())

#define TYPE_PAGE_VIEW (page_view_get_type ())
#define PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_VIEW, PageView))
#define PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_VIEW, PageViewClass))
#define IS_PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_VIEW))
#define IS_PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_VIEW))
#define PAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_VIEW, PageViewClass))

typedef struct _PageView PageView;
typedef struct _PageViewClass PageViewClass;
typedef struct _PageViewPrivate PageViewPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecPageView ParamSpecPageView;

typedef enum  {
	CROP_LOCATION_NONE = 0,
	CROP_LOCATION_MIDDLE,
	CROP_LOCATION_TOP,
	CROP_LOCATION_BOTTOM,
	CROP_LOCATION_LEFT,
	CROP_LOCATION_RIGHT,
	CROP_LOCATION_TOP_LEFT,
	CROP_LOCATION_TOP_RIGHT,
	CROP_LOCATION_BOTTOM_LEFT,
	CROP_LOCATION_BOTTOM_RIGHT
} CropLocation;

struct _PageView {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PageViewPrivate * priv;
};

struct _PageViewClass {
	GTypeClass parent_class;
	void (*finalize) (PageView *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _PageViewPrivate {
	Page* _page;
	GdkPixbuf* image;
	gboolean selected_;
	gint border_width;
	gboolean update_image;
	ScanDirection scan_direction;
	gint scan_line;
	gint width;
	gint height;
	gint _x_offset;
	gint _y_offset;
	CropLocation crop_location;
	gdouble selected_crop_px;
	gdouble selected_crop_py;
	gint selected_crop_x;
	gint selected_crop_y;
	gint selected_crop_w;
	gint selected_crop_h;
	GdkCursorType _cursor;
	gint animate_n_segments;
	gint animate_segment;
	guint animate_timeout;
};

struct _ParamSpecPageView {
	GParamSpec parent_instance;
};


static gpointer page_view_parent_class = NULL;

GType crop_location_get_type (void) G_GNUC_CONST;
gpointer page_view_ref (gpointer instance);
void page_view_unref (gpointer instance);
GParamSpec* param_spec_page_view (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page_view (GValue* value, gpointer v_object);
void value_take_page_view (GValue* value, gpointer v_object);
gpointer value_get_page_view (const GValue* value);
GType page_view_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
GType scan_direction_get_type (void) G_GNUC_CONST;
#define PAGE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PAGE_VIEW, PageViewPrivate))
enum  {
	PAGE_VIEW_DUMMY_PROPERTY
};
Page* page_view_get_page (PageView* self);
static void page_view_page_pixels_changed_cb (PageView* self, Page* p);
static void _page_view_page_pixels_changed_cb_page_pixels_changed (Page* _sender, gpointer self);
static void page_view_page_size_changed_cb (PageView* self, Page* p);
static void _page_view_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self);
static void page_view_page_overlay_changed_cb (PageView* self, Page* p);
static void _page_view_page_overlay_changed_cb_page_crop_changed (Page* _sender, gpointer self);
static void _page_view_page_overlay_changed_cb_page_scan_line_changed (Page* _sender, gpointer self);
static void page_view_scan_direction_changed_cb (PageView* self, Page* p);
static void _page_view_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self);
PageView* page_view_new (Page* page);
PageView* page_view_construct (GType object_type, Page* page);
static void page_view_set_page (PageView* self, Page* value);
static guchar page_view_get_sample (PageView* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint sample);
static void page_view_get_pixel (PageView* self, Page* page, gint x, gint y, guchar* pixel, int pixel_length1);
ScanDirection page_get_scan_direction (Page* self);
gint page_get_scan_width (Page* self);
gint page_get_scan_height (Page* self);
gint page_get_depth (Page* self);
gint page_get_n_channels (Page* self);
guchar* page_get_pixels (Page* self, int* result_length1);
gint page_get_rowstride (Page* self);
static void page_view_set_pixel (PageView* self, Page* page, gdouble l, gdouble r, gdouble t, gdouble b, guchar* output, int output_length1, gint offset);
static void page_view_update_preview (PageView* self, Page* page, GdkPixbuf** output_image, gint output_width, gint output_height, ScanDirection scan_direction, gint old_scan_line, gint scan_line);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gboolean page_get_has_data (Page* self);
static gint page_view_get_preview_width (PageView* self);
static gint page_view_get_preview_height (PageView* self);
static void page_view_update_page_view (PageView* self);
gint page_get_scan_line (Page* self);
static gint page_view_page_to_screen_x (PageView* self, gint x);
static gint page_view_page_to_screen_y (PageView* self, gint y);
static gint page_view_screen_to_page_x (PageView* self, gint x);
static gint page_view_screen_to_page_y (PageView* self, gint y);
static CropLocation page_view_get_crop_location (PageView* self, gint x, gint y);
gboolean page_get_has_crop (Page* self);
gint page_get_crop_x (Page* self);
gint page_get_crop_y (Page* self);
gint page_get_crop_width (Page* self);
gint page_get_crop_height (Page* self);
const gchar* page_get_crop_name (Page* self);
void page_view_button_press (PageView* self, gint x, gint y);
void page_view_motion (PageView* self, gint x, gint y);
static void page_view_set_cursor (PageView* self, GdkCursorType value);
void page_move_crop (Page* self, gint x, gint y);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_view_button_release (PageView* self, gint x, gint y);
static gboolean page_view_animation_cb (PageView* self);
static void page_view_update_animation (PageView* self);
gboolean page_get_is_scanning (Page* self);
static gboolean _page_view_animation_cb_gsource_func (gpointer self);
void page_view_render (PageView* self, cairo_t* context);
gint page_view_get_x_offset (PageView* self);
gint page_view_get_y_offset (PageView* self);
void page_view_set_width (PageView* self, gint width);
void page_view_set_height (PageView* self, gint height);
gint page_view_get_width (PageView* self);
gint page_view_get_height (PageView* self);
gboolean page_view_get_selected (PageView* self);
void page_view_set_selected (PageView* self, gboolean value);
void page_view_set_x_offset (PageView* self, gint value);
void page_view_set_y_offset (PageView* self, gint value);
GdkCursorType page_view_get_cursor (PageView* self);
static void page_view_finalize (PageView* obj);


GType crop_location_get_type (void) {
	static volatile gsize crop_location_type_id__volatile = 0;
	if (g_once_init_enter (&crop_location_type_id__volatile)) {
		static const GEnumValue values[] = {{CROP_LOCATION_NONE, "CROP_LOCATION_NONE", "none"}, {CROP_LOCATION_MIDDLE, "CROP_LOCATION_MIDDLE", "middle"}, {CROP_LOCATION_TOP, "CROP_LOCATION_TOP", "top"}, {CROP_LOCATION_BOTTOM, "CROP_LOCATION_BOTTOM", "bottom"}, {CROP_LOCATION_LEFT, "CROP_LOCATION_LEFT", "left"}, {CROP_LOCATION_RIGHT, "CROP_LOCATION_RIGHT", "right"}, {CROP_LOCATION_TOP_LEFT, "CROP_LOCATION_TOP_LEFT", "top-left"}, {CROP_LOCATION_TOP_RIGHT, "CROP_LOCATION_TOP_RIGHT", "top-right"}, {CROP_LOCATION_BOTTOM_LEFT, "CROP_LOCATION_BOTTOM_LEFT", "bottom-left"}, {CROP_LOCATION_BOTTOM_RIGHT, "CROP_LOCATION_BOTTOM_RIGHT", "bottom-right"}, {0, NULL, NULL}};
		GType crop_location_type_id;
		crop_location_type_id = g_enum_register_static ("CropLocation", values);
		g_once_init_leave (&crop_location_type_id__volatile, crop_location_type_id);
	}
	return crop_location_type_id__volatile;
}


static void _page_view_page_pixels_changed_cb_page_pixels_changed (Page* _sender, gpointer self) {
#line 97 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_page_pixels_changed_cb (self, _sender);
#line 222 "page-view.c"
}


static void _page_view_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self) {
#line 98 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_page_size_changed_cb (self, _sender);
#line 229 "page-view.c"
}


static void _page_view_page_overlay_changed_cb_page_crop_changed (Page* _sender, gpointer self) {
#line 99 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_page_overlay_changed_cb (self, _sender);
#line 236 "page-view.c"
}


static void _page_view_page_overlay_changed_cb_page_scan_line_changed (Page* _sender, gpointer self) {
#line 100 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_page_overlay_changed_cb (self, _sender);
#line 243 "page-view.c"
}


static void _page_view_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_scan_direction_changed_cb (self, _sender);
#line 250 "page-view.c"
}


PageView* page_view_construct (GType object_type, Page* page) {
	PageView* self = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	Page* _tmp5_;
#line 85 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (page != NULL, NULL);
#line 85 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self = (PageView*) g_type_create_instance (object_type);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = page;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_set_page (self, _tmp0_);
#line 88 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = page;
#line 88 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_connect (_tmp1_, "pixels-changed", (GCallback) _page_view_page_pixels_changed_cb_page_pixels_changed, self);
#line 89 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page;
#line 89 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_connect (_tmp2_, "size-changed", (GCallback) _page_view_page_size_changed_cb_page_size_changed, self);
#line 90 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = page;
#line 90 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_connect (_tmp3_, "crop-changed", (GCallback) _page_view_page_overlay_changed_cb_page_crop_changed, self);
#line 91 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = page;
#line 91 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_connect (_tmp4_, "scan-line-changed", (GCallback) _page_view_page_overlay_changed_cb_page_scan_line_changed, self);
#line 92 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = page;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_connect (_tmp5_, "scan-direction-changed", (GCallback) _page_view_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 85 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return self;
#line 292 "page-view.c"
}


PageView* page_view_new (Page* page) {
#line 85 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return page_view_construct (TYPE_PAGE_VIEW, page);
#line 299 "page-view.c"
}


static guchar page_view_get_sample (PageView* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint sample) {
	guchar result = '\0';
#line 104 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 107 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = (guchar) 0xFF;
#line 107 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 311 "page-view.c"
}


static void page_view_get_pixel (PageView* self, Page* page, gint x, gint y, guchar* pixel, int pixel_length1) {
	Page* _tmp0_;
	ScanDirection _tmp1_;
	ScanDirection _tmp2_;
	Page* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint depth;
	Page* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint n_channels;
	Page* _tmp29_;
	gint _tmp30_ = 0;
	guchar* _tmp31_ = NULL;
	guchar* pixels;
	gint pixels_length1;
	gint _pixels_size_;
	Page* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gint offset;
	gboolean _tmp36_ = FALSE;
	gint _tmp37_;
	gboolean _tmp39_;
	guchar* _tmp110_;
	gint _tmp110__length1;
	guchar* _tmp111_;
	gint _tmp111__length1;
	gint _tmp112_;
	gint _tmp113_;
	gint _tmp114_;
	gint _tmp115_;
	gint _tmp116_;
	guchar _tmp117_ = '\0';
	guchar _tmp118_;
	guchar* _tmp119_;
	gint _tmp119__length1;
	guchar* _tmp120_;
	gint _tmp120__length1;
	gint _tmp121_;
	gint _tmp122_;
	gint _tmp123_;
	gint _tmp124_;
	gint _tmp125_;
	guchar _tmp126_ = '\0';
	guchar _tmp127_;
	guchar* _tmp128_;
	gint _tmp128__length1;
	guchar* _tmp129_;
	gint _tmp129__length1;
	gint _tmp130_;
	gint _tmp131_;
	gint _tmp132_;
	gint _tmp133_;
	gint _tmp134_;
	guchar _tmp135_ = '\0';
	guchar _tmp136_;
#line 110 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 110 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (page != NULL);
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = page;
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = page_get_scan_direction (_tmp0_);
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = _tmp1_;
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	switch (_tmp2_) {
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 388 "page-view.c"
		{
#line 115 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 392 "page-view.c"
		}
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 396 "page-view.c"
		{
			Page* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			Page* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp3_ = page;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp4_ = page_get_scan_width (_tmp3_);
#line 117 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp5_ = _tmp4_;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp6_ = x;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			x = (_tmp5_ - _tmp6_) - 1;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp7_ = page;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp8_ = page_get_scan_height (_tmp7_);
#line 118 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp9_ = _tmp8_;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp10_ = y;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			y = (_tmp9_ - _tmp10_) - 1;
#line 119 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 428 "page-view.c"
		}
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 432 "page-view.c"
		{
			gint _tmp11_;
			gint t;
			Page* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
#line 121 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp11_ = x;
#line 121 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			t = _tmp11_;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp12_ = page;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp13_ = page_get_scan_width (_tmp12_);
#line 122 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp14_ = _tmp13_;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp15_ = y;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			x = (_tmp14_ - _tmp15_) - 1;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp16_ = t;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			y = _tmp16_;
#line 124 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 461 "page-view.c"
		}
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 465 "page-view.c"
		{
			gint _tmp17_;
			gint t;
			gint _tmp18_;
			Page* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
#line 126 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp17_ = x;
#line 126 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			t = _tmp17_;
#line 127 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp18_ = y;
#line 127 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			x = _tmp18_;
#line 128 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp19_ = page;
#line 128 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp20_ = page_get_scan_height (_tmp19_);
#line 128 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp21_ = _tmp20_;
#line 128 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp22_ = t;
#line 128 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			y = (_tmp21_ - _tmp22_) - 1;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 494 "page-view.c"
		}
		default:
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		break;
#line 499 "page-view.c"
	}
#line 132 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp23_ = page;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp24_ = page_get_depth (_tmp23_);
#line 132 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp25_ = _tmp24_;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	depth = _tmp25_;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp26_ = page;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp27_ = page_get_n_channels (_tmp26_);
#line 133 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp28_ = _tmp27_;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	n_channels = _tmp28_;
#line 134 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp29_ = page;
#line 134 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp31_ = page_get_pixels (_tmp29_, &_tmp30_);
#line 134 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	pixels = _tmp31_;
#line 134 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	pixels_length1 = _tmp30_;
#line 134 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_pixels_size_ = pixels_length1;
#line 135 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp32_ = page;
#line 135 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp33_ = page_get_rowstride (_tmp32_);
#line 135 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp34_ = _tmp33_;
#line 135 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp35_ = y;
#line 135 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	offset = _tmp34_ * _tmp35_;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp37_ = depth;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp37_ == 8) {
#line 541 "page-view.c"
		gint _tmp38_;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp38_ = n_channels;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp36_ = _tmp38_ == 3;
#line 547 "page-view.c"
	} else {
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp36_ = FALSE;
#line 551 "page-view.c"
	}
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp39_ = _tmp36_;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp39_) {
#line 557 "page-view.c"
		gint _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint o;
		guchar* _tmp43_;
		gint _tmp43__length1;
		guchar* _tmp44_;
		gint _tmp44__length1;
		gint _tmp45_;
		guchar _tmp46_;
		guchar _tmp47_;
		guchar* _tmp48_;
		gint _tmp48__length1;
		guchar* _tmp49_;
		gint _tmp49__length1;
		gint _tmp50_;
		guchar _tmp51_;
		guchar _tmp52_;
		guchar* _tmp53_;
		gint _tmp53__length1;
		guchar* _tmp54_;
		gint _tmp54__length1;
		gint _tmp55_;
		guchar _tmp56_;
		guchar _tmp57_;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp40_ = offset;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp41_ = x;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp42_ = n_channels;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		o = _tmp40_ + (_tmp41_ * _tmp42_);
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp43_ = pixel;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp43__length1 = pixel_length1;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp44_ = pixels;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp44__length1 = pixels_length1;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp45_ = o;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp46_ = _tmp44_[_tmp45_];
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp43_[0] = _tmp46_;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp47_ = _tmp43_[0];
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp48_ = pixel;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp48__length1 = pixel_length1;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp49_ = pixels;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp49__length1 = pixels_length1;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp50_ = o;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp51_ = _tmp49_[_tmp50_ + 1];
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp48_[1] = _tmp51_;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp52_ = _tmp48_[1];
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp53_ = pixel;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp53__length1 = pixel_length1;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp54_ = pixels;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp54__length1 = pixels_length1;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp55_ = o;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp56_ = _tmp54_[_tmp55_ + 2];
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp53_[2] = _tmp56_;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp57_ = _tmp53_[2];
#line 144 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 641 "page-view.c"
	} else {
		gboolean _tmp58_ = FALSE;
		gint _tmp59_;
		gboolean _tmp61_;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp59_ = depth;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp59_ == 8) {
#line 650 "page-view.c"
			gint _tmp60_;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp60_ = n_channels;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp58_ = _tmp60_ == 1;
#line 656 "page-view.c"
		} else {
#line 146 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp58_ = FALSE;
#line 660 "page-view.c"
		}
#line 146 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp61_ = _tmp58_;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp61_) {
#line 666 "page-view.c"
			guchar* _tmp62_;
			gint _tmp62__length1;
			guchar* _tmp63_;
			gint _tmp63__length1;
			guchar* _tmp64_;
			gint _tmp64__length1;
			guchar* _tmp65_;
			gint _tmp65__length1;
			gint _tmp66_;
			gint _tmp67_;
			guchar _tmp68_;
			guchar _tmp69_;
			guchar _tmp70_;
			guchar _tmp71_;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp62_ = pixel;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp62__length1 = pixel_length1;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp63_ = pixel;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp63__length1 = pixel_length1;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp64_ = pixel;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp64__length1 = pixel_length1;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp65_ = pixels;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp65__length1 = pixels_length1;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp66_ = offset;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp67_ = x;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp68_ = _tmp65_[_tmp66_ + _tmp67_];
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp64_[2] = _tmp68_;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp69_ = _tmp64_[2];
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp63_[1] = _tmp69_;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp70_ = _tmp63_[1];
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp62_[0] = _tmp70_;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp71_ = _tmp62_[0];
#line 149 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			return;
#line 717 "page-view.c"
		} else {
			gboolean _tmp72_ = FALSE;
			gint _tmp73_;
			gboolean _tmp75_;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp73_ = depth;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			if (_tmp73_ == 1) {
#line 726 "page-view.c"
				gint _tmp74_;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp74_ = n_channels;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp72_ = _tmp74_ == 1;
#line 732 "page-view.c"
			} else {
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp72_ = FALSE;
#line 736 "page-view.c"
			}
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp75_ = _tmp72_;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			if (_tmp75_) {
#line 742 "page-view.c"
				gint _tmp76_;
				gint _tmp77_;
				gint o;
				gint _tmp78_ = 0;
				guchar* _tmp79_;
				gint _tmp79__length1;
				gint _tmp80_;
				guchar _tmp81_;
				gint _tmp82_;
				guchar* _tmp83_;
				gint _tmp83__length1;
				guchar* _tmp84_;
				gint _tmp84__length1;
				guchar* _tmp85_;
				gint _tmp85__length1;
				gint _tmp86_;
				guchar _tmp87_;
				guchar _tmp88_;
				guchar _tmp89_;
#line 155 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp76_ = offset;
#line 155 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp77_ = x;
#line 155 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				o = _tmp76_ + (_tmp77_ / 8);
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp79_ = pixels;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp79__length1 = pixels_length1;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp80_ = o;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp81_ = _tmp79_[_tmp80_];
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp82_ = x;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (((gint) (_tmp81_ & (0x80 >> (_tmp82_ % 8)))) != 0) {
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp78_ = 0x00;
#line 782 "page-view.c"
				} else {
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp78_ = 0xFF;
#line 786 "page-view.c"
				}
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp83_ = pixel;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp83__length1 = pixel_length1;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp84_ = pixel;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp84__length1 = pixel_length1;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp85_ = pixel;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp85__length1 = pixel_length1;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp86_ = _tmp78_;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp85_[2] = (guchar) _tmp86_;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp87_ = _tmp85_[2];
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp84_[1] = _tmp87_;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp88_ = _tmp84_[1];
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp83_[0] = _tmp88_;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp89_ = _tmp83_[0];
#line 157 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				return;
#line 816 "page-view.c"
			} else {
				gboolean _tmp90_ = FALSE;
				gint _tmp91_;
				gboolean _tmp93_;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp91_ = depth;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (_tmp91_ == 2) {
#line 825 "page-view.c"
					gint _tmp92_;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp92_ = n_channels;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp90_ = _tmp92_ == 1;
#line 831 "page-view.c"
				} else {
#line 161 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp90_ = FALSE;
#line 835 "page-view.c"
				}
#line 161 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp93_ = _tmp90_;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (_tmp93_) {
#line 841 "page-view.c"
					gint _tmp94_[4] = {0};
					gint block_shift[4];
					gint _tmp95_;
					gint _tmp96_;
					gint o;
					guchar* _tmp97_;
					gint _tmp97__length1;
					gint _tmp98_;
					guchar _tmp99_;
					gint _tmp100_;
					gint _tmp101_;
					gint sample;
					gint _tmp102_;
					guchar* _tmp103_;
					gint _tmp103__length1;
					guchar* _tmp104_;
					gint _tmp104__length1;
					guchar* _tmp105_;
					gint _tmp105__length1;
					gint _tmp106_;
					guchar _tmp107_;
					guchar _tmp108_;
					guchar _tmp109_;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp94_[0] = 6;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp94_[1] = 4;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp94_[2] = 2;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp94_[3] = 0;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					memcpy (block_shift, _tmp94_, 4 * sizeof (gint));
#line 165 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp95_ = offset;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp96_ = x;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					o = _tmp95_ + (_tmp96_ / 4);
#line 166 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp97_ = pixels;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp97__length1 = pixels_length1;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp98_ = o;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp99_ = _tmp97_[_tmp98_];
#line 166 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp100_ = x;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp101_ = block_shift[_tmp100_ % 4];
#line 166 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					sample = (_tmp99_ >> _tmp101_) & 0x3;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp102_ = sample;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					sample = (_tmp102_ * 255) / 3;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp103_ = pixel;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp103__length1 = pixel_length1;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp104_ = pixel;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp104__length1 = pixel_length1;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp105_ = pixel;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp105__length1 = pixel_length1;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp106_ = sample;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp105_[2] = (guchar) _tmp106_;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp107_ = _tmp105_[2];
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp104_[1] = _tmp107_;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp108_ = _tmp104_[1];
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp103_[0] = _tmp108_;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp109_ = _tmp103_[0];
#line 170 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					return;
#line 927 "page-view.c"
				}
			}
		}
	}
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp110_ = pixel;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp110__length1 = pixel_length1;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp111_ = pixels;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp111__length1 = pixels_length1;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp112_ = offset;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp113_ = x;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp114_ = depth;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp115_ = x;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp116_ = n_channels;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp117_ = page_view_get_sample (self, _tmp111_, _tmp111__length1, _tmp112_, _tmp113_, _tmp114_, _tmp115_ * _tmp116_);
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp110_[0] = _tmp117_;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp118_ = _tmp110_[0];
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp119_ = pixel;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp119__length1 = pixel_length1;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp120_ = pixels;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp120__length1 = pixels_length1;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp121_ = offset;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp122_ = x;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp123_ = depth;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp124_ = x;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp125_ = n_channels;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp126_ = page_view_get_sample (self, _tmp120_, _tmp120__length1, _tmp121_, _tmp122_, _tmp123_, (_tmp124_ * _tmp125_) + 1);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp119_[1] = _tmp126_;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp127_ = _tmp119_[1];
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp128_ = pixel;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp128__length1 = pixel_length1;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp129_ = pixels;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp129__length1 = pixels_length1;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp130_ = offset;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp131_ = x;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp132_ = depth;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp133_ = x;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp134_ = n_channels;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp135_ = page_view_get_sample (self, _tmp129_, _tmp129__length1, _tmp130_, _tmp131_, _tmp132_, (_tmp133_ * _tmp134_) + 2);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp128_[2] = _tmp135_;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp136_ = _tmp128_[2];
#line 1004 "page-view.c"
}


static void page_view_set_pixel (PageView* self, Page* page, gdouble l, gdouble r, gdouble t, gdouble b, guchar* output, int output_length1, gint offset) {
	gdouble _tmp0_;
	gint L;
	gint _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp4_;
	gint R;
	gdouble _tmp5_;
	gint T;
	gint _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp9_;
	gint B;
	gdouble red;
	gdouble green;
	gdouble blue;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gboolean _tmp16_;
	gboolean _tmp23_;
	gboolean _tmp293_ = FALSE;
	gdouble _tmp294_;
	gint _tmp295_;
	gboolean _tmp298_;
	gboolean _tmp320_ = FALSE;
	gdouble _tmp321_;
	gint _tmp322_;
	gboolean _tmp325_;
	gboolean _tmp347_ = FALSE;
	gdouble _tmp348_;
	gint _tmp349_;
	gboolean _tmp352_;
	gboolean _tmp374_ = FALSE;
	gdouble _tmp375_;
	gint _tmp376_;
	gboolean _tmp379_;
	gdouble _tmp401_;
	gdouble _tmp402_;
	gdouble _tmp403_;
	gdouble _tmp404_;
	gdouble scale;
	guchar* _tmp405_;
	gint _tmp405__length1;
	gint _tmp406_;
	gdouble _tmp407_;
	gdouble _tmp408_;
	guchar _tmp409_;
	guchar* _tmp410_;
	gint _tmp410__length1;
	gint _tmp411_;
	gdouble _tmp412_;
	gdouble _tmp413_;
	guchar _tmp414_;
	guchar* _tmp415_;
	gint _tmp415__length1;
	gint _tmp416_;
	gdouble _tmp417_;
	gdouble _tmp418_;
	guchar _tmp419_;
#line 179 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 179 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (page != NULL);
#line 225 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = l;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	L = (gint) _tmp0_;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = L;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = l;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (((gdouble) _tmp1_) != _tmp2_) {
#line 1083 "page-view.c"
		gint _tmp3_;
#line 227 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp3_ = L;
#line 227 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		L = _tmp3_ + 1;
#line 1089 "page-view.c"
	}
#line 228 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = r;
#line 228 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	R = (gint) _tmp4_;
#line 229 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = t;
#line 229 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	T = (gint) _tmp5_;
#line 230 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = T;
#line 230 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp7_ = t;
#line 230 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (((gdouble) _tmp6_) != _tmp7_) {
#line 1105 "page-view.c"
		gint _tmp8_;
#line 231 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp8_ = T;
#line 231 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		T = _tmp8_ + 1;
#line 1111 "page-view.c"
	}
#line 232 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp9_ = b;
#line 232 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	B = (gint) _tmp9_;
#line 234 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	red = 0.0;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	green = 0.0;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	blue = 0.0;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = r;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = l;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if ((_tmp12_ - _tmp13_) <= 1.0) {
#line 1129 "page-view.c"
		gdouble _tmp14_;
		gdouble _tmp15_;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp14_ = r;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp15_ = l;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = ((gint) _tmp14_) == ((gint) _tmp15_);
#line 1138 "page-view.c"
	} else {
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = FALSE;
#line 1142 "page-view.c"
	}
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp16_ = _tmp11_;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp16_) {
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp10_ = TRUE;
#line 1150 "page-view.c"
	} else {
		gboolean _tmp17_ = FALSE;
		gdouble _tmp18_;
		gdouble _tmp19_;
		gboolean _tmp22_;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp18_ = b;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp19_ = t;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if ((_tmp18_ - _tmp19_) <= 1.0) {
#line 1162 "page-view.c"
			gdouble _tmp20_;
			gdouble _tmp21_;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp20_ = b;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp21_ = t;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp17_ = ((gint) _tmp20_) == ((gint) _tmp21_);
#line 1171 "page-view.c"
		} else {
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp17_ = FALSE;
#line 1175 "page-view.c"
		}
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp22_ = _tmp17_;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp10_ = _tmp22_;
#line 1181 "page-view.c"
	}
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp23_ = _tmp10_;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp23_) {
#line 1187 "page-view.c"
		gboolean _tmp24_ = FALSE;
		gdouble _tmp25_;
		gdouble _tmp26_;
		gboolean _tmp29_;
		gint _tmp45_;
		gint _tmp46_;
		gdouble _tmp173_;
		gdouble _tmp174_;
		gdouble _tmp175_;
		gdouble _tmp176_;
		gdouble scale;
		guchar* _tmp177_;
		gint _tmp177__length1;
		gint _tmp178_;
		gdouble _tmp179_;
		gdouble _tmp180_;
		guchar _tmp181_;
		guchar* _tmp182_;
		gint _tmp182__length1;
		gint _tmp183_;
		gdouble _tmp184_;
		gdouble _tmp185_;
		guchar _tmp186_;
		guchar* _tmp187_;
		gint _tmp187__length1;
		gint _tmp188_;
		gdouble _tmp189_;
		gdouble _tmp190_;
		guchar _tmp191_;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp25_ = l;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp26_ = r;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (((gint) _tmp25_) == ((gint) _tmp26_)) {
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp24_ = TRUE;
#line 1225 "page-view.c"
		} else {
			gdouble _tmp27_;
			gdouble _tmp28_;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp27_ = t;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp28_ = b;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp24_ = ((gint) _tmp27_) == ((gint) _tmp28_);
#line 1235 "page-view.c"
		}
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp29_ = _tmp24_;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp29_) {
#line 1241 "page-view.c"
			guchar p[3] = {0};
			Page* _tmp30_;
			gdouble _tmp31_;
			gdouble _tmp32_;
			guchar* _tmp33_;
			gint _tmp33__length1;
			gint _tmp34_;
			guchar _tmp35_;
			guchar _tmp36_;
			guchar* _tmp37_;
			gint _tmp37__length1;
			gint _tmp38_;
			guchar _tmp39_;
			guchar _tmp40_;
			guchar* _tmp41_;
			gint _tmp41__length1;
			gint _tmp42_;
			guchar _tmp43_;
			guchar _tmp44_;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp30_ = page;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp31_ = l;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp32_ = t;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			page_view_get_pixel (self, _tmp30_, (gint) _tmp31_, (gint) _tmp32_, p, 3);
#line 254 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp33_ = output;
#line 254 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp33__length1 = output_length1;
#line 254 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp34_ = offset;
#line 254 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp35_ = p[0];
#line 254 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp33_[_tmp34_] = _tmp35_;
#line 254 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp36_ = _tmp33_[_tmp34_];
#line 255 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp37_ = output;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp37__length1 = output_length1;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp38_ = offset;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp39_ = p[1];
#line 255 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp37_[_tmp38_ + 1] = _tmp39_;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp40_ = _tmp37_[_tmp38_ + 1];
#line 256 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp41_ = output;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp41__length1 = output_length1;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp42_ = offset;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp43_ = p[2];
#line 256 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp41_[_tmp42_ + 2] = _tmp43_;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp44_ = _tmp41_[_tmp42_ + 2];
#line 257 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			return;
#line 1307 "page-view.c"
		}
#line 261 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp45_ = L;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp46_ = R;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp45_ > _tmp46_) {
#line 1315 "page-view.c"
			guchar p[3] = {0};
			Page* _tmp47_;
			gint _tmp48_;
			gint _tmp49_;
			gdouble _tmp50_;
			guchar _tmp51_;
			gdouble _tmp52_;
			gdouble _tmp53_;
			gint _tmp54_;
			gdouble _tmp55_;
			gdouble _tmp56_;
			guchar _tmp57_;
			gdouble _tmp58_;
			gdouble _tmp59_;
			gint _tmp60_;
			gdouble _tmp61_;
			gdouble _tmp62_;
			guchar _tmp63_;
			gdouble _tmp64_;
			gdouble _tmp65_;
			gint _tmp66_;
			gdouble _tmp67_;
			Page* _tmp89_;
			gint _tmp90_;
			gint _tmp91_;
			gdouble _tmp92_;
			guchar _tmp93_;
			gdouble _tmp94_;
			gdouble _tmp95_;
			gdouble _tmp96_;
			gint _tmp97_;
			gdouble _tmp98_;
			guchar _tmp99_;
			gdouble _tmp100_;
			gdouble _tmp101_;
			gdouble _tmp102_;
			gint _tmp103_;
			gdouble _tmp104_;
			guchar _tmp105_;
			gdouble _tmp106_;
			gdouble _tmp107_;
			gdouble _tmp108_;
			gint _tmp109_;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp47_ = page;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp48_ = R;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp49_ = T;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			page_view_get_pixel (self, _tmp47_, _tmp48_, _tmp49_ - 1, p, 3);
#line 265 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp50_ = red;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp51_ = p[0];
#line 265 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp52_ = r;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp53_ = l;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp54_ = T;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp55_ = t;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			red = _tmp50_ + ((_tmp51_ * (_tmp52_ - _tmp53_)) * (_tmp54_ - _tmp55_));
#line 266 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp56_ = green;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp57_ = p[1];
#line 266 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp58_ = r;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp59_ = l;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp60_ = T;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp61_ = t;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			green = _tmp56_ + ((_tmp57_ * (_tmp58_ - _tmp59_)) * (_tmp60_ - _tmp61_));
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp62_ = blue;
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp63_ = p[2];
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp64_ = r;
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp65_ = l;
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp66_ = T;
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp67_ = t;
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			blue = _tmp62_ + ((_tmp63_ * (_tmp64_ - _tmp65_)) * (_tmp66_ - _tmp67_));
#line 1409 "page-view.c"
			{
				gint _tmp68_;
				gint y;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp68_ = T;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y = _tmp68_;
#line 1417 "page-view.c"
				{
					gboolean _tmp69_;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp69_ = TRUE;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					while (TRUE) {
#line 1424 "page-view.c"
						gboolean _tmp70_;
						gint _tmp72_;
						gint _tmp73_;
						Page* _tmp74_;
						gint _tmp75_;
						gint _tmp76_;
						gdouble _tmp77_;
						guchar _tmp78_;
						gdouble _tmp79_;
						gdouble _tmp80_;
						gdouble _tmp81_;
						guchar _tmp82_;
						gdouble _tmp83_;
						gdouble _tmp84_;
						gdouble _tmp85_;
						guchar _tmp86_;
						gdouble _tmp87_;
						gdouble _tmp88_;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp70_ = _tmp69_;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						if (!_tmp70_) {
#line 1447 "page-view.c"
							gint _tmp71_;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp71_ = y;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							y = _tmp71_ + 1;
#line 1453 "page-view.c"
						}
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp69_ = FALSE;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp72_ = y;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp73_ = B;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						if (!(_tmp72_ < _tmp73_)) {
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							break;
#line 1465 "page-view.c"
						}
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp74_ = page;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp75_ = R;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp76_ = y;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						page_view_get_pixel (self, _tmp74_, _tmp75_, _tmp76_, p, 3);
#line 271 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp77_ = red;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp78_ = p[0];
#line 271 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp79_ = r;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp80_ = l;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						red = _tmp77_ + (_tmp78_ * (_tmp79_ - _tmp80_));
#line 272 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp81_ = green;
#line 272 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp82_ = p[1];
#line 272 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp83_ = r;
#line 272 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp84_ = l;
#line 272 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						green = _tmp81_ + (_tmp82_ * (_tmp83_ - _tmp84_));
#line 273 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp85_ = blue;
#line 273 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp86_ = p[2];
#line 273 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp87_ = r;
#line 273 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp88_ = l;
#line 273 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						blue = _tmp85_ + (_tmp86_ * (_tmp87_ - _tmp88_));
#line 1505 "page-view.c"
					}
				}
			}
#line 275 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp89_ = page;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp90_ = R;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp91_ = B;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			page_view_get_pixel (self, _tmp89_, _tmp90_, _tmp91_, p, 3);
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp92_ = red;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp93_ = p[0];
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp94_ = r;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp95_ = l;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp96_ = b;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp97_ = B;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			red = _tmp92_ + ((_tmp93_ * (_tmp94_ - _tmp95_)) * (_tmp96_ - _tmp97_));
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp98_ = green;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp99_ = p[1];
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp100_ = r;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp101_ = l;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp102_ = b;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp103_ = B;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			green = _tmp98_ + ((_tmp99_ * (_tmp100_ - _tmp101_)) * (_tmp102_ - _tmp103_));
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp104_ = blue;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp105_ = p[2];
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp106_ = r;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp107_ = l;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp108_ = b;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp109_ = B;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			blue = _tmp104_ + ((_tmp105_ * (_tmp106_ - _tmp107_)) * (_tmp108_ - _tmp109_));
#line 1559 "page-view.c"
		} else {
			guchar p[3] = {0};
			Page* _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
			gdouble _tmp113_;
			guchar _tmp114_;
			gdouble _tmp115_;
			gdouble _tmp116_;
			gint _tmp117_;
			gdouble _tmp118_;
			gdouble _tmp119_;
			guchar _tmp120_;
			gdouble _tmp121_;
			gdouble _tmp122_;
			gint _tmp123_;
			gdouble _tmp124_;
			gdouble _tmp125_;
			guchar _tmp126_;
			gdouble _tmp127_;
			gdouble _tmp128_;
			gint _tmp129_;
			gdouble _tmp130_;
			Page* _tmp152_;
			gint _tmp153_;
			gint _tmp154_;
			gdouble _tmp155_;
			guchar _tmp156_;
			gdouble _tmp157_;
			gdouble _tmp158_;
			gdouble _tmp159_;
			gint _tmp160_;
			gdouble _tmp161_;
			guchar _tmp162_;
			gdouble _tmp163_;
			gdouble _tmp164_;
			gdouble _tmp165_;
			gint _tmp166_;
			gdouble _tmp167_;
			guchar _tmp168_;
			gdouble _tmp169_;
			gdouble _tmp170_;
			gdouble _tmp171_;
			gint _tmp172_;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp110_ = page;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp111_ = L;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp112_ = B;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			page_view_get_pixel (self, _tmp110_, _tmp111_ - 1, _tmp112_, p, 3);
#line 285 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp113_ = red;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp114_ = p[0];
#line 285 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp115_ = b;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp116_ = t;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp117_ = L;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp118_ = l;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			red = _tmp113_ + ((_tmp114_ * (_tmp115_ - _tmp116_)) * (_tmp117_ - _tmp118_));
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp119_ = green;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp120_ = p[1];
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp121_ = b;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp122_ = t;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp123_ = L;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp124_ = l;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			green = _tmp119_ + ((_tmp120_ * (_tmp121_ - _tmp122_)) * (_tmp123_ - _tmp124_));
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp125_ = blue;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp126_ = p[2];
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp127_ = b;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp128_ = t;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp129_ = L;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp130_ = l;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			blue = _tmp125_ + ((_tmp126_ * (_tmp127_ - _tmp128_)) * (_tmp129_ - _tmp130_));
#line 1654 "page-view.c"
			{
				gint _tmp131_;
				gint x;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp131_ = L;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x = _tmp131_;
#line 1662 "page-view.c"
				{
					gboolean _tmp132_;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp132_ = TRUE;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					while (TRUE) {
#line 1669 "page-view.c"
						gboolean _tmp133_;
						gint _tmp135_;
						gint _tmp136_;
						Page* _tmp137_;
						gint _tmp138_;
						gint _tmp139_;
						gdouble _tmp140_;
						guchar _tmp141_;
						gdouble _tmp142_;
						gdouble _tmp143_;
						gdouble _tmp144_;
						guchar _tmp145_;
						gdouble _tmp146_;
						gdouble _tmp147_;
						gdouble _tmp148_;
						guchar _tmp149_;
						gdouble _tmp150_;
						gdouble _tmp151_;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp133_ = _tmp132_;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						if (!_tmp133_) {
#line 1692 "page-view.c"
							gint _tmp134_;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp134_ = x;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							x = _tmp134_ + 1;
#line 1698 "page-view.c"
						}
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp132_ = FALSE;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp135_ = x;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp136_ = R;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						if (!(_tmp135_ < _tmp136_)) {
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							break;
#line 1710 "page-view.c"
						}
#line 289 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp137_ = page;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp138_ = x;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp139_ = B;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						page_view_get_pixel (self, _tmp137_, _tmp138_, _tmp139_, p, 3);
#line 290 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp140_ = red;
#line 290 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp141_ = p[0];
#line 290 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp142_ = b;
#line 290 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp143_ = t;
#line 290 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						red = _tmp140_ + (_tmp141_ * (_tmp142_ - _tmp143_));
#line 291 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp144_ = green;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp145_ = p[1];
#line 291 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp146_ = b;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp147_ = t;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						green = _tmp144_ + (_tmp145_ * (_tmp146_ - _tmp147_));
#line 292 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp148_ = blue;
#line 292 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp149_ = p[2];
#line 292 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp150_ = b;
#line 292 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp151_ = t;
#line 292 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						blue = _tmp148_ + (_tmp149_ * (_tmp150_ - _tmp151_));
#line 1750 "page-view.c"
					}
				}
			}
#line 294 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp152_ = page;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp153_ = R;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp154_ = B;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			page_view_get_pixel (self, _tmp152_, _tmp153_, _tmp154_, p, 3);
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp155_ = red;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp156_ = p[0];
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp157_ = b;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp158_ = t;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp159_ = r;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp160_ = R;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			red = _tmp155_ + ((_tmp156_ * (_tmp157_ - _tmp158_)) * (_tmp159_ - _tmp160_));
#line 296 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp161_ = green;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp162_ = p[1];
#line 296 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp163_ = b;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp164_ = t;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp165_ = r;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp166_ = R;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			green = _tmp161_ + ((_tmp162_ * (_tmp163_ - _tmp164_)) * (_tmp165_ - _tmp166_));
#line 297 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp167_ = blue;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp168_ = p[2];
#line 297 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp169_ = b;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp170_ = t;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp171_ = r;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp172_ = R;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			blue = _tmp167_ + ((_tmp168_ * (_tmp169_ - _tmp170_)) * (_tmp171_ - _tmp172_));
#line 1804 "page-view.c"
		}
#line 300 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp173_ = r;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp174_ = l;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp175_ = b;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp176_ = t;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		scale = 1.0 / ((_tmp173_ - _tmp174_) * (_tmp175_ - _tmp176_));
#line 301 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp177_ = output;
#line 301 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp177__length1 = output_length1;
#line 301 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp178_ = offset;
#line 301 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp179_ = red;
#line 301 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp180_ = scale;
#line 301 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp177_[_tmp178_] = (guchar) ((_tmp179_ * _tmp180_) + 0.5);
#line 301 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp181_ = _tmp177_[_tmp178_];
#line 302 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp182_ = output;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp182__length1 = output_length1;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp183_ = offset;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp184_ = green;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp185_ = scale;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp182_[_tmp183_ + 1] = (guchar) ((_tmp184_ * _tmp185_) + 0.5);
#line 302 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp186_ = _tmp182_[_tmp183_ + 1];
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp187_ = output;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp187__length1 = output_length1;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp188_ = offset;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp189_ = blue;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp190_ = scale;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp187_[_tmp188_ + 2] = (guchar) ((_tmp189_ * _tmp190_) + 0.5);
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp191_ = _tmp187_[_tmp188_ + 2];
#line 304 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 1860 "page-view.c"
	}
	{
		gint _tmp192_;
		gint x;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp192_ = L;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		x = _tmp192_;
#line 1869 "page-view.c"
		{
			gboolean _tmp193_;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp193_ = TRUE;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			while (TRUE) {
#line 1876 "page-view.c"
				gboolean _tmp194_;
				gint _tmp196_;
				gint _tmp197_;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp194_ = _tmp193_;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!_tmp194_) {
#line 1884 "page-view.c"
					gint _tmp195_;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp195_ = x;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					x = _tmp195_ + 1;
#line 1890 "page-view.c"
				}
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp193_ = FALSE;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp196_ = x;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp197_ = R;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!(_tmp196_ < _tmp197_)) {
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					break;
#line 1902 "page-view.c"
				}
				{
					gint _tmp198_;
					gint y;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp198_ = T;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					y = _tmp198_;
#line 1911 "page-view.c"
					{
						gboolean _tmp199_;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp199_ = TRUE;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						while (TRUE) {
#line 1918 "page-view.c"
							gboolean _tmp200_;
							gint _tmp202_;
							gint _tmp203_;
							guchar p[3] = {0};
							Page* _tmp204_;
							gint _tmp205_;
							gint _tmp206_;
							gdouble _tmp207_;
							guchar _tmp208_;
							gdouble _tmp209_;
							guchar _tmp210_;
							gdouble _tmp211_;
							guchar _tmp212_;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp200_ = _tmp199_;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							if (!_tmp200_) {
#line 1936 "page-view.c"
								gint _tmp201_;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp201_ = y;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								y = _tmp201_ + 1;
#line 1942 "page-view.c"
							}
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp199_ = FALSE;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp202_ = y;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp203_ = B;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							if (!(_tmp202_ < _tmp203_)) {
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								break;
#line 1954 "page-view.c"
							}
#line 313 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp204_ = page;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp205_ = x;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp206_ = y;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							page_view_get_pixel (self, _tmp204_, _tmp205_, _tmp206_, p, 3);
#line 314 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp207_ = red;
#line 314 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp208_ = p[0];
#line 314 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							red = _tmp207_ + _tmp208_;
#line 315 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp209_ = green;
#line 315 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp210_ = p[1];
#line 315 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							green = _tmp209_ + _tmp210_;
#line 316 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp211_ = blue;
#line 316 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp212_ = p[2];
#line 316 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							blue = _tmp211_ + _tmp212_;
#line 1982 "page-view.c"
						}
					}
				}
			}
		}
	}
	{
		gint _tmp213_;
		gint x;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp213_ = L;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		x = _tmp213_;
#line 1996 "page-view.c"
		{
			gboolean _tmp214_;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp214_ = TRUE;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			while (TRUE) {
#line 2003 "page-view.c"
				gboolean _tmp215_;
				gint _tmp217_;
				gint _tmp218_;
				gdouble _tmp219_;
				gint _tmp220_;
				gdouble _tmp236_;
				gint _tmp237_;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp215_ = _tmp214_;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!_tmp215_) {
#line 2015 "page-view.c"
					gint _tmp216_;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp216_ = x;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					x = _tmp216_ + 1;
#line 2021 "page-view.c"
				}
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp214_ = FALSE;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp217_ = x;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp218_ = R;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!(_tmp217_ < _tmp218_)) {
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					break;
#line 2033 "page-view.c"
				}
#line 323 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp219_ = t;
#line 323 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp220_ = T;
#line 323 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (_tmp219_ != ((gdouble) _tmp220_)) {
#line 2041 "page-view.c"
					guchar p[3] = {0};
					Page* _tmp221_;
					gint _tmp222_;
					gint _tmp223_;
					gdouble _tmp224_;
					guchar _tmp225_;
					gint _tmp226_;
					gdouble _tmp227_;
					gdouble _tmp228_;
					guchar _tmp229_;
					gint _tmp230_;
					gdouble _tmp231_;
					gdouble _tmp232_;
					guchar _tmp233_;
					gint _tmp234_;
					gdouble _tmp235_;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp221_ = page;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp222_ = x;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp223_ = T;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					page_view_get_pixel (self, _tmp221_, _tmp222_, _tmp223_ - 1, p, 3);
#line 327 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp224_ = red;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp225_ = p[0];
#line 327 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp226_ = T;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp227_ = t;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					red = _tmp224_ + (_tmp225_ * (_tmp226_ - _tmp227_));
#line 328 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp228_ = green;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp229_ = p[1];
#line 328 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp230_ = T;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp231_ = t;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					green = _tmp228_ + (_tmp229_ * (_tmp230_ - _tmp231_));
#line 329 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp232_ = blue;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp233_ = p[2];
#line 329 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp234_ = T;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp235_ = t;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					blue = _tmp232_ + (_tmp233_ * (_tmp234_ - _tmp235_));
#line 2096 "page-view.c"
				}
#line 332 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp236_ = b;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp237_ = B;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (_tmp236_ != ((gdouble) _tmp237_)) {
#line 2104 "page-view.c"
					guchar p[3] = {0};
					Page* _tmp238_;
					gint _tmp239_;
					gint _tmp240_;
					gdouble _tmp241_;
					guchar _tmp242_;
					gdouble _tmp243_;
					gint _tmp244_;
					gdouble _tmp245_;
					guchar _tmp246_;
					gdouble _tmp247_;
					gint _tmp248_;
					gdouble _tmp249_;
					guchar _tmp250_;
					gdouble _tmp251_;
					gint _tmp252_;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp238_ = page;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp239_ = x;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp240_ = B;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					page_view_get_pixel (self, _tmp238_, _tmp239_, _tmp240_, p, 3);
#line 336 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp241_ = red;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp242_ = p[0];
#line 336 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp243_ = b;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp244_ = B;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					red = _tmp241_ + (_tmp242_ * (_tmp243_ - _tmp244_));
#line 337 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp245_ = green;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp246_ = p[1];
#line 337 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp247_ = b;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp248_ = B;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					green = _tmp245_ + (_tmp246_ * (_tmp247_ - _tmp248_));
#line 338 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp249_ = blue;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp250_ = p[2];
#line 338 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp251_ = b;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp252_ = B;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					blue = _tmp249_ + (_tmp250_ * (_tmp251_ - _tmp252_));
#line 2159 "page-view.c"
				}
			}
		}
	}
	{
		gint _tmp253_;
		gint y;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp253_ = T;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		y = _tmp253_;
#line 2171 "page-view.c"
		{
			gboolean _tmp254_;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp254_ = TRUE;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			while (TRUE) {
#line 2178 "page-view.c"
				gboolean _tmp255_;
				gint _tmp257_;
				gint _tmp258_;
				gdouble _tmp259_;
				gint _tmp260_;
				gdouble _tmp276_;
				gint _tmp277_;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp255_ = _tmp254_;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!_tmp255_) {
#line 2190 "page-view.c"
					gint _tmp256_;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp256_ = y;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					y = _tmp256_ + 1;
#line 2196 "page-view.c"
				}
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp254_ = FALSE;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp257_ = y;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp258_ = B;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!(_tmp257_ < _tmp258_)) {
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					break;
#line 2208 "page-view.c"
				}
#line 345 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp259_ = l;
#line 345 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp260_ = L;
#line 345 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (_tmp259_ != ((gdouble) _tmp260_)) {
#line 2216 "page-view.c"
					guchar p[3] = {0};
					Page* _tmp261_;
					gint _tmp262_;
					gint _tmp263_;
					gdouble _tmp264_;
					guchar _tmp265_;
					gint _tmp266_;
					gdouble _tmp267_;
					gdouble _tmp268_;
					guchar _tmp269_;
					gint _tmp270_;
					gdouble _tmp271_;
					gdouble _tmp272_;
					guchar _tmp273_;
					gint _tmp274_;
					gdouble _tmp275_;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp261_ = page;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp262_ = L;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp263_ = y;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					page_view_get_pixel (self, _tmp261_, _tmp262_ - 1, _tmp263_, p, 3);
#line 349 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp264_ = red;
#line 349 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp265_ = p[0];
#line 349 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp266_ = L;
#line 349 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp267_ = l;
#line 349 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					red = _tmp264_ + (_tmp265_ * (_tmp266_ - _tmp267_));
#line 350 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp268_ = green;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp269_ = p[1];
#line 350 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp270_ = L;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp271_ = l;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					green = _tmp268_ + (_tmp269_ * (_tmp270_ - _tmp271_));
#line 351 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp272_ = blue;
#line 351 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp273_ = p[2];
#line 351 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp274_ = L;
#line 351 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp275_ = l;
#line 351 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					blue = _tmp272_ + (_tmp273_ * (_tmp274_ - _tmp275_));
#line 2271 "page-view.c"
				}
#line 354 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp276_ = r;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp277_ = R;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (_tmp276_ != ((gdouble) _tmp277_)) {
#line 2279 "page-view.c"
					guchar p[3] = {0};
					Page* _tmp278_;
					gint _tmp279_;
					gint _tmp280_;
					gdouble _tmp281_;
					guchar _tmp282_;
					gdouble _tmp283_;
					gint _tmp284_;
					gdouble _tmp285_;
					guchar _tmp286_;
					gdouble _tmp287_;
					gint _tmp288_;
					gdouble _tmp289_;
					guchar _tmp290_;
					gdouble _tmp291_;
					gint _tmp292_;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp278_ = page;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp279_ = R;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp280_ = y;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					page_view_get_pixel (self, _tmp278_, _tmp279_, _tmp280_, p, 3);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp281_ = red;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp282_ = p[0];
#line 358 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp283_ = r;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp284_ = R;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					red = _tmp281_ + (_tmp282_ * (_tmp283_ - _tmp284_));
#line 359 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp285_ = green;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp286_ = p[1];
#line 359 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp287_ = r;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp288_ = R;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					green = _tmp285_ + (_tmp286_ * (_tmp287_ - _tmp288_));
#line 360 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp289_ = blue;
#line 360 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp290_ = p[2];
#line 360 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp291_ = r;
#line 360 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp292_ = R;
#line 360 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					blue = _tmp289_ + (_tmp290_ * (_tmp291_ - _tmp292_));
#line 2334 "page-view.c"
				}
			}
		}
	}
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp294_ = l;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp295_ = L;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp294_ != ((gdouble) _tmp295_)) {
#line 2345 "page-view.c"
		gdouble _tmp296_;
		gint _tmp297_;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp296_ = t;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp297_ = T;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp293_ = _tmp296_ != ((gdouble) _tmp297_);
#line 2354 "page-view.c"
	} else {
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp293_ = FALSE;
#line 2358 "page-view.c"
	}
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp298_ = _tmp293_;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp298_) {
#line 2364 "page-view.c"
		guchar p[3] = {0};
		Page* _tmp299_;
		gint _tmp300_;
		gint _tmp301_;
		gdouble _tmp302_;
		guchar _tmp303_;
		gint _tmp304_;
		gdouble _tmp305_;
		gint _tmp306_;
		gdouble _tmp307_;
		gdouble _tmp308_;
		guchar _tmp309_;
		gint _tmp310_;
		gdouble _tmp311_;
		gint _tmp312_;
		gdouble _tmp313_;
		gdouble _tmp314_;
		guchar _tmp315_;
		gint _tmp316_;
		gdouble _tmp317_;
		gint _tmp318_;
		gdouble _tmp319_;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp299_ = page;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp300_ = L;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp301_ = T;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_get_pixel (self, _tmp299_, _tmp300_ - 1, _tmp301_ - 1, p, 3);
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp302_ = red;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp303_ = p[0];
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp304_ = L;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp305_ = l;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp306_ = T;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp307_ = t;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		red = _tmp302_ + ((_tmp303_ * (_tmp304_ - _tmp305_)) * (_tmp306_ - _tmp307_));
#line 370 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp308_ = green;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp309_ = p[1];
#line 370 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp310_ = L;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp311_ = l;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp312_ = T;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp313_ = t;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		green = _tmp308_ + ((_tmp309_ * (_tmp310_ - _tmp311_)) * (_tmp312_ - _tmp313_));
#line 371 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp314_ = blue;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp315_ = p[2];
#line 371 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp316_ = L;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp317_ = l;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp318_ = T;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp319_ = t;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		blue = _tmp314_ + ((_tmp315_ * (_tmp316_ - _tmp317_)) * (_tmp318_ - _tmp319_));
#line 2437 "page-view.c"
	}
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp321_ = r;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp322_ = R;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp321_ != ((gdouble) _tmp322_)) {
#line 2445 "page-view.c"
		gdouble _tmp323_;
		gint _tmp324_;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp323_ = t;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp324_ = T;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp320_ = _tmp323_ != ((gdouble) _tmp324_);
#line 2454 "page-view.c"
	} else {
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp320_ = FALSE;
#line 2458 "page-view.c"
	}
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp325_ = _tmp320_;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp325_) {
#line 2464 "page-view.c"
		guchar p[3] = {0};
		Page* _tmp326_;
		gint _tmp327_;
		gint _tmp328_;
		gdouble _tmp329_;
		guchar _tmp330_;
		gdouble _tmp331_;
		gint _tmp332_;
		gint _tmp333_;
		gdouble _tmp334_;
		gdouble _tmp335_;
		guchar _tmp336_;
		gdouble _tmp337_;
		gint _tmp338_;
		gint _tmp339_;
		gdouble _tmp340_;
		gdouble _tmp341_;
		guchar _tmp342_;
		gdouble _tmp343_;
		gint _tmp344_;
		gint _tmp345_;
		gdouble _tmp346_;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp326_ = page;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp327_ = R;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp328_ = T;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_get_pixel (self, _tmp326_, _tmp327_, _tmp328_ - 1, p, 3);
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp329_ = red;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp330_ = p[0];
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp331_ = r;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp332_ = R;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp333_ = T;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp334_ = t;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		red = _tmp329_ + ((_tmp330_ * (_tmp331_ - _tmp332_)) * (_tmp333_ - _tmp334_));
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp335_ = green;
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp336_ = p[1];
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp337_ = r;
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp338_ = R;
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp339_ = T;
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp340_ = t;
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		green = _tmp335_ + ((_tmp336_ * (_tmp337_ - _tmp338_)) * (_tmp339_ - _tmp340_));
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp341_ = blue;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp342_ = p[2];
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp343_ = r;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp344_ = R;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp345_ = T;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp346_ = t;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		blue = _tmp341_ + ((_tmp342_ * (_tmp343_ - _tmp344_)) * (_tmp345_ - _tmp346_));
#line 2537 "page-view.c"
	}
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp348_ = r;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp349_ = R;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp348_ != ((gdouble) _tmp349_)) {
#line 2545 "page-view.c"
		gdouble _tmp350_;
		gint _tmp351_;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp350_ = b;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp351_ = B;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp347_ = _tmp350_ != ((gdouble) _tmp351_);
#line 2554 "page-view.c"
	} else {
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp347_ = FALSE;
#line 2558 "page-view.c"
	}
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp352_ = _tmp347_;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp352_) {
#line 2564 "page-view.c"
		guchar p[3] = {0};
		Page* _tmp353_;
		gint _tmp354_;
		gint _tmp355_;
		gdouble _tmp356_;
		guchar _tmp357_;
		gdouble _tmp358_;
		gint _tmp359_;
		gdouble _tmp360_;
		gint _tmp361_;
		gdouble _tmp362_;
		guchar _tmp363_;
		gdouble _tmp364_;
		gint _tmp365_;
		gdouble _tmp366_;
		gint _tmp367_;
		gdouble _tmp368_;
		guchar _tmp369_;
		gdouble _tmp370_;
		gint _tmp371_;
		gdouble _tmp372_;
		gint _tmp373_;
#line 384 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp353_ = page;
#line 384 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp354_ = R;
#line 384 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp355_ = B;
#line 384 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_get_pixel (self, _tmp353_, _tmp354_, _tmp355_, p, 3);
#line 385 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp356_ = red;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp357_ = p[0];
#line 385 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp358_ = r;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp359_ = R;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp360_ = b;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp361_ = B;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		red = _tmp356_ + ((_tmp357_ * (_tmp358_ - _tmp359_)) * (_tmp360_ - _tmp361_));
#line 386 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp362_ = green;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp363_ = p[1];
#line 386 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp364_ = r;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp365_ = R;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp366_ = b;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp367_ = B;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		green = _tmp362_ + ((_tmp363_ * (_tmp364_ - _tmp365_)) * (_tmp366_ - _tmp367_));
#line 387 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp368_ = blue;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp369_ = p[2];
#line 387 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp370_ = r;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp371_ = R;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp372_ = b;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp373_ = B;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		blue = _tmp368_ + ((_tmp369_ * (_tmp370_ - _tmp371_)) * (_tmp372_ - _tmp373_));
#line 2637 "page-view.c"
	}
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp375_ = l;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp376_ = L;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp375_ != ((gdouble) _tmp376_)) {
#line 2645 "page-view.c"
		gdouble _tmp377_;
		gint _tmp378_;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp377_ = b;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp378_ = B;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp374_ = _tmp377_ != ((gdouble) _tmp378_);
#line 2654 "page-view.c"
	} else {
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp374_ = FALSE;
#line 2658 "page-view.c"
	}
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp379_ = _tmp374_;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp379_) {
#line 2664 "page-view.c"
		guchar p[3] = {0};
		Page* _tmp380_;
		gint _tmp381_;
		gint _tmp382_;
		gdouble _tmp383_;
		guchar _tmp384_;
		gint _tmp385_;
		gdouble _tmp386_;
		gdouble _tmp387_;
		gint _tmp388_;
		gdouble _tmp389_;
		guchar _tmp390_;
		gint _tmp391_;
		gdouble _tmp392_;
		gdouble _tmp393_;
		gint _tmp394_;
		gdouble _tmp395_;
		guchar _tmp396_;
		gint _tmp397_;
		gdouble _tmp398_;
		gdouble _tmp399_;
		gint _tmp400_;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp380_ = page;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp381_ = L;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp382_ = B;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_get_pixel (self, _tmp380_, _tmp381_ - 1, _tmp382_, p, 3);
#line 393 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp383_ = red;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp384_ = p[0];
#line 393 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp385_ = L;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp386_ = l;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp387_ = b;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp388_ = B;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		red = _tmp383_ + ((_tmp384_ * (_tmp385_ - _tmp386_)) * (_tmp387_ - _tmp388_));
#line 394 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp389_ = green;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp390_ = p[1];
#line 394 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp391_ = L;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp392_ = l;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp393_ = b;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp394_ = B;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		green = _tmp389_ + ((_tmp390_ * (_tmp391_ - _tmp392_)) * (_tmp393_ - _tmp394_));
#line 395 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp395_ = blue;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp396_ = p[2];
#line 395 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp397_ = L;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp398_ = l;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp399_ = b;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp400_ = B;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		blue = _tmp395_ + ((_tmp396_ * (_tmp397_ - _tmp398_)) * (_tmp399_ - _tmp400_));
#line 2737 "page-view.c"
	}
#line 399 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp401_ = r;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp402_ = l;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp403_ = b;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp404_ = t;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	scale = 1.0 / ((_tmp401_ - _tmp402_) * (_tmp403_ - _tmp404_));
#line 400 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp405_ = output;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp405__length1 = output_length1;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp406_ = offset;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp407_ = red;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp408_ = scale;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp405_[_tmp406_] = (guchar) ((_tmp407_ * _tmp408_) + 0.5);
#line 400 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp409_ = _tmp405_[_tmp406_];
#line 401 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp410_ = output;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp410__length1 = output_length1;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp411_ = offset;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp412_ = green;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp413_ = scale;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp410_[_tmp411_ + 1] = (guchar) ((_tmp412_ * _tmp413_) + 0.5);
#line 401 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp414_ = _tmp410_[_tmp411_ + 1];
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp415_ = output;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp415__length1 = output_length1;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp416_ = offset;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp417_ = blue;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp418_ = scale;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp415_[_tmp416_ + 2] = (guchar) ((_tmp417_ * _tmp418_) + 0.5);
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp419_ = _tmp415_[_tmp416_ + 2];
#line 2791 "page-view.c"
}


static void page_view_update_preview (PageView* self, Page* page, GdkPixbuf** output_image, gint output_width, gint output_height, ScanDirection scan_direction, gint old_scan_line, gint scan_line) {
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint input_width;
	Page* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint input_height;
	gint L = 0;
	gint R = 0;
	gint T = 0;
	gint B = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GdkPixbuf* _tmp8_;
	gboolean _tmp13_;
	gboolean _tmp18_;
	gint _tmp60_;
	gint _tmp61_;
	gint _tmp63_;
	gint _tmp64_;
	gint _tmp66_;
	gint _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	gint _tmp70_;
	gint _tmp71_;
	GdkPixbuf* _tmp72_;
	GdkPixbuf* _tmp73_;
	guint8* _tmp74_ = NULL;
	guchar* output;
	gint output_length1;
	gint _output_size_;
	GdkPixbuf* _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
	gint output_rowstride;
	GdkPixbuf* _tmp78_;
	gint _tmp79_ = 0;
	gint output_n_channels;
	Page* _tmp80_;
	gboolean _tmp81_;
	gboolean _tmp82_;
#line 405 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 405 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (page != NULL);
#line 408 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = page;
#line 408 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 408 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = _tmp1_;
#line 408 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	input_width = _tmp2_;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = page;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = page_get_height (_tmp3_);
#line 409 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = _tmp4_;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	input_height = _tmp5_;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = *output_image;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp8_ == NULL) {
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = TRUE;
#line 2865 "page-view.c"
	} else {
		GdkPixbuf* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
#line 414 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp9_ = *output_image;
#line 414 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp10_ = gdk_pixbuf_get_width (_tmp9_);
#line 414 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = _tmp10_;
#line 414 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp12_ = output_width;
#line 414 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = _tmp11_ != _tmp12_;
#line 2881 "page-view.c"
	}
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = _tmp7_;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp13_) {
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp6_ = TRUE;
#line 2889 "page-view.c"
	} else {
		GdkPixbuf* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp14_ = *output_image;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp15_ = gdk_pixbuf_get_height (_tmp14_);
#line 415 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp16_ = _tmp15_;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp17_ = output_height;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp6_ = _tmp16_ != _tmp17_;
#line 2905 "page-view.c"
	}
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp18_ = _tmp6_;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp18_) {
#line 2911 "page-view.c"
		gint _tmp19_;
		gint _tmp20_;
		GdkPixbuf* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
#line 417 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp19_ = output_width;
#line 417 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp20_ = output_height;
#line 417 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp21_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, _tmp19_, _tmp20_);
#line 417 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_object_unref0 (*output_image);
#line 417 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		*output_image = _tmp21_;
#line 424 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		L = 0;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp22_ = output_width;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		R = _tmp22_ - 1;
#line 426 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		T = 0;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp23_ = output_height;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		B = _tmp23_ - 1;
#line 2939 "page-view.c"
	} else {
		ScanDirection _tmp24_;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp24_ = scan_direction;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		switch (_tmp24_) {
#line 432 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 2948 "page-view.c"
			{
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				L = 0;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp25_ = output_width;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				R = _tmp25_ - 1;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp26_ = old_scan_line;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp27_ = output_height;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp28_ = input_height;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				T = (gint) ((((gdouble) _tmp26_) * _tmp27_) / _tmp28_);
#line 438 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp29_ = scan_line;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp30_ = output_height;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp31_ = input_height;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				B = (gint) (((((gdouble) _tmp29_) * _tmp30_) / _tmp31_) + 0.5);
#line 439 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 2981 "page-view.c"
			}
#line 432 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 2985 "page-view.c"
			{
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp32_ = old_scan_line;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp33_ = output_width;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp34_ = input_width;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				L = (gint) ((((gdouble) _tmp32_) * _tmp33_) / _tmp34_);
#line 442 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp35_ = scan_line;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp36_ = output_width;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp37_ = input_width;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				R = (gint) (((((gdouble) _tmp35_) * _tmp36_) / _tmp37_) + 0.5);
#line 443 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				T = 0;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp38_ = output_height;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				B = _tmp38_ - 1;
#line 445 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 3018 "page-view.c"
			}
#line 432 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 3022 "page-view.c"
			{
				gint _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				L = 0;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp39_ = output_width;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				R = _tmp39_ - 1;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp40_ = input_height;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp41_ = scan_line;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp42_ = output_height;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp43_ = input_height;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				T = (gint) ((((gdouble) (_tmp40_ - _tmp41_)) * _tmp42_) / _tmp43_);
#line 450 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp44_ = input_height;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp45_ = old_scan_line;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp46_ = output_height;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp47_ = input_height;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				B = (gint) (((((gdouble) (_tmp44_ - _tmp45_)) * _tmp46_) / _tmp47_) + 0.5);
#line 451 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 3061 "page-view.c"
			}
#line 432 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 3065 "page-view.c"
			{
				gint _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp48_ = input_width;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp49_ = scan_line;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp50_ = output_width;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp51_ = input_width;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				L = (gint) ((((gdouble) (_tmp48_ - _tmp49_)) * _tmp50_) / _tmp51_);
#line 454 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp52_ = input_width;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp53_ = old_scan_line;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp54_ = output_width;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp55_ = input_width;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				R = (gint) (((((gdouble) (_tmp52_ - _tmp53_)) * _tmp54_) / _tmp55_) + 0.5);
#line 455 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				T = 0;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp56_ = output_height;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				B = _tmp56_ - 1;
#line 457 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 3104 "page-view.c"
			}
			default:
			{
				gint _tmp57_;
				gint _tmp58_;
				gint _tmp59_;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				T = 0;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp57_ = T;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				B = _tmp57_;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp58_ = B;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				R = _tmp58_;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp59_ = R;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				L = _tmp59_;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 3127 "page-view.c"
			}
		}
	}
#line 465 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp60_ = R;
#line 465 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp61_ = output_width;
#line 465 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp60_ >= _tmp61_) {
#line 3137 "page-view.c"
		gint _tmp62_;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp62_ = output_width;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		R = _tmp62_ - 1;
#line 3143 "page-view.c"
	}
#line 467 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp63_ = B;
#line 467 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp64_ = output_height;
#line 467 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp63_ >= _tmp64_) {
#line 3151 "page-view.c"
		gint _tmp65_;
#line 468 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp65_ = output_height;
#line 468 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		B = _tmp65_ - 1;
#line 3157 "page-view.c"
	}
#line 470 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp66_ = L;
#line 470 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (_tmp66_ >= 0);
#line 471 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp67_ = R;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp68_ = output_width;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (_tmp67_ < _tmp68_);
#line 472 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp69_ = T;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (_tmp69_ >= 0);
#line 473 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp70_ = B;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp71_ = output_height;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (_tmp70_ < _tmp71_);
#line 474 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp72_ = *output_image;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (_tmp72_ != NULL);
#line 476 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp73_ = *output_image;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp74_ = gdk_pixbuf_get_pixels (_tmp73_);
#line 476 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	output = _tmp74_;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	output_length1 = -1;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_output_size_ = output_length1;
#line 477 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp75_ = *output_image;
#line 477 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp76_ = gdk_pixbuf_get_rowstride (_tmp75_);
#line 477 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp77_ = _tmp76_;
#line 477 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	output_rowstride = _tmp77_;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp78_ = *output_image;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp79_ = gdk_pixbuf_get_n_channels (_tmp78_);
#line 478 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	output_n_channels = _tmp79_;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp80_ = page;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp81_ = page_get_has_data (_tmp80_);
#line 480 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp82_ = _tmp81_;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (!_tmp82_) {
#line 3215 "page-view.c"
		{
			gint _tmp83_;
			gint x;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp83_ = L;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			x = _tmp83_;
#line 3223 "page-view.c"
			{
				gboolean _tmp84_;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp84_ = TRUE;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				while (TRUE) {
#line 3230 "page-view.c"
					gboolean _tmp85_;
					gint _tmp87_;
					gint _tmp88_;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp85_ = _tmp84_;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					if (!_tmp85_) {
#line 3238 "page-view.c"
						gint _tmp86_;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp86_ = x;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						x = _tmp86_ + 1;
#line 3244 "page-view.c"
					}
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp84_ = FALSE;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp87_ = x;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp88_ = R;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					if (!(_tmp87_ <= _tmp88_)) {
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						break;
#line 3256 "page-view.c"
					}
					{
						gint _tmp89_;
						gint y;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp89_ = T;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						y = _tmp89_;
#line 3265 "page-view.c"
						{
							gboolean _tmp90_;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp90_ = TRUE;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							while (TRUE) {
#line 3272 "page-view.c"
								gboolean _tmp91_;
								gint _tmp93_;
								gint _tmp94_;
								gint _tmp95_;
								gint _tmp96_;
								gint _tmp97_;
								gint _tmp98_;
								gint o;
								guchar* _tmp99_;
								gint _tmp99__length1;
								gint _tmp100_;
								guchar* _tmp101_;
								gint _tmp101__length1;
								gint _tmp102_;
								guchar* _tmp103_;
								gint _tmp103__length1;
								gint _tmp104_;
								guchar _tmp105_;
								guchar _tmp106_;
								guchar _tmp107_;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp91_ = _tmp90_;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								if (!_tmp91_) {
#line 3297 "page-view.c"
									gint _tmp92_;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
									_tmp92_ = y;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
									y = _tmp92_ + 1;
#line 3303 "page-view.c"
								}
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp90_ = FALSE;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp93_ = y;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp94_ = B;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								if (!(_tmp93_ <= _tmp94_)) {
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
									break;
#line 3315 "page-view.c"
								}
#line 485 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp95_ = output_rowstride;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp96_ = y;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp97_ = x;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp98_ = output_n_channels;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								o = (_tmp95_ * _tmp96_) + (_tmp97_ * _tmp98_);
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp99_ = output;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp99__length1 = output_length1;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp100_ = o;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp101_ = output;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp101__length1 = output_length1;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp102_ = o;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp103_ = output;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp103__length1 = output_length1;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp104_ = o;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp103_[_tmp104_ + 2] = (guchar) 0xFF;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp105_ = _tmp103_[_tmp104_ + 2];
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp101_[_tmp102_ + 1] = _tmp105_;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp106_ = _tmp101_[_tmp102_ + 1];
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp99_[_tmp100_] = _tmp106_;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp107_ = _tmp99_[_tmp100_];
#line 3357 "page-view.c"
							}
						}
					}
				}
			}
		}
#line 488 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 3366 "page-view.c"
	}
	{
		gint _tmp108_;
		gint x;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp108_ = L;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		x = _tmp108_;
#line 3375 "page-view.c"
		{
			gboolean _tmp109_;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp109_ = TRUE;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			while (TRUE) {
#line 3382 "page-view.c"
				gboolean _tmp110_;
				gint _tmp112_;
				gint _tmp113_;
				gint _tmp114_;
				gint _tmp115_;
				gint _tmp116_;
				gdouble l;
				gint _tmp117_;
				gint _tmp118_;
				gint _tmp119_;
				gdouble r;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp110_ = _tmp109_;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!_tmp110_) {
#line 3398 "page-view.c"
					gint _tmp111_;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp111_ = x;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					x = _tmp111_ + 1;
#line 3404 "page-view.c"
				}
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp109_ = FALSE;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp112_ = x;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp113_ = R;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!(_tmp112_ <= _tmp113_)) {
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					break;
#line 3416 "page-view.c"
				}
#line 494 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp114_ = x;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp115_ = input_width;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp116_ = output_width;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				l = (((gdouble) _tmp114_) * _tmp115_) / _tmp116_;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp117_ = x;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp118_ = input_width;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp119_ = output_width;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				r = (((gdouble) (_tmp117_ + 1)) * _tmp118_) / _tmp119_;
#line 3434 "page-view.c"
				{
					gint _tmp120_;
					gint y;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp120_ = T;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					y = _tmp120_;
#line 3442 "page-view.c"
					{
						gboolean _tmp121_;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp121_ = TRUE;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						while (TRUE) {
#line 3449 "page-view.c"
							gboolean _tmp122_;
							gint _tmp124_;
							gint _tmp125_;
							gint _tmp126_;
							gint _tmp127_;
							gint _tmp128_;
							gdouble t;
							gint _tmp129_;
							gint _tmp130_;
							gint _tmp131_;
							gdouble b;
							Page* _tmp132_;
							gdouble _tmp133_;
							gdouble _tmp134_;
							gdouble _tmp135_;
							gdouble _tmp136_;
							guchar* _tmp137_;
							gint _tmp137__length1;
							gint _tmp138_;
							gint _tmp139_;
							gint _tmp140_;
							gint _tmp141_;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp122_ = _tmp121_;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							if (!_tmp122_) {
#line 3476 "page-view.c"
								gint _tmp123_;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp123_ = y;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								y = _tmp123_ + 1;
#line 3482 "page-view.c"
							}
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp121_ = FALSE;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp124_ = y;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp125_ = B;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							if (!(_tmp124_ <= _tmp125_)) {
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								break;
#line 3494 "page-view.c"
							}
#line 499 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp126_ = y;
#line 499 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp127_ = input_height;
#line 499 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp128_ = output_height;
#line 499 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							t = (((gdouble) _tmp126_) * _tmp127_) / _tmp128_;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp129_ = y;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp130_ = input_height;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp131_ = output_height;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							b = (((gdouble) (_tmp129_ + 1)) * _tmp130_) / _tmp131_;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp132_ = page;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp133_ = l;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp134_ = r;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp135_ = t;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp136_ = b;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp137_ = output;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp137__length1 = output_length1;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp138_ = output_rowstride;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp139_ = y;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp140_ = x;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp141_ = output_n_channels;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							page_view_set_pixel (self, _tmp132_, _tmp133_, _tmp134_, _tmp135_, _tmp136_, _tmp137_, _tmp137__length1, (_tmp138_ * _tmp139_) + (_tmp140_ * _tmp141_));
#line 3536 "page-view.c"
						}
					}
				}
			}
		}
	}
}


static gint page_view_get_preview_width (PageView* self) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->width;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->border_width;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_ - (_tmp1_ * 2);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 3560 "page-view.c"
}


static gint page_view_get_preview_height (PageView* self) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 516 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->height;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->border_width;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_ - (_tmp1_ * 2);
#line 516 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 3578 "page-view.c"
}


static void page_view_update_page_view (PageView* self) {
	gboolean _tmp0_;
	gint _tmp1_;
	gint old_scan_line;
	Page* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint scan_line;
	ScanDirection _tmp5_;
	Page* _tmp6_;
	ScanDirection _tmp7_;
	ScanDirection _tmp8_;
	ScanDirection left_steps;
	gboolean _tmp9_ = FALSE;
	ScanDirection _tmp10_;
	gboolean _tmp12_;
	Page* _tmp13_;
	ScanDirection _tmp14_;
	ScanDirection _tmp15_;
	Page* _tmp16_;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	Page* _tmp19_;
	ScanDirection _tmp20_;
	ScanDirection _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 521 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->update_image;
#line 521 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (!_tmp0_) {
#line 522 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 3618 "page-view.c"
	}
#line 524 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->scan_line;
#line 524 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	old_scan_line = _tmp1_;
#line 525 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = self->priv->_page;
#line 525 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = page_get_scan_line (_tmp2_);
#line 525 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = _tmp3_;
#line 525 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	scan_line = _tmp4_;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = self->priv->scan_direction;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = self->priv->_page;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp7_ = page_get_scan_direction (_tmp6_);
#line 528 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = _tmp7_;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	left_steps = _tmp5_ - _tmp8_;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp10_ = left_steps;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp10_ != 0) {
#line 3646 "page-view.c"
		GdkPixbuf* _tmp11_;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = self->priv->image;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp9_ = _tmp11_ != NULL;
#line 3652 "page-view.c"
	} else {
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp9_ = FALSE;
#line 3656 "page-view.c"
	}
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = _tmp9_;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp12_) {
#line 530 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_object_unref0 (self->priv->image);
#line 530 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->image = NULL;
#line 3666 "page-view.c"
	}
#line 531 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = self->priv->_page;
#line 531 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp14_ = page_get_scan_direction (_tmp13_);
#line 531 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp15_ = _tmp14_;
#line 531 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->scan_direction = _tmp15_;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp16_ = self->priv->_page;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp17_ = page_view_get_preview_width (self);
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp18_ = page_view_get_preview_height (self);
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp19_ = self->priv->_page;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp20_ = page_get_scan_direction (_tmp19_);
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp21_ = _tmp20_;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp22_ = old_scan_line;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp23_ = scan_line;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_update_preview (self, _tmp16_, &self->priv->image, _tmp17_, _tmp18_, _tmp21_, _tmp22_, _tmp23_);
#line 539 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->update_image = FALSE;
#line 540 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp24_ = scan_line;
#line 540 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->scan_line = _tmp24_;
#line 3700 "page-view.c"
}


static gint page_view_page_to_screen_x (PageView* self, gint x) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_ = 0;
	Page* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = x;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = page_view_get_preview_width (self);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = self->priv->_page;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = page_get_width (_tmp2_);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = _tmp3_;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = (gint) (((((gdouble) _tmp0_) * _tmp1_) / _tmp4_) + 0.5);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 3727 "page-view.c"
}


static gint page_view_page_to_screen_y (PageView* self, gint y) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_ = 0;
	Page* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
#line 548 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = y;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = page_view_get_preview_height (self);
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = self->priv->_page;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = page_get_height (_tmp2_);
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = _tmp3_;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = (gint) (((((gdouble) _tmp0_) * _tmp1_) / _tmp4_) + 0.5);
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 3754 "page-view.c"
}


static gint page_view_screen_to_page_x (PageView* self, gint x) {
	gint result = 0;
	gint _tmp0_;
	Page* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_ = 0;
#line 553 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = x;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->_page;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_get_width (_tmp1_);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = page_view_get_preview_width (self);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = (gint) (((((gdouble) _tmp0_) * _tmp3_) / _tmp4_) + 0.5);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 3781 "page-view.c"
}


static gint page_view_screen_to_page_y (PageView* self, gint y) {
	gint result = 0;
	gint _tmp0_;
	Page* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_ = 0;
#line 558 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 560 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = y;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->_page;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_get_height (_tmp1_);
#line 560 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = page_view_get_preview_height (self);
#line 560 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = (gint) (((((gdouble) _tmp0_) * _tmp3_) / _tmp4_) + 0.5);
#line 560 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 3808 "page-view.c"
}


static CropLocation page_view_get_crop_location (PageView* self, gint x, gint y) {
	CropLocation result = 0;
	Page* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	Page* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint cx;
	Page* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint cy;
	Page* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint cw;
	Page* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint ch;
	gint _tmp15_;
	gint _tmp16_ = 0;
	gint dx;
	gint _tmp17_;
	gint _tmp18_ = 0;
	gint dy;
	gint _tmp19_;
	gint _tmp20_ = 0;
	gint dw;
	gint _tmp21_;
	gint _tmp22_ = 0;
	gint dh;
	gint _tmp23_;
	gint _tmp24_;
	gint ix;
	gint _tmp25_;
	gint _tmp26_;
	gint iy;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gint _tmp30_;
	gboolean _tmp33_;
	gboolean _tmp35_;
	gboolean _tmp38_;
	Page* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* name;
	const gchar* _tmp43_;
	gint crop_border;
	gint _tmp44_;
	gint _tmp45_;
	gint _tmp47_;
	gint _tmp48_;
	gboolean _tmp50_ = FALSE;
	gint _tmp51_;
	gint _tmp52_;
	gboolean _tmp55_;
	gboolean _tmp56_ = FALSE;
	gint _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	gboolean _tmp62_;
	gboolean _tmp63_ = FALSE;
	gint _tmp64_;
	gint _tmp65_;
	gboolean _tmp69_;
	gboolean _tmp70_ = FALSE;
	gint _tmp71_;
	gint _tmp72_;
	gint _tmp73_;
	gboolean _tmp77_;
	gint _tmp78_;
	gint _tmp79_;
	gint _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	gint _tmp83_;
	gint _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	gint _tmp87_;
#line 563 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = page_get_has_crop (_tmp0_);
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = _tmp1_;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (!_tmp2_) {
#line 566 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = 0;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 3911 "page-view.c"
	}
#line 568 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = self->priv->_page;
#line 568 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = page_get_crop_x (_tmp3_);
#line 568 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = _tmp4_;
#line 568 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cx = _tmp5_;
#line 569 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = self->priv->_page;
#line 569 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp7_ = page_get_crop_y (_tmp6_);
#line 569 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = _tmp7_;
#line 569 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cy = _tmp8_;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp9_ = self->priv->_page;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp10_ = page_get_crop_width (_tmp9_);
#line 570 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp11_ = _tmp10_;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cw = _tmp11_;
#line 571 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = self->priv->_page;
#line 571 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = page_get_crop_height (_tmp12_);
#line 571 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp14_ = _tmp13_;
#line 571 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	ch = _tmp14_;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp15_ = cx;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp16_ = page_view_page_to_screen_x (self, _tmp15_);
#line 572 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	dx = _tmp16_;
#line 573 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp17_ = cy;
#line 573 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp18_ = page_view_page_to_screen_y (self, _tmp17_);
#line 573 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	dy = _tmp18_;
#line 574 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp19_ = cw;
#line 574 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp20_ = page_view_page_to_screen_x (self, _tmp19_);
#line 574 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	dw = _tmp20_;
#line 575 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp21_ = ch;
#line 575 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp22_ = page_view_page_to_screen_y (self, _tmp21_);
#line 575 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	dh = _tmp22_;
#line 576 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp23_ = x;
#line 576 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp24_ = dx;
#line 576 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	ix = _tmp23_ - _tmp24_;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp25_ = y;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp26_ = dy;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	iy = _tmp25_ - _tmp26_;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp30_ = ix;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp30_ < 0) {
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp29_ = TRUE;
#line 3987 "page-view.c"
	} else {
		gint _tmp31_;
		gint _tmp32_;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp31_ = ix;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp32_ = dw;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp29_ = _tmp31_ > _tmp32_;
#line 3997 "page-view.c"
	}
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp33_ = _tmp29_;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp33_) {
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp28_ = TRUE;
#line 4005 "page-view.c"
	} else {
		gint _tmp34_;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp34_ = iy;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp28_ = _tmp34_ < 0;
#line 4012 "page-view.c"
	}
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp35_ = _tmp28_;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp35_) {
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp27_ = TRUE;
#line 4020 "page-view.c"
	} else {
		gint _tmp36_;
		gint _tmp37_;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp36_ = iy;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp37_ = dh;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp27_ = _tmp36_ > _tmp37_;
#line 4030 "page-view.c"
	}
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp38_ = _tmp27_;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp38_) {
#line 580 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_NONE;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4040 "page-view.c"
	}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp39_ = self->priv->_page;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp40_ = page_get_crop_name (_tmp39_);
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp41_ = _tmp40_;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp42_ = g_strdup (_tmp41_);
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	name = _tmp42_;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp43_ = name;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp43_ != NULL) {
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_MIDDLE;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4062 "page-view.c"
	}
#line 588 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	crop_border = 20;
#line 589 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp44_ = dw;
#line 589 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp45_ = crop_border;
#line 589 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp44_ < (_tmp45_ * 3)) {
#line 4072 "page-view.c"
		gint _tmp46_;
#line 590 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp46_ = dw;
#line 590 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		crop_border = _tmp46_ / 3;
#line 4078 "page-view.c"
	}
#line 591 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp47_ = dh;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp48_ = crop_border;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp47_ < (_tmp48_ * 3)) {
#line 4086 "page-view.c"
		gint _tmp49_;
#line 592 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp49_ = dh;
#line 592 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		crop_border = _tmp49_ / 3;
#line 4092 "page-view.c"
	}
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp51_ = ix;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp52_ = crop_border;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp51_ < _tmp52_) {
#line 4100 "page-view.c"
		gint _tmp53_;
		gint _tmp54_;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp53_ = iy;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp54_ = crop_border;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp50_ = _tmp53_ < _tmp54_;
#line 4109 "page-view.c"
	} else {
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp50_ = FALSE;
#line 4113 "page-view.c"
	}
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp55_ = _tmp50_;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp55_) {
#line 596 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_TOP_LEFT;
#line 596 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 596 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4125 "page-view.c"
	}
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp57_ = ix;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp58_ = dw;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp59_ = crop_border;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp57_ > (_tmp58_ - _tmp59_)) {
#line 4135 "page-view.c"
		gint _tmp60_;
		gint _tmp61_;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp60_ = iy;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp61_ = crop_border;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp56_ = _tmp60_ < _tmp61_;
#line 4144 "page-view.c"
	} else {
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp56_ = FALSE;
#line 4148 "page-view.c"
	}
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp62_ = _tmp56_;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp62_) {
#line 599 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_TOP_RIGHT;
#line 599 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 599 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4160 "page-view.c"
	}
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp64_ = ix;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp65_ = crop_border;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp64_ < _tmp65_) {
#line 4168 "page-view.c"
		gint _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp66_ = iy;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp67_ = dh;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp68_ = crop_border;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp63_ = _tmp66_ > (_tmp67_ - _tmp68_);
#line 4180 "page-view.c"
	} else {
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp63_ = FALSE;
#line 4184 "page-view.c"
	}
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp69_ = _tmp63_;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp69_) {
#line 602 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_BOTTOM_LEFT;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 602 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4196 "page-view.c"
	}
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp71_ = ix;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp72_ = dw;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp73_ = crop_border;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp71_ > (_tmp72_ - _tmp73_)) {
#line 4206 "page-view.c"
		gint _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp74_ = iy;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp75_ = dh;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp76_ = crop_border;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp70_ = _tmp74_ > (_tmp75_ - _tmp76_);
#line 4218 "page-view.c"
	} else {
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp70_ = FALSE;
#line 4222 "page-view.c"
	}
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp77_ = _tmp70_;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp77_) {
#line 605 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_BOTTOM_RIGHT;
#line 605 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 605 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4234 "page-view.c"
	}
#line 608 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp78_ = ix;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp79_ = crop_border;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp78_ < _tmp79_) {
#line 609 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_LEFT;
#line 609 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 609 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4248 "page-view.c"
	}
#line 611 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp80_ = ix;
#line 611 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp81_ = dw;
#line 611 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp82_ = crop_border;
#line 611 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp80_ > (_tmp81_ - _tmp82_)) {
#line 612 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_RIGHT;
#line 612 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 612 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4264 "page-view.c"
	}
#line 614 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp83_ = iy;
#line 614 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp84_ = crop_border;
#line 614 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp83_ < _tmp84_) {
#line 615 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_TOP;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 615 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4278 "page-view.c"
	}
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp85_ = iy;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp86_ = dh;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp87_ = crop_border;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp85_ > (_tmp86_ - _tmp87_)) {
#line 618 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_BOTTOM;
#line 618 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 618 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4294 "page-view.c"
	}
#line 621 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = CROP_LOCATION_MIDDLE;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_g_free0 (name);
#line 621 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 4302 "page-view.c"
}


void page_view_button_press (PageView* self, gint x, gint y) {
	gint _tmp0_;
	gint _tmp1_;
	CropLocation _tmp2_ = 0;
	CropLocation location;
	CropLocation _tmp3_;
#line 624 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = x;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = y;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_view_get_crop_location (self, _tmp0_, _tmp1_);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	location = _tmp2_;
#line 628 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = location;
#line 628 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp3_ != CROP_LOCATION_NONE) {
#line 4326 "page-view.c"
		CropLocation _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		Page* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		Page* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		Page* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		Page* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
#line 630 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp4_ = location;
#line 630 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->crop_location = _tmp4_;
#line 631 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp5_ = x;
#line 631 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->selected_crop_px = (gdouble) _tmp5_;
#line 632 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp6_ = y;
#line 632 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->selected_crop_py = (gdouble) _tmp6_;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = self->priv->_page;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp8_ = page_get_crop_x (_tmp7_);
#line 633 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp9_ = _tmp8_;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->selected_crop_x = _tmp9_;
#line 634 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp10_ = self->priv->_page;
#line 634 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = page_get_crop_y (_tmp10_);
#line 634 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp12_ = _tmp11_;
#line 634 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->selected_crop_y = _tmp12_;
#line 635 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp13_ = self->priv->_page;
#line 635 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp14_ = page_get_crop_width (_tmp13_);
#line 635 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp15_ = _tmp14_;
#line 635 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->selected_crop_w = _tmp15_;
#line 636 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp16_ = self->priv->_page;
#line 636 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp17_ = page_get_crop_height (_tmp16_);
#line 636 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp18_ = _tmp17_;
#line 636 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->selected_crop_h = _tmp18_;
#line 4386 "page-view.c"
	}
}


void page_view_motion (PageView* self, gint x, gint y) {
	gint _tmp0_;
	gint _tmp1_;
	CropLocation _tmp2_ = 0;
	CropLocation location;
	GdkCursorType cursor = 0;
	CropLocation _tmp3_;
	CropLocation _tmp4_;
	Page* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint pw;
	Page* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint ph;
	Page* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint cw;
	Page* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint ch;
	gint _tmp18_;
	gdouble _tmp19_;
	gint _tmp20_ = 0;
	gint dx;
	gint _tmp21_;
	gdouble _tmp22_;
	gint _tmp23_ = 0;
	gint dy;
	gint _tmp24_;
	gint new_x;
	gint _tmp25_;
	gint new_y;
	gint _tmp26_;
	gint new_w;
	gint _tmp27_;
	gint new_h;
	gint _tmp28_ = 0;
	gint min_size;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	CropLocation _tmp31_;
	gboolean _tmp33_;
	gboolean _tmp35_;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	CropLocation _tmp46_;
	gboolean _tmp48_;
	gboolean _tmp50_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	CropLocation _tmp61_;
	gboolean _tmp63_;
	gboolean _tmp65_;
	gboolean _tmp78_ = FALSE;
	gboolean _tmp79_ = FALSE;
	CropLocation _tmp80_;
	gboolean _tmp82_;
	gboolean _tmp84_;
	CropLocation _tmp97_;
	CropLocation _tmp118_;
	gboolean _tmp123_ = FALSE;
	gboolean _tmp124_ = FALSE;
	CropLocation _tmp125_;
	gboolean _tmp127_;
	gboolean _tmp129_;
	gboolean _tmp134_ = FALSE;
	gboolean _tmp135_ = FALSE;
	CropLocation _tmp136_;
	gboolean _tmp138_;
	gboolean _tmp140_;
	gboolean _tmp145_ = FALSE;
	gboolean _tmp146_ = FALSE;
	CropLocation _tmp147_;
	gboolean _tmp149_;
	gboolean _tmp151_;
	gboolean _tmp154_ = FALSE;
	gboolean _tmp155_ = FALSE;
	CropLocation _tmp156_;
	gboolean _tmp158_;
	gboolean _tmp160_;
	Page* _tmp163_;
	gint _tmp164_;
	gint _tmp165_;
	gboolean _tmp166_ = FALSE;
	gint _tmp167_;
	gint _tmp168_;
	gboolean _tmp171_;
#line 640 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = x;
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = y;
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_view_get_crop_location (self, _tmp0_, _tmp1_);
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	location = _tmp2_;
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = location;
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	switch (_tmp3_) {
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_MIDDLE:
#line 4498 "page-view.c"
		{
#line 647 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_HAND1;
#line 648 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4504 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_TOP:
#line 4508 "page-view.c"
		{
#line 650 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_TOP_SIDE;
#line 651 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4514 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_BOTTOM:
#line 4518 "page-view.c"
		{
#line 653 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_BOTTOM_SIDE;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4524 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_LEFT:
#line 4528 "page-view.c"
		{
#line 656 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_LEFT_SIDE;
#line 657 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4534 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_RIGHT:
#line 4538 "page-view.c"
		{
#line 659 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_RIGHT_SIDE;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4544 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_TOP_LEFT:
#line 4548 "page-view.c"
		{
#line 662 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_TOP_LEFT_CORNER;
#line 663 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4554 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_TOP_RIGHT:
#line 4558 "page-view.c"
		{
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_TOP_RIGHT_CORNER;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4564 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_BOTTOM_LEFT:
#line 4568 "page-view.c"
		{
#line 668 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_BOTTOM_LEFT_CORNER;
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4574 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_BOTTOM_RIGHT:
#line 4578 "page-view.c"
		{
#line 671 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_BOTTOM_RIGHT_CORNER;
#line 672 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4584 "page-view.c"
		}
		default:
		{
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_ARROW;
#line 675 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4592 "page-view.c"
		}
	}
#line 678 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = self->priv->crop_location;
#line 678 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp4_ == CROP_LOCATION_NONE) {
#line 4599 "page-view.c"
		GdkCursorType _tmp5_;
#line 680 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp5_ = cursor;
#line 680 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_set_cursor (self, _tmp5_);
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 4607 "page-view.c"
	}
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = self->priv->_page;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp7_ = page_get_width (_tmp6_);
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = _tmp7_;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	pw = _tmp8_;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp9_ = self->priv->_page;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp10_ = page_get_height (_tmp9_);
#line 686 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp11_ = _tmp10_;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	ph = _tmp11_;
#line 687 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = self->priv->_page;
#line 687 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = page_get_crop_width (_tmp12_);
#line 687 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp14_ = _tmp13_;
#line 687 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cw = _tmp14_;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp15_ = self->priv->_page;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp16_ = page_get_crop_height (_tmp15_);
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp17_ = _tmp16_;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	ch = _tmp17_;
#line 690 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp18_ = x;
#line 690 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp19_ = self->priv->selected_crop_px;
#line 690 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp20_ = page_view_screen_to_page_x (self, _tmp18_ - ((gint) _tmp19_));
#line 690 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	dx = _tmp20_;
#line 691 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp21_ = y;
#line 691 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp22_ = self->priv->selected_crop_py;
#line 691 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp23_ = page_view_screen_to_page_y (self, _tmp21_ - ((gint) _tmp22_));
#line 691 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	dy = _tmp23_;
#line 693 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp24_ = self->priv->selected_crop_x;
#line 693 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	new_x = _tmp24_;
#line 694 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp25_ = self->priv->selected_crop_y;
#line 694 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	new_y = _tmp25_;
#line 695 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp26_ = self->priv->selected_crop_w;
#line 695 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	new_w = _tmp26_;
#line 696 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp27_ = self->priv->selected_crop_h;
#line 696 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	new_h = _tmp27_;
#line 699 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp28_ = page_view_screen_to_page_x (self, 15);
#line 699 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	min_size = _tmp28_;
#line 700 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp31_ = self->priv->crop_location;
#line 700 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp31_ == CROP_LOCATION_TOP_LEFT) {
#line 700 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp30_ = TRUE;
#line 4683 "page-view.c"
	} else {
		CropLocation _tmp32_;
#line 701 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp32_ = self->priv->crop_location;
#line 701 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp30_ = _tmp32_ == CROP_LOCATION_LEFT;
#line 4690 "page-view.c"
	}
#line 700 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp33_ = _tmp30_;
#line 700 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp33_) {
#line 700 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp29_ = TRUE;
#line 4698 "page-view.c"
	} else {
		CropLocation _tmp34_;
#line 702 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp34_ = self->priv->crop_location;
#line 702 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp29_ = _tmp34_ == CROP_LOCATION_BOTTOM_LEFT;
#line 4705 "page-view.c"
	}
#line 700 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp35_ = _tmp29_;
#line 700 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp35_) {
#line 4711 "page-view.c"
		gint _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp41_;
		gint _tmp42_;
#line 704 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp36_ = dx;
#line 704 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp37_ = new_w;
#line 704 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp38_ = min_size;
#line 704 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp36_ > (_tmp37_ - _tmp38_)) {
#line 4725 "page-view.c"
			gint _tmp39_;
			gint _tmp40_;
#line 705 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp39_ = new_w;
#line 705 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp40_ = min_size;
#line 705 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dx = _tmp39_ - _tmp40_;
#line 4734 "page-view.c"
		}
#line 706 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp41_ = new_x;
#line 706 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp42_ = dx;
#line 706 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if ((_tmp41_ + _tmp42_) < 0) {
#line 4742 "page-view.c"
			gint _tmp43_;
#line 707 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp43_ = new_x;
#line 707 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dx = -_tmp43_;
#line 4748 "page-view.c"
		}
	}
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp46_ = self->priv->crop_location;
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp46_ == CROP_LOCATION_TOP_LEFT) {
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp45_ = TRUE;
#line 4757 "page-view.c"
	} else {
		CropLocation _tmp47_;
#line 710 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp47_ = self->priv->crop_location;
#line 710 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp45_ = _tmp47_ == CROP_LOCATION_TOP;
#line 4764 "page-view.c"
	}
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp48_ = _tmp45_;
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp48_) {
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp44_ = TRUE;
#line 4772 "page-view.c"
	} else {
		CropLocation _tmp49_;
#line 711 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp49_ = self->priv->crop_location;
#line 711 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp44_ = _tmp49_ == CROP_LOCATION_TOP_RIGHT;
#line 4779 "page-view.c"
	}
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp50_ = _tmp44_;
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp50_) {
#line 4785 "page-view.c"
		gint _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		gint _tmp56_;
		gint _tmp57_;
#line 713 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp51_ = dy;
#line 713 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp52_ = new_h;
#line 713 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp53_ = min_size;
#line 713 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp51_ > (_tmp52_ - _tmp53_)) {
#line 4799 "page-view.c"
			gint _tmp54_;
			gint _tmp55_;
#line 714 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp54_ = new_h;
#line 714 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp55_ = min_size;
#line 714 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dy = _tmp54_ - _tmp55_;
#line 4808 "page-view.c"
		}
#line 715 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp56_ = new_y;
#line 715 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp57_ = dy;
#line 715 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if ((_tmp56_ + _tmp57_) < 0) {
#line 4816 "page-view.c"
			gint _tmp58_;
#line 716 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp58_ = new_y;
#line 716 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dy = -_tmp58_;
#line 4822 "page-view.c"
		}
	}
#line 719 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp61_ = self->priv->crop_location;
#line 719 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp61_ == CROP_LOCATION_TOP_RIGHT) {
#line 719 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp60_ = TRUE;
#line 4831 "page-view.c"
	} else {
		CropLocation _tmp62_;
#line 720 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp62_ = self->priv->crop_location;
#line 720 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp60_ = _tmp62_ == CROP_LOCATION_RIGHT;
#line 4838 "page-view.c"
	}
#line 719 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp63_ = _tmp60_;
#line 719 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp63_) {
#line 719 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp59_ = TRUE;
#line 4846 "page-view.c"
	} else {
		CropLocation _tmp64_;
#line 721 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp64_ = self->priv->crop_location;
#line 721 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp59_ = _tmp64_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 4853 "page-view.c"
	}
#line 719 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp65_ = _tmp59_;
#line 719 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp65_) {
#line 4859 "page-view.c"
		gint _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		gint _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp66_ = dx;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp67_ = min_size;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp68_ = new_w;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp66_ < (_tmp67_ - _tmp68_)) {
#line 4875 "page-view.c"
			gint _tmp69_;
			gint _tmp70_;
#line 724 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp69_ = min_size;
#line 724 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp70_ = new_w;
#line 724 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dx = _tmp69_ - _tmp70_;
#line 4884 "page-view.c"
		}
#line 725 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp71_ = new_x;
#line 725 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp72_ = new_w;
#line 725 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp73_ = dx;
#line 725 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp74_ = pw;
#line 725 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (((_tmp71_ + _tmp72_) + _tmp73_) > _tmp74_) {
#line 4896 "page-view.c"
			gint _tmp75_;
			gint _tmp76_;
			gint _tmp77_;
#line 726 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp75_ = pw;
#line 726 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp76_ = new_x;
#line 726 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp77_ = new_w;
#line 726 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dx = (_tmp75_ - _tmp76_) - _tmp77_;
#line 4908 "page-view.c"
		}
	}
#line 728 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp80_ = self->priv->crop_location;
#line 728 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp80_ == CROP_LOCATION_BOTTOM_LEFT) {
#line 728 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp79_ = TRUE;
#line 4917 "page-view.c"
	} else {
		CropLocation _tmp81_;
#line 729 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp81_ = self->priv->crop_location;
#line 729 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp79_ = _tmp81_ == CROP_LOCATION_BOTTOM;
#line 4924 "page-view.c"
	}
#line 728 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp82_ = _tmp79_;
#line 728 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp82_) {
#line 728 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp78_ = TRUE;
#line 4932 "page-view.c"
	} else {
		CropLocation _tmp83_;
#line 730 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp83_ = self->priv->crop_location;
#line 730 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp78_ = _tmp83_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 4939 "page-view.c"
	}
#line 728 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp84_ = _tmp78_;
#line 728 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp84_) {
#line 4945 "page-view.c"
		gint _tmp85_;
		gint _tmp86_;
		gint _tmp87_;
		gint _tmp90_;
		gint _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
#line 732 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp85_ = dy;
#line 732 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp86_ = min_size;
#line 732 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp87_ = new_h;
#line 732 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp85_ < (_tmp86_ - _tmp87_)) {
#line 4961 "page-view.c"
			gint _tmp88_;
			gint _tmp89_;
#line 733 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp88_ = min_size;
#line 733 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp89_ = new_h;
#line 733 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dy = _tmp88_ - _tmp89_;
#line 4970 "page-view.c"
		}
#line 734 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp90_ = new_y;
#line 734 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp91_ = new_h;
#line 734 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp92_ = dy;
#line 734 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp93_ = ph;
#line 734 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (((_tmp90_ + _tmp91_) + _tmp92_) > _tmp93_) {
#line 4982 "page-view.c"
			gint _tmp94_;
			gint _tmp95_;
			gint _tmp96_;
#line 735 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp94_ = ph;
#line 735 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp95_ = new_y;
#line 735 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp96_ = new_h;
#line 735 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dy = (_tmp94_ - _tmp95_) - _tmp96_;
#line 4994 "page-view.c"
		}
	}
#line 737 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp97_ = self->priv->crop_location;
#line 737 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp97_ == CROP_LOCATION_MIDDLE) {
#line 5001 "page-view.c"
		gint _tmp98_;
		gint _tmp99_;
		gint _tmp100_;
		gint _tmp101_;
		gint _tmp105_;
		gint _tmp106_;
		gint _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		gint _tmp111_;
		gint _tmp115_;
		gint _tmp116_;
#line 739 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp98_ = new_x;
#line 739 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp99_ = dx;
#line 739 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp100_ = new_w;
#line 739 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp101_ = pw;
#line 739 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (((_tmp98_ + _tmp99_) + _tmp100_) > _tmp101_) {
#line 5024 "page-view.c"
			gint _tmp102_;
			gint _tmp103_;
			gint _tmp104_;
#line 740 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp102_ = pw;
#line 740 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp103_ = new_x;
#line 740 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp104_ = new_w;
#line 740 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dx = (_tmp102_ - _tmp103_) - _tmp104_;
#line 5036 "page-view.c"
		}
#line 741 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp105_ = new_x;
#line 741 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp106_ = dx;
#line 741 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if ((_tmp105_ + _tmp106_) < 0) {
#line 5044 "page-view.c"
			gint _tmp107_;
#line 742 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp107_ = new_x;
#line 742 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dx = -_tmp107_;
#line 5050 "page-view.c"
		}
#line 743 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp108_ = new_y;
#line 743 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp109_ = dy;
#line 743 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp110_ = new_h;
#line 743 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp111_ = ph;
#line 743 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (((_tmp108_ + _tmp109_) + _tmp110_) > _tmp111_) {
#line 5062 "page-view.c"
			gint _tmp112_;
			gint _tmp113_;
			gint _tmp114_;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp112_ = ph;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp113_ = new_y;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp114_ = new_h;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dy = (_tmp112_ - _tmp113_) - _tmp114_;
#line 5074 "page-view.c"
		}
#line 745 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp115_ = new_y;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp116_ = dy;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if ((_tmp115_ + _tmp116_) < 0) {
#line 5082 "page-view.c"
			gint _tmp117_;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp117_ = new_y;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dy = -_tmp117_;
#line 5088 "page-view.c"
		}
	}
#line 750 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp118_ = self->priv->crop_location;
#line 750 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp118_ == CROP_LOCATION_MIDDLE) {
#line 5095 "page-view.c"
		gint _tmp119_;
		gint _tmp120_;
		gint _tmp121_;
		gint _tmp122_;
#line 752 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp119_ = new_x;
#line 752 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp120_ = dx;
#line 752 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_x = _tmp119_ + _tmp120_;
#line 753 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp121_ = new_y;
#line 753 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp122_ = dy;
#line 753 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_y = _tmp121_ + _tmp122_;
#line 5112 "page-view.c"
	}
#line 755 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp125_ = self->priv->crop_location;
#line 755 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp125_ == CROP_LOCATION_TOP_LEFT) {
#line 755 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp124_ = TRUE;
#line 5120 "page-view.c"
	} else {
		CropLocation _tmp126_;
#line 756 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp126_ = self->priv->crop_location;
#line 756 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp124_ = _tmp126_ == CROP_LOCATION_LEFT;
#line 5127 "page-view.c"
	}
#line 755 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp127_ = _tmp124_;
#line 755 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp127_) {
#line 755 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp123_ = TRUE;
#line 5135 "page-view.c"
	} else {
		CropLocation _tmp128_;
#line 757 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp128_ = self->priv->crop_location;
#line 757 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp123_ = _tmp128_ == CROP_LOCATION_BOTTOM_LEFT;
#line 5142 "page-view.c"
	}
#line 755 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp129_ = _tmp123_;
#line 755 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp129_) {
#line 5148 "page-view.c"
		gint _tmp130_;
		gint _tmp131_;
		gint _tmp132_;
		gint _tmp133_;
#line 759 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp130_ = new_x;
#line 759 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp131_ = dx;
#line 759 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_x = _tmp130_ + _tmp131_;
#line 760 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp132_ = new_w;
#line 760 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp133_ = dx;
#line 760 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_w = _tmp132_ - _tmp133_;
#line 5165 "page-view.c"
	}
#line 762 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp136_ = self->priv->crop_location;
#line 762 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp136_ == CROP_LOCATION_TOP_LEFT) {
#line 762 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp135_ = TRUE;
#line 5173 "page-view.c"
	} else {
		CropLocation _tmp137_;
#line 763 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp137_ = self->priv->crop_location;
#line 763 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp135_ = _tmp137_ == CROP_LOCATION_TOP;
#line 5180 "page-view.c"
	}
#line 762 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp138_ = _tmp135_;
#line 762 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp138_) {
#line 762 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp134_ = TRUE;
#line 5188 "page-view.c"
	} else {
		CropLocation _tmp139_;
#line 764 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp139_ = self->priv->crop_location;
#line 764 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp134_ = _tmp139_ == CROP_LOCATION_TOP_RIGHT;
#line 5195 "page-view.c"
	}
#line 762 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp140_ = _tmp134_;
#line 762 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp140_) {
#line 5201 "page-view.c"
		gint _tmp141_;
		gint _tmp142_;
		gint _tmp143_;
		gint _tmp144_;
#line 766 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp141_ = new_y;
#line 766 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp142_ = dy;
#line 766 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_y = _tmp141_ + _tmp142_;
#line 767 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp143_ = new_h;
#line 767 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp144_ = dy;
#line 767 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_h = _tmp143_ - _tmp144_;
#line 5218 "page-view.c"
	}
#line 770 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp147_ = self->priv->crop_location;
#line 770 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp147_ == CROP_LOCATION_TOP_RIGHT) {
#line 770 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp146_ = TRUE;
#line 5226 "page-view.c"
	} else {
		CropLocation _tmp148_;
#line 771 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp148_ = self->priv->crop_location;
#line 771 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp146_ = _tmp148_ == CROP_LOCATION_RIGHT;
#line 5233 "page-view.c"
	}
#line 770 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp149_ = _tmp146_;
#line 770 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp149_) {
#line 770 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp145_ = TRUE;
#line 5241 "page-view.c"
	} else {
		CropLocation _tmp150_;
#line 772 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp150_ = self->priv->crop_location;
#line 772 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp145_ = _tmp150_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 5248 "page-view.c"
	}
#line 770 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp151_ = _tmp145_;
#line 770 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp151_) {
#line 5254 "page-view.c"
		gint _tmp152_;
		gint _tmp153_;
#line 773 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp152_ = new_w;
#line 773 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp153_ = dx;
#line 773 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_w = _tmp152_ + _tmp153_;
#line 5263 "page-view.c"
	}
#line 774 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp156_ = self->priv->crop_location;
#line 774 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp156_ == CROP_LOCATION_BOTTOM_LEFT) {
#line 774 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp155_ = TRUE;
#line 5271 "page-view.c"
	} else {
		CropLocation _tmp157_;
#line 775 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp157_ = self->priv->crop_location;
#line 775 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp155_ = _tmp157_ == CROP_LOCATION_BOTTOM;
#line 5278 "page-view.c"
	}
#line 774 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp158_ = _tmp155_;
#line 774 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp158_) {
#line 774 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp154_ = TRUE;
#line 5286 "page-view.c"
	} else {
		CropLocation _tmp159_;
#line 776 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp159_ = self->priv->crop_location;
#line 776 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp154_ = _tmp159_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 5293 "page-view.c"
	}
#line 774 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp160_ = _tmp154_;
#line 774 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp160_) {
#line 5299 "page-view.c"
		gint _tmp161_;
		gint _tmp162_;
#line 777 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp161_ = new_h;
#line 777 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp162_ = dy;
#line 777 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_h = _tmp161_ + _tmp162_;
#line 5308 "page-view.c"
	}
#line 779 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp163_ = self->priv->_page;
#line 779 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp164_ = new_x;
#line 779 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp165_ = new_y;
#line 779 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_move_crop (_tmp163_, _tmp164_, _tmp165_);
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp167_ = new_w;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp168_ = cw;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp167_ != _tmp168_) {
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp166_ = TRUE;
#line 5326 "page-view.c"
	} else {
		gint _tmp169_;
		gint _tmp170_;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp169_ = new_h;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp170_ = ch;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp166_ = _tmp169_ != _tmp170_;
#line 5336 "page-view.c"
	}
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp171_ = _tmp166_;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp171_) {
#line 5342 "page-view.c"
		Page* _tmp172_;
		gint _tmp173_;
		gint _tmp174_;
#line 783 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp172_ = self->priv->_page;
#line 783 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp173_ = new_w;
#line 783 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp174_ = new_h;
#line 783 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_set_custom_crop (_tmp172_, _tmp173_, _tmp174_);
#line 5354 "page-view.c"
	}
}


void page_view_button_release (PageView* self, gint x, gint y) {
#line 786 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 789 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->crop_location = CROP_LOCATION_NONE;
#line 790 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 5366 "page-view.c"
}


static gboolean page_view_animation_cb (PageView* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
#line 793 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 795 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->animate_segment;
#line 795 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->animate_n_segments;
#line 795 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->animate_segment = (_tmp0_ + 1) % _tmp1_;
#line 796 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 797 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = TRUE;
#line 797 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 5388 "page-view.c"
}


static gboolean _page_view_animation_cb_gsource_func (gpointer self) {
	gboolean result;
	result = page_view_animation_cb (self);
#line 813 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 5397 "page-view.c"
}


static void page_view_update_animation (PageView* self) {
	gboolean animate = FALSE;
	gboolean is_animating = FALSE;
	gboolean _tmp0_ = FALSE;
	Page* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp7_;
	guint _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
#line 800 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->_page;
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_get_is_scanning (_tmp1_);
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp3_) {
#line 5423 "page-view.c"
		Page* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp4_ = self->priv->_page;
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp5_ = page_get_has_data (_tmp4_);
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp6_ = _tmp5_;
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp0_ = !_tmp6_;
#line 5435 "page-view.c"
	} else {
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp0_ = FALSE;
#line 5439 "page-view.c"
	}
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp7_ = _tmp0_;
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	animate = _tmp7_;
#line 805 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = self->priv->animate_timeout;
#line 805 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	is_animating = _tmp8_ != ((guint) 0);
#line 806 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp9_ = animate;
#line 806 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp10_ = is_animating;
#line 806 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp9_ == _tmp10_) {
#line 807 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 5457 "page-view.c"
	}
#line 809 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp11_ = animate;
#line 809 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp11_) {
#line 5463 "page-view.c"
		guint _tmp12_;
#line 811 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->animate_segment = 0;
#line 812 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp12_ = self->priv->animate_timeout;
#line 812 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp12_ == ((guint) 0)) {
#line 5471 "page-view.c"
			guint _tmp13_ = 0U;
#line 813 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp13_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, _page_view_animation_cb_gsource_func, page_view_ref (self), page_view_unref);
#line 813 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			self->priv->animate_timeout = _tmp13_;
#line 5477 "page-view.c"
		}
	} else {
		guint _tmp14_;
#line 817 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp14_ = self->priv->animate_timeout;
#line 817 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp14_ != ((guint) 0)) {
#line 5485 "page-view.c"
			guint _tmp15_;
#line 818 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp15_ = self->priv->animate_timeout;
#line 818 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			g_source_remove (_tmp15_);
#line 5491 "page-view.c"
		}
#line 819 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->animate_timeout = (guint) 0;
#line 5495 "page-view.c"
	}
}


void page_view_render (PageView* self, cairo_t* context) {
	gint _tmp0_ = 0;
	gint w;
	gint _tmp1_ = 0;
	gint h;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	gint _tmp8_;
	cairo_t* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	cairo_t* _tmp20_;
	GdkPixbuf* _tmp21_;
	cairo_t* _tmp22_;
	gboolean _tmp23_ = FALSE;
	Page* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp30_;
	gboolean _tmp72_ = FALSE;
	Page* _tmp73_;
	gboolean _tmp74_;
	gboolean _tmp75_;
	gboolean _tmp79_;
	Page* _tmp121_;
	gboolean _tmp122_;
	gboolean _tmp123_;
#line 823 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 823 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (context != NULL);
#line 825 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_update_animation (self);
#line 826 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_update_page_view (self);
#line 828 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = page_view_get_preview_width (self);
#line 828 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	w = _tmp0_;
#line 829 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = page_view_get_preview_height (self);
#line 829 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	h = _tmp1_;
#line 831 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = context;
#line 831 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_set_line_width (_tmp2_, (gdouble) 1);
#line 832 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = context;
#line 832 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = self->priv->_x_offset;
#line 832 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = self->priv->_y_offset;
#line 832 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_translate (_tmp3_, (gdouble) _tmp4_, (gdouble) _tmp5_);
#line 835 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = context;
#line 835 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_set_source_rgb (_tmp6_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 836 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp7_ = context;
#line 836 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = self->priv->border_width;
#line 836 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_set_line_width (_tmp7_, (gdouble) _tmp8_);
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp9_ = context;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp10_ = self->priv->border_width;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp11_ = self->priv->border_width;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = self->priv->width;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = self->priv->border_width;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp14_ = self->priv->height;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp15_ = self->priv->border_width;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_rectangle (_tmp9_, ((gdouble) _tmp10_) / 2, ((gdouble) _tmp11_) / 2, (gdouble) (_tmp12_ - _tmp13_), (gdouble) (_tmp14_ - _tmp15_));
#line 841 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp16_ = context;
#line 841 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_stroke (_tmp16_);
#line 844 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp17_ = context;
#line 844 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp18_ = self->priv->border_width;
#line 844 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp19_ = self->priv->border_width;
#line 844 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_translate (_tmp17_, (gdouble) _tmp18_, (gdouble) _tmp19_);
#line 845 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp20_ = context;
#line 845 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp21_ = self->priv->image;
#line 845 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	gdk_cairo_set_source_pixbuf (_tmp20_, _tmp21_, (gdouble) 0, (gdouble) 0);
#line 846 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp22_ = context;
#line 846 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_paint (_tmp22_);
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp24_ = self->priv->_page;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp25_ = page_get_is_scanning (_tmp24_);
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp26_ = _tmp25_;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp26_) {
#line 5623 "page-view.c"
		Page* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp27_ = self->priv->_page;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp28_ = page_get_has_data (_tmp27_);
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp29_ = _tmp28_;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp23_ = !_tmp29_;
#line 5635 "page-view.c"
	} else {
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp23_ = FALSE;
#line 5639 "page-view.c"
	}
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp30_ = _tmp23_;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp30_) {
#line 5645 "page-view.c"
		gdouble outer_radius = 0.0;
		gint _tmp31_;
		gint _tmp32_;
		gint _tmp35_;
		gdouble arc;
		gdouble _tmp36_;
		gdouble _tmp37_;
		gdouble _tmp38_ = 0.0;
		gdouble x;
		gdouble _tmp39_;
		gdouble _tmp40_;
		gdouble _tmp41_ = 0.0;
		gdouble y;
		gdouble _tmp42_;
		gdouble _tmp43_;
		gdouble _tmp44_;
		gdouble _tmp45_;
		gdouble _tmp46_ = 0.0;
		gdouble inner_radius;
		gdouble offset;
#line 852 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp31_ = w;
#line 852 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp32_ = h;
#line 852 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp31_ > _tmp32_) {
#line 5672 "page-view.c"
			gint _tmp33_;
#line 853 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp33_ = w;
#line 853 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			outer_radius = 0.15 * _tmp33_;
#line 5678 "page-view.c"
		} else {
			gint _tmp34_;
#line 855 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp34_ = h;
#line 855 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			outer_radius = 0.15 * _tmp34_;
#line 5685 "page-view.c"
		}
#line 856 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp35_ = self->priv->animate_n_segments;
#line 856 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		arc = G_PI / _tmp35_;
#line 859 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp36_ = outer_radius;
#line 859 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp37_ = arc;
#line 859 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp38_ = sin (_tmp37_);
#line 859 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		x = _tmp36_ * _tmp38_;
#line 860 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp39_ = outer_radius;
#line 860 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp40_ = arc;
#line 860 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp41_ = cos (_tmp40_);
#line 860 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		y = _tmp39_ * (_tmp41_ - 1.0);
#line 861 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp42_ = x;
#line 861 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp43_ = x;
#line 861 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp44_ = y;
#line 861 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp45_ = y;
#line 861 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp46_ = sqrt ((_tmp42_ * _tmp43_) + (_tmp44_ * _tmp45_));
#line 861 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		inner_radius = 0.6 * _tmp46_;
#line 863 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		offset = 0.0;
#line 5721 "page-view.c"
		{
			gint i;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			i = 0;
#line 5726 "page-view.c"
			{
				gboolean _tmp47_;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp47_ = TRUE;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				while (TRUE) {
#line 5733 "page-view.c"
					gboolean _tmp48_;
					gint _tmp52_;
					gint _tmp53_;
					gint _tmp54_;
					gdouble _tmp55_;
					gdouble _tmp56_;
					gdouble _tmp57_ = 0.0;
					gint _tmp58_;
					gdouble _tmp59_;
					gdouble _tmp60_;
					gdouble _tmp61_ = 0.0;
					cairo_t* _tmp62_;
					gdouble _tmp63_;
					gdouble _tmp64_;
					gdouble _tmp65_;
					gint _tmp66_;
					gint _tmp67_;
					cairo_t* _tmp70_;
					cairo_t* _tmp71_;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp48_ = _tmp47_;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					if (!_tmp48_) {
#line 5757 "page-view.c"
						gint _tmp49_;
						gdouble _tmp50_;
						gdouble _tmp51_;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp49_ = i;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						i = _tmp49_ + 1;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp50_ = offset;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp51_ = arc;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						offset = _tmp50_ + (_tmp51_ * 2);
#line 5771 "page-view.c"
					}
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp47_ = FALSE;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp52_ = i;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp53_ = self->priv->animate_n_segments;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					if (!(_tmp52_ < _tmp53_)) {
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						break;
#line 5783 "page-view.c"
					}
#line 866 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp54_ = w;
#line 866 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp55_ = outer_radius;
#line 866 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp56_ = offset;
#line 866 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp57_ = sin (_tmp56_);
#line 866 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					x = (_tmp54_ / 2) + (_tmp55_ * _tmp57_);
#line 867 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp58_ = h;
#line 867 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp59_ = outer_radius;
#line 867 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp60_ = offset;
#line 867 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp61_ = cos (_tmp60_);
#line 867 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					y = (_tmp58_ / 2) - (_tmp59_ * _tmp61_);
#line 868 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp62_ = context;
#line 868 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp63_ = x;
#line 868 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp64_ = y;
#line 868 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp65_ = inner_radius;
#line 868 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					cairo_arc (_tmp62_, _tmp63_, _tmp64_, _tmp65_, (gdouble) 0, 2 * G_PI);
#line 870 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp66_ = i;
#line 870 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp67_ = self->priv->animate_segment;
#line 870 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					if (_tmp66_ == _tmp67_) {
#line 5821 "page-view.c"
						cairo_t* _tmp68_;
						cairo_t* _tmp69_;
#line 872 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp68_ = context;
#line 872 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						cairo_set_source_rgb (_tmp68_, 0.75, 0.75, 0.75);
#line 873 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp69_ = context;
#line 873 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						cairo_fill_preserve (_tmp69_);
#line 5832 "page-view.c"
					}
#line 876 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp70_ = context;
#line 876 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					cairo_set_source_rgb (_tmp70_, 0.5, 0.5, 0.5);
#line 877 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp71_ = context;
#line 877 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					cairo_stroke (_tmp71_);
#line 5842 "page-view.c"
				}
			}
		}
	}
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp73_ = self->priv->_page;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp74_ = page_get_is_scanning (_tmp73_);
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp75_ = _tmp74_;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp75_) {
#line 5855 "page-view.c"
		Page* _tmp76_;
		gint _tmp77_;
		gint _tmp78_;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp76_ = self->priv->_page;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp77_ = page_get_scan_line (_tmp76_);
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp78_ = _tmp77_;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp72_ = _tmp78_ > 0;
#line 5867 "page-view.c"
	} else {
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp72_ = FALSE;
#line 5871 "page-view.c"
	}
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp79_ = _tmp72_;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp79_) {
#line 5877 "page-view.c"
		Page* _tmp80_;
		gint _tmp81_;
		gint _tmp82_;
		gint scan_line;
		gdouble s = 0.0;
		gdouble x1 = 0.0;
		gdouble y1 = 0.0;
		gdouble x2 = 0.0;
		gdouble y2 = 0.0;
		Page* _tmp83_;
		ScanDirection _tmp84_;
		ScanDirection _tmp85_;
		cairo_t* _tmp113_;
		gdouble _tmp114_;
		gdouble _tmp115_;
		cairo_t* _tmp116_;
		gdouble _tmp117_;
		gdouble _tmp118_;
		cairo_t* _tmp119_;
		cairo_t* _tmp120_;
#line 884 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp80_ = self->priv->_page;
#line 884 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp81_ = page_get_scan_line (_tmp80_);
#line 884 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp82_ = _tmp81_;
#line 884 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		scan_line = _tmp82_;
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp83_ = self->priv->_page;
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp84_ = page_get_scan_direction (_tmp83_);
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp85_ = _tmp84_;
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		switch (_tmp85_) {
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 5916 "page-view.c"
			{
				gint _tmp86_;
				gint _tmp87_ = 0;
				gdouble _tmp88_;
				gint _tmp89_;
				gdouble _tmp90_;
#line 891 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp86_ = scan_line;
#line 891 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp87_ = page_view_page_to_screen_y (self, _tmp86_);
#line 891 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				s = (gdouble) _tmp87_;
#line 892 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x1 = (gdouble) 0;
#line 892 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp88_ = s;
#line 892 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y1 = _tmp88_ + 0.5;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp89_ = w;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x2 = (gdouble) _tmp89_;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp90_ = s;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y2 = _tmp90_ + 0.5;
#line 894 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 5945 "page-view.c"
			}
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 5949 "page-view.c"
			{
				gint _tmp91_;
				gint _tmp92_ = 0;
				gint _tmp93_;
				gdouble _tmp94_;
				gint _tmp95_;
				gint _tmp96_;
				gdouble _tmp97_;
#line 896 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp91_ = scan_line;
#line 896 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp92_ = page_view_page_to_screen_y (self, _tmp91_);
#line 896 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				s = (gdouble) _tmp92_;
#line 897 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x1 = (gdouble) 0;
#line 897 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp93_ = h;
#line 897 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp94_ = s;
#line 897 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y1 = (_tmp93_ - _tmp94_) + 0.5;
#line 898 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp95_ = w;
#line 898 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x2 = (gdouble) _tmp95_;
#line 898 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp96_ = h;
#line 898 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp97_ = s;
#line 898 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y2 = (_tmp96_ - _tmp97_) + 0.5;
#line 899 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 5984 "page-view.c"
			}
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 5988 "page-view.c"
			{
				gint _tmp98_;
				gint _tmp99_ = 0;
				gdouble _tmp100_;
				gdouble _tmp101_;
				gint _tmp102_;
#line 901 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp98_ = scan_line;
#line 901 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp99_ = page_view_page_to_screen_x (self, _tmp98_);
#line 901 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				s = (gdouble) _tmp99_;
#line 902 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp100_ = s;
#line 902 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x1 = _tmp100_ + 0.5;
#line 902 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y1 = (gdouble) 0;
#line 903 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp101_ = s;
#line 903 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x2 = _tmp101_ + 0.5;
#line 903 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp102_ = h;
#line 903 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y2 = (gdouble) _tmp102_;
#line 904 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 6017 "page-view.c"
			}
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 6021 "page-view.c"
			{
				gint _tmp103_;
				gint _tmp104_ = 0;
				gint _tmp105_;
				gdouble _tmp106_;
				gint _tmp107_;
				gdouble _tmp108_;
				gint _tmp109_;
#line 906 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp103_ = scan_line;
#line 906 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp104_ = page_view_page_to_screen_x (self, _tmp103_);
#line 906 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				s = (gdouble) _tmp104_;
#line 907 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp105_ = w;
#line 907 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp106_ = s;
#line 907 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x1 = (_tmp105_ - _tmp106_) + 0.5;
#line 907 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y1 = (gdouble) 0;
#line 908 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp107_ = w;
#line 908 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp108_ = s;
#line 908 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x2 = (_tmp107_ - _tmp108_) + 0.5;
#line 908 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp109_ = h;
#line 908 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y2 = (gdouble) _tmp109_;
#line 909 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 6056 "page-view.c"
			}
			default:
			{
				gdouble _tmp110_;
				gdouble _tmp111_;
				gdouble _tmp112_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y2 = (gdouble) 0;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp110_ = y2;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x2 = _tmp110_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp111_ = x2;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y1 = _tmp111_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp112_ = y1;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x1 = _tmp112_;
#line 912 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 6079 "page-view.c"
			}
		}
#line 915 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp113_ = context;
#line 915 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp114_ = x1;
#line 915 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp115_ = y1;
#line 915 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_move_to (_tmp113_, _tmp114_, _tmp115_);
#line 916 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp116_ = context;
#line 916 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp117_ = x2;
#line 916 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp118_ = y2;
#line 916 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_line_to (_tmp116_, _tmp117_, _tmp118_);
#line 917 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp119_ = context;
#line 917 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_set_source_rgb (_tmp119_, 1.0, 0.0, 0.0);
#line 918 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp120_ = context;
#line 918 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_stroke (_tmp120_);
#line 6106 "page-view.c"
	}
#line 922 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp121_ = self->priv->_page;
#line 922 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp122_ = page_get_has_crop (_tmp121_);
#line 922 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp123_ = _tmp122_;
#line 922 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp123_) {
#line 6116 "page-view.c"
		Page* _tmp124_;
		gint _tmp125_;
		gint _tmp126_;
		gint x;
		Page* _tmp127_;
		gint _tmp128_;
		gint _tmp129_;
		gint y;
		Page* _tmp130_;
		gint _tmp131_;
		gint _tmp132_;
		gint crop_width;
		Page* _tmp133_;
		gint _tmp134_;
		gint _tmp135_;
		gint crop_height;
		gint _tmp136_;
		gint _tmp137_ = 0;
		gint dx;
		gint _tmp138_;
		gint _tmp139_ = 0;
		gint dy;
		gint _tmp140_;
		gint _tmp141_ = 0;
		gint dw;
		gint _tmp142_;
		gint _tmp143_ = 0;
		gint dh;
		cairo_t* _tmp144_;
		gint _tmp145_;
		gint _tmp146_;
		cairo_t* _tmp147_;
		cairo_t* _tmp148_;
		gint _tmp149_;
		gint _tmp150_;
		gint _tmp151_;
		gint _tmp152_;
		cairo_t* _tmp153_;
		cairo_t* _tmp154_;
		cairo_t* _tmp155_;
		cairo_t* _tmp156_;
		gint _tmp157_;
		gint _tmp158_;
		gint _tmp159_;
		gint _tmp160_;
		cairo_t* _tmp161_;
		cairo_t* _tmp162_;
		cairo_t* _tmp163_;
		gint _tmp164_;
		gint _tmp165_;
		gint _tmp166_;
		gint _tmp167_;
		cairo_t* _tmp168_;
		cairo_t* _tmp169_;
#line 924 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp124_ = self->priv->_page;
#line 924 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp125_ = page_get_crop_x (_tmp124_);
#line 924 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp126_ = _tmp125_;
#line 924 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		x = _tmp126_;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp127_ = self->priv->_page;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp128_ = page_get_crop_y (_tmp127_);
#line 925 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp129_ = _tmp128_;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		y = _tmp129_;
#line 926 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp130_ = self->priv->_page;
#line 926 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp131_ = page_get_crop_width (_tmp130_);
#line 926 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp132_ = _tmp131_;
#line 926 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		crop_width = _tmp132_;
#line 927 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp133_ = self->priv->_page;
#line 927 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp134_ = page_get_crop_height (_tmp133_);
#line 927 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp135_ = _tmp134_;
#line 927 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		crop_height = _tmp135_;
#line 929 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp136_ = x;
#line 929 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp137_ = page_view_page_to_screen_x (self, _tmp136_);
#line 929 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		dx = _tmp137_;
#line 930 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp138_ = y;
#line 930 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp139_ = page_view_page_to_screen_y (self, _tmp138_);
#line 930 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		dy = _tmp139_;
#line 931 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp140_ = crop_width;
#line 931 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp141_ = page_view_page_to_screen_x (self, _tmp140_);
#line 931 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		dw = _tmp141_;
#line 932 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp142_ = crop_height;
#line 932 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp143_ = page_view_page_to_screen_y (self, _tmp142_);
#line 932 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		dh = _tmp143_;
#line 935 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp144_ = context;
#line 935 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp145_ = w;
#line 935 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp146_ = h;
#line 935 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_rectangle (_tmp144_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp145_, (gdouble) _tmp146_);
#line 936 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp147_ = context;
#line 936 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_new_sub_path (_tmp147_);
#line 937 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp148_ = context;
#line 937 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp149_ = dx;
#line 937 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp150_ = dy;
#line 937 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp151_ = dw;
#line 937 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp152_ = dh;
#line 937 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_rectangle (_tmp148_, (gdouble) _tmp149_, (gdouble) _tmp150_, (gdouble) _tmp151_, (gdouble) _tmp152_);
#line 938 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp153_ = context;
#line 938 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_set_fill_rule (_tmp153_, CAIRO_FILL_RULE_EVEN_ODD);
#line 939 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp154_ = context;
#line 939 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_set_source_rgba (_tmp154_, 0.25, 0.25, 0.25, 0.2);
#line 940 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp155_ = context;
#line 940 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_fill (_tmp155_);
#line 943 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp156_ = context;
#line 943 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp157_ = dx;
#line 943 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp158_ = dy;
#line 943 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp159_ = dw;
#line 943 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp160_ = dh;
#line 943 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_rectangle (_tmp156_, _tmp157_ - 1.5, _tmp158_ - 1.5, (gdouble) (_tmp159_ + 3), (gdouble) (_tmp160_ + 3));
#line 944 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp161_ = context;
#line 944 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_set_source_rgb (_tmp161_, 1.0, 1.0, 1.0);
#line 945 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp162_ = context;
#line 945 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_stroke (_tmp162_);
#line 946 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp163_ = context;
#line 946 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp164_ = dx;
#line 946 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp165_ = dy;
#line 946 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp166_ = dw;
#line 946 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp167_ = dh;
#line 946 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_rectangle (_tmp163_, _tmp164_ - 0.5, _tmp165_ - 0.5, (gdouble) (_tmp166_ + 1), (gdouble) (_tmp167_ + 1));
#line 947 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp168_ = context;
#line 947 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_set_source_rgb (_tmp168_, 0.0, 0.0, 0.0);
#line 948 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp169_ = context;
#line 948 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_stroke (_tmp169_);
#line 6303 "page-view.c"
	}
}


void page_view_set_width (PageView* self, gint width) {
	gint _tmp0_;
	Page* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Page* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint height;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
#line 952 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 955 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = width;
#line 955 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->_page;
#line 955 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_get_height (_tmp1_);
#line 955 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 955 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = self->priv->_page;
#line 955 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = page_get_width (_tmp4_);
#line 955 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = _tmp5_;
#line 955 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	height = (gint) ((((gdouble) _tmp0_) * _tmp3_) / _tmp6_);
#line 956 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = self->priv->width;
#line 956 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp9_ = width;
#line 956 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp8_ == _tmp9_) {
#line 6347 "page-view.c"
		gint _tmp10_;
		gint _tmp11_;
#line 956 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp10_ = self->priv->height;
#line 956 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = height;
#line 956 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = _tmp10_ == _tmp11_;
#line 6356 "page-view.c"
	} else {
#line 956 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = FALSE;
#line 6360 "page-view.c"
	}
#line 956 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = _tmp7_;
#line 956 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp12_) {
#line 957 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 6368 "page-view.c"
	}
#line 959 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = width;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->width = _tmp13_;
#line 960 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp14_ = height;
#line 960 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->height = _tmp14_;
#line 963 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 965 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 966 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6384 "page-view.c"
}


void page_view_set_height (PageView* self, gint height) {
	gint _tmp0_;
	Page* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Page* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint width;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
#line 969 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 972 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = height;
#line 972 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->_page;
#line 972 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_get_width (_tmp1_);
#line 972 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 972 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = self->priv->_page;
#line 972 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = page_get_height (_tmp4_);
#line 972 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = _tmp5_;
#line 972 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	width = (gint) ((((gdouble) _tmp0_) * _tmp3_) / _tmp6_);
#line 973 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = self->priv->width;
#line 973 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp9_ = width;
#line 973 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp8_ == _tmp9_) {
#line 6427 "page-view.c"
		gint _tmp10_;
		gint _tmp11_;
#line 973 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp10_ = self->priv->height;
#line 973 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = height;
#line 973 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = _tmp10_ == _tmp11_;
#line 6436 "page-view.c"
	} else {
#line 973 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = FALSE;
#line 6440 "page-view.c"
	}
#line 973 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = _tmp7_;
#line 973 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp12_) {
#line 974 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 6448 "page-view.c"
	}
#line 976 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = width;
#line 976 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->width = _tmp13_;
#line 977 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp14_ = height;
#line 977 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->height = _tmp14_;
#line 980 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 982 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 983 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6464 "page-view.c"
}


gint page_view_get_width (PageView* self) {
	gint result = 0;
	gint _tmp0_;
#line 986 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 988 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->width;
#line 988 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_;
#line 988 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 6479 "page-view.c"
}


gint page_view_get_height (PageView* self) {
	gint result = 0;
	gint _tmp0_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 993 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->height;
#line 993 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_;
#line 993 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 6494 "page-view.c"
}


static void page_view_page_pixels_changed_cb (PageView* self, Page* p) {
#line 996 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 996 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 999 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 1000 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6507 "page-view.c"
}


static void page_view_page_size_changed_cb (PageView* self, Page* p) {
#line 1003 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 1003 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 1006 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 1007 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 1008 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6522 "page-view.c"
}


static void page_view_page_overlay_changed_cb (PageView* self, Page* p) {
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 1013 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6533 "page-view.c"
}


static void page_view_scan_direction_changed_cb (PageView* self, Page* p) {
#line 1016 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 1016 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 1019 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 1020 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 1021 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6548 "page-view.c"
}


Page* page_view_get_page (PageView* self) {
	Page* result;
	Page* _tmp0_;
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_;
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 6563 "page-view.c"
}


static gpointer _page_ref0 (gpointer self) {
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return self ? page_ref (self) : NULL;
#line 6570 "page-view.c"
}


static void page_view_set_page (PageView* self, Page* value) {
	Page* _tmp0_;
	Page* _tmp1_;
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = value;
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = _page_ref0 (_tmp0_);
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_page_unref0 (self->priv->_page);
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->_page = _tmp1_;
#line 6587 "page-view.c"
}


gboolean page_view_get_selected (PageView* self) {
	gboolean result;
	gboolean _tmp0_;
#line 38 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 38 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->selected_;
#line 38 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_;
#line 38 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 6602 "page-view.c"
}


void page_view_set_selected (PageView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp6_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_view_get_selected (self);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp3_) {
#line 6623 "page-view.c"
		gboolean _tmp4_;
		gboolean _tmp5_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp4_ = page_view_get_selected (self);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp5_ = _tmp4_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp1_ = _tmp5_;
#line 6632 "page-view.c"
	} else {
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp1_ = FALSE;
#line 6636 "page-view.c"
	}
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = _tmp1_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp6_) {
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp0_ = TRUE;
#line 6644 "page-view.c"
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp12_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp8_ = page_view_get_selected (self);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp9_ = _tmp8_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (!_tmp9_) {
#line 6656 "page-view.c"
			gboolean _tmp10_;
			gboolean _tmp11_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp10_ = page_view_get_selected (self);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp11_ = _tmp10_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp7_ = !_tmp11_;
#line 6665 "page-view.c"
		} else {
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp7_ = FALSE;
#line 6669 "page-view.c"
		}
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp12_ = _tmp7_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp0_ = _tmp12_;
#line 6675 "page-view.c"
	}
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = _tmp0_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp13_) {
#line 42 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 6683 "page-view.c"
	}
#line 43 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp14_ = page_view_get_selected (self);
#line 43 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp15_ = _tmp14_;
#line 43 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_set_selected (self, _tmp15_);
#line 44 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6693 "page-view.c"
}


gint page_view_get_x_offset (PageView* self) {
	gint result;
	gint _tmp0_;
#line 64 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 64 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->_x_offset;
#line 64 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_;
#line 64 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 6708 "page-view.c"
}


void page_view_set_x_offset (PageView* self, gint value) {
	gint _tmp0_;
#line 64 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = value;
#line 64 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->_x_offset = _tmp0_;
#line 6720 "page-view.c"
}


gint page_view_get_y_offset (PageView* self) {
	gint result;
	gint _tmp0_;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->_y_offset;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 6735 "page-view.c"
}


void page_view_set_y_offset (PageView* self, gint value) {
	gint _tmp0_;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = value;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->_y_offset = _tmp0_;
#line 6747 "page-view.c"
}


GdkCursorType page_view_get_cursor (PageView* self) {
	GdkCursorType result;
	GdkCursorType _tmp0_;
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->_cursor;
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_;
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 6762 "page-view.c"
}


static void page_view_set_cursor (PageView* self, GdkCursorType value) {
	GdkCursorType _tmp0_;
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = value;
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->_cursor = _tmp0_;
#line 6774 "page-view.c"
}


static void value_page_view_init (GValue* value) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	value->data[0].v_pointer = NULL;
#line 6781 "page-view.c"
}


static void value_page_view_free_value (GValue* value) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (value->data[0].v_pointer) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_unref (value->data[0].v_pointer);
#line 6790 "page-view.c"
	}
}


static void value_page_view_copy_value (const GValue* src_value, GValue* dest_value) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (src_value->data[0].v_pointer) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		dest_value->data[0].v_pointer = page_view_ref (src_value->data[0].v_pointer);
#line 6800 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		dest_value->data[0].v_pointer = NULL;
#line 6804 "page-view.c"
	}
}


static gpointer value_page_view_peek_pointer (const GValue* value) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return value->data[0].v_pointer;
#line 6812 "page-view.c"
}


static gchar* value_page_view_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (collect_values[0].v_pointer) {
#line 6819 "page-view.c"
		PageView* object;
		object = collect_values[0].v_pointer;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (object->parent_instance.g_class == NULL) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6826 "page-view.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6830 "page-view.c"
		}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		value->data[0].v_pointer = page_view_ref (object);
#line 6834 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		value->data[0].v_pointer = NULL;
#line 6838 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return NULL;
#line 6842 "page-view.c"
}


static gchar* value_page_view_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PageView** object_p;
	object_p = collect_values[0].v_pointer;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (!object_p) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 6853 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (!value->data[0].v_pointer) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		*object_p = NULL;
#line 6859 "page-view.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		*object_p = value->data[0].v_pointer;
#line 6863 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		*object_p = page_view_ref (value->data[0].v_pointer);
#line 6867 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return NULL;
#line 6871 "page-view.c"
}


GParamSpec* param_spec_page_view (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPageView* spec;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PAGE_VIEW), NULL);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return G_PARAM_SPEC (spec);
#line 6885 "page-view.c"
}


gpointer value_get_page_view (const GValue* value) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW), NULL);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return value->data[0].v_pointer;
#line 6894 "page-view.c"
}


void value_set_page_view (GValue* value, gpointer v_object) {
	PageView* old;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW));
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	old = value->data[0].v_pointer;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (v_object) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE_VIEW));
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		value->data[0].v_pointer = v_object;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_ref (value->data[0].v_pointer);
#line 6914 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		value->data[0].v_pointer = NULL;
#line 6918 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (old) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_unref (old);
#line 6924 "page-view.c"
	}
}


void value_take_page_view (GValue* value, gpointer v_object) {
	PageView* old;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW));
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	old = value->data[0].v_pointer;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (v_object) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE_VIEW));
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		value->data[0].v_pointer = v_object;
#line 6943 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		value->data[0].v_pointer = NULL;
#line 6947 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (old) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_unref (old);
#line 6953 "page-view.c"
	}
}


static void page_view_class_init (PageViewClass * klass) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	PAGE_VIEW_CLASS (klass)->finalize = page_view_finalize;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_type_class_add_private (klass, sizeof (PageViewPrivate));
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_new ("size_changed", TYPE_PAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_new ("changed", TYPE_PAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 6969 "page-view.c"
}


static void page_view_instance_init (PageView * self) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv = PAGE_VIEW_GET_PRIVATE (self);
#line 32 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->image = NULL;
#line 35 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->selected_ = FALSE;
#line 48 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->border_width = 1;
#line 51 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->_cursor = GDK_ARROW;
#line 78 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->animate_n_segments = 7;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->ref_count = 1;
#line 6990 "page-view.c"
}


static void page_view_finalize (PageView* obj) {
	PageView * self;
	Page* _tmp0_;
	guint _tmp1_ = 0U;
	Page* _tmp2_;
	guint _tmp3_ = 0U;
	Page* _tmp4_;
	guint _tmp5_ = 0U;
	Page* _tmp6_;
	guint _tmp7_ = 0U;
	Page* _tmp8_;
	guint _tmp9_ = 0U;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_VIEW, PageView);
#line 97 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 97 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 97 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _page_view_page_pixels_changed_cb_page_pixels_changed, self);
#line 98 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = self->priv->_page;
#line 98 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 98 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _page_view_page_size_changed_cb_page_size_changed, self);
#line 99 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = self->priv->_page;
#line 99 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 99 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _page_view_page_overlay_changed_cb_page_crop_changed, self);
#line 100 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = self->priv->_page;
#line 100 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_parse_name ("scan-line-changed", TYPE_PAGE, &_tmp7_, NULL, FALSE);
#line 100 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _page_view_page_overlay_changed_cb_page_scan_line_changed, self);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = self->priv->_page;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp9_, NULL, FALSE);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _page_view_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_page_unref0 (self->priv->_page);
#line 32 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_g_object_unref0 (self->priv->image);
#line 7042 "page-view.c"
}


GType page_view_get_type (void) {
	static volatile gsize page_view_type_id__volatile = 0;
	if (g_once_init_enter (&page_view_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_page_view_init, value_page_view_free_value, value_page_view_copy_value, value_page_view_peek_pointer, "p", value_page_view_collect_value, "p", value_page_view_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PageViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PageView), 0, (GInstanceInitFunc) page_view_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType page_view_type_id;
		page_view_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PageView", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&page_view_type_id__volatile, page_view_type_id);
	}
	return page_view_type_id__volatile;
}


gpointer page_view_ref (gpointer instance) {
	PageView* self;
	self = instance;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_atomic_int_inc (&self->ref_count);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return instance;
#line 7067 "page-view.c"
}


void page_view_unref (gpointer instance) {
	PageView* self;
	self = instance;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		PAGE_VIEW_GET_CLASS (self)->finalize (self);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 7080 "page-view.c"
	}
}



