/* ui.c generated by valac 0.24.0, the Vala compiler
 * generated from ui.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>,
 *         Eduard Gotwig <g@ox.io>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gstdio.h>
#include <unistd.h>


#define TYPE_USER_INTERFACE (user_interface_get_type ())
#define USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INTERFACE, UserInterface))
#define USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_INTERFACE, UserInterfaceClass))
#define IS_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INTERFACE))
#define IS_USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_INTERFACE))
#define USER_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_INTERFACE, UserInterfaceClass))

typedef struct _UserInterface UserInterface;
typedef struct _UserInterfaceClass UserInterfaceClass;
typedef struct _UserInterfacePrivate UserInterfacePrivate;

#define TYPE_PROGRESS_BAR_DIALOG (progress_bar_dialog_get_type ())
#define PROGRESS_BAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialog))
#define PROGRESS_BAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogClass))
#define IS_PROGRESS_BAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_BAR_DIALOG))
#define IS_PROGRESS_BAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_BAR_DIALOG))
#define PROGRESS_BAR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogClass))

typedef struct _ProgressBarDialog ProgressBarDialog;
typedef struct _ProgressBarDialogClass ProgressBarDialogClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;

#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))
#define _autosave_manager_unref0(var) ((var == NULL) ? NULL : (var = (autosave_manager_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_MODE (scan_mode_get_type ())
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
#define _scan_options_unref0(var) ((var == NULL) ? NULL : (var = (scan_options_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TYPE_PAGE_ICON (page_icon_get_type ())
#define PAGE_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_ICON, PageIcon))
#define PAGE_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_ICON, PageIconClass))
#define IS_PAGE_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_ICON))
#define IS_PAGE_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_ICON))
#define PAGE_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_ICON, PageIconClass))

typedef struct _PageIcon PageIcon;
typedef struct _PageIconClass PageIconClass;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _ProgressBarDialogPrivate ProgressBarDialogPrivate;
typedef struct _PageIconPrivate PageIconPrivate;

struct _UserInterface {
	GtkApplicationWindow parent_instance;
	UserInterfacePrivate * priv;
};

struct _UserInterfaceClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _UserInterfacePrivate {
	GSettings* settings;
	GtkMenuBar* menubar;
	GtkToolbar* toolbar;
	GtkMenu* page_menu;
	GtkBox* main_vbox;
	GtkInfoBar* info_bar;
	GtkImage* info_bar_image;
	GtkLabel* info_bar_label;
	GtkButton* info_bar_close_button;
	GtkButton* info_bar_change_scanner_button;
	GtkRadioMenuItem* custom_crop_menuitem;
	GtkRadioMenuItem* a4_menuitem;
	GtkRadioMenuItem* a5_menuitem;
	GtkRadioMenuItem* a6_menuitem;
	GtkRadioMenuItem* letter_menuitem;
	GtkRadioMenuItem* legal_menuitem;
	GtkRadioMenuItem* four_by_six_menuitem;
	GtkRadioMenuItem* no_crop_menuitem;
	GtkMenuItem* page_move_left_menuitem;
	GtkMenuItem* page_move_right_menuitem;
	GtkMenuItem* page_delete_menuitem;
	GtkMenuItem* crop_rotate_menuitem;
	GtkMenuItem* save_menuitem;
	GtkMenuItem* save_as_menuitem;
	GtkMenuItem* copy_to_clipboard_menuitem;
	GtkButton* save_button;
	GtkToolButton* save_toolbutton;
	GtkMenuItem* stop_scan_menuitem;
	GtkToolButton* stop_toolbutton;
	GtkToggleButton* crop_button;
	GtkToggleToolButton* crop_toolbutton;
	GtkButton* stop_button;
	GtkButton* scan_button;
	GtkRadioMenuItem* text_button_menuitem;
	GtkRadioMenuItem* text_menuitem;
	GtkRadioMenuItem* photo_button_menuitem;
	GtkRadioMenuItem* photo_menuitem;
	GtkDialog* authorize_dialog;
	GtkLabel* authorize_label;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	GtkDialog* preferences_dialog;
	GtkComboBox* device_combo;
	GtkComboBox* text_dpi_combo;
	GtkComboBox* photo_dpi_combo;
	GtkComboBox* page_side_combo;
	GtkComboBox* paper_size_combo;
	GtkScale* brightness_scale;
	GtkScale* contrast_scale;
	GtkScale* quality_scale;
	GtkListStore* device_model;
	GtkListStore* text_dpi_model;
	GtkListStore* photo_dpi_model;
	GtkListStore* page_side_model;
	GtkListStore* paper_size_model;
	GtkAdjustment* brightness_adjustment;
	GtkAdjustment* contrast_adjustment;
	GtkAdjustment* quality_adjustment;
	gboolean setting_devices;
	gboolean user_selected_device;
	GtkFileChooserDialog* save_dialog;
	ProgressBarDialog* progress_dialog;
	gboolean have_error;
	gchar* error_title;
	gchar* error_text;
	gboolean error_change_scanner_hint;
	Book* _book;
	gchar* book_uri;
	AutosaveManager* autosave_manager;
	BookView* book_view;
	gboolean updating_page_menu;
	gint default_page_width;
	gint default_page_height;
	gint default_page_dpi;
	ScanDirection default_page_scan_direction;
	gchar* document_hint;
	gchar* _default_file_name;
	gboolean scanning_;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
	guint save_state_timeout;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _Block1Data {
	int _ref_count_;
	UserInterface* self;
	GtkWindow* dialog;
};

struct _ProgressBarDialog {
	GtkWindow parent_instance;
	ProgressBarDialogPrivate * priv;
};

struct _ProgressBarDialogClass {
	GtkWindowClass parent_class;
};

struct _ProgressBarDialogPrivate {
	GtkProgressBar* bar;
};

struct _PageIcon {
	GtkDrawingArea parent_instance;
	PageIconPrivate * priv;
};

struct _PageIconClass {
	GtkDrawingAreaClass parent_class;
};

struct _PageIconPrivate {
	gchar* text;
	gdouble r;
	gdouble g;
	gdouble b;
};


static gpointer user_interface_parent_class = NULL;
static gpointer progress_bar_dialog_parent_class = NULL;
static gpointer page_icon_parent_class = NULL;

GType user_interface_get_type (void) G_GNUC_CONST;
GType progress_bar_dialog_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer autosave_manager_ref (gpointer instance);
void autosave_manager_unref (gpointer instance);
GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_autosave_manager (GValue* value, gpointer v_object);
void value_take_autosave_manager (GValue* value, gpointer v_object);
gpointer value_get_autosave_manager (const GValue* value);
GType autosave_manager_get_type (void) G_GNUC_CONST;
GType book_view_get_type (void) G_GNUC_CONST;
GType scan_direction_get_type (void) G_GNUC_CONST;
#define USER_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_INTERFACE, UserInterfacePrivate))
enum  {
	USER_INTERFACE_DUMMY_PROPERTY,
	USER_INTERFACE_BOOK,
	USER_INTERFACE_SELECTED_PAGE,
	USER_INTERFACE_DEFAULT_FILE_NAME,
	USER_INTERFACE_SCANNING,
	USER_INTERFACE_BRIGHTNESS,
	USER_INTERFACE_CONTRAST,
	USER_INTERFACE_QUALITY,
	USER_INTERFACE_SELECTED_DEVICE
};
Book* user_interface_get_book (UserInterface* self);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static void user_interface_page_added_cb (UserInterface* self, Book* book, Page* page);
static void _user_interface_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self);
static void user_interface_reordered_cb (UserInterface* self, Book* book);
static void _user_interface_reordered_cb_book_reordered (Book* _sender, gpointer self);
static void user_interface_page_removed_cb (UserInterface* self, Book* book, Page* page);
static void _user_interface_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self);
#define USER_INTERFACE_DEFAULT_TEXT_DPI 150
#define USER_INTERFACE_DEFAULT_PHOTO_DPI 300
void user_interface_new_document_activate_cb (UserInterface* self);
static void _user_interface_new_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_reorder_document_activate_cb (UserInterface* self);
static void _user_interface_reorder_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_save_document_activate_cb (UserInterface* self);
static void _user_interface_save_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_save_as_document_activate_cb (UserInterface* self);
static void _user_interface_save_as_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_email_document_activate_cb (UserInterface* self);
static void _user_interface_email_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_print_document_activate_cb (UserInterface* self);
static void _user_interface_print_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_preferences_activate_cb (UserInterface* self);
static void _user_interface_preferences_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_help_contents_activate_cb (UserInterface* self);
static void _user_interface_help_contents_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_about_activate_cb (UserInterface* self);
static void _user_interface_about_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_quit_activate_cb (UserInterface* self);
static void _user_interface_quit_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
UserInterface* user_interface_new (void);
UserInterface* user_interface_construct (GType object_type);
Book* book_new (void);
Book* book_construct (GType object_type);
static void user_interface_set_book (UserInterface* self, Book* value);
static void user_interface_load (UserInterface* self);
AutosaveManager* autosave_manager_new (void);
AutosaveManager* autosave_manager_construct (GType object_type);
void autosave_manager_set_book (AutosaveManager* self, Book* value);
void autosave_manager_load (AutosaveManager* self);
guint book_get_n_pages (Book* self);
static void user_interface_add_default_page (UserInterface* self);
void book_set_needs_saving (Book* self, gboolean value);
Page* book_get_page (Book* self, gint page_number);
void book_view_set_selected_page (BookView* self, Page* value);
static void user_interface_needs_saving_cb (UserInterface* self, Book* book);
static void _user_interface_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self);
static gboolean user_interface_find_scan_device (UserInterface* self, const gchar* device, GtkTreeIter* iter);
static void user_interface_show_error_dialog (UserInterface* self, const gchar* error_title, const gchar* error_text);
void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password);
static void user_interface_device_combo_changed_cb (UserInterface* self, GtkWidget* widget);
gchar* user_interface_get_selected_device (UserInterface* self);
static void _user_interface_device_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void user_interface_update_info_bar (UserInterface* self);
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
void user_interface_set_scan_devices (UserInterface* self, GList* devices);
Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction);
void book_append_page (Book* self, Page* page);
static void user_interface_on_file_type_changed (UserInterface* self, GtkTreeSelection* selection);
static gchar* user_interface_get_selected_extension (UserInterface* self, GtkTreeSelection* selection);
static gchar* user_interface_choose_file_location (UserInterface* self);
const gchar* user_interface_get_default_file_name (UserInterface* self);
static void _user_interface_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static gboolean user_interface_save_document (UserInterface* self, gboolean force_choose_location);
void user_interface_show_progress_dialog (UserInterface* self);
void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
gint user_interface_get_quality (UserInterface* self);
void user_interface_hide_progress_dialog (UserInterface* self);
void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
static gboolean user_interface_prompt_to_save (UserInterface* self, const gchar* title, const gchar* discard_label);
gboolean book_get_needs_saving (Book* self);
static void user_interface_clear_document (UserInterface* self);
void book_clear (Book* self);
static void user_interface_new_document (UserInterface* self);
gboolean user_interface_get_scanning (UserInterface* self);
static void user_interface_new_button_clicked_cb (UserInterface* self, GtkWidget* widget);
static void _user_interface_new_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void user_interface_set_document_hint (UserInterface* self, const gchar* document_hint, gboolean save);
static void user_interface_text_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget);
static void _user_interface_text_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void user_interface_photo_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget);
static void _user_interface_photo_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
GType scan_type_get_type (void) G_GNUC_CONST;
static void user_interface_set_page_side (UserInterface* self, ScanType page_side);
static void user_interface_set_paper_size (UserInterface* self, gint width, gint height);
static gint user_interface_get_text_dpi (UserInterface* self);
static gint user_interface_get_photo_dpi (UserInterface* self);
static ScanType user_interface_get_page_side (UserInterface* self);
static gboolean user_interface_get_paper_size (UserInterface* self, gint* width, gint* height);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static ScanOptions* user_interface_make_scan_options (UserInterface* self);
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
GType scan_mode_get_type (void) G_GNUC_CONST;
gint user_interface_get_brightness (UserInterface* self);
gint user_interface_get_contrast (UserInterface* self);
static void user_interface_scan_button_clicked_cb (UserInterface* self, GtkWidget* widget);
static void _user_interface_scan_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void user_interface_stop_scan_button_clicked_cb (UserInterface* self, GtkWidget* widget);
static void _user_interface_stop_scan_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void user_interface_continuous_scan_button_clicked_cb (UserInterface* self, GtkWidget* widget);
static void _user_interface_continuous_scan_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void user_interface_preferences_button_clicked_cb (UserInterface* self, GtkWidget* widget);
static void _user_interface_preferences_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static gboolean user_interface_preferences_dialog_delete_event_cb (UserInterface* self, GtkWidget* widget, GdkEventAny* event);
static gboolean _user_interface_preferences_dialog_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void user_interface_preferences_dialog_response_cb (UserInterface* self, GtkWidget* widget, gint response_id);
static void _user_interface_preferences_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void user_interface_update_page_menu (UserInterface* self);
Page* book_view_get_selected_page (BookView* self);
guint book_get_page_index (Book* self, Page* page);
static void user_interface_page_selected_cb (UserInterface* self, BookView* view, Page* page);
gboolean page_get_has_crop (Page* self);
const gchar* page_get_crop_name (Page* self);
static void user_interface_show_page_cb (UserInterface* self, BookView* view, Page* page);
gchar* get_temporary_filename (const gchar* prefix, const gchar* extension);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
static void user_interface_show_page_menu_cb (UserInterface* self, BookView* view);
static void user_interface_rotate_left_button_clicked_cb (UserInterface* self, GtkWidget* widget);
void page_rotate_left (Page* self);
static void _user_interface_rotate_left_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void user_interface_rotate_right_button_clicked_cb (UserInterface* self, GtkWidget* widget);
void page_rotate_right (Page* self);
static void _user_interface_rotate_right_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void user_interface_set_crop (UserInterface* self, const gchar* crop_name);
void page_set_no_crop (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
void page_set_named_crop (Page* self, const gchar* name);
static void user_interface_no_crop_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget);
static void _user_interface_no_crop_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void user_interface_custom_crop_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget);
static void _user_interface_custom_crop_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void user_interface_crop_button_toggled_cb (UserInterface* self, GtkToggleButton* widget);
static void _user_interface_crop_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void user_interface_crop_toolbutton_toggled_cb (UserInterface* self, GtkToggleToolButton* widget);
static void _user_interface_crop_toolbutton_toggled_cb_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static void user_interface_four_by_six_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget);
static void _user_interface_four_by_six_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void user_interface_legal_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget);
static void _user_interface_legal_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void user_interface_letter_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget);
static void _user_interface_letter_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void user_interface_a6_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget);
static void _user_interface_a6_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void user_interface_a5_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget);
static void _user_interface_a5_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void user_interface_a4_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget);
static void _user_interface_a4_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void user_interface_crop_rotate_menuitem_activate_cb (UserInterface* self, GtkWidget* widget);
void page_rotate_crop (Page* self);
static void _user_interface_crop_rotate_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void user_interface_page_move_left_menuitem_activate_cb (UserInterface* self, GtkWidget* widget);
void book_move_page (Book* self, Page* page, guint location);
static void _user_interface_page_move_left_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void user_interface_page_move_right_menuitem_activate_cb (UserInterface* self, GtkWidget* widget);
static void _user_interface_page_move_right_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void user_interface_page_delete_menuitem_activate_cb (UserInterface* self, GtkWidget* widget);
Book* book_view_get_book (BookView* self);
void book_delete_page (Book* self, Page* page);
static void _user_interface_page_delete_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void user_interface_reorder_document (UserInterface* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block1Data* _data1_, GdkEventKey* e);
static gboolean ___lambda4__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static GtkButton* user_interface_make_reorder_button (UserInterface* self, const gchar* text, const gchar* items);
static void __lambda5_ (Block1Data* _data1_);
void book_combine_sides (Book* self);
static void ___lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda6_ (Block1Data* _data1_);
void book_combine_sides_reverse (Book* self);
static void ___lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda7_ (Block1Data* _data1_);
void book_reverse (Book* self);
static void ___lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda8_ (Block1Data* _data1_);
static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void user_interface_reorder_menuitem_activate_cb (UserInterface* self, GtkWidget* widget);
static void _user_interface_reorder_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static GtkBox* user_interface_make_reorder_box (UserInterface* self, const gchar* items);
GType page_icon_get_type (void) G_GNUC_CONST;
PageIcon* page_icon_new (const gchar* text, gdouble r, gdouble g, gdouble b);
PageIcon* page_icon_construct (GType object_type, const gchar* text, gdouble r, gdouble g, gdouble b);
static void user_interface_save_file_button_clicked_cb (UserInterface* self, GtkWidget* widget);
static void _user_interface_save_file_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void user_interface_copy_to_clipboard_button_clicked_cb (UserInterface* self, GtkWidget* widget);
void page_copy_to_clipboard (Page* self, GtkWindow* window);
static void _user_interface_copy_to_clipboard_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void user_interface_save_as_file_button_clicked_cb (UserInterface* self, GtkWidget* widget);
static void _user_interface_save_as_file_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void user_interface_draw_page (UserInterface* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number);
gboolean page_get_is_landscape (Page* self);
gint page_get_dpi (Page* self);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
static void user_interface_email_button_clicked_cb (UserInterface* self, GtkWidget* widget);
static void _user_interface_email_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void user_interface_print_document (UserInterface* self);
static void _user_interface_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
static void user_interface_print_button_clicked_cb (UserInterface* self, GtkWidget* widget);
static void _user_interface_print_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void user_interface_launch_help (UserInterface* self);
static void user_interface_help_contents_menuitem_activate_cb (UserInterface* self, GtkWidget* widget);
static void _user_interface_help_contents_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void user_interface_show_about (UserInterface* self);
static void user_interface_about_menuitem_activate_cb (UserInterface* self, GtkWidget* widget);
static void _user_interface_about_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static gboolean user_interface_on_quit (UserInterface* self);
static void user_interface_save_state (UserInterface* self, gboolean force);
void autosave_manager_cleanup (AutosaveManager* self);
static void user_interface_quit_menuitem_activate_cb (UserInterface* self, GtkWidget* widget);
static void _user_interface_quit_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static gboolean user_interface_simple_scan_window_configure_event_cb (UserInterface* self, GtkWidget* widget, GdkEventConfigure* event);
static gboolean _user_interface_simple_scan_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static void user_interface_info_bar_response_cb (UserInterface* self, GtkInfoBar* widget, gint response_id);
static gboolean user_interface_simple_scan_window_window_state_event_cb (UserInterface* self, GtkWidget* widget, GdkEventWindowState* event);
static gboolean _user_interface_simple_scan_window_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static gboolean user_interface_window_delete_event_cb (UserInterface* self, GtkWidget* widget, GdkEvent* event);
static gboolean _user_interface_window_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void user_interface_page_size_changed_cb (UserInterface* self, Page* page);
static void user_interface_page_scan_direction_changed_cb (UserInterface* self, Page* page);
ScanDirection page_get_scan_direction (Page* self);
static void _user_interface_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self);
static void _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self);
static void user_interface_set_dpi_combo (UserInterface* self, GtkComboBox* combo, gint default_dpi, gint current_dpi);
static gboolean user_interface_get_shell_shows_menubar (UserInterface* self);
static void _user_interface_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
static void __lambda10_ (UserInterface* self);
static void ___lambda10__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda11_ (UserInterface* self);
static void ___lambda11__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda12_ (UserInterface* self);
static void ___lambda12__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda13_ (UserInterface* self);
static void ___lambda13__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
void user_interface_set_brightness (UserInterface* self, gint value);
static void __lambda14_ (UserInterface* self);
static void ___lambda14__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
void user_interface_set_contrast (UserInterface* self, gint value);
static void __lambda15_ (UserInterface* self);
static void ___lambda15__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
void user_interface_set_quality (UserInterface* self, gint value);
static void __lambda16_ (UserInterface* self);
static void ___lambda16__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
BookView* book_view_new (Book* book);
BookView* book_view_construct (GType object_type, Book* book);
static void _user_interface_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self);
static void _user_interface_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self);
static void _user_interface_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self);
static void user_interface_load_state (UserInterface* self);
ProgressBarDialog* progress_bar_dialog_new (GtkApplicationWindow* parent, const gchar* title);
ProgressBarDialog* progress_bar_dialog_construct (GType object_type, GtkApplicationWindow* parent, const gchar* title);
static void user_interface_book_saving_cb (UserInterface* self, gint page_number);
static void _user_interface_book_saving_cb_book_saving (Book* _sender, gint i, gpointer self);
static gchar* user_interface_get_state_filename (UserInterface* self);
static gint user_interface_state_get_integer (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, gint _default_);
static gboolean user_interface_state_get_boolean (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, gboolean _default_);
static gchar* user_interface_state_get_string (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, const gchar* _default_);
static gboolean ___lambda9_ (UserInterface* self);
static gboolean ____lambda9__gsource_func (gpointer self);
static gboolean ___lambda17_ (UserInterface* self);
static gboolean ____lambda17__gsource_func (gpointer self);
void progress_bar_dialog_set_fraction (ProgressBarDialog* self, gdouble value);
void progress_bar_dialog_set_message (ProgressBarDialog* self, const gchar* value);
void user_interface_start (UserInterface* self);
Page* user_interface_get_selected_page (UserInterface* self);
void user_interface_set_selected_page (UserInterface* self, Page* value);
void user_interface_set_default_file_name (UserInterface* self, const gchar* value);
void user_interface_set_scanning (UserInterface* self, gboolean value);
void user_interface_set_selected_device (UserInterface* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void user_interface_finalize (GObject* obj);
static void _vala_user_interface_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_user_interface_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define PROGRESS_BAR_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogPrivate))
enum  {
	PROGRESS_BAR_DIALOG_DUMMY_PROPERTY,
	PROGRESS_BAR_DIALOG_FRACTION,
	PROGRESS_BAR_DIALOG_MESSAGE
};
gdouble progress_bar_dialog_get_fraction (ProgressBarDialog* self);
const gchar* progress_bar_dialog_get_message (ProgressBarDialog* self);
static void progress_bar_dialog_finalize (GObject* obj);
static void _vala_progress_bar_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_progress_bar_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define PAGE_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PAGE_ICON, PageIconPrivate))
enum  {
	PAGE_ICON_DUMMY_PROPERTY
};
#define PAGE_ICON_MINIMUM_WIDTH 20
static void page_icon_real_get_preferred_width (GtkWidget* base, gint* minimum_width, gint* natural_width);
static void page_icon_real_get_preferred_height (GtkWidget* base, gint* minimum_height, gint* natural_height);
static void page_icon_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum_height, gint* natural_height);
static void page_icon_real_get_preferred_width_for_height (GtkWidget* base, gint height, gint* minimum_width, gint* natural_width);
static gboolean page_icon_real_draw (GtkWidget* base, cairo_t* c);
static void page_icon_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry USER_INTERFACE_action_entries[10] = {{"new_document", _user_interface_new_document_activate_cb_gsimple_action_activate_callback}, {"reorder", _user_interface_reorder_document_activate_cb_gsimple_action_activate_callback}, {"save", _user_interface_save_document_activate_cb_gsimple_action_activate_callback}, {"save_as", _user_interface_save_as_document_activate_cb_gsimple_action_activate_callback}, {"email", _user_interface_email_document_activate_cb_gsimple_action_activate_callback}, {"print", _user_interface_print_document_activate_cb_gsimple_action_activate_callback}, {"preferences", _user_interface_preferences_activate_cb_gsimple_action_activate_callback}, {"help", _user_interface_help_contents_activate_cb_gsimple_action_activate_callback}, {"about", _user_interface_about_activate_cb_gsimple_action_activate_callback}, {"quit", _user_interface_quit_activate_cb_gsimple_action_activate_callback}};

static void _user_interface_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self) {
#line 274 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_added_cb ((UserInterface*) self, _sender, page);
#line 688 "ui.c"
}


static void _user_interface_reordered_cb_book_reordered (Book* _sender, gpointer self) {
#line 275 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_reordered_cb ((UserInterface*) self, _sender);
#line 695 "ui.c"
}


static void _user_interface_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self) {
#line 276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_removed_cb ((UserInterface*) self, _sender, page);
#line 702 "ui.c"
}


static void _user_interface_new_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 19 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_new_document_activate_cb ((UserInterface*) self);
#line 709 "ui.c"
}


static void _user_interface_reorder_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 19 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_reorder_document_activate_cb ((UserInterface*) self);
#line 716 "ui.c"
}


static void _user_interface_save_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 19 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_document_activate_cb ((UserInterface*) self);
#line 723 "ui.c"
}


static void _user_interface_save_as_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 19 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_as_document_activate_cb ((UserInterface*) self);
#line 730 "ui.c"
}


static void _user_interface_email_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 19 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_email_document_activate_cb ((UserInterface*) self);
#line 737 "ui.c"
}


static void _user_interface_print_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 19 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_print_document_activate_cb ((UserInterface*) self);
#line 744 "ui.c"
}


static void _user_interface_preferences_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 19 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_preferences_activate_cb ((UserInterface*) self);
#line 751 "ui.c"
}


static void _user_interface_help_contents_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 19 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_help_contents_activate_cb ((UserInterface*) self);
#line 758 "ui.c"
}


static void _user_interface_about_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 19 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_about_activate_cb ((UserInterface*) self);
#line 765 "ui.c"
}


static void _user_interface_quit_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 19 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_quit_activate_cb ((UserInterface*) self);
#line 772 "ui.c"
}


static void _user_interface_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self) {
#line 269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_needs_saving_cb ((UserInterface*) self, _sender);
#line 779 "ui.c"
}


UserInterface* user_interface_construct (GType object_type) {
	UserInterface * self = NULL;
	GSettings* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	Book* _tmp2_ = NULL;
	Book* _tmp3_ = NULL;
	Book* _tmp4_ = NULL;
	Book* _tmp5_ = NULL;
	AutosaveManager* _tmp6_ = NULL;
	AutosaveManager* _tmp7_ = NULL;
	Book* _tmp8_ = NULL;
	AutosaveManager* _tmp9_ = NULL;
	Book* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	Book* _tmp18_ = NULL;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = (UserInterface*) g_object_new (object_type, NULL);
#line 249 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = g_settings_new ("org.gnome.SimpleScan");
#line 249 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->settings);
#line 249 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->settings = _tmp0_;
#line 251 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_new ();
#line 251 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 251 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_book (self, _tmp2_);
#line 251 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_book_unref0 (_tmp2_);
#line 252 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->_book;
#line 252 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp3_, "page-added", (GCallback) _user_interface_page_added_cb_book_page_added, self, 0);
#line 253 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->_book;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp4_, "reordered", (GCallback) _user_interface_reordered_cb_book_reordered, self, 0);
#line 254 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = self->priv->_book;
#line 254 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp5_, "page-removed", (GCallback) _user_interface_page_removed_cb_book_page_removed, self, 0);
#line 256 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_load (self);
#line 258 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = autosave_manager_new ();
#line 258 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_autosave_manager_unref0 (self->priv->autosave_manager);
#line 258 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->autosave_manager = _tmp6_;
#line 259 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = self->priv->autosave_manager;
#line 259 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = self->priv->_book;
#line 259 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	autosave_manager_set_book (_tmp7_, _tmp8_);
#line 260 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->autosave_manager;
#line 260 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	autosave_manager_load (_tmp9_);
#line 262 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = self->priv->_book;
#line 262 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = book_get_n_pages (_tmp10_);
#line 262 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = _tmp11_;
#line 262 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp12_ == ((guint) 0)) {
#line 853 "ui.c"
		Book* _tmp13_ = NULL;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_add_default_page (self);
#line 265 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp13_ = self->priv->_book;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		book_set_needs_saving (_tmp13_, FALSE);
#line 861 "ui.c"
	} else {
		BookView* _tmp14_ = NULL;
		Book* _tmp15_ = NULL;
		Page* _tmp16_ = NULL;
		Page* _tmp17_ = NULL;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp14_ = self->priv->book_view;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = self->priv->_book;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp16_ = book_get_page (_tmp15_, 0);
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp17_ = _tmp16_;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		book_view_set_selected_page (_tmp14_, _tmp17_);
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_page_unref0 (_tmp17_);
#line 879 "ui.c"
	}
#line 269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = self->priv->_book;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp18_, "needs-saving-changed", (GCallback) _user_interface_needs_saving_cb_book_needs_saving_changed, self, 0);
#line 247 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self;
#line 887 "ui.c"
}


UserInterface* user_interface_new (void) {
#line 247 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return user_interface_construct (TYPE_USER_INTERFACE);
#line 894 "ui.c"
}


static gboolean user_interface_find_scan_device (UserInterface* self, const gchar* device, GtkTreeIter* iter) {
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gboolean have_iter = FALSE;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 279 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (device != NULL, FALSE);
#line 281 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	have_iter = FALSE;
#line 283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->device_model;
#line 283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_iter = _tmp1_;
#line 283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 919 "ui.c"
		{
			gboolean _tmp3_ = FALSE;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp3_ = TRUE;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			while (TRUE) {
#line 926 "ui.c"
				gchar* d = NULL;
				GtkListStore* _tmp8_ = NULL;
				GtkTreeIter _tmp9_ = {0};
				const gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (!_tmp3_) {
#line 934 "ui.c"
					gboolean _tmp4_ = FALSE;
					gboolean _tmp5_ = FALSE;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp5_ = have_iter;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (!_tmp5_) {
#line 941 "ui.c"
						GtkListStore* _tmp6_ = NULL;
						gboolean _tmp7_ = FALSE;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp6_ = self->priv->device_model;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp7_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp6_, &_vala_iter);
#line 291 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp4_ = _tmp7_;
#line 950 "ui.c"
					} else {
#line 291 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp4_ = FALSE;
#line 954 "ui.c"
					}
#line 291 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (!_tmp4_) {
#line 291 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						break;
#line 960 "ui.c"
					}
				}
#line 285 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp3_ = FALSE;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp8_ = self->priv->device_model;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp9_ = _vala_iter;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp8_, &_tmp9_, 0, &d, -1, -1);
#line 289 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp10_ = d;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp11_ = device;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
#line 290 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					have_iter = TRUE;
#line 979 "ui.c"
				}
#line 285 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (d);
#line 983 "ui.c"
			}
		}
	}
#line 294 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = have_iter;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (iter) {
#line 294 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*iter = _vala_iter;
#line 993 "ui.c"
	}
#line 294 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 997 "ui.c"
}


static void user_interface_show_error_dialog (UserInterface* self, const gchar* error_title, const gchar* error_text) {
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp0_ = NULL;
	GtkMessageDialog* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 297 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (error_title != NULL);
#line 297 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (error_text != NULL);
#line 299 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = error_title;
#line 299 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp0_);
#line 299 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp1_);
#line 299 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dialog = _tmp1_;
#line 304 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _ ("_Close");
#line 304 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) dialog, _tmp2_, 0);
#line 305 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = error_text;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp3_);
#line 306 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 297 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (dialog);
#line 1033 "ui.c"
}


void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password) {
	gchar* _vala_username = NULL;
	gchar* _vala_password = NULL;
	gchar* description = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	GtkEntry* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	GtkEntry* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GtkEntry* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
#line 309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (resource != NULL);
#line 312 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = _ ("Username and password required to access '%s'");
#line 312 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = resource;
#line 312 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = g_strdup_printf (_tmp0_, _tmp1_);
#line 312 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	description = _tmp2_;
#line 314 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->username_entry;
#line 314 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_entry_set_text (_tmp3_, "");
#line 315 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->password_entry;
#line 315 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_entry_set_text (_tmp4_, "");
#line 316 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = self->priv->authorize_label;
#line 316 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_label_set_text (_tmp5_, description);
#line 318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = self->priv->authorize_dialog;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
#line 319 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = self->priv->authorize_dialog;
#line 319 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_run (_tmp7_);
#line 320 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = self->priv->authorize_dialog;
#line 320 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp8_, FALSE);
#line 322 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->username_entry;
#line 322 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = gtk_entry_get_text (_tmp9_);
#line 322 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = _tmp10_;
#line 322 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 322 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_vala_username);
#line 322 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_username = _tmp12_;
#line 323 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = self->priv->password_entry;
#line 323 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = gtk_entry_get_text (_tmp13_);
#line 323 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = _tmp14_;
#line 323 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 323 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_vala_password);
#line 323 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_password = _tmp16_;
#line 309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (description);
#line 309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (username) {
#line 309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*username = _vala_username;
#line 1124 "ui.c"
	} else {
#line 309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_vala_username);
#line 1128 "ui.c"
	}
#line 309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (password) {
#line 309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*password = _vala_password;
#line 1134 "ui.c"
	} else {
#line 309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_vala_password);
#line 1138 "ui.c"
	}
}


static void user_interface_device_combo_changed_cb (UserInterface* self, GtkWidget* widget) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 327 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 329 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->setting_devices;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 330 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 1159 "ui.c"
	}
#line 331 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->user_selected_device = TRUE;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_selected_device (self);
#line 332 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_tmp3_);
#line 332 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_) {
#line 1175 "ui.c"
		GSettings* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = self->priv->settings;
#line 333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = user_interface_get_selected_device (self);
#line 333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = _tmp6_;
#line 333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = _tmp7_;
#line 333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_settings_set_string (_tmp5_, "selected-device", _tmp8_);
#line 333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp8_);
#line 1192 "ui.c"
	}
}


static void _user_interface_device_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_device_combo_changed_cb ((UserInterface*) self, _sender);
#line 1200 "ui.c"
}


static void user_interface_update_info_bar (UserInterface* self) {
	GtkMessageType type = 0;
	gchar* title = NULL;
	gchar* text = NULL;
	gchar* image_id = NULL;
	gboolean show_close_button = FALSE;
	gboolean show_change_scanner_button = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkInfoBar* _tmp15_ = NULL;
	GtkMessageType _tmp16_ = 0;
	GtkImage* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* message = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkButton* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	GtkButton* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	GtkInfoBar* _tmp28_ = NULL;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 340 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	show_close_button = FALSE;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	show_change_scanner_button = FALSE;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->have_error;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 1237 "ui.c"
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 345 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		type = GTK_MESSAGE_ERROR;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = g_strdup ("dialog-error");
#line 346 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (image_id);
#line 346 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		image_id = _tmp1_;
#line 347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = self->priv->error_title;
#line 347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (title);
#line 347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		title = _tmp3_;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->error_text;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (text);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		text = _tmp5_;
#line 349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		show_close_button = TRUE;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = self->priv->error_change_scanner_hint;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		show_change_scanner_button = _tmp6_;
#line 1274 "ui.c"
	} else {
		GtkListStore* _tmp7_ = NULL;
		gint _tmp8_ = 0;
#line 352 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = self->priv->device_model;
#line 352 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp7_, NULL);
#line 352 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp8_ == 0) {
#line 1284 "ui.c"
			gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			type = GTK_MESSAGE_WARNING;
#line 355 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp9_ = g_strdup ("dialog-warning");
#line 355 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (image_id);
#line 355 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			image_id = _tmp9_;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp10_ = _ ("No scanners detected");
#line 357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (title);
#line 357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			title = _tmp11_;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp12_ = _ ("Please check your scanner is connected and powered on");
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp13_ = g_strdup (_tmp12_);
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (text);
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			text = _tmp13_;
#line 1314 "ui.c"
		} else {
			GtkInfoBar* _tmp14_ = NULL;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp14_ = self->priv->info_bar;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_widget_set_visible ((GtkWidget*) _tmp14_, FALSE);
#line 364 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (image_id);
#line 364 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (text);
#line 364 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (title);
#line 364 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			return;
#line 1329 "ui.c"
		}
	}
#line 367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = self->priv->info_bar;
#line 367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = type;
#line 367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_info_bar_set_message_type (_tmp15_, _tmp16_);
#line 368 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = self->priv->info_bar_image;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = image_id;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_image_set_from_icon_name (_tmp17_, _tmp18_, GTK_ICON_SIZE_DIALOG);
#line 369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = title;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = text;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = g_strdup_printf ("<big><b>%s</b></big>\n\n%s", _tmp19_, _tmp20_);
#line 369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	message = _tmp21_;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = self->priv->info_bar_label;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = message;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_label_set_markup (_tmp22_, _tmp23_);
#line 371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = self->priv->info_bar_close_button;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = show_close_button;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp24_, _tmp25_);
#line 372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = self->priv->info_bar_change_scanner_button;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = show_change_scanner_button;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp26_, _tmp27_);
#line 373 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp28_ = self->priv->info_bar;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp28_, TRUE);
#line 336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (message);
#line 336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (image_id);
#line 336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (text);
#line 336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (title);
#line 1382 "ui.c"
}


static gpointer _scan_device_ref0 (gpointer self) {
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self ? scan_device_ref (self) : NULL;
#line 1389 "ui.c"
}


void user_interface_set_scan_devices (UserInterface* self, GList* devices) {
	gboolean have_selection = FALSE;
	gint index = 0;
	GtkTreeIter iter = {0};
	gboolean _tmp0_ = FALSE;
	GList* _tmp4_ = NULL;
	gboolean _tmp51_ = FALSE;
	gboolean _tmp52_ = FALSE;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 378 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	have_selection = FALSE;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->setting_devices = TRUE;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->user_selected_device;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 1411 "ui.c"
		GtkComboBox* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = self->priv->device_combo;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = gtk_combo_box_get_active (_tmp1_);
#line 386 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = _tmp2_;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		have_selection = _tmp3_ >= 0;
#line 1423 "ui.c"
	}
#line 389 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	index = 0;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = devices;
#line 1429 "ui.c"
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		device_collection = _tmp4_;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 1437 "ui.c"
			ScanDevice* _tmp5_ = NULL;
			ScanDevice* device = NULL;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp5_ = _scan_device_ref0 ((ScanDevice*) device_it->data);
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			device = _tmp5_;
#line 1444 "ui.c"
			{
				gint n_delete = 0;
				GtkListStore* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				GtkTreeIter _tmp8_ = {0};
				gboolean _tmp9_ = FALSE;
				gint _tmp21_ = 0;
				gint _tmp44_ = 0;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				n_delete = -1;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp6_ = self->priv->device_model;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp7_ = index;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp9_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp6_, &_tmp8_, NULL, _tmp7_);
#line 395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				iter = _tmp8_;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp9_) {
#line 1465 "ui.c"
					gint i = 0;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					i = 0;
#line 1469 "ui.c"
					{
						gboolean _tmp10_ = FALSE;
#line 398 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp10_ = TRUE;
#line 398 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						while (TRUE) {
#line 1476 "ui.c"
							gchar* name = NULL;
							gboolean matched = FALSE;
							GtkListStore* _tmp13_ = NULL;
							GtkTreeIter _tmp14_ = {0};
							const gchar* _tmp15_ = NULL;
							ScanDevice* _tmp16_ = NULL;
							const gchar* _tmp17_ = NULL;
							gboolean _tmp18_ = FALSE;
							gint _tmp20_ = 0;
#line 398 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (!_tmp10_) {
#line 1488 "ui.c"
								GtkListStore* _tmp11_ = NULL;
								gboolean _tmp12_ = FALSE;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp11_ = self->priv->device_model;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp12_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp11_, &iter);
#line 412 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								if (!_tmp12_) {
#line 412 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
									break;
#line 1499 "ui.c"
								}
							}
#line 398 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp10_ = FALSE;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp13_ = self->priv->device_model;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp14_ = iter;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							gtk_tree_model_get ((GtkTreeModel*) _tmp13_, &_tmp14_, 0, &name, -1, -1);
#line 404 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp15_ = name;
#line 404 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp16_ = device;
#line 404 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp17_ = _tmp16_->name;
#line 404 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							matched = g_strcmp0 (_tmp15_, _tmp17_) == 0;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp18_ = matched;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (_tmp18_) {
#line 1522 "ui.c"
								gint _tmp19_ = 0;
#line 408 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp19_ = i;
#line 408 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								n_delete = _tmp19_;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_g_free0 (name);
#line 409 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								break;
#line 1532 "ui.c"
							}
#line 411 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp20_ = i;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							i = _tmp20_ + 1;
#line 398 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_g_free0 (name);
#line 1540 "ui.c"
						}
					}
				}
#line 416 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp21_ = n_delete;
#line 416 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp21_ >= 0) {
#line 1548 "ui.c"
					gint i = 0;
					GtkListStore* _tmp22_ = NULL;
					GtkTreeIter _tmp23_ = {0};
					ScanDevice* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp22_ = self->priv->device_model;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp23_ = iter;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp24_ = device;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp25_ = _tmp24_->label;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_list_store_set (_tmp22_, &_tmp23_, 1, _tmp25_, -1, -1);
#line 1564 "ui.c"
					{
						gboolean _tmp26_ = FALSE;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						i = 0;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp26_ = TRUE;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						while (TRUE) {
#line 1573 "ui.c"
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							GtkListStore* _tmp30_ = NULL;
							gint _tmp31_ = 0;
							GtkTreeIter _tmp32_ = {0};
							GtkListStore* _tmp33_ = NULL;
							GtkTreeIter _tmp34_ = {0};
#line 423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (!_tmp26_) {
#line 1583 "ui.c"
								gint _tmp27_ = 0;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp27_ = i;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								i = _tmp27_ + 1;
#line 1589 "ui.c"
							}
#line 423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp26_ = FALSE;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp28_ = i;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp29_ = n_delete;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (!(_tmp28_ < _tmp29_)) {
#line 423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								break;
#line 1601 "ui.c"
							}
#line 425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp30_ = self->priv->device_model;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp31_ = index;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp30_, &_tmp32_, NULL, _tmp31_);
#line 425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							iter = _tmp32_;
#line 426 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp33_ = self->priv->device_model;
#line 426 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp34_ = iter;
#line 426 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							gtk_list_store_remove (_tmp33_, &_tmp34_);
#line 1617 "ui.c"
						}
					}
				} else {
					GtkListStore* _tmp35_ = NULL;
					gint _tmp36_ = 0;
					GtkTreeIter _tmp37_ = {0};
					GtkListStore* _tmp38_ = NULL;
					GtkTreeIter _tmp39_ = {0};
					ScanDevice* _tmp40_ = NULL;
					const gchar* _tmp41_ = NULL;
					ScanDevice* _tmp42_ = NULL;
					const gchar* _tmp43_ = NULL;
#line 431 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp35_ = self->priv->device_model;
#line 431 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp36_ = index;
#line 431 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_list_store_insert (_tmp35_, &_tmp37_, _tmp36_);
#line 431 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					iter = _tmp37_;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp38_ = self->priv->device_model;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp39_ = iter;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp40_ = device;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp41_ = _tmp40_->name;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp42_ = device;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp43_ = _tmp42_->label;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_list_store_set (_tmp38_, &_tmp39_, 0, _tmp41_, 1, _tmp43_, -1, -1);
#line 1652 "ui.c"
				}
#line 434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp44_ = index;
#line 434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				index = _tmp44_ + 1;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_scan_device_unref0 (device);
#line 1660 "ui.c"
			}
		}
	}
#line 438 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	while (TRUE) {
#line 1666 "ui.c"
		GtkListStore* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		GtkTreeIter _tmp47_ = {0};
		gboolean _tmp48_ = FALSE;
		GtkListStore* _tmp49_ = NULL;
		GtkTreeIter _tmp50_ = {0};
#line 438 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp45_ = self->priv->device_model;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp46_ = index;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp48_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp45_, &_tmp47_, NULL, _tmp46_);
#line 438 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		iter = _tmp47_;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (!_tmp48_) {
#line 438 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			break;
#line 1685 "ui.c"
		}
#line 439 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp49_ = self->priv->device_model;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp50_ = iter;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_list_store_remove (_tmp49_, &_tmp50_);
#line 1693 "ui.c"
	}
#line 442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp52_ = have_selection;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp52_) {
#line 1699 "ui.c"
		GList* _tmp53_ = NULL;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp53_ = devices;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp51_ = _tmp53_ != NULL;
#line 1705 "ui.c"
	} else {
#line 442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp51_ = FALSE;
#line 1709 "ui.c"
	}
#line 442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp51_) {
#line 1713 "ui.c"
		GtkComboBox* _tmp54_ = NULL;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp54_ = self->priv->device_combo;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_combo_box_set_active (_tmp54_, 0);
#line 1719 "ui.c"
	}
#line 445 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->setting_devices = FALSE;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_info_bar (self);
#line 1725 "ui.c"
}


static void user_interface_add_default_page (UserInterface* self) {
	Page* page = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ScanDirection _tmp3_ = 0;
	Page* _tmp4_ = NULL;
	Book* _tmp5_ = NULL;
	BookView* _tmp6_ = NULL;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->default_page_width;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->default_page_height;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->default_page_dpi;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->default_page_scan_direction;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp4_;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = self->priv->_book;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_append_page (_tmp5_, page);
#line 457 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = self->priv->book_view;
#line 457 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_view_set_selected_page (_tmp6_, page);
#line 450 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 1762 "ui.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 930 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 931 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 931 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 931 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 931 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 933 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 933 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1787 "ui.c"
		gchar* _tmp4_ = NULL;
#line 934 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 934 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 934 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 1795 "ui.c"
	} else {
#line 936 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		result = -1;
#line 936 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 1801 "ui.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1226 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1227 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1227 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1227 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1228 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1228 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1835 "ui.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1229 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1229 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1229 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1844 "ui.c"
	}
#line 1231 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1231 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1850 "ui.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1232 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1232 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1232 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1859 "ui.c"
	}
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1865 "ui.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1874 "ui.c"
	} else {
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1878 "ui.c"
	}
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 1886 "ui.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 1895 "ui.c"
	} else {
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 1899 "ui.c"
	}
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1236 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1236 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1236 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 1921 "ui.c"
}


static void user_interface_on_file_type_changed (UserInterface* self, GtkTreeSelection* selection) {
	gchar* extension = NULL;
	GtkTreeSelection* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path = NULL;
	GtkFileChooserDialog* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint extension_index = 0;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GtkFileChooserDialog* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 460 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (selection != NULL);
#line 462 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = selection;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_selected_extension (self, _tmp0_);
#line 462 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	extension = _tmp1_;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->save_dialog;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp2_);
#line 463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	path = _tmp3_;
#line 464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = path;
#line 464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = g_path_get_basename (_tmp4_);
#line 464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filename = _tmp5_;
#line 467 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = filename;
#line 467 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = string_last_index_of_char (_tmp6_, (gunichar) '.', 0);
#line 467 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	extension_index = _tmp7_;
#line 468 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = extension_index;
#line 468 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp8_ >= 0) {
#line 1976 "ui.c"
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gchar* _tmp11_ = NULL;
#line 469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = filename;
#line 469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = extension_index;
#line 469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = string_slice (_tmp9_, (glong) 0, (glong) _tmp10_);
#line 469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (filename);
#line 469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		filename = _tmp11_;
#line 1990 "ui.c"
	}
#line 470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = filename;
#line 470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = extension;
#line 470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
#line 470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (filename);
#line 470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filename = _tmp14_;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = self->priv->save_dialog;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = filename;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp15_, _tmp16_);
#line 460 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (filename);
#line 460 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (path);
#line 460 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (extension);
#line 2014 "ui.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self ? g_object_ref (self) : NULL;
#line 2021 "ui.c"
}


static gchar* user_interface_get_selected_extension (UserInterface* self, GtkTreeSelection* selection) {
	gchar* result = NULL;
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	gchar* extension = NULL;
	gchar* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	GtkTreeModel* _tmp5_ = NULL;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 474 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (selection != NULL, NULL);
#line 478 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = g_strdup ("");
#line 478 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	extension = _tmp0_;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = selection;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = gtk_tree_selection_get_selected (_tmp1_, &_tmp2_, &_tmp3_);
#line 480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (model);
#line 480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _g_object_ref0 (_tmp2_);
#line 480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	model = _tmp5_;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp3_;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_) {
#line 2058 "ui.c"
		GtkTreeModel* _tmp6_ = NULL;
		GtkTreeIter _tmp7_ = {0};
#line 481 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = model;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = iter;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get (_tmp6_, &_tmp7_, 1, &extension, -1, -1);
#line 2067 "ui.c"
	}
#line 482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = extension;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (model);
#line 482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 2075 "ui.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1193 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1193 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1193 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1193 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1194 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1194 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 2098 "ui.c"
		glong _tmp4_ = 0L;
#line 1195 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1195 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1195 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 2106 "ui.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1197 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1197 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1197 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1197 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 2118 "ui.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1204 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1206 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1206 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2142 "ui.c"
		glong _tmp2_ = 0L;
#line 1206 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1206 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2148 "ui.c"
	} else {
#line 1206 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2152 "ui.c"
	}
#line 1206 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 2156 "ui.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1208 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1208 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1208 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1208 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 2168 "ui.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1210 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1210 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1210 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 2178 "ui.c"
	}
#line 1213 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1213 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 2184 "ui.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1214 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1214 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1214 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1215 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1215 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 2198 "ui.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1217 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1217 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1217 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 2208 "ui.c"
	}
#line 1219 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1219 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 2214 "ui.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1220 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1220 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1220 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 2223 "ui.c"
	}
#line 1222 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1222 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1222 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1222 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1223 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1223 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1223 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1223 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1223 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 2243 "ui.c"
}


static void _user_interface_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
#line 569 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_on_file_type_changed ((UserInterface*) self, _sender);
#line 2250 "ui.c"
}


static gchar* user_interface_choose_file_location (UserInterface* self) {
	gchar* result = NULL;
	gchar* directory = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkFileChooserDialog* _tmp10_ = NULL;
	GtkFileChooserDialog* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GtkFileChooserDialog* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp17_ = NULL;
	GtkFileFilter* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GtkFileFilter* _tmp20_ = NULL;
	GtkFileFilter* _tmp21_ = NULL;
	GtkFileChooserDialog* _tmp22_ = NULL;
	GtkFileFilter* _tmp23_ = NULL;
	GtkFileFilter* _tmp24_ = NULL;
	GtkFileFilter* _tmp25_ = NULL;
	GtkFileFilter* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GtkFileFilter* _tmp28_ = NULL;
	GtkFileChooserDialog* _tmp29_ = NULL;
	GtkFileFilter* _tmp30_ = NULL;
	GtkFileFilter* _tmp31_ = NULL;
	GtkExpander* expander = NULL;
	const gchar* _tmp32_ = NULL;
	GtkExpander* _tmp33_ = NULL;
	GtkExpander* _tmp34_ = NULL;
	GtkFileChooserDialog* _tmp35_ = NULL;
	GtkExpander* _tmp36_ = NULL;
	gchar* default_extension = NULL;
	gchar* _tmp37_ = NULL;
	gint index = 0;
	const gchar* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	GtkListStore* file_type_store = NULL;
	GtkListStore* _tmp44_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp45_ = NULL;
	GtkTreeIter _tmp46_ = {0};
	GtkListStore* _tmp47_ = NULL;
	GtkTreeIter _tmp48_ = {0};
	const gchar* _tmp49_ = NULL;
	GtkListStore* _tmp50_ = NULL;
	GtkTreeIter _tmp51_ = {0};
	GtkListStore* _tmp52_ = NULL;
	GtkTreeIter _tmp53_ = {0};
	const gchar* _tmp54_ = NULL;
	GtkListStore* _tmp55_ = NULL;
	GtkTreeIter _tmp56_ = {0};
	GtkListStore* _tmp57_ = NULL;
	GtkTreeIter _tmp58_ = {0};
	const gchar* _tmp59_ = NULL;
	GtkTreeView* file_type_view = NULL;
	GtkListStore* _tmp60_ = NULL;
	GtkTreeView* _tmp61_ = NULL;
	GtkTreeView* _tmp62_ = NULL;
	GtkTreeView* _tmp63_ = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkCellRendererText* _tmp64_ = NULL;
	GtkCellRendererText* _tmp65_ = NULL;
	GtkTreeViewColumn* _tmp66_ = NULL;
	GtkTreeViewColumn* _tmp67_ = NULL;
	GtkTreeView* _tmp68_ = NULL;
	GtkTreeViewColumn* _tmp69_ = NULL;
	GtkExpander* _tmp70_ = NULL;
	GtkTreeView* _tmp71_ = NULL;
	GtkListStore* _tmp72_ = NULL;
	GtkTreeIter _tmp73_ = {0};
	gboolean _tmp74_ = FALSE;
	GtkTreeView* _tmp85_ = NULL;
	GtkTreeSelection* _tmp86_ = NULL;
	GtkExpander* _tmp87_ = NULL;
	gint response = 0;
	GtkFileChooserDialog* _tmp88_ = NULL;
	gint _tmp89_ = 0;
	gchar* uri = NULL;
	gint _tmp90_ = 0;
	GSettings* _tmp110_ = NULL;
	GtkFileChooserDialog* _tmp111_ = NULL;
	gchar* _tmp112_ = NULL;
	gchar* _tmp113_ = NULL;
	GtkTreeView* _tmp114_ = NULL;
	GtkTreeSelection* _tmp115_ = NULL;
	guint _tmp116_ = 0U;
	GtkFileChooserDialog* _tmp117_ = NULL;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	directory = NULL;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_settings_get_string (_tmp0_, "save-directory");
#line 489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (directory);
#line 489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	directory = _tmp1_;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = directory;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp3_ == NULL) {
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = TRUE;
#line 2368 "ui.c"
	} else {
		const gchar* _tmp4_ = NULL;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = directory;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
#line 2375 "ui.c"
	}
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 2379 "ui.c"
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
#line 492 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 492 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (directory);
#line 492 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		directory = _tmp6_;
#line 2390 "ui.c"
	}
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = _ ("Save As...");
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = _ ("_Cancel");
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = _ ("_Save");
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp7_, (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, _tmp8_, GTK_RESPONSE_CANCEL, _tmp9_, GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp10_);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->save_dialog = _tmp10_;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = self->priv->save_dialog;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp11_, TRUE);
#line 502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = self->priv->save_dialog;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp12_, FALSE);
#line 503 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = self->priv->save_dialog;
#line 503 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = directory;
#line 503 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp13_, _tmp14_);
#line 504 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = self->priv->save_dialog;
#line 504 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = self->priv->_default_file_name;
#line 504 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp15_, _tmp16_);
#line 507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = gtk_file_filter_new ();
#line 507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp17_);
#line 507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filter = _tmp17_;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = filter;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = _ ("Image Files");
#line 508 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_set_name (_tmp18_, _tmp19_);
#line 510 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = filter;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_add_pixbuf_formats (_tmp20_);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = filter;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_add_mime_type (_tmp21_, "application/pdf");
#line 512 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = self->priv->save_dialog;
#line 512 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = filter;
#line 512 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = _g_object_ref0 (_tmp23_);
#line 512 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp22_, _tmp24_);
#line 513 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = gtk_file_filter_new ();
#line 513 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp25_);
#line 513 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (filter);
#line 513 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filter = _tmp25_;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = filter;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = _ ("All Files");
#line 514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_set_name (_tmp26_, _tmp27_);
#line 516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp28_ = filter;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_add_pattern (_tmp28_, "*");
#line 517 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp29_ = self->priv->save_dialog;
#line 517 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp30_ = filter;
#line 517 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp31_ = _g_object_ref0 (_tmp30_);
#line 517 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp29_, _tmp31_);
#line 519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp32_ = _ ("Select File _Type");
#line 519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp33_ = (GtkExpander*) gtk_expander_new_with_mnemonic (_tmp32_);
#line 519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp33_);
#line 519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	expander = _tmp33_;
#line 521 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp34_ = expander;
#line 521 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_expander_set_spacing (_tmp34_, 5);
#line 522 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp35_ = self->priv->save_dialog;
#line 522 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp36_ = expander;
#line 522 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_extra_widget ((GtkFileChooser*) _tmp35_, (GtkWidget*) _tmp36_);
#line 524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp37_ = g_strdup ("");
#line 524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	default_extension = _tmp37_;
#line 525 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp38_ = self->priv->_default_file_name;
#line 525 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp39_ = string_last_index_of_char (_tmp38_, (gunichar) '.', 0);
#line 525 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	index = _tmp39_;
#line 526 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp40_ = index;
#line 526 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp40_ >= 0) {
#line 2512 "ui.c"
		const gchar* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gchar* _tmp43_ = NULL;
#line 527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp41_ = self->priv->_default_file_name;
#line 527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp42_ = index;
#line 527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp43_ = string_substring (_tmp41_, (glong) _tmp42_, (glong) (-1));
#line 527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (default_extension);
#line 527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		default_extension = _tmp43_;
#line 2526 "ui.c"
	}
#line 529 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp44_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
#line 529 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	file_type_store = _tmp44_;
#line 531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp45_ = file_type_store;
#line 531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp45_, &_tmp46_);
#line 531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp46_;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp47_ = file_type_store;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp48_ = iter;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp49_ = _ ("PDF (multi-page document)");
#line 532 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp47_, &_tmp48_, 0, _tmp49_, 1, ".pdf", -1, -1);
#line 537 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp50_ = file_type_store;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp50_, &_tmp51_);
#line 537 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp51_;
#line 538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp52_ = file_type_store;
#line 538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp53_ = iter;
#line 538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp54_ = _ ("JPEG (compressed)");
#line 538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp52_, &_tmp53_, 0, _tmp54_, 1, ".jpg", -1, -1);
#line 543 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp55_ = file_type_store;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp55_, &_tmp56_);
#line 543 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp56_;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp57_ = file_type_store;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp58_ = iter;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp59_ = _ ("PNG (lossless)");
#line 544 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp57_, &_tmp58_, 0, _tmp59_, 1, ".png", -1, -1);
#line 550 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp60_ = file_type_store;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp61_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp60_);
#line 550 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp61_);
#line 550 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	file_type_view = _tmp61_;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp62_ = file_type_view;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_tree_view_set_headers_visible (_tmp62_, FALSE);
#line 552 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp63_ = file_type_view;
#line 552 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_tree_view_set_rules_hint (_tmp63_, TRUE);
#line 553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp64_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp64_);
#line 553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp65_ = _tmp64_;
#line 553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp66_ = gtk_tree_view_column_new_with_attributes ("", (GtkCellRenderer*) _tmp65_, "text", 0, NULL, NULL);
#line 553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp66_);
#line 553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp67_ = _tmp66_;
#line 553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (_tmp65_);
#line 553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	column = _tmp67_;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp68_ = file_type_view;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp69_ = column;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_tree_view_append_column (_tmp68_, _tmp69_);
#line 557 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp70_ = expander;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp71_ = file_type_view;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_add ((GtkContainer*) _tmp70_, (GtkWidget*) _tmp71_);
#line 559 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp72_ = file_type_store;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp74_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp72_, &_tmp73_);
#line 559 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp73_;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp74_) {
#line 2626 "ui.c"
		{
			gboolean _tmp75_ = FALSE;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp75_ = TRUE;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			while (TRUE) {
#line 2633 "ui.c"
				gchar* e = NULL;
				GtkListStore* _tmp78_ = NULL;
				GtkTreeIter _tmp79_ = {0};
				const gchar* _tmp80_ = NULL;
				const gchar* _tmp81_ = NULL;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (!_tmp75_) {
#line 2641 "ui.c"
					GtkListStore* _tmp76_ = NULL;
					gboolean _tmp77_ = FALSE;
#line 567 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp76_ = file_type_store;
#line 567 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp77_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp76_, &iter);
#line 567 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (!_tmp77_) {
#line 567 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						break;
#line 2652 "ui.c"
					}
				}
#line 561 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp75_ = FALSE;
#line 564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp78_ = file_type_store;
#line 564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp79_ = iter;
#line 564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp78_, &_tmp79_, 1, &e, -1, -1);
#line 565 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp80_ = default_extension;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp81_ = e;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (g_strcmp0 (_tmp80_, _tmp81_) == 0) {
#line 2669 "ui.c"
					GtkTreeView* _tmp82_ = NULL;
					GtkTreeSelection* _tmp83_ = NULL;
					GtkTreeIter _tmp84_ = {0};
#line 566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp82_ = file_type_view;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp83_ = gtk_tree_view_get_selection (_tmp82_);
#line 566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp84_ = iter;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_tree_selection_select_iter (_tmp83_, &_tmp84_);
#line 2681 "ui.c"
				}
#line 561 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (e);
#line 2685 "ui.c"
			}
		}
	}
#line 569 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp85_ = file_type_view;
#line 569 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp86_ = gtk_tree_view_get_selection (_tmp85_);
#line 569 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp86_, "changed", (GCallback) _user_interface_on_file_type_changed_gtk_tree_selection_changed, self, 0);
#line 571 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp87_ = expander;
#line 571 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp87_);
#line 573 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp88_ = self->priv->save_dialog;
#line 573 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp89_ = gtk_dialog_run ((GtkDialog*) _tmp88_);
#line 573 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	response = _tmp89_;
#line 575 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	uri = NULL;
#line 576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp90_ = response;
#line 576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp90_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 2711 "ui.c"
		GtkTreeSelection* selection = NULL;
		GtkTreeView* _tmp91_ = NULL;
		GtkTreeSelection* _tmp92_ = NULL;
		GtkTreeSelection* _tmp93_ = NULL;
		gchar* extension = NULL;
		GtkTreeSelection* _tmp94_ = NULL;
		gchar* _tmp95_ = NULL;
		gchar* path = NULL;
		GtkFileChooserDialog* _tmp96_ = NULL;
		gchar* _tmp97_ = NULL;
		gchar* filename = NULL;
		const gchar* _tmp98_ = NULL;
		gchar* _tmp99_ = NULL;
		gint extension_index = 0;
		const gchar* _tmp100_ = NULL;
		gint _tmp101_ = 0;
		gint _tmp102_ = 0;
		const gchar* _tmp106_ = NULL;
		GFile* _tmp107_ = NULL;
		GFile* _tmp108_ = NULL;
		gchar* _tmp109_ = NULL;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp91_ = file_type_view;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp92_ = gtk_tree_view_get_selection (_tmp91_);
#line 578 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp93_ = _g_object_ref0 (_tmp92_);
#line 578 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		selection = _tmp93_;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp94_ = selection;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp95_ = user_interface_get_selected_extension (self, _tmp94_);
#line 579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		extension = _tmp95_;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp96_ = self->priv->save_dialog;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp97_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp96_);
#line 581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		path = _tmp97_;
#line 582 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp98_ = path;
#line 582 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp99_ = g_path_get_basename (_tmp98_);
#line 582 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		filename = _tmp99_;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp100_ = filename;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp101_ = string_last_index_of_char (_tmp100_, (gunichar) '.', 0);
#line 584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		extension_index = _tmp101_;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp102_ = extension_index;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp102_ < 0) {
#line 2769 "ui.c"
			const gchar* _tmp103_ = NULL;
			const gchar* _tmp104_ = NULL;
			gchar* _tmp105_ = NULL;
#line 586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp103_ = path;
#line 586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp104_ = extension;
#line 586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp105_ = g_strconcat (_tmp103_, _tmp104_, NULL);
#line 586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (path);
#line 586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			path = _tmp105_;
#line 2783 "ui.c"
		}
#line 588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp106_ = path;
#line 588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp107_ = g_file_new_for_path (_tmp106_);
#line 588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp108_ = _tmp107_;
#line 588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp109_ = g_file_get_uri (_tmp108_);
#line 588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		uri = _tmp109_;
#line 588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (_tmp108_);
#line 576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (filename);
#line 576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (extension);
#line 576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (selection);
#line 2807 "ui.c"
	}
#line 591 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp110_ = self->priv->settings;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp111_ = self->priv->save_dialog;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp112_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp111_);
#line 591 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp113_ = _tmp112_;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_string (_tmp110_, "save-directory", _tmp113_);
#line 591 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_tmp113_);
#line 593 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp114_ = file_type_view;
#line 593 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp115_ = gtk_tree_view_get_selection (_tmp114_);
#line 593 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("changed", GTK_TYPE_TREE_SELECTION, &_tmp116_, NULL, FALSE);
#line 593 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp115_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp116_, 0, NULL, (GCallback) _user_interface_on_file_type_changed_gtk_tree_selection_changed, self);
#line 594 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp117_ = self->priv->save_dialog;
#line 594 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp117_);
#line 595 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 595 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->save_dialog = NULL;
#line 597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = uri;
#line 597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (column);
#line 597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (file_type_view);
#line 597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (file_type_store);
#line 597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (default_extension);
#line 597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (expander);
#line 597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (filter);
#line 597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (directory);
#line 597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 2855 "ui.c"
}


static gboolean user_interface_save_document (UserInterface* self, gboolean force_choose_location) {
	gboolean result = FALSE;
	gchar* uri = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp6_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* uri_lower = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* format = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	Book* _tmp40_ = NULL;
	GError * _inner_error_ = NULL;
#line 600 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->book_uri;
#line 603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_ != NULL) {
#line 2886 "ui.c"
		gboolean _tmp2_ = FALSE;
#line 603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = force_choose_location;
#line 603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = !_tmp2_;
#line 2892 "ui.c"
	} else {
#line 603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = FALSE;
#line 2896 "ui.c"
	}
#line 603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 2900 "ui.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->book_uri;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		uri = _tmp4_;
#line 2911 "ui.c"
	} else {
		gchar* _tmp5_ = NULL;
#line 606 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = user_interface_choose_file_location (self);
#line 606 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 606 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		uri = _tmp5_;
#line 2920 "ui.c"
	}
#line 607 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = uri;
#line 607 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp6_ == NULL) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = FALSE;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 2932 "ui.c"
	}
#line 610 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = uri;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = g_file_new_for_uri (_tmp7_);
#line 610 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	file = _tmp8_;
#line 612 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = uri;
#line 612 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_debug ("ui.vala:612: Saving to '%s'", _tmp9_);
#line 614 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = uri;
#line 614 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = g_utf8_strdown (_tmp10_, (gssize) (-1));
#line 614 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	uri_lower = _tmp11_;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = g_strdup ("jpeg");
#line 615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	format = _tmp12_;
#line 616 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = uri_lower;
#line 616 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = g_str_has_suffix (_tmp13_, ".pdf");
#line 616 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp14_) {
#line 2960 "ui.c"
		gchar* _tmp15_ = NULL;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = g_strdup ("pdf");
#line 617 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (format);
#line 617 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		format = _tmp15_;
#line 2968 "ui.c"
	} else {
		const gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 618 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp16_ = uri_lower;
#line 618 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp17_ = g_str_has_suffix (_tmp16_, ".ps");
#line 618 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp17_) {
#line 2978 "ui.c"
			gchar* _tmp18_ = NULL;
#line 619 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp18_ = g_strdup ("ps");
#line 619 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (format);
#line 619 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			format = _tmp18_;
#line 2986 "ui.c"
		} else {
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
#line 620 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp19_ = uri_lower;
#line 620 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp20_ = g_str_has_suffix (_tmp19_, ".png");
#line 620 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (_tmp20_) {
#line 2996 "ui.c"
				gchar* _tmp21_ = NULL;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp21_ = g_strdup ("png");
#line 621 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (format);
#line 621 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				format = _tmp21_;
#line 3004 "ui.c"
			} else {
				gboolean _tmp22_ = FALSE;
				const gchar* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
#line 622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp23_ = uri_lower;
#line 622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp24_ = g_str_has_suffix (_tmp23_, ".tif");
#line 622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp24_) {
#line 622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp22_ = TRUE;
#line 3017 "ui.c"
				} else {
					const gchar* _tmp25_ = NULL;
					gboolean _tmp26_ = FALSE;
#line 622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp25_ = uri_lower;
#line 622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp26_ = g_str_has_suffix (_tmp25_, ".tiff");
#line 622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp22_ = _tmp26_;
#line 3027 "ui.c"
				}
#line 622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp22_) {
#line 3031 "ui.c"
					gchar* _tmp27_ = NULL;
#line 623 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp27_ = g_strdup ("tiff");
#line 623 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_g_free0 (format);
#line 623 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					format = _tmp27_;
#line 3039 "ui.c"
				}
			}
		}
	}
#line 625 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_progress_dialog (self);
#line 3046 "ui.c"
	{
		Book* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		GFile* _tmp32_ = NULL;
#line 628 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp28_ = self->priv->_book;
#line 628 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp29_ = format;
#line 628 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp30_ = user_interface_get_quality (self);
#line 628 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp31_ = _tmp30_;
#line 628 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp32_ = file;
#line 628 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		book_save (_tmp28_, _tmp29_, _tmp31_, _tmp32_, &_inner_error_);
#line 628 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 3067 "ui.c"
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		GError* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
#line 626 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 626 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 632 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_hide_progress_dialog (self);
#line 633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp33_ = e;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp34_ = _tmp33_->message;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_warning ("ui.vala:633: Error saving file: %s", _tmp34_);
#line 634 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp35_ = _ ("Failed to save file");
#line 634 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp36_ = e;
#line 634 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp37_ = _tmp36_->message;
#line 634 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_show_error (self, _tmp35_, _tmp37_, FALSE);
#line 638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = FALSE;
#line 638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (format);
#line 638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri_lower);
#line 638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 3114 "ui.c"
	}
	__finally16:
#line 626 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 626 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (format);
#line 626 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri_lower);
#line 626 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 626 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 626 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 626 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 626 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return FALSE;
#line 3133 "ui.c"
	}
#line 641 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp38_ = uri;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp39_ = g_strdup (_tmp38_);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->book_uri = _tmp39_;
#line 642 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp40_ = self->priv->_book;
#line 642 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_set_needs_saving (_tmp40_, FALSE);
#line 643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = TRUE;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (format);
#line 643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (uri_lower);
#line 643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (file);
#line 643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (uri);
#line 643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3159 "ui.c"
}


static gboolean user_interface_prompt_to_save (UserInterface* self, const gchar* title, const gchar* discard_label) {
	gboolean result = FALSE;
	Book* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	GtkMessageDialog* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GtkMessageDialog* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkMessageDialog* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GtkMessageDialog* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gint response = 0;
	GtkMessageDialog* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	GtkMessageDialog* _tmp15_ = NULL;
	gint _tmp16_ = 0;
#line 646 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 646 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (title != NULL, FALSE);
#line 646 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (discard_label != NULL, FALSE);
#line 648 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 648 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_get_needs_saving (_tmp0_);
#line 648 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 648 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp2_) {
#line 649 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = TRUE;
#line 649 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 3202 "ui.c"
	}
#line 651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = title;
#line 651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp3_);
#line 651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp4_);
#line 651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dialog = _tmp4_;
#line 656 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = dialog;
#line 656 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = _ ("If you don't save, changes will be permanently lost.");
#line 656 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_message_dialog_format_secondary_text (_tmp5_, "%s", _tmp6_);
#line 659 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = dialog;
#line 659 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = discard_label;
#line 659 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp7_, _tmp8_, (gint) GTK_RESPONSE_NO);
#line 660 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = dialog;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = _ ("_Cancel");
#line 660 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp9_, _tmp10_, (gint) GTK_RESPONSE_CANCEL);
#line 661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = dialog;
#line 661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = _ ("_Save");
#line 661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp11_, _tmp12_, (gint) GTK_RESPONSE_YES);
#line 663 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = dialog;
#line 663 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = gtk_dialog_run ((GtkDialog*) _tmp13_);
#line 663 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	response = _tmp14_;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = dialog;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp15_);
#line 666 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = response;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	switch (_tmp16_) {
#line 666 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case GTK_RESPONSE_YES:
#line 3252 "ui.c"
		{
			gboolean _tmp17_ = FALSE;
#line 669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp17_ = user_interface_save_document (self, FALSE);
#line 669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (_tmp17_) {
#line 670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				result = TRUE;
#line 670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_object_unref0 (dialog);
#line 670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				return result;
#line 3265 "ui.c"
			} else {
#line 672 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				result = FALSE;
#line 672 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_object_unref0 (dialog);
#line 672 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				return result;
#line 3273 "ui.c"
			}
		}
#line 666 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case GTK_RESPONSE_CANCEL:
#line 3278 "ui.c"
		{
#line 674 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			result = FALSE;
#line 674 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_object_unref0 (dialog);
#line 674 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			return result;
#line 3286 "ui.c"
		}
		default:
#line 666 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case GTK_RESPONSE_NO:
#line 3291 "ui.c"
		{
#line 677 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			result = TRUE;
#line 677 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_object_unref0 (dialog);
#line 677 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			return result;
#line 3299 "ui.c"
		}
	}
#line 646 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (dialog);
#line 3304 "ui.c"
}


static void user_interface_clear_document (UserInterface* self) {
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	GtkMenuItem* _tmp2_ = NULL;
	GtkMenuItem* _tmp3_ = NULL;
#line 681 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 683 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 683 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_clear (_tmp0_);
#line 684 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_add_default_page (self);
#line 685 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 685 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->book_uri = NULL;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->_book;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_set_needs_saving (_tmp1_, FALSE);
#line 687 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->save_as_menuitem;
#line 687 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
#line 688 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->copy_to_clipboard_menuitem;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
#line 3337 "ui.c"
}


static void user_interface_new_document (UserInterface* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 691 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 693 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = _ ("Save current document?");
#line 693 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _ ("Discard Changes");
#line 693 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = user_interface_prompt_to_save (self, _tmp0_, _tmp1_);
#line 693 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp2_) {
#line 697 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 3359 "ui.c"
	}
#line 699 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = user_interface_get_scanning (self);
#line 699 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = _tmp3_;
#line 699 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_) {
#line 700 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_signal_emit_by_name (self, "stop-scan");
#line 3369 "ui.c"
	}
#line 701 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_clear_document (self);
#line 3373 "ui.c"
}


static void user_interface_new_button_clicked_cb (UserInterface* self, GtkWidget* widget) {
#line 705 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 705 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 707 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_new_document (self);
#line 3384 "ui.c"
}


static void _user_interface_new_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_new_button_clicked_cb ((UserInterface*) self, _sender);
#line 3391 "ui.c"
}


void user_interface_new_document_activate_cb (UserInterface* self) {
#line 710 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_new_document (self);
#line 3400 "ui.c"
}


static void user_interface_set_document_hint (UserInterface* self, const gchar* document_hint, gboolean save) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 715 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 715 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (document_hint != NULL);
#line 717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = document_hint;
#line 717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->document_hint);
#line 717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->document_hint = _tmp1_;
#line 719 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = document_hint;
#line 719 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (g_strcmp0 (_tmp2_, "text") == 0) {
#line 3425 "ui.c"
		GtkRadioMenuItem* _tmp3_ = NULL;
		GtkRadioMenuItem* _tmp4_ = NULL;
#line 721 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->text_button_menuitem;
#line 721 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp3_, TRUE);
#line 722 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->text_menuitem;
#line 722 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp4_, TRUE);
#line 3436 "ui.c"
	} else {
		const gchar* _tmp5_ = NULL;
#line 724 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = document_hint;
#line 724 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (g_strcmp0 (_tmp5_, "photo") == 0) {
#line 3443 "ui.c"
			GtkRadioMenuItem* _tmp6_ = NULL;
			GtkRadioMenuItem* _tmp7_ = NULL;
#line 726 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp6_ = self->priv->photo_button_menuitem;
#line 726 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp6_, TRUE);
#line 727 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp7_ = self->priv->photo_menuitem;
#line 727 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp7_, TRUE);
#line 3454 "ui.c"
		}
	}
#line 730 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = save;
#line 730 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp8_) {
#line 3461 "ui.c"
		GSettings* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 731 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = self->priv->settings;
#line 731 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = document_hint;
#line 731 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_settings_set_string (_tmp9_, "document-type", _tmp10_);
#line 3470 "ui.c"
	}
}


static void user_interface_text_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 735 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 735 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 737 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 737 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 737 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 737 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 738 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_document_hint (self, "text", TRUE);
#line 3493 "ui.c"
	}
}


static void _user_interface_text_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_text_menuitem_toggled_cb ((UserInterface*) self, _sender);
#line 3501 "ui.c"
}


static void user_interface_photo_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 742 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 742 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 744 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 744 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 746 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_document_hint (self, "photo", TRUE);
#line 3523 "ui.c"
	}
}


static void _user_interface_photo_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_photo_menuitem_toggled_cb ((UserInterface*) self, _sender);
#line 3531 "ui.c"
}


static void user_interface_set_page_side (UserInterface* self, ScanType page_side) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 750 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 754 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->page_side_model;
#line 754 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 754 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 754 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 3550 "ui.c"
		{
			gboolean _tmp3_ = FALSE;
#line 756 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp3_ = TRUE;
#line 756 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			while (TRUE) {
#line 3557 "ui.c"
				gint s = 0;
				GtkListStore* _tmp6_ = NULL;
				GtkTreeIter _tmp7_ = {0};
				gint _tmp8_ = 0;
				ScanType _tmp9_ = 0;
#line 756 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (!_tmp3_) {
#line 3565 "ui.c"
					GtkListStore* _tmp4_ = NULL;
					gboolean _tmp5_ = FALSE;
#line 765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp4_ = self->priv->page_side_model;
#line 765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter);
#line 765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (!_tmp5_) {
#line 765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						break;
#line 3576 "ui.c"
					}
				}
#line 756 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp3_ = FALSE;
#line 759 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp6_ = self->priv->page_side_model;
#line 759 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp7_ = iter;
#line 759 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, 0, &s, -1, -1);
#line 760 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp8_ = s;
#line 760 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp9_ = page_side;
#line 760 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp8_ == ((gint) _tmp9_)) {
#line 3593 "ui.c"
					GtkComboBox* _tmp10_ = NULL;
					GtkTreeIter _tmp11_ = {0};
#line 762 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp10_ = self->priv->page_side_combo;
#line 762 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp11_ = iter;
#line 762 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_combo_box_set_active_iter (_tmp10_, &_tmp11_);
#line 763 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					return;
#line 3604 "ui.c"
				}
			}
		}
	}
}


static void user_interface_set_paper_size (UserInterface* self, gint width, gint height) {
	GtkTreeIter iter = {0};
	gboolean have_iter = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp18_ = FALSE;
#line 769 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 3619 "ui.c"
	{
		GtkListStore* _tmp0_ = NULL;
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
#line 774 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = self->priv->paper_size_model;
#line 774 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 774 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		iter = _tmp1_;
#line 774 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		have_iter = _tmp2_;
#line 774 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = TRUE;
#line 774 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		while (TRUE) {
#line 3637 "ui.c"
			gboolean _tmp6_ = FALSE;
			gint w = 0;
			gint h = 0;
			GtkListStore* _tmp7_ = NULL;
			GtkTreeIter _tmp8_ = {0};
			gboolean _tmp9_ = FALSE;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
#line 774 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (!_tmp3_) {
#line 3648 "ui.c"
				GtkListStore* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
#line 776 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp4_ = self->priv->paper_size_model;
#line 776 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter);
#line 776 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				have_iter = _tmp5_;
#line 3657 "ui.c"
			}
#line 774 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp3_ = FALSE;
#line 775 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp6_ = have_iter;
#line 775 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (!_tmp6_) {
#line 775 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				break;
#line 3667 "ui.c"
			}
#line 779 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp7_ = self->priv->paper_size_model;
#line 779 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp8_ = iter;
#line 779 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, 0, &w, 1, &h, -1, -1);
#line 780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp10_ = w;
#line 780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp11_ = width;
#line 780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (_tmp10_ == _tmp11_) {
#line 3681 "ui.c"
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
#line 780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp12_ = h;
#line 780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp13_ = height;
#line 780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp9_ = _tmp12_ == _tmp13_;
#line 3690 "ui.c"
			} else {
#line 780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp9_ = FALSE;
#line 3694 "ui.c"
			}
#line 780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (_tmp9_) {
#line 781 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				break;
#line 3700 "ui.c"
			}
		}
	}
#line 784 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = have_iter;
#line 784 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp14_) {
#line 3708 "ui.c"
		GtkListStore* _tmp15_ = NULL;
		GtkTreeIter _tmp16_ = {0};
		gboolean _tmp17_ = FALSE;
#line 785 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = self->priv->paper_size_model;
#line 785 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp17_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp15_, &_tmp16_);
#line 785 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		iter = _tmp16_;
#line 785 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		have_iter = _tmp17_;
#line 3720 "ui.c"
	}
#line 786 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = have_iter;
#line 786 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp18_) {
#line 3726 "ui.c"
		GtkComboBox* _tmp19_ = NULL;
		GtkTreeIter _tmp20_ = {0};
#line 787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp19_ = self->priv->paper_size_combo;
#line 787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp20_ = iter;
#line 787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_combo_box_set_active_iter (_tmp19_, &_tmp20_);
#line 3735 "ui.c"
	}
}


static gint user_interface_get_text_dpi (UserInterface* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi = 0;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 790 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 793 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dpi = USER_INTERFACE_DEFAULT_TEXT_DPI;
#line 795 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->text_dpi_combo;
#line 795 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 795 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 795 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 3759 "ui.c"
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 796 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->text_dpi_model;
#line 796 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = iter;
#line 796 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
#line 3768 "ui.c"
	}
#line 798 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = dpi;
#line 798 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3774 "ui.c"
}


static gint user_interface_get_photo_dpi (UserInterface* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi = 0;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 801 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 804 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dpi = USER_INTERFACE_DEFAULT_PHOTO_DPI;
#line 806 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->photo_dpi_combo;
#line 806 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 806 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 806 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 3797 "ui.c"
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 807 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->photo_dpi_model;
#line 807 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = iter;
#line 807 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
#line 3806 "ui.c"
	}
#line 809 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = dpi;
#line 809 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3812 "ui.c"
}


static ScanType user_interface_get_page_side (UserInterface* self) {
	ScanType result = 0;
	GtkTreeIter iter = {0};
	gint page_side = 0;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint _tmp5_ = 0;
#line 812 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 815 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page_side = (gint) SCAN_TYPE_ADF_BOTH;
#line 817 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->page_side_combo;
#line 817 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 817 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 817 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 3836 "ui.c"
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 818 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->page_side_model;
#line 818 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = iter;
#line 818 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &page_side, -1, -1);
#line 3845 "ui.c"
	}
#line 820 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page_side;
#line 820 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = (ScanType) _tmp5_;
#line 820 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3853 "ui.c"
}


static gboolean user_interface_get_paper_size (UserInterface* self, gint* width, gint* height) {
	gint _vala_width = 0;
	gint _vala_height = 0;
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	gint _tmp0_ = 0;
	GtkComboBox* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
#line 823 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 827 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_height = 0;
#line 827 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = _vala_height;
#line 827 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_width = _tmp0_;
#line 828 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->paper_size_combo;
#line 828 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
#line 828 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp2_;
#line 828 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp3_) {
#line 3882 "ui.c"
		GtkListStore* _tmp4_ = NULL;
		GtkTreeIter _tmp5_ = {0};
#line 830 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->paper_size_model;
#line 830 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = iter;
#line 830 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 0, &_vala_width, 1, &_vala_height, -1, -1);
#line 831 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = TRUE;
#line 831 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (width) {
#line 831 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			*width = _vala_width;
#line 3897 "ui.c"
		}
#line 831 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (height) {
#line 831 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			*height = _vala_height;
#line 3903 "ui.c"
		}
#line 831 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 3907 "ui.c"
	}
#line 834 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 834 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (width) {
#line 834 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*width = _vala_width;
#line 3915 "ui.c"
	}
#line 834 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (height) {
#line 834 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*height = _vala_height;
#line 3921 "ui.c"
	}
#line 834 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3925 "ui.c"
}


static ScanOptions* user_interface_make_scan_options (UserInterface* self) {
	ScanOptions* result = NULL;
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ScanOptions* _tmp10_ = NULL;
	ScanOptions* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	ScanOptions* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	ScanOptions* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 839 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = scan_options_new ();
#line 839 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	options = _tmp0_;
#line 840 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->document_hint;
#line 840 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (g_strcmp0 (_tmp1_, "text") == 0) {
#line 3954 "ui.c"
		ScanOptions* _tmp2_ = NULL;
		ScanOptions* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		ScanOptions* _tmp5_ = NULL;
#line 842 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = options;
#line 842 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_->scan_mode = SCAN_MODE_GRAY;
#line 843 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = options;
#line 843 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = user_interface_get_text_dpi (self);
#line 843 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_->dpi = _tmp4_;
#line 844 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = options;
#line 844 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_->depth = 2;
#line 3973 "ui.c"
	} else {
		ScanOptions* _tmp6_ = NULL;
		ScanOptions* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		ScanOptions* _tmp9_ = NULL;
#line 848 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = options;
#line 848 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_->scan_mode = SCAN_MODE_COLOR;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = options;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = user_interface_get_photo_dpi (self);
#line 849 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_->dpi = _tmp8_;
#line 850 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = options;
#line 850 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_->depth = 8;
#line 3993 "ui.c"
	}
#line 852 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = options;
#line 852 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = options;
#line 852 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_get_paper_size (self, &_tmp12_, &_tmp13_);
#line 852 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_->paper_width = _tmp12_;
#line 852 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_->paper_height = _tmp13_;
#line 853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = options;
#line 853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = user_interface_get_brightness (self);
#line 853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = _tmp15_;
#line 853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_->brightness = _tmp16_;
#line 854 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = options;
#line 854 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = user_interface_get_contrast (self);
#line 854 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = _tmp18_;
#line 854 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_->contrast = _tmp19_;
#line 856 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = options;
#line 856 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 4025 "ui.c"
}


static void user_interface_scan_button_clicked_cb (UserInterface* self, GtkWidget* widget) {
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 860 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 860 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 862 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = user_interface_make_scan_options (self);
#line 862 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	options = _tmp0_;
#line 863 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	options->type = SCAN_TYPE_SINGLE;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_selected_device (self);
#line 864 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_emit_by_name (self, "start-scan", _tmp3_, options);
#line 864 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_tmp3_);
#line 860 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_scan_options_unref0 (options);
#line 4057 "ui.c"
}


static void _user_interface_scan_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_scan_button_clicked_cb ((UserInterface*) self, _sender);
#line 4064 "ui.c"
}


static void user_interface_stop_scan_button_clicked_cb (UserInterface* self, GtkWidget* widget) {
#line 868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 870 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_emit_by_name (self, "stop-scan");
#line 4075 "ui.c"
}


static void _user_interface_stop_scan_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_stop_scan_button_clicked_cb ((UserInterface*) self, _sender);
#line 4082 "ui.c"
}


static void user_interface_continuous_scan_button_clicked_cb (UserInterface* self, GtkWidget* widget) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 874 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 874 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = user_interface_get_scanning (self);
#line 876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _tmp0_;
#line 876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 877 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_signal_emit_by_name (self, "stop-scan");
#line 4101 "ui.c"
	} else {
		ScanOptions* options = NULL;
		ScanOptions* _tmp2_ = NULL;
		ScanOptions* _tmp3_ = NULL;
		ScanType _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		ScanOptions* _tmp8_ = NULL;
#line 880 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = user_interface_make_scan_options (self);
#line 880 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		options = _tmp2_;
#line 881 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = options;
#line 881 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = user_interface_get_page_side (self);
#line 881 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_->type = _tmp4_;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = user_interface_get_selected_device (self);
#line 882 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = _tmp5_;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = _tmp6_;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = options;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_signal_emit_by_name (self, "start-scan", _tmp7_, _tmp8_);
#line 882 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp7_);
#line 876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_scan_options_unref0 (options);
#line 4135 "ui.c"
	}
}


static void _user_interface_continuous_scan_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_continuous_scan_button_clicked_cb ((UserInterface*) self, _sender);
#line 4143 "ui.c"
}


static void user_interface_preferences_button_clicked_cb (UserInterface* self, GtkWidget* widget) {
	GtkDialog* _tmp0_ = NULL;
#line 887 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 887 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 889 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 889 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 4157 "ui.c"
}


static void _user_interface_preferences_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_preferences_button_clicked_cb ((UserInterface*) self, _sender);
#line 4164 "ui.c"
}


void user_interface_preferences_activate_cb (UserInterface* self) {
	GtkDialog* _tmp0_ = NULL;
#line 892 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 894 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 894 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 4176 "ui.c"
}


static gboolean user_interface_preferences_dialog_delete_event_cb (UserInterface* self, GtkWidget* widget, GdkEventAny* event) {
	gboolean result = FALSE;
#line 898 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 898 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 898 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 900 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = TRUE;
#line 900 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 4192 "ui.c"
}


static gboolean _user_interface_preferences_dialog_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = user_interface_preferences_dialog_delete_event_cb ((UserInterface*) self, _sender, event);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 4201 "ui.c"
}


static void user_interface_preferences_dialog_response_cb (UserInterface* self, GtkWidget* widget, gint response_id) {
	GtkDialog* _tmp0_ = NULL;
#line 904 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 904 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 906 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 906 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
#line 4215 "ui.c"
}


static void _user_interface_preferences_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_preferences_dialog_response_cb ((UserInterface*) self, _sender, response_id);
#line 4222 "ui.c"
}


static gpointer _page_ref0 (gpointer self) {
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self ? page_ref (self) : NULL;
#line 4229 "ui.c"
}


static void user_interface_update_page_menu (UserInterface* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
#line 909 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp3_;
#line 912 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page;
#line 912 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_ == NULL) {
#line 4256 "ui.c"
		GtkMenuItem* _tmp5_ = NULL;
		GtkMenuItem* _tmp6_ = NULL;
#line 914 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = self->priv->page_move_left_menuitem;
#line 914 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
#line 915 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = self->priv->page_move_right_menuitem;
#line 915 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
#line 4267 "ui.c"
	} else {
		guint index = 0U;
		Book* _tmp7_ = NULL;
		Page* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		GtkMenuItem* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		GtkMenuItem* _tmp12_ = NULL;
		guint _tmp13_ = 0U;
		Book* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		guint _tmp16_ = 0U;
#line 919 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = self->priv->_book;
#line 919 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = page;
#line 919 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = book_get_page_index (_tmp7_, _tmp8_);
#line 919 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		index = _tmp9_;
#line 920 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = self->priv->page_move_left_menuitem;
#line 920 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = index;
#line 920 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, _tmp11_ > ((guint) 0));
#line 921 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp12_ = self->priv->page_move_right_menuitem;
#line 921 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp13_ = index;
#line 921 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp14_ = self->priv->_book;
#line 921 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = book_get_n_pages (_tmp14_);
#line 921 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp16_ = _tmp15_;
#line 921 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, _tmp13_ < (_tmp16_ - 1));
#line 4306 "ui.c"
	}
#line 909 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 4310 "ui.c"
}


static void user_interface_page_selected_cb (UserInterface* self, BookView* view, Page* page) {
	Page* _tmp0_ = NULL;
	GtkRadioMenuItem* menuitem = NULL;
	GtkRadioMenuItem* _tmp1_ = NULL;
	GtkRadioMenuItem* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GtkRadioMenuItem* _tmp31_ = NULL;
	GtkToggleButton* _tmp32_ = NULL;
	Page* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GtkToggleToolButton* _tmp36_ = NULL;
	Page* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 927 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 927 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_ == NULL) {
#line 928 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4341 "ui.c"
	}
#line 930 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->updating_page_menu = TRUE;
#line 932 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_page_menu (self);
#line 934 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->no_crop_menuitem;
#line 934 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 934 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	menuitem = _tmp2_;
#line 935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = page;
#line 935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page_get_has_crop (_tmp3_);
#line 935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp5_) {
#line 4361 "ui.c"
		gchar* crop_name = NULL;
		Page* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 937 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = page;
#line 937 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = page_get_crop_name (_tmp6_);
#line 937 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = _tmp7_;
#line 937 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 937 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		crop_name = _tmp9_;
#line 938 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = crop_name;
#line 938 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp10_ != NULL) {
#line 4382 "ui.c"
			const gchar* _tmp11_ = NULL;
#line 940 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp11_ = crop_name;
#line 940 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (g_strcmp0 (_tmp11_, "A4") == 0) {
#line 4388 "ui.c"
				GtkRadioMenuItem* _tmp12_ = NULL;
				GtkRadioMenuItem* _tmp13_ = NULL;
#line 941 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp12_ = self->priv->a4_menuitem;
#line 941 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp13_ = _g_object_ref0 (_tmp12_);
#line 941 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_object_unref0 (menuitem);
#line 941 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				menuitem = _tmp13_;
#line 4399 "ui.c"
			} else {
				const gchar* _tmp14_ = NULL;
#line 942 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp14_ = crop_name;
#line 942 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (g_strcmp0 (_tmp14_, "A5") == 0) {
#line 4406 "ui.c"
					GtkRadioMenuItem* _tmp15_ = NULL;
					GtkRadioMenuItem* _tmp16_ = NULL;
#line 943 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp15_ = self->priv->a5_menuitem;
#line 943 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp16_ = _g_object_ref0 (_tmp15_);
#line 943 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_g_object_unref0 (menuitem);
#line 943 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					menuitem = _tmp16_;
#line 4417 "ui.c"
				} else {
					const gchar* _tmp17_ = NULL;
#line 944 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp17_ = crop_name;
#line 944 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (g_strcmp0 (_tmp17_, "A6") == 0) {
#line 4424 "ui.c"
						GtkRadioMenuItem* _tmp18_ = NULL;
						GtkRadioMenuItem* _tmp19_ = NULL;
#line 945 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp18_ = self->priv->a6_menuitem;
#line 945 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp19_ = _g_object_ref0 (_tmp18_);
#line 945 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_g_object_unref0 (menuitem);
#line 945 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						menuitem = _tmp19_;
#line 4435 "ui.c"
					} else {
						const gchar* _tmp20_ = NULL;
#line 946 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp20_ = crop_name;
#line 946 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						if (g_strcmp0 (_tmp20_, "letter") == 0) {
#line 4442 "ui.c"
							GtkRadioMenuItem* _tmp21_ = NULL;
							GtkRadioMenuItem* _tmp22_ = NULL;
#line 947 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp21_ = self->priv->letter_menuitem;
#line 947 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp22_ = _g_object_ref0 (_tmp21_);
#line 947 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_g_object_unref0 (menuitem);
#line 947 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							menuitem = _tmp22_;
#line 4453 "ui.c"
						} else {
							const gchar* _tmp23_ = NULL;
#line 948 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp23_ = crop_name;
#line 948 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (g_strcmp0 (_tmp23_, "legal") == 0) {
#line 4460 "ui.c"
								GtkRadioMenuItem* _tmp24_ = NULL;
								GtkRadioMenuItem* _tmp25_ = NULL;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp24_ = self->priv->legal_menuitem;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp25_ = _g_object_ref0 (_tmp24_);
#line 949 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_g_object_unref0 (menuitem);
#line 949 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								menuitem = _tmp25_;
#line 4471 "ui.c"
							} else {
								const gchar* _tmp26_ = NULL;
#line 950 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp26_ = crop_name;
#line 950 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								if (g_strcmp0 (_tmp26_, "4x6") == 0) {
#line 4478 "ui.c"
									GtkRadioMenuItem* _tmp27_ = NULL;
									GtkRadioMenuItem* _tmp28_ = NULL;
#line 951 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
									_tmp27_ = self->priv->four_by_six_menuitem;
#line 951 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
									_tmp28_ = _g_object_ref0 (_tmp27_);
#line 951 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
									_g_object_unref0 (menuitem);
#line 951 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
									menuitem = _tmp28_;
#line 4489 "ui.c"
								}
							}
						}
					}
				}
			}
		} else {
			GtkRadioMenuItem* _tmp29_ = NULL;
			GtkRadioMenuItem* _tmp30_ = NULL;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp29_ = self->priv->custom_crop_menuitem;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp30_ = _g_object_ref0 (_tmp29_);
#line 954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_object_unref0 (menuitem);
#line 954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			menuitem = _tmp30_;
#line 4507 "ui.c"
		}
#line 935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (crop_name);
#line 4511 "ui.c"
	}
#line 957 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp31_ = menuitem;
#line 957 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp31_, TRUE);
#line 958 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp32_ = self->priv->crop_button;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp33_ = page;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp34_ = page_get_has_crop (_tmp33_);
#line 958 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp35_ = _tmp34_;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_toggle_button_set_active (_tmp32_, _tmp35_);
#line 959 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp36_ = self->priv->crop_toolbutton;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp37_ = page;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp38_ = page_get_has_crop (_tmp37_);
#line 959 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp39_ = _tmp38_;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_toggle_tool_button_set_active (_tmp36_, _tmp39_);
#line 961 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->updating_page_menu = FALSE;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (menuitem);
#line 4541 "ui.c"
}


static void user_interface_show_page_cb (UserInterface* self, BookView* view, Page* page) {
	gchar* path = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 964 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 964 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 964 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 966 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = get_temporary_filename ("scanned-page", "tiff");
#line 966 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	path = _tmp0_;
#line 967 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = path;
#line 967 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_ == NULL) {
#line 968 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 968 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4571 "ui.c"
	}
#line 969 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = path;
#line 969 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = g_file_new_for_path (_tmp2_);
#line 969 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	file = _tmp3_;
#line 4579 "ui.c"
	{
		Page* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GFile* _tmp7_ = NULL;
#line 973 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = page;
#line 973 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = user_interface_get_quality (self);
#line 973 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = _tmp5_;
#line 973 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = file;
#line 973 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_save (_tmp4_, "tiff", _tmp6_, _tmp7_, &_inner_error_);
#line 973 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 4597 "ui.c"
			goto __catch17_g_error;
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 971 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 971 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 977 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = _ ("Unable to save image for preview");
#line 977 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = e;
#line 977 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = _tmp9_->message;
#line 977 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp8_, _tmp10_);
#line 980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4628 "ui.c"
	}
	__finally17:
#line 971 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 971 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 971 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 971 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 971 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 971 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4643 "ui.c"
	}
	{
		GdkScreen* _tmp11_ = NULL;
		GdkScreen* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		guint32 _tmp16_ = 0U;
#line 985 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = gtk_window_get_screen ((GtkWindow*) self);
#line 985 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp12_ = _tmp11_;
#line 985 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp13_ = file;
#line 985 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp14_ = g_file_get_uri (_tmp13_);
#line 985 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = _tmp14_;
#line 985 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp16_ = gtk_get_current_event_time ();
#line 985 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_show_uri (_tmp12_, _tmp15_, _tmp16_, &_inner_error_);
#line 985 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp15_);
#line 985 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 4670 "ui.c"
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 983 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 983 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 989 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp17_ = _ ("Unable to open image preview application");
#line 989 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp18_ = e;
#line 989 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp19_ = _tmp18_->message;
#line 989 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp17_, _tmp19_);
#line 983 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 4695 "ui.c"
	}
	__finally18:
#line 983 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 983 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 983 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 983 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 983 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 983 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4710 "ui.c"
	}
#line 964 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (file);
#line 964 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (path);
#line 4716 "ui.c"
}


static void user_interface_show_page_menu_cb (UserInterface* self, BookView* view) {
	GtkMenu* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
#line 995 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 995 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 997 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->page_menu;
#line 997 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_get_current_event_time ();
#line 997 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_menu_popup (_tmp0_, NULL, NULL, NULL, NULL, (guint) 3, _tmp1_);
#line 4733 "ui.c"
}


static void user_interface_rotate_left_button_clicked_cb (UserInterface* self, GtkWidget* widget) {
	gboolean _tmp0_ = FALSE;
	Page* page = NULL;
	BookView* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 1001 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1001 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1003 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 1003 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 1004 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4755 "ui.c"
	}
#line 1005 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->book_view;
#line 1005 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_view_get_selected_page (_tmp1_);
#line 1005 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1005 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = _page_ref0 (_tmp3_);
#line 1005 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp4_;
#line 1006 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page;
#line 1006 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp5_ != NULL) {
#line 4771 "ui.c"
		Page* _tmp6_ = NULL;
#line 1007 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = page;
#line 1007 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_rotate_left (_tmp6_);
#line 4777 "ui.c"
	}
#line 1001 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 4781 "ui.c"
}


static void _user_interface_rotate_left_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_rotate_left_button_clicked_cb ((UserInterface*) self, _sender);
#line 4788 "ui.c"
}


static void user_interface_rotate_right_button_clicked_cb (UserInterface* self, GtkWidget* widget) {
	gboolean _tmp0_ = FALSE;
	Page* page = NULL;
	BookView* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1013 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 1013 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4810 "ui.c"
	}
#line 1015 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->book_view;
#line 1015 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_view_get_selected_page (_tmp1_);
#line 1015 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1015 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = _page_ref0 (_tmp3_);
#line 1015 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp4_;
#line 1016 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page;
#line 1016 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp5_ != NULL) {
#line 4826 "ui.c"
		Page* _tmp6_ = NULL;
#line 1017 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = page;
#line 1017 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_rotate_right (_tmp6_);
#line 4832 "ui.c"
	}
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 4836 "ui.c"
}


static void _user_interface_rotate_right_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_rotate_right_button_clicked_cb ((UserInterface*) self, _sender);
#line 4843 "ui.c"
}


static void user_interface_set_crop (UserInterface* self, const gchar* crop_name) {
	GtkMenuItem* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Page* page = NULL;
	BookView* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	Page* _tmp6_ = NULL;
	Page* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 1020 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1022 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->crop_rotate_menuitem;
#line 1022 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = crop_name;
#line 1022 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_ != NULL);
#line 1024 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->updating_page_menu;
#line 1024 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 1025 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4872 "ui.c"
	}
#line 1027 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->book_view;
#line 1027 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = book_view_get_selected_page (_tmp3_);
#line 1027 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 1027 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = _page_ref0 (_tmp5_);
#line 1027 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp6_;
#line 1028 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = page;
#line 1028 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp7_ == NULL) {
#line 1030 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_warning ("ui.vala:1030: Trying to set crop but no selected page");
#line 1031 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_page_unref0 (page);
#line 1031 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4894 "ui.c"
	}
#line 1034 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = crop_name;
#line 1034 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp8_ == NULL) {
#line 4900 "ui.c"
		Page* _tmp9_ = NULL;
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = page;
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_set_no_crop (_tmp9_);
#line 4906 "ui.c"
	} else {
		const gchar* _tmp10_ = NULL;
#line 1036 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = crop_name;
#line 1036 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (g_strcmp0 (_tmp10_, "custom") == 0) {
#line 4913 "ui.c"
			gint width = 0;
			Page* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint height = 0;
			Page* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint crop_width = 0;
			gint _tmp17_ = 0;
			gint crop_height = 0;
			gint _tmp18_ = 0;
			Page* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			Page* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
#line 1038 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp11_ = page;
#line 1038 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp12_ = page_get_width (_tmp11_);
#line 1038 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp13_ = _tmp12_;
#line 1038 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			width = _tmp13_;
#line 1039 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp14_ = page;
#line 1039 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp15_ = page_get_height (_tmp14_);
#line 1039 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp16_ = _tmp15_;
#line 1039 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			height = _tmp16_;
#line 1040 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp17_ = width;
#line 1040 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			crop_width = (gint) ((_tmp17_ * 0.8) + 0.5);
#line 1041 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp18_ = height;
#line 1041 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			crop_height = (gint) ((_tmp18_ * 0.8) + 0.5);
#line 1042 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp19_ = page;
#line 1042 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp20_ = crop_width;
#line 1042 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp21_ = crop_height;
#line 1042 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			page_set_custom_crop (_tmp19_, _tmp20_, _tmp21_);
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp22_ = page;
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp23_ = width;
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp24_ = crop_width;
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp25_ = height;
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp26_ = crop_height;
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			page_move_crop (_tmp22_, (_tmp23_ - _tmp24_) / 2, (_tmp25_ - _tmp26_) / 2);
#line 4978 "ui.c"
		} else {
			Page* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp27_ = page;
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp28_ = crop_name;
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			page_set_named_crop (_tmp27_, _tmp28_);
#line 4988 "ui.c"
		}
	}
#line 1020 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 4993 "ui.c"
}


static void user_interface_no_crop_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1052 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1052 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1052 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1052 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 1053 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, NULL);
#line 5015 "ui.c"
	}
}


static void _user_interface_no_crop_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_no_crop_menuitem_toggled_cb ((UserInterface*) self, _sender);
#line 5023 "ui.c"
}


static void user_interface_custom_crop_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 1057 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1057 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 1060 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "custom");
#line 5045 "ui.c"
	}
}


static void _user_interface_custom_crop_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_custom_crop_menuitem_toggled_cb ((UserInterface*) self, _sender);
#line 5053 "ui.c"
}


static void user_interface_crop_button_toggled_cb (UserInterface* self, GtkToggleButton* widget) {
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 1064 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1064 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 1067 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 5072 "ui.c"
	}
#line 1069 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = widget;
#line 1069 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
#line 1069 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1069 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp3_) {
#line 5082 "ui.c"
		GtkRadioMenuItem* _tmp4_ = NULL;
#line 1070 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->custom_crop_menuitem;
#line 1070 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp4_, TRUE);
#line 5088 "ui.c"
	} else {
		GtkRadioMenuItem* _tmp5_ = NULL;
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = self->priv->no_crop_menuitem;
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp5_, TRUE);
#line 5095 "ui.c"
	}
}


static void _user_interface_crop_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_crop_button_toggled_cb ((UserInterface*) self, _sender);
#line 5103 "ui.c"
}


static void user_interface_crop_toolbutton_toggled_cb (UserInterface* self, GtkToggleToolButton* widget) {
	gboolean _tmp0_ = FALSE;
	GtkToggleToolButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1078 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 1078 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 1079 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 5122 "ui.c"
	}
#line 1081 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = widget;
#line 1081 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_toggle_tool_button_get_active (_tmp1_);
#line 1081 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1081 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp3_) {
#line 5132 "ui.c"
		GtkRadioMenuItem* _tmp4_ = NULL;
#line 1082 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->custom_crop_menuitem;
#line 1082 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp4_, TRUE);
#line 5138 "ui.c"
	} else {
		GtkRadioMenuItem* _tmp5_ = NULL;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = self->priv->no_crop_menuitem;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp5_, TRUE);
#line 5145 "ui.c"
	}
}


static void _user_interface_crop_toolbutton_toggled_cb_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_crop_toolbutton_toggled_cb ((UserInterface*) self, _sender);
#line 5153 "ui.c"
}


static void user_interface_four_by_six_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 1088 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1088 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1090 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1090 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1090 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1090 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 1091 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "4x6");
#line 5175 "ui.c"
	}
}


static void _user_interface_four_by_six_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_four_by_six_menuitem_toggled_cb ((UserInterface*) self, _sender);
#line 5183 "ui.c"
}


static void user_interface_legal_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 1098 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "legal");
#line 5205 "ui.c"
	}
}


static void _user_interface_legal_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_legal_menuitem_toggled_cb ((UserInterface*) self, _sender);
#line 5213 "ui.c"
}


static void user_interface_letter_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 1102 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1102 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1104 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1104 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1104 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1104 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 1105 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "letter");
#line 5235 "ui.c"
	}
}


static void _user_interface_letter_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_letter_menuitem_toggled_cb ((UserInterface*) self, _sender);
#line 5243 "ui.c"
}


static void user_interface_a6_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 1109 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1109 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "A6");
#line 5265 "ui.c"
	}
}


static void _user_interface_a6_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_a6_menuitem_toggled_cb ((UserInterface*) self, _sender);
#line 5273 "ui.c"
}


static void user_interface_a5_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 1116 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1116 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 1119 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "A5");
#line 5295 "ui.c"
	}
}


static void _user_interface_a5_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_a5_menuitem_toggled_cb ((UserInterface*) self, _sender);
#line 5303 "ui.c"
}


static void user_interface_a4_menuitem_toggled_cb (UserInterface* self, GtkCheckMenuItem* widget) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 1123 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1123 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 1126 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "A4");
#line 5325 "ui.c"
	}
}


static void _user_interface_a4_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_a4_menuitem_toggled_cb ((UserInterface*) self, _sender);
#line 5333 "ui.c"
}


static void user_interface_crop_rotate_menuitem_activate_cb (UserInterface* self, GtkWidget* widget) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 1130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp3_;
#line 1133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page;
#line 1133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_ == NULL) {
#line 1134 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_page_unref0 (page);
#line 1134 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 5367 "ui.c"
	}
#line 1135 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page;
#line 1135 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page_rotate_crop (_tmp5_);
#line 1130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 5375 "ui.c"
}


static void _user_interface_crop_rotate_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_crop_rotate_menuitem_activate_cb ((UserInterface*) self, _sender);
#line 5382 "ui.c"
}


static void user_interface_page_move_left_menuitem_activate_cb (UserInterface* self, GtkWidget* widget) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	guint index = 0U;
	Book* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
#line 1139 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1139 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 1141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 1141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp3_;
#line 1142 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->_book;
#line 1142 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page;
#line 1142 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = book_get_page_index (_tmp4_, _tmp5_);
#line 1142 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	index = _tmp6_;
#line 1143 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = index;
#line 1143 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp7_ > ((guint) 0)) {
#line 5423 "ui.c"
		Book* _tmp8_ = NULL;
		Page* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = self->priv->_book;
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = page;
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = index;
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		book_move_page (_tmp8_, _tmp9_, _tmp10_ - 1);
#line 5435 "ui.c"
	}
#line 1139 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 5439 "ui.c"
}


static void _user_interface_page_move_left_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_move_left_menuitem_activate_cb ((UserInterface*) self, _sender);
#line 5446 "ui.c"
}


static void user_interface_page_move_right_menuitem_activate_cb (UserInterface* self, GtkWidget* widget) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	guint index = 0U;
	Book* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	Book* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
#line 1148 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1148 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 1150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 1150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp3_;
#line 1151 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->_book;
#line 1151 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page;
#line 1151 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = book_get_page_index (_tmp4_, _tmp5_);
#line 1151 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	index = _tmp6_;
#line 1152 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = index;
#line 1152 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = self->priv->_book;
#line 1152 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = book_get_n_pages (_tmp8_);
#line 1152 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = _tmp9_;
#line 1152 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp7_ < (_tmp10_ - 1)) {
#line 5496 "ui.c"
		Book* _tmp11_ = NULL;
		Page* _tmp12_ = NULL;
		Book* _tmp13_ = NULL;
		Page* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
#line 1153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = self->priv->_book;
#line 1153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp12_ = page;
#line 1153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp13_ = self->priv->_book;
#line 1153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp14_ = page;
#line 1153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = book_get_page_index (_tmp13_, _tmp14_);
#line 1153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		book_move_page (_tmp11_, _tmp12_, _tmp15_ + 1);
#line 5514 "ui.c"
	}
#line 1148 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 5518 "ui.c"
}


static void _user_interface_page_move_right_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_move_right_menuitem_activate_cb ((UserInterface*) self, _sender);
#line 5525 "ui.c"
}


static void user_interface_page_delete_menuitem_activate_cb (UserInterface* self, GtkWidget* widget) {
	BookView* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	Book* _tmp2_ = NULL;
	BookView* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 1157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_book (_tmp0_);
#line 1159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->book_view;
#line 1159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = book_view_get_selected_page (_tmp3_);
#line 1159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 1159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_delete_page (_tmp2_, _tmp5_);
#line 5554 "ui.c"
}


static void _user_interface_page_delete_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_delete_menuitem_activate_cb ((UserInterface*) self, _sender);
#line 5561 "ui.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return _data1_;
#line 5570 "ui.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 5579 "ui.c"
		UserInterface* self;
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self = _data1_->self;
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (_data1_->dialog);
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (self);
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_slice_free (Block1Data, _data1_);
#line 5589 "ui.c"
	}
}


static gboolean __lambda4_ (Block1Data* _data1_, GdkEventKey* e) {
	UserInterface* self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_ = NULL;
	GdkModifierType _tmp2_ = 0;
#line 1171 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = _data1_->self;
#line 1171 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (e != NULL, FALSE);
#line 1173 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = e;
#line 1173 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_->state;
#line 1173 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_ == 0) {
#line 5610 "ui.c"
		GdkEventKey* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
#line 1173 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = e;
#line 1173 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = _tmp3_->keyval;
#line 1173 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = _tmp4_ == ((guint) GDK_KEY_Escape);
#line 5619 "ui.c"
	} else {
#line 1173 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = FALSE;
#line 5623 "ui.c"
	}
#line 1173 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 1175 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_destroy ((GtkWidget*) _data1_->dialog);
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = TRUE;
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 5633 "ui.c"
	}
#line 1179 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 1179 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 5639 "ui.c"
}


static gboolean ___lambda4__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = __lambda4_ (self, event);
#line 1171 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 5648 "ui.c"
}


static void __lambda5_ (Block1Data* _data1_) {
	UserInterface* self;
	Book* _tmp0_ = NULL;
#line 1193 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = _data1_->self;
#line 1195 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 1195 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_combine_sides (_tmp0_);
#line 1196 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _data1_->dialog);
#line 5663 "ui.c"
}


static void ___lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 1193 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda5_ (self);
#line 5670 "ui.c"
}


static void __lambda6_ (Block1Data* _data1_) {
	UserInterface* self;
	Book* _tmp0_ = NULL;
#line 1203 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = _data1_->self;
#line 1205 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 1205 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_combine_sides_reverse (_tmp0_);
#line 1206 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _data1_->dialog);
#line 5685 "ui.c"
}


static void ___lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 1203 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda6_ (self);
#line 5692 "ui.c"
}


static void __lambda7_ (Block1Data* _data1_) {
	UserInterface* self;
	Book* _tmp0_ = NULL;
#line 1213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = _data1_->self;
#line 1215 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 1215 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_reverse (_tmp0_);
#line 1216 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _data1_->dialog);
#line 5707 "ui.c"
}


static void ___lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 1213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda7_ (self);
#line 5714 "ui.c"
}


static void __lambda8_ (Block1Data* _data1_) {
	UserInterface* self;
#line 1223 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = _data1_->self;
#line 1225 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _data1_->dialog);
#line 5724 "ui.c"
}


static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 1223 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda8_ (self);
#line 5731 "ui.c"
}


static void user_interface_reorder_document (UserInterface* self) {
	Block1Data* _data1_;
	GtkWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkGrid* g = NULL;
	GtkGrid* _tmp2_ = NULL;
	GtkButton* b = NULL;
	const gchar* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	GtkButton* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	GtkButton* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkButton* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GtkButton* _tmp19_ = NULL;
	GtkButton* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkButton* _tmp22_ = NULL;
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_data1_->_ref_count_ = 1;
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_data1_->self = g_object_ref (self);
#line 1164 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
#line 1164 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp0_);
#line 1164 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_data1_->dialog = _tmp0_;
#line 1165 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_type_hint (_data1_->dialog, GDK_WINDOW_TYPE_HINT_DIALOG);
#line 1166 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_modal (_data1_->dialog, TRUE);
#line 1167 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_set_border_width ((GtkContainer*) _data1_->dialog, (guint) 12);
#line 1169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _ ("Reorder Pages");
#line 1169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_title (_data1_->dialog, _tmp1_);
#line 1170 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_transient_for (_data1_->dialog, (GtkWindow*) self);
#line 1171 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_data ((GtkWidget*) _data1_->dialog, "key-press-event", (GCallback) ___lambda4__gtk_widget_key_press_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 1181 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _data1_->dialog, TRUE);
#line 1183 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
#line 1183 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp2_);
#line 1183 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g = _tmp2_;
#line 1184 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_grid_set_row_homogeneous (g, TRUE);
#line 1185 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_grid_set_row_spacing (g, 6);
#line 1186 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_grid_set_column_homogeneous (g, TRUE);
#line 1187 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_grid_set_column_spacing (g, 6);
#line 1188 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) g, TRUE);
#line 1189 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_add ((GtkContainer*) _data1_->dialog, (GtkWidget*) g);
#line 1192 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _ ("Combine sides");
#line 1192 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = user_interface_make_reorder_button (self, _tmp3_, "F1F2F3B1B2B3-F1B1F2B2F3B3");
#line 1192 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	b = _tmp4_;
#line 1193 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = b;
#line 1193 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_data (_tmp5_, "clicked", (GCallback) ___lambda5__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 1198 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = b;
#line 1198 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
#line 1199 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = b;
#line 1199 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_grid_attach (g, (GtkWidget*) _tmp7_, 0, 0, 1, 1);
#line 1202 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = _ ("Combine sides (reverse)");
#line 1202 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = user_interface_make_reorder_button (self, _tmp8_, "F1F2F3B3B2B1-F1B1F2B2F3B3");
#line 1202 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (b);
#line 1202 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	b = _tmp9_;
#line 1203 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = b;
#line 1203 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_data (_tmp10_, "clicked", (GCallback) ___lambda6__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 1208 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = b;
#line 1208 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp11_, TRUE);
#line 1209 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = b;
#line 1209 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_grid_attach (g, (GtkWidget*) _tmp12_, 1, 0, 1, 1);
#line 1212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = _ ("Reverse");
#line 1212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = user_interface_make_reorder_button (self, _tmp13_, "C1C2C3C4C5C6-C6C5C4C3C2C1");
#line 1212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (b);
#line 1212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	b = _tmp14_;
#line 1213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = b;
#line 1213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_data (_tmp15_, "clicked", (GCallback) ___lambda7__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 1218 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = b;
#line 1218 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp16_, TRUE);
#line 1219 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = b;
#line 1219 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_grid_attach (g, (GtkWidget*) _tmp17_, 0, 2, 1, 1);
#line 1222 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = _ ("Keep unchanged");
#line 1222 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = user_interface_make_reorder_button (self, _tmp18_, "C1C2C3C4C5C6-C1C2C3C4C5C6");
#line 1222 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (b);
#line 1222 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	b = _tmp19_;
#line 1223 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = b;
#line 1223 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_data (_tmp20_, "clicked", (GCallback) ___lambda8__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 1227 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = b;
#line 1227 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp21_, TRUE);
#line 1228 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = b;
#line 1228 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_grid_attach (g, (GtkWidget*) _tmp22_, 1, 2, 1, 1);
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_present (_data1_->dialog);
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (b);
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (g);
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	block1_data_unref (_data1_);
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_data1_ = NULL;
#line 5898 "ui.c"
}


void user_interface_reorder_document_activate_cb (UserInterface* self) {
#line 1233 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_reorder_document (self);
#line 5907 "ui.c"
}


static void user_interface_reorder_menuitem_activate_cb (UserInterface* self, GtkWidget* widget) {
#line 1239 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1239 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1241 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_reorder_document (self);
#line 5918 "ui.c"
}


static void _user_interface_reorder_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_reorder_menuitem_activate_cb ((UserInterface*) self, _sender);
#line 5925 "ui.c"
}


static GtkButton* user_interface_make_reorder_button (UserInterface* self, const gchar* text, const gchar* items) {
	GtkButton* result = NULL;
	GtkButton* b = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp1_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkBox* rb = NULL;
	const gchar* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
#line 1244 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1244 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 1244 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (items != NULL, NULL);
#line 1246 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = (GtkButton*) gtk_button_new ();
#line 1246 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp0_);
#line 1246 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	b = _tmp0_;
#line 1248 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
#line 1248 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp1_);
#line 1248 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	vbox = _tmp1_;
#line 1249 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) vbox, TRUE);
#line 1250 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_add ((GtkContainer*) b, (GtkWidget*) vbox);
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = text;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp3_);
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	label = _tmp3_;
#line 1253 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) label, TRUE);
#line 1254 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (vbox, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = items;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = user_interface_make_reorder_box (self, _tmp4_);
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	rb = _tmp5_;
#line 1257 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) rb, TRUE);
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (vbox, (GtkWidget*) rb, TRUE, TRUE, (guint) 0);
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = b;
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (rb);
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (label);
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (vbox);
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 5995 "ui.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 6013 "ui.c"
}


static GtkBox* user_interface_make_reorder_box (UserInterface* self, const gchar* items) {
	GtkBox* result = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp0_ = NULL;
	GtkBox* _tmp1_ = NULL;
	GtkBox* page_box = NULL;
#line 1263 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1263 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (items != NULL, NULL);
#line 1265 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
#line 1265 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp0_);
#line 1265 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	box = _tmp0_;
#line 1266 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = box;
#line 1266 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
#line 1268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page_box = NULL;
#line 6039 "ui.c"
	{
		gint i = 0;
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		i = 0;
#line 6044 "ui.c"
		{
			gboolean _tmp2_ = FALSE;
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp2_ = TRUE;
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			while (TRUE) {
#line 6051 "ui.c"
				const gchar* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gchar _tmp6_ = '\0';
				const gchar* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gchar _tmp9_ = '\0';
				gchar side = '\0';
				const gchar* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gchar _tmp16_ = '\0';
				gint _tmp17_ = 0;
				const gchar* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gchar _tmp20_ = '\0';
				GtkBox* _tmp21_ = NULL;
				gdouble r = 0.0;
				gdouble g = 0.0;
				gdouble b = 0.0;
				gchar _tmp26_ = '\0';
				gdouble _tmp33_ = 0.0;
				gdouble _tmp34_ = 0.0;
				gdouble _tmp35_ = 0.0;
				gdouble _tmp36_ = 0.0;
				gdouble _tmp37_ = 0.0;
				gdouble _tmp38_ = 0.0;
				PageIcon* icon = NULL;
				const gchar* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				gchar _tmp41_ = '\0';
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gdouble _tmp44_ = 0.0;
				gdouble _tmp45_ = 0.0;
				gdouble _tmp46_ = 0.0;
				PageIcon* _tmp47_ = NULL;
				PageIcon* _tmp48_ = NULL;
				PageIcon* _tmp49_ = NULL;
				GtkBox* _tmp50_ = NULL;
				PageIcon* _tmp51_ = NULL;
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (!_tmp2_) {
#line 6093 "ui.c"
					gint _tmp3_ = 0;
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp3_ = i;
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					i = _tmp3_ + 1;
#line 6099 "ui.c"
				}
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp2_ = FALSE;
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp4_ = items;
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp5_ = i;
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp6_ = string_get (_tmp4_, (glong) _tmp5_);
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (!(_tmp6_ != '\0')) {
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					break;
#line 6113 "ui.c"
				}
#line 1271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp7_ = items;
#line 1271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp8_ = i;
#line 1271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp9_ = string_get (_tmp7_, (glong) _tmp8_);
#line 1271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp9_ == '-') {
#line 6123 "ui.c"
					GtkArrow* a = NULL;
					GtkArrow* _tmp10_ = NULL;
					GtkArrow* _tmp11_ = NULL;
					GtkBox* _tmp12_ = NULL;
					GtkArrow* _tmp13_ = NULL;
#line 1273 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp10_ = (GtkArrow*) gtk_arrow_new (GTK_ARROW_RIGHT, GTK_SHADOW_NONE);
#line 1273 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					g_object_ref_sink (_tmp10_);
#line 1273 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					a = _tmp10_;
#line 1274 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp11_ = a;
#line 1274 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_widget_set_visible ((GtkWidget*) _tmp11_, TRUE);
#line 1275 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp12_ = box;
#line 1275 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp13_ = a;
#line 1275 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_box_pack_start (_tmp12_, (GtkWidget*) _tmp13_, FALSE, FALSE, (guint) 0);
#line 1276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_g_object_unref0 (page_box);
#line 1276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					page_box = NULL;
#line 1277 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_g_object_unref0 (a);
#line 1277 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					continue;
#line 6153 "ui.c"
				}
#line 1281 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp14_ = items;
#line 1281 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp15_ = i;
#line 1281 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp16_ = string_get (_tmp14_, (glong) _tmp15_);
#line 1281 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				side = _tmp16_;
#line 1282 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp17_ = i;
#line 1282 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				i = _tmp17_ + 1;
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp18_ = items;
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp19_ = i;
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp20_ = string_get (_tmp18_, (glong) _tmp19_);
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp20_ == '\0') {
#line 1284 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					break;
#line 6177 "ui.c"
				}
#line 1286 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp21_ = page_box;
#line 1286 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp21_ == NULL) {
#line 6183 "ui.c"
					GtkBox* _tmp22_ = NULL;
					GtkBox* _tmp23_ = NULL;
					GtkBox* _tmp24_ = NULL;
					GtkBox* _tmp25_ = NULL;
#line 1288 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp22_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
#line 1288 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					g_object_ref_sink (_tmp22_);
#line 1288 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_g_object_unref0 (page_box);
#line 1288 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					page_box = _tmp22_;
#line 1289 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp23_ = page_box;
#line 1289 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_widget_set_visible ((GtkWidget*) _tmp23_, TRUE);
#line 1290 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp24_ = box;
#line 1290 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp25_ = page_box;
#line 1290 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_box_pack_start (_tmp24_, (GtkWidget*) _tmp25_, FALSE, FALSE, (guint) 0);
#line 6206 "ui.c"
				}
#line 1294 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				r = 1.0;
#line 1295 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				g = 1.0;
#line 1296 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				b = 1.0;
#line 1297 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp26_ = side;
#line 1297 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				switch (_tmp26_) {
#line 1297 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					case 'F':
#line 6220 "ui.c"
					{
#line 1301 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						r = 0x75 / 255.0;
#line 1302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						g = 0x50 / 255.0;
#line 1303 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						b = 0x7B / 255.0;
#line 1304 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						break;
#line 6230 "ui.c"
					}
#line 1297 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					case 'B':
#line 6234 "ui.c"
					{
#line 1307 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						r = 0xF5 / 255.0;
#line 1308 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						g = 0x79 / 255.0;
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						b = 0.0;
#line 1310 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						break;
#line 6244 "ui.c"
					}
#line 1297 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					case 'C':
#line 6248 "ui.c"
					{
						gdouble p = 0.0;
						const gchar* _tmp27_ = NULL;
						gint _tmp28_ = 0;
						gchar _tmp29_ = '\0';
						gdouble _tmp30_ = 0.0;
						gdouble _tmp31_ = 0.0;
						gdouble _tmp32_ = 0.0;
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp27_ = items;
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp28_ = i;
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp29_ = string_get (_tmp27_, (glong) _tmp28_);
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						p = (_tmp29_ - '1') / 5.0;
#line 1314 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp30_ = p;
#line 1314 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp31_ = p;
#line 1314 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						r = ((0xED / 255.0) * (1 - _tmp30_)) + (0xCC * _tmp31_);
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp32_ = p;
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						g = (0xD4 / 255.0) * (1 - _tmp32_);
#line 1316 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						b = (gdouble) 0;
#line 1317 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						break;
#line 6279 "ui.c"
					}
					default:
#line 1297 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					break;
#line 6284 "ui.c"
				}
#line 1321 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp33_ = r;
#line 1321 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp34_ = r;
#line 1321 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				r = _tmp33_ + ((1.0 - _tmp34_) * 0.7);
#line 1322 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp35_ = g;
#line 1322 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp36_ = g;
#line 1322 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				g = _tmp35_ + ((1.0 - _tmp36_) * 0.7);
#line 1323 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp37_ = b;
#line 1323 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp38_ = b;
#line 1323 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				b = _tmp37_ + ((1.0 - _tmp38_) * 0.7);
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp39_ = items;
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp40_ = i;
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp41_ = string_get (_tmp39_, (glong) _tmp40_);
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp42_ = g_strdup_printf ("%c", (gint) _tmp41_);
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp43_ = _tmp42_;
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp44_ = r;
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp45_ = g;
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp46_ = b;
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp47_ = page_icon_new (_tmp43_, _tmp44_, _tmp45_, _tmp46_);
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				g_object_ref_sink (_tmp47_);
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp48_ = _tmp47_;
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (_tmp43_);
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				icon = _tmp48_;
#line 1326 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp49_ = icon;
#line 1326 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_widget_set_visible ((GtkWidget*) _tmp49_, TRUE);
#line 1327 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp50_ = page_box;
#line 1327 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp51_ = icon;
#line 1327 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_box_pack_start (_tmp50_, (GtkWidget*) _tmp51_, FALSE, FALSE, (guint) 0);
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_object_unref0 (icon);
#line 6342 "ui.c"
			}
		}
	}
#line 1330 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = box;
#line 1330 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (page_box);
#line 1330 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 6352 "ui.c"
}


static void user_interface_save_file_button_clicked_cb (UserInterface* self, GtkWidget* widget) {
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_document (self, FALSE);
#line 6363 "ui.c"
}


static void _user_interface_save_file_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_file_button_clicked_cb ((UserInterface*) self, _sender);
#line 6370 "ui.c"
}


void user_interface_save_document_activate_cb (UserInterface* self) {
#line 1339 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1341 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_document (self, FALSE);
#line 6379 "ui.c"
}


static void user_interface_copy_to_clipboard_button_clicked_cb (UserInterface* self, GtkWidget* widget) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 1347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 1347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp3_;
#line 1348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page;
#line 1348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_ != NULL) {
#line 6408 "ui.c"
		Page* _tmp5_ = NULL;
#line 1349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = page;
#line 1349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_copy_to_clipboard (_tmp5_, (GtkWindow*) self);
#line 6414 "ui.c"
	}
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 6418 "ui.c"
}


static void _user_interface_copy_to_clipboard_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_copy_to_clipboard_button_clicked_cb ((UserInterface*) self, _sender);
#line 6425 "ui.c"
}


static void user_interface_save_as_file_button_clicked_cb (UserInterface* self, GtkWidget* widget) {
#line 1353 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1353 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1355 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_document (self, TRUE);
#line 6436 "ui.c"
}


static void _user_interface_save_as_file_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_as_file_button_clicked_cb ((UserInterface*) self, _sender);
#line 6443 "ui.c"
}


void user_interface_save_as_document_activate_cb (UserInterface* self) {
#line 1358 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1360 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_document (self, TRUE);
#line 6452 "ui.c"
}


static gpointer _cairo_reference0 (gpointer self) {
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self ? cairo_reference (self) : NULL;
#line 6459 "ui.c"
}


static void user_interface_draw_page (UserInterface* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number) {
	cairo_t* context = NULL;
	GtkPrintContext* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	Page* page = NULL;
	Book* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Page* _tmp5_ = NULL;
	gboolean is_landscape = FALSE;
	GtkPrintContext* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	GtkPrintContext* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	Page* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	cairo_t* _tmp18_ = NULL;
	GtkPrintContext* _tmp19_ = NULL;
	gdouble _tmp20_ = 0.0;
	Page* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	GtkPrintContext* _tmp24_ = NULL;
	gdouble _tmp25_ = 0.0;
	Page* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GdkPixbuf* image = NULL;
	Page* _tmp29_ = NULL;
	GdkPixbuf* _tmp30_ = NULL;
	cairo_t* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (operation != NULL);
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (print_context != NULL);
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = print_context;
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _cairo_reference0 (_tmp1_);
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	context = _tmp2_;
#line 1368 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->_book;
#line 1368 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page_number;
#line 1368 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = book_get_page (_tmp3_, _tmp4_);
#line 1368 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp5_;
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	is_landscape = FALSE;
#line 1372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = print_context;
#line 1372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = gtk_print_context_get_width (_tmp6_);
#line 1372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = print_context;
#line 1372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = gtk_print_context_get_height (_tmp8_);
#line 1372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp7_ > _tmp9_) {
#line 1373 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		is_landscape = TRUE;
#line 6533 "ui.c"
	}
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = page;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = page_get_is_landscape (_tmp10_);
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = _tmp11_;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = is_landscape;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp12_ != _tmp13_) {
#line 6545 "ui.c"
		cairo_t* _tmp14_ = NULL;
		GtkPrintContext* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		cairo_t* _tmp17_ = NULL;
#line 1376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp14_ = context;
#line 1376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = print_context;
#line 1376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp16_ = gtk_print_context_get_width (_tmp15_);
#line 1376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		cairo_translate (_tmp14_, _tmp16_, (gdouble) 0);
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp17_ = context;
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		cairo_rotate (_tmp17_, G_PI_2);
#line 6562 "ui.c"
	}
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = context;
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = print_context;
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = gtk_print_context_get_dpi_x (_tmp19_);
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = page;
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = page_get_dpi (_tmp21_);
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = _tmp22_;
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = print_context;
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = gtk_print_context_get_dpi_y (_tmp24_);
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = page;
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = page_get_dpi (_tmp26_);
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp28_ = _tmp27_;
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_scale (_tmp18_, _tmp20_ / _tmp23_, _tmp25_ / _tmp28_);
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp29_ = page;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp30_ = page_get_image (_tmp29_, TRUE);
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	image = _tmp30_;
#line 1384 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp31_ = context;
#line 1384 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gdk_cairo_set_source_pixbuf (_tmp31_, image, (gdouble) 0, (gdouble) 0);
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp32_ = context;
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_paint (_tmp32_);
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (image);
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_cairo_destroy0 (context);
#line 6608 "ui.c"
}


static void user_interface_email_button_clicked_cb (UserInterface* self, GtkWidget* widget) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->document_hint;
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_quality (self);
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1391 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_emit_by_name (self, "email", _tmp0_, _tmp2_);
#line 6628 "ui.c"
}


static void _user_interface_email_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_email_button_clicked_cb ((UserInterface*) self, _sender);
#line 6635 "ui.c"
}


void user_interface_email_document_activate_cb (UserInterface* self) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->document_hint;
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_quality (self);
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_emit_by_name (self, "email", _tmp0_, _tmp2_);
#line 6653 "ui.c"
}


static void _user_interface_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
#line 1403 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_draw_page ((UserInterface*) self, _sender, context, page_nr);
#line 6660 "ui.c"
}


static void user_interface_print_document (UserInterface* self) {
	GtkPrintOperation* print = NULL;
	GtkPrintOperation* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp6_ = 0U;
	GError * _inner_error_ = NULL;
#line 1399 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1401 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = gtk_print_operation_new ();
#line 1401 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	print = _tmp0_;
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->_book;
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_set (print, "n-pages", (gint) _tmp3_, NULL);
#line 1403 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (print, "draw-page", (GCallback) _user_interface_draw_page_gtk_print_operation_draw_page, self, 0);
#line 6688 "ui.c"
	{
#line 1407 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_print_operation_run (print, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, (GtkWindow*) self, &_inner_error_);
#line 1407 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 6694 "ui.c"
			goto __catch19_g_error;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 1405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 1405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1411 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = e;
#line 1411 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _tmp4_->message;
#line 1411 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_warning ("ui.vala:1411: Error printing: %s", _tmp5_);
#line 1405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 6716 "ui.c"
	}
	__finally19:
#line 1405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (print);
#line 1405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 6729 "ui.c"
	}
#line 1414 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("draw-page", GTK_TYPE_PRINT_OPERATION, &_tmp6_, NULL, FALSE);
#line 1414 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (print, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _user_interface_draw_page_gtk_print_operation_draw_page, self);
#line 1399 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (print);
#line 6737 "ui.c"
}


static void user_interface_print_button_clicked_cb (UserInterface* self, GtkWidget* widget) {
#line 1418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1420 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_print_document (self);
#line 6748 "ui.c"
}


static void _user_interface_print_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_print_button_clicked_cb ((UserInterface*) self, _sender);
#line 6755 "ui.c"
}


void user_interface_print_document_activate_cb (UserInterface* self) {
#line 1423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_print_document (self);
#line 6764 "ui.c"
}


static void user_interface_launch_help (UserInterface* self) {
	GError * _inner_error_ = NULL;
#line 1428 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 6772 "ui.c"
	{
		GdkScreen* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 1432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
#line 1432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = _tmp0_;
#line 1432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 1432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_show_uri (_tmp1_, "help:simple-scan", _tmp2_, &_inner_error_);
#line 1432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 6787 "ui.c"
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1436 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = _ ("Unable to open help file");
#line 1436 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = e;
#line 1436 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _tmp4_->message;
#line 1436 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp3_, _tmp5_);
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 6812 "ui.c"
	}
	__finally20:
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 6823 "ui.c"
	}
}


static void user_interface_help_contents_menuitem_activate_cb (UserInterface* self, GtkWidget* widget) {
#line 1443 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1443 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1445 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_launch_help (self);
#line 6835 "ui.c"
}


static void _user_interface_help_contents_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_help_contents_menuitem_activate_cb ((UserInterface*) self, _sender);
#line 6842 "ui.c"
}


void user_interface_help_contents_activate_cb (UserInterface* self) {
#line 1448 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1450 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_launch_help (self);
#line 6851 "ui.c"
}


static void user_interface_show_about (UserInterface* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar* license = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* title = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* description = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1455 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = g_strdup ("Robert Ancell <robert.ancell@canonical.com>");
#line 1455 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 1455 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_[0] = _tmp0_;
#line 1455 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	authors = _tmp1_;
#line 1455 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	authors_length1 = 1;
#line 1455 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_authors_size_ = authors_length1;
#line 1458 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _ ("This program is free software: you can redistribute it and/or modify\n" \
"it under the terms of the GNU General Public License as published by\n" \
"the Free Software Foundation, either version 3 of the License, or\n" \
"(at your option) any later version.\n" \
"\n" \
"This program is distributed in the hope that it will be useful,\n" \
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"GNU General Public License for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License\n" \
"along with this program.  If not, see <http://www.gnu.org/licenses/>.");
#line 1458 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1458 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	license = _tmp3_;
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = _ ("About Simple Scan");
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	title = _tmp5_;
#line 1464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = _ ("Simple document scanning tool");
#line 1464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 1464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	description = _tmp7_;
#line 1466 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = _ ("translator-credits");
#line 1466 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_show_about_dialog ((GtkWindow*) self, "title", title, "program-name", "Simple Scan", "version", VERSION, "comments", description, "logo-icon-name", "scanner", "authors", authors, "translator-credits", _tmp8_, "website", "https://launchpad.net/simple-scan", "copyright", "Copyright © 2009-2011 Canonical Ltd.", "license", license, "wrap-license", TRUE, NULL, NULL);
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (description);
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (title);
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (license);
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 6915 "ui.c"
}


static void user_interface_about_menuitem_activate_cb (UserInterface* self, GtkWidget* widget) {
#line 1482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1484 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_about (self);
#line 6926 "ui.c"
}


static void _user_interface_about_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_about_menuitem_activate_cb ((UserInterface*) self, _sender);
#line 6933 "ui.c"
}


void user_interface_about_activate_cb (UserInterface* self) {
#line 1487 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_about (self);
#line 6942 "ui.c"
}


static gboolean user_interface_on_quit (UserInterface* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	guint _tmp3_ = 0U;
	AutosaveManager* _tmp4_ = NULL;
#line 1492 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = _ ("Save document before quitting?");
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _ ("Quit without Saving");
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = user_interface_prompt_to_save (self, _tmp0_, _tmp1_);
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp2_) {
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = FALSE;
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 6967 "ui.c"
	}
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) self);
#line 1502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->save_state_timeout;
#line 1502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp3_ != ((guint) 0)) {
#line 1503 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_save_state (self, TRUE);
#line 6977 "ui.c"
	}
#line 1505 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->autosave_manager;
#line 1505 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	autosave_manager_cleanup (_tmp4_);
#line 1507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = TRUE;
#line 1507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 6987 "ui.c"
}


static void user_interface_quit_menuitem_activate_cb (UserInterface* self, GtkWidget* widget) {
#line 1511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1513 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_on_quit (self);
#line 6998 "ui.c"
}


static void _user_interface_quit_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_quit_menuitem_activate_cb ((UserInterface*) self, _sender);
#line 7005 "ui.c"
}


void user_interface_quit_activate_cb (UserInterface* self) {
#line 1516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1518 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_on_quit (self);
#line 7014 "ui.c"
}


static gboolean user_interface_simple_scan_window_configure_event_cb (UserInterface* self, GtkWidget* widget, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1522 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1522 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1522 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->window_is_maximized;
#line 1524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp0_) {
#line 7031 "ui.c"
		GdkEventConfigure* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 1526 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = event;
#line 1526 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = _tmp1_->width;
#line 1526 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_width = _tmp2_;
#line 1527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = event;
#line 1527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = _tmp3_->height;
#line 1527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_height = _tmp4_;
#line 1528 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_save_state (self, FALSE);
#line 7050 "ui.c"
	}
#line 1531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 1531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 7056 "ui.c"
}


static gboolean _user_interface_simple_scan_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = user_interface_simple_scan_window_configure_event_cb ((UserInterface*) self, _sender, event);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 7065 "ui.c"
}


static void user_interface_info_bar_response_cb (UserInterface* self, GtkInfoBar* widget, gint response_id) {
	gint _tmp0_ = 0;
#line 1534 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1534 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1536 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = response_id;
#line 1536 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_ == 1) {
#line 7079 "ui.c"
		GtkComboBox* _tmp1_ = NULL;
		GtkDialog* _tmp2_ = NULL;
#line 1538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = self->priv->device_combo;
#line 1538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
#line 1539 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = self->priv->preferences_dialog;
#line 1539 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_window_present ((GtkWindow*) _tmp2_);
#line 7090 "ui.c"
	} else {
#line 1543 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->have_error = FALSE;
#line 1544 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (self->priv->error_title);
#line 1544 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->error_title = NULL;
#line 1545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (self->priv->error_text);
#line 1545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->error_text = NULL;
#line 1546 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_update_info_bar (self);
#line 7104 "ui.c"
	}
}


static gboolean user_interface_simple_scan_window_window_state_event_cb (UserInterface* self, GtkWidget* widget, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
#line 1551 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1551 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1551 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = event;
#line 1553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 1553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 7125 "ui.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 1555 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = event;
#line 1555 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 1555 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_save_state (self, FALSE);
#line 7136 "ui.c"
	}
#line 1558 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 1558 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 7142 "ui.c"
}


static gboolean _user_interface_simple_scan_window_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = user_interface_simple_scan_window_window_state_event_cb ((UserInterface*) self, _sender, event);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 7151 "ui.c"
}


static gboolean user_interface_window_delete_event_cb (UserInterface* self, GtkWidget* widget, GdkEvent* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1562 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1562 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1562 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = user_interface_on_quit (self);
#line 1564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = !_tmp0_;
#line 1564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 7170 "ui.c"
}


static gboolean _user_interface_window_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = user_interface_window_delete_event_cb ((UserInterface*) self, _sender, event);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 7179 "ui.c"
}


static void user_interface_page_size_changed_cb (UserInterface* self, Page* page) {
	Page* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Page* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Page* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 1567 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1567 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1569 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 1569 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 1569 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1569 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_width = _tmp2_;
#line 1570 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = page;
#line 1570 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page_get_height (_tmp3_);
#line 1570 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 1570 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_height = _tmp5_;
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = page;
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = page_get_dpi (_tmp6_);
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = _tmp7_;
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_dpi = _tmp8_;
#line 1572 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_state (self, FALSE);
#line 7223 "ui.c"
}


static void user_interface_page_scan_direction_changed_cb (UserInterface* self, Page* page) {
	Page* _tmp0_ = NULL;
	ScanDirection _tmp1_ = 0;
	ScanDirection _tmp2_ = 0;
#line 1575 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1575 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1577 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 1577 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = page_get_scan_direction (_tmp0_);
#line 1577 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1577 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_scan_direction = _tmp2_;
#line 1578 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_state (self, FALSE);
#line 7245 "ui.c"
}


static void _user_interface_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self) {
#line 1585 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_size_changed_cb ((UserInterface*) self, _sender);
#line 7252 "ui.c"
}


static void _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self) {
#line 1586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_scan_direction_changed_cb ((UserInterface*) self, _sender);
#line 7259 "ui.c"
}


static void user_interface_page_added_cb (UserInterface* self, Book* book, Page* page) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	ScanDirection _tmp2_ = 0;
	ScanDirection _tmp3_ = 0;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 1581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1583 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 1583 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_size_changed_cb (self, _tmp0_);
#line 1584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = page;
#line 1584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = page_get_scan_direction (_tmp1_);
#line 1584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_scan_direction = _tmp3_;
#line 1585 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page;
#line 1585 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp4_, "size-changed", (GCallback) _user_interface_page_size_changed_cb_page_size_changed, self, 0);
#line 1586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page;
#line 1586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp5_, "scan-direction-changed", (GCallback) _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed, self, 0);
#line 1588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_page_menu (self);
#line 7298 "ui.c"
}


static void user_interface_reordered_cb (UserInterface* self, Book* book) {
#line 1591 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1591 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1593 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_page_menu (self);
#line 7309 "ui.c"
}


static void user_interface_page_removed_cb (UserInterface* self, Book* book, Page* page) {
	Page* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Book* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
#line 1596 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1596 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1596 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1598 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 1598 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 1598 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _user_interface_page_size_changed_cb_page_size_changed, self);
#line 1599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = page;
#line 1599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 1599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 1602 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = book;
#line 1602 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = book_get_n_pages (_tmp4_);
#line 1602 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = _tmp5_;
#line 1602 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp6_ == ((guint) 1)) {
#line 1603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_add_default_page (self);
#line 7349 "ui.c"
	}
#line 1605 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_page_menu (self);
#line 7353 "ui.c"
}


static void user_interface_set_dpi_combo (UserInterface* self, GtkComboBox* combo, gint default_dpi, gint current_dpi) {
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	GtkCellRendererText* _tmp2_ = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkCellRendererText* _tmp4_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkListStore* _tmp8_ = NULL;
	gint* scan_resolutions = NULL;
	gint* _tmp9_ = NULL;
	gint scan_resolutions_length1 = 0;
	gint _scan_resolutions_size_ = 0;
	gint* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
#line 1608 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1608 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (combo != NULL);
#line 1610 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1610 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp0_);
#line 1610 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	renderer = _tmp0_;
#line 1611 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = combo;
#line 1611 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = renderer;
#line 1611 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp1_, (GtkCellRenderer*) _tmp2_, TRUE);
#line 1612 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = combo;
#line 1612 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = renderer;
#line 1612 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) _tmp4_, "text", 1);
#line 1614 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = combo;
#line 1614 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
#line 1614 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = _tmp6_;
#line 1614 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_LIST_STORE) ? ((GtkListStore*) _tmp7_) : NULL);
#line 1614 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	model = _tmp8_;
#line 1615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = g_new0 (gint, 6);
#line 1615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_[0] = 75;
#line 1615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_[1] = 150;
#line 1615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_[2] = 300;
#line 1615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_[3] = 600;
#line 1615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_[4] = 1200;
#line 1615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_[5] = 2400;
#line 1615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	scan_resolutions = _tmp9_;
#line 1615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	scan_resolutions_length1 = 6;
#line 1615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_scan_resolutions_size_ = scan_resolutions_length1;
#line 1616 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = scan_resolutions;
#line 1616 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10__length1 = scan_resolutions_length1;
#line 7431 "ui.c"
	{
		gint* dpi_collection = NULL;
		gint dpi_collection_length1 = 0;
		gint _dpi_collection_size_ = 0;
		gint dpi_it = 0;
#line 1616 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dpi_collection = _tmp10_;
#line 1616 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dpi_collection_length1 = _tmp10__length1;
#line 1616 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		for (dpi_it = 0; dpi_it < _tmp10__length1; dpi_it = dpi_it + 1) {
#line 7443 "ui.c"
			gint dpi = 0;
#line 1616 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			dpi = dpi_collection[dpi_it];
#line 7447 "ui.c"
			{
				gchar* label = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp27_ = NULL;
				GtkTreeIter _tmp28_ = {0};
				GtkListStore* _tmp29_ = NULL;
				GtkTreeIter _tmp30_ = {0};
				gint _tmp31_ = 0;
				const gchar* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
#line 1619 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp11_ = dpi;
#line 1619 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp12_ = default_dpi;
#line 1619 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp11_ == _tmp12_) {
#line 7467 "ui.c"
					const gchar* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
#line 1621 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp13_ = _ ("%d dpi (default)");
#line 1621 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp14_ = dpi;
#line 1621 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
#line 1621 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_g_free0 (label);
#line 1621 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					label = _tmp15_;
#line 7481 "ui.c"
				} else {
					gint _tmp16_ = 0;
#line 1622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp16_ = dpi;
#line 1622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (_tmp16_ == 75) {
#line 7488 "ui.c"
						const gchar* _tmp17_ = NULL;
						gint _tmp18_ = 0;
						gchar* _tmp19_ = NULL;
#line 1624 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp17_ = _ ("%d dpi (draft)");
#line 1624 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp18_ = dpi;
#line 1624 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp19_ = g_strdup_printf (_tmp17_, _tmp18_);
#line 1624 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_g_free0 (label);
#line 1624 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						label = _tmp19_;
#line 7502 "ui.c"
					} else {
						gint _tmp20_ = 0;
#line 1625 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp20_ = dpi;
#line 1625 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						if (_tmp20_ == 1200) {
#line 7509 "ui.c"
							const gchar* _tmp21_ = NULL;
							gint _tmp22_ = 0;
							gchar* _tmp23_ = NULL;
#line 1627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp21_ = _ ("%d dpi (high resolution)");
#line 1627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp22_ = dpi;
#line 1627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp23_ = g_strdup_printf (_tmp21_, _tmp22_);
#line 1627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_g_free0 (label);
#line 1627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							label = _tmp23_;
#line 7523 "ui.c"
						} else {
							const gchar* _tmp24_ = NULL;
							gint _tmp25_ = 0;
							gchar* _tmp26_ = NULL;
#line 1630 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp24_ = _ ("%d dpi");
#line 1630 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp25_ = dpi;
#line 1630 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp26_ = g_strdup_printf (_tmp24_, _tmp25_);
#line 1630 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_g_free0 (label);
#line 1630 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							label = _tmp26_;
#line 7538 "ui.c"
						}
					}
				}
#line 1633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp27_ = model;
#line 1633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_list_store_append (_tmp27_, &_tmp28_);
#line 1633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				iter = _tmp28_;
#line 1634 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp29_ = model;
#line 1634 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp30_ = iter;
#line 1634 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp31_ = dpi;
#line 1634 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp32_ = label;
#line 1634 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_list_store_set (_tmp29_, &_tmp30_, 0, _tmp31_, 1, _tmp32_, -1, -1);
#line 1636 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp33_ = dpi;
#line 1636 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp34_ = current_dpi;
#line 1636 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp33_ == _tmp34_) {
#line 7564 "ui.c"
					GtkComboBox* _tmp35_ = NULL;
					GtkTreeIter _tmp36_ = {0};
#line 1637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp35_ = combo;
#line 1637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp36_ = iter;
#line 1637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_combo_box_set_active_iter (_tmp35_, &_tmp36_);
#line 7573 "ui.c"
				}
#line 1616 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (label);
#line 7577 "ui.c"
			}
		}
	}
#line 1608 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	scan_resolutions = (g_free (scan_resolutions), NULL);
#line 1608 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (model);
#line 1608 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (renderer);
#line 7587 "ui.c"
}


static void user_interface_needs_saving_cb (UserInterface* self, Book* book) {
	GtkMenuItem* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkButton* _tmp4_ = NULL;
	Book* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkToolButton* _tmp8_ = NULL;
	Book* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	Book* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	GtkMenuItem* _tmp16_ = NULL;
#line 1641 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1641 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->save_menuitem;
#line 1643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book;
#line 1643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_get_needs_saving (_tmp1_);
#line 1643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp3_);
#line 1644 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->save_button;
#line 1644 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = book;
#line 1644 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = book_get_needs_saving (_tmp5_);
#line 1644 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = _tmp6_;
#line 1644 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, _tmp7_);
#line 1645 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = self->priv->save_toolbutton;
#line 1645 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = book;
#line 1645 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = book_get_needs_saving (_tmp9_);
#line 1645 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = _tmp10_;
#line 1645 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, _tmp11_);
#line 1646 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = book;
#line 1646 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = book_get_needs_saving (_tmp12_);
#line 1646 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = _tmp13_;
#line 1646 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp14_) {
#line 7650 "ui.c"
		GtkMenuItem* _tmp15_ = NULL;
#line 1647 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = self->priv->save_as_menuitem;
#line 1647 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, TRUE);
#line 7656 "ui.c"
	}
#line 1648 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = self->priv->copy_to_clipboard_menuitem;
#line 1648 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, TRUE);
#line 7662 "ui.c"
}


static void _user_interface_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
#line 1718 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_info_bar_response_cb ((UserInterface*) self, _sender, response_id);
#line 7669 "ui.c"
}


static void __lambda10_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 1760 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1760 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_text_dpi (self);
#line 1760 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp0_, "text-dpi", _tmp1_);
#line 7682 "ui.c"
}


static void ___lambda10__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 1760 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda10_ ((UserInterface*) self);
#line 7689 "ui.c"
}


static void __lambda11_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_photo_dpi (self);
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp0_, "photo-dpi", _tmp1_);
#line 7702 "ui.c"
}


static void ___lambda11__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda11_ ((UserInterface*) self);
#line 7709 "ui.c"
}


static void __lambda12_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	ScanType _tmp1_ = 0;
#line 1775 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1775 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_page_side (self);
#line 1775 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_enum (_tmp0_, "page-side", (gint) _tmp1_);
#line 7722 "ui.c"
}


static void ___lambda12__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 1775 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda12_ ((UserInterface*) self);
#line 7729 "ui.c"
}


static void __lambda13_ (UserInterface* self) {
	gint w = 0;
	gint h = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
#line 1786 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_get_paper_size (self, &_tmp0_, &_tmp1_);
#line 1786 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	w = _tmp0_;
#line 1786 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	h = _tmp1_;
#line 1787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->settings;
#line 1787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp2_, "paper-width", w);
#line 1788 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->settings;
#line 1788 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp3_, "paper-height", h);
#line 7754 "ui.c"
}


static void ___lambda13__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 1783 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda13_ ((UserInterface*) self);
#line 7761 "ui.c"
}


static void __lambda14_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1799 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1799 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_brightness (self);
#line 1799 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1799 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp0_, "brightness", _tmp2_);
#line 7777 "ui.c"
}


static void ___lambda14__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 1799 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda14_ ((UserInterface*) self);
#line 7784 "ui.c"
}


static void __lambda15_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1809 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1809 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_contrast (self);
#line 1809 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1809 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp0_, "contrast", _tmp2_);
#line 7800 "ui.c"
}


static void ___lambda15__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 1809 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda15_ ((UserInterface*) self);
#line 7807 "ui.c"
}


static void __lambda16_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1819 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1819 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_quality (self);
#line 1819 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1819 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp0_, "jpeg-quality", _tmp2_);
#line 7823 "ui.c"
}


static void ___lambda16__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 1819 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda16_ ((UserInterface*) self);
#line 7830 "ui.c"
}


static void _user_interface_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self) {
#line 1835 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_selected_cb ((UserInterface*) self, _sender, page);
#line 7837 "ui.c"
}


static void _user_interface_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self) {
#line 1836 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_page_cb ((UserInterface*) self, _sender, page);
#line 7844 "ui.c"
}


static void _user_interface_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self) {
#line 1837 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_page_menu_cb ((UserInterface*) self, _sender);
#line 7851 "ui.c"
}


static void _user_interface_book_saving_cb_book_saving (Book* _sender, gint i, gpointer self) {
#line 1853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_book_saving_cb ((UserInterface*) self, i);
#line 7858 "ui.c"
}


static void user_interface_load (UserInterface* self) {
	GtkIconTheme* _tmp0_ = NULL;
	GtkApplication* app = NULL;
	GApplication* _tmp1_ = NULL;
	GtkApplication* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkApplication* _tmp54_ = NULL;
	GtkInfoBar* _tmp55_ = NULL;
	GtkInfoBar* _tmp56_ = NULL;
	GtkBox* _tmp57_ = NULL;
	GtkInfoBar* _tmp58_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp59_ = NULL;
	GtkContainer* content_area = NULL;
	GtkInfoBar* _tmp60_ = NULL;
	GtkContainer* _tmp61_ = NULL;
	GtkContainer* _tmp62_ = NULL;
	GtkContainer* _tmp63_ = NULL;
	GtkBox* _tmp64_ = NULL;
	GtkBox* _tmp65_ = NULL;
	GtkImage* _tmp66_ = NULL;
	GtkBox* _tmp67_ = NULL;
	GtkImage* _tmp68_ = NULL;
	GtkImage* _tmp69_ = NULL;
	GtkLabel* _tmp70_ = NULL;
	GtkLabel* _tmp71_ = NULL;
	GtkBox* _tmp72_ = NULL;
	GtkLabel* _tmp73_ = NULL;
	GtkLabel* _tmp74_ = NULL;
	GtkInfoBar* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	GtkButton* _tmp77_ = NULL;
	GtkButton* _tmp78_ = NULL;
	GtkInfoBar* _tmp79_ = NULL;
	const gchar* _tmp80_ = NULL;
	GtkButton* _tmp81_ = NULL;
	GtkButton* _tmp82_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp83_ = NULL;
	GtkTreeIter _tmp84_ = {0};
	GtkListStore* _tmp85_ = NULL;
	GtkTreeIter _tmp86_ = {0};
	const gchar* _tmp87_ = NULL;
	GtkListStore* _tmp88_ = NULL;
	GtkTreeIter _tmp89_ = {0};
	GtkListStore* _tmp90_ = NULL;
	GtkTreeIter _tmp91_ = {0};
	GtkListStore* _tmp92_ = NULL;
	GtkTreeIter _tmp93_ = {0};
	GtkListStore* _tmp94_ = NULL;
	GtkTreeIter _tmp95_ = {0};
	GtkListStore* _tmp96_ = NULL;
	GtkTreeIter _tmp97_ = {0};
	GtkListStore* _tmp98_ = NULL;
	GtkTreeIter _tmp99_ = {0};
	GtkListStore* _tmp100_ = NULL;
	GtkTreeIter _tmp101_ = {0};
	GtkListStore* _tmp102_ = NULL;
	GtkTreeIter _tmp103_ = {0};
	GtkListStore* _tmp104_ = NULL;
	GtkTreeIter _tmp105_ = {0};
	GtkListStore* _tmp106_ = NULL;
	GtkTreeIter _tmp107_ = {0};
	GtkListStore* _tmp108_ = NULL;
	GtkTreeIter _tmp109_ = {0};
	GtkListStore* _tmp110_ = NULL;
	GtkTreeIter _tmp111_ = {0};
	gint dpi = 0;
	GSettings* _tmp112_ = NULL;
	gint _tmp113_ = 0;
	gint _tmp114_ = 0;
	GtkComboBox* _tmp115_ = NULL;
	gint _tmp116_ = 0;
	GtkComboBox* _tmp117_ = NULL;
	GSettings* _tmp118_ = NULL;
	gint _tmp119_ = 0;
	gint _tmp120_ = 0;
	GtkComboBox* _tmp121_ = NULL;
	gint _tmp122_ = 0;
	GtkComboBox* _tmp123_ = NULL;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp124_ = NULL;
	GtkComboBox* _tmp125_ = NULL;
	GtkCellRendererText* _tmp126_ = NULL;
	GtkComboBox* _tmp127_ = NULL;
	GtkCellRendererText* _tmp128_ = NULL;
	GtkCellRendererText* _tmp129_ = NULL;
	GtkComboBox* _tmp130_ = NULL;
	GtkCellRendererText* _tmp131_ = NULL;
	GtkComboBox* _tmp132_ = NULL;
	GtkCellRendererText* _tmp133_ = NULL;
	GSettings* _tmp134_ = NULL;
	gint _tmp135_ = 0;
	GtkComboBox* _tmp136_ = NULL;
	GtkCellRendererText* _tmp137_ = NULL;
	GtkComboBox* _tmp138_ = NULL;
	GtkCellRendererText* _tmp139_ = NULL;
	GtkComboBox* _tmp140_ = NULL;
	GtkCellRendererText* _tmp141_ = NULL;
	gint paper_width = 0;
	GSettings* _tmp142_ = NULL;
	gint _tmp143_ = 0;
	gint paper_height = 0;
	GSettings* _tmp144_ = NULL;
	gint _tmp145_ = 0;
	gint _tmp146_ = 0;
	gint _tmp147_ = 0;
	GtkComboBox* _tmp148_ = NULL;
	gdouble lower = 0.0;
	GtkAdjustment* _tmp149_ = NULL;
	gdouble _tmp150_ = 0.0;
	gdouble _tmp151_ = 0.0;
	gchar* darker_label = NULL;
	const gchar* _tmp152_ = NULL;
	gchar* _tmp153_ = NULL;
	gdouble upper = 0.0;
	GtkAdjustment* _tmp154_ = NULL;
	gdouble _tmp155_ = 0.0;
	gdouble _tmp156_ = 0.0;
	gchar* lighter_label = NULL;
	const gchar* _tmp157_ = NULL;
	gchar* _tmp158_ = NULL;
	GtkScale* _tmp159_ = NULL;
	gdouble _tmp160_ = 0.0;
	const gchar* _tmp161_ = NULL;
	GtkScale* _tmp162_ = NULL;
	GtkScale* _tmp163_ = NULL;
	gdouble _tmp164_ = 0.0;
	const gchar* _tmp165_ = NULL;
	GSettings* _tmp166_ = NULL;
	gint _tmp167_ = 0;
	GtkAdjustment* _tmp168_ = NULL;
	GtkAdjustment* _tmp169_ = NULL;
	gdouble _tmp170_ = 0.0;
	gdouble _tmp171_ = 0.0;
	gchar* less_label = NULL;
	const gchar* _tmp172_ = NULL;
	gchar* _tmp173_ = NULL;
	GtkAdjustment* _tmp174_ = NULL;
	gdouble _tmp175_ = 0.0;
	gdouble _tmp176_ = 0.0;
	gchar* more_label = NULL;
	const gchar* _tmp177_ = NULL;
	gchar* _tmp178_ = NULL;
	GtkScale* _tmp179_ = NULL;
	gdouble _tmp180_ = 0.0;
	const gchar* _tmp181_ = NULL;
	GtkScale* _tmp182_ = NULL;
	GtkScale* _tmp183_ = NULL;
	gdouble _tmp184_ = 0.0;
	const gchar* _tmp185_ = NULL;
	GSettings* _tmp186_ = NULL;
	gint _tmp187_ = 0;
	GtkAdjustment* _tmp188_ = NULL;
	GtkAdjustment* _tmp189_ = NULL;
	gdouble _tmp190_ = 0.0;
	gdouble _tmp191_ = 0.0;
	gchar* minimum_label = NULL;
	const gchar* _tmp192_ = NULL;
	gchar* _tmp193_ = NULL;
	GtkAdjustment* _tmp194_ = NULL;
	gdouble _tmp195_ = 0.0;
	gdouble _tmp196_ = 0.0;
	gchar* maximum_label = NULL;
	const gchar* _tmp197_ = NULL;
	gchar* _tmp198_ = NULL;
	GtkScale* _tmp199_ = NULL;
	gdouble _tmp200_ = 0.0;
	const gchar* _tmp201_ = NULL;
	GtkScale* _tmp202_ = NULL;
	GtkScale* _tmp203_ = NULL;
	gdouble _tmp204_ = 0.0;
	const gchar* _tmp205_ = NULL;
	GSettings* _tmp206_ = NULL;
	gint _tmp207_ = 0;
	GtkAdjustment* _tmp208_ = NULL;
	gchar* device = NULL;
	GSettings* _tmp209_ = NULL;
	gchar* _tmp210_ = NULL;
	const gchar* _tmp211_ = NULL;
	gchar* document_type = NULL;
	GSettings* _tmp217_ = NULL;
	gchar* _tmp218_ = NULL;
	const gchar* _tmp219_ = NULL;
	Book* _tmp221_ = NULL;
	BookView* _tmp222_ = NULL;
	BookView* _tmp223_ = NULL;
	GtkBox* _tmp224_ = NULL;
	BookView* _tmp225_ = NULL;
	BookView* _tmp226_ = NULL;
	BookView* _tmp227_ = NULL;
	BookView* _tmp228_ = NULL;
	BookView* _tmp229_ = NULL;
	gint _tmp230_ = 0;
	gint _tmp231_ = 0;
	gint _tmp232_ = 0;
	gint _tmp233_ = 0;
	gboolean _tmp234_ = FALSE;
	const gchar* _tmp235_ = NULL;
	ProgressBarDialog* _tmp236_ = NULL;
	Book* _tmp237_ = NULL;
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1663 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = gtk_icon_theme_get_default ();
#line 1663 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_icon_theme_append_search_path (_tmp0_, ICON_DIR);
#line 1665 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_default_icon_name ("scanner");
#line 1667 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_application_get_default ();
#line 1667 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GTK_TYPE_APPLICATION) ? ((GtkApplication*) _tmp1_) : NULL);
#line 1667 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	app = _tmp2_;
#line 1669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = user_interface_get_shell_shows_menubar (self);
#line 1669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = _tmp3_;
#line 1669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp4_) {
#line 8084 "ui.c"
		GtkApplication* _tmp5_ = NULL;
		GMenu* appmenu = NULL;
		GMenu* _tmp6_ = NULL;
		GMenu* section = NULL;
		GMenu* _tmp7_ = NULL;
		GMenu* _tmp8_ = NULL;
		GMenu* _tmp9_ = NULL;
		GMenu* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GMenu* _tmp12_ = NULL;
		GMenu* _tmp13_ = NULL;
		GMenu* _tmp14_ = NULL;
		GMenu* menu = NULL;
		GMenu* _tmp15_ = NULL;
		GMenu* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GMenu* _tmp18_ = NULL;
		GMenu* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GMenu* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		GMenu* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		GMenu* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		GMenu* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		GMenu* _tmp29_ = NULL;
		GMenu* _tmp30_ = NULL;
		GMenu* _tmp31_ = NULL;
		GMenu* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		GMenu* _tmp34_ = NULL;
		GMenu* _tmp35_ = NULL;
		GMenu* _tmp36_ = NULL;
		GMenu* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		GMenu* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		GMenu* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		GtkApplication* _tmp43_ = NULL;
		GMenu* _tmp44_ = NULL;
		GtkApplication* _tmp45_ = NULL;
		GtkApplication* _tmp46_ = NULL;
		GtkApplication* _tmp47_ = NULL;
		GtkApplication* _tmp48_ = NULL;
		GtkApplication* _tmp49_ = NULL;
		GtkApplication* _tmp50_ = NULL;
		GtkApplication* _tmp51_ = NULL;
#line 1671 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = app;
#line 1671 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_action_map_add_action_entries ((GActionMap*) _tmp5_, USER_INTERFACE_action_entries, G_N_ELEMENTS (USER_INTERFACE_action_entries), self);
#line 1673 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = g_menu_new ();
#line 1673 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		appmenu = _tmp6_;
#line 1674 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = g_menu_new ();
#line 1674 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		section = _tmp7_;
#line 1675 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = appmenu;
#line 1675 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = section;
#line 1675 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append_section (_tmp8_, NULL, (GMenuModel*) _tmp9_);
#line 1676 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = section;
#line 1676 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = _ ("New Document");
#line 1676 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append (_tmp10_, _tmp11_, "app.new_document");
#line 1678 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp12_ = g_menu_new ();
#line 1678 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (section);
#line 1678 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		section = _tmp12_;
#line 1679 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp13_ = appmenu;
#line 1679 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp14_ = section;
#line 1679 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append_section (_tmp13_, NULL, (GMenuModel*) _tmp14_);
#line 1680 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = g_menu_new ();
#line 1680 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		menu = _tmp15_;
#line 1681 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp16_ = section;
#line 1681 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp17_ = _ ("Document");
#line 1681 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp18_ = menu;
#line 1681 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append_submenu (_tmp16_, _tmp17_, (GMenuModel*) _tmp18_);
#line 1682 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp19_ = menu;
#line 1682 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp20_ = _ ("Reorder Pages");
#line 1682 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append (_tmp19_, _tmp20_, "app.reorder");
#line 1683 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp21_ = menu;
#line 1683 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp22_ = _ ("Save");
#line 1683 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append (_tmp21_, _tmp22_, "app.save");
#line 1684 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp23_ = menu;
#line 1684 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp24_ = _ ("Save As...");
#line 1684 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append (_tmp23_, _tmp24_, "app.save_as");
#line 1685 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp25_ = menu;
#line 1685 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp26_ = _ ("Email...");
#line 1685 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append (_tmp25_, _tmp26_, "app.email");
#line 1686 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp27_ = menu;
#line 1686 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp28_ = _ ("Print...");
#line 1686 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append (_tmp27_, _tmp28_, "app.print");
#line 1688 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp29_ = g_menu_new ();
#line 1688 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (section);
#line 1688 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		section = _tmp29_;
#line 1689 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp30_ = appmenu;
#line 1689 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp31_ = section;
#line 1689 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append_section (_tmp30_, NULL, (GMenuModel*) _tmp31_);
#line 1690 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp32_ = section;
#line 1690 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp33_ = _ ("Preferences");
#line 1690 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append (_tmp32_, _tmp33_, "app.preferences");
#line 1692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp34_ = g_menu_new ();
#line 1692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (section);
#line 1692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		section = _tmp34_;
#line 1693 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp35_ = appmenu;
#line 1693 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp36_ = section;
#line 1693 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append_section (_tmp35_, NULL, (GMenuModel*) _tmp36_);
#line 1694 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp37_ = section;
#line 1694 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp38_ = _ ("Help");
#line 1694 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append (_tmp37_, _tmp38_, "app.help");
#line 1695 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp39_ = section;
#line 1695 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp40_ = _ ("About");
#line 1695 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append (_tmp39_, _tmp40_, "app.about");
#line 1696 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp41_ = section;
#line 1696 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp42_ = _ ("Quit");
#line 1696 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_menu_append (_tmp41_, _tmp42_, "app.quit");
#line 1698 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp43_ = app;
#line 1698 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp44_ = appmenu;
#line 1698 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_application_set_app_menu (_tmp43_, (GMenuModel*) _tmp44_);
#line 1700 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp45_ = app;
#line 1700 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_application_add_accelerator (_tmp45_, "<Ctrl>N", "app.new_document", NULL);
#line 1701 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp46_ = app;
#line 1701 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_application_add_accelerator (_tmp46_, "<Ctrl>S", "app.save", NULL);
#line 1702 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp47_ = app;
#line 1702 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_application_add_accelerator (_tmp47_, "<Shift><Ctrl>S", "app.save_as", NULL);
#line 1703 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp48_ = app;
#line 1703 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_application_add_accelerator (_tmp48_, "<Ctrl>E", "app.email", NULL);
#line 1704 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp49_ = app;
#line 1704 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_application_add_accelerator (_tmp49_, "<Ctrl>P", "app.print", NULL);
#line 1705 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp50_ = app;
#line 1705 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_application_add_accelerator (_tmp50_, "F1", "app.help", NULL);
#line 1706 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp51_ = app;
#line 1706 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_application_add_accelerator (_tmp51_, "<Ctrl>Q", "app.quit", NULL);
#line 1669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (menu);
#line 1669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (section);
#line 1669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (appmenu);
#line 8301 "ui.c"
	} else {
		GtkMenuBar* _tmp52_ = NULL;
		GtkToolbar* _tmp53_ = NULL;
#line 1710 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_window_set_titlebar ((GtkWindow*) self, NULL);
#line 1711 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp52_ = self->priv->menubar;
#line 1711 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp52_, TRUE);
#line 1712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp53_ = self->priv->toolbar;
#line 1712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp53_, TRUE);
#line 8315 "ui.c"
	}
#line 1714 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp54_ = app;
#line 1714 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_application_add_window (_tmp54_, (GtkWindow*) self);
#line 1717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp55_ = (GtkInfoBar*) gtk_info_bar_new ();
#line 1717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp55_);
#line 1717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 1717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar = _tmp55_;
#line 1718 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp56_ = self->priv->info_bar;
#line 1718 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp56_, "response", (GCallback) _user_interface_info_bar_response_cb_gtk_info_bar_response, self, 0);
#line 1719 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp57_ = self->priv->main_vbox;
#line 1719 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp58_ = self->priv->info_bar;
#line 1719 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (_tmp57_, (GtkWidget*) _tmp58_, FALSE, TRUE, (guint) 0);
#line 1720 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp59_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
#line 1720 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp59_);
#line 1720 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	hbox = _tmp59_;
#line 1721 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp60_ = self->priv->info_bar;
#line 1721 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp61_ = gtk_info_bar_get_content_area (_tmp60_);
#line 1721 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp61_, GTK_TYPE_CONTAINER) ? ((GtkContainer*) _tmp61_) : NULL);
#line 1721 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	content_area = _tmp62_;
#line 1722 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp63_ = content_area;
#line 1722 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp64_ = hbox;
#line 1722 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_add (_tmp63_, (GtkWidget*) _tmp64_);
#line 1723 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp65_ = hbox;
#line 1723 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp65_, TRUE);
#line 1725 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp66_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-warning", GTK_ICON_SIZE_DIALOG);
#line 1725 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp66_);
#line 1725 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_image);
#line 1725 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar_image = _tmp66_;
#line 1726 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp67_ = hbox;
#line 1726 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp68_ = self->priv->info_bar_image;
#line 1726 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (_tmp67_, (GtkWidget*) _tmp68_, FALSE, TRUE, (guint) 0);
#line 1727 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp69_ = self->priv->info_bar_image;
#line 1727 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp69_, TRUE);
#line 1729 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp70_ = (GtkLabel*) gtk_label_new (NULL);
#line 1729 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp70_);
#line 1729 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 1729 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar_label = _tmp70_;
#line 1730 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp71_ = self->priv->info_bar_label;
#line 1730 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp71_, 0.0f, 0.5f);
#line 1731 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp72_ = hbox;
#line 1731 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp73_ = self->priv->info_bar_label;
#line 1731 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (_tmp72_, (GtkWidget*) _tmp73_, TRUE, TRUE, (guint) 0);
#line 1732 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp74_ = self->priv->info_bar_label;
#line 1732 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp74_, TRUE);
#line 1734 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp75_ = self->priv->info_bar;
#line 1734 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp76_ = _ ("_Close");
#line 1734 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp77_ = gtk_info_bar_add_button (_tmp75_, _tmp76_, (gint) GTK_RESPONSE_CLOSE);
#line 1734 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp78_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp77_) : NULL);
#line 1734 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_close_button);
#line 1734 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar_close_button = _tmp78_;
#line 1735 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp79_ = self->priv->info_bar;
#line 1735 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp80_ = _ ("Change _Scanner");
#line 1735 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp81_ = gtk_info_bar_add_button (_tmp79_, _tmp80_, 1);
#line 1735 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp81_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp81_) : NULL);
#line 1735 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
#line 1735 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar_change_scanner_button = _tmp82_;
#line 1739 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp83_ = self->priv->paper_size_model;
#line 1739 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp83_, &_tmp84_);
#line 1739 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp84_;
#line 1740 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp85_ = self->priv->paper_size_model;
#line 1740 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp86_ = iter;
#line 1740 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp87_ = _ ("Automatic");
#line 1740 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp85_, &_tmp86_, 0, 0, 1, 0, 2, _tmp87_, -1, -1);
#line 1743 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp88_ = self->priv->paper_size_model;
#line 1743 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp88_, &_tmp89_);
#line 1743 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp89_;
#line 1744 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp90_ = self->priv->paper_size_model;
#line 1744 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp91_ = iter;
#line 1744 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp90_, &_tmp91_, 0, 1050, 1, 1480, 2, "A6", -1, -1);
#line 1745 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp92_ = self->priv->paper_size_model;
#line 1745 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp92_, &_tmp93_);
#line 1745 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp93_;
#line 1746 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp94_ = self->priv->paper_size_model;
#line 1746 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp95_ = iter;
#line 1746 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp94_, &_tmp95_, 0, 1480, 1, 2100, 2, "A5", -1, -1);
#line 1747 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp96_ = self->priv->paper_size_model;
#line 1747 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp96_, &_tmp97_);
#line 1747 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp97_;
#line 1748 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp98_ = self->priv->paper_size_model;
#line 1748 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp99_ = iter;
#line 1748 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp98_, &_tmp99_, 0, 2100, 1, 2970, 2, "A4", -1, -1);
#line 1749 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp100_ = self->priv->paper_size_model;
#line 1749 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp100_, &_tmp101_);
#line 1749 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp101_;
#line 1750 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp102_ = self->priv->paper_size_model;
#line 1750 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp103_ = iter;
#line 1750 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp102_, &_tmp103_, 0, 2159, 1, 2794, 2, "Letter", -1, -1);
#line 1751 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp104_ = self->priv->paper_size_model;
#line 1751 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp104_, &_tmp105_);
#line 1751 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp105_;
#line 1752 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp106_ = self->priv->paper_size_model;
#line 1752 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp107_ = iter;
#line 1752 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp106_, &_tmp107_, 0, 2159, 1, 3556, 2, "Legal", -1, -1);
#line 1753 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp108_ = self->priv->paper_size_model;
#line 1753 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp108_, &_tmp109_);
#line 1753 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp109_;
#line 1754 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp110_ = self->priv->paper_size_model;
#line 1754 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp111_ = iter;
#line 1754 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp110_, &_tmp111_, 0, 1016, 1, 1524, 2, "4×6", -1, -1);
#line 1756 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp112_ = self->priv->settings;
#line 1756 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp113_ = g_settings_get_int (_tmp112_, "text-dpi");
#line 1756 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dpi = _tmp113_;
#line 1757 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp114_ = dpi;
#line 1757 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp114_ <= 0) {
#line 1758 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dpi = USER_INTERFACE_DEFAULT_TEXT_DPI;
#line 8525 "ui.c"
	}
#line 1759 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp115_ = self->priv->text_dpi_combo;
#line 1759 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp116_ = dpi;
#line 1759 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_dpi_combo (self, _tmp115_, USER_INTERFACE_DEFAULT_TEXT_DPI, _tmp116_);
#line 1760 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp117_ = self->priv->text_dpi_combo;
#line 1760 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp117_, "changed", (GCallback) ___lambda10__gtk_combo_box_changed, self, 0);
#line 1761 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp118_ = self->priv->settings;
#line 1761 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp119_ = g_settings_get_int (_tmp118_, "photo-dpi");
#line 1761 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dpi = _tmp119_;
#line 1762 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp120_ = dpi;
#line 1762 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp120_ <= 0) {
#line 1763 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dpi = USER_INTERFACE_DEFAULT_PHOTO_DPI;
#line 8549 "ui.c"
	}
#line 1764 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp121_ = self->priv->photo_dpi_combo;
#line 1764 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp122_ = dpi;
#line 1764 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_dpi_combo (self, _tmp121_, USER_INTERFACE_DEFAULT_PHOTO_DPI, _tmp122_);
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp123_ = self->priv->photo_dpi_combo;
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp123_, "changed", (GCallback) ___lambda11__gtk_combo_box_changed, self, 0);
#line 1767 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp124_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1767 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp124_);
#line 1767 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	renderer = _tmp124_;
#line 1768 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp125_ = self->priv->device_combo;
#line 1768 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp126_ = renderer;
#line 1768 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp125_, (GtkCellRenderer*) _tmp126_, TRUE);
#line 1769 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp127_ = self->priv->device_combo;
#line 1769 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp128_ = renderer;
#line 1769 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp127_, (GtkCellRenderer*) _tmp128_, "text", 1);
#line 1771 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp129_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1771 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp129_);
#line 1771 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1771 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	renderer = _tmp129_;
#line 1772 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp130_ = self->priv->page_side_combo;
#line 1772 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp131_ = renderer;
#line 1772 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp130_, (GtkCellRenderer*) _tmp131_, TRUE);
#line 1773 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp132_ = self->priv->page_side_combo;
#line 1773 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp133_ = renderer;
#line 1773 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp132_, (GtkCellRenderer*) _tmp133_, "text", 1);
#line 1774 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp134_ = self->priv->settings;
#line 1774 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp135_ = g_settings_get_enum (_tmp134_, "page-side");
#line 1774 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_page_side (self, (ScanType) _tmp135_);
#line 1775 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp136_ = self->priv->page_side_combo;
#line 1775 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp136_, "changed", (GCallback) ___lambda12__gtk_combo_box_changed, self, 0);
#line 1777 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp137_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1777 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp137_);
#line 1777 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1777 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	renderer = _tmp137_;
#line 1778 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp138_ = self->priv->paper_size_combo;
#line 1778 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp139_ = renderer;
#line 1778 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp138_, (GtkCellRenderer*) _tmp139_, TRUE);
#line 1779 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp140_ = self->priv->paper_size_combo;
#line 1779 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp141_ = renderer;
#line 1779 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp140_, (GtkCellRenderer*) _tmp141_, "text", 2);
#line 1780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp142_ = self->priv->settings;
#line 1780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp143_ = g_settings_get_int (_tmp142_, "paper-width");
#line 1780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	paper_width = _tmp143_;
#line 1781 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp144_ = self->priv->settings;
#line 1781 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp145_ = g_settings_get_int (_tmp144_, "paper-height");
#line 1781 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	paper_height = _tmp145_;
#line 1782 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp146_ = paper_width;
#line 1782 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp147_ = paper_height;
#line 1782 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_paper_size (self, _tmp146_, _tmp147_);
#line 1783 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp148_ = self->priv->paper_size_combo;
#line 1783 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp148_, "changed", (GCallback) ___lambda13__gtk_combo_box_changed, self, 0);
#line 1791 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp149_ = self->priv->brightness_adjustment;
#line 1791 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp150_ = gtk_adjustment_get_lower (_tmp149_);
#line 1791 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp151_ = _tmp150_;
#line 1791 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	lower = _tmp151_;
#line 1792 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp152_ = _ ("Darker");
#line 1792 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp153_ = g_strdup_printf ("<small>%s</small>", _tmp152_);
#line 1792 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	darker_label = _tmp153_;
#line 1793 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp154_ = self->priv->brightness_adjustment;
#line 1793 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp155_ = gtk_adjustment_get_upper (_tmp154_);
#line 1793 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp156_ = _tmp155_;
#line 1793 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	upper = _tmp156_;
#line 1794 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp157_ = _ ("Lighter");
#line 1794 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp158_ = g_strdup_printf ("<small>%s</small>", _tmp157_);
#line 1794 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	lighter_label = _tmp158_;
#line 1795 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp159_ = self->priv->brightness_scale;
#line 1795 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp160_ = lower;
#line 1795 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp161_ = darker_label;
#line 1795 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp159_, _tmp160_, GTK_POS_BOTTOM, _tmp161_);
#line 1796 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp162_ = self->priv->brightness_scale;
#line 1796 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp162_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
#line 1797 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp163_ = self->priv->brightness_scale;
#line 1797 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp164_ = upper;
#line 1797 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp165_ = lighter_label;
#line 1797 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp163_, _tmp164_, GTK_POS_BOTTOM, _tmp165_);
#line 1798 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp166_ = self->priv->settings;
#line 1798 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp167_ = g_settings_get_int (_tmp166_, "brightness");
#line 1798 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_brightness (self, _tmp167_);
#line 1799 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp168_ = self->priv->brightness_adjustment;
#line 1799 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp168_, "value-changed", (GCallback) ___lambda14__gtk_adjustment_value_changed, self, 0);
#line 1801 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp169_ = self->priv->contrast_adjustment;
#line 1801 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp170_ = gtk_adjustment_get_lower (_tmp169_);
#line 1801 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp171_ = _tmp170_;
#line 1801 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	lower = _tmp171_;
#line 1802 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp172_ = _ ("Less");
#line 1802 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp173_ = g_strdup_printf ("<small>%s</small>", _tmp172_);
#line 1802 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	less_label = _tmp173_;
#line 1803 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp174_ = self->priv->contrast_adjustment;
#line 1803 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp175_ = gtk_adjustment_get_upper (_tmp174_);
#line 1803 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp176_ = _tmp175_;
#line 1803 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	upper = _tmp176_;
#line 1804 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp177_ = _ ("More");
#line 1804 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp178_ = g_strdup_printf ("<small>%s</small>", _tmp177_);
#line 1804 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	more_label = _tmp178_;
#line 1805 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp179_ = self->priv->contrast_scale;
#line 1805 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp180_ = lower;
#line 1805 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp181_ = less_label;
#line 1805 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp179_, _tmp180_, GTK_POS_BOTTOM, _tmp181_);
#line 1806 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp182_ = self->priv->contrast_scale;
#line 1806 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp182_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
#line 1807 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp183_ = self->priv->contrast_scale;
#line 1807 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp184_ = upper;
#line 1807 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp185_ = more_label;
#line 1807 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp183_, _tmp184_, GTK_POS_BOTTOM, _tmp185_);
#line 1808 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp186_ = self->priv->settings;
#line 1808 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp187_ = g_settings_get_int (_tmp186_, "contrast");
#line 1808 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_contrast (self, _tmp187_);
#line 1809 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp188_ = self->priv->contrast_adjustment;
#line 1809 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp188_, "value-changed", (GCallback) ___lambda15__gtk_adjustment_value_changed, self, 0);
#line 1811 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp189_ = self->priv->quality_adjustment;
#line 1811 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp190_ = gtk_adjustment_get_lower (_tmp189_);
#line 1811 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp191_ = _tmp190_;
#line 1811 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	lower = _tmp191_;
#line 1812 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp192_ = _ ("Minimum");
#line 1812 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp193_ = g_strdup_printf ("<small>%s</small>", _tmp192_);
#line 1812 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	minimum_label = _tmp193_;
#line 1813 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp194_ = self->priv->quality_adjustment;
#line 1813 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp195_ = gtk_adjustment_get_upper (_tmp194_);
#line 1813 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp196_ = _tmp195_;
#line 1813 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	upper = _tmp196_;
#line 1814 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp197_ = _ ("Maximum");
#line 1814 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp198_ = g_strdup_printf ("<small>%s</small>", _tmp197_);
#line 1814 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	maximum_label = _tmp198_;
#line 1815 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp199_ = self->priv->quality_scale;
#line 1815 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp200_ = lower;
#line 1815 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp201_ = minimum_label;
#line 1815 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp199_, _tmp200_, GTK_POS_BOTTOM, _tmp201_);
#line 1816 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp202_ = self->priv->quality_scale;
#line 1816 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp202_, (gdouble) 75, GTK_POS_BOTTOM, NULL);
#line 1817 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp203_ = self->priv->quality_scale;
#line 1817 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp204_ = upper;
#line 1817 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp205_ = maximum_label;
#line 1817 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp203_, _tmp204_, GTK_POS_BOTTOM, _tmp205_);
#line 1818 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp206_ = self->priv->settings;
#line 1818 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp207_ = g_settings_get_int (_tmp206_, "jpeg-quality");
#line 1818 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_quality (self, _tmp207_);
#line 1819 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp208_ = self->priv->quality_adjustment;
#line 1819 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp208_, "value-changed", (GCallback) ___lambda16__gtk_adjustment_value_changed, self, 0);
#line 1821 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp209_ = self->priv->settings;
#line 1821 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp210_ = g_settings_get_string (_tmp209_, "selected-device");
#line 1821 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	device = _tmp210_;
#line 1822 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp211_ = device;
#line 1822 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp211_ != NULL) {
#line 8835 "ui.c"
		const gchar* _tmp212_ = NULL;
		GtkTreeIter _tmp213_ = {0};
		gboolean _tmp214_ = FALSE;
#line 1824 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp212_ = device;
#line 1824 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp214_ = user_interface_find_scan_device (self, _tmp212_, &_tmp213_);
#line 1824 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		iter = _tmp213_;
#line 1824 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp214_) {
#line 8847 "ui.c"
			GtkComboBox* _tmp215_ = NULL;
			GtkTreeIter _tmp216_ = {0};
#line 1825 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp215_ = self->priv->device_combo;
#line 1825 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp216_ = iter;
#line 1825 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_combo_box_set_active_iter (_tmp215_, &_tmp216_);
#line 8856 "ui.c"
		}
	}
#line 1828 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp217_ = self->priv->settings;
#line 1828 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp218_ = g_settings_get_string (_tmp217_, "document-type");
#line 1828 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	document_type = _tmp218_;
#line 1829 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp219_ = document_type;
#line 1829 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp219_ != NULL) {
#line 8869 "ui.c"
		const gchar* _tmp220_ = NULL;
#line 1830 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp220_ = document_type;
#line 1830 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_document_hint (self, _tmp220_, FALSE);
#line 8875 "ui.c"
	}
#line 1832 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp221_ = self->priv->_book;
#line 1832 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp222_ = book_view_new (_tmp221_);
#line 1832 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp222_);
#line 1832 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->book_view);
#line 1832 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->book_view = _tmp222_;
#line 1833 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp223_ = self->priv->book_view;
#line 1833 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp223_, (guint) 18);
#line 1834 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp224_ = self->priv->main_vbox;
#line 1834 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp225_ = self->priv->book_view;
#line 1834 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_end (_tmp224_, (GtkWidget*) _tmp225_, TRUE, TRUE, (guint) 0);
#line 1835 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp226_ = self->priv->book_view;
#line 1835 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp226_, "page-selected", (GCallback) _user_interface_page_selected_cb_book_view_page_selected, self, 0);
#line 1836 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp227_ = self->priv->book_view;
#line 1836 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp227_, "show-page", (GCallback) _user_interface_show_page_cb_book_view_show_page, self, 0);
#line 1837 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp228_ = self->priv->book_view;
#line 1837 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp228_, "show-menu", (GCallback) _user_interface_show_page_menu_cb_book_view_show_menu, self, 0);
#line 1838 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp229_ = self->priv->book_view;
#line 1838 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp229_, TRUE);
#line 1841 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_load_state (self);
#line 1844 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp230_ = self->priv->window_width;
#line 1844 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp231_ = self->priv->window_height;
#line 1844 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_debug ("ui.vala:1844: Restoring window to %dx%d pixels", _tmp230_, _tmp231_);
#line 1845 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp232_ = self->priv->window_width;
#line 1845 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp233_ = self->priv->window_height;
#line 1845 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_default_size ((GtkWindow*) self, _tmp232_, _tmp233_);
#line 1846 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp234_ = self->priv->window_is_maximized;
#line 1846 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp234_) {
#line 1848 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_debug ("ui.vala:1848: Restoring window to maximized");
#line 1849 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_window_maximize ((GtkWindow*) self);
#line 8935 "ui.c"
	}
#line 1852 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp235_ = _ ("Saving document...");
#line 1852 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp236_ = progress_bar_dialog_new ((GtkApplicationWindow*) self, _tmp235_);
#line 1852 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp236_);
#line 1852 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 1852 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->progress_dialog = _tmp236_;
#line 1853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp237_ = self->priv->_book;
#line 1853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect_object (_tmp237_, "saving", (GCallback) _user_interface_book_saving_cb_book_saving, self, 0);
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (document_type);
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (device);
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (maximum_label);
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (minimum_label);
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (more_label);
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (less_label);
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (lighter_label);
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (darker_label);
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (content_area);
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (hbox);
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (app);
#line 8975 "ui.c"
}


static void user_interface_load_state (UserInterface* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GKeyFile* f = NULL;
	GKeyFile* _tmp3_ = NULL;
	GKeyFile* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GKeyFile* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GKeyFile* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GKeyFile* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	GKeyFile* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	GKeyFile* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	GKeyFile* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GQuark _tmp29_ = 0U;
#line 1885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	static GQuark _tmp28_label0 = 0;
#line 1885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	static GQuark _tmp28_label1 = 0;
#line 1885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	static GQuark _tmp28_label2 = 0;
#line 9009 "ui.c"
	GError * _inner_error_ = NULL;
#line 1861 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1863 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = user_interface_get_state_filename (self);
#line 1863 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _tmp0_;
#line 1863 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1863 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_debug ("ui.vala:1863: Loading state from %s", _tmp2_);
#line 1863 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_tmp2_);
#line 1865 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = g_key_file_new ();
#line 1865 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	f = _tmp3_;
#line 9027 "ui.c"
	{
		GKeyFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = f;
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = user_interface_get_state_filename (self);
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = _tmp5_;
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = _tmp6_;
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_key_file_load_from_file (_tmp4_, _tmp7_, G_KEY_FILE_NONE, &_inner_error_);
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp7_);
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 9047 "ui.c"
			goto __catch21_g_error;
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
#line 1866 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 1866 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1872 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = e;
#line 1872 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (!g_error_matches (_tmp8_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
#line 9064 "ui.c"
			GError* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
#line 1873 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp9_ = e;
#line 1873 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp10_ = _tmp9_->message;
#line 1873 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			g_warning ("ui.vala:1873: Failed to load state: %s", _tmp10_);
#line 9073 "ui.c"
		}
#line 1866 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 9077 "ui.c"
	}
	__finally21:
#line 1866 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1866 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_key_file_unref0 (f);
#line 1866 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1866 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1866 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 9090 "ui.c"
	}
#line 1875 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = f;
#line 1875 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = user_interface_state_get_integer (self, _tmp11_, "window", "width", 600);
#line 1875 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->window_width = _tmp12_;
#line 1876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = self->priv->window_width;
#line 1876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp13_ <= 0) {
#line 1877 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_width = 600;
#line 9104 "ui.c"
	}
#line 1878 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = f;
#line 1878 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = user_interface_state_get_integer (self, _tmp14_, "window", "height", 400);
#line 1878 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->window_height = _tmp15_;
#line 1879 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = self->priv->window_height;
#line 1879 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp16_ <= 0) {
#line 1880 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_height = 400;
#line 9118 "ui.c"
	}
#line 1881 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = f;
#line 1881 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = user_interface_state_get_boolean (self, _tmp17_, "window", "is-maximized", FALSE);
#line 1881 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->window_is_maximized = _tmp18_;
#line 1882 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = f;
#line 1882 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = user_interface_state_get_integer (self, _tmp19_, "last-page", "width", 595);
#line 1882 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_width = _tmp20_;
#line 1883 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = f;
#line 1883 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = user_interface_state_get_integer (self, _tmp21_, "last-page", "height", 842);
#line 1883 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_height = _tmp22_;
#line 1884 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = f;
#line 1884 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = user_interface_state_get_integer (self, _tmp23_, "last-page", "dpi", 72);
#line 1884 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_dpi = _tmp24_;
#line 1885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = f;
#line 1885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = user_interface_state_get_string (self, _tmp25_, "last-page", "scan-direction", "top-to-bottom");
#line 1885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = _tmp26_;
#line 1885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp29_ = (NULL == _tmp27_) ? 0 : g_quark_from_string (_tmp27_);
#line 1885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_free (_tmp27_);
#line 1885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp29_ == ((0 != _tmp28_label0) ? _tmp28_label0 : (_tmp28_label0 = g_quark_from_static_string ("bottom-to-top")))) {
#line 1885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		switch (0) {
#line 9158 "ui.c"
			default:
			{
#line 1892 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				self->priv->default_page_scan_direction = SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 1893 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				break;
#line 9165 "ui.c"
			}
		}
	} else if (_tmp29_ == ((0 != _tmp28_label1) ? _tmp28_label1 : (_tmp28_label1 = g_quark_from_static_string ("left-to-right")))) {
#line 1885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		switch (0) {
#line 9171 "ui.c"
			default:
			{
#line 1895 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				self->priv->default_page_scan_direction = SCAN_DIRECTION_LEFT_TO_RIGHT;
#line 1896 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				break;
#line 9178 "ui.c"
			}
		}
	} else if (_tmp29_ == ((0 != _tmp28_label2) ? _tmp28_label2 : (_tmp28_label2 = g_quark_from_static_string ("right-to-left")))) {
#line 1885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		switch (0) {
#line 9184 "ui.c"
			default:
			{
#line 1898 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				self->priv->default_page_scan_direction = SCAN_DIRECTION_RIGHT_TO_LEFT;
#line 1899 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				break;
#line 9191 "ui.c"
			}
		}
	} else {
#line 1885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		switch (0) {
#line 9197 "ui.c"
			default:
			{
#line 1889 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				self->priv->default_page_scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 1890 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				break;
#line 9204 "ui.c"
			}
		}
	}
#line 1861 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_key_file_unref0 (f);
#line 9210 "ui.c"
}


static gint user_interface_state_get_integer (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, gint _default_) {
	gint result = 0;
	GError * _inner_error_ = NULL;
#line 1903 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1903 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (f != NULL, 0);
#line 1903 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (group_name != NULL, 0);
#line 1903 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 9225 "ui.c"
	{
		gint _tmp0_ = 0;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 1907 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = f;
#line 1907 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = group_name;
#line 1907 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = key;
#line 1907 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = g_key_file_get_integer (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 1907 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = _tmp4_;
#line 1907 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 9244 "ui.c"
			goto __catch22_g_error;
		}
#line 1907 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = _tmp0_;
#line 1907 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 9251 "ui.c"
	}
	goto __finally22;
	__catch22_g_error:
	{
		gint _tmp5_ = 0;
#line 1905 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1905 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _default_;
#line 1911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = _tmp5_;
#line 1911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 9267 "ui.c"
	}
	__finally22:
#line 1905 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1905 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_clear_error (&_inner_error_);
#line 1905 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return 0;
#line 9276 "ui.c"
}


static gboolean user_interface_state_get_boolean (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, gboolean _default_) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1915 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1915 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (f != NULL, FALSE);
#line 1915 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (group_name != NULL, FALSE);
#line 1915 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 9291 "ui.c"
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 1919 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = f;
#line 1919 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = group_name;
#line 1919 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = key;
#line 1919 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = g_key_file_get_boolean (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 1919 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = _tmp4_;
#line 1919 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 9310 "ui.c"
			goto __catch23_g_error;
		}
#line 1919 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = _tmp0_;
#line 1919 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 9317 "ui.c"
	}
	goto __finally23;
	__catch23_g_error:
	{
		gboolean _tmp5_ = FALSE;
#line 1917 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1917 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1923 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _default_;
#line 1923 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = _tmp5_;
#line 1923 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 9333 "ui.c"
	}
	__finally23:
#line 1917 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1917 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_clear_error (&_inner_error_);
#line 1917 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return FALSE;
#line 9342 "ui.c"
}


static gchar* user_interface_state_get_string (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, const gchar* _default_) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1927 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1927 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (f != NULL, NULL);
#line 1927 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (group_name != NULL, NULL);
#line 1927 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 1927 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (_default_ != NULL, NULL);
#line 9359 "ui.c"
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 1931 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = f;
#line 1931 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = group_name;
#line 1931 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = key;
#line 1931 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = g_key_file_get_string (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 1931 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = _tmp4_;
#line 1931 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 9379 "ui.c"
			goto __catch24_g_error;
		}
#line 1931 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _tmp0_;
#line 1931 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = NULL;
#line 1931 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = _tmp5_;
#line 1931 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp0_);
#line 1931 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 9392 "ui.c"
	}
	goto __finally24;
	__catch24_g_error:
	{
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 1929 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1929 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = _default_;
#line 1935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 1935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = _tmp7_;
#line 1935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 9411 "ui.c"
	}
	__finally24:
#line 1929 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1929 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_clear_error (&_inner_error_);
#line 1929 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return NULL;
#line 9420 "ui.c"
}


static gboolean ___lambda9_ (UserInterface* self) {
	gboolean result = FALSE;
#line 1947 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_state (self, TRUE);
#line 1948 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->save_state_timeout = (guint) 0;
#line 1949 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 1949 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9434 "ui.c"
}


static gboolean ____lambda9__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda9_ ((UserInterface*) self);
#line 1945 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9443 "ui.c"
}


static void user_interface_save_state (UserInterface* self, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GKeyFile* f = NULL;
	GKeyFile* _tmp7_ = NULL;
	GKeyFile* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GKeyFile* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GKeyFile* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GKeyFile* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GKeyFile* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GKeyFile* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	ScanDirection _tmp20_ = 0;
	GError * _inner_error_ = NULL;
#line 1939 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1941 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = force;
#line 1941 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp0_) {
#line 9474 "ui.c"
		guint _tmp1_ = 0U;
		guint _tmp3_ = 0U;
#line 1943 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = self->priv->save_state_timeout;
#line 1943 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp1_ != ((guint) 0)) {
#line 9481 "ui.c"
			guint _tmp2_ = 0U;
#line 1944 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp2_ = self->priv->save_state_timeout;
#line 1944 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			g_source_remove (_tmp2_);
#line 9487 "ui.c"
		}
#line 1945 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda9__gsource_func, g_object_ref (self), g_object_unref);
#line 1945 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->save_state_timeout = _tmp3_;
#line 1951 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 9495 "ui.c"
	}
#line 1954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = user_interface_get_state_filename (self);
#line 1954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 1954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = _tmp5_;
#line 1954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_debug ("ui.vala:1954: Saving state to %s", _tmp6_);
#line 1954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_tmp6_);
#line 1956 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = g_key_file_new ();
#line 1956 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	f = _tmp7_;
#line 1957 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = f;
#line 1957 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->window_width;
#line 1957 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_key_file_set_integer (_tmp8_, "window", "width", _tmp9_);
#line 1958 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = f;
#line 1958 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = self->priv->window_height;
#line 1958 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_key_file_set_integer (_tmp10_, "window", "height", _tmp11_);
#line 1959 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = f;
#line 1959 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = self->priv->window_is_maximized;
#line 1959 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_key_file_set_boolean (_tmp12_, "window", "is-maximized", _tmp13_);
#line 1960 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = f;
#line 1960 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = self->priv->default_page_width;
#line 1960 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_key_file_set_integer (_tmp14_, "last-page", "width", _tmp15_);
#line 1961 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = f;
#line 1961 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = self->priv->default_page_height;
#line 1961 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_key_file_set_integer (_tmp16_, "last-page", "height", _tmp17_);
#line 1962 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = f;
#line 1962 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = self->priv->default_page_dpi;
#line 1962 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_key_file_set_integer (_tmp18_, "last-page", "dpi", _tmp19_);
#line 1963 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = self->priv->default_page_scan_direction;
#line 1963 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	switch (_tmp20_) {
#line 1963 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 9553 "ui.c"
		{
			GKeyFile* _tmp21_ = NULL;
#line 1966 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp21_ = f;
#line 1966 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			g_key_file_set_value (_tmp21_, "last-page", "scan-direction", "top-to-bottom");
#line 1967 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			break;
#line 9562 "ui.c"
		}
#line 1963 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 9566 "ui.c"
		{
			GKeyFile* _tmp22_ = NULL;
#line 1969 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp22_ = f;
#line 1969 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			g_key_file_set_value (_tmp22_, "last-page", "scan-direction", "bottom-to-top");
#line 1970 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			break;
#line 9575 "ui.c"
		}
#line 1963 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 9579 "ui.c"
		{
			GKeyFile* _tmp23_ = NULL;
#line 1972 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp23_ = f;
#line 1972 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			g_key_file_set_value (_tmp23_, "last-page", "scan-direction", "left-to-right");
#line 1973 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			break;
#line 9588 "ui.c"
		}
#line 1963 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 9592 "ui.c"
		{
			GKeyFile* _tmp24_ = NULL;
#line 1975 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp24_ = f;
#line 1975 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			g_key_file_set_value (_tmp24_, "last-page", "scan-direction", "right-to-left");
#line 1976 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			break;
#line 9601 "ui.c"
		}
		default:
#line 1963 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 9606 "ui.c"
	}
	{
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		GKeyFile* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
#line 1980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp25_ = user_interface_get_state_filename (self);
#line 1980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp26_ = _tmp25_;
#line 1980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp27_ = _tmp26_;
#line 1980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp28_ = f;
#line 1980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp29_ = g_key_file_to_data (_tmp28_, NULL, NULL);
#line 1980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp30_ = _tmp29_;
#line 1980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_file_set_contents (_tmp27_, _tmp30_, (gssize) (-1), &_inner_error_);
#line 1980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp30_);
#line 1980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp27_);
#line 1980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 9635 "ui.c"
			goto __catch25_g_error;
		}
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
#line 1978 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 1978 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1984 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp31_ = e;
#line 1984 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp32_ = _tmp31_->message;
#line 1984 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_warning ("ui.vala:1984: Failed to write state: %s", _tmp32_);
#line 1978 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 9657 "ui.c"
	}
	__finally25:
#line 1978 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1978 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_key_file_unref0 (f);
#line 1978 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1978 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1978 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 9670 "ui.c"
	}
#line 1939 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_key_file_unref0 (f);
#line 9674 "ui.c"
}


static gboolean ___lambda17_ (UserInterface* self) {
	gboolean result = FALSE;
	ProgressBarDialog* _tmp0_ = NULL;
#line 1999 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 1999 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
#line 2000 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 2000 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9689 "ui.c"
}


static gboolean ____lambda17__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda17_ ((UserInterface*) self);
#line 1998 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9698 "ui.c"
}


static void user_interface_book_saving_cb (UserInterface* self, gint page_number) {
	gint total = 0;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gdouble fraction = 0.0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean complete = FALSE;
	gdouble _tmp6_ = 0.0;
	gboolean _tmp7_ = FALSE;
	gchar* message = NULL;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	ProgressBarDialog* _tmp12_ = NULL;
	gdouble _tmp13_ = 0.0;
	ProgressBarDialog* _tmp14_ = NULL;
#line 1988 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1991 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	while (TRUE) {
#line 9725 "ui.c"
		gboolean _tmp0_ = FALSE;
#line 1991 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = gtk_events_pending ();
#line 1991 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (!_tmp0_) {
#line 1991 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			break;
#line 9733 "ui.c"
		}
#line 1992 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_main_iteration ();
#line 9737 "ui.c"
	}
#line 1994 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->_book;
#line 1994 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 1994 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1994 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	total = (gint) _tmp3_;
#line 1995 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page_number;
#line 1995 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = total;
#line 1995 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	fraction = (_tmp4_ + 1.0) / _tmp5_;
#line 1996 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = fraction;
#line 1996 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	complete = _tmp6_ == 1.0;
#line 1997 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = complete;
#line 1997 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp7_) {
#line 1998 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda17__gsource_func, g_object_ref (self), g_object_unref);
#line 9763 "ui.c"
	}
#line 2002 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = _ ("Saving page %d out of %d");
#line 2002 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = page_number;
#line 2002 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = total;
#line 2002 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = g_strdup_printf (_tmp8_, _tmp9_ + 1, _tmp10_);
#line 2002 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	message = _tmp11_;
#line 2004 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = self->priv->progress_dialog;
#line 2004 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = fraction;
#line 2004 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	progress_bar_dialog_set_fraction (_tmp12_, _tmp13_);
#line 2005 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = self->priv->progress_dialog;
#line 2005 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	progress_bar_dialog_set_message (_tmp14_, message);
#line 1988 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (message);
#line 9787 "ui.c"
}


void user_interface_show_progress_dialog (UserInterface* self) {
	ProgressBarDialog* _tmp0_ = NULL;
#line 2008 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 2010 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 2010 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
#line 9799 "ui.c"
}


void user_interface_hide_progress_dialog (UserInterface* self) {
	ProgressBarDialog* _tmp0_ = NULL;
#line 2013 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 2015 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 2015 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
#line 9811 "ui.c"
}


void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 2018 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 2018 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (error_title != NULL);
#line 2018 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (error_text != NULL);
#line 2020 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->have_error = TRUE;
#line 2021 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = error_title;
#line 2021 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 2021 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->error_title);
#line 2021 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->error_title = _tmp1_;
#line 2022 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = error_text;
#line 2022 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 2022 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->error_text);
#line 2022 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->error_text = _tmp3_;
#line 2023 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = change_scanner_hint;
#line 2023 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->error_change_scanner_hint = _tmp4_;
#line 2024 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_info_bar (self);
#line 9851 "ui.c"
}


void user_interface_start (UserInterface* self) {
#line 2027 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 2029 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) self, TRUE);
#line 9860 "ui.c"
}


Book* user_interface_get_book (UserInterface* self) {
	Book* result;
	Book* _tmp0_ = NULL;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp0_;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9875 "ui.c"
}


static gpointer _book_ref0 (gpointer self) {
#line 150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self ? book_ref (self) : NULL;
#line 9882 "ui.c"
}


static void user_interface_set_book (UserInterface* self, Book* value) {
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = value;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _book_ref0 (_tmp0_);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_book_unref0 (self->priv->_book);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->_book = _tmp1_;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_notify ((GObject *) self, "book");
#line 9901 "ui.c"
}


Page* user_interface_get_selected_page (UserInterface* self) {
	Page* result;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
#line 155 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp2_;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9922 "ui.c"
}


void user_interface_set_selected_page (UserInterface* self, Page* value) {
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 161 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = value;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_view_set_selected_page (_tmp0_, _tmp1_);
#line 159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_notify ((GObject *) self, "selected-page");
#line 9939 "ui.c"
}


const gchar* user_interface_get_default_file_name (UserInterface* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->_default_file_name;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp0_;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9954 "ui.c"
}


void user_interface_set_default_file_name (UserInterface* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = value;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->_default_file_name);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->_default_file_name = _tmp1_;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_notify ((GObject *) self, "default-file-name");
#line 9973 "ui.c"
}


gboolean user_interface_get_scanning (UserInterface* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 180 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->scanning_;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp0_;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9988 "ui.c"
}


void user_interface_set_scanning (UserInterface* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	GtkMenuItem* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkMenuItem* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkToolButton* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GtkButton* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GtkButton* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 183 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = value;
#line 183 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->scanning_ = _tmp0_;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->page_delete_menuitem;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = value;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, !_tmp2_);
#line 185 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->stop_scan_menuitem;
#line 185 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = value;
#line 185 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp4_);
#line 186 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = self->priv->stop_toolbutton;
#line 186 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = value;
#line 186 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp6_);
#line 187 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = self->priv->scan_button;
#line 187 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = value;
#line 187 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, !_tmp8_);
#line 188 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->stop_button;
#line 188 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = value;
#line 188 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, _tmp10_);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_notify ((GObject *) self, "scanning");
#line 10042 "ui.c"
}


gint user_interface_get_brightness (UserInterface* self) {
	gint result;
	GtkAdjustment* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->brightness_adjustment;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = (gint) _tmp2_;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 10063 "ui.c"
}


void user_interface_set_brightness (UserInterface* self, gint value) {
	GtkAdjustment* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 201 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->brightness_adjustment;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = value;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 201 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_notify ((GObject *) self, "brightness");
#line 10080 "ui.c"
}


gint user_interface_get_contrast (UserInterface* self) {
	gint result;
	GtkAdjustment* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
#line 206 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 206 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->contrast_adjustment;
#line 206 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 206 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 206 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = (gint) _tmp2_;
#line 206 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 10101 "ui.c"
}


void user_interface_set_contrast (UserInterface* self, gint value) {
	GtkAdjustment* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->contrast_adjustment;
#line 207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = value;
#line 207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_notify ((GObject *) self, "contrast");
#line 10118 "ui.c"
}


gint user_interface_get_quality (UserInterface* self) {
	gint result;
	GtkAdjustment* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->quality_adjustment;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = (gint) _tmp2_;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 10139 "ui.c"
}


void user_interface_set_quality (UserInterface* self, gint value) {
	GtkAdjustment* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->quality_adjustment;
#line 213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = value;
#line 213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_notify ((GObject *) self, "quality");
#line 10156 "ui.c"
}


gchar* user_interface_get_selected_device (UserInterface* self) {
	gchar* result;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 218 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 222 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->device_combo;
#line 222 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 222 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 222 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 10176 "ui.c"
		gchar* device = NULL;
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 225 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->device_model;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = iter;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &device, -1, -1);
#line 226 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = device;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 10190 "ui.c"
	}
#line 229 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = NULL;
#line 229 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 10196 "ui.c"
}


void user_interface_set_selected_device (UserInterface* self, const gchar* value) {
	GtkTreeIter iter = {0};
	const gchar* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
#line 232 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = value;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = user_interface_find_scan_device (self, _tmp0_, &_tmp1_);
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp2_) {
#line 236 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 10219 "ui.c"
	}
#line 238 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->device_combo;
#line 238 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = iter;
#line 238 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_combo_box_set_active_iter (_tmp3_, &_tmp4_);
#line 239 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->user_selected_device = TRUE;
#line 232 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_notify ((GObject *) self, "selected-device");
#line 10231 "ui.c"
}


static gboolean user_interface_get_shell_shows_menubar (UserInterface* self) {
	gboolean result;
	gboolean shell_shows_menubar = FALSE;
	GtkSettings* _tmp0_ = NULL;
#line 1653 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1656 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = gtk_settings_get_default ();
#line 1656 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_get ((GObject*) _tmp0_, "gtk-shell-shows-menubar", &shell_shows_menubar, NULL);
#line 1657 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = shell_shows_menubar;
#line 1657 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 10249 "ui.c"
}


static gchar* user_interface_get_state_filename (UserInterface* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1858 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1858 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = g_get_user_cache_dir ();
#line 1858 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_build_filename (_tmp0_, "simple-scan", "state", NULL);
#line 1858 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp1_;
#line 1858 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 10267 "ui.c"
}


static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_SCAN_OPTIONS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (n_param_values == 3);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data1 = closure->data;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data2 = param_values->data[0].v_pointer;
#line 10286 "ui.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data1 = param_values->data[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data2 = closure->data;
#line 10292 "ui.c"
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	callback = (GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (marshal_data ? marshal_data : cc->callback);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	callback (data1, g_value_get_string (param_values + 1), value_get_scan_options (param_values + 2), data2);
#line 10298 "ui.c"
}


static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_INT) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (n_param_values == 3);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data1 = closure->data;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data2 = param_values->data[0].v_pointer;
#line 10317 "ui.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data1 = param_values->data[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data2 = closure->data;
#line 10323 "ui.c"
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	callback = (GMarshalFunc_VOID__STRING_INT) (marshal_data ? marshal_data : cc->callback);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 10329 "ui.c"
}


static void user_interface_class_init (UserInterfaceClass * klass) {
	gint UserInterface_private_offset;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_type_class_add_private (klass, sizeof (UserInterfacePrivate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_user_interface_get_property;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_user_interface_set_property;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_OBJECT_CLASS (klass)->finalize = user_interface_finalize;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_INTERFACE_BOOK, param_spec_book ("book", "book", "book", TYPE_BOOK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_INTERFACE_SELECTED_PAGE, param_spec_page ("selected-page", "selected-page", "selected-page", TYPE_PAGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_INTERFACE_DEFAULT_FILE_NAME, g_param_spec_string ("default-file-name", "default-file-name", "default-file-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_INTERFACE_SCANNING, g_param_spec_boolean ("scanning", "scanning", "scanning", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_INTERFACE_BRIGHTNESS, g_param_spec_int ("brightness", "brightness", "brightness", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_INTERFACE_CONTRAST, g_param_spec_int ("contrast", "contrast", "contrast", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_INTERFACE_QUALITY, g_param_spec_int ("quality", "quality", "quality", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_INTERFACE_SELECTED_DEVICE, g_param_spec_string ("selected-device", "selected-device", "selected-device", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	UserInterface_private_offset = g_type_class_get_instance_private_offset (klass);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/SimpleScan/simple-scan.ui");
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_new ("start_scan", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_SCAN_OPTIONS);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_new ("stop_scan", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_new ("email", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_INT);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menubar", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, menubar));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toolbar", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, toolbar));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_menu", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, page_menu));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_vbox", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, main_vbox));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_crop_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, custom_crop_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "a4_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, a4_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "a5_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, a5_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "a6_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, a6_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "letter_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, letter_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "legal_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, legal_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "four_by_six_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, four_by_six_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "no_crop_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, no_crop_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_move_left_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, page_move_left_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_move_right_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, page_move_right_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_delete_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, page_delete_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "crop_rotate_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, crop_rotate_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "save_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, save_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "save_as_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, save_as_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "copy_to_clipboard_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, copy_to_clipboard_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "save_button", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, save_button));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "save_toolbutton", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, save_toolbutton));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stop_scan_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, stop_scan_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stop_toolbutton", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, stop_toolbutton));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "crop_button", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, crop_button));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "crop_toolbutton", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, crop_toolbutton));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stop_button", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, stop_button));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scan_button", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, scan_button));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_button_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, text_button_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, text_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "photo_button_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, photo_button_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "photo_menuitem", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, photo_menuitem));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "authorize_dialog", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, authorize_dialog));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "authorize_label", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, authorize_label));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "username_entry", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, username_entry));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "password_entry", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, password_entry));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preferences_dialog", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, preferences_dialog));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "device_combo", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, device_combo));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_dpi_combo", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, text_dpi_combo));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "photo_dpi_combo", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, photo_dpi_combo));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_side_combo", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, page_side_combo));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "paper_size_combo", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, paper_size_combo));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "brightness_scale", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, brightness_scale));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contrast_scale", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, contrast_scale));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "quality_scale", FALSE, UserInterface_private_offset + G_STRUCT_OFFSET (UserInterfacePrivate, quality_scale));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "device_combo_changed_cb", G_CALLBACK(_user_interface_device_combo_changed_cb_gtk_combo_box_changed));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "new_button_clicked_cb", G_CALLBACK(_user_interface_new_button_clicked_cb_gtk_button_clicked));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "text_menuitem_toggled_cb", G_CALLBACK(_user_interface_text_menuitem_toggled_cb_gtk_check_menu_item_toggled));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "photo_menuitem_toggled_cb", G_CALLBACK(_user_interface_photo_menuitem_toggled_cb_gtk_check_menu_item_toggled));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scan_button_clicked_cb", G_CALLBACK(_user_interface_scan_button_clicked_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "stop_scan_button_clicked_cb", G_CALLBACK(_user_interface_stop_scan_button_clicked_cb_gtk_button_clicked));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "continuous_scan_button_clicked_cb", G_CALLBACK(_user_interface_continuous_scan_button_clicked_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "preferences_button_clicked_cb", G_CALLBACK(_user_interface_preferences_button_clicked_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "preferences_dialog_delete_event_cb", G_CALLBACK(_user_interface_preferences_dialog_delete_event_cb_gtk_widget_delete_event));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "preferences_dialog_response_cb", G_CALLBACK(_user_interface_preferences_dialog_response_cb_gtk_dialog_response));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "rotate_left_button_clicked_cb", G_CALLBACK(_user_interface_rotate_left_button_clicked_cb_gtk_button_clicked));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "rotate_right_button_clicked_cb", G_CALLBACK(_user_interface_rotate_right_button_clicked_cb_gtk_button_clicked));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "no_crop_menuitem_toggled_cb", G_CALLBACK(_user_interface_no_crop_menuitem_toggled_cb_gtk_check_menu_item_toggled));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "custom_crop_menuitem_toggled_cb", G_CALLBACK(_user_interface_custom_crop_menuitem_toggled_cb_gtk_check_menu_item_toggled));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "crop_button_toggled_cb", G_CALLBACK(_user_interface_crop_button_toggled_cb_gtk_toggle_button_toggled));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "crop_toolbutton_toggled_cb", G_CALLBACK(_user_interface_crop_toolbutton_toggled_cb_gtk_toggle_tool_button_toggled));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "four_by_six_menuitem_toggled_cb", G_CALLBACK(_user_interface_four_by_six_menuitem_toggled_cb_gtk_check_menu_item_toggled));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "legal_menuitem_toggled_cb", G_CALLBACK(_user_interface_legal_menuitem_toggled_cb_gtk_check_menu_item_toggled));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "letter_menuitem_toggled_cb", G_CALLBACK(_user_interface_letter_menuitem_toggled_cb_gtk_check_menu_item_toggled));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "a6_menuitem_toggled_cb", G_CALLBACK(_user_interface_a6_menuitem_toggled_cb_gtk_check_menu_item_toggled));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "a5_menuitem_toggled_cb", G_CALLBACK(_user_interface_a5_menuitem_toggled_cb_gtk_check_menu_item_toggled));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "a4_menuitem_toggled_cb", G_CALLBACK(_user_interface_a4_menuitem_toggled_cb_gtk_check_menu_item_toggled));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "crop_rotate_menuitem_activate_cb", G_CALLBACK(_user_interface_crop_rotate_menuitem_activate_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "page_move_left_menuitem_activate_cb", G_CALLBACK(_user_interface_page_move_left_menuitem_activate_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "page_move_right_menuitem_activate_cb", G_CALLBACK(_user_interface_page_move_right_menuitem_activate_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "page_delete_menuitem_activate_cb", G_CALLBACK(_user_interface_page_delete_menuitem_activate_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "reorder_menuitem_activate_cb", G_CALLBACK(_user_interface_reorder_menuitem_activate_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "save_file_button_clicked_cb", G_CALLBACK(_user_interface_save_file_button_clicked_cb_gtk_button_clicked));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "copy_to_clipboard_button_clicked_cb", G_CALLBACK(_user_interface_copy_to_clipboard_button_clicked_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "save_as_file_button_clicked_cb", G_CALLBACK(_user_interface_save_as_file_button_clicked_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "email_button_clicked_cb", G_CALLBACK(_user_interface_email_button_clicked_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "print_button_clicked_cb", G_CALLBACK(_user_interface_print_button_clicked_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "help_contents_menuitem_activate_cb", G_CALLBACK(_user_interface_help_contents_menuitem_activate_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "about_menuitem_activate_cb", G_CALLBACK(_user_interface_about_menuitem_activate_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "quit_menuitem_activate_cb", G_CALLBACK(_user_interface_quit_menuitem_activate_cb_gtk_menu_item_activate));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "simple_scan_window_configure_event_cb", G_CALLBACK(_user_interface_simple_scan_window_configure_event_cb_gtk_widget_configure_event));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "simple_scan_window_window_state_event_cb", G_CALLBACK(_user_interface_simple_scan_window_window_state_event_cb_gtk_widget_window_state_event));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "window_delete_event_cb", G_CALLBACK(_user_interface_window_delete_event_cb_gtk_widget_delete_event));
#line 10535 "ui.c"
}


static void user_interface_instance_init (UserInterface * self) {
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv = USER_INTERFACE_GET_PRIVATE (self);
#line 151 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->book_uri = NULL;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = g_strdup ("photo");
#line 174 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->document_hint = _tmp0_;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _ ("Scanned Document.pdf");
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->_default_file_name = _tmp2_;
#line 177 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->scanning_ = FALSE;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 10561 "ui.c"
}


static void user_interface_finalize (GObject* obj) {
	UserInterface * self;
	Book* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Book* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Book* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_INTERFACE, UserInterface);
#line 274 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 274 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp1_, NULL, FALSE);
#line 274 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _user_interface_page_added_cb_book_page_added, self);
#line 275 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->_book;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("reordered", TYPE_BOOK, &_tmp3_, NULL, FALSE);
#line 275 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _user_interface_reordered_cb_book_reordered, self);
#line 276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->_book;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp5_, NULL, FALSE);
#line 276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _user_interface_page_removed_cb_book_page_removed, self);
#line 33 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->settings);
#line 36 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->menubar);
#line 38 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->toolbar);
#line 40 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_menu);
#line 42 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->main_vbox);
#line 43 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 44 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_image);
#line 45 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 46 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_close_button);
#line 47 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
#line 49 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->custom_crop_menuitem);
#line 51 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->a4_menuitem);
#line 53 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->a5_menuitem);
#line 55 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->a6_menuitem);
#line 57 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->letter_menuitem);
#line 59 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->legal_menuitem);
#line 61 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->four_by_six_menuitem);
#line 63 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->no_crop_menuitem);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_left_menuitem);
#line 67 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_right_menuitem);
#line 69 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_delete_menuitem);
#line 71 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
#line 73 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_menuitem);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_as_menuitem);
#line 77 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->copy_to_clipboard_menuitem);
#line 79 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_button);
#line 81 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_toolbutton);
#line 83 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->stop_scan_menuitem);
#line 85 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->stop_toolbutton);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->crop_button);
#line 89 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->crop_toolbutton);
#line 91 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->stop_button);
#line 93 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->scan_button);
#line 96 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_button_menuitem);
#line 98 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_menuitem);
#line 100 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_button_menuitem);
#line 102 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_menuitem);
#line 105 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_dialog);
#line 107 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_label);
#line 109 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 111 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 116 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->device_combo);
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_combo);
#line 120 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_combo);
#line 122 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_combo);
#line 124 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_combo);
#line 126 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_scale);
#line 128 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_scale);
#line 130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->quality_scale);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->device_model);
#line 132 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_model);
#line 133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_model);
#line 134 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_model);
#line 135 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_model);
#line 136 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_adjustment);
#line 137 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_adjustment);
#line 138 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->quality_adjustment);
#line 142 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 143 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 146 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->error_title);
#line 147 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->error_text);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_book_unref0 (self->priv->_book);
#line 151 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 165 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_autosave_manager_unref0 (self->priv->autosave_manager);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->book_view);
#line 174 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->document_hint);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->_default_file_name);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_OBJECT_CLASS (user_interface_parent_class)->finalize (obj);
#line 10731 "ui.c"
}


GType user_interface_get_type (void) {
	static volatile gsize user_interface_type_id__volatile = 0;
	if (g_once_init_enter (&user_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserInterface), 0, (GInstanceInitFunc) user_interface_instance_init, NULL };
		GType user_interface_type_id;
		user_interface_type_id = g_type_register_static (GTK_TYPE_APPLICATION_WINDOW, "UserInterface", &g_define_type_info, 0);
		g_once_init_leave (&user_interface_type_id__volatile, user_interface_type_id);
	}
	return user_interface_type_id__volatile;
}


static void _vala_user_interface_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UserInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_INTERFACE, UserInterface);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	switch (property_id) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_BOOK:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		value_set_book (value, user_interface_get_book (self));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_SELECTED_PAGE:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		value_set_page (value, user_interface_get_selected_page (self));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_DEFAULT_FILE_NAME:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_value_set_string (value, user_interface_get_default_file_name (self));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_SCANNING:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_value_set_boolean (value, user_interface_get_scanning (self));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_BRIGHTNESS:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_value_set_int (value, user_interface_get_brightness (self));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_CONTRAST:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_value_set_int (value, user_interface_get_contrast (self));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_QUALITY:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_value_set_int (value, user_interface_get_quality (self));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_SELECTED_DEVICE:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_value_take_string (value, user_interface_get_selected_device (self));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 10800 "ui.c"
		default:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 10806 "ui.c"
	}
}


static void _vala_user_interface_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UserInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_INTERFACE, UserInterface);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	switch (property_id) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_BOOK:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_book (self, value_get_book (value));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_SELECTED_PAGE:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_selected_page (self, value_get_page (value));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_DEFAULT_FILE_NAME:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_default_file_name (self, g_value_get_string (value));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_SCANNING:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_scanning (self, g_value_get_boolean (value));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_BRIGHTNESS:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_brightness (self, g_value_get_int (value));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_CONTRAST:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_contrast (self, g_value_get_int (value));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_QUALITY:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_quality (self, g_value_get_int (value));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case USER_INTERFACE_SELECTED_DEVICE:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_selected_device (self, g_value_get_string (value));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 10864 "ui.c"
		default:
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 10870 "ui.c"
	}
}


ProgressBarDialog* progress_bar_dialog_construct (GType object_type, GtkApplicationWindow* parent, const gchar* title) {
	ProgressBarDialog * self = NULL;
	GtkProgressBar* _tmp0_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp1_ = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp2_ = NULL;
	GtkProgressBar* _tmp3_ = NULL;
	GtkProgressBar* _tmp4_ = NULL;
	GtkProgressBar* _tmp5_ = NULL;
	GtkProgressBar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkApplicationWindow* _tmp8_ = NULL;
	GtkProgressBar* _tmp9_ = NULL;
#line 2049 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 2049 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 2049 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = (ProgressBarDialog*) g_object_new (object_type, NULL);
#line 2051 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = (GtkProgressBar*) gtk_progress_bar_new ();
#line 2051 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp0_);
#line 2051 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->bar);
#line 2051 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->bar = _tmp0_;
#line 2052 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
#line 2052 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp1_);
#line 2052 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	hbox = _tmp1_;
#line 2053 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
#line 2053 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp2_);
#line 2053 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	vbox = _tmp2_;
#line 2054 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_hexpand ((GtkWidget*) hbox, TRUE);
#line 2056 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->bar;
#line 2056 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_progress_bar_set_text (_tmp3_, "");
#line 2057 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->bar;
#line 2057 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_progress_bar_set_show_text (_tmp4_, TRUE);
#line 2058 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = self->priv->bar;
#line 2058 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp5_, 225, 25);
#line 2059 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 250, 50);
#line 2061 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = self->priv->bar;
#line 2061 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp6_, TRUE, FALSE, (guint) 0);
#line 2062 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (hbox, (GtkWidget*) vbox, TRUE, FALSE, (guint) 0);
#line 2063 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox);
#line 2064 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = title;
#line 2064 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp7_);
#line 2066 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = parent;
#line 2066 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) _tmp8_);
#line 2067 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER_ON_PARENT);
#line 2068 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
#line 2069 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
#line 2071 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) hbox, TRUE);
#line 2072 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) vbox, TRUE);
#line 2073 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->bar;
#line 2073 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, TRUE);
#line 2049 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (vbox);
#line 2049 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (hbox);
#line 2049 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self;
#line 10967 "ui.c"
}


ProgressBarDialog* progress_bar_dialog_new (GtkApplicationWindow* parent, const gchar* title) {
#line 2049 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return progress_bar_dialog_construct (TYPE_PROGRESS_BAR_DIALOG, parent, title);
#line 10974 "ui.c"
}


gdouble progress_bar_dialog_get_fraction (ProgressBarDialog* self) {
	gdouble result;
	GtkProgressBar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
#line 2039 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 2039 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->bar;
#line 2039 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_progress_bar_get_fraction (_tmp0_);
#line 2039 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 2039 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp2_;
#line 2039 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 10995 "ui.c"
}


void progress_bar_dialog_set_fraction (ProgressBarDialog* self, gdouble value) {
	GtkProgressBar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 2040 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 2040 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->bar;
#line 2040 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = value;
#line 2040 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_progress_bar_set_fraction (_tmp0_, _tmp1_);
#line 2040 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_notify ((GObject *) self, "fraction");
#line 11012 "ui.c"
}


const gchar* progress_bar_dialog_get_message (ProgressBarDialog* self) {
	const gchar* result;
	GtkProgressBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 2045 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2045 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->bar;
#line 2045 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_progress_bar_get_text (_tmp0_);
#line 2045 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 2045 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp2_;
#line 2045 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 11033 "ui.c"
}


void progress_bar_dialog_set_message (ProgressBarDialog* self, const gchar* value) {
	GtkProgressBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 2046 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 2046 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->bar;
#line 2046 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = value;
#line 2046 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_progress_bar_set_text (_tmp0_, _tmp1_);
#line 2046 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_notify ((GObject *) self, "message");
#line 11050 "ui.c"
}


static void progress_bar_dialog_class_init (ProgressBarDialogClass * klass) {
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	progress_bar_dialog_parent_class = g_type_class_peek_parent (klass);
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_type_class_add_private (klass, sizeof (ProgressBarDialogPrivate));
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_progress_bar_dialog_get_property;
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_progress_bar_dialog_set_property;
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_OBJECT_CLASS (klass)->finalize = progress_bar_dialog_finalize;
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROGRESS_BAR_DIALOG_FRACTION, g_param_spec_double ("fraction", "fraction", "fraction", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROGRESS_BAR_DIALOG_MESSAGE, g_param_spec_string ("message", "message", "message", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 11069 "ui.c"
}


static void progress_bar_dialog_instance_init (ProgressBarDialog * self) {
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv = PROGRESS_BAR_DIALOG_GET_PRIVATE (self);
#line 11076 "ui.c"
}


static void progress_bar_dialog_finalize (GObject* obj) {
	ProgressBarDialog * self;
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialog);
#line 2035 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->bar);
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_OBJECT_CLASS (progress_bar_dialog_parent_class)->finalize (obj);
#line 11088 "ui.c"
}


GType progress_bar_dialog_get_type (void) {
	static volatile gsize progress_bar_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&progress_bar_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProgressBarDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) progress_bar_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProgressBarDialog), 0, (GInstanceInitFunc) progress_bar_dialog_instance_init, NULL };
		GType progress_bar_dialog_type_id;
		progress_bar_dialog_type_id = g_type_register_static (GTK_TYPE_WINDOW, "ProgressBarDialog", &g_define_type_info, 0);
		g_once_init_leave (&progress_bar_dialog_type_id__volatile, progress_bar_dialog_type_id);
	}
	return progress_bar_dialog_type_id__volatile;
}


static void _vala_progress_bar_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ProgressBarDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialog);
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	switch (property_id) {
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case PROGRESS_BAR_DIALOG_FRACTION:
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_value_set_double (value, progress_bar_dialog_get_fraction (self));
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case PROGRESS_BAR_DIALOG_MESSAGE:
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_value_set_string (value, progress_bar_dialog_get_message (self));
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 11121 "ui.c"
		default:
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 11127 "ui.c"
	}
}


static void _vala_progress_bar_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ProgressBarDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialog);
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	switch (property_id) {
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case PROGRESS_BAR_DIALOG_FRACTION:
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		progress_bar_dialog_set_fraction (self, g_value_get_double (value));
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case PROGRESS_BAR_DIALOG_MESSAGE:
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		progress_bar_dialog_set_message (self, g_value_get_string (value));
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 11149 "ui.c"
		default:
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 2033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 11155 "ui.c"
	}
}


gchar* get_temporary_filename (const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	gchar* filename = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
#line 2078 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 2078 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 2083 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = prefix;
#line 2083 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = extension;
#line 2083 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = g_strdup_printf ("%sXXXXXX.%s", _tmp0_, _tmp1_);
#line 2083 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filename = _tmp2_;
#line 11180 "ui.c"
	{
		gint fd = 0;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 2087 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = filename;
#line 2087 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = g_file_open_tmp (_tmp3_, &_tmp4_, &_inner_error_);
#line 2087 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 2087 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		path = _tmp4_;
#line 2087 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		fd = _tmp5_;
#line 2087 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 11199 "ui.c"
			goto __catch26_g_error;
		}
#line 2088 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = fd;
#line 2088 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		close (_tmp6_);
#line 11206 "ui.c"
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 2085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 2085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 2092 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = e;
#line 2092 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = _tmp7_->message;
#line 2092 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_warning ("ui.vala:2092: Error saving email attachment: %s", _tmp8_);
#line 2093 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = NULL;
#line 2093 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 2093 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 2093 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (filename);
#line 2093 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 11234 "ui.c"
	}
	__finally26:
#line 2085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 2085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 2085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (filename);
#line 2085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 2085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return NULL;
#line 11249 "ui.c"
	}
#line 2096 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = path;
#line 2096 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (filename);
#line 2096 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 11257 "ui.c"
}


PageIcon* page_icon_construct (GType object_type, const gchar* text, gdouble r, gdouble g, gdouble b) {
	PageIcon * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
#line 2107 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 2107 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = (PageIcon*) g_object_new (object_type, NULL);
#line 2109 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = text;
#line 2109 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 2109 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->text);
#line 2109 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->text = _tmp1_;
#line 2110 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = r;
#line 2110 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->r = _tmp2_;
#line 2111 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = g;
#line 2111 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->g = _tmp3_;
#line 2112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = b;
#line 2112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->b = _tmp4_;
#line 2107 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self;
#line 11294 "ui.c"
}


PageIcon* page_icon_new (const gchar* text, gdouble r, gdouble g, gdouble b) {
#line 2107 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return page_icon_construct (TYPE_PAGE_ICON, text, r, g, b);
#line 11301 "ui.c"
}


static void page_icon_real_get_preferred_width (GtkWidget* base, gint* minimum_width, gint* natural_width) {
	PageIcon * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
#line 2115 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = (PageIcon*) base;
#line 2117 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_natural_width = PAGE_ICON_MINIMUM_WIDTH;
#line 2117 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_minimum_width = _vala_natural_width;
#line 2115 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (minimum_width) {
#line 2115 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*minimum_width = _vala_minimum_width;
#line 11319 "ui.c"
	}
#line 2115 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (natural_width) {
#line 2115 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*natural_width = _vala_natural_width;
#line 11325 "ui.c"
	}
}


static void page_icon_real_get_preferred_height (GtkWidget* base, gint* minimum_height, gint* natural_height) {
	PageIcon * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	gdouble _tmp0_ = 0.0;
#line 2120 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = (PageIcon*) base;
#line 2122 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = round (PAGE_ICON_MINIMUM_WIDTH * G_SQRT2);
#line 2122 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_natural_height = (gint) _tmp0_;
#line 2122 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_minimum_height = _vala_natural_height;
#line 2120 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (minimum_height) {
#line 2120 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*minimum_height = _vala_minimum_height;
#line 11347 "ui.c"
	}
#line 2120 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (natural_height) {
#line 2120 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*natural_height = _vala_natural_height;
#line 11353 "ui.c"
	}
}


static void page_icon_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum_height, gint* natural_height) {
	PageIcon * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	gint _tmp0_ = 0;
#line 2125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = (PageIcon*) base;
#line 2127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = width;
#line 2127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_natural_height = (gint) (_tmp0_ * G_SQRT2);
#line 2127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_minimum_height = _vala_natural_height;
#line 2125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (minimum_height) {
#line 2125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*minimum_height = _vala_minimum_height;
#line 11375 "ui.c"
	}
#line 2125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (natural_height) {
#line 2125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*natural_height = _vala_natural_height;
#line 11381 "ui.c"
	}
}


static void page_icon_real_get_preferred_width_for_height (GtkWidget* base, gint height, gint* minimum_width, gint* natural_width) {
	PageIcon * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	gint _tmp0_ = 0;
#line 2130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = (PageIcon*) base;
#line 2132 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = height;
#line 2132 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_natural_width = (gint) (_tmp0_ / G_SQRT2);
#line 2132 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_minimum_width = _vala_natural_width;
#line 2130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (minimum_width) {
#line 2130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*minimum_width = _vala_minimum_width;
#line 11403 "ui.c"
	}
#line 2130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (natural_width) {
#line 2130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*natural_width = _vala_natural_width;
#line 11409 "ui.c"
	}
}


static gboolean page_icon_real_draw (GtkWidget* base, cairo_t* c) {
	PageIcon * self;
	gboolean result = FALSE;
	gint w = 0;
	gint _tmp0_ = 0;
	gint h = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	cairo_t* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	cairo_t* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	cairo_t* _tmp16_ = NULL;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	cairo_t* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
	cairo_t* _tmp22_ = NULL;
	cairo_t* _tmp23_ = NULL;
	cairo_text_extents_t extents = {0};
	cairo_t* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	cairo_text_extents_t _tmp26_ = {0};
	cairo_t* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	cairo_text_extents_t _tmp29_ = {0};
	gdouble _tmp30_ = 0.0;
	gint _tmp31_ = 0;
	cairo_text_extents_t _tmp32_ = {0};
	gdouble _tmp33_ = 0.0;
	cairo_t* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
#line 2135 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = (PageIcon*) base;
#line 2135 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 2137 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 2137 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	w = _tmp0_;
#line 2138 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 2138 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	h = _tmp1_;
#line 2139 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = w;
#line 2139 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = h;
#line 2139 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if ((_tmp2_ * G_SQRT2) > ((gdouble) _tmp3_)) {
#line 11470 "ui.c"
		gint _tmp4_ = 0;
		gdouble _tmp5_ = 0.0;
#line 2140 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = h;
#line 2140 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = round (_tmp4_ / G_SQRT2);
#line 2140 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		w = (gint) _tmp5_;
#line 11479 "ui.c"
	} else {
		gint _tmp6_ = 0;
		gdouble _tmp7_ = 0.0;
#line 2142 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = w;
#line 2142 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = round (_tmp6_ * G_SQRT2);
#line 2142 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		h = (gint) _tmp7_;
#line 11489 "ui.c"
	}
#line 2144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = c;
#line 2144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 2144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = w;
#line 2144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 2144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = h;
#line 2144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_translate (_tmp8_, (gdouble) ((_tmp9_ - _tmp10_) / 2), (gdouble) ((_tmp11_ - _tmp12_) / 2));
#line 2146 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = c;
#line 2146 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = w;
#line 2146 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = h;
#line 2146 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_rectangle (_tmp13_, 0.5, 0.5, (gdouble) (_tmp14_ - 1), (gdouble) (_tmp15_ - 1));
#line 2148 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = c;
#line 2148 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = self->priv->r;
#line 2148 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = self->priv->g;
#line 2148 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = self->priv->b;
#line 2148 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_set_source_rgb (_tmp16_, _tmp17_, _tmp18_, _tmp19_);
#line 2149 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = c;
#line 2149 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_fill_preserve (_tmp20_);
#line 2151 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = c;
#line 2151 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_set_line_width (_tmp21_, 1.0);
#line 2152 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = c;
#line 2152 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_set_source_rgb (_tmp22_, 0.0, 0.0, 0.0);
#line 2153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = c;
#line 2153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_stroke (_tmp23_);
#line 2156 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = c;
#line 2156 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = self->priv->text;
#line 2156 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_text_extents (_tmp24_, _tmp25_, &_tmp26_);
#line 2156 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	extents = _tmp26_;
#line 2157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = c;
#line 2157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp28_ = w;
#line 2157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp29_ = extents;
#line 2157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp30_ = _tmp29_.width;
#line 2157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp31_ = h;
#line 2157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp32_ = extents;
#line 2157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp33_ = _tmp32_.height;
#line 2157 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_translate (_tmp27_, ((_tmp28_ - _tmp30_) * 0.5) - 0.5, ((_tmp31_ + _tmp33_) * 0.5) - 0.5);
#line 2158 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp34_ = c;
#line 2158 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp35_ = self->priv->text;
#line 2158 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_show_text (_tmp34_, _tmp35_);
#line 2160 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = TRUE;
#line 2160 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 11571 "ui.c"
}


static void page_icon_class_init (PageIconClass * klass) {
#line 2099 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page_icon_parent_class = g_type_class_peek_parent (klass);
#line 2099 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_type_class_add_private (klass, sizeof (PageIconPrivate));
#line 2099 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	GTK_WIDGET_CLASS (klass)->get_preferred_width = page_icon_real_get_preferred_width;
#line 2099 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	GTK_WIDGET_CLASS (klass)->get_preferred_height = page_icon_real_get_preferred_height;
#line 2099 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	GTK_WIDGET_CLASS (klass)->get_preferred_height_for_width = page_icon_real_get_preferred_height_for_width;
#line 2099 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	GTK_WIDGET_CLASS (klass)->get_preferred_width_for_height = page_icon_real_get_preferred_width_for_height;
#line 2099 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	GTK_WIDGET_CLASS (klass)->draw = page_icon_real_draw;
#line 2099 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_OBJECT_CLASS (klass)->finalize = page_icon_finalize;
#line 11592 "ui.c"
}


static void page_icon_instance_init (PageIcon * self) {
#line 2099 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv = PAGE_ICON_GET_PRIVATE (self);
#line 11599 "ui.c"
}


static void page_icon_finalize (GObject* obj) {
	PageIcon * self;
#line 2099 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_ICON, PageIcon);
#line 2101 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->text);
#line 2099 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_OBJECT_CLASS (page_icon_parent_class)->finalize (obj);
#line 11611 "ui.c"
}


GType page_icon_get_type (void) {
	static volatile gsize page_icon_type_id__volatile = 0;
	if (g_once_init_enter (&page_icon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PageIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PageIcon), 0, (GInstanceInitFunc) page_icon_instance_init, NULL };
		GType page_icon_type_id;
		page_icon_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "PageIcon", &g_define_type_info, 0);
		g_once_init_leave (&page_icon_type_id__volatile, page_icon_type_id);
	}
	return page_icon_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



