/* book-view.c generated by valac 0.40.9, the Vala compiler
 * generated from book-view.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* FIXME: When scrolling, copy existing render sideways?*/
/* FIXME: Only render pages that change and only the part that changed*/


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>


#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;
typedef struct _BookViewPrivate BookViewPrivate;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_PAGE_VIEW (page_view_get_type ())
#define PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_VIEW, PageView))
#define PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_VIEW, PageViewClass))
#define IS_PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_VIEW))
#define IS_PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_VIEW))
#define PAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_VIEW, PageViewClass))

typedef struct _PageView PageView;
typedef struct _PageViewClass PageViewClass;
enum  {
	BOOK_VIEW_0_PROPERTY,
	BOOK_VIEW_BOOK_PROPERTY,
	BOOK_VIEW_SELECTED_PAGE_PROPERTY,
	BOOK_VIEW_X_OFFSET_PROPERTY,
	BOOK_VIEW_NUM_PROPERTIES
};
static GParamSpec* book_view_properties[BOOK_VIEW_NUM_PROPERTIES];
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _page_view_unref0(var) ((var == NULL) ? NULL : (var = (page_view_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
enum  {
	BOOK_VIEW_PAGE_SELECTED_SIGNAL,
	BOOK_VIEW_SHOW_PAGE_SIGNAL,
	BOOK_VIEW_SHOW_MENU_SIGNAL,
	BOOK_VIEW_NUM_SIGNALS
};
static guint book_view_signals[BOOK_VIEW_NUM_SIGNALS] = {0};

struct _BookView {
	GtkBox parent_instance;
	BookViewPrivate * priv;
};

struct _BookViewClass {
	GtkBoxClass parent_class;
};

struct _BookViewPrivate {
	Book* _book;
	GHashTable* page_data;
	gboolean need_layout;
	gboolean laying_out;
	gboolean show_selected_page;
	PageView* selected_page_view;
	GtkWidget* drawing_area;
	GtkScrollbar* scroll;
	GtkAdjustment* adjustment;
	GdkCursorType cursor;
};


static gpointer book_view_parent_class = NULL;

GType book_view_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_book (GValue* value,
                     gpointer v_object);
void value_take_book (GValue* value,
                      gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_page (GValue* value,
                     gpointer v_object);
void value_take_page (GValue* value,
                      gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
gpointer page_view_ref (gpointer instance);
void page_view_unref (gpointer instance);
GParamSpec* param_spec_page_view (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_page_view (GValue* value,
                          gpointer v_object);
void value_take_page_view (GValue* value,
                           gpointer v_object);
gpointer value_get_page_view (const GValue* value);
GType page_view_get_type (void) G_GNUC_CONST;
#define BOOK_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOK_VIEW, BookViewPrivate))
Book* book_view_get_book (BookView* self);
static void book_view_add_cb (BookView* self,
                       Book* book,
                       Page* page);
static void _book_view_add_cb_book_page_added (Book* _sender,
                                        Page* page,
                                        gpointer self);
static void book_view_remove_cb (BookView* self,
                          Book* book,
                          Page* page);
static void _book_view_remove_cb_book_page_removed (Book* _sender,
                                             Page* page,
                                             gpointer self);
static void book_view_reorder_cb (BookView* self,
                           Book* book);
static void _book_view_reorder_cb_book_reordered (Book* _sender,
                                           gpointer self);
static void book_view_clear_cb (BookView* self,
                         Book* book);
static void _book_view_clear_cb_book_cleared (Book* _sender,
                                       gpointer self);
static gboolean book_view_configure_cb (BookView* self,
                                 GtkWidget* widget,
                                 GdkEventConfigure* event);
static gboolean _book_view_configure_cb_gtk_widget_configure_event (GtkWidget* _sender,
                                                             GdkEventConfigure* event,
                                                             gpointer self);
static gboolean book_view_draw_cb (BookView* self,
                            GtkWidget* widget,
                            cairo_t* context);
static gboolean _book_view_draw_cb_gtk_widget_draw (GtkWidget* _sender,
                                             cairo_t* cr,
                                             gpointer self);
static gboolean book_view_motion_cb (BookView* self,
                              GtkWidget* widget,
                              GdkEventMotion* event);
static gboolean _book_view_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                              GdkEventMotion* event,
                                                              gpointer self);
static gboolean book_view_key_cb (BookView* self,
                           GtkWidget* widget,
                           GdkEventKey* event);
static gboolean _book_view_key_cb_gtk_widget_key_press_event (GtkWidget* _sender,
                                                       GdkEventKey* event,
                                                       gpointer self);
static gboolean book_view_button_cb (BookView* self,
                              GtkWidget* widget,
                              GdkEventButton* event);
static gboolean _book_view_button_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                             GdkEventButton* event,
                                                             gpointer self);
static gboolean _book_view_button_cb_gtk_widget_button_release_event (GtkWidget* _sender,
                                                               GdkEventButton* event,
                                                               gpointer self);
static gboolean book_view_focus_cb (BookView* self,
                             GtkWidget* widget,
                             GdkEventFocus* event);
static gboolean _book_view_focus_cb_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                        GdkEventFocus* event,
                                                        gpointer self);
static gboolean _book_view_focus_cb_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                         GdkEventFocus* event,
                                                         gpointer self);
static void book_view_scroll_cb (BookView* self,
                          GtkAdjustment* adjustment);
static void _book_view_scroll_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                        gpointer self);
BookView* book_view_new (Book* book);
BookView* book_view_construct (GType object_type,
                               Book* book);
static void book_view_set_book (BookView* self,
                         Book* value);
guint book_get_n_pages (Book* self);
Page* book_get_page (Book* self,
                     gint page_number);
void book_view_set_selected_page (BookView* self,
                                  Page* value);
static void _page_unref0_ (gpointer var);
static void _page_view_unref0_ (gpointer var);
static PageView* book_view_get_nth_page (BookView* self,
                                  gint n);
static PageView* book_view_get_next_page (BookView* self,
                                   PageView* page);
Page* page_view_get_page (PageView* self);
static PageView* book_view_get_prev_page (BookView* self,
                                   PageView* page);
static void book_view_page_view_changed_cb (BookView* self,
                                     PageView* page);
void book_view_redraw (BookView* self);
static void book_view_page_view_size_changed_cb (BookView* self,
                                          PageView* page);
PageView* page_view_new (Page* page);
PageView* page_view_construct (GType object_type,
                               Page* page);
static void _book_view_page_view_changed_cb_page_view_changed (PageView* _sender,
                                                        gpointer self);
static void _book_view_page_view_size_changed_cb_page_view_size_changed (PageView* _sender,
                                                                  gpointer self);
static void book_view_set_selected_page_view (BookView* self,
                                       PageView* page);
void page_view_set_selected (PageView* self,
                             gboolean value);
static void book_view_show_page_view (BookView* self,
                               PageView* page);
gint page_view_get_x_offset (PageView* self);
gint page_view_get_width (PageView* self);
gint book_view_get_x_offset (BookView* self);
void book_view_set_x_offset (BookView* self,
                             gint value);
static void book_view_select_page_view (BookView* self,
                                 PageView* page);
Page* book_view_get_selected_page (BookView* self);
static void book_view_layout_into (BookView* self,
                            gint width,
                            gint height,
                            gint* book_width,
                            gint* book_height);
gint page_get_dpi (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
void page_view_set_width (PageView* self,
                          gint value);
void page_view_set_height (PageView* self,
                           gint value);
gint page_view_get_height (PageView* self);
void page_view_set_x_offset (PageView* self,
                             gint value);
void page_view_set_y_offset (PageView* self,
                             gint value);
static void book_view_layout (BookView* self);
void page_view_render (PageView* self,
                       cairo_t* context);
gboolean page_view_get_selected (PageView* self);
gint page_view_get_y_offset (PageView* self);
static PageView* book_view_get_page_at (BookView* self,
                                 gint x,
                                 gint y,
                                 gint* x_,
                                 gint* y_);
void page_view_button_press (PageView* self,
                             gint x,
                             gint y);
void page_view_button_release (PageView* self,
                               gint x,
                               gint y);
static void book_view_set_cursor (BookView* self,
                           GdkCursorType cursor);
void page_view_motion (PageView* self,
                       gint x,
                       gint y);
GdkCursorType page_view_get_cursor (PageView* self);
void book_view_select_next_page (BookView* self);
void book_view_select_prev_page (BookView* self);
static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data);
static void book_view_finalize (GObject * obj);
static void _vala_book_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_book_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);


static void
_book_view_add_cb_book_page_added (Book* _sender,
                                   Page* page,
                                   gpointer self)
{
#line 123 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_add_cb ((BookView*) self, _sender, page);
#line 332 "book-view.c"
}


static void
_book_view_remove_cb_book_page_removed (Book* _sender,
                                        Page* page,
                                        gpointer self)
{
#line 124 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_remove_cb ((BookView*) self, _sender, page);
#line 343 "book-view.c"
}


static void
_book_view_reorder_cb_book_reordered (Book* _sender,
                                      gpointer self)
{
#line 125 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_reorder_cb ((BookView*) self, _sender);
#line 353 "book-view.c"
}


static void
_book_view_clear_cb_book_cleared (Book* _sender,
                                  gpointer self)
{
#line 126 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_clear_cb ((BookView*) self, _sender);
#line 363 "book-view.c"
}


static gboolean
_book_view_configure_cb_gtk_widget_configure_event (GtkWidget* _sender,
                                                    GdkEventConfigure* event,
                                                    gpointer self)
{
	gboolean result;
	result = book_view_configure_cb ((BookView*) self, _sender, event);
#line 127 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 376 "book-view.c"
}


static gboolean
_book_view_draw_cb_gtk_widget_draw (GtkWidget* _sender,
                                    cairo_t* cr,
                                    gpointer self)
{
	gboolean result;
	result = book_view_draw_cb ((BookView*) self, _sender, cr);
#line 128 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 389 "book-view.c"
}


static gboolean
_book_view_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                     GdkEventMotion* event,
                                                     gpointer self)
{
	gboolean result;
	result = book_view_motion_cb ((BookView*) self, _sender, event);
#line 129 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 402 "book-view.c"
}


static gboolean
_book_view_key_cb_gtk_widget_key_press_event (GtkWidget* _sender,
                                              GdkEventKey* event,
                                              gpointer self)
{
	gboolean result;
	result = book_view_key_cb ((BookView*) self, _sender, event);
#line 130 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 415 "book-view.c"
}


static gboolean
_book_view_button_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                    GdkEventButton* event,
                                                    gpointer self)
{
	gboolean result;
	result = book_view_button_cb ((BookView*) self, _sender, event);
#line 131 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 428 "book-view.c"
}


static gboolean
_book_view_button_cb_gtk_widget_button_release_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self)
{
	gboolean result;
	result = book_view_button_cb ((BookView*) self, _sender, event);
#line 132 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 441 "book-view.c"
}


static gboolean
_book_view_focus_cb_gtk_widget_focus_in_event (GtkWidget* _sender,
                                               GdkEventFocus* event,
                                               gpointer self)
{
	gboolean result;
	result = book_view_focus_cb ((BookView*) self, _sender, event);
#line 133 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 454 "book-view.c"
}


static gboolean
_book_view_focus_cb_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                GdkEventFocus* event,
                                                gpointer self)
{
	gboolean result;
	result = book_view_focus_cb ((BookView*) self, _sender, event);
#line 134 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 467 "book-view.c"
}


static void
_book_view_scroll_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                   gpointer self)
{
#line 135 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_scroll_cb ((BookView*) self, _sender);
#line 477 "book-view.c"
}


static void
_page_unref0_ (gpointer var)
{
#line 95 "/home/bob/git/simple-scan/src/book-view.vala"
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
#line 486 "book-view.c"
}


static void
_page_view_unref0_ (gpointer var)
{
#line 95 "/home/bob/git/simple-scan/src/book-view.vala"
	(var == NULL) ? NULL : (var = (page_view_unref (var), NULL));
#line 495 "book-view.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 105 "/home/bob/git/simple-scan/src/book-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 504 "book-view.c"
}


BookView*
book_view_construct (GType object_type,
                     Book* book)
{
	BookView * self = NULL;
	Page* _tmp8_;
	Page* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	GtkDrawingArea* _tmp13_;
	GtkWidget* _tmp14_;
	GtkWidget* _tmp15_;
	GtkWidget* _tmp16_;
	GtkWidget* _tmp17_;
	GtkScrollbar* _tmp18_;
	GtkScrollbar* _tmp19_;
	GtkAdjustment* _tmp20_;
	GtkAdjustment* _tmp21_;
	GtkAdjustment* _tmp22_;
	GtkScrollbar* _tmp23_;
	GtkWidget* _tmp24_;
	GtkWidget* _tmp25_;
	GtkWidget* _tmp26_;
	GtkWidget* _tmp27_;
	GtkWidget* _tmp28_;
	GtkWidget* _tmp29_;
	GtkWidget* _tmp30_;
	GtkWidget* _tmp31_;
	GtkAdjustment* _tmp32_;
	GtkWidget* _tmp33_;
#line 74 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (book != NULL, NULL);
#line 76 "/home/bob/git/simple-scan/src/book-view.vala"
	self = (BookView*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
#line 77 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_set_book (self, book);
#line 545 "book-view.c"
	{
		gint i = 0;
#line 80 "/home/bob/git/simple-scan/src/book-view.vala"
		i = 0;
#line 550 "book-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 80 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp0_ = TRUE;
#line 80 "/home/bob/git/simple-scan/src/book-view.vala"
			while (TRUE) {
#line 557 "book-view.c"
				gint _tmp2_;
				guint _tmp3_;
				guint _tmp4_;
				Page* page = NULL;
				gint _tmp5_;
				Page* _tmp6_;
				Page* _tmp7_;
#line 80 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!_tmp0_) {
#line 567 "book-view.c"
					gint _tmp1_;
#line 80 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp1_ = i;
#line 80 "/home/bob/git/simple-scan/src/book-view.vala"
					i = _tmp1_ + 1;
#line 573 "book-view.c"
				}
#line 80 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp0_ = FALSE;
#line 80 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp2_ = i;
#line 80 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp3_ = book_get_n_pages (book);
#line 80 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp4_ = _tmp3_;
#line 80 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!(((guint) _tmp2_) < _tmp4_)) {
#line 80 "/home/bob/git/simple-scan/src/book-view.vala"
					break;
#line 587 "book-view.c"
				}
#line 82 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp5_ = i;
#line 82 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp6_ = book_get_page (book, _tmp5_);
#line 82 "/home/bob/git/simple-scan/src/book-view.vala"
				page = _tmp6_;
#line 83 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp7_ = page;
#line 83 "/home/bob/git/simple-scan/src/book-view.vala"
				book_view_add_cb (self, book, _tmp7_);
#line 80 "/home/bob/git/simple-scan/src/book-view.vala"
				_page_unref0 (page);
#line 601 "book-view.c"
			}
		}
	}
#line 86 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp8_ = book_get_page (book, 0);
#line 86 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp9_ = _tmp8_;
#line 86 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_set_selected_page (self, _tmp9_);
#line 86 "/home/bob/git/simple-scan/src/book-view.vala"
	_page_unref0 (_tmp9_);
#line 89 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (book, "page-added", (GCallback) _book_view_add_cb_book_page_added, self, 0);
#line 90 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (book, "page-removed", (GCallback) _book_view_remove_cb_book_page_removed, self, 0);
#line 91 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (book, "reordered", (GCallback) _book_view_reorder_cb_book_reordered, self, 0);
#line 92 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (book, "cleared", (GCallback) _book_view_clear_cb_book_cleared, self, 0);
#line 94 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->need_layout = TRUE;
#line 95 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp10_ = g_direct_hash;
#line 95 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp11_ = g_direct_equal;
#line 95 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, _page_unref0_, _page_view_unref0_);
#line 95 "/home/bob/git/simple-scan/src/book-view.vala"
	_g_hash_table_unref0 (self->priv->page_data);
#line 95 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->page_data = _tmp12_;
#line 96 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->cursor = GDK_ARROW;
#line 98 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp13_ = (GtkDrawingArea*) gtk_drawing_area_new ();
#line 98 "/home/bob/git/simple-scan/src/book-view.vala"
	g_object_ref_sink (_tmp13_);
#line 98 "/home/bob/git/simple-scan/src/book-view.vala"
	_g_object_unref0 (self->priv->drawing_area);
#line 98 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->drawing_area = (GtkWidget*) _tmp13_;
#line 99 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp14_ = self->priv->drawing_area;
#line 99 "/home/bob/git/simple-scan/src/book-view.vala"
	gtk_widget_set_size_request (_tmp14_, 200, 100);
#line 100 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp15_ = self->priv->drawing_area;
#line 100 "/home/bob/git/simple-scan/src/book-view.vala"
	gtk_widget_set_can_focus (_tmp15_, TRUE);
#line 101 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp16_ = self->priv->drawing_area;
#line 101 "/home/bob/git/simple-scan/src/book-view.vala"
	gtk_widget_set_events (_tmp16_, ((((GDK_POINTER_MOTION_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_FOCUS_CHANGE_MASK) | GDK_STRUCTURE_MASK) | GDK_SCROLL_MASK);
#line 102 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp17_ = self->priv->drawing_area;
#line 102 "/home/bob/git/simple-scan/src/book-view.vala"
	gtk_box_pack_start ((GtkBox*) self, _tmp17_, TRUE, TRUE, (guint) 0);
#line 104 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp18_ = (GtkScrollbar*) gtk_scrollbar_new (GTK_ORIENTATION_HORIZONTAL, NULL);
#line 104 "/home/bob/git/simple-scan/src/book-view.vala"
	g_object_ref_sink (_tmp18_);
#line 104 "/home/bob/git/simple-scan/src/book-view.vala"
	_g_object_unref0 (self->priv->scroll);
#line 104 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->scroll = _tmp18_;
#line 105 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp19_ = self->priv->scroll;
#line 105 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp20_ = gtk_range_get_adjustment ((GtkRange*) _tmp19_);
#line 105 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp21_ = _tmp20_;
#line 105 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp22_ = _g_object_ref0 (_tmp21_);
#line 105 "/home/bob/git/simple-scan/src/book-view.vala"
	_g_object_unref0 (self->priv->adjustment);
#line 105 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->adjustment = _tmp22_;
#line 106 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp23_ = self->priv->scroll;
#line 106 "/home/bob/git/simple-scan/src/book-view.vala"
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp23_, FALSE, TRUE, (guint) 0);
#line 108 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp24_ = self->priv->drawing_area;
#line 108 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (_tmp24_, "configure-event", (GCallback) _book_view_configure_cb_gtk_widget_configure_event, self, 0);
#line 109 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp25_ = self->priv->drawing_area;
#line 109 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (_tmp25_, "draw", (GCallback) _book_view_draw_cb_gtk_widget_draw, self, 0);
#line 110 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp26_ = self->priv->drawing_area;
#line 110 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (_tmp26_, "motion-notify-event", (GCallback) _book_view_motion_cb_gtk_widget_motion_notify_event, self, 0);
#line 111 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp27_ = self->priv->drawing_area;
#line 111 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (_tmp27_, "key-press-event", (GCallback) _book_view_key_cb_gtk_widget_key_press_event, self, 0);
#line 112 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp28_ = self->priv->drawing_area;
#line 112 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (_tmp28_, "button-press-event", (GCallback) _book_view_button_cb_gtk_widget_button_press_event, self, 0);
#line 113 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp29_ = self->priv->drawing_area;
#line 113 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (_tmp29_, "button-release-event", (GCallback) _book_view_button_cb_gtk_widget_button_release_event, self, 0);
#line 114 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp30_ = self->priv->drawing_area;
#line 114 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (_tmp30_, "focus-in-event", (GCallback) _book_view_focus_cb_gtk_widget_focus_in_event, self, G_CONNECT_AFTER);
#line 115 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp31_ = self->priv->drawing_area;
#line 115 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (_tmp31_, "focus-out-event", (GCallback) _book_view_focus_cb_gtk_widget_focus_out_event, self, G_CONNECT_AFTER);
#line 116 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp32_ = self->priv->adjustment;
#line 116 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (_tmp32_, "value-changed", (GCallback) _book_view_scroll_cb_gtk_adjustment_value_changed, self, 0);
#line 118 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp33_ = self->priv->drawing_area;
#line 118 "/home/bob/git/simple-scan/src/book-view.vala"
	gtk_widget_set_visible (_tmp33_, TRUE);
#line 74 "/home/bob/git/simple-scan/src/book-view.vala"
	return self;
#line 725 "book-view.c"
}


BookView*
book_view_new (Book* book)
{
#line 74 "/home/bob/git/simple-scan/src/book-view.vala"
	return book_view_construct (TYPE_BOOK_VIEW, book);
#line 734 "book-view.c"
}


static gpointer
_page_view_ref0 (gpointer self)
{
#line 141 "/home/bob/git/simple-scan/src/book-view.vala"
	return self ? page_view_ref (self) : NULL;
#line 743 "book-view.c"
}


static PageView*
book_view_get_nth_page (BookView* self,
                        gint n)
{
	PageView* result = NULL;
	Page* page = NULL;
	Book* _tmp0_;
	Page* _tmp1_;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_;
	PageView* _tmp4_;
#line 138 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 140 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->_book;
#line 140 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp1_ = book_get_page (_tmp0_, n);
#line 140 "/home/bob/git/simple-scan/src/book-view.vala"
	page = _tmp1_;
#line 141 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp2_ = self->priv->page_data;
#line 141 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp3_ = g_hash_table_lookup (_tmp2_, page);
#line 141 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp4_ = _page_view_ref0 ((PageView*) _tmp3_);
#line 141 "/home/bob/git/simple-scan/src/book-view.vala"
	result = _tmp4_;
#line 141 "/home/bob/git/simple-scan/src/book-view.vala"
	_page_unref0 (page);
#line 141 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 778 "book-view.c"
}


static PageView*
book_view_get_next_page (BookView* self,
                         PageView* page)
{
	PageView* result = NULL;
	PageView* _tmp17_;
#line 144 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 144 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (page != NULL, NULL);
#line 792 "book-view.c"
	{
		gint i = 0;
#line 146 "/home/bob/git/simple-scan/src/book-view.vala"
		i = 0;
#line 797 "book-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 146 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp0_ = TRUE;
#line 146 "/home/bob/git/simple-scan/src/book-view.vala"
			while (TRUE) {
#line 804 "book-view.c"
				Page* p = NULL;
				Book* _tmp2_;
				gint _tmp3_;
				Page* _tmp4_;
				Page* _tmp5_;
				Page* _tmp6_;
				Page* _tmp7_;
				Page* _tmp8_;
#line 146 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!_tmp0_) {
#line 815 "book-view.c"
					gint _tmp1_;
#line 146 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp1_ = i;
#line 146 "/home/bob/git/simple-scan/src/book-view.vala"
					i = _tmp1_ + 1;
#line 821 "book-view.c"
				}
#line 146 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp0_ = FALSE;
#line 148 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp2_ = self->priv->_book;
#line 148 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp3_ = i;
#line 148 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp4_ = book_get_page (_tmp2_, _tmp3_);
#line 148 "/home/bob/git/simple-scan/src/book-view.vala"
				p = _tmp4_;
#line 149 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp5_ = p;
#line 149 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp5_ == NULL) {
#line 150 "/home/bob/git/simple-scan/src/book-view.vala"
					_page_unref0 (p);
#line 150 "/home/bob/git/simple-scan/src/book-view.vala"
					break;
#line 841 "book-view.c"
				}
#line 151 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp6_ = p;
#line 151 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp7_ = page_view_get_page (page);
#line 151 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp8_ = _tmp7_;
#line 151 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp6_ == _tmp8_) {
#line 851 "book-view.c"
					Book* _tmp9_;
					gint _tmp10_;
					Page* _tmp11_;
					Page* _tmp12_;
#line 153 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp9_ = self->priv->_book;
#line 153 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp10_ = i;
#line 153 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp11_ = book_get_page (_tmp9_, _tmp10_ + 1);
#line 153 "/home/bob/git/simple-scan/src/book-view.vala"
					_page_unref0 (p);
#line 153 "/home/bob/git/simple-scan/src/book-view.vala"
					p = _tmp11_;
#line 154 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp12_ = p;
#line 154 "/home/bob/git/simple-scan/src/book-view.vala"
					if (_tmp12_ != NULL) {
#line 870 "book-view.c"
						GHashTable* _tmp13_;
						Page* _tmp14_;
						gconstpointer _tmp15_;
						PageView* _tmp16_;
#line 155 "/home/bob/git/simple-scan/src/book-view.vala"
						_tmp13_ = self->priv->page_data;
#line 155 "/home/bob/git/simple-scan/src/book-view.vala"
						_tmp14_ = p;
#line 155 "/home/bob/git/simple-scan/src/book-view.vala"
						_tmp15_ = g_hash_table_lookup (_tmp13_, _tmp14_);
#line 155 "/home/bob/git/simple-scan/src/book-view.vala"
						_tmp16_ = _page_view_ref0 ((PageView*) _tmp15_);
#line 155 "/home/bob/git/simple-scan/src/book-view.vala"
						result = _tmp16_;
#line 155 "/home/bob/git/simple-scan/src/book-view.vala"
						_page_unref0 (p);
#line 155 "/home/bob/git/simple-scan/src/book-view.vala"
						return result;
#line 889 "book-view.c"
					}
				}
#line 146 "/home/bob/git/simple-scan/src/book-view.vala"
				_page_unref0 (p);
#line 894 "book-view.c"
			}
		}
	}
#line 159 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp17_ = _page_view_ref0 (page);
#line 159 "/home/bob/git/simple-scan/src/book-view.vala"
	result = _tmp17_;
#line 159 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 904 "book-view.c"
}


static PageView*
book_view_get_prev_page (BookView* self,
                         PageView* page)
{
	PageView* result = NULL;
	PageView* prev_page = NULL;
	PageView* _tmp0_;
	PageView* _tmp14_;
#line 162 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 162 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (page != NULL, NULL);
#line 164 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = _page_view_ref0 (page);
#line 164 "/home/bob/git/simple-scan/src/book-view.vala"
	prev_page = _tmp0_;
#line 924 "book-view.c"
	{
		gint i = 0;
#line 165 "/home/bob/git/simple-scan/src/book-view.vala"
		i = 0;
#line 929 "book-view.c"
		{
			gboolean _tmp1_ = FALSE;
#line 165 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp1_ = TRUE;
#line 165 "/home/bob/git/simple-scan/src/book-view.vala"
			while (TRUE) {
#line 936 "book-view.c"
				Page* p = NULL;
				Book* _tmp3_;
				gint _tmp4_;
				Page* _tmp5_;
				Page* _tmp6_;
				Page* _tmp7_;
				Page* _tmp8_;
				Page* _tmp9_;
				GHashTable* _tmp10_;
				Page* _tmp11_;
				gconstpointer _tmp12_;
				PageView* _tmp13_;
#line 165 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!_tmp1_) {
#line 951 "book-view.c"
					gint _tmp2_;
#line 165 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp2_ = i;
#line 165 "/home/bob/git/simple-scan/src/book-view.vala"
					i = _tmp2_ + 1;
#line 957 "book-view.c"
				}
#line 165 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp1_ = FALSE;
#line 167 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp3_ = self->priv->_book;
#line 167 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp4_ = i;
#line 167 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp5_ = book_get_page (_tmp3_, _tmp4_);
#line 167 "/home/bob/git/simple-scan/src/book-view.vala"
				p = _tmp5_;
#line 168 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp6_ = p;
#line 168 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp6_ == NULL) {
#line 169 "/home/bob/git/simple-scan/src/book-view.vala"
					_page_unref0 (p);
#line 169 "/home/bob/git/simple-scan/src/book-view.vala"
					break;
#line 977 "book-view.c"
				}
#line 170 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp7_ = p;
#line 170 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp8_ = page_view_get_page (page);
#line 170 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp9_ = _tmp8_;
#line 170 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp7_ == _tmp9_) {
#line 171 "/home/bob/git/simple-scan/src/book-view.vala"
					result = prev_page;
#line 171 "/home/bob/git/simple-scan/src/book-view.vala"
					_page_unref0 (p);
#line 171 "/home/bob/git/simple-scan/src/book-view.vala"
					return result;
#line 993 "book-view.c"
				}
#line 172 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp10_ = self->priv->page_data;
#line 172 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp11_ = p;
#line 172 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
#line 172 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp13_ = _page_view_ref0 ((PageView*) _tmp12_);
#line 172 "/home/bob/git/simple-scan/src/book-view.vala"
				_page_view_unref0 (prev_page);
#line 172 "/home/bob/git/simple-scan/src/book-view.vala"
				prev_page = _tmp13_;
#line 165 "/home/bob/git/simple-scan/src/book-view.vala"
				_page_unref0 (p);
#line 1009 "book-view.c"
			}
		}
	}
#line 175 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp14_ = _page_view_ref0 (page);
#line 175 "/home/bob/git/simple-scan/src/book-view.vala"
	result = _tmp14_;
#line 175 "/home/bob/git/simple-scan/src/book-view.vala"
	_page_view_unref0 (prev_page);
#line 175 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 1021 "book-view.c"
}


static void
book_view_page_view_changed_cb (BookView* self,
                                PageView* page)
{
#line 178 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 178 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (page != NULL);
#line 180 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_redraw (self);
#line 1035 "book-view.c"
}


static void
book_view_page_view_size_changed_cb (BookView* self,
                                     PageView* page)
{
#line 183 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 183 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (page != NULL);
#line 185 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->need_layout = TRUE;
#line 186 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_redraw (self);
#line 1051 "book-view.c"
}


static void
_book_view_page_view_changed_cb_page_view_changed (PageView* _sender,
                                                   gpointer self)
{
#line 192 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_page_view_changed_cb ((BookView*) self, _sender);
#line 1061 "book-view.c"
}


static void
_book_view_page_view_size_changed_cb_page_view_size_changed (PageView* _sender,
                                                             gpointer self)
{
#line 193 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_page_view_size_changed_cb ((BookView*) self, _sender);
#line 1071 "book-view.c"
}


static gpointer
_page_ref0 (gpointer self)
{
#line 194 "/home/bob/git/simple-scan/src/book-view.vala"
	return self ? page_ref (self) : NULL;
#line 1080 "book-view.c"
}


static void
book_view_add_cb (BookView* self,
                  Book* book,
                  Page* page)
{
	PageView* page_view = NULL;
	PageView* _tmp0_;
	GHashTable* _tmp1_;
	Page* _tmp2_;
	PageView* _tmp3_;
#line 189 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 189 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (book != NULL);
#line 189 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (page != NULL);
#line 191 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = page_view_new (page);
#line 191 "/home/bob/git/simple-scan/src/book-view.vala"
	page_view = _tmp0_;
#line 192 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (page_view, "changed", (GCallback) _book_view_page_view_changed_cb_page_view_changed, self, 0);
#line 193 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_connect_object (page_view, "size-changed", (GCallback) _book_view_page_view_size_changed_cb_page_view_size_changed, self, 0);
#line 194 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp1_ = self->priv->page_data;
#line 194 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp2_ = _page_ref0 (page);
#line 194 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp3_ = _page_view_ref0 (page_view);
#line 194 "/home/bob/git/simple-scan/src/book-view.vala"
	g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
#line 195 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->need_layout = TRUE;
#line 196 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_redraw (self);
#line 189 "/home/bob/git/simple-scan/src/book-view.vala"
	_page_view_unref0 (page_view);
#line 1122 "book-view.c"
}


static void
book_view_set_selected_page_view (BookView* self,
                                  PageView* page)
{
	gboolean _tmp0_ = FALSE;
	PageView* _tmp1_;
	PageView* _tmp4_;
	PageView* _tmp5_;
	GtkWidget* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
#line 199 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 202 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp1_ = self->priv->selected_page_view;
#line 202 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp1_ != NULL) {
#line 1143 "book-view.c"
		PageView* _tmp2_;
#line 202 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp2_ = self->priv->selected_page_view;
#line 202 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp0_ = page != _tmp2_;
#line 1149 "book-view.c"
	} else {
#line 202 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp0_ = FALSE;
#line 1153 "book-view.c"
	}
#line 202 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp0_) {
#line 1157 "book-view.c"
		PageView* _tmp3_;
#line 203 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp3_ = self->priv->selected_page_view;
#line 203 "/home/bob/git/simple-scan/src/book-view.vala"
		page_view_set_selected (_tmp3_, TRUE);
#line 1163 "book-view.c"
	}
#line 205 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp4_ = _page_view_ref0 (page);
#line 205 "/home/bob/git/simple-scan/src/book-view.vala"
	_page_view_unref0 (self->priv->selected_page_view);
#line 205 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->selected_page_view = _tmp4_;
#line 206 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp5_ = self->priv->selected_page_view;
#line 206 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp5_ == NULL) {
#line 207 "/home/bob/git/simple-scan/src/book-view.vala"
		return;
#line 1177 "book-view.c"
	}
#line 210 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp6_ = self->priv->drawing_area;
#line 210 "/home/bob/git/simple-scan/src/book-view.vala"
	g_object_get (_tmp6_, "has-focus", &_tmp7_, NULL);
#line 210 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp8_ = _tmp7_;
#line 210 "/home/bob/git/simple-scan/src/book-view.vala"
	if (!_tmp8_) {
#line 1187 "book-view.c"
		PageView* _tmp9_;
#line 211 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp9_ = self->priv->selected_page_view;
#line 211 "/home/bob/git/simple-scan/src/book-view.vala"
		page_view_set_selected (_tmp9_, FALSE);
#line 1193 "book-view.c"
	} else {
		PageView* _tmp10_;
#line 213 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp10_ = self->priv->selected_page_view;
#line 213 "/home/bob/git/simple-scan/src/book-view.vala"
		page_view_set_selected (_tmp10_, TRUE);
#line 1200 "book-view.c"
	}
}


static void
book_view_show_page_view (BookView* self,
                          PageView* page)
{
	gboolean _tmp0_ = FALSE;
	GtkAllocation allocation = {0};
	GtkWidget* _tmp2_;
	GtkAllocation _tmp3_ = {0};
	gint left_edge = 0;
	gint _tmp4_;
	gint _tmp5_;
	gint right_edge = 0;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
#line 216 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 218 "/home/bob/git/simple-scan/src/book-view.vala"
	if (page == NULL) {
#line 218 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp0_ = TRUE;
#line 1230 "book-view.c"
	} else {
		GtkScrollbar* _tmp1_;
#line 218 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp1_ = self->priv->scroll;
#line 218 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp0_ = !gtk_widget_get_visible ((GtkWidget*) _tmp1_);
#line 1237 "book-view.c"
	}
#line 218 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp0_) {
#line 219 "/home/bob/git/simple-scan/src/book-view.vala"
		return;
#line 1243 "book-view.c"
	}
#line 222 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp2_ = self->priv->drawing_area;
#line 222 "/home/bob/git/simple-scan/src/book-view.vala"
	gtk_widget_get_allocation (_tmp2_, &_tmp3_);
#line 222 "/home/bob/git/simple-scan/src/book-view.vala"
	allocation = _tmp3_;
#line 223 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp4_ = page_view_get_x_offset (page);
#line 223 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp5_ = _tmp4_;
#line 223 "/home/bob/git/simple-scan/src/book-view.vala"
	left_edge = _tmp5_;
#line 224 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp6_ = page_view_get_x_offset (page);
#line 224 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp7_ = _tmp6_;
#line 224 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp8_ = page_view_get_width (page);
#line 224 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp9_ = _tmp8_;
#line 224 "/home/bob/git/simple-scan/src/book-view.vala"
	right_edge = _tmp7_ + _tmp9_;
#line 226 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp10_ = left_edge;
#line 226 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp11_ = book_view_get_x_offset (self);
#line 226 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp12_ = _tmp11_;
#line 226 "/home/bob/git/simple-scan/src/book-view.vala"
	if ((_tmp10_ - _tmp12_) < 0) {
#line 1275 "book-view.c"
		gint _tmp13_;
#line 227 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp13_ = left_edge;
#line 227 "/home/bob/git/simple-scan/src/book-view.vala"
		book_view_set_x_offset (self, _tmp13_);
#line 1281 "book-view.c"
	} else {
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		GtkAllocation _tmp17_;
		gint _tmp18_;
#line 228 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp14_ = right_edge;
#line 228 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp15_ = book_view_get_x_offset (self);
#line 228 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp16_ = _tmp15_;
#line 228 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp17_ = allocation;
#line 228 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp18_ = _tmp17_.width;
#line 228 "/home/bob/git/simple-scan/src/book-view.vala"
		if ((_tmp14_ - _tmp16_) > _tmp18_) {
#line 1300 "book-view.c"
			gint _tmp19_;
			GtkAllocation _tmp20_;
			gint _tmp21_;
#line 229 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp19_ = right_edge;
#line 229 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp20_ = allocation;
#line 229 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp21_ = _tmp20_.width;
#line 229 "/home/bob/git/simple-scan/src/book-view.vala"
			book_view_set_x_offset (self, _tmp19_ - _tmp21_);
#line 1312 "book-view.c"
		}
	}
}


static void
book_view_select_page_view (BookView* self,
                            PageView* page)
{
	Page* p = NULL;
	PageView* _tmp0_;
	gboolean _tmp1_;
	Page* _tmp5_;
#line 232 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 234 "/home/bob/git/simple-scan/src/book-view.vala"
	p = NULL;
#line 236 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->selected_page_view;
#line 236 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp0_ == page) {
#line 237 "/home/bob/git/simple-scan/src/book-view.vala"
		_page_unref0 (p);
#line 237 "/home/bob/git/simple-scan/src/book-view.vala"
		return;
#line 1338 "book-view.c"
	}
#line 239 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_set_selected_page_view (self, page);
#line 241 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp1_ = self->priv->need_layout;
#line 241 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp1_) {
#line 242 "/home/bob/git/simple-scan/src/book-view.vala"
		self->priv->show_selected_page = TRUE;
#line 1348 "book-view.c"
	} else {
#line 244 "/home/bob/git/simple-scan/src/book-view.vala"
		book_view_show_page_view (self, page);
#line 1352 "book-view.c"
	}
#line 246 "/home/bob/git/simple-scan/src/book-view.vala"
	if (page != NULL) {
#line 1356 "book-view.c"
		Page* _tmp2_;
		Page* _tmp3_;
		Page* _tmp4_;
#line 247 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp2_ = page_view_get_page (page);
#line 247 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp3_ = _tmp2_;
#line 247 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp4_ = _page_ref0 (_tmp3_);
#line 247 "/home/bob/git/simple-scan/src/book-view.vala"
		_page_unref0 (p);
#line 247 "/home/bob/git/simple-scan/src/book-view.vala"
		p = _tmp4_;
#line 1370 "book-view.c"
	}
#line 248 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp5_ = p;
#line 248 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_emit (self, book_view_signals[BOOK_VIEW_PAGE_SELECTED_SIGNAL], 0, _tmp5_);
#line 232 "/home/bob/git/simple-scan/src/book-view.vala"
	_page_unref0 (p);
#line 1378 "book-view.c"
}


static void
book_view_remove_cb (BookView* self,
                     Book* book,
                     Page* page)
{
	PageView* new_selection = NULL;
	PageView* _tmp0_;
	PageView* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	PageView* page_view = NULL;
	GHashTable* _tmp10_;
	gconstpointer _tmp11_;
	PageView* _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	GHashTable* _tmp15_;
	PageView* _tmp16_;
#line 251 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 251 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (book != NULL);
#line 251 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (page != NULL);
#line 253 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->selected_page_view;
#line 253 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp1_ = _page_view_ref0 (_tmp0_);
#line 253 "/home/bob/git/simple-scan/src/book-view.vala"
	new_selection = _tmp1_;
#line 256 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp2_ = book_view_get_selected_page (self);
#line 256 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp3_ = _tmp2_;
#line 256 "/home/bob/git/simple-scan/src/book-view.vala"
	if (page == _tmp3_) {
#line 1418 "book-view.c"
		PageView* _tmp4_;
		PageView* _tmp5_;
		PageView* _tmp6_;
		PageView* _tmp7_;
#line 258 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp4_ = self->priv->selected_page_view;
#line 258 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp5_ = book_view_get_prev_page (self, _tmp4_);
#line 258 "/home/bob/git/simple-scan/src/book-view.vala"
		_page_view_unref0 (new_selection);
#line 258 "/home/bob/git/simple-scan/src/book-view.vala"
		new_selection = _tmp5_;
#line 259 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp6_ = new_selection;
#line 259 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp7_ = self->priv->selected_page_view;
#line 259 "/home/bob/git/simple-scan/src/book-view.vala"
		if (_tmp6_ == _tmp7_) {
#line 1437 "book-view.c"
			PageView* _tmp8_;
			PageView* _tmp9_;
#line 260 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp8_ = self->priv->selected_page_view;
#line 260 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp9_ = book_view_get_next_page (self, _tmp8_);
#line 260 "/home/bob/git/simple-scan/src/book-view.vala"
			_page_view_unref0 (new_selection);
#line 260 "/home/bob/git/simple-scan/src/book-view.vala"
			new_selection = _tmp9_;
#line 1448 "book-view.c"
		}
#line 261 "/home/bob/git/simple-scan/src/book-view.vala"
		_page_view_unref0 (self->priv->selected_page_view);
#line 261 "/home/bob/git/simple-scan/src/book-view.vala"
		self->priv->selected_page_view = NULL;
#line 1454 "book-view.c"
	}
#line 264 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp10_ = self->priv->page_data;
#line 264 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp11_ = g_hash_table_lookup (_tmp10_, page);
#line 264 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp12_ = _page_view_ref0 ((PageView*) _tmp11_);
#line 264 "/home/bob/git/simple-scan/src/book-view.vala"
	page_view = _tmp12_;
#line 265 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("changed", TYPE_PAGE_VIEW, &_tmp13_, NULL, FALSE);
#line 265 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (page_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _book_view_page_view_changed_cb_page_view_changed, self);
#line 266 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("size-changed", TYPE_PAGE_VIEW, &_tmp14_, NULL, FALSE);
#line 266 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (page_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _book_view_page_view_size_changed_cb_page_view_size_changed, self);
#line 267 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp15_ = self->priv->page_data;
#line 267 "/home/bob/git/simple-scan/src/book-view.vala"
	g_hash_table_remove (_tmp15_, page);
#line 269 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp16_ = new_selection;
#line 269 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_select_page_view (self, _tmp16_);
#line 271 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->need_layout = TRUE;
#line 272 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_redraw (self);
#line 251 "/home/bob/git/simple-scan/src/book-view.vala"
	_page_view_unref0 (page_view);
#line 251 "/home/bob/git/simple-scan/src/book-view.vala"
	_page_view_unref0 (new_selection);
#line 1488 "book-view.c"
}


static void
book_view_reorder_cb (BookView* self,
                      Book* book)
{
#line 275 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 275 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (book != NULL);
#line 277 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->need_layout = TRUE;
#line 278 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_redraw (self);
#line 1504 "book-view.c"
}


static void
book_view_clear_cb (BookView* self,
                    Book* book)
{
	GHashTable* _tmp0_;
#line 281 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 281 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (book != NULL);
#line 283 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->page_data;
#line 283 "/home/bob/git/simple-scan/src/book-view.vala"
	g_hash_table_remove_all (_tmp0_);
#line 284 "/home/bob/git/simple-scan/src/book-view.vala"
	_page_view_unref0 (self->priv->selected_page_view);
#line 284 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->selected_page_view = NULL;
#line 285 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_emit (self, book_view_signals[BOOK_VIEW_PAGE_SELECTED_SIGNAL], 0, NULL);
#line 286 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->need_layout = TRUE;
#line 287 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_redraw (self);
#line 1531 "book-view.c"
}


static gboolean
book_view_configure_cb (BookView* self,
                        GtkWidget* widget,
                        GdkEventConfigure* event)
{
	gboolean result = FALSE;
#line 290 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 290 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 290 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 292 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->need_layout = TRUE;
#line 293 "/home/bob/git/simple-scan/src/book-view.vala"
	result = FALSE;
#line 293 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 1553 "book-view.c"
}


static void
book_view_layout_into (BookView* self,
                       gint width,
                       gint height,
                       gint* book_width,
                       gint* book_height)
{
	gint _vala_book_width = 0;
	gint _vala_book_height = 0;
	gint max_dpi = 0;
	gint max_width = 0;
	gint max_height = 0;
	gdouble aspect = 0.0;
	gdouble max_aspect = 0.0;
	gint _tmp47_;
	gint _tmp48_;
	gint spacing = 0;
	gint x_offset = 0;
#line 296 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 299 "/home/bob/git/simple-scan/src/book-view.vala"
	max_dpi = 0;
#line 1579 "book-view.c"
	{
		gint i = 0;
#line 300 "/home/bob/git/simple-scan/src/book-view.vala"
		i = 0;
#line 1584 "book-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 300 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp0_ = TRUE;
#line 300 "/home/bob/git/simple-scan/src/book-view.vala"
			while (TRUE) {
#line 1591 "book-view.c"
				gint _tmp2_;
				Book* _tmp3_;
				guint _tmp4_;
				guint _tmp5_;
				Page* page = NULL;
				Book* _tmp6_;
				gint _tmp7_;
				Page* _tmp8_;
				Page* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
#line 300 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!_tmp0_) {
#line 1606 "book-view.c"
					gint _tmp1_;
#line 300 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp1_ = i;
#line 300 "/home/bob/git/simple-scan/src/book-view.vala"
					i = _tmp1_ + 1;
#line 1612 "book-view.c"
				}
#line 300 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp0_ = FALSE;
#line 300 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp2_ = i;
#line 300 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp3_ = self->priv->_book;
#line 300 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp4_ = book_get_n_pages (_tmp3_);
#line 300 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp5_ = _tmp4_;
#line 300 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!(((guint) _tmp2_) < _tmp5_)) {
#line 300 "/home/bob/git/simple-scan/src/book-view.vala"
					break;
#line 1628 "book-view.c"
				}
#line 302 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp6_ = self->priv->_book;
#line 302 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp7_ = i;
#line 302 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp8_ = book_get_page (_tmp6_, _tmp7_);
#line 302 "/home/bob/git/simple-scan/src/book-view.vala"
				page = _tmp8_;
#line 303 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp9_ = page;
#line 303 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp10_ = page_get_dpi (_tmp9_);
#line 303 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp11_ = _tmp10_;
#line 303 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp12_ = max_dpi;
#line 303 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp11_ > _tmp12_) {
#line 1648 "book-view.c"
					Page* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
#line 304 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp13_ = page;
#line 304 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp14_ = page_get_dpi (_tmp13_);
#line 304 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp15_ = _tmp14_;
#line 304 "/home/bob/git/simple-scan/src/book-view.vala"
					max_dpi = _tmp15_;
#line 1660 "book-view.c"
				}
#line 300 "/home/bob/git/simple-scan/src/book-view.vala"
				_page_unref0 (page);
#line 1664 "book-view.c"
			}
		}
	}
#line 308 "/home/bob/git/simple-scan/src/book-view.vala"
	max_width = 0;
#line 308 "/home/bob/git/simple-scan/src/book-view.vala"
	max_height = 0;
#line 1672 "book-view.c"
	{
		gint i = 0;
#line 309 "/home/bob/git/simple-scan/src/book-view.vala"
		i = 0;
#line 1677 "book-view.c"
		{
			gboolean _tmp16_ = FALSE;
#line 309 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp16_ = TRUE;
#line 309 "/home/bob/git/simple-scan/src/book-view.vala"
			while (TRUE) {
#line 1684 "book-view.c"
				gint _tmp18_;
				Book* _tmp19_;
				guint _tmp20_;
				guint _tmp21_;
				Page* page = NULL;
				Book* _tmp22_;
				gint _tmp23_;
				Page* _tmp24_;
				gint w = 0;
				Page* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint h = 0;
				Page* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				Page* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				Page* _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				gint _tmp44_;
				gint _tmp45_;
#line 309 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!_tmp16_) {
#line 1717 "book-view.c"
					gint _tmp17_;
#line 309 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp17_ = i;
#line 309 "/home/bob/git/simple-scan/src/book-view.vala"
					i = _tmp17_ + 1;
#line 1723 "book-view.c"
				}
#line 309 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp16_ = FALSE;
#line 309 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp18_ = i;
#line 309 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp19_ = self->priv->_book;
#line 309 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp20_ = book_get_n_pages (_tmp19_);
#line 309 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp21_ = _tmp20_;
#line 309 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!(((guint) _tmp18_) < _tmp21_)) {
#line 309 "/home/bob/git/simple-scan/src/book-view.vala"
					break;
#line 1739 "book-view.c"
				}
#line 311 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp22_ = self->priv->_book;
#line 311 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp23_ = i;
#line 311 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp24_ = book_get_page (_tmp22_, _tmp23_);
#line 311 "/home/bob/git/simple-scan/src/book-view.vala"
				page = _tmp24_;
#line 312 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp25_ = page;
#line 312 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp26_ = page_get_width (_tmp25_);
#line 312 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp27_ = _tmp26_;
#line 312 "/home/bob/git/simple-scan/src/book-view.vala"
				w = _tmp27_;
#line 313 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp28_ = page;
#line 313 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp29_ = page_get_height (_tmp28_);
#line 313 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp30_ = _tmp29_;
#line 313 "/home/bob/git/simple-scan/src/book-view.vala"
				h = _tmp30_;
#line 316 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp31_ = w;
#line 316 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp32_ = max_dpi;
#line 316 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp33_ = page;
#line 316 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp34_ = page_get_dpi (_tmp33_);
#line 316 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp35_ = _tmp34_;
#line 316 "/home/bob/git/simple-scan/src/book-view.vala"
				w = (gint) (((((gdouble) _tmp31_) * _tmp32_) / _tmp35_) + 0.5);
#line 317 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp36_ = h;
#line 317 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp37_ = max_dpi;
#line 317 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp38_ = page;
#line 317 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp39_ = page_get_dpi (_tmp38_);
#line 317 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp40_ = _tmp39_;
#line 317 "/home/bob/git/simple-scan/src/book-view.vala"
				h = (gint) (((((gdouble) _tmp36_) * _tmp37_) / _tmp40_) + 0.5);
#line 319 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp41_ = w;
#line 319 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp42_ = max_width;
#line 319 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp41_ > _tmp42_) {
#line 1795 "book-view.c"
					gint _tmp43_;
#line 320 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp43_ = w;
#line 320 "/home/bob/git/simple-scan/src/book-view.vala"
					max_width = _tmp43_;
#line 1801 "book-view.c"
				}
#line 321 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp44_ = h;
#line 321 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp45_ = max_height;
#line 321 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp44_ > _tmp45_) {
#line 1809 "book-view.c"
					gint _tmp46_;
#line 322 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp46_ = h;
#line 322 "/home/bob/git/simple-scan/src/book-view.vala"
					max_height = _tmp46_;
#line 1815 "book-view.c"
				}
#line 309 "/home/bob/git/simple-scan/src/book-view.vala"
				_page_unref0 (page);
#line 1819 "book-view.c"
			}
		}
	}
#line 325 "/home/bob/git/simple-scan/src/book-view.vala"
	aspect = ((gdouble) width) / height;
#line 326 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp47_ = max_width;
#line 326 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp48_ = max_height;
#line 326 "/home/bob/git/simple-scan/src/book-view.vala"
	max_aspect = ((gdouble) _tmp47_) / _tmp48_;
#line 329 "/home/bob/git/simple-scan/src/book-view.vala"
	spacing = 12;
#line 330 "/home/bob/git/simple-scan/src/book-view.vala"
	_vala_book_width = 0;
#line 331 "/home/bob/git/simple-scan/src/book-view.vala"
	_vala_book_height = 0;
#line 1837 "book-view.c"
	{
		gint i = 0;
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
		i = 0;
#line 1842 "book-view.c"
		{
			gboolean _tmp49_ = FALSE;
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp49_ = TRUE;
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
			while (TRUE) {
#line 1849 "book-view.c"
				gint _tmp51_;
				Book* _tmp52_;
				guint _tmp53_;
				guint _tmp54_;
				PageView* page = NULL;
				gint _tmp55_;
				PageView* _tmp56_;
				Page* p = NULL;
				PageView* _tmp57_;
				Page* _tmp58_;
				Page* _tmp59_;
				Page* _tmp60_;
				gdouble _tmp61_;
				gdouble _tmp62_;
				gint h = 0;
				PageView* _tmp83_;
				gint _tmp84_;
				gint _tmp85_;
				gint _tmp86_;
				gint _tmp87_;
				gint _tmp89_;
				PageView* _tmp90_;
				gint _tmp91_;
				gint _tmp92_;
				gint _tmp93_;
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!_tmp49_) {
#line 1877 "book-view.c"
					gint _tmp50_;
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp50_ = i;
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
					i = _tmp50_ + 1;
#line 1883 "book-view.c"
				}
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp49_ = FALSE;
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp51_ = i;
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp52_ = self->priv->_book;
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp53_ = book_get_n_pages (_tmp52_);
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp54_ = _tmp53_;
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!(((guint) _tmp51_) < _tmp54_)) {
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
					break;
#line 1899 "book-view.c"
				}
#line 334 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp55_ = i;
#line 334 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp56_ = book_view_get_nth_page (self, _tmp55_);
#line 334 "/home/bob/git/simple-scan/src/book-view.vala"
				page = _tmp56_;
#line 335 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp57_ = page;
#line 335 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp58_ = page_view_get_page (_tmp57_);
#line 335 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp59_ = _tmp58_;
#line 335 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp60_ = _page_ref0 (_tmp59_);
#line 335 "/home/bob/git/simple-scan/src/book-view.vala"
				p = _tmp60_;
#line 338 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp61_ = max_aspect;
#line 338 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp62_ = aspect;
#line 338 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp61_ > _tmp62_) {
#line 1923 "book-view.c"
					gint w = 0;
					Page* _tmp63_;
					gint _tmp64_;
					gint _tmp65_;
					gint _tmp66_;
					Page* _tmp67_;
					gint _tmp68_;
					gint _tmp69_;
					gint _tmp70_;
					PageView* _tmp71_;
					gint _tmp72_;
#line 341 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp63_ = p;
#line 341 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp64_ = page_get_width (_tmp63_);
#line 341 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp65_ = _tmp64_;
#line 341 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp66_ = max_dpi;
#line 341 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp67_ = p;
#line 341 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp68_ = page_get_dpi (_tmp67_);
#line 341 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp69_ = _tmp68_;
#line 341 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp70_ = max_width;
#line 341 "/home/bob/git/simple-scan/src/book-view.vala"
					w = (gint) (((((gdouble) _tmp65_) * _tmp66_) * width) / (_tmp69_ * _tmp70_));
#line 342 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp71_ = page;
#line 342 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp72_ = w;
#line 342 "/home/bob/git/simple-scan/src/book-view.vala"
					page_view_set_width (_tmp71_, _tmp72_);
#line 1959 "book-view.c"
				} else {
					gint h = 0;
					Page* _tmp73_;
					gint _tmp74_;
					gint _tmp75_;
					gint _tmp76_;
					Page* _tmp77_;
					gint _tmp78_;
					gint _tmp79_;
					gint _tmp80_;
					PageView* _tmp81_;
					gint _tmp82_;
#line 347 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp73_ = p;
#line 347 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp74_ = page_get_height (_tmp73_);
#line 347 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp75_ = _tmp74_;
#line 347 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp76_ = max_dpi;
#line 347 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp77_ = p;
#line 347 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp78_ = page_get_dpi (_tmp77_);
#line 347 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp79_ = _tmp78_;
#line 347 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp80_ = max_height;
#line 347 "/home/bob/git/simple-scan/src/book-view.vala"
					h = (gint) (((((gdouble) _tmp75_) * _tmp76_) * height) / (_tmp79_ * _tmp80_));
#line 348 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp81_ = page;
#line 348 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp82_ = h;
#line 348 "/home/bob/git/simple-scan/src/book-view.vala"
					page_view_set_height (_tmp81_, _tmp82_);
#line 1996 "book-view.c"
				}
#line 351 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp83_ = page;
#line 351 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp84_ = page_view_get_height (_tmp83_);
#line 351 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp85_ = _tmp84_;
#line 351 "/home/bob/git/simple-scan/src/book-view.vala"
				h = _tmp85_;
#line 352 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp86_ = h;
#line 352 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp87_ = _vala_book_height;
#line 352 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp86_ > _tmp87_) {
#line 2012 "book-view.c"
					gint _tmp88_;
#line 353 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp88_ = h;
#line 353 "/home/bob/git/simple-scan/src/book-view.vala"
					_vala_book_height = _tmp88_;
#line 2018 "book-view.c"
				}
#line 354 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp89_ = _vala_book_width;
#line 354 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp90_ = page;
#line 354 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp91_ = page_view_get_width (_tmp90_);
#line 354 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp92_ = _tmp91_;
#line 354 "/home/bob/git/simple-scan/src/book-view.vala"
				_vala_book_width = _tmp89_ + _tmp92_;
#line 355 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp93_ = i;
#line 355 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp93_ != 0) {
#line 2034 "book-view.c"
					gint _tmp94_;
					gint _tmp95_;
#line 356 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp94_ = _vala_book_width;
#line 356 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp95_ = spacing;
#line 356 "/home/bob/git/simple-scan/src/book-view.vala"
					_vala_book_width = _tmp94_ + _tmp95_;
#line 2043 "book-view.c"
				}
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
				_page_unref0 (p);
#line 332 "/home/bob/git/simple-scan/src/book-view.vala"
				_page_view_unref0 (page);
#line 2049 "book-view.c"
			}
		}
	}
#line 359 "/home/bob/git/simple-scan/src/book-view.vala"
	x_offset = 0;
#line 2055 "book-view.c"
	{
		gint i = 0;
#line 360 "/home/bob/git/simple-scan/src/book-view.vala"
		i = 0;
#line 2060 "book-view.c"
		{
			gboolean _tmp96_ = FALSE;
#line 360 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp96_ = TRUE;
#line 360 "/home/bob/git/simple-scan/src/book-view.vala"
			while (TRUE) {
#line 2067 "book-view.c"
				gint _tmp98_;
				Book* _tmp99_;
				guint _tmp100_;
				guint _tmp101_;
				PageView* page = NULL;
				gint _tmp102_;
				PageView* _tmp103_;
				PageView* _tmp104_;
				gint _tmp105_;
				gint _tmp106_;
				PageView* _tmp107_;
				gint _tmp108_;
				gint _tmp109_;
				gint _tmp110_;
				PageView* _tmp111_;
				PageView* _tmp112_;
				gint _tmp113_;
				gint _tmp114_;
#line 360 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!_tmp96_) {
#line 2088 "book-view.c"
					gint _tmp97_;
#line 360 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp97_ = i;
#line 360 "/home/bob/git/simple-scan/src/book-view.vala"
					i = _tmp97_ + 1;
#line 2094 "book-view.c"
				}
#line 360 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp96_ = FALSE;
#line 360 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp98_ = i;
#line 360 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp99_ = self->priv->_book;
#line 360 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp100_ = book_get_n_pages (_tmp99_);
#line 360 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp101_ = _tmp100_;
#line 360 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!(((guint) _tmp98_) < _tmp101_)) {
#line 360 "/home/bob/git/simple-scan/src/book-view.vala"
					break;
#line 2110 "book-view.c"
				}
#line 362 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp102_ = i;
#line 362 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp103_ = book_view_get_nth_page (self, _tmp102_);
#line 362 "/home/bob/git/simple-scan/src/book-view.vala"
				page = _tmp103_;
#line 365 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp104_ = page;
#line 365 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp105_ = x_offset;
#line 365 "/home/bob/git/simple-scan/src/book-view.vala"
				page_view_set_x_offset (_tmp104_, _tmp105_);
#line 366 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp106_ = x_offset;
#line 366 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp107_ = page;
#line 366 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp108_ = page_view_get_width (_tmp107_);
#line 366 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp109_ = _tmp108_;
#line 366 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp110_ = spacing;
#line 366 "/home/bob/git/simple-scan/src/book-view.vala"
				x_offset = _tmp106_ + (_tmp109_ + _tmp110_);
#line 369 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp111_ = page;
#line 369 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp112_ = page;
#line 369 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp113_ = page_view_get_height (_tmp112_);
#line 369 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp114_ = _tmp113_;
#line 369 "/home/bob/git/simple-scan/src/book-view.vala"
				page_view_set_y_offset (_tmp111_, (height - _tmp114_) / 2);
#line 360 "/home/bob/git/simple-scan/src/book-view.vala"
				_page_view_unref0 (page);
#line 2148 "book-view.c"
			}
		}
	}
#line 296 "/home/bob/git/simple-scan/src/book-view.vala"
	if (book_width) {
#line 296 "/home/bob/git/simple-scan/src/book-view.vala"
		*book_width = _vala_book_width;
#line 2156 "book-view.c"
	}
#line 296 "/home/bob/git/simple-scan/src/book-view.vala"
	if (book_height) {
#line 296 "/home/bob/git/simple-scan/src/book-view.vala"
		*book_height = _vala_book_height;
#line 2162 "book-view.c"
	}
}


static void
book_view_layout (BookView* self)
{
	gboolean _tmp0_;
	GtkAllocation allocation = {0};
	GtkWidget* _tmp1_;
	GtkAllocation _tmp2_ = {0};
	GtkAllocation box_allocation = {0};
	GtkAllocation _tmp3_ = {0};
	gboolean right_aligned = FALSE;
	GtkAdjustment* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	gint width = 0;
	GtkAllocation _tmp7_;
	gint _tmp8_;
	gint height = 0;
	GtkAllocation _tmp9_;
	gint _tmp10_;
	gint book_width = 0;
	gint book_height = 0;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_;
	GtkAllocation _tmp16_;
	gint _tmp17_;
	gboolean _tmp50_;
#line 373 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 375 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->need_layout;
#line 375 "/home/bob/git/simple-scan/src/book-view.vala"
	if (!_tmp0_) {
#line 376 "/home/bob/git/simple-scan/src/book-view.vala"
		return;
#line 2204 "book-view.c"
	}
#line 378 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->laying_out = TRUE;
#line 381 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp1_ = self->priv->drawing_area;
#line 381 "/home/bob/git/simple-scan/src/book-view.vala"
	gtk_widget_get_allocation (_tmp1_, &_tmp2_);
#line 381 "/home/bob/git/simple-scan/src/book-view.vala"
	allocation = _tmp2_;
#line 383 "/home/bob/git/simple-scan/src/book-view.vala"
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp3_);
#line 383 "/home/bob/git/simple-scan/src/book-view.vala"
	box_allocation = _tmp3_;
#line 386 "/home/bob/git/simple-scan/src/book-view.vala"
	right_aligned = TRUE;
#line 387 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp4_ = self->priv->adjustment;
#line 387 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp5_ = self->priv->adjustment;
#line 387 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp6_ = self->priv->adjustment;
#line 387 "/home/bob/git/simple-scan/src/book-view.vala"
	if (gtk_adjustment_get_value (_tmp4_) < (gtk_adjustment_get_upper (_tmp5_) - gtk_adjustment_get_page_size (_tmp6_))) {
#line 388 "/home/bob/git/simple-scan/src/book-view.vala"
		right_aligned = FALSE;
#line 2230 "book-view.c"
	}
#line 391 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp7_ = allocation;
#line 391 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp8_ = _tmp7_.width;
#line 391 "/home/bob/git/simple-scan/src/book-view.vala"
	width = (gint) _tmp8_;
#line 392 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp9_ = box_allocation;
#line 392 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp10_ = _tmp9_.height;
#line 392 "/home/bob/git/simple-scan/src/book-view.vala"
	height = (gint) (_tmp10_ - (gtk_container_get_border_width ((GtkContainer*) self) * 2));
#line 394 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp11_ = width;
#line 394 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp12_ = height;
#line 394 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_layout_into (self, _tmp11_, _tmp12_, &_tmp13_, &_tmp14_);
#line 394 "/home/bob/git/simple-scan/src/book-view.vala"
	book_width = _tmp13_;
#line 394 "/home/bob/git/simple-scan/src/book-view.vala"
	book_height = _tmp14_;
#line 397 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp15_ = book_width;
#line 397 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp16_ = allocation;
#line 397 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp17_ = _tmp16_.width;
#line 397 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp15_ > _tmp17_) {
#line 2262 "book-view.c"
		GtkAllocation _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		GtkAdjustment* _tmp24_;
		GtkAdjustment* _tmp25_;
		gint _tmp26_;
		GtkAdjustment* _tmp27_;
		GtkAllocation _tmp28_;
		gint _tmp29_;
		gint max_offset = 0;
		gint _tmp30_;
		GtkAllocation _tmp31_;
		gint _tmp32_;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_;
		GtkScrollbar* _tmp39_;
#line 400 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp18_ = allocation;
#line 400 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp19_ = _tmp18_.height;
#line 400 "/home/bob/git/simple-scan/src/book-view.vala"
		height = _tmp19_;
#line 401 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp20_ = width;
#line 401 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp21_ = height;
#line 401 "/home/bob/git/simple-scan/src/book-view.vala"
		book_view_layout_into (self, _tmp20_, _tmp21_, &_tmp22_, &_tmp23_);
#line 401 "/home/bob/git/simple-scan/src/book-view.vala"
		book_width = _tmp22_;
#line 401 "/home/bob/git/simple-scan/src/book-view.vala"
		book_height = _tmp23_;
#line 404 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp24_ = self->priv->adjustment;
#line 404 "/home/bob/git/simple-scan/src/book-view.vala"
		gtk_adjustment_set_lower (_tmp24_, (gdouble) 0);
#line 405 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp25_ = self->priv->adjustment;
#line 405 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp26_ = book_width;
#line 405 "/home/bob/git/simple-scan/src/book-view.vala"
		gtk_adjustment_set_upper (_tmp25_, (gdouble) _tmp26_);
#line 406 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp27_ = self->priv->adjustment;
#line 406 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp28_ = allocation;
#line 406 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp29_ = _tmp28_.width;
#line 406 "/home/bob/git/simple-scan/src/book-view.vala"
		gtk_adjustment_set_page_size (_tmp27_, (gdouble) _tmp29_);
#line 409 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp30_ = book_width;
#line 409 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp31_ = allocation;
#line 409 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp32_ = _tmp31_.width;
#line 409 "/home/bob/git/simple-scan/src/book-view.vala"
		max_offset = _tmp30_ - _tmp32_;
#line 410 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp34_ = right_aligned;
#line 410 "/home/bob/git/simple-scan/src/book-view.vala"
		if (_tmp34_) {
#line 410 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp33_ = TRUE;
#line 2330 "book-view.c"
		} else {
			gint _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
#line 410 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp35_ = book_view_get_x_offset (self);
#line 410 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp36_ = _tmp35_;
#line 410 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp37_ = max_offset;
#line 410 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp33_ = _tmp36_ > _tmp37_;
#line 2343 "book-view.c"
		}
#line 410 "/home/bob/git/simple-scan/src/book-view.vala"
		if (_tmp33_) {
#line 2347 "book-view.c"
			gint _tmp38_;
#line 411 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp38_ = max_offset;
#line 411 "/home/bob/git/simple-scan/src/book-view.vala"
			book_view_set_x_offset (self, _tmp38_);
#line 2353 "book-view.c"
		}
#line 413 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp39_ = self->priv->scroll;
#line 413 "/home/bob/git/simple-scan/src/book-view.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp39_, TRUE);
#line 2359 "book-view.c"
	} else {
		GtkScrollbar* _tmp40_;
		gint offset = 0;
		gint _tmp41_;
		GtkAllocation _tmp42_;
		gint _tmp43_;
		GtkAdjustment* _tmp44_;
		gint _tmp45_;
		GtkAdjustment* _tmp46_;
		gint _tmp47_;
		GtkAdjustment* _tmp48_;
		gint _tmp49_;
#line 417 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp40_ = self->priv->scroll;
#line 417 "/home/bob/git/simple-scan/src/book-view.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp40_, FALSE);
#line 418 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp41_ = book_width;
#line 418 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp42_ = allocation;
#line 418 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp43_ = _tmp42_.width;
#line 418 "/home/bob/git/simple-scan/src/book-view.vala"
		offset = (_tmp41_ - _tmp43_) / 2;
#line 419 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp44_ = self->priv->adjustment;
#line 419 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp45_ = offset;
#line 419 "/home/bob/git/simple-scan/src/book-view.vala"
		gtk_adjustment_set_lower (_tmp44_, (gdouble) _tmp45_);
#line 420 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp46_ = self->priv->adjustment;
#line 420 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp47_ = offset;
#line 420 "/home/bob/git/simple-scan/src/book-view.vala"
		gtk_adjustment_set_upper (_tmp46_, (gdouble) _tmp47_);
#line 421 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp48_ = self->priv->adjustment;
#line 421 "/home/bob/git/simple-scan/src/book-view.vala"
		gtk_adjustment_set_page_size (_tmp48_, (gdouble) 0);
#line 422 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp49_ = offset;
#line 422 "/home/bob/git/simple-scan/src/book-view.vala"
		book_view_set_x_offset (self, _tmp49_);
#line 2404 "book-view.c"
	}
#line 425 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp50_ = self->priv->show_selected_page;
#line 425 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp50_) {
#line 2410 "book-view.c"
		PageView* _tmp51_;
#line 426 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp51_ = self->priv->selected_page_view;
#line 426 "/home/bob/git/simple-scan/src/book-view.vala"
		book_view_show_page_view (self, _tmp51_);
#line 2416 "book-view.c"
	}
#line 428 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->need_layout = FALSE;
#line 429 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->show_selected_page = FALSE;
#line 430 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->laying_out = FALSE;
#line 2424 "book-view.c"
}


static gboolean
book_view_draw_cb (BookView* self,
                   GtkWidget* widget,
                   cairo_t* context)
{
	gboolean result = FALSE;
	Book* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gdouble left = 0.0;
	gdouble top = 0.0;
	gdouble right = 0.0;
	gdouble bottom = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
#line 433 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 433 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 433 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (context != NULL, FALSE);
#line 435 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->_book;
#line 435 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp1_ = book_get_n_pages (_tmp0_);
#line 435 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp2_ = _tmp1_;
#line 435 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp2_ == ((guint) 0)) {
#line 436 "/home/bob/git/simple-scan/src/book-view.vala"
		result = FALSE;
#line 436 "/home/bob/git/simple-scan/src/book-view.vala"
		return result;
#line 2463 "book-view.c"
	}
#line 438 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_layout (self);
#line 441 "/home/bob/git/simple-scan/src/book-view.vala"
	cairo_clip_extents (context, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
#line 441 "/home/bob/git/simple-scan/src/book-view.vala"
	left = _tmp3_;
#line 441 "/home/bob/git/simple-scan/src/book-view.vala"
	top = _tmp4_;
#line 441 "/home/bob/git/simple-scan/src/book-view.vala"
	right = _tmp5_;
#line 441 "/home/bob/git/simple-scan/src/book-view.vala"
	bottom = _tmp6_;
#line 2477 "book-view.c"
	{
		gint i = 0;
#line 444 "/home/bob/git/simple-scan/src/book-view.vala"
		i = 0;
#line 2482 "book-view.c"
		{
			gboolean _tmp7_ = FALSE;
#line 444 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp7_ = TRUE;
#line 444 "/home/bob/git/simple-scan/src/book-view.vala"
			while (TRUE) {
#line 2489 "book-view.c"
				gint _tmp9_;
				Book* _tmp10_;
				guint _tmp11_;
				guint _tmp12_;
				PageView* page = NULL;
				gint _tmp13_;
				PageView* _tmp14_;
				gint left_edge = 0;
				PageView* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint right_edge = 0;
				PageView* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				PageView* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gboolean _tmp28_ = FALSE;
				gint _tmp29_;
				gdouble _tmp30_;
				gint _tmp33_;
				gint _tmp34_;
				PageView* _tmp35_;
				PageView* _tmp36_;
				gboolean _tmp37_;
				gboolean _tmp38_;
#line 444 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!_tmp7_) {
#line 2523 "book-view.c"
					gint _tmp8_;
#line 444 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp8_ = i;
#line 444 "/home/bob/git/simple-scan/src/book-view.vala"
					i = _tmp8_ + 1;
#line 2529 "book-view.c"
				}
#line 444 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp7_ = FALSE;
#line 444 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp9_ = i;
#line 444 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp10_ = self->priv->_book;
#line 444 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp11_ = book_get_n_pages (_tmp10_);
#line 444 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp12_ = _tmp11_;
#line 444 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!(((guint) _tmp9_) < _tmp12_)) {
#line 444 "/home/bob/git/simple-scan/src/book-view.vala"
					break;
#line 2545 "book-view.c"
				}
#line 446 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp13_ = i;
#line 446 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp14_ = book_view_get_nth_page (self, _tmp13_);
#line 446 "/home/bob/git/simple-scan/src/book-view.vala"
				page = _tmp14_;
#line 447 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp15_ = page;
#line 447 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp16_ = page_view_get_x_offset (_tmp15_);
#line 447 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp17_ = _tmp16_;
#line 447 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp18_ = book_view_get_x_offset (self);
#line 447 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp19_ = _tmp18_;
#line 447 "/home/bob/git/simple-scan/src/book-view.vala"
				left_edge = _tmp17_ - _tmp19_;
#line 448 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp20_ = page;
#line 448 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp21_ = page_view_get_x_offset (_tmp20_);
#line 448 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp22_ = _tmp21_;
#line 448 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp23_ = page;
#line 448 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp24_ = page_view_get_width (_tmp23_);
#line 448 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp25_ = _tmp24_;
#line 448 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp26_ = book_view_get_x_offset (self);
#line 448 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp27_ = _tmp26_;
#line 448 "/home/bob/git/simple-scan/src/book-view.vala"
				right_edge = (_tmp22_ + _tmp25_) - _tmp27_;
#line 451 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp29_ = right_edge;
#line 451 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp30_ = left;
#line 451 "/home/bob/git/simple-scan/src/book-view.vala"
				if (((gdouble) _tmp29_) < _tmp30_) {
#line 451 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp28_ = TRUE;
#line 2591 "book-view.c"
				} else {
					gint _tmp31_;
					gdouble _tmp32_;
#line 451 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp31_ = left_edge;
#line 451 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp32_ = right;
#line 451 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp28_ = ((gdouble) _tmp31_) > _tmp32_;
#line 2601 "book-view.c"
				}
#line 451 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp28_) {
#line 452 "/home/bob/git/simple-scan/src/book-view.vala"
					_page_view_unref0 (page);
#line 452 "/home/bob/git/simple-scan/src/book-view.vala"
					continue;
#line 2609 "book-view.c"
				}
#line 454 "/home/bob/git/simple-scan/src/book-view.vala"
				cairo_save (context);
#line 455 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp33_ = book_view_get_x_offset (self);
#line 455 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp34_ = _tmp33_;
#line 455 "/home/bob/git/simple-scan/src/book-view.vala"
				cairo_translate (context, (gdouble) (-_tmp34_), (gdouble) 0);
#line 456 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp35_ = page;
#line 456 "/home/bob/git/simple-scan/src/book-view.vala"
				page_view_render (_tmp35_, context);
#line 457 "/home/bob/git/simple-scan/src/book-view.vala"
				cairo_restore (context);
#line 459 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp36_ = page;
#line 459 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp37_ = page_view_get_selected (_tmp36_);
#line 459 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp38_ = _tmp37_;
#line 459 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp38_) {
#line 2633 "book-view.c"
					GtkWidget* _tmp39_;
					GtkStyleContext* _tmp40_;
					PageView* _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
					gint _tmp45_;
					PageView* _tmp46_;
					gint _tmp47_;
					gint _tmp48_;
					PageView* _tmp49_;
					gint _tmp50_;
					gint _tmp51_;
					PageView* _tmp52_;
					gint _tmp53_;
					gint _tmp54_;
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp39_ = self->priv->drawing_area;
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp40_ = gtk_widget_get_style_context (_tmp39_);
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp41_ = page;
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp42_ = page_view_get_x_offset (_tmp41_);
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp43_ = _tmp42_;
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp44_ = book_view_get_x_offset (self);
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp45_ = _tmp44_;
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp46_ = page;
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp47_ = page_view_get_y_offset (_tmp46_);
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp48_ = _tmp47_;
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp49_ = page;
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp50_ = page_view_get_width (_tmp49_);
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp51_ = _tmp50_;
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp52_ = page;
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp53_ = page_view_get_height (_tmp52_);
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp54_ = _tmp53_;
#line 460 "/home/bob/git/simple-scan/src/book-view.vala"
					gtk_render_focus (_tmp40_, context, (gdouble) (_tmp43_ - _tmp45_), (gdouble) _tmp48_, (gdouble) _tmp51_, (gdouble) _tmp54_);
#line 2684 "book-view.c"
				}
#line 444 "/home/bob/git/simple-scan/src/book-view.vala"
				_page_view_unref0 (page);
#line 2688 "book-view.c"
			}
		}
	}
#line 467 "/home/bob/git/simple-scan/src/book-view.vala"
	result = FALSE;
#line 467 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 2696 "book-view.c"
}


static PageView*
book_view_get_page_at (BookView* self,
                       gint x,
                       gint y,
                       gint* x_,
                       gint* y_)
{
	gint _vala_x_ = 0;
	gint _vala_y_ = 0;
	PageView* result = NULL;
	gint _tmp0_;
#line 470 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 472 "/home/bob/git/simple-scan/src/book-view.vala"
	_vala_y_ = 0;
#line 472 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = _vala_y_;
#line 472 "/home/bob/git/simple-scan/src/book-view.vala"
	_vala_x_ = _tmp0_;
#line 2719 "book-view.c"
	{
		gint i = 0;
#line 473 "/home/bob/git/simple-scan/src/book-view.vala"
		i = 0;
#line 2724 "book-view.c"
		{
			gboolean _tmp1_ = FALSE;
#line 473 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp1_ = TRUE;
#line 473 "/home/bob/git/simple-scan/src/book-view.vala"
			while (TRUE) {
#line 2731 "book-view.c"
				gint _tmp3_;
				Book* _tmp4_;
				guint _tmp5_;
				guint _tmp6_;
				PageView* page = NULL;
				gint _tmp7_;
				PageView* _tmp8_;
				gint left = 0;
				PageView* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gint right = 0;
				gint _tmp12_;
				PageView* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gint top = 0;
				PageView* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint bottom = 0;
				gint _tmp19_;
				PageView* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				gint _tmp26_;
#line 473 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!_tmp1_) {
#line 2763 "book-view.c"
					gint _tmp2_;
#line 473 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp2_ = i;
#line 473 "/home/bob/git/simple-scan/src/book-view.vala"
					i = _tmp2_ + 1;
#line 2769 "book-view.c"
				}
#line 473 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp1_ = FALSE;
#line 473 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp3_ = i;
#line 473 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp4_ = self->priv->_book;
#line 473 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp5_ = book_get_n_pages (_tmp4_);
#line 473 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp6_ = _tmp5_;
#line 473 "/home/bob/git/simple-scan/src/book-view.vala"
				if (!(((guint) _tmp3_) < _tmp6_)) {
#line 473 "/home/bob/git/simple-scan/src/book-view.vala"
					break;
#line 2785 "book-view.c"
				}
#line 475 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp7_ = i;
#line 475 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp8_ = book_view_get_nth_page (self, _tmp7_);
#line 475 "/home/bob/git/simple-scan/src/book-view.vala"
				page = _tmp8_;
#line 476 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp9_ = page;
#line 476 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp10_ = page_view_get_x_offset (_tmp9_);
#line 476 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp11_ = _tmp10_;
#line 476 "/home/bob/git/simple-scan/src/book-view.vala"
				left = _tmp11_;
#line 477 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp12_ = left;
#line 477 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp13_ = page;
#line 477 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp14_ = page_view_get_width (_tmp13_);
#line 477 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp15_ = _tmp14_;
#line 477 "/home/bob/git/simple-scan/src/book-view.vala"
				right = _tmp12_ + _tmp15_;
#line 478 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp16_ = page;
#line 478 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp17_ = page_view_get_y_offset (_tmp16_);
#line 478 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp18_ = _tmp17_;
#line 478 "/home/bob/git/simple-scan/src/book-view.vala"
				top = _tmp18_;
#line 479 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp19_ = top;
#line 479 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp20_ = page;
#line 479 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp21_ = page_view_get_height (_tmp20_);
#line 479 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp22_ = _tmp21_;
#line 479 "/home/bob/git/simple-scan/src/book-view.vala"
				bottom = _tmp19_ + _tmp22_;
#line 480 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp26_ = left;
#line 480 "/home/bob/git/simple-scan/src/book-view.vala"
				if (x >= _tmp26_) {
#line 2833 "book-view.c"
					gint _tmp27_;
#line 480 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp27_ = right;
#line 480 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp25_ = x <= _tmp27_;
#line 2839 "book-view.c"
				} else {
#line 480 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp25_ = FALSE;
#line 2843 "book-view.c"
				}
#line 480 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp25_) {
#line 2847 "book-view.c"
					gint _tmp28_;
#line 480 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp28_ = top;
#line 480 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp24_ = y >= _tmp28_;
#line 2853 "book-view.c"
				} else {
#line 480 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp24_ = FALSE;
#line 2857 "book-view.c"
				}
#line 480 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp24_) {
#line 2861 "book-view.c"
					gint _tmp29_;
#line 480 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp29_ = bottom;
#line 480 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp23_ = y <= _tmp29_;
#line 2867 "book-view.c"
				} else {
#line 480 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp23_ = FALSE;
#line 2871 "book-view.c"
				}
#line 480 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp23_) {
#line 2875 "book-view.c"
					gint _tmp30_;
					gint _tmp31_;
#line 482 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp30_ = left;
#line 482 "/home/bob/git/simple-scan/src/book-view.vala"
					_vala_x_ = x - _tmp30_;
#line 483 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp31_ = top;
#line 483 "/home/bob/git/simple-scan/src/book-view.vala"
					_vala_y_ = y - _tmp31_;
#line 484 "/home/bob/git/simple-scan/src/book-view.vala"
					result = page;
#line 484 "/home/bob/git/simple-scan/src/book-view.vala"
					if (x_) {
#line 484 "/home/bob/git/simple-scan/src/book-view.vala"
						*x_ = _vala_x_;
#line 2892 "book-view.c"
					}
#line 484 "/home/bob/git/simple-scan/src/book-view.vala"
					if (y_) {
#line 484 "/home/bob/git/simple-scan/src/book-view.vala"
						*y_ = _vala_y_;
#line 2898 "book-view.c"
					}
#line 484 "/home/bob/git/simple-scan/src/book-view.vala"
					return result;
#line 2902 "book-view.c"
				}
#line 473 "/home/bob/git/simple-scan/src/book-view.vala"
				_page_view_unref0 (page);
#line 2906 "book-view.c"
			}
		}
	}
#line 488 "/home/bob/git/simple-scan/src/book-view.vala"
	result = NULL;
#line 488 "/home/bob/git/simple-scan/src/book-view.vala"
	if (x_) {
#line 488 "/home/bob/git/simple-scan/src/book-view.vala"
		*x_ = _vala_x_;
#line 2916 "book-view.c"
	}
#line 488 "/home/bob/git/simple-scan/src/book-view.vala"
	if (y_) {
#line 488 "/home/bob/git/simple-scan/src/book-view.vala"
		*y_ = _vala_y_;
#line 2922 "book-view.c"
	}
#line 488 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 2926 "book-view.c"
}


static gboolean
book_view_button_cb (BookView* self,
                     GtkWidget* widget,
                     GdkEventButton* event)
{
	gboolean result = FALSE;
	GtkWidget* _tmp0_;
	gint x = 0;
	gint y = 0;
	GdkEventType _tmp1_;
	PageView* _tmp10_;
	guint _tmp11_;
	guint _tmp23_;
#line 491 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 491 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 491 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 493 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_layout (self);
#line 495 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->drawing_area;
#line 495 "/home/bob/git/simple-scan/src/book-view.vala"
	gtk_widget_grab_focus (_tmp0_);
#line 497 "/home/bob/git/simple-scan/src/book-view.vala"
	x = 0;
#line 497 "/home/bob/git/simple-scan/src/book-view.vala"
	y = 0;
#line 498 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp1_ = event->type;
#line 498 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp1_ == GDK_BUTTON_PRESS) {
#line 2963 "book-view.c"
		gdouble _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gdouble _tmp5_;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		PageView* _tmp8_;
		PageView* _tmp9_;
#line 499 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp2_ = event->x;
#line 499 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp3_ = book_view_get_x_offset (self);
#line 499 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp4_ = _tmp3_;
#line 499 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp5_ = event->y;
#line 499 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp8_ = book_view_get_page_at (self, (gint) (_tmp2_ + _tmp4_), (gint) _tmp5_, &_tmp6_, &_tmp7_);
#line 499 "/home/bob/git/simple-scan/src/book-view.vala"
		x = _tmp6_;
#line 499 "/home/bob/git/simple-scan/src/book-view.vala"
		y = _tmp7_;
#line 499 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp9_ = _tmp8_;
#line 499 "/home/bob/git/simple-scan/src/book-view.vala"
		book_view_select_page_view (self, _tmp9_);
#line 499 "/home/bob/git/simple-scan/src/book-view.vala"
		_page_view_unref0 (_tmp9_);
#line 2992 "book-view.c"
	}
#line 501 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp10_ = self->priv->selected_page_view;
#line 501 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp10_ == NULL) {
#line 502 "/home/bob/git/simple-scan/src/book-view.vala"
		result = FALSE;
#line 502 "/home/bob/git/simple-scan/src/book-view.vala"
		return result;
#line 3002 "book-view.c"
	}
#line 505 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp11_ = event->button;
#line 505 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp11_ == ((guint) 1)) {
#line 3008 "book-view.c"
		GdkEventType _tmp12_;
#line 507 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp12_ = event->type;
#line 507 "/home/bob/git/simple-scan/src/book-view.vala"
		if (_tmp12_ == GDK_BUTTON_PRESS) {
#line 3014 "book-view.c"
			PageView* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
#line 508 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp13_ = self->priv->selected_page_view;
#line 508 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp14_ = x;
#line 508 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp15_ = y;
#line 508 "/home/bob/git/simple-scan/src/book-view.vala"
			page_view_button_press (_tmp13_, _tmp14_, _tmp15_);
#line 3026 "book-view.c"
		} else {
			GdkEventType _tmp16_;
#line 509 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp16_ = event->type;
#line 509 "/home/bob/git/simple-scan/src/book-view.vala"
			if (_tmp16_ == GDK_BUTTON_RELEASE) {
#line 3033 "book-view.c"
				PageView* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
#line 510 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp17_ = self->priv->selected_page_view;
#line 510 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp18_ = x;
#line 510 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp19_ = y;
#line 510 "/home/bob/git/simple-scan/src/book-view.vala"
				page_view_button_release (_tmp17_, _tmp18_, _tmp19_);
#line 3045 "book-view.c"
			} else {
				GdkEventType _tmp20_;
#line 511 "/home/bob/git/simple-scan/src/book-view.vala"
				_tmp20_ = event->type;
#line 511 "/home/bob/git/simple-scan/src/book-view.vala"
				if (_tmp20_ == GDK_2BUTTON_PRESS) {
#line 3052 "book-view.c"
					Page* _tmp21_;
					Page* _tmp22_;
#line 512 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp21_ = book_view_get_selected_page (self);
#line 512 "/home/bob/git/simple-scan/src/book-view.vala"
					_tmp22_ = _tmp21_;
#line 512 "/home/bob/git/simple-scan/src/book-view.vala"
					g_signal_emit (self, book_view_signals[BOOK_VIEW_SHOW_PAGE_SIGNAL], 0, _tmp22_);
#line 3061 "book-view.c"
				}
			}
		}
	}
#line 516 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp23_ = event->button;
#line 516 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp23_ == ((guint) 3)) {
#line 517 "/home/bob/git/simple-scan/src/book-view.vala"
		g_signal_emit (self, book_view_signals[BOOK_VIEW_SHOW_MENU_SIGNAL], 0);
#line 3072 "book-view.c"
	}
#line 519 "/home/bob/git/simple-scan/src/book-view.vala"
	result = FALSE;
#line 519 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 3078 "book-view.c"
}


static void
book_view_set_cursor (BookView* self,
                      GdkCursorType cursor)
{
	GdkCursor* c = NULL;
	GdkCursorType _tmp0_;
	GdkDisplay* _tmp1_;
	GdkCursor* _tmp2_;
	GtkWidget* _tmp3_;
	GdkWindow* _tmp4_;
	GdkCursor* _tmp5_;
#line 522 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 526 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->cursor;
#line 526 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp0_ == cursor) {
#line 527 "/home/bob/git/simple-scan/src/book-view.vala"
		_g_object_unref0 (c);
#line 527 "/home/bob/git/simple-scan/src/book-view.vala"
		return;
#line 3103 "book-view.c"
	}
#line 528 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->cursor = cursor;
#line 530 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp1_ = gtk_widget_get_display ((GtkWidget*) self);
#line 530 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp2_ = gdk_cursor_new_for_display (_tmp1_, cursor);
#line 530 "/home/bob/git/simple-scan/src/book-view.vala"
	_g_object_unref0 (c);
#line 530 "/home/bob/git/simple-scan/src/book-view.vala"
	c = _tmp2_;
#line 531 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp3_ = self->priv->drawing_area;
#line 531 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp4_ = gtk_widget_get_window (_tmp3_);
#line 531 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp5_ = c;
#line 531 "/home/bob/git/simple-scan/src/book-view.vala"
	gdk_window_set_cursor (_tmp4_, _tmp5_);
#line 522 "/home/bob/git/simple-scan/src/book-view.vala"
	_g_object_unref0 (c);
#line 3125 "book-view.c"
}


static gboolean
book_view_motion_cb (BookView* self,
                     GtkWidget* widget,
                     GdkEventMotion* event)
{
	gboolean result = FALSE;
	GdkCursorType cursor = 0;
	gboolean _tmp0_ = FALSE;
	PageView* _tmp1_;
	GdkCursorType _tmp33_;
#line 534 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 534 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 534 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 536 "/home/bob/git/simple-scan/src/book-view.vala"
	cursor = GDK_ARROW;
#line 539 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp1_ = self->priv->selected_page_view;
#line 539 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp1_ != NULL) {
#line 3151 "book-view.c"
		GdkModifierType _tmp2_;
#line 539 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp2_ = event->state;
#line 539 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp0_ = (_tmp2_ & GDK_BUTTON1_MASK) != 0;
#line 3157 "book-view.c"
	} else {
#line 539 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp0_ = FALSE;
#line 3161 "book-view.c"
	}
#line 539 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp0_) {
#line 3165 "book-view.c"
		gint x = 0;
		gdouble _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		PageView* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint y = 0;
		gdouble _tmp9_;
		PageView* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		PageView* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		PageView* _tmp16_;
		GdkCursorType _tmp17_;
		GdkCursorType _tmp18_;
#line 541 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp3_ = event->x;
#line 541 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp4_ = book_view_get_x_offset (self);
#line 541 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp5_ = _tmp4_;
#line 541 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp6_ = self->priv->selected_page_view;
#line 541 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp7_ = page_view_get_x_offset (_tmp6_);
#line 541 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp8_ = _tmp7_;
#line 541 "/home/bob/git/simple-scan/src/book-view.vala"
		x = (gint) ((_tmp3_ + _tmp5_) - _tmp8_);
#line 542 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp9_ = event->y;
#line 542 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp10_ = self->priv->selected_page_view;
#line 542 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp11_ = page_view_get_y_offset (_tmp10_);
#line 542 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp12_ = _tmp11_;
#line 542 "/home/bob/git/simple-scan/src/book-view.vala"
		y = (gint) (_tmp9_ - _tmp12_);
#line 543 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp13_ = self->priv->selected_page_view;
#line 543 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp14_ = x;
#line 543 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp15_ = y;
#line 543 "/home/bob/git/simple-scan/src/book-view.vala"
		page_view_motion (_tmp13_, _tmp14_, _tmp15_);
#line 544 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp16_ = self->priv->selected_page_view;
#line 544 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp17_ = page_view_get_cursor (_tmp16_);
#line 544 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp18_ = _tmp17_;
#line 544 "/home/bob/git/simple-scan/src/book-view.vala"
		cursor = _tmp18_;
#line 3224 "book-view.c"
	} else {
		gint x = 0;
		gint y = 0;
		PageView* over_page = NULL;
		gdouble _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gdouble _tmp22_;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		PageView* _tmp25_;
		PageView* _tmp26_;
#line 549 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp19_ = event->x;
#line 549 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp20_ = book_view_get_x_offset (self);
#line 549 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp21_ = _tmp20_;
#line 549 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp22_ = event->y;
#line 549 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp25_ = book_view_get_page_at (self, (gint) (_tmp19_ + _tmp21_), (gint) _tmp22_, &_tmp23_, &_tmp24_);
#line 549 "/home/bob/git/simple-scan/src/book-view.vala"
		x = _tmp23_;
#line 549 "/home/bob/git/simple-scan/src/book-view.vala"
		y = _tmp24_;
#line 549 "/home/bob/git/simple-scan/src/book-view.vala"
		over_page = _tmp25_;
#line 550 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp26_ = over_page;
#line 550 "/home/bob/git/simple-scan/src/book-view.vala"
		if (_tmp26_ != NULL) {
#line 3257 "book-view.c"
			PageView* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			PageView* _tmp30_;
			GdkCursorType _tmp31_;
			GdkCursorType _tmp32_;
#line 552 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp27_ = over_page;
#line 552 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp28_ = x;
#line 552 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp29_ = y;
#line 552 "/home/bob/git/simple-scan/src/book-view.vala"
			page_view_motion (_tmp27_, _tmp28_, _tmp29_);
#line 553 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp30_ = over_page;
#line 553 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp31_ = page_view_get_cursor (_tmp30_);
#line 553 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp32_ = _tmp31_;
#line 553 "/home/bob/git/simple-scan/src/book-view.vala"
			cursor = _tmp32_;
#line 3280 "book-view.c"
		}
#line 539 "/home/bob/git/simple-scan/src/book-view.vala"
		_page_view_unref0 (over_page);
#line 3284 "book-view.c"
	}
#line 557 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp33_ = cursor;
#line 557 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_set_cursor (self, _tmp33_);
#line 559 "/home/bob/git/simple-scan/src/book-view.vala"
	result = FALSE;
#line 559 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 3294 "book-view.c"
}


static gboolean
book_view_key_cb (BookView* self,
                  GtkWidget* widget,
                  GdkEventKey* event)
{
	gboolean result = FALSE;
	guint _tmp0_;
#line 562 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 562 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 562 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 564 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = event->keyval;
#line 564 "/home/bob/git/simple-scan/src/book-view.vala"
	switch (_tmp0_) {
#line 564 "/home/bob/git/simple-scan/src/book-view.vala"
		case 0xff50:
#line 3317 "book-view.c"
		{
			Book* _tmp1_;
			Page* _tmp2_;
			Page* _tmp3_;
#line 567 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp1_ = self->priv->_book;
#line 567 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp2_ = book_get_page (_tmp1_, 0);
#line 567 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp3_ = _tmp2_;
#line 567 "/home/bob/git/simple-scan/src/book-view.vala"
			book_view_set_selected_page (self, _tmp3_);
#line 567 "/home/bob/git/simple-scan/src/book-view.vala"
			_page_unref0 (_tmp3_);
#line 568 "/home/bob/git/simple-scan/src/book-view.vala"
			result = TRUE;
#line 568 "/home/bob/git/simple-scan/src/book-view.vala"
			return result;
#line 3336 "book-view.c"
		}
#line 564 "/home/bob/git/simple-scan/src/book-view.vala"
		case 0xff51:
#line 3340 "book-view.c"
		{
			PageView* _tmp4_;
			PageView* _tmp5_;
			PageView* _tmp6_;
#line 570 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp4_ = self->priv->selected_page_view;
#line 570 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp5_ = book_view_get_prev_page (self, _tmp4_);
#line 570 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp6_ = _tmp5_;
#line 570 "/home/bob/git/simple-scan/src/book-view.vala"
			book_view_select_page_view (self, _tmp6_);
#line 570 "/home/bob/git/simple-scan/src/book-view.vala"
			_page_view_unref0 (_tmp6_);
#line 571 "/home/bob/git/simple-scan/src/book-view.vala"
			result = TRUE;
#line 571 "/home/bob/git/simple-scan/src/book-view.vala"
			return result;
#line 3359 "book-view.c"
		}
#line 564 "/home/bob/git/simple-scan/src/book-view.vala"
		case 0xff53:
#line 3363 "book-view.c"
		{
			PageView* _tmp7_;
			PageView* _tmp8_;
			PageView* _tmp9_;
#line 573 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp7_ = self->priv->selected_page_view;
#line 573 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp8_ = book_view_get_next_page (self, _tmp7_);
#line 573 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp9_ = _tmp8_;
#line 573 "/home/bob/git/simple-scan/src/book-view.vala"
			book_view_select_page_view (self, _tmp9_);
#line 573 "/home/bob/git/simple-scan/src/book-view.vala"
			_page_view_unref0 (_tmp9_);
#line 574 "/home/bob/git/simple-scan/src/book-view.vala"
			result = TRUE;
#line 574 "/home/bob/git/simple-scan/src/book-view.vala"
			return result;
#line 3382 "book-view.c"
		}
#line 564 "/home/bob/git/simple-scan/src/book-view.vala"
		case 0xFF57:
#line 3386 "book-view.c"
		{
			Book* _tmp10_;
			Book* _tmp11_;
			guint _tmp12_;
			guint _tmp13_;
			Page* _tmp14_;
			Page* _tmp15_;
#line 576 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp10_ = self->priv->_book;
#line 576 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp11_ = self->priv->_book;
#line 576 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp12_ = book_get_n_pages (_tmp11_);
#line 576 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp13_ = _tmp12_;
#line 576 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp14_ = book_get_page (_tmp10_, ((gint) _tmp13_) - 1);
#line 576 "/home/bob/git/simple-scan/src/book-view.vala"
			_tmp15_ = _tmp14_;
#line 576 "/home/bob/git/simple-scan/src/book-view.vala"
			book_view_set_selected_page (self, _tmp15_);
#line 576 "/home/bob/git/simple-scan/src/book-view.vala"
			_page_unref0 (_tmp15_);
#line 577 "/home/bob/git/simple-scan/src/book-view.vala"
			result = TRUE;
#line 577 "/home/bob/git/simple-scan/src/book-view.vala"
			return result;
#line 3414 "book-view.c"
		}
		default:
		{
#line 580 "/home/bob/git/simple-scan/src/book-view.vala"
			result = FALSE;
#line 580 "/home/bob/git/simple-scan/src/book-view.vala"
			return result;
#line 3422 "book-view.c"
		}
	}
}


static gboolean
book_view_focus_cb (BookView* self,
                    GtkWidget* widget,
                    GdkEventFocus* event)
{
	gboolean result = FALSE;
	PageView* _tmp0_;
#line 584 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 584 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 584 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 586 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->selected_page_view;
#line 586 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_set_selected_page_view (self, _tmp0_);
#line 587 "/home/bob/git/simple-scan/src/book-view.vala"
	result = FALSE;
#line 587 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 3449 "book-view.c"
}


static void
book_view_scroll_cb (BookView* self,
                     GtkAdjustment* adjustment)
{
	gboolean _tmp0_;
#line 590 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 590 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (adjustment != NULL);
#line 592 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->laying_out;
#line 592 "/home/bob/git/simple-scan/src/book-view.vala"
	if (!_tmp0_) {
#line 593 "/home/bob/git/simple-scan/src/book-view.vala"
		book_view_redraw (self);
#line 3468 "book-view.c"
	}
}


void
book_view_redraw (BookView* self)
{
	GtkWidget* _tmp0_;
#line 596 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 598 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->drawing_area;
#line 598 "/home/bob/git/simple-scan/src/book-view.vala"
	gtk_widget_queue_draw (_tmp0_);
#line 3483 "book-view.c"
}


void
book_view_select_next_page (BookView* self)
{
	PageView* _tmp0_;
	PageView* _tmp1_;
	PageView* _tmp2_;
#line 601 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 603 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->selected_page_view;
#line 603 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp1_ = book_view_get_next_page (self, _tmp0_);
#line 603 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp2_ = _tmp1_;
#line 603 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_select_page_view (self, _tmp2_);
#line 603 "/home/bob/git/simple-scan/src/book-view.vala"
	_page_view_unref0 (_tmp2_);
#line 3505 "book-view.c"
}


void
book_view_select_prev_page (BookView* self)
{
	PageView* _tmp0_;
	PageView* _tmp1_;
	PageView* _tmp2_;
#line 606 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 608 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->selected_page_view;
#line 608 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp1_ = book_view_get_prev_page (self, _tmp0_);
#line 608 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp2_ = _tmp1_;
#line 608 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_select_page_view (self, _tmp2_);
#line 608 "/home/bob/git/simple-scan/src/book-view.vala"
	_page_view_unref0 (_tmp2_);
#line 3527 "book-view.c"
}


Book*
book_view_get_book (BookView* self)
{
	Book* result;
	Book* _tmp0_;
#line 18 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 18 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->_book;
#line 18 "/home/bob/git/simple-scan/src/book-view.vala"
	result = _tmp0_;
#line 18 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 3544 "book-view.c"
}


static gpointer
_book_ref0 (gpointer self)
{
#line 18 "/home/bob/git/simple-scan/src/book-view.vala"
	return self ? book_ref (self) : NULL;
#line 3553 "book-view.c"
}


static void
book_view_set_book (BookView* self,
                    Book* value)
{
#line 18 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 18 "/home/bob/git/simple-scan/src/book-view.vala"
	if (book_view_get_book (self) != value) {
#line 3565 "book-view.c"
		Book* _tmp0_;
#line 18 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp0_ = _book_ref0 (value);
#line 18 "/home/bob/git/simple-scan/src/book-view.vala"
		_book_unref0 (self->priv->_book);
#line 18 "/home/bob/git/simple-scan/src/book-view.vala"
		self->priv->_book = _tmp0_;
#line 18 "/home/bob/git/simple-scan/src/book-view.vala"
		g_object_notify_by_pspec ((GObject *) self, book_view_properties[BOOK_VIEW_BOOK_PROPERTY]);
#line 3575 "book-view.c"
	}
}


Page*
book_view_get_selected_page (BookView* self)
{
	Page* result;
	PageView* _tmp0_;
#line 30 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->selected_page_view;
#line 32 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp0_ != NULL) {
#line 3591 "book-view.c"
		PageView* _tmp1_;
		Page* _tmp2_;
		Page* _tmp3_;
#line 33 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp1_ = self->priv->selected_page_view;
#line 33 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp2_ = page_view_get_page (_tmp1_);
#line 33 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp3_ = _tmp2_;
#line 33 "/home/bob/git/simple-scan/src/book-view.vala"
		result = _tmp3_;
#line 33 "/home/bob/git/simple-scan/src/book-view.vala"
		return result;
#line 3605 "book-view.c"
	} else {
#line 35 "/home/bob/git/simple-scan/src/book-view.vala"
		result = NULL;
#line 35 "/home/bob/git/simple-scan/src/book-view.vala"
		return result;
#line 3611 "book-view.c"
	}
}


void
book_view_set_selected_page (BookView* self,
                             Page* value)
{
	Page* _tmp0_;
	Page* _tmp1_;
#line 37 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 39 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = book_view_get_selected_page (self);
#line 39 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp1_ = _tmp0_;
#line 39 "/home/bob/git/simple-scan/src/book-view.vala"
	if (_tmp1_ == value) {
#line 40 "/home/bob/git/simple-scan/src/book-view.vala"
		return;
#line 3632 "book-view.c"
	}
#line 42 "/home/bob/git/simple-scan/src/book-view.vala"
	if (value != NULL) {
#line 3636 "book-view.c"
		GHashTable* _tmp2_;
		gconstpointer _tmp3_;
#line 43 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp2_ = self->priv->page_data;
#line 43 "/home/bob/git/simple-scan/src/book-view.vala"
		_tmp3_ = g_hash_table_lookup (_tmp2_, value);
#line 43 "/home/bob/git/simple-scan/src/book-view.vala"
		book_view_select_page_view (self, (PageView*) _tmp3_);
#line 3645 "book-view.c"
	} else {
#line 45 "/home/bob/git/simple-scan/src/book-view.vala"
		book_view_select_page_view (self, NULL);
#line 3649 "book-view.c"
	}
#line 37 "/home/bob/git/simple-scan/src/book-view.vala"
	g_object_notify_by_pspec ((GObject *) self, book_view_properties[BOOK_VIEW_SELECTED_PAGE_PROPERTY]);
#line 3653 "book-view.c"
}


gint
book_view_get_x_offset (BookView* self)
{
	gint result;
	GtkAdjustment* _tmp0_;
#line 64 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 66 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->adjustment;
#line 66 "/home/bob/git/simple-scan/src/book-view.vala"
	result = (gint) gtk_adjustment_get_value (_tmp0_);
#line 66 "/home/bob/git/simple-scan/src/book-view.vala"
	return result;
#line 3670 "book-view.c"
}


void
book_view_set_x_offset (BookView* self,
                        gint value)
{
	GtkAdjustment* _tmp0_;
#line 68 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->adjustment;
#line 70 "/home/bob/git/simple-scan/src/book-view.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) value);
#line 68 "/home/bob/git/simple-scan/src/book-view.vala"
	g_object_notify_by_pspec ((GObject *) self, book_view_properties[BOOK_VIEW_X_OFFSET_PROPERTY]);
#line 3687 "book-view.c"
}


static void
g_cclosure_user_marshal_VOID__PAGE (GClosure * closure,
                                    GValue * return_value,
                                    guint n_param_values,
                                    const GValue * param_values,
                                    gpointer invocation_hint,
                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__PAGE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__PAGE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	g_return_if_fail (n_param_values == 2);
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		data1 = closure->data;
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		data2 = param_values->data[0].v_pointer;
#line 3713 "book-view.c"
	} else {
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		data1 = param_values->data[0].v_pointer;
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		data2 = closure->data;
#line 3719 "book-view.c"
	}
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	callback = (GMarshalFunc_VOID__PAGE) (marshal_data ? marshal_data : cc->callback);
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	callback (data1, value_get_page (param_values + 1), data2);
#line 3725 "book-view.c"
}


static void
book_view_class_init (BookViewClass * klass)
{
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_parent_class = g_type_class_peek_parent (klass);
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	g_type_class_add_private (klass, sizeof (BookViewPrivate));
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_book_view_get_property;
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_book_view_set_property;
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	G_OBJECT_CLASS (klass)->finalize = book_view_finalize;
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOK_VIEW_BOOK_PROPERTY, book_view_properties[BOOK_VIEW_BOOK_PROPERTY] = param_spec_book ("book", "book", "book", TYPE_BOOK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOK_VIEW_SELECTED_PAGE_PROPERTY, book_view_properties[BOOK_VIEW_SELECTED_PAGE_PROPERTY] = param_spec_page ("selected-page", "selected-page", "selected-page", TYPE_PAGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOK_VIEW_X_OFFSET_PROPERTY, book_view_properties[BOOK_VIEW_X_OFFSET_PROPERTY] = g_param_spec_int ("x-offset", "x-offset", "x-offset", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_signals[BOOK_VIEW_PAGE_SELECTED_SIGNAL] = g_signal_new ("page-selected", TYPE_BOOK_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_signals[BOOK_VIEW_SHOW_PAGE_SIGNAL] = g_signal_new ("show-page", TYPE_BOOK_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	book_view_signals[BOOK_VIEW_SHOW_MENU_SIGNAL] = g_signal_new ("show-menu", TYPE_BOOK_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3754 "book-view.c"
}


static void
book_view_instance_init (BookView * self)
{
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv = BOOK_VIEW_GET_PRIVATE (self);
#line 27 "/home/bob/git/simple-scan/src/book-view.vala"
	self->priv->selected_page_view = NULL;
#line 3765 "book-view.c"
}


static void
book_view_finalize (GObject * obj)
{
	BookView * self;
	Book* _tmp0_;
	guint _tmp1_;
	Book* _tmp2_;
	guint _tmp3_;
	Book* _tmp4_;
	guint _tmp5_;
	Book* _tmp6_;
	guint _tmp7_;
	GtkWidget* _tmp8_;
	guint _tmp9_;
	GtkWidget* _tmp10_;
	guint _tmp11_;
	GtkWidget* _tmp12_;
	guint _tmp13_;
	GtkWidget* _tmp14_;
	guint _tmp15_;
	GtkWidget* _tmp16_;
	guint _tmp17_;
	GtkWidget* _tmp18_;
	guint _tmp19_;
	GtkWidget* _tmp20_;
	guint _tmp21_;
	GtkWidget* _tmp22_;
	guint _tmp23_;
	GtkAdjustment* _tmp24_;
	guint _tmp25_;
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK_VIEW, BookView);
#line 123 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp0_ = self->priv->_book;
#line 123 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp1_, NULL, FALSE);
#line 123 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_view_add_cb_book_page_added, self);
#line 124 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp2_ = self->priv->_book;
#line 124 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp3_, NULL, FALSE);
#line 124 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_view_remove_cb_book_page_removed, self);
#line 125 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp4_ = self->priv->_book;
#line 125 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("reordered", TYPE_BOOK, &_tmp5_, NULL, FALSE);
#line 125 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_view_reorder_cb_book_reordered, self);
#line 126 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp6_ = self->priv->_book;
#line 126 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("cleared", TYPE_BOOK, &_tmp7_, NULL, FALSE);
#line 126 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _book_view_clear_cb_book_cleared, self);
#line 127 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp8_ = self->priv->drawing_area;
#line 127 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("configure-event", gtk_widget_get_type (), &_tmp9_, NULL, FALSE);
#line 127 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _book_view_configure_cb_gtk_widget_configure_event, self);
#line 128 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp10_ = self->priv->drawing_area;
#line 128 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("draw", gtk_widget_get_type (), &_tmp11_, NULL, FALSE);
#line 128 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _book_view_draw_cb_gtk_widget_draw, self);
#line 129 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp12_ = self->priv->drawing_area;
#line 129 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("motion-notify-event", gtk_widget_get_type (), &_tmp13_, NULL, FALSE);
#line 129 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _book_view_motion_cb_gtk_widget_motion_notify_event, self);
#line 130 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp14_ = self->priv->drawing_area;
#line 130 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("key-press-event", gtk_widget_get_type (), &_tmp15_, NULL, FALSE);
#line 130 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _book_view_key_cb_gtk_widget_key_press_event, self);
#line 131 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp16_ = self->priv->drawing_area;
#line 131 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("button-press-event", gtk_widget_get_type (), &_tmp17_, NULL, FALSE);
#line 131 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _book_view_button_cb_gtk_widget_button_press_event, self);
#line 132 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp18_ = self->priv->drawing_area;
#line 132 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("button-release-event", gtk_widget_get_type (), &_tmp19_, NULL, FALSE);
#line 132 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (_tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _book_view_button_cb_gtk_widget_button_release_event, self);
#line 133 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp20_ = self->priv->drawing_area;
#line 133 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("focus-in-event", gtk_widget_get_type (), &_tmp21_, NULL, FALSE);
#line 133 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (_tmp20_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp21_, 0, NULL, (GCallback) _book_view_focus_cb_gtk_widget_focus_in_event, self);
#line 134 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp22_ = self->priv->drawing_area;
#line 134 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("focus-out-event", gtk_widget_get_type (), &_tmp23_, NULL, FALSE);
#line 134 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _book_view_focus_cb_gtk_widget_focus_out_event, self);
#line 135 "/home/bob/git/simple-scan/src/book-view.vala"
	_tmp24_ = self->priv->adjustment;
#line 135 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp25_, NULL, FALSE);
#line 135 "/home/bob/git/simple-scan/src/book-view.vala"
	g_signal_handlers_disconnect_matched (_tmp24_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp25_, 0, NULL, (GCallback) _book_view_scroll_cb_gtk_adjustment_value_changed, self);
#line 18 "/home/bob/git/simple-scan/src/book-view.vala"
	_book_unref0 (self->priv->_book);
#line 19 "/home/bob/git/simple-scan/src/book-view.vala"
	_g_hash_table_unref0 (self->priv->page_data);
#line 27 "/home/bob/git/simple-scan/src/book-view.vala"
	_page_view_unref0 (self->priv->selected_page_view);
#line 50 "/home/bob/git/simple-scan/src/book-view.vala"
	_g_object_unref0 (self->priv->drawing_area);
#line 53 "/home/bob/git/simple-scan/src/book-view.vala"
	_g_object_unref0 (self->priv->scroll);
#line 54 "/home/bob/git/simple-scan/src/book-view.vala"
	_g_object_unref0 (self->priv->adjustment);
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	G_OBJECT_CLASS (book_view_parent_class)->finalize (obj);
#line 3893 "book-view.c"
}


GType
book_view_get_type (void)
{
	static volatile gsize book_view_type_id__volatile = 0;
	if (g_once_init_enter (&book_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BookViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookView), 0, (GInstanceInitFunc) book_view_instance_init, NULL };
		GType book_view_type_id;
		book_view_type_id = g_type_register_static (gtk_box_get_type (), "BookView", &g_define_type_info, 0);
		g_once_init_leave (&book_view_type_id__volatile, book_view_type_id);
	}
	return book_view_type_id__volatile;
}


static void
_vala_book_view_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	BookView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOK_VIEW, BookView);
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	switch (property_id) {
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		case BOOK_VIEW_BOOK_PROPERTY:
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		value_set_book (value, book_view_get_book (self));
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		break;
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		case BOOK_VIEW_SELECTED_PAGE_PROPERTY:
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		value_set_page (value, book_view_get_selected_page (self));
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		break;
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		case BOOK_VIEW_X_OFFSET_PROPERTY:
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		g_value_set_int (value, book_view_get_x_offset (self));
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		break;
#line 3939 "book-view.c"
		default:
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		break;
#line 3945 "book-view.c"
	}
}


static void
_vala_book_view_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	BookView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOK_VIEW, BookView);
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
	switch (property_id) {
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		case BOOK_VIEW_BOOK_PROPERTY:
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		book_view_set_book (self, value_get_book (value));
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		break;
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		case BOOK_VIEW_SELECTED_PAGE_PROPERTY:
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		book_view_set_selected_page (self, value_get_page (value));
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		break;
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		case BOOK_VIEW_X_OFFSET_PROPERTY:
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		book_view_set_x_offset (self, g_value_get_int (value));
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		break;
#line 3978 "book-view.c"
		default:
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 15 "/home/bob/git/simple-scan/src/book-view.vala"
		break;
#line 3984 "book-view.c"
	}
}



