/* page-view.c generated by valac 0.40.9, the Vala compiler
 * generated from page-view.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <string.h>
#include <stdlib.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CROP_LOCATION (crop_location_get_type ())

#define TYPE_PAGE_VIEW (page_view_get_type ())
#define PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_VIEW, PageView))
#define PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_VIEW, PageViewClass))
#define IS_PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_VIEW))
#define IS_PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_VIEW))
#define PAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_VIEW, PageViewClass))

typedef struct _PageView PageView;
typedef struct _PageViewClass PageViewClass;
typedef struct _PageViewPrivate PageViewPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecPageView ParamSpecPageView;
enum  {
	PAGE_VIEW_SIZE_CHANGED_SIGNAL,
	PAGE_VIEW_CHANGED_SIGNAL,
	PAGE_VIEW_NUM_SIGNALS
};
static guint page_view_signals[PAGE_VIEW_NUM_SIGNALS] = {0};

typedef enum  {
	CROP_LOCATION_NONE = 0,
	CROP_LOCATION_MIDDLE,
	CROP_LOCATION_TOP,
	CROP_LOCATION_BOTTOM,
	CROP_LOCATION_LEFT,
	CROP_LOCATION_RIGHT,
	CROP_LOCATION_TOP_LEFT,
	CROP_LOCATION_TOP_RIGHT,
	CROP_LOCATION_BOTTOM_LEFT,
	CROP_LOCATION_BOTTOM_RIGHT
} CropLocation;

struct _PageView {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PageViewPrivate * priv;
};

struct _PageViewClass {
	GTypeClass parent_class;
	void (*finalize) (PageView *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _PageViewPrivate {
	Page* _page;
	GdkPixbuf* image;
	gboolean selected_;
	gint border_width;
	gboolean update_image;
	ScanDirection scan_direction;
	gint scan_line;
	gint width_;
	gint height_;
	gint _x_offset;
	gint _y_offset;
	CropLocation crop_location;
	gdouble selected_crop_px;
	gdouble selected_crop_py;
	gint selected_crop_x;
	gint selected_crop_y;
	gint selected_crop_w;
	gint selected_crop_h;
	GdkCursorType _cursor;
	gint animate_n_segments;
	gint animate_segment;
	guint animate_timeout;
};

struct _ParamSpecPageView {
	GParamSpec parent_instance;
};


static gpointer page_view_parent_class = NULL;

GType crop_location_get_type (void) G_GNUC_CONST;
gpointer page_view_ref (gpointer instance);
void page_view_unref (gpointer instance);
GParamSpec* param_spec_page_view (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_page_view (GValue* value,
                          gpointer v_object);
void value_take_page_view (GValue* value,
                           gpointer v_object);
gpointer value_get_page_view (const GValue* value);
GType page_view_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_page (GValue* value,
                     gpointer v_object);
void value_take_page (GValue* value,
                      gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
GType scan_direction_get_type (void) G_GNUC_CONST;
#define PAGE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PAGE_VIEW, PageViewPrivate))
Page* page_view_get_page (PageView* self);
static void page_view_page_pixels_changed_cb (PageView* self,
                                       Page* p);
static void _page_view_page_pixels_changed_cb_page_pixels_changed (Page* _sender,
                                                            gpointer self);
static void page_view_page_size_changed_cb (PageView* self,
                                     Page* p);
static void _page_view_page_size_changed_cb_page_size_changed (Page* _sender,
                                                        gpointer self);
static void page_view_page_overlay_changed_cb (PageView* self,
                                        Page* p);
static void _page_view_page_overlay_changed_cb_page_crop_changed (Page* _sender,
                                                           gpointer self);
static void _page_view_page_overlay_changed_cb_page_scan_line_changed (Page* _sender,
                                                                gpointer self);
static void page_view_scan_direction_changed_cb (PageView* self,
                                          Page* p);
static void _page_view_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender,
                                                                       gpointer self);
PageView* page_view_new (Page* page);
PageView* page_view_construct (GType object_type,
                               Page* page);
static void page_view_set_page (PageView* self,
                         Page* value);
static guchar page_view_get_sample (PageView* self,
                             guchar* pixels,
                             int pixels_length1,
                             gint offset,
                             gint x,
                             gint depth,
                             gint sample);
static void page_view_get_pixel (PageView* self,
                          Page* page,
                          gint x,
                          gint y,
                          guchar* pixel,
                          int pixel_length1);
ScanDirection page_get_scan_direction (Page* self);
gint page_get_scan_width (Page* self);
gint page_get_scan_height (Page* self);
gint page_get_depth (Page* self);
gint page_get_n_channels (Page* self);
guchar* page_get_pixels (Page* self,
                         int* result_length1);
gint page_get_rowstride (Page* self);
static void page_view_set_pixel (PageView* self,
                          Page* page,
                          gdouble l,
                          gdouble r,
                          gdouble t,
                          gdouble b,
                          guchar* output,
                          int output_length1,
                          gint offset);
static void page_view_update_preview (PageView* self,
                               Page* page,
                               GdkPixbuf* * output_image,
                               gint output_width,
                               gint output_height,
                               ScanDirection scan_direction,
                               gint old_scan_line,
                               gint scan_line);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gboolean page_get_has_data (Page* self);
static gint page_view_get_preview_width (PageView* self);
static gint page_view_get_preview_height (PageView* self);
static void page_view_update_page_view (PageView* self);
gint page_get_scan_line (Page* self);
static gint page_view_page_to_screen_x (PageView* self,
                                 gint x);
static gint page_view_page_to_screen_y (PageView* self,
                                 gint y);
static gint page_view_screen_to_page_x (PageView* self,
                                 gint x);
static gint page_view_screen_to_page_y (PageView* self,
                                 gint y);
static CropLocation page_view_get_crop_location (PageView* self,
                                          gint x,
                                          gint y);
gboolean page_get_has_crop (Page* self);
gint page_get_crop_x (Page* self);
gint page_get_crop_y (Page* self);
gint page_get_crop_width (Page* self);
gint page_get_crop_height (Page* self);
const gchar* page_get_crop_name (Page* self);
void page_view_button_press (PageView* self,
                             gint x,
                             gint y);
void page_view_motion (PageView* self,
                       gint x,
                       gint y);
static void page_view_set_cursor (PageView* self,
                           GdkCursorType value);
void page_move_crop (Page* self,
                     gint x,
                     gint y);
void page_set_custom_crop (Page* self,
                           gint width,
                           gint height);
void page_view_button_release (PageView* self,
                               gint x,
                               gint y);
static gboolean page_view_animation_cb (PageView* self);
static void page_view_update_animation (PageView* self);
gboolean page_get_is_scanning (Page* self);
static gboolean _page_view_animation_cb_gsource_func (gpointer self);
void page_view_render (PageView* self,
                       cairo_t* context);
gint page_view_get_x_offset (PageView* self);
gint page_view_get_y_offset (PageView* self);
gboolean page_view_get_selected (PageView* self);
void page_view_set_selected (PageView* self,
                             gboolean value);
void page_view_set_x_offset (PageView* self,
                             gint value);
void page_view_set_y_offset (PageView* self,
                             gint value);
GdkCursorType page_view_get_cursor (PageView* self);
gint page_view_get_width (PageView* self);
void page_view_set_width (PageView* self,
                          gint value);
gint page_view_get_height (PageView* self);
void page_view_set_height (PageView* self,
                           gint value);
static void page_view_finalize (PageView * obj);


GType
crop_location_get_type (void)
{
	static volatile gsize crop_location_type_id__volatile = 0;
	if (g_once_init_enter (&crop_location_type_id__volatile)) {
		static const GEnumValue values[] = {{CROP_LOCATION_NONE, "CROP_LOCATION_NONE", "none"}, {CROP_LOCATION_MIDDLE, "CROP_LOCATION_MIDDLE", "middle"}, {CROP_LOCATION_TOP, "CROP_LOCATION_TOP", "top"}, {CROP_LOCATION_BOTTOM, "CROP_LOCATION_BOTTOM", "bottom"}, {CROP_LOCATION_LEFT, "CROP_LOCATION_LEFT", "left"}, {CROP_LOCATION_RIGHT, "CROP_LOCATION_RIGHT", "right"}, {CROP_LOCATION_TOP_LEFT, "CROP_LOCATION_TOP_LEFT", "top-left"}, {CROP_LOCATION_TOP_RIGHT, "CROP_LOCATION_TOP_RIGHT", "top-right"}, {CROP_LOCATION_BOTTOM_LEFT, "CROP_LOCATION_BOTTOM_LEFT", "bottom-left"}, {CROP_LOCATION_BOTTOM_RIGHT, "CROP_LOCATION_BOTTOM_RIGHT", "bottom-right"}, {0, NULL, NULL}};
		GType crop_location_type_id;
		crop_location_type_id = g_enum_register_static ("CropLocation", values);
		g_once_init_leave (&crop_location_type_id__volatile, crop_location_type_id);
	}
	return crop_location_type_id__volatile;
}


static void
_page_view_page_pixels_changed_cb_page_pixels_changed (Page* _sender,
                                                       gpointer self)
{
#line 97 "/home/bob/git/simple-scan/src/page-view.vala"
	page_view_page_pixels_changed_cb ((PageView*) self, _sender);
#line 304 "page-view.c"
}


static void
_page_view_page_size_changed_cb_page_size_changed (Page* _sender,
                                                   gpointer self)
{
#line 98 "/home/bob/git/simple-scan/src/page-view.vala"
	page_view_page_size_changed_cb ((PageView*) self, _sender);
#line 314 "page-view.c"
}


static void
_page_view_page_overlay_changed_cb_page_crop_changed (Page* _sender,
                                                      gpointer self)
{
#line 99 "/home/bob/git/simple-scan/src/page-view.vala"
	page_view_page_overlay_changed_cb ((PageView*) self, _sender);
#line 324 "page-view.c"
}


static void
_page_view_page_overlay_changed_cb_page_scan_line_changed (Page* _sender,
                                                           gpointer self)
{
#line 100 "/home/bob/git/simple-scan/src/page-view.vala"
	page_view_page_overlay_changed_cb ((PageView*) self, _sender);
#line 334 "page-view.c"
}


static void
_page_view_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender,
                                                                  gpointer self)
{
#line 101 "/home/bob/git/simple-scan/src/page-view.vala"
	page_view_scan_direction_changed_cb ((PageView*) self, _sender);
#line 344 "page-view.c"
}


PageView*
page_view_construct (GType object_type,
                     Page* page)
{
	PageView* self = NULL;
#line 85 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (page != NULL, NULL);
#line 85 "/home/bob/git/simple-scan/src/page-view.vala"
	self = (PageView*) g_type_create_instance (object_type);
#line 87 "/home/bob/git/simple-scan/src/page-view.vala"
	page_view_set_page (self, page);
#line 88 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_connect (page, "pixels-changed", (GCallback) _page_view_page_pixels_changed_cb_page_pixels_changed, self);
#line 89 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_connect (page, "size-changed", (GCallback) _page_view_page_size_changed_cb_page_size_changed, self);
#line 90 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_connect (page, "crop-changed", (GCallback) _page_view_page_overlay_changed_cb_page_crop_changed, self);
#line 91 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_connect (page, "scan-line-changed", (GCallback) _page_view_page_overlay_changed_cb_page_scan_line_changed, self);
#line 92 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_connect (page, "scan-direction-changed", (GCallback) _page_view_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 85 "/home/bob/git/simple-scan/src/page-view.vala"
	return self;
#line 371 "page-view.c"
}


PageView*
page_view_new (Page* page)
{
#line 85 "/home/bob/git/simple-scan/src/page-view.vala"
	return page_view_construct (TYPE_PAGE_VIEW, page);
#line 380 "page-view.c"
}


static guchar
page_view_get_sample (PageView* self,
                      guchar* pixels,
                      int pixels_length1,
                      gint offset,
                      gint x,
                      gint depth,
                      gint sample)
{
	guchar result = '\0';
#line 104 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 107 "/home/bob/git/simple-scan/src/page-view.vala"
	result = (guchar) 0xFF;
#line 107 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 400 "page-view.c"
}


static void
page_view_get_pixel (PageView* self,
                     Page* page,
                     gint x,
                     gint y,
                     guchar* pixel,
                     int pixel_length1)
{
	ScanDirection _tmp0_;
	ScanDirection _tmp1_;
	gint depth = 0;
	gint _tmp12_;
	gint _tmp13_;
	gint n_channels = 0;
	gint _tmp14_;
	gint _tmp15_;
	guchar* pixels = NULL;
	gint _tmp16_;
	guchar* _tmp17_;
	gint pixels_length1;
	gint _pixels_size_;
	gint offset = 0;
	gint _tmp18_;
	gint _tmp19_;
	gboolean _tmp20_ = FALSE;
	gint _tmp21_;
	guchar* _tmp71_;
	gint _tmp71__length1;
	gint _tmp72_;
	gint _tmp73_;
	gint _tmp74_;
	guchar _tmp75_;
	guchar* _tmp76_;
	gint _tmp76__length1;
	gint _tmp77_;
	gint _tmp78_;
	gint _tmp79_;
	guchar _tmp80_;
	guchar* _tmp81_;
	gint _tmp81__length1;
	gint _tmp82_;
	gint _tmp83_;
	gint _tmp84_;
	guchar _tmp85_;
#line 110 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 110 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (page != NULL);
#line 112 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = page_get_scan_direction (page);
#line 112 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = _tmp0_;
#line 112 "/home/bob/git/simple-scan/src/page-view.vala"
	switch (_tmp1_) {
#line 112 "/home/bob/git/simple-scan/src/page-view.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 460 "page-view.c"
		{
#line 115 "/home/bob/git/simple-scan/src/page-view.vala"
			break;
#line 464 "page-view.c"
		}
#line 112 "/home/bob/git/simple-scan/src/page-view.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 468 "page-view.c"
		{
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
#line 117 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp2_ = page_get_scan_width (page);
#line 117 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp3_ = _tmp2_;
#line 117 "/home/bob/git/simple-scan/src/page-view.vala"
			x = (_tmp3_ - x) - 1;
#line 118 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp4_ = page_get_scan_height (page);
#line 118 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp5_ = _tmp4_;
#line 118 "/home/bob/git/simple-scan/src/page-view.vala"
			y = (_tmp5_ - y) - 1;
#line 119 "/home/bob/git/simple-scan/src/page-view.vala"
			break;
#line 488 "page-view.c"
		}
#line 112 "/home/bob/git/simple-scan/src/page-view.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 492 "page-view.c"
		{
			gint t = 0;
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
#line 121 "/home/bob/git/simple-scan/src/page-view.vala"
			t = x;
#line 122 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp6_ = page_get_scan_width (page);
#line 122 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp7_ = _tmp6_;
#line 122 "/home/bob/git/simple-scan/src/page-view.vala"
			x = (_tmp7_ - y) - 1;
#line 123 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp8_ = t;
#line 123 "/home/bob/git/simple-scan/src/page-view.vala"
			y = _tmp8_;
#line 124 "/home/bob/git/simple-scan/src/page-view.vala"
			break;
#line 512 "page-view.c"
		}
#line 112 "/home/bob/git/simple-scan/src/page-view.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 516 "page-view.c"
		{
			gint t = 0;
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
#line 126 "/home/bob/git/simple-scan/src/page-view.vala"
			t = x;
#line 127 "/home/bob/git/simple-scan/src/page-view.vala"
			x = y;
#line 128 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp9_ = page_get_scan_height (page);
#line 128 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp10_ = _tmp9_;
#line 128 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp11_ = t;
#line 128 "/home/bob/git/simple-scan/src/page-view.vala"
			y = (_tmp10_ - _tmp11_) - 1;
#line 129 "/home/bob/git/simple-scan/src/page-view.vala"
			break;
#line 536 "page-view.c"
		}
		default:
#line 112 "/home/bob/git/simple-scan/src/page-view.vala"
		break;
#line 541 "page-view.c"
	}
#line 132 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp12_ = page_get_depth (page);
#line 132 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp13_ = _tmp12_;
#line 132 "/home/bob/git/simple-scan/src/page-view.vala"
	depth = _tmp13_;
#line 133 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp14_ = page_get_n_channels (page);
#line 133 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp15_ = _tmp14_;
#line 133 "/home/bob/git/simple-scan/src/page-view.vala"
	n_channels = _tmp15_;
#line 134 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp17_ = page_get_pixels (page, &_tmp16_);
#line 134 "/home/bob/git/simple-scan/src/page-view.vala"
	pixels = _tmp17_;
#line 134 "/home/bob/git/simple-scan/src/page-view.vala"
	pixels_length1 = _tmp16_;
#line 134 "/home/bob/git/simple-scan/src/page-view.vala"
	_pixels_size_ = pixels_length1;
#line 135 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp18_ = page_get_rowstride (page);
#line 135 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp19_ = _tmp18_;
#line 135 "/home/bob/git/simple-scan/src/page-view.vala"
	offset = _tmp19_ * y;
#line 138 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp21_ = depth;
#line 138 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp21_ == 8) {
#line 573 "page-view.c"
		gint _tmp22_;
#line 138 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp22_ = n_channels;
#line 138 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp20_ = _tmp22_ == 3;
#line 579 "page-view.c"
	} else {
#line 138 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp20_ = FALSE;
#line 583 "page-view.c"
	}
#line 138 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp20_) {
#line 587 "page-view.c"
		gint o = 0;
		gint _tmp23_;
		gint _tmp24_;
		guchar* _tmp25_;
		gint _tmp25__length1;
		gint _tmp26_;
		guchar _tmp27_;
		guchar _tmp28_;
		guchar* _tmp29_;
		gint _tmp29__length1;
		gint _tmp30_;
		guchar _tmp31_;
		guchar _tmp32_;
		guchar* _tmp33_;
		gint _tmp33__length1;
		gint _tmp34_;
		guchar _tmp35_;
		guchar _tmp36_;
#line 140 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp23_ = offset;
#line 140 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp24_ = n_channels;
#line 140 "/home/bob/git/simple-scan/src/page-view.vala"
		o = _tmp23_ + (x * _tmp24_);
#line 141 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp25_ = pixels;
#line 141 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp25__length1 = pixels_length1;
#line 141 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp26_ = o;
#line 141 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp27_ = _tmp25_[_tmp26_];
#line 141 "/home/bob/git/simple-scan/src/page-view.vala"
		pixel[0] = _tmp27_;
#line 141 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp28_ = pixel[0];
#line 142 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp29_ = pixels;
#line 142 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp29__length1 = pixels_length1;
#line 142 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp30_ = o;
#line 142 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp31_ = _tmp29_[_tmp30_ + 1];
#line 142 "/home/bob/git/simple-scan/src/page-view.vala"
		pixel[1] = _tmp31_;
#line 142 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp32_ = pixel[1];
#line 143 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp33_ = pixels;
#line 143 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp33__length1 = pixels_length1;
#line 143 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp34_ = o;
#line 143 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp35_ = _tmp33_[_tmp34_ + 2];
#line 143 "/home/bob/git/simple-scan/src/page-view.vala"
		pixel[2] = _tmp35_;
#line 143 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp36_ = pixel[2];
#line 144 "/home/bob/git/simple-scan/src/page-view.vala"
		return;
#line 650 "page-view.c"
	} else {
		gboolean _tmp37_ = FALSE;
		gint _tmp38_;
#line 146 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp38_ = depth;
#line 146 "/home/bob/git/simple-scan/src/page-view.vala"
		if (_tmp38_ == 8) {
#line 658 "page-view.c"
			gint _tmp39_;
#line 146 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp39_ = n_channels;
#line 146 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp37_ = _tmp39_ == 1;
#line 664 "page-view.c"
		} else {
#line 146 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp37_ = FALSE;
#line 668 "page-view.c"
		}
#line 146 "/home/bob/git/simple-scan/src/page-view.vala"
		if (_tmp37_) {
#line 672 "page-view.c"
			guchar* _tmp40_;
			gint _tmp40__length1;
			gint _tmp41_;
			guchar _tmp42_;
			guchar _tmp43_;
			guchar _tmp44_;
			guchar _tmp45_;
#line 148 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp40_ = pixels;
#line 148 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp40__length1 = pixels_length1;
#line 148 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp41_ = offset;
#line 148 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp42_ = _tmp40_[_tmp41_ + x];
#line 148 "/home/bob/git/simple-scan/src/page-view.vala"
			pixel[2] = _tmp42_;
#line 148 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp43_ = pixel[2];
#line 148 "/home/bob/git/simple-scan/src/page-view.vala"
			pixel[1] = _tmp43_;
#line 148 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp44_ = pixel[1];
#line 148 "/home/bob/git/simple-scan/src/page-view.vala"
			pixel[0] = _tmp44_;
#line 148 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp45_ = pixel[0];
#line 149 "/home/bob/git/simple-scan/src/page-view.vala"
			return;
#line 702 "page-view.c"
		} else {
			gboolean _tmp46_ = FALSE;
			gint _tmp47_;
#line 153 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp47_ = depth;
#line 153 "/home/bob/git/simple-scan/src/page-view.vala"
			if (_tmp47_ == 1) {
#line 710 "page-view.c"
				gint _tmp48_;
#line 153 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp48_ = n_channels;
#line 153 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp46_ = _tmp48_ == 1;
#line 716 "page-view.c"
			} else {
#line 153 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp46_ = FALSE;
#line 720 "page-view.c"
			}
#line 153 "/home/bob/git/simple-scan/src/page-view.vala"
			if (_tmp46_) {
#line 724 "page-view.c"
				gint o = 0;
				gint _tmp49_;
				gint _tmp50_ = 0;
				guchar* _tmp51_;
				gint _tmp51__length1;
				gint _tmp52_;
				guchar _tmp53_;
				guchar _tmp54_;
				guchar _tmp55_;
				guchar _tmp56_;
#line 155 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp49_ = offset;
#line 155 "/home/bob/git/simple-scan/src/page-view.vala"
				o = _tmp49_ + (x / 8);
#line 156 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp51_ = pixels;
#line 156 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp51__length1 = pixels_length1;
#line 156 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp52_ = o;
#line 156 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp53_ = _tmp51_[_tmp52_];
#line 156 "/home/bob/git/simple-scan/src/page-view.vala"
				if (((gint) (_tmp53_ & (0x80 >> (x % 8)))) != 0) {
#line 156 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp50_ = 0x00;
#line 751 "page-view.c"
				} else {
#line 156 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp50_ = 0xFF;
#line 755 "page-view.c"
				}
#line 156 "/home/bob/git/simple-scan/src/page-view.vala"
				pixel[2] = (guchar) _tmp50_;
#line 156 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp54_ = pixel[2];
#line 156 "/home/bob/git/simple-scan/src/page-view.vala"
				pixel[1] = _tmp54_;
#line 156 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp55_ = pixel[1];
#line 156 "/home/bob/git/simple-scan/src/page-view.vala"
				pixel[0] = _tmp55_;
#line 156 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp56_ = pixel[0];
#line 157 "/home/bob/git/simple-scan/src/page-view.vala"
				return;
#line 771 "page-view.c"
			} else {
				gboolean _tmp57_ = FALSE;
				gint _tmp58_;
#line 161 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp58_ = depth;
#line 161 "/home/bob/git/simple-scan/src/page-view.vala"
				if (_tmp58_ == 2) {
#line 779 "page-view.c"
					gint _tmp59_;
#line 161 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp59_ = n_channels;
#line 161 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp57_ = _tmp59_ == 1;
#line 785 "page-view.c"
				} else {
#line 161 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp57_ = FALSE;
#line 789 "page-view.c"
				}
#line 161 "/home/bob/git/simple-scan/src/page-view.vala"
				if (_tmp57_) {
#line 793 "page-view.c"
					gint block_shift[4] = {0};
					gint _tmp60_[4] = {0};
					gint o = 0;
					gint _tmp61_;
					gint sample = 0;
					guchar* _tmp62_;
					gint _tmp62__length1;
					gint _tmp63_;
					guchar _tmp64_;
					gint _tmp65_;
					gint _tmp66_;
					gint _tmp67_;
					guchar _tmp68_;
					guchar _tmp69_;
					guchar _tmp70_;
#line 163 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp60_[0] = 6;
#line 163 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp60_[1] = 4;
#line 163 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp60_[2] = 2;
#line 163 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp60_[3] = 0;
#line 163 "/home/bob/git/simple-scan/src/page-view.vala"
					memcpy (block_shift, _tmp60_, 4 * sizeof (gint));
#line 165 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp61_ = offset;
#line 165 "/home/bob/git/simple-scan/src/page-view.vala"
					o = _tmp61_ + (x / 4);
#line 166 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp62_ = pixels;
#line 166 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp62__length1 = pixels_length1;
#line 166 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp63_ = o;
#line 166 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp64_ = _tmp62_[_tmp63_];
#line 166 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp65_ = block_shift[x % 4];
#line 166 "/home/bob/git/simple-scan/src/page-view.vala"
					sample = (_tmp64_ >> _tmp65_) & 0x3;
#line 167 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp66_ = sample;
#line 167 "/home/bob/git/simple-scan/src/page-view.vala"
					sample = (_tmp66_ * 255) / 3;
#line 169 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp67_ = sample;
#line 169 "/home/bob/git/simple-scan/src/page-view.vala"
					pixel[2] = (guchar) _tmp67_;
#line 169 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp68_ = pixel[2];
#line 169 "/home/bob/git/simple-scan/src/page-view.vala"
					pixel[1] = _tmp68_;
#line 169 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp69_ = pixel[1];
#line 169 "/home/bob/git/simple-scan/src/page-view.vala"
					pixel[0] = _tmp69_;
#line 169 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp70_ = pixel[0];
#line 170 "/home/bob/git/simple-scan/src/page-view.vala"
					return;
#line 855 "page-view.c"
				}
			}
		}
	}
#line 174 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp71_ = pixels;
#line 174 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp71__length1 = pixels_length1;
#line 174 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp72_ = offset;
#line 174 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp73_ = depth;
#line 174 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp74_ = n_channels;
#line 174 "/home/bob/git/simple-scan/src/page-view.vala"
	pixel[0] = page_view_get_sample (self, _tmp71_, _tmp71__length1, _tmp72_, x, _tmp73_, x * _tmp74_);
#line 174 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp75_ = pixel[0];
#line 175 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp76_ = pixels;
#line 175 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp76__length1 = pixels_length1;
#line 175 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp77_ = offset;
#line 175 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp78_ = depth;
#line 175 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp79_ = n_channels;
#line 175 "/home/bob/git/simple-scan/src/page-view.vala"
	pixel[1] = page_view_get_sample (self, _tmp76_, _tmp76__length1, _tmp77_, x, _tmp78_, (x * _tmp79_) + 1);
#line 175 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp80_ = pixel[1];
#line 176 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp81_ = pixels;
#line 176 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp81__length1 = pixels_length1;
#line 176 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp82_ = offset;
#line 176 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp83_ = depth;
#line 176 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp84_ = n_channels;
#line 176 "/home/bob/git/simple-scan/src/page-view.vala"
	pixel[2] = page_view_get_sample (self, _tmp81_, _tmp81__length1, _tmp82_, x, _tmp83_, (x * _tmp84_) + 2);
#line 176 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp85_ = pixel[2];
#line 902 "page-view.c"
}


static void
page_view_set_pixel (PageView* self,
                     Page* page,
                     gdouble l,
                     gdouble r,
                     gdouble t,
                     gdouble b,
                     guchar* output,
                     int output_length1,
                     gint offset)
{
	gint L = 0;
	gint _tmp0_;
	gint R = 0;
	gint T = 0;
	gint _tmp2_;
	gint B = 0;
	gdouble red = 0.0;
	gdouble green = 0.0;
	gdouble blue = 0.0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp171_ = FALSE;
	gint _tmp172_;
	gboolean _tmp188_ = FALSE;
	gint _tmp189_;
	gboolean _tmp205_ = FALSE;
	gint _tmp206_;
	gboolean _tmp222_ = FALSE;
	gint _tmp223_;
	gdouble scale = 0.0;
	gdouble _tmp239_;
	gdouble _tmp240_;
	guchar _tmp241_;
	gdouble _tmp242_;
	gdouble _tmp243_;
	guchar _tmp244_;
	gdouble _tmp245_;
	gdouble _tmp246_;
	guchar _tmp247_;
#line 179 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 179 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (page != NULL);
#line 225 "/home/bob/git/simple-scan/src/page-view.vala"
	L = (gint) l;
#line 226 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = L;
#line 226 "/home/bob/git/simple-scan/src/page-view.vala"
	if (((gdouble) _tmp0_) != l) {
#line 956 "page-view.c"
		gint _tmp1_;
#line 227 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp1_ = L;
#line 227 "/home/bob/git/simple-scan/src/page-view.vala"
		L = _tmp1_ + 1;
#line 962 "page-view.c"
	}
#line 228 "/home/bob/git/simple-scan/src/page-view.vala"
	R = (gint) r;
#line 229 "/home/bob/git/simple-scan/src/page-view.vala"
	T = (gint) t;
#line 230 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp2_ = T;
#line 230 "/home/bob/git/simple-scan/src/page-view.vala"
	if (((gdouble) _tmp2_) != t) {
#line 972 "page-view.c"
		gint _tmp3_;
#line 231 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp3_ = T;
#line 231 "/home/bob/git/simple-scan/src/page-view.vala"
		T = _tmp3_ + 1;
#line 978 "page-view.c"
	}
#line 232 "/home/bob/git/simple-scan/src/page-view.vala"
	B = (gint) b;
#line 234 "/home/bob/git/simple-scan/src/page-view.vala"
	red = 0.0;
#line 235 "/home/bob/git/simple-scan/src/page-view.vala"
	green = 0.0;
#line 236 "/home/bob/git/simple-scan/src/page-view.vala"
	blue = 0.0;
#line 247 "/home/bob/git/simple-scan/src/page-view.vala"
	if ((r - l) <= 1.0) {
#line 247 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp5_ = ((gint) r) == ((gint) l);
#line 992 "page-view.c"
	} else {
#line 247 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp5_ = FALSE;
#line 996 "page-view.c"
	}
#line 247 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp5_) {
#line 247 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp4_ = TRUE;
#line 1002 "page-view.c"
	} else {
		gboolean _tmp6_ = FALSE;
#line 247 "/home/bob/git/simple-scan/src/page-view.vala"
		if ((b - t) <= 1.0) {
#line 247 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp6_ = ((gint) b) == ((gint) t);
#line 1009 "page-view.c"
		} else {
#line 247 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp6_ = FALSE;
#line 1013 "page-view.c"
		}
#line 247 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp4_ = _tmp6_;
#line 1017 "page-view.c"
	}
#line 247 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp4_) {
#line 1021 "page-view.c"
		gboolean _tmp7_ = FALSE;
		gint _tmp14_;
		gint _tmp15_;
		gdouble scale = 0.0;
		gdouble _tmp86_;
		gdouble _tmp87_;
		guchar _tmp88_;
		gdouble _tmp89_;
		gdouble _tmp90_;
		guchar _tmp91_;
		gdouble _tmp92_;
		gdouble _tmp93_;
		guchar _tmp94_;
#line 250 "/home/bob/git/simple-scan/src/page-view.vala"
		if (((gint) l) == ((gint) r)) {
#line 250 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp7_ = TRUE;
#line 1039 "page-view.c"
		} else {
#line 250 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp7_ = ((gint) t) == ((gint) b);
#line 1043 "page-view.c"
		}
#line 250 "/home/bob/git/simple-scan/src/page-view.vala"
		if (_tmp7_) {
#line 1047 "page-view.c"
			guchar p[3] = {0};
			guchar _tmp8_;
			guchar _tmp9_;
			guchar _tmp10_;
			guchar _tmp11_;
			guchar _tmp12_;
			guchar _tmp13_;
#line 253 "/home/bob/git/simple-scan/src/page-view.vala"
			page_view_get_pixel (self, page, (gint) l, (gint) t, p, 3);
#line 254 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp8_ = p[0];
#line 254 "/home/bob/git/simple-scan/src/page-view.vala"
			output[offset] = _tmp8_;
#line 254 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp9_ = output[offset];
#line 255 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp10_ = p[1];
#line 255 "/home/bob/git/simple-scan/src/page-view.vala"
			output[offset + 1] = _tmp10_;
#line 255 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp11_ = output[offset + 1];
#line 256 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp12_ = p[2];
#line 256 "/home/bob/git/simple-scan/src/page-view.vala"
			output[offset + 2] = _tmp12_;
#line 256 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp13_ = output[offset + 2];
#line 257 "/home/bob/git/simple-scan/src/page-view.vala"
			return;
#line 1077 "page-view.c"
		}
#line 261 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp14_ = L;
#line 261 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp15_ = R;
#line 261 "/home/bob/git/simple-scan/src/page-view.vala"
		if (_tmp14_ > _tmp15_) {
#line 1085 "page-view.c"
			guchar p[3] = {0};
			gint _tmp16_;
			gint _tmp17_;
			gdouble _tmp18_;
			guchar _tmp19_;
			gint _tmp20_;
			gdouble _tmp21_;
			guchar _tmp22_;
			gint _tmp23_;
			gdouble _tmp24_;
			guchar _tmp25_;
			gint _tmp26_;
			gint _tmp40_;
			gint _tmp41_;
			gdouble _tmp42_;
			guchar _tmp43_;
			gint _tmp44_;
			gdouble _tmp45_;
			guchar _tmp46_;
			gint _tmp47_;
			gdouble _tmp48_;
			guchar _tmp49_;
			gint _tmp50_;
#line 264 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp16_ = R;
#line 264 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp17_ = T;
#line 264 "/home/bob/git/simple-scan/src/page-view.vala"
			page_view_get_pixel (self, page, _tmp16_, _tmp17_ - 1, p, 3);
#line 265 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp18_ = red;
#line 265 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp19_ = p[0];
#line 265 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp20_ = T;
#line 265 "/home/bob/git/simple-scan/src/page-view.vala"
			red = _tmp18_ + ((_tmp19_ * (r - l)) * (_tmp20_ - t));
#line 266 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp21_ = green;
#line 266 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp22_ = p[1];
#line 266 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp23_ = T;
#line 266 "/home/bob/git/simple-scan/src/page-view.vala"
			green = _tmp21_ + ((_tmp22_ * (r - l)) * (_tmp23_ - t));
#line 267 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp24_ = blue;
#line 267 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp25_ = p[2];
#line 267 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp26_ = T;
#line 267 "/home/bob/git/simple-scan/src/page-view.vala"
			blue = _tmp24_ + ((_tmp25_ * (r - l)) * (_tmp26_ - t));
#line 1139 "page-view.c"
			{
				gint y = 0;
				gint _tmp27_;
#line 268 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp27_ = T;
#line 268 "/home/bob/git/simple-scan/src/page-view.vala"
				y = _tmp27_;
#line 1147 "page-view.c"
				{
					gboolean _tmp28_ = FALSE;
#line 268 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp28_ = TRUE;
#line 268 "/home/bob/git/simple-scan/src/page-view.vala"
					while (TRUE) {
#line 1154 "page-view.c"
						gint _tmp30_;
						gint _tmp31_;
						gint _tmp32_;
						gint _tmp33_;
						gdouble _tmp34_;
						guchar _tmp35_;
						gdouble _tmp36_;
						guchar _tmp37_;
						gdouble _tmp38_;
						guchar _tmp39_;
#line 268 "/home/bob/git/simple-scan/src/page-view.vala"
						if (!_tmp28_) {
#line 1167 "page-view.c"
							gint _tmp29_;
#line 268 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp29_ = y;
#line 268 "/home/bob/git/simple-scan/src/page-view.vala"
							y = _tmp29_ + 1;
#line 1173 "page-view.c"
						}
#line 268 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp28_ = FALSE;
#line 268 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp30_ = y;
#line 268 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp31_ = B;
#line 268 "/home/bob/git/simple-scan/src/page-view.vala"
						if (!(_tmp30_ < _tmp31_)) {
#line 268 "/home/bob/git/simple-scan/src/page-view.vala"
							break;
#line 1185 "page-view.c"
						}
#line 270 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp32_ = R;
#line 270 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp33_ = y;
#line 270 "/home/bob/git/simple-scan/src/page-view.vala"
						page_view_get_pixel (self, page, _tmp32_, _tmp33_, p, 3);
#line 271 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp34_ = red;
#line 271 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp35_ = p[0];
#line 271 "/home/bob/git/simple-scan/src/page-view.vala"
						red = _tmp34_ + (_tmp35_ * (r - l));
#line 272 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp36_ = green;
#line 272 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp37_ = p[1];
#line 272 "/home/bob/git/simple-scan/src/page-view.vala"
						green = _tmp36_ + (_tmp37_ * (r - l));
#line 273 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp38_ = blue;
#line 273 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp39_ = p[2];
#line 273 "/home/bob/git/simple-scan/src/page-view.vala"
						blue = _tmp38_ + (_tmp39_ * (r - l));
#line 1211 "page-view.c"
					}
				}
			}
#line 275 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp40_ = R;
#line 275 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp41_ = B;
#line 275 "/home/bob/git/simple-scan/src/page-view.vala"
			page_view_get_pixel (self, page, _tmp40_, _tmp41_, p, 3);
#line 276 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp42_ = red;
#line 276 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp43_ = p[0];
#line 276 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp44_ = B;
#line 276 "/home/bob/git/simple-scan/src/page-view.vala"
			red = _tmp42_ + ((_tmp43_ * (r - l)) * (b - _tmp44_));
#line 277 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp45_ = green;
#line 277 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp46_ = p[1];
#line 277 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp47_ = B;
#line 277 "/home/bob/git/simple-scan/src/page-view.vala"
			green = _tmp45_ + ((_tmp46_ * (r - l)) * (b - _tmp47_));
#line 278 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp48_ = blue;
#line 278 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp49_ = p[2];
#line 278 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp50_ = B;
#line 278 "/home/bob/git/simple-scan/src/page-view.vala"
			blue = _tmp48_ + ((_tmp49_ * (r - l)) * (b - _tmp50_));
#line 1245 "page-view.c"
		} else {
			guchar p[3] = {0};
			gint _tmp51_;
			gint _tmp52_;
			gdouble _tmp53_;
			guchar _tmp54_;
			gint _tmp55_;
			gdouble _tmp56_;
			guchar _tmp57_;
			gint _tmp58_;
			gdouble _tmp59_;
			guchar _tmp60_;
			gint _tmp61_;
			gint _tmp75_;
			gint _tmp76_;
			gdouble _tmp77_;
			guchar _tmp78_;
			gint _tmp79_;
			gdouble _tmp80_;
			guchar _tmp81_;
			gint _tmp82_;
			gdouble _tmp83_;
			guchar _tmp84_;
			gint _tmp85_;
#line 284 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp51_ = L;
#line 284 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp52_ = B;
#line 284 "/home/bob/git/simple-scan/src/page-view.vala"
			page_view_get_pixel (self, page, _tmp51_ - 1, _tmp52_, p, 3);
#line 285 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp53_ = red;
#line 285 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp54_ = p[0];
#line 285 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp55_ = L;
#line 285 "/home/bob/git/simple-scan/src/page-view.vala"
			red = _tmp53_ + ((_tmp54_ * (b - t)) * (_tmp55_ - l));
#line 286 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp56_ = green;
#line 286 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp57_ = p[1];
#line 286 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp58_ = L;
#line 286 "/home/bob/git/simple-scan/src/page-view.vala"
			green = _tmp56_ + ((_tmp57_ * (b - t)) * (_tmp58_ - l));
#line 287 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp59_ = blue;
#line 287 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp60_ = p[2];
#line 287 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp61_ = L;
#line 287 "/home/bob/git/simple-scan/src/page-view.vala"
			blue = _tmp59_ + ((_tmp60_ * (b - t)) * (_tmp61_ - l));
#line 1300 "page-view.c"
			{
				gint x = 0;
				gint _tmp62_;
#line 288 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp62_ = L;
#line 288 "/home/bob/git/simple-scan/src/page-view.vala"
				x = _tmp62_;
#line 1308 "page-view.c"
				{
					gboolean _tmp63_ = FALSE;
#line 288 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp63_ = TRUE;
#line 288 "/home/bob/git/simple-scan/src/page-view.vala"
					while (TRUE) {
#line 1315 "page-view.c"
						gint _tmp65_;
						gint _tmp66_;
						gint _tmp67_;
						gint _tmp68_;
						gdouble _tmp69_;
						guchar _tmp70_;
						gdouble _tmp71_;
						guchar _tmp72_;
						gdouble _tmp73_;
						guchar _tmp74_;
#line 288 "/home/bob/git/simple-scan/src/page-view.vala"
						if (!_tmp63_) {
#line 1328 "page-view.c"
							gint _tmp64_;
#line 288 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp64_ = x;
#line 288 "/home/bob/git/simple-scan/src/page-view.vala"
							x = _tmp64_ + 1;
#line 1334 "page-view.c"
						}
#line 288 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp63_ = FALSE;
#line 288 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp65_ = x;
#line 288 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp66_ = R;
#line 288 "/home/bob/git/simple-scan/src/page-view.vala"
						if (!(_tmp65_ < _tmp66_)) {
#line 288 "/home/bob/git/simple-scan/src/page-view.vala"
							break;
#line 1346 "page-view.c"
						}
#line 289 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp67_ = x;
#line 289 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp68_ = B;
#line 289 "/home/bob/git/simple-scan/src/page-view.vala"
						page_view_get_pixel (self, page, _tmp67_, _tmp68_, p, 3);
#line 290 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp69_ = red;
#line 290 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp70_ = p[0];
#line 290 "/home/bob/git/simple-scan/src/page-view.vala"
						red = _tmp69_ + (_tmp70_ * (b - t));
#line 291 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp71_ = green;
#line 291 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp72_ = p[1];
#line 291 "/home/bob/git/simple-scan/src/page-view.vala"
						green = _tmp71_ + (_tmp72_ * (b - t));
#line 292 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp73_ = blue;
#line 292 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp74_ = p[2];
#line 292 "/home/bob/git/simple-scan/src/page-view.vala"
						blue = _tmp73_ + (_tmp74_ * (b - t));
#line 1372 "page-view.c"
					}
				}
			}
#line 294 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp75_ = R;
#line 294 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp76_ = B;
#line 294 "/home/bob/git/simple-scan/src/page-view.vala"
			page_view_get_pixel (self, page, _tmp75_, _tmp76_, p, 3);
#line 295 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp77_ = red;
#line 295 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp78_ = p[0];
#line 295 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp79_ = R;
#line 295 "/home/bob/git/simple-scan/src/page-view.vala"
			red = _tmp77_ + ((_tmp78_ * (b - t)) * (r - _tmp79_));
#line 296 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp80_ = green;
#line 296 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp81_ = p[1];
#line 296 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp82_ = R;
#line 296 "/home/bob/git/simple-scan/src/page-view.vala"
			green = _tmp80_ + ((_tmp81_ * (b - t)) * (r - _tmp82_));
#line 297 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp83_ = blue;
#line 297 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp84_ = p[2];
#line 297 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp85_ = R;
#line 297 "/home/bob/git/simple-scan/src/page-view.vala"
			blue = _tmp83_ + ((_tmp84_ * (b - t)) * (r - _tmp85_));
#line 1406 "page-view.c"
		}
#line 300 "/home/bob/git/simple-scan/src/page-view.vala"
		scale = 1.0 / ((r - l) * (b - t));
#line 301 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp86_ = red;
#line 301 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp87_ = scale;
#line 301 "/home/bob/git/simple-scan/src/page-view.vala"
		output[offset] = (guchar) ((_tmp86_ * _tmp87_) + 0.5);
#line 301 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp88_ = output[offset];
#line 302 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp89_ = green;
#line 302 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp90_ = scale;
#line 302 "/home/bob/git/simple-scan/src/page-view.vala"
		output[offset + 1] = (guchar) ((_tmp89_ * _tmp90_) + 0.5);
#line 302 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp91_ = output[offset + 1];
#line 303 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp92_ = blue;
#line 303 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp93_ = scale;
#line 303 "/home/bob/git/simple-scan/src/page-view.vala"
		output[offset + 2] = (guchar) ((_tmp92_ * _tmp93_) + 0.5);
#line 303 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp94_ = output[offset + 2];
#line 304 "/home/bob/git/simple-scan/src/page-view.vala"
		return;
#line 1436 "page-view.c"
	}
	{
		gint x = 0;
		gint _tmp95_;
#line 308 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp95_ = L;
#line 308 "/home/bob/git/simple-scan/src/page-view.vala"
		x = _tmp95_;
#line 1445 "page-view.c"
		{
			gboolean _tmp96_ = FALSE;
#line 308 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp96_ = TRUE;
#line 308 "/home/bob/git/simple-scan/src/page-view.vala"
			while (TRUE) {
#line 1452 "page-view.c"
				gint _tmp98_;
				gint _tmp99_;
#line 308 "/home/bob/git/simple-scan/src/page-view.vala"
				if (!_tmp96_) {
#line 1457 "page-view.c"
					gint _tmp97_;
#line 308 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp97_ = x;
#line 308 "/home/bob/git/simple-scan/src/page-view.vala"
					x = _tmp97_ + 1;
#line 1463 "page-view.c"
				}
#line 308 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp96_ = FALSE;
#line 308 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp98_ = x;
#line 308 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp99_ = R;
#line 308 "/home/bob/git/simple-scan/src/page-view.vala"
				if (!(_tmp98_ < _tmp99_)) {
#line 308 "/home/bob/git/simple-scan/src/page-view.vala"
					break;
#line 1475 "page-view.c"
				}
				{
					gint y = 0;
					gint _tmp100_;
#line 310 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp100_ = T;
#line 310 "/home/bob/git/simple-scan/src/page-view.vala"
					y = _tmp100_;
#line 1484 "page-view.c"
					{
						gboolean _tmp101_ = FALSE;
#line 310 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp101_ = TRUE;
#line 310 "/home/bob/git/simple-scan/src/page-view.vala"
						while (TRUE) {
#line 1491 "page-view.c"
							gint _tmp103_;
							gint _tmp104_;
							guchar p[3] = {0};
							gint _tmp105_;
							gint _tmp106_;
							gdouble _tmp107_;
							guchar _tmp108_;
							gdouble _tmp109_;
							guchar _tmp110_;
							gdouble _tmp111_;
							guchar _tmp112_;
#line 310 "/home/bob/git/simple-scan/src/page-view.vala"
							if (!_tmp101_) {
#line 1505 "page-view.c"
								gint _tmp102_;
#line 310 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp102_ = y;
#line 310 "/home/bob/git/simple-scan/src/page-view.vala"
								y = _tmp102_ + 1;
#line 1511 "page-view.c"
							}
#line 310 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp101_ = FALSE;
#line 310 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp103_ = y;
#line 310 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp104_ = B;
#line 310 "/home/bob/git/simple-scan/src/page-view.vala"
							if (!(_tmp103_ < _tmp104_)) {
#line 310 "/home/bob/git/simple-scan/src/page-view.vala"
								break;
#line 1523 "page-view.c"
							}
#line 313 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp105_ = x;
#line 313 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp106_ = y;
#line 313 "/home/bob/git/simple-scan/src/page-view.vala"
							page_view_get_pixel (self, page, _tmp105_, _tmp106_, p, 3);
#line 314 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp107_ = red;
#line 314 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp108_ = p[0];
#line 314 "/home/bob/git/simple-scan/src/page-view.vala"
							red = _tmp107_ + _tmp108_;
#line 315 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp109_ = green;
#line 315 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp110_ = p[1];
#line 315 "/home/bob/git/simple-scan/src/page-view.vala"
							green = _tmp109_ + _tmp110_;
#line 316 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp111_ = blue;
#line 316 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp112_ = p[2];
#line 316 "/home/bob/git/simple-scan/src/page-view.vala"
							blue = _tmp111_ + _tmp112_;
#line 1549 "page-view.c"
						}
					}
				}
			}
		}
	}
	{
		gint x = 0;
		gint _tmp113_;
#line 321 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp113_ = L;
#line 321 "/home/bob/git/simple-scan/src/page-view.vala"
		x = _tmp113_;
#line 1563 "page-view.c"
		{
			gboolean _tmp114_ = FALSE;
#line 321 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp114_ = TRUE;
#line 321 "/home/bob/git/simple-scan/src/page-view.vala"
			while (TRUE) {
#line 1570 "page-view.c"
				gint _tmp116_;
				gint _tmp117_;
				gint _tmp118_;
				gint _tmp130_;
#line 321 "/home/bob/git/simple-scan/src/page-view.vala"
				if (!_tmp114_) {
#line 1577 "page-view.c"
					gint _tmp115_;
#line 321 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp115_ = x;
#line 321 "/home/bob/git/simple-scan/src/page-view.vala"
					x = _tmp115_ + 1;
#line 1583 "page-view.c"
				}
#line 321 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp114_ = FALSE;
#line 321 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp116_ = x;
#line 321 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp117_ = R;
#line 321 "/home/bob/git/simple-scan/src/page-view.vala"
				if (!(_tmp116_ < _tmp117_)) {
#line 321 "/home/bob/git/simple-scan/src/page-view.vala"
					break;
#line 1595 "page-view.c"
				}
#line 323 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp118_ = T;
#line 323 "/home/bob/git/simple-scan/src/page-view.vala"
				if (t != ((gdouble) _tmp118_)) {
#line 1601 "page-view.c"
					guchar p[3] = {0};
					gint _tmp119_;
					gint _tmp120_;
					gdouble _tmp121_;
					guchar _tmp122_;
					gint _tmp123_;
					gdouble _tmp124_;
					guchar _tmp125_;
					gint _tmp126_;
					gdouble _tmp127_;
					guchar _tmp128_;
					gint _tmp129_;
#line 326 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp119_ = x;
#line 326 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp120_ = T;
#line 326 "/home/bob/git/simple-scan/src/page-view.vala"
					page_view_get_pixel (self, page, _tmp119_, _tmp120_ - 1, p, 3);
#line 327 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp121_ = red;
#line 327 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp122_ = p[0];
#line 327 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp123_ = T;
#line 327 "/home/bob/git/simple-scan/src/page-view.vala"
					red = _tmp121_ + (_tmp122_ * (_tmp123_ - t));
#line 328 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp124_ = green;
#line 328 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp125_ = p[1];
#line 328 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp126_ = T;
#line 328 "/home/bob/git/simple-scan/src/page-view.vala"
					green = _tmp124_ + (_tmp125_ * (_tmp126_ - t));
#line 329 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp127_ = blue;
#line 329 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp128_ = p[2];
#line 329 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp129_ = T;
#line 329 "/home/bob/git/simple-scan/src/page-view.vala"
					blue = _tmp127_ + (_tmp128_ * (_tmp129_ - t));
#line 1644 "page-view.c"
				}
#line 332 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp130_ = B;
#line 332 "/home/bob/git/simple-scan/src/page-view.vala"
				if (b != ((gdouble) _tmp130_)) {
#line 1650 "page-view.c"
					guchar p[3] = {0};
					gint _tmp131_;
					gint _tmp132_;
					gdouble _tmp133_;
					guchar _tmp134_;
					gint _tmp135_;
					gdouble _tmp136_;
					guchar _tmp137_;
					gint _tmp138_;
					gdouble _tmp139_;
					guchar _tmp140_;
					gint _tmp141_;
#line 335 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp131_ = x;
#line 335 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp132_ = B;
#line 335 "/home/bob/git/simple-scan/src/page-view.vala"
					page_view_get_pixel (self, page, _tmp131_, _tmp132_, p, 3);
#line 336 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp133_ = red;
#line 336 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp134_ = p[0];
#line 336 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp135_ = B;
#line 336 "/home/bob/git/simple-scan/src/page-view.vala"
					red = _tmp133_ + (_tmp134_ * (b - _tmp135_));
#line 337 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp136_ = green;
#line 337 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp137_ = p[1];
#line 337 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp138_ = B;
#line 337 "/home/bob/git/simple-scan/src/page-view.vala"
					green = _tmp136_ + (_tmp137_ * (b - _tmp138_));
#line 338 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp139_ = blue;
#line 338 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp140_ = p[2];
#line 338 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp141_ = B;
#line 338 "/home/bob/git/simple-scan/src/page-view.vala"
					blue = _tmp139_ + (_tmp140_ * (b - _tmp141_));
#line 1693 "page-view.c"
				}
			}
		}
	}
	{
		gint y = 0;
		gint _tmp142_;
#line 343 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp142_ = T;
#line 343 "/home/bob/git/simple-scan/src/page-view.vala"
		y = _tmp142_;
#line 1705 "page-view.c"
		{
			gboolean _tmp143_ = FALSE;
#line 343 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp143_ = TRUE;
#line 343 "/home/bob/git/simple-scan/src/page-view.vala"
			while (TRUE) {
#line 1712 "page-view.c"
				gint _tmp145_;
				gint _tmp146_;
				gint _tmp147_;
				gint _tmp159_;
#line 343 "/home/bob/git/simple-scan/src/page-view.vala"
				if (!_tmp143_) {
#line 1719 "page-view.c"
					gint _tmp144_;
#line 343 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp144_ = y;
#line 343 "/home/bob/git/simple-scan/src/page-view.vala"
					y = _tmp144_ + 1;
#line 1725 "page-view.c"
				}
#line 343 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp143_ = FALSE;
#line 343 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp145_ = y;
#line 343 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp146_ = B;
#line 343 "/home/bob/git/simple-scan/src/page-view.vala"
				if (!(_tmp145_ < _tmp146_)) {
#line 343 "/home/bob/git/simple-scan/src/page-view.vala"
					break;
#line 1737 "page-view.c"
				}
#line 345 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp147_ = L;
#line 345 "/home/bob/git/simple-scan/src/page-view.vala"
				if (l != ((gdouble) _tmp147_)) {
#line 1743 "page-view.c"
					guchar p[3] = {0};
					gint _tmp148_;
					gint _tmp149_;
					gdouble _tmp150_;
					guchar _tmp151_;
					gint _tmp152_;
					gdouble _tmp153_;
					guchar _tmp154_;
					gint _tmp155_;
					gdouble _tmp156_;
					guchar _tmp157_;
					gint _tmp158_;
#line 348 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp148_ = L;
#line 348 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp149_ = y;
#line 348 "/home/bob/git/simple-scan/src/page-view.vala"
					page_view_get_pixel (self, page, _tmp148_ - 1, _tmp149_, p, 3);
#line 349 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp150_ = red;
#line 349 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp151_ = p[0];
#line 349 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp152_ = L;
#line 349 "/home/bob/git/simple-scan/src/page-view.vala"
					red = _tmp150_ + (_tmp151_ * (_tmp152_ - l));
#line 350 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp153_ = green;
#line 350 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp154_ = p[1];
#line 350 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp155_ = L;
#line 350 "/home/bob/git/simple-scan/src/page-view.vala"
					green = _tmp153_ + (_tmp154_ * (_tmp155_ - l));
#line 351 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp156_ = blue;
#line 351 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp157_ = p[2];
#line 351 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp158_ = L;
#line 351 "/home/bob/git/simple-scan/src/page-view.vala"
					blue = _tmp156_ + (_tmp157_ * (_tmp158_ - l));
#line 1786 "page-view.c"
				}
#line 354 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp159_ = R;
#line 354 "/home/bob/git/simple-scan/src/page-view.vala"
				if (r != ((gdouble) _tmp159_)) {
#line 1792 "page-view.c"
					guchar p[3] = {0};
					gint _tmp160_;
					gint _tmp161_;
					gdouble _tmp162_;
					guchar _tmp163_;
					gint _tmp164_;
					gdouble _tmp165_;
					guchar _tmp166_;
					gint _tmp167_;
					gdouble _tmp168_;
					guchar _tmp169_;
					gint _tmp170_;
#line 357 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp160_ = R;
#line 357 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp161_ = y;
#line 357 "/home/bob/git/simple-scan/src/page-view.vala"
					page_view_get_pixel (self, page, _tmp160_, _tmp161_, p, 3);
#line 358 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp162_ = red;
#line 358 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp163_ = p[0];
#line 358 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp164_ = R;
#line 358 "/home/bob/git/simple-scan/src/page-view.vala"
					red = _tmp162_ + (_tmp163_ * (r - _tmp164_));
#line 359 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp165_ = green;
#line 359 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp166_ = p[1];
#line 359 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp167_ = R;
#line 359 "/home/bob/git/simple-scan/src/page-view.vala"
					green = _tmp165_ + (_tmp166_ * (r - _tmp167_));
#line 360 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp168_ = blue;
#line 360 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp169_ = p[2];
#line 360 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp170_ = R;
#line 360 "/home/bob/git/simple-scan/src/page-view.vala"
					blue = _tmp168_ + (_tmp169_ * (r - _tmp170_));
#line 1835 "page-view.c"
				}
			}
		}
	}
#line 365 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp172_ = L;
#line 365 "/home/bob/git/simple-scan/src/page-view.vala"
	if (l != ((gdouble) _tmp172_)) {
#line 1844 "page-view.c"
		gint _tmp173_;
#line 365 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp173_ = T;
#line 365 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp171_ = t != ((gdouble) _tmp173_);
#line 1850 "page-view.c"
	} else {
#line 365 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp171_ = FALSE;
#line 1854 "page-view.c"
	}
#line 365 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp171_) {
#line 1858 "page-view.c"
		guchar p[3] = {0};
		gint _tmp174_;
		gint _tmp175_;
		gdouble _tmp176_;
		guchar _tmp177_;
		gint _tmp178_;
		gint _tmp179_;
		gdouble _tmp180_;
		guchar _tmp181_;
		gint _tmp182_;
		gint _tmp183_;
		gdouble _tmp184_;
		guchar _tmp185_;
		gint _tmp186_;
		gint _tmp187_;
#line 368 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp174_ = L;
#line 368 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp175_ = T;
#line 368 "/home/bob/git/simple-scan/src/page-view.vala"
		page_view_get_pixel (self, page, _tmp174_ - 1, _tmp175_ - 1, p, 3);
#line 369 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp176_ = red;
#line 369 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp177_ = p[0];
#line 369 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp178_ = L;
#line 369 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp179_ = T;
#line 369 "/home/bob/git/simple-scan/src/page-view.vala"
		red = _tmp176_ + ((_tmp177_ * (_tmp178_ - l)) * (_tmp179_ - t));
#line 370 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp180_ = green;
#line 370 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp181_ = p[1];
#line 370 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp182_ = L;
#line 370 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp183_ = T;
#line 370 "/home/bob/git/simple-scan/src/page-view.vala"
		green = _tmp180_ + ((_tmp181_ * (_tmp182_ - l)) * (_tmp183_ - t));
#line 371 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp184_ = blue;
#line 371 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp185_ = p[2];
#line 371 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp186_ = L;
#line 371 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp187_ = T;
#line 371 "/home/bob/git/simple-scan/src/page-view.vala"
		blue = _tmp184_ + ((_tmp185_ * (_tmp186_ - l)) * (_tmp187_ - t));
#line 1910 "page-view.c"
	}
#line 373 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp189_ = R;
#line 373 "/home/bob/git/simple-scan/src/page-view.vala"
	if (r != ((gdouble) _tmp189_)) {
#line 1916 "page-view.c"
		gint _tmp190_;
#line 373 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp190_ = T;
#line 373 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp188_ = t != ((gdouble) _tmp190_);
#line 1922 "page-view.c"
	} else {
#line 373 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp188_ = FALSE;
#line 1926 "page-view.c"
	}
#line 373 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp188_) {
#line 1930 "page-view.c"
		guchar p[3] = {0};
		gint _tmp191_;
		gint _tmp192_;
		gdouble _tmp193_;
		guchar _tmp194_;
		gint _tmp195_;
		gint _tmp196_;
		gdouble _tmp197_;
		guchar _tmp198_;
		gint _tmp199_;
		gint _tmp200_;
		gdouble _tmp201_;
		guchar _tmp202_;
		gint _tmp203_;
		gint _tmp204_;
#line 376 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp191_ = R;
#line 376 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp192_ = T;
#line 376 "/home/bob/git/simple-scan/src/page-view.vala"
		page_view_get_pixel (self, page, _tmp191_, _tmp192_ - 1, p, 3);
#line 377 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp193_ = red;
#line 377 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp194_ = p[0];
#line 377 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp195_ = R;
#line 377 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp196_ = T;
#line 377 "/home/bob/git/simple-scan/src/page-view.vala"
		red = _tmp193_ + ((_tmp194_ * (r - _tmp195_)) * (_tmp196_ - t));
#line 378 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp197_ = green;
#line 378 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp198_ = p[1];
#line 378 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp199_ = R;
#line 378 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp200_ = T;
#line 378 "/home/bob/git/simple-scan/src/page-view.vala"
		green = _tmp197_ + ((_tmp198_ * (r - _tmp199_)) * (_tmp200_ - t));
#line 379 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp201_ = blue;
#line 379 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp202_ = p[2];
#line 379 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp203_ = R;
#line 379 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp204_ = T;
#line 379 "/home/bob/git/simple-scan/src/page-view.vala"
		blue = _tmp201_ + ((_tmp202_ * (r - _tmp203_)) * (_tmp204_ - t));
#line 1982 "page-view.c"
	}
#line 381 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp206_ = R;
#line 381 "/home/bob/git/simple-scan/src/page-view.vala"
	if (r != ((gdouble) _tmp206_)) {
#line 1988 "page-view.c"
		gint _tmp207_;
#line 381 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp207_ = B;
#line 381 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp205_ = b != ((gdouble) _tmp207_);
#line 1994 "page-view.c"
	} else {
#line 381 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp205_ = FALSE;
#line 1998 "page-view.c"
	}
#line 381 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp205_) {
#line 2002 "page-view.c"
		guchar p[3] = {0};
		gint _tmp208_;
		gint _tmp209_;
		gdouble _tmp210_;
		guchar _tmp211_;
		gint _tmp212_;
		gint _tmp213_;
		gdouble _tmp214_;
		guchar _tmp215_;
		gint _tmp216_;
		gint _tmp217_;
		gdouble _tmp218_;
		guchar _tmp219_;
		gint _tmp220_;
		gint _tmp221_;
#line 384 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp208_ = R;
#line 384 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp209_ = B;
#line 384 "/home/bob/git/simple-scan/src/page-view.vala"
		page_view_get_pixel (self, page, _tmp208_, _tmp209_, p, 3);
#line 385 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp210_ = red;
#line 385 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp211_ = p[0];
#line 385 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp212_ = R;
#line 385 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp213_ = B;
#line 385 "/home/bob/git/simple-scan/src/page-view.vala"
		red = _tmp210_ + ((_tmp211_ * (r - _tmp212_)) * (b - _tmp213_));
#line 386 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp214_ = green;
#line 386 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp215_ = p[1];
#line 386 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp216_ = R;
#line 386 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp217_ = B;
#line 386 "/home/bob/git/simple-scan/src/page-view.vala"
		green = _tmp214_ + ((_tmp215_ * (r - _tmp216_)) * (b - _tmp217_));
#line 387 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp218_ = blue;
#line 387 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp219_ = p[2];
#line 387 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp220_ = R;
#line 387 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp221_ = B;
#line 387 "/home/bob/git/simple-scan/src/page-view.vala"
		blue = _tmp218_ + ((_tmp219_ * (r - _tmp220_)) * (b - _tmp221_));
#line 2054 "page-view.c"
	}
#line 389 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp223_ = L;
#line 389 "/home/bob/git/simple-scan/src/page-view.vala"
	if (l != ((gdouble) _tmp223_)) {
#line 2060 "page-view.c"
		gint _tmp224_;
#line 389 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp224_ = B;
#line 389 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp222_ = b != ((gdouble) _tmp224_);
#line 2066 "page-view.c"
	} else {
#line 389 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp222_ = FALSE;
#line 2070 "page-view.c"
	}
#line 389 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp222_) {
#line 2074 "page-view.c"
		guchar p[3] = {0};
		gint _tmp225_;
		gint _tmp226_;
		gdouble _tmp227_;
		guchar _tmp228_;
		gint _tmp229_;
		gint _tmp230_;
		gdouble _tmp231_;
		guchar _tmp232_;
		gint _tmp233_;
		gint _tmp234_;
		gdouble _tmp235_;
		guchar _tmp236_;
		gint _tmp237_;
		gint _tmp238_;
#line 392 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp225_ = L;
#line 392 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp226_ = B;
#line 392 "/home/bob/git/simple-scan/src/page-view.vala"
		page_view_get_pixel (self, page, _tmp225_ - 1, _tmp226_, p, 3);
#line 393 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp227_ = red;
#line 393 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp228_ = p[0];
#line 393 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp229_ = L;
#line 393 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp230_ = B;
#line 393 "/home/bob/git/simple-scan/src/page-view.vala"
		red = _tmp227_ + ((_tmp228_ * (_tmp229_ - l)) * (b - _tmp230_));
#line 394 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp231_ = green;
#line 394 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp232_ = p[1];
#line 394 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp233_ = L;
#line 394 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp234_ = B;
#line 394 "/home/bob/git/simple-scan/src/page-view.vala"
		green = _tmp231_ + ((_tmp232_ * (_tmp233_ - l)) * (b - _tmp234_));
#line 395 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp235_ = blue;
#line 395 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp236_ = p[2];
#line 395 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp237_ = L;
#line 395 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp238_ = B;
#line 395 "/home/bob/git/simple-scan/src/page-view.vala"
		blue = _tmp235_ + ((_tmp236_ * (_tmp237_ - l)) * (b - _tmp238_));
#line 2126 "page-view.c"
	}
#line 399 "/home/bob/git/simple-scan/src/page-view.vala"
	scale = 1.0 / ((r - l) * (b - t));
#line 400 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp239_ = red;
#line 400 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp240_ = scale;
#line 400 "/home/bob/git/simple-scan/src/page-view.vala"
	output[offset] = (guchar) ((_tmp239_ * _tmp240_) + 0.5);
#line 400 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp241_ = output[offset];
#line 401 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp242_ = green;
#line 401 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp243_ = scale;
#line 401 "/home/bob/git/simple-scan/src/page-view.vala"
	output[offset + 1] = (guchar) ((_tmp242_ * _tmp243_) + 0.5);
#line 401 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp244_ = output[offset + 1];
#line 402 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp245_ = blue;
#line 402 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp246_ = scale;
#line 402 "/home/bob/git/simple-scan/src/page-view.vala"
	output[offset + 2] = (guchar) ((_tmp245_ * _tmp246_) + 0.5);
#line 402 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp247_ = output[offset + 2];
#line 2154 "page-view.c"
}


static void
page_view_update_preview (PageView* self,
                          Page* page,
                          GdkPixbuf* * output_image,
                          gint output_width,
                          gint output_height,
                          ScanDirection scan_direction,
                          gint old_scan_line,
                          gint scan_line)
{
	gint input_width = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint input_height = 0;
	gint _tmp2_;
	gint _tmp3_;
	gint L = 0;
	gint R = 0;
	gint T = 0;
	gint B = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	guchar* output = NULL;
	guint8* _tmp32_;
	gint output_length1;
	gint _output_size_;
	gint output_rowstride = 0;
	gint _tmp33_;
	gint _tmp34_;
	gint output_n_channels = 0;
	gint _tmp35_;
	gint _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
#line 405 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 405 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (page != NULL);
#line 408 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = page_get_width (page);
#line 408 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = _tmp0_;
#line 408 "/home/bob/git/simple-scan/src/page-view.vala"
	input_width = _tmp1_;
#line 409 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp2_ = page_get_height (page);
#line 409 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 409 "/home/bob/git/simple-scan/src/page-view.vala"
	input_height = _tmp3_;
#line 413 "/home/bob/git/simple-scan/src/page-view.vala"
	if ((*output_image) == NULL) {
#line 413 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp5_ = TRUE;
#line 2218 "page-view.c"
	} else {
		gint _tmp6_;
		gint _tmp7_;
#line 414 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp6_ = gdk_pixbuf_get_width (*output_image);
#line 414 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp7_ = _tmp6_;
#line 414 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp5_ = _tmp7_ != output_width;
#line 2228 "page-view.c"
	}
#line 413 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp5_) {
#line 413 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp4_ = TRUE;
#line 2234 "page-view.c"
	} else {
		gint _tmp8_;
		gint _tmp9_;
#line 415 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp8_ = gdk_pixbuf_get_height (*output_image);
#line 415 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp9_ = _tmp8_;
#line 415 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp4_ = _tmp9_ != output_height;
#line 2244 "page-view.c"
	}
#line 413 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp4_) {
#line 2248 "page-view.c"
		GdkPixbuf* _tmp10_;
#line 417 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp10_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, output_width, output_height);
#line 417 "/home/bob/git/simple-scan/src/page-view.vala"
		_g_object_unref0 (*output_image);
#line 417 "/home/bob/git/simple-scan/src/page-view.vala"
		*output_image = _tmp10_;
#line 424 "/home/bob/git/simple-scan/src/page-view.vala"
		L = 0;
#line 425 "/home/bob/git/simple-scan/src/page-view.vala"
		R = output_width - 1;
#line 426 "/home/bob/git/simple-scan/src/page-view.vala"
		T = 0;
#line 427 "/home/bob/git/simple-scan/src/page-view.vala"
		B = output_height - 1;
#line 2264 "page-view.c"
	} else {
#line 432 "/home/bob/git/simple-scan/src/page-view.vala"
		switch (scan_direction) {
#line 432 "/home/bob/git/simple-scan/src/page-view.vala"
			case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 2270 "page-view.c"
			{
				gint _tmp11_;
				gint _tmp12_;
#line 435 "/home/bob/git/simple-scan/src/page-view.vala"
				L = 0;
#line 436 "/home/bob/git/simple-scan/src/page-view.vala"
				R = output_width - 1;
#line 437 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp11_ = input_height;
#line 437 "/home/bob/git/simple-scan/src/page-view.vala"
				T = (gint) ((((gdouble) old_scan_line) * output_height) / _tmp11_);
#line 438 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp12_ = input_height;
#line 438 "/home/bob/git/simple-scan/src/page-view.vala"
				B = (gint) (((((gdouble) scan_line) * output_height) / _tmp12_) + 0.5);
#line 439 "/home/bob/git/simple-scan/src/page-view.vala"
				break;
#line 2288 "page-view.c"
			}
#line 432 "/home/bob/git/simple-scan/src/page-view.vala"
			case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 2292 "page-view.c"
			{
				gint _tmp13_;
				gint _tmp14_;
#line 441 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp13_ = input_width;
#line 441 "/home/bob/git/simple-scan/src/page-view.vala"
				L = (gint) ((((gdouble) old_scan_line) * output_width) / _tmp13_);
#line 442 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp14_ = input_width;
#line 442 "/home/bob/git/simple-scan/src/page-view.vala"
				R = (gint) (((((gdouble) scan_line) * output_width) / _tmp14_) + 0.5);
#line 443 "/home/bob/git/simple-scan/src/page-view.vala"
				T = 0;
#line 444 "/home/bob/git/simple-scan/src/page-view.vala"
				B = output_height - 1;
#line 445 "/home/bob/git/simple-scan/src/page-view.vala"
				break;
#line 2310 "page-view.c"
			}
#line 432 "/home/bob/git/simple-scan/src/page-view.vala"
			case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 2314 "page-view.c"
			{
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
#line 447 "/home/bob/git/simple-scan/src/page-view.vala"
				L = 0;
#line 448 "/home/bob/git/simple-scan/src/page-view.vala"
				R = output_width - 1;
#line 449 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp15_ = input_height;
#line 449 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp16_ = input_height;
#line 449 "/home/bob/git/simple-scan/src/page-view.vala"
				T = (gint) ((((gdouble) (_tmp15_ - scan_line)) * output_height) / _tmp16_);
#line 450 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp17_ = input_height;
#line 450 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp18_ = input_height;
#line 450 "/home/bob/git/simple-scan/src/page-view.vala"
				B = (gint) (((((gdouble) (_tmp17_ - old_scan_line)) * output_height) / _tmp18_) + 0.5);
#line 451 "/home/bob/git/simple-scan/src/page-view.vala"
				break;
#line 2338 "page-view.c"
			}
#line 432 "/home/bob/git/simple-scan/src/page-view.vala"
			case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 2342 "page-view.c"
			{
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
#line 453 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp19_ = input_width;
#line 453 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp20_ = input_width;
#line 453 "/home/bob/git/simple-scan/src/page-view.vala"
				L = (gint) ((((gdouble) (_tmp19_ - scan_line)) * output_width) / _tmp20_);
#line 454 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp21_ = input_width;
#line 454 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp22_ = input_width;
#line 454 "/home/bob/git/simple-scan/src/page-view.vala"
				R = (gint) (((((gdouble) (_tmp21_ - old_scan_line)) * output_width) / _tmp22_) + 0.5);
#line 455 "/home/bob/git/simple-scan/src/page-view.vala"
				T = 0;
#line 456 "/home/bob/git/simple-scan/src/page-view.vala"
				B = output_height - 1;
#line 457 "/home/bob/git/simple-scan/src/page-view.vala"
				break;
#line 2366 "page-view.c"
			}
			default:
			{
				gint _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
#line 459 "/home/bob/git/simple-scan/src/page-view.vala"
				T = 0;
#line 459 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp23_ = T;
#line 459 "/home/bob/git/simple-scan/src/page-view.vala"
				B = _tmp23_;
#line 459 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp24_ = B;
#line 459 "/home/bob/git/simple-scan/src/page-view.vala"
				R = _tmp24_;
#line 459 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp25_ = R;
#line 459 "/home/bob/git/simple-scan/src/page-view.vala"
				L = _tmp25_;
#line 460 "/home/bob/git/simple-scan/src/page-view.vala"
				break;
#line 2389 "page-view.c"
			}
		}
	}
#line 465 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp26_ = R;
#line 465 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp26_ >= output_width) {
#line 466 "/home/bob/git/simple-scan/src/page-view.vala"
		R = output_width - 1;
#line 2399 "page-view.c"
	}
#line 467 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp27_ = B;
#line 467 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp27_ >= output_height) {
#line 468 "/home/bob/git/simple-scan/src/page-view.vala"
		B = output_height - 1;
#line 2407 "page-view.c"
	}
#line 470 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp28_ = L;
#line 470 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (_tmp28_ >= 0);
#line 471 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp29_ = R;
#line 471 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (_tmp29_ < output_width);
#line 472 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp30_ = T;
#line 472 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (_tmp30_ >= 0);
#line 473 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp31_ = B;
#line 473 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (_tmp31_ < output_height);
#line 474 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail ((*output_image) != NULL);
#line 476 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp32_ = gdk_pixbuf_get_pixels (*output_image);
#line 476 "/home/bob/git/simple-scan/src/page-view.vala"
	output = _tmp32_;
#line 476 "/home/bob/git/simple-scan/src/page-view.vala"
	output_length1 = -1;
#line 476 "/home/bob/git/simple-scan/src/page-view.vala"
	_output_size_ = output_length1;
#line 477 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp33_ = gdk_pixbuf_get_rowstride (*output_image);
#line 477 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp34_ = _tmp33_;
#line 477 "/home/bob/git/simple-scan/src/page-view.vala"
	output_rowstride = _tmp34_;
#line 478 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp35_ = gdk_pixbuf_get_n_channels (*output_image);
#line 478 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp36_ = _tmp35_;
#line 478 "/home/bob/git/simple-scan/src/page-view.vala"
	output_n_channels = _tmp36_;
#line 480 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp37_ = page_get_has_data (page);
#line 480 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp38_ = _tmp37_;
#line 480 "/home/bob/git/simple-scan/src/page-view.vala"
	if (!_tmp38_) {
#line 2453 "page-view.c"
		{
			gint x = 0;
			gint _tmp39_;
#line 482 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp39_ = L;
#line 482 "/home/bob/git/simple-scan/src/page-view.vala"
			x = _tmp39_;
#line 2461 "page-view.c"
			{
				gboolean _tmp40_ = FALSE;
#line 482 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp40_ = TRUE;
#line 482 "/home/bob/git/simple-scan/src/page-view.vala"
				while (TRUE) {
#line 2468 "page-view.c"
					gint _tmp42_;
					gint _tmp43_;
#line 482 "/home/bob/git/simple-scan/src/page-view.vala"
					if (!_tmp40_) {
#line 2473 "page-view.c"
						gint _tmp41_;
#line 482 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp41_ = x;
#line 482 "/home/bob/git/simple-scan/src/page-view.vala"
						x = _tmp41_ + 1;
#line 2479 "page-view.c"
					}
#line 482 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp40_ = FALSE;
#line 482 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp42_ = x;
#line 482 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp43_ = R;
#line 482 "/home/bob/git/simple-scan/src/page-view.vala"
					if (!(_tmp42_ <= _tmp43_)) {
#line 482 "/home/bob/git/simple-scan/src/page-view.vala"
						break;
#line 2491 "page-view.c"
					}
					{
						gint y = 0;
						gint _tmp44_;
#line 483 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp44_ = T;
#line 483 "/home/bob/git/simple-scan/src/page-view.vala"
						y = _tmp44_;
#line 2500 "page-view.c"
						{
							gboolean _tmp45_ = FALSE;
#line 483 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp45_ = TRUE;
#line 483 "/home/bob/git/simple-scan/src/page-view.vala"
							while (TRUE) {
#line 2507 "page-view.c"
								gint _tmp47_;
								gint _tmp48_;
								gint o = 0;
								gint _tmp49_;
								gint _tmp50_;
								gint _tmp51_;
								gint _tmp52_;
								guchar* _tmp53_;
								gint _tmp53__length1;
								gint _tmp54_;
								guchar* _tmp55_;
								gint _tmp55__length1;
								gint _tmp56_;
								guchar* _tmp57_;
								gint _tmp57__length1;
								gint _tmp58_;
								guchar _tmp59_;
								guchar _tmp60_;
								guchar _tmp61_;
#line 483 "/home/bob/git/simple-scan/src/page-view.vala"
								if (!_tmp45_) {
#line 2529 "page-view.c"
									gint _tmp46_;
#line 483 "/home/bob/git/simple-scan/src/page-view.vala"
									_tmp46_ = y;
#line 483 "/home/bob/git/simple-scan/src/page-view.vala"
									y = _tmp46_ + 1;
#line 2535 "page-view.c"
								}
#line 483 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp45_ = FALSE;
#line 483 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp47_ = y;
#line 483 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp48_ = B;
#line 483 "/home/bob/git/simple-scan/src/page-view.vala"
								if (!(_tmp47_ <= _tmp48_)) {
#line 483 "/home/bob/git/simple-scan/src/page-view.vala"
									break;
#line 2547 "page-view.c"
								}
#line 485 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp49_ = output_rowstride;
#line 485 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp50_ = y;
#line 485 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp51_ = x;
#line 485 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp52_ = output_n_channels;
#line 485 "/home/bob/git/simple-scan/src/page-view.vala"
								o = (_tmp49_ * _tmp50_) + (_tmp51_ * _tmp52_);
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp53_ = output;
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp53__length1 = output_length1;
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp54_ = o;
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp55_ = output;
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp55__length1 = output_length1;
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp56_ = o;
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp57_ = output;
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp57__length1 = output_length1;
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp58_ = o;
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp57_[_tmp58_ + 2] = (guchar) 0xFF;
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp59_ = _tmp57_[_tmp58_ + 2];
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp55_[_tmp56_ + 1] = _tmp59_;
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp60_ = _tmp55_[_tmp56_ + 1];
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp53_[_tmp54_] = _tmp60_;
#line 486 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp61_ = _tmp53_[_tmp54_];
#line 2589 "page-view.c"
							}
						}
					}
				}
			}
		}
#line 488 "/home/bob/git/simple-scan/src/page-view.vala"
		return;
#line 2598 "page-view.c"
	}
	{
		gint x = 0;
		gint _tmp62_;
#line 492 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp62_ = L;
#line 492 "/home/bob/git/simple-scan/src/page-view.vala"
		x = _tmp62_;
#line 2607 "page-view.c"
		{
			gboolean _tmp63_ = FALSE;
#line 492 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp63_ = TRUE;
#line 492 "/home/bob/git/simple-scan/src/page-view.vala"
			while (TRUE) {
#line 2614 "page-view.c"
				gint _tmp65_;
				gint _tmp66_;
				gdouble l = 0.0;
				gint _tmp67_;
				gint _tmp68_;
				gdouble r = 0.0;
				gint _tmp69_;
				gint _tmp70_;
#line 492 "/home/bob/git/simple-scan/src/page-view.vala"
				if (!_tmp63_) {
#line 2625 "page-view.c"
					gint _tmp64_;
#line 492 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp64_ = x;
#line 492 "/home/bob/git/simple-scan/src/page-view.vala"
					x = _tmp64_ + 1;
#line 2631 "page-view.c"
				}
#line 492 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp63_ = FALSE;
#line 492 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp65_ = x;
#line 492 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp66_ = R;
#line 492 "/home/bob/git/simple-scan/src/page-view.vala"
				if (!(_tmp65_ <= _tmp66_)) {
#line 492 "/home/bob/git/simple-scan/src/page-view.vala"
					break;
#line 2643 "page-view.c"
				}
#line 494 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp67_ = x;
#line 494 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp68_ = input_width;
#line 494 "/home/bob/git/simple-scan/src/page-view.vala"
				l = (((gdouble) _tmp67_) * _tmp68_) / output_width;
#line 495 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp69_ = x;
#line 495 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp70_ = input_width;
#line 495 "/home/bob/git/simple-scan/src/page-view.vala"
				r = (((gdouble) (_tmp69_ + 1)) * _tmp70_) / output_width;
#line 2657 "page-view.c"
				{
					gint y = 0;
					gint _tmp71_;
#line 497 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp71_ = T;
#line 497 "/home/bob/git/simple-scan/src/page-view.vala"
					y = _tmp71_;
#line 2665 "page-view.c"
					{
						gboolean _tmp72_ = FALSE;
#line 497 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp72_ = TRUE;
#line 497 "/home/bob/git/simple-scan/src/page-view.vala"
						while (TRUE) {
#line 2672 "page-view.c"
							gint _tmp74_;
							gint _tmp75_;
							gdouble t = 0.0;
							gint _tmp76_;
							gint _tmp77_;
							gdouble b = 0.0;
							gint _tmp78_;
							gint _tmp79_;
							gdouble _tmp80_;
							gdouble _tmp81_;
							gdouble _tmp82_;
							gdouble _tmp83_;
							guchar* _tmp84_;
							gint _tmp84__length1;
							gint _tmp85_;
							gint _tmp86_;
							gint _tmp87_;
							gint _tmp88_;
#line 497 "/home/bob/git/simple-scan/src/page-view.vala"
							if (!_tmp72_) {
#line 2693 "page-view.c"
								gint _tmp73_;
#line 497 "/home/bob/git/simple-scan/src/page-view.vala"
								_tmp73_ = y;
#line 497 "/home/bob/git/simple-scan/src/page-view.vala"
								y = _tmp73_ + 1;
#line 2699 "page-view.c"
							}
#line 497 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp72_ = FALSE;
#line 497 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp74_ = y;
#line 497 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp75_ = B;
#line 497 "/home/bob/git/simple-scan/src/page-view.vala"
							if (!(_tmp74_ <= _tmp75_)) {
#line 497 "/home/bob/git/simple-scan/src/page-view.vala"
								break;
#line 2711 "page-view.c"
							}
#line 499 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp76_ = y;
#line 499 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp77_ = input_height;
#line 499 "/home/bob/git/simple-scan/src/page-view.vala"
							t = (((gdouble) _tmp76_) * _tmp77_) / output_height;
#line 500 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp78_ = y;
#line 500 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp79_ = input_height;
#line 500 "/home/bob/git/simple-scan/src/page-view.vala"
							b = (((gdouble) (_tmp78_ + 1)) * _tmp79_) / output_height;
#line 502 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp80_ = l;
#line 502 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp81_ = r;
#line 502 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp82_ = t;
#line 502 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp83_ = b;
#line 502 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp84_ = output;
#line 502 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp84__length1 = output_length1;
#line 502 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp85_ = output_rowstride;
#line 502 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp86_ = y;
#line 502 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp87_ = x;
#line 502 "/home/bob/git/simple-scan/src/page-view.vala"
							_tmp88_ = output_n_channels;
#line 502 "/home/bob/git/simple-scan/src/page-view.vala"
							page_view_set_pixel (self, page, _tmp80_, _tmp81_, _tmp82_, _tmp83_, _tmp84_, _tmp84__length1, (_tmp85_ * _tmp86_) + (_tmp87_ * _tmp88_));
#line 2747 "page-view.c"
						}
					}
				}
			}
		}
	}
}


static gint
page_view_get_preview_width (PageView* self)
{
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
#line 509 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 511 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->width_;
#line 511 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = self->priv->border_width;
#line 511 "/home/bob/git/simple-scan/src/page-view.vala"
	result = _tmp0_ - (_tmp1_ * 2);
#line 511 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 2773 "page-view.c"
}


static gint
page_view_get_preview_height (PageView* self)
{
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
#line 514 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 516 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->height_;
#line 516 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = self->priv->border_width;
#line 516 "/home/bob/git/simple-scan/src/page-view.vala"
	result = _tmp0_ - (_tmp1_ * 2);
#line 516 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 2793 "page-view.c"
}


static void
page_view_update_page_view (PageView* self)
{
	gboolean _tmp0_;
	gint old_scan_line = 0;
	gint _tmp1_;
	gint scan_line = 0;
	Page* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ScanDirection left_steps = 0;
	ScanDirection _tmp5_;
	Page* _tmp6_;
	ScanDirection _tmp7_;
	ScanDirection _tmp8_;
	gboolean _tmp9_ = FALSE;
	ScanDirection _tmp10_;
	Page* _tmp12_;
	ScanDirection _tmp13_;
	ScanDirection _tmp14_;
	Page* _tmp15_;
	Page* _tmp16_;
	ScanDirection _tmp17_;
	ScanDirection _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
#line 519 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 521 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->update_image;
#line 521 "/home/bob/git/simple-scan/src/page-view.vala"
	if (!_tmp0_) {
#line 522 "/home/bob/git/simple-scan/src/page-view.vala"
		return;
#line 2832 "page-view.c"
	}
#line 524 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = self->priv->scan_line;
#line 524 "/home/bob/git/simple-scan/src/page-view.vala"
	old_scan_line = _tmp1_;
#line 525 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp2_ = self->priv->_page;
#line 525 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp3_ = page_get_scan_line (_tmp2_);
#line 525 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp4_ = _tmp3_;
#line 525 "/home/bob/git/simple-scan/src/page-view.vala"
	scan_line = _tmp4_;
#line 528 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp5_ = self->priv->scan_direction;
#line 528 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp6_ = self->priv->_page;
#line 528 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp7_ = page_get_scan_direction (_tmp6_);
#line 528 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp8_ = _tmp7_;
#line 528 "/home/bob/git/simple-scan/src/page-view.vala"
	left_steps = _tmp5_ - _tmp8_;
#line 529 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp10_ = left_steps;
#line 529 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp10_ != 0) {
#line 2860 "page-view.c"
		GdkPixbuf* _tmp11_;
#line 529 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp11_ = self->priv->image;
#line 529 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp9_ = _tmp11_ != NULL;
#line 2866 "page-view.c"
	} else {
#line 529 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp9_ = FALSE;
#line 2870 "page-view.c"
	}
#line 529 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp9_) {
#line 530 "/home/bob/git/simple-scan/src/page-view.vala"
		_g_object_unref0 (self->priv->image);
#line 530 "/home/bob/git/simple-scan/src/page-view.vala"
		self->priv->image = NULL;
#line 2878 "page-view.c"
	}
#line 531 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp12_ = self->priv->_page;
#line 531 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp13_ = page_get_scan_direction (_tmp12_);
#line 531 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp14_ = _tmp13_;
#line 531 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->scan_direction = _tmp14_;
#line 533 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp15_ = self->priv->_page;
#line 533 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp16_ = self->priv->_page;
#line 533 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp17_ = page_get_scan_direction (_tmp16_);
#line 533 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp18_ = _tmp17_;
#line 533 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp19_ = old_scan_line;
#line 533 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp20_ = scan_line;
#line 533 "/home/bob/git/simple-scan/src/page-view.vala"
	page_view_update_preview (self, _tmp15_, &self->priv->image, page_view_get_preview_width (self), page_view_get_preview_height (self), _tmp18_, _tmp19_, _tmp20_);
#line 539 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->update_image = FALSE;
#line 540 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp21_ = scan_line;
#line 540 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->scan_line = _tmp21_;
#line 2908 "page-view.c"
}


static gint
page_view_page_to_screen_x (PageView* self,
                            gint x)
{
	gint result = 0;
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 543 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 545 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 545 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 545 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp2_ = _tmp1_;
#line 545 "/home/bob/git/simple-scan/src/page-view.vala"
	result = (gint) (((((gdouble) x) * page_view_get_preview_width (self)) / _tmp2_) + 0.5);
#line 545 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 2932 "page-view.c"
}


static gint
page_view_page_to_screen_y (PageView* self,
                            gint y)
{
	gint result = 0;
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 548 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 550 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 550 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = page_get_height (_tmp0_);
#line 550 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp2_ = _tmp1_;
#line 550 "/home/bob/git/simple-scan/src/page-view.vala"
	result = (gint) (((((gdouble) y) * page_view_get_preview_height (self)) / _tmp2_) + 0.5);
#line 550 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 2956 "page-view.c"
}


static gint
page_view_screen_to_page_x (PageView* self,
                            gint x)
{
	gint result = 0;
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 553 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 555 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 555 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 555 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp2_ = _tmp1_;
#line 555 "/home/bob/git/simple-scan/src/page-view.vala"
	result = (gint) (((((gdouble) x) * _tmp2_) / page_view_get_preview_width (self)) + 0.5);
#line 555 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 2980 "page-view.c"
}


static gint
page_view_screen_to_page_y (PageView* self,
                            gint y)
{
	gint result = 0;
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 558 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 560 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 560 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = page_get_height (_tmp0_);
#line 560 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp2_ = _tmp1_;
#line 560 "/home/bob/git/simple-scan/src/page-view.vala"
	result = (gint) (((((gdouble) y) * _tmp2_) / page_view_get_preview_height (self)) + 0.5);
#line 560 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 3004 "page-view.c"
}


static CropLocation
page_view_get_crop_location (PageView* self,
                             gint x,
                             gint y)
{
	CropLocation result = 0;
	Page* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint cx = 0;
	Page* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint cy = 0;
	Page* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint cw = 0;
	Page* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint ch = 0;
	Page* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint dx = 0;
	gint _tmp15_;
	gint dy = 0;
	gint _tmp16_;
	gint dw = 0;
	gint _tmp17_;
	gint dh = 0;
	gint _tmp18_;
	gint ix = 0;
	gint _tmp19_;
	gint iy = 0;
	gint _tmp20_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gint _tmp24_;
	gchar* name = NULL;
	Page* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	gint crop_border = 0;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp38_;
	gint _tmp39_;
	gboolean _tmp41_ = FALSE;
	gint _tmp42_;
	gint _tmp43_;
	gboolean _tmp46_ = FALSE;
	gint _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gboolean _tmp52_ = FALSE;
	gint _tmp53_;
	gint _tmp54_;
	gboolean _tmp58_ = FALSE;
	gint _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	gint _tmp65_;
	gint _tmp66_;
	gint _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	gint _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	gint _tmp73_;
	gint _tmp74_;
#line 563 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 565 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 565 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = page_get_has_crop (_tmp0_);
#line 565 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp2_ = _tmp1_;
#line 565 "/home/bob/git/simple-scan/src/page-view.vala"
	if (!_tmp2_) {
#line 566 "/home/bob/git/simple-scan/src/page-view.vala"
		result = 0;
#line 566 "/home/bob/git/simple-scan/src/page-view.vala"
		return result;
#line 3098 "page-view.c"
	}
#line 568 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp3_ = self->priv->_page;
#line 568 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp4_ = page_get_crop_x (_tmp3_);
#line 568 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp5_ = _tmp4_;
#line 568 "/home/bob/git/simple-scan/src/page-view.vala"
	cx = _tmp5_;
#line 569 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp6_ = self->priv->_page;
#line 569 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp7_ = page_get_crop_y (_tmp6_);
#line 569 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp8_ = _tmp7_;
#line 569 "/home/bob/git/simple-scan/src/page-view.vala"
	cy = _tmp8_;
#line 570 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp9_ = self->priv->_page;
#line 570 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp10_ = page_get_crop_width (_tmp9_);
#line 570 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp11_ = _tmp10_;
#line 570 "/home/bob/git/simple-scan/src/page-view.vala"
	cw = _tmp11_;
#line 571 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp12_ = self->priv->_page;
#line 571 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp13_ = page_get_crop_height (_tmp12_);
#line 571 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp14_ = _tmp13_;
#line 571 "/home/bob/git/simple-scan/src/page-view.vala"
	ch = _tmp14_;
#line 572 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp15_ = cx;
#line 572 "/home/bob/git/simple-scan/src/page-view.vala"
	dx = page_view_page_to_screen_x (self, _tmp15_);
#line 573 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp16_ = cy;
#line 573 "/home/bob/git/simple-scan/src/page-view.vala"
	dy = page_view_page_to_screen_y (self, _tmp16_);
#line 574 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp17_ = cw;
#line 574 "/home/bob/git/simple-scan/src/page-view.vala"
	dw = page_view_page_to_screen_x (self, _tmp17_);
#line 575 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp18_ = ch;
#line 575 "/home/bob/git/simple-scan/src/page-view.vala"
	dh = page_view_page_to_screen_y (self, _tmp18_);
#line 576 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp19_ = dx;
#line 576 "/home/bob/git/simple-scan/src/page-view.vala"
	ix = x - _tmp19_;
#line 577 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp20_ = dy;
#line 577 "/home/bob/git/simple-scan/src/page-view.vala"
	iy = y - _tmp20_;
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp24_ = ix;
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp24_ < 0) {
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp23_ = TRUE;
#line 3162 "page-view.c"
	} else {
		gint _tmp25_;
		gint _tmp26_;
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp25_ = ix;
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp26_ = dw;
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp23_ = _tmp25_ > _tmp26_;
#line 3172 "page-view.c"
	}
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp23_) {
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp22_ = TRUE;
#line 3178 "page-view.c"
	} else {
		gint _tmp27_;
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp27_ = iy;
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp22_ = _tmp27_ < 0;
#line 3185 "page-view.c"
	}
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp22_) {
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp21_ = TRUE;
#line 3191 "page-view.c"
	} else {
		gint _tmp28_;
		gint _tmp29_;
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp28_ = iy;
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp29_ = dh;
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp21_ = _tmp28_ > _tmp29_;
#line 3201 "page-view.c"
	}
#line 579 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp21_) {
#line 580 "/home/bob/git/simple-scan/src/page-view.vala"
		result = CROP_LOCATION_NONE;
#line 580 "/home/bob/git/simple-scan/src/page-view.vala"
		return result;
#line 3209 "page-view.c"
	}
#line 583 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp30_ = self->priv->_page;
#line 583 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp31_ = page_get_crop_name (_tmp30_);
#line 583 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp32_ = _tmp31_;
#line 583 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp33_ = g_strdup (_tmp32_);
#line 583 "/home/bob/git/simple-scan/src/page-view.vala"
	name = _tmp33_;
#line 584 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp34_ = name;
#line 584 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp34_ != NULL) {
#line 585 "/home/bob/git/simple-scan/src/page-view.vala"
		result = CROP_LOCATION_MIDDLE;
#line 585 "/home/bob/git/simple-scan/src/page-view.vala"
		_g_free0 (name);
#line 585 "/home/bob/git/simple-scan/src/page-view.vala"
		return result;
#line 3231 "page-view.c"
	}
#line 588 "/home/bob/git/simple-scan/src/page-view.vala"
	crop_border = 20;
#line 589 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp35_ = dw;
#line 589 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp36_ = crop_border;
#line 589 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp35_ < (_tmp36_ * 3)) {
#line 3241 "page-view.c"
		gint _tmp37_;
#line 590 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp37_ = dw;
#line 590 "/home/bob/git/simple-scan/src/page-view.vala"
		crop_border = _tmp37_ / 3;
#line 3247 "page-view.c"
	}
#line 591 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp38_ = dh;
#line 591 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp39_ = crop_border;
#line 591 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp38_ < (_tmp39_ * 3)) {
#line 3255 "page-view.c"
		gint _tmp40_;
#line 592 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp40_ = dh;
#line 592 "/home/bob/git/simple-scan/src/page-view.vala"
		crop_border = _tmp40_ / 3;
#line 3261 "page-view.c"
	}
#line 595 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp42_ = ix;
#line 595 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp43_ = crop_border;
#line 595 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp42_ < _tmp43_) {
#line 3269 "page-view.c"
		gint _tmp44_;
		gint _tmp45_;
#line 595 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp44_ = iy;
#line 595 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp45_ = crop_border;
#line 595 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp41_ = _tmp44_ < _tmp45_;
#line 3278 "page-view.c"
	} else {
#line 595 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp41_ = FALSE;
#line 3282 "page-view.c"
	}
#line 595 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp41_) {
#line 596 "/home/bob/git/simple-scan/src/page-view.vala"
		result = CROP_LOCATION_TOP_LEFT;
#line 596 "/home/bob/git/simple-scan/src/page-view.vala"
		_g_free0 (name);
#line 596 "/home/bob/git/simple-scan/src/page-view.vala"
		return result;
#line 3292 "page-view.c"
	}
#line 598 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp47_ = ix;
#line 598 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp48_ = dw;
#line 598 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp49_ = crop_border;
#line 598 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp47_ > (_tmp48_ - _tmp49_)) {
#line 3302 "page-view.c"
		gint _tmp50_;
		gint _tmp51_;
#line 598 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp50_ = iy;
#line 598 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp51_ = crop_border;
#line 598 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp46_ = _tmp50_ < _tmp51_;
#line 3311 "page-view.c"
	} else {
#line 598 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp46_ = FALSE;
#line 3315 "page-view.c"
	}
#line 598 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp46_) {
#line 599 "/home/bob/git/simple-scan/src/page-view.vala"
		result = CROP_LOCATION_TOP_RIGHT;
#line 599 "/home/bob/git/simple-scan/src/page-view.vala"
		_g_free0 (name);
#line 599 "/home/bob/git/simple-scan/src/page-view.vala"
		return result;
#line 3325 "page-view.c"
	}
#line 601 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp53_ = ix;
#line 601 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp54_ = crop_border;
#line 601 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp53_ < _tmp54_) {
#line 3333 "page-view.c"
		gint _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
#line 601 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp55_ = iy;
#line 601 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp56_ = dh;
#line 601 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp57_ = crop_border;
#line 601 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp52_ = _tmp55_ > (_tmp56_ - _tmp57_);
#line 3345 "page-view.c"
	} else {
#line 601 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp52_ = FALSE;
#line 3349 "page-view.c"
	}
#line 601 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp52_) {
#line 602 "/home/bob/git/simple-scan/src/page-view.vala"
		result = CROP_LOCATION_BOTTOM_LEFT;
#line 602 "/home/bob/git/simple-scan/src/page-view.vala"
		_g_free0 (name);
#line 602 "/home/bob/git/simple-scan/src/page-view.vala"
		return result;
#line 3359 "page-view.c"
	}
#line 604 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp59_ = ix;
#line 604 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp60_ = dw;
#line 604 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp61_ = crop_border;
#line 604 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp59_ > (_tmp60_ - _tmp61_)) {
#line 3369 "page-view.c"
		gint _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
#line 604 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp62_ = iy;
#line 604 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp63_ = dh;
#line 604 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp64_ = crop_border;
#line 604 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp58_ = _tmp62_ > (_tmp63_ - _tmp64_);
#line 3381 "page-view.c"
	} else {
#line 604 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp58_ = FALSE;
#line 3385 "page-view.c"
	}
#line 604 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp58_) {
#line 605 "/home/bob/git/simple-scan/src/page-view.vala"
		result = CROP_LOCATION_BOTTOM_RIGHT;
#line 605 "/home/bob/git/simple-scan/src/page-view.vala"
		_g_free0 (name);
#line 605 "/home/bob/git/simple-scan/src/page-view.vala"
		return result;
#line 3395 "page-view.c"
	}
#line 608 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp65_ = ix;
#line 608 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp66_ = crop_border;
#line 608 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp65_ < _tmp66_) {
#line 609 "/home/bob/git/simple-scan/src/page-view.vala"
		result = CROP_LOCATION_LEFT;
#line 609 "/home/bob/git/simple-scan/src/page-view.vala"
		_g_free0 (name);
#line 609 "/home/bob/git/simple-scan/src/page-view.vala"
		return result;
#line 3409 "page-view.c"
	}
#line 611 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp67_ = ix;
#line 611 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp68_ = dw;
#line 611 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp69_ = crop_border;
#line 611 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp67_ > (_tmp68_ - _tmp69_)) {
#line 612 "/home/bob/git/simple-scan/src/page-view.vala"
		result = CROP_LOCATION_RIGHT;
#line 612 "/home/bob/git/simple-scan/src/page-view.vala"
		_g_free0 (name);
#line 612 "/home/bob/git/simple-scan/src/page-view.vala"
		return result;
#line 3425 "page-view.c"
	}
#line 614 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp70_ = iy;
#line 614 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp71_ = crop_border;
#line 614 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp70_ < _tmp71_) {
#line 615 "/home/bob/git/simple-scan/src/page-view.vala"
		result = CROP_LOCATION_TOP;
#line 615 "/home/bob/git/simple-scan/src/page-view.vala"
		_g_free0 (name);
#line 615 "/home/bob/git/simple-scan/src/page-view.vala"
		return result;
#line 3439 "page-view.c"
	}
#line 617 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp72_ = iy;
#line 617 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp73_ = dh;
#line 617 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp74_ = crop_border;
#line 617 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp72_ > (_tmp73_ - _tmp74_)) {
#line 618 "/home/bob/git/simple-scan/src/page-view.vala"
		result = CROP_LOCATION_BOTTOM;
#line 618 "/home/bob/git/simple-scan/src/page-view.vala"
		_g_free0 (name);
#line 618 "/home/bob/git/simple-scan/src/page-view.vala"
		return result;
#line 3455 "page-view.c"
	}
#line 621 "/home/bob/git/simple-scan/src/page-view.vala"
	result = CROP_LOCATION_MIDDLE;
#line 621 "/home/bob/git/simple-scan/src/page-view.vala"
	_g_free0 (name);
#line 621 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 3463 "page-view.c"
}


void
page_view_button_press (PageView* self,
                        gint x,
                        gint y)
{
	CropLocation location = 0;
	CropLocation _tmp0_;
#line 624 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 627 "/home/bob/git/simple-scan/src/page-view.vala"
	location = page_view_get_crop_location (self, x, y);
#line 628 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = location;
#line 628 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp0_ != CROP_LOCATION_NONE) {
#line 3482 "page-view.c"
		CropLocation _tmp1_;
		Page* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		Page* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		Page* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		Page* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
#line 630 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp1_ = location;
#line 630 "/home/bob/git/simple-scan/src/page-view.vala"
		self->priv->crop_location = _tmp1_;
#line 631 "/home/bob/git/simple-scan/src/page-view.vala"
		self->priv->selected_crop_px = (gdouble) x;
#line 632 "/home/bob/git/simple-scan/src/page-view.vala"
		self->priv->selected_crop_py = (gdouble) y;
#line 633 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp2_ = self->priv->_page;
#line 633 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp3_ = page_get_crop_x (_tmp2_);
#line 633 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp4_ = _tmp3_;
#line 633 "/home/bob/git/simple-scan/src/page-view.vala"
		self->priv->selected_crop_x = _tmp4_;
#line 634 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp5_ = self->priv->_page;
#line 634 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp6_ = page_get_crop_y (_tmp5_);
#line 634 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp7_ = _tmp6_;
#line 634 "/home/bob/git/simple-scan/src/page-view.vala"
		self->priv->selected_crop_y = _tmp7_;
#line 635 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp8_ = self->priv->_page;
#line 635 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp9_ = page_get_crop_width (_tmp8_);
#line 635 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp10_ = _tmp9_;
#line 635 "/home/bob/git/simple-scan/src/page-view.vala"
		self->priv->selected_crop_w = _tmp10_;
#line 636 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp11_ = self->priv->_page;
#line 636 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp12_ = page_get_crop_height (_tmp11_);
#line 636 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp13_ = _tmp12_;
#line 636 "/home/bob/git/simple-scan/src/page-view.vala"
		self->priv->selected_crop_h = _tmp13_;
#line 3536 "page-view.c"
	}
}


void
page_view_motion (PageView* self,
                  gint x,
                  gint y)
{
	CropLocation location = 0;
	GdkCursorType cursor = 0;
	CropLocation _tmp0_;
	CropLocation _tmp1_;
	gint pw = 0;
	Page* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint ph = 0;
	Page* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint cw = 0;
	Page* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint ch = 0;
	Page* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint dx = 0;
	gdouble _tmp15_;
	gint dy = 0;
	gdouble _tmp16_;
	gint new_x = 0;
	gint _tmp17_;
	gint new_y = 0;
	gint _tmp18_;
	gint new_w = 0;
	gint _tmp19_;
	gint new_h = 0;
	gint _tmp20_;
	gint min_size = 0;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	CropLocation _tmp23_;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	CropLocation _tmp36_;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	CropLocation _tmp49_;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp65_ = FALSE;
	CropLocation _tmp66_;
	CropLocation _tmp81_;
	CropLocation _tmp102_;
	gboolean _tmp107_ = FALSE;
	gboolean _tmp108_ = FALSE;
	CropLocation _tmp109_;
	gboolean _tmp116_ = FALSE;
	gboolean _tmp117_ = FALSE;
	CropLocation _tmp118_;
	gboolean _tmp125_ = FALSE;
	gboolean _tmp126_ = FALSE;
	CropLocation _tmp127_;
	gboolean _tmp132_ = FALSE;
	gboolean _tmp133_ = FALSE;
	CropLocation _tmp134_;
	Page* _tmp139_;
	gint _tmp140_;
	gint _tmp141_;
	gboolean _tmp142_ = FALSE;
	gint _tmp143_;
	gint _tmp144_;
#line 640 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 642 "/home/bob/git/simple-scan/src/page-view.vala"
	location = page_view_get_crop_location (self, x, y);
#line 644 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = location;
#line 644 "/home/bob/git/simple-scan/src/page-view.vala"
	switch (_tmp0_) {
#line 644 "/home/bob/git/simple-scan/src/page-view.vala"
		case CROP_LOCATION_MIDDLE:
#line 3621 "page-view.c"
		{
#line 647 "/home/bob/git/simple-scan/src/page-view.vala"
			cursor = GDK_HAND1;
#line 648 "/home/bob/git/simple-scan/src/page-view.vala"
			break;
#line 3627 "page-view.c"
		}
#line 644 "/home/bob/git/simple-scan/src/page-view.vala"
		case CROP_LOCATION_TOP:
#line 3631 "page-view.c"
		{
#line 650 "/home/bob/git/simple-scan/src/page-view.vala"
			cursor = GDK_TOP_SIDE;
#line 651 "/home/bob/git/simple-scan/src/page-view.vala"
			break;
#line 3637 "page-view.c"
		}
#line 644 "/home/bob/git/simple-scan/src/page-view.vala"
		case CROP_LOCATION_BOTTOM:
#line 3641 "page-view.c"
		{
#line 653 "/home/bob/git/simple-scan/src/page-view.vala"
			cursor = GDK_BOTTOM_SIDE;
#line 654 "/home/bob/git/simple-scan/src/page-view.vala"
			break;
#line 3647 "page-view.c"
		}
#line 644 "/home/bob/git/simple-scan/src/page-view.vala"
		case CROP_LOCATION_LEFT:
#line 3651 "page-view.c"
		{
#line 656 "/home/bob/git/simple-scan/src/page-view.vala"
			cursor = GDK_LEFT_SIDE;
#line 657 "/home/bob/git/simple-scan/src/page-view.vala"
			break;
#line 3657 "page-view.c"
		}
#line 644 "/home/bob/git/simple-scan/src/page-view.vala"
		case CROP_LOCATION_RIGHT:
#line 3661 "page-view.c"
		{
#line 659 "/home/bob/git/simple-scan/src/page-view.vala"
			cursor = GDK_RIGHT_SIDE;
#line 660 "/home/bob/git/simple-scan/src/page-view.vala"
			break;
#line 3667 "page-view.c"
		}
#line 644 "/home/bob/git/simple-scan/src/page-view.vala"
		case CROP_LOCATION_TOP_LEFT:
#line 3671 "page-view.c"
		{
#line 662 "/home/bob/git/simple-scan/src/page-view.vala"
			cursor = GDK_TOP_LEFT_CORNER;
#line 663 "/home/bob/git/simple-scan/src/page-view.vala"
			break;
#line 3677 "page-view.c"
		}
#line 644 "/home/bob/git/simple-scan/src/page-view.vala"
		case CROP_LOCATION_TOP_RIGHT:
#line 3681 "page-view.c"
		{
#line 665 "/home/bob/git/simple-scan/src/page-view.vala"
			cursor = GDK_TOP_RIGHT_CORNER;
#line 666 "/home/bob/git/simple-scan/src/page-view.vala"
			break;
#line 3687 "page-view.c"
		}
#line 644 "/home/bob/git/simple-scan/src/page-view.vala"
		case CROP_LOCATION_BOTTOM_LEFT:
#line 3691 "page-view.c"
		{
#line 668 "/home/bob/git/simple-scan/src/page-view.vala"
			cursor = GDK_BOTTOM_LEFT_CORNER;
#line 669 "/home/bob/git/simple-scan/src/page-view.vala"
			break;
#line 3697 "page-view.c"
		}
#line 644 "/home/bob/git/simple-scan/src/page-view.vala"
		case CROP_LOCATION_BOTTOM_RIGHT:
#line 3701 "page-view.c"
		{
#line 671 "/home/bob/git/simple-scan/src/page-view.vala"
			cursor = GDK_BOTTOM_RIGHT_CORNER;
#line 672 "/home/bob/git/simple-scan/src/page-view.vala"
			break;
#line 3707 "page-view.c"
		}
		default:
		{
#line 674 "/home/bob/git/simple-scan/src/page-view.vala"
			cursor = GDK_ARROW;
#line 675 "/home/bob/git/simple-scan/src/page-view.vala"
			break;
#line 3715 "page-view.c"
		}
	}
#line 678 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = self->priv->crop_location;
#line 678 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp1_ == CROP_LOCATION_NONE) {
#line 3722 "page-view.c"
		GdkCursorType _tmp2_;
#line 680 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp2_ = cursor;
#line 680 "/home/bob/git/simple-scan/src/page-view.vala"
		page_view_set_cursor (self, _tmp2_);
#line 681 "/home/bob/git/simple-scan/src/page-view.vala"
		return;
#line 3730 "page-view.c"
	}
#line 685 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp3_ = self->priv->_page;
#line 685 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp4_ = page_get_width (_tmp3_);
#line 685 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp5_ = _tmp4_;
#line 685 "/home/bob/git/simple-scan/src/page-view.vala"
	pw = _tmp5_;
#line 686 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp6_ = self->priv->_page;
#line 686 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp7_ = page_get_height (_tmp6_);
#line 686 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp8_ = _tmp7_;
#line 686 "/home/bob/git/simple-scan/src/page-view.vala"
	ph = _tmp8_;
#line 687 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp9_ = self->priv->_page;
#line 687 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp10_ = page_get_crop_width (_tmp9_);
#line 687 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp11_ = _tmp10_;
#line 687 "/home/bob/git/simple-scan/src/page-view.vala"
	cw = _tmp11_;
#line 688 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp12_ = self->priv->_page;
#line 688 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp13_ = page_get_crop_height (_tmp12_);
#line 688 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp14_ = _tmp13_;
#line 688 "/home/bob/git/simple-scan/src/page-view.vala"
	ch = _tmp14_;
#line 690 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp15_ = self->priv->selected_crop_px;
#line 690 "/home/bob/git/simple-scan/src/page-view.vala"
	dx = page_view_screen_to_page_x (self, x - ((gint) _tmp15_));
#line 691 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp16_ = self->priv->selected_crop_py;
#line 691 "/home/bob/git/simple-scan/src/page-view.vala"
	dy = page_view_screen_to_page_y (self, y - ((gint) _tmp16_));
#line 693 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp17_ = self->priv->selected_crop_x;
#line 693 "/home/bob/git/simple-scan/src/page-view.vala"
	new_x = _tmp17_;
#line 694 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp18_ = self->priv->selected_crop_y;
#line 694 "/home/bob/git/simple-scan/src/page-view.vala"
	new_y = _tmp18_;
#line 695 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp19_ = self->priv->selected_crop_w;
#line 695 "/home/bob/git/simple-scan/src/page-view.vala"
	new_w = _tmp19_;
#line 696 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp20_ = self->priv->selected_crop_h;
#line 696 "/home/bob/git/simple-scan/src/page-view.vala"
	new_h = _tmp20_;
#line 699 "/home/bob/git/simple-scan/src/page-view.vala"
	min_size = page_view_screen_to_page_x (self, 15);
#line 700 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp23_ = self->priv->crop_location;
#line 700 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp23_ == CROP_LOCATION_TOP_LEFT) {
#line 700 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp22_ = TRUE;
#line 3796 "page-view.c"
	} else {
		CropLocation _tmp24_;
#line 701 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp24_ = self->priv->crop_location;
#line 701 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp22_ = _tmp24_ == CROP_LOCATION_LEFT;
#line 3803 "page-view.c"
	}
#line 700 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp22_) {
#line 700 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp21_ = TRUE;
#line 3809 "page-view.c"
	} else {
		CropLocation _tmp25_;
#line 702 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp25_ = self->priv->crop_location;
#line 702 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp21_ = _tmp25_ == CROP_LOCATION_BOTTOM_LEFT;
#line 3816 "page-view.c"
	}
#line 700 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp21_) {
#line 3820 "page-view.c"
		gint _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _tmp31_;
		gint _tmp32_;
#line 704 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp26_ = dx;
#line 704 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp27_ = new_w;
#line 704 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp28_ = min_size;
#line 704 "/home/bob/git/simple-scan/src/page-view.vala"
		if (_tmp26_ > (_tmp27_ - _tmp28_)) {
#line 3834 "page-view.c"
			gint _tmp29_;
			gint _tmp30_;
#line 705 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp29_ = new_w;
#line 705 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp30_ = min_size;
#line 705 "/home/bob/git/simple-scan/src/page-view.vala"
			dx = _tmp29_ - _tmp30_;
#line 3843 "page-view.c"
		}
#line 706 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp31_ = new_x;
#line 706 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp32_ = dx;
#line 706 "/home/bob/git/simple-scan/src/page-view.vala"
		if ((_tmp31_ + _tmp32_) < 0) {
#line 3851 "page-view.c"
			gint _tmp33_;
#line 707 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp33_ = new_x;
#line 707 "/home/bob/git/simple-scan/src/page-view.vala"
			dx = -_tmp33_;
#line 3857 "page-view.c"
		}
	}
#line 709 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp36_ = self->priv->crop_location;
#line 709 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp36_ == CROP_LOCATION_TOP_LEFT) {
#line 709 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp35_ = TRUE;
#line 3866 "page-view.c"
	} else {
		CropLocation _tmp37_;
#line 710 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp37_ = self->priv->crop_location;
#line 710 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp35_ = _tmp37_ == CROP_LOCATION_TOP;
#line 3873 "page-view.c"
	}
#line 709 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp35_) {
#line 709 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp34_ = TRUE;
#line 3879 "page-view.c"
	} else {
		CropLocation _tmp38_;
#line 711 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp38_ = self->priv->crop_location;
#line 711 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp34_ = _tmp38_ == CROP_LOCATION_TOP_RIGHT;
#line 3886 "page-view.c"
	}
#line 709 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp34_) {
#line 3890 "page-view.c"
		gint _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _tmp44_;
		gint _tmp45_;
#line 713 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp39_ = dy;
#line 713 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp40_ = new_h;
#line 713 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp41_ = min_size;
#line 713 "/home/bob/git/simple-scan/src/page-view.vala"
		if (_tmp39_ > (_tmp40_ - _tmp41_)) {
#line 3904 "page-view.c"
			gint _tmp42_;
			gint _tmp43_;
#line 714 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp42_ = new_h;
#line 714 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp43_ = min_size;
#line 714 "/home/bob/git/simple-scan/src/page-view.vala"
			dy = _tmp42_ - _tmp43_;
#line 3913 "page-view.c"
		}
#line 715 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp44_ = new_y;
#line 715 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp45_ = dy;
#line 715 "/home/bob/git/simple-scan/src/page-view.vala"
		if ((_tmp44_ + _tmp45_) < 0) {
#line 3921 "page-view.c"
			gint _tmp46_;
#line 716 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp46_ = new_y;
#line 716 "/home/bob/git/simple-scan/src/page-view.vala"
			dy = -_tmp46_;
#line 3927 "page-view.c"
		}
	}
#line 719 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp49_ = self->priv->crop_location;
#line 719 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp49_ == CROP_LOCATION_TOP_RIGHT) {
#line 719 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp48_ = TRUE;
#line 3936 "page-view.c"
	} else {
		CropLocation _tmp50_;
#line 720 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp50_ = self->priv->crop_location;
#line 720 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp48_ = _tmp50_ == CROP_LOCATION_RIGHT;
#line 3943 "page-view.c"
	}
#line 719 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp48_) {
#line 719 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp47_ = TRUE;
#line 3949 "page-view.c"
	} else {
		CropLocation _tmp51_;
#line 721 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp51_ = self->priv->crop_location;
#line 721 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp47_ = _tmp51_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 3956 "page-view.c"
	}
#line 719 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp47_) {
#line 3960 "page-view.c"
		gint _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
#line 723 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp52_ = dx;
#line 723 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp53_ = min_size;
#line 723 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp54_ = new_w;
#line 723 "/home/bob/git/simple-scan/src/page-view.vala"
		if (_tmp52_ < (_tmp53_ - _tmp54_)) {
#line 3976 "page-view.c"
			gint _tmp55_;
			gint _tmp56_;
#line 724 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp55_ = min_size;
#line 724 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp56_ = new_w;
#line 724 "/home/bob/git/simple-scan/src/page-view.vala"
			dx = _tmp55_ - _tmp56_;
#line 3985 "page-view.c"
		}
#line 725 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp57_ = new_x;
#line 725 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp58_ = new_w;
#line 725 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp59_ = dx;
#line 725 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp60_ = pw;
#line 725 "/home/bob/git/simple-scan/src/page-view.vala"
		if (((_tmp57_ + _tmp58_) + _tmp59_) > _tmp60_) {
#line 3997 "page-view.c"
			gint _tmp61_;
			gint _tmp62_;
			gint _tmp63_;
#line 726 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp61_ = pw;
#line 726 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp62_ = new_x;
#line 726 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp63_ = new_w;
#line 726 "/home/bob/git/simple-scan/src/page-view.vala"
			dx = (_tmp61_ - _tmp62_) - _tmp63_;
#line 4009 "page-view.c"
		}
	}
#line 728 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp66_ = self->priv->crop_location;
#line 728 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp66_ == CROP_LOCATION_BOTTOM_LEFT) {
#line 728 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp65_ = TRUE;
#line 4018 "page-view.c"
	} else {
		CropLocation _tmp67_;
#line 729 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp67_ = self->priv->crop_location;
#line 729 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp65_ = _tmp67_ == CROP_LOCATION_BOTTOM;
#line 4025 "page-view.c"
	}
#line 728 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp65_) {
#line 728 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp64_ = TRUE;
#line 4031 "page-view.c"
	} else {
		CropLocation _tmp68_;
#line 730 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp68_ = self->priv->crop_location;
#line 730 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp64_ = _tmp68_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 4038 "page-view.c"
	}
#line 728 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp64_) {
#line 4042 "page-view.c"
		gint _tmp69_;
		gint _tmp70_;
		gint _tmp71_;
		gint _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
		gint _tmp77_;
#line 732 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp69_ = dy;
#line 732 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp70_ = min_size;
#line 732 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp71_ = new_h;
#line 732 "/home/bob/git/simple-scan/src/page-view.vala"
		if (_tmp69_ < (_tmp70_ - _tmp71_)) {
#line 4058 "page-view.c"
			gint _tmp72_;
			gint _tmp73_;
#line 733 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp72_ = min_size;
#line 733 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp73_ = new_h;
#line 733 "/home/bob/git/simple-scan/src/page-view.vala"
			dy = _tmp72_ - _tmp73_;
#line 4067 "page-view.c"
		}
#line 734 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp74_ = new_y;
#line 734 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp75_ = new_h;
#line 734 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp76_ = dy;
#line 734 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp77_ = ph;
#line 734 "/home/bob/git/simple-scan/src/page-view.vala"
		if (((_tmp74_ + _tmp75_) + _tmp76_) > _tmp77_) {
#line 4079 "page-view.c"
			gint _tmp78_;
			gint _tmp79_;
			gint _tmp80_;
#line 735 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp78_ = ph;
#line 735 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp79_ = new_y;
#line 735 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp80_ = new_h;
#line 735 "/home/bob/git/simple-scan/src/page-view.vala"
			dy = (_tmp78_ - _tmp79_) - _tmp80_;
#line 4091 "page-view.c"
		}
	}
#line 737 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp81_ = self->priv->crop_location;
#line 737 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp81_ == CROP_LOCATION_MIDDLE) {
#line 4098 "page-view.c"
		gint _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _tmp85_;
		gint _tmp89_;
		gint _tmp90_;
		gint _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		gint _tmp95_;
		gint _tmp99_;
		gint _tmp100_;
#line 739 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp82_ = new_x;
#line 739 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp83_ = dx;
#line 739 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp84_ = new_w;
#line 739 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp85_ = pw;
#line 739 "/home/bob/git/simple-scan/src/page-view.vala"
		if (((_tmp82_ + _tmp83_) + _tmp84_) > _tmp85_) {
#line 4121 "page-view.c"
			gint _tmp86_;
			gint _tmp87_;
			gint _tmp88_;
#line 740 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp86_ = pw;
#line 740 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp87_ = new_x;
#line 740 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp88_ = new_w;
#line 740 "/home/bob/git/simple-scan/src/page-view.vala"
			dx = (_tmp86_ - _tmp87_) - _tmp88_;
#line 4133 "page-view.c"
		}
#line 741 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp89_ = new_x;
#line 741 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp90_ = dx;
#line 741 "/home/bob/git/simple-scan/src/page-view.vala"
		if ((_tmp89_ + _tmp90_) < 0) {
#line 4141 "page-view.c"
			gint _tmp91_;
#line 742 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp91_ = new_x;
#line 742 "/home/bob/git/simple-scan/src/page-view.vala"
			dx = -_tmp91_;
#line 4147 "page-view.c"
		}
#line 743 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp92_ = new_y;
#line 743 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp93_ = dy;
#line 743 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp94_ = new_h;
#line 743 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp95_ = ph;
#line 743 "/home/bob/git/simple-scan/src/page-view.vala"
		if (((_tmp92_ + _tmp93_) + _tmp94_) > _tmp95_) {
#line 4159 "page-view.c"
			gint _tmp96_;
			gint _tmp97_;
			gint _tmp98_;
#line 744 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp96_ = ph;
#line 744 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp97_ = new_y;
#line 744 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp98_ = new_h;
#line 744 "/home/bob/git/simple-scan/src/page-view.vala"
			dy = (_tmp96_ - _tmp97_) - _tmp98_;
#line 4171 "page-view.c"
		}
#line 745 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp99_ = new_y;
#line 745 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp100_ = dy;
#line 745 "/home/bob/git/simple-scan/src/page-view.vala"
		if ((_tmp99_ + _tmp100_) < 0) {
#line 4179 "page-view.c"
			gint _tmp101_;
#line 746 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp101_ = new_y;
#line 746 "/home/bob/git/simple-scan/src/page-view.vala"
			dy = -_tmp101_;
#line 4185 "page-view.c"
		}
	}
#line 750 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp102_ = self->priv->crop_location;
#line 750 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp102_ == CROP_LOCATION_MIDDLE) {
#line 4192 "page-view.c"
		gint _tmp103_;
		gint _tmp104_;
		gint _tmp105_;
		gint _tmp106_;
#line 752 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp103_ = new_x;
#line 752 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp104_ = dx;
#line 752 "/home/bob/git/simple-scan/src/page-view.vala"
		new_x = _tmp103_ + _tmp104_;
#line 753 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp105_ = new_y;
#line 753 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp106_ = dy;
#line 753 "/home/bob/git/simple-scan/src/page-view.vala"
		new_y = _tmp105_ + _tmp106_;
#line 4209 "page-view.c"
	}
#line 755 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp109_ = self->priv->crop_location;
#line 755 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp109_ == CROP_LOCATION_TOP_LEFT) {
#line 755 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp108_ = TRUE;
#line 4217 "page-view.c"
	} else {
		CropLocation _tmp110_;
#line 756 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp110_ = self->priv->crop_location;
#line 756 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp108_ = _tmp110_ == CROP_LOCATION_LEFT;
#line 4224 "page-view.c"
	}
#line 755 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp108_) {
#line 755 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp107_ = TRUE;
#line 4230 "page-view.c"
	} else {
		CropLocation _tmp111_;
#line 757 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp111_ = self->priv->crop_location;
#line 757 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp107_ = _tmp111_ == CROP_LOCATION_BOTTOM_LEFT;
#line 4237 "page-view.c"
	}
#line 755 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp107_) {
#line 4241 "page-view.c"
		gint _tmp112_;
		gint _tmp113_;
		gint _tmp114_;
		gint _tmp115_;
#line 759 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp112_ = new_x;
#line 759 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp113_ = dx;
#line 759 "/home/bob/git/simple-scan/src/page-view.vala"
		new_x = _tmp112_ + _tmp113_;
#line 760 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp114_ = new_w;
#line 760 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp115_ = dx;
#line 760 "/home/bob/git/simple-scan/src/page-view.vala"
		new_w = _tmp114_ - _tmp115_;
#line 4258 "page-view.c"
	}
#line 762 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp118_ = self->priv->crop_location;
#line 762 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp118_ == CROP_LOCATION_TOP_LEFT) {
#line 762 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp117_ = TRUE;
#line 4266 "page-view.c"
	} else {
		CropLocation _tmp119_;
#line 763 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp119_ = self->priv->crop_location;
#line 763 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp117_ = _tmp119_ == CROP_LOCATION_TOP;
#line 4273 "page-view.c"
	}
#line 762 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp117_) {
#line 762 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp116_ = TRUE;
#line 4279 "page-view.c"
	} else {
		CropLocation _tmp120_;
#line 764 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp120_ = self->priv->crop_location;
#line 764 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp116_ = _tmp120_ == CROP_LOCATION_TOP_RIGHT;
#line 4286 "page-view.c"
	}
#line 762 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp116_) {
#line 4290 "page-view.c"
		gint _tmp121_;
		gint _tmp122_;
		gint _tmp123_;
		gint _tmp124_;
#line 766 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp121_ = new_y;
#line 766 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp122_ = dy;
#line 766 "/home/bob/git/simple-scan/src/page-view.vala"
		new_y = _tmp121_ + _tmp122_;
#line 767 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp123_ = new_h;
#line 767 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp124_ = dy;
#line 767 "/home/bob/git/simple-scan/src/page-view.vala"
		new_h = _tmp123_ - _tmp124_;
#line 4307 "page-view.c"
	}
#line 770 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp127_ = self->priv->crop_location;
#line 770 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp127_ == CROP_LOCATION_TOP_RIGHT) {
#line 770 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp126_ = TRUE;
#line 4315 "page-view.c"
	} else {
		CropLocation _tmp128_;
#line 771 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp128_ = self->priv->crop_location;
#line 771 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp126_ = _tmp128_ == CROP_LOCATION_RIGHT;
#line 4322 "page-view.c"
	}
#line 770 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp126_) {
#line 770 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp125_ = TRUE;
#line 4328 "page-view.c"
	} else {
		CropLocation _tmp129_;
#line 772 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp129_ = self->priv->crop_location;
#line 772 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp125_ = _tmp129_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 4335 "page-view.c"
	}
#line 770 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp125_) {
#line 4339 "page-view.c"
		gint _tmp130_;
		gint _tmp131_;
#line 773 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp130_ = new_w;
#line 773 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp131_ = dx;
#line 773 "/home/bob/git/simple-scan/src/page-view.vala"
		new_w = _tmp130_ + _tmp131_;
#line 4348 "page-view.c"
	}
#line 774 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp134_ = self->priv->crop_location;
#line 774 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp134_ == CROP_LOCATION_BOTTOM_LEFT) {
#line 774 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp133_ = TRUE;
#line 4356 "page-view.c"
	} else {
		CropLocation _tmp135_;
#line 775 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp135_ = self->priv->crop_location;
#line 775 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp133_ = _tmp135_ == CROP_LOCATION_BOTTOM;
#line 4363 "page-view.c"
	}
#line 774 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp133_) {
#line 774 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp132_ = TRUE;
#line 4369 "page-view.c"
	} else {
		CropLocation _tmp136_;
#line 776 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp136_ = self->priv->crop_location;
#line 776 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp132_ = _tmp136_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 4376 "page-view.c"
	}
#line 774 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp132_) {
#line 4380 "page-view.c"
		gint _tmp137_;
		gint _tmp138_;
#line 777 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp137_ = new_h;
#line 777 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp138_ = dy;
#line 777 "/home/bob/git/simple-scan/src/page-view.vala"
		new_h = _tmp137_ + _tmp138_;
#line 4389 "page-view.c"
	}
#line 779 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp139_ = self->priv->_page;
#line 779 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp140_ = new_x;
#line 779 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp141_ = new_y;
#line 779 "/home/bob/git/simple-scan/src/page-view.vala"
	page_move_crop (_tmp139_, _tmp140_, _tmp141_);
#line 782 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp143_ = new_w;
#line 782 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp144_ = cw;
#line 782 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp143_ != _tmp144_) {
#line 782 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp142_ = TRUE;
#line 4407 "page-view.c"
	} else {
		gint _tmp145_;
		gint _tmp146_;
#line 782 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp145_ = new_h;
#line 782 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp146_ = ch;
#line 782 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp142_ = _tmp145_ != _tmp146_;
#line 4417 "page-view.c"
	}
#line 782 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp142_) {
#line 4421 "page-view.c"
		Page* _tmp147_;
		gint _tmp148_;
		gint _tmp149_;
#line 783 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp147_ = self->priv->_page;
#line 783 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp148_ = new_w;
#line 783 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp149_ = new_h;
#line 783 "/home/bob/git/simple-scan/src/page-view.vala"
		page_set_custom_crop (_tmp147_, _tmp148_, _tmp149_);
#line 4433 "page-view.c"
	}
}


void
page_view_button_release (PageView* self,
                          gint x,
                          gint y)
{
#line 786 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 789 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->crop_location = CROP_LOCATION_NONE;
#line 790 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
#line 4449 "page-view.c"
}


static gboolean
page_view_animation_cb (PageView* self)
{
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
#line 793 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 795 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->animate_segment;
#line 795 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = self->priv->animate_n_segments;
#line 795 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->animate_segment = (_tmp0_ + 1) % _tmp1_;
#line 796 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
#line 797 "/home/bob/git/simple-scan/src/page-view.vala"
	result = TRUE;
#line 797 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 4473 "page-view.c"
}


static gboolean
_page_view_animation_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = page_view_animation_cb ((PageView*) self);
#line 813 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 4484 "page-view.c"
}


static void
page_view_update_animation (PageView* self)
{
	gboolean animate = FALSE;
	gboolean is_animating = FALSE;
	gboolean _tmp0_ = FALSE;
	Page* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	guint _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
#line 800 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 804 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = self->priv->_page;
#line 804 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp2_ = page_get_is_scanning (_tmp1_);
#line 804 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 804 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp3_) {
#line 4511 "page-view.c"
		Page* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
#line 804 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp4_ = self->priv->_page;
#line 804 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp5_ = page_get_has_data (_tmp4_);
#line 804 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp6_ = _tmp5_;
#line 804 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp0_ = !_tmp6_;
#line 4523 "page-view.c"
	} else {
#line 804 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp0_ = FALSE;
#line 4527 "page-view.c"
	}
#line 804 "/home/bob/git/simple-scan/src/page-view.vala"
	animate = _tmp0_;
#line 805 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp7_ = self->priv->animate_timeout;
#line 805 "/home/bob/git/simple-scan/src/page-view.vala"
	is_animating = _tmp7_ != ((guint) 0);
#line 806 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp8_ = animate;
#line 806 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp9_ = is_animating;
#line 806 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp8_ == _tmp9_) {
#line 807 "/home/bob/git/simple-scan/src/page-view.vala"
		return;
#line 4543 "page-view.c"
	}
#line 809 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp10_ = animate;
#line 809 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp10_) {
#line 4549 "page-view.c"
		guint _tmp11_;
#line 811 "/home/bob/git/simple-scan/src/page-view.vala"
		self->priv->animate_segment = 0;
#line 812 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp11_ = self->priv->animate_timeout;
#line 812 "/home/bob/git/simple-scan/src/page-view.vala"
		if (_tmp11_ == ((guint) 0)) {
#line 813 "/home/bob/git/simple-scan/src/page-view.vala"
			self->priv->animate_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, _page_view_animation_cb_gsource_func, page_view_ref (self), page_view_unref);
#line 4559 "page-view.c"
		}
	} else {
		guint _tmp12_;
#line 817 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp12_ = self->priv->animate_timeout;
#line 817 "/home/bob/git/simple-scan/src/page-view.vala"
		if (_tmp12_ != ((guint) 0)) {
#line 4567 "page-view.c"
			guint _tmp13_;
#line 818 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp13_ = self->priv->animate_timeout;
#line 818 "/home/bob/git/simple-scan/src/page-view.vala"
			g_source_remove (_tmp13_);
#line 4573 "page-view.c"
		}
#line 819 "/home/bob/git/simple-scan/src/page-view.vala"
		self->priv->animate_timeout = (guint) 0;
#line 4577 "page-view.c"
	}
}


void
page_view_render (PageView* self,
                  cairo_t* context)
{
	gint w = 0;
	gint h = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GdkPixbuf* _tmp11_;
	gboolean _tmp12_ = FALSE;
	Page* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp49_ = FALSE;
	Page* _tmp50_;
	gboolean _tmp51_;
	gboolean _tmp52_;
	Page* _tmp89_;
	gboolean _tmp90_;
	gboolean _tmp91_;
#line 823 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 823 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (context != NULL);
#line 825 "/home/bob/git/simple-scan/src/page-view.vala"
	page_view_update_animation (self);
#line 826 "/home/bob/git/simple-scan/src/page-view.vala"
	page_view_update_page_view (self);
#line 828 "/home/bob/git/simple-scan/src/page-view.vala"
	w = page_view_get_preview_width (self);
#line 829 "/home/bob/git/simple-scan/src/page-view.vala"
	h = page_view_get_preview_height (self);
#line 831 "/home/bob/git/simple-scan/src/page-view.vala"
	cairo_set_line_width (context, (gdouble) 1);
#line 832 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->_x_offset;
#line 832 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = self->priv->_y_offset;
#line 832 "/home/bob/git/simple-scan/src/page-view.vala"
	cairo_translate (context, (gdouble) _tmp0_, (gdouble) _tmp1_);
#line 835 "/home/bob/git/simple-scan/src/page-view.vala"
	cairo_set_source_rgb (context, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 836 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp2_ = self->priv->border_width;
#line 836 "/home/bob/git/simple-scan/src/page-view.vala"
	cairo_set_line_width (context, (gdouble) _tmp2_);
#line 837 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp3_ = self->priv->border_width;
#line 837 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp4_ = self->priv->border_width;
#line 837 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp5_ = self->priv->width_;
#line 837 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp6_ = self->priv->border_width;
#line 837 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp7_ = self->priv->height_;
#line 837 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp8_ = self->priv->border_width;
#line 837 "/home/bob/git/simple-scan/src/page-view.vala"
	cairo_rectangle (context, ((gdouble) _tmp3_) / 2, ((gdouble) _tmp4_) / 2, (gdouble) (_tmp5_ - _tmp6_), (gdouble) (_tmp7_ - _tmp8_));
#line 841 "/home/bob/git/simple-scan/src/page-view.vala"
	cairo_stroke (context);
#line 844 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp9_ = self->priv->border_width;
#line 844 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp10_ = self->priv->border_width;
#line 844 "/home/bob/git/simple-scan/src/page-view.vala"
	cairo_translate (context, (gdouble) _tmp9_, (gdouble) _tmp10_);
#line 845 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp11_ = self->priv->image;
#line 845 "/home/bob/git/simple-scan/src/page-view.vala"
	gdk_cairo_set_source_pixbuf (context, _tmp11_, (gdouble) 0, (gdouble) 0);
#line 846 "/home/bob/git/simple-scan/src/page-view.vala"
	cairo_paint (context);
#line 849 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp13_ = self->priv->_page;
#line 849 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp14_ = page_get_is_scanning (_tmp13_);
#line 849 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp15_ = _tmp14_;
#line 849 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp15_) {
#line 4673 "page-view.c"
		Page* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
#line 849 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp16_ = self->priv->_page;
#line 849 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp17_ = page_get_has_data (_tmp16_);
#line 849 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp18_ = _tmp17_;
#line 849 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp12_ = !_tmp18_;
#line 4685 "page-view.c"
	} else {
#line 849 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp12_ = FALSE;
#line 4689 "page-view.c"
	}
#line 849 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp12_) {
#line 4693 "page-view.c"
		gdouble outer_radius = 0.0;
		gint _tmp19_;
		gint _tmp20_;
		gdouble arc = 0.0;
		gint _tmp23_;
		gdouble x = 0.0;
		gdouble _tmp24_;
		gdouble _tmp25_;
		gdouble y = 0.0;
		gdouble _tmp26_;
		gdouble _tmp27_;
		gdouble inner_radius = 0.0;
		gdouble _tmp28_;
		gdouble _tmp29_;
		gdouble _tmp30_;
		gdouble _tmp31_;
		gdouble offset = 0.0;
#line 852 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp19_ = w;
#line 852 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp20_ = h;
#line 852 "/home/bob/git/simple-scan/src/page-view.vala"
		if (_tmp19_ > _tmp20_) {
#line 4717 "page-view.c"
			gint _tmp21_;
#line 853 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp21_ = w;
#line 853 "/home/bob/git/simple-scan/src/page-view.vala"
			outer_radius = 0.15 * _tmp21_;
#line 4723 "page-view.c"
		} else {
			gint _tmp22_;
#line 855 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp22_ = h;
#line 855 "/home/bob/git/simple-scan/src/page-view.vala"
			outer_radius = 0.15 * _tmp22_;
#line 4730 "page-view.c"
		}
#line 856 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp23_ = self->priv->animate_n_segments;
#line 856 "/home/bob/git/simple-scan/src/page-view.vala"
		arc = G_PI / _tmp23_;
#line 859 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp24_ = outer_radius;
#line 859 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp25_ = arc;
#line 859 "/home/bob/git/simple-scan/src/page-view.vala"
		x = _tmp24_ * sin (_tmp25_);
#line 860 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp26_ = outer_radius;
#line 860 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp27_ = arc;
#line 860 "/home/bob/git/simple-scan/src/page-view.vala"
		y = _tmp26_ * (cos (_tmp27_) - 1.0);
#line 861 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp28_ = x;
#line 861 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp29_ = x;
#line 861 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp30_ = y;
#line 861 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp31_ = y;
#line 861 "/home/bob/git/simple-scan/src/page-view.vala"
		inner_radius = 0.6 * sqrt ((_tmp28_ * _tmp29_) + (_tmp30_ * _tmp31_));
#line 863 "/home/bob/git/simple-scan/src/page-view.vala"
		offset = 0.0;
#line 4760 "page-view.c"
		{
			gint i = 0;
#line 864 "/home/bob/git/simple-scan/src/page-view.vala"
			i = 0;
#line 4765 "page-view.c"
			{
				gboolean _tmp32_ = FALSE;
#line 864 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp32_ = TRUE;
#line 864 "/home/bob/git/simple-scan/src/page-view.vala"
				while (TRUE) {
#line 4772 "page-view.c"
					gint _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					gdouble _tmp39_;
					gdouble _tmp40_;
					gint _tmp41_;
					gdouble _tmp42_;
					gdouble _tmp43_;
					gdouble _tmp44_;
					gdouble _tmp45_;
					gdouble _tmp46_;
					gint _tmp47_;
					gint _tmp48_;
#line 864 "/home/bob/git/simple-scan/src/page-view.vala"
					if (!_tmp32_) {
#line 4788 "page-view.c"
						gint _tmp33_;
						gdouble _tmp34_;
						gdouble _tmp35_;
#line 864 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp33_ = i;
#line 864 "/home/bob/git/simple-scan/src/page-view.vala"
						i = _tmp33_ + 1;
#line 864 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp34_ = offset;
#line 864 "/home/bob/git/simple-scan/src/page-view.vala"
						_tmp35_ = arc;
#line 864 "/home/bob/git/simple-scan/src/page-view.vala"
						offset = _tmp34_ + (_tmp35_ * 2);
#line 4802 "page-view.c"
					}
#line 864 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp32_ = FALSE;
#line 864 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp36_ = i;
#line 864 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp37_ = self->priv->animate_n_segments;
#line 864 "/home/bob/git/simple-scan/src/page-view.vala"
					if (!(_tmp36_ < _tmp37_)) {
#line 864 "/home/bob/git/simple-scan/src/page-view.vala"
						break;
#line 4814 "page-view.c"
					}
#line 866 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp38_ = w;
#line 866 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp39_ = outer_radius;
#line 866 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp40_ = offset;
#line 866 "/home/bob/git/simple-scan/src/page-view.vala"
					x = (_tmp38_ / 2) + (_tmp39_ * sin (_tmp40_));
#line 867 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp41_ = h;
#line 867 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp42_ = outer_radius;
#line 867 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp43_ = offset;
#line 867 "/home/bob/git/simple-scan/src/page-view.vala"
					y = (_tmp41_ / 2) - (_tmp42_ * cos (_tmp43_));
#line 868 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp44_ = x;
#line 868 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp45_ = y;
#line 868 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp46_ = inner_radius;
#line 868 "/home/bob/git/simple-scan/src/page-view.vala"
					cairo_arc (context, _tmp44_, _tmp45_, _tmp46_, (gdouble) 0, 2 * G_PI);
#line 870 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp47_ = i;
#line 870 "/home/bob/git/simple-scan/src/page-view.vala"
					_tmp48_ = self->priv->animate_segment;
#line 870 "/home/bob/git/simple-scan/src/page-view.vala"
					if (_tmp47_ == _tmp48_) {
#line 872 "/home/bob/git/simple-scan/src/page-view.vala"
						cairo_set_source_rgb (context, 0.75, 0.75, 0.75);
#line 873 "/home/bob/git/simple-scan/src/page-view.vala"
						cairo_fill_preserve (context);
#line 4850 "page-view.c"
					}
#line 876 "/home/bob/git/simple-scan/src/page-view.vala"
					cairo_set_source_rgb (context, 0.5, 0.5, 0.5);
#line 877 "/home/bob/git/simple-scan/src/page-view.vala"
					cairo_stroke (context);
#line 4856 "page-view.c"
				}
			}
		}
	}
#line 882 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp50_ = self->priv->_page;
#line 882 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp51_ = page_get_is_scanning (_tmp50_);
#line 882 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp52_ = _tmp51_;
#line 882 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp52_) {
#line 4869 "page-view.c"
		Page* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
#line 882 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp53_ = self->priv->_page;
#line 882 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp54_ = page_get_scan_line (_tmp53_);
#line 882 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp55_ = _tmp54_;
#line 882 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp49_ = _tmp55_ > 0;
#line 4881 "page-view.c"
	} else {
#line 882 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp49_ = FALSE;
#line 4885 "page-view.c"
	}
#line 882 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp49_) {
#line 4889 "page-view.c"
		gint scan_line = 0;
		Page* _tmp56_;
		gint _tmp57_;
		gint _tmp58_;
		gdouble s = 0.0;
		gdouble x1 = 0.0;
		gdouble y1 = 0.0;
		gdouble x2 = 0.0;
		gdouble y2 = 0.0;
		Page* _tmp59_;
		ScanDirection _tmp60_;
		ScanDirection _tmp61_;
		gdouble _tmp85_;
		gdouble _tmp86_;
		gdouble _tmp87_;
		gdouble _tmp88_;
#line 884 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp56_ = self->priv->_page;
#line 884 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp57_ = page_get_scan_line (_tmp56_);
#line 884 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp58_ = _tmp57_;
#line 884 "/home/bob/git/simple-scan/src/page-view.vala"
		scan_line = _tmp58_;
#line 888 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp59_ = self->priv->_page;
#line 888 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp60_ = page_get_scan_direction (_tmp59_);
#line 888 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp61_ = _tmp60_;
#line 888 "/home/bob/git/simple-scan/src/page-view.vala"
		switch (_tmp61_) {
#line 888 "/home/bob/git/simple-scan/src/page-view.vala"
			case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 4924 "page-view.c"
			{
				gint _tmp62_;
				gdouble _tmp63_;
				gint _tmp64_;
				gdouble _tmp65_;
#line 891 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp62_ = scan_line;
#line 891 "/home/bob/git/simple-scan/src/page-view.vala"
				s = (gdouble) page_view_page_to_screen_y (self, _tmp62_);
#line 892 "/home/bob/git/simple-scan/src/page-view.vala"
				x1 = (gdouble) 0;
#line 892 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp63_ = s;
#line 892 "/home/bob/git/simple-scan/src/page-view.vala"
				y1 = _tmp63_ + 0.5;
#line 893 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp64_ = w;
#line 893 "/home/bob/git/simple-scan/src/page-view.vala"
				x2 = (gdouble) _tmp64_;
#line 893 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp65_ = s;
#line 893 "/home/bob/git/simple-scan/src/page-view.vala"
				y2 = _tmp65_ + 0.5;
#line 894 "/home/bob/git/simple-scan/src/page-view.vala"
				break;
#line 4950 "page-view.c"
			}
#line 888 "/home/bob/git/simple-scan/src/page-view.vala"
			case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 4954 "page-view.c"
			{
				gint _tmp66_;
				gint _tmp67_;
				gdouble _tmp68_;
				gint _tmp69_;
				gint _tmp70_;
				gdouble _tmp71_;
#line 896 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp66_ = scan_line;
#line 896 "/home/bob/git/simple-scan/src/page-view.vala"
				s = (gdouble) page_view_page_to_screen_y (self, _tmp66_);
#line 897 "/home/bob/git/simple-scan/src/page-view.vala"
				x1 = (gdouble) 0;
#line 897 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp67_ = h;
#line 897 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp68_ = s;
#line 897 "/home/bob/git/simple-scan/src/page-view.vala"
				y1 = (_tmp67_ - _tmp68_) + 0.5;
#line 898 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp69_ = w;
#line 898 "/home/bob/git/simple-scan/src/page-view.vala"
				x2 = (gdouble) _tmp69_;
#line 898 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp70_ = h;
#line 898 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp71_ = s;
#line 898 "/home/bob/git/simple-scan/src/page-view.vala"
				y2 = (_tmp70_ - _tmp71_) + 0.5;
#line 899 "/home/bob/git/simple-scan/src/page-view.vala"
				break;
#line 4986 "page-view.c"
			}
#line 888 "/home/bob/git/simple-scan/src/page-view.vala"
			case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 4990 "page-view.c"
			{
				gint _tmp72_;
				gdouble _tmp73_;
				gdouble _tmp74_;
				gint _tmp75_;
#line 901 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp72_ = scan_line;
#line 901 "/home/bob/git/simple-scan/src/page-view.vala"
				s = (gdouble) page_view_page_to_screen_x (self, _tmp72_);
#line 902 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp73_ = s;
#line 902 "/home/bob/git/simple-scan/src/page-view.vala"
				x1 = _tmp73_ + 0.5;
#line 902 "/home/bob/git/simple-scan/src/page-view.vala"
				y1 = (gdouble) 0;
#line 903 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp74_ = s;
#line 903 "/home/bob/git/simple-scan/src/page-view.vala"
				x2 = _tmp74_ + 0.5;
#line 903 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp75_ = h;
#line 903 "/home/bob/git/simple-scan/src/page-view.vala"
				y2 = (gdouble) _tmp75_;
#line 904 "/home/bob/git/simple-scan/src/page-view.vala"
				break;
#line 5016 "page-view.c"
			}
#line 888 "/home/bob/git/simple-scan/src/page-view.vala"
			case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 5020 "page-view.c"
			{
				gint _tmp76_;
				gint _tmp77_;
				gdouble _tmp78_;
				gint _tmp79_;
				gdouble _tmp80_;
				gint _tmp81_;
#line 906 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp76_ = scan_line;
#line 906 "/home/bob/git/simple-scan/src/page-view.vala"
				s = (gdouble) page_view_page_to_screen_x (self, _tmp76_);
#line 907 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp77_ = w;
#line 907 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp78_ = s;
#line 907 "/home/bob/git/simple-scan/src/page-view.vala"
				x1 = (_tmp77_ - _tmp78_) + 0.5;
#line 907 "/home/bob/git/simple-scan/src/page-view.vala"
				y1 = (gdouble) 0;
#line 908 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp79_ = w;
#line 908 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp80_ = s;
#line 908 "/home/bob/git/simple-scan/src/page-view.vala"
				x2 = (_tmp79_ - _tmp80_) + 0.5;
#line 908 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp81_ = h;
#line 908 "/home/bob/git/simple-scan/src/page-view.vala"
				y2 = (gdouble) _tmp81_;
#line 909 "/home/bob/git/simple-scan/src/page-view.vala"
				break;
#line 5052 "page-view.c"
			}
			default:
			{
				gdouble _tmp82_;
				gdouble _tmp83_;
				gdouble _tmp84_;
#line 911 "/home/bob/git/simple-scan/src/page-view.vala"
				y2 = (gdouble) 0;
#line 911 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp82_ = y2;
#line 911 "/home/bob/git/simple-scan/src/page-view.vala"
				x2 = _tmp82_;
#line 911 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp83_ = x2;
#line 911 "/home/bob/git/simple-scan/src/page-view.vala"
				y1 = _tmp83_;
#line 911 "/home/bob/git/simple-scan/src/page-view.vala"
				_tmp84_ = y1;
#line 911 "/home/bob/git/simple-scan/src/page-view.vala"
				x1 = _tmp84_;
#line 912 "/home/bob/git/simple-scan/src/page-view.vala"
				break;
#line 5075 "page-view.c"
			}
		}
#line 915 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp85_ = x1;
#line 915 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp86_ = y1;
#line 915 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_move_to (context, _tmp85_, _tmp86_);
#line 916 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp87_ = x2;
#line 916 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp88_ = y2;
#line 916 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_line_to (context, _tmp87_, _tmp88_);
#line 917 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_set_source_rgb (context, 1.0, 0.0, 0.0);
#line 918 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_stroke (context);
#line 5094 "page-view.c"
	}
#line 922 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp89_ = self->priv->_page;
#line 922 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp90_ = page_get_has_crop (_tmp89_);
#line 922 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp91_ = _tmp90_;
#line 922 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp91_) {
#line 5104 "page-view.c"
		gint x = 0;
		Page* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		gint y = 0;
		Page* _tmp95_;
		gint _tmp96_;
		gint _tmp97_;
		gint crop_width = 0;
		Page* _tmp98_;
		gint _tmp99_;
		gint _tmp100_;
		gint crop_height = 0;
		Page* _tmp101_;
		gint _tmp102_;
		gint _tmp103_;
		gint dx = 0;
		gint _tmp104_;
		gint dy = 0;
		gint _tmp105_;
		gint dw = 0;
		gint _tmp106_;
		gint dh = 0;
		gint _tmp107_;
		gint _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		gint _tmp111_;
		gint _tmp112_;
		gint _tmp113_;
		gint _tmp114_;
		gint _tmp115_;
		gint _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _tmp119_;
		gint _tmp120_;
		gint _tmp121_;
#line 924 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp92_ = self->priv->_page;
#line 924 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp93_ = page_get_crop_x (_tmp92_);
#line 924 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp94_ = _tmp93_;
#line 924 "/home/bob/git/simple-scan/src/page-view.vala"
		x = _tmp94_;
#line 925 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp95_ = self->priv->_page;
#line 925 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp96_ = page_get_crop_y (_tmp95_);
#line 925 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp97_ = _tmp96_;
#line 925 "/home/bob/git/simple-scan/src/page-view.vala"
		y = _tmp97_;
#line 926 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp98_ = self->priv->_page;
#line 926 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp99_ = page_get_crop_width (_tmp98_);
#line 926 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp100_ = _tmp99_;
#line 926 "/home/bob/git/simple-scan/src/page-view.vala"
		crop_width = _tmp100_;
#line 927 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp101_ = self->priv->_page;
#line 927 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp102_ = page_get_crop_height (_tmp101_);
#line 927 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp103_ = _tmp102_;
#line 927 "/home/bob/git/simple-scan/src/page-view.vala"
		crop_height = _tmp103_;
#line 929 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp104_ = x;
#line 929 "/home/bob/git/simple-scan/src/page-view.vala"
		dx = page_view_page_to_screen_x (self, _tmp104_);
#line 930 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp105_ = y;
#line 930 "/home/bob/git/simple-scan/src/page-view.vala"
		dy = page_view_page_to_screen_y (self, _tmp105_);
#line 931 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp106_ = crop_width;
#line 931 "/home/bob/git/simple-scan/src/page-view.vala"
		dw = page_view_page_to_screen_x (self, _tmp106_);
#line 932 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp107_ = crop_height;
#line 932 "/home/bob/git/simple-scan/src/page-view.vala"
		dh = page_view_page_to_screen_y (self, _tmp107_);
#line 935 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp108_ = w;
#line 935 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp109_ = h;
#line 935 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_rectangle (context, (gdouble) 0, (gdouble) 0, (gdouble) _tmp108_, (gdouble) _tmp109_);
#line 936 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_new_sub_path (context);
#line 937 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp110_ = dx;
#line 937 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp111_ = dy;
#line 937 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp112_ = dw;
#line 937 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp113_ = dh;
#line 937 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_rectangle (context, (gdouble) _tmp110_, (gdouble) _tmp111_, (gdouble) _tmp112_, (gdouble) _tmp113_);
#line 938 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_set_fill_rule (context, CAIRO_FILL_RULE_EVEN_ODD);
#line 939 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_set_source_rgba (context, 0.25, 0.25, 0.25, 0.2);
#line 940 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_fill (context);
#line 943 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp114_ = dx;
#line 943 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp115_ = dy;
#line 943 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp116_ = dw;
#line 943 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp117_ = dh;
#line 943 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_rectangle (context, _tmp114_ - 1.5, _tmp115_ - 1.5, (gdouble) (_tmp116_ + 3), (gdouble) (_tmp117_ + 3));
#line 944 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_set_source_rgb (context, 1.0, 1.0, 1.0);
#line 945 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_stroke (context);
#line 946 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp118_ = dx;
#line 946 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp119_ = dy;
#line 946 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp120_ = dw;
#line 946 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp121_ = dh;
#line 946 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_rectangle (context, _tmp118_ - 0.5, _tmp119_ - 0.5, (gdouble) (_tmp120_ + 1), (gdouble) (_tmp121_ + 1));
#line 947 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_set_source_rgb (context, 0.0, 0.0, 0.0);
#line 948 "/home/bob/git/simple-scan/src/page-view.vala"
		cairo_stroke (context);
#line 5243 "page-view.c"
	}
}


static void
page_view_page_pixels_changed_cb (PageView* self,
                                  Page* p)
{
#line 994 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 994 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 997 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 998 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
#line 5260 "page-view.c"
}


static void
page_view_page_size_changed_cb (PageView* self,
                                Page* p)
{
#line 1001 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 1001 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 1004 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 1005 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_emit (self, page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL], 0);
#line 1006 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
#line 5278 "page-view.c"
}


static void
page_view_page_overlay_changed_cb (PageView* self,
                                   Page* p)
{
#line 1009 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 1009 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 1011 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
#line 5292 "page-view.c"
}


static void
page_view_scan_direction_changed_cb (PageView* self,
                                     Page* p)
{
#line 1014 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 1014 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 1017 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 1018 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_emit (self, page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL], 0);
#line 1019 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
#line 5310 "page-view.c"
}


Page*
page_view_get_page (PageView* self)
{
	Page* result;
	Page* _tmp0_;
#line 29 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 29 "/home/bob/git/simple-scan/src/page-view.vala"
	result = _tmp0_;
#line 29 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 5327 "page-view.c"
}


static gpointer
_page_ref0 (gpointer self)
{
#line 29 "/home/bob/git/simple-scan/src/page-view.vala"
	return self ? page_ref (self) : NULL;
#line 5336 "page-view.c"
}


static void
page_view_set_page (PageView* self,
                    Page* value)
{
	Page* _tmp0_;
#line 29 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 29 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = _page_ref0 (value);
#line 29 "/home/bob/git/simple-scan/src/page-view.vala"
	_page_unref0 (self->priv->_page);
#line 29 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->_page = _tmp0_;
#line 5353 "page-view.c"
}


gboolean
page_view_get_selected (PageView* self)
{
	gboolean result;
	gboolean _tmp0_;
#line 38 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 38 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->selected_;
#line 38 "/home/bob/git/simple-scan/src/page-view.vala"
	result = _tmp0_;
#line 38 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 5370 "page-view.c"
}


void
page_view_set_selected (PageView* self,
                        gboolean value)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp11_;
	gboolean _tmp12_;
#line 39 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp2_ = page_view_get_selected (self);
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp3_) {
#line 5392 "page-view.c"
		gboolean _tmp4_;
		gboolean _tmp5_;
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp4_ = page_view_get_selected (self);
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp5_ = _tmp4_;
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp1_ = _tmp5_;
#line 5401 "page-view.c"
	} else {
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp1_ = FALSE;
#line 5405 "page-view.c"
	}
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp1_) {
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp0_ = TRUE;
#line 5411 "page-view.c"
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		gboolean _tmp8_;
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp7_ = page_view_get_selected (self);
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp8_ = _tmp7_;
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
		if (!_tmp8_) {
#line 5422 "page-view.c"
			gboolean _tmp9_;
			gboolean _tmp10_;
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp9_ = page_view_get_selected (self);
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp10_ = _tmp9_;
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp6_ = !_tmp10_;
#line 5431 "page-view.c"
		} else {
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
			_tmp6_ = FALSE;
#line 5435 "page-view.c"
		}
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp0_ = _tmp6_;
#line 5439 "page-view.c"
	}
#line 41 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp0_) {
#line 42 "/home/bob/git/simple-scan/src/page-view.vala"
		return;
#line 5445 "page-view.c"
	}
#line 43 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp11_ = page_view_get_selected (self);
#line 43 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp12_ = _tmp11_;
#line 43 "/home/bob/git/simple-scan/src/page-view.vala"
	page_view_set_selected (self, _tmp12_);
#line 44 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
#line 5455 "page-view.c"
}


gint
page_view_get_x_offset (PageView* self)
{
	gint result;
	gint _tmp0_;
#line 64 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 64 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->_x_offset;
#line 64 "/home/bob/git/simple-scan/src/page-view.vala"
	result = _tmp0_;
#line 64 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 5472 "page-view.c"
}


void
page_view_set_x_offset (PageView* self,
                        gint value)
{
#line 64 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->_x_offset = value;
#line 5484 "page-view.c"
}


gint
page_view_get_y_offset (PageView* self)
{
	gint result;
	gint _tmp0_;
#line 65 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 65 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->_y_offset;
#line 65 "/home/bob/git/simple-scan/src/page-view.vala"
	result = _tmp0_;
#line 65 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 5501 "page-view.c"
}


void
page_view_set_y_offset (PageView* self,
                        gint value)
{
#line 65 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->_y_offset = value;
#line 5513 "page-view.c"
}


GdkCursorType
page_view_get_cursor (PageView* self)
{
	GdkCursorType result;
	GdkCursorType _tmp0_;
#line 76 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 76 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->_cursor;
#line 76 "/home/bob/git/simple-scan/src/page-view.vala"
	result = _tmp0_;
#line 76 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 5530 "page-view.c"
}


static void
page_view_set_cursor (PageView* self,
                      GdkCursorType value)
{
#line 76 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 76 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->_cursor = value;
#line 5542 "page-view.c"
}


gint
page_view_get_width (PageView* self)
{
	gint result;
	gint _tmp0_;
#line 954 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 954 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->width_;
#line 954 "/home/bob/git/simple-scan/src/page-view.vala"
	result = _tmp0_;
#line 954 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 5559 "page-view.c"
}


void
page_view_set_width (PageView* self,
                     gint value)
{
	gint h = 0;
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Page* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gint _tmp10_;
#line 955 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 958 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 958 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = page_get_height (_tmp0_);
#line 958 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp2_ = _tmp1_;
#line 958 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp3_ = self->priv->_page;
#line 958 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp4_ = page_get_width (_tmp3_);
#line 958 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp5_ = _tmp4_;
#line 958 "/home/bob/git/simple-scan/src/page-view.vala"
	h = (gint) ((((gdouble) value) * _tmp2_) / _tmp5_);
#line 959 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp7_ = self->priv->width_;
#line 959 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp7_ == value) {
#line 5597 "page-view.c"
		gint _tmp8_;
		gint _tmp9_;
#line 959 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp8_ = self->priv->height_;
#line 959 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp9_ = h;
#line 959 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp6_ = _tmp8_ == _tmp9_;
#line 5606 "page-view.c"
	} else {
#line 959 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp6_ = FALSE;
#line 5610 "page-view.c"
	}
#line 959 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp6_) {
#line 960 "/home/bob/git/simple-scan/src/page-view.vala"
		return;
#line 5616 "page-view.c"
	}
#line 962 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->width_ = value;
#line 963 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp10_ = h;
#line 963 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->height_ = _tmp10_;
#line 966 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 968 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_emit (self, page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL], 0);
#line 969 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
#line 5630 "page-view.c"
}


gint
page_view_get_height (PageView* self)
{
	gint result;
	gint _tmp0_;
#line 975 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 975 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->height_;
#line 975 "/home/bob/git/simple-scan/src/page-view.vala"
	result = _tmp0_;
#line 975 "/home/bob/git/simple-scan/src/page-view.vala"
	return result;
#line 5647 "page-view.c"
}


void
page_view_set_height (PageView* self,
                      gint value)
{
	gint w = 0;
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Page* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp10_;
#line 976 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 979 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 979 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 979 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp2_ = _tmp1_;
#line 979 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp3_ = self->priv->_page;
#line 979 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp4_ = page_get_height (_tmp3_);
#line 979 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp5_ = _tmp4_;
#line 979 "/home/bob/git/simple-scan/src/page-view.vala"
	w = (gint) ((((gdouble) value) * _tmp2_) / _tmp5_);
#line 980 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp7_ = self->priv->width_;
#line 980 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp8_ = w;
#line 980 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp7_ == _tmp8_) {
#line 5688 "page-view.c"
		gint _tmp9_;
#line 980 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp9_ = self->priv->height_;
#line 980 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp6_ = _tmp9_ == value;
#line 5694 "page-view.c"
	} else {
#line 980 "/home/bob/git/simple-scan/src/page-view.vala"
		_tmp6_ = FALSE;
#line 5698 "page-view.c"
	}
#line 980 "/home/bob/git/simple-scan/src/page-view.vala"
	if (_tmp6_) {
#line 981 "/home/bob/git/simple-scan/src/page-view.vala"
		return;
#line 5704 "page-view.c"
	}
#line 983 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp10_ = w;
#line 983 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->width_ = _tmp10_;
#line 984 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->height_ = value;
#line 987 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 989 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_emit (self, page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL], 0);
#line 990 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
#line 5718 "page-view.c"
}


static void
value_page_view_init (GValue* value)
{
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	value->data[0].v_pointer = NULL;
#line 5727 "page-view.c"
}


static void
value_page_view_free_value (GValue* value)
{
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	if (value->data[0].v_pointer) {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		page_view_unref (value->data[0].v_pointer);
#line 5738 "page-view.c"
	}
}


static void
value_page_view_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	if (src_value->data[0].v_pointer) {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		dest_value->data[0].v_pointer = page_view_ref (src_value->data[0].v_pointer);
#line 5751 "page-view.c"
	} else {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5755 "page-view.c"
	}
}


static gpointer
value_page_view_peek_pointer (const GValue* value)
{
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	return value->data[0].v_pointer;
#line 5765 "page-view.c"
}


static gchar*
value_page_view_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	if (collect_values[0].v_pointer) {
#line 5777 "page-view.c"
		PageView * object;
		object = collect_values[0].v_pointer;
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		if (object->parent_instance.g_class == NULL) {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5784 "page-view.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5788 "page-view.c"
		}
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		value->data[0].v_pointer = page_view_ref (object);
#line 5792 "page-view.c"
	} else {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		value->data[0].v_pointer = NULL;
#line 5796 "page-view.c"
	}
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	return NULL;
#line 5800 "page-view.c"
}


static gchar*
value_page_view_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	PageView ** object_p;
	object_p = collect_values[0].v_pointer;
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	if (!object_p) {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5816 "page-view.c"
	}
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	if (!value->data[0].v_pointer) {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		*object_p = NULL;
#line 5822 "page-view.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		*object_p = value->data[0].v_pointer;
#line 5826 "page-view.c"
	} else {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		*object_p = page_view_ref (value->data[0].v_pointer);
#line 5830 "page-view.c"
	}
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	return NULL;
#line 5834 "page-view.c"
}


GParamSpec*
param_spec_page_view (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecPageView* spec;
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PAGE_VIEW), NULL);
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	return G_PARAM_SPEC (spec);
#line 5854 "page-view.c"
}


gpointer
value_get_page_view (const GValue* value)
{
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW), NULL);
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	return value->data[0].v_pointer;
#line 5865 "page-view.c"
}


void
value_set_page_view (GValue* value,
                     gpointer v_object)
{
	PageView * old;
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW));
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	old = value->data[0].v_pointer;
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	if (v_object) {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE_VIEW));
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		value->data[0].v_pointer = v_object;
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		page_view_ref (value->data[0].v_pointer);
#line 5888 "page-view.c"
	} else {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		value->data[0].v_pointer = NULL;
#line 5892 "page-view.c"
	}
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	if (old) {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		page_view_unref (old);
#line 5898 "page-view.c"
	}
}


void
value_take_page_view (GValue* value,
                      gpointer v_object)
{
	PageView * old;
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW));
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	old = value->data[0].v_pointer;
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	if (v_object) {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE_VIEW));
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		value->data[0].v_pointer = v_object;
#line 5920 "page-view.c"
	} else {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		value->data[0].v_pointer = NULL;
#line 5924 "page-view.c"
	}
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	if (old) {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		page_view_unref (old);
#line 5930 "page-view.c"
	}
}


static void
page_view_class_init (PageViewClass * klass)
{
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	page_view_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	((PageViewClass *) klass)->finalize = page_view_finalize;
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	g_type_class_add_private (klass, sizeof (PageViewPrivate));
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL] = g_signal_new ("size-changed", TYPE_PAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	page_view_signals[PAGE_VIEW_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_PAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 5948 "page-view.c"
}


static void
page_view_instance_init (PageView * self)
{
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv = PAGE_VIEW_GET_PRIVATE (self);
#line 32 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->image = NULL;
#line 35 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->selected_ = FALSE;
#line 48 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->border_width = 1;
#line 51 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 76 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->_cursor = GDK_ARROW;
#line 78 "/home/bob/git/simple-scan/src/page-view.vala"
	self->priv->animate_n_segments = 7;
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	self->ref_count = 1;
#line 5971 "page-view.c"
}


static void
page_view_finalize (PageView * obj)
{
	PageView * self;
	Page* _tmp0_;
	guint _tmp1_;
	Page* _tmp2_;
	guint _tmp3_;
	Page* _tmp4_;
	guint _tmp5_;
	Page* _tmp6_;
	guint _tmp7_;
	Page* _tmp8_;
	guint _tmp9_;
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_VIEW, PageView);
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_handlers_destroy (self);
#line 97 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 97 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 97 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _page_view_page_pixels_changed_cb_page_pixels_changed, self);
#line 98 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp2_ = self->priv->_page;
#line 98 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 98 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _page_view_page_size_changed_cb_page_size_changed, self);
#line 99 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp4_ = self->priv->_page;
#line 99 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 99 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _page_view_page_overlay_changed_cb_page_crop_changed, self);
#line 100 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp6_ = self->priv->_page;
#line 100 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_parse_name ("scan-line-changed", TYPE_PAGE, &_tmp7_, NULL, FALSE);
#line 100 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _page_view_page_overlay_changed_cb_page_scan_line_changed, self);
#line 101 "/home/bob/git/simple-scan/src/page-view.vala"
	_tmp8_ = self->priv->_page;
#line 101 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp9_, NULL, FALSE);
#line 101 "/home/bob/git/simple-scan/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _page_view_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 29 "/home/bob/git/simple-scan/src/page-view.vala"
	_page_unref0 (self->priv->_page);
#line 32 "/home/bob/git/simple-scan/src/page-view.vala"
	_g_object_unref0 (self->priv->image);
#line 6027 "page-view.c"
}


GType
page_view_get_type (void)
{
	static volatile gsize page_view_type_id__volatile = 0;
	if (g_once_init_enter (&page_view_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_page_view_init, value_page_view_free_value, value_page_view_copy_value, value_page_view_peek_pointer, "p", value_page_view_collect_value, "p", value_page_view_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PageViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PageView), 0, (GInstanceInitFunc) page_view_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType page_view_type_id;
		page_view_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PageView", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&page_view_type_id__volatile, page_view_type_id);
	}
	return page_view_type_id__volatile;
}


gpointer
page_view_ref (gpointer instance)
{
	PageView * self;
	self = instance;
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	g_atomic_int_inc (&self->ref_count);
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	return instance;
#line 6056 "page-view.c"
}


void
page_view_unref (gpointer instance)
{
	PageView * self;
	self = instance;
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		PAGE_VIEW_GET_CLASS (self)->finalize (self);
#line 26 "/home/bob/git/simple-scan/src/page-view.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 6071 "page-view.c"
	}
}



