/* page.c generated by valac 0.40.9, the Vala compiler
 * generated from page.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
typedef struct _PagePrivate PagePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanLinePrivate ScanLinePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PIXBUF_WRITER (pixbuf_writer_get_type ())
#define PIXBUF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXBUF_WRITER, PixbufWriter))
#define PIXBUF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXBUF_WRITER, PixbufWriterClass))
#define IS_PIXBUF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXBUF_WRITER))
#define IS_PIXBUF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXBUF_WRITER))
#define PIXBUF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXBUF_WRITER, PixbufWriterClass))

typedef struct _PixbufWriter PixbufWriter;
typedef struct _PixbufWriterClass PixbufWriterClass;
#define _pixbuf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pixbuf_writer_unref (var), NULL)))
typedef struct _ParamSpecPage ParamSpecPage;
enum  {
	PAGE_PIXELS_CHANGED_SIGNAL,
	PAGE_SIZE_CHANGED_SIGNAL,
	PAGE_SCAN_LINE_CHANGED_SIGNAL,
	PAGE_SCAN_DIRECTION_CHANGED_SIGNAL,
	PAGE_CROP_CHANGED_SIGNAL,
	PAGE_SCAN_FINISHED_SIGNAL,
	PAGE_NUM_SIGNALS
};
static guint page_signals[PAGE_NUM_SIGNALS] = {0};
typedef struct _PixbufWriterPrivate PixbufWriterPrivate;
typedef struct _ParamSpecPixbufWriter ParamSpecPixbufWriter;

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _Page {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PagePrivate * priv;
};

struct _PageClass {
	GTypeClass parent_class;
	void (*finalize) (Page *self);
};

struct _PagePrivate {
	gint _dpi;
	gint expected_rows;
	gint _depth;
	gchar* _color_profile;
	gint _scan_width;
	gint _scan_height;
	gint _rowstride;
	gint _n_channels;
	guchar* pixels;
	gint pixels_length1;
	gint _pixels_size_;
	gboolean _is_scanning;
	gboolean _has_data;
	gint _scan_line;
	ScanDirection scan_direction_;
	gboolean _has_crop;
	gchar* _crop_name;
	gint _crop_x;
	gint _crop_y;
	gint _crop_width;
	gint _crop_height;
};

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

struct _ScanLine {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanLinePrivate * priv;
	gint number;
	gint n_lines;
	gint width;
	gint depth;
	gint channel;
	guchar* data;
	gint data_length1;
	gint data_length;
};

struct _ScanLineClass {
	GTypeClass parent_class;
	void (*finalize) (ScanLine *self);
};

struct _ParamSpecPage {
	GParamSpec parent_instance;
};

struct _PixbufWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PixbufWriterPrivate * priv;
	GFileOutputStream* stream;
};

struct _PixbufWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PixbufWriter *self);
};

struct _ParamSpecPixbufWriter {
	GParamSpec parent_instance;
};


static gpointer page_parent_class = NULL;
static gpointer pixbuf_writer_parent_class = NULL;

GType scan_direction_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_page (GValue* value,
                     gpointer v_object);
void value_take_page (GValue* value,
                      gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PAGE, PagePrivate))
Page* page_new (gint width,
                gint height,
                gint dpi,
                ScanDirection scan_direction);
Page* page_construct (GType object_type,
                      gint width,
                      gint height,
                      gint dpi,
                      ScanDirection scan_direction);
static void page_set_scan_width (Page* self,
                          gint value);
static void page_set_scan_height (Page* self,
                           gint value);
static void page_set_dpi (Page* self,
                   gint value);
void page_set_scan_direction (Page* self,
                              ScanDirection value);
Page* page_new_from_data (gint scan_width,
                          gint scan_height,
                          gint rowstride,
                          gint n_channels,
                          gint depth,
                          gint dpi,
                          ScanDirection scan_direction,
                          const gchar* color_profile,
                          guchar* pixels,
                          int pixels_length1,
                          gboolean has_crop,
                          const gchar* crop_name,
                          gint crop_x,
                          gint crop_y,
                          gint crop_width,
                          gint crop_height);
Page* page_construct_from_data (GType object_type,
                                gint scan_width,
                                gint scan_height,
                                gint rowstride,
                                gint n_channels,
                                gint depth,
                                gint dpi,
                                ScanDirection scan_direction,
                                const gchar* color_profile,
                                guchar* pixels,
                                int pixels_length1,
                                gboolean has_crop,
                                const gchar* crop_name,
                                gint crop_x,
                                gint crop_y,
                                gint crop_width,
                                gint crop_height);
static void page_set_rowstride (Page* self,
                         gint value);
static void page_set_n_channels (Page* self,
                          gint value);
static void page_set_depth (Page* self,
                     gint value);
void page_set_color_profile (Page* self,
                             const gchar* value);
static guchar* _vala_array_dup3 (guchar* self,
                          int length);
static void page_set_has_data (Page* self,
                        gboolean value);
static void page_set_has_crop (Page* self,
                        gboolean value);
static void page_set_crop_name (Page* self,
                         const gchar* value);
static void page_set_crop_x (Page* self,
                      gint value);
static void page_set_crop_y (Page* self,
                      gint value);
static void page_set_crop_width (Page* self,
                          gint value);
static void page_set_crop_height (Page* self,
                           gint value);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_scan_page_info (GValue* value,
                               gpointer v_object);
void value_take_scan_page_info (GValue* value,
                                gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
void page_set_page_info (Page* self,
                         ScanPageInfo* info);
gint page_get_scan_height (Page* self);
gint page_get_scan_width (Page* self);
gint page_get_depth (Page* self);
gint page_get_n_channels (Page* self);
gint page_get_rowstride (Page* self);
void page_start (Page* self);
static void page_set_is_scanning (Page* self,
                           gboolean value);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_scan_line (GValue* value,
                          gpointer v_object);
void value_take_scan_line (GValue* value,
                           gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
static void page_parse_line (Page* self,
                      ScanLine* line,
                      gint n,
                      gboolean* size_changed);
static void page_set_scan_line (Page* self,
                         gint value);
void page_parse_scan_line (Page* self,
                           ScanLine* line);
void page_finish (Page* self);
gint page_get_scan_line (Page* self);
void page_rotate_left (Page* self);
ScanDirection page_get_scan_direction (Page* self);
void page_rotate_right (Page* self);
void page_set_no_crop (Page* self);
gboolean page_get_has_crop (Page* self);
void page_set_custom_crop (Page* self,
                           gint width,
                           gint height);
const gchar* page_get_crop_name (Page* self);
gint page_get_crop_width (Page* self);
gint page_get_crop_height (Page* self);
void page_set_named_crop (Page* self,
                          const gchar* name);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gint page_get_dpi (Page* self);
void page_move_crop (Page* self,
                     gint x,
                     gint y);
void page_rotate_crop (Page* self);
gint page_get_crop_x (Page* self);
gint page_get_crop_y (Page* self);
guchar* page_get_pixels (Page* self,
                         int* result_length1);
static guchar page_get_sample (Page* self,
                        guchar* pixels,
                        int pixels_length1,
                        gint offset,
                        gint x,
                        gint depth,
                        gint n_channels,
                        gint channel);
static void page_get_pixel (Page* self,
                     gint x,
                     gint y,
                     guchar* pixel,
                     int pixel_length1,
                     gint offset);
GdkPixbuf* page_get_image (Page* self,
                           gboolean apply_crop);
static gchar* page_get_icc_data_encoded (Page* self,
                                  const gchar* icc_profile_filename);
void page_copy_to_clipboard (Page* self,
                             GtkWindow* window);
void page_save (Page* self,
                const gchar* type,
                gint quality,
                GFile* file,
                GError** error);
gpointer pixbuf_writer_ref (gpointer instance);
void pixbuf_writer_unref (gpointer instance);
GParamSpec* param_spec_pixbuf_writer (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void value_set_pixbuf_writer (GValue* value,
                              gpointer v_object);
void value_take_pixbuf_writer (GValue* value,
                               gpointer v_object);
gpointer value_get_pixbuf_writer (const GValue* value);
GType pixbuf_writer_get_type (void) G_GNUC_CONST;
PixbufWriter* pixbuf_writer_new (GFileOutputStream* stream);
PixbufWriter* pixbuf_writer_construct (GType object_type,
                                       GFileOutputStream* stream);
const gchar* page_get_color_profile (Page* self);
void pixbuf_writer_save (PixbufWriter* self,
                         GdkPixbuf* image,
                         const gchar* type,
                         gchar** option_keys,
                         int option_keys_length1,
                         gchar** option_values,
                         int option_values_length1,
                         GError** error);
gboolean page_get_is_landscape (Page* self);
gboolean page_get_is_scanning (Page* self);
gboolean page_get_has_data (Page* self);
gboolean page_get_is_color (Page* self);
static void page_finalize (Page * obj);
static gboolean pixbuf_writer_write_pixbuf_data (PixbufWriter* self,
                                          guint8* buf,
                                          int buf_length1,
                                          GError** error);
static gboolean _pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf,
                                                                gsize buf_length1,
                                                                GError** error,
                                                                gpointer self);
static void pixbuf_writer_finalize (PixbufWriter * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


GType
scan_direction_get_type (void)
{
	static volatile gsize scan_direction_type_id__volatile = 0;
	if (g_once_init_enter (&scan_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_DIRECTION_TOP_TO_BOTTOM, "SCAN_DIRECTION_TOP_TO_BOTTOM", "top-to-bottom"}, {SCAN_DIRECTION_LEFT_TO_RIGHT, "SCAN_DIRECTION_LEFT_TO_RIGHT", "left-to-right"}, {SCAN_DIRECTION_BOTTOM_TO_TOP, "SCAN_DIRECTION_BOTTOM_TO_TOP", "bottom-to-top"}, {SCAN_DIRECTION_RIGHT_TO_LEFT, "SCAN_DIRECTION_RIGHT_TO_LEFT", "right-to-left"}, {0, NULL, NULL}};
		GType scan_direction_type_id;
		scan_direction_type_id = g_enum_register_static ("ScanDirection", values);
		g_once_init_leave (&scan_direction_type_id__volatile, scan_direction_type_id);
	}
	return scan_direction_type_id__volatile;
}


Page*
page_construct (GType object_type,
                gint width,
                gint height,
                gint dpi,
                ScanDirection scan_direction)
{
	Page* self = NULL;
	gboolean _tmp0_ = FALSE;
#line 172 "/home/bob/git/simple-scan/src/page.vala"
	self = (Page*) g_type_create_instance (object_type);
#line 174 "/home/bob/git/simple-scan/src/page.vala"
	if (scan_direction == SCAN_DIRECTION_TOP_TO_BOTTOM) {
#line 174 "/home/bob/git/simple-scan/src/page.vala"
		_tmp0_ = TRUE;
#line 455 "page.c"
	} else {
#line 174 "/home/bob/git/simple-scan/src/page.vala"
		_tmp0_ = scan_direction == SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 459 "page.c"
	}
#line 174 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp0_) {
#line 176 "/home/bob/git/simple-scan/src/page.vala"
		page_set_scan_width (self, width);
#line 177 "/home/bob/git/simple-scan/src/page.vala"
		page_set_scan_height (self, height);
#line 467 "page.c"
	} else {
#line 181 "/home/bob/git/simple-scan/src/page.vala"
		page_set_scan_width (self, height);
#line 182 "/home/bob/git/simple-scan/src/page.vala"
		page_set_scan_height (self, width);
#line 473 "page.c"
	}
#line 184 "/home/bob/git/simple-scan/src/page.vala"
	page_set_dpi (self, dpi);
#line 185 "/home/bob/git/simple-scan/src/page.vala"
	page_set_scan_direction (self, scan_direction);
#line 172 "/home/bob/git/simple-scan/src/page.vala"
	return self;
#line 481 "page.c"
}


Page*
page_new (gint width,
          gint height,
          gint dpi,
          ScanDirection scan_direction)
{
#line 172 "/home/bob/git/simple-scan/src/page.vala"
	return page_construct (TYPE_PAGE, width, height, dpi, scan_direction);
#line 493 "page.c"
}


static guchar*
_vala_array_dup3 (guchar* self,
                  int length)
{
#line 213 "/home/bob/git/simple-scan/src/page.vala"
	return g_memdup (self, length * sizeof (guchar));
#line 503 "page.c"
}


Page*
page_construct_from_data (GType object_type,
                          gint scan_width,
                          gint scan_height,
                          gint rowstride,
                          gint n_channels,
                          gint depth,
                          gint dpi,
                          ScanDirection scan_direction,
                          const gchar* color_profile,
                          guchar* pixels,
                          int pixels_length1,
                          gboolean has_crop,
                          const gchar* crop_name,
                          gint crop_x,
                          gint crop_y,
                          gint crop_width,
                          gint crop_height)
{
	Page* self = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
#line 188 "/home/bob/git/simple-scan/src/page.vala"
	self = (Page*) g_type_create_instance (object_type);
#line 204 "/home/bob/git/simple-scan/src/page.vala"
	page_set_scan_width (self, scan_width);
#line 205 "/home/bob/git/simple-scan/src/page.vala"
	page_set_scan_height (self, scan_height);
#line 206 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->expected_rows = scan_height;
#line 207 "/home/bob/git/simple-scan/src/page.vala"
	page_set_rowstride (self, rowstride);
#line 208 "/home/bob/git/simple-scan/src/page.vala"
	page_set_n_channels (self, n_channels);
#line 209 "/home/bob/git/simple-scan/src/page.vala"
	page_set_depth (self, depth);
#line 210 "/home/bob/git/simple-scan/src/page.vala"
	page_set_dpi (self, dpi);
#line 211 "/home/bob/git/simple-scan/src/page.vala"
	page_set_scan_direction (self, scan_direction);
#line 212 "/home/bob/git/simple-scan/src/page.vala"
	page_set_color_profile (self, color_profile);
#line 213 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = (pixels != NULL) ? _vala_array_dup3 (pixels, pixels_length1) : ((gpointer) pixels);
#line 213 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0__length1 = pixels_length1;
#line 213 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->pixels = (g_free (self->priv->pixels), NULL);
#line 213 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->pixels = _tmp0_;
#line 213 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->pixels_length1 = _tmp0__length1;
#line 213 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_pixels_size_ = self->priv->pixels_length1;
#line 214 "/home/bob/git/simple-scan/src/page.vala"
	page_set_has_data (self, pixels != NULL);
#line 215 "/home/bob/git/simple-scan/src/page.vala"
	page_set_has_crop (self, has_crop);
#line 216 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_name (self, crop_name);
#line 217 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_x (self, crop_x);
#line 218 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_y (self, crop_y);
#line 219 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_width (self, crop_width);
#line 220 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_height (self, crop_height);
#line 188 "/home/bob/git/simple-scan/src/page.vala"
	return self;
#line 577 "page.c"
}


Page*
page_new_from_data (gint scan_width,
                    gint scan_height,
                    gint rowstride,
                    gint n_channels,
                    gint depth,
                    gint dpi,
                    ScanDirection scan_direction,
                    const gchar* color_profile,
                    guchar* pixels,
                    int pixels_length1,
                    gboolean has_crop,
                    const gchar* crop_name,
                    gint crop_x,
                    gint crop_y,
                    gint crop_width,
                    gint crop_height)
{
#line 188 "/home/bob/git/simple-scan/src/page.vala"
	return page_construct_from_data (TYPE_PAGE, scan_width, scan_height, rowstride, n_channels, depth, dpi, scan_direction, color_profile, pixels, pixels_length1, has_crop, crop_name, crop_x, crop_y, crop_width, crop_height);
#line 601 "page.c"
}


void
page_set_page_info (Page* self,
                    ScanPageInfo* info)
{
	gint _tmp0_;
	gdouble _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	guchar* _tmp14_;
	gint _tmp14__length1;
	gint _tmp15_;
#line 223 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 223 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (info != NULL);
#line 225 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = info->height;
#line 225 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->expected_rows = _tmp0_;
#line 226 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1_ = info->dpi;
#line 226 "/home/bob/git/simple-scan/src/page.vala"
	page_set_dpi (self, (gint) _tmp1_);
#line 229 "/home/bob/git/simple-scan/src/page.vala"
	_tmp2_ = info->width;
#line 229 "/home/bob/git/simple-scan/src/page.vala"
	page_set_scan_width (self, _tmp2_);
#line 230 "/home/bob/git/simple-scan/src/page.vala"
	_tmp3_ = info->height;
#line 230 "/home/bob/git/simple-scan/src/page.vala"
	page_set_scan_height (self, _tmp3_);
#line 232 "/home/bob/git/simple-scan/src/page.vala"
	_tmp4_ = self->priv->_scan_height;
#line 232 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp4_ < 0) {
#line 649 "page.c"
		gint _tmp5_;
#line 233 "/home/bob/git/simple-scan/src/page.vala"
		_tmp5_ = self->priv->_scan_width;
#line 233 "/home/bob/git/simple-scan/src/page.vala"
		page_set_scan_height (self, _tmp5_ / 2);
#line 655 "page.c"
	}
#line 234 "/home/bob/git/simple-scan/src/page.vala"
	_tmp6_ = info->depth;
#line 234 "/home/bob/git/simple-scan/src/page.vala"
	page_set_depth (self, _tmp6_);
#line 235 "/home/bob/git/simple-scan/src/page.vala"
	_tmp7_ = info->n_channels;
#line 235 "/home/bob/git/simple-scan/src/page.vala"
	page_set_n_channels (self, _tmp7_);
#line 236 "/home/bob/git/simple-scan/src/page.vala"
	_tmp8_ = self->priv->_scan_width;
#line 236 "/home/bob/git/simple-scan/src/page.vala"
	_tmp9_ = self->priv->_depth;
#line 236 "/home/bob/git/simple-scan/src/page.vala"
	_tmp10_ = self->priv->_n_channels;
#line 236 "/home/bob/git/simple-scan/src/page.vala"
	page_set_rowstride (self, (((_tmp8_ * _tmp9_) * _tmp10_) + 7) / 8);
#line 237 "/home/bob/git/simple-scan/src/page.vala"
	_tmp11_ = self->priv->_scan_height;
#line 237 "/home/bob/git/simple-scan/src/page.vala"
	_tmp12_ = self->priv->_rowstride;
#line 237 "/home/bob/git/simple-scan/src/page.vala"
	_tmp13_ = _tmp11_ * _tmp12_;
#line 237 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp11_ * _tmp12_);
#line 237 "/home/bob/git/simple-scan/src/page.vala"
	(_tmp13_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp13_ - self->priv->pixels_length1)) : NULL;
#line 237 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->pixels_length1 = _tmp13_;
#line 237 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_pixels_size_ = _tmp13_;
#line 238 "/home/bob/git/simple-scan/src/page.vala"
	_tmp14_ = self->priv->pixels;
#line 238 "/home/bob/git/simple-scan/src/page.vala"
	_tmp14__length1 = self->priv->pixels_length1;
#line 238 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (_tmp14_ != NULL);
#line 241 "/home/bob/git/simple-scan/src/page.vala"
	_tmp15_ = self->priv->_depth;
#line 241 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp15_ == 1) {
#line 697 "page.c"
		guchar* _tmp16_;
		gint _tmp16__length1;
		gint _tmp17_;
		gint _tmp18_;
#line 242 "/home/bob/git/simple-scan/src/page.vala"
		_tmp16_ = self->priv->pixels;
#line 242 "/home/bob/git/simple-scan/src/page.vala"
		_tmp16__length1 = self->priv->pixels_length1;
#line 242 "/home/bob/git/simple-scan/src/page.vala"
		_tmp17_ = self->priv->_scan_height;
#line 242 "/home/bob/git/simple-scan/src/page.vala"
		_tmp18_ = self->priv->_rowstride;
#line 242 "/home/bob/git/simple-scan/src/page.vala"
		memset (_tmp16_, 0x00, (gsize) (_tmp17_ * _tmp18_));
#line 712 "page.c"
	} else {
		guchar* _tmp19_;
		gint _tmp19__length1;
		gint _tmp20_;
		gint _tmp21_;
#line 244 "/home/bob/git/simple-scan/src/page.vala"
		_tmp19_ = self->priv->pixels;
#line 244 "/home/bob/git/simple-scan/src/page.vala"
		_tmp19__length1 = self->priv->pixels_length1;
#line 244 "/home/bob/git/simple-scan/src/page.vala"
		_tmp20_ = self->priv->_scan_height;
#line 244 "/home/bob/git/simple-scan/src/page.vala"
		_tmp21_ = self->priv->_rowstride;
#line 244 "/home/bob/git/simple-scan/src/page.vala"
		memset (_tmp19_, 0xFF, (gsize) (_tmp20_ * _tmp21_));
#line 728 "page.c"
	}
#line 246 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_emit (self, page_signals[PAGE_SIZE_CHANGED_SIGNAL], 0);
#line 247 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_emit (self, page_signals[PAGE_PIXELS_CHANGED_SIGNAL], 0);
#line 734 "page.c"
}


void
page_start (Page* self)
{
#line 250 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 252 "/home/bob/git/simple-scan/src/page.vala"
	page_set_is_scanning (self, TRUE);
#line 253 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_emit (self, page_signals[PAGE_SCAN_LINE_CHANGED_SIGNAL], 0);
#line 747 "page.c"
}


static void
page_parse_line (Page* self,
                 ScanLine* line,
                 gint n,
                 gboolean* size_changed)
{
	gboolean _vala_size_changed = FALSE;
	gint line_number = 0;
	gint _tmp0_;
	gint offset = 0;
	gint _tmp11_;
	gint _tmp12_;
	gint line_offset = 0;
	gint _tmp13_;
	gint _tmp26_;
#line 256 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 256 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (line != NULL);
#line 258 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = line->number;
#line 258 "/home/bob/git/simple-scan/src/page.vala"
	line_number = _tmp0_ + n;
#line 261 "/home/bob/git/simple-scan/src/page.vala"
	_vala_size_changed = FALSE;
#line 262 "/home/bob/git/simple-scan/src/page.vala"
	while (TRUE) {
#line 778 "page.c"
		gint _tmp1_;
		gint _tmp2_;
		gint rows = 0;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 262 "/home/bob/git/simple-scan/src/page.vala"
		_tmp1_ = line_number;
#line 262 "/home/bob/git/simple-scan/src/page.vala"
		_tmp2_ = self->priv->_scan_height;
#line 262 "/home/bob/git/simple-scan/src/page.vala"
		if (!(_tmp1_ >= _tmp2_)) {
#line 262 "/home/bob/git/simple-scan/src/page.vala"
			break;
#line 798 "page.c"
		}
#line 265 "/home/bob/git/simple-scan/src/page.vala"
		_tmp3_ = self->priv->_scan_height;
#line 265 "/home/bob/git/simple-scan/src/page.vala"
		rows = _tmp3_;
#line 266 "/home/bob/git/simple-scan/src/page.vala"
		_tmp4_ = rows;
#line 266 "/home/bob/git/simple-scan/src/page.vala"
		_tmp5_ = self->priv->_scan_width;
#line 266 "/home/bob/git/simple-scan/src/page.vala"
		page_set_scan_height (self, _tmp4_ + (_tmp5_ / 2));
#line 267 "/home/bob/git/simple-scan/src/page.vala"
		_tmp6_ = rows;
#line 267 "/home/bob/git/simple-scan/src/page.vala"
		_tmp7_ = self->priv->_scan_height;
#line 267 "/home/bob/git/simple-scan/src/page.vala"
		g_debug ("page.vala:267: Extending image from %d lines to %d lines", _tmp6_, _tmp7_);
#line 268 "/home/bob/git/simple-scan/src/page.vala"
		_tmp8_ = self->priv->_scan_height;
#line 268 "/home/bob/git/simple-scan/src/page.vala"
		_tmp9_ = self->priv->_rowstride;
#line 268 "/home/bob/git/simple-scan/src/page.vala"
		_tmp10_ = _tmp8_ * _tmp9_;
#line 268 "/home/bob/git/simple-scan/src/page.vala"
		self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp8_ * _tmp9_);
#line 268 "/home/bob/git/simple-scan/src/page.vala"
		(_tmp10_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp10_ - self->priv->pixels_length1)) : NULL;
#line 268 "/home/bob/git/simple-scan/src/page.vala"
		self->priv->pixels_length1 = _tmp10_;
#line 268 "/home/bob/git/simple-scan/src/page.vala"
		self->priv->_pixels_size_ = _tmp10_;
#line 270 "/home/bob/git/simple-scan/src/page.vala"
		_vala_size_changed = TRUE;
#line 832 "page.c"
	}
#line 274 "/home/bob/git/simple-scan/src/page.vala"
	_tmp11_ = line_number;
#line 274 "/home/bob/git/simple-scan/src/page.vala"
	_tmp12_ = self->priv->_rowstride;
#line 274 "/home/bob/git/simple-scan/src/page.vala"
	offset = _tmp11_ * _tmp12_;
#line 275 "/home/bob/git/simple-scan/src/page.vala"
	_tmp13_ = line->data_length;
#line 275 "/home/bob/git/simple-scan/src/page.vala"
	line_offset = n * _tmp13_;
#line 844 "page.c"
	{
		gint i = 0;
#line 276 "/home/bob/git/simple-scan/src/page.vala"
		i = 0;
#line 849 "page.c"
		{
			gboolean _tmp14_ = FALSE;
#line 276 "/home/bob/git/simple-scan/src/page.vala"
			_tmp14_ = TRUE;
#line 276 "/home/bob/git/simple-scan/src/page.vala"
			while (TRUE) {
#line 856 "page.c"
				gint _tmp16_;
				gint _tmp17_;
				guchar* _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				gint _tmp20_;
				guchar* _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				gint _tmp23_;
				guchar _tmp24_;
				guchar _tmp25_;
#line 276 "/home/bob/git/simple-scan/src/page.vala"
				if (!_tmp14_) {
#line 871 "page.c"
					gint _tmp15_;
#line 276 "/home/bob/git/simple-scan/src/page.vala"
					_tmp15_ = i;
#line 276 "/home/bob/git/simple-scan/src/page.vala"
					i = _tmp15_ + 1;
#line 877 "page.c"
				}
#line 276 "/home/bob/git/simple-scan/src/page.vala"
				_tmp14_ = FALSE;
#line 276 "/home/bob/git/simple-scan/src/page.vala"
				_tmp16_ = i;
#line 276 "/home/bob/git/simple-scan/src/page.vala"
				_tmp17_ = line->data_length;
#line 276 "/home/bob/git/simple-scan/src/page.vala"
				if (!(_tmp16_ < _tmp17_)) {
#line 276 "/home/bob/git/simple-scan/src/page.vala"
					break;
#line 889 "page.c"
				}
#line 277 "/home/bob/git/simple-scan/src/page.vala"
				_tmp18_ = self->priv->pixels;
#line 277 "/home/bob/git/simple-scan/src/page.vala"
				_tmp18__length1 = self->priv->pixels_length1;
#line 277 "/home/bob/git/simple-scan/src/page.vala"
				_tmp19_ = offset;
#line 277 "/home/bob/git/simple-scan/src/page.vala"
				_tmp20_ = i;
#line 277 "/home/bob/git/simple-scan/src/page.vala"
				_tmp21_ = line->data;
#line 277 "/home/bob/git/simple-scan/src/page.vala"
				_tmp21__length1 = line->data_length1;
#line 277 "/home/bob/git/simple-scan/src/page.vala"
				_tmp22_ = line_offset;
#line 277 "/home/bob/git/simple-scan/src/page.vala"
				_tmp23_ = i;
#line 277 "/home/bob/git/simple-scan/src/page.vala"
				_tmp24_ = _tmp21_[_tmp22_ + _tmp23_];
#line 277 "/home/bob/git/simple-scan/src/page.vala"
				_tmp18_[_tmp19_ + _tmp20_] = _tmp24_;
#line 277 "/home/bob/git/simple-scan/src/page.vala"
				_tmp25_ = _tmp18_[_tmp19_ + _tmp20_];
#line 913 "page.c"
			}
		}
	}
#line 279 "/home/bob/git/simple-scan/src/page.vala"
	_tmp26_ = line_number;
#line 279 "/home/bob/git/simple-scan/src/page.vala"
	page_set_scan_line (self, _tmp26_);
#line 256 "/home/bob/git/simple-scan/src/page.vala"
	if (size_changed) {
#line 256 "/home/bob/git/simple-scan/src/page.vala"
		*size_changed = _vala_size_changed;
#line 925 "page.c"
	}
}


void
page_parse_scan_line (Page* self,
                      ScanLine* line)
{
	gboolean size_has_changed = FALSE;
	gboolean _tmp6_;
#line 282 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 282 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (line != NULL);
#line 284 "/home/bob/git/simple-scan/src/page.vala"
	size_has_changed = FALSE;
#line 942 "page.c"
	{
		gint i = 0;
#line 285 "/home/bob/git/simple-scan/src/page.vala"
		i = 0;
#line 947 "page.c"
		{
			gboolean _tmp0_ = FALSE;
#line 285 "/home/bob/git/simple-scan/src/page.vala"
			_tmp0_ = TRUE;
#line 285 "/home/bob/git/simple-scan/src/page.vala"
			while (TRUE) {
#line 954 "page.c"
				gint _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				gboolean _tmp5_ = FALSE;
#line 285 "/home/bob/git/simple-scan/src/page.vala"
				if (!_tmp0_) {
#line 961 "page.c"
					gint _tmp1_;
#line 285 "/home/bob/git/simple-scan/src/page.vala"
					_tmp1_ = i;
#line 285 "/home/bob/git/simple-scan/src/page.vala"
					i = _tmp1_ + 1;
#line 967 "page.c"
				}
#line 285 "/home/bob/git/simple-scan/src/page.vala"
				_tmp0_ = FALSE;
#line 285 "/home/bob/git/simple-scan/src/page.vala"
				_tmp2_ = i;
#line 285 "/home/bob/git/simple-scan/src/page.vala"
				_tmp3_ = line->n_lines;
#line 285 "/home/bob/git/simple-scan/src/page.vala"
				if (!(_tmp2_ < _tmp3_)) {
#line 285 "/home/bob/git/simple-scan/src/page.vala"
					break;
#line 979 "page.c"
				}
#line 286 "/home/bob/git/simple-scan/src/page.vala"
				_tmp4_ = i;
#line 286 "/home/bob/git/simple-scan/src/page.vala"
				page_parse_line (self, line, _tmp4_, &_tmp5_);
#line 286 "/home/bob/git/simple-scan/src/page.vala"
				size_has_changed = _tmp5_;
#line 987 "page.c"
			}
		}
	}
#line 288 "/home/bob/git/simple-scan/src/page.vala"
	page_set_has_data (self, TRUE);
#line 290 "/home/bob/git/simple-scan/src/page.vala"
	_tmp6_ = size_has_changed;
#line 290 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp6_) {
#line 291 "/home/bob/git/simple-scan/src/page.vala"
		g_signal_emit (self, page_signals[PAGE_SIZE_CHANGED_SIGNAL], 0);
#line 999 "page.c"
	}
#line 292 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_emit (self, page_signals[PAGE_SCAN_LINE_CHANGED_SIGNAL], 0);
#line 293 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_emit (self, page_signals[PAGE_PIXELS_CHANGED_SIGNAL], 0);
#line 1005 "page.c"
}


void
page_finish (Page* self)
{
	gboolean size_has_changed = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp11_;
#line 296 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 298 "/home/bob/git/simple-scan/src/page.vala"
	size_has_changed = FALSE;
#line 301 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1_ = self->priv->expected_rows;
#line 301 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp1_ < 0) {
#line 1024 "page.c"
		gint _tmp2_;
		gint _tmp3_;
#line 302 "/home/bob/git/simple-scan/src/page.vala"
		_tmp2_ = self->priv->_scan_line;
#line 302 "/home/bob/git/simple-scan/src/page.vala"
		_tmp3_ = self->priv->_scan_height;
#line 302 "/home/bob/git/simple-scan/src/page.vala"
		_tmp0_ = _tmp2_ != _tmp3_;
#line 1033 "page.c"
	} else {
#line 301 "/home/bob/git/simple-scan/src/page.vala"
		_tmp0_ = FALSE;
#line 1037 "page.c"
	}
#line 301 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp0_) {
#line 1041 "page.c"
		gint rows = 0;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 304 "/home/bob/git/simple-scan/src/page.vala"
		_tmp4_ = self->priv->_scan_height;
#line 304 "/home/bob/git/simple-scan/src/page.vala"
		rows = _tmp4_;
#line 305 "/home/bob/git/simple-scan/src/page.vala"
		_tmp5_ = self->priv->_scan_line;
#line 305 "/home/bob/git/simple-scan/src/page.vala"
		page_set_scan_height (self, _tmp5_);
#line 306 "/home/bob/git/simple-scan/src/page.vala"
		_tmp6_ = self->priv->_scan_height;
#line 306 "/home/bob/git/simple-scan/src/page.vala"
		_tmp7_ = self->priv->_rowstride;
#line 306 "/home/bob/git/simple-scan/src/page.vala"
		_tmp8_ = _tmp6_ * _tmp7_;
#line 306 "/home/bob/git/simple-scan/src/page.vala"
		self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp6_ * _tmp7_);
#line 306 "/home/bob/git/simple-scan/src/page.vala"
		(_tmp8_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp8_ - self->priv->pixels_length1)) : NULL;
#line 306 "/home/bob/git/simple-scan/src/page.vala"
		self->priv->pixels_length1 = _tmp8_;
#line 306 "/home/bob/git/simple-scan/src/page.vala"
		self->priv->_pixels_size_ = _tmp8_;
#line 307 "/home/bob/git/simple-scan/src/page.vala"
		_tmp9_ = rows;
#line 307 "/home/bob/git/simple-scan/src/page.vala"
		_tmp10_ = self->priv->_scan_height;
#line 307 "/home/bob/git/simple-scan/src/page.vala"
		g_debug ("page.vala:307: Trimming page from %d lines to %d lines", _tmp9_, _tmp10_);
#line 309 "/home/bob/git/simple-scan/src/page.vala"
		size_has_changed = TRUE;
#line 1080 "page.c"
	}
#line 311 "/home/bob/git/simple-scan/src/page.vala"
	page_set_is_scanning (self, FALSE);
#line 313 "/home/bob/git/simple-scan/src/page.vala"
	_tmp11_ = size_has_changed;
#line 313 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp11_) {
#line 314 "/home/bob/git/simple-scan/src/page.vala"
		g_signal_emit (self, page_signals[PAGE_SIZE_CHANGED_SIGNAL], 0);
#line 1090 "page.c"
	}
#line 315 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_emit (self, page_signals[PAGE_SCAN_LINE_CHANGED_SIGNAL], 0);
#line 316 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_emit (self, page_signals[PAGE_SCAN_FINISHED_SIGNAL], 0);
#line 1096 "page.c"
}


void
page_rotate_left (Page* self)
{
	ScanDirection _tmp0_;
	ScanDirection _tmp1_;
#line 319 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 321 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = page_get_scan_direction (self);
#line 321 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1_ = _tmp0_;
#line 321 "/home/bob/git/simple-scan/src/page.vala"
	switch (_tmp1_) {
#line 321 "/home/bob/git/simple-scan/src/page.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 1115 "page.c"
		{
#line 324 "/home/bob/git/simple-scan/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_LEFT_TO_RIGHT);
#line 325 "/home/bob/git/simple-scan/src/page.vala"
			break;
#line 1121 "page.c"
		}
#line 321 "/home/bob/git/simple-scan/src/page.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 1125 "page.c"
		{
#line 327 "/home/bob/git/simple-scan/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_BOTTOM_TO_TOP);
#line 328 "/home/bob/git/simple-scan/src/page.vala"
			break;
#line 1131 "page.c"
		}
#line 321 "/home/bob/git/simple-scan/src/page.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 1135 "page.c"
		{
#line 330 "/home/bob/git/simple-scan/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_RIGHT_TO_LEFT);
#line 331 "/home/bob/git/simple-scan/src/page.vala"
			break;
#line 1141 "page.c"
		}
#line 321 "/home/bob/git/simple-scan/src/page.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 1145 "page.c"
		{
#line 333 "/home/bob/git/simple-scan/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_TOP_TO_BOTTOM);
#line 334 "/home/bob/git/simple-scan/src/page.vala"
			break;
#line 1151 "page.c"
		}
		default:
#line 321 "/home/bob/git/simple-scan/src/page.vala"
		break;
#line 1156 "page.c"
	}
}


void
page_rotate_right (Page* self)
{
	ScanDirection _tmp0_;
	ScanDirection _tmp1_;
#line 338 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 340 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = page_get_scan_direction (self);
#line 340 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1_ = _tmp0_;
#line 340 "/home/bob/git/simple-scan/src/page.vala"
	switch (_tmp1_) {
#line 340 "/home/bob/git/simple-scan/src/page.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 1176 "page.c"
		{
#line 343 "/home/bob/git/simple-scan/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_RIGHT_TO_LEFT);
#line 344 "/home/bob/git/simple-scan/src/page.vala"
			break;
#line 1182 "page.c"
		}
#line 340 "/home/bob/git/simple-scan/src/page.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 1186 "page.c"
		{
#line 346 "/home/bob/git/simple-scan/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_TOP_TO_BOTTOM);
#line 347 "/home/bob/git/simple-scan/src/page.vala"
			break;
#line 1192 "page.c"
		}
#line 340 "/home/bob/git/simple-scan/src/page.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 1196 "page.c"
		{
#line 349 "/home/bob/git/simple-scan/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_LEFT_TO_RIGHT);
#line 350 "/home/bob/git/simple-scan/src/page.vala"
			break;
#line 1202 "page.c"
		}
#line 340 "/home/bob/git/simple-scan/src/page.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 1206 "page.c"
		{
#line 352 "/home/bob/git/simple-scan/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_BOTTOM_TO_TOP);
#line 353 "/home/bob/git/simple-scan/src/page.vala"
			break;
#line 1212 "page.c"
		}
		default:
#line 340 "/home/bob/git/simple-scan/src/page.vala"
		break;
#line 1217 "page.c"
	}
}


void
page_set_no_crop (Page* self)
{
	gboolean _tmp0_;
#line 357 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 359 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_has_crop;
#line 359 "/home/bob/git/simple-scan/src/page.vala"
	if (!_tmp0_) {
#line 360 "/home/bob/git/simple-scan/src/page.vala"
		return;
#line 1234 "page.c"
	}
#line 361 "/home/bob/git/simple-scan/src/page.vala"
	page_set_has_crop (self, FALSE);
#line 362 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_name (self, NULL);
#line 363 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_x (self, 0);
#line 364 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_y (self, 0);
#line 365 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_width (self, 0);
#line 366 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_height (self, 0);
#line 367 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_emit (self, page_signals[PAGE_CROP_CHANGED_SIGNAL], 0);
#line 1250 "page.c"
}


void
page_set_custom_crop (Page* self,
                      gint width,
                      gint height)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
#line 370 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 372 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (width >= 1);
#line 373 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (height >= 1);
#line 375 "/home/bob/git/simple-scan/src/page.vala"
	_tmp3_ = self->priv->_crop_name;
#line 375 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp3_ == NULL) {
#line 1273 "page.c"
		gboolean _tmp4_;
#line 375 "/home/bob/git/simple-scan/src/page.vala"
		_tmp4_ = self->priv->_has_crop;
#line 375 "/home/bob/git/simple-scan/src/page.vala"
		_tmp2_ = _tmp4_;
#line 1279 "page.c"
	} else {
#line 375 "/home/bob/git/simple-scan/src/page.vala"
		_tmp2_ = FALSE;
#line 1283 "page.c"
	}
#line 375 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp2_) {
#line 1287 "page.c"
		gint _tmp5_;
#line 375 "/home/bob/git/simple-scan/src/page.vala"
		_tmp5_ = self->priv->_crop_width;
#line 375 "/home/bob/git/simple-scan/src/page.vala"
		_tmp1_ = _tmp5_ == width;
#line 1293 "page.c"
	} else {
#line 375 "/home/bob/git/simple-scan/src/page.vala"
		_tmp1_ = FALSE;
#line 1297 "page.c"
	}
#line 375 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp1_) {
#line 1301 "page.c"
		gint _tmp6_;
#line 375 "/home/bob/git/simple-scan/src/page.vala"
		_tmp6_ = self->priv->_crop_height;
#line 375 "/home/bob/git/simple-scan/src/page.vala"
		_tmp0_ = _tmp6_ == height;
#line 1307 "page.c"
	} else {
#line 375 "/home/bob/git/simple-scan/src/page.vala"
		_tmp0_ = FALSE;
#line 1311 "page.c"
	}
#line 375 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp0_) {
#line 376 "/home/bob/git/simple-scan/src/page.vala"
		return;
#line 1317 "page.c"
	}
#line 377 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_name (self, NULL);
#line 378 "/home/bob/git/simple-scan/src/page.vala"
	page_set_has_crop (self, TRUE);
#line 380 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_width (self, width);
#line 381 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_height (self, height);
#line 394 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_emit (self, page_signals[PAGE_CROP_CHANGED_SIGNAL], 0);
#line 1329 "page.c"
}


void
page_set_named_crop (Page* self,
                     const gchar* name)
{
	gdouble w = 0.0;
	gdouble h = 0.0;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 400 "/home/bob/git/simple-scan/src/page.vala"
	static GQuark _tmp1_label0 = 0;
#line 400 "/home/bob/git/simple-scan/src/page.vala"
	static GQuark _tmp1_label1 = 0;
#line 400 "/home/bob/git/simple-scan/src/page.vala"
	static GQuark _tmp1_label2 = 0;
#line 400 "/home/bob/git/simple-scan/src/page.vala"
	static GQuark _tmp1_label3 = 0;
#line 400 "/home/bob/git/simple-scan/src/page.vala"
	static GQuark _tmp1_label4 = 0;
#line 400 "/home/bob/git/simple-scan/src/page.vala"
	static GQuark _tmp1_label5 = 0;
#line 1353 "page.c"
	gint pw = 0;
	gint _tmp3_;
	gint _tmp4_;
	gint ph = 0;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gdouble _tmp12_;
	gint _tmp13_;
	gdouble _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp20_;
	gint _tmp21_;
#line 397 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 397 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (name != NULL);
#line 400 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = name;
#line 400 "/home/bob/git/simple-scan/src/page.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 400 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("A4")))) {
#line 400 "/home/bob/git/simple-scan/src/page.vala"
		switch (0) {
#line 1382 "page.c"
			default:
			{
#line 403 "/home/bob/git/simple-scan/src/page.vala"
				w = 8.3;
#line 404 "/home/bob/git/simple-scan/src/page.vala"
				h = 11.7;
#line 405 "/home/bob/git/simple-scan/src/page.vala"
				break;
#line 1391 "page.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("A5")))) {
#line 400 "/home/bob/git/simple-scan/src/page.vala"
		switch (0) {
#line 1397 "page.c"
			default:
			{
#line 407 "/home/bob/git/simple-scan/src/page.vala"
				w = 5.8;
#line 408 "/home/bob/git/simple-scan/src/page.vala"
				h = 8.3;
#line 409 "/home/bob/git/simple-scan/src/page.vala"
				break;
#line 1406 "page.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("A6")))) {
#line 400 "/home/bob/git/simple-scan/src/page.vala"
		switch (0) {
#line 1412 "page.c"
			default:
			{
#line 411 "/home/bob/git/simple-scan/src/page.vala"
				w = 4.1;
#line 412 "/home/bob/git/simple-scan/src/page.vala"
				h = 5.8;
#line 413 "/home/bob/git/simple-scan/src/page.vala"
				break;
#line 1421 "page.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("letter")))) {
#line 400 "/home/bob/git/simple-scan/src/page.vala"
		switch (0) {
#line 1427 "page.c"
			default:
			{
#line 415 "/home/bob/git/simple-scan/src/page.vala"
				w = 8.5;
#line 416 "/home/bob/git/simple-scan/src/page.vala"
				h = (gdouble) 11;
#line 417 "/home/bob/git/simple-scan/src/page.vala"
				break;
#line 1436 "page.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("legal")))) {
#line 400 "/home/bob/git/simple-scan/src/page.vala"
		switch (0) {
#line 1442 "page.c"
			default:
			{
#line 419 "/home/bob/git/simple-scan/src/page.vala"
				w = 8.5;
#line 420 "/home/bob/git/simple-scan/src/page.vala"
				h = (gdouble) 14;
#line 421 "/home/bob/git/simple-scan/src/page.vala"
				break;
#line 1451 "page.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("4x6")))) {
#line 400 "/home/bob/git/simple-scan/src/page.vala"
		switch (0) {
#line 1457 "page.c"
			default:
			{
#line 423 "/home/bob/git/simple-scan/src/page.vala"
				w = (gdouble) 4;
#line 424 "/home/bob/git/simple-scan/src/page.vala"
				h = (gdouble) 6;
#line 425 "/home/bob/git/simple-scan/src/page.vala"
				break;
#line 1466 "page.c"
			}
		}
	} else {
#line 400 "/home/bob/git/simple-scan/src/page.vala"
		switch (0) {
#line 1472 "page.c"
			default:
			{
#line 427 "/home/bob/git/simple-scan/src/page.vala"
				g_warning ("page.vala:427: Unknown paper size '%s'", name);
#line 428 "/home/bob/git/simple-scan/src/page.vala"
				return;
#line 1479 "page.c"
			}
		}
	}
#line 431 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_name (self, name);
#line 432 "/home/bob/git/simple-scan/src/page.vala"
	page_set_has_crop (self, TRUE);
#line 434 "/home/bob/git/simple-scan/src/page.vala"
	_tmp3_ = page_get_width (self);
#line 434 "/home/bob/git/simple-scan/src/page.vala"
	_tmp4_ = _tmp3_;
#line 434 "/home/bob/git/simple-scan/src/page.vala"
	pw = _tmp4_;
#line 435 "/home/bob/git/simple-scan/src/page.vala"
	_tmp5_ = page_get_height (self);
#line 435 "/home/bob/git/simple-scan/src/page.vala"
	_tmp6_ = _tmp5_;
#line 435 "/home/bob/git/simple-scan/src/page.vala"
	ph = _tmp6_;
#line 438 "/home/bob/git/simple-scan/src/page.vala"
	_tmp7_ = pw;
#line 438 "/home/bob/git/simple-scan/src/page.vala"
	_tmp8_ = ph;
#line 438 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp7_ > _tmp8_) {
#line 1505 "page.c"
		gdouble t = 0.0;
		gdouble _tmp9_;
		gdouble _tmp10_;
		gdouble _tmp11_;
#line 440 "/home/bob/git/simple-scan/src/page.vala"
		_tmp9_ = w;
#line 440 "/home/bob/git/simple-scan/src/page.vala"
		t = _tmp9_;
#line 441 "/home/bob/git/simple-scan/src/page.vala"
		_tmp10_ = h;
#line 441 "/home/bob/git/simple-scan/src/page.vala"
		w = _tmp10_;
#line 442 "/home/bob/git/simple-scan/src/page.vala"
		_tmp11_ = t;
#line 442 "/home/bob/git/simple-scan/src/page.vala"
		h = _tmp11_;
#line 1522 "page.c"
	}
#line 446 "/home/bob/git/simple-scan/src/page.vala"
	_tmp12_ = w;
#line 446 "/home/bob/git/simple-scan/src/page.vala"
	_tmp13_ = self->priv->_dpi;
#line 446 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_width (self, (gint) ((_tmp12_ * _tmp13_) + 0.5));
#line 447 "/home/bob/git/simple-scan/src/page.vala"
	_tmp14_ = h;
#line 447 "/home/bob/git/simple-scan/src/page.vala"
	_tmp15_ = self->priv->_dpi;
#line 447 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_height (self, (gint) ((_tmp14_ * _tmp15_) + 0.5));
#line 449 "/home/bob/git/simple-scan/src/page.vala"
	_tmp16_ = self->priv->_crop_width;
#line 449 "/home/bob/git/simple-scan/src/page.vala"
	_tmp17_ = pw;
#line 449 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp16_ < _tmp17_) {
#line 1542 "page.c"
		gint _tmp18_;
		gint _tmp19_;
#line 450 "/home/bob/git/simple-scan/src/page.vala"
		_tmp18_ = pw;
#line 450 "/home/bob/git/simple-scan/src/page.vala"
		_tmp19_ = self->priv->_crop_width;
#line 450 "/home/bob/git/simple-scan/src/page.vala"
		page_set_crop_x (self, (_tmp18_ - _tmp19_) / 2);
#line 1551 "page.c"
	} else {
#line 452 "/home/bob/git/simple-scan/src/page.vala"
		page_set_crop_x (self, 0);
#line 1555 "page.c"
	}
#line 453 "/home/bob/git/simple-scan/src/page.vala"
	_tmp20_ = self->priv->_crop_height;
#line 453 "/home/bob/git/simple-scan/src/page.vala"
	_tmp21_ = ph;
#line 453 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp20_ < _tmp21_) {
#line 1563 "page.c"
		gint _tmp22_;
		gint _tmp23_;
#line 454 "/home/bob/git/simple-scan/src/page.vala"
		_tmp22_ = ph;
#line 454 "/home/bob/git/simple-scan/src/page.vala"
		_tmp23_ = self->priv->_crop_height;
#line 454 "/home/bob/git/simple-scan/src/page.vala"
		page_set_crop_y (self, (_tmp22_ - _tmp23_) / 2);
#line 1572 "page.c"
	} else {
#line 456 "/home/bob/git/simple-scan/src/page.vala"
		page_set_crop_y (self, 0);
#line 1576 "page.c"
	}
#line 457 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_emit (self, page_signals[PAGE_CROP_CHANGED_SIGNAL], 0);
#line 1580 "page.c"
}


void
page_move_crop (Page* self,
                gint x,
                gint y)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
#line 460 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 462 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (x >= 0);
#line 463 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (y >= 0);
#line 464 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = page_get_width (self);
#line 464 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1_ = _tmp0_;
#line 464 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (x < _tmp1_);
#line 465 "/home/bob/git/simple-scan/src/page.vala"
	_tmp2_ = page_get_height (self);
#line 465 "/home/bob/git/simple-scan/src/page.vala"
	_tmp3_ = _tmp2_;
#line 465 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (y < _tmp3_);
#line 467 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_x (self, x);
#line 468 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_y (self, y);
#line 469 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_emit (self, page_signals[PAGE_CROP_CHANGED_SIGNAL], 0);
#line 1617 "page.c"
}


void
page_rotate_crop (Page* self)
{
	gboolean _tmp0_;
	gint t = 0;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp4_;
#line 472 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 474 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_has_crop;
#line 474 "/home/bob/git/simple-scan/src/page.vala"
	if (!_tmp0_) {
#line 475 "/home/bob/git/simple-scan/src/page.vala"
		return;
#line 1638 "page.c"
	}
#line 477 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1_ = self->priv->_crop_width;
#line 477 "/home/bob/git/simple-scan/src/page.vala"
	t = _tmp1_;
#line 478 "/home/bob/git/simple-scan/src/page.vala"
	_tmp2_ = self->priv->_crop_height;
#line 478 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_width (self, _tmp2_);
#line 479 "/home/bob/git/simple-scan/src/page.vala"
	_tmp3_ = t;
#line 479 "/home/bob/git/simple-scan/src/page.vala"
	page_set_crop_height (self, _tmp3_);
#line 482 "/home/bob/git/simple-scan/src/page.vala"
	_tmp4_ = self->priv->_crop_name;
#line 482 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp4_ == NULL) {
#line 1656 "page.c"
		gint w = 0;
		gint _tmp5_;
		gint _tmp6_;
		gint h = 0;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp14_;
		gint _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _tmp21_;
#line 484 "/home/bob/git/simple-scan/src/page.vala"
		_tmp5_ = page_get_width (self);
#line 484 "/home/bob/git/simple-scan/src/page.vala"
		_tmp6_ = _tmp5_;
#line 484 "/home/bob/git/simple-scan/src/page.vala"
		w = _tmp6_;
#line 485 "/home/bob/git/simple-scan/src/page.vala"
		_tmp7_ = page_get_height (self);
#line 485 "/home/bob/git/simple-scan/src/page.vala"
		_tmp8_ = _tmp7_;
#line 485 "/home/bob/git/simple-scan/src/page.vala"
		h = _tmp8_;
#line 487 "/home/bob/git/simple-scan/src/page.vala"
		_tmp9_ = self->priv->_crop_x;
#line 487 "/home/bob/git/simple-scan/src/page.vala"
		_tmp10_ = self->priv->_crop_width;
#line 487 "/home/bob/git/simple-scan/src/page.vala"
		_tmp11_ = w;
#line 487 "/home/bob/git/simple-scan/src/page.vala"
		if ((_tmp9_ + _tmp10_) > _tmp11_) {
#line 1691 "page.c"
			gint _tmp12_;
			gint _tmp13_;
#line 488 "/home/bob/git/simple-scan/src/page.vala"
			_tmp12_ = w;
#line 488 "/home/bob/git/simple-scan/src/page.vala"
			_tmp13_ = self->priv->_crop_width;
#line 488 "/home/bob/git/simple-scan/src/page.vala"
			page_set_crop_x (self, _tmp12_ - _tmp13_);
#line 1700 "page.c"
		}
#line 489 "/home/bob/git/simple-scan/src/page.vala"
		_tmp14_ = self->priv->_crop_x;
#line 489 "/home/bob/git/simple-scan/src/page.vala"
		if (_tmp14_ < 0) {
#line 1706 "page.c"
			gint _tmp15_;
#line 491 "/home/bob/git/simple-scan/src/page.vala"
			page_set_crop_x (self, 0);
#line 492 "/home/bob/git/simple-scan/src/page.vala"
			_tmp15_ = w;
#line 492 "/home/bob/git/simple-scan/src/page.vala"
			page_set_crop_width (self, _tmp15_);
#line 1714 "page.c"
		}
#line 494 "/home/bob/git/simple-scan/src/page.vala"
		_tmp16_ = self->priv->_crop_y;
#line 494 "/home/bob/git/simple-scan/src/page.vala"
		_tmp17_ = self->priv->_crop_height;
#line 494 "/home/bob/git/simple-scan/src/page.vala"
		_tmp18_ = h;
#line 494 "/home/bob/git/simple-scan/src/page.vala"
		if ((_tmp16_ + _tmp17_) > _tmp18_) {
#line 1724 "page.c"
			gint _tmp19_;
			gint _tmp20_;
#line 495 "/home/bob/git/simple-scan/src/page.vala"
			_tmp19_ = h;
#line 495 "/home/bob/git/simple-scan/src/page.vala"
			_tmp20_ = self->priv->_crop_height;
#line 495 "/home/bob/git/simple-scan/src/page.vala"
			page_set_crop_y (self, _tmp19_ - _tmp20_);
#line 1733 "page.c"
		}
#line 496 "/home/bob/git/simple-scan/src/page.vala"
		_tmp21_ = self->priv->_crop_y;
#line 496 "/home/bob/git/simple-scan/src/page.vala"
		if (_tmp21_ < 0) {
#line 1739 "page.c"
			gint _tmp22_;
#line 498 "/home/bob/git/simple-scan/src/page.vala"
			page_set_crop_y (self, 0);
#line 499 "/home/bob/git/simple-scan/src/page.vala"
			_tmp22_ = h;
#line 499 "/home/bob/git/simple-scan/src/page.vala"
			page_set_crop_height (self, _tmp22_);
#line 1747 "page.c"
		}
	}
#line 503 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_emit (self, page_signals[PAGE_CROP_CHANGED_SIGNAL], 0);
#line 1752 "page.c"
}


guchar*
page_get_pixels (Page* self,
                 int* result_length1)
{
	guchar* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	guchar* _tmp1_;
	gint _tmp1__length1;
#line 506 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 508 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->pixels;
#line 508 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0__length1 = self->priv->pixels_length1;
#line 508 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1_ = _tmp0_;
#line 508 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1__length1 = _tmp0__length1;
#line 508 "/home/bob/git/simple-scan/src/page.vala"
	if (result_length1) {
#line 508 "/home/bob/git/simple-scan/src/page.vala"
		*result_length1 = _tmp1__length1;
#line 1779 "page.c"
	}
#line 508 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp1_;
#line 508 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 1785 "page.c"
}


static guchar
page_get_sample (Page* self,
                 guchar* pixels,
                 int pixels_length1,
                 gint offset,
                 gint x,
                 gint depth,
                 gint n_channels,
                 gint channel)
{
	guchar result = '\0';
#line 512 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 515 "/home/bob/git/simple-scan/src/page.vala"
	result = (guchar) 0xFF;
#line 515 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 1806 "page.c"
}


static void
page_get_pixel (Page* self,
                gint x,
                gint y,
                guchar* pixel,
                int pixel_length1,
                gint offset)
{
	ScanDirection _tmp0_;
	ScanDirection _tmp1_;
	gint line_offset = 0;
	gint _tmp8_;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
	guchar* _tmp61_;
	gint _tmp61__length1;
	gint _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	guchar _tmp65_;
	guchar* _tmp66_;
	gint _tmp66__length1;
	gint _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	guchar _tmp70_;
	guchar* _tmp71_;
	gint _tmp71__length1;
	gint _tmp72_;
	gint _tmp73_;
	gint _tmp74_;
	guchar _tmp75_;
#line 519 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 521 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = page_get_scan_direction (self);
#line 521 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1_ = _tmp0_;
#line 521 "/home/bob/git/simple-scan/src/page.vala"
	switch (_tmp1_) {
#line 521 "/home/bob/git/simple-scan/src/page.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 1852 "page.c"
		{
#line 524 "/home/bob/git/simple-scan/src/page.vala"
			break;
#line 1856 "page.c"
		}
#line 521 "/home/bob/git/simple-scan/src/page.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 1860 "page.c"
		{
			gint _tmp2_;
			gint _tmp3_;
#line 526 "/home/bob/git/simple-scan/src/page.vala"
			_tmp2_ = self->priv->_scan_width;
#line 526 "/home/bob/git/simple-scan/src/page.vala"
			x = (_tmp2_ - x) - 1;
#line 527 "/home/bob/git/simple-scan/src/page.vala"
			_tmp3_ = self->priv->_scan_height;
#line 527 "/home/bob/git/simple-scan/src/page.vala"
			y = (_tmp3_ - y) - 1;
#line 528 "/home/bob/git/simple-scan/src/page.vala"
			break;
#line 1874 "page.c"
		}
#line 521 "/home/bob/git/simple-scan/src/page.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 1878 "page.c"
		{
			gint t = 0;
			gint _tmp4_;
			gint _tmp5_;
#line 530 "/home/bob/git/simple-scan/src/page.vala"
			t = x;
#line 531 "/home/bob/git/simple-scan/src/page.vala"
			_tmp4_ = self->priv->_scan_width;
#line 531 "/home/bob/git/simple-scan/src/page.vala"
			x = (_tmp4_ - y) - 1;
#line 532 "/home/bob/git/simple-scan/src/page.vala"
			_tmp5_ = t;
#line 532 "/home/bob/git/simple-scan/src/page.vala"
			y = _tmp5_;
#line 533 "/home/bob/git/simple-scan/src/page.vala"
			break;
#line 1895 "page.c"
		}
#line 521 "/home/bob/git/simple-scan/src/page.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 1899 "page.c"
		{
			gint t = 0;
			gint _tmp6_;
			gint _tmp7_;
#line 535 "/home/bob/git/simple-scan/src/page.vala"
			t = x;
#line 536 "/home/bob/git/simple-scan/src/page.vala"
			x = y;
#line 537 "/home/bob/git/simple-scan/src/page.vala"
			_tmp6_ = self->priv->_scan_height;
#line 537 "/home/bob/git/simple-scan/src/page.vala"
			_tmp7_ = t;
#line 537 "/home/bob/git/simple-scan/src/page.vala"
			y = (_tmp6_ - _tmp7_) - 1;
#line 538 "/home/bob/git/simple-scan/src/page.vala"
			break;
#line 1916 "page.c"
		}
		default:
#line 521 "/home/bob/git/simple-scan/src/page.vala"
		break;
#line 1921 "page.c"
	}
#line 541 "/home/bob/git/simple-scan/src/page.vala"
	_tmp8_ = self->priv->_rowstride;
#line 541 "/home/bob/git/simple-scan/src/page.vala"
	line_offset = _tmp8_ * y;
#line 544 "/home/bob/git/simple-scan/src/page.vala"
	_tmp10_ = self->priv->_depth;
#line 544 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp10_ == 8) {
#line 1931 "page.c"
		gint _tmp11_;
#line 544 "/home/bob/git/simple-scan/src/page.vala"
		_tmp11_ = self->priv->_n_channels;
#line 544 "/home/bob/git/simple-scan/src/page.vala"
		_tmp9_ = _tmp11_ == 3;
#line 1937 "page.c"
	} else {
#line 544 "/home/bob/git/simple-scan/src/page.vala"
		_tmp9_ = FALSE;
#line 1941 "page.c"
	}
#line 544 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp9_) {
#line 1945 "page.c"
		gint o = 0;
		gint _tmp12_;
		gint _tmp13_;
		guchar* _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_;
		guchar _tmp16_;
		guchar _tmp17_;
		guchar* _tmp18_;
		gint _tmp18__length1;
		gint _tmp19_;
		guchar _tmp20_;
		guchar _tmp21_;
		guchar* _tmp22_;
		gint _tmp22__length1;
		gint _tmp23_;
		guchar _tmp24_;
		guchar _tmp25_;
#line 546 "/home/bob/git/simple-scan/src/page.vala"
		_tmp12_ = line_offset;
#line 546 "/home/bob/git/simple-scan/src/page.vala"
		_tmp13_ = self->priv->_n_channels;
#line 546 "/home/bob/git/simple-scan/src/page.vala"
		o = _tmp12_ + (x * _tmp13_);
#line 547 "/home/bob/git/simple-scan/src/page.vala"
		_tmp14_ = self->priv->pixels;
#line 547 "/home/bob/git/simple-scan/src/page.vala"
		_tmp14__length1 = self->priv->pixels_length1;
#line 547 "/home/bob/git/simple-scan/src/page.vala"
		_tmp15_ = o;
#line 547 "/home/bob/git/simple-scan/src/page.vala"
		_tmp16_ = _tmp14_[_tmp15_];
#line 547 "/home/bob/git/simple-scan/src/page.vala"
		pixel[offset + 0] = _tmp16_;
#line 547 "/home/bob/git/simple-scan/src/page.vala"
		_tmp17_ = pixel[offset + 0];
#line 548 "/home/bob/git/simple-scan/src/page.vala"
		_tmp18_ = self->priv->pixels;
#line 548 "/home/bob/git/simple-scan/src/page.vala"
		_tmp18__length1 = self->priv->pixels_length1;
#line 548 "/home/bob/git/simple-scan/src/page.vala"
		_tmp19_ = o;
#line 548 "/home/bob/git/simple-scan/src/page.vala"
		_tmp20_ = _tmp18_[_tmp19_ + 1];
#line 548 "/home/bob/git/simple-scan/src/page.vala"
		pixel[offset + 1] = _tmp20_;
#line 548 "/home/bob/git/simple-scan/src/page.vala"
		_tmp21_ = pixel[offset + 1];
#line 549 "/home/bob/git/simple-scan/src/page.vala"
		_tmp22_ = self->priv->pixels;
#line 549 "/home/bob/git/simple-scan/src/page.vala"
		_tmp22__length1 = self->priv->pixels_length1;
#line 549 "/home/bob/git/simple-scan/src/page.vala"
		_tmp23_ = o;
#line 549 "/home/bob/git/simple-scan/src/page.vala"
		_tmp24_ = _tmp22_[_tmp23_ + 2];
#line 549 "/home/bob/git/simple-scan/src/page.vala"
		pixel[offset + 2] = _tmp24_;
#line 549 "/home/bob/git/simple-scan/src/page.vala"
		_tmp25_ = pixel[offset + 2];
#line 550 "/home/bob/git/simple-scan/src/page.vala"
		return;
#line 2008 "page.c"
	} else {
		gboolean _tmp26_ = FALSE;
		gint _tmp27_;
#line 552 "/home/bob/git/simple-scan/src/page.vala"
		_tmp27_ = self->priv->_depth;
#line 552 "/home/bob/git/simple-scan/src/page.vala"
		if (_tmp27_ == 8) {
#line 2016 "page.c"
			gint _tmp28_;
#line 552 "/home/bob/git/simple-scan/src/page.vala"
			_tmp28_ = self->priv->_n_channels;
#line 552 "/home/bob/git/simple-scan/src/page.vala"
			_tmp26_ = _tmp28_ == 1;
#line 2022 "page.c"
		} else {
#line 552 "/home/bob/git/simple-scan/src/page.vala"
			_tmp26_ = FALSE;
#line 2026 "page.c"
		}
#line 552 "/home/bob/git/simple-scan/src/page.vala"
		if (_tmp26_) {
#line 2030 "page.c"
			guchar p = '\0';
			guchar* _tmp29_;
			gint _tmp29__length1;
			gint _tmp30_;
			guchar _tmp31_;
			guchar _tmp32_;
			guchar _tmp33_;
			guchar _tmp34_;
			guchar _tmp35_;
#line 554 "/home/bob/git/simple-scan/src/page.vala"
			_tmp29_ = self->priv->pixels;
#line 554 "/home/bob/git/simple-scan/src/page.vala"
			_tmp29__length1 = self->priv->pixels_length1;
#line 554 "/home/bob/git/simple-scan/src/page.vala"
			_tmp30_ = line_offset;
#line 554 "/home/bob/git/simple-scan/src/page.vala"
			_tmp31_ = _tmp29_[_tmp30_ + x];
#line 554 "/home/bob/git/simple-scan/src/page.vala"
			p = _tmp31_;
#line 555 "/home/bob/git/simple-scan/src/page.vala"
			_tmp32_ = p;
#line 555 "/home/bob/git/simple-scan/src/page.vala"
			pixel[offset + 2] = _tmp32_;
#line 555 "/home/bob/git/simple-scan/src/page.vala"
			_tmp33_ = pixel[offset + 2];
#line 555 "/home/bob/git/simple-scan/src/page.vala"
			pixel[offset + 1] = _tmp33_;
#line 555 "/home/bob/git/simple-scan/src/page.vala"
			_tmp34_ = pixel[offset + 1];
#line 555 "/home/bob/git/simple-scan/src/page.vala"
			pixel[offset + 0] = _tmp34_;
#line 555 "/home/bob/git/simple-scan/src/page.vala"
			_tmp35_ = pixel[offset + 0];
#line 556 "/home/bob/git/simple-scan/src/page.vala"
			return;
#line 2066 "page.c"
		} else {
			gboolean _tmp36_ = FALSE;
			gint _tmp37_;
#line 560 "/home/bob/git/simple-scan/src/page.vala"
			_tmp37_ = self->priv->_depth;
#line 560 "/home/bob/git/simple-scan/src/page.vala"
			if (_tmp37_ == 1) {
#line 2074 "page.c"
				gint _tmp38_;
#line 560 "/home/bob/git/simple-scan/src/page.vala"
				_tmp38_ = self->priv->_n_channels;
#line 560 "/home/bob/git/simple-scan/src/page.vala"
				_tmp36_ = _tmp38_ == 1;
#line 2080 "page.c"
			} else {
#line 560 "/home/bob/git/simple-scan/src/page.vala"
				_tmp36_ = FALSE;
#line 2084 "page.c"
			}
#line 560 "/home/bob/git/simple-scan/src/page.vala"
			if (_tmp36_) {
#line 2088 "page.c"
				guchar p = '\0';
				guchar* _tmp39_;
				gint _tmp39__length1;
				gint _tmp40_;
				guchar _tmp41_;
				gint _tmp42_ = 0;
				guchar _tmp43_;
				guchar _tmp44_;
				guchar _tmp45_;
				guchar _tmp46_;
#line 562 "/home/bob/git/simple-scan/src/page.vala"
				_tmp39_ = self->priv->pixels;
#line 562 "/home/bob/git/simple-scan/src/page.vala"
				_tmp39__length1 = self->priv->pixels_length1;
#line 562 "/home/bob/git/simple-scan/src/page.vala"
				_tmp40_ = line_offset;
#line 562 "/home/bob/git/simple-scan/src/page.vala"
				_tmp41_ = _tmp39_[_tmp40_ + (x / 8)];
#line 562 "/home/bob/git/simple-scan/src/page.vala"
				p = _tmp41_;
#line 563 "/home/bob/git/simple-scan/src/page.vala"
				_tmp43_ = p;
#line 563 "/home/bob/git/simple-scan/src/page.vala"
				if (((gint) (_tmp43_ & (0x80 >> (x % 8)))) != 0) {
#line 563 "/home/bob/git/simple-scan/src/page.vala"
					_tmp42_ = 0x00;
#line 2115 "page.c"
				} else {
#line 563 "/home/bob/git/simple-scan/src/page.vala"
					_tmp42_ = 0xFF;
#line 2119 "page.c"
				}
#line 563 "/home/bob/git/simple-scan/src/page.vala"
				pixel[offset + 2] = (guchar) _tmp42_;
#line 563 "/home/bob/git/simple-scan/src/page.vala"
				_tmp44_ = pixel[offset + 2];
#line 563 "/home/bob/git/simple-scan/src/page.vala"
				pixel[offset + 1] = _tmp44_;
#line 563 "/home/bob/git/simple-scan/src/page.vala"
				_tmp45_ = pixel[offset + 1];
#line 563 "/home/bob/git/simple-scan/src/page.vala"
				pixel[offset + 0] = _tmp45_;
#line 563 "/home/bob/git/simple-scan/src/page.vala"
				_tmp46_ = pixel[offset + 0];
#line 564 "/home/bob/git/simple-scan/src/page.vala"
				return;
#line 2135 "page.c"
			} else {
				gboolean _tmp47_ = FALSE;
				gint _tmp48_;
#line 568 "/home/bob/git/simple-scan/src/page.vala"
				_tmp48_ = self->priv->_depth;
#line 568 "/home/bob/git/simple-scan/src/page.vala"
				if (_tmp48_ == 2) {
#line 2143 "page.c"
					gint _tmp49_;
#line 568 "/home/bob/git/simple-scan/src/page.vala"
					_tmp49_ = self->priv->_n_channels;
#line 568 "/home/bob/git/simple-scan/src/page.vala"
					_tmp47_ = _tmp49_ == 1;
#line 2149 "page.c"
				} else {
#line 568 "/home/bob/git/simple-scan/src/page.vala"
					_tmp47_ = FALSE;
#line 2153 "page.c"
				}
#line 568 "/home/bob/git/simple-scan/src/page.vala"
				if (_tmp47_) {
#line 2157 "page.c"
					gint block_shift[4] = {0};
					gint _tmp50_[4] = {0};
					guchar p = '\0';
					guchar* _tmp51_;
					gint _tmp51__length1;
					gint _tmp52_;
					guchar _tmp53_;
					gint sample = 0;
					guchar _tmp54_;
					gint _tmp55_;
					gint _tmp56_;
					gint _tmp57_;
					guchar _tmp58_;
					guchar _tmp59_;
					guchar _tmp60_;
#line 570 "/home/bob/git/simple-scan/src/page.vala"
					_tmp50_[0] = 6;
#line 570 "/home/bob/git/simple-scan/src/page.vala"
					_tmp50_[1] = 4;
#line 570 "/home/bob/git/simple-scan/src/page.vala"
					_tmp50_[2] = 2;
#line 570 "/home/bob/git/simple-scan/src/page.vala"
					_tmp50_[3] = 0;
#line 570 "/home/bob/git/simple-scan/src/page.vala"
					memcpy (block_shift, _tmp50_, 4 * sizeof (gint));
#line 572 "/home/bob/git/simple-scan/src/page.vala"
					_tmp51_ = self->priv->pixels;
#line 572 "/home/bob/git/simple-scan/src/page.vala"
					_tmp51__length1 = self->priv->pixels_length1;
#line 572 "/home/bob/git/simple-scan/src/page.vala"
					_tmp52_ = line_offset;
#line 572 "/home/bob/git/simple-scan/src/page.vala"
					_tmp53_ = _tmp51_[_tmp52_ + (x / 4)];
#line 572 "/home/bob/git/simple-scan/src/page.vala"
					p = _tmp53_;
#line 573 "/home/bob/git/simple-scan/src/page.vala"
					_tmp54_ = p;
#line 573 "/home/bob/git/simple-scan/src/page.vala"
					_tmp55_ = block_shift[x % 4];
#line 573 "/home/bob/git/simple-scan/src/page.vala"
					sample = (_tmp54_ >> _tmp55_) & 0x3;
#line 574 "/home/bob/git/simple-scan/src/page.vala"
					_tmp56_ = sample;
#line 574 "/home/bob/git/simple-scan/src/page.vala"
					sample = (_tmp56_ * 255) / 3;
#line 576 "/home/bob/git/simple-scan/src/page.vala"
					_tmp57_ = sample;
#line 576 "/home/bob/git/simple-scan/src/page.vala"
					pixel[offset + 2] = (guchar) _tmp57_;
#line 576 "/home/bob/git/simple-scan/src/page.vala"
					_tmp58_ = pixel[offset + 2];
#line 576 "/home/bob/git/simple-scan/src/page.vala"
					pixel[offset + 1] = _tmp58_;
#line 576 "/home/bob/git/simple-scan/src/page.vala"
					_tmp59_ = pixel[offset + 1];
#line 576 "/home/bob/git/simple-scan/src/page.vala"
					pixel[offset + 0] = _tmp59_;
#line 576 "/home/bob/git/simple-scan/src/page.vala"
					_tmp60_ = pixel[offset + 0];
#line 577 "/home/bob/git/simple-scan/src/page.vala"
					return;
#line 2219 "page.c"
				}
			}
		}
	}
#line 581 "/home/bob/git/simple-scan/src/page.vala"
	_tmp61_ = self->priv->pixels;
#line 581 "/home/bob/git/simple-scan/src/page.vala"
	_tmp61__length1 = self->priv->pixels_length1;
#line 581 "/home/bob/git/simple-scan/src/page.vala"
	_tmp62_ = line_offset;
#line 581 "/home/bob/git/simple-scan/src/page.vala"
	_tmp63_ = self->priv->_depth;
#line 581 "/home/bob/git/simple-scan/src/page.vala"
	_tmp64_ = self->priv->_n_channels;
#line 581 "/home/bob/git/simple-scan/src/page.vala"
	pixel[offset + 0] = page_get_sample (self, _tmp61_, _tmp61__length1, _tmp62_, x, _tmp63_, _tmp64_, 0);
#line 581 "/home/bob/git/simple-scan/src/page.vala"
	_tmp65_ = pixel[offset + 0];
#line 582 "/home/bob/git/simple-scan/src/page.vala"
	_tmp66_ = self->priv->pixels;
#line 582 "/home/bob/git/simple-scan/src/page.vala"
	_tmp66__length1 = self->priv->pixels_length1;
#line 582 "/home/bob/git/simple-scan/src/page.vala"
	_tmp67_ = line_offset;
#line 582 "/home/bob/git/simple-scan/src/page.vala"
	_tmp68_ = self->priv->_depth;
#line 582 "/home/bob/git/simple-scan/src/page.vala"
	_tmp69_ = self->priv->_n_channels;
#line 582 "/home/bob/git/simple-scan/src/page.vala"
	pixel[offset + 1] = page_get_sample (self, _tmp66_, _tmp66__length1, _tmp67_, x, _tmp68_, _tmp69_, 1);
#line 582 "/home/bob/git/simple-scan/src/page.vala"
	_tmp70_ = pixel[offset + 1];
#line 583 "/home/bob/git/simple-scan/src/page.vala"
	_tmp71_ = self->priv->pixels;
#line 583 "/home/bob/git/simple-scan/src/page.vala"
	_tmp71__length1 = self->priv->pixels_length1;
#line 583 "/home/bob/git/simple-scan/src/page.vala"
	_tmp72_ = line_offset;
#line 583 "/home/bob/git/simple-scan/src/page.vala"
	_tmp73_ = self->priv->_depth;
#line 583 "/home/bob/git/simple-scan/src/page.vala"
	_tmp74_ = self->priv->_n_channels;
#line 583 "/home/bob/git/simple-scan/src/page.vala"
	pixel[offset + 2] = page_get_sample (self, _tmp71_, _tmp71__length1, _tmp72_, x, _tmp73_, _tmp74_, 2);
#line 583 "/home/bob/git/simple-scan/src/page.vala"
	_tmp75_ = pixel[offset + 2];
#line 2266 "page.c"
}


GdkPixbuf*
page_get_image (Page* self,
                gboolean apply_crop)
{
	GdkPixbuf* result = NULL;
	gint l = 0;
	gint r = 0;
	gint t = 0;
	gint b = 0;
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* image = NULL;
	gint _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GdkPixbuf* _tmp28_;
	guint8* image_pixels = NULL;
	GdkPixbuf* _tmp29_;
	guint8* _tmp30_;
	gint image_pixels_length1;
	gint _image_pixels_size_;
#line 586 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 589 "/home/bob/git/simple-scan/src/page.vala"
	if (apply_crop) {
#line 2295 "page.c"
		gboolean _tmp1_;
#line 589 "/home/bob/git/simple-scan/src/page.vala"
		_tmp1_ = self->priv->_has_crop;
#line 589 "/home/bob/git/simple-scan/src/page.vala"
		_tmp0_ = _tmp1_;
#line 2301 "page.c"
	} else {
#line 589 "/home/bob/git/simple-scan/src/page.vala"
		_tmp0_ = FALSE;
#line 2305 "page.c"
	}
#line 589 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp0_) {
#line 2309 "page.c"
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
#line 591 "/home/bob/git/simple-scan/src/page.vala"
		_tmp2_ = self->priv->_crop_x;
#line 591 "/home/bob/git/simple-scan/src/page.vala"
		l = _tmp2_;
#line 592 "/home/bob/git/simple-scan/src/page.vala"
		_tmp3_ = l;
#line 592 "/home/bob/git/simple-scan/src/page.vala"
		_tmp4_ = self->priv->_crop_width;
#line 592 "/home/bob/git/simple-scan/src/page.vala"
		r = _tmp3_ + _tmp4_;
#line 593 "/home/bob/git/simple-scan/src/page.vala"
		_tmp5_ = self->priv->_crop_y;
#line 593 "/home/bob/git/simple-scan/src/page.vala"
		t = _tmp5_;
#line 594 "/home/bob/git/simple-scan/src/page.vala"
		_tmp6_ = t;
#line 594 "/home/bob/git/simple-scan/src/page.vala"
		_tmp7_ = self->priv->_crop_height;
#line 594 "/home/bob/git/simple-scan/src/page.vala"
		b = _tmp6_ + _tmp7_;
#line 596 "/home/bob/git/simple-scan/src/page.vala"
		_tmp8_ = l;
#line 596 "/home/bob/git/simple-scan/src/page.vala"
		if (_tmp8_ < 0) {
#line 597 "/home/bob/git/simple-scan/src/page.vala"
			l = 0;
#line 2350 "page.c"
		}
#line 598 "/home/bob/git/simple-scan/src/page.vala"
		_tmp9_ = r;
#line 598 "/home/bob/git/simple-scan/src/page.vala"
		_tmp10_ = page_get_width (self);
#line 598 "/home/bob/git/simple-scan/src/page.vala"
		_tmp11_ = _tmp10_;
#line 598 "/home/bob/git/simple-scan/src/page.vala"
		if (_tmp9_ > _tmp11_) {
#line 2360 "page.c"
			gint _tmp12_;
			gint _tmp13_;
#line 599 "/home/bob/git/simple-scan/src/page.vala"
			_tmp12_ = page_get_width (self);
#line 599 "/home/bob/git/simple-scan/src/page.vala"
			_tmp13_ = _tmp12_;
#line 599 "/home/bob/git/simple-scan/src/page.vala"
			r = _tmp13_;
#line 2369 "page.c"
		}
#line 600 "/home/bob/git/simple-scan/src/page.vala"
		_tmp14_ = t;
#line 600 "/home/bob/git/simple-scan/src/page.vala"
		if (_tmp14_ < 0) {
#line 601 "/home/bob/git/simple-scan/src/page.vala"
			t = 0;
#line 2377 "page.c"
		}
#line 602 "/home/bob/git/simple-scan/src/page.vala"
		_tmp15_ = b;
#line 602 "/home/bob/git/simple-scan/src/page.vala"
		_tmp16_ = page_get_height (self);
#line 602 "/home/bob/git/simple-scan/src/page.vala"
		_tmp17_ = _tmp16_;
#line 602 "/home/bob/git/simple-scan/src/page.vala"
		if (_tmp15_ > _tmp17_) {
#line 2387 "page.c"
			gint _tmp18_;
			gint _tmp19_;
#line 603 "/home/bob/git/simple-scan/src/page.vala"
			_tmp18_ = page_get_height (self);
#line 603 "/home/bob/git/simple-scan/src/page.vala"
			_tmp19_ = _tmp18_;
#line 603 "/home/bob/git/simple-scan/src/page.vala"
			b = _tmp19_;
#line 2396 "page.c"
		}
	} else {
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
#line 607 "/home/bob/git/simple-scan/src/page.vala"
		l = 0;
#line 608 "/home/bob/git/simple-scan/src/page.vala"
		_tmp20_ = page_get_width (self);
#line 608 "/home/bob/git/simple-scan/src/page.vala"
		_tmp21_ = _tmp20_;
#line 608 "/home/bob/git/simple-scan/src/page.vala"
		r = _tmp21_;
#line 609 "/home/bob/git/simple-scan/src/page.vala"
		t = 0;
#line 610 "/home/bob/git/simple-scan/src/page.vala"
		_tmp22_ = page_get_height (self);
#line 610 "/home/bob/git/simple-scan/src/page.vala"
		_tmp23_ = _tmp22_;
#line 610 "/home/bob/git/simple-scan/src/page.vala"
		b = _tmp23_;
#line 2419 "page.c"
	}
#line 613 "/home/bob/git/simple-scan/src/page.vala"
	_tmp24_ = r;
#line 613 "/home/bob/git/simple-scan/src/page.vala"
	_tmp25_ = l;
#line 613 "/home/bob/git/simple-scan/src/page.vala"
	_tmp26_ = b;
#line 613 "/home/bob/git/simple-scan/src/page.vala"
	_tmp27_ = t;
#line 613 "/home/bob/git/simple-scan/src/page.vala"
	_tmp28_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, _tmp24_ - _tmp25_, _tmp26_ - _tmp27_);
#line 613 "/home/bob/git/simple-scan/src/page.vala"
	image = _tmp28_;
#line 614 "/home/bob/git/simple-scan/src/page.vala"
	_tmp29_ = image;
#line 614 "/home/bob/git/simple-scan/src/page.vala"
	_tmp30_ = gdk_pixbuf_get_pixels (_tmp29_);
#line 614 "/home/bob/git/simple-scan/src/page.vala"
	image_pixels = _tmp30_;
#line 614 "/home/bob/git/simple-scan/src/page.vala"
	image_pixels_length1 = -1;
#line 614 "/home/bob/git/simple-scan/src/page.vala"
	_image_pixels_size_ = image_pixels_length1;
#line 2443 "page.c"
	{
		gint y = 0;
		gint _tmp31_;
#line 615 "/home/bob/git/simple-scan/src/page.vala"
		_tmp31_ = t;
#line 615 "/home/bob/git/simple-scan/src/page.vala"
		y = _tmp31_;
#line 2451 "page.c"
		{
			gboolean _tmp32_ = FALSE;
#line 615 "/home/bob/git/simple-scan/src/page.vala"
			_tmp32_ = TRUE;
#line 615 "/home/bob/git/simple-scan/src/page.vala"
			while (TRUE) {
#line 2458 "page.c"
				gint _tmp34_;
				gint _tmp35_;
				gint offset = 0;
				GdkPixbuf* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
#line 615 "/home/bob/git/simple-scan/src/page.vala"
				if (!_tmp32_) {
#line 2467 "page.c"
					gint _tmp33_;
#line 615 "/home/bob/git/simple-scan/src/page.vala"
					_tmp33_ = y;
#line 615 "/home/bob/git/simple-scan/src/page.vala"
					y = _tmp33_ + 1;
#line 2473 "page.c"
				}
#line 615 "/home/bob/git/simple-scan/src/page.vala"
				_tmp32_ = FALSE;
#line 615 "/home/bob/git/simple-scan/src/page.vala"
				_tmp34_ = y;
#line 615 "/home/bob/git/simple-scan/src/page.vala"
				_tmp35_ = b;
#line 615 "/home/bob/git/simple-scan/src/page.vala"
				if (!(_tmp34_ < _tmp35_)) {
#line 615 "/home/bob/git/simple-scan/src/page.vala"
					break;
#line 2485 "page.c"
				}
#line 617 "/home/bob/git/simple-scan/src/page.vala"
				_tmp36_ = image;
#line 617 "/home/bob/git/simple-scan/src/page.vala"
				_tmp37_ = y;
#line 617 "/home/bob/git/simple-scan/src/page.vala"
				_tmp38_ = t;
#line 617 "/home/bob/git/simple-scan/src/page.vala"
				offset = gdk_pixbuf_get_rowstride (_tmp36_) * (_tmp37_ - _tmp38_);
#line 2495 "page.c"
				{
					gint x = 0;
					gint _tmp39_;
#line 618 "/home/bob/git/simple-scan/src/page.vala"
					_tmp39_ = l;
#line 618 "/home/bob/git/simple-scan/src/page.vala"
					x = _tmp39_;
#line 2503 "page.c"
					{
						gboolean _tmp40_ = FALSE;
#line 618 "/home/bob/git/simple-scan/src/page.vala"
						_tmp40_ = TRUE;
#line 618 "/home/bob/git/simple-scan/src/page.vala"
						while (TRUE) {
#line 2510 "page.c"
							gint _tmp42_;
							gint _tmp43_;
							gint _tmp44_;
							gint _tmp45_;
							guint8* _tmp46_;
							gint _tmp46__length1;
							gint _tmp47_;
							gint _tmp48_;
							gint _tmp49_;
#line 618 "/home/bob/git/simple-scan/src/page.vala"
							if (!_tmp40_) {
#line 2522 "page.c"
								gint _tmp41_;
#line 618 "/home/bob/git/simple-scan/src/page.vala"
								_tmp41_ = x;
#line 618 "/home/bob/git/simple-scan/src/page.vala"
								x = _tmp41_ + 1;
#line 2528 "page.c"
							}
#line 618 "/home/bob/git/simple-scan/src/page.vala"
							_tmp40_ = FALSE;
#line 618 "/home/bob/git/simple-scan/src/page.vala"
							_tmp42_ = x;
#line 618 "/home/bob/git/simple-scan/src/page.vala"
							_tmp43_ = r;
#line 618 "/home/bob/git/simple-scan/src/page.vala"
							if (!(_tmp42_ < _tmp43_)) {
#line 618 "/home/bob/git/simple-scan/src/page.vala"
								break;
#line 2540 "page.c"
							}
#line 619 "/home/bob/git/simple-scan/src/page.vala"
							_tmp44_ = x;
#line 619 "/home/bob/git/simple-scan/src/page.vala"
							_tmp45_ = y;
#line 619 "/home/bob/git/simple-scan/src/page.vala"
							_tmp46_ = image_pixels;
#line 619 "/home/bob/git/simple-scan/src/page.vala"
							_tmp46__length1 = image_pixels_length1;
#line 619 "/home/bob/git/simple-scan/src/page.vala"
							_tmp47_ = offset;
#line 619 "/home/bob/git/simple-scan/src/page.vala"
							_tmp48_ = x;
#line 619 "/home/bob/git/simple-scan/src/page.vala"
							_tmp49_ = l;
#line 619 "/home/bob/git/simple-scan/src/page.vala"
							page_get_pixel (self, _tmp44_, _tmp45_, _tmp46_, _tmp46__length1, _tmp47_ + ((_tmp48_ - _tmp49_) * 3));
#line 2558 "page.c"
						}
					}
				}
			}
		}
	}
#line 622 "/home/bob/git/simple-scan/src/page.vala"
	result = image;
#line 622 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 2569 "page.c"
}


static gchar*
string_to_utf8 (const gchar* self,
                int* result_length1)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
#line 1505 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1506 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1506 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1506 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1506 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1506 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1506 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1507 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1507 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1508 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1508 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1508 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1508 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1508 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1509 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1509 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1509 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1509 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 2627 "page.c"
	}
#line 1509 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1509 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 2633 "page.c"
}


static gchar*
page_get_icc_data_encoded (Page* self,
                           const gchar* icc_profile_filename)
{
	gchar* result = NULL;
	gchar* contents = NULL;
	const gchar* _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	guchar* _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError * _inner_error_ = NULL;
#line 625 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 625 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (icc_profile_filename != NULL, NULL);
#line 2655 "page.c"
	{
		gchar* _tmp0_ = NULL;
#line 631 "/home/bob/git/simple-scan/src/page.vala"
		g_file_get_contents (icc_profile_filename, &_tmp0_, NULL, &_inner_error_);
#line 631 "/home/bob/git/simple-scan/src/page.vala"
		_g_free0 (contents);
#line 631 "/home/bob/git/simple-scan/src/page.vala"
		contents = _tmp0_;
#line 631 "/home/bob/git/simple-scan/src/page.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2666 "page.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 629 "/home/bob/git/simple-scan/src/page.vala"
		e = _inner_error_;
#line 629 "/home/bob/git/simple-scan/src/page.vala"
		_inner_error_ = NULL;
#line 635 "/home/bob/git/simple-scan/src/page.vala"
		_tmp1_ = e;
#line 635 "/home/bob/git/simple-scan/src/page.vala"
		_tmp2_ = _tmp1_->message;
#line 635 "/home/bob/git/simple-scan/src/page.vala"
		g_warning ("page.vala:635: failed to get icc profile data: %s", _tmp2_);
#line 636 "/home/bob/git/simple-scan/src/page.vala"
		result = NULL;
#line 636 "/home/bob/git/simple-scan/src/page.vala"
		_g_error_free0 (e);
#line 636 "/home/bob/git/simple-scan/src/page.vala"
		_g_free0 (contents);
#line 636 "/home/bob/git/simple-scan/src/page.vala"
		return result;
#line 2694 "page.c"
	}
	__finally3:
#line 629 "/home/bob/git/simple-scan/src/page.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 629 "/home/bob/git/simple-scan/src/page.vala"
		_g_free0 (contents);
#line 629 "/home/bob/git/simple-scan/src/page.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 629 "/home/bob/git/simple-scan/src/page.vala"
		g_clear_error (&_inner_error_);
#line 629 "/home/bob/git/simple-scan/src/page.vala"
		return NULL;
#line 2707 "page.c"
	}
#line 640 "/home/bob/git/simple-scan/src/page.vala"
	_tmp3_ = contents;
#line 640 "/home/bob/git/simple-scan/src/page.vala"
	_tmp5_ = string_to_utf8 (_tmp3_, &_tmp4_);
#line 640 "/home/bob/git/simple-scan/src/page.vala"
	_tmp6_ = (guchar*) _tmp5_;
#line 640 "/home/bob/git/simple-scan/src/page.vala"
	_tmp6__length1 = (_tmp4_ * sizeof (gchar)) / sizeof (guchar);
#line 640 "/home/bob/git/simple-scan/src/page.vala"
	_tmp7_ = g_base64_encode (_tmp6_, (_tmp4_ * sizeof (gchar)) / sizeof (guchar));
#line 640 "/home/bob/git/simple-scan/src/page.vala"
	_tmp8_ = _tmp7_;
#line 640 "/home/bob/git/simple-scan/src/page.vala"
	_tmp6_ = (g_free (_tmp6_), NULL);
#line 640 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp8_;
#line 640 "/home/bob/git/simple-scan/src/page.vala"
	_g_free0 (contents);
#line 640 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 2729 "page.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 645 "/home/bob/git/simple-scan/src/page.vala"
	return self ? g_object_ref (self) : NULL;
#line 2738 "page.c"
}


void
page_copy_to_clipboard (Page* self,
                        GtkWindow* window)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp2_;
	GtkClipboard* _tmp3_;
	GdkPixbuf* image = NULL;
	GdkPixbuf* _tmp4_;
#line 643 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 643 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (window != NULL);
#line 645 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) window);
#line 645 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 645 "/home/bob/git/simple-scan/src/page.vala"
	display = _tmp1_;
#line 646 "/home/bob/git/simple-scan/src/page.vala"
	_tmp2_ = gtk_clipboard_get_for_display (display, GDK_SELECTION_CLIPBOARD);
#line 646 "/home/bob/git/simple-scan/src/page.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 646 "/home/bob/git/simple-scan/src/page.vala"
	clipboard = _tmp3_;
#line 647 "/home/bob/git/simple-scan/src/page.vala"
	_tmp4_ = page_get_image (self, TRUE);
#line 647 "/home/bob/git/simple-scan/src/page.vala"
	image = _tmp4_;
#line 648 "/home/bob/git/simple-scan/src/page.vala"
	gtk_clipboard_set_image (clipboard, image);
#line 643 "/home/bob/git/simple-scan/src/page.vala"
	_g_object_unref0 (image);
#line 643 "/home/bob/git/simple-scan/src/page.vala"
	_g_object_unref0 (clipboard);
#line 643 "/home/bob/git/simple-scan/src/page.vala"
	_g_object_unref0 (display);
#line 2782 "page.c"
}


void
page_save (Page* self,
           const gchar* type,
           gint quality,
           GFile* file,
           GError** error)
{
	GFileOutputStream* stream = NULL;
	GFileOutputStream* _tmp0_;
	PixbufWriter* writer = NULL;
	GFileOutputStream* _tmp1_;
	PixbufWriter* _tmp2_;
	GdkPixbuf* image = NULL;
	GdkPixbuf* _tmp3_;
	gchar* icc_profile_data = NULL;
	const gchar* _tmp4_;
	GCompareFunc _tmp7_;
	GError * _inner_error_ = NULL;
#line 651 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 651 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (type != NULL);
#line 651 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (file != NULL);
#line 653 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = g_file_replace (file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 653 "/home/bob/git/simple-scan/src/page.vala"
	stream = _tmp0_;
#line 653 "/home/bob/git/simple-scan/src/page.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 653 "/home/bob/git/simple-scan/src/page.vala"
		g_propagate_error (error, _inner_error_);
#line 653 "/home/bob/git/simple-scan/src/page.vala"
		return;
#line 2820 "page.c"
	}
#line 654 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1_ = stream;
#line 654 "/home/bob/git/simple-scan/src/page.vala"
	_tmp2_ = pixbuf_writer_new (_tmp1_);
#line 654 "/home/bob/git/simple-scan/src/page.vala"
	writer = _tmp2_;
#line 655 "/home/bob/git/simple-scan/src/page.vala"
	_tmp3_ = page_get_image (self, TRUE);
#line 655 "/home/bob/git/simple-scan/src/page.vala"
	image = _tmp3_;
#line 657 "/home/bob/git/simple-scan/src/page.vala"
	icc_profile_data = NULL;
#line 658 "/home/bob/git/simple-scan/src/page.vala"
	_tmp4_ = self->priv->_color_profile;
#line 658 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp4_ != NULL) {
#line 2838 "page.c"
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 659 "/home/bob/git/simple-scan/src/page.vala"
		_tmp5_ = self->priv->_color_profile;
#line 659 "/home/bob/git/simple-scan/src/page.vala"
		_tmp6_ = page_get_icc_data_encoded (self, _tmp5_);
#line 659 "/home/bob/git/simple-scan/src/page.vala"
		_g_free0 (icc_profile_data);
#line 659 "/home/bob/git/simple-scan/src/page.vala"
		icc_profile_data = _tmp6_;
#line 2849 "page.c"
	}
#line 661 "/home/bob/git/simple-scan/src/page.vala"
	_tmp7_ = g_strcmp0;
#line 661 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp7_ (type, "jpeg") == 0) {
#line 2855 "page.c"
		gchar** keys = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gint keys_length1;
		gint _keys_size_;
		gchar** values = NULL;
		gint _tmp13_;
		gchar* _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gint values_length1;
		gint _values_size_;
		const gchar* _tmp21_;
		PixbufWriter* _tmp24_;
		GdkPixbuf* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar** _tmp27_;
		gint _tmp27__length1;
#line 663 "/home/bob/git/simple-scan/src/page.vala"
		_tmp8_ = g_strdup ("x-dpi");
#line 663 "/home/bob/git/simple-scan/src/page.vala"
		_tmp9_ = g_strdup ("y-dpi");
#line 663 "/home/bob/git/simple-scan/src/page.vala"
		_tmp10_ = g_strdup ("quality");
#line 663 "/home/bob/git/simple-scan/src/page.vala"
		_tmp11_ = g_strdup ("icc-profile");
#line 663 "/home/bob/git/simple-scan/src/page.vala"
		_tmp12_ = g_new0 (gchar*, 5 + 1);
#line 663 "/home/bob/git/simple-scan/src/page.vala"
		_tmp12_[0] = _tmp8_;
#line 663 "/home/bob/git/simple-scan/src/page.vala"
		_tmp12_[1] = _tmp9_;
#line 663 "/home/bob/git/simple-scan/src/page.vala"
		_tmp12_[2] = _tmp10_;
#line 663 "/home/bob/git/simple-scan/src/page.vala"
		_tmp12_[3] = _tmp11_;
#line 663 "/home/bob/git/simple-scan/src/page.vala"
		_tmp12_[4] = NULL;
#line 663 "/home/bob/git/simple-scan/src/page.vala"
		keys = _tmp12_;
#line 663 "/home/bob/git/simple-scan/src/page.vala"
		keys_length1 = 5;
#line 663 "/home/bob/git/simple-scan/src/page.vala"
		_keys_size_ = keys_length1;
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		_tmp13_ = self->priv->_dpi;
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		_tmp14_ = g_strdup_printf ("%d", _tmp13_);
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		_tmp15_ = self->priv->_dpi;
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		_tmp16_ = g_strdup_printf ("%d", _tmp15_);
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		_tmp17_ = g_strdup_printf ("%d", quality);
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		_tmp18_ = icc_profile_data;
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		_tmp19_ = g_strdup (_tmp18_);
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		_tmp20_ = g_new0 (gchar*, 5 + 1);
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		_tmp20_[0] = _tmp14_;
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		_tmp20_[1] = _tmp16_;
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		_tmp20_[2] = _tmp17_;
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		_tmp20_[3] = _tmp19_;
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		_tmp20_[4] = NULL;
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		values = _tmp20_;
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		values_length1 = 5;
#line 664 "/home/bob/git/simple-scan/src/page.vala"
		_values_size_ = values_length1;
#line 665 "/home/bob/git/simple-scan/src/page.vala"
		_tmp21_ = icc_profile_data;
#line 665 "/home/bob/git/simple-scan/src/page.vala"
		if (_tmp21_ == NULL) {
#line 2944 "page.c"
			gchar** _tmp22_;
			gint _tmp22__length1;
			gchar* _tmp23_;
#line 666 "/home/bob/git/simple-scan/src/page.vala"
			_tmp22_ = keys;
#line 666 "/home/bob/git/simple-scan/src/page.vala"
			_tmp22__length1 = keys_length1;
#line 666 "/home/bob/git/simple-scan/src/page.vala"
			_g_free0 (_tmp22_[3]);
#line 666 "/home/bob/git/simple-scan/src/page.vala"
			_tmp22_[3] = NULL;
#line 666 "/home/bob/git/simple-scan/src/page.vala"
			_tmp23_ = _tmp22_[3];
#line 2958 "page.c"
		}
#line 667 "/home/bob/git/simple-scan/src/page.vala"
		_tmp24_ = writer;
#line 667 "/home/bob/git/simple-scan/src/page.vala"
		_tmp25_ = image;
#line 667 "/home/bob/git/simple-scan/src/page.vala"
		_tmp26_ = keys;
#line 667 "/home/bob/git/simple-scan/src/page.vala"
		_tmp26__length1 = keys_length1;
#line 667 "/home/bob/git/simple-scan/src/page.vala"
		_tmp27_ = values;
#line 667 "/home/bob/git/simple-scan/src/page.vala"
		_tmp27__length1 = values_length1;
#line 667 "/home/bob/git/simple-scan/src/page.vala"
		pixbuf_writer_save (_tmp24_, _tmp25_, "jpeg", _tmp26_, _tmp26__length1, _tmp27_, _tmp27__length1, &_inner_error_);
#line 667 "/home/bob/git/simple-scan/src/page.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 667 "/home/bob/git/simple-scan/src/page.vala"
			g_propagate_error (error, _inner_error_);
#line 667 "/home/bob/git/simple-scan/src/page.vala"
			values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 667 "/home/bob/git/simple-scan/src/page.vala"
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 667 "/home/bob/git/simple-scan/src/page.vala"
			_g_free0 (icc_profile_data);
#line 667 "/home/bob/git/simple-scan/src/page.vala"
			_g_object_unref0 (image);
#line 667 "/home/bob/git/simple-scan/src/page.vala"
			_pixbuf_writer_unref0 (writer);
#line 667 "/home/bob/git/simple-scan/src/page.vala"
			_g_object_unref0 (stream);
#line 667 "/home/bob/git/simple-scan/src/page.vala"
			return;
#line 2992 "page.c"
		}
#line 661 "/home/bob/git/simple-scan/src/page.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 661 "/home/bob/git/simple-scan/src/page.vala"
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 2998 "page.c"
	} else {
		GCompareFunc _tmp28_;
#line 669 "/home/bob/git/simple-scan/src/page.vala"
		_tmp28_ = g_strcmp0;
#line 669 "/home/bob/git/simple-scan/src/page.vala"
		if (_tmp28_ (type, "png") == 0) {
#line 3005 "page.c"
			gchar** keys = NULL;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar** _tmp32_;
			gint keys_length1;
			gint _keys_size_;
			gchar** values = NULL;
			gint _tmp33_;
			gchar* _tmp34_;
			gint _tmp35_;
			gchar* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gchar** _tmp39_;
			gint values_length1;
			gint _values_size_;
			const gchar* _tmp40_;
			PixbufWriter* _tmp43_;
			GdkPixbuf* _tmp44_;
			gchar** _tmp45_;
			gint _tmp45__length1;
			gchar** _tmp46_;
			gint _tmp46__length1;
#line 671 "/home/bob/git/simple-scan/src/page.vala"
			_tmp29_ = g_strdup ("x-dpi");
#line 671 "/home/bob/git/simple-scan/src/page.vala"
			_tmp30_ = g_strdup ("y-dpi");
#line 671 "/home/bob/git/simple-scan/src/page.vala"
			_tmp31_ = g_strdup ("icc-profile");
#line 671 "/home/bob/git/simple-scan/src/page.vala"
			_tmp32_ = g_new0 (gchar*, 4 + 1);
#line 671 "/home/bob/git/simple-scan/src/page.vala"
			_tmp32_[0] = _tmp29_;
#line 671 "/home/bob/git/simple-scan/src/page.vala"
			_tmp32_[1] = _tmp30_;
#line 671 "/home/bob/git/simple-scan/src/page.vala"
			_tmp32_[2] = _tmp31_;
#line 671 "/home/bob/git/simple-scan/src/page.vala"
			_tmp32_[3] = NULL;
#line 671 "/home/bob/git/simple-scan/src/page.vala"
			keys = _tmp32_;
#line 671 "/home/bob/git/simple-scan/src/page.vala"
			keys_length1 = 4;
#line 671 "/home/bob/git/simple-scan/src/page.vala"
			_keys_size_ = keys_length1;
#line 672 "/home/bob/git/simple-scan/src/page.vala"
			_tmp33_ = self->priv->_dpi;
#line 672 "/home/bob/git/simple-scan/src/page.vala"
			_tmp34_ = g_strdup_printf ("%d", _tmp33_);
#line 672 "/home/bob/git/simple-scan/src/page.vala"
			_tmp35_ = self->priv->_dpi;
#line 672 "/home/bob/git/simple-scan/src/page.vala"
			_tmp36_ = g_strdup_printf ("%d", _tmp35_);
#line 672 "/home/bob/git/simple-scan/src/page.vala"
			_tmp37_ = icc_profile_data;
#line 672 "/home/bob/git/simple-scan/src/page.vala"
			_tmp38_ = g_strdup (_tmp37_);
#line 672 "/home/bob/git/simple-scan/src/page.vala"
			_tmp39_ = g_new0 (gchar*, 4 + 1);
#line 672 "/home/bob/git/simple-scan/src/page.vala"
			_tmp39_[0] = _tmp34_;
#line 672 "/home/bob/git/simple-scan/src/page.vala"
			_tmp39_[1] = _tmp36_;
#line 672 "/home/bob/git/simple-scan/src/page.vala"
			_tmp39_[2] = _tmp38_;
#line 672 "/home/bob/git/simple-scan/src/page.vala"
			_tmp39_[3] = NULL;
#line 672 "/home/bob/git/simple-scan/src/page.vala"
			values = _tmp39_;
#line 672 "/home/bob/git/simple-scan/src/page.vala"
			values_length1 = 4;
#line 672 "/home/bob/git/simple-scan/src/page.vala"
			_values_size_ = values_length1;
#line 673 "/home/bob/git/simple-scan/src/page.vala"
			_tmp40_ = icc_profile_data;
#line 673 "/home/bob/git/simple-scan/src/page.vala"
			if (_tmp40_ == NULL) {
#line 3084 "page.c"
				gchar** _tmp41_;
				gint _tmp41__length1;
				gchar* _tmp42_;
#line 674 "/home/bob/git/simple-scan/src/page.vala"
				_tmp41_ = keys;
#line 674 "/home/bob/git/simple-scan/src/page.vala"
				_tmp41__length1 = keys_length1;
#line 674 "/home/bob/git/simple-scan/src/page.vala"
				_g_free0 (_tmp41_[2]);
#line 674 "/home/bob/git/simple-scan/src/page.vala"
				_tmp41_[2] = NULL;
#line 674 "/home/bob/git/simple-scan/src/page.vala"
				_tmp42_ = _tmp41_[2];
#line 3098 "page.c"
			}
#line 675 "/home/bob/git/simple-scan/src/page.vala"
			_tmp43_ = writer;
#line 675 "/home/bob/git/simple-scan/src/page.vala"
			_tmp44_ = image;
#line 675 "/home/bob/git/simple-scan/src/page.vala"
			_tmp45_ = keys;
#line 675 "/home/bob/git/simple-scan/src/page.vala"
			_tmp45__length1 = keys_length1;
#line 675 "/home/bob/git/simple-scan/src/page.vala"
			_tmp46_ = values;
#line 675 "/home/bob/git/simple-scan/src/page.vala"
			_tmp46__length1 = values_length1;
#line 675 "/home/bob/git/simple-scan/src/page.vala"
			pixbuf_writer_save (_tmp43_, _tmp44_, "png", _tmp45_, _tmp45__length1, _tmp46_, _tmp46__length1, &_inner_error_);
#line 675 "/home/bob/git/simple-scan/src/page.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 675 "/home/bob/git/simple-scan/src/page.vala"
				g_propagate_error (error, _inner_error_);
#line 675 "/home/bob/git/simple-scan/src/page.vala"
				values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 675 "/home/bob/git/simple-scan/src/page.vala"
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 675 "/home/bob/git/simple-scan/src/page.vala"
				_g_free0 (icc_profile_data);
#line 675 "/home/bob/git/simple-scan/src/page.vala"
				_g_object_unref0 (image);
#line 675 "/home/bob/git/simple-scan/src/page.vala"
				_pixbuf_writer_unref0 (writer);
#line 675 "/home/bob/git/simple-scan/src/page.vala"
				_g_object_unref0 (stream);
#line 675 "/home/bob/git/simple-scan/src/page.vala"
				return;
#line 3132 "page.c"
			}
#line 669 "/home/bob/git/simple-scan/src/page.vala"
			values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 669 "/home/bob/git/simple-scan/src/page.vala"
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 3138 "page.c"
		} else {
			GCompareFunc _tmp47_;
#line 677 "/home/bob/git/simple-scan/src/page.vala"
			_tmp47_ = g_strcmp0;
#line 677 "/home/bob/git/simple-scan/src/page.vala"
			if (_tmp47_ (type, "tiff") == 0) {
#line 3145 "page.c"
				gchar** keys = NULL;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar** _tmp52_;
				gint keys_length1;
				gint _keys_size_;
				gchar** values = NULL;
				gint _tmp53_;
				gchar* _tmp54_;
				gint _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				const gchar* _tmp58_;
				gchar* _tmp59_;
				gchar** _tmp60_;
				gint values_length1;
				gint _values_size_;
				const gchar* _tmp61_;
				PixbufWriter* _tmp64_;
				GdkPixbuf* _tmp65_;
				gchar** _tmp66_;
				gint _tmp66__length1;
				gchar** _tmp67_;
				gint _tmp67__length1;
#line 679 "/home/bob/git/simple-scan/src/page.vala"
				_tmp48_ = g_strdup ("x-dpi");
#line 679 "/home/bob/git/simple-scan/src/page.vala"
				_tmp49_ = g_strdup ("y-dpi");
#line 679 "/home/bob/git/simple-scan/src/page.vala"
				_tmp50_ = g_strdup ("compression");
#line 679 "/home/bob/git/simple-scan/src/page.vala"
				_tmp51_ = g_strdup ("icc-profile");
#line 679 "/home/bob/git/simple-scan/src/page.vala"
				_tmp52_ = g_new0 (gchar*, 5 + 1);
#line 679 "/home/bob/git/simple-scan/src/page.vala"
				_tmp52_[0] = _tmp48_;
#line 679 "/home/bob/git/simple-scan/src/page.vala"
				_tmp52_[1] = _tmp49_;
#line 679 "/home/bob/git/simple-scan/src/page.vala"
				_tmp52_[2] = _tmp50_;
#line 679 "/home/bob/git/simple-scan/src/page.vala"
				_tmp52_[3] = _tmp51_;
#line 679 "/home/bob/git/simple-scan/src/page.vala"
				_tmp52_[4] = NULL;
#line 679 "/home/bob/git/simple-scan/src/page.vala"
				keys = _tmp52_;
#line 679 "/home/bob/git/simple-scan/src/page.vala"
				keys_length1 = 5;
#line 679 "/home/bob/git/simple-scan/src/page.vala"
				_keys_size_ = keys_length1;
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				_tmp53_ = self->priv->_dpi;
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				_tmp54_ = g_strdup_printf ("%d", _tmp53_);
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				_tmp55_ = self->priv->_dpi;
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				_tmp56_ = g_strdup_printf ("%d", _tmp55_);
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				_tmp57_ = g_strdup ("8");
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				_tmp58_ = icc_profile_data;
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				_tmp59_ = g_strdup (_tmp58_);
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				_tmp60_ = g_new0 (gchar*, 5 + 1);
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				_tmp60_[0] = _tmp54_;
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				_tmp60_[1] = _tmp56_;
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				_tmp60_[2] = _tmp57_;
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				_tmp60_[3] = _tmp59_;
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				_tmp60_[4] = NULL;
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				values = _tmp60_;
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				values_length1 = 5;
#line 680 "/home/bob/git/simple-scan/src/page.vala"
				_values_size_ = values_length1;
#line 681 "/home/bob/git/simple-scan/src/page.vala"
				_tmp61_ = icc_profile_data;
#line 681 "/home/bob/git/simple-scan/src/page.vala"
				if (_tmp61_ == NULL) {
#line 3234 "page.c"
					gchar** _tmp62_;
					gint _tmp62__length1;
					gchar* _tmp63_;
#line 682 "/home/bob/git/simple-scan/src/page.vala"
					_tmp62_ = keys;
#line 682 "/home/bob/git/simple-scan/src/page.vala"
					_tmp62__length1 = keys_length1;
#line 682 "/home/bob/git/simple-scan/src/page.vala"
					_g_free0 (_tmp62_[3]);
#line 682 "/home/bob/git/simple-scan/src/page.vala"
					_tmp62_[3] = NULL;
#line 682 "/home/bob/git/simple-scan/src/page.vala"
					_tmp63_ = _tmp62_[3];
#line 3248 "page.c"
				}
#line 683 "/home/bob/git/simple-scan/src/page.vala"
				_tmp64_ = writer;
#line 683 "/home/bob/git/simple-scan/src/page.vala"
				_tmp65_ = image;
#line 683 "/home/bob/git/simple-scan/src/page.vala"
				_tmp66_ = keys;
#line 683 "/home/bob/git/simple-scan/src/page.vala"
				_tmp66__length1 = keys_length1;
#line 683 "/home/bob/git/simple-scan/src/page.vala"
				_tmp67_ = values;
#line 683 "/home/bob/git/simple-scan/src/page.vala"
				_tmp67__length1 = values_length1;
#line 683 "/home/bob/git/simple-scan/src/page.vala"
				pixbuf_writer_save (_tmp64_, _tmp65_, "tiff", _tmp66_, _tmp66__length1, _tmp67_, _tmp67__length1, &_inner_error_);
#line 683 "/home/bob/git/simple-scan/src/page.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 683 "/home/bob/git/simple-scan/src/page.vala"
					g_propagate_error (error, _inner_error_);
#line 683 "/home/bob/git/simple-scan/src/page.vala"
					values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 683 "/home/bob/git/simple-scan/src/page.vala"
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 683 "/home/bob/git/simple-scan/src/page.vala"
					_g_free0 (icc_profile_data);
#line 683 "/home/bob/git/simple-scan/src/page.vala"
					_g_object_unref0 (image);
#line 683 "/home/bob/git/simple-scan/src/page.vala"
					_pixbuf_writer_unref0 (writer);
#line 683 "/home/bob/git/simple-scan/src/page.vala"
					_g_object_unref0 (stream);
#line 683 "/home/bob/git/simple-scan/src/page.vala"
					return;
#line 3282 "page.c"
				}
#line 677 "/home/bob/git/simple-scan/src/page.vala"
				values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 677 "/home/bob/git/simple-scan/src/page.vala"
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 3288 "page.c"
			} else {
				gchar* _tmp68_;
				gchar* _tmp69_;
				GError* _tmp70_;
				GError* _tmp71_;
#line 686 "/home/bob/git/simple-scan/src/page.vala"
				_tmp68_ = g_strdup_printf ("Unknown file type: %s", type);
#line 686 "/home/bob/git/simple-scan/src/page.vala"
				_tmp69_ = _tmp68_;
#line 686 "/home/bob/git/simple-scan/src/page.vala"
				_tmp70_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp69_);
#line 686 "/home/bob/git/simple-scan/src/page.vala"
				_tmp71_ = _tmp70_;
#line 686 "/home/bob/git/simple-scan/src/page.vala"
				_g_free0 (_tmp69_);
#line 686 "/home/bob/git/simple-scan/src/page.vala"
				_inner_error_ = _tmp71_;
#line 686 "/home/bob/git/simple-scan/src/page.vala"
				g_propagate_error (error, _inner_error_);
#line 686 "/home/bob/git/simple-scan/src/page.vala"
				_g_free0 (icc_profile_data);
#line 686 "/home/bob/git/simple-scan/src/page.vala"
				_g_object_unref0 (image);
#line 686 "/home/bob/git/simple-scan/src/page.vala"
				_pixbuf_writer_unref0 (writer);
#line 686 "/home/bob/git/simple-scan/src/page.vala"
				_g_object_unref0 (stream);
#line 686 "/home/bob/git/simple-scan/src/page.vala"
				return;
#line 3318 "page.c"
			}
		}
	}
#line 651 "/home/bob/git/simple-scan/src/page.vala"
	_g_free0 (icc_profile_data);
#line 651 "/home/bob/git/simple-scan/src/page.vala"
	_g_object_unref0 (image);
#line 651 "/home/bob/git/simple-scan/src/page.vala"
	_pixbuf_writer_unref0 (writer);
#line 651 "/home/bob/git/simple-scan/src/page.vala"
	_g_object_unref0 (stream);
#line 3330 "page.c"
}


gint
page_get_width (Page* self)
{
	gint result;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_;
	ScanDirection _tmp2_;
#line 25 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 27 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1_ = page_get_scan_direction (self);
#line 27 "/home/bob/git/simple-scan/src/page.vala"
	_tmp2_ = _tmp1_;
#line 27 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp2_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
#line 27 "/home/bob/git/simple-scan/src/page.vala"
		_tmp0_ = TRUE;
#line 3351 "page.c"
	} else {
		ScanDirection _tmp3_;
		ScanDirection _tmp4_;
#line 27 "/home/bob/git/simple-scan/src/page.vala"
		_tmp3_ = page_get_scan_direction (self);
#line 27 "/home/bob/git/simple-scan/src/page.vala"
		_tmp4_ = _tmp3_;
#line 27 "/home/bob/git/simple-scan/src/page.vala"
		_tmp0_ = _tmp4_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 3361 "page.c"
	}
#line 27 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp0_) {
#line 3365 "page.c"
		gint _tmp5_;
#line 28 "/home/bob/git/simple-scan/src/page.vala"
		_tmp5_ = self->priv->_scan_width;
#line 28 "/home/bob/git/simple-scan/src/page.vala"
		result = _tmp5_;
#line 28 "/home/bob/git/simple-scan/src/page.vala"
		return result;
#line 3373 "page.c"
	} else {
		gint _tmp6_;
#line 30 "/home/bob/git/simple-scan/src/page.vala"
		_tmp6_ = self->priv->_scan_height;
#line 30 "/home/bob/git/simple-scan/src/page.vala"
		result = _tmp6_;
#line 30 "/home/bob/git/simple-scan/src/page.vala"
		return result;
#line 3382 "page.c"
	}
}


gint
page_get_height (Page* self)
{
	gint result;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_;
	ScanDirection _tmp2_;
#line 37 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 39 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1_ = page_get_scan_direction (self);
#line 39 "/home/bob/git/simple-scan/src/page.vala"
	_tmp2_ = _tmp1_;
#line 39 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp2_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
#line 39 "/home/bob/git/simple-scan/src/page.vala"
		_tmp0_ = TRUE;
#line 3404 "page.c"
	} else {
		ScanDirection _tmp3_;
		ScanDirection _tmp4_;
#line 39 "/home/bob/git/simple-scan/src/page.vala"
		_tmp3_ = page_get_scan_direction (self);
#line 39 "/home/bob/git/simple-scan/src/page.vala"
		_tmp4_ = _tmp3_;
#line 39 "/home/bob/git/simple-scan/src/page.vala"
		_tmp0_ = _tmp4_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 3414 "page.c"
	}
#line 39 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp0_) {
#line 3418 "page.c"
		gint _tmp5_;
#line 40 "/home/bob/git/simple-scan/src/page.vala"
		_tmp5_ = self->priv->_scan_height;
#line 40 "/home/bob/git/simple-scan/src/page.vala"
		result = _tmp5_;
#line 40 "/home/bob/git/simple-scan/src/page.vala"
		return result;
#line 3426 "page.c"
	} else {
		gint _tmp6_;
#line 42 "/home/bob/git/simple-scan/src/page.vala"
		_tmp6_ = self->priv->_scan_width;
#line 42 "/home/bob/git/simple-scan/src/page.vala"
		result = _tmp6_;
#line 42 "/home/bob/git/simple-scan/src/page.vala"
		return result;
#line 3435 "page.c"
	}
}


gboolean
page_get_is_landscape (Page* self)
{
	gboolean result;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
#line 47 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 47 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = page_get_width (self);
#line 47 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1_ = _tmp0_;
#line 47 "/home/bob/git/simple-scan/src/page.vala"
	_tmp2_ = page_get_height (self);
#line 47 "/home/bob/git/simple-scan/src/page.vala"
	_tmp3_ = _tmp2_;
#line 47 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp1_ > _tmp3_;
#line 47 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 3462 "page.c"
}


gint
page_get_dpi (Page* self)
{
	gint result;
	gint _tmp0_;
#line 50 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 50 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_dpi;
#line 50 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 50 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 3479 "page.c"
}


static void
page_set_dpi (Page* self,
              gint value)
{
#line 50 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 50 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_dpi = value;
#line 3491 "page.c"
}


gint
page_get_depth (Page* self)
{
	gint result;
	gint _tmp0_;
#line 56 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 56 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_depth;
#line 56 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 56 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 3508 "page.c"
}


static void
page_set_depth (Page* self,
                gint value)
{
#line 56 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 56 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_depth = value;
#line 3520 "page.c"
}


const gchar*
page_get_color_profile (Page* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 59 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 59 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_color_profile;
#line 59 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 59 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 3537 "page.c"
}


void
page_set_color_profile (Page* self,
                        const gchar* value)
{
	gchar* _tmp0_;
#line 59 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 59 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = g_strdup (value);
#line 59 "/home/bob/git/simple-scan/src/page.vala"
	_g_free0 (self->priv->_color_profile);
#line 59 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_color_profile = _tmp0_;
#line 3554 "page.c"
}


gint
page_get_scan_width (Page* self)
{
	gint result;
	gint _tmp0_;
#line 62 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 62 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_scan_width;
#line 62 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 62 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 3571 "page.c"
}


static void
page_set_scan_width (Page* self,
                     gint value)
{
#line 62 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 62 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_scan_width = value;
#line 3583 "page.c"
}


gint
page_get_scan_height (Page* self)
{
	gint result;
	gint _tmp0_;
#line 65 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 65 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_scan_height;
#line 65 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 65 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 3600 "page.c"
}


static void
page_set_scan_height (Page* self,
                      gint value)
{
#line 65 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_scan_height = value;
#line 3612 "page.c"
}


gint
page_get_rowstride (Page* self)
{
	gint result;
	gint _tmp0_;
#line 68 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 68 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_rowstride;
#line 68 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 68 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 3629 "page.c"
}


static void
page_set_rowstride (Page* self,
                    gint value)
{
#line 68 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_rowstride = value;
#line 3641 "page.c"
}


gint
page_get_n_channels (Page* self)
{
	gint result;
	gint _tmp0_;
#line 71 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 71 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_n_channels;
#line 71 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 71 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 3658 "page.c"
}


static void
page_set_n_channels (Page* self,
                     gint value)
{
#line 71 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 71 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_n_channels = value;
#line 3670 "page.c"
}


gboolean
page_get_is_scanning (Page* self)
{
	gboolean result;
	gboolean _tmp0_;
#line 77 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 77 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_is_scanning;
#line 77 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 77 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 3687 "page.c"
}


static void
page_set_is_scanning (Page* self,
                      gboolean value)
{
#line 77 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_is_scanning = value;
#line 3699 "page.c"
}


gboolean
page_get_has_data (Page* self)
{
	gboolean result;
	gboolean _tmp0_;
#line 80 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 80 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_has_data;
#line 80 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 80 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 3716 "page.c"
}


static void
page_set_has_data (Page* self,
                   gboolean value)
{
#line 80 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 80 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_has_data = value;
#line 3728 "page.c"
}


gint
page_get_scan_line (Page* self)
{
	gint result;
	gint _tmp0_;
#line 83 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 83 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_scan_line;
#line 83 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 83 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 3745 "page.c"
}


static void
page_set_scan_line (Page* self,
                    gint value)
{
#line 83 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_scan_line = value;
#line 3757 "page.c"
}


gboolean
page_get_is_color (Page* self)
{
	gboolean result;
	gint _tmp0_;
#line 86 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 86 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_n_channels;
#line 86 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_ > 1;
#line 86 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 3774 "page.c"
}


ScanDirection
page_get_scan_direction (Page* self)
{
	ScanDirection result;
	ScanDirection _tmp0_;
#line 92 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 92 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->scan_direction_;
#line 92 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 92 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 3791 "page.c"
}


void
page_set_scan_direction (Page* self,
                         ScanDirection value)
{
	ScanDirection _tmp0_;
	gboolean size_has_changed = FALSE;
	gint left_steps = 0;
	ScanDirection _tmp1_;
	gint _tmp2_;
	gint _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp33_;
	gboolean _tmp34_;
#line 94 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 96 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->scan_direction_;
#line 96 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp0_ == value) {
#line 97 "/home/bob/git/simple-scan/src/page.vala"
		return;
#line 3816 "page.c"
	}
#line 100 "/home/bob/git/simple-scan/src/page.vala"
	size_has_changed = FALSE;
#line 101 "/home/bob/git/simple-scan/src/page.vala"
	_tmp1_ = self->priv->scan_direction_;
#line 101 "/home/bob/git/simple-scan/src/page.vala"
	left_steps = (gint) (value - _tmp1_);
#line 102 "/home/bob/git/simple-scan/src/page.vala"
	_tmp2_ = left_steps;
#line 102 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp2_ < 0) {
#line 3828 "page.c"
		gint _tmp3_;
#line 103 "/home/bob/git/simple-scan/src/page.vala"
		_tmp3_ = left_steps;
#line 103 "/home/bob/git/simple-scan/src/page.vala"
		left_steps = _tmp3_ + 4;
#line 3834 "page.c"
	}
#line 104 "/home/bob/git/simple-scan/src/page.vala"
	_tmp4_ = left_steps;
#line 104 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp4_ != 2) {
#line 105 "/home/bob/git/simple-scan/src/page.vala"
		size_has_changed = TRUE;
#line 3842 "page.c"
	}
#line 108 "/home/bob/git/simple-scan/src/page.vala"
	_tmp5_ = self->priv->_has_crop;
#line 108 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp5_) {
#line 3848 "page.c"
		gint _tmp6_;
#line 110 "/home/bob/git/simple-scan/src/page.vala"
		_tmp6_ = left_steps;
#line 110 "/home/bob/git/simple-scan/src/page.vala"
		switch (_tmp6_) {
#line 110 "/home/bob/git/simple-scan/src/page.vala"
			case 1:
#line 3856 "page.c"
			{
				gint t = 0;
				gint _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
#line 114 "/home/bob/git/simple-scan/src/page.vala"
				_tmp7_ = self->priv->_crop_x;
#line 114 "/home/bob/git/simple-scan/src/page.vala"
				t = _tmp7_;
#line 115 "/home/bob/git/simple-scan/src/page.vala"
				_tmp8_ = self->priv->_crop_y;
#line 115 "/home/bob/git/simple-scan/src/page.vala"
				page_set_crop_x (self, _tmp8_);
#line 116 "/home/bob/git/simple-scan/src/page.vala"
				_tmp9_ = page_get_width (self);
#line 116 "/home/bob/git/simple-scan/src/page.vala"
				_tmp10_ = _tmp9_;
#line 116 "/home/bob/git/simple-scan/src/page.vala"
				_tmp11_ = t;
#line 116 "/home/bob/git/simple-scan/src/page.vala"
				_tmp12_ = self->priv->_crop_width;
#line 116 "/home/bob/git/simple-scan/src/page.vala"
				page_set_crop_y (self, _tmp10_ - (_tmp11_ + _tmp12_));
#line 117 "/home/bob/git/simple-scan/src/page.vala"
				_tmp13_ = self->priv->_crop_width;
#line 117 "/home/bob/git/simple-scan/src/page.vala"
				t = _tmp13_;
#line 118 "/home/bob/git/simple-scan/src/page.vala"
				_tmp14_ = self->priv->_crop_height;
#line 118 "/home/bob/git/simple-scan/src/page.vala"
				page_set_crop_width (self, _tmp14_);
#line 119 "/home/bob/git/simple-scan/src/page.vala"
				_tmp15_ = t;
#line 119 "/home/bob/git/simple-scan/src/page.vala"
				page_set_crop_height (self, _tmp15_);
#line 120 "/home/bob/git/simple-scan/src/page.vala"
				break;
#line 3900 "page.c"
			}
#line 110 "/home/bob/git/simple-scan/src/page.vala"
			case 2:
#line 3904 "page.c"
			{
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
#line 123 "/home/bob/git/simple-scan/src/page.vala"
				_tmp16_ = page_get_width (self);
#line 123 "/home/bob/git/simple-scan/src/page.vala"
				_tmp17_ = _tmp16_;
#line 123 "/home/bob/git/simple-scan/src/page.vala"
				_tmp18_ = self->priv->_crop_x;
#line 123 "/home/bob/git/simple-scan/src/page.vala"
				_tmp19_ = self->priv->_crop_width;
#line 123 "/home/bob/git/simple-scan/src/page.vala"
				page_set_crop_x (self, _tmp17_ - (_tmp18_ + _tmp19_));
#line 124 "/home/bob/git/simple-scan/src/page.vala"
				_tmp20_ = page_get_width (self);
#line 124 "/home/bob/git/simple-scan/src/page.vala"
				_tmp21_ = _tmp20_;
#line 124 "/home/bob/git/simple-scan/src/page.vala"
				_tmp22_ = self->priv->_crop_y;
#line 124 "/home/bob/git/simple-scan/src/page.vala"
				_tmp23_ = self->priv->_crop_height;
#line 124 "/home/bob/git/simple-scan/src/page.vala"
				page_set_crop_y (self, _tmp21_ - (_tmp22_ + _tmp23_));
#line 125 "/home/bob/git/simple-scan/src/page.vala"
				break;
#line 3936 "page.c"
			}
#line 110 "/home/bob/git/simple-scan/src/page.vala"
			case 3:
#line 3940 "page.c"
			{
				gint t = 0;
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
#line 128 "/home/bob/git/simple-scan/src/page.vala"
				_tmp24_ = self->priv->_crop_y;
#line 128 "/home/bob/git/simple-scan/src/page.vala"
				t = _tmp24_;
#line 129 "/home/bob/git/simple-scan/src/page.vala"
				_tmp25_ = self->priv->_crop_x;
#line 129 "/home/bob/git/simple-scan/src/page.vala"
				page_set_crop_y (self, _tmp25_);
#line 130 "/home/bob/git/simple-scan/src/page.vala"
				_tmp26_ = page_get_height (self);
#line 130 "/home/bob/git/simple-scan/src/page.vala"
				_tmp27_ = _tmp26_;
#line 130 "/home/bob/git/simple-scan/src/page.vala"
				_tmp28_ = t;
#line 130 "/home/bob/git/simple-scan/src/page.vala"
				_tmp29_ = self->priv->_crop_height;
#line 130 "/home/bob/git/simple-scan/src/page.vala"
				page_set_crop_x (self, _tmp27_ - (_tmp28_ + _tmp29_));
#line 131 "/home/bob/git/simple-scan/src/page.vala"
				_tmp30_ = self->priv->_crop_width;
#line 131 "/home/bob/git/simple-scan/src/page.vala"
				t = _tmp30_;
#line 132 "/home/bob/git/simple-scan/src/page.vala"
				_tmp31_ = self->priv->_crop_height;
#line 132 "/home/bob/git/simple-scan/src/page.vala"
				page_set_crop_width (self, _tmp31_);
#line 133 "/home/bob/git/simple-scan/src/page.vala"
				_tmp32_ = t;
#line 133 "/home/bob/git/simple-scan/src/page.vala"
				page_set_crop_height (self, _tmp32_);
#line 134 "/home/bob/git/simple-scan/src/page.vala"
				break;
#line 3984 "page.c"
			}
			default:
#line 110 "/home/bob/git/simple-scan/src/page.vala"
			break;
#line 3989 "page.c"
		}
	}
#line 138 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->scan_direction_ = value;
#line 139 "/home/bob/git/simple-scan/src/page.vala"
	_tmp33_ = size_has_changed;
#line 139 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp33_) {
#line 140 "/home/bob/git/simple-scan/src/page.vala"
		g_signal_emit (self, page_signals[PAGE_SIZE_CHANGED_SIGNAL], 0);
#line 4000 "page.c"
	}
#line 141 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_emit (self, page_signals[PAGE_SCAN_DIRECTION_CHANGED_SIGNAL], 0);
#line 142 "/home/bob/git/simple-scan/src/page.vala"
	_tmp34_ = self->priv->_has_crop;
#line 142 "/home/bob/git/simple-scan/src/page.vala"
	if (_tmp34_) {
#line 143 "/home/bob/git/simple-scan/src/page.vala"
		g_signal_emit (self, page_signals[PAGE_CROP_CHANGED_SIGNAL], 0);
#line 4010 "page.c"
	}
}


gboolean
page_get_has_crop (Page* self)
{
	gboolean result;
	gboolean _tmp0_;
#line 148 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 148 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_has_crop;
#line 148 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 148 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 4028 "page.c"
}


static void
page_set_has_crop (Page* self,
                   gboolean value)
{
#line 148 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 148 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_has_crop = value;
#line 4040 "page.c"
}


const gchar*
page_get_crop_name (Page* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 151 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 151 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_crop_name;
#line 151 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 151 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 4057 "page.c"
}


static void
page_set_crop_name (Page* self,
                    const gchar* value)
{
	gchar* _tmp0_;
#line 151 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 151 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = g_strdup (value);
#line 151 "/home/bob/git/simple-scan/src/page.vala"
	_g_free0 (self->priv->_crop_name);
#line 151 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_crop_name = _tmp0_;
#line 4074 "page.c"
}


gint
page_get_crop_x (Page* self)
{
	gint result;
	gint _tmp0_;
#line 154 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 154 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_crop_x;
#line 154 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 154 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 4091 "page.c"
}


static void
page_set_crop_x (Page* self,
                 gint value)
{
#line 154 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 154 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_crop_x = value;
#line 4103 "page.c"
}


gint
page_get_crop_y (Page* self)
{
	gint result;
	gint _tmp0_;
#line 157 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 157 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_crop_y;
#line 157 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 157 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 4120 "page.c"
}


static void
page_set_crop_y (Page* self,
                 gint value)
{
#line 157 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 157 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_crop_y = value;
#line 4132 "page.c"
}


gint
page_get_crop_width (Page* self)
{
	gint result;
	gint _tmp0_;
#line 160 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 160 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_crop_width;
#line 160 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 160 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 4149 "page.c"
}


static void
page_set_crop_width (Page* self,
                     gint value)
{
#line 160 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 160 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_crop_width = value;
#line 4161 "page.c"
}


gint
page_get_crop_height (Page* self)
{
	gint result;
	gint _tmp0_;
#line 163 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 163 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->priv->_crop_height;
#line 163 "/home/bob/git/simple-scan/src/page.vala"
	result = _tmp0_;
#line 163 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 4178 "page.c"
}


static void
page_set_crop_height (Page* self,
                      gint value)
{
#line 163 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 163 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->_crop_height = value;
#line 4190 "page.c"
}


static void
value_page_init (GValue* value)
{
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	value->data[0].v_pointer = NULL;
#line 4199 "page.c"
}


static void
value_page_free_value (GValue* value)
{
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	if (value->data[0].v_pointer) {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		page_unref (value->data[0].v_pointer);
#line 4210 "page.c"
	}
}


static void
value_page_copy_value (const GValue* src_value,
                       GValue* dest_value)
{
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		dest_value->data[0].v_pointer = page_ref (src_value->data[0].v_pointer);
#line 4223 "page.c"
	} else {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4227 "page.c"
	}
}


static gpointer
value_page_peek_pointer (const GValue* value)
{
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	return value->data[0].v_pointer;
#line 4237 "page.c"
}


static gchar*
value_page_collect_value (GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	if (collect_values[0].v_pointer) {
#line 4249 "page.c"
		Page * object;
		object = collect_values[0].v_pointer;
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4256 "page.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4260 "page.c"
		}
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		value->data[0].v_pointer = page_ref (object);
#line 4264 "page.c"
	} else {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4268 "page.c"
	}
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	return NULL;
#line 4272 "page.c"
}


static gchar*
value_page_lcopy_value (const GValue* value,
                        guint n_collect_values,
                        GTypeCValue* collect_values,
                        guint collect_flags)
{
	Page ** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	if (!object_p) {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4288 "page.c"
	}
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	if (!value->data[0].v_pointer) {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		*object_p = NULL;
#line 4294 "page.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		*object_p = value->data[0].v_pointer;
#line 4298 "page.c"
	} else {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		*object_p = page_ref (value->data[0].v_pointer);
#line 4302 "page.c"
	}
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	return NULL;
#line 4306 "page.c"
}


GParamSpec*
param_spec_page (const gchar* name,
                 const gchar* nick,
                 const gchar* blurb,
                 GType object_type,
                 GParamFlags flags)
{
	ParamSpecPage* spec;
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PAGE), NULL);
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	return G_PARAM_SPEC (spec);
#line 4326 "page.c"
}


gpointer
value_get_page (const GValue* value)
{
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE), NULL);
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	return value->data[0].v_pointer;
#line 4337 "page.c"
}


void
value_set_page (GValue* value,
                gpointer v_object)
{
	Page * old;
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE));
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	if (v_object) {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE));
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		page_ref (value->data[0].v_pointer);
#line 4360 "page.c"
	} else {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4364 "page.c"
	}
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	if (old) {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		page_unref (old);
#line 4370 "page.c"
	}
}


void
value_take_page (GValue* value,
                 gpointer v_object)
{
	Page * old;
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE));
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	if (v_object) {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE));
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 4392 "page.c"
	} else {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4396 "page.c"
	}
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	if (old) {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		page_unref (old);
#line 4402 "page.c"
	}
}


static void
page_class_init (PageClass * klass)
{
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	page_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	((PageClass *) klass)->finalize = page_finalize;
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	g_type_class_add_private (klass, sizeof (PagePrivate));
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	page_signals[PAGE_PIXELS_CHANGED_SIGNAL] = g_signal_new ("pixels-changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	page_signals[PAGE_SIZE_CHANGED_SIGNAL] = g_signal_new ("size-changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	page_signals[PAGE_SCAN_LINE_CHANGED_SIGNAL] = g_signal_new ("scan-line-changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	page_signals[PAGE_SCAN_DIRECTION_CHANGED_SIGNAL] = g_signal_new ("scan-direction-changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	page_signals[PAGE_CROP_CHANGED_SIGNAL] = g_signal_new ("crop-changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	page_signals[PAGE_SCAN_FINISHED_SIGNAL] = g_signal_new ("scan-finished", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 4428 "page.c"
}


static void
page_instance_init (Page * self)
{
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	self->priv = PAGE_GET_PRIVATE (self);
#line 89 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->scan_direction_ = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	self->ref_count = 1;
#line 4441 "page.c"
}


static void
page_finalize (Page * obj)
{
	Page * self;
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE, Page);
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_handlers_destroy (self);
#line 59 "/home/bob/git/simple-scan/src/page.vala"
	_g_free0 (self->priv->_color_profile);
#line 74 "/home/bob/git/simple-scan/src/page.vala"
	self->priv->pixels = (g_free (self->priv->pixels), NULL);
#line 151 "/home/bob/git/simple-scan/src/page.vala"
	_g_free0 (self->priv->_crop_name);
#line 4459 "page.c"
}


GType
page_get_type (void)
{
	static volatile gsize page_type_id__volatile = 0;
	if (g_once_init_enter (&page_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_page_init, value_page_free_value, value_page_copy_value, value_page_peek_pointer, "p", value_page_collect_value, "p", value_page_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Page), 0, (GInstanceInitFunc) page_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType page_type_id;
		page_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Page", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&page_type_id__volatile, page_type_id);
	}
	return page_type_id__volatile;
}


gpointer
page_ref (gpointer instance)
{
	Page * self;
	self = instance;
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	return instance;
#line 4488 "page.c"
}


void
page_unref (gpointer instance)
{
	Page * self;
	self = instance;
#line 20 "/home/bob/git/simple-scan/src/page.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		PAGE_GET_CLASS (self)->finalize (self);
#line 20 "/home/bob/git/simple-scan/src/page.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4503 "page.c"
	}
}


PixbufWriter*
pixbuf_writer_construct (GType object_type,
                         GFileOutputStream* stream)
{
	PixbufWriter* self = NULL;
	GFileOutputStream* _tmp0_;
#line 694 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 694 "/home/bob/git/simple-scan/src/page.vala"
	self = (PixbufWriter*) g_type_create_instance (object_type);
#line 696 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = _g_object_ref0 (stream);
#line 696 "/home/bob/git/simple-scan/src/page.vala"
	_g_object_unref0 (self->stream);
#line 696 "/home/bob/git/simple-scan/src/page.vala"
	self->stream = _tmp0_;
#line 694 "/home/bob/git/simple-scan/src/page.vala"
	return self;
#line 4526 "page.c"
}


PixbufWriter*
pixbuf_writer_new (GFileOutputStream* stream)
{
#line 694 "/home/bob/git/simple-scan/src/page.vala"
	return pixbuf_writer_construct (TYPE_PIXBUF_WRITER, stream);
#line 4535 "page.c"
}


static gboolean
_pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf,
                                                       gsize buf_length1,
                                                       GError** error,
                                                       gpointer self)
{
	gboolean result;
	result = pixbuf_writer_write_pixbuf_data ((PixbufWriter*) self, buf, buf_length1, error);
#line 701 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 4549 "page.c"
}


void
pixbuf_writer_save (PixbufWriter* self,
                    GdkPixbuf* image,
                    const gchar* type,
                    gchar** option_keys,
                    int option_keys_length1,
                    gchar** option_values,
                    int option_values_length1,
                    GError** error)
{
	GError * _inner_error_ = NULL;
#line 699 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (self != NULL);
#line 699 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (image != NULL);
#line 699 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (type != NULL);
#line 701 "/home/bob/git/simple-scan/src/page.vala"
	gdk_pixbuf_save_to_callbackv (image, _pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func, self, type, option_keys, option_values, &_inner_error_);
#line 701 "/home/bob/git/simple-scan/src/page.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 701 "/home/bob/git/simple-scan/src/page.vala"
		g_propagate_error (error, _inner_error_);
#line 701 "/home/bob/git/simple-scan/src/page.vala"
		return;
#line 4578 "page.c"
	}
}


static gboolean
pixbuf_writer_write_pixbuf_data (PixbufWriter* self,
                                 guint8* buf,
                                 int buf_length1,
                                 GError** error)
{
	gboolean result = FALSE;
	GFileOutputStream* _tmp0_;
	GError * _inner_error_ = NULL;
#line 704 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 706 "/home/bob/git/simple-scan/src/page.vala"
	_tmp0_ = self->stream;
#line 706 "/home/bob/git/simple-scan/src/page.vala"
	g_output_stream_write_all ((GOutputStream*) _tmp0_, buf, (gsize) buf_length1, NULL, NULL, &_inner_error_);
#line 706 "/home/bob/git/simple-scan/src/page.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4600 "page.c"
		gboolean _tmp1_ = FALSE;
#line 706 "/home/bob/git/simple-scan/src/page.vala"
		g_propagate_error (error, _inner_error_);
#line 706 "/home/bob/git/simple-scan/src/page.vala"
		return _tmp1_;
#line 4606 "page.c"
	}
#line 707 "/home/bob/git/simple-scan/src/page.vala"
	result = TRUE;
#line 707 "/home/bob/git/simple-scan/src/page.vala"
	return result;
#line 4612 "page.c"
}


static void
value_pixbuf_writer_init (GValue* value)
{
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	value->data[0].v_pointer = NULL;
#line 4621 "page.c"
}


static void
value_pixbuf_writer_free_value (GValue* value)
{
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	if (value->data[0].v_pointer) {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		pixbuf_writer_unref (value->data[0].v_pointer);
#line 4632 "page.c"
	}
}


static void
value_pixbuf_writer_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	if (src_value->data[0].v_pointer) {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		dest_value->data[0].v_pointer = pixbuf_writer_ref (src_value->data[0].v_pointer);
#line 4645 "page.c"
	} else {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4649 "page.c"
	}
}


static gpointer
value_pixbuf_writer_peek_pointer (const GValue* value)
{
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	return value->data[0].v_pointer;
#line 4659 "page.c"
}


static gchar*
value_pixbuf_writer_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	if (collect_values[0].v_pointer) {
#line 4671 "page.c"
		PixbufWriter * object;
		object = collect_values[0].v_pointer;
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		if (object->parent_instance.g_class == NULL) {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4678 "page.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4682 "page.c"
		}
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		value->data[0].v_pointer = pixbuf_writer_ref (object);
#line 4686 "page.c"
	} else {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4690 "page.c"
	}
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	return NULL;
#line 4694 "page.c"
}


static gchar*
value_pixbuf_writer_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	PixbufWriter ** object_p;
	object_p = collect_values[0].v_pointer;
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	if (!object_p) {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4710 "page.c"
	}
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	if (!value->data[0].v_pointer) {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		*object_p = NULL;
#line 4716 "page.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		*object_p = value->data[0].v_pointer;
#line 4720 "page.c"
	} else {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		*object_p = pixbuf_writer_ref (value->data[0].v_pointer);
#line 4724 "page.c"
	}
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	return NULL;
#line 4728 "page.c"
}


GParamSpec*
param_spec_pixbuf_writer (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecPixbufWriter* spec;
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIXBUF_WRITER), NULL);
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	return G_PARAM_SPEC (spec);
#line 4748 "page.c"
}


gpointer
value_get_pixbuf_writer (const GValue* value)
{
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER), NULL);
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	return value->data[0].v_pointer;
#line 4759 "page.c"
}


void
value_set_pixbuf_writer (GValue* value,
                         gpointer v_object)
{
	PixbufWriter * old;
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER));
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	old = value->data[0].v_pointer;
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	if (v_object) {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXBUF_WRITER));
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		pixbuf_writer_ref (value->data[0].v_pointer);
#line 4782 "page.c"
	} else {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4786 "page.c"
	}
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	if (old) {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		pixbuf_writer_unref (old);
#line 4792 "page.c"
	}
}


void
value_take_pixbuf_writer (GValue* value,
                          gpointer v_object)
{
	PixbufWriter * old;
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER));
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	old = value->data[0].v_pointer;
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	if (v_object) {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXBUF_WRITER));
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 4814 "page.c"
	} else {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4818 "page.c"
	}
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	if (old) {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		pixbuf_writer_unref (old);
#line 4824 "page.c"
	}
}


static void
pixbuf_writer_class_init (PixbufWriterClass * klass)
{
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	pixbuf_writer_parent_class = g_type_class_peek_parent (klass);
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	((PixbufWriterClass *) klass)->finalize = pixbuf_writer_finalize;
#line 4836 "page.c"
}


static void
pixbuf_writer_instance_init (PixbufWriter * self)
{
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	self->ref_count = 1;
#line 4845 "page.c"
}


static void
pixbuf_writer_finalize (PixbufWriter * obj)
{
	PixbufWriter * self;
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXBUF_WRITER, PixbufWriter);
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	g_signal_handlers_destroy (self);
#line 692 "/home/bob/git/simple-scan/src/page.vala"
	_g_object_unref0 (self->stream);
#line 4859 "page.c"
}


GType
pixbuf_writer_get_type (void)
{
	static volatile gsize pixbuf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pixbuf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pixbuf_writer_init, value_pixbuf_writer_free_value, value_pixbuf_writer_copy_value, value_pixbuf_writer_peek_pointer, "p", value_pixbuf_writer_collect_value, "p", value_pixbuf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PixbufWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufWriter), 0, (GInstanceInitFunc) pixbuf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pixbuf_writer_type_id;
		pixbuf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PixbufWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pixbuf_writer_type_id__volatile, pixbuf_writer_type_id);
	}
	return pixbuf_writer_type_id__volatile;
}


gpointer
pixbuf_writer_ref (gpointer instance)
{
	PixbufWriter * self;
	self = instance;
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	g_atomic_int_inc (&self->ref_count);
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	return instance;
#line 4888 "page.c"
}


void
pixbuf_writer_unref (gpointer instance)
{
	PixbufWriter * self;
	self = instance;
#line 690 "/home/bob/git/simple-scan/src/page.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		PIXBUF_WRITER_GET_CLASS (self)->finalize (self);
#line 690 "/home/bob/git/simple-scan/src/page.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4903 "page.c"
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



