/* book.c generated by valac 0.24.0, the Vala compiler
 * generated from book.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-ps.h>
#include <zlib.h>
#include "jpeglib.h"
#include "config.h"
#include <gobject/gvaluecollector.h>


#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
typedef struct _BookPrivate BookPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define __g_list_free__page_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__page_unref0_ (var), NULL)))

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_PS_WRITER (ps_writer_get_type ())
#define PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PS_WRITER, PsWriter))
#define PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PS_WRITER, PsWriterClass))
#define IS_PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PS_WRITER))
#define IS_PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PS_WRITER))
#define PS_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PS_WRITER, PsWriterClass))

typedef struct _PsWriter PsWriter;
typedef struct _PsWriterClass PsWriterClass;
typedef struct _PsWriterPrivate PsWriterPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _ps_writer_unref0(var) ((var == NULL) ? NULL : (var = (ps_writer_unref (var), NULL)))

#define TYPE_PDF_WRITER (pdf_writer_get_type ())
#define PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PDF_WRITER, PDFWriter))
#define PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PDF_WRITER, PDFWriterClass))
#define IS_PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PDF_WRITER))
#define IS_PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PDF_WRITER))
#define PDF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PDF_WRITER, PDFWriterClass))

typedef struct _PDFWriter PDFWriter;
typedef struct _PDFWriterClass PDFWriterClass;
typedef struct _PDFWriterPrivate PDFWriterPrivate;
#define _pdf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pdf_writer_unref (var), NULL)))
typedef struct _ParamSpecBook ParamSpecBook;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecPDFWriter ParamSpecPDFWriter;
typedef struct _ParamSpecPsWriter ParamSpecPsWriter;

struct _Book {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookPrivate * priv;
};

struct _BookClass {
	GTypeClass parent_class;
	void (*finalize) (Book *self);
};

struct _BookPrivate {
	GList* pages;
	gboolean needs_saving;
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _PsWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PsWriterPrivate * priv;
	cairo_surface_t* surface;
	GFileOutputStream* stream;
};

struct _PsWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PsWriter *self);
};

struct _PDFWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PDFWriterPrivate * priv;
	gsize offset;
	GList* object_offsets;
};

struct _PDFWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PDFWriter *self);
};

struct _ParamSpecBook {
	GParamSpec parent_instance;
};

struct _PDFWriterPrivate {
	GFileOutputStream* stream;
};

struct _ParamSpecPDFWriter {
	GParamSpec parent_instance;
};

struct _ParamSpecPsWriter {
	GParamSpec parent_instance;
};


static gpointer book_parent_class = NULL;
static gpointer pdf_writer_parent_class = NULL;
static gpointer ps_writer_parent_class = NULL;

gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define BOOK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOK, BookPrivate))
enum  {
	BOOK_DUMMY_PROPERTY
};
static void book_page_changed_cb (Book* self, Page* page);
static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self);
static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self);
static void _page_unref0_ (gpointer var);
static void _g_list_free__page_unref0_ (GList* self);
Book* book_new (void);
Book* book_construct (GType object_type);
void book_clear (Book* self);
void book_set_needs_saving (Book* self, gboolean needs_saving);
GType scan_direction_get_type (void) G_GNUC_CONST;
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction);
void book_move_page (Book* self, Page* page, guint location);
void book_delete_page (Book* self, Page* page);
guint book_get_n_pages (Book* self);
Page* book_get_page (Book* self, gint page_number);
guint book_get_page_index (Book* self, Page* page);
static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i);
static void book_save_multi_file (Book* self, const gchar* type, GFile* file, GError** error);
void page_save (Page* self, const gchar* type, GFile* file, GError** error);
static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi);
static void book_save_ps (Book* self, GFile* file, GError** error);
gpointer ps_writer_ref (gpointer instance);
void ps_writer_unref (gpointer instance);
GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ps_writer (GValue* value, gpointer v_object);
void value_take_ps_writer (GValue* value, gpointer v_object);
gpointer value_get_ps_writer (const GValue* value);
GType ps_writer_get_type (void) G_GNUC_CONST;
PsWriter* ps_writer_new (GFileOutputStream* stream);
PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
gint page_get_dpi (Page* self);
static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1);
static void book_jpeg_init_cb (struct jpeg_compress_struct* info);
static gboolean book_jpeg_empty_cb (struct jpeg_compress_struct* info);
static void book_jpeg_term_cb (struct jpeg_compress_struct* info);
static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gsize* n_written, int* result_length1);
static void _book_jpeg_init_cb_jpeg_initdestinationfunc (struct jpeg_compress_struct* cinfo);
static gboolean _book_jpeg_empty_cb_jpeg_emptyoutputbufferfunc (struct jpeg_compress_struct* cinfo);
static void _book_jpeg_term_cb_jpeg_termdestinationfunc (struct jpeg_compress_struct* cinfo);
static void book_save_pdf (Book* self, GFile* file, GError** error);
gpointer pdf_writer_ref (gpointer instance);
void pdf_writer_unref (gpointer instance);
GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pdf_writer (GValue* value, gpointer v_object);
void value_take_pdf_writer (GValue* value, gpointer v_object);
gpointer value_get_pdf_writer (const GValue* value);
GType pdf_writer_get_type (void) G_GNUC_CONST;
PDFWriter* pdf_writer_new (GFileOutputStream* stream);
PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream);
void pdf_writer_write_string (PDFWriter* self, const gchar* text);
guint pdf_writer_start_object (PDFWriter* self);
gboolean page_is_color (Page* self);
gint page_get_depth (Page* self);
static guint8* _vala_array_dup1 (guint8* self, int length);
static guint8* _vala_array_dup2 (guint8* self, int length);
void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1);
void book_save (Book* self, const gchar* type, GFile* file, GError** error);
gboolean book_get_needs_saving (Book* self);
static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void book_finalize (Book* obj);
#define PDF_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PDF_WRITER, PDFWriterPrivate))
enum  {
	PDF_WRITER_DUMMY_PROPERTY
};
static void pdf_writer_finalize (PDFWriter* obj);
enum  {
	PS_WRITER_DUMMY_PROPERTY
};
static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1);
static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1);
static void ps_writer_finalize (PsWriter* obj);


static gpointer _page_ref0 (gpointer self) {
#line 31 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return self ? page_ref (self) : NULL;
#line 258 "book.c"
}


static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self) {
#line 33 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	book_page_changed_cb ((Book*) self, _sender);
#line 265 "book.c"
}


static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self) {
#line 34 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	book_page_changed_cb ((Book*) self, _sender);
#line 272 "book.c"
}


static void _page_unref0_ (gpointer var) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
#line 279 "book.c"
}


static void _g_list_free__page_unref0_ (GList* self) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_list_foreach (self, (GFunc) _page_unref0_, NULL);
#line 14 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_list_free (self);
#line 288 "book.c"
}


Book* book_construct (GType object_type) {
	Book* self = NULL;
#line 24 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self = (Book*) g_type_create_instance (object_type);
#line 26 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 26 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->priv->pages = NULL;
#line 24 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return self;
#line 302 "book.c"
}


Book* book_new (void) {
#line 24 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return book_construct (TYPE_BOOK);
#line 309 "book.c"
}


void book_clear (Book* self) {
	GList* _tmp0_ = NULL;
#line 38 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (self != NULL);
#line 40 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 319 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 40 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		page_collection = _tmp0_;
#line 40 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 327 "book.c"
			Page* _tmp1_ = NULL;
			Page* page = NULL;
#line 40 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 40 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			page = _tmp1_;
#line 334 "book.c"
			{
				Page* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
				Page* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
#line 42 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp2_ = page;
#line 42 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 42 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 43 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp4_ = page;
#line 43 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 43 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 40 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_page_unref0 (page);
#line 354 "book.c"
			}
		}
	}
#line 45 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 45 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->priv->pages = NULL;
#line 46 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_emit_by_name (self, "cleared");
#line 364 "book.c"
}


static void book_page_changed_cb (Book* self, Page* page) {
#line 49 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (self != NULL);
#line 49 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (page != NULL);
#line 51 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 375 "book.c"
}


Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction) {
	Page* result = NULL;
	Page* page = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ScanDirection _tmp3_ = 0;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 54 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = width;
#line 56 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp1_ = height;
#line 56 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp2_ = dpi;
#line 56 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp3_ = scan_direction;
#line 56 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp4_ = page_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 56 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	page = _tmp4_;
#line 57 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_connect (page, "pixels-changed", (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 58 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_connect (page, "crop-changed", (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 60 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp5_ = _page_ref0 (page);
#line 60 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->priv->pages = g_list_append (self->priv->pages, _tmp5_);
#line 61 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_emit_by_name (self, "page-added", page);
#line 62 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 64 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	result = page;
#line 64 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return result;
#line 418 "book.c"
}


void book_move_page (Book* self, Page* page, guint location) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 67 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (self != NULL);
#line 67 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (page != NULL);
#line 69 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = page;
#line 69 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, _tmp0_);
#line 70 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp1_ = page;
#line 70 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp2_ = _page_ref0 (_tmp1_);
#line 70 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp3_ = location;
#line 70 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->priv->pages = g_list_insert (self->priv->pages, _tmp2_, (gint) _tmp3_);
#line 71 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_emit_by_name (self, "reordered");
#line 72 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 447 "book.c"
}


void book_delete_page (Book* self, Page* page) {
	Page* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (self != NULL);
#line 75 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (page != NULL);
#line 77 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = page;
#line 77 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 77 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 78 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp2_ = page;
#line 78 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 78 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 79 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp4_ = page;
#line 79 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_emit_by_name (self, "page-removed", _tmp4_);
#line 80 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp5_ = page;
#line 80 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, _tmp5_);
#line 81 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 484 "book.c"
}


guint book_get_n_pages (Book* self) {
	guint result = 0U;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 84 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 86 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 86 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 86 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	result = _tmp1_;
#line 86 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return result;
#line 502 "book.c"
}


Page* book_get_page (Book* self, gint page_number) {
	Page* result = NULL;
	gint _tmp0_ = 0;
	GList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gconstpointer _tmp6_ = NULL;
	Page* _tmp7_ = NULL;
#line 89 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 91 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = page_number;
#line 91 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (_tmp0_ < 0) {
#line 519 "book.c"
		GList* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		gint _tmp3_ = 0;
#line 92 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp1_ = self->priv->pages;
#line 92 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp2_ = g_list_length (_tmp1_);
#line 92 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp3_ = page_number;
#line 92 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		page_number = ((gint) _tmp2_) + _tmp3_;
#line 531 "book.c"
	}
#line 93 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp4_ = self->priv->pages;
#line 93 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp5_ = page_number;
#line 93 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp6_ = g_list_nth_data (_tmp4_, (guint) _tmp5_);
#line 93 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp7_ = _page_ref0 ((Page*) _tmp6_);
#line 93 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	result = _tmp7_;
#line 93 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return result;
#line 545 "book.c"
}


guint book_get_page_index (Book* self, Page* page) {
	guint result = 0U;
	GList* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 96 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 96 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (page != NULL, 0U);
#line 98 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 98 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp1_ = page;
#line 98 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp2_ = g_list_index (_tmp0_, _tmp1_);
#line 98 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	result = (guint) _tmp2_;
#line 98 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return result;
#line 568 "book.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 930 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 931 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 931 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 931 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 931 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 933 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 933 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 593 "book.c"
		gchar* _tmp4_ = NULL;
#line 934 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 934 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 934 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 601 "book.c"
	} else {
#line 936 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		result = -1;
#line 936 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 607 "book.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1226 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1227 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1227 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1227 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1228 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1228 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 641 "book.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1229 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1229 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1229 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 650 "book.c"
	}
#line 1231 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1231 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 656 "book.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1232 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1232 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1232 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 665 "book.c"
	}
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 671 "book.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 680 "book.c"
	} else {
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 684 "book.c"
	}
#line 1234 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 692 "book.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 701 "book.c"
	} else {
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 705 "book.c"
	}
#line 1235 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1236 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1236 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1236 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1237 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 727 "book.c"
}


static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i) {
	GFile* result = NULL;
	guint _tmp0_ = 0U;
	gchar* basename = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* prefix = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* suffix = NULL;
	gchar* _tmp7_ = NULL;
	gint extension_index = 0;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	const gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GFile* _tmp30_ = NULL;
	GFile* _tmp31_ = NULL;
#line 101 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 101 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 103 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = book_get_n_pages (self);
#line 103 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (_tmp0_ == ((guint) 1)) {
#line 761 "book.c"
		const gchar* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
#line 104 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp1_ = uri;
#line 104 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp2_ = g_file_new_for_uri (_tmp1_);
#line 104 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		result = _tmp2_;
#line 104 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		return result;
#line 772 "book.c"
	}
#line 107 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp3_ = uri;
#line 107 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp4_ = g_path_get_basename (_tmp3_);
#line 107 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	basename = _tmp4_;
#line 108 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp5_ = uri;
#line 108 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 108 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	prefix = _tmp6_;
#line 108 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp7_ = g_strdup ("");
#line 108 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	suffix = _tmp7_;
#line 109 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp8_ = basename;
#line 109 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp9_ = string_last_index_of_char (_tmp8_, (gunichar) '.', 0);
#line 109 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	extension_index = _tmp9_;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp10_ = extension_index;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (_tmp10_ >= 0) {
#line 800 "book.c"
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		const gchar* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gchar* _tmp24_ = NULL;
#line 112 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp11_ = basename;
#line 112 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp12_ = extension_index;
#line 112 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp13_ = basename;
#line 112 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp14_ = strlen (_tmp13_);
#line 112 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp15_ = _tmp14_;
#line 112 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp16_ = string_slice (_tmp11_, (glong) _tmp12_, (glong) _tmp15_);
#line 112 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_g_free0 (suffix);
#line 112 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		suffix = _tmp16_;
#line 113 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp17_ = uri;
#line 113 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp18_ = uri;
#line 113 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp19_ = strlen (_tmp18_);
#line 113 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp20_ = _tmp19_;
#line 113 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp21_ = suffix;
#line 113 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp22_ = strlen (_tmp21_);
#line 113 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp23_ = _tmp22_;
#line 113 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp24_ = string_slice (_tmp17_, (glong) 0, (glong) (_tmp20_ - _tmp23_));
#line 113 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_g_free0 (prefix);
#line 113 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		prefix = _tmp24_;
#line 851 "book.c"
	}
#line 116 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp25_ = prefix;
#line 116 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp26_ = i;
#line 116 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp27_ = suffix;
#line 116 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp28_ = g_strdup_printf ("%s-%d%s", _tmp25_, _tmp26_ + 1, _tmp27_);
#line 116 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp29_ = _tmp28_;
#line 116 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp30_ = g_file_new_for_uri (_tmp29_);
#line 116 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp31_ = _tmp30_;
#line 116 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (_tmp29_);
#line 116 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	result = _tmp31_;
#line 116 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (suffix);
#line 116 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (prefix);
#line 116 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (basename);
#line 116 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return result;
#line 879 "book.c"
}


static void book_save_multi_file (Book* self, const gchar* type, GFile* file, GError** error) {
	gint i = 0;
	GList* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 119 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (self != NULL);
#line 119 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (type != NULL);
#line 119 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (file != NULL);
#line 121 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	i = 0;
#line 122 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 897 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 122 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		page_collection = _tmp0_;
#line 122 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 905 "book.c"
			Page* _tmp1_ = NULL;
			Page* page = NULL;
#line 122 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 122 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			page = _tmp1_;
#line 912 "book.c"
			{
				Page* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				GFile* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				GFile* _tmp8_ = NULL;
				GFile* _tmp9_ = NULL;
				gint _tmp10_ = 0;
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp2_ = page;
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp3_ = type;
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp4_ = file;
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp5_ = g_file_get_uri (_tmp4_);
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp6_ = _tmp5_;
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp7_ = i;
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp8_ = book_make_indexed_file (self, _tmp6_, _tmp7_);
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp9_ = _tmp8_;
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				page_save (_tmp2_, _tmp3_, _tmp9_, &_inner_error_);
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_object_unref0 (_tmp9_);
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp6_);
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				if (_inner_error_ != NULL) {
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_page_unref0 (page);
#line 124 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					return;
#line 953 "book.c"
				}
#line 125 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp10_ = i;
#line 125 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				i = _tmp10_ + 1;
#line 122 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_page_unref0 (page);
#line 961 "book.c"
			}
		}
	}
}


static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi) {
	cairo_t* context = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GdkPixbuf* _tmp4_ = NULL;
	cairo_pattern_t* _tmp5_ = NULL;
#line 129 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (self != NULL);
#line 129 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (surface != NULL);
#line 129 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (image != NULL);
#line 131 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = surface;
#line 131 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp1_ = cairo_create (_tmp0_);
#line 131 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	context = _tmp1_;
#line 132 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp2_ = dpi;
#line 132 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp3_ = dpi;
#line 132 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	cairo_scale (context, 72.0 / _tmp2_, 72.0 / _tmp3_);
#line 133 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp4_ = image;
#line 133 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	gdk_cairo_set_source_pixbuf (context, _tmp4_, (gdouble) 0, (gdouble) 0);
#line 134 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp5_ = cairo_get_source (context);
#line 134 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	cairo_pattern_set_filter (_tmp5_, CAIRO_FILTER_BEST);
#line 135 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	cairo_paint (context);
#line 129 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_cairo_destroy0 (context);
#line 1006 "book.c"
}


static gpointer _cairo_surface_reference0 (gpointer self) {
#line 142 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return self ? cairo_surface_reference (self) : NULL;
#line 1013 "book.c"
}


static void book_save_ps (Book* self, GFile* file, GError** error) {
	GFileOutputStream* stream = NULL;
	GFile* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	PsWriter* writer = NULL;
	PsWriter* _tmp2_ = NULL;
	cairo_surface_t* surface = NULL;
	PsWriter* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	cairo_surface_t* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 138 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (self != NULL);
#line 138 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (file != NULL);
#line 140 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = file;
#line 140 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 140 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	stream = _tmp1_;
#line 140 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (_inner_error_ != NULL) {
#line 140 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 140 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		return;
#line 1045 "book.c"
	}
#line 141 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp2_ = ps_writer_new (stream);
#line 141 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	writer = _tmp2_;
#line 142 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp3_ = writer;
#line 142 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp4_ = _tmp3_->surface;
#line 142 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp5_ = _cairo_surface_reference0 (_tmp4_);
#line 142 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	surface = _tmp5_;
#line 144 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp6_ = self->priv->pages;
#line 1061 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 144 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		page_collection = _tmp6_;
#line 144 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 1069 "book.c"
			Page* _tmp7_ = NULL;
			Page* page = NULL;
#line 144 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			_tmp7_ = _page_ref0 ((Page*) page_it->data);
#line 144 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			page = _tmp7_;
#line 1076 "book.c"
			{
				GdkPixbuf* image = NULL;
				Page* _tmp8_ = NULL;
				GdkPixbuf* _tmp9_ = NULL;
				gdouble width = 0.0;
				GdkPixbuf* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				Page* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gdouble height = 0.0;
				GdkPixbuf* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				Page* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				cairo_surface_t* _tmp18_ = NULL;
				gdouble _tmp19_ = 0.0;
				gdouble _tmp20_ = 0.0;
				cairo_surface_t* _tmp21_ = NULL;
				GdkPixbuf* _tmp22_ = NULL;
				Page* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				cairo_surface_t* _tmp25_ = NULL;
#line 146 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp8_ = page;
#line 146 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp9_ = page_get_image (_tmp8_, TRUE);
#line 146 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				image = _tmp9_;
#line 147 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp10_ = image;
#line 147 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp11_ = gdk_pixbuf_get_width (_tmp10_);
#line 147 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp12_ = page;
#line 147 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp13_ = page_get_dpi (_tmp12_);
#line 147 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				width = (_tmp11_ * 72.0) / _tmp13_;
#line 148 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp14_ = image;
#line 148 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp15_ = gdk_pixbuf_get_height (_tmp14_);
#line 148 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp16_ = page;
#line 148 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp17_ = page_get_dpi (_tmp16_);
#line 148 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				height = (_tmp15_ * 72.0) / _tmp17_;
#line 149 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp18_ = surface;
#line 149 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp19_ = width;
#line 149 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp20_ = height;
#line 149 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				cairo_ps_surface_set_size (_tmp18_, _tmp19_, _tmp20_);
#line 150 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp21_ = surface;
#line 150 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp22_ = image;
#line 150 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp23_ = page;
#line 150 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp24_ = page_get_dpi (_tmp23_);
#line 150 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				book_save_ps_pdf_surface (self, _tmp21_, _tmp22_, (gdouble) _tmp24_);
#line 151 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp25_ = surface;
#line 151 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				cairo_surface_show_page (_tmp25_);
#line 144 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_object_unref0 (image);
#line 144 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_page_unref0 (page);
#line 1151 "book.c"
			}
		}
	}
#line 138 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_cairo_surface_destroy0 (surface);
#line 138 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_ps_writer_unref0 (writer);
#line 138 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_object_unref0 (stream);
#line 1161 "book.c"
}


static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1) {
	guint8* result = NULL;
	z_stream stream = {0};
	guint8* out_data = NULL;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	guint8* _tmp1_ = NULL;
	gint out_data_length1 = 0;
	gint _out_data_size_ = 0;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	z_stream _tmp7_ = {0};
	guint _tmp8_ = 0U;
	guint n_written = 0U;
	guint8* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	z_stream _tmp11_ = {0};
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	gint _tmp14_ = 0;
	guint8* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
#line 155 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 157 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	deflateInit (&stream, (gint) Z_BEST_COMPRESSION);
#line 158 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = data;
#line 158 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0__length1 = data_length1;
#line 158 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp1_ = g_new0 (guint8, _tmp0__length1);
#line 158 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	out_data = _tmp1_;
#line 158 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	out_data_length1 = _tmp0__length1;
#line 158 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_out_data_size_ = out_data_length1;
#line 160 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp2_ = data;
#line 160 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp2__length1 = data_length1;
#line 160 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	stream.next_in = _tmp2_;
#line 160 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	stream.avail_in = _tmp2__length1;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp3_ = out_data;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp3__length1 = out_data_length1;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	stream.next_out = _tmp3_;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	stream.avail_out = _tmp3__length1;
#line 162 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	while (TRUE) {
#line 1223 "book.c"
		z_stream _tmp4_ = {0};
		guint _tmp5_ = 0U;
		gint _tmp6_ = 0;
#line 162 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp4_ = stream;
#line 162 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp5_ = _tmp4_.avail_in;
#line 162 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		if (!(_tmp5_ > ((guint) 0))) {
#line 162 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			break;
#line 1235 "book.c"
		}
#line 164 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp6_ = deflate (&stream, (gint) Z_FINISH);
#line 164 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		if (_tmp6_ == ((gint) Z_STREAM_ERROR)) {
#line 165 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			break;
#line 1243 "book.c"
		}
	}
#line 168 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp7_ = stream;
#line 168 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp8_ = _tmp7_.avail_in;
#line 168 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (_tmp8_ > ((guint) 0)) {
#line 1252 "book.c"
		guint8* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp9_ = NULL;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp9__length1 = 0;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		if (result_length1) {
#line 169 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			*result_length1 = _tmp9__length1;
#line 1263 "book.c"
		}
#line 169 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		result = _tmp9_;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		out_data = (g_free (out_data), NULL);
#line 169 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		deflateEnd (&stream);
#line 169 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		return result;
#line 1273 "book.c"
	}
#line 171 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp10_ = data;
#line 171 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp10__length1 = data_length1;
#line 171 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp11_ = stream;
#line 171 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp12_ = _tmp11_.avail_out;
#line 171 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	n_written = _tmp10__length1 - _tmp12_;
#line 172 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp13_ = n_written;
#line 172 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp14_ = (gint) _tmp13_;
#line 172 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	out_data = g_renew (guint8, out_data, (gint) _tmp13_);
#line 172 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	(_tmp14_ > out_data_length1) ? memset (out_data + out_data_length1, 0, sizeof (guint8) * (_tmp14_ - out_data_length1)) : NULL;
#line 172 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	out_data_length1 = _tmp14_;
#line 172 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_out_data_size_ = _tmp14_;
#line 174 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp15_ = out_data;
#line 174 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp15__length1 = out_data_length1;
#line 174 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (result_length1) {
#line 174 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		*result_length1 = _tmp15__length1;
#line 1305 "book.c"
	}
#line 174 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	result = _tmp15_;
#line 174 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	deflateEnd (&stream);
#line 174 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return result;
#line 1313 "book.c"
}


static void book_jpeg_init_cb (struct jpeg_compress_struct* info) {
#line 177 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (info != NULL);
#line 1320 "book.c"
}


static gboolean book_jpeg_empty_cb (struct jpeg_compress_struct* info) {
	gboolean result = FALSE;
#line 178 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (info != NULL, FALSE);
#line 178 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	result = TRUE;
#line 178 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return result;
#line 1332 "book.c"
}


static void book_jpeg_term_cb (struct jpeg_compress_struct* info) {
#line 179 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (info != NULL);
#line 1339 "book.c"
}


static void _book_jpeg_init_cb_jpeg_initdestinationfunc (struct jpeg_compress_struct* cinfo) {
#line 200 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	book_jpeg_init_cb (cinfo);
#line 1346 "book.c"
}


static gboolean _book_jpeg_empty_cb_jpeg_emptyoutputbufferfunc (struct jpeg_compress_struct* cinfo) {
	gboolean result;
	result = book_jpeg_empty_cb (cinfo);
#line 201 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return result;
#line 1355 "book.c"
}


static void _book_jpeg_term_cb_jpeg_termdestinationfunc (struct jpeg_compress_struct* cinfo) {
#line 202 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	book_jpeg_term_cb (cinfo);
#line 1362 "book.c"
}


static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gsize* n_written, int* result_length1) {
	gsize _vala_n_written = 0UL;
	guint8* result = NULL;
	struct jpeg_compress_struct info = {0};
	struct jpeg_error_mgr jerr = {0};
	struct jpeg_destination_mgr dest_mgr = {0};
	struct jpeg_error_mgr* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GdkPixbuf* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint max_length = 0;
	struct jpeg_compress_struct _tmp5_ = {0};
	gint _tmp6_ = 0;
	struct jpeg_compress_struct _tmp7_ = {0};
	gint _tmp8_ = 0;
	struct jpeg_compress_struct _tmp9_ = {0};
	gint _tmp10_ = 0;
	guint8* data = NULL;
	gint _tmp11_ = 0;
	guint8* _tmp12_ = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	guint8* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp14_ = 0;
	guint8* pixels = NULL;
	GdkPixbuf* _tmp15_ = NULL;
	guint8* _tmp16_ = NULL;
	gint pixels_length1 = 0;
	gint _pixels_size_ = 0;
	gint _tmp27_ = 0;
	struct jpeg_destination_mgr _tmp28_ = {0};
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	guint8* _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
#line 181 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 181 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (image != NULL, NULL);
#line 183 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	memset (&info, 0, sizeof (struct jpeg_compress_struct));
#line 184 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	memset (&jerr, 0, sizeof (struct jpeg_error_mgr));
#line 185 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	memset (&dest_mgr, 0, sizeof (struct jpeg_destination_mgr));
#line 187 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = jpeg_std_error (&jerr);
#line 187 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	info.err = _tmp0_;
#line 188 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	jpeg_create_compress (&info);
#line 190 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp1_ = image;
#line 190 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp2_ = gdk_pixbuf_get_width (_tmp1_);
#line 190 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	info.image_width = _tmp2_;
#line 191 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp3_ = image;
#line 191 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp4_ = gdk_pixbuf_get_height (_tmp3_);
#line 191 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	info.image_height = _tmp4_;
#line 192 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	info.input_components = 3;
#line 193 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	info.in_color_space = JCS_RGB;
#line 194 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	jpeg_set_defaults (&info);
#line 196 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp5_ = info;
#line 196 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp6_ = _tmp5_.image_width;
#line 196 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp7_ = info;
#line 196 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp8_ = _tmp7_.image_height;
#line 196 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp9_ = info;
#line 196 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp10_ = _tmp9_.input_components;
#line 196 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	max_length = (_tmp6_ * _tmp8_) * _tmp10_;
#line 197 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp11_ = max_length;
#line 197 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp12_ = g_new0 (guint8, _tmp11_);
#line 197 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	data = _tmp12_;
#line 197 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	data_length1 = _tmp11_;
#line 197 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_data_size_ = data_length1;
#line 198 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp13_ = data;
#line 198 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp13__length1 = data_length1;
#line 198 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	dest_mgr.next_output_byte = _tmp13_;
#line 199 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp14_ = max_length;
#line 199 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	dest_mgr.free_in_buffer = _tmp14_;
#line 200 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	dest_mgr.init_destination = _book_jpeg_init_cb_jpeg_initdestinationfunc;
#line 201 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	dest_mgr.empty_output_buffer = _book_jpeg_empty_cb_jpeg_emptyoutputbufferfunc;
#line 202 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	dest_mgr.term_destination = _book_jpeg_term_cb_jpeg_termdestinationfunc;
#line 203 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	info.dest = &dest_mgr;
#line 205 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	jpeg_start_compress (&info, TRUE);
#line 206 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp15_ = image;
#line 206 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp16_ = gdk_pixbuf_get_pixels (_tmp15_);
#line 206 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pixels = _tmp16_;
#line 206 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pixels_length1 = -1;
#line 206 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_pixels_size_ = pixels_length1;
#line 1491 "book.c"
	{
		gint r = 0;
#line 207 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		r = 0;
#line 1496 "book.c"
		{
			gboolean _tmp17_ = FALSE;
#line 207 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			_tmp17_ = TRUE;
#line 207 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			while (TRUE) {
#line 1503 "book.c"
				gint _tmp19_ = 0;
				struct jpeg_compress_struct _tmp20_ = {0};
				gint _tmp21_ = 0;
				guint8* row[1] = {0};
				guint8* _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				GdkPixbuf* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				guint8* _tmp26_ = NULL;
#line 207 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				if (!_tmp17_) {
#line 1516 "book.c"
					gint _tmp18_ = 0;
#line 207 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp18_ = r;
#line 207 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					r = _tmp18_ + 1;
#line 1522 "book.c"
				}
#line 207 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp17_ = FALSE;
#line 207 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp19_ = r;
#line 207 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp20_ = info;
#line 207 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp21_ = _tmp20_.image_height;
#line 207 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				if (!(_tmp19_ < _tmp21_)) {
#line 207 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					break;
#line 1536 "book.c"
				}
#line 210 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp22_ = pixels;
#line 210 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp22__length1 = pixels_length1;
#line 210 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp23_ = r;
#line 210 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp24_ = image;
#line 210 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp25_ = gdk_pixbuf_get_rowstride (_tmp24_);
#line 210 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				row[0] = ((guint8*) _tmp22_) + (_tmp23_ * _tmp25_);
#line 210 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp26_ = row[0];
#line 211 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				jpeg_write_scanlines (&info, row, 1);
#line 1554 "book.c"
			}
		}
	}
#line 213 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	jpeg_finish_compress (&info);
#line 214 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp27_ = max_length;
#line 214 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp28_ = dest_mgr;
#line 214 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp29_ = _tmp28_.free_in_buffer;
#line 214 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_vala_n_written = (gsize) (_tmp27_ - _tmp29_);
#line 215 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp30_ = (gint) _vala_n_written;
#line 215 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	data = g_renew (guint8, data, (gint) _vala_n_written);
#line 215 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	(_tmp30_ > data_length1) ? memset (data + data_length1, 0, sizeof (guint8) * (_tmp30_ - data_length1)) : NULL;
#line 215 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	data_length1 = _tmp30_;
#line 215 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_data_size_ = _tmp30_;
#line 217 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp31_ = data;
#line 217 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp31__length1 = data_length1;
#line 217 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (result_length1) {
#line 217 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		*result_length1 = _tmp31__length1;
#line 1586 "book.c"
	}
#line 217 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	result = _tmp31_;
#line 217 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	jpeg_destroy_compress (&info);
#line 217 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (n_written) {
#line 217 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		*n_written = _vala_n_written;
#line 1596 "book.c"
	}
#line 217 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return result;
#line 1600 "book.c"
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
#line 423 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1607 "book.c"
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
#line 430 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1614 "book.c"
}


static void book_save_pdf (Book* self, GFile* file, GError** error) {
	gchar* id = NULL;
	gchar* _tmp0_ = NULL;
	GFileOutputStream* stream = NULL;
	GFile* _tmp9_ = NULL;
	GFileOutputStream* _tmp10_ = NULL;
	PDFWriter* writer = NULL;
	PDFWriter* _tmp11_ = NULL;
	PDFWriter* _tmp12_ = NULL;
	PDFWriter* _tmp13_ = NULL;
	guint catalog_number = 0U;
	PDFWriter* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	PDFWriter* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	PDFWriter* _tmp20_ = NULL;
	PDFWriter* _tmp21_ = NULL;
	PDFWriter* _tmp22_ = NULL;
	guint _tmp23_ = 0U;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	PDFWriter* _tmp26_ = NULL;
	PDFWriter* _tmp27_ = NULL;
	PDFWriter* _tmp28_ = NULL;
	guint pages_number = 0U;
	PDFWriter* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	PDFWriter* _tmp31_ = NULL;
	guint _tmp32_ = 0U;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	PDFWriter* _tmp35_ = NULL;
	PDFWriter* _tmp36_ = NULL;
	PDFWriter* _tmp37_ = NULL;
	PDFWriter* _tmp47_ = NULL;
	PDFWriter* _tmp48_ = NULL;
	guint _tmp49_ = 0U;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	PDFWriter* _tmp52_ = NULL;
	PDFWriter* _tmp53_ = NULL;
	PDFWriter* _tmp348_ = NULL;
	guint info_number = 0U;
	PDFWriter* _tmp349_ = NULL;
	guint _tmp350_ = 0U;
	PDFWriter* _tmp351_ = NULL;
	guint _tmp352_ = 0U;
	gchar* _tmp353_ = NULL;
	gchar* _tmp354_ = NULL;
	PDFWriter* _tmp355_ = NULL;
	PDFWriter* _tmp356_ = NULL;
	gchar* _tmp357_ = NULL;
	gchar* _tmp358_ = NULL;
	PDFWriter* _tmp359_ = NULL;
	PDFWriter* _tmp360_ = NULL;
	PDFWriter* _tmp361_ = NULL;
	gsize xref_offset = 0UL;
	PDFWriter* _tmp362_ = NULL;
	gsize _tmp363_ = 0UL;
	PDFWriter* _tmp364_ = NULL;
	PDFWriter* _tmp365_ = NULL;
	PDFWriter* _tmp366_ = NULL;
	GList* _tmp367_ = NULL;
	guint _tmp368_ = 0U;
	gchar* _tmp369_ = NULL;
	gchar* _tmp370_ = NULL;
	PDFWriter* _tmp371_ = NULL;
	PDFWriter* _tmp372_ = NULL;
	GList* _tmp373_ = NULL;
	PDFWriter* _tmp378_ = NULL;
	PDFWriter* _tmp379_ = NULL;
	PDFWriter* _tmp380_ = NULL;
	PDFWriter* _tmp381_ = NULL;
	PDFWriter* _tmp382_ = NULL;
	GList* _tmp383_ = NULL;
	guint _tmp384_ = 0U;
	gchar* _tmp385_ = NULL;
	gchar* _tmp386_ = NULL;
	PDFWriter* _tmp387_ = NULL;
	guint _tmp388_ = 0U;
	gchar* _tmp389_ = NULL;
	gchar* _tmp390_ = NULL;
	PDFWriter* _tmp391_ = NULL;
	guint _tmp392_ = 0U;
	gchar* _tmp393_ = NULL;
	gchar* _tmp394_ = NULL;
	PDFWriter* _tmp395_ = NULL;
	const gchar* _tmp396_ = NULL;
	const gchar* _tmp397_ = NULL;
	gchar* _tmp398_ = NULL;
	gchar* _tmp399_ = NULL;
	PDFWriter* _tmp400_ = NULL;
	PDFWriter* _tmp401_ = NULL;
	PDFWriter* _tmp402_ = NULL;
	gsize _tmp403_ = 0UL;
	gchar* _tmp404_ = NULL;
	gchar* _tmp405_ = NULL;
	PDFWriter* _tmp406_ = NULL;
	GError * _inner_error_ = NULL;
#line 220 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (self != NULL);
#line 220 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (file != NULL);
#line 223 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = g_strdup ("");
#line 223 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	id = _tmp0_;
#line 1727 "book.c"
	{
		gint i = 0;
#line 224 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		i = 0;
#line 1732 "book.c"
		{
			gboolean _tmp1_ = FALSE;
#line 224 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			_tmp1_ = TRUE;
#line 224 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			while (TRUE) {
#line 1739 "book.c"
				gint _tmp3_ = 0;
				const gchar* _tmp4_ = NULL;
				guint32 _tmp5_ = 0U;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
#line 224 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				if (!_tmp1_) {
#line 1748 "book.c"
					gint _tmp2_ = 0;
#line 224 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp2_ = i;
#line 224 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					i = _tmp2_ + 1;
#line 1754 "book.c"
				}
#line 224 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp1_ = FALSE;
#line 224 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp3_ = i;
#line 224 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				if (!(_tmp3_ < 4)) {
#line 224 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					break;
#line 1764 "book.c"
				}
#line 225 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp4_ = id;
#line 225 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp5_ = g_random_int ();
#line 225 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp6_ = g_strdup_printf ("%08x", (guint) _tmp5_);
#line 225 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp7_ = _tmp6_;
#line 225 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
#line 225 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (id);
#line 225 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				id = _tmp8_;
#line 225 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp7_);
#line 1782 "book.c"
			}
		}
	}
#line 227 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp9_ = file;
#line 227 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp10_ = g_file_replace (_tmp9_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 227 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	stream = _tmp10_;
#line 227 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (_inner_error_ != NULL) {
#line 227 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 227 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_g_free0 (id);
#line 227 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		return;
#line 1800 "book.c"
	}
#line 228 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp11_ = pdf_writer_new (stream);
#line 228 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	writer = _tmp11_;
#line 231 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp12_ = writer;
#line 231 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp12_, "%PDF-1.3\n");
#line 234 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp13_ = writer;
#line 234 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp13_, "%\xe2\xe3\xcf\xd3\n");
#line 237 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp14_ = writer;
#line 237 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp15_ = pdf_writer_start_object (_tmp14_);
#line 237 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	catalog_number = _tmp15_;
#line 238 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp16_ = writer;
#line 238 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp17_ = catalog_number;
#line 238 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp18_ = g_strdup_printf ("%u 0 obj\n", _tmp17_);
#line 238 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp19_ = _tmp18_;
#line 238 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp16_, _tmp19_);
#line 238 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (_tmp19_);
#line 239 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp20_ = writer;
#line 239 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp20_, "<<\n");
#line 240 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp21_ = writer;
#line 240 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp21_, "/Type /Catalog\n");
#line 243 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp22_ = writer;
#line 243 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp23_ = catalog_number;
#line 243 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp24_ = g_strdup_printf ("/Pages %u 0 R\n", _tmp23_ + 1);
#line 243 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp25_ = _tmp24_;
#line 243 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp22_, _tmp25_);
#line 243 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (_tmp25_);
#line 244 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp26_ = writer;
#line 244 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp26_, ">>\n");
#line 245 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp27_ = writer;
#line 245 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp27_, "endobj\n");
#line 263 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp28_ = writer;
#line 263 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp28_, "\n");
#line 264 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp29_ = writer;
#line 264 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp30_ = pdf_writer_start_object (_tmp29_);
#line 264 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pages_number = _tmp30_;
#line 265 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp31_ = writer;
#line 265 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp32_ = pages_number;
#line 265 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp33_ = g_strdup_printf ("%u 0 obj\n", _tmp32_);
#line 265 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp34_ = _tmp33_;
#line 265 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp31_, _tmp34_);
#line 265 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (_tmp34_);
#line 266 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp35_ = writer;
#line 266 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp35_, "<<\n");
#line 267 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp36_ = writer;
#line 267 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp36_, "/Type /Pages\n");
#line 268 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp37_ = writer;
#line 268 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp37_, "/Kids [");
#line 1894 "book.c"
	{
		gint i = 0;
#line 269 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		i = 0;
#line 1899 "book.c"
		{
			gboolean _tmp38_ = FALSE;
#line 269 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			_tmp38_ = TRUE;
#line 269 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			while (TRUE) {
#line 1906 "book.c"
				gint _tmp40_ = 0;
				guint _tmp41_ = 0U;
				PDFWriter* _tmp42_ = NULL;
				guint _tmp43_ = 0U;
				gint _tmp44_ = 0;
				gchar* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
#line 269 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				if (!_tmp38_) {
#line 1916 "book.c"
					gint _tmp39_ = 0;
#line 269 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp39_ = i;
#line 269 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					i = _tmp39_ + 1;
#line 1922 "book.c"
				}
#line 269 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp38_ = FALSE;
#line 269 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp40_ = i;
#line 269 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp41_ = book_get_n_pages (self);
#line 269 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				if (!(((guint) _tmp40_) < _tmp41_)) {
#line 269 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					break;
#line 1934 "book.c"
				}
#line 270 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp42_ = writer;
#line 270 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp43_ = pages_number;
#line 270 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp44_ = i;
#line 270 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp45_ = g_strdup_printf (" %u 0 R", (_tmp43_ + 1) + (_tmp44_ * 3));
#line 270 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp46_ = _tmp45_;
#line 270 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp42_, _tmp46_);
#line 270 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp46_);
#line 1950 "book.c"
			}
		}
	}
#line 271 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp47_ = writer;
#line 271 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp47_, " ]\n");
#line 272 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp48_ = writer;
#line 272 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp49_ = book_get_n_pages (self);
#line 272 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp50_ = g_strdup_printf ("/Count %u\n", _tmp49_);
#line 272 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp51_ = _tmp50_;
#line 272 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp48_, _tmp51_);
#line 272 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (_tmp51_);
#line 273 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp52_ = writer;
#line 273 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp52_, ">>\n");
#line 274 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp53_ = writer;
#line 274 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp53_, "endobj\n");
#line 1978 "book.c"
	{
		gint i = 0;
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		i = 0;
#line 1983 "book.c"
		{
			gboolean _tmp54_ = FALSE;
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			_tmp54_ = TRUE;
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			while (TRUE) {
#line 1990 "book.c"
				gint _tmp56_ = 0;
				guint _tmp57_ = 0U;
				Page* page = NULL;
				gint _tmp58_ = 0;
				Page* _tmp59_ = NULL;
				GdkPixbuf* image = NULL;
				Page* _tmp60_ = NULL;
				GdkPixbuf* _tmp61_ = NULL;
				gint width = 0;
				GdkPixbuf* _tmp62_ = NULL;
				gint _tmp63_ = 0;
				gint height = 0;
				GdkPixbuf* _tmp64_ = NULL;
				gint _tmp65_ = 0;
				guint8* pixels = NULL;
				GdkPixbuf* _tmp66_ = NULL;
				guint8* _tmp67_ = NULL;
				gint pixels_length1 = 0;
				gint _pixels_size_ = 0;
				gdouble page_width = 0.0;
				gint _tmp68_ = 0;
				Page* _tmp69_ = NULL;
				gint _tmp70_ = 0;
				gdouble page_height = 0.0;
				gint _tmp71_ = 0;
				Page* _tmp72_ = NULL;
				gint _tmp73_ = 0;
				gint depth = 0;
				gchar* color_space = NULL;
				gchar* _tmp74_ = NULL;
				gchar* filter = NULL;
				gchar* width_buffer = NULL;
				gchar* _tmp75_ = NULL;
				gint width_buffer_length1 = 0;
				gint _width_buffer_size_ = 0;
				gchar* height_buffer = NULL;
				gchar* _tmp76_ = NULL;
				gint height_buffer_length1 = 0;
				gint _height_buffer_size_ = 0;
				guint8* data = NULL;
				gint data_length1 = 0;
				gint _data_size_ = 0;
				Page* _tmp77_ = NULL;
				gboolean _tmp78_ = FALSE;
				guint8* compressed_data = NULL;
				guint8* _tmp226_ = NULL;
				gint _tmp226__length1 = 0;
				gint _tmp227_ = 0;
				guint8* _tmp228_ = NULL;
				gint compressed_data_length1 = 0;
				gint _compressed_data_size_ = 0;
				guint8* _tmp229_ = NULL;
				gint _tmp229__length1 = 0;
				PDFWriter* _tmp244_ = NULL;
				guint number = 0U;
				PDFWriter* _tmp245_ = NULL;
				guint _tmp246_ = 0U;
				PDFWriter* _tmp247_ = NULL;
				guint _tmp248_ = 0U;
				gchar* _tmp249_ = NULL;
				gchar* _tmp250_ = NULL;
				PDFWriter* _tmp251_ = NULL;
				PDFWriter* _tmp252_ = NULL;
				PDFWriter* _tmp253_ = NULL;
				guint _tmp254_ = 0U;
				gchar* _tmp255_ = NULL;
				gchar* _tmp256_ = NULL;
				PDFWriter* _tmp257_ = NULL;
				gint _tmp258_ = 0;
				guint _tmp259_ = 0U;
				gchar* _tmp260_ = NULL;
				gchar* _tmp261_ = NULL;
				PDFWriter* _tmp262_ = NULL;
				gdouble _tmp263_ = 0.0;
				gchar* _tmp264_ = NULL;
				gint _tmp264__length1 = 0;
				const gchar* _tmp265_ = NULL;
				gdouble _tmp266_ = 0.0;
				gchar* _tmp267_ = NULL;
				gint _tmp267__length1 = 0;
				const gchar* _tmp268_ = NULL;
				gchar* _tmp269_ = NULL;
				gchar* _tmp270_ = NULL;
				PDFWriter* _tmp271_ = NULL;
				guint _tmp272_ = 0U;
				gchar* _tmp273_ = NULL;
				gchar* _tmp274_ = NULL;
				PDFWriter* _tmp275_ = NULL;
				PDFWriter* _tmp276_ = NULL;
				PDFWriter* _tmp277_ = NULL;
				PDFWriter* _tmp278_ = NULL;
				guint _tmp279_ = 0U;
				PDFWriter* _tmp280_ = NULL;
				guint _tmp281_ = 0U;
				gchar* _tmp282_ = NULL;
				gchar* _tmp283_ = NULL;
				PDFWriter* _tmp284_ = NULL;
				PDFWriter* _tmp285_ = NULL;
				PDFWriter* _tmp286_ = NULL;
				PDFWriter* _tmp287_ = NULL;
				gint _tmp288_ = 0;
				gchar* _tmp289_ = NULL;
				gchar* _tmp290_ = NULL;
				PDFWriter* _tmp291_ = NULL;
				gint _tmp292_ = 0;
				gchar* _tmp293_ = NULL;
				gchar* _tmp294_ = NULL;
				PDFWriter* _tmp295_ = NULL;
				const gchar* _tmp296_ = NULL;
				gchar* _tmp297_ = NULL;
				gchar* _tmp298_ = NULL;
				PDFWriter* _tmp299_ = NULL;
				gint _tmp300_ = 0;
				gchar* _tmp301_ = NULL;
				gchar* _tmp302_ = NULL;
				PDFWriter* _tmp303_ = NULL;
				guint8* _tmp304_ = NULL;
				gint _tmp304__length1 = 0;
				gchar* _tmp305_ = NULL;
				gchar* _tmp306_ = NULL;
				const gchar* _tmp307_ = NULL;
				PDFWriter* _tmp312_ = NULL;
				PDFWriter* _tmp313_ = NULL;
				PDFWriter* _tmp314_ = NULL;
				guint8* _tmp315_ = NULL;
				gint _tmp315__length1 = 0;
				PDFWriter* _tmp316_ = NULL;
				PDFWriter* _tmp317_ = NULL;
				PDFWriter* _tmp318_ = NULL;
				gchar* command = NULL;
				gdouble _tmp319_ = 0.0;
				gchar* _tmp320_ = NULL;
				gint _tmp320__length1 = 0;
				const gchar* _tmp321_ = NULL;
				gdouble _tmp322_ = 0.0;
				gchar* _tmp323_ = NULL;
				gint _tmp323__length1 = 0;
				const gchar* _tmp324_ = NULL;
				gint _tmp325_ = 0;
				gchar* _tmp326_ = NULL;
				PDFWriter* _tmp327_ = NULL;
				PDFWriter* _tmp328_ = NULL;
				guint _tmp329_ = 0U;
				PDFWriter* _tmp330_ = NULL;
				guint _tmp331_ = 0U;
				gchar* _tmp332_ = NULL;
				gchar* _tmp333_ = NULL;
				PDFWriter* _tmp334_ = NULL;
				PDFWriter* _tmp335_ = NULL;
				const gchar* _tmp336_ = NULL;
				gint _tmp337_ = 0;
				gint _tmp338_ = 0;
				gchar* _tmp339_ = NULL;
				gchar* _tmp340_ = NULL;
				PDFWriter* _tmp341_ = NULL;
				PDFWriter* _tmp342_ = NULL;
				PDFWriter* _tmp343_ = NULL;
				const gchar* _tmp344_ = NULL;
				PDFWriter* _tmp345_ = NULL;
				PDFWriter* _tmp346_ = NULL;
				PDFWriter* _tmp347_ = NULL;
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				if (!_tmp54_) {
#line 2154 "book.c"
					gint _tmp55_ = 0;
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp55_ = i;
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					i = _tmp55_ + 1;
#line 2160 "book.c"
				}
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp54_ = FALSE;
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp56_ = i;
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp57_ = book_get_n_pages (self);
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				if (!(((guint) _tmp56_) < _tmp57_)) {
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					break;
#line 2172 "book.c"
				}
#line 278 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp58_ = i;
#line 278 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp59_ = book_get_page (self, _tmp58_);
#line 278 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				page = _tmp59_;
#line 279 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp60_ = page;
#line 279 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp61_ = page_get_image (_tmp60_, TRUE);
#line 279 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				image = _tmp61_;
#line 280 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp62_ = image;
#line 280 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp63_ = gdk_pixbuf_get_width (_tmp62_);
#line 280 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				width = _tmp63_;
#line 281 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp64_ = image;
#line 281 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp65_ = gdk_pixbuf_get_height (_tmp64_);
#line 281 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				height = _tmp65_;
#line 282 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp66_ = image;
#line 282 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp67_ = gdk_pixbuf_get_pixels (_tmp66_);
#line 282 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pixels = _tmp67_;
#line 282 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pixels_length1 = -1;
#line 282 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_pixels_size_ = pixels_length1;
#line 283 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp68_ = width;
#line 283 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp69_ = page;
#line 283 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp70_ = page_get_dpi (_tmp69_);
#line 283 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				page_width = (_tmp68_ * 72.0) / _tmp70_;
#line 284 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp71_ = height;
#line 284 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp72_ = page;
#line 284 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp73_ = page_get_dpi (_tmp72_);
#line 284 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				page_height = (_tmp71_ * 72.0) / _tmp73_;
#line 286 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				depth = 8;
#line 287 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp74_ = g_strdup ("DeviceRGB");
#line 287 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				color_space = _tmp74_;
#line 288 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				filter = NULL;
#line 289 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp75_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 289 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				width_buffer = _tmp75_;
#line 289 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				width_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 289 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_width_buffer_size_ = width_buffer_length1;
#line 290 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp76_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 290 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				height_buffer = _tmp76_;
#line 290 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				height_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 290 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_height_buffer_size_ = height_buffer_length1;
#line 292 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp77_ = page;
#line 292 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp78_ = page_is_color (_tmp77_);
#line 292 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				if (_tmp78_) {
#line 2254 "book.c"
					gchar* _tmp79_ = NULL;
					gint data_length = 0;
					gint _tmp80_ = 0;
					gint _tmp81_ = 0;
					gint _tmp82_ = 0;
					guint8* _tmp83_ = NULL;
#line 294 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					depth = 8;
#line 295 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp79_ = g_strdup ("DeviceRGB");
#line 295 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_g_free0 (color_space);
#line 295 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					color_space = _tmp79_;
#line 296 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp80_ = height;
#line 296 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp81_ = width;
#line 296 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					data_length = (_tmp80_ * _tmp81_) * 3;
#line 297 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp82_ = data_length;
#line 297 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp83_ = g_new0 (guint8, _tmp82_);
#line 297 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					data = (g_free (data), NULL);
#line 297 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					data = _tmp83_;
#line 297 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					data_length1 = _tmp82_;
#line 297 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_data_size_ = data_length1;
#line 2287 "book.c"
					{
						gint row = 0;
#line 298 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						row = 0;
#line 2292 "book.c"
						{
							gboolean _tmp84_ = FALSE;
#line 298 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp84_ = TRUE;
#line 298 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							while (TRUE) {
#line 2299 "book.c"
								gint _tmp86_ = 0;
								gint _tmp87_ = 0;
								gint in_offset = 0;
								gint _tmp88_ = 0;
								GdkPixbuf* _tmp89_ = NULL;
								gint _tmp90_ = 0;
								gint out_offset = 0;
								gint _tmp91_ = 0;
								gint _tmp92_ = 0;
#line 298 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								if (!_tmp84_) {
#line 2311 "book.c"
									gint _tmp85_ = 0;
#line 298 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									_tmp85_ = row;
#line 298 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									row = _tmp85_ + 1;
#line 2317 "book.c"
								}
#line 298 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								_tmp84_ = FALSE;
#line 298 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								_tmp86_ = row;
#line 298 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								_tmp87_ = height;
#line 298 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								if (!(_tmp86_ < _tmp87_)) {
#line 298 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									break;
#line 2329 "book.c"
								}
#line 300 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								_tmp88_ = row;
#line 300 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								_tmp89_ = image;
#line 300 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								_tmp90_ = gdk_pixbuf_get_rowstride (_tmp89_);
#line 300 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								in_offset = _tmp88_ * _tmp90_;
#line 301 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								_tmp91_ = row;
#line 301 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								_tmp92_ = width;
#line 301 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								out_offset = (_tmp91_ * _tmp92_) * 3;
#line 2345 "book.c"
								{
									gint x = 0;
#line 302 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									x = 0;
#line 2350 "book.c"
									{
										gboolean _tmp93_ = FALSE;
#line 302 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp93_ = TRUE;
#line 302 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										while (TRUE) {
#line 2357 "book.c"
											gint _tmp95_ = 0;
											gint _tmp96_ = 0;
											gint in_o = 0;
											gint _tmp97_ = 0;
											gint _tmp98_ = 0;
											gint out_o = 0;
											gint _tmp99_ = 0;
											gint _tmp100_ = 0;
											guint8* _tmp101_ = NULL;
											gint _tmp101__length1 = 0;
											gint _tmp102_ = 0;
											guint8* _tmp103_ = NULL;
											gint _tmp103__length1 = 0;
											gint _tmp104_ = 0;
											guint8 _tmp105_ = 0U;
											guint8 _tmp106_ = 0U;
											guint8* _tmp107_ = NULL;
											gint _tmp107__length1 = 0;
											gint _tmp108_ = 0;
											guint8* _tmp109_ = NULL;
											gint _tmp109__length1 = 0;
											gint _tmp110_ = 0;
											guint8 _tmp111_ = 0U;
											guint8 _tmp112_ = 0U;
											guint8* _tmp113_ = NULL;
											gint _tmp113__length1 = 0;
											gint _tmp114_ = 0;
											guint8* _tmp115_ = NULL;
											gint _tmp115__length1 = 0;
											gint _tmp116_ = 0;
											guint8 _tmp117_ = 0U;
											guint8 _tmp118_ = 0U;
#line 302 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											if (!_tmp93_) {
#line 2392 "book.c"
												gint _tmp94_ = 0;
#line 302 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												_tmp94_ = x;
#line 302 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												x = _tmp94_ + 1;
#line 2398 "book.c"
											}
#line 302 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp93_ = FALSE;
#line 302 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp95_ = x;
#line 302 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp96_ = width;
#line 302 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											if (!(_tmp95_ < _tmp96_)) {
#line 302 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												break;
#line 2410 "book.c"
											}
#line 304 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp97_ = in_offset;
#line 304 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp98_ = x;
#line 304 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											in_o = _tmp97_ + (_tmp98_ * 3);
#line 305 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp99_ = out_offset;
#line 305 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp100_ = x;
#line 305 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											out_o = _tmp99_ + (_tmp100_ * 3);
#line 307 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp101_ = data;
#line 307 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp101__length1 = data_length1;
#line 307 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp102_ = out_o;
#line 307 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp103_ = pixels;
#line 307 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp103__length1 = pixels_length1;
#line 307 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp104_ = in_o;
#line 307 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp105_ = _tmp103_[_tmp104_];
#line 307 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp101_[_tmp102_] = _tmp105_;
#line 307 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp106_ = _tmp101_[_tmp102_];
#line 308 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp107_ = data;
#line 308 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp107__length1 = data_length1;
#line 308 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp108_ = out_o;
#line 308 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp109_ = pixels;
#line 308 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp109__length1 = pixels_length1;
#line 308 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp110_ = in_o;
#line 308 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp111_ = _tmp109_[_tmp110_ + 1];
#line 308 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp107_[_tmp108_ + 1] = _tmp111_;
#line 308 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp112_ = _tmp107_[_tmp108_ + 1];
#line 309 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp113_ = data;
#line 309 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp113__length1 = data_length1;
#line 309 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp114_ = out_o;
#line 309 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp115_ = pixels;
#line 309 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp115__length1 = pixels_length1;
#line 309 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp116_ = in_o;
#line 309 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp117_ = _tmp115_[_tmp116_ + 2];
#line 309 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp113_[_tmp114_ + 2] = _tmp117_;
#line 309 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp118_ = _tmp113_[_tmp114_ + 2];
#line 2478 "book.c"
										}
									}
								}
							}
						}
					}
				} else {
					Page* _tmp119_ = NULL;
					gint _tmp120_ = 0;
#line 313 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp119_ = page;
#line 313 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp120_ = page_get_depth (_tmp119_);
#line 313 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					if (_tmp120_ == 2) {
#line 2494 "book.c"
						gint shift_count = 0;
						gchar* _tmp121_ = NULL;
						gint data_length = 0;
						gint _tmp122_ = 0;
						gint _tmp123_ = 0;
						gint _tmp124_ = 0;
						guint8* _tmp125_ = NULL;
						gint offset = 0;
#line 315 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						shift_count = 6;
#line 316 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						depth = 2;
#line 317 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp121_ = g_strdup ("DeviceGray");
#line 317 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_g_free0 (color_space);
#line 317 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						color_space = _tmp121_;
#line 318 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp122_ = height;
#line 318 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp123_ = width;
#line 318 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						data_length = _tmp122_ * (((_tmp123_ * 2) + 7) / 8);
#line 319 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp124_ = data_length;
#line 319 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp125_ = g_new0 (guint8, _tmp124_);
#line 319 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						data = (g_free (data), NULL);
#line 319 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						data = _tmp125_;
#line 319 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						data_length1 = _tmp124_;
#line 319 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_data_size_ = data_length1;
#line 320 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						offset = 0;
#line 2533 "book.c"
						{
							gint row = 0;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							row = 0;
#line 2538 "book.c"
							{
								gboolean _tmp126_ = FALSE;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								_tmp126_ = TRUE;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								while (TRUE) {
#line 2545 "book.c"
									gint _tmp128_ = 0;
									gint _tmp129_ = 0;
									gint _tmp130_ = 0;
									gint in_offset = 0;
									gint _tmp132_ = 0;
									GdkPixbuf* _tmp133_ = NULL;
									gint _tmp134_ = 0;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									if (!_tmp126_) {
#line 2555 "book.c"
										gint _tmp127_ = 0;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp127_ = row;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										row = _tmp127_ + 1;
#line 2561 "book.c"
									}
#line 321 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									_tmp126_ = FALSE;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									_tmp128_ = row;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									_tmp129_ = height;
#line 321 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									if (!(_tmp128_ < _tmp129_)) {
#line 321 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										break;
#line 2573 "book.c"
									}
#line 324 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									_tmp130_ = shift_count;
#line 324 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									if (_tmp130_ != 6) {
#line 2579 "book.c"
										gint _tmp131_ = 0;
#line 326 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp131_ = offset;
#line 326 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										offset = _tmp131_ + 1;
#line 327 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										shift_count = 6;
#line 2587 "book.c"
									}
#line 330 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									_tmp132_ = row;
#line 330 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									_tmp133_ = image;
#line 330 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									_tmp134_ = gdk_pixbuf_get_rowstride (_tmp133_);
#line 330 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									in_offset = _tmp132_ * _tmp134_;
#line 2597 "book.c"
									{
										gint x = 0;
#line 331 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										x = 0;
#line 2602 "book.c"
										{
											gboolean _tmp135_ = FALSE;
#line 331 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp135_ = TRUE;
#line 331 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											while (TRUE) {
#line 2609 "book.c"
												gint _tmp137_ = 0;
												gint _tmp138_ = 0;
												gint _tmp139_ = 0;
												guint8 p = 0U;
												guint8* _tmp143_ = NULL;
												gint _tmp143__length1 = 0;
												gint _tmp144_ = 0;
												gint _tmp145_ = 0;
												guint8 _tmp146_ = 0U;
												guint8 _tmp147_ = 0U;
												gint _tmp162_ = 0;
#line 331 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												if (!_tmp135_) {
#line 2623 "book.c"
													gint _tmp136_ = 0;
#line 331 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp136_ = x;
#line 331 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													x = _tmp136_ + 1;
#line 2629 "book.c"
												}
#line 331 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												_tmp135_ = FALSE;
#line 331 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												_tmp137_ = x;
#line 331 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												_tmp138_ = width;
#line 331 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												if (!(_tmp137_ < _tmp138_)) {
#line 331 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													break;
#line 2641 "book.c"
												}
#line 334 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												_tmp139_ = shift_count;
#line 334 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												if (_tmp139_ == 6) {
#line 2647 "book.c"
													guint8* _tmp140_ = NULL;
													gint _tmp140__length1 = 0;
													gint _tmp141_ = 0;
													guint8 _tmp142_ = 0U;
#line 335 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp140_ = data;
#line 335 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp140__length1 = data_length1;
#line 335 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp141_ = offset;
#line 335 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp140_[_tmp141_] = (guint8) 0;
#line 335 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp142_ = _tmp140_[_tmp141_];
#line 2662 "book.c"
												}
#line 338 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												_tmp143_ = pixels;
#line 338 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												_tmp143__length1 = pixels_length1;
#line 338 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												_tmp144_ = in_offset;
#line 338 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												_tmp145_ = x;
#line 338 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												_tmp146_ = _tmp143_[_tmp144_ + (_tmp145_ * 3)];
#line 338 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												p = _tmp146_;
#line 339 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												_tmp147_ = p;
#line 339 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												if (((gint) _tmp147_) >= 192) {
#line 2680 "book.c"
													guint8* _tmp148_ = NULL;
													gint _tmp148__length1 = 0;
													gint _tmp149_ = 0;
													gint _tmp150_ = 0;
													guint8 _tmp151_ = 0U;
#line 340 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp148_ = data;
#line 340 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp148__length1 = data_length1;
#line 340 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp149_ = offset;
#line 340 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp150_ = shift_count;
#line 340 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp148_[_tmp149_] |= (guint8) (3 << _tmp150_);
#line 340 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp151_ = _tmp148_[_tmp149_];
#line 2698 "book.c"
												} else {
													guint8 _tmp152_ = 0U;
#line 341 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp152_ = p;
#line 341 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													if (((gint) _tmp152_) >= 128) {
#line 2705 "book.c"
														guint8* _tmp153_ = NULL;
														gint _tmp153__length1 = 0;
														gint _tmp154_ = 0;
														gint _tmp155_ = 0;
														guint8 _tmp156_ = 0U;
#line 342 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp153_ = data;
#line 342 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp153__length1 = data_length1;
#line 342 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp154_ = offset;
#line 342 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp155_ = shift_count;
#line 342 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp153_[_tmp154_] |= (guint8) (2 << _tmp155_);
#line 342 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp156_ = _tmp153_[_tmp154_];
#line 2723 "book.c"
													} else {
														guint8 _tmp157_ = 0U;
#line 343 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp157_ = p;
#line 343 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														if (((gint) _tmp157_) >= 64) {
#line 2730 "book.c"
															guint8* _tmp158_ = NULL;
															gint _tmp158__length1 = 0;
															gint _tmp159_ = 0;
															gint _tmp160_ = 0;
															guint8 _tmp161_ = 0U;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
															_tmp158_ = data;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
															_tmp158__length1 = data_length1;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
															_tmp159_ = offset;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
															_tmp160_ = shift_count;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
															_tmp158_[_tmp159_] |= (guint8) (1 << _tmp160_);
#line 344 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
															_tmp161_ = _tmp158_[_tmp159_];
#line 2748 "book.c"
														}
													}
												}
#line 347 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												_tmp162_ = shift_count;
#line 347 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												if (_tmp162_ == 0) {
#line 2756 "book.c"
													gint _tmp163_ = 0;
#line 349 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp163_ = offset;
#line 349 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													offset = _tmp163_ + 1;
#line 350 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													shift_count = 6;
#line 2764 "book.c"
												} else {
													gint _tmp164_ = 0;
#line 353 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp164_ = shift_count;
#line 353 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													shift_count = _tmp164_ - 2;
#line 2771 "book.c"
												}
											}
										}
									}
								}
							}
						}
					} else {
						Page* _tmp165_ = NULL;
						gint _tmp166_ = 0;
#line 357 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp165_ = page;
#line 357 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp166_ = page_get_depth (_tmp165_);
#line 357 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						if (_tmp166_ == 1) {
#line 2788 "book.c"
							gint mask = 0;
							gchar* _tmp167_ = NULL;
							gint data_length = 0;
							gint _tmp168_ = 0;
							gint _tmp169_ = 0;
							gint _tmp170_ = 0;
							guint8* _tmp171_ = NULL;
							gint offset = 0;
#line 359 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							mask = 0x80;
#line 361 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							depth = 1;
#line 362 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp167_ = g_strdup ("DeviceGray");
#line 362 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_g_free0 (color_space);
#line 362 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							color_space = _tmp167_;
#line 363 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp168_ = height;
#line 363 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp169_ = width;
#line 363 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							data_length = _tmp168_ * ((_tmp169_ + 7) / 8);
#line 364 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp170_ = data_length;
#line 364 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp171_ = g_new0 (guint8, _tmp170_);
#line 364 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							data = (g_free (data), NULL);
#line 364 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							data = _tmp171_;
#line 364 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							data_length1 = _tmp170_;
#line 364 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_data_size_ = data_length1;
#line 365 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							offset = 0;
#line 2827 "book.c"
							{
								gint row = 0;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								row = 0;
#line 2832 "book.c"
								{
									gboolean _tmp172_ = FALSE;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									_tmp172_ = TRUE;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									while (TRUE) {
#line 2839 "book.c"
										gint _tmp174_ = 0;
										gint _tmp175_ = 0;
										gint _tmp176_ = 0;
										gint in_offset = 0;
										gint _tmp178_ = 0;
										GdkPixbuf* _tmp179_ = NULL;
										gint _tmp180_ = 0;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										if (!_tmp172_) {
#line 2849 "book.c"
											gint _tmp173_ = 0;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp173_ = row;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											row = _tmp173_ + 1;
#line 2855 "book.c"
										}
#line 366 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp172_ = FALSE;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp174_ = row;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp175_ = height;
#line 366 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										if (!(_tmp174_ < _tmp175_)) {
#line 366 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											break;
#line 2867 "book.c"
										}
#line 369 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp176_ = mask;
#line 369 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										if (_tmp176_ != 0x80) {
#line 2873 "book.c"
											gint _tmp177_ = 0;
#line 371 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp177_ = offset;
#line 371 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											offset = _tmp177_ + 1;
#line 372 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											mask = 0x80;
#line 2881 "book.c"
										}
#line 375 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp178_ = row;
#line 375 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp179_ = image;
#line 375 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp180_ = gdk_pixbuf_get_rowstride (_tmp179_);
#line 375 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										in_offset = _tmp178_ * _tmp180_;
#line 2891 "book.c"
										{
											gint x = 0;
#line 376 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											x = 0;
#line 2896 "book.c"
											{
												gboolean _tmp181_ = FALSE;
#line 376 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												_tmp181_ = TRUE;
#line 376 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												while (TRUE) {
#line 2903 "book.c"
													gint _tmp183_ = 0;
													gint _tmp184_ = 0;
													gint _tmp185_ = 0;
													guint8* _tmp189_ = NULL;
													gint _tmp189__length1 = 0;
													gint _tmp190_ = 0;
													gint _tmp191_ = 0;
													guint8 _tmp192_ = 0U;
													gint _tmp197_ = 0;
													gint _tmp198_ = 0;
#line 376 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													if (!_tmp181_) {
#line 2916 "book.c"
														gint _tmp182_ = 0;
#line 376 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp182_ = x;
#line 376 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														x = _tmp182_ + 1;
#line 2922 "book.c"
													}
#line 376 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp181_ = FALSE;
#line 376 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp183_ = x;
#line 376 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp184_ = width;
#line 376 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													if (!(_tmp183_ < _tmp184_)) {
#line 376 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														break;
#line 2934 "book.c"
													}
#line 379 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp185_ = mask;
#line 379 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													if (_tmp185_ == 0x80) {
#line 2940 "book.c"
														guint8* _tmp186_ = NULL;
														gint _tmp186__length1 = 0;
														gint _tmp187_ = 0;
														guint8 _tmp188_ = 0U;
#line 380 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp186_ = data;
#line 380 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp186__length1 = data_length1;
#line 380 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp187_ = offset;
#line 380 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp186_[_tmp187_] = (guint8) 0;
#line 380 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp188_ = _tmp186_[_tmp187_];
#line 2955 "book.c"
													}
#line 383 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp189_ = pixels;
#line 383 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp189__length1 = pixels_length1;
#line 383 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp190_ = in_offset;
#line 383 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp191_ = x;
#line 383 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp192_ = _tmp189_[_tmp190_ + (_tmp191_ * 3)];
#line 383 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													if (((gint) _tmp192_) != 0) {
#line 2969 "book.c"
														guint8* _tmp193_ = NULL;
														gint _tmp193__length1 = 0;
														gint _tmp194_ = 0;
														gint _tmp195_ = 0;
														guint8 _tmp196_ = 0U;
#line 384 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp193_ = data;
#line 384 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp193__length1 = data_length1;
#line 384 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp194_ = offset;
#line 384 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp195_ = mask;
#line 384 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp193_[_tmp194_] |= (guint8) _tmp195_;
#line 384 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp196_ = _tmp193_[_tmp194_];
#line 2987 "book.c"
													}
#line 387 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp197_ = mask;
#line 387 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													mask = _tmp197_ >> 1;
#line 388 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp198_ = mask;
#line 388 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													if (_tmp198_ == 0) {
#line 2997 "book.c"
														gint _tmp199_ = 0;
#line 390 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp199_ = offset;
#line 390 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														offset = _tmp199_ + 1;
#line 391 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														mask = 0x80;
#line 3005 "book.c"
													}
												}
											}
										}
									}
								}
							}
						} else {
							gchar* _tmp200_ = NULL;
							gint data_length = 0;
							gint _tmp201_ = 0;
							gint _tmp202_ = 0;
							gint _tmp203_ = 0;
							guint8* _tmp204_ = NULL;
#line 398 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							depth = 8;
#line 399 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp200_ = g_strdup ("DeviceGray");
#line 399 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_g_free0 (color_space);
#line 399 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							color_space = _tmp200_;
#line 400 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp201_ = height;
#line 400 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp202_ = width;
#line 400 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							data_length = _tmp201_ * _tmp202_;
#line 401 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp203_ = data_length;
#line 401 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp204_ = g_new0 (guint8, _tmp203_);
#line 401 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							data = (g_free (data), NULL);
#line 401 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							data = _tmp204_;
#line 401 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							data_length1 = _tmp203_;
#line 401 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_data_size_ = data_length1;
#line 3046 "book.c"
							{
								gint row = 0;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
								row = 0;
#line 3051 "book.c"
								{
									gboolean _tmp205_ = FALSE;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									_tmp205_ = TRUE;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
									while (TRUE) {
#line 3058 "book.c"
										gint _tmp207_ = 0;
										gint _tmp208_ = 0;
										gint in_offset = 0;
										gint _tmp209_ = 0;
										GdkPixbuf* _tmp210_ = NULL;
										gint _tmp211_ = 0;
										gint out_offset = 0;
										gint _tmp212_ = 0;
										gint _tmp213_ = 0;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										if (!_tmp205_) {
#line 3070 "book.c"
											gint _tmp206_ = 0;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											_tmp206_ = row;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											row = _tmp206_ + 1;
#line 3076 "book.c"
										}
#line 402 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp205_ = FALSE;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp207_ = row;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp208_ = height;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										if (!(_tmp207_ < _tmp208_)) {
#line 402 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											break;
#line 3088 "book.c"
										}
#line 404 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp209_ = row;
#line 404 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp210_ = image;
#line 404 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp211_ = gdk_pixbuf_get_rowstride (_tmp210_);
#line 404 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										in_offset = _tmp209_ * _tmp211_;
#line 405 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp212_ = row;
#line 405 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										_tmp213_ = width;
#line 405 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
										out_offset = _tmp212_ * _tmp213_;
#line 3104 "book.c"
										{
											gint x = 0;
#line 406 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
											x = 0;
#line 3109 "book.c"
											{
												gboolean _tmp214_ = FALSE;
#line 406 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												_tmp214_ = TRUE;
#line 406 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
												while (TRUE) {
#line 3116 "book.c"
													gint _tmp216_ = 0;
													gint _tmp217_ = 0;
													guint8* _tmp218_ = NULL;
													gint _tmp218__length1 = 0;
													gint _tmp219_ = 0;
													gint _tmp220_ = 0;
													guint8* _tmp221_ = NULL;
													gint _tmp221__length1 = 0;
													gint _tmp222_ = 0;
													gint _tmp223_ = 0;
													guint8 _tmp224_ = 0U;
													guint8 _tmp225_ = 0U;
#line 406 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													if (!_tmp214_) {
#line 3131 "book.c"
														gint _tmp215_ = 0;
#line 406 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														_tmp215_ = x;
#line 406 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														x = _tmp215_ + 1;
#line 3137 "book.c"
													}
#line 406 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp214_ = FALSE;
#line 406 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp216_ = x;
#line 406 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp217_ = width;
#line 406 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													if (!(_tmp216_ < _tmp217_)) {
#line 406 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
														break;
#line 3149 "book.c"
													}
#line 407 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp218_ = data;
#line 407 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp218__length1 = data_length1;
#line 407 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp219_ = out_offset;
#line 407 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp220_ = x;
#line 407 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp221_ = pixels;
#line 407 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp221__length1 = pixels_length1;
#line 407 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp222_ = in_offset;
#line 407 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp223_ = x;
#line 407 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp224_ = _tmp221_[_tmp222_ + (_tmp223_ * 3)];
#line 407 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp218_[_tmp219_ + _tmp220_] = _tmp224_;
#line 407 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
													_tmp225_ = _tmp218_[_tmp219_ + _tmp220_];
#line 3173 "book.c"
												}
											}
										}
									}
								}
							}
						}
					}
				}
#line 412 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp226_ = data;
#line 412 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp226__length1 = data_length1;
#line 412 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp228_ = book_compress_zlib (self, _tmp226_, _tmp226__length1, &_tmp227_);
#line 412 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				compressed_data = _tmp228_;
#line 412 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				compressed_data_length1 = _tmp227_;
#line 412 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_compressed_data_size_ = compressed_data_length1;
#line 413 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp229_ = compressed_data;
#line 413 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp229__length1 = compressed_data_length1;
#line 413 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				if (_tmp229_ != NULL) {
#line 3201 "book.c"
					gint _tmp230_ = 0;
					const gchar* _tmp240_ = NULL;
#line 416 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp230_ = depth;
#line 416 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					if (_tmp230_ > 1) {
#line 3208 "book.c"
						gsize jpeg_length = 0UL;
						guint8* jpeg_data = NULL;
						GdkPixbuf* _tmp231_ = NULL;
						gsize _tmp232_ = 0UL;
						gint _tmp233_ = 0;
						guint8* _tmp234_ = NULL;
						gint jpeg_data_length1 = 0;
						gint _jpeg_data_size_ = 0;
						gsize _tmp235_ = 0UL;
						guint8* _tmp236_ = NULL;
						gint _tmp236__length1 = 0;
#line 419 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp231_ = image;
#line 419 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp234_ = book_compress_jpeg (self, _tmp231_, &_tmp232_, &_tmp233_);
#line 419 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						jpeg_length = _tmp232_;
#line 419 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						jpeg_data = _tmp234_;
#line 419 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						jpeg_data_length1 = _tmp233_;
#line 419 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_jpeg_data_size_ = jpeg_data_length1;
#line 420 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp235_ = jpeg_length;
#line 420 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp236_ = compressed_data;
#line 420 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp236__length1 = compressed_data_length1;
#line 420 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						if (_tmp235_ < ((gsize) _tmp236__length1)) {
#line 3240 "book.c"
							gchar* _tmp237_ = NULL;
							guint8* _tmp238_ = NULL;
							gint _tmp238__length1 = 0;
							guint8* _tmp239_ = NULL;
							gint _tmp239__length1 = 0;
#line 422 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp237_ = g_strdup ("DCTDecode");
#line 422 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_g_free0 (filter);
#line 422 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							filter = _tmp237_;
#line 423 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp238_ = jpeg_data;
#line 423 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp238__length1 = jpeg_data_length1;
#line 423 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp239_ = (_tmp238_ != NULL) ? _vala_array_dup1 (_tmp238_, _tmp238__length1) : ((gpointer) _tmp238_);
#line 423 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_tmp239__length1 = _tmp238__length1;
#line 423 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							data = (g_free (data), NULL);
#line 423 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							data = _tmp239_;
#line 423 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							data_length1 = _tmp239__length1;
#line 423 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							_data_size_ = data_length1;
#line 3268 "book.c"
						}
#line 416 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						jpeg_data = (g_free (jpeg_data), NULL);
#line 3272 "book.c"
					}
#line 427 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp240_ = filter;
#line 427 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					if (_tmp240_ == NULL) {
#line 3278 "book.c"
						gchar* _tmp241_ = NULL;
						guint8* _tmp242_ = NULL;
						gint _tmp242__length1 = 0;
						guint8* _tmp243_ = NULL;
						gint _tmp243__length1 = 0;
#line 429 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp241_ = g_strdup ("FlateDecode");
#line 429 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_g_free0 (filter);
#line 429 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						filter = _tmp241_;
#line 430 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp242_ = compressed_data;
#line 430 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp242__length1 = compressed_data_length1;
#line 430 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp243_ = (_tmp242_ != NULL) ? _vala_array_dup2 (_tmp242_, _tmp242__length1) : ((gpointer) _tmp242_);
#line 430 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp243__length1 = _tmp242__length1;
#line 430 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						data = (g_free (data), NULL);
#line 430 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						data = _tmp243_;
#line 430 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						data_length1 = _tmp243__length1;
#line 430 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_data_size_ = data_length1;
#line 3306 "book.c"
					}
				}
#line 435 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp244_ = writer;
#line 435 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp244_, "\n");
#line 436 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp245_ = writer;
#line 436 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp246_ = pdf_writer_start_object (_tmp245_);
#line 436 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				number = _tmp246_;
#line 437 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp247_ = writer;
#line 437 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp248_ = number;
#line 437 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp249_ = g_strdup_printf ("%u 0 obj\n", _tmp248_);
#line 437 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp250_ = _tmp249_;
#line 437 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp247_, _tmp250_);
#line 437 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp250_);
#line 438 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp251_ = writer;
#line 438 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp251_, "<<\n");
#line 439 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp252_ = writer;
#line 439 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp252_, "/Type /Page\n");
#line 440 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp253_ = writer;
#line 440 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp254_ = pages_number;
#line 440 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp255_ = g_strdup_printf ("/Parent %u 0 R\n", _tmp254_);
#line 440 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp256_ = _tmp255_;
#line 440 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp253_, _tmp256_);
#line 440 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp256_);
#line 441 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp257_ = writer;
#line 441 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp258_ = i;
#line 441 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp259_ = number;
#line 441 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp260_ = g_strdup_printf ("/Resources << /XObject << /Im%d %u 0 R >> >>\n", _tmp258_, _tmp259_ + 1);
#line 441 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp261_ = _tmp260_;
#line 441 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp257_, _tmp261_);
#line 441 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp261_);
#line 442 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp262_ = writer;
#line 442 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp263_ = page_width;
#line 442 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp264_ = width_buffer;
#line 442 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp264__length1 = width_buffer_length1;
#line 442 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp265_ = g_ascii_formatd (_tmp264_, _tmp264__length1, "%.2f", _tmp263_);
#line 442 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp266_ = page_height;
#line 442 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp267_ = height_buffer;
#line 442 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp267__length1 = height_buffer_length1;
#line 442 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp268_ = g_ascii_formatd (_tmp267_, _tmp267__length1, "%.2f", _tmp266_);
#line 442 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp269_ = g_strdup_printf ("/MediaBox [ 0 0 %s %s ]\n", _tmp265_, _tmp268_);
#line 442 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp270_ = _tmp269_;
#line 442 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp262_, _tmp270_);
#line 442 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp270_);
#line 443 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp271_ = writer;
#line 443 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp272_ = number;
#line 443 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp273_ = g_strdup_printf ("/Contents %u 0 R\n", _tmp272_ + 2);
#line 443 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp274_ = _tmp273_;
#line 443 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp271_, _tmp274_);
#line 443 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp274_);
#line 444 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp275_ = writer;
#line 444 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp275_, ">>\n");
#line 445 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp276_ = writer;
#line 445 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp276_, "endobj\n");
#line 448 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp277_ = writer;
#line 448 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp277_, "\n");
#line 449 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp278_ = writer;
#line 449 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp279_ = pdf_writer_start_object (_tmp278_);
#line 449 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				number = _tmp279_;
#line 450 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp280_ = writer;
#line 450 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp281_ = number;
#line 450 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp282_ = g_strdup_printf ("%u 0 obj\n", _tmp281_);
#line 450 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp283_ = _tmp282_;
#line 450 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp280_, _tmp283_);
#line 450 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp283_);
#line 451 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp284_ = writer;
#line 451 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp284_, "<<\n");
#line 452 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp285_ = writer;
#line 452 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp285_, "/Type /XObject\n");
#line 453 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp286_ = writer;
#line 453 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp286_, "/Subtype /Image\n");
#line 454 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp287_ = writer;
#line 454 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp288_ = width;
#line 454 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp289_ = g_strdup_printf ("/Width %d\n", _tmp288_);
#line 454 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp290_ = _tmp289_;
#line 454 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp287_, _tmp290_);
#line 454 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp290_);
#line 455 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp291_ = writer;
#line 455 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp292_ = height;
#line 455 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp293_ = g_strdup_printf ("/Height %d\n", _tmp292_);
#line 455 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp294_ = _tmp293_;
#line 455 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp291_, _tmp294_);
#line 455 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp294_);
#line 456 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp295_ = writer;
#line 456 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp296_ = color_space;
#line 456 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp297_ = g_strdup_printf ("/ColorSpace /%s\n", _tmp296_);
#line 456 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp298_ = _tmp297_;
#line 456 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp295_, _tmp298_);
#line 456 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp298_);
#line 457 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp299_ = writer;
#line 457 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp300_ = depth;
#line 457 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp301_ = g_strdup_printf ("/BitsPerComponent %d\n", _tmp300_);
#line 457 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp302_ = _tmp301_;
#line 457 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp299_, _tmp302_);
#line 457 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp302_);
#line 458 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp303_ = writer;
#line 458 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp304_ = data;
#line 458 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp304__length1 = data_length1;
#line 458 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp305_ = g_strdup_printf ("/Length %d\n", _tmp304__length1);
#line 458 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp306_ = _tmp305_;
#line 458 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp303_, _tmp306_);
#line 458 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp306_);
#line 459 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp307_ = filter;
#line 459 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				if (_tmp307_ != NULL) {
#line 3511 "book.c"
					PDFWriter* _tmp308_ = NULL;
					const gchar* _tmp309_ = NULL;
					gchar* _tmp310_ = NULL;
					gchar* _tmp311_ = NULL;
#line 460 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp308_ = writer;
#line 460 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp309_ = filter;
#line 460 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp310_ = g_strdup_printf ("/Filter /%s\n", _tmp309_);
#line 460 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp311_ = _tmp310_;
#line 460 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					pdf_writer_write_string (_tmp308_, _tmp311_);
#line 460 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_g_free0 (_tmp311_);
#line 3528 "book.c"
				}
#line 461 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp312_ = writer;
#line 461 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp312_, ">>\n");
#line 462 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp313_ = writer;
#line 462 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp313_, "stream\n");
#line 463 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp314_ = writer;
#line 463 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp315_ = data;
#line 463 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp315__length1 = data_length1;
#line 463 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write (_tmp314_, _tmp315_, _tmp315__length1);
#line 464 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp316_ = writer;
#line 464 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp316_, "\n");
#line 465 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp317_ = writer;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp317_, "endstream\n");
#line 466 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp318_ = writer;
#line 466 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp318_, "endobj\n");
#line 469 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp319_ = page_width;
#line 469 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp320_ = width_buffer;
#line 469 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp320__length1 = width_buffer_length1;
#line 469 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp321_ = g_ascii_formatd (_tmp320_, _tmp320__length1, "%f", _tmp319_);
#line 469 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp322_ = page_height;
#line 469 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp323_ = height_buffer;
#line 469 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp323__length1 = height_buffer_length1;
#line 469 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp324_ = g_ascii_formatd (_tmp323_, _tmp323__length1, "%f", _tmp322_);
#line 469 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp325_ = i;
#line 469 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp326_ = g_strdup_printf ("q\n%s 0 0 %s 0 0 cm\n/Im%d Do\nQ", _tmp321_, _tmp324_, _tmp325_);
#line 469 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				command = _tmp326_;
#line 470 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp327_ = writer;
#line 470 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp327_, "\n");
#line 471 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp328_ = writer;
#line 471 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp329_ = pdf_writer_start_object (_tmp328_);
#line 471 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				number = _tmp329_;
#line 472 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp330_ = writer;
#line 472 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp331_ = number;
#line 472 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp332_ = g_strdup_printf ("%u 0 obj\n", _tmp331_);
#line 472 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp333_ = _tmp332_;
#line 472 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp330_, _tmp333_);
#line 472 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp333_);
#line 473 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp334_ = writer;
#line 473 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp334_, "<<\n");
#line 474 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp335_ = writer;
#line 474 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp336_ = command;
#line 474 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp337_ = strlen (_tmp336_);
#line 474 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp338_ = _tmp337_;
#line 474 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp339_ = g_strdup_printf ("/Length %d\n", _tmp338_);
#line 474 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp340_ = _tmp339_;
#line 474 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp335_, _tmp340_);
#line 474 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp340_);
#line 475 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp341_ = writer;
#line 475 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp341_, ">>\n");
#line 476 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp342_ = writer;
#line 476 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp342_, "stream\n");
#line 477 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp343_ = writer;
#line 477 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp344_ = command;
#line 477 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp343_, _tmp344_);
#line 478 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp345_ = writer;
#line 478 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp345_, "\n");
#line 479 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp346_ = writer;
#line 479 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp346_, "endstream\n");
#line 480 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp347_ = writer;
#line 480 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp347_, "endobj\n");
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (command);
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				compressed_data = (g_free (compressed_data), NULL);
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				data = (g_free (data), NULL);
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				height_buffer = (g_free (height_buffer), NULL);
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				width_buffer = (g_free (width_buffer), NULL);
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (filter);
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (color_space);
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_object_unref0 (image);
#line 276 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_page_unref0 (page);
#line 3666 "book.c"
			}
		}
	}
#line 484 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp348_ = writer;
#line 484 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp348_, "\n");
#line 485 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp349_ = writer;
#line 485 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp350_ = pdf_writer_start_object (_tmp349_);
#line 485 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	info_number = _tmp350_;
#line 486 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp351_ = writer;
#line 486 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp352_ = info_number;
#line 486 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp353_ = g_strdup_printf ("%u 0 obj\n", _tmp352_);
#line 486 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp354_ = _tmp353_;
#line 486 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp351_, _tmp354_);
#line 486 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (_tmp354_);
#line 487 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp355_ = writer;
#line 487 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp355_, "<<\n");
#line 488 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp356_ = writer;
#line 488 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp357_ = g_strdup_printf ("/Creator (Simple Scan %s)\n", VERSION);
#line 488 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp358_ = _tmp357_;
#line 488 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp356_, _tmp358_);
#line 488 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (_tmp358_);
#line 489 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp359_ = writer;
#line 489 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp359_, ">>\n");
#line 490 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp360_ = writer;
#line 490 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp360_, "endobj\n");
#line 493 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp361_ = writer;
#line 493 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp361_, "\n");
#line 494 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp362_ = writer;
#line 494 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp363_ = _tmp362_->offset;
#line 494 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	xref_offset = _tmp363_;
#line 495 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp364_ = writer;
#line 495 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp364_, "xref\n");
#line 496 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp365_ = writer;
#line 496 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp366_ = writer;
#line 496 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp367_ = _tmp366_->object_offsets;
#line 496 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp368_ = g_list_length (_tmp367_);
#line 496 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp369_ = g_strdup_printf ("0 %zu\n", (gsize) (_tmp368_ + 1));
#line 496 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp370_ = _tmp369_;
#line 496 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp365_, _tmp370_);
#line 496 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (_tmp370_);
#line 497 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp371_ = writer;
#line 497 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp371_, "0000000000 65535 f \n");
#line 498 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp372_ = writer;
#line 498 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp373_ = _tmp372_->object_offsets;
#line 3752 "book.c"
	{
		GList* offset_collection = NULL;
		GList* offset_it = NULL;
#line 498 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		offset_collection = _tmp373_;
#line 498 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		for (offset_it = offset_collection; offset_it != NULL; offset_it = offset_it->next) {
#line 3760 "book.c"
			guint offset = 0U;
#line 498 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			offset = (guint) ((guintptr) offset_it->data);
#line 3764 "book.c"
			{
				PDFWriter* _tmp374_ = NULL;
				guint _tmp375_ = 0U;
				gchar* _tmp376_ = NULL;
				gchar* _tmp377_ = NULL;
#line 499 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp374_ = writer;
#line 499 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp375_ = offset;
#line 499 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp376_ = g_strdup_printf ("%010zu 00000 n \n", (gsize) _tmp375_);
#line 499 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp377_ = _tmp376_;
#line 499 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				pdf_writer_write_string (_tmp374_, _tmp377_);
#line 499 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_g_free0 (_tmp377_);
#line 3782 "book.c"
			}
		}
	}
#line 502 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp378_ = writer;
#line 502 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp378_, "\n");
#line 503 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp379_ = writer;
#line 503 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp379_, "trailer\n");
#line 504 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp380_ = writer;
#line 504 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp380_, "<<\n");
#line 505 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp381_ = writer;
#line 505 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp382_ = writer;
#line 505 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp383_ = _tmp382_->object_offsets;
#line 505 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp384_ = g_list_length (_tmp383_);
#line 505 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp385_ = g_strdup_printf ("/Size %zu\n", (gsize) (_tmp384_ + 1));
#line 505 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp386_ = _tmp385_;
#line 505 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp381_, _tmp386_);
#line 505 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (_tmp386_);
#line 506 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp387_ = writer;
#line 506 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp388_ = info_number;
#line 506 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp389_ = g_strdup_printf ("/Info %u 0 R\n", _tmp388_);
#line 506 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp390_ = _tmp389_;
#line 506 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp387_, _tmp390_);
#line 506 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (_tmp390_);
#line 507 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp391_ = writer;
#line 507 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp392_ = catalog_number;
#line 507 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp393_ = g_strdup_printf ("/Root %u 0 R\n", _tmp392_);
#line 507 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp394_ = _tmp393_;
#line 507 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp391_, _tmp394_);
#line 507 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (_tmp394_);
#line 508 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp395_ = writer;
#line 508 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp396_ = id;
#line 508 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp397_ = id;
#line 508 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp398_ = g_strdup_printf ("/ID [<%s> <%s>]\n", _tmp396_, _tmp397_);
#line 508 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp399_ = _tmp398_;
#line 508 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp395_, _tmp399_);
#line 508 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (_tmp399_);
#line 509 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp400_ = writer;
#line 509 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp400_, ">>\n");
#line 510 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp401_ = writer;
#line 510 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp401_, "startxref\n");
#line 511 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp402_ = writer;
#line 511 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp403_ = xref_offset;
#line 511 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp404_ = g_strdup_printf ("%zu\n", _tmp403_);
#line 511 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp405_ = _tmp404_;
#line 511 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp402_, _tmp405_);
#line 511 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (_tmp405_);
#line 512 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp406_ = writer;
#line 512 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write_string (_tmp406_, "%%EOF\n");
#line 220 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_pdf_writer_unref0 (writer);
#line 220 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_object_unref0 (stream);
#line 220 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_free0 (id);
#line 3882 "book.c"
}


void book_save (Book* self, const gchar* type, GFile* file, GError** error) {
	GCompareFunc _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GError * _inner_error_ = NULL;
#line 515 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (self != NULL);
#line 515 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (type != NULL);
#line 515 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (file != NULL);
#line 517 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = g_strcmp0;
#line 517 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp1_ = type;
#line 517 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp2_ = _tmp0_ (_tmp1_, "jpeg");
#line 517 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (_tmp2_ == 0) {
#line 3905 "book.c"
		GFile* _tmp3_ = NULL;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp3_ = file;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		book_save_multi_file (self, "jpeg", _tmp3_, &_inner_error_);
#line 518 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		if (_inner_error_ != NULL) {
#line 518 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			g_propagate_error (error, _inner_error_);
#line 518 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			return;
#line 3917 "book.c"
		}
	} else {
		GCompareFunc _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 519 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp4_ = g_strcmp0;
#line 519 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp5_ = type;
#line 519 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp6_ = _tmp4_ (_tmp5_, "png");
#line 519 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		if (_tmp6_ == 0) {
#line 3931 "book.c"
			GFile* _tmp7_ = NULL;
#line 520 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			_tmp7_ = file;
#line 520 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			book_save_multi_file (self, "png", _tmp7_, &_inner_error_);
#line 520 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			if (_inner_error_ != NULL) {
#line 520 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				g_propagate_error (error, _inner_error_);
#line 520 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				return;
#line 3943 "book.c"
			}
		} else {
			GCompareFunc _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gint _tmp10_ = 0;
#line 521 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			_tmp8_ = g_strcmp0;
#line 521 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			_tmp9_ = type;
#line 521 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			_tmp10_ = _tmp8_ (_tmp9_, "tiff");
#line 521 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			if (_tmp10_ == 0) {
#line 3957 "book.c"
				GFile* _tmp11_ = NULL;
#line 522 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp11_ = file;
#line 522 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				book_save_multi_file (self, "tiff", _tmp11_, &_inner_error_);
#line 522 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				if (_inner_error_ != NULL) {
#line 522 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 522 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					return;
#line 3969 "book.c"
				}
			} else {
				GCompareFunc _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gint _tmp14_ = 0;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp12_ = g_strcmp0;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp13_ = type;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp14_ = _tmp12_ (_tmp13_, "ps");
#line 523 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				if (_tmp14_ == 0) {
#line 3983 "book.c"
					GFile* _tmp15_ = NULL;
#line 524 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp15_ = file;
#line 524 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					book_save_ps (self, _tmp15_, &_inner_error_);
#line 524 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					if (_inner_error_ != NULL) {
#line 524 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						g_propagate_error (error, _inner_error_);
#line 524 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						return;
#line 3995 "book.c"
					}
				} else {
					GCompareFunc _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					gint _tmp18_ = 0;
#line 525 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp16_ = g_strcmp0;
#line 525 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp17_ = type;
#line 525 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					_tmp18_ = _tmp16_ (_tmp17_, "pdf");
#line 525 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
					if (_tmp18_ == 0) {
#line 4009 "book.c"
						GFile* _tmp19_ = NULL;
#line 526 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						_tmp19_ = file;
#line 526 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						book_save_pdf (self, _tmp19_, &_inner_error_);
#line 526 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
						if (_inner_error_ != NULL) {
#line 526 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							g_propagate_error (error, _inner_error_);
#line 526 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
							return;
#line 4021 "book.c"
						}
					}
				}
			}
		}
	}
}


void book_set_needs_saving (Book* self, gboolean needs_saving) {
	gboolean needed_saving = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 529 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (self != NULL);
#line 531 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = self->priv->needs_saving;
#line 531 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	needed_saving = _tmp0_;
#line 532 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp1_ = needs_saving;
#line 532 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->priv->needs_saving = _tmp1_;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp2_ = needed_saving;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp3_ = needs_saving;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (_tmp2_ != _tmp3_) {
#line 534 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_signal_emit_by_name (self, "needs-saving-changed");
#line 4055 "book.c"
	}
}


gboolean book_get_needs_saving (Book* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 537 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 539 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = self->priv->needs_saving;
#line 539 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	result = _tmp0_;
#line 539 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return result;
#line 4071 "book.c"
}


static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__PAGE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__PAGE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (n_param_values == 2);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		data2 = param_values->data[0].v_pointer;
#line 4090 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		data2 = closure->data;
#line 4096 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	callback = (GMarshalFunc_VOID__PAGE) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	callback (data1, value_get_page (param_values + 1), data2);
#line 4102 "book.c"
}


static void value_book_init (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 4109 "book.c"
}


static void value_book_free_value (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		book_unref (value->data[0].v_pointer);
#line 4118 "book.c"
	}
}


static void value_book_copy_value (const GValue* src_value, GValue* dest_value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		dest_value->data[0].v_pointer = book_ref (src_value->data[0].v_pointer);
#line 4128 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4132 "book.c"
	}
}


static gpointer value_book_peek_pointer (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return value->data[0].v_pointer;
#line 4140 "book.c"
}


static gchar* value_book_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 4147 "book.c"
		Book* object;
		object = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4154 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4158 "book.c"
		}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = book_ref (object);
#line 4162 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4166 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return NULL;
#line 4170 "book.c"
}


static gchar* value_book_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Book** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (!object_p) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4181 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		*object_p = NULL;
#line 4187 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 4191 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		*object_p = book_ref (value->data[0].v_pointer);
#line 4195 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return NULL;
#line 4199 "book.c"
}


GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBook* spec;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BOOK), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 4213 "book.c"
}


gpointer value_get_book (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return value->data[0].v_pointer;
#line 4222 "book.c"
}


void value_set_book (GValue* value, gpointer v_object) {
	Book* old;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		book_ref (value->data[0].v_pointer);
#line 4242 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4246 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		book_unref (old);
#line 4252 "book.c"
	}
}


void value_take_book (GValue* value, gpointer v_object) {
	Book* old;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 4271 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4275 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		book_unref (old);
#line 4281 "book.c"
	}
}


static void book_class_init (BookClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	book_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	BOOK_CLASS (klass)->finalize = book_finalize;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_type_class_add_private (klass, sizeof (BookPrivate));
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_new ("page_added", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_new ("page_removed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_new ("reordered", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_new ("cleared", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_signal_new ("needs_saving_changed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 4303 "book.c"
}


static void book_instance_init (Book * self) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->priv = BOOK_GET_PRIVATE (self);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->ref_count = 1;
#line 4312 "book.c"
}


static void book_finalize (Book* obj) {
	Book * self;
	GList* _tmp0_ = NULL;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK, Book);
#line 31 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 4323 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 31 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		page_collection = _tmp0_;
#line 31 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 4331 "book.c"
			Page* _tmp1_ = NULL;
			Page* page = NULL;
#line 31 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 31 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			page = _tmp1_;
#line 4338 "book.c"
			{
				Page* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
				Page* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
#line 33 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp2_ = page;
#line 33 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 33 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 34 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_tmp4_ = page;
#line 34 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 34 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 31 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
				_page_unref0 (page);
#line 4358 "book.c"
			}
		}
	}
#line 14 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 4364 "book.c"
}


GType book_get_type (void) {
	static volatile gsize book_type_id__volatile = 0;
	if (g_once_init_enter (&book_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_book_init, value_book_free_value, value_book_copy_value, value_book_peek_pointer, "p", value_book_collect_value, "p", value_book_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Book), 0, (GInstanceInitFunc) book_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType book_type_id;
		book_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Book", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&book_type_id__volatile, book_type_id);
	}
	return book_type_id__volatile;
}


gpointer book_ref (gpointer instance) {
	Book* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return instance;
#line 4389 "book.c"
}


void book_unref (gpointer instance) {
	Book* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		BOOK_GET_CLASS (self)->finalize (self);
#line 12 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4402 "book.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 551 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return self ? g_object_ref (self) : NULL;
#line 4410 "book.c"
}


PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream) {
	PDFWriter* self = NULL;
	GFileOutputStream* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
#line 549 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 549 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self = (PDFWriter*) g_type_create_instance (object_type);
#line 551 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = stream;
#line 551 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 551 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 551 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->priv->stream = _tmp1_;
#line 549 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return self;
#line 4432 "book.c"
}


PDFWriter* pdf_writer_new (GFileOutputStream* stream) {
#line 549 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return pdf_writer_construct (TYPE_PDF_WRITER, stream);
#line 4439 "book.c"
}


void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1) {
	gsize _tmp4_ = 0UL;
	guint8* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GError * _inner_error_ = NULL;
#line 554 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (self != NULL);
#line 4450 "book.c"
	{
		GFileOutputStream* _tmp0_ = NULL;
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 558 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp0_ = self->priv->stream;
#line 558 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp1_ = data;
#line 558 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp1__length1 = data_length1;
#line 558 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 558 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		if (_inner_error_ != NULL) {
#line 4465 "book.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 556 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		e = _inner_error_;
#line 556 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_inner_error_ = NULL;
#line 562 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp2_ = e;
#line 562 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp3_ = _tmp2_->message;
#line 562 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_warning ("book.vala:562: Error writing PDF: %s", _tmp3_);
#line 556 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_g_error_free0 (e);
#line 4487 "book.c"
	}
	__finally0:
#line 556 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (_inner_error_ != NULL) {
#line 556 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 556 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_clear_error (&_inner_error_);
#line 556 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		return;
#line 4498 "book.c"
	}
#line 564 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp4_ = self->offset;
#line 564 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp5_ = data;
#line 564 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp5__length1 = data_length1;
#line 564 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->offset = _tmp4_ + _tmp5__length1;
#line 4508 "book.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 1303 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1304 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1304 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1304 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1304 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1304 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1304 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1305 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1305 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1306 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1306 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1306 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1306 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1306 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1307 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1307 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1307 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1307 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 4563 "book.c"
	}
#line 1307 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1307 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 4569 "book.c"
}


void pdf_writer_write_string (PDFWriter* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 567 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (self != NULL);
#line 567 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (text != NULL);
#line 569 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = text;
#line 569 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
#line 569 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp3_ = (guint8*) _tmp2_;
#line 569 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp3__length1 = (_tmp1_ * sizeof (gchar)) / sizeof (guint8);
#line 569 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_write (self, _tmp3_, (_tmp1_ * sizeof (gchar)) / sizeof (guint8));
#line 569 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp3_ = (g_free (_tmp3_), NULL);
#line 4595 "book.c"
}


guint pdf_writer_start_object (PDFWriter* self) {
	guint result = 0U;
	gsize _tmp0_ = 0UL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 572 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 574 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = self->offset;
#line 574 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->object_offsets = g_list_append (self->object_offsets, (gpointer) ((guintptr) ((guint) _tmp0_)));
#line 575 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp1_ = self->object_offsets;
#line 575 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp2_ = g_list_length (_tmp1_);
#line 575 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	result = _tmp2_;
#line 575 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return result;
#line 4618 "book.c"
}


static void value_pdf_writer_init (GValue* value) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 4625 "book.c"
}


static void value_pdf_writer_free_value (GValue* value) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (value->data[0].v_pointer) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		pdf_writer_unref (value->data[0].v_pointer);
#line 4634 "book.c"
	}
}


static void value_pdf_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		dest_value->data[0].v_pointer = pdf_writer_ref (src_value->data[0].v_pointer);
#line 4644 "book.c"
	} else {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4648 "book.c"
	}
}


static gpointer value_pdf_writer_peek_pointer (const GValue* value) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return value->data[0].v_pointer;
#line 4656 "book.c"
}


static gchar* value_pdf_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 4663 "book.c"
		PDFWriter* object;
		object = collect_values[0].v_pointer;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4670 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4674 "book.c"
		}
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = pdf_writer_ref (object);
#line 4678 "book.c"
	} else {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4682 "book.c"
	}
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return NULL;
#line 4686 "book.c"
}


static gchar* value_pdf_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PDFWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (!object_p) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4697 "book.c"
	}
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		*object_p = NULL;
#line 4703 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 4707 "book.c"
	} else {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		*object_p = pdf_writer_ref (value->data[0].v_pointer);
#line 4711 "book.c"
	}
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return NULL;
#line 4715 "book.c"
}


GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPDFWriter* spec;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PDF_WRITER), NULL);
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 4729 "book.c"
}


gpointer value_get_pdf_writer (const GValue* value) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER), NULL);
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return value->data[0].v_pointer;
#line 4738 "book.c"
}


void value_set_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	old = value->data[0].v_pointer;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (v_object) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		pdf_writer_ref (value->data[0].v_pointer);
#line 4758 "book.c"
	} else {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4762 "book.c"
	}
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (old) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		pdf_writer_unref (old);
#line 4768 "book.c"
	}
}


void value_take_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	old = value->data[0].v_pointer;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (v_object) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 4787 "book.c"
	} else {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4791 "book.c"
	}
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (old) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		pdf_writer_unref (old);
#line 4797 "book.c"
	}
}


static void pdf_writer_class_init (PDFWriterClass * klass) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	pdf_writer_parent_class = g_type_class_peek_parent (klass);
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	PDF_WRITER_CLASS (klass)->finalize = pdf_writer_finalize;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_type_class_add_private (klass, sizeof (PDFWriterPrivate));
#line 4809 "book.c"
}


static void pdf_writer_instance_init (PDFWriter * self) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->priv = PDF_WRITER_GET_PRIVATE (self);
#line 545 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->offset = (gsize) 0;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->ref_count = 1;
#line 4820 "book.c"
}


static void pdf_writer_finalize (PDFWriter* obj) {
	PDFWriter * self;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PDF_WRITER, PDFWriter);
#line 546 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_list_free0 (self->object_offsets);
#line 547 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 4832 "book.c"
}


GType pdf_writer_get_type (void) {
	static volatile gsize pdf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pdf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pdf_writer_init, value_pdf_writer_free_value, value_pdf_writer_copy_value, value_pdf_writer_peek_pointer, "p", value_pdf_writer_collect_value, "p", value_pdf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PDFWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PDFWriter), 0, (GInstanceInitFunc) pdf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pdf_writer_type_id;
		pdf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PDFWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pdf_writer_type_id__volatile, pdf_writer_type_id);
	}
	return pdf_writer_type_id__volatile;
}


gpointer pdf_writer_ref (gpointer instance) {
	PDFWriter* self;
	self = instance;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return instance;
#line 4857 "book.c"
}


void pdf_writer_unref (gpointer instance) {
	PDFWriter* self;
	self = instance;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		PDF_WRITER_GET_CLASS (self)->finalize (self);
#line 543 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4870 "book.c"
	}
}


static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1) {
	cairo_status_t result;
	result = ps_writer_write_cairo_data ((PsWriter*) self, data, data_length1);
#line 587 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return result;
#line 4880 "book.c"
}


PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream) {
	PsWriter* self = NULL;
	GFileOutputStream* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
#line 584 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 584 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self = (PsWriter*) g_type_create_instance (object_type);
#line 586 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp0_ = stream;
#line 586 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 586 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_object_unref0 (self->stream);
#line 586 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->stream = _tmp1_;
#line 587 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_tmp2_ = cairo_ps_surface_create_for_stream (_ps_writer_write_cairo_data_cairo_write_func_t, self, (gdouble) 0, (gdouble) 0);
#line 587 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 587 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->surface = _tmp2_;
#line 584 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return self;
#line 4909 "book.c"
}


PsWriter* ps_writer_new (GFileOutputStream* stream) {
#line 584 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return ps_writer_construct (TYPE_PS_WRITER, stream);
#line 4916 "book.c"
}


static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1) {
	cairo_status_t result = 0;
	GError * _inner_error_ = NULL;
#line 590 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 4925 "book.c"
	{
		GFileOutputStream* _tmp0_ = NULL;
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 594 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp0_ = self->stream;
#line 594 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp1_ = data;
#line 594 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp1__length1 = data_length1;
#line 594 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 594 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		if (_inner_error_ != NULL) {
#line 4940 "book.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 592 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		e = _inner_error_;
#line 592 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_inner_error_ = NULL;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp2_ = e;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_tmp3_ = _tmp2_->message;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_warning ("book.vala:598: Error writing data: %s", _tmp3_);
#line 599 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		result = CAIRO_STATUS_WRITE_ERROR;
#line 599 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		_g_error_free0 (e);
#line 599 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		return result;
#line 4966 "book.c"
	}
	__finally1:
#line 592 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (_inner_error_ != NULL) {
#line 592 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 592 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_clear_error (&_inner_error_);
#line 592 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		return 0;
#line 4977 "book.c"
	}
#line 602 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	result = CAIRO_STATUS_SUCCESS;
#line 602 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return result;
#line 4983 "book.c"
}


static void value_ps_writer_init (GValue* value) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 4990 "book.c"
}


static void value_ps_writer_free_value (GValue* value) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (value->data[0].v_pointer) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		ps_writer_unref (value->data[0].v_pointer);
#line 4999 "book.c"
	}
}


static void value_ps_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		dest_value->data[0].v_pointer = ps_writer_ref (src_value->data[0].v_pointer);
#line 5009 "book.c"
	} else {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5013 "book.c"
	}
}


static gpointer value_ps_writer_peek_pointer (const GValue* value) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return value->data[0].v_pointer;
#line 5021 "book.c"
}


static gchar* value_ps_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 5028 "book.c"
		PsWriter* object;
		object = collect_values[0].v_pointer;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5035 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5039 "book.c"
		}
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = ps_writer_ref (object);
#line 5043 "book.c"
	} else {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5047 "book.c"
	}
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return NULL;
#line 5051 "book.c"
}


static gchar* value_ps_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PsWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (!object_p) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5062 "book.c"
	}
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		*object_p = NULL;
#line 5068 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 5072 "book.c"
	} else {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		*object_p = ps_writer_ref (value->data[0].v_pointer);
#line 5076 "book.c"
	}
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return NULL;
#line 5080 "book.c"
}


GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPsWriter* spec;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PS_WRITER), NULL);
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 5094 "book.c"
}


gpointer value_get_ps_writer (const GValue* value) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER), NULL);
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return value->data[0].v_pointer;
#line 5103 "book.c"
}


void value_set_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	old = value->data[0].v_pointer;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (v_object) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		ps_writer_ref (value->data[0].v_pointer);
#line 5123 "book.c"
	} else {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5127 "book.c"
	}
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (old) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		ps_writer_unref (old);
#line 5133 "book.c"
	}
}


void value_take_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	old = value->data[0].v_pointer;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (v_object) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 5152 "book.c"
	} else {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5156 "book.c"
	}
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (old) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		ps_writer_unref (old);
#line 5162 "book.c"
	}
}


static void ps_writer_class_init (PsWriterClass * klass) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	ps_writer_parent_class = g_type_class_peek_parent (klass);
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	PS_WRITER_CLASS (klass)->finalize = ps_writer_finalize;
#line 5172 "book.c"
}


static void ps_writer_instance_init (PsWriter * self) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self->ref_count = 1;
#line 5179 "book.c"
}


static void ps_writer_finalize (PsWriter* obj) {
	PsWriter * self;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PS_WRITER, PsWriter);
#line 581 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 582 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	_g_object_unref0 (self->stream);
#line 5191 "book.c"
}


GType ps_writer_get_type (void) {
	static volatile gsize ps_writer_type_id__volatile = 0;
	if (g_once_init_enter (&ps_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_ps_writer_init, value_ps_writer_free_value, value_ps_writer_copy_value, value_ps_writer_peek_pointer, "p", value_ps_writer_collect_value, "p", value_ps_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PsWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ps_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PsWriter), 0, (GInstanceInitFunc) ps_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ps_writer_type_id;
		ps_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PsWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ps_writer_type_id__volatile, ps_writer_type_id);
	}
	return ps_writer_type_id__volatile;
}


gpointer ps_writer_ref (gpointer instance) {
	PsWriter* self;
	self = instance;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	return instance;
#line 5216 "book.c"
}


void ps_writer_unref (gpointer instance) {
	PsWriter* self;
	self = instance;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		PS_WRITER_GET_CLASS (self)->finalize (self);
#line 579 "/home/bob/bzr/simple-scan/3.4/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5229 "book.c"
	}
}



