/* scanner.c generated by valac 0.24.0, the Vala compiler
 * generated from scanner.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* TODO: Could indicate the start of the next page immediately after the last page is received (i.e. before the sane_cancel()) */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include "sane/sane.h"
#include <glib/gi18n-lib.h>
#include "sane/saneopts.h"
#include <gobject/gvaluecollector.h>


#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecScanDevice ParamSpecScanDevice;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ParamSpecScanPageInfo ParamSpecScanPageInfo;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanLinePrivate ScanLinePrivate;
typedef struct _ParamSpecScanLine ParamSpecScanLine;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
typedef struct _ParamSpecScanOptions ParamSpecScanOptions;

#define TYPE_SCAN_JOB (scan_job_get_type ())
#define SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_JOB, ScanJob))
#define SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_JOB, ScanJobClass))
#define IS_SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_JOB))
#define IS_SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_JOB))
#define SCAN_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_JOB, ScanJobClass))

typedef struct _ScanJob ScanJob;
typedef struct _ScanJobClass ScanJobClass;
typedef struct _ScanJobPrivate ScanJobPrivate;
typedef struct _ParamSpecScanJob ParamSpecScanJob;

#define TYPE_REQUEST (request_get_type ())
#define REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST, Request))
#define REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST, RequestClass))
#define IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST))
#define IS_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST))
#define REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST, RequestClass))

typedef struct _Request Request;
typedef struct _RequestClass RequestClass;
typedef struct _RequestPrivate RequestPrivate;
typedef struct _ParamSpecRequest ParamSpecRequest;

#define TYPE_REQUEST_REDETECT (request_redetect_get_type ())
#define REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_REDETECT, RequestRedetect))
#define REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_REDETECT, RequestRedetectClass))
#define IS_REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_REDETECT))
#define IS_REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_REDETECT))
#define REQUEST_REDETECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_REDETECT, RequestRedetectClass))

typedef struct _RequestRedetect RequestRedetect;
typedef struct _RequestRedetectClass RequestRedetectClass;
typedef struct _RequestRedetectPrivate RequestRedetectPrivate;

#define TYPE_REQUEST_CANCEL (request_cancel_get_type ())
#define REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_CANCEL, RequestCancel))
#define REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_CANCEL, RequestCancelClass))
#define IS_REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_CANCEL))
#define IS_REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_CANCEL))
#define REQUEST_CANCEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_CANCEL, RequestCancelClass))

typedef struct _RequestCancel RequestCancel;
typedef struct _RequestCancelClass RequestCancelClass;
typedef struct _RequestCancelPrivate RequestCancelPrivate;

#define TYPE_REQUEST_START_SCAN (request_start_scan_get_type ())
#define REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_START_SCAN, RequestStartScan))
#define REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_START_SCAN, RequestStartScanClass))
#define IS_REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_START_SCAN))
#define IS_REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_START_SCAN))
#define REQUEST_START_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_START_SCAN, RequestStartScanClass))

typedef struct _RequestStartScan RequestStartScan;
typedef struct _RequestStartScanClass RequestStartScanClass;
typedef struct _RequestStartScanPrivate RequestStartScanPrivate;
#define _scan_job_unref0(var) ((var == NULL) ? NULL : (var = (scan_job_unref (var), NULL)))

#define TYPE_REQUEST_QUIT (request_quit_get_type ())
#define REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_QUIT, RequestQuit))
#define REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_QUIT, RequestQuitClass))
#define IS_REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_QUIT))
#define IS_REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_QUIT))
#define REQUEST_QUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_QUIT, RequestQuitClass))

typedef struct _RequestQuit RequestQuit;
typedef struct _RequestQuitClass RequestQuitClass;
typedef struct _RequestQuitPrivate RequestQuitPrivate;

#define TYPE_CREDENTIALS (credentials_get_type ())
#define CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CREDENTIALS, Credentials))
#define CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CREDENTIALS, CredentialsClass))
#define IS_CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CREDENTIALS))
#define IS_CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CREDENTIALS))
#define CREDENTIALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CREDENTIALS, CredentialsClass))

typedef struct _Credentials Credentials;
typedef struct _CredentialsClass CredentialsClass;
typedef struct _CredentialsPrivate CredentialsPrivate;
typedef struct _ParamSpecCredentials ParamSpecCredentials;

#define TYPE_SCAN_STATE (scan_state_get_type ())

#define TYPE_NOTIFY (notify_get_type ())
#define NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY, Notify))
#define NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY, NotifyClass))
#define IS_NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY))
#define IS_NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY))
#define NOTIFY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY, NotifyClass))

typedef struct _Notify Notify;
typedef struct _NotifyClass NotifyClass;
typedef struct _NotifyPrivate NotifyPrivate;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;
typedef struct _ParamSpecNotify ParamSpecNotify;

#define TYPE_NOTIFY_SCANNING_CHANGED (notify_scanning_changed_get_type ())
#define NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChanged))
#define NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))
#define IS_NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCANNING_CHANGED))
#define IS_NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCANNING_CHANGED))
#define NOTIFY_SCANNING_CHANGED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))

typedef struct _NotifyScanningChanged NotifyScanningChanged;
typedef struct _NotifyScanningChangedClass NotifyScanningChangedClass;
typedef struct _NotifyScanningChangedPrivate NotifyScanningChangedPrivate;

#define TYPE_NOTIFY_UPDATE_DEVICES (notify_update_devices_get_type ())
#define NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevices))
#define NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))
#define IS_NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_UPDATE_DEVICES))
#define IS_NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_UPDATE_DEVICES))
#define NOTIFY_UPDATE_DEVICES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))

typedef struct _NotifyUpdateDevices NotifyUpdateDevices;
typedef struct _NotifyUpdateDevicesClass NotifyUpdateDevicesClass;
typedef struct _NotifyUpdateDevicesPrivate NotifyUpdateDevicesPrivate;
#define __g_list_free__scan_device_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_device_unref0_ (var), NULL)))

#define TYPE_NOTIFY_REQUEST_AUTHORIZATION (notify_request_authorization_get_type ())
#define NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorization))
#define NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))
#define IS_NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define IS_NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define NOTIFY_REQUEST_AUTHORIZATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))

typedef struct _NotifyRequestAuthorization NotifyRequestAuthorization;
typedef struct _NotifyRequestAuthorizationClass NotifyRequestAuthorizationClass;
typedef struct _NotifyRequestAuthorizationPrivate NotifyRequestAuthorizationPrivate;

#define TYPE_NOTIFY_SCAN_FAILED (notify_scan_failed_get_type ())
#define NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailed))
#define NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))
#define IS_NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCAN_FAILED))
#define IS_NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCAN_FAILED))
#define NOTIFY_SCAN_FAILED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))

typedef struct _NotifyScanFailed NotifyScanFailed;
typedef struct _NotifyScanFailedClass NotifyScanFailedClass;
typedef struct _NotifyScanFailedPrivate NotifyScanFailedPrivate;

#define TYPE_NOTIFY_DOCUMENT_DONE (notify_document_done_get_type ())
#define NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDone))
#define NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))
#define IS_NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_DOCUMENT_DONE))
#define IS_NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_DOCUMENT_DONE))
#define NOTIFY_DOCUMENT_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))

typedef struct _NotifyDocumentDone NotifyDocumentDone;
typedef struct _NotifyDocumentDoneClass NotifyDocumentDoneClass;
typedef struct _NotifyDocumentDonePrivate NotifyDocumentDonePrivate;

#define TYPE_NOTIFY_EXPECT_PAGE (notify_expect_page_get_type ())
#define NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPage))
#define NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))
#define IS_NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_EXPECT_PAGE))
#define IS_NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_EXPECT_PAGE))
#define NOTIFY_EXPECT_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))

typedef struct _NotifyExpectPage NotifyExpectPage;
typedef struct _NotifyExpectPageClass NotifyExpectPageClass;
typedef struct _NotifyExpectPagePrivate NotifyExpectPagePrivate;

#define TYPE_NOTIFY_GOT_PAGE_INFO (notify_got_page_info_get_type ())
#define NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfo))
#define NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))
#define IS_NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_PAGE_INFO))
#define IS_NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_PAGE_INFO))
#define NOTIFY_GOT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))

typedef struct _NotifyGotPageInfo NotifyGotPageInfo;
typedef struct _NotifyGotPageInfoClass NotifyGotPageInfoClass;
typedef struct _NotifyGotPageInfoPrivate NotifyGotPageInfoPrivate;
#define _scan_page_info_unref0(var) ((var == NULL) ? NULL : (var = (scan_page_info_unref (var), NULL)))
typedef struct _ScannerPrivate ScannerPrivate;

#define TYPE_NOTIFY_PAGE_DONE (notify_page_done_get_type ())
#define NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDone))
#define NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))
#define IS_NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_PAGE_DONE))
#define IS_NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_PAGE_DONE))
#define NOTIFY_PAGE_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))

typedef struct _NotifyPageDone NotifyPageDone;
typedef struct _NotifyPageDoneClass NotifyPageDoneClass;
typedef struct _NotifyPageDonePrivate NotifyPageDonePrivate;

#define TYPE_NOTIFY_GOT_LINE (notify_got_line_get_type ())
#define NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLine))
#define NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))
#define IS_NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_LINE))
#define IS_NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_LINE))
#define NOTIFY_GOT_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))

typedef struct _NotifyGotLine NotifyGotLine;
typedef struct _NotifyGotLineClass NotifyGotLineClass;
typedef struct _NotifyGotLinePrivate NotifyGotLinePrivate;
#define _scan_line_unref0(var) ((var == NULL) ? NULL : (var = (scan_line_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define __g_list_free__scan_job_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_job_unref0_ (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _notify_unref0(var) ((var == NULL) ? NULL : (var = (notify_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _credentials_unref0(var) ((var == NULL) ? NULL : (var = (credentials_unref (var), NULL)))
#define _request_unref0(var) ((var == NULL) ? NULL : (var = (request_unref (var), NULL)))
typedef struct _ParamSpecScanner ParamSpecScanner;

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

struct _ParamSpecScanDevice {
	GParamSpec parent_instance;
};

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

struct _ParamSpecScanPageInfo {
	GParamSpec parent_instance;
};

struct _ScanLine {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanLinePrivate * priv;
	gint number;
	gint n_lines;
	gint width;
	gint depth;
	gint channel;
	guchar* data;
	gint data_length1;
	gint data_length;
};

struct _ScanLineClass {
	GTypeClass parent_class;
	void (*finalize) (ScanLine *self);
};

struct _ParamSpecScanLine {
	GParamSpec parent_instance;
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecScanOptions {
	GParamSpec parent_instance;
};

struct _ScanJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanJobPrivate * priv;
	gint id;
	gchar* device;
	gdouble dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint page_width;
	gint page_height;
};

struct _ScanJobClass {
	GTypeClass parent_class;
	void (*finalize) (ScanJob *self);
};

struct _ParamSpecScanJob {
	GParamSpec parent_instance;
};

struct _Request {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RequestPrivate * priv;
};

struct _RequestClass {
	GTypeClass parent_class;
	void (*finalize) (Request *self);
};

struct _ParamSpecRequest {
	GParamSpec parent_instance;
};

struct _RequestRedetect {
	Request parent_instance;
	RequestRedetectPrivate * priv;
};

struct _RequestRedetectClass {
	RequestClass parent_class;
};

struct _RequestCancel {
	Request parent_instance;
	RequestCancelPrivate * priv;
};

struct _RequestCancelClass {
	RequestClass parent_class;
};

struct _RequestStartScan {
	Request parent_instance;
	RequestStartScanPrivate * priv;
	ScanJob* job;
};

struct _RequestStartScanClass {
	RequestClass parent_class;
};

struct _RequestQuit {
	Request parent_instance;
	RequestQuitPrivate * priv;
};

struct _RequestQuitClass {
	RequestClass parent_class;
};

struct _Credentials {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CredentialsPrivate * priv;
	gchar* username;
	gchar* password;
};

struct _CredentialsClass {
	GTypeClass parent_class;
	void (*finalize) (Credentials *self);
};

struct _ParamSpecCredentials {
	GParamSpec parent_instance;
};

typedef enum  {
	SCAN_STATE_IDLE = 0,
	SCAN_STATE_REDETECT,
	SCAN_STATE_OPEN,
	SCAN_STATE_GET_OPTION,
	SCAN_STATE_START,
	SCAN_STATE_GET_PARAMETERS,
	SCAN_STATE_READ
} ScanState;

struct _Notify {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NotifyPrivate * priv;
};

struct _NotifyClass {
	GTypeClass parent_class;
	void (*finalize) (Notify *self);
	void (*run) (Notify* self, Scanner* scanner);
};

struct _ParamSpecNotify {
	GParamSpec parent_instance;
};

struct _NotifyScanningChanged {
	Notify parent_instance;
	NotifyScanningChangedPrivate * priv;
};

struct _NotifyScanningChangedClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevices {
	Notify parent_instance;
	NotifyUpdateDevicesPrivate * priv;
};

struct _NotifyUpdateDevicesClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevicesPrivate {
	GList* devices;
};

struct _NotifyRequestAuthorization {
	Notify parent_instance;
	NotifyRequestAuthorizationPrivate * priv;
};

struct _NotifyRequestAuthorizationClass {
	NotifyClass parent_class;
};

struct _NotifyRequestAuthorizationPrivate {
	gchar* resource;
};

struct _NotifyScanFailed {
	Notify parent_instance;
	NotifyScanFailedPrivate * priv;
};

struct _NotifyScanFailedClass {
	NotifyClass parent_class;
};

struct _NotifyScanFailedPrivate {
	gint error_code;
	gchar* error_string;
};

struct _NotifyDocumentDone {
	Notify parent_instance;
	NotifyDocumentDonePrivate * priv;
};

struct _NotifyDocumentDoneClass {
	NotifyClass parent_class;
};

struct _NotifyExpectPage {
	Notify parent_instance;
	NotifyExpectPagePrivate * priv;
};

struct _NotifyExpectPageClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfo {
	Notify parent_instance;
	NotifyGotPageInfoPrivate * priv;
};

struct _NotifyGotPageInfoClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfoPrivate {
	gint job_id;
	ScanPageInfo* info;
};

struct _Scanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScannerPrivate * priv;
	gint first_job_id;
	gint job_id;
};

struct _ScannerClass {
	GTypeClass parent_class;
	void (*finalize) (Scanner *self);
};

struct _NotifyPageDone {
	Notify parent_instance;
	NotifyPageDonePrivate * priv;
};

struct _NotifyPageDoneClass {
	NotifyClass parent_class;
};

struct _NotifyPageDonePrivate {
	gint job_id;
};

struct _NotifyGotLine {
	Notify parent_instance;
	NotifyGotLinePrivate * priv;
};

struct _NotifyGotLineClass {
	NotifyClass parent_class;
};

struct _NotifyGotLinePrivate {
	gint job_id;
	ScanLine* line;
};

struct _ScannerPrivate {
	GThread* thread;
	GAsyncQueue* request_queue;
	GAsyncQueue* notify_queue;
	GAsyncQueue* authorize_queue;
	gchar* default_device;
	ScanState state;
	gboolean need_redetect;
	GList* job_queue;
	SANE_Handle handle;
	gboolean have_handle;
	gchar* current_device;
	SANE_Parameters parameters;
	SANE_Int option_index;
	GHashTable* options;
	guchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gint n_used;
	gint line_count;
	gint pass_number;
	gint page_number;
	gint notified_page;
	gboolean scanning;
};

struct _ParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer scan_device_parent_class = NULL;
static gpointer scan_page_info_parent_class = NULL;
static gpointer scan_line_parent_class = NULL;
static gpointer scan_options_parent_class = NULL;
static gpointer scan_job_parent_class = NULL;
static gpointer request_parent_class = NULL;
static gpointer request_redetect_parent_class = NULL;
static gpointer request_cancel_parent_class = NULL;
static gpointer request_start_scan_parent_class = NULL;
static gpointer request_quit_parent_class = NULL;
static gpointer credentials_parent_class = NULL;
static gpointer notify_parent_class = NULL;
static gpointer notify_scanning_changed_parent_class = NULL;
static gpointer notify_update_devices_parent_class = NULL;
static gpointer notify_request_authorization_parent_class = NULL;
static gpointer notify_scan_failed_parent_class = NULL;
static gpointer notify_document_done_parent_class = NULL;
static gpointer notify_expect_page_parent_class = NULL;
static gpointer notify_got_page_info_parent_class = NULL;
static gpointer notify_page_done_parent_class = NULL;
static gpointer notify_got_line_parent_class = NULL;
static gpointer scanner_parent_class = NULL;
static Scanner* scanner_scanner_object;
static Scanner* scanner_scanner_object = NULL;

gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_DEVICE_DUMMY_PROPERTY
};
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void scan_device_finalize (ScanDevice* obj);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_PAGE_INFO_DUMMY_PROPERTY
};
ScanPageInfo* scan_page_info_new (void);
ScanPageInfo* scan_page_info_construct (GType object_type);
static void scan_page_info_finalize (ScanPageInfo* obj);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_LINE_DUMMY_PROPERTY
};
ScanLine* scan_line_new (void);
ScanLine* scan_line_construct (GType object_type);
static void scan_line_finalize (ScanLine* obj);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_OPTIONS_DUMMY_PROPERTY
};
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
static void scan_options_finalize (ScanOptions* obj);
gpointer scan_job_ref (gpointer instance);
void scan_job_unref (gpointer instance);
GParamSpec* param_spec_scan_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_job (GValue* value, gpointer v_object);
void value_take_scan_job (GValue* value, gpointer v_object);
gpointer value_get_scan_job (const GValue* value);
GType scan_job_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_JOB_DUMMY_PROPERTY
};
ScanJob* scan_job_new (void);
ScanJob* scan_job_construct (GType object_type);
static void scan_job_finalize (ScanJob* obj);
gpointer request_ref (gpointer instance);
void request_unref (gpointer instance);
GParamSpec* param_spec_request (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_request (GValue* value, gpointer v_object);
void value_take_request (GValue* value, gpointer v_object);
gpointer value_get_request (const GValue* value);
GType request_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_DUMMY_PROPERTY
};
Request* request_new (void);
Request* request_construct (GType object_type);
static void request_finalize (Request* obj);
GType request_redetect_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_REDETECT_DUMMY_PROPERTY
};
RequestRedetect* request_redetect_new (void);
RequestRedetect* request_redetect_construct (GType object_type);
GType request_cancel_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_CANCEL_DUMMY_PROPERTY
};
RequestCancel* request_cancel_new (void);
RequestCancel* request_cancel_construct (GType object_type);
GType request_start_scan_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_START_SCAN_DUMMY_PROPERTY
};
RequestStartScan* request_start_scan_new (void);
RequestStartScan* request_start_scan_construct (GType object_type);
static void request_start_scan_finalize (Request* obj);
GType request_quit_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_QUIT_DUMMY_PROPERTY
};
RequestQuit* request_quit_new (void);
RequestQuit* request_quit_construct (GType object_type);
gpointer credentials_ref (gpointer instance);
void credentials_unref (gpointer instance);
GParamSpec* param_spec_credentials (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_credentials (GValue* value, gpointer v_object);
void value_take_credentials (GValue* value, gpointer v_object);
gpointer value_get_credentials (const GValue* value);
GType credentials_get_type (void) G_GNUC_CONST;
enum  {
	CREDENTIALS_DUMMY_PROPERTY
};
Credentials* credentials_new (void);
Credentials* credentials_construct (GType object_type);
static void credentials_finalize (Credentials* obj);
GType scan_state_get_type (void) G_GNUC_CONST;
gpointer notify_ref (gpointer instance);
void notify_unref (gpointer instance);
GParamSpec* param_spec_notify (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_notify (GValue* value, gpointer v_object);
void value_take_notify (GValue* value, gpointer v_object);
gpointer value_get_notify (const GValue* value);
GType notify_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scanner (GValue* value, gpointer v_object);
void value_take_scanner (GValue* value, gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_DUMMY_PROPERTY
};
void notify_run (Notify* self, Scanner* scanner);
static void notify_real_run (Notify* self, Scanner* scanner);
Notify* notify_new (void);
Notify* notify_construct (GType object_type);
static void notify_finalize (Notify* obj);
GType notify_scanning_changed_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_SCANNING_CHANGED_DUMMY_PROPERTY
};
static void notify_scanning_changed_real_run (Notify* base, Scanner* scanner);
NotifyScanningChanged* notify_scanning_changed_new (void);
NotifyScanningChanged* notify_scanning_changed_construct (GType object_type);
GType notify_update_devices_get_type (void) G_GNUC_CONST;
#define NOTIFY_UPDATE_DEVICES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesPrivate))
enum  {
	NOTIFY_UPDATE_DEVICES_DUMMY_PROPERTY
};
static void _scan_device_unref0_ (gpointer var);
static void _g_list_free__scan_device_unref0_ (GList* self);
NotifyUpdateDevices* notify_update_devices_new (GList* devices);
NotifyUpdateDevices* notify_update_devices_construct (GType object_type, GList* devices);
static void notify_update_devices_real_run (Notify* base, Scanner* scanner);
static void notify_update_devices_finalize (Notify* obj);
GType notify_request_authorization_get_type (void) G_GNUC_CONST;
#define NOTIFY_REQUEST_AUTHORIZATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationPrivate))
enum  {
	NOTIFY_REQUEST_AUTHORIZATION_DUMMY_PROPERTY
};
NotifyRequestAuthorization* notify_request_authorization_new (const gchar* resource);
NotifyRequestAuthorization* notify_request_authorization_construct (GType object_type, const gchar* resource);
static void notify_request_authorization_real_run (Notify* base, Scanner* scanner);
static void notify_request_authorization_finalize (Notify* obj);
GType notify_scan_failed_get_type (void) G_GNUC_CONST;
#define NOTIFY_SCAN_FAILED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedPrivate))
enum  {
	NOTIFY_SCAN_FAILED_DUMMY_PROPERTY
};
NotifyScanFailed* notify_scan_failed_new (gint error_code, const gchar* error_string);
NotifyScanFailed* notify_scan_failed_construct (GType object_type, gint error_code, const gchar* error_string);
static void notify_scan_failed_real_run (Notify* base, Scanner* scanner);
static void notify_scan_failed_finalize (Notify* obj);
GType notify_document_done_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_DOCUMENT_DONE_DUMMY_PROPERTY
};
static void notify_document_done_real_run (Notify* base, Scanner* scanner);
NotifyDocumentDone* notify_document_done_new (void);
NotifyDocumentDone* notify_document_done_construct (GType object_type);
GType notify_expect_page_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_EXPECT_PAGE_DUMMY_PROPERTY
};
static void notify_expect_page_real_run (Notify* base, Scanner* scanner);
NotifyExpectPage* notify_expect_page_new (void);
NotifyExpectPage* notify_expect_page_construct (GType object_type);
GType notify_got_page_info_get_type (void) G_GNUC_CONST;
#define NOTIFY_GOT_PAGE_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoPrivate))
enum  {
	NOTIFY_GOT_PAGE_INFO_DUMMY_PROPERTY
};
NotifyGotPageInfo* notify_got_page_info_new (gint job_id, ScanPageInfo* info);
NotifyGotPageInfo* notify_got_page_info_construct (GType object_type, gint job_id, ScanPageInfo* info);
static void notify_got_page_info_real_run (Notify* base, Scanner* scanner);
static void notify_got_page_info_finalize (Notify* obj);
GType notify_page_done_get_type (void) G_GNUC_CONST;
#define NOTIFY_PAGE_DONE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_PAGE_DONE, NotifyPageDonePrivate))
enum  {
	NOTIFY_PAGE_DONE_DUMMY_PROPERTY
};
NotifyPageDone* notify_page_done_new (gint job_id);
NotifyPageDone* notify_page_done_construct (GType object_type, gint job_id);
static void notify_page_done_real_run (Notify* base, Scanner* scanner);
static void notify_page_done_finalize (Notify* obj);
GType notify_got_line_get_type (void) G_GNUC_CONST;
#define NOTIFY_GOT_LINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_GOT_LINE, NotifyGotLinePrivate))
enum  {
	NOTIFY_GOT_LINE_DUMMY_PROPERTY
};
NotifyGotLine* notify_got_line_new (gint job_id, ScanLine* line);
NotifyGotLine* notify_got_line_construct (GType object_type, gint job_id, ScanLine* line);
static void notify_got_line_real_run (Notify* base, Scanner* scanner);
static void notify_got_line_finalize (Notify* obj);
#define SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCANNER, ScannerPrivate))
enum  {
	SCANNER_DUMMY_PROPERTY
};
static void _scan_job_unref0_ (gpointer var);
static void _g_list_free__scan_job_unref0_ (GList* self);
static Scanner* scanner_new (void);
static Scanner* scanner_construct (GType object_type);
static void _request_unref0_ (gpointer var);
static void _notify_unref0_ (gpointer var);
static void _credentials_unref0_ (gpointer var);
Scanner* scanner_get_instance (void);
static gboolean scanner_notify_idle_cb (Scanner* self);
static void scanner_notify (Scanner* self, Notify* notification);
static gboolean _scanner_notify_idle_cb_gsource_func (gpointer self);
static void scanner_set_scanning (Scanner* self, gboolean is_scanning);
static gint scanner_get_device_weight (const gchar* device);
static gint scanner_compare_devices (ScanDevice* device1, ScanDevice* device2);
static void scanner_do_redetect (Scanner* self);
static gint _scanner_compare_devices_gcompare_func (gconstpointer a, gconstpointer b);
static gboolean scanner_set_default_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index);
static void scanner_set_bool_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gboolean value, gboolean* _result_);
static void scanner_set_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gint value, gint* _result_);
static void scanner_set_fixed_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_);
static void scanner_set_fixed_or_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_);
static void scanner_set_option_to_max (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index);
static gboolean scanner_set_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, const gchar* value, gchar** _result_);
static gboolean scanner_set_constrained_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gchar** values, int values_length1, gchar** _result_);
static void scanner_log_option (Scanner* self, SANE_Int index, SANE_Option_Descriptor* option);
static void scanner_authorization_cb (const gchar* resource, gchar* username, int username_length1, gchar* password, int password_length1);
void scanner_authorize (Scanner* self, const gchar* username, const gchar* password);
static void scanner_close_device (Scanner* self);
static void scanner_fail_scan (Scanner* self, gint error_code, const gchar* error_string);
static gboolean scanner_handle_requests (Scanner* self);
static void scanner_do_open (Scanner* self);
static void _g_free0_ (gpointer var);
static void scanner_do_get_option (Scanner* self);
static SANE_Option_Descriptor* scanner_get_option_by_name (Scanner* self, SANE_Handle handle, const gchar* name, gint* index);
static gdouble scanner_convert_page_size (Scanner* self, SANE_Option_Descriptor* option, gdouble size, gdouble dpi);
static void scanner_do_complete_document (Scanner* self);
static void scanner_do_start (Scanner* self);
static void scanner_do_get_parameters (Scanner* self);
static void scanner_do_complete_page (Scanner* self);
static void scanner_do_read (Scanner* self);
static void* scanner_scan_thread (Scanner* self);
static void _scanner_authorization_cb_sane_authcallback (const gchar* resource, gchar* username, gchar* password);
void scanner_redetect (Scanner* self);
void scanner_start (Scanner* self);
static gpointer _scanner_scan_thread_gthread_func (gpointer self);
gboolean scanner_is_scanning (Scanner* self);
static gchar* scanner_get_scan_mode_string (Scanner* self, ScanMode mode);
static gchar* scanner_get_scan_type_string (Scanner* self, ScanType type);
void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options);
void scanner_cancel (Scanner* self);
void scanner_free (Scanner* self);
static void g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__SCAN_LINE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void scanner_finalize (Scanner* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ScanDevice* scan_device_construct (GType object_type) {
	ScanDevice* self = NULL;
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (ScanDevice*) g_type_create_instance (object_type);
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 980 "scanner.c"
}


ScanDevice* scan_device_new (void) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return scan_device_construct (TYPE_SCAN_DEVICE);
#line 987 "scanner.c"
}


static void value_scan_device_init (GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 994 "scanner.c"
}


static void value_scan_device_free_value (GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_device_unref (value->data[0].v_pointer);
#line 1003 "scanner.c"
	}
}


static void value_scan_device_copy_value (const GValue* src_value, GValue* dest_value) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_device_ref (src_value->data[0].v_pointer);
#line 1013 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1017 "scanner.c"
	}
}


static gpointer value_scan_device_peek_pointer (const GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1025 "scanner.c"
}


static gchar* value_scan_device_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1032 "scanner.c"
		ScanDevice* object;
		object = collect_values[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1039 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1043 "scanner.c"
		}
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = scan_device_ref (object);
#line 1047 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1051 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 1055 "scanner.c"
}


static gchar* value_scan_device_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanDevice** object_p;
	object_p = collect_values[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!object_p) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1066 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = NULL;
#line 1072 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1076 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = scan_device_ref (value->data[0].v_pointer);
#line 1080 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 1084 "scanner.c"
}


GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanDevice* spec;
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_DEVICE), NULL);
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1098 "scanner.c"
}


gpointer value_get_scan_device (const GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE), NULL);
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1107 "scanner.c"
}


void value_set_scan_device (GValue* value, gpointer v_object) {
	ScanDevice* old;
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_device_ref (value->data[0].v_pointer);
#line 1127 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1131 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_device_unref (old);
#line 1137 "scanner.c"
	}
}


void value_take_scan_device (GValue* value, gpointer v_object) {
	ScanDevice* old;
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1156 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1160 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_device_unref (old);
#line 1166 "scanner.c"
	}
}


static void scan_device_class_init (ScanDeviceClass * klass) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scan_device_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	SCAN_DEVICE_CLASS (klass)->finalize = scan_device_finalize;
#line 1176 "scanner.c"
}


static void scan_device_instance_init (ScanDevice * self) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->ref_count = 1;
#line 1183 "scanner.c"
}


static void scan_device_finalize (ScanDevice* obj) {
	ScanDevice * self;
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_DEVICE, ScanDevice);
#line 16 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (self->name);
#line 17 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (self->label);
#line 1195 "scanner.c"
}


GType scan_device_get_type (void) {
	static volatile gsize scan_device_type_id__volatile = 0;
	if (g_once_init_enter (&scan_device_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_device_init, value_scan_device_free_value, value_scan_device_copy_value, value_scan_device_peek_pointer, "p", value_scan_device_collect_value, "p", value_scan_device_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanDevice), 0, (GInstanceInitFunc) scan_device_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_device_type_id;
		scan_device_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanDevice", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_device_type_id__volatile, scan_device_type_id);
	}
	return scan_device_type_id__volatile;
}


gpointer scan_device_ref (gpointer instance) {
	ScanDevice* self;
	self = instance;
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return instance;
#line 1220 "scanner.c"
}


void scan_device_unref (gpointer instance) {
	ScanDevice* self;
	self = instance;
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		SCAN_DEVICE_GET_CLASS (self)->finalize (self);
#line 14 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1233 "scanner.c"
	}
}


ScanPageInfo* scan_page_info_construct (GType object_type) {
	ScanPageInfo* self = NULL;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (ScanPageInfo*) g_type_create_instance (object_type);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 1244 "scanner.c"
}


ScanPageInfo* scan_page_info_new (void) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return scan_page_info_construct (TYPE_SCAN_PAGE_INFO);
#line 1251 "scanner.c"
}


static void value_scan_page_info_init (GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1258 "scanner.c"
}


static void value_scan_page_info_free_value (GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_page_info_unref (value->data[0].v_pointer);
#line 1267 "scanner.c"
	}
}


static void value_scan_page_info_copy_value (const GValue* src_value, GValue* dest_value) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_page_info_ref (src_value->data[0].v_pointer);
#line 1277 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1281 "scanner.c"
	}
}


static gpointer value_scan_page_info_peek_pointer (const GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1289 "scanner.c"
}


static gchar* value_scan_page_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1296 "scanner.c"
		ScanPageInfo* object;
		object = collect_values[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1303 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1307 "scanner.c"
		}
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = scan_page_info_ref (object);
#line 1311 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1315 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 1319 "scanner.c"
}


static gchar* value_scan_page_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanPageInfo** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!object_p) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1330 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = NULL;
#line 1336 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1340 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = scan_page_info_ref (value->data[0].v_pointer);
#line 1344 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 1348 "scanner.c"
}


GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanPageInfo* spec;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_PAGE_INFO), NULL);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1362 "scanner.c"
}


gpointer value_get_scan_page_info (const GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO), NULL);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1371 "scanner.c"
}


void value_set_scan_page_info (GValue* value, gpointer v_object) {
	ScanPageInfo* old;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_page_info_ref (value->data[0].v_pointer);
#line 1391 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1395 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_page_info_unref (old);
#line 1401 "scanner.c"
	}
}


void value_take_scan_page_info (GValue* value, gpointer v_object) {
	ScanPageInfo* old;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1420 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1424 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_page_info_unref (old);
#line 1430 "scanner.c"
	}
}


static void scan_page_info_class_init (ScanPageInfoClass * klass) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scan_page_info_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	SCAN_PAGE_INFO_CLASS (klass)->finalize = scan_page_info_finalize;
#line 1440 "scanner.c"
}


static void scan_page_info_instance_init (ScanPageInfo * self) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->ref_count = 1;
#line 1447 "scanner.c"
}


static void scan_page_info_finalize (ScanPageInfo* obj) {
	ScanPageInfo * self;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_PAGE_INFO, ScanPageInfo);
#line 36 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (self->device);
#line 1457 "scanner.c"
}


GType scan_page_info_get_type (void) {
	static volatile gsize scan_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&scan_page_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_page_info_init, value_scan_page_info_free_value, value_scan_page_info_copy_value, value_scan_page_info_peek_pointer, "p", value_scan_page_info_collect_value, "p", value_scan_page_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanPageInfo), 0, (GInstanceInitFunc) scan_page_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_page_info_type_id;
		scan_page_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanPageInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_page_info_type_id__volatile, scan_page_info_type_id);
	}
	return scan_page_info_type_id__volatile;
}


gpointer scan_page_info_ref (gpointer instance) {
	ScanPageInfo* self;
	self = instance;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return instance;
#line 1482 "scanner.c"
}


void scan_page_info_unref (gpointer instance) {
	ScanPageInfo* self;
	self = instance;
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		SCAN_PAGE_INFO_GET_CLASS (self)->finalize (self);
#line 20 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1495 "scanner.c"
	}
}


ScanLine* scan_line_construct (GType object_type) {
	ScanLine* self = NULL;
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (ScanLine*) g_type_create_instance (object_type);
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 1506 "scanner.c"
}


ScanLine* scan_line_new (void) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return scan_line_construct (TYPE_SCAN_LINE);
#line 1513 "scanner.c"
}


static void value_scan_line_init (GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1520 "scanner.c"
}


static void value_scan_line_free_value (GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_line_unref (value->data[0].v_pointer);
#line 1529 "scanner.c"
	}
}


static void value_scan_line_copy_value (const GValue* src_value, GValue* dest_value) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_line_ref (src_value->data[0].v_pointer);
#line 1539 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1543 "scanner.c"
	}
}


static gpointer value_scan_line_peek_pointer (const GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1551 "scanner.c"
}


static gchar* value_scan_line_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1558 "scanner.c"
		ScanLine* object;
		object = collect_values[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1565 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1569 "scanner.c"
		}
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = scan_line_ref (object);
#line 1573 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1577 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 1581 "scanner.c"
}


static gchar* value_scan_line_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanLine** object_p;
	object_p = collect_values[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!object_p) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1592 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = NULL;
#line 1598 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1602 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = scan_line_ref (value->data[0].v_pointer);
#line 1606 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 1610 "scanner.c"
}


GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanLine* spec;
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_LINE), NULL);
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1624 "scanner.c"
}


gpointer value_get_scan_line (const GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE), NULL);
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1633 "scanner.c"
}


void value_set_scan_line (GValue* value, gpointer v_object) {
	ScanLine* old;
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_line_ref (value->data[0].v_pointer);
#line 1653 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1657 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_line_unref (old);
#line 1663 "scanner.c"
	}
}


void value_take_scan_line (GValue* value, gpointer v_object) {
	ScanLine* old;
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1682 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1686 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_line_unref (old);
#line 1692 "scanner.c"
	}
}


static void scan_line_class_init (ScanLineClass * klass) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scan_line_parent_class = g_type_class_peek_parent (klass);
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	SCAN_LINE_CLASS (klass)->finalize = scan_line_finalize;
#line 1702 "scanner.c"
}


static void scan_line_instance_init (ScanLine * self) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->ref_count = 1;
#line 1709 "scanner.c"
}


static void scan_line_finalize (ScanLine* obj) {
	ScanLine * self;
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_LINE, ScanLine);
#line 55 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->data = (g_free (self->data), NULL);
#line 1719 "scanner.c"
}


GType scan_line_get_type (void) {
	static volatile gsize scan_line_type_id__volatile = 0;
	if (g_once_init_enter (&scan_line_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_line_init, value_scan_line_free_value, value_scan_line_copy_value, value_scan_line_peek_pointer, "p", value_scan_line_collect_value, "p", value_scan_line_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanLine), 0, (GInstanceInitFunc) scan_line_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_line_type_id;
		scan_line_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanLine", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_line_type_id__volatile, scan_line_type_id);
	}
	return scan_line_type_id__volatile;
}


gpointer scan_line_ref (gpointer instance) {
	ScanLine* self;
	self = instance;
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return instance;
#line 1744 "scanner.c"
}


void scan_line_unref (gpointer instance) {
	ScanLine* self;
	self = instance;
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		SCAN_LINE_GET_CLASS (self)->finalize (self);
#line 39 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1757 "scanner.c"
	}
}


GType scan_mode_get_type (void) {
	static volatile gsize scan_mode_type_id__volatile = 0;
	if (g_once_init_enter (&scan_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_MODE_DEFAULT, "SCAN_MODE_DEFAULT", "default"}, {SCAN_MODE_COLOR, "SCAN_MODE_COLOR", "color"}, {SCAN_MODE_GRAY, "SCAN_MODE_GRAY", "gray"}, {SCAN_MODE_LINEART, "SCAN_MODE_LINEART", "lineart"}, {0, NULL, NULL}};
		GType scan_mode_type_id;
		scan_mode_type_id = g_enum_register_static ("ScanMode", values);
		g_once_init_leave (&scan_mode_type_id__volatile, scan_mode_type_id);
	}
	return scan_mode_type_id__volatile;
}


GType scan_type_get_type (void) {
	static volatile gsize scan_type_type_id__volatile = 0;
	if (g_once_init_enter (&scan_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_TYPE_SINGLE, "SCAN_TYPE_SINGLE", "single"}, {SCAN_TYPE_ADF_FRONT, "SCAN_TYPE_ADF_FRONT", "adf-front"}, {SCAN_TYPE_ADF_BACK, "SCAN_TYPE_ADF_BACK", "adf-back"}, {SCAN_TYPE_ADF_BOTH, "SCAN_TYPE_ADF_BOTH", "adf-both"}, {0, NULL, NULL}};
		GType scan_type_type_id;
		scan_type_type_id = g_enum_register_static ("ScanType", values);
		g_once_init_leave (&scan_type_type_id__volatile, scan_type_type_id);
	}
	return scan_type_type_id__volatile;
}


ScanOptions* scan_options_construct (GType object_type) {
	ScanOptions* self = NULL;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (ScanOptions*) g_type_create_instance (object_type);
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 1792 "scanner.c"
}


ScanOptions* scan_options_new (void) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return scan_options_construct (TYPE_SCAN_OPTIONS);
#line 1799 "scanner.c"
}


static void value_scan_options_init (GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1806 "scanner.c"
}


static void value_scan_options_free_value (GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_options_unref (value->data[0].v_pointer);
#line 1815 "scanner.c"
	}
}


static void value_scan_options_copy_value (const GValue* src_value, GValue* dest_value) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_options_ref (src_value->data[0].v_pointer);
#line 1825 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1829 "scanner.c"
	}
}


static gpointer value_scan_options_peek_pointer (const GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1837 "scanner.c"
}


static gchar* value_scan_options_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1844 "scanner.c"
		ScanOptions* object;
		object = collect_values[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1851 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1855 "scanner.c"
		}
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = scan_options_ref (object);
#line 1859 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1863 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 1867 "scanner.c"
}


static gchar* value_scan_options_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanOptions** object_p;
	object_p = collect_values[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!object_p) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1878 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = NULL;
#line 1884 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1888 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = scan_options_ref (value->data[0].v_pointer);
#line 1892 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 1896 "scanner.c"
}


GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanOptions* spec;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_OPTIONS), NULL);
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1910 "scanner.c"
}


gpointer value_get_scan_options (const GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS), NULL);
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1919 "scanner.c"
}


void value_set_scan_options (GValue* value, gpointer v_object) {
	ScanOptions* old;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_options_ref (value->data[0].v_pointer);
#line 1939 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1943 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_options_unref (old);
#line 1949 "scanner.c"
	}
}


void value_take_scan_options (GValue* value, gpointer v_object) {
	ScanOptions* old;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1968 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1972 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_options_unref (old);
#line 1978 "scanner.c"
	}
}


static void scan_options_class_init (ScanOptionsClass * klass) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scan_options_parent_class = g_type_class_peek_parent (klass);
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	SCAN_OPTIONS_CLASS (klass)->finalize = scan_options_finalize;
#line 1988 "scanner.c"
}


static void scan_options_instance_init (ScanOptions * self) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->ref_count = 1;
#line 1995 "scanner.c"
}


static void scan_options_finalize (ScanOptions* obj) {
	ScanOptions * self;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_OPTIONS, ScanOptions);
#line 2003 "scanner.c"
}


GType scan_options_get_type (void) {
	static volatile gsize scan_options_type_id__volatile = 0;
	if (g_once_init_enter (&scan_options_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_options_init, value_scan_options_free_value, value_scan_options_copy_value, value_scan_options_peek_pointer, "p", value_scan_options_collect_value, "p", value_scan_options_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanOptionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_options_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanOptions), 0, (GInstanceInitFunc) scan_options_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_options_type_id;
		scan_options_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanOptions", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_options_type_id__volatile, scan_options_type_id);
	}
	return scan_options_type_id__volatile;
}


gpointer scan_options_ref (gpointer instance) {
	ScanOptions* self;
	self = instance;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return instance;
#line 2028 "scanner.c"
}


void scan_options_unref (gpointer instance) {
	ScanOptions* self;
	self = instance;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		SCAN_OPTIONS_GET_CLASS (self)->finalize (self);
#line 75 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2041 "scanner.c"
	}
}


ScanJob* scan_job_construct (GType object_type) {
	ScanJob* self = NULL;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (ScanJob*) g_type_create_instance (object_type);
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 2052 "scanner.c"
}


ScanJob* scan_job_new (void) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return scan_job_construct (TYPE_SCAN_JOB);
#line 2059 "scanner.c"
}


static void value_scan_job_init (GValue* value) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2066 "scanner.c"
}


static void value_scan_job_free_value (GValue* value) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_job_unref (value->data[0].v_pointer);
#line 2075 "scanner.c"
	}
}


static void value_scan_job_copy_value (const GValue* src_value, GValue* dest_value) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_job_ref (src_value->data[0].v_pointer);
#line 2085 "scanner.c"
	} else {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2089 "scanner.c"
	}
}


static gpointer value_scan_job_peek_pointer (const GValue* value) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2097 "scanner.c"
}


static gchar* value_scan_job_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2104 "scanner.c"
		ScanJob* object;
		object = collect_values[0].v_pointer;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2111 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2115 "scanner.c"
		}
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = scan_job_ref (object);
#line 2119 "scanner.c"
	} else {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2123 "scanner.c"
	}
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 2127 "scanner.c"
}


static gchar* value_scan_job_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanJob** object_p;
	object_p = collect_values[0].v_pointer;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!object_p) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2138 "scanner.c"
	}
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = NULL;
#line 2144 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2148 "scanner.c"
	} else {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = scan_job_ref (value->data[0].v_pointer);
#line 2152 "scanner.c"
	}
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 2156 "scanner.c"
}


GParamSpec* param_spec_scan_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanJob* spec;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_JOB), NULL);
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2170 "scanner.c"
}


gpointer value_get_scan_job (const GValue* value) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB), NULL);
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2179 "scanner.c"
}


void value_set_scan_job (GValue* value, gpointer v_object) {
	ScanJob* old;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB));
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_JOB));
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_job_ref (value->data[0].v_pointer);
#line 2199 "scanner.c"
	} else {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2203 "scanner.c"
	}
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_job_unref (old);
#line 2209 "scanner.c"
	}
}


void value_take_scan_job (GValue* value, gpointer v_object) {
	ScanJob* old;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB));
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_JOB));
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2228 "scanner.c"
	} else {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2232 "scanner.c"
	}
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scan_job_unref (old);
#line 2238 "scanner.c"
	}
}


static void scan_job_class_init (ScanJobClass * klass) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scan_job_parent_class = g_type_class_peek_parent (klass);
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	SCAN_JOB_CLASS (klass)->finalize = scan_job_finalize;
#line 2248 "scanner.c"
}


static void scan_job_instance_init (ScanJob * self) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->ref_count = 1;
#line 2255 "scanner.c"
}


static void scan_job_finalize (ScanJob* obj) {
	ScanJob * self;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_JOB, ScanJob);
#line 88 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (self->device);
#line 2265 "scanner.c"
}


GType scan_job_get_type (void) {
	static volatile gsize scan_job_type_id__volatile = 0;
	if (g_once_init_enter (&scan_job_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_job_init, value_scan_job_free_value, value_scan_job_copy_value, value_scan_job_peek_pointer, "p", value_scan_job_collect_value, "p", value_scan_job_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanJob), 0, (GInstanceInitFunc) scan_job_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_job_type_id;
		scan_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanJob", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_job_type_id__volatile, scan_job_type_id);
	}
	return scan_job_type_id__volatile;
}


gpointer scan_job_ref (gpointer instance) {
	ScanJob* self;
	self = instance;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return instance;
#line 2290 "scanner.c"
}


void scan_job_unref (gpointer instance) {
	ScanJob* self;
	self = instance;
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		SCAN_JOB_GET_CLASS (self)->finalize (self);
#line 85 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2303 "scanner.c"
	}
}


Request* request_construct (GType object_type) {
	Request* self = NULL;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (Request*) g_type_create_instance (object_type);
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 2314 "scanner.c"
}


Request* request_new (void) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return request_construct (TYPE_REQUEST);
#line 2321 "scanner.c"
}


static void value_request_init (GValue* value) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2328 "scanner.c"
}


static void value_request_free_value (GValue* value) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		request_unref (value->data[0].v_pointer);
#line 2337 "scanner.c"
	}
}


static void value_request_copy_value (const GValue* src_value, GValue* dest_value) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = request_ref (src_value->data[0].v_pointer);
#line 2347 "scanner.c"
	} else {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2351 "scanner.c"
	}
}


static gpointer value_request_peek_pointer (const GValue* value) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2359 "scanner.c"
}


static gchar* value_request_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2366 "scanner.c"
		Request* object;
		object = collect_values[0].v_pointer;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2373 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2377 "scanner.c"
		}
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = request_ref (object);
#line 2381 "scanner.c"
	} else {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2385 "scanner.c"
	}
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 2389 "scanner.c"
}


static gchar* value_request_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Request** object_p;
	object_p = collect_values[0].v_pointer;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!object_p) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2400 "scanner.c"
	}
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = NULL;
#line 2406 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2410 "scanner.c"
	} else {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = request_ref (value->data[0].v_pointer);
#line 2414 "scanner.c"
	}
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 2418 "scanner.c"
}


GParamSpec* param_spec_request (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecRequest* spec;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_REQUEST), NULL);
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2432 "scanner.c"
}


gpointer value_get_request (const GValue* value) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST), NULL);
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2441 "scanner.c"
}


void value_set_request (GValue* value, gpointer v_object) {
	Request* old;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		request_ref (value->data[0].v_pointer);
#line 2461 "scanner.c"
	} else {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2465 "scanner.c"
	}
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		request_unref (old);
#line 2471 "scanner.c"
	}
}


void value_take_request (GValue* value, gpointer v_object) {
	Request* old;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2490 "scanner.c"
	} else {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2494 "scanner.c"
	}
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		request_unref (old);
#line 2500 "scanner.c"
	}
}


static void request_class_init (RequestClass * klass) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	request_parent_class = g_type_class_peek_parent (klass);
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	REQUEST_CLASS (klass)->finalize = request_finalize;
#line 2510 "scanner.c"
}


static void request_instance_init (Request * self) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->ref_count = 1;
#line 2517 "scanner.c"
}


static void request_finalize (Request* obj) {
	Request * self;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REQUEST, Request);
#line 2525 "scanner.c"
}


GType request_get_type (void) {
	static volatile gsize request_type_id__volatile = 0;
	if (g_once_init_enter (&request_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_request_init, value_request_free_value, value_request_copy_value, value_request_peek_pointer, "p", value_request_collect_value, "p", value_request_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Request), 0, (GInstanceInitFunc) request_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType request_type_id;
		request_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Request", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&request_type_id__volatile, request_type_id);
	}
	return request_type_id__volatile;
}


gpointer request_ref (gpointer instance) {
	Request* self;
	self = instance;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return instance;
#line 2550 "scanner.c"
}


void request_unref (gpointer instance) {
	Request* self;
	self = instance;
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		REQUEST_GET_CLASS (self)->finalize (self);
#line 97 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2563 "scanner.c"
	}
}


RequestRedetect* request_redetect_construct (GType object_type) {
	RequestRedetect* self = NULL;
#line 99 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (RequestRedetect*) request_construct (object_type);
#line 99 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 2574 "scanner.c"
}


RequestRedetect* request_redetect_new (void) {
#line 99 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return request_redetect_construct (TYPE_REQUEST_REDETECT);
#line 2581 "scanner.c"
}


static void request_redetect_class_init (RequestRedetectClass * klass) {
#line 99 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	request_redetect_parent_class = g_type_class_peek_parent (klass);
#line 2588 "scanner.c"
}


static void request_redetect_instance_init (RequestRedetect * self) {
}


GType request_redetect_get_type (void) {
	static volatile gsize request_redetect_type_id__volatile = 0;
	if (g_once_init_enter (&request_redetect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestRedetectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_redetect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestRedetect), 0, (GInstanceInitFunc) request_redetect_instance_init, NULL };
		GType request_redetect_type_id;
		request_redetect_type_id = g_type_register_static (TYPE_REQUEST, "RequestRedetect", &g_define_type_info, 0);
		g_once_init_leave (&request_redetect_type_id__volatile, request_redetect_type_id);
	}
	return request_redetect_type_id__volatile;
}


RequestCancel* request_cancel_construct (GType object_type) {
	RequestCancel* self = NULL;
#line 101 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (RequestCancel*) request_construct (object_type);
#line 101 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 2614 "scanner.c"
}


RequestCancel* request_cancel_new (void) {
#line 101 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return request_cancel_construct (TYPE_REQUEST_CANCEL);
#line 2621 "scanner.c"
}


static void request_cancel_class_init (RequestCancelClass * klass) {
#line 101 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	request_cancel_parent_class = g_type_class_peek_parent (klass);
#line 2628 "scanner.c"
}


static void request_cancel_instance_init (RequestCancel * self) {
}


GType request_cancel_get_type (void) {
	static volatile gsize request_cancel_type_id__volatile = 0;
	if (g_once_init_enter (&request_cancel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestCancelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_cancel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestCancel), 0, (GInstanceInitFunc) request_cancel_instance_init, NULL };
		GType request_cancel_type_id;
		request_cancel_type_id = g_type_register_static (TYPE_REQUEST, "RequestCancel", &g_define_type_info, 0);
		g_once_init_leave (&request_cancel_type_id__volatile, request_cancel_type_id);
	}
	return request_cancel_type_id__volatile;
}


RequestStartScan* request_start_scan_construct (GType object_type) {
	RequestStartScan* self = NULL;
#line 103 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (RequestStartScan*) request_construct (object_type);
#line 103 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 2654 "scanner.c"
}


RequestStartScan* request_start_scan_new (void) {
#line 103 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return request_start_scan_construct (TYPE_REQUEST_START_SCAN);
#line 2661 "scanner.c"
}


static void request_start_scan_class_init (RequestStartScanClass * klass) {
#line 103 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	request_start_scan_parent_class = g_type_class_peek_parent (klass);
#line 103 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	REQUEST_CLASS (klass)->finalize = request_start_scan_finalize;
#line 2670 "scanner.c"
}


static void request_start_scan_instance_init (RequestStartScan * self) {
}


static void request_start_scan_finalize (Request* obj) {
	RequestStartScan * self;
#line 103 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REQUEST_START_SCAN, RequestStartScan);
#line 105 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_scan_job_unref0 (self->job);
#line 103 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	REQUEST_CLASS (request_start_scan_parent_class)->finalize (obj);
#line 2686 "scanner.c"
}


GType request_start_scan_get_type (void) {
	static volatile gsize request_start_scan_type_id__volatile = 0;
	if (g_once_init_enter (&request_start_scan_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestStartScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_start_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestStartScan), 0, (GInstanceInitFunc) request_start_scan_instance_init, NULL };
		GType request_start_scan_type_id;
		request_start_scan_type_id = g_type_register_static (TYPE_REQUEST, "RequestStartScan", &g_define_type_info, 0);
		g_once_init_leave (&request_start_scan_type_id__volatile, request_start_scan_type_id);
	}
	return request_start_scan_type_id__volatile;
}


RequestQuit* request_quit_construct (GType object_type) {
	RequestQuit* self = NULL;
#line 108 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (RequestQuit*) request_construct (object_type);
#line 108 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 2708 "scanner.c"
}


RequestQuit* request_quit_new (void) {
#line 108 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return request_quit_construct (TYPE_REQUEST_QUIT);
#line 2715 "scanner.c"
}


static void request_quit_class_init (RequestQuitClass * klass) {
#line 108 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	request_quit_parent_class = g_type_class_peek_parent (klass);
#line 2722 "scanner.c"
}


static void request_quit_instance_init (RequestQuit * self) {
}


GType request_quit_get_type (void) {
	static volatile gsize request_quit_type_id__volatile = 0;
	if (g_once_init_enter (&request_quit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestQuitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_quit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestQuit), 0, (GInstanceInitFunc) request_quit_instance_init, NULL };
		GType request_quit_type_id;
		request_quit_type_id = g_type_register_static (TYPE_REQUEST, "RequestQuit", &g_define_type_info, 0);
		g_once_init_leave (&request_quit_type_id__volatile, request_quit_type_id);
	}
	return request_quit_type_id__volatile;
}


Credentials* credentials_construct (GType object_type) {
	Credentials* self = NULL;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (Credentials*) g_type_create_instance (object_type);
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 2748 "scanner.c"
}


Credentials* credentials_new (void) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return credentials_construct (TYPE_CREDENTIALS);
#line 2755 "scanner.c"
}


static void value_credentials_init (GValue* value) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2762 "scanner.c"
}


static void value_credentials_free_value (GValue* value) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		credentials_unref (value->data[0].v_pointer);
#line 2771 "scanner.c"
	}
}


static void value_credentials_copy_value (const GValue* src_value, GValue* dest_value) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = credentials_ref (src_value->data[0].v_pointer);
#line 2781 "scanner.c"
	} else {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2785 "scanner.c"
	}
}


static gpointer value_credentials_peek_pointer (const GValue* value) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2793 "scanner.c"
}


static gchar* value_credentials_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2800 "scanner.c"
		Credentials* object;
		object = collect_values[0].v_pointer;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2807 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2811 "scanner.c"
		}
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = credentials_ref (object);
#line 2815 "scanner.c"
	} else {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2819 "scanner.c"
	}
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 2823 "scanner.c"
}


static gchar* value_credentials_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Credentials** object_p;
	object_p = collect_values[0].v_pointer;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!object_p) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2834 "scanner.c"
	}
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = NULL;
#line 2840 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2844 "scanner.c"
	} else {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = credentials_ref (value->data[0].v_pointer);
#line 2848 "scanner.c"
	}
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 2852 "scanner.c"
}


GParamSpec* param_spec_credentials (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecCredentials* spec;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CREDENTIALS), NULL);
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2866 "scanner.c"
}


gpointer value_get_credentials (const GValue* value) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS), NULL);
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2875 "scanner.c"
}


void value_set_credentials (GValue* value, gpointer v_object) {
	Credentials* old;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		credentials_ref (value->data[0].v_pointer);
#line 2895 "scanner.c"
	} else {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2899 "scanner.c"
	}
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		credentials_unref (old);
#line 2905 "scanner.c"
	}
}


void value_take_credentials (GValue* value, gpointer v_object) {
	Credentials* old;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2924 "scanner.c"
	} else {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2928 "scanner.c"
	}
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		credentials_unref (old);
#line 2934 "scanner.c"
	}
}


static void credentials_class_init (CredentialsClass * klass) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	credentials_parent_class = g_type_class_peek_parent (klass);
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	CREDENTIALS_CLASS (klass)->finalize = credentials_finalize;
#line 2944 "scanner.c"
}


static void credentials_instance_init (Credentials * self) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->ref_count = 1;
#line 2951 "scanner.c"
}


static void credentials_finalize (Credentials* obj) {
	Credentials * self;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CREDENTIALS, Credentials);
#line 112 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (self->username);
#line 113 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (self->password);
#line 2963 "scanner.c"
}


GType credentials_get_type (void) {
	static volatile gsize credentials_type_id__volatile = 0;
	if (g_once_init_enter (&credentials_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_credentials_init, value_credentials_free_value, value_credentials_copy_value, value_credentials_peek_pointer, "p", value_credentials_collect_value, "p", value_credentials_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CredentialsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) credentials_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Credentials), 0, (GInstanceInitFunc) credentials_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType credentials_type_id;
		credentials_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Credentials", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&credentials_type_id__volatile, credentials_type_id);
	}
	return credentials_type_id__volatile;
}


gpointer credentials_ref (gpointer instance) {
	Credentials* self;
	self = instance;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return instance;
#line 2988 "scanner.c"
}


void credentials_unref (gpointer instance) {
	Credentials* self;
	self = instance;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		CREDENTIALS_GET_CLASS (self)->finalize (self);
#line 110 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3001 "scanner.c"
	}
}


GType scan_state_get_type (void) {
	static volatile gsize scan_state_type_id__volatile = 0;
	if (g_once_init_enter (&scan_state_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_STATE_IDLE, "SCAN_STATE_IDLE", "idle"}, {SCAN_STATE_REDETECT, "SCAN_STATE_REDETECT", "redetect"}, {SCAN_STATE_OPEN, "SCAN_STATE_OPEN", "open"}, {SCAN_STATE_GET_OPTION, "SCAN_STATE_GET_OPTION", "get-option"}, {SCAN_STATE_START, "SCAN_STATE_START", "start"}, {SCAN_STATE_GET_PARAMETERS, "SCAN_STATE_GET_PARAMETERS", "get-parameters"}, {SCAN_STATE_READ, "SCAN_STATE_READ", "read"}, {0, NULL, NULL}};
		GType scan_state_type_id;
		scan_state_type_id = g_enum_register_static ("ScanState", values);
		g_once_init_leave (&scan_state_type_id__volatile, scan_state_type_id);
	}
	return scan_state_type_id__volatile;
}


static void notify_real_run (Notify* self, Scanner* scanner) {
#line 129 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 3021 "scanner.c"
}


void notify_run (Notify* self, Scanner* scanner) {
#line 129 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 129 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_GET_CLASS (self)->run (self, scanner);
#line 3030 "scanner.c"
}


Notify* notify_construct (GType object_type) {
	Notify* self = NULL;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (Notify*) g_type_create_instance (object_type);
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 3040 "scanner.c"
}


Notify* notify_new (void) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return notify_construct (TYPE_NOTIFY);
#line 3047 "scanner.c"
}


static void value_notify_init (GValue* value) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 3054 "scanner.c"
}


static void value_notify_free_value (GValue* value) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		notify_unref (value->data[0].v_pointer);
#line 3063 "scanner.c"
	}
}


static void value_notify_copy_value (const GValue* src_value, GValue* dest_value) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = notify_ref (src_value->data[0].v_pointer);
#line 3073 "scanner.c"
	} else {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3077 "scanner.c"
	}
}


static gpointer value_notify_peek_pointer (const GValue* value) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 3085 "scanner.c"
}


static gchar* value_notify_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 3092 "scanner.c"
		Notify* object;
		object = collect_values[0].v_pointer;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3099 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3103 "scanner.c"
		}
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = notify_ref (object);
#line 3107 "scanner.c"
	} else {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3111 "scanner.c"
	}
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 3115 "scanner.c"
}


static gchar* value_notify_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Notify** object_p;
	object_p = collect_values[0].v_pointer;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!object_p) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3126 "scanner.c"
	}
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = NULL;
#line 3132 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 3136 "scanner.c"
	} else {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = notify_ref (value->data[0].v_pointer);
#line 3140 "scanner.c"
	}
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 3144 "scanner.c"
}


GParamSpec* param_spec_notify (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecNotify* spec;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NOTIFY), NULL);
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 3158 "scanner.c"
}


gpointer value_get_notify (const GValue* value) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY), NULL);
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 3167 "scanner.c"
}


void value_set_notify (GValue* value, gpointer v_object) {
	Notify* old;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		notify_ref (value->data[0].v_pointer);
#line 3187 "scanner.c"
	} else {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3191 "scanner.c"
	}
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		notify_unref (old);
#line 3197 "scanner.c"
	}
}


void value_take_notify (GValue* value, gpointer v_object) {
	Notify* old;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 3216 "scanner.c"
	} else {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3220 "scanner.c"
	}
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		notify_unref (old);
#line 3226 "scanner.c"
	}
}


static void notify_class_init (NotifyClass * klass) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	notify_parent_class = g_type_class_peek_parent (klass);
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_finalize;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_real_run;
#line 3238 "scanner.c"
}


static void notify_instance_init (Notify * self) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->ref_count = 1;
#line 3245 "scanner.c"
}


static void notify_finalize (Notify* obj) {
	Notify * self;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY, Notify);
#line 3253 "scanner.c"
}


GType notify_get_type (void) {
	static volatile gsize notify_type_id__volatile = 0;
	if (g_once_init_enter (&notify_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_notify_init, value_notify_free_value, value_notify_copy_value, value_notify_peek_pointer, "p", value_notify_collect_value, "p", value_notify_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (NotifyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Notify), 0, (GInstanceInitFunc) notify_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType notify_type_id;
		notify_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Notify", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&notify_type_id__volatile, notify_type_id);
	}
	return notify_type_id__volatile;
}


gpointer notify_ref (gpointer instance) {
	Notify* self;
	self = instance;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return instance;
#line 3278 "scanner.c"
}


void notify_unref (gpointer instance) {
	Notify* self;
	self = instance;
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		NOTIFY_GET_CLASS (self)->finalize (self);
#line 127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3291 "scanner.c"
	}
}


static void notify_scanning_changed_real_run (Notify* base, Scanner* scanner) {
	NotifyScanningChanged * self;
	Scanner* _tmp0_ = NULL;
#line 134 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyScanningChanged*) base;
#line 134 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 134 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = scanner;
#line 134 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "scanning-changed");
#line 3307 "scanner.c"
}


NotifyScanningChanged* notify_scanning_changed_construct (GType object_type) {
	NotifyScanningChanged* self = NULL;
#line 132 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyScanningChanged*) notify_construct (object_type);
#line 132 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 3317 "scanner.c"
}


NotifyScanningChanged* notify_scanning_changed_new (void) {
#line 132 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return notify_scanning_changed_construct (TYPE_NOTIFY_SCANNING_CHANGED);
#line 3324 "scanner.c"
}


static void notify_scanning_changed_class_init (NotifyScanningChangedClass * klass) {
#line 132 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	notify_scanning_changed_parent_class = g_type_class_peek_parent (klass);
#line 132 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_scanning_changed_real_run;
#line 3333 "scanner.c"
}


static void notify_scanning_changed_instance_init (NotifyScanningChanged * self) {
}


GType notify_scanning_changed_get_type (void) {
	static volatile gsize notify_scanning_changed_type_id__volatile = 0;
	if (g_once_init_enter (&notify_scanning_changed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyScanningChangedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scanning_changed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanningChanged), 0, (GInstanceInitFunc) notify_scanning_changed_instance_init, NULL };
		GType notify_scanning_changed_type_id;
		notify_scanning_changed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanningChanged", &g_define_type_info, 0);
		g_once_init_leave (&notify_scanning_changed_type_id__volatile, notify_scanning_changed_type_id);
	}
	return notify_scanning_changed_type_id__volatile;
}


static void _scan_device_unref0_ (gpointer var) {
#line 140 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
#line 3356 "scanner.c"
}


static void _g_list_free__scan_device_unref0_ (GList* self) {
#line 140 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_list_foreach (self, (GFunc) _scan_device_unref0_, NULL);
#line 140 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_list_free (self);
#line 3365 "scanner.c"
}


NotifyUpdateDevices* notify_update_devices_construct (GType object_type, GList* devices) {
	NotifyUpdateDevices* self = NULL;
	GList* _tmp0_ = NULL;
#line 139 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyUpdateDevices*) notify_construct (object_type);
#line 139 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = devices;
#line 139 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	devices = NULL;
#line 139 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (self->priv->devices);
#line 139 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->devices = _tmp0_;
#line 139 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (devices);
#line 139 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 3386 "scanner.c"
}


NotifyUpdateDevices* notify_update_devices_new (GList* devices) {
#line 139 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return notify_update_devices_construct (TYPE_NOTIFY_UPDATE_DEVICES, devices);
#line 3393 "scanner.c"
}


static void notify_update_devices_real_run (Notify* base, Scanner* scanner) {
	NotifyUpdateDevices * self;
	Scanner* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
#line 141 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyUpdateDevices*) base;
#line 141 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 141 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = scanner;
#line 141 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = self->priv->devices;
#line 141 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "update-devices", _tmp1_);
#line 3411 "scanner.c"
}


static void notify_update_devices_class_init (NotifyUpdateDevicesClass * klass) {
#line 137 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	notify_update_devices_parent_class = g_type_class_peek_parent (klass);
#line 137 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_update_devices_finalize;
#line 137 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyUpdateDevicesPrivate));
#line 137 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_update_devices_real_run;
#line 3424 "scanner.c"
}


static void notify_update_devices_instance_init (NotifyUpdateDevices * self) {
#line 137 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv = NOTIFY_UPDATE_DEVICES_GET_PRIVATE (self);
#line 3431 "scanner.c"
}


static void notify_update_devices_finalize (Notify* obj) {
	NotifyUpdateDevices * self;
#line 137 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevices);
#line 140 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (self->priv->devices);
#line 137 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (notify_update_devices_parent_class)->finalize (obj);
#line 3443 "scanner.c"
}


GType notify_update_devices_get_type (void) {
	static volatile gsize notify_update_devices_type_id__volatile = 0;
	if (g_once_init_enter (&notify_update_devices_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyUpdateDevicesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_update_devices_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyUpdateDevices), 0, (GInstanceInitFunc) notify_update_devices_instance_init, NULL };
		GType notify_update_devices_type_id;
		notify_update_devices_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyUpdateDevices", &g_define_type_info, 0);
		g_once_init_leave (&notify_update_devices_type_id__volatile, notify_update_devices_type_id);
	}
	return notify_update_devices_type_id__volatile;
}


NotifyRequestAuthorization* notify_request_authorization_construct (GType object_type, const gchar* resource) {
	NotifyRequestAuthorization* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 146 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (resource != NULL, NULL);
#line 146 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyRequestAuthorization*) notify_construct (object_type);
#line 146 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = resource;
#line 146 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 146 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (self->priv->resource);
#line 146 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->resource = _tmp1_;
#line 146 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 3477 "scanner.c"
}


NotifyRequestAuthorization* notify_request_authorization_new (const gchar* resource) {
#line 146 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return notify_request_authorization_construct (TYPE_NOTIFY_REQUEST_AUTHORIZATION, resource);
#line 3484 "scanner.c"
}


static void notify_request_authorization_real_run (Notify* base, Scanner* scanner) {
	NotifyRequestAuthorization * self;
	Scanner* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 148 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyRequestAuthorization*) base;
#line 148 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 148 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = scanner;
#line 148 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = self->priv->resource;
#line 148 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "request-authorization", _tmp1_);
#line 3502 "scanner.c"
}


static void notify_request_authorization_class_init (NotifyRequestAuthorizationClass * klass) {
#line 144 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	notify_request_authorization_parent_class = g_type_class_peek_parent (klass);
#line 144 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_request_authorization_finalize;
#line 144 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyRequestAuthorizationPrivate));
#line 144 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_request_authorization_real_run;
#line 3515 "scanner.c"
}


static void notify_request_authorization_instance_init (NotifyRequestAuthorization * self) {
#line 144 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv = NOTIFY_REQUEST_AUTHORIZATION_GET_PRIVATE (self);
#line 3522 "scanner.c"
}


static void notify_request_authorization_finalize (Notify* obj) {
	NotifyRequestAuthorization * self;
#line 144 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorization);
#line 147 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (self->priv->resource);
#line 144 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (notify_request_authorization_parent_class)->finalize (obj);
#line 3534 "scanner.c"
}


GType notify_request_authorization_get_type (void) {
	static volatile gsize notify_request_authorization_type_id__volatile = 0;
	if (g_once_init_enter (&notify_request_authorization_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyRequestAuthorizationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_request_authorization_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyRequestAuthorization), 0, (GInstanceInitFunc) notify_request_authorization_instance_init, NULL };
		GType notify_request_authorization_type_id;
		notify_request_authorization_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyRequestAuthorization", &g_define_type_info, 0);
		g_once_init_leave (&notify_request_authorization_type_id__volatile, notify_request_authorization_type_id);
	}
	return notify_request_authorization_type_id__volatile;
}


NotifyScanFailed* notify_scan_failed_construct (GType object_type, gint error_code, const gchar* error_string) {
	NotifyScanFailed* self = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 153 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (error_string != NULL, NULL);
#line 153 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyScanFailed*) notify_construct (object_type);
#line 153 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = error_code;
#line 153 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->error_code = _tmp0_;
#line 153 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = error_string;
#line 153 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 153 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (self->priv->error_string);
#line 153 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->error_string = _tmp2_;
#line 153 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 3573 "scanner.c"
}


NotifyScanFailed* notify_scan_failed_new (gint error_code, const gchar* error_string) {
#line 153 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return notify_scan_failed_construct (TYPE_NOTIFY_SCAN_FAILED, error_code, error_string);
#line 3580 "scanner.c"
}


static void notify_scan_failed_real_run (Notify* base, Scanner* scanner) {
	NotifyScanFailed * self;
	Scanner* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
#line 156 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyScanFailed*) base;
#line 156 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 156 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = scanner;
#line 156 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = self->priv->error_code;
#line 156 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = self->priv->error_string;
#line 156 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "scan-failed", _tmp1_, _tmp2_);
#line 3601 "scanner.c"
}


static void notify_scan_failed_class_init (NotifyScanFailedClass * klass) {
#line 151 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	notify_scan_failed_parent_class = g_type_class_peek_parent (klass);
#line 151 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_scan_failed_finalize;
#line 151 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyScanFailedPrivate));
#line 151 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_scan_failed_real_run;
#line 3614 "scanner.c"
}


static void notify_scan_failed_instance_init (NotifyScanFailed * self) {
#line 151 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv = NOTIFY_SCAN_FAILED_GET_PRIVATE (self);
#line 3621 "scanner.c"
}


static void notify_scan_failed_finalize (Notify* obj) {
	NotifyScanFailed * self;
#line 151 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailed);
#line 155 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (self->priv->error_string);
#line 151 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (notify_scan_failed_parent_class)->finalize (obj);
#line 3633 "scanner.c"
}


GType notify_scan_failed_get_type (void) {
	static volatile gsize notify_scan_failed_type_id__volatile = 0;
	if (g_once_init_enter (&notify_scan_failed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyScanFailedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scan_failed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanFailed), 0, (GInstanceInitFunc) notify_scan_failed_instance_init, NULL };
		GType notify_scan_failed_type_id;
		notify_scan_failed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanFailed", &g_define_type_info, 0);
		g_once_init_leave (&notify_scan_failed_type_id__volatile, notify_scan_failed_type_id);
	}
	return notify_scan_failed_type_id__volatile;
}


static void notify_document_done_real_run (Notify* base, Scanner* scanner) {
	NotifyDocumentDone * self;
	Scanner* _tmp0_ = NULL;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyDocumentDone*) base;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 161 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = scanner;
#line 161 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "document-done");
#line 3660 "scanner.c"
}


NotifyDocumentDone* notify_document_done_construct (GType object_type) {
	NotifyDocumentDone* self = NULL;
#line 159 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyDocumentDone*) notify_construct (object_type);
#line 159 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 3670 "scanner.c"
}


NotifyDocumentDone* notify_document_done_new (void) {
#line 159 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return notify_document_done_construct (TYPE_NOTIFY_DOCUMENT_DONE);
#line 3677 "scanner.c"
}


static void notify_document_done_class_init (NotifyDocumentDoneClass * klass) {
#line 159 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	notify_document_done_parent_class = g_type_class_peek_parent (klass);
#line 159 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_document_done_real_run;
#line 3686 "scanner.c"
}


static void notify_document_done_instance_init (NotifyDocumentDone * self) {
}


GType notify_document_done_get_type (void) {
	static volatile gsize notify_document_done_type_id__volatile = 0;
	if (g_once_init_enter (&notify_document_done_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyDocumentDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_document_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyDocumentDone), 0, (GInstanceInitFunc) notify_document_done_instance_init, NULL };
		GType notify_document_done_type_id;
		notify_document_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyDocumentDone", &g_define_type_info, 0);
		g_once_init_leave (&notify_document_done_type_id__volatile, notify_document_done_type_id);
	}
	return notify_document_done_type_id__volatile;
}


static void notify_expect_page_real_run (Notify* base, Scanner* scanner) {
	NotifyExpectPage * self;
	Scanner* _tmp0_ = NULL;
#line 166 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyExpectPage*) base;
#line 166 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 166 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = scanner;
#line 166 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "expect-page");
#line 3717 "scanner.c"
}


NotifyExpectPage* notify_expect_page_construct (GType object_type) {
	NotifyExpectPage* self = NULL;
#line 164 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyExpectPage*) notify_construct (object_type);
#line 164 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 3727 "scanner.c"
}


NotifyExpectPage* notify_expect_page_new (void) {
#line 164 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return notify_expect_page_construct (TYPE_NOTIFY_EXPECT_PAGE);
#line 3734 "scanner.c"
}


static void notify_expect_page_class_init (NotifyExpectPageClass * klass) {
#line 164 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	notify_expect_page_parent_class = g_type_class_peek_parent (klass);
#line 164 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_expect_page_real_run;
#line 3743 "scanner.c"
}


static void notify_expect_page_instance_init (NotifyExpectPage * self) {
}


GType notify_expect_page_get_type (void) {
	static volatile gsize notify_expect_page_type_id__volatile = 0;
	if (g_once_init_enter (&notify_expect_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyExpectPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_expect_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyExpectPage), 0, (GInstanceInitFunc) notify_expect_page_instance_init, NULL };
		GType notify_expect_page_type_id;
		notify_expect_page_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyExpectPage", &g_define_type_info, 0);
		g_once_init_leave (&notify_expect_page_type_id__volatile, notify_expect_page_type_id);
	}
	return notify_expect_page_type_id__volatile;
}


static gpointer _scan_page_info_ref0 (gpointer self) {
#line 171 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self ? scan_page_info_ref (self) : NULL;
#line 3766 "scanner.c"
}


NotifyGotPageInfo* notify_got_page_info_construct (GType object_type, gint job_id, ScanPageInfo* info) {
	NotifyGotPageInfo* self = NULL;
	gint _tmp0_ = 0;
	ScanPageInfo* _tmp1_ = NULL;
	ScanPageInfo* _tmp2_ = NULL;
#line 171 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 171 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyGotPageInfo*) notify_construct (object_type);
#line 171 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = job_id;
#line 171 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->job_id = _tmp0_;
#line 171 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = info;
#line 171 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = _scan_page_info_ref0 (_tmp1_);
#line 171 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_scan_page_info_unref0 (self->priv->info);
#line 171 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->info = _tmp2_;
#line 171 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 3793 "scanner.c"
}


NotifyGotPageInfo* notify_got_page_info_new (gint job_id, ScanPageInfo* info) {
#line 171 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return notify_got_page_info_construct (TYPE_NOTIFY_GOT_PAGE_INFO, job_id, info);
#line 3800 "scanner.c"
}


static void notify_got_page_info_real_run (Notify* base, Scanner* scanner) {
	NotifyGotPageInfo * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	Scanner* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 174 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyGotPageInfo*) base;
#line 174 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 176 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 176 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = scanner;
#line 176 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = _tmp2_->first_job_id;
#line 176 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp1_ >= _tmp3_) {
#line 3822 "scanner.c"
		gint _tmp4_ = 0;
		Scanner* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 176 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp4_ = self->priv->job_id;
#line 176 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp5_ = scanner;
#line 176 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp6_ = _tmp5_->job_id;
#line 176 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp0_ = _tmp4_ < _tmp6_;
#line 3834 "scanner.c"
	} else {
#line 176 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp0_ = FALSE;
#line 3838 "scanner.c"
	}
#line 176 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp0_) {
#line 3842 "scanner.c"
		Scanner* _tmp7_ = NULL;
		ScanPageInfo* _tmp8_ = NULL;
#line 177 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_ = scanner;
#line 177 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp8_ = self->priv->info;
#line 177 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_signal_emit_by_name (_tmp7_, "got-page-info", _tmp8_);
#line 3851 "scanner.c"
	}
}


static void notify_got_page_info_class_init (NotifyGotPageInfoClass * klass) {
#line 169 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	notify_got_page_info_parent_class = g_type_class_peek_parent (klass);
#line 169 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_got_page_info_finalize;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyGotPageInfoPrivate));
#line 169 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_got_page_info_real_run;
#line 3865 "scanner.c"
}


static void notify_got_page_info_instance_init (NotifyGotPageInfo * self) {
#line 169 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv = NOTIFY_GOT_PAGE_INFO_GET_PRIVATE (self);
#line 3872 "scanner.c"
}


static void notify_got_page_info_finalize (Notify* obj) {
	NotifyGotPageInfo * self;
#line 169 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfo);
#line 173 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_scan_page_info_unref0 (self->priv->info);
#line 169 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (notify_got_page_info_parent_class)->finalize (obj);
#line 3884 "scanner.c"
}


GType notify_got_page_info_get_type (void) {
	static volatile gsize notify_got_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&notify_got_page_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyGotPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotPageInfo), 0, (GInstanceInitFunc) notify_got_page_info_instance_init, NULL };
		GType notify_got_page_info_type_id;
		notify_got_page_info_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotPageInfo", &g_define_type_info, 0);
		g_once_init_leave (&notify_got_page_info_type_id__volatile, notify_got_page_info_type_id);
	}
	return notify_got_page_info_type_id__volatile;
}


NotifyPageDone* notify_page_done_construct (GType object_type, gint job_id) {
	NotifyPageDone* self = NULL;
	gint _tmp0_ = 0;
#line 183 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyPageDone*) notify_construct (object_type);
#line 183 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = job_id;
#line 183 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->job_id = _tmp0_;
#line 183 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 3911 "scanner.c"
}


NotifyPageDone* notify_page_done_new (gint job_id) {
#line 183 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return notify_page_done_construct (TYPE_NOTIFY_PAGE_DONE, job_id);
#line 3918 "scanner.c"
}


static void notify_page_done_real_run (Notify* base, Scanner* scanner) {
	NotifyPageDone * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	Scanner* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 185 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyPageDone*) base;
#line 185 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = scanner;
#line 187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = _tmp2_->first_job_id;
#line 187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp1_ >= _tmp3_) {
#line 3940 "scanner.c"
		gint _tmp4_ = 0;
		Scanner* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp4_ = self->priv->job_id;
#line 187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp5_ = scanner;
#line 187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp6_ = _tmp5_->job_id;
#line 187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp0_ = _tmp4_ < _tmp6_;
#line 3952 "scanner.c"
	} else {
#line 187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp0_ = FALSE;
#line 3956 "scanner.c"
	}
#line 187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp0_) {
#line 3960 "scanner.c"
		Scanner* _tmp7_ = NULL;
#line 188 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_ = scanner;
#line 188 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_signal_emit_by_name (_tmp7_, "page-done");
#line 3966 "scanner.c"
	}
}


static void notify_page_done_class_init (NotifyPageDoneClass * klass) {
#line 181 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	notify_page_done_parent_class = g_type_class_peek_parent (klass);
#line 181 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_page_done_finalize;
#line 181 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyPageDonePrivate));
#line 181 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_page_done_real_run;
#line 3980 "scanner.c"
}


static void notify_page_done_instance_init (NotifyPageDone * self) {
#line 181 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv = NOTIFY_PAGE_DONE_GET_PRIVATE (self);
#line 3987 "scanner.c"
}


static void notify_page_done_finalize (Notify* obj) {
	NotifyPageDone * self;
#line 181 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_PAGE_DONE, NotifyPageDone);
#line 181 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (notify_page_done_parent_class)->finalize (obj);
#line 3997 "scanner.c"
}


GType notify_page_done_get_type (void) {
	static volatile gsize notify_page_done_type_id__volatile = 0;
	if (g_once_init_enter (&notify_page_done_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyPageDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_page_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyPageDone), 0, (GInstanceInitFunc) notify_page_done_instance_init, NULL };
		GType notify_page_done_type_id;
		notify_page_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyPageDone", &g_define_type_info, 0);
		g_once_init_leave (&notify_page_done_type_id__volatile, notify_page_done_type_id);
	}
	return notify_page_done_type_id__volatile;
}


static gpointer _scan_line_ref0 (gpointer self) {
#line 194 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self ? scan_line_ref (self) : NULL;
#line 4016 "scanner.c"
}


NotifyGotLine* notify_got_line_construct (GType object_type, gint job_id, ScanLine* line) {
	NotifyGotLine* self = NULL;
	gint _tmp0_ = 0;
	ScanLine* _tmp1_ = NULL;
	ScanLine* _tmp2_ = NULL;
#line 194 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (line != NULL, NULL);
#line 194 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyGotLine*) notify_construct (object_type);
#line 194 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = job_id;
#line 194 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->job_id = _tmp0_;
#line 194 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = line;
#line 194 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = _scan_line_ref0 (_tmp1_);
#line 194 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_scan_line_unref0 (self->priv->line);
#line 194 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->line = _tmp2_;
#line 194 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 4043 "scanner.c"
}


NotifyGotLine* notify_got_line_new (gint job_id, ScanLine* line) {
#line 194 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return notify_got_line_construct (TYPE_NOTIFY_GOT_LINE, job_id, line);
#line 4050 "scanner.c"
}


static void notify_got_line_real_run (Notify* base, Scanner* scanner) {
	NotifyGotLine * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	Scanner* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 197 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (NotifyGotLine*) base;
#line 197 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = scanner;
#line 199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = _tmp2_->first_job_id;
#line 199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp1_ >= _tmp3_) {
#line 4072 "scanner.c"
		gint _tmp4_ = 0;
		Scanner* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp4_ = self->priv->job_id;
#line 199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp5_ = scanner;
#line 199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp6_ = _tmp5_->job_id;
#line 199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp0_ = _tmp4_ < _tmp6_;
#line 4084 "scanner.c"
	} else {
#line 199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp0_ = FALSE;
#line 4088 "scanner.c"
	}
#line 199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp0_) {
#line 4092 "scanner.c"
		Scanner* _tmp7_ = NULL;
		ScanLine* _tmp8_ = NULL;
#line 200 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_ = scanner;
#line 200 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp8_ = self->priv->line;
#line 200 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_signal_emit_by_name (_tmp7_, "got-line", _tmp8_);
#line 4101 "scanner.c"
	}
}


static void notify_got_line_class_init (NotifyGotLineClass * klass) {
#line 192 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	notify_got_line_parent_class = g_type_class_peek_parent (klass);
#line 192 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_got_line_finalize;
#line 192 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyGotLinePrivate));
#line 192 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_got_line_real_run;
#line 4115 "scanner.c"
}


static void notify_got_line_instance_init (NotifyGotLine * self) {
#line 192 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv = NOTIFY_GOT_LINE_GET_PRIVATE (self);
#line 4122 "scanner.c"
}


static void notify_got_line_finalize (Notify* obj) {
	NotifyGotLine * self;
#line 192 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_GOT_LINE, NotifyGotLine);
#line 196 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_scan_line_unref0 (self->priv->line);
#line 192 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	NOTIFY_CLASS (notify_got_line_parent_class)->finalize (obj);
#line 4134 "scanner.c"
}


GType notify_got_line_get_type (void) {
	static volatile gsize notify_got_line_type_id__volatile = 0;
	if (g_once_init_enter (&notify_got_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyGotLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotLine), 0, (GInstanceInitFunc) notify_got_line_instance_init, NULL };
		GType notify_got_line_type_id;
		notify_got_line_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotLine", &g_define_type_info, 0);
		g_once_init_leave (&notify_got_line_type_id__volatile, notify_got_line_type_id);
	}
	return notify_got_line_type_id__volatile;
}


static void _scan_job_unref0_ (gpointer var) {
#line 230 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	(var == NULL) ? NULL : (var = (scan_job_unref (var), NULL));
#line 4153 "scanner.c"
}


static void _g_list_free__scan_job_unref0_ (GList* self) {
#line 230 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_list_foreach (self, (GFunc) _scan_job_unref0_, NULL);
#line 230 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_list_free (self);
#line 4162 "scanner.c"
}


static void _request_unref0_ (gpointer var) {
#line 269 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	(var == NULL) ? NULL : (var = (request_unref (var), NULL));
#line 4169 "scanner.c"
}


static void _notify_unref0_ (gpointer var) {
#line 270 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	(var == NULL) ? NULL : (var = (notify_unref (var), NULL));
#line 4176 "scanner.c"
}


static void _credentials_unref0_ (gpointer var) {
#line 271 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	(var == NULL) ? NULL : (var = (credentials_unref (var), NULL));
#line 4183 "scanner.c"
}


static Scanner* scanner_construct (GType object_type) {
	Scanner* self = NULL;
	GAsyncQueue* _tmp0_ = NULL;
	GAsyncQueue* _tmp1_ = NULL;
	GAsyncQueue* _tmp2_ = NULL;
#line 267 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = (Scanner*) g_type_create_instance (object_type);
#line 269 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = g_async_queue_new_full (_request_unref0_);
#line 269 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->request_queue);
#line 269 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->request_queue = _tmp0_;
#line 270 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = g_async_queue_new_full (_notify_unref0_);
#line 270 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->notify_queue);
#line 270 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->notify_queue = _tmp1_;
#line 271 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = g_async_queue_new_full (_credentials_unref0_);
#line 271 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->authorize_queue);
#line 271 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->authorize_queue = _tmp2_;
#line 267 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self;
#line 4214 "scanner.c"
}


static Scanner* scanner_new (void) {
#line 267 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return scanner_construct (TYPE_SCANNER);
#line 4221 "scanner.c"
}


static gpointer _scanner_ref0 (gpointer self) {
#line 278 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self ? scanner_ref (self) : NULL;
#line 4228 "scanner.c"
}


Scanner* scanner_get_instance (void) {
	Scanner* result = NULL;
	Scanner* _tmp0_ = NULL;
	Scanner* _tmp2_ = NULL;
	Scanner* _tmp3_ = NULL;
#line 276 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = scanner_scanner_object;
#line 276 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp0_ == NULL) {
#line 4241 "scanner.c"
		Scanner* _tmp1_ = NULL;
#line 277 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp1_ = scanner_new ();
#line 277 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_scanner_unref0 (scanner_scanner_object);
#line 277 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_scanner_object = _tmp1_;
#line 4249 "scanner.c"
	}
#line 278 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = scanner_scanner_object;
#line 278 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = _scanner_ref0 (_tmp2_);
#line 278 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	result = _tmp3_;
#line 278 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return result;
#line 4259 "scanner.c"
}


static gboolean scanner_notify_idle_cb (Scanner* self) {
	gboolean result = FALSE;
	Notify* notification = NULL;
	GAsyncQueue* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
#line 281 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 283 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = self->priv->notify_queue;
#line 283 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = g_async_queue_pop (_tmp0_);
#line 283 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	notification = (Notify*) _tmp1_;
#line 284 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	notify_run (notification, self);
#line 285 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	result = FALSE;
#line 285 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_notify_unref0 (notification);
#line 285 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return result;
#line 4284 "scanner.c"
}


static gpointer _notify_ref0 (gpointer self) {
#line 290 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self ? notify_ref (self) : NULL;
#line 4291 "scanner.c"
}


static gboolean _scanner_notify_idle_cb_gsource_func (gpointer self) {
	gboolean result;
	result = scanner_notify_idle_cb ((Scanner*) self);
#line 291 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return result;
#line 4300 "scanner.c"
}


static void scanner_notify (Scanner* self, Notify* notification) {
	GAsyncQueue* _tmp0_ = NULL;
	Notify* _tmp1_ = NULL;
	Notify* _tmp2_ = NULL;
#line 288 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 288 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (notification != NULL);
#line 290 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = self->priv->notify_queue;
#line 290 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = notification;
#line 290 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = _notify_ref0 (_tmp1_);
#line 290 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_async_queue_push (_tmp0_, _tmp2_);
#line 291 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _scanner_notify_idle_cb_gsource_func, scanner_ref (self), scanner_unref);
#line 4322 "scanner.c"
}


static void scanner_set_scanning (Scanner* self, gboolean is_scanning) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 294 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = self->priv->scanning;
#line 296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp2_) {
#line 4336 "scanner.c"
		gboolean _tmp3_ = FALSE;
#line 296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp3_ = is_scanning;
#line 296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp1_ = !_tmp3_;
#line 4342 "scanner.c"
	} else {
#line 296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp1_ = FALSE;
#line 4346 "scanner.c"
	}
#line 296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp1_) {
#line 296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp0_ = TRUE;
#line 4352 "scanner.c"
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp5_ = self->priv->scanning;
#line 296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (!_tmp5_) {
#line 4360 "scanner.c"
			gboolean _tmp6_ = FALSE;
#line 296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp6_ = is_scanning;
#line 296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp4_ = _tmp6_;
#line 4366 "scanner.c"
		} else {
#line 296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp4_ = FALSE;
#line 4370 "scanner.c"
		}
#line 296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp0_ = _tmp4_;
#line 4374 "scanner.c"
	}
#line 296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp0_) {
#line 4378 "scanner.c"
		gboolean _tmp7_ = FALSE;
		NotifyScanningChanged* _tmp8_ = NULL;
		NotifyScanningChanged* _tmp9_ = NULL;
#line 298 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_ = is_scanning;
#line 298 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->scanning = _tmp7_;
#line 299 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp8_ = notify_scanning_changed_new ();
#line 299 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp9_ = _tmp8_;
#line 299 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp9_);
#line 299 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_notify_unref0 (_tmp9_);
#line 4394 "scanner.c"
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1274 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1274 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1275 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1275 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1275 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1275 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 4415 "scanner.c"
}


static gint scanner_get_device_weight (const gchar* device) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 303 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (device != NULL, 0);
#line 308 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = device;
#line 308 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, "vfl:");
#line 308 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp1_) {
#line 309 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		result = 2;
#line 309 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return result;
#line 4437 "scanner.c"
	}
#line 312 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = device;
#line 312 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = string_contains (_tmp2_, "usb");
#line 312 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp3_) {
#line 313 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		result = 0;
#line 313 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return result;
#line 4449 "scanner.c"
	}
#line 315 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	result = 1;
#line 315 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return result;
#line 4455 "scanner.c"
}


static gint scanner_compare_devices (ScanDevice* device1, ScanDevice* device2) {
	gint result = 0;
	gint weight1 = 0;
	ScanDevice* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint weight2 = 0;
	ScanDevice* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GCompareFunc _tmp10_ = NULL;
	ScanDevice* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	ScanDevice* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gint _tmp15_ = 0;
#line 318 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (device1 != NULL, 0);
#line 318 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (device2 != NULL, 0);
#line 322 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = device1;
#line 322 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = _tmp0_->name;
#line 322 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = scanner_get_device_weight (_tmp1_);
#line 322 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	weight1 = _tmp2_;
#line 323 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = device2;
#line 323 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = _tmp3_->name;
#line 323 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = scanner_get_device_weight (_tmp4_);
#line 323 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	weight2 = _tmp5_;
#line 324 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp6_ = weight1;
#line 324 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp7_ = weight2;
#line 324 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp6_ != _tmp7_) {
#line 4503 "scanner.c"
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 325 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp8_ = weight1;
#line 325 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp9_ = weight2;
#line 325 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		result = _tmp8_ - _tmp9_;
#line 325 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return result;
#line 4514 "scanner.c"
	}
#line 327 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp10_ = g_strcmp0;
#line 327 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp11_ = device1;
#line 327 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp12_ = _tmp11_->label;
#line 327 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp13_ = device2;
#line 327 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp14_ = _tmp13_->label;
#line 327 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp15_ = _tmp10_ (_tmp12_, _tmp14_);
#line 327 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	result = _tmp15_;
#line 327 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return result;
#line 4532 "scanner.c"
}


static gchar* sane_status_to_string (SANE_Status status) {
	gchar* result = NULL;
	SANE_Status _tmp0_ = 0;
#line 54 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
	_tmp0_ = status;
#line 54 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
	switch (_tmp0_) {
#line 54 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_STATUS_GOOD:
#line 4545 "scanner.c"
		{
			gchar* _tmp1_ = NULL;
#line 57 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp1_ = g_strdup ("SANE_STATUS_GOOD");
#line 57 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp1_;
#line 57 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 4554 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_STATUS_UNSUPPORTED:
#line 4558 "scanner.c"
		{
			gchar* _tmp2_ = NULL;
#line 59 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp2_ = g_strdup ("SANE_STATUS_UNSUPPORTED");
#line 59 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp2_;
#line 59 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 4567 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_STATUS_CANCELLED:
#line 4571 "scanner.c"
		{
			gchar* _tmp3_ = NULL;
#line 61 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp3_ = g_strdup ("SANE_STATUS_CANCELLED");
#line 61 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp3_;
#line 61 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 4580 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_STATUS_DEVICE_BUSY:
#line 4584 "scanner.c"
		{
			gchar* _tmp4_ = NULL;
#line 63 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp4_ = g_strdup ("SANE_STATUS_DEVICE_BUSY");
#line 63 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp4_;
#line 63 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 4593 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_STATUS_INVAL:
#line 4597 "scanner.c"
		{
			gchar* _tmp5_ = NULL;
#line 65 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp5_ = g_strdup ("SANE_STATUS_INVAL");
#line 65 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp5_;
#line 65 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 4606 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_STATUS_EOF:
#line 4610 "scanner.c"
		{
			gchar* _tmp6_ = NULL;
#line 67 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp6_ = g_strdup ("SANE_STATUS_EOF");
#line 67 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp6_;
#line 67 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 4619 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_STATUS_JAMMED:
#line 4623 "scanner.c"
		{
			gchar* _tmp7_ = NULL;
#line 69 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp7_ = g_strdup ("SANE_STATUS_JAMMED");
#line 69 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp7_;
#line 69 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 4632 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_STATUS_NO_DOCS:
#line 4636 "scanner.c"
		{
			gchar* _tmp8_ = NULL;
#line 71 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp8_ = g_strdup ("SANE_STATUS_NO_DOCS");
#line 71 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp8_;
#line 71 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 4645 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_STATUS_COVER_OPEN:
#line 4649 "scanner.c"
		{
			gchar* _tmp9_ = NULL;
#line 73 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp9_ = g_strdup ("SANE_STATUS_COVER_OPEN");
#line 73 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp9_;
#line 73 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 4658 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_STATUS_IO_ERROR:
#line 4662 "scanner.c"
		{
			gchar* _tmp10_ = NULL;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp10_ = g_strdup ("SANE_STATUS_IO_ERROR");
#line 75 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp10_;
#line 75 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 4671 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_STATUS_NO_MEM:
#line 4675 "scanner.c"
		{
			gchar* _tmp11_ = NULL;
#line 77 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp11_ = g_strdup ("SANE_STATUS_NO_MEM");
#line 77 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp11_;
#line 77 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 4684 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_STATUS_ACCESS_DENIED:
#line 4688 "scanner.c"
		{
			gchar* _tmp12_ = NULL;
#line 79 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp12_ = g_strdup ("SANE_STATUS_ACCESS_DENIED");
#line 79 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp12_;
#line 79 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 4697 "scanner.c"
		}
		default:
		{
			SANE_Status _tmp13_ = 0;
			gchar* _tmp14_ = NULL;
#line 81 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp13_ = status;
#line 81 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp14_ = g_strdup_printf ("SANE_STATUS(%d)", (gint) _tmp13_);
#line 81 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp14_;
#line 81 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 4711 "scanner.c"
		}
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1278 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1278 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1278 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 4726 "scanner.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4757 "scanner.c"
				goto __catch13_g_regex_error;
			}
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1280 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			return NULL;
#line 4766 "scanner.c"
		}
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4782 "scanner.c"
				goto __catch13_g_regex_error;
			}
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
			return NULL;
#line 4793 "scanner.c"
		}
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1281 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 4807 "scanner.c"
	}
	goto __finally13;
	__catch13_g_regex_error:
	{
		GError* e = NULL;
#line 1279 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1279 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1283 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1279 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 4821 "scanner.c"
	}
	__finally13:
#line 1279 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1279 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1279 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1279 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		return NULL;
#line 4832 "scanner.c"
	}
}


static gpointer _scan_device_ref0 (gpointer self) {
#line 361 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self ? scan_device_ref (self) : NULL;
#line 4840 "scanner.c"
}


static gint _scanner_compare_devices_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = scanner_compare_devices ((ScanDevice*) a, (ScanDevice*) b);
#line 365 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return result;
#line 4849 "scanner.c"
}


static void scanner_do_redetect (Scanner* self) {
	SANE_Device** device_list = NULL;
	gint device_list_length1 = 0;
	gint _device_list_size_ = 0;
	SANE_Status status = 0;
	SANE_Device** _tmp0_ = NULL;
	SANE_Status _tmp1_ = 0;
	SANE_Status _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SANE_Status _tmp5_ = 0;
	GList* devices = NULL;
	GList* _tmp56_ = NULL;
	GList* _tmp63_ = NULL;
	NotifyUpdateDevices* _tmp64_ = NULL;
	NotifyUpdateDevices* _tmp65_ = NULL;
#line 330 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 332 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	device_list = NULL;
#line 332 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	device_list_length1 = 0;
#line 332 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_device_list_size_ = device_list_length1;
#line 333 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = sane_get_devices (&_tmp0_, FALSE);
#line 333 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	device_list = _tmp0_;
#line 333 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	device_list_length1 = -1;
#line 333 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_device_list_size_ = device_list_length1;
#line 333 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	status = _tmp1_;
#line 334 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = status;
#line 334 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = sane_status_to_string (_tmp2_);
#line 334 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 334 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:334: sane_get_devices () -> %s", _tmp4_);
#line 334 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp4_);
#line 335 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = status;
#line 335 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp5_ != SANE_STATUS_GOOD) {
#line 4901 "scanner.c"
		SANE_Status _tmp6_ = 0;
		const gchar* _tmp7_ = NULL;
#line 337 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp6_ = status;
#line 337 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_ = sane_strstatus (_tmp6_);
#line 337 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_warning ("scanner.vala:337: Unable to get SANE devices: %s", _tmp7_);
#line 338 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->need_redetect = FALSE;
#line 339 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->state = SCAN_STATE_IDLE;
#line 340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 4916 "scanner.c"
	}
#line 343 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	devices = NULL;
#line 4920 "scanner.c"
	{
		gint i = 0;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		i = 0;
#line 4925 "scanner.c"
		{
			gboolean _tmp8_ = FALSE;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp8_ = TRUE;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			while (TRUE) {
#line 4932 "scanner.c"
				SANE_Device** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint _tmp11_ = 0;
				SANE_Device* _tmp12_ = NULL;
				SANE_Device** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				SANE_Device* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				SANE_Device** _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				gint _tmp18_ = 0;
				SANE_Device* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				SANE_Device** _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				gint _tmp22_ = 0;
				SANE_Device* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				SANE_Device** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				gint _tmp26_ = 0;
				SANE_Device* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				ScanDevice* scan_device = NULL;
				ScanDevice* _tmp29_ = NULL;
				ScanDevice* _tmp30_ = NULL;
				SANE_Device** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				SANE_Device* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				gchar* vendor = NULL;
				SANE_Device** _tmp36_ = NULL;
				gint _tmp36__length1 = 0;
				gint _tmp37_ = 0;
				SANE_Device* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				ScanDevice* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				SANE_Device** _tmp45_ = NULL;
				gint _tmp45__length1 = 0;
				gint _tmp46_ = 0;
				SANE_Device* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				ScanDevice* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				gchar* _tmp52_ = NULL;
				gchar* _tmp53_ = NULL;
				ScanDevice* _tmp54_ = NULL;
				ScanDevice* _tmp55_ = NULL;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (!_tmp8_) {
#line 4990 "scanner.c"
					gint _tmp9_ = 0;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp9_ = i;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					i = _tmp9_ + 1;
#line 4996 "scanner.c"
				}
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp8_ = FALSE;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp10_ = device_list;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp10__length1 = device_list_length1;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp11_ = i;
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp12_ = _tmp10_[_tmp11_];
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (!(_tmp12_ != NULL)) {
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					break;
#line 5012 "scanner.c"
				}
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp13_ = device_list;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp13__length1 = device_list_length1;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp14_ = i;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp15_ = _tmp13_[_tmp14_];
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp16_ = _tmp15_->name;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp17_ = device_list;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp17__length1 = device_list_length1;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp18_ = i;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp19_ = _tmp17_[_tmp18_];
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp20_ = _tmp19_->vendor;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp21_ = device_list;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp21__length1 = device_list_length1;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp22_ = i;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp23_ = _tmp21_[_tmp22_];
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp24_ = _tmp23_->model;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp25_ = device_list;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp25__length1 = device_list_length1;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp26_ = i;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp27_ = _tmp25_[_tmp26_];
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp28_ = _tmp27_->type;
#line 346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				g_debug ("scanner.vala:346: Device: name=\"%s\" vendor=\"%s\" model=\"%s\" type=" \
"\"%s\"", _tmp16_, _tmp20_, _tmp24_, _tmp28_);
#line 349 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp29_ = scan_device_new ();
#line 349 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scan_device = _tmp29_;
#line 350 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp30_ = scan_device;
#line 350 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp31_ = device_list;
#line 350 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp31__length1 = device_list_length1;
#line 350 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp32_ = i;
#line 350 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp33_ = _tmp31_[_tmp32_];
#line 350 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp34_ = _tmp33_->name;
#line 350 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp35_ = g_strdup (_tmp34_);
#line 350 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (_tmp30_->name);
#line 350 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp30_->name = _tmp35_;
#line 353 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp36_ = device_list;
#line 353 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp36__length1 = device_list_length1;
#line 353 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp37_ = i;
#line 353 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp38_ = _tmp36_[_tmp37_];
#line 353 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp39_ = _tmp38_->vendor;
#line 353 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp40_ = g_strdup (_tmp39_);
#line 353 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				vendor = _tmp40_;
#line 354 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp41_ = vendor;
#line 354 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (g_strcmp0 (_tmp41_, "Hewlett-Packard") == 0) {
#line 5096 "scanner.c"
					gchar* _tmp42_ = NULL;
#line 355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp42_ = g_strdup ("HP");
#line 355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_g_free0 (vendor);
#line 355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					vendor = _tmp42_;
#line 5104 "scanner.c"
				}
#line 357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp43_ = scan_device;
#line 357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp44_ = vendor;
#line 357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp45_ = device_list;
#line 357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp45__length1 = device_list_length1;
#line 357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp46_ = i;
#line 357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp47_ = _tmp45_[_tmp46_];
#line 357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp48_ = _tmp47_->model;
#line 357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp49_ = g_strdup_printf ("%s %s", _tmp44_, _tmp48_);
#line 357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (_tmp43_->label);
#line 357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp43_->label = _tmp49_;
#line 359 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp50_ = scan_device;
#line 359 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp51_ = _tmp50_->label;
#line 359 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp52_ = string_replace (_tmp51_, "_", " ");
#line 359 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp53_ = _tmp52_;
#line 359 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (_tmp53_);
#line 361 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp54_ = scan_device;
#line 361 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp55_ = _scan_device_ref0 (_tmp54_);
#line 361 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				devices = g_list_append (devices, _tmp55_);
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (vendor);
#line 344 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_scan_device_unref0 (scan_device);
#line 5146 "scanner.c"
			}
		}
	}
#line 365 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	devices = g_list_sort (devices, _scanner_compare_devices_gcompare_func);
#line 367 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->need_redetect = FALSE;
#line 368 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 370 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp56_ = devices;
#line 370 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp56_ != NULL) {
#line 5160 "scanner.c"
		ScanDevice* device = NULL;
		GList* _tmp57_ = NULL;
		gconstpointer _tmp58_ = NULL;
		ScanDevice* _tmp59_ = NULL;
		ScanDevice* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
#line 372 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp57_ = devices;
#line 372 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp58_ = g_list_nth_data (_tmp57_, (guint) 0);
#line 372 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp59_ = _scan_device_ref0 ((ScanDevice*) _tmp58_);
#line 372 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		device = _tmp59_;
#line 373 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp60_ = device;
#line 373 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp61_ = _tmp60_->name;
#line 373 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp62_ = g_strdup (_tmp61_);
#line 373 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_free0 (self->priv->default_device);
#line 373 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->default_device = _tmp62_;
#line 370 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_scan_device_unref0 (device);
#line 5188 "scanner.c"
	} else {
#line 376 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_free0 (self->priv->default_device);
#line 376 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->default_device = NULL;
#line 5194 "scanner.c"
	}
#line 378 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp63_ = devices;
#line 378 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	devices = NULL;
#line 378 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp64_ = notify_update_devices_new (_tmp63_);
#line 378 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp65_ = _tmp64_;
#line 378 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp65_);
#line 378 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_notify_unref0 (_tmp65_);
#line 330 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (devices);
#line 5210 "scanner.c"
}


static gboolean scanner_set_default_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index) {
	gboolean result = FALSE;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Int _tmp1_ = {0};
	SANE_Status status = 0;
	SANE_Handle _tmp2_ = {0};
	SANE_Int _tmp3_ = {0};
	SANE_Status _tmp4_ = 0;
	SANE_Int _tmp5_ = {0};
	SANE_Status _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	SANE_Status _tmp9_ = 0;
	SANE_Status _tmp14_ = 0;
#line 381 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 381 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 384 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = option;
#line 384 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = _tmp0_->cap;
#line 384 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if ((_tmp1_ & SANE_CAP_AUTOMATIC) == ((SANE_Int) 0)) {
#line 385 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		result = FALSE;
#line 385 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return result;
#line 5242 "scanner.c"
	}
#line 387 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = handle;
#line 387 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = option_index;
#line 387 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = sane_control_option (_tmp2_, _tmp3_, SANE_ACTION_SET_AUTO, NULL, NULL);
#line 387 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	status = _tmp4_;
#line 388 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = option_index;
#line 388 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp6_ = status;
#line 388 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp7_ = sane_status_to_string (_tmp6_);
#line 388 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp8_ = _tmp7_;
#line 388 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:388: sane_control_option (%d, SANE_ACTION_SET_AUTO) -> %s", (gint) _tmp5_, _tmp8_);
#line 388 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp8_);
#line 389 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp9_ = status;
#line 389 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp9_ != SANE_STATUS_GOOD) {
#line 5268 "scanner.c"
		SANE_Option_Descriptor* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		SANE_Status _tmp12_ = 0;
		const gchar* _tmp13_ = NULL;
#line 390 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp10_ = option;
#line 390 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp11_ = _tmp10_->name;
#line 390 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp12_ = status;
#line 390 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp13_ = sane_strstatus (_tmp12_);
#line 390 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_warning ("scanner.vala:390: Error setting default option %s: %s", _tmp11_, _tmp13_);
#line 5283 "scanner.c"
	}
#line 392 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp14_ = status;
#line 392 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	result = _tmp14_ == SANE_STATUS_GOOD;
#line 392 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return result;
#line 5291 "scanner.c"
}


static void scanner_set_bool_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gboolean value, gboolean* _result_) {
	gboolean _vala_result = FALSE;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Value_Type _tmp1_ = 0;
	SANE_Bool v = {0};
	gboolean _tmp2_ = FALSE;
	SANE_Status status = 0;
	SANE_Handle _tmp3_ = {0};
	SANE_Int _tmp4_ = {0};
	SANE_Status _tmp5_ = 0;
	SANE_Bool _tmp6_ = {0};
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	SANE_Int _tmp11_ = {0};
	SANE_Status _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
#line 395 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 395 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 397 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = option;
#line 397 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 397 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (_tmp1_ == SANE_TYPE_BOOL);
#line 399 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = value;
#line 399 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	v = (SANE_Bool) _tmp2_;
#line 400 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = handle;
#line 400 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = option_index;
#line 400 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = sane_control_option (_tmp3_, _tmp4_, SANE_ACTION_SET_VALUE, &v, NULL);
#line 400 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	status = _tmp5_;
#line 401 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp6_ = v;
#line 401 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_vala_result = (gboolean) _tmp6_;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp8_ = value;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp8_) {
#line 402 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_ = "SANE_TRUE";
#line 5346 "scanner.c"
	} else {
#line 402 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_ = "SANE_FALSE";
#line 5350 "scanner.c"
	}
#line 402 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp10_ = _vala_result;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp10_) {
#line 402 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp9_ = "SANE_TRUE";
#line 5358 "scanner.c"
	} else {
#line 402 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp9_ = "SANE_FALSE";
#line 5362 "scanner.c"
	}
#line 402 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp11_ = option_index;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp12_ = status;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp13_ = sane_status_to_string (_tmp12_);
#line 402 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp14_ = _tmp13_;
#line 402 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:402: sane_control_option (%d, SANE_ACTION_SET_VALUE, %s) " \
"-> (%s, %s)", (gint) _tmp11_, _tmp7_, _tmp14_, _tmp9_);
#line 402 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp14_);
#line 395 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_result_) {
#line 395 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*_result_ = _vala_result;
#line 5380 "scanner.c"
	}
}


static void scanner_set_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gint value, gint* _result_) {
	gint _vala_result = 0;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Value_Type _tmp1_ = 0;
	SANE_Int v = {0};
	gint _tmp2_ = 0;
	SANE_Option_Descriptor* _tmp3_ = NULL;
	SANE_Constraint_Type _tmp4_ = 0;
	SANE_Status status = 0;
	SANE_Handle _tmp48_ = {0};
	SANE_Int _tmp49_ = {0};
	SANE_Status _tmp50_ = 0;
	SANE_Int _tmp51_ = {0};
	gint _tmp52_ = 0;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	SANE_Int _tmp55_ = {0};
	SANE_Int _tmp56_ = {0};
#line 405 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 405 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 407 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = option;
#line 407 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 407 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (_tmp1_ == SANE_TYPE_INT);
#line 409 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = value;
#line 409 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	v = (SANE_Int) _tmp2_;
#line 410 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = option;
#line 410 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = _tmp3_->constraint_type;
#line 410 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp4_ == SANE_CONSTRAINT_RANGE) {
#line 5423 "scanner.c"
		SANE_Option_Descriptor* _tmp5_ = NULL;
		SANE_Range* _tmp6_ = NULL;
		SANE_Word _tmp7_ = {0};
		SANE_Int _tmp12_ = {0};
		SANE_Option_Descriptor* _tmp13_ = NULL;
		SANE_Range* _tmp14_ = NULL;
		SANE_Word _tmp15_ = {0};
		SANE_Int _tmp19_ = {0};
		SANE_Option_Descriptor* _tmp20_ = NULL;
		SANE_Range* _tmp21_ = NULL;
		SANE_Word _tmp22_ = {0};
#line 412 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp5_ = option;
#line 412 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp6_ = _tmp5_->constraint.range;
#line 412 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_ = _tmp6_->quant;
#line 412 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp7_ != ((SANE_Word) 0)) {
#line 5443 "scanner.c"
			SANE_Int _tmp8_ = {0};
			SANE_Option_Descriptor* _tmp9_ = NULL;
			SANE_Range* _tmp10_ = NULL;
			SANE_Word _tmp11_ = {0};
#line 413 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp8_ = v;
#line 413 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp9_ = option;
#line 413 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp10_ = _tmp9_->constraint.range;
#line 413 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp11_ = _tmp10_->quant;
#line 413 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			v = _tmp8_ * _tmp11_;
#line 5458 "scanner.c"
		}
#line 414 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp12_ = v;
#line 414 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp13_ = option;
#line 414 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp14_ = _tmp13_->constraint.range;
#line 414 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp15_ = _tmp14_->min;
#line 414 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp12_ < ((SANE_Int) _tmp15_)) {
#line 5470 "scanner.c"
			SANE_Option_Descriptor* _tmp16_ = NULL;
			SANE_Range* _tmp17_ = NULL;
			SANE_Word _tmp18_ = {0};
#line 415 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp16_ = option;
#line 415 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp17_ = _tmp16_->constraint.range;
#line 415 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp18_ = _tmp17_->min;
#line 415 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			v = (SANE_Int) _tmp18_;
#line 5482 "scanner.c"
		}
#line 416 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp19_ = v;
#line 416 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp20_ = option;
#line 416 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp21_ = _tmp20_->constraint.range;
#line 416 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp22_ = _tmp21_->max;
#line 416 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp19_ > ((SANE_Int) _tmp22_)) {
#line 5494 "scanner.c"
			SANE_Option_Descriptor* _tmp23_ = NULL;
			SANE_Range* _tmp24_ = NULL;
			SANE_Word _tmp25_ = {0};
#line 417 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp23_ = option;
#line 417 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp24_ = _tmp23_->constraint.range;
#line 417 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp25_ = _tmp24_->max;
#line 417 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			v = (SANE_Int) _tmp25_;
#line 5506 "scanner.c"
		}
	} else {
		SANE_Option_Descriptor* _tmp26_ = NULL;
		SANE_Constraint_Type _tmp27_ = 0;
#line 419 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp26_ = option;
#line 419 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp27_ = _tmp26_->constraint_type;
#line 419 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp27_ == SANE_CONSTRAINT_WORD_LIST) {
#line 5517 "scanner.c"
			gint distance = 0;
			gint _tmp28_ = 0;
			gint nearest = 0;
			gint _tmp47_ = 0;
#line 421 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp28_ = G_MAXINT;
#line 421 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			distance = _tmp28_;
#line 421 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			nearest = 0;
#line 5528 "scanner.c"
			{
				gint i = 0;
#line 424 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				i = 0;
#line 5533 "scanner.c"
				{
					gboolean _tmp29_ = FALSE;
#line 424 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp29_ = TRUE;
#line 424 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					while (TRUE) {
#line 5540 "scanner.c"
						gint _tmp31_ = 0;
						SANE_Option_Descriptor* _tmp32_ = NULL;
						SANE_Word* _tmp33_ = NULL;
						gint _tmp33__length1 = 0;
						SANE_Word _tmp34_ = {0};
						gint x = 0;
						SANE_Option_Descriptor* _tmp35_ = NULL;
						SANE_Word* _tmp36_ = NULL;
						gint _tmp36__length1 = 0;
						gint _tmp37_ = 0;
						SANE_Word _tmp38_ = {0};
						gint d = 0;
						gint _tmp39_ = 0;
						SANE_Int _tmp40_ = {0};
						gint _tmp41_ = 0;
						gint _tmp42_ = 0;
						gint _tmp43_ = 0;
						gint _tmp44_ = 0;
#line 424 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!_tmp29_) {
#line 5561 "scanner.c"
							gint _tmp30_ = 0;
#line 424 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp30_ = i;
#line 424 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							i = _tmp30_ + 1;
#line 5567 "scanner.c"
						}
#line 424 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp29_ = FALSE;
#line 424 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp31_ = i;
#line 424 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp32_ = option;
#line 424 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp33_ = _tmp32_->constraint.word_list;
#line 424 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp33__length1 = -1;
#line 424 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp34_ = _tmp33_[0];
#line 424 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!(((SANE_Word) _tmp31_) < _tmp34_)) {
#line 424 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							break;
#line 5585 "scanner.c"
						}
#line 426 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp35_ = option;
#line 426 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp36_ = _tmp35_->constraint.word_list;
#line 426 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp36__length1 = -1;
#line 426 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp37_ = i;
#line 426 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp38_ = _tmp36_[_tmp37_ + 1];
#line 426 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						x = (gint) _tmp38_;
#line 427 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp39_ = x;
#line 427 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp40_ = v;
#line 427 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						d = (gint) (_tmp39_ - _tmp40_);
#line 428 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp41_ = d;
#line 428 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp42_ = abs (_tmp41_);
#line 428 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						d = _tmp42_;
#line 429 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp43_ = d;
#line 429 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp44_ = distance;
#line 429 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (_tmp43_ < _tmp44_) {
#line 5617 "scanner.c"
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
#line 431 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp45_ = d;
#line 431 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							distance = _tmp45_;
#line 432 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp46_ = x;
#line 432 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							nearest = _tmp46_;
#line 5628 "scanner.c"
						}
					}
				}
			}
#line 435 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp47_ = nearest;
#line 435 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			v = (SANE_Int) _tmp47_;
#line 5637 "scanner.c"
		}
	}
#line 438 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp48_ = handle;
#line 438 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp49_ = option_index;
#line 438 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp50_ = sane_control_option (_tmp48_, _tmp49_, SANE_ACTION_SET_VALUE, &v, NULL);
#line 438 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	status = _tmp50_;
#line 439 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp51_ = option_index;
#line 439 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp52_ = value;
#line 439 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp53_ = sane_status_to_string (status);
#line 439 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp54_ = _tmp53_;
#line 439 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp55_ = v;
#line 439 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:439: sane_control_option (%d, SANE_ACTION_SET_VALUE, %d) " \
"-> (%s, %d)", (gint) _tmp51_, _tmp52_, _tmp54_, (gint) _tmp55_);
#line 439 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp54_);
#line 440 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp56_ = v;
#line 440 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_vala_result = (gint) _tmp56_;
#line 405 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_result_) {
#line 405 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*_result_ = _vala_result;
#line 5670 "scanner.c"
	}
}


static void scanner_set_fixed_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	SANE_Fixed v_fixed = {0};
	SANE_Option_Descriptor* _tmp1_ = NULL;
	SANE_Value_Type _tmp2_ = 0;
	SANE_Option_Descriptor* _tmp3_ = NULL;
	SANE_Constraint_Type _tmp4_ = 0;
	gdouble _tmp42_ = 0.0;
	SANE_Fixed _tmp43_ = {0};
	SANE_Status status = 0;
	SANE_Handle _tmp44_ = {0};
	SANE_Int _tmp45_ = {0};
	SANE_Status _tmp46_ = 0;
	SANE_Int _tmp47_ = {0};
	gdouble _tmp48_ = 0.0;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gdouble _tmp51_ = 0.0;
	gdouble _tmp52_ = 0.0;
#line 443 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 443 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 445 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = value;
#line 445 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	v = _tmp0_;
#line 448 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = option;
#line 448 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = _tmp1_->type;
#line 448 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (_tmp2_ == SANE_TYPE_FIXED);
#line 450 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = option;
#line 450 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = _tmp3_->constraint_type;
#line 450 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp4_ == SANE_CONSTRAINT_RANGE) {
#line 5716 "scanner.c"
		gdouble min = 0.0;
		SANE_Option_Descriptor* _tmp5_ = NULL;
		SANE_Range* _tmp6_ = NULL;
		SANE_Word _tmp7_ = {0};
		gdouble _tmp8_ = 0.0;
		gdouble max = 0.0;
		SANE_Option_Descriptor* _tmp9_ = NULL;
		SANE_Range* _tmp10_ = NULL;
		SANE_Word _tmp11_ = {0};
		gdouble _tmp12_ = 0.0;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		gdouble _tmp16_ = 0.0;
		gdouble _tmp17_ = 0.0;
#line 452 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp5_ = option;
#line 452 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp6_ = _tmp5_->constraint.range;
#line 452 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_ = _tmp6_->min;
#line 452 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp8_ = SANE_UNFIX ((SANE_Fixed) _tmp7_);
#line 452 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		min = _tmp8_;
#line 453 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp9_ = option;
#line 453 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp10_ = _tmp9_->constraint.range;
#line 453 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp11_ = _tmp10_->max;
#line 453 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp12_ = SANE_UNFIX ((SANE_Fixed) _tmp11_);
#line 453 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		max = _tmp12_;
#line 455 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp13_ = v;
#line 455 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp14_ = min;
#line 455 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp13_ < _tmp14_) {
#line 5757 "scanner.c"
			gdouble _tmp15_ = 0.0;
#line 456 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp15_ = min;
#line 456 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			v = _tmp15_;
#line 5763 "scanner.c"
		}
#line 457 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp16_ = v;
#line 457 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp17_ = max;
#line 457 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp16_ > _tmp17_) {
#line 5771 "scanner.c"
			gdouble _tmp18_ = 0.0;
#line 458 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp18_ = max;
#line 458 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			v = _tmp18_;
#line 5777 "scanner.c"
		}
	} else {
		SANE_Option_Descriptor* _tmp19_ = NULL;
		SANE_Constraint_Type _tmp20_ = 0;
#line 460 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp19_ = option;
#line 460 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp20_ = _tmp19_->constraint_type;
#line 460 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp20_ == SANE_CONSTRAINT_WORD_LIST) {
#line 5788 "scanner.c"
			gdouble distance = 0.0;
			gdouble _tmp21_ = 0.0;
			gdouble nearest = 0.0;
			gdouble _tmp41_ = 0.0;
#line 462 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp21_ = DBL_MAX;
#line 462 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			distance = _tmp21_;
#line 462 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			nearest = 0.0;
#line 5799 "scanner.c"
			{
				gint i = 0;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				i = 0;
#line 5804 "scanner.c"
				{
					gboolean _tmp22_ = FALSE;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp22_ = TRUE;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					while (TRUE) {
#line 5811 "scanner.c"
						gint _tmp24_ = 0;
						SANE_Option_Descriptor* _tmp25_ = NULL;
						SANE_Word* _tmp26_ = NULL;
						gint _tmp26__length1 = 0;
						SANE_Word _tmp27_ = {0};
						gdouble x = 0.0;
						SANE_Option_Descriptor* _tmp28_ = NULL;
						SANE_Word* _tmp29_ = NULL;
						gint _tmp29__length1 = 0;
						gint _tmp30_ = 0;
						SANE_Word _tmp31_ = {0};
						gdouble _tmp32_ = 0.0;
						gdouble _tmp33_ = 0.0;
						gdouble _tmp34_ = 0.0;
						gdouble _tmp35_ = 0.0;
						gdouble _tmp36_ = 0.0;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!_tmp22_) {
#line 5830 "scanner.c"
							gint _tmp23_ = 0;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp23_ = i;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							i = _tmp23_ + 1;
#line 5836 "scanner.c"
						}
#line 465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp22_ = FALSE;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp24_ = i;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp25_ = option;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp26_ = _tmp25_->constraint.word_list;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp26__length1 = -1;
#line 465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp27_ = _tmp26_[0];
#line 465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!(((SANE_Word) _tmp24_) < _tmp27_)) {
#line 465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							break;
#line 5854 "scanner.c"
						}
#line 467 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp28_ = option;
#line 467 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp29_ = _tmp28_->constraint.word_list;
#line 467 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp29__length1 = -1;
#line 467 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp30_ = i;
#line 467 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp31_ = _tmp29_[_tmp30_ + 1];
#line 467 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp32_ = SANE_UNFIX ((SANE_Fixed) _tmp31_);
#line 467 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						x = _tmp32_;
#line 468 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp33_ = x;
#line 468 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp34_ = v;
#line 468 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp35_ = fabs (_tmp33_ - _tmp34_);
#line 468 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp36_ = distance;
#line 468 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (_tmp35_ < _tmp36_) {
#line 5880 "scanner.c"
							gdouble _tmp37_ = 0.0;
							gdouble _tmp38_ = 0.0;
							gdouble _tmp39_ = 0.0;
							gdouble _tmp40_ = 0.0;
#line 470 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp37_ = x;
#line 470 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp38_ = v;
#line 470 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp39_ = fabs (_tmp37_ - _tmp38_);
#line 470 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							distance = _tmp39_;
#line 471 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp40_ = x;
#line 471 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							nearest = _tmp40_;
#line 5897 "scanner.c"
						}
					}
				}
			}
#line 474 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp41_ = nearest;
#line 474 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			v = _tmp41_;
#line 5906 "scanner.c"
		}
	}
#line 477 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp42_ = v;
#line 477 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp43_ = SANE_FIX (_tmp42_);
#line 477 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	v_fixed = _tmp43_;
#line 478 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp44_ = handle;
#line 478 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp45_ = option_index;
#line 478 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp46_ = sane_control_option (_tmp44_, _tmp45_, SANE_ACTION_SET_VALUE, &v_fixed, NULL);
#line 478 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	status = _tmp46_;
#line 479 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp47_ = option_index;
#line 479 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp48_ = value;
#line 479 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp49_ = sane_status_to_string (status);
#line 479 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp50_ = _tmp49_;
#line 479 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp51_ = SANE_UNFIX (v_fixed);
#line 479 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:479: sane_control_option (%d, SANE_ACTION_SET_VALUE, %f) " \
"-> (%s, %f)", (gint) _tmp47_, _tmp48_, _tmp50_, _tmp51_);
#line 479 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp50_);
#line 481 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp52_ = SANE_UNFIX (v_fixed);
#line 481 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_vala_result = _tmp52_;
#line 443 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_result_) {
#line 443 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*_result_ = _vala_result;
#line 5945 "scanner.c"
	}
}


static void scanner_set_fixed_or_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Value_Type _tmp1_ = 0;
#line 484 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 484 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 486 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = option;
#line 486 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 486 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp1_ == SANE_TYPE_FIXED) {
#line 5964 "scanner.c"
		SANE_Handle _tmp2_ = {0};
		SANE_Option_Descriptor* _tmp3_ = NULL;
		SANE_Int _tmp4_ = {0};
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
#line 487 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp2_ = handle;
#line 487 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp3_ = option;
#line 487 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp4_ = option_index;
#line 487 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp5_ = value;
#line 487 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_set_fixed_option (self, _tmp2_, _tmp3_, _tmp4_, _tmp5_, &_tmp6_);
#line 487 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_vala_result = _tmp6_;
#line 5982 "scanner.c"
	} else {
		SANE_Option_Descriptor* _tmp7_ = NULL;
		SANE_Value_Type _tmp8_ = 0;
#line 488 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_ = option;
#line 488 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp8_ = _tmp7_->type;
#line 488 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp8_ == SANE_TYPE_INT) {
#line 5992 "scanner.c"
			gint r = 0;
			SANE_Handle _tmp9_ = {0};
			SANE_Option_Descriptor* _tmp10_ = NULL;
			SANE_Int _tmp11_ = {0};
			gdouble _tmp12_ = 0.0;
			gdouble _tmp13_ = 0.0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
#line 491 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp9_ = handle;
#line 491 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp10_ = option;
#line 491 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp11_ = option_index;
#line 491 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp12_ = value;
#line 491 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp13_ = round (_tmp12_);
#line 491 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			scanner_set_int_option (self, _tmp9_, _tmp10_, _tmp11_, (gint) _tmp13_, &_tmp14_);
#line 491 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			r = _tmp14_;
#line 492 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp15_ = r;
#line 492 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_vala_result = (gdouble) _tmp15_;
#line 6019 "scanner.c"
		} else {
#line 496 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_vala_result = 0.0;
#line 497 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			g_warning ("scanner.vala:497: Unable to set unsupported option type");
#line 6025 "scanner.c"
		}
	}
#line 484 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_result_) {
#line 484 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*_result_ = _vala_result;
#line 6032 "scanner.c"
	}
}


static void scanner_set_option_to_max (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index) {
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Constraint_Type _tmp1_ = 0;
	SANE_Status status = 0;
	SANE_Handle _tmp2_ = {0};
	SANE_Int _tmp3_ = {0};
	SANE_Option_Descriptor* _tmp4_ = NULL;
	SANE_Range* _tmp5_ = NULL;
	SANE_Status _tmp6_ = 0;
	SANE_Int _tmp7_ = {0};
	SANE_Status _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
#line 501 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 501 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 503 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = option;
#line 503 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = _tmp0_->constraint_type;
#line 503 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp1_ != SANE_CONSTRAINT_RANGE) {
#line 504 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 6062 "scanner.c"
	}
#line 506 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = handle;
#line 506 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = option_index;
#line 506 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = option;
#line 506 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = _tmp4_->constraint.range;
#line 506 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp6_ = sane_control_option (_tmp2_, _tmp3_, SANE_ACTION_SET_VALUE, &_tmp5_->max, NULL);
#line 506 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	status = _tmp6_;
#line 507 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp7_ = option_index;
#line 507 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp8_ = status;
#line 507 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp9_ = sane_status_to_string (_tmp8_);
#line 507 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp10_ = _tmp9_;
#line 507 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:507: sane_control_option (%d, SANE_ACTION_SET_VALUE, opti" \
"on.range.max) -> (%s)", (gint) _tmp7_, _tmp10_);
#line 507 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp10_);
#line 6088 "scanner.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 6106 "scanner.c"
}


static gboolean scanner_set_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, const gchar* value, gchar** _result_) {
	gchar* _vala_result = NULL;
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	SANE_Option_Descriptor* _tmp1_ = NULL;
	SANE_Value_Type _tmp2_ = 0;
	gchar* s = NULL;
	SANE_Option_Descriptor* _tmp3_ = NULL;
	SANE_Int _tmp4_ = {0};
	gchar* _tmp5_ = NULL;
	gint s_length1 = 0;
	gint _s_size_ = 0;
	gint i = 0;
	gchar* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp22_ = 0;
	gchar _tmp23_ = '\0';
	SANE_Status status = 0;
	SANE_Handle _tmp24_ = {0};
	SANE_Int _tmp25_ = {0};
	gchar* _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	SANE_Status _tmp27_ = 0;
	gchar* _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	gchar* _tmp29_ = NULL;
	SANE_Int _tmp30_ = {0};
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
#line 510 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 510 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 510 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (value != NULL, FALSE);
#line 512 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = g_strdup ("");
#line 512 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_vala_result);
#line 512 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_vala_result = _tmp0_;
#line 514 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = option;
#line 514 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = _tmp1_->type;
#line 514 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (_tmp2_ == SANE_TYPE_STRING, FALSE);
#line 516 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = option;
#line 516 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = _tmp3_->size;
#line 516 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = g_new0 (gchar, _tmp4_);
#line 516 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	s = _tmp5_;
#line 516 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	s_length1 = _tmp4_;
#line 516 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_s_size_ = s_length1;
#line 517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	i = 0;
#line 6173 "scanner.c"
	{
		gboolean _tmp6_ = FALSE;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp6_ = TRUE;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		while (TRUE) {
#line 6180 "scanner.c"
			gboolean _tmp8_ = FALSE;
			gint _tmp9_ = 0;
			SANE_Option_Descriptor* _tmp10_ = NULL;
			SANE_Int _tmp11_ = {0};
			gchar* _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			gint _tmp16_ = 0;
			const gchar* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gchar _tmp19_ = '\0';
			gchar _tmp20_ = '\0';
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (!_tmp6_) {
#line 6194 "scanner.c"
				gint _tmp7_ = 0;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp7_ = i;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				i = _tmp7_ + 1;
#line 6200 "scanner.c"
			}
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp6_ = FALSE;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp9_ = i;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp10_ = option;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp11_ = _tmp10_->size;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (((SANE_Int) _tmp9_) < (_tmp11_ - 1)) {
#line 6212 "scanner.c"
				const gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gchar _tmp14_ = '\0';
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp12_ = value;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp13_ = i;
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp8_ = _tmp14_ != '\0';
#line 6224 "scanner.c"
			} else {
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp8_ = FALSE;
#line 6228 "scanner.c"
			}
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (!_tmp8_) {
#line 518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				break;
#line 6234 "scanner.c"
			}
#line 519 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp15_ = s;
#line 519 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp15__length1 = s_length1;
#line 519 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp16_ = i;
#line 519 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp17_ = value;
#line 519 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp18_ = i;
#line 519 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp19_ = string_get (_tmp17_, (glong) _tmp18_);
#line 519 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp15_[_tmp16_] = _tmp19_;
#line 519 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp20_ = _tmp15_[_tmp16_];
#line 6252 "scanner.c"
		}
	}
#line 520 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp21_ = s;
#line 520 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp21__length1 = s_length1;
#line 520 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp22_ = i;
#line 520 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp21_[_tmp22_] = '\0';
#line 520 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp23_ = _tmp21_[_tmp22_];
#line 521 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp24_ = handle;
#line 521 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp25_ = option_index;
#line 521 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp26_ = s;
#line 521 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp26__length1 = s_length1;
#line 521 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp27_ = sane_control_option (_tmp24_, _tmp25_, SANE_ACTION_SET_VALUE, _tmp26_, NULL);
#line 521 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	status = _tmp27_;
#line 522 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp28_ = s;
#line 522 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp28__length1 = s_length1;
#line 522 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp29_ = g_strdup ((const gchar*) _tmp28_);
#line 522 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_vala_result);
#line 522 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_vala_result = _tmp29_;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp30_ = option_index;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp31_ = value;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp32_ = sane_status_to_string (status);
#line 523 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp33_ = _tmp32_;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp34_ = _vala_result;
#line 523 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:523: sane_control_option (%d, SANE_ACTION_SET_VALUE, \"%s" \
"\") -> (%s, \"%s\")", (gint) _tmp30_, _tmp31_, _tmp33_, _tmp34_);
#line 523 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp33_);
#line 525 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	result = status == SANE_STATUS_GOOD;
#line 525 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	s = (g_free (s), NULL);
#line 525 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_result_) {
#line 525 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*_result_ = _vala_result;
#line 6309 "scanner.c"
	} else {
#line 525 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_free0 (_vala_result);
#line 6313 "scanner.c"
	}
#line 525 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return result;
#line 6317 "scanner.c"
}


static gboolean scanner_set_constrained_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gchar** values, int values_length1, gchar** _result_) {
	gchar* _vala_result = NULL;
	gboolean result = FALSE;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Value_Type _tmp1_ = 0;
	SANE_Option_Descriptor* _tmp2_ = NULL;
	SANE_Constraint_Type _tmp3_ = 0;
	gchar* _tmp34_ = NULL;
#line 528 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 528 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 530 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = option;
#line 530 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 530 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (_tmp1_ == SANE_TYPE_STRING, FALSE);
#line 531 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = option;
#line 531 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = _tmp2_->constraint_type;
#line 531 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (_tmp3_ == SANE_CONSTRAINT_STRING_LIST, FALSE);
#line 6345 "scanner.c"
	{
		gint i = 0;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		i = 0;
#line 6350 "scanner.c"
		{
			gboolean _tmp4_ = FALSE;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp4_ = TRUE;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			while (TRUE) {
#line 6357 "scanner.c"
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				const gchar* _tmp8_ = NULL;
				gint j = 0;
				SANE_Option_Descriptor* _tmp22_ = NULL;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gint _tmp24_ = 0;
				const gchar* _tmp25_ = NULL;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (!_tmp4_) {
#line 6370 "scanner.c"
					gint _tmp5_ = 0;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp5_ = i;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					i = _tmp5_ + 1;
#line 6376 "scanner.c"
				}
#line 533 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp4_ = FALSE;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp6_ = values;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp6__length1 = values_length1;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp7_ = i;
#line 533 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp8_ = _tmp6_[_tmp7_];
#line 533 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (!(_tmp8_ != NULL)) {
#line 533 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					break;
#line 6392 "scanner.c"
				}
#line 535 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				j = 0;
#line 6396 "scanner.c"
				{
					gboolean _tmp9_ = FALSE;
#line 536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp9_ = TRUE;
#line 536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					while (TRUE) {
#line 6403 "scanner.c"
						SANE_Option_Descriptor* _tmp11_ = NULL;
						gchar** _tmp12_ = NULL;
						gint _tmp12__length1 = 0;
						gint _tmp13_ = 0;
						const gchar* _tmp14_ = NULL;
						gchar** _tmp15_ = NULL;
						gint _tmp15__length1 = 0;
						gint _tmp16_ = 0;
						const gchar* _tmp17_ = NULL;
						SANE_Option_Descriptor* _tmp18_ = NULL;
						gchar** _tmp19_ = NULL;
						gint _tmp19__length1 = 0;
						gint _tmp20_ = 0;
						const gchar* _tmp21_ = NULL;
#line 536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!_tmp9_) {
#line 6420 "scanner.c"
							gint _tmp10_ = 0;
#line 536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp10_ = j;
#line 536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							j = _tmp10_ + 1;
#line 6426 "scanner.c"
						}
#line 536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp9_ = FALSE;
#line 536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp11_ = option;
#line 536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp12_ = _tmp11_->constraint.string_list;
#line 536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp12__length1 = -1;
#line 536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp13_ = j;
#line 536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp14_ = _tmp12_[_tmp13_];
#line 536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!(_tmp14_ != NULL)) {
#line 536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							break;
#line 6444 "scanner.c"
						}
#line 538 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp15_ = values;
#line 538 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp15__length1 = values_length1;
#line 538 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp16_ = i;
#line 538 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp17_ = _tmp15_[_tmp16_];
#line 538 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp18_ = option;
#line 538 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp19_ = _tmp18_->constraint.string_list;
#line 538 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp19__length1 = -1;
#line 538 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp20_ = j;
#line 538 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp21_ = _tmp19_[_tmp20_];
#line 538 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (g_strcmp0 (_tmp17_, _tmp21_) == 0) {
#line 539 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							break;
#line 6468 "scanner.c"
						}
					}
				}
#line 542 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp22_ = option;
#line 542 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp23_ = _tmp22_->constraint.string_list;
#line 542 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp23__length1 = -1;
#line 542 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp24_ = j;
#line 542 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp25_ = _tmp23_[_tmp24_];
#line 542 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (_tmp25_ != NULL) {
#line 6484 "scanner.c"
					SANE_Handle _tmp26_ = {0};
					SANE_Option_Descriptor* _tmp27_ = NULL;
					SANE_Int _tmp28_ = {0};
					gchar** _tmp29_ = NULL;
					gint _tmp29__length1 = 0;
					gint _tmp30_ = 0;
					const gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					gboolean _tmp33_ = FALSE;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp26_ = handle;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp27_ = option;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp28_ = option_index;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp29_ = values;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp29__length1 = values_length1;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp30_ = i;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp31_ = _tmp29_[_tmp30_];
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp33_ = scanner_set_string_option (self, _tmp26_, _tmp27_, _tmp28_, _tmp31_, &_tmp32_);
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_g_free0 (_vala_result);
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_vala_result = _tmp32_;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					result = _tmp33_;
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					if (_result_) {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						*_result_ = _vala_result;
#line 6520 "scanner.c"
					} else {
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_g_free0 (_vala_result);
#line 6524 "scanner.c"
					}
#line 543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					return result;
#line 6528 "scanner.c"
				}
			}
		}
	}
#line 546 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp34_ = g_strdup ("");
#line 546 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_vala_result);
#line 546 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_vala_result = _tmp34_;
#line 547 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	result = FALSE;
#line 547 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_result_) {
#line 547 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*_result_ = _vala_result;
#line 6545 "scanner.c"
	} else {
#line 547 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_free0 (_vala_result);
#line 6549 "scanner.c"
	}
#line 547 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return result;
#line 6553 "scanner.c"
}


static void scanner_log_option (Scanner* self, SANE_Int index, SANE_Option_Descriptor* option) {
	gchar* s = NULL;
	SANE_Int _tmp0_ = {0};
	gchar* _tmp1_ = NULL;
	SANE_Option_Descriptor* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	SANE_Option_Descriptor* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	SANE_Option_Descriptor* _tmp18_ = NULL;
	SANE_Value_Type _tmp19_ = 0;
	const gchar* _tmp38_ = NULL;
	SANE_Option_Descriptor* _tmp39_ = NULL;
	SANE_Int _tmp40_ = {0};
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	SANE_Option_Descriptor* _tmp44_ = NULL;
	SANE_Unit _tmp45_ = 0;
	SANE_Option_Descriptor* _tmp64_ = NULL;
	SANE_Constraint_Type _tmp65_ = 0;
	SANE_Int cap = {0};
	SANE_Option_Descriptor* _tmp149_ = NULL;
	SANE_Int _tmp150_ = {0};
	SANE_Int _tmp151_ = {0};
	const gchar* _tmp212_ = NULL;
	SANE_Option_Descriptor* _tmp213_ = NULL;
	const gchar* _tmp214_ = NULL;
#line 550 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 550 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 552 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = index;
#line 552 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = g_strdup_printf ("Option %d:", (gint) _tmp0_);
#line 552 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	s = _tmp1_;
#line 554 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = option;
#line 554 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = _tmp2_->name;
#line 554 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (g_strcmp0 (_tmp3_, "") != 0) {
#line 6600 "scanner.c"
		const gchar* _tmp4_ = NULL;
		SANE_Option_Descriptor* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 555 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp4_ = s;
#line 555 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp5_ = option;
#line 555 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp6_ = _tmp5_->name;
#line 555 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_ = g_strdup_printf (" name='%s'", _tmp6_);
#line 555 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp8_ = _tmp7_;
#line 555 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp9_ = g_strconcat (_tmp4_, _tmp8_, NULL);
#line 555 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_free0 (s);
#line 555 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		s = _tmp9_;
#line 555 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_free0 (_tmp8_);
#line 6625 "scanner.c"
	}
#line 557 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp10_ = option;
#line 557 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp11_ = _tmp10_->title;
#line 557 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (g_strcmp0 (_tmp11_, "") != 0) {
#line 6633 "scanner.c"
		const gchar* _tmp12_ = NULL;
		SANE_Option_Descriptor* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 558 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp12_ = s;
#line 558 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp13_ = option;
#line 558 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp14_ = _tmp13_->title;
#line 558 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp15_ = g_strdup_printf (" title='%s'", _tmp14_);
#line 558 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp16_ = _tmp15_;
#line 558 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp17_ = g_strconcat (_tmp12_, _tmp16_, NULL);
#line 558 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_free0 (s);
#line 558 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		s = _tmp17_;
#line 558 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_free0 (_tmp16_);
#line 6658 "scanner.c"
	}
#line 560 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp18_ = option;
#line 560 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp19_ = _tmp18_->type;
#line 560 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	switch (_tmp19_) {
#line 560 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_TYPE_BOOL:
#line 6668 "scanner.c"
		{
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
#line 563 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp20_ = s;
#line 563 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp21_ = g_strconcat (_tmp20_, " type=bool", NULL);
#line 563 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 563 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp21_;
#line 564 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6682 "scanner.c"
		}
#line 560 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_TYPE_INT:
#line 6686 "scanner.c"
		{
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
#line 566 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp22_ = s;
#line 566 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp23_ = g_strconcat (_tmp22_, " type=int", NULL);
#line 566 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 566 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp23_;
#line 567 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6700 "scanner.c"
		}
#line 560 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_TYPE_FIXED:
#line 6704 "scanner.c"
		{
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
#line 569 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp24_ = s;
#line 569 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp25_ = g_strconcat (_tmp24_, " type=fixed", NULL);
#line 569 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 569 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp25_;
#line 570 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6718 "scanner.c"
		}
#line 560 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_TYPE_STRING:
#line 6722 "scanner.c"
		{
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
#line 572 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp26_ = s;
#line 572 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp27_ = g_strconcat (_tmp26_, " type=string", NULL);
#line 572 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 572 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp27_;
#line 573 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6736 "scanner.c"
		}
#line 560 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_TYPE_BUTTON:
#line 6740 "scanner.c"
		{
			const gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
#line 575 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp28_ = s;
#line 575 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp29_ = g_strconcat (_tmp28_, " type=button", NULL);
#line 575 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 575 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp29_;
#line 576 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6754 "scanner.c"
		}
#line 560 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_TYPE_GROUP:
#line 6758 "scanner.c"
		{
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
#line 578 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp30_ = s;
#line 578 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp31_ = g_strconcat (_tmp30_, " type=group", NULL);
#line 578 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 578 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp31_;
#line 579 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6772 "scanner.c"
		}
		default:
		{
			const gchar* _tmp32_ = NULL;
			SANE_Option_Descriptor* _tmp33_ = NULL;
			SANE_Value_Type _tmp34_ = 0;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
#line 581 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp32_ = s;
#line 581 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp33_ = option;
#line 581 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp34_ = _tmp33_->type;
#line 581 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp35_ = g_strdup_printf (" type=%d", (gint) _tmp34_);
#line 581 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp36_ = _tmp35_;
#line 581 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp37_ = g_strconcat (_tmp32_, _tmp36_, NULL);
#line 581 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 581 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp37_;
#line 581 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (_tmp36_);
#line 582 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6802 "scanner.c"
		}
	}
#line 585 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp38_ = s;
#line 585 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp39_ = option;
#line 585 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp40_ = _tmp39_->size;
#line 585 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp41_ = g_strdup_printf (" size=%d", (gint) _tmp40_);
#line 585 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp42_ = _tmp41_;
#line 585 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp43_ = g_strconcat (_tmp38_, _tmp42_, NULL);
#line 585 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (s);
#line 585 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	s = _tmp43_;
#line 585 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp42_);
#line 587 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp44_ = option;
#line 587 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp45_ = _tmp44_->unit;
#line 587 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	switch (_tmp45_) {
#line 587 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_UNIT_NONE:
#line 6831 "scanner.c"
		{
#line 590 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6835 "scanner.c"
		}
#line 587 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_UNIT_PIXEL:
#line 6839 "scanner.c"
		{
			const gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
#line 592 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp46_ = s;
#line 592 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp47_ = g_strconcat (_tmp46_, " unit=pixels", NULL);
#line 592 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 592 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp47_;
#line 593 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6853 "scanner.c"
		}
#line 587 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_UNIT_BIT:
#line 6857 "scanner.c"
		{
			const gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
#line 595 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp48_ = s;
#line 595 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp49_ = g_strconcat (_tmp48_, " unit=bits", NULL);
#line 595 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 595 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp49_;
#line 596 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6871 "scanner.c"
		}
#line 587 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_UNIT_MM:
#line 6875 "scanner.c"
		{
			const gchar* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp50_ = s;
#line 598 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp51_ = g_strconcat (_tmp50_, " unit=mm", NULL);
#line 598 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 598 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp51_;
#line 599 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6889 "scanner.c"
		}
#line 587 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_UNIT_DPI:
#line 6893 "scanner.c"
		{
			const gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
#line 601 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp52_ = s;
#line 601 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp53_ = g_strconcat (_tmp52_, " unit=dpi", NULL);
#line 601 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 601 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp53_;
#line 602 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6907 "scanner.c"
		}
#line 587 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_UNIT_PERCENT:
#line 6911 "scanner.c"
		{
			const gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
#line 604 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp54_ = s;
#line 604 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp55_ = g_strconcat (_tmp54_, " unit=percent", NULL);
#line 604 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 604 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp55_;
#line 605 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6925 "scanner.c"
		}
#line 587 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_UNIT_MICROSECOND:
#line 6929 "scanner.c"
		{
			const gchar* _tmp56_ = NULL;
			gchar* _tmp57_ = NULL;
#line 607 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp56_ = s;
#line 607 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp57_ = g_strconcat (_tmp56_, " unit=microseconds", NULL);
#line 607 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 607 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp57_;
#line 608 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6943 "scanner.c"
		}
		default:
		{
			const gchar* _tmp58_ = NULL;
			SANE_Option_Descriptor* _tmp59_ = NULL;
			SANE_Unit _tmp60_ = 0;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			gchar* _tmp63_ = NULL;
#line 610 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp58_ = s;
#line 610 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp59_ = option;
#line 610 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp60_ = _tmp59_->unit;
#line 610 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp61_ = g_strdup_printf (" unit=%d", (gint) _tmp60_);
#line 610 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp62_ = _tmp61_;
#line 610 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp63_ = g_strconcat (_tmp58_, _tmp62_, NULL);
#line 610 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 610 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp63_;
#line 610 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (_tmp62_);
#line 611 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 6973 "scanner.c"
		}
	}
#line 614 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp64_ = option;
#line 614 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp65_ = _tmp64_->constraint_type;
#line 614 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	switch (_tmp65_) {
#line 614 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_CONSTRAINT_RANGE:
#line 6984 "scanner.c"
		{
			SANE_Option_Descriptor* _tmp66_ = NULL;
			SANE_Value_Type _tmp67_ = 0;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp66_ = option;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp67_ = _tmp66_->type;
#line 617 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (_tmp67_ == SANE_TYPE_FIXED) {
#line 6994 "scanner.c"
				const gchar* _tmp68_ = NULL;
				SANE_Option_Descriptor* _tmp69_ = NULL;
				SANE_Range* _tmp70_ = NULL;
				SANE_Word _tmp71_ = {0};
				gdouble _tmp72_ = 0.0;
				SANE_Option_Descriptor* _tmp73_ = NULL;
				SANE_Range* _tmp74_ = NULL;
				SANE_Word _tmp75_ = {0};
				gdouble _tmp76_ = 0.0;
				SANE_Option_Descriptor* _tmp77_ = NULL;
				SANE_Range* _tmp78_ = NULL;
				SANE_Word _tmp79_ = {0};
				gchar* _tmp80_ = NULL;
				gchar* _tmp81_ = NULL;
				gchar* _tmp82_ = NULL;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp68_ = s;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp69_ = option;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp70_ = _tmp69_->constraint.range;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp71_ = _tmp70_->min;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp72_ = SANE_UNFIX ((SANE_Fixed) _tmp71_);
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp73_ = option;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp74_ = _tmp73_->constraint.range;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp75_ = _tmp74_->max;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp76_ = SANE_UNFIX ((SANE_Fixed) _tmp75_);
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp77_ = option;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp78_ = _tmp77_->constraint.range;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp79_ = _tmp78_->quant;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp80_ = g_strdup_printf (" min=%f, max=%f, quant=%d", _tmp72_, _tmp76_, (gint) _tmp79_);
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp81_ = _tmp80_;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp82_ = g_strconcat (_tmp68_, _tmp81_, NULL);
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (s);
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				s = _tmp82_;
#line 618 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (_tmp81_);
#line 7046 "scanner.c"
			} else {
				const gchar* _tmp83_ = NULL;
				SANE_Option_Descriptor* _tmp84_ = NULL;
				SANE_Range* _tmp85_ = NULL;
				SANE_Word _tmp86_ = {0};
				SANE_Option_Descriptor* _tmp87_ = NULL;
				SANE_Range* _tmp88_ = NULL;
				SANE_Word _tmp89_ = {0};
				SANE_Option_Descriptor* _tmp90_ = NULL;
				SANE_Range* _tmp91_ = NULL;
				SANE_Word _tmp92_ = {0};
				gchar* _tmp93_ = NULL;
				gchar* _tmp94_ = NULL;
				gchar* _tmp95_ = NULL;
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp83_ = s;
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp84_ = option;
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp85_ = _tmp84_->constraint.range;
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp86_ = _tmp85_->min;
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp87_ = option;
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp88_ = _tmp87_->constraint.range;
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp89_ = _tmp88_->max;
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp90_ = option;
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp91_ = _tmp90_->constraint.range;
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp92_ = _tmp91_->quant;
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp93_ = g_strdup_printf (" min=%d, max=%d, quant=%d", (gint) _tmp86_, (gint) _tmp89_, (gint) _tmp92_);
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp94_ = _tmp93_;
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp95_ = g_strconcat (_tmp83_, _tmp94_, NULL);
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (s);
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				s = _tmp95_;
#line 620 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (_tmp94_);
#line 7093 "scanner.c"
			}
#line 621 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 7097 "scanner.c"
		}
#line 614 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_CONSTRAINT_WORD_LIST:
#line 7101 "scanner.c"
		{
			const gchar* _tmp96_ = NULL;
			gchar* _tmp97_ = NULL;
			const gchar* _tmp126_ = NULL;
			gchar* _tmp127_ = NULL;
#line 623 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp96_ = s;
#line 623 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp97_ = g_strconcat (_tmp96_, " values=[", NULL);
#line 623 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 623 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp97_;
#line 7115 "scanner.c"
			{
				gint i = 0;
#line 624 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				i = 0;
#line 7120 "scanner.c"
				{
					gboolean _tmp98_ = FALSE;
#line 624 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp98_ = TRUE;
#line 624 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					while (TRUE) {
#line 7127 "scanner.c"
						gint _tmp100_ = 0;
						SANE_Option_Descriptor* _tmp101_ = NULL;
						SANE_Word* _tmp102_ = NULL;
						gint _tmp102__length1 = 0;
						SANE_Word _tmp103_ = {0};
						gint _tmp104_ = 0;
						SANE_Option_Descriptor* _tmp107_ = NULL;
						SANE_Value_Type _tmp108_ = 0;
#line 624 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!_tmp98_) {
#line 7138 "scanner.c"
							gint _tmp99_ = 0;
#line 624 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp99_ = i;
#line 624 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							i = _tmp99_ + 1;
#line 7144 "scanner.c"
						}
#line 624 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp98_ = FALSE;
#line 624 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp100_ = i;
#line 624 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp101_ = option;
#line 624 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp102_ = _tmp101_->constraint.word_list;
#line 624 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp102__length1 = -1;
#line 624 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp103_ = _tmp102_[0];
#line 624 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!(((SANE_Word) _tmp100_) < _tmp103_)) {
#line 624 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							break;
#line 7162 "scanner.c"
						}
#line 626 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp104_ = i;
#line 626 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (_tmp104_ != 0) {
#line 7168 "scanner.c"
							const gchar* _tmp105_ = NULL;
							gchar* _tmp106_ = NULL;
#line 627 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp105_ = s;
#line 627 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp106_ = g_strconcat (_tmp105_, ", ", NULL);
#line 627 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_g_free0 (s);
#line 627 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							s = _tmp106_;
#line 7179 "scanner.c"
						}
#line 628 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp107_ = option;
#line 628 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp108_ = _tmp107_->type;
#line 628 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (_tmp108_ == SANE_TYPE_INT) {
#line 7187 "scanner.c"
							const gchar* _tmp109_ = NULL;
							SANE_Option_Descriptor* _tmp110_ = NULL;
							SANE_Word* _tmp111_ = NULL;
							gint _tmp111__length1 = 0;
							gint _tmp112_ = 0;
							SANE_Word _tmp113_ = {0};
							gchar* _tmp114_ = NULL;
							gchar* _tmp115_ = NULL;
							gchar* _tmp116_ = NULL;
#line 629 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp109_ = s;
#line 629 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp110_ = option;
#line 629 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp111_ = _tmp110_->constraint.word_list;
#line 629 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp111__length1 = -1;
#line 629 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp112_ = i;
#line 629 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp113_ = _tmp111_[_tmp112_ + 1];
#line 629 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp114_ = g_strdup_printf ("%d", (gint) _tmp113_);
#line 629 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp115_ = _tmp114_;
#line 629 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp116_ = g_strconcat (_tmp109_, _tmp115_, NULL);
#line 629 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_g_free0 (s);
#line 629 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							s = _tmp116_;
#line 629 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_g_free0 (_tmp115_);
#line 7221 "scanner.c"
						} else {
							const gchar* _tmp117_ = NULL;
							SANE_Option_Descriptor* _tmp118_ = NULL;
							SANE_Word* _tmp119_ = NULL;
							gint _tmp119__length1 = 0;
							gint _tmp120_ = 0;
							SANE_Word _tmp121_ = {0};
							gdouble _tmp122_ = 0.0;
							gchar* _tmp123_ = NULL;
							gchar* _tmp124_ = NULL;
							gchar* _tmp125_ = NULL;
#line 631 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp117_ = s;
#line 631 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp118_ = option;
#line 631 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp119_ = _tmp118_->constraint.word_list;
#line 631 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp119__length1 = -1;
#line 631 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp120_ = i;
#line 631 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp121_ = _tmp119_[_tmp120_ + 1];
#line 631 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp122_ = SANE_UNFIX ((SANE_Fixed) _tmp121_);
#line 631 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp123_ = g_strdup_printf ("%f", _tmp122_);
#line 631 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp124_ = _tmp123_;
#line 631 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp125_ = g_strconcat (_tmp117_, _tmp124_, NULL);
#line 631 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_g_free0 (s);
#line 631 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							s = _tmp125_;
#line 631 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_g_free0 (_tmp124_);
#line 7259 "scanner.c"
						}
					}
				}
			}
#line 633 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp126_ = s;
#line 633 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp127_ = g_strconcat (_tmp126_, "]", NULL);
#line 633 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 633 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp127_;
#line 634 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 7274 "scanner.c"
		}
#line 614 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SANE_CONSTRAINT_STRING_LIST:
#line 7278 "scanner.c"
		{
			const gchar* _tmp128_ = NULL;
			gchar* _tmp129_ = NULL;
			const gchar* _tmp147_ = NULL;
			gchar* _tmp148_ = NULL;
#line 636 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp128_ = s;
#line 636 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp129_ = g_strconcat (_tmp128_, " values=[", NULL);
#line 636 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 636 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp129_;
#line 7292 "scanner.c"
			{
				gint i = 0;
#line 637 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				i = 0;
#line 7297 "scanner.c"
				{
					gboolean _tmp130_ = FALSE;
#line 637 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp130_ = TRUE;
#line 637 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					while (TRUE) {
#line 7304 "scanner.c"
						SANE_Option_Descriptor* _tmp132_ = NULL;
						gchar** _tmp133_ = NULL;
						gint _tmp133__length1 = 0;
						gint _tmp134_ = 0;
						const gchar* _tmp135_ = NULL;
						gint _tmp136_ = 0;
						const gchar* _tmp139_ = NULL;
						SANE_Option_Descriptor* _tmp140_ = NULL;
						gchar** _tmp141_ = NULL;
						gint _tmp141__length1 = 0;
						gint _tmp142_ = 0;
						const gchar* _tmp143_ = NULL;
						gchar* _tmp144_ = NULL;
						gchar* _tmp145_ = NULL;
						gchar* _tmp146_ = NULL;
#line 637 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!_tmp130_) {
#line 7322 "scanner.c"
							gint _tmp131_ = 0;
#line 637 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp131_ = i;
#line 637 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							i = _tmp131_ + 1;
#line 7328 "scanner.c"
						}
#line 637 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp130_ = FALSE;
#line 637 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp132_ = option;
#line 637 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp133_ = _tmp132_->constraint.string_list;
#line 637 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp133__length1 = -1;
#line 637 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp134_ = i;
#line 637 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp135_ = _tmp133_[_tmp134_];
#line 637 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!(_tmp135_ != NULL)) {
#line 637 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							break;
#line 7346 "scanner.c"
						}
#line 639 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp136_ = i;
#line 639 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (_tmp136_ != 0) {
#line 7352 "scanner.c"
							const gchar* _tmp137_ = NULL;
							gchar* _tmp138_ = NULL;
#line 640 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp137_ = s;
#line 640 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp138_ = g_strconcat (_tmp137_, ", ", NULL);
#line 640 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_g_free0 (s);
#line 640 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							s = _tmp138_;
#line 7363 "scanner.c"
						}
#line 641 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp139_ = s;
#line 641 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp140_ = option;
#line 641 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp141_ = _tmp140_->constraint.string_list;
#line 641 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp141__length1 = -1;
#line 641 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp142_ = i;
#line 641 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp143_ = _tmp141_[_tmp142_];
#line 641 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp144_ = g_strdup_printf ("\"%s\"", _tmp143_);
#line 641 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp145_ = _tmp144_;
#line 641 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp146_ = g_strconcat (_tmp139_, _tmp145_, NULL);
#line 641 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_g_free0 (s);
#line 641 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						s = _tmp146_;
#line 641 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_g_free0 (_tmp145_);
#line 7389 "scanner.c"
					}
				}
			}
#line 643 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp147_ = s;
#line 643 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp148_ = g_strconcat (_tmp147_, "]", NULL);
#line 643 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 643 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp148_;
#line 644 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 7403 "scanner.c"
		}
		default:
		{
#line 646 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 7409 "scanner.c"
		}
	}
#line 649 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp149_ = option;
#line 649 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp150_ = _tmp149_->cap;
#line 649 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	cap = _tmp150_;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp151_ = cap;
#line 650 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp151_ != ((SANE_Int) 0)) {
#line 7422 "scanner.c"
		const gchar* _tmp152_ = NULL;
		gchar* _tmp153_ = NULL;
		SANE_Int _tmp154_ = {0};
		SANE_Int _tmp161_ = {0};
		SANE_Int _tmp168_ = {0};
		SANE_Int _tmp175_ = {0};
		SANE_Int _tmp182_ = {0};
		SANE_Int _tmp189_ = {0};
		SANE_Int _tmp196_ = {0};
		SANE_Int _tmp203_ = {0};
#line 652 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp152_ = s;
#line 652 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp153_ = g_strconcat (_tmp152_, " cap=", NULL);
#line 652 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_free0 (s);
#line 652 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		s = _tmp153_;
#line 653 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp154_ = cap;
#line 653 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if ((_tmp154_ & SANE_CAP_SOFT_SELECT) != ((SANE_Int) 0)) {
#line 7445 "scanner.c"
			const gchar* _tmp155_ = NULL;
			const gchar* _tmp158_ = NULL;
			gchar* _tmp159_ = NULL;
			SANE_Int _tmp160_ = {0};
#line 655 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp155_ = s;
#line 655 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (g_strcmp0 (_tmp155_, "") != 0) {
#line 7454 "scanner.c"
				const gchar* _tmp156_ = NULL;
				gchar* _tmp157_ = NULL;
#line 656 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp156_ = s;
#line 656 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp157_ = g_strconcat (_tmp156_, ",", NULL);
#line 656 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (s);
#line 656 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				s = _tmp157_;
#line 7465 "scanner.c"
			}
#line 657 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp158_ = s;
#line 657 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp159_ = g_strconcat (_tmp158_, "soft-select", NULL);
#line 657 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 657 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp159_;
#line 658 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp160_ = cap;
#line 658 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			cap = _tmp160_ & (~SANE_CAP_SOFT_SELECT);
#line 7479 "scanner.c"
		}
#line 660 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp161_ = cap;
#line 660 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if ((_tmp161_ & SANE_CAP_HARD_SELECT) != ((SANE_Int) 0)) {
#line 7485 "scanner.c"
			const gchar* _tmp162_ = NULL;
			const gchar* _tmp165_ = NULL;
			gchar* _tmp166_ = NULL;
			SANE_Int _tmp167_ = {0};
#line 662 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp162_ = s;
#line 662 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (g_strcmp0 (_tmp162_, "") != 0) {
#line 7494 "scanner.c"
				const gchar* _tmp163_ = NULL;
				gchar* _tmp164_ = NULL;
#line 663 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp163_ = s;
#line 663 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp164_ = g_strconcat (_tmp163_, ",", NULL);
#line 663 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (s);
#line 663 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				s = _tmp164_;
#line 7505 "scanner.c"
			}
#line 664 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp165_ = s;
#line 664 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp166_ = g_strconcat (_tmp165_, "hard-select", NULL);
#line 664 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 664 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp166_;
#line 665 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp167_ = cap;
#line 665 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			cap = _tmp167_ & (~SANE_CAP_HARD_SELECT);
#line 7519 "scanner.c"
		}
#line 667 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp168_ = cap;
#line 667 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if ((_tmp168_ & SANE_CAP_SOFT_DETECT) != ((SANE_Int) 0)) {
#line 7525 "scanner.c"
			const gchar* _tmp169_ = NULL;
			const gchar* _tmp172_ = NULL;
			gchar* _tmp173_ = NULL;
			SANE_Int _tmp174_ = {0};
#line 669 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp169_ = s;
#line 669 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (g_strcmp0 (_tmp169_, "") != 0) {
#line 7534 "scanner.c"
				const gchar* _tmp170_ = NULL;
				gchar* _tmp171_ = NULL;
#line 670 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp170_ = s;
#line 670 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp171_ = g_strconcat (_tmp170_, ",", NULL);
#line 670 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (s);
#line 670 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				s = _tmp171_;
#line 7545 "scanner.c"
			}
#line 671 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp172_ = s;
#line 671 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp173_ = g_strconcat (_tmp172_, "soft-detect", NULL);
#line 671 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 671 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp173_;
#line 672 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp174_ = cap;
#line 672 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			cap = _tmp174_ & (~SANE_CAP_SOFT_DETECT);
#line 7559 "scanner.c"
		}
#line 674 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp175_ = cap;
#line 674 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if ((_tmp175_ & SANE_CAP_EMULATED) != ((SANE_Int) 0)) {
#line 7565 "scanner.c"
			const gchar* _tmp176_ = NULL;
			const gchar* _tmp179_ = NULL;
			gchar* _tmp180_ = NULL;
			SANE_Int _tmp181_ = {0};
#line 676 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp176_ = s;
#line 676 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (g_strcmp0 (_tmp176_, "") != 0) {
#line 7574 "scanner.c"
				const gchar* _tmp177_ = NULL;
				gchar* _tmp178_ = NULL;
#line 677 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp177_ = s;
#line 677 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp178_ = g_strconcat (_tmp177_, ",", NULL);
#line 677 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (s);
#line 677 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				s = _tmp178_;
#line 7585 "scanner.c"
			}
#line 678 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp179_ = s;
#line 678 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp180_ = g_strconcat (_tmp179_, "emulated", NULL);
#line 678 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 678 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp180_;
#line 679 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp181_ = cap;
#line 679 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			cap = _tmp181_ & (~SANE_CAP_EMULATED);
#line 7599 "scanner.c"
		}
#line 681 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp182_ = cap;
#line 681 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if ((_tmp182_ & SANE_CAP_AUTOMATIC) != ((SANE_Int) 0)) {
#line 7605 "scanner.c"
			const gchar* _tmp183_ = NULL;
			const gchar* _tmp186_ = NULL;
			gchar* _tmp187_ = NULL;
			SANE_Int _tmp188_ = {0};
#line 683 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp183_ = s;
#line 683 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (g_strcmp0 (_tmp183_, "") != 0) {
#line 7614 "scanner.c"
				const gchar* _tmp184_ = NULL;
				gchar* _tmp185_ = NULL;
#line 684 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp184_ = s;
#line 684 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp185_ = g_strconcat (_tmp184_, ",", NULL);
#line 684 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (s);
#line 684 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				s = _tmp185_;
#line 7625 "scanner.c"
			}
#line 685 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp186_ = s;
#line 685 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp187_ = g_strconcat (_tmp186_, "automatic", NULL);
#line 685 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 685 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp187_;
#line 686 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp188_ = cap;
#line 686 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			cap = _tmp188_ & (~SANE_CAP_AUTOMATIC);
#line 7639 "scanner.c"
		}
#line 688 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp189_ = cap;
#line 688 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if ((_tmp189_ & SANE_CAP_INACTIVE) != ((SANE_Int) 0)) {
#line 7645 "scanner.c"
			const gchar* _tmp190_ = NULL;
			const gchar* _tmp193_ = NULL;
			gchar* _tmp194_ = NULL;
			SANE_Int _tmp195_ = {0};
#line 690 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp190_ = s;
#line 690 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (g_strcmp0 (_tmp190_, "") != 0) {
#line 7654 "scanner.c"
				const gchar* _tmp191_ = NULL;
				gchar* _tmp192_ = NULL;
#line 691 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp191_ = s;
#line 691 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp192_ = g_strconcat (_tmp191_, ",", NULL);
#line 691 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (s);
#line 691 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				s = _tmp192_;
#line 7665 "scanner.c"
			}
#line 692 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp193_ = s;
#line 692 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp194_ = g_strconcat (_tmp193_, "inactive", NULL);
#line 692 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 692 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp194_;
#line 693 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp195_ = cap;
#line 693 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			cap = _tmp195_ & (~SANE_CAP_INACTIVE);
#line 7679 "scanner.c"
		}
#line 695 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp196_ = cap;
#line 695 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if ((_tmp196_ & SANE_CAP_ADVANCED) != ((SANE_Int) 0)) {
#line 7685 "scanner.c"
			const gchar* _tmp197_ = NULL;
			const gchar* _tmp200_ = NULL;
			gchar* _tmp201_ = NULL;
			SANE_Int _tmp202_ = {0};
#line 697 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp197_ = s;
#line 697 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (g_strcmp0 (_tmp197_, "") != 0) {
#line 7694 "scanner.c"
				const gchar* _tmp198_ = NULL;
				gchar* _tmp199_ = NULL;
#line 698 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp198_ = s;
#line 698 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp199_ = g_strconcat (_tmp198_, ",", NULL);
#line 698 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (s);
#line 698 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				s = _tmp199_;
#line 7705 "scanner.c"
			}
#line 699 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp200_ = s;
#line 699 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp201_ = g_strconcat (_tmp200_, "advanced", NULL);
#line 699 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 699 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp201_;
#line 700 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp202_ = cap;
#line 700 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			cap = _tmp202_ & (~SANE_CAP_ADVANCED);
#line 7719 "scanner.c"
		}
#line 703 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp203_ = cap;
#line 703 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp203_ != ((SANE_Int) 0)) {
#line 7725 "scanner.c"
			const gchar* _tmp204_ = NULL;
			const gchar* _tmp207_ = NULL;
			SANE_Int _tmp208_ = {0};
			gchar* _tmp209_ = NULL;
			gchar* _tmp210_ = NULL;
			gchar* _tmp211_ = NULL;
#line 705 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp204_ = s;
#line 705 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (g_strcmp0 (_tmp204_, "") != 0) {
#line 7736 "scanner.c"
				const gchar* _tmp205_ = NULL;
				gchar* _tmp206_ = NULL;
#line 706 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp205_ = s;
#line 706 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp206_ = g_strconcat (_tmp205_, ",", NULL);
#line 706 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_g_free0 (s);
#line 706 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				s = _tmp206_;
#line 7747 "scanner.c"
			}
#line 707 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp207_ = s;
#line 707 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp208_ = cap;
#line 707 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp209_ = g_strdup_printf ("%x", (guint) ((gint) _tmp208_));
#line 707 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp210_ = _tmp209_;
#line 707 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp211_ = g_strconcat (_tmp207_, _tmp210_, NULL);
#line 707 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (s);
#line 707 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			s = _tmp211_;
#line 707 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_g_free0 (_tmp210_);
#line 7765 "scanner.c"
		}
	}
#line 711 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp212_ = s;
#line 711 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:711: %s", _tmp212_);
#line 713 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp213_ = option;
#line 713 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp214_ = _tmp213_->desc;
#line 713 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp214_ != NULL) {
#line 7778 "scanner.c"
		SANE_Option_Descriptor* _tmp215_ = NULL;
		const gchar* _tmp216_ = NULL;
#line 714 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp215_ = option;
#line 714 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp216_ = _tmp215_->desc;
#line 714 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_debug ("scanner.vala:714:   Description: %s", _tmp216_);
#line 7787 "scanner.c"
	}
#line 550 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (s);
#line 7791 "scanner.c"
}


static void scanner_authorization_cb (const gchar* resource, gchar* username, int username_length1, gchar* password, int password_length1) {
	Scanner* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	NotifyRequestAuthorization* _tmp2_ = NULL;
	NotifyRequestAuthorization* _tmp3_ = NULL;
	Credentials* credentials = NULL;
	Scanner* _tmp4_ = NULL;
	GAsyncQueue* _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
#line 717 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (resource != NULL);
#line 719 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = scanner_scanner_object;
#line 719 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = resource;
#line 719 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = notify_request_authorization_new (_tmp1_);
#line 719 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = _tmp2_;
#line 719 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_notify (_tmp0_, (Notify*) _tmp3_);
#line 719 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_notify_unref0 (_tmp3_);
#line 721 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = scanner_scanner_object;
#line 721 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = _tmp4_->priv->authorize_queue;
#line 721 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp6_ = g_async_queue_pop (_tmp5_);
#line 721 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	credentials = (Credentials*) _tmp6_;
#line 7826 "scanner.c"
	{
		gint i = 0;
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		i = 0;
#line 7831 "scanner.c"
		{
			gboolean _tmp7_ = FALSE;
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp7_ = TRUE;
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			while (TRUE) {
#line 7838 "scanner.c"
				gboolean _tmp9_ = FALSE;
				Credentials* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gchar _tmp13_ = '\0';
				gchar* _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gint _tmp17_ = 0;
				Credentials* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gchar _tmp21_ = '\0';
				gchar _tmp22_ = '\0';
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (!_tmp7_) {
#line 7854 "scanner.c"
					gint _tmp8_ = 0;
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp8_ = i;
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					i = _tmp8_ + 1;
#line 7860 "scanner.c"
				}
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp7_ = FALSE;
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp10_ = credentials;
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp11_ = _tmp10_->username;
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp12_ = i;
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp13_ = string_get (_tmp11_, (glong) _tmp12_);
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (_tmp13_ != '\0') {
#line 7874 "scanner.c"
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp14_ = i;
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp15_ = SANE_MAX_USERNAME_LEN;
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp9_ = _tmp14_ < _tmp15_;
#line 7883 "scanner.c"
				} else {
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp9_ = FALSE;
#line 7887 "scanner.c"
				}
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (!_tmp9_) {
#line 722 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					break;
#line 7893 "scanner.c"
				}
#line 723 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp16_ = username;
#line 723 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp16__length1 = username_length1;
#line 723 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp17_ = i;
#line 723 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp18_ = credentials;
#line 723 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp19_ = _tmp18_->username;
#line 723 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp20_ = i;
#line 723 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp21_ = string_get (_tmp19_, (glong) _tmp20_);
#line 723 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp16_[_tmp17_] = _tmp21_;
#line 723 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp22_ = _tmp16_[_tmp17_];
#line 7913 "scanner.c"
			}
		}
	}
	{
		gint i = 0;
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		i = 0;
#line 7921 "scanner.c"
		{
			gboolean _tmp23_ = FALSE;
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp23_ = TRUE;
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			while (TRUE) {
#line 7928 "scanner.c"
				gboolean _tmp25_ = FALSE;
				Credentials* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				gchar _tmp29_ = '\0';
				gchar* _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gint _tmp33_ = 0;
				Credentials* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gchar _tmp37_ = '\0';
				gchar _tmp38_ = '\0';
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (!_tmp23_) {
#line 7944 "scanner.c"
					gint _tmp24_ = 0;
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp24_ = i;
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					i = _tmp24_ + 1;
#line 7950 "scanner.c"
				}
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp23_ = FALSE;
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp26_ = credentials;
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp27_ = _tmp26_->password;
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp28_ = i;
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp29_ = string_get (_tmp27_, (glong) _tmp28_);
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (_tmp29_ != '\0') {
#line 7964 "scanner.c"
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp30_ = i;
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp31_ = SANE_MAX_USERNAME_LEN;
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp25_ = _tmp30_ < _tmp31_;
#line 7973 "scanner.c"
				} else {
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp25_ = FALSE;
#line 7977 "scanner.c"
				}
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (!_tmp25_) {
#line 724 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					break;
#line 7983 "scanner.c"
				}
#line 725 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp32_ = password;
#line 725 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp32__length1 = password_length1;
#line 725 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp33_ = i;
#line 725 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp34_ = credentials;
#line 725 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp35_ = _tmp34_->password;
#line 725 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp36_ = i;
#line 725 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp37_ = string_get (_tmp35_, (glong) _tmp36_);
#line 725 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp32_[_tmp33_] = _tmp37_;
#line 725 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp38_ = _tmp32_[_tmp33_];
#line 8003 "scanner.c"
			}
		}
	}
#line 717 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_credentials_unref0 (credentials);
#line 8009 "scanner.c"
}


static gpointer _credentials_ref0 (gpointer self) {
#line 733 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self ? credentials_ref (self) : NULL;
#line 8016 "scanner.c"
}


void scanner_authorize (Scanner* self, const gchar* username, const gchar* password) {
	Credentials* credentials = NULL;
	Credentials* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GAsyncQueue* _tmp5_ = NULL;
	Credentials* _tmp6_ = NULL;
#line 728 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 728 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (username != NULL);
#line 728 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (password != NULL);
#line 730 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = credentials_new ();
#line 730 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	credentials = _tmp0_;
#line 731 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = username;
#line 731 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 731 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (credentials->username);
#line 731 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	credentials->username = _tmp2_;
#line 732 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = password;
#line 732 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 732 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (credentials->password);
#line 732 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	credentials->password = _tmp4_;
#line 733 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = self->priv->authorize_queue;
#line 733 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp6_ = _credentials_ref0 (credentials);
#line 733 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_async_queue_push (_tmp5_, _tmp6_);
#line 728 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_credentials_unref0 (credentials);
#line 8063 "scanner.c"
}


static void scanner_close_device (Scanner* self) {
	gboolean _tmp0_ = FALSE;
#line 736 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 738 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = self->priv->have_handle;
#line 738 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp0_) {
#line 8075 "scanner.c"
		SANE_Handle _tmp1_ = {0};
		SANE_Handle _tmp2_ = {0};
#line 740 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp1_ = self->priv->handle;
#line 740 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		sane_cancel (_tmp1_);
#line 741 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_debug ("scanner.vala:741: sane_cancel ()");
#line 743 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp2_ = self->priv->handle;
#line 743 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		sane_close (_tmp2_);
#line 744 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_debug ("scanner.vala:744: sane_close ()");
#line 745 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->have_handle = FALSE;
#line 746 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_hash_table_unref0 (self->priv->options);
#line 746 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->options = NULL;
#line 8096 "scanner.c"
	}
#line 749 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 749 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->buffer = NULL;
#line 749 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->buffer_length1 = 0;
#line 749 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 750 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	__g_list_free__scan_job_unref0_0 (self->priv->job_queue);
#line 750 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->job_queue = NULL;
#line 752 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_set_scanning (self, FALSE);
#line 8112 "scanner.c"
}


static void scanner_fail_scan (Scanner* self, gint error_code, const gchar* error_string) {
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	NotifyScanFailed* _tmp2_ = NULL;
	NotifyScanFailed* _tmp3_ = NULL;
#line 755 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 755 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (error_string != NULL);
#line 757 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_close_device (self);
#line 758 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 759 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = error_code;
#line 759 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = error_string;
#line 759 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = notify_scan_failed_new (_tmp0_, _tmp1_);
#line 759 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = _tmp2_;
#line 759 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp3_);
#line 759 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_notify_unref0 (_tmp3_);
#line 8141 "scanner.c"
}


static gpointer _request_ref0 (gpointer self) {
#line 784 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self ? request_ref (self) : NULL;
#line 8148 "scanner.c"
}


static gpointer _scan_job_ref0 (gpointer self) {
#line 785 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self ? scan_job_ref (self) : NULL;
#line 8155 "scanner.c"
}


static gboolean scanner_handle_requests (Scanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ScanState _tmp1_ = 0;
	gint request_count = 0;
#line 762 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 765 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = self->priv->state;
#line 765 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp1_ == SCAN_STATE_IDLE) {
#line 8170 "scanner.c"
		gboolean _tmp2_ = FALSE;
#line 765 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp2_ = self->priv->need_redetect;
#line 765 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp0_ = _tmp2_;
#line 8176 "scanner.c"
	} else {
#line 765 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp0_ = FALSE;
#line 8180 "scanner.c"
	}
#line 765 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp0_) {
#line 766 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->state = SCAN_STATE_REDETECT;
#line 8186 "scanner.c"
	}
#line 769 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	request_count = 0;
#line 770 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	while (TRUE) {
#line 8192 "scanner.c"
		Request* request = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		ScanState _tmp5_ = 0;
		gint _tmp11_ = 0;
		Request* _tmp12_ = NULL;
#line 773 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp5_ = self->priv->state;
#line 773 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp5_ == SCAN_STATE_IDLE) {
#line 8203 "scanner.c"
			gint _tmp6_ = 0;
#line 773 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp6_ = request_count;
#line 773 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp4_ = _tmp6_ == 0;
#line 8209 "scanner.c"
		} else {
#line 773 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp4_ = FALSE;
#line 8213 "scanner.c"
		}
#line 773 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp4_) {
#line 773 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp3_ = TRUE;
#line 8219 "scanner.c"
		} else {
			GAsyncQueue* _tmp7_ = NULL;
			gint _tmp8_ = 0;
#line 774 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp7_ = self->priv->request_queue;
#line 774 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp8_ = g_async_queue_length (_tmp7_);
#line 774 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp3_ = _tmp8_ > 0;
#line 8229 "scanner.c"
		}
#line 773 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp3_) {
#line 8233 "scanner.c"
			GAsyncQueue* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
#line 775 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp9_ = self->priv->request_queue;
#line 775 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp10_ = g_async_queue_pop (_tmp9_);
#line 775 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_request_unref0 (request);
#line 775 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			request = (Request*) _tmp10_;
#line 8244 "scanner.c"
		} else {
#line 777 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			result = TRUE;
#line 777 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_request_unref0 (request);
#line 777 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return result;
#line 8252 "scanner.c"
		}
#line 779 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_debug ("scanner.vala:779: Processing request");
#line 780 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp11_ = request_count;
#line 780 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		request_count = _tmp11_ + 1;
#line 782 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp12_ = request;
#line 782 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, TYPE_REQUEST_START_SCAN)) {
#line 8264 "scanner.c"
			RequestStartScan* r = NULL;
			Request* _tmp13_ = NULL;
			RequestStartScan* _tmp14_ = NULL;
			RequestStartScan* _tmp15_ = NULL;
			ScanJob* _tmp16_ = NULL;
			ScanJob* _tmp17_ = NULL;
#line 784 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp13_ = request;
#line 784 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp14_ = _request_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_REQUEST_START_SCAN, RequestStartScan));
#line 784 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			r = _tmp14_;
#line 785 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp15_ = r;
#line 785 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp16_ = _tmp15_->job;
#line 785 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp17_ = _scan_job_ref0 (_tmp16_);
#line 785 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			self->priv->job_queue = g_list_append (self->priv->job_queue, _tmp17_);
#line 782 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_request_unref0 (r);
#line 8287 "scanner.c"
		} else {
			Request* _tmp18_ = NULL;
#line 787 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp18_ = request;
#line 787 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, TYPE_REQUEST_CANCEL)) {
#line 789 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_fail_scan (self, (gint) SANE_STATUS_CANCELLED, "Scan cancelled - do not report this error");
#line 8296 "scanner.c"
			} else {
				Request* _tmp19_ = NULL;
#line 791 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp19_ = request;
#line 791 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, TYPE_REQUEST_QUIT)) {
#line 793 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					scanner_close_device (self);
#line 794 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					result = FALSE;
#line 794 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_request_unref0 (request);
#line 794 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					return result;
#line 8311 "scanner.c"
				}
			}
		}
#line 770 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_request_unref0 (request);
#line 8317 "scanner.c"
	}
}


static void _g_free0_ (gpointer var) {
#line 838 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	var = (g_free (var), NULL);
#line 8325 "scanner.c"
}


static void scanner_do_open (Scanner* self) {
	ScanJob* job = NULL;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	ScanJob* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	ScanJob* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	ScanJob* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp13_ = FALSE;
	GHashFunc _tmp18_ = NULL;
	GEqualFunc _tmp19_ = NULL;
	GHashTable* _tmp20_ = NULL;
	SANE_Status status = 0;
	ScanJob* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	SANE_Handle _tmp23_ = {0};
	SANE_Status _tmp24_ = 0;
	ScanJob* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	SANE_Status _tmp27_ = 0;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	SANE_Status _tmp30_ = 0;
	ScanJob* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
#line 799 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 801 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 801 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 801 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 801 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	job = _tmp2_;
#line 803 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->line_count = 0;
#line 804 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->pass_number = 0;
#line 805 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->page_number = 0;
#line 806 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->notified_page = -1;
#line 807 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->option_index = (SANE_Int) 0;
#line 809 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = job;
#line 809 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = _tmp4_->device;
#line 809 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp5_ == NULL) {
#line 8383 "scanner.c"
		const gchar* _tmp6_ = NULL;
#line 809 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp6_ = self->priv->default_device;
#line 809 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp3_ = _tmp6_ != NULL;
#line 8389 "scanner.c"
	} else {
#line 809 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp3_ = FALSE;
#line 8393 "scanner.c"
	}
#line 809 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp3_) {
#line 8397 "scanner.c"
		ScanJob* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 810 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_ = job;
#line 810 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp8_ = self->priv->default_device;
#line 810 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 810 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_free0 (_tmp7_->device);
#line 810 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_->device = _tmp9_;
#line 8411 "scanner.c"
	}
#line 812 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp10_ = job;
#line 812 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp11_ = _tmp10_->device;
#line 812 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp11_ == NULL) {
#line 8419 "scanner.c"
		const gchar* _tmp12_ = NULL;
#line 814 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_warning ("scanner.vala:814: No scan device available");
#line 815 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp12_ = _ ("No scanners available.  Please connect a scanner.");
#line 815 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_fail_scan (self, 0, _tmp12_);
#line 818 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_scan_job_unref0 (job);
#line 818 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 8431 "scanner.c"
	}
#line 822 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp13_ = self->priv->have_handle;
#line 822 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp13_) {
#line 8437 "scanner.c"
		const gchar* _tmp14_ = NULL;
		ScanJob* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		SANE_Handle _tmp17_ = {0};
#line 824 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp14_ = self->priv->current_device;
#line 824 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp15_ = job;
#line 824 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp16_ = _tmp15_->device;
#line 824 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (g_strcmp0 (_tmp14_, _tmp16_) == 0) {
#line 826 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			self->priv->state = SCAN_STATE_GET_OPTION;
#line 827 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_scan_job_unref0 (job);
#line 827 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return;
#line 8456 "scanner.c"
		}
#line 830 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp17_ = self->priv->handle;
#line 830 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		sane_close (_tmp17_);
#line 831 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_debug ("scanner.vala:831: sane_close ()");
#line 832 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->have_handle = FALSE;
#line 8466 "scanner.c"
	}
#line 835 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 835 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->current_device = NULL;
#line 837 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->have_handle = FALSE;
#line 838 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp18_ = g_str_hash;
#line 838 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp19_ = g_str_equal;
#line 838 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp20_ = g_hash_table_new_full (_tmp18_, _tmp19_, _g_free0_, NULL);
#line 838 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_hash_table_unref0 (self->priv->options);
#line 838 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->options = _tmp20_;
#line 839 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp21_ = job;
#line 839 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp22_ = _tmp21_->device;
#line 839 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp24_ = sane_open (_tmp22_, &_tmp23_);
#line 839 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->handle = _tmp23_;
#line 839 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	status = _tmp24_;
#line 840 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp25_ = job;
#line 840 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp26_ = _tmp25_->device;
#line 840 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp27_ = status;
#line 840 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp28_ = sane_status_to_string (_tmp27_);
#line 840 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp29_ = _tmp28_;
#line 840 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:840: sane_open (\"%s\") -> %s", _tmp26_, _tmp29_);
#line 840 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp29_);
#line 842 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp30_ = status;
#line 842 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp30_ != SANE_STATUS_GOOD) {
#line 8512 "scanner.c"
		SANE_Status _tmp31_ = 0;
		const gchar* _tmp32_ = NULL;
		SANE_Status _tmp33_ = 0;
		const gchar* _tmp34_ = NULL;
#line 844 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp31_ = status;
#line 844 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp32_ = sane_strstatus (_tmp31_);
#line 844 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_warning ("scanner.vala:844: Unable to get open device: %s", _tmp32_);
#line 845 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp33_ = status;
#line 845 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp34_ = _ ("Unable to connect to scanner");
#line 845 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp33_, _tmp34_);
#line 848 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_scan_job_unref0 (job);
#line 848 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 8533 "scanner.c"
	}
#line 850 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->have_handle = TRUE;
#line 852 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp35_ = job;
#line 852 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp36_ = _tmp35_->device;
#line 852 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp37_ = g_strdup (_tmp36_);
#line 852 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 852 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->current_device = _tmp37_;
#line 853 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->state = SCAN_STATE_GET_OPTION;
#line 799 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_scan_job_unref0 (job);
#line 8551 "scanner.c"
}


static void scanner_do_get_option (Scanner* self) {
	ScanJob* job = NULL;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	ScanJob* _tmp2_ = NULL;
	SANE_Option_Descriptor* option = NULL;
	SANE_Handle _tmp3_ = {0};
	SANE_Int _tmp4_ = {0};
	SANE_Option_Descriptor* _tmp5_ = NULL;
	SANE_Int _tmp6_ = {0};
	SANE_Int index = {0};
	SANE_Int _tmp7_ = {0};
	SANE_Int _tmp8_ = {0};
	SANE_Option_Descriptor* _tmp9_ = NULL;
	SANE_Int _tmp326_ = {0};
	SANE_Option_Descriptor* _tmp327_ = NULL;
	SANE_Option_Descriptor* _tmp328_ = NULL;
	SANE_Value_Type _tmp329_ = 0;
	SANE_Option_Descriptor* _tmp330_ = NULL;
	SANE_Int _tmp331_ = {0};
	SANE_Option_Descriptor* _tmp332_ = NULL;
	const gchar* _tmp333_ = NULL;
	GHashTable* _tmp334_ = NULL;
	SANE_Option_Descriptor* _tmp335_ = NULL;
	const gchar* _tmp336_ = NULL;
	gchar* _tmp337_ = NULL;
	SANE_Int _tmp338_ = {0};
#line 856 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 858 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 858 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 858 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 858 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	job = _tmp2_;
#line 860 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = self->priv->handle;
#line 860 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = self->priv->option_index;
#line 860 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = sane_get_option_descriptor (_tmp3_, _tmp4_);
#line 860 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	option = _tmp5_;
#line 861 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp6_ = self->priv->option_index;
#line 861 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:861: sane_get_option_descriptor (%d)", (gint) _tmp6_);
#line 862 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp7_ = self->priv->option_index;
#line 862 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	index = _tmp7_;
#line 863 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp8_ = self->priv->option_index;
#line 863 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->option_index = _tmp8_ + 1;
#line 866 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp9_ = option;
#line 866 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp9_ == NULL) {
#line 8616 "scanner.c"
		SANE_Handle _tmp10_ = {0};
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		SANE_Option_Descriptor* _tmp13_ = NULL;
		SANE_Option_Descriptor* _tmp14_ = NULL;
		SANE_Option_Descriptor* _tmp18_ = NULL;
		SANE_Handle _tmp96_ = {0};
		const gchar* _tmp97_ = NULL;
		gint _tmp98_ = 0;
		SANE_Option_Descriptor* _tmp99_ = NULL;
		SANE_Option_Descriptor* _tmp100_ = NULL;
		SANE_Handle _tmp156_ = {0};
		gint _tmp157_ = 0;
		SANE_Option_Descriptor* _tmp158_ = NULL;
		SANE_Option_Descriptor* _tmp159_ = NULL;
		SANE_Handle _tmp167_ = {0};
		gint _tmp168_ = 0;
		SANE_Option_Descriptor* _tmp169_ = NULL;
		SANE_Option_Descriptor* _tmp170_ = NULL;
		SANE_Handle _tmp178_ = {0};
		gint _tmp179_ = 0;
		SANE_Option_Descriptor* _tmp180_ = NULL;
		SANE_Option_Descriptor* _tmp181_ = NULL;
		SANE_Handle _tmp194_ = {0};
		const gchar* _tmp195_ = NULL;
		gint _tmp196_ = 0;
		SANE_Option_Descriptor* _tmp197_ = NULL;
		SANE_Option_Descriptor* _tmp198_ = NULL;
		SANE_Handle _tmp218_ = {0};
		const gchar* _tmp219_ = NULL;
		gint _tmp220_ = 0;
		SANE_Option_Descriptor* _tmp221_ = NULL;
		SANE_Option_Descriptor* _tmp222_ = NULL;
		SANE_Handle _tmp237_ = {0};
		const gchar* _tmp238_ = NULL;
		gint _tmp239_ = 0;
		SANE_Option_Descriptor* _tmp240_ = NULL;
		SANE_Option_Descriptor* _tmp241_ = NULL;
		SANE_Handle _tmp256_ = {0};
		const gchar* _tmp257_ = NULL;
		gint _tmp258_ = 0;
		SANE_Option_Descriptor* _tmp259_ = NULL;
		gboolean _tmp260_ = FALSE;
		SANE_Option_Descriptor* _tmp261_ = NULL;
		SANE_Handle _tmp273_ = {0};
		const gchar* _tmp274_ = NULL;
		gint _tmp275_ = 0;
		SANE_Option_Descriptor* _tmp276_ = NULL;
		gboolean _tmp277_ = FALSE;
		SANE_Option_Descriptor* _tmp278_ = NULL;
		const gchar* _tmp290_ = NULL;
#line 869 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp10_ = self->priv->handle;
#line 869 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp11_ = SANE_NAME_SCAN_SOURCE;
#line 869 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp13_ = scanner_get_option_by_name (self, _tmp10_, _tmp11_, &_tmp12_);
#line 869 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		index = (SANE_Int) _tmp12_;
#line 869 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		option = _tmp13_;
#line 870 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp14_ = option;
#line 870 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp14_ == NULL) {
#line 8682 "scanner.c"
			SANE_Handle _tmp15_ = {0};
			gint _tmp16_ = 0;
			SANE_Option_Descriptor* _tmp17_ = NULL;
#line 872 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			g_debug ("scanner.vala:872: SCAN_SOURCE not available, trying alternative \"doc-" \
"source\"");
#line 873 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp15_ = self->priv->handle;
#line 873 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp17_ = scanner_get_option_by_name (self, _tmp15_, "doc-source", &_tmp16_);
#line 873 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			index = (SANE_Int) _tmp16_;
#line 873 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			option = _tmp17_;
#line 8696 "scanner.c"
		}
#line 875 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp18_ = option;
#line 875 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp18_ != NULL) {
#line 8702 "scanner.c"
			gchar** flatbed_sources = NULL;
			gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar** _tmp29_ = NULL;
			gint flatbed_sources_length1 = 0;
			gint _flatbed_sources_size_ = 0;
			gchar** adf_sources = NULL;
			gchar* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar** _tmp37_ = NULL;
			gint adf_sources_length1 = 0;
			gint _adf_sources_size_ = 0;
			gchar** adf_front_sources = NULL;
			gchar* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			gchar** _tmp41_ = NULL;
			gint adf_front_sources_length1 = 0;
			gint _adf_front_sources_size_ = 0;
			gchar** adf_back_sources = NULL;
			gchar* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			gchar** _tmp45_ = NULL;
			gint adf_back_sources_length1 = 0;
			gint _adf_back_sources_size_ = 0;
			gchar** adf_duplex_sources = NULL;
			gchar* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			gchar** _tmp54_ = NULL;
			gint adf_duplex_sources_length1 = 0;
			gint _adf_duplex_sources_size_ = 0;
			ScanJob* _tmp55_ = NULL;
			ScanType _tmp56_ = 0;
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp19_ = g_strdup ("Auto");
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp20_ = SANE_I18N ("Auto");
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp21_ = g_strdup (_tmp20_);
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp22_ = g_strdup ("Flatbed");
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp23_ = SANE_I18N ("Flatbed");
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp24_ = g_strdup (_tmp23_);
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp25_ = g_strdup ("FlatBed");
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp26_ = g_strdup ("Normal");
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp27_ = SANE_I18N ("Normal");
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp28_ = g_strdup (_tmp27_);
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp29_ = g_new0 (gchar*, 7 + 1);
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp29_[0] = _tmp19_;
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp29_[1] = _tmp21_;
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp29_[2] = _tmp22_;
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp29_[3] = _tmp24_;
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp29_[4] = _tmp25_;
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp29_[5] = _tmp26_;
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp29_[6] = _tmp28_;
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			flatbed_sources = _tmp29_;
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			flatbed_sources_length1 = 7;
#line 877 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_flatbed_sources_size_ = flatbed_sources_length1;
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp30_ = g_strdup ("Automatic Document Feeder");
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp31_ = SANE_I18N ("Automatic Document Feeder");
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp32_ = g_strdup (_tmp31_);
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp33_ = g_strdup ("ADF");
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp34_ = g_strdup ("Automatic Document Feeder(left aligned)");
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp35_ = g_strdup ("Automatic Document Feeder(centrally aligned)");
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp36_ = g_strdup ("ADF Simplex");
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp37_ = g_new0 (gchar*, 6 + 1);
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp37_[0] = _tmp30_;
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp37_[1] = _tmp32_;
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp37_[2] = _tmp33_;
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp37_[3] = _tmp34_;
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp37_[4] = _tmp35_;
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp37_[5] = _tmp36_;
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			adf_sources = _tmp37_;
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			adf_sources_length1 = 6;
#line 888 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_adf_sources_size_ = adf_sources_length1;
#line 898 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp38_ = g_strdup ("ADF Front");
#line 898 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp39_ = SANE_I18N ("ADF Front");
#line 898 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp40_ = g_strdup (_tmp39_);
#line 898 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp41_ = g_new0 (gchar*, 2 + 1);
#line 898 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp41_[0] = _tmp38_;
#line 898 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp41_[1] = _tmp40_;
#line 898 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			adf_front_sources = _tmp41_;
#line 898 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			adf_front_sources_length1 = 2;
#line 898 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_adf_front_sources_size_ = adf_front_sources_length1;
#line 904 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp42_ = g_strdup ("ADF Back");
#line 904 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp43_ = SANE_I18N ("ADF Back");
#line 904 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp44_ = g_strdup (_tmp43_);
#line 904 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp45_ = g_new0 (gchar*, 2 + 1);
#line 904 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp45_[0] = _tmp42_;
#line 904 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp45_[1] = _tmp44_;
#line 904 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			adf_back_sources = _tmp45_;
#line 904 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			adf_back_sources_length1 = 2;
#line 904 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_adf_back_sources_size_ = adf_back_sources_length1;
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp46_ = g_strdup ("ADF Duplex");
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp47_ = SANE_I18N ("ADF Duplex");
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp48_ = g_strdup (_tmp47_);
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp49_ = g_strdup ("ADF Duplex - Long-Edge Binding");
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp50_ = g_strdup ("ADF Duplex - Short-Edge Binding");
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp51_ = g_strdup ("Duplex");
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp52_ = g_strdup ("Automatic Document Feeder(centrally aligned,Duplex)");
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp53_ = g_strdup ("Automatic Document Feeder(left aligned,Duplex)");
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp54_ = g_new0 (gchar*, 7 + 1);
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp54_[0] = _tmp46_;
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp54_[1] = _tmp48_;
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp54_[2] = _tmp49_;
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp54_[3] = _tmp50_;
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp54_[4] = _tmp51_;
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp54_[5] = _tmp52_;
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp54_[6] = _tmp53_;
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			adf_duplex_sources = _tmp54_;
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			adf_duplex_sources_length1 = 7;
#line 910 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_adf_duplex_sources_size_ = adf_duplex_sources_length1;
#line 921 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp55_ = job;
#line 921 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp56_ = _tmp55_->type;
#line 921 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			switch (_tmp56_) {
#line 921 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				case SCAN_TYPE_SINGLE:
#line 8914 "scanner.c"
				{
					SANE_Handle _tmp57_ = {0};
					SANE_Option_Descriptor* _tmp58_ = NULL;
					SANE_Int _tmp59_ = {0};
					gboolean _tmp60_ = FALSE;
#line 924 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp57_ = self->priv->handle;
#line 924 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp58_ = option;
#line 924 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp59_ = index;
#line 924 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp60_ = scanner_set_default_option (self, _tmp57_, _tmp58_, _tmp59_);
#line 924 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					if (!_tmp60_) {
#line 8930 "scanner.c"
						SANE_Handle _tmp61_ = {0};
						SANE_Option_Descriptor* _tmp62_ = NULL;
						SANE_Int _tmp63_ = {0};
						gchar** _tmp64_ = NULL;
						gint _tmp64__length1 = 0;
						gboolean _tmp65_ = FALSE;
#line 925 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp61_ = self->priv->handle;
#line 925 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp62_ = option;
#line 925 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp63_ = index;
#line 925 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp64_ = flatbed_sources;
#line 925 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp64__length1 = flatbed_sources_length1;
#line 925 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp65_ = scanner_set_constrained_string_option (self, _tmp61_, _tmp62_, _tmp63_, _tmp64_, _tmp64__length1, NULL);
#line 925 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!_tmp65_) {
#line 926 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							g_warning ("scanner.vala:926: Unable to set single page source, please file a bug");
#line 8953 "scanner.c"
						}
					}
#line 927 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					break;
#line 8958 "scanner.c"
				}
#line 921 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				case SCAN_TYPE_ADF_FRONT:
#line 8962 "scanner.c"
				{
					SANE_Handle _tmp66_ = {0};
					SANE_Option_Descriptor* _tmp67_ = NULL;
					SANE_Int _tmp68_ = {0};
					gchar** _tmp69_ = NULL;
					gint _tmp69__length1 = 0;
					gboolean _tmp70_ = FALSE;
#line 929 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp66_ = self->priv->handle;
#line 929 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp67_ = option;
#line 929 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp68_ = index;
#line 929 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp69_ = adf_front_sources;
#line 929 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp69__length1 = adf_front_sources_length1;
#line 929 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp70_ = scanner_set_constrained_string_option (self, _tmp66_, _tmp67_, _tmp68_, _tmp69_, _tmp69__length1, NULL);
#line 929 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					if (!_tmp70_) {
#line 8984 "scanner.c"
						SANE_Handle _tmp71_ = {0};
						SANE_Option_Descriptor* _tmp72_ = NULL;
						SANE_Int _tmp73_ = {0};
						gchar** _tmp74_ = NULL;
						gint _tmp74__length1 = 0;
						gboolean _tmp75_ = FALSE;
#line 930 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp71_ = self->priv->handle;
#line 930 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp72_ = option;
#line 930 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp73_ = index;
#line 930 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp74_ = adf_sources;
#line 930 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp74__length1 = adf_sources_length1;
#line 930 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp75_ = scanner_set_constrained_string_option (self, _tmp71_, _tmp72_, _tmp73_, _tmp74_, _tmp74__length1, NULL);
#line 930 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!_tmp75_) {
#line 931 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							g_warning ("scanner.vala:931: Unable to set front ADF source, please file a bug");
#line 9007 "scanner.c"
						}
					}
#line 932 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					break;
#line 9012 "scanner.c"
				}
#line 921 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				case SCAN_TYPE_ADF_BACK:
#line 9016 "scanner.c"
				{
					SANE_Handle _tmp76_ = {0};
					SANE_Option_Descriptor* _tmp77_ = NULL;
					SANE_Int _tmp78_ = {0};
					gchar** _tmp79_ = NULL;
					gint _tmp79__length1 = 0;
					gboolean _tmp80_ = FALSE;
#line 934 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp76_ = self->priv->handle;
#line 934 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp77_ = option;
#line 934 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp78_ = index;
#line 934 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp79_ = adf_back_sources;
#line 934 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp79__length1 = adf_back_sources_length1;
#line 934 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp80_ = scanner_set_constrained_string_option (self, _tmp76_, _tmp77_, _tmp78_, _tmp79_, _tmp79__length1, NULL);
#line 934 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					if (!_tmp80_) {
#line 9038 "scanner.c"
						SANE_Handle _tmp81_ = {0};
						SANE_Option_Descriptor* _tmp82_ = NULL;
						SANE_Int _tmp83_ = {0};
						gchar** _tmp84_ = NULL;
						gint _tmp84__length1 = 0;
						gboolean _tmp85_ = FALSE;
#line 935 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp81_ = self->priv->handle;
#line 935 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp82_ = option;
#line 935 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp83_ = index;
#line 935 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp84_ = adf_sources;
#line 935 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp84__length1 = adf_sources_length1;
#line 935 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp85_ = scanner_set_constrained_string_option (self, _tmp81_, _tmp82_, _tmp83_, _tmp84_, _tmp84__length1, NULL);
#line 935 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!_tmp85_) {
#line 936 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							g_warning ("scanner.vala:936: Unable to set back ADF source, please file a bug");
#line 9061 "scanner.c"
						}
					}
#line 937 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					break;
#line 9066 "scanner.c"
				}
#line 921 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				case SCAN_TYPE_ADF_BOTH:
#line 9070 "scanner.c"
				{
					SANE_Handle _tmp86_ = {0};
					SANE_Option_Descriptor* _tmp87_ = NULL;
					SANE_Int _tmp88_ = {0};
					gchar** _tmp89_ = NULL;
					gint _tmp89__length1 = 0;
					gboolean _tmp90_ = FALSE;
#line 939 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp86_ = self->priv->handle;
#line 939 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp87_ = option;
#line 939 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp88_ = index;
#line 939 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp89_ = adf_duplex_sources;
#line 939 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp89__length1 = adf_duplex_sources_length1;
#line 939 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp90_ = scanner_set_constrained_string_option (self, _tmp86_, _tmp87_, _tmp88_, _tmp89_, _tmp89__length1, NULL);
#line 939 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					if (!_tmp90_) {
#line 9092 "scanner.c"
						SANE_Handle _tmp91_ = {0};
						SANE_Option_Descriptor* _tmp92_ = NULL;
						SANE_Int _tmp93_ = {0};
						gchar** _tmp94_ = NULL;
						gint _tmp94__length1 = 0;
						gboolean _tmp95_ = FALSE;
#line 940 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp91_ = self->priv->handle;
#line 940 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp92_ = option;
#line 940 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp93_ = index;
#line 940 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp94_ = adf_sources;
#line 940 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp94__length1 = adf_sources_length1;
#line 940 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp95_ = scanner_set_constrained_string_option (self, _tmp91_, _tmp92_, _tmp93_, _tmp94_, _tmp94__length1, NULL);
#line 940 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!_tmp95_) {
#line 941 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							g_warning ("scanner.vala:941: Unable to set duplex ADF source, please file a bug");
#line 9115 "scanner.c"
						}
					}
#line 942 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					break;
#line 9120 "scanner.c"
				}
				default:
#line 921 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				break;
#line 9125 "scanner.c"
			}
#line 875 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			adf_duplex_sources = (_vala_array_free (adf_duplex_sources, adf_duplex_sources_length1, (GDestroyNotify) g_free), NULL);
#line 875 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			adf_back_sources = (_vala_array_free (adf_back_sources, adf_back_sources_length1, (GDestroyNotify) g_free), NULL);
#line 875 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			adf_front_sources = (_vala_array_free (adf_front_sources, adf_front_sources_length1, (GDestroyNotify) g_free), NULL);
#line 875 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			adf_sources = (_vala_array_free (adf_sources, adf_sources_length1, (GDestroyNotify) g_free), NULL);
#line 875 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			flatbed_sources = (_vala_array_free (flatbed_sources, flatbed_sources_length1, (GDestroyNotify) g_free), NULL);
#line 9137 "scanner.c"
		}
#line 947 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp96_ = self->priv->handle;
#line 947 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp97_ = SANE_NAME_SCAN_MODE;
#line 947 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp99_ = scanner_get_option_by_name (self, _tmp96_, _tmp97_, &_tmp98_);
#line 947 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		index = (SANE_Int) _tmp98_;
#line 947 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		option = _tmp99_;
#line 948 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp100_ = option;
#line 948 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp100_ != NULL) {
#line 9153 "scanner.c"
			gchar** color_scan_modes = NULL;
			const gchar* _tmp101_ = NULL;
			gchar* _tmp102_ = NULL;
			gchar* _tmp103_ = NULL;
			gchar* _tmp104_ = NULL;
			gchar* _tmp105_ = NULL;
			gchar** _tmp106_ = NULL;
			gint color_scan_modes_length1 = 0;
			gint _color_scan_modes_size_ = 0;
			gchar** gray_scan_modes = NULL;
			const gchar* _tmp107_ = NULL;
			gchar* _tmp108_ = NULL;
			gchar* _tmp109_ = NULL;
			gchar* _tmp110_ = NULL;
			const gchar* _tmp111_ = NULL;
			gchar* _tmp112_ = NULL;
			gchar* _tmp113_ = NULL;
			gchar* _tmp114_ = NULL;
			gchar** _tmp115_ = NULL;
			gint gray_scan_modes_length1 = 0;
			gint _gray_scan_modes_size_ = 0;
			gchar** lineart_scan_modes = NULL;
			const gchar* _tmp116_ = NULL;
			gchar* _tmp117_ = NULL;
			gchar* _tmp118_ = NULL;
			gchar* _tmp119_ = NULL;
			const gchar* _tmp120_ = NULL;
			gchar* _tmp121_ = NULL;
			gchar* _tmp122_ = NULL;
			const gchar* _tmp123_ = NULL;
			gchar* _tmp124_ = NULL;
			gchar* _tmp125_ = NULL;
			const gchar* _tmp126_ = NULL;
			gchar* _tmp127_ = NULL;
			gchar* _tmp128_ = NULL;
			const gchar* _tmp129_ = NULL;
			gchar* _tmp130_ = NULL;
			gchar* _tmp131_ = NULL;
			gchar* _tmp132_ = NULL;
			const gchar* _tmp133_ = NULL;
			gchar* _tmp134_ = NULL;
			gchar* _tmp135_ = NULL;
			gchar* _tmp136_ = NULL;
			gchar* _tmp137_ = NULL;
			gchar** _tmp138_ = NULL;
			gint lineart_scan_modes_length1 = 0;
			gint _lineart_scan_modes_size_ = 0;
			ScanJob* _tmp139_ = NULL;
			ScanMode _tmp140_ = 0;
#line 951 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp101_ = SANE_VALUE_SCAN_MODE_COLOR;
#line 951 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp102_ = g_strdup (_tmp101_);
#line 951 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp103_ = g_strdup ("Color");
#line 951 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp104_ = g_strdup ("24bit Color");
#line 951 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp105_ = g_strdup ("Color - 16 Million Colors");
#line 951 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp106_ = g_new0 (gchar*, 4 + 1);
#line 951 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp106_[0] = _tmp102_;
#line 951 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp106_[1] = _tmp103_;
#line 951 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp106_[2] = _tmp104_;
#line 951 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp106_[3] = _tmp105_;
#line 951 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			color_scan_modes = _tmp106_;
#line 951 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			color_scan_modes_length1 = 4;
#line 951 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_color_scan_modes_size_ = color_scan_modes_length1;
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp107_ = SANE_VALUE_SCAN_MODE_GRAY;
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp108_ = g_strdup (_tmp107_);
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp109_ = g_strdup ("Gray");
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp110_ = g_strdup ("Grayscale");
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp111_ = SANE_I18N ("Grayscale");
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp112_ = g_strdup (_tmp111_);
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp113_ = g_strdup ("True Gray");
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp114_ = g_strdup ("Grayscale - 256 Levels");
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp115_ = g_new0 (gchar*, 6 + 1);
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp115_[0] = _tmp108_;
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp115_[1] = _tmp109_;
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp115_[2] = _tmp110_;
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp115_[3] = _tmp112_;
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp115_[4] = _tmp113_;
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp115_[5] = _tmp114_;
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			gray_scan_modes = _tmp115_;
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			gray_scan_modes_length1 = 6;
#line 958 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_gray_scan_modes_size_ = gray_scan_modes_length1;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp116_ = SANE_VALUE_SCAN_MODE_LINEART;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp117_ = g_strdup (_tmp116_);
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp118_ = g_strdup ("Lineart");
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp119_ = g_strdup ("LineArt");
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp120_ = SANE_I18N ("LineArt");
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp121_ = g_strdup (_tmp120_);
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp122_ = g_strdup ("Black & White");
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp123_ = SANE_I18N ("Black & White");
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp124_ = g_strdup (_tmp123_);
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp125_ = g_strdup ("Binary");
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp126_ = SANE_I18N ("Binary");
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp127_ = g_strdup (_tmp126_);
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp128_ = g_strdup ("Thresholded");
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp129_ = SANE_VALUE_SCAN_MODE_GRAY;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp130_ = g_strdup (_tmp129_);
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp131_ = g_strdup ("Gray");
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp132_ = g_strdup ("Grayscale");
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp133_ = SANE_I18N ("Grayscale");
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp134_ = g_strdup (_tmp133_);
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp135_ = g_strdup ("True Gray");
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp136_ = g_strdup ("Black and White - Line Art");
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp137_ = g_strdup ("Black and White - Halftone");
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_ = g_new0 (gchar*, 16 + 1);
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[0] = _tmp117_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[1] = _tmp118_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[2] = _tmp119_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[3] = _tmp121_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[4] = _tmp122_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[5] = _tmp124_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[6] = _tmp125_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[7] = _tmp127_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[8] = _tmp128_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[9] = _tmp130_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[10] = _tmp131_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[11] = _tmp132_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[12] = _tmp134_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[13] = _tmp135_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[14] = _tmp136_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp138_[15] = _tmp137_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			lineart_scan_modes = _tmp138_;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			lineart_scan_modes_length1 = 16;
#line 967 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_lineart_scan_modes_size_ = lineart_scan_modes_length1;
#line 987 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp139_ = job;
#line 987 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp140_ = _tmp139_->scan_mode;
#line 987 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			switch (_tmp140_) {
#line 987 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				case SCAN_MODE_COLOR:
#line 9357 "scanner.c"
				{
					SANE_Handle _tmp141_ = {0};
					SANE_Option_Descriptor* _tmp142_ = NULL;
					SANE_Int _tmp143_ = {0};
					gchar** _tmp144_ = NULL;
					gint _tmp144__length1 = 0;
					gboolean _tmp145_ = FALSE;
#line 990 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp141_ = self->priv->handle;
#line 990 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp142_ = option;
#line 990 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp143_ = index;
#line 990 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp144_ = color_scan_modes;
#line 990 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp144__length1 = color_scan_modes_length1;
#line 990 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp145_ = scanner_set_constrained_string_option (self, _tmp141_, _tmp142_, _tmp143_, _tmp144_, _tmp144__length1, NULL);
#line 990 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					if (!_tmp145_) {
#line 991 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						g_warning ("scanner.vala:991: Unable to set Color mode, please file a bug");
#line 9381 "scanner.c"
					}
#line 992 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					break;
#line 9385 "scanner.c"
				}
#line 987 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				case SCAN_MODE_GRAY:
#line 9389 "scanner.c"
				{
					SANE_Handle _tmp146_ = {0};
					SANE_Option_Descriptor* _tmp147_ = NULL;
					SANE_Int _tmp148_ = {0};
					gchar** _tmp149_ = NULL;
					gint _tmp149__length1 = 0;
					gboolean _tmp150_ = FALSE;
#line 994 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp146_ = self->priv->handle;
#line 994 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp147_ = option;
#line 994 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp148_ = index;
#line 994 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp149_ = gray_scan_modes;
#line 994 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp149__length1 = gray_scan_modes_length1;
#line 994 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp150_ = scanner_set_constrained_string_option (self, _tmp146_, _tmp147_, _tmp148_, _tmp149_, _tmp149__length1, NULL);
#line 994 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					if (!_tmp150_) {
#line 995 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						g_warning ("scanner.vala:995: Unable to set Gray mode, please file a bug");
#line 9413 "scanner.c"
					}
#line 996 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					break;
#line 9417 "scanner.c"
				}
#line 987 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				case SCAN_MODE_LINEART:
#line 9421 "scanner.c"
				{
					SANE_Handle _tmp151_ = {0};
					SANE_Option_Descriptor* _tmp152_ = NULL;
					SANE_Int _tmp153_ = {0};
					gchar** _tmp154_ = NULL;
					gint _tmp154__length1 = 0;
					gboolean _tmp155_ = FALSE;
#line 998 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp151_ = self->priv->handle;
#line 998 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp152_ = option;
#line 998 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp153_ = index;
#line 998 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp154_ = lineart_scan_modes;
#line 998 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp154__length1 = lineart_scan_modes_length1;
#line 998 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp155_ = scanner_set_constrained_string_option (self, _tmp151_, _tmp152_, _tmp153_, _tmp154_, _tmp154__length1, NULL);
#line 998 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					if (!_tmp155_) {
#line 999 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						g_warning ("scanner.vala:999: Unable to set Lineart mode, please file a bug");
#line 9445 "scanner.c"
					}
#line 1000 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					break;
#line 9449 "scanner.c"
				}
				default:
				{
#line 1002 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					break;
#line 9455 "scanner.c"
				}
			}
#line 948 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			lineart_scan_modes = (_vala_array_free (lineart_scan_modes, lineart_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 948 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			gray_scan_modes = (_vala_array_free (gray_scan_modes, gray_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 948 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			color_scan_modes = (_vala_array_free (color_scan_modes, color_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 9464 "scanner.c"
		}
#line 1007 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp156_ = self->priv->handle;
#line 1007 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp158_ = scanner_get_option_by_name (self, _tmp156_, "duplex", &_tmp157_);
#line 1007 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		index = (SANE_Int) _tmp157_;
#line 1007 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		option = _tmp158_;
#line 1008 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp159_ = option;
#line 1008 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp159_ != NULL) {
#line 9478 "scanner.c"
			SANE_Option_Descriptor* _tmp160_ = NULL;
			SANE_Value_Type _tmp161_ = 0;
#line 1010 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp160_ = option;
#line 1010 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp161_ = _tmp160_->type;
#line 1010 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (_tmp161_ == SANE_TYPE_BOOL) {
#line 9487 "scanner.c"
				SANE_Handle _tmp162_ = {0};
				SANE_Option_Descriptor* _tmp163_ = NULL;
				SANE_Int _tmp164_ = {0};
				ScanJob* _tmp165_ = NULL;
				ScanType _tmp166_ = 0;
#line 1011 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp162_ = self->priv->handle;
#line 1011 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp163_ = option;
#line 1011 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp164_ = index;
#line 1011 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp165_ = job;
#line 1011 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp166_ = _tmp165_->type;
#line 1011 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_set_bool_option (self, _tmp162_, _tmp163_, _tmp164_, _tmp166_ == SCAN_TYPE_ADF_BOTH, NULL);
#line 9505 "scanner.c"
			}
		}
#line 1015 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp167_ = self->priv->handle;
#line 1015 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp169_ = scanner_get_option_by_name (self, _tmp167_, "batch-scan", &_tmp168_);
#line 1015 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		index = (SANE_Int) _tmp168_;
#line 1015 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		option = _tmp169_;
#line 1016 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp170_ = option;
#line 1016 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp170_ != NULL) {
#line 9520 "scanner.c"
			SANE_Option_Descriptor* _tmp171_ = NULL;
			SANE_Value_Type _tmp172_ = 0;
#line 1018 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp171_ = option;
#line 1018 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp172_ = _tmp171_->type;
#line 1018 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (_tmp172_ == SANE_TYPE_BOOL) {
#line 9529 "scanner.c"
				SANE_Handle _tmp173_ = {0};
				SANE_Option_Descriptor* _tmp174_ = NULL;
				SANE_Int _tmp175_ = {0};
				ScanJob* _tmp176_ = NULL;
				ScanType _tmp177_ = 0;
#line 1019 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp173_ = self->priv->handle;
#line 1019 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp174_ = option;
#line 1019 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp175_ = index;
#line 1019 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp176_ = job;
#line 1019 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp177_ = _tmp176_->type;
#line 1019 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_set_bool_option (self, _tmp173_, _tmp174_, _tmp175_, _tmp177_ != SCAN_TYPE_SINGLE, NULL);
#line 9547 "scanner.c"
			}
		}
#line 1023 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp178_ = self->priv->handle;
#line 1023 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp180_ = scanner_get_option_by_name (self, _tmp178_, "compression", &_tmp179_);
#line 1023 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		index = (SANE_Int) _tmp179_;
#line 1023 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		option = _tmp180_;
#line 1024 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp181_ = option;
#line 1024 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp181_ != NULL) {
#line 9562 "scanner.c"
			gchar** disable_compression_names = NULL;
			const gchar* _tmp182_ = NULL;
			gchar* _tmp183_ = NULL;
			const gchar* _tmp184_ = NULL;
			gchar* _tmp185_ = NULL;
			gchar* _tmp186_ = NULL;
			gchar* _tmp187_ = NULL;
			gchar** _tmp188_ = NULL;
			gint disable_compression_names_length1 = 0;
			gint _disable_compression_names_size_ = 0;
			SANE_Handle _tmp189_ = {0};
			SANE_Option_Descriptor* _tmp190_ = NULL;
			SANE_Int _tmp191_ = {0};
			gchar** _tmp192_ = NULL;
			gint _tmp192__length1 = 0;
			gboolean _tmp193_ = FALSE;
#line 1026 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp182_ = SANE_I18N ("None");
#line 1026 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp183_ = g_strdup (_tmp182_);
#line 1026 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp184_ = SANE_I18N ("none");
#line 1026 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp185_ = g_strdup (_tmp184_);
#line 1026 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp186_ = g_strdup ("None");
#line 1026 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp187_ = g_strdup ("none");
#line 1026 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp188_ = g_new0 (gchar*, 4 + 1);
#line 1026 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp188_[0] = _tmp183_;
#line 1026 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp188_[1] = _tmp185_;
#line 1026 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp188_[2] = _tmp186_;
#line 1026 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp188_[3] = _tmp187_;
#line 1026 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			disable_compression_names = _tmp188_;
#line 1026 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			disable_compression_names_length1 = 4;
#line 1026 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_disable_compression_names_size_ = disable_compression_names_length1;
#line 1034 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp189_ = self->priv->handle;
#line 1034 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp190_ = option;
#line 1034 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp191_ = index;
#line 1034 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp192_ = disable_compression_names;
#line 1034 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp192__length1 = disable_compression_names_length1;
#line 1034 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp193_ = scanner_set_constrained_string_option (self, _tmp189_, _tmp190_, _tmp191_, _tmp192_, _tmp192__length1, NULL);
#line 1034 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (!_tmp193_) {
#line 1035 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				g_warning ("scanner.vala:1035: Unable to disable compression, please file a bug");
#line 9623 "scanner.c"
			}
#line 1024 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			disable_compression_names = (_vala_array_free (disable_compression_names, disable_compression_names_length1, (GDestroyNotify) g_free), NULL);
#line 9627 "scanner.c"
		}
#line 1039 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp194_ = self->priv->handle;
#line 1039 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp195_ = SANE_NAME_SCAN_RESOLUTION;
#line 1039 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp197_ = scanner_get_option_by_name (self, _tmp194_, _tmp195_, &_tmp196_);
#line 1039 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		index = (SANE_Int) _tmp196_;
#line 1039 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		option = _tmp197_;
#line 1040 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp198_ = option;
#line 1040 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp198_ != NULL) {
#line 9643 "scanner.c"
			SANE_Handle _tmp199_ = {0};
			SANE_Option_Descriptor* _tmp200_ = NULL;
			SANE_Int _tmp201_ = {0};
			ScanJob* _tmp202_ = NULL;
			gdouble _tmp203_ = 0.0;
			ScanJob* _tmp204_ = NULL;
			gdouble _tmp205_ = 0.0;
			SANE_Handle _tmp206_ = {0};
			const gchar* _tmp207_ = NULL;
			gint _tmp208_ = 0;
			SANE_Option_Descriptor* _tmp209_ = NULL;
			SANE_Option_Descriptor* _tmp210_ = NULL;
#line 1042 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp199_ = self->priv->handle;
#line 1042 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp200_ = option;
#line 1042 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp201_ = index;
#line 1042 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp202_ = job;
#line 1042 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp203_ = _tmp202_->dpi;
#line 1042 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp204_ = job;
#line 1042 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp199_, _tmp200_, _tmp201_, _tmp203_, &_tmp205_);
#line 1042 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp204_->dpi = _tmp205_;
#line 1043 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp206_ = self->priv->handle;
#line 1043 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp207_ = SANE_NAME_BIT_DEPTH;
#line 1043 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp209_ = scanner_get_option_by_name (self, _tmp206_, _tmp207_, &_tmp208_);
#line 1043 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			index = (SANE_Int) _tmp208_;
#line 1043 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			option = _tmp209_;
#line 1044 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp210_ = option;
#line 1044 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (_tmp210_ != NULL) {
#line 9686 "scanner.c"
				ScanJob* _tmp211_ = NULL;
				gint _tmp212_ = 0;
#line 1046 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp211_ = job;
#line 1046 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp212_ = _tmp211_->depth;
#line 1046 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (_tmp212_ > 0) {
#line 9695 "scanner.c"
					SANE_Handle _tmp213_ = {0};
					SANE_Option_Descriptor* _tmp214_ = NULL;
					SANE_Int _tmp215_ = {0};
					ScanJob* _tmp216_ = NULL;
					gint _tmp217_ = 0;
#line 1047 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp213_ = self->priv->handle;
#line 1047 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp214_ = option;
#line 1047 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp215_ = index;
#line 1047 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp216_ = job;
#line 1047 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp217_ = _tmp216_->depth;
#line 1047 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					scanner_set_int_option (self, _tmp213_, _tmp214_, _tmp215_, _tmp217_, NULL);
#line 9713 "scanner.c"
				}
			}
		}
#line 1052 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp218_ = self->priv->handle;
#line 1052 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp219_ = SANE_NAME_SCAN_BR_X;
#line 1052 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp221_ = scanner_get_option_by_name (self, _tmp218_, _tmp219_, &_tmp220_);
#line 1052 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		index = (SANE_Int) _tmp220_;
#line 1052 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		option = _tmp221_;
#line 1053 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp222_ = option;
#line 1053 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp222_ != NULL) {
#line 9731 "scanner.c"
			ScanJob* _tmp223_ = NULL;
			gint _tmp224_ = 0;
#line 1055 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp223_ = job;
#line 1055 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp224_ = _tmp223_->page_width;
#line 1055 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (_tmp224_ > 0) {
#line 9740 "scanner.c"
				SANE_Handle _tmp225_ = {0};
				SANE_Option_Descriptor* _tmp226_ = NULL;
				SANE_Int _tmp227_ = {0};
				SANE_Option_Descriptor* _tmp228_ = NULL;
				ScanJob* _tmp229_ = NULL;
				gint _tmp230_ = 0;
				ScanJob* _tmp231_ = NULL;
				gdouble _tmp232_ = 0.0;
				gdouble _tmp233_ = 0.0;
#line 1056 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp225_ = self->priv->handle;
#line 1056 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp226_ = option;
#line 1056 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp227_ = index;
#line 1056 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp228_ = option;
#line 1056 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp229_ = job;
#line 1056 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp230_ = _tmp229_->page_width;
#line 1056 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp231_ = job;
#line 1056 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp232_ = _tmp231_->dpi;
#line 1056 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp233_ = scanner_convert_page_size (self, _tmp228_, (gdouble) _tmp230_, _tmp232_);
#line 1056 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_set_fixed_or_int_option (self, _tmp225_, _tmp226_, _tmp227_, _tmp233_, NULL);
#line 9770 "scanner.c"
			} else {
				SANE_Handle _tmp234_ = {0};
				SANE_Option_Descriptor* _tmp235_ = NULL;
				SANE_Int _tmp236_ = {0};
#line 1058 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp234_ = self->priv->handle;
#line 1058 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp235_ = option;
#line 1058 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp236_ = index;
#line 1058 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_set_option_to_max (self, _tmp234_, _tmp235_, _tmp236_);
#line 9783 "scanner.c"
			}
		}
#line 1060 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp237_ = self->priv->handle;
#line 1060 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp238_ = SANE_NAME_SCAN_BR_Y;
#line 1060 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp240_ = scanner_get_option_by_name (self, _tmp237_, _tmp238_, &_tmp239_);
#line 1060 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		index = (SANE_Int) _tmp239_;
#line 1060 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		option = _tmp240_;
#line 1061 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp241_ = option;
#line 1061 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp241_ != NULL) {
#line 9800 "scanner.c"
			ScanJob* _tmp242_ = NULL;
			gint _tmp243_ = 0;
#line 1063 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp242_ = job;
#line 1063 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp243_ = _tmp242_->page_height;
#line 1063 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (_tmp243_ > 0) {
#line 9809 "scanner.c"
				SANE_Handle _tmp244_ = {0};
				SANE_Option_Descriptor* _tmp245_ = NULL;
				SANE_Int _tmp246_ = {0};
				SANE_Option_Descriptor* _tmp247_ = NULL;
				ScanJob* _tmp248_ = NULL;
				gint _tmp249_ = 0;
				ScanJob* _tmp250_ = NULL;
				gdouble _tmp251_ = 0.0;
				gdouble _tmp252_ = 0.0;
#line 1064 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp244_ = self->priv->handle;
#line 1064 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp245_ = option;
#line 1064 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp246_ = index;
#line 1064 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp247_ = option;
#line 1064 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp248_ = job;
#line 1064 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp249_ = _tmp248_->page_height;
#line 1064 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp250_ = job;
#line 1064 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp251_ = _tmp250_->dpi;
#line 1064 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp252_ = scanner_convert_page_size (self, _tmp247_, (gdouble) _tmp249_, _tmp251_);
#line 1064 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_set_fixed_or_int_option (self, _tmp244_, _tmp245_, _tmp246_, _tmp252_, NULL);
#line 9839 "scanner.c"
			} else {
				SANE_Handle _tmp253_ = {0};
				SANE_Option_Descriptor* _tmp254_ = NULL;
				SANE_Int _tmp255_ = {0};
#line 1066 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp253_ = self->priv->handle;
#line 1066 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp254_ = option;
#line 1066 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp255_ = index;
#line 1066 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_set_option_to_max (self, _tmp253_, _tmp254_, _tmp255_);
#line 9852 "scanner.c"
			}
		}
#line 1070 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp256_ = self->priv->handle;
#line 1070 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp257_ = SANE_NAME_PAGE_WIDTH;
#line 1070 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp259_ = scanner_get_option_by_name (self, _tmp256_, _tmp257_, &_tmp258_);
#line 1070 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		index = (SANE_Int) _tmp258_;
#line 1070 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		option = _tmp259_;
#line 1071 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp261_ = option;
#line 1071 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp261_ != NULL) {
#line 9869 "scanner.c"
			ScanJob* _tmp262_ = NULL;
			gint _tmp263_ = 0;
#line 1071 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp262_ = job;
#line 1071 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp263_ = _tmp262_->page_width;
#line 1071 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp260_ = ((gdouble) _tmp263_) > 0.0;
#line 9878 "scanner.c"
		} else {
#line 1071 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp260_ = FALSE;
#line 9882 "scanner.c"
		}
#line 1071 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp260_) {
#line 9886 "scanner.c"
			SANE_Handle _tmp264_ = {0};
			SANE_Option_Descriptor* _tmp265_ = NULL;
			SANE_Int _tmp266_ = {0};
			SANE_Option_Descriptor* _tmp267_ = NULL;
			ScanJob* _tmp268_ = NULL;
			gint _tmp269_ = 0;
			ScanJob* _tmp270_ = NULL;
			gdouble _tmp271_ = 0.0;
			gdouble _tmp272_ = 0.0;
#line 1072 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp264_ = self->priv->handle;
#line 1072 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp265_ = option;
#line 1072 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp266_ = index;
#line 1072 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp267_ = option;
#line 1072 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp268_ = job;
#line 1072 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp269_ = _tmp268_->page_width;
#line 1072 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp270_ = job;
#line 1072 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp271_ = _tmp270_->dpi;
#line 1072 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp272_ = scanner_convert_page_size (self, _tmp267_, (gdouble) _tmp269_, _tmp271_);
#line 1072 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp264_, _tmp265_, _tmp266_, _tmp272_, NULL);
#line 9916 "scanner.c"
		}
#line 1073 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp273_ = self->priv->handle;
#line 1073 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp274_ = SANE_NAME_PAGE_HEIGHT;
#line 1073 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp276_ = scanner_get_option_by_name (self, _tmp273_, _tmp274_, &_tmp275_);
#line 1073 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		index = (SANE_Int) _tmp275_;
#line 1073 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		option = _tmp276_;
#line 1074 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp278_ = option;
#line 1074 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp278_ != NULL) {
#line 9932 "scanner.c"
			ScanJob* _tmp279_ = NULL;
			gint _tmp280_ = 0;
#line 1074 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp279_ = job;
#line 1074 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp280_ = _tmp279_->page_height;
#line 1074 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp277_ = ((gdouble) _tmp280_) > 0.0;
#line 9941 "scanner.c"
		} else {
#line 1074 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp277_ = FALSE;
#line 9945 "scanner.c"
		}
#line 1074 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp277_) {
#line 9949 "scanner.c"
			SANE_Handle _tmp281_ = {0};
			SANE_Option_Descriptor* _tmp282_ = NULL;
			SANE_Int _tmp283_ = {0};
			SANE_Option_Descriptor* _tmp284_ = NULL;
			ScanJob* _tmp285_ = NULL;
			gint _tmp286_ = 0;
			ScanJob* _tmp287_ = NULL;
			gdouble _tmp288_ = 0.0;
			gdouble _tmp289_ = 0.0;
#line 1075 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp281_ = self->priv->handle;
#line 1075 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp282_ = option;
#line 1075 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp283_ = index;
#line 1075 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp284_ = option;
#line 1075 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp285_ = job;
#line 1075 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp286_ = _tmp285_->page_height;
#line 1075 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp287_ = job;
#line 1075 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp288_ = _tmp287_->dpi;
#line 1075 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp289_ = scanner_convert_page_size (self, _tmp284_, (gdouble) _tmp286_, _tmp288_);
#line 1075 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp281_, _tmp282_, _tmp283_, _tmp289_, NULL);
#line 9979 "scanner.c"
		}
#line 1078 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp290_ = self->priv->current_device;
#line 1078 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (g_strcmp0 (_tmp290_, "test") == 0) {
#line 9985 "scanner.c"
			SANE_Handle _tmp291_ = {0};
			gint _tmp292_ = 0;
			SANE_Option_Descriptor* _tmp293_ = NULL;
			SANE_Option_Descriptor* _tmp294_ = NULL;
			SANE_Handle _tmp298_ = {0};
			gint _tmp299_ = 0;
			SANE_Option_Descriptor* _tmp300_ = NULL;
			SANE_Option_Descriptor* _tmp301_ = NULL;
			SANE_Handle _tmp305_ = {0};
			gint _tmp306_ = 0;
			SANE_Option_Descriptor* _tmp307_ = NULL;
			SANE_Option_Descriptor* _tmp308_ = NULL;
			SANE_Handle _tmp312_ = {0};
			gint _tmp313_ = 0;
			SANE_Option_Descriptor* _tmp314_ = NULL;
			SANE_Option_Descriptor* _tmp315_ = NULL;
			SANE_Handle _tmp319_ = {0};
			gint _tmp320_ = 0;
			SANE_Option_Descriptor* _tmp321_ = NULL;
			SANE_Option_Descriptor* _tmp322_ = NULL;
#line 1080 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp291_ = self->priv->handle;
#line 1080 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp293_ = scanner_get_option_by_name (self, _tmp291_, "hand-scanner", &_tmp292_);
#line 1080 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			index = (SANE_Int) _tmp292_;
#line 1080 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			option = _tmp293_;
#line 1081 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp294_ = option;
#line 1081 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (_tmp294_ != NULL) {
#line 10018 "scanner.c"
				SANE_Handle _tmp295_ = {0};
				SANE_Option_Descriptor* _tmp296_ = NULL;
				SANE_Int _tmp297_ = {0};
#line 1082 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp295_ = self->priv->handle;
#line 1082 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp296_ = option;
#line 1082 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp297_ = index;
#line 1082 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_set_bool_option (self, _tmp295_, _tmp296_, _tmp297_, FALSE, NULL);
#line 10030 "scanner.c"
			}
#line 1083 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp298_ = self->priv->handle;
#line 1083 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp300_ = scanner_get_option_by_name (self, _tmp298_, "three-pass", &_tmp299_);
#line 1083 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			index = (SANE_Int) _tmp299_;
#line 1083 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			option = _tmp300_;
#line 1084 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp301_ = option;
#line 1084 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (_tmp301_ != NULL) {
#line 10044 "scanner.c"
				SANE_Handle _tmp302_ = {0};
				SANE_Option_Descriptor* _tmp303_ = NULL;
				SANE_Int _tmp304_ = {0};
#line 1085 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp302_ = self->priv->handle;
#line 1085 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp303_ = option;
#line 1085 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp304_ = index;
#line 1085 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_set_bool_option (self, _tmp302_, _tmp303_, _tmp304_, FALSE, NULL);
#line 10056 "scanner.c"
			}
#line 1086 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp305_ = self->priv->handle;
#line 1086 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp307_ = scanner_get_option_by_name (self, _tmp305_, "test-picture", &_tmp306_);
#line 1086 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			index = (SANE_Int) _tmp306_;
#line 1086 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			option = _tmp307_;
#line 1087 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp308_ = option;
#line 1087 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (_tmp308_ != NULL) {
#line 10070 "scanner.c"
				SANE_Handle _tmp309_ = {0};
				SANE_Option_Descriptor* _tmp310_ = NULL;
				SANE_Int _tmp311_ = {0};
#line 1088 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp309_ = self->priv->handle;
#line 1088 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp310_ = option;
#line 1088 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp311_ = index;
#line 1088 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_set_string_option (self, _tmp309_, _tmp310_, _tmp311_, "Color pattern", NULL);
#line 10082 "scanner.c"
			}
#line 1089 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp312_ = self->priv->handle;
#line 1089 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp314_ = scanner_get_option_by_name (self, _tmp312_, "read-delay", &_tmp313_);
#line 1089 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			index = (SANE_Int) _tmp313_;
#line 1089 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			option = _tmp314_;
#line 1090 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp315_ = option;
#line 1090 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (_tmp315_ != NULL) {
#line 10096 "scanner.c"
				SANE_Handle _tmp316_ = {0};
				SANE_Option_Descriptor* _tmp317_ = NULL;
				SANE_Int _tmp318_ = {0};
#line 1091 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp316_ = self->priv->handle;
#line 1091 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp317_ = option;
#line 1091 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp318_ = index;
#line 1091 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_set_bool_option (self, _tmp316_, _tmp317_, _tmp318_, TRUE, NULL);
#line 10108 "scanner.c"
			}
#line 1092 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp319_ = self->priv->handle;
#line 1092 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp321_ = scanner_get_option_by_name (self, _tmp319_, "read-delay-duration", &_tmp320_);
#line 1092 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			index = (SANE_Int) _tmp320_;
#line 1092 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			option = _tmp321_;
#line 1093 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp322_ = option;
#line 1093 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			if (_tmp322_ != NULL) {
#line 10122 "scanner.c"
				SANE_Handle _tmp323_ = {0};
				SANE_Option_Descriptor* _tmp324_ = NULL;
				SANE_Int _tmp325_ = {0};
#line 1094 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp323_ = self->priv->handle;
#line 1094 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp324_ = option;
#line 1094 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp325_ = index;
#line 1094 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_set_int_option (self, _tmp323_, _tmp324_, _tmp325_, 200000, NULL);
#line 10134 "scanner.c"
			}
		}
#line 1097 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1098 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1098 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 10143 "scanner.c"
	}
#line 1101 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp326_ = index;
#line 1101 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp327_ = option;
#line 1101 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_log_option (self, _tmp326_, _tmp327_);
#line 1104 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp328_ = option;
#line 1104 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp329_ = _tmp328_->type;
#line 1104 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp329_ == SANE_TYPE_GROUP) {
#line 1105 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1105 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 10161 "scanner.c"
	}
#line 1108 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp330_ = option;
#line 1108 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp331_ = _tmp330_->cap;
#line 1108 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if ((_tmp331_ & SANE_CAP_INACTIVE) != ((SANE_Int) 0)) {
#line 1109 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1109 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 10173 "scanner.c"
	}
#line 1112 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp332_ = option;
#line 1112 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp333_ = _tmp332_->name;
#line 1112 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp333_ == NULL) {
#line 1113 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1113 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 10185 "scanner.c"
	}
#line 1115 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp334_ = self->priv->options;
#line 1115 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp335_ = option;
#line 1115 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp336_ = _tmp335_->name;
#line 1115 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp337_ = g_strdup (_tmp336_);
#line 1115 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp338_ = index;
#line 1115 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_hash_table_insert (_tmp334_, _tmp337_, (gpointer) ((gintptr) ((gint) _tmp338_)));
#line 856 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_scan_job_unref0 (job);
#line 10201 "scanner.c"
}


static gdouble scanner_convert_page_size (Scanner* self, SANE_Option_Descriptor* option, gdouble size, gdouble dpi) {
	gdouble result = 0.0;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Unit _tmp1_ = 0;
#line 1118 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 1118 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (option != NULL, 0.0);
#line 1120 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = option;
#line 1120 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = _tmp0_->unit;
#line 1120 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp1_ == SANE_UNIT_PIXEL) {
#line 10219 "scanner.c"
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
#line 1121 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp2_ = dpi;
#line 1121 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp3_ = size;
#line 1121 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		result = (_tmp2_ * _tmp3_) / 254.0;
#line 1121 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return result;
#line 10230 "scanner.c"
	} else {
		SANE_Option_Descriptor* _tmp4_ = NULL;
		SANE_Unit _tmp5_ = 0;
#line 1122 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp4_ = option;
#line 1122 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp5_ = _tmp4_->unit;
#line 1122 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp5_ == SANE_UNIT_MM) {
#line 10240 "scanner.c"
			gdouble _tmp6_ = 0.0;
#line 1123 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp6_ = size;
#line 1123 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			result = _tmp6_ / 10.0;
#line 1123 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return result;
#line 10248 "scanner.c"
		} else {
#line 1126 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			g_warning ("scanner.vala:1126: Unable to set unsupported unit type");
#line 1127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			result = (gdouble) 0.0f;
#line 1127 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return result;
#line 10256 "scanner.c"
		}
	}
}


static SANE_Option_Descriptor* scanner_get_option_by_name (Scanner* self, SANE_Handle handle, const gchar* name, gint* index) {
	gint _vala_index = 0;
	SANE_Option_Descriptor* result = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gint _tmp3_ = 0;
	SANE_Handle _tmp4_ = {0};
	gint _tmp5_ = 0;
	SANE_Option_Descriptor* _tmp6_ = NULL;
#line 1131 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1131 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 1133 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = self->priv->options;
#line 1133 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = name;
#line 1133 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 1133 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_vala_index = (gint) ((gintptr) _tmp2_);
#line 1134 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = _vala_index;
#line 1134 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp3_ == 0) {
#line 1135 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		result = NULL;
#line 1135 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (index) {
#line 1135 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			*index = _vala_index;
#line 10294 "scanner.c"
		}
#line 1135 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return result;
#line 10298 "scanner.c"
	}
#line 1137 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = handle;
#line 1137 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = _vala_index;
#line 1137 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp6_ = sane_get_option_descriptor (_tmp4_, (SANE_Int) _tmp5_);
#line 1137 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	result = _tmp6_;
#line 1137 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (index) {
#line 1137 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*index = _vala_index;
#line 10312 "scanner.c"
	}
#line 1137 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return result;
#line 10316 "scanner.c"
}


static void scanner_do_complete_document (Scanner* self) {
	SANE_Handle _tmp0_ = {0};
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	NotifyDocumentDone* _tmp3_ = NULL;
	NotifyDocumentDone* _tmp4_ = NULL;
#line 1140 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1142 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = self->priv->handle;
#line 1142 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	sane_cancel (_tmp0_);
#line 1143 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:1143: sane_cancel ()");
#line 1145 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = self->priv->job_queue;
#line 1145 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->job_queue = g_list_remove_link (self->priv->job_queue, _tmp1_);
#line 1147 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 1150 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = self->priv->job_queue;
#line 1150 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp2_ != NULL) {
#line 1152 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->state = SCAN_STATE_OPEN;
#line 1153 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 10348 "scanner.c"
	}
#line 1159 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = notify_document_done_new ();
#line 1159 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 1159 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp4_);
#line 1159 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_notify_unref0 (_tmp4_);
#line 1160 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_set_scanning (self, FALSE);
#line 10360 "scanner.c"
}


static void scanner_do_start (Scanner* self) {
	SANE_Status status = 0;
	NotifyExpectPage* _tmp0_ = NULL;
	NotifyExpectPage* _tmp1_ = NULL;
	SANE_Handle _tmp2_ = {0};
	SANE_Status _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	SANE_Status _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	SANE_Status _tmp9_ = 0;
#line 1163 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1167 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = notify_expect_page_new ();
#line 1167 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = _tmp0_;
#line 1167 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp1_);
#line 1167 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_notify_unref0 (_tmp1_);
#line 1169 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = self->priv->handle;
#line 1169 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = sane_start (_tmp2_);
#line 1169 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	status = _tmp3_;
#line 1170 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = self->priv->page_number;
#line 1170 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = self->priv->pass_number;
#line 1170 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp6_ = status;
#line 1170 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp7_ = sane_status_to_string (_tmp6_);
#line 1170 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp8_ = _tmp7_;
#line 1170 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:1170: sane_start (page=%d, pass=%d) -> %s", _tmp4_, _tmp5_, _tmp8_);
#line 1170 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp8_);
#line 1171 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp9_ = status;
#line 1171 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp9_ == SANE_STATUS_GOOD) {
#line 1172 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->state = SCAN_STATE_GET_PARAMETERS;
#line 10412 "scanner.c"
	} else {
		SANE_Status _tmp10_ = 0;
#line 1173 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp10_ = status;
#line 1173 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp10_ == SANE_STATUS_NO_DOCS) {
#line 1174 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			scanner_do_complete_document (self);
#line 10421 "scanner.c"
		} else {
			SANE_Status _tmp11_ = 0;
			const gchar* _tmp12_ = NULL;
			SANE_Status _tmp13_ = 0;
			const gchar* _tmp14_ = NULL;
#line 1177 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp11_ = status;
#line 1177 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp12_ = sane_strstatus (_tmp11_);
#line 1177 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			g_warning ("scanner.vala:1177: Unable to start device: %s", _tmp12_);
#line 1178 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp13_ = status;
#line 1178 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp14_ = _ ("Unable to start scan");
#line 1178 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			scanner_fail_scan (self, (gint) _tmp13_, _tmp14_);
#line 10439 "scanner.c"
		}
	}
}


static gchar* sane_frame_to_string (SANE_Frame frame) {
	gchar* result = NULL;
	SANE_Frame _tmp0_ = 0;
#line 103 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
	_tmp0_ = frame;
#line 103 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
	switch (_tmp0_) {
#line 103 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_FRAME_GRAY:
#line 10454 "scanner.c"
		{
			gchar* _tmp1_ = NULL;
#line 106 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp1_ = g_strdup ("SANE_FRAME_GRAY");
#line 106 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp1_;
#line 106 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 10463 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_FRAME_RGB:
#line 10467 "scanner.c"
		{
			gchar* _tmp2_ = NULL;
#line 108 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp2_ = g_strdup ("SANE_FRAME_RGB");
#line 108 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp2_;
#line 108 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 10476 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_FRAME_RED:
#line 10480 "scanner.c"
		{
			gchar* _tmp3_ = NULL;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp3_ = g_strdup ("SANE_FRAME_RED");
#line 110 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp3_;
#line 110 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 10489 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_FRAME_GREEN:
#line 10493 "scanner.c"
		{
			gchar* _tmp4_ = NULL;
#line 112 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp4_ = g_strdup ("SANE_FRAME_GREEN");
#line 112 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp4_;
#line 112 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 10502 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
		case SANE_FRAME_BLUE:
#line 10506 "scanner.c"
		{
			gchar* _tmp5_ = NULL;
#line 114 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp5_ = g_strdup ("SANE_FRAME_BLUE");
#line 114 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp5_;
#line 114 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 10515 "scanner.c"
		}
		default:
		{
			SANE_Frame _tmp6_ = 0;
			gchar* _tmp7_ = NULL;
#line 116 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp6_ = frame;
#line 116 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			_tmp7_ = g_strdup_printf ("SANE_FRAME(%d)", (gint) _tmp6_);
#line 116 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			result = _tmp7_;
#line 116 "/home/bob/bzr/simple-scan/3.4/src/sane.vapi"
			return result;
#line 10529 "scanner.c"
		}
	}
}


static void scanner_do_get_parameters (Scanner* self) {
	SANE_Status status = 0;
	SANE_Handle _tmp0_ = {0};
	SANE_Parameters _tmp1_ = {0};
	SANE_Status _tmp2_ = 0;
	SANE_Status _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	SANE_Status _tmp6_ = 0;
	ScanJob* job = NULL;
	GList* _tmp11_ = NULL;
	gconstpointer _tmp12_ = NULL;
	ScanJob* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	SANE_Parameters _tmp15_ = {0};
	gboolean _tmp16_ = FALSE;
	SANE_Parameters _tmp17_ = {0};
	SANE_Frame _tmp18_ = 0;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	SANE_Parameters _tmp21_ = {0};
	gint _tmp22_ = 0;
	SANE_Parameters _tmp23_ = {0};
	gint _tmp24_ = 0;
	SANE_Parameters _tmp25_ = {0};
	gint _tmp26_ = 0;
	SANE_Parameters _tmp27_ = {0};
	gint _tmp28_ = 0;
	ScanPageInfo* info = NULL;
	ScanPageInfo* _tmp29_ = NULL;
	ScanPageInfo* _tmp30_ = NULL;
	SANE_Parameters _tmp31_ = {0};
	gint _tmp32_ = 0;
	ScanPageInfo* _tmp33_ = NULL;
	SANE_Parameters _tmp34_ = {0};
	gint _tmp35_ = 0;
	ScanPageInfo* _tmp36_ = NULL;
	SANE_Parameters _tmp37_ = {0};
	gint _tmp38_ = 0;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	SANE_Parameters _tmp42_ = {0};
	gint _tmp43_ = 0;
	gint _tmp53_ = 0;
	SANE_Parameters _tmp54_ = {0};
	SANE_Frame _tmp55_ = 0;
	ScanPageInfo* _tmp56_ = NULL;
	ScanPageInfo* _tmp57_ = NULL;
	ScanJob* _tmp58_ = NULL;
	gdouble _tmp59_ = 0.0;
	ScanPageInfo* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	gint buffer_size = 0;
	SANE_Parameters _tmp71_ = {0};
	gint _tmp72_ = 0;
	gint _tmp73_ = 0;
	guchar* _tmp74_ = NULL;
#line 1184 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1186 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = self->priv->handle;
#line 1186 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = sane_get_parameters (_tmp0_, &_tmp1_);
#line 1186 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->parameters = _tmp1_;
#line 1186 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	status = _tmp2_;
#line 1187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = status;
#line 1187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = sane_status_to_string (_tmp3_);
#line 1187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = _tmp4_;
#line 1187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:1187: sane_get_parameters () -> %s", _tmp5_);
#line 1187 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp5_);
#line 1188 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp6_ = status;
#line 1188 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp6_ != SANE_STATUS_GOOD) {
#line 10620 "scanner.c"
		SANE_Status _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
		SANE_Status _tmp9_ = 0;
		const gchar* _tmp10_ = NULL;
#line 1190 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_ = status;
#line 1190 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp8_ = sane_strstatus (_tmp7_);
#line 1190 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_warning ("scanner.vala:1190: Unable to get device parameters: %s", _tmp8_);
#line 1191 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp9_ = status;
#line 1191 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp10_ = _ ("Error communicating with scanner");
#line 1191 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp9_, _tmp10_);
#line 1194 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 10639 "scanner.c"
	}
#line 1197 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp11_ = self->priv->job_queue;
#line 1197 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp12_ = _tmp11_->data;
#line 1197 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp13_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp12_, TYPE_SCAN_JOB, ScanJob));
#line 1197 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	job = _tmp13_;
#line 1201 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp15_ = self->priv->parameters;
#line 1201 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp16_ = _tmp15_.last_frame;
#line 1201 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp16_) {
#line 1201 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp14_ = "SANE_TRUE";
#line 10657 "scanner.c"
	} else {
#line 1201 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp14_ = "SANE_FALSE";
#line 10661 "scanner.c"
	}
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp17_ = self->priv->parameters;
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp18_ = _tmp17_.format;
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp19_ = sane_frame_to_string (_tmp18_);
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp20_ = _tmp19_;
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp21_ = self->priv->parameters;
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp22_ = _tmp21_.bytes_per_line;
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp23_ = self->priv->parameters;
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp24_ = _tmp23_.pixels_per_line;
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp25_ = self->priv->parameters;
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp26_ = _tmp25_.lines;
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp27_ = self->priv->parameters;
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp28_ = _tmp27_.depth;
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:1199: Parameters: format=%s last_frame=%s bytes_per_line=" \
"%d pixels_per_line=%d lines=%d depth=%d", _tmp20_, _tmp14_, _tmp22_, _tmp24_, _tmp26_, _tmp28_);
#line 1199 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp20_);
#line 1207 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp29_ = scan_page_info_new ();
#line 1207 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	info = _tmp29_;
#line 1208 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp30_ = info;
#line 1208 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp31_ = self->priv->parameters;
#line 1208 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp32_ = _tmp31_.pixels_per_line;
#line 1208 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp30_->width = _tmp32_;
#line 1209 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp33_ = info;
#line 1209 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp34_ = self->priv->parameters;
#line 1209 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp35_ = _tmp34_.lines;
#line 1209 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp33_->height = _tmp35_;
#line 1210 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp36_ = info;
#line 1210 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp37_ = self->priv->parameters;
#line 1210 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp38_ = _tmp37_.depth;
#line 1210 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp36_->depth = _tmp38_;
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp42_ = self->priv->parameters;
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp43_ = _tmp42_.depth;
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp43_ == 8) {
#line 10725 "scanner.c"
		SANE_Parameters _tmp44_ = {0};
		SANE_Frame _tmp45_ = 0;
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp44_ = self->priv->parameters;
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp45_ = _tmp44_.format;
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp41_ = _tmp45_ == SANE_FRAME_GRAY;
#line 10734 "scanner.c"
	} else {
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp41_ = FALSE;
#line 10738 "scanner.c"
	}
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp41_) {
#line 10742 "scanner.c"
		ScanJob* _tmp46_ = NULL;
		gint _tmp47_ = 0;
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp46_ = job;
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp47_ = _tmp46_->depth;
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp40_ = _tmp47_ == 2;
#line 10751 "scanner.c"
	} else {
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp40_ = FALSE;
#line 10755 "scanner.c"
	}
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp40_) {
#line 10759 "scanner.c"
		ScanJob* _tmp48_ = NULL;
		ScanMode _tmp49_ = 0;
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp48_ = job;
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp49_ = _tmp48_->scan_mode;
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp39_ = _tmp49_ == SCAN_MODE_GRAY;
#line 10768 "scanner.c"
	} else {
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp39_ = FALSE;
#line 10772 "scanner.c"
	}
#line 1213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp39_) {
#line 10776 "scanner.c"
		ScanPageInfo* _tmp50_ = NULL;
		ScanJob* _tmp51_ = NULL;
		gint _tmp52_ = 0;
#line 1214 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp50_ = info;
#line 1214 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp51_ = job;
#line 1214 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp52_ = _tmp51_->depth;
#line 1214 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp50_->depth = _tmp52_;
#line 10788 "scanner.c"
	}
#line 1215 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp54_ = self->priv->parameters;
#line 1215 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp55_ = _tmp54_.format;
#line 1215 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp55_ == SANE_FRAME_GRAY) {
#line 1215 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp53_ = 1;
#line 10798 "scanner.c"
	} else {
#line 1215 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp53_ = 3;
#line 10802 "scanner.c"
	}
#line 1215 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp56_ = info;
#line 1215 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp56_->n_channels = _tmp53_;
#line 1216 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp57_ = info;
#line 1216 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp58_ = job;
#line 1216 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp59_ = _tmp58_->dpi;
#line 1216 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp57_->dpi = _tmp59_;
#line 1217 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp60_ = info;
#line 1217 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp61_ = self->priv->current_device;
#line 1217 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp62_ = g_strdup (_tmp61_);
#line 1217 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp60_->device);
#line 1217 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp60_->device = _tmp62_;
#line 1219 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp63_ = self->priv->page_number;
#line 1219 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp64_ = self->priv->notified_page;
#line 1219 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp63_ != _tmp64_) {
#line 10832 "scanner.c"
		ScanJob* _tmp65_ = NULL;
		gint _tmp66_ = 0;
		ScanPageInfo* _tmp67_ = NULL;
		NotifyGotPageInfo* _tmp68_ = NULL;
		NotifyGotPageInfo* _tmp69_ = NULL;
		gint _tmp70_ = 0;
#line 1221 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp65_ = job;
#line 1221 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp66_ = _tmp65_->id;
#line 1221 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp67_ = info;
#line 1221 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp68_ = notify_got_page_info_new (_tmp66_, _tmp67_);
#line 1221 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp69_ = _tmp68_;
#line 1221 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp69_);
#line 1221 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_notify_unref0 (_tmp69_);
#line 1222 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp70_ = self->priv->page_number;
#line 1222 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->notified_page = _tmp70_;
#line 10857 "scanner.c"
	}
#line 1226 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp71_ = self->priv->parameters;
#line 1226 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp72_ = _tmp71_.bytes_per_line;
#line 1226 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	buffer_size = _tmp72_ + 1;
#line 1227 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp73_ = buffer_size;
#line 1227 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp74_ = g_new0 (guchar, _tmp73_);
#line 1227 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 1227 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->buffer = _tmp74_;
#line 1227 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->buffer_length1 = _tmp73_;
#line 1227 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 1228 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->n_used = 0;
#line 1229 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->line_count = 0;
#line 1230 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->pass_number = 0;
#line 1231 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->state = SCAN_STATE_READ;
#line 1184 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_scan_page_info_unref0 (info);
#line 1184 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_scan_job_unref0 (job);
#line 10889 "scanner.c"
}


static void scanner_do_complete_page (Scanner* self) {
	ScanJob* job = NULL;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	ScanJob* _tmp2_ = NULL;
	ScanJob* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	NotifyPageDone* _tmp5_ = NULL;
	NotifyPageDone* _tmp6_ = NULL;
	SANE_Parameters _tmp7_ = {0};
	gboolean _tmp8_ = FALSE;
	ScanJob* _tmp10_ = NULL;
	ScanType _tmp11_ = 0;
#line 1234 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1236 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 1236 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 1236 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 1236 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	job = _tmp2_;
#line 1238 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = job;
#line 1238 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = _tmp3_->id;
#line 1238 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = notify_page_done_new (_tmp4_);
#line 1238 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp6_ = _tmp5_;
#line 1238 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp6_);
#line 1238 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_notify_unref0 (_tmp6_);
#line 1241 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp7_ = self->priv->parameters;
#line 1241 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp8_ = _tmp7_.last_frame;
#line 1241 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!_tmp8_) {
#line 10934 "scanner.c"
		gint _tmp9_ = 0;
#line 1243 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp9_ = self->priv->pass_number;
#line 1243 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->pass_number = _tmp9_ + 1;
#line 1244 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1245 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1245 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 10946 "scanner.c"
	}
#line 1249 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp10_ = job;
#line 1249 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp11_ = _tmp10_->type;
#line 1249 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp11_ != SCAN_TYPE_SINGLE) {
#line 10954 "scanner.c"
		gint _tmp12_ = 0;
		ScanJob* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		NotifyPageDone* _tmp15_ = NULL;
		NotifyPageDone* _tmp16_ = NULL;
#line 1251 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp12_ = self->priv->page_number;
#line 1251 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->page_number = _tmp12_ + 1;
#line 1252 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->pass_number = 0;
#line 1253 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp13_ = job;
#line 1253 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp14_ = _tmp13_->id;
#line 1253 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp15_ = notify_page_done_new (_tmp14_);
#line 1253 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp16_ = _tmp15_;
#line 1253 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp16_);
#line 1253 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_notify_unref0 (_tmp16_);
#line 1254 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1255 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1255 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 10984 "scanner.c"
	}
#line 1258 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_do_complete_document (self);
#line 1234 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_scan_job_unref0 (job);
#line 10990 "scanner.c"
}


static void scanner_do_read (Scanner* self) {
	ScanJob* job = NULL;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	ScanJob* _tmp2_ = NULL;
	gint n_to_read = 0;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	SANE_Int n_read = {0};
	guchar* b = NULL;
	guchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	SANE_Status status = 0;
	SANE_Handle _tmp6_ = {0};
	guchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	SANE_Int _tmp10_ = {0};
	SANE_Status _tmp11_ = 0;
	gint _tmp12_ = 0;
	SANE_Status _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	SANE_Int _tmp16_ = {0};
	SANE_Status _tmp17_ = 0;
	SANE_Status _tmp29_ = 0;
	gboolean full_read = FALSE;
	gboolean _tmp34_ = FALSE;
	gint _tmp35_ = 0;
	gint _tmp38_ = 0;
	SANE_Int _tmp39_ = {0};
	gint _tmp40_ = 0;
	SANE_Parameters _tmp41_ = {0};
	gint _tmp42_ = 0;
#line 1261 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1263 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 1263 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 1263 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 1263 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	job = _tmp2_;
#line 1266 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = self->priv->buffer;
#line 1266 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3__length1 = self->priv->buffer_length1;
#line 1266 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = self->priv->n_used;
#line 1266 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	n_to_read = _tmp3__length1 - _tmp4_;
#line 1269 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = self->priv->buffer;
#line 1269 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5__length1 = self->priv->buffer_length1;
#line 1269 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	b = (guchar*) _tmp5_;
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp6_ = self->priv->handle;
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp7_ = b;
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp8_ = self->priv->n_used;
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp9_ = n_to_read;
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp11_ = sane_read (_tmp6_, (guint8*) (_tmp7_ + _tmp8_), (SANE_Int) _tmp9_, &_tmp10_);
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	n_read = _tmp10_;
#line 1270 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	status = _tmp11_;
#line 1271 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp12_ = n_to_read;
#line 1271 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp13_ = status;
#line 1271 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp14_ = sane_status_to_string (_tmp13_);
#line 1271 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp15_ = _tmp14_;
#line 1271 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp16_ = n_read;
#line 1271 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:1271: sane_read (%d) -> (%s, %d)", _tmp12_, _tmp15_, (gint) _tmp16_);
#line 1271 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp15_);
#line 1274 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp17_ = status;
#line 1274 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp17_ == SANE_STATUS_EOF) {
#line 11085 "scanner.c"
		gboolean _tmp18_ = FALSE;
		SANE_Parameters _tmp19_ = {0};
		gint _tmp20_ = 0;
		gint _tmp27_ = 0;
#line 1276 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp19_ = self->priv->parameters;
#line 1276 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp20_ = _tmp19_.lines;
#line 1276 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp20_ > 0) {
#line 11096 "scanner.c"
			gint _tmp21_ = 0;
			SANE_Parameters _tmp22_ = {0};
			gint _tmp23_ = 0;
#line 1276 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp21_ = self->priv->line_count;
#line 1276 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp22_ = self->priv->parameters;
#line 1276 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp23_ = _tmp22_.lines;
#line 1276 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp18_ = _tmp21_ != _tmp23_;
#line 11108 "scanner.c"
		} else {
#line 1276 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp18_ = FALSE;
#line 11112 "scanner.c"
		}
#line 1276 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp18_) {
#line 11116 "scanner.c"
			gint _tmp24_ = 0;
			SANE_Parameters _tmp25_ = {0};
			gint _tmp26_ = 0;
#line 1277 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp24_ = self->priv->line_count;
#line 1277 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp25_ = self->priv->parameters;
#line 1277 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp26_ = _tmp25_.lines;
#line 1277 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			g_warning ("scanner.vala:1277: Scan completed with %d lines, expected %d lines", _tmp24_, _tmp26_);
#line 11128 "scanner.c"
		}
#line 1278 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp27_ = self->priv->n_used;
#line 1278 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp27_ > 0) {
#line 11134 "scanner.c"
			gint _tmp28_ = 0;
#line 1279 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp28_ = self->priv->n_used;
#line 1279 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			g_warning ("scanner.vala:1279: Scan complete with %d bytes of unused data", _tmp28_);
#line 11140 "scanner.c"
		}
#line 1280 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_do_complete_page (self);
#line 1281 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1281 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 11148 "scanner.c"
	}
#line 1285 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp29_ = status;
#line 1285 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp29_ != SANE_STATUS_GOOD) {
#line 11154 "scanner.c"
		SANE_Status _tmp30_ = 0;
		const gchar* _tmp31_ = NULL;
		SANE_Status _tmp32_ = 0;
		const gchar* _tmp33_ = NULL;
#line 1287 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp30_ = status;
#line 1287 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp31_ = sane_strstatus (_tmp30_);
#line 1287 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_warning ("scanner.vala:1287: Unable to read frame from device: %s", _tmp31_);
#line 1288 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp32_ = status;
#line 1288 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp33_ = _ ("Error communicating with scanner");
#line 1288 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp32_, _tmp33_);
#line 1291 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1291 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 11175 "scanner.c"
	}
#line 1294 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	full_read = FALSE;
#line 1295 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp35_ = self->priv->n_used;
#line 1295 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp35_ == 0) {
#line 11183 "scanner.c"
		SANE_Int _tmp36_ = {0};
		guchar* _tmp37_ = NULL;
		gint _tmp37__length1 = 0;
#line 1295 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp36_ = n_read;
#line 1295 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp37_ = self->priv->buffer;
#line 1295 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp37__length1 = self->priv->buffer_length1;
#line 1295 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp34_ = _tmp36_ == ((SANE_Int) _tmp37__length1);
#line 11195 "scanner.c"
	} else {
#line 1295 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp34_ = FALSE;
#line 11199 "scanner.c"
	}
#line 1295 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp34_) {
#line 1296 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		full_read = TRUE;
#line 11205 "scanner.c"
	}
#line 1297 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp38_ = self->priv->n_used;
#line 1297 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp39_ = n_read;
#line 1297 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->n_used = _tmp38_ + ((gint) _tmp39_);
#line 1300 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp40_ = self->priv->n_used;
#line 1300 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp41_ = self->priv->parameters;
#line 1300 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp42_ = _tmp41_.bytes_per_line;
#line 1300 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp40_ >= _tmp42_) {
#line 11221 "scanner.c"
		ScanLine* line = NULL;
		ScanLine* _tmp43_ = NULL;
		SANE_Parameters _tmp44_ = {0};
		SANE_Frame _tmp45_ = 0;
		ScanLine* _tmp51_ = NULL;
		SANE_Parameters _tmp52_ = {0};
		gint _tmp53_ = 0;
		ScanLine* _tmp54_ = NULL;
		SANE_Parameters _tmp55_ = {0};
		gint _tmp56_ = 0;
		ScanLine* _tmp57_ = NULL;
		guchar* _tmp58_ = NULL;
		gint _tmp58__length1 = 0;
		ScanLine* _tmp59_ = NULL;
		SANE_Parameters _tmp60_ = {0};
		gint _tmp61_ = 0;
		ScanLine* _tmp62_ = NULL;
		gint _tmp63_ = 0;
		ScanLine* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		ScanLine* _tmp66_ = NULL;
		gint _tmp67_ = 0;
		gint _tmp68_ = 0;
		ScanLine* _tmp69_ = NULL;
		gint _tmp70_ = 0;
		gint buffer_size = 0;
		ScanLine* _tmp71_ = NULL;
		guchar* _tmp72_ = NULL;
		gint _tmp72__length1 = 0;
		gboolean _tmp73_ = FALSE;
		gint _tmp77_ = 0;
		guchar* _tmp78_ = NULL;
		gint n_remaining = 0;
		gint _tmp79_ = 0;
		ScanLine* _tmp80_ = NULL;
		gint _tmp81_ = 0;
		ScanLine* _tmp82_ = NULL;
		gint _tmp83_ = 0;
		gboolean _tmp100_ = FALSE;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		SANE_Parameters _tmp103_ = {0};
		gint _tmp104_ = 0;
		ScanJob* _tmp153_ = NULL;
		gint _tmp154_ = 0;
		ScanLine* _tmp155_ = NULL;
		NotifyGotLine* _tmp156_ = NULL;
		NotifyGotLine* _tmp157_ = NULL;
#line 1302 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp43_ = scan_line_new ();
#line 1302 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		line = _tmp43_;
#line 1303 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp44_ = self->priv->parameters;
#line 1303 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp45_ = _tmp44_.format;
#line 1303 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		switch (_tmp45_) {
#line 1303 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			case SANE_FRAME_GRAY:
#line 11282 "scanner.c"
			{
				ScanLine* _tmp46_ = NULL;
#line 1306 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp46_ = line;
#line 1306 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp46_->channel = 0;
#line 1307 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				break;
#line 11291 "scanner.c"
			}
#line 1303 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			case SANE_FRAME_RGB:
#line 11295 "scanner.c"
			{
				ScanLine* _tmp47_ = NULL;
#line 1309 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp47_ = line;
#line 1309 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp47_->channel = -1;
#line 1310 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				break;
#line 11304 "scanner.c"
			}
#line 1303 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			case SANE_FRAME_RED:
#line 11308 "scanner.c"
			{
				ScanLine* _tmp48_ = NULL;
#line 1312 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp48_ = line;
#line 1312 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp48_->channel = 0;
#line 1313 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				break;
#line 11317 "scanner.c"
			}
#line 1303 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			case SANE_FRAME_GREEN:
#line 11321 "scanner.c"
			{
				ScanLine* _tmp49_ = NULL;
#line 1315 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp49_ = line;
#line 1315 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp49_->channel = 1;
#line 1316 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				break;
#line 11330 "scanner.c"
			}
#line 1303 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			case SANE_FRAME_BLUE:
#line 11334 "scanner.c"
			{
				ScanLine* _tmp50_ = NULL;
#line 1318 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp50_ = line;
#line 1318 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp50_->channel = 2;
#line 1319 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				break;
#line 11343 "scanner.c"
			}
			default:
#line 1303 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 11348 "scanner.c"
		}
#line 1321 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp51_ = line;
#line 1321 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp52_ = self->priv->parameters;
#line 1321 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp53_ = _tmp52_.pixels_per_line;
#line 1321 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp51_->width = _tmp53_;
#line 1322 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp54_ = line;
#line 1322 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp55_ = self->priv->parameters;
#line 1322 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp56_ = _tmp55_.depth;
#line 1322 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp54_->depth = _tmp56_;
#line 1323 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp57_ = line;
#line 1323 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp58_ = self->priv->buffer;
#line 1323 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp58__length1 = self->priv->buffer_length1;
#line 1323 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->buffer = NULL;
#line 1323 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->buffer_length1 = 0;
#line 1323 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp57_->data = (g_free (_tmp57_->data), NULL);
#line 1323 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp57_->data = _tmp58_;
#line 1323 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp57_->data_length1 = _tmp58__length1;
#line 1324 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp59_ = line;
#line 1324 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp60_ = self->priv->parameters;
#line 1324 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp61_ = _tmp60_.bytes_per_line;
#line 1324 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp59_->data_length = _tmp61_;
#line 1325 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp62_ = line;
#line 1325 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp63_ = self->priv->line_count;
#line 1325 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp62_->number = _tmp63_;
#line 1326 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp64_ = line;
#line 1326 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp65_ = self->priv->n_used;
#line 1326 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp66_ = line;
#line 1326 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp67_ = _tmp66_->data_length;
#line 1326 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp64_->n_lines = _tmp65_ / _tmp67_;
#line 1328 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp68_ = self->priv->line_count;
#line 1328 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp69_ = line;
#line 1328 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp70_ = _tmp69_->n_lines;
#line 1328 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->line_count = _tmp68_ + _tmp70_;
#line 1331 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp71_ = line;
#line 1331 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp72_ = _tmp71_->data;
#line 1331 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp72__length1 = _tmp71_->data_length1;
#line 1331 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		buffer_size = _tmp72__length1;
#line 1332 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp73_ = full_read;
#line 1332 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp73_) {
#line 11426 "scanner.c"
			gint _tmp74_ = 0;
			SANE_Parameters _tmp75_ = {0};
			gint _tmp76_ = 0;
#line 1333 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp74_ = buffer_size;
#line 1333 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp75_ = self->priv->parameters;
#line 1333 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp76_ = _tmp75_.bytes_per_line;
#line 1333 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			buffer_size = _tmp74_ + _tmp76_;
#line 11438 "scanner.c"
		}
#line 1335 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp77_ = buffer_size;
#line 1335 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp78_ = g_new0 (guchar, _tmp77_);
#line 1335 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 1335 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->buffer = _tmp78_;
#line 1335 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->buffer_length1 = _tmp77_;
#line 1335 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 1336 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp79_ = self->priv->n_used;
#line 1336 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp80_ = line;
#line 1336 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp81_ = _tmp80_->n_lines;
#line 1336 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp82_ = line;
#line 1336 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp83_ = _tmp82_->data_length;
#line 1336 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		n_remaining = _tmp79_ - (_tmp81_ * _tmp83_);
#line 1337 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->n_used = 0;
#line 11466 "scanner.c"
		{
			gint i = 0;
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			i = 0;
#line 11471 "scanner.c"
			{
				gboolean _tmp84_ = FALSE;
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp84_ = TRUE;
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				while (TRUE) {
#line 11478 "scanner.c"
					gint _tmp86_ = 0;
					gint _tmp87_ = 0;
					guchar* _tmp88_ = NULL;
					gint _tmp88__length1 = 0;
					gint _tmp89_ = 0;
					ScanLine* _tmp90_ = NULL;
					guchar* _tmp91_ = NULL;
					gint _tmp91__length1 = 0;
					gint _tmp92_ = 0;
					ScanLine* _tmp93_ = NULL;
					gint _tmp94_ = 0;
					ScanLine* _tmp95_ = NULL;
					gint _tmp96_ = 0;
					guchar _tmp97_ = '\0';
					guchar _tmp98_ = '\0';
					gint _tmp99_ = 0;
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					if (!_tmp84_) {
#line 11497 "scanner.c"
						gint _tmp85_ = 0;
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp85_ = i;
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						i = _tmp85_ + 1;
#line 11503 "scanner.c"
					}
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp84_ = FALSE;
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp86_ = i;
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp87_ = n_remaining;
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					if (!(_tmp86_ < _tmp87_)) {
#line 1338 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						break;
#line 11515 "scanner.c"
					}
#line 1340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp88_ = self->priv->buffer;
#line 1340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp88__length1 = self->priv->buffer_length1;
#line 1340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp89_ = i;
#line 1340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp90_ = line;
#line 1340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp91_ = _tmp90_->data;
#line 1340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp91__length1 = _tmp90_->data_length1;
#line 1340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp92_ = i;
#line 1340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp93_ = line;
#line 1340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp94_ = _tmp93_->n_lines;
#line 1340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp95_ = line;
#line 1340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp96_ = _tmp95_->data_length;
#line 1340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp97_ = _tmp91_[_tmp92_ + (_tmp94_ * _tmp96_)];
#line 1340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp88_[_tmp89_] = _tmp97_;
#line 1340 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp98_ = _tmp88_[_tmp89_];
#line 1341 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp99_ = self->priv->n_used;
#line 1341 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					self->priv->n_used = _tmp99_ + 1;
#line 11549 "scanner.c"
				}
			}
		}
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp103_ = self->priv->parameters;
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp104_ = _tmp103_.depth;
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp104_ == 8) {
#line 11559 "scanner.c"
			SANE_Parameters _tmp105_ = {0};
			SANE_Frame _tmp106_ = 0;
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp105_ = self->priv->parameters;
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp106_ = _tmp105_.format;
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp102_ = _tmp106_ == SANE_FRAME_GRAY;
#line 11568 "scanner.c"
		} else {
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp102_ = FALSE;
#line 11572 "scanner.c"
		}
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp102_) {
#line 11576 "scanner.c"
			ScanJob* _tmp107_ = NULL;
			gint _tmp108_ = 0;
#line 1347 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp107_ = job;
#line 1347 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp108_ = _tmp107_->depth;
#line 1347 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp101_ = _tmp108_ == 2;
#line 11585 "scanner.c"
		} else {
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp101_ = FALSE;
#line 11589 "scanner.c"
		}
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp101_) {
#line 11593 "scanner.c"
			ScanJob* _tmp109_ = NULL;
			ScanMode _tmp110_ = 0;
#line 1347 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp109_ = job;
#line 1347 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp110_ = _tmp109_->scan_mode;
#line 1347 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp100_ = _tmp110_ == SCAN_MODE_GRAY;
#line 11602 "scanner.c"
		} else {
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp100_ = FALSE;
#line 11606 "scanner.c"
		}
#line 1346 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_tmp100_) {
#line 11610 "scanner.c"
			guchar block = '\0';
			gint write_offset = 0;
			gint block_shift = 0;
			ScanLine* _tmp150_ = NULL;
			ScanLine* _tmp151_ = NULL;
			gint _tmp152_ = 0;
#line 1349 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			block = (guchar) 0;
#line 1350 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			write_offset = 0;
#line 1351 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			block_shift = 6;
#line 11623 "scanner.c"
			{
				gint i = 0;
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				i = 0;
#line 11628 "scanner.c"
				{
					gboolean _tmp111_ = FALSE;
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					_tmp111_ = TRUE;
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					while (TRUE) {
#line 11635 "scanner.c"
						gint _tmp113_ = 0;
						ScanLine* _tmp114_ = NULL;
						gint _tmp115_ = 0;
						gint offset = 0;
						gint _tmp116_ = 0;
						ScanLine* _tmp117_ = NULL;
						gint _tmp118_ = 0;
						gint _tmp143_ = 0;
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!_tmp111_) {
#line 11646 "scanner.c"
							gint _tmp112_ = 0;
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp112_ = i;
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							i = _tmp112_ + 1;
#line 11652 "scanner.c"
						}
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp111_ = FALSE;
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp113_ = i;
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp114_ = line;
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp115_ = _tmp114_->n_lines;
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (!(_tmp113_ < _tmp115_)) {
#line 1352 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							break;
#line 11666 "scanner.c"
						}
#line 1354 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp116_ = i;
#line 1354 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp117_ = line;
#line 1354 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp118_ = _tmp117_->data_length;
#line 1354 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						offset = _tmp116_ * _tmp118_;
#line 11676 "scanner.c"
						{
							gint x = 0;
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							x = 0;
#line 11681 "scanner.c"
							{
								gboolean _tmp119_ = FALSE;
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
								_tmp119_ = TRUE;
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
								while (TRUE) {
#line 11688 "scanner.c"
									gint _tmp121_ = 0;
									ScanLine* _tmp122_ = NULL;
									gint _tmp123_ = 0;
									guchar p = '\0';
									ScanLine* _tmp124_ = NULL;
									guchar* _tmp125_ = NULL;
									gint _tmp125__length1 = 0;
									gint _tmp126_ = 0;
									gint _tmp127_ = 0;
									guchar _tmp128_ = '\0';
									guchar sample = '\0';
									guchar _tmp129_ = '\0';
									guchar _tmp132_ = '\0';
									guchar _tmp133_ = '\0';
									gint _tmp134_ = 0;
									gint _tmp135_ = 0;
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									if (!_tmp119_) {
#line 11707 "scanner.c"
										gint _tmp120_ = 0;
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										_tmp120_ = x;
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										x = _tmp120_ + 1;
#line 11713 "scanner.c"
									}
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp119_ = FALSE;
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp121_ = x;
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp122_ = line;
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp123_ = _tmp122_->width;
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									if (!(_tmp121_ < _tmp123_)) {
#line 1355 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										break;
#line 11727 "scanner.c"
									}
#line 1357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp124_ = line;
#line 1357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp125_ = _tmp124_->data;
#line 1357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp125__length1 = _tmp124_->data_length1;
#line 1357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp126_ = offset;
#line 1357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp127_ = x;
#line 1357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp128_ = _tmp125_[_tmp126_ + _tmp127_];
#line 1357 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									p = _tmp128_;
#line 1360 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp129_ = p;
#line 1360 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									if (((gint) _tmp129_) >= 192) {
#line 1361 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										sample = (guchar) 3;
#line 11749 "scanner.c"
									} else {
										guchar _tmp130_ = '\0';
#line 1362 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										_tmp130_ = p;
#line 1362 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										if (((gint) _tmp130_) >= 128) {
#line 1363 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
											sample = (guchar) 2;
#line 11758 "scanner.c"
										} else {
											guchar _tmp131_ = '\0';
#line 1364 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
											_tmp131_ = p;
#line 1364 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
											if (((gint) _tmp131_) >= 64) {
#line 1365 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
												sample = (guchar) 1;
#line 11767 "scanner.c"
											} else {
#line 1367 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
												sample = (guchar) 0;
#line 11771 "scanner.c"
											}
										}
									}
#line 1369 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp132_ = block;
#line 1369 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp133_ = sample;
#line 1369 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp134_ = block_shift;
#line 1369 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									block = _tmp132_ | (_tmp133_ << _tmp134_);
#line 1370 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									_tmp135_ = block_shift;
#line 1370 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
									if (_tmp135_ == 0) {
#line 11787 "scanner.c"
										ScanLine* _tmp136_ = NULL;
										guchar* _tmp137_ = NULL;
										gint _tmp137__length1 = 0;
										gint _tmp138_ = 0;
										guchar _tmp139_ = '\0';
										guchar _tmp140_ = '\0';
										gint _tmp141_ = 0;
#line 1372 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										_tmp136_ = line;
#line 1372 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										_tmp137_ = _tmp136_->data;
#line 1372 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										_tmp137__length1 = _tmp136_->data_length1;
#line 1372 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										_tmp138_ = write_offset;
#line 1372 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										_tmp139_ = block;
#line 1372 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										_tmp137_[_tmp138_] = _tmp139_;
#line 1372 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										_tmp140_ = _tmp137_[_tmp138_];
#line 1373 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										_tmp141_ = write_offset;
#line 1373 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										write_offset = _tmp141_ + 1;
#line 1374 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										block = (guchar) 0;
#line 1375 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										block_shift = 6;
#line 11817 "scanner.c"
									} else {
										gint _tmp142_ = 0;
#line 1378 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										_tmp142_ = block_shift;
#line 1378 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
										block_shift = _tmp142_ - 2;
#line 11824 "scanner.c"
									}
								}
							}
						}
#line 1382 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						_tmp143_ = block_shift;
#line 1382 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
						if (_tmp143_ != 6) {
#line 11833 "scanner.c"
							ScanLine* _tmp144_ = NULL;
							guchar* _tmp145_ = NULL;
							gint _tmp145__length1 = 0;
							gint _tmp146_ = 0;
							guchar _tmp147_ = '\0';
							guchar _tmp148_ = '\0';
							gint _tmp149_ = 0;
#line 1384 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp144_ = line;
#line 1384 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp145_ = _tmp144_->data;
#line 1384 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp145__length1 = _tmp144_->data_length1;
#line 1384 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp146_ = write_offset;
#line 1384 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp147_ = block;
#line 1384 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp145_[_tmp146_] = _tmp147_;
#line 1384 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp148_ = _tmp145_[_tmp146_];
#line 1385 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							_tmp149_ = write_offset;
#line 1385 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							write_offset = _tmp149_ + 1;
#line 1386 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							block = (guchar) 0;
#line 1387 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
							block_shift = 6;
#line 11863 "scanner.c"
						}
					}
				}
			}
#line 1391 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp150_ = line;
#line 1391 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp151_ = line;
#line 1391 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp152_ = _tmp151_->width;
#line 1391 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp150_->data_length = ((_tmp152_ * 2) + 7) / 8;
#line 11876 "scanner.c"
		}
#line 1394 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp153_ = job;
#line 1394 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp154_ = _tmp153_->id;
#line 1394 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp155_ = line;
#line 1394 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp156_ = notify_got_line_new (_tmp154_, _tmp155_);
#line 1394 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp157_ = _tmp156_;
#line 1394 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp157_);
#line 1394 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_notify_unref0 (_tmp157_);
#line 1300 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_scan_line_unref0 (line);
#line 11894 "scanner.c"
	}
#line 1261 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_scan_job_unref0 (job);
#line 11898 "scanner.c"
}


static void _scanner_authorization_cb_sane_authcallback (const gchar* resource, gchar* username, gchar* password) {
#line 1403 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_authorization_cb (resource, username, -1, password, -1);
#line 11905 "scanner.c"
}


static void* scanner_scan_thread (Scanner* self) {
	void* result = NULL;
	SANE_Int version_code = {0};
	SANE_Status status = 0;
	SANE_Int _tmp0_ = {0};
	SANE_Status _tmp1_ = 0;
	SANE_Status _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SANE_Status _tmp5_ = 0;
	SANE_Int _tmp8_ = {0};
	gint _tmp9_ = 0;
	SANE_Int _tmp10_ = {0};
	gint _tmp11_ = 0;
	SANE_Int _tmp12_ = {0};
	gint _tmp13_ = 0;
#line 1398 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1400 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 1403 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = sane_init (&_tmp0_, _scanner_authorization_cb_sane_authcallback);
#line 1403 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	version_code = _tmp0_;
#line 1403 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	status = _tmp1_;
#line 1404 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = status;
#line 1404 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = sane_status_to_string (_tmp2_);
#line 1404 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 1404 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:1404: sane_init () -> %s", _tmp4_);
#line 1404 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp4_);
#line 1405 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = status;
#line 1405 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp5_ != SANE_STATUS_GOOD) {
#line 11949 "scanner.c"
		SANE_Status _tmp6_ = 0;
		const gchar* _tmp7_ = NULL;
#line 1407 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp6_ = status;
#line 1407 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp7_ = sane_strstatus (_tmp6_);
#line 1407 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_warning ("scanner.vala:1407: Unable to initialize SANE backend: %s", _tmp7_);
#line 1408 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		result = NULL;
#line 1408 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return result;
#line 11962 "scanner.c"
	}
#line 1410 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp8_ = version_code;
#line 1410 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp9_ = SANE_VERSION_MAJOR (_tmp8_);
#line 1410 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp10_ = version_code;
#line 1410 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp11_ = SANE_VERSION_MINOR (_tmp10_);
#line 1410 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp12_ = version_code;
#line 1410 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp13_ = SANE_VERSION_BUILD (_tmp12_);
#line 1410 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:1410: SANE version %d.%d.%d", _tmp9_, _tmp11_, _tmp13_);
#line 1416 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_redetect (self);
#line 1418 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	while (TRUE) {
#line 11982 "scanner.c"
		gboolean _tmp14_ = FALSE;
		ScanState _tmp15_ = 0;
#line 1418 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp14_ = scanner_handle_requests (self);
#line 1418 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (!_tmp14_) {
#line 1418 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 11991 "scanner.c"
		}
#line 1420 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp15_ = self->priv->state;
#line 1420 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		switch (_tmp15_) {
#line 1420 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			case SCAN_STATE_IDLE:
#line 11999 "scanner.c"
			{
				GList* _tmp16_ = NULL;
#line 1423 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				_tmp16_ = self->priv->job_queue;
#line 1423 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				if (_tmp16_ != NULL) {
#line 1425 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					scanner_set_scanning (self, TRUE);
#line 1426 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
					self->priv->state = SCAN_STATE_OPEN;
#line 12010 "scanner.c"
				}
#line 1428 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				break;
#line 12014 "scanner.c"
			}
#line 1420 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			case SCAN_STATE_REDETECT:
#line 12018 "scanner.c"
			{
#line 1430 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_do_redetect (self);
#line 1431 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				break;
#line 12024 "scanner.c"
			}
#line 1420 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			case SCAN_STATE_OPEN:
#line 12028 "scanner.c"
			{
#line 1433 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_do_open (self);
#line 1434 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				break;
#line 12034 "scanner.c"
			}
#line 1420 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			case SCAN_STATE_GET_OPTION:
#line 12038 "scanner.c"
			{
#line 1436 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_do_get_option (self);
#line 1437 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				break;
#line 12044 "scanner.c"
			}
#line 1420 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			case SCAN_STATE_START:
#line 12048 "scanner.c"
			{
#line 1439 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_do_start (self);
#line 1440 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				break;
#line 12054 "scanner.c"
			}
#line 1420 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			case SCAN_STATE_GET_PARAMETERS:
#line 12058 "scanner.c"
			{
#line 1442 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_do_get_parameters (self);
#line 1443 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				break;
#line 12064 "scanner.c"
			}
#line 1420 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			case SCAN_STATE_READ:
#line 12068 "scanner.c"
			{
#line 1445 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				scanner_do_read (self);
#line 1446 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
				break;
#line 12074 "scanner.c"
			}
			default:
#line 1420 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			break;
#line 12079 "scanner.c"
		}
	}
#line 1450 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	result = NULL;
#line 1450 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return result;
#line 12086 "scanner.c"
}


static gpointer _scanner_scan_thread_gthread_func (gpointer self) {
	gpointer result;
	result = scanner_scan_thread ((Scanner*) self);
#line 1457 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_unref (self);
#line 1457 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return result;
#line 12097 "scanner.c"
}


void scanner_start (Scanner* self) {
	GError * _inner_error_ = NULL;
#line 1453 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 12105 "scanner.c"
	{
		GThread* _tmp0_ = NULL;
		GThread* _tmp1_ = NULL;
		GThread* _tmp2_ = NULL;
#line 1457 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp1_ = g_thread_try_new ("scan-thread", _scanner_scan_thread_gthread_func, scanner_ref (self), &_inner_error_);
#line 1457 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp0_ = _tmp1_;
#line 1457 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (_inner_error_ != NULL) {
#line 12116 "scanner.c"
			goto __catch14_g_error;
		}
#line 1457 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp2_ = _tmp0_;
#line 1457 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp0_ = NULL;
#line 1457 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_thread_unref0 (self->priv->thread);
#line 1457 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->thread = _tmp2_;
#line 1455 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_thread_unref0 (_tmp0_);
#line 12129 "scanner.c"
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 1455 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		e = _inner_error_;
#line 1455 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_inner_error_ = NULL;
#line 1461 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp3_ = e;
#line 1461 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp4_ = _tmp3_->message;
#line 1461 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_critical ("scanner.vala:1461: Unable to create thread: %s", _tmp4_);
#line 1455 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_error_free0 (e);
#line 12149 "scanner.c"
	}
	__finally14:
#line 1455 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_inner_error_ != NULL) {
#line 1455 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1455 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_clear_error (&_inner_error_);
#line 1455 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 12160 "scanner.c"
	}
}


void scanner_redetect (Scanner* self) {
	gboolean _tmp0_ = FALSE;
	GAsyncQueue* _tmp1_ = NULL;
	RequestRedetect* _tmp2_ = NULL;
#line 1465 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1467 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = self->priv->need_redetect;
#line 1467 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp0_) {
#line 1468 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return;
#line 12177 "scanner.c"
	}
#line 1469 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->need_redetect = TRUE;
#line 1471 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:1471: Requesting redetection of scan devices");
#line 1473 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = self->priv->request_queue;
#line 1473 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = request_redetect_new ();
#line 1473 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_async_queue_push (_tmp1_, (Request*) _tmp2_);
#line 12189 "scanner.c"
}


gboolean scanner_is_scanning (Scanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1476 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1478 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = self->priv->scanning;
#line 1478 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	result = _tmp0_;
#line 1478 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return result;
#line 12204 "scanner.c"
}


static gchar* scanner_get_scan_mode_string (Scanner* self, ScanMode mode) {
	gchar* result = NULL;
	ScanMode _tmp0_ = 0;
#line 1481 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1483 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = mode;
#line 1483 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	switch (_tmp0_) {
#line 1483 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SCAN_MODE_DEFAULT:
#line 12219 "scanner.c"
		{
			gchar* _tmp1_ = NULL;
#line 1486 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp1_ = g_strdup ("ScanMode.DEFAULT");
#line 1486 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			result = _tmp1_;
#line 1486 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return result;
#line 12228 "scanner.c"
		}
#line 1483 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SCAN_MODE_COLOR:
#line 12232 "scanner.c"
		{
			gchar* _tmp2_ = NULL;
#line 1488 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp2_ = g_strdup ("ScanMode.COLOR");
#line 1488 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			result = _tmp2_;
#line 1488 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return result;
#line 12241 "scanner.c"
		}
#line 1483 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SCAN_MODE_GRAY:
#line 12245 "scanner.c"
		{
			gchar* _tmp3_ = NULL;
#line 1490 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp3_ = g_strdup ("ScanMode.GRAY");
#line 1490 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			result = _tmp3_;
#line 1490 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return result;
#line 12254 "scanner.c"
		}
#line 1483 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SCAN_MODE_LINEART:
#line 12258 "scanner.c"
		{
			gchar* _tmp4_ = NULL;
#line 1492 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp4_ = g_strdup ("ScanMode.LINEART");
#line 1492 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			result = _tmp4_;
#line 1492 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return result;
#line 12267 "scanner.c"
		}
		default:
		{
			ScanMode _tmp5_ = 0;
			gchar* _tmp6_ = NULL;
#line 1494 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp5_ = mode;
#line 1494 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp6_ = g_strdup_printf ("%d", (gint) _tmp5_);
#line 1494 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			result = _tmp6_;
#line 1494 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return result;
#line 12281 "scanner.c"
		}
	}
}


static gchar* scanner_get_scan_type_string (Scanner* self, ScanType type) {
	gchar* result = NULL;
	ScanType _tmp0_ = 0;
#line 1498 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1500 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = type;
#line 1500 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	switch (_tmp0_) {
#line 1500 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SCAN_TYPE_SINGLE:
#line 12298 "scanner.c"
		{
			gchar* _tmp1_ = NULL;
#line 1503 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp1_ = g_strdup ("ScanType.SINGLE");
#line 1503 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			result = _tmp1_;
#line 1503 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return result;
#line 12307 "scanner.c"
		}
#line 1500 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SCAN_TYPE_ADF_FRONT:
#line 12311 "scanner.c"
		{
			gchar* _tmp2_ = NULL;
#line 1505 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp2_ = g_strdup ("ScanType.ADF_FRONT");
#line 1505 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			result = _tmp2_;
#line 1505 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return result;
#line 12320 "scanner.c"
		}
#line 1500 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SCAN_TYPE_ADF_BACK:
#line 12324 "scanner.c"
		{
			gchar* _tmp3_ = NULL;
#line 1507 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp3_ = g_strdup ("ScanType.ADF_BACK");
#line 1507 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			result = _tmp3_;
#line 1507 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return result;
#line 12333 "scanner.c"
		}
#line 1500 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		case SCAN_TYPE_ADF_BOTH:
#line 12337 "scanner.c"
		{
			gchar* _tmp4_ = NULL;
#line 1509 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp4_ = g_strdup ("ScanType.ADF_BOTH");
#line 1509 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			result = _tmp4_;
#line 1509 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return result;
#line 12346 "scanner.c"
		}
		default:
		{
			ScanType _tmp5_ = 0;
			gchar* _tmp6_ = NULL;
#line 1511 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp5_ = type;
#line 1511 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			_tmp6_ = g_strdup_printf ("%d", (gint) _tmp5_);
#line 1511 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			result = _tmp6_;
#line 1511 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return result;
#line 12360 "scanner.c"
		}
	}
}


void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ScanOptions* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	ScanOptions* _tmp5_ = NULL;
	ScanMode _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	ScanOptions* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	ScanOptions* _tmp11_ = NULL;
	ScanType _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	ScanOptions* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	ScanOptions* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	RequestStartScan* request = NULL;
	RequestStartScan* _tmp19_ = NULL;
	ScanJob* _tmp20_ = NULL;
	ScanJob* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	ScanJob* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	ScanJob* _tmp26_ = NULL;
	ScanOptions* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	ScanJob* _tmp29_ = NULL;
	ScanOptions* _tmp30_ = NULL;
	ScanMode _tmp31_ = 0;
	ScanJob* _tmp32_ = NULL;
	ScanOptions* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	ScanJob* _tmp35_ = NULL;
	ScanOptions* _tmp36_ = NULL;
	ScanType _tmp37_ = 0;
	ScanJob* _tmp38_ = NULL;
	ScanOptions* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	ScanJob* _tmp41_ = NULL;
	ScanOptions* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	GAsyncQueue* _tmp44_ = NULL;
	Request* _tmp45_ = NULL;
#line 1515 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1515 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (options != NULL);
#line 1518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = device;
#line 1518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp1_ != NULL) {
#line 12421 "scanner.c"
		const gchar* _tmp2_ = NULL;
#line 1518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp2_ = device;
#line 1518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp0_ = _tmp2_;
#line 12427 "scanner.c"
	} else {
#line 1518 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp0_ = "(null)";
#line 12431 "scanner.c"
	}
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp3_ = options;
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp4_ = _tmp3_->dpi;
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp5_ = options;
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp6_ = _tmp5_->scan_mode;
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp7_ = scanner_get_scan_mode_string (self, _tmp6_);
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp8_ = _tmp7_;
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp9_ = options;
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp10_ = _tmp9_->depth;
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp11_ = options;
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp12_ = _tmp11_->type;
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp13_ = scanner_get_scan_type_string (self, _tmp12_);
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp14_ = _tmp13_;
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp15_ = options;
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp16_ = _tmp15_->paper_width;
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp17_ = options;
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp18_ = _tmp17_->paper_height;
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:1517: Scanner.scan (\"%s\", dpi=%d, scan_mode=%s, depth=%" \
"d, type=%s, paper_width=%d, paper_height=%d)", _tmp0_, _tmp4_, _tmp8_, _tmp10_, _tmp14_, _tmp16_, _tmp18_);
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp14_);
#line 1517 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp8_);
#line 1520 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp19_ = request_start_scan_new ();
#line 1520 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	request = _tmp19_;
#line 1521 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp20_ = scan_job_new ();
#line 1521 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_scan_job_unref0 (request->job);
#line 1521 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	request->job = _tmp20_;
#line 1522 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp21_ = request->job;
#line 1522 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp22_ = self->job_id;
#line 1522 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->job_id = _tmp22_ + 1;
#line 1522 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp21_->id = _tmp22_;
#line 1523 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp23_ = request->job;
#line 1523 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp24_ = device;
#line 1523 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp25_ = g_strdup (_tmp24_);
#line 1523 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (_tmp23_->device);
#line 1523 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp23_->device = _tmp25_;
#line 1524 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp26_ = request->job;
#line 1524 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp27_ = options;
#line 1524 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp28_ = _tmp27_->dpi;
#line 1524 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp26_->dpi = (gdouble) _tmp28_;
#line 1525 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp29_ = request->job;
#line 1525 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp30_ = options;
#line 1525 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp31_ = _tmp30_->scan_mode;
#line 1525 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp29_->scan_mode = _tmp31_;
#line 1526 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp32_ = request->job;
#line 1526 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp33_ = options;
#line 1526 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp34_ = _tmp33_->depth;
#line 1526 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp32_->depth = _tmp34_;
#line 1527 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp35_ = request->job;
#line 1527 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp36_ = options;
#line 1527 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp37_ = _tmp36_->type;
#line 1527 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp35_->type = _tmp37_;
#line 1528 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp38_ = request->job;
#line 1528 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp39_ = options;
#line 1528 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp40_ = _tmp39_->paper_width;
#line 1528 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp38_->page_width = _tmp40_;
#line 1529 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp41_ = request->job;
#line 1529 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp42_ = options;
#line 1529 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp43_ = _tmp42_->paper_height;
#line 1529 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp41_->page_height = _tmp43_;
#line 1530 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp44_ = self->priv->request_queue;
#line 1530 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp45_ = _request_ref0 ((Request*) request);
#line 1530 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_async_queue_push (_tmp44_, _tmp45_);
#line 1515 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_request_unref0 (request);
#line 12555 "scanner.c"
}


void scanner_cancel (Scanner* self) {
	gint _tmp0_ = 0;
	GAsyncQueue* _tmp1_ = NULL;
	RequestCancel* _tmp2_ = NULL;
#line 1533 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1535 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = self->job_id;
#line 1535 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->first_job_id = _tmp0_;
#line 1536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = self->priv->request_queue;
#line 1536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = request_cancel_new ();
#line 1536 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_async_queue_push (_tmp1_, (Request*) _tmp2_);
#line 12575 "scanner.c"
}


static gpointer _g_thread_ref0 (gpointer self) {
#line 1547 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return self ? g_thread_ref (self) : NULL;
#line 12582 "scanner.c"
}


void scanner_free (Scanner* self) {
	GAsyncQueue* _tmp0_ = NULL;
	RequestQuit* _tmp1_ = NULL;
	GThread* _tmp2_ = NULL;
#line 1539 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1541 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:1541: Stopping scan thread");
#line 1543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp0_ = self->priv->request_queue;
#line 1543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp1_ = request_quit_new ();
#line 1543 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_async_queue_push (_tmp0_, (Request*) _tmp1_);
#line 1545 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_tmp2_ = self->priv->thread;
#line 1545 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (_tmp2_ != NULL) {
#line 12604 "scanner.c"
		GThread* _tmp3_ = NULL;
		GThread* _tmp4_ = NULL;
#line 1547 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp3_ = self->priv->thread;
#line 1547 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_tmp4_ = _g_thread_ref0 (_tmp3_);
#line 1547 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_thread_join (_tmp4_);
#line 1548 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		_g_thread_unref0 (self->priv->thread);
#line 1548 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		self->priv->thread = NULL;
#line 12617 "scanner.c"
	}
#line 1551 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	sane_exit ();
#line 1552 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_debug ("scanner.vala:1552: sane_exit ()");
#line 12623 "scanner.c"
}


static void g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__SCAN_PAGE_INFO) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__SCAN_PAGE_INFO callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (n_param_values == 2);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		data1 = closure->data;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 12642 "scanner.c"
	} else {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		data2 = closure->data;
#line 12648 "scanner.c"
	}
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	callback = (GMarshalFunc_VOID__SCAN_PAGE_INFO) (marshal_data ? marshal_data : cc->callback);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	callback (data1, value_get_scan_page_info (param_values + 1), data2);
#line 12654 "scanner.c"
}


static void g_cclosure_user_marshal_VOID__SCAN_LINE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__SCAN_LINE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__SCAN_LINE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (n_param_values == 2);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		data1 = closure->data;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 12673 "scanner.c"
	} else {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		data2 = closure->data;
#line 12679 "scanner.c"
	}
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	callback = (GMarshalFunc_VOID__SCAN_LINE) (marshal_data ? marshal_data : cc->callback);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	callback (data1, value_get_scan_line (param_values + 1), data2);
#line 12685 "scanner.c"
}


static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (n_param_values == 3);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		data1 = closure->data;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 12704 "scanner.c"
	} else {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		data2 = closure->data;
#line 12710 "scanner.c"
	}
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	callback = (GMarshalFunc_VOID__INT_STRING) (marshal_data ? marshal_data : cc->callback);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 12716 "scanner.c"
}


static void value_scanner_init (GValue* value) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 12723 "scanner.c"
}


static void value_scanner_free_value (GValue* value) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_unref (value->data[0].v_pointer);
#line 12732 "scanner.c"
	}
}


static void value_scanner_copy_value (const GValue* src_value, GValue* dest_value) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = scanner_ref (src_value->data[0].v_pointer);
#line 12742 "scanner.c"
	} else {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 12746 "scanner.c"
	}
}


static gpointer value_scanner_peek_pointer (const GValue* value) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 12754 "scanner.c"
}


static gchar* value_scanner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 12761 "scanner.c"
		Scanner* object;
		object = collect_values[0].v_pointer;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 12768 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 12772 "scanner.c"
		}
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = scanner_ref (object);
#line 12776 "scanner.c"
	} else {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 12780 "scanner.c"
	}
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 12784 "scanner.c"
}


static gchar* value_scanner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Scanner** object_p;
	object_p = collect_values[0].v_pointer;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!object_p) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 12795 "scanner.c"
	}
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = NULL;
#line 12801 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 12805 "scanner.c"
	} else {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		*object_p = scanner_ref (value->data[0].v_pointer);
#line 12809 "scanner.c"
	}
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return NULL;
#line 12813 "scanner.c"
}


GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanner* spec;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCANNER), NULL);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 12827 "scanner.c"
}


gpointer value_get_scanner (const GValue* value) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER), NULL);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return value->data[0].v_pointer;
#line 12836 "scanner.c"
}


void value_set_scanner (GValue* value, gpointer v_object) {
	Scanner* old;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER));
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCANNER));
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_ref (value->data[0].v_pointer);
#line 12856 "scanner.c"
	} else {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 12860 "scanner.c"
	}
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_unref (old);
#line 12866 "scanner.c"
	}
}


void value_take_scanner (GValue* value, gpointer v_object) {
	Scanner* old;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER));
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (v_object) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCANNER));
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 12885 "scanner.c"
	} else {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 12889 "scanner.c"
	}
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (old) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		scanner_unref (old);
#line 12895 "scanner.c"
	}
}


static void scanner_class_init (ScannerClass * klass) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	scanner_parent_class = g_type_class_peek_parent (klass);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	SCANNER_CLASS (klass)->finalize = scanner_finalize;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (ScannerPrivate));
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_new ("update_devices", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_new ("request_authorization", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_new ("expect_page", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_new ("got_page_info", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO, G_TYPE_NONE, 1, TYPE_SCAN_PAGE_INFO);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_new ("got_line", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__SCAN_LINE, G_TYPE_NONE, 1, TYPE_SCAN_LINE);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_new ("scan_failed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_STRING, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_STRING);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_new ("page_done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_new ("document_done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_signal_new ("scanning_changed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12925 "scanner.c"
}


static void scanner_instance_init (Scanner * self) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv = SCANNER_GET_PRIVATE (self);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->ref_count = 1;
#line 12934 "scanner.c"
}


static void scanner_finalize (Scanner* obj) {
	Scanner * self;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCANNER, Scanner);
#line 210 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_thread_unref0 (self->priv->thread);
#line 213 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->request_queue);
#line 216 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->notify_queue);
#line 219 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->authorize_queue);
#line 225 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (self->priv->default_device);
#line 230 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	__g_list_free__scan_job_unref0_0 (self->priv->job_queue);
#line 235 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 243 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	_g_hash_table_unref0 (self->priv->options);
#line 246 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 12960 "scanner.c"
}


GType scanner_get_type (void) {
	static volatile gsize scanner_type_id__volatile = 0;
	if (g_once_init_enter (&scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scanner_init, value_scanner_free_value, value_scanner_copy_value, value_scanner_peek_pointer, "p", value_scanner_collect_value, "p", value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scanner), 0, (GInstanceInitFunc) scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scanner_type_id;
		scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Scanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scanner_type_id__volatile, scanner_type_id);
	}
	return scanner_type_id__volatile;
}


gpointer scanner_ref (gpointer instance) {
	Scanner* self;
	self = instance;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	return instance;
#line 12985 "scanner.c"
}


void scanner_unref (gpointer instance) {
	Scanner* self;
	self = instance;
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		SCANNER_GET_CLASS (self)->finalize (self);
#line 204 "/home/bob/bzr/simple-scan/3.4/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 12998 "scanner.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



