/* autosave-manager.c generated by valac 0.18.1, the Vala compiler
 * generated from autosave-manager.vala, do not modify */

/*
 * Copyright (C) 2011 Timo Kluck
 * Author: Timo Kluck <tkluck@infty.nl>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*
 * We store autosaves in a database named
 *    ~/.cache/simple-scan/autosaves/autosaves.db
 * It contains a single table of pages, each containing the process id (pid) of
 * the simple-scan instance that saved it, and a hash of the Book and Page
 * objects corresponding to it. The pixels are saved as a BLOB.
 * Additionally, the autosaves directory contains a number of tiff files that
 * the user can use for manual recovery.
 *
 * At startup, we check whether autosaves.db contains any records
 * with a pid that does not match a current pid for simple-scan. If so, we take
 * ownership by an UPDATE statement changing to our own pid. Then, we
 * recover the book. We're trying our best to avoid the possible race
 * condition if several instances of simple-scan are started simultaneously.
 *
 * At application exit, we delete the records corresponding to our own pid.
 *
 * Important notes:
 *  - We enforce that there is only one AutosaveManager instance in a given
 *    process by using a create function.
 *  - It should be possible to change the book object at runtime, although this
 *    is not used in the current implementation so it has not been tested.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;
typedef struct _AutosaveManagerPrivate AutosaveManagerPrivate;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))
#define _autosave_manager_unref0(var) ((var == NULL) ? NULL : (var = (autosave_manager_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
#define _scan_page_info_unref0(var) ((var == NULL) ? NULL : (var = (scan_page_info_unref (var), NULL)))
typedef struct _ParamSpecAutosaveManager ParamSpecAutosaveManager;

struct _AutosaveManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AutosaveManagerPrivate * priv;
};

struct _AutosaveManagerClass {
	GTypeClass parent_class;
	void (*finalize) (AutosaveManager *self);
};

struct _AutosaveManagerPrivate {
	sqlite3* database_connection;
	Book* _book;
	gint cur_book_revision;
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

struct _ParamSpecAutosaveManager {
	GParamSpec parent_instance;
};


static gpointer autosave_manager_parent_class = NULL;
static gchar* autosave_manager_AUTOSAVE_DIR;
static gchar* autosave_manager_AUTOSAVE_DIR = NULL;
static gchar* autosave_manager_AUTOSAVE_NAME;
static gchar* autosave_manager_AUTOSAVE_NAME = NULL;
static gchar* autosave_manager_AUTOSAVE_EXT;
static gchar* autosave_manager_AUTOSAVE_EXT = NULL;
static gchar* autosave_manager_AUTOSAVE_FILENAME;
static gchar* autosave_manager_AUTOSAVE_FILENAME = NULL;
static gchar* autosave_manager_PID;
static gchar* autosave_manager_PID = NULL;
static gint autosave_manager_number_of_instances;
static gint autosave_manager_number_of_instances = 0;

gpointer autosave_manager_ref (gpointer instance);
void autosave_manager_unref (gpointer instance);
GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_autosave_manager (GValue* value, gpointer v_object);
void value_take_autosave_manager (GValue* value, gpointer v_object);
gpointer value_get_autosave_manager (const GValue* value);
GType autosave_manager_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
#define AUTOSAVE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AUTOSAVE_MANAGER, AutosaveManagerPrivate))
enum  {
	AUTOSAVE_MANAGER_DUMMY_PROPERTY
};
AutosaveManager* autosave_manager_create (Book** book);
static AutosaveManager* autosave_manager_new (void);
static AutosaveManager* autosave_manager_construct (GType object_type);
static sqlite3* autosave_manager_open_database_connection (GError** error);
static void autosave_manager_recover_book (AutosaveManager* self, Book** book);
void autosave_manager_set_book (AutosaveManager* self, Book* value);
guint book_get_n_pages (Book* self);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
Page* book_get_page (Book* self, gint page_number);
static void autosave_manager_on_page_added (AutosaveManager* self, Page* page);
void autosave_manager_cleanup (AutosaveManager* self);
static void autosave_manager_insert_page (AutosaveManager* self, Page* page);
void autosave_manager_on_page_changed (AutosaveManager* self, Page* page);
static void _autosave_manager_on_page_changed_page_size_changed (Page* _sender, gpointer self);
static void _autosave_manager_on_page_changed_page_scan_direction_changed (Page* _sender, gpointer self);
static void _autosave_manager_on_page_changed_page_crop_changed (Page* _sender, gpointer self);
static void _autosave_manager_on_page_changed_page_scan_finished (Page* _sender, gpointer self);
void autosave_manager_on_page_removed (AutosaveManager* self, Page* page);
static void _autosave_manager_on_page_changed_page_pixels_changed (Page* _sender, gpointer self);
Book* autosave_manager_get_book (AutosaveManager* self);
void autosave_manager_on_reordered (AutosaveManager* self);
static void autosave_manager_update_page (AutosaveManager* self, Page* page);
void autosave_manager_on_needs_saving_changed (AutosaveManager* self, Book* book);
void autosave_manager_on_cleared (AutosaveManager* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
guint book_get_page_index (Book* self, Page* page);
gint page_get_dpi (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gint page_get_depth (Page* self);
gint page_get_n_channels (Page* self);
gint page_get_rowstride (Page* self);
GType scan_direction_get_type (void) G_GNUC_CONST;
ScanDirection page_get_scan_direction (Page* self);
gchar* page_get_color_profile (Page* self);
guchar* page_get_pixels (Page* self, int* result_length1);
void book_clear (Book* self);
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
ScanPageInfo* scan_page_info_new (void);
ScanPageInfo* scan_page_info_construct (GType object_type);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
void page_set_page_info (Page* self, ScanPageInfo* info);
void page_set_color_profile (Page* self, const gchar* color_profile);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
void page_set_pixels (Page* self, guchar* new_pixels, int new_pixels_length1);
static void _autosave_manager_on_page_added_book_page_added (Book* _sender, Page* page, gpointer self);
static void _autosave_manager_on_page_removed_book_page_removed (Book* _sender, Page* page, gpointer self);
static void _autosave_manager_on_reordered_book_reordered (Book* _sender, gpointer self);
static void _autosave_manager_on_cleared_book_cleared (Book* _sender, gpointer self);
static void autosave_manager_finalize (AutosaveManager* obj);


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


AutosaveManager* autosave_manager_create (Book** book) {
	AutosaveManager* result = NULL;
	gint _tmp0_;
	AutosaveManager* _tmp1_;
	AutosaveManager* man;
	gint _tmp2_;
	gboolean any_pages_recovered;
	AutosaveManager* _tmp51_;
	Book* _tmp52_;
	gboolean _tmp53_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (*book != NULL, NULL);
	_tmp0_ = autosave_manager_number_of_instances;
	if (_tmp0_ > 0) {
		g_assert_not_reached ();
	}
	_tmp1_ = autosave_manager_new ();
	man = _tmp1_;
	_tmp2_ = autosave_manager_number_of_instances;
	autosave_manager_number_of_instances = _tmp2_ + 1;
	{
		sqlite3* _tmp3_ = NULL;
		sqlite3* _tmp4_;
		AutosaveManager* _tmp5_;
		_tmp3_ = autosave_manager_open_database_connection (&_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch22_g_error;
		}
		_tmp5_ = man;
		_sqlite3_close0 (_tmp5_->priv->database_connection);
		_tmp5_->priv->database_connection = _tmp4_;
	}
	goto __finally22;
	__catch22_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		g_warning ("autosave-manager.vala:96: Could not connect to the autosave database; " \
"no autosaves will be kept.");
		result = NULL;
		_autosave_manager_unref0 (man);
		return result;
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_autosave_manager_unref0 (man);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	any_pages_recovered = FALSE;
	{
		gchar* current_pids = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		sqlite3_stmt* stmt = NULL;
		const gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* query;
		AutosaveManager* _tmp12_;
		sqlite3* _tmp13_;
		const gchar* _tmp14_;
		sqlite3_stmt* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _result_;
		gint _tmp17_;
		g_spawn_command_line_sync ("pidof simple-scan | sed \"s/ /,/g\"", &_tmp6_, NULL, NULL, &_inner_error_);
		_g_free0 (current_pids);
		current_pids = _tmp6_;
		if (_inner_error_ != NULL) {
			_g_free0 (current_pids);
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch23_g_spawn_error;
			}
			_g_free0 (current_pids);
			_autosave_manager_unref0 (man);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp7_ = current_pids;
		_tmp8_ = string_strip (_tmp7_);
		_g_free0 (current_pids);
		current_pids = _tmp8_;
		_tmp9_ = current_pids;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("\n" \
"                   SELECT process_id, book_hash, book_revision FROM pa" \
"ges\n" \
"                   WHERE NOT process_id IN (", _tmp10_, ")\n                   LIMIT 1\n                ", NULL);
		query = _tmp11_;
		_tmp12_ = man;
		_tmp13_ = _tmp12_->priv->database_connection;
		_tmp14_ = query;
		_tmp16_ = sqlite3_prepare_v2 (_tmp13_, _tmp14_, -1, &_tmp15_, NULL);
		_sqlite3_finalize0 (stmt);
		stmt = _tmp15_;
		_result_ = _tmp16_;
		_tmp17_ = _result_;
		if (_tmp17_ == SQLITE_OK) {
			while (TRUE) {
				sqlite3_stmt* _tmp18_;
				gint _tmp19_ = 0;
				sqlite3_stmt* _tmp20_;
				gint _tmp21_ = 0;
				gint unowned_pid;
				sqlite3_stmt* _tmp22_;
				gint _tmp23_ = 0;
				gint book_hash;
				sqlite3_stmt* _tmp24_;
				gint _tmp25_ = 0;
				gint book_revision;
				const gchar* _tmp26_;
				const gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				sqlite3_stmt* stmt2 = NULL;
				AutosaveManager* _tmp29_;
				sqlite3* _tmp30_;
				const gchar* _tmp31_;
				sqlite3_stmt* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				gint _tmp34_;
				sqlite3_stmt* _tmp39_;
				gint _tmp40_;
				sqlite3_stmt* _tmp41_;
				gint _tmp42_;
				sqlite3_stmt* _tmp43_;
				gint _tmp44_;
				sqlite3_stmt* _tmp45_;
				gint _tmp46_ = 0;
				gint _tmp47_;
				_tmp18_ = stmt;
				_tmp19_ = sqlite3_step (_tmp18_);
				if (!(_tmp19_ == SQLITE_ROW)) {
					break;
				}
				g_debug ("autosave-manager.vala:119: Found at least one autosave page, taking ow" \
"nership");
				_tmp20_ = stmt;
				_tmp21_ = sqlite3_column_int (_tmp20_, 0);
				unowned_pid = _tmp21_;
				_tmp22_ = stmt;
				_tmp23_ = sqlite3_column_int (_tmp22_, 1);
				book_hash = _tmp23_;
				_tmp24_ = stmt;
				_tmp25_ = sqlite3_column_int (_tmp24_, 2);
				book_revision = _tmp25_;
				_tmp26_ = autosave_manager_PID;
				_tmp27_ = string_to_string (_tmp26_);
				_tmp28_ = g_strconcat ("\n" \
"                        UPDATE pages\n" \
"                           SET process_id = ", _tmp27_, "\n" \
"                         WHERE process_id = ?2\n" \
"                           AND book_hash = ?3\n" \
"                           AND book_revision = ?4", NULL);
				_g_free0 (query);
				query = _tmp28_;
				_tmp29_ = man;
				_tmp30_ = _tmp29_->priv->database_connection;
				_tmp31_ = query;
				_tmp33_ = sqlite3_prepare_v2 (_tmp30_, _tmp31_, -1, &_tmp32_, NULL);
				_sqlite3_finalize0 (stmt2);
				stmt2 = _tmp32_;
				_result_ = _tmp33_;
				_tmp34_ = _result_;
				if (_tmp34_ != SQLITE_OK) {
					const gchar* _tmp35_;
					const gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					gchar* _tmp38_;
					_tmp35_ = query;
					_tmp36_ = string_to_string (_tmp35_);
					_tmp37_ = g_strconcat ("Error preparing statement: ", _tmp36_, NULL);
					_tmp38_ = _tmp37_;
					g_warning ("autosave-manager.vala:138: %s", _tmp38_);
					_g_free0 (_tmp38_);
				}
				_tmp39_ = stmt2;
				_tmp40_ = unowned_pid;
				sqlite3_bind_int64 (_tmp39_, 2, (gint64) _tmp40_);
				_tmp41_ = stmt2;
				_tmp42_ = book_hash;
				sqlite3_bind_int64 (_tmp41_, 3, (gint64) _tmp42_);
				_tmp43_ = stmt2;
				_tmp44_ = book_revision;
				sqlite3_bind_int64 (_tmp43_, 4, (gint64) _tmp44_);
				_tmp45_ = stmt2;
				_tmp46_ = sqlite3_step (_tmp45_);
				_result_ = _tmp46_;
				_tmp47_ = _result_;
				if (_tmp47_ == SQLITE_DONE) {
					AutosaveManager* _tmp48_;
					any_pages_recovered = TRUE;
					_tmp48_ = man;
					autosave_manager_recover_book (_tmp48_, book);
				} else {
					gint _tmp49_;
					_tmp49_ = _result_;
					g_warning ("autosave-manager.vala:150: Error %d while executing query", _tmp49_);
				}
				_sqlite3_finalize0 (stmt2);
			}
		} else {
			gint _tmp50_;
			_tmp50_ = _result_;
			g_warning ("autosave-manager.vala:154: Error %d while preparing statement", _tmp50_);
		}
		_g_free0 (query);
		_sqlite3_finalize0 (stmt);
		_g_free0 (current_pids);
	}
	goto __finally23;
	__catch23_g_spawn_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("autosave-manager.vala:158: Could not obtain current process ids; not r" \
"estoring any autosaves");
		_g_error_free0 (e);
	}
	__finally23:
	if (_inner_error_ != NULL) {
		_autosave_manager_unref0 (man);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp51_ = man;
	_tmp52_ = *book;
	autosave_manager_set_book (_tmp51_, _tmp52_);
	_tmp53_ = any_pages_recovered;
	if (!_tmp53_) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp54_;
				_tmp54_ = TRUE;
				while (TRUE) {
					gboolean _tmp55_;
					gint _tmp57_;
					Book* _tmp58_;
					guint _tmp59_ = 0U;
					Book* _tmp60_;
					gint _tmp61_;
					Page* _tmp62_ = NULL;
					Page* page;
					AutosaveManager* _tmp63_;
					Page* _tmp64_;
					_tmp55_ = _tmp54_;
					if (!_tmp55_) {
						gint _tmp56_;
						_tmp56_ = i;
						i = _tmp56_ + 1;
					}
					_tmp54_ = FALSE;
					_tmp57_ = i;
					_tmp58_ = *book;
					_tmp59_ = book_get_n_pages (_tmp58_);
					if (!(((guint) _tmp57_) < _tmp59_)) {
						break;
					}
					_tmp60_ = *book;
					_tmp61_ = i;
					_tmp62_ = book_get_page (_tmp60_, _tmp61_);
					page = _tmp62_;
					_tmp63_ = man;
					_tmp64_ = page;
					autosave_manager_on_page_added (_tmp63_, _tmp64_);
					_page_unref0 (page);
				}
			}
		}
	}
	result = man;
	return result;
}


static AutosaveManager* autosave_manager_construct (GType object_type) {
	AutosaveManager* self = NULL;
	self = (AutosaveManager*) g_type_create_instance (object_type);
	return self;
}


static AutosaveManager* autosave_manager_new (void) {
	return autosave_manager_construct (TYPE_AUTOSAVE_MANAGER);
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	const gchar* _tmp0_;
	sqlite3_callback _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint ec;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


void autosave_manager_cleanup (AutosaveManager* self) {
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_debug ("autosave-manager.vala:180: Clean exit; deleting autosave records");
	_tmp0_ = self->priv->database_connection;
	_tmp1_ = autosave_manager_PID;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strconcat ("\n            DELETE FROM pages\n                WHERE process_id = ", _tmp2_, "\n        ", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _sqlite3_exec (_tmp0_, _tmp4_, NULL, NULL, NULL);
	g_warn_if_fail (_tmp5_ == SQLITE_OK);
	_g_free0 (_tmp4_);
}


static sqlite3* autosave_manager_open_database_connection (GError** error) {
	sqlite3* result = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* autosaves_dir;
	sqlite3* connection = NULL;
	const gchar* _tmp3_;
	sqlite3* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp7_;
	gchar* query;
	sqlite3* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_ = 0;
	gint _result_;
	gint _tmp11_;
	GError * _inner_error_ = NULL;
	_tmp0_ = autosave_manager_AUTOSAVE_DIR;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	autosaves_dir = _tmp1_;
	{
		GFile* _tmp2_;
		_tmp2_ = autosaves_dir;
		g_file_make_directory_with_parents (_tmp2_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
	}
	goto __finally24;
	__catch24_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally24:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (autosaves_dir);
		return NULL;
	}
	_tmp3_ = autosave_manager_AUTOSAVE_FILENAME;
	_tmp5_ = sqlite3_open (_tmp3_, &_tmp4_);
	_sqlite3_close0 (connection);
	connection = _tmp4_;
	if (_tmp5_ != SQLITE_OK) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Could not connect to autosave database");
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		_sqlite3_close0 (connection);
		_g_object_unref0 (autosaves_dir);
		return NULL;
	}
	_tmp7_ = g_strdup ("\n" \
"            CREATE TABLE IF NOT EXISTS pages (\n" \
"                id integer PRIMARY KEY,\n" \
"                process_id integer,\n" \
"                page_hash integer,\n" \
"                book_hash integer,\n" \
"                book_revision integer,\n" \
"                page_number integer,\n" \
"                dpi integer,\n" \
"                width integer,\n" \
"                height integer,\n" \
"                depth integer,\n" \
"                n_channels integer,\n" \
"                rowstride integer,\n" \
"                color_profile string,\n" \
"                crop_x integer,\n" \
"                crop_y integer,\n" \
"                crop_width integer,\n" \
"                crop_height integer,\n" \
"                scan_direction integer,\n" \
"                pixels binary\n" \
"            )");
	query = _tmp7_;
	_tmp8_ = connection;
	_tmp9_ = query;
	_tmp10_ = _sqlite3_exec (_tmp8_, _tmp9_, NULL, NULL, NULL);
	_result_ = _tmp10_;
	_tmp11_ = _result_;
	if (_tmp11_ != SQLITE_OK) {
		gint _tmp12_;
		_tmp12_ = _result_;
		g_warning ("autosave-manager.vala:225: Error %d while executing query", _tmp12_);
	}
	result = connection;
	_g_free0 (query);
	_g_object_unref0 (autosaves_dir);
	return result;
}


static void _autosave_manager_on_page_changed_page_size_changed (Page* _sender, gpointer self) {
	autosave_manager_on_page_changed (self, _sender);
}


static void _autosave_manager_on_page_changed_page_scan_direction_changed (Page* _sender, gpointer self) {
	autosave_manager_on_page_changed (self, _sender);
}


static void _autosave_manager_on_page_changed_page_crop_changed (Page* _sender, gpointer self) {
	autosave_manager_on_page_changed (self, _sender);
}


static void _autosave_manager_on_page_changed_page_scan_finished (Page* _sender, gpointer self) {
	autosave_manager_on_page_changed (self, _sender);
}


static void autosave_manager_on_page_added (AutosaveManager* self, Page* page) {
	Page* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	autosave_manager_insert_page (self, _tmp0_);
	_tmp1_ = page;
	g_signal_connect (_tmp1_, "size-changed", (GCallback) _autosave_manager_on_page_changed_page_size_changed, self);
	_tmp2_ = page;
	g_signal_connect (_tmp2_, "scan-direction-changed", (GCallback) _autosave_manager_on_page_changed_page_scan_direction_changed, self);
	_tmp3_ = page;
	g_signal_connect (_tmp3_, "crop-changed", (GCallback) _autosave_manager_on_page_changed_page_crop_changed, self);
	_tmp4_ = page;
	g_signal_connect (_tmp4_, "scan-finished", (GCallback) _autosave_manager_on_page_changed_page_scan_finished, self);
}


static void _autosave_manager_on_page_changed_page_pixels_changed (Page* _sender, gpointer self) {
	autosave_manager_on_page_changed (self, _sender);
}


void autosave_manager_on_page_removed (AutosaveManager* self, Page* page) {
	Page* _tmp0_;
	guint _tmp1_ = 0U;
	Page* _tmp2_;
	guint _tmp3_ = 0U;
	Page* _tmp4_;
	guint _tmp5_ = 0U;
	Page* _tmp6_;
	guint _tmp7_ = 0U;
	Page* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* query;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp12_;
	const gchar* _tmp13_;
	sqlite3_stmt* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _result_;
	gint _tmp16_;
	sqlite3_stmt* _tmp22_;
	GHashFunc _tmp23_;
	Page* _tmp24_;
	guint _tmp25_ = 0U;
	sqlite3_stmt* _tmp26_;
	GHashFunc _tmp27_;
	Book* _tmp28_;
	Book* _tmp29_;
	guint _tmp30_ = 0U;
	sqlite3_stmt* _tmp31_;
	gint _tmp32_;
	sqlite3_stmt* _tmp33_;
	gint _tmp34_ = 0;
	gint _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _autosave_manager_on_page_changed_page_pixels_changed, self);
	_tmp2_ = page;
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _autosave_manager_on_page_changed_page_size_changed, self);
	_tmp4_ = page;
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _autosave_manager_on_page_changed_page_scan_direction_changed, self);
	_tmp6_ = page;
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _autosave_manager_on_page_changed_page_crop_changed, self);
	_tmp8_ = page;
	g_signal_connect (_tmp8_, "scan-finished", (GCallback) _autosave_manager_on_page_changed_page_scan_finished, self);
	_tmp9_ = autosave_manager_PID;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = g_strconcat ("\n        DELETE FROM pages\n            WHERE process_id = ", _tmp10_, "\n" \
"              AND page_hash = ?2\n" \
"              AND book_hash = ?3\n" \
"              AND book_revision = ?4\n" \
"        ", NULL);
	query = _tmp11_;
	_tmp12_ = self->priv->database_connection;
	_tmp13_ = query;
	_tmp15_ = sqlite3_prepare_v2 (_tmp12_, _tmp13_, -1, &_tmp14_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp14_;
	_result_ = _tmp15_;
	_tmp16_ = _result_;
	if (_tmp16_ != SQLITE_OK) {
		gint _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		_tmp17_ = _result_;
		_tmp18_ = g_strdup_printf ("%i", _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat ("Error ", _tmp19_, " while preparing query", NULL);
		_tmp21_ = _tmp20_;
		g_warning ("autosave-manager.vala:257: %s", _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
	}
	_tmp22_ = stmt;
	_tmp23_ = g_direct_hash;
	_tmp24_ = page;
	_tmp25_ = _tmp23_ (_tmp24_);
	sqlite3_bind_int64 (_tmp22_, 2, (gint64) _tmp25_);
	_tmp26_ = stmt;
	_tmp27_ = g_direct_hash;
	_tmp28_ = autosave_manager_get_book (self);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp27_ (_tmp29_);
	sqlite3_bind_int64 (_tmp26_, 3, (gint64) _tmp30_);
	_tmp31_ = stmt;
	_tmp32_ = self->priv->cur_book_revision;
	sqlite3_bind_int64 (_tmp31_, 4, (gint64) _tmp32_);
	_tmp33_ = stmt;
	_tmp34_ = sqlite3_step (_tmp33_);
	_result_ = _tmp34_;
	_tmp35_ = _result_;
	if (_tmp35_ != SQLITE_DONE) {
		gint _tmp36_;
		_tmp36_ = _result_;
		g_warning ("autosave-manager.vala:264: Error %d while executing query", _tmp36_);
	}
	_sqlite3_finalize0 (stmt);
	_g_free0 (query);
}


void autosave_manager_on_reordered (AutosaveManager* self) {
	g_return_if_fail (self != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				Book* _tmp4_;
				Book* _tmp5_;
				guint _tmp6_ = 0U;
				Book* _tmp7_;
				Book* _tmp8_;
				gint _tmp9_;
				Page* _tmp10_ = NULL;
				Page* page;
				const gchar* _tmp11_;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gchar* query;
				sqlite3_stmt* stmt = NULL;
				sqlite3* _tmp14_;
				const gchar* _tmp15_;
				sqlite3_stmt* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gint _result_;
				gint _tmp18_;
				sqlite3_stmt* _tmp24_;
				gint _tmp25_;
				sqlite3_stmt* _tmp26_;
				GHashFunc _tmp27_;
				Page* _tmp28_;
				guint _tmp29_ = 0U;
				sqlite3_stmt* _tmp30_;
				GHashFunc _tmp31_;
				Book* _tmp32_;
				Book* _tmp33_;
				guint _tmp34_ = 0U;
				sqlite3_stmt* _tmp35_;
				gint _tmp36_;
				sqlite3_stmt* _tmp37_;
				gint _tmp38_ = 0;
				gint _tmp39_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = autosave_manager_get_book (self);
				_tmp5_ = _tmp4_;
				_tmp6_ = book_get_n_pages (_tmp5_);
				if (!(((guint) _tmp3_) < _tmp6_)) {
					break;
				}
				_tmp7_ = autosave_manager_get_book (self);
				_tmp8_ = _tmp7_;
				_tmp9_ = i;
				_tmp10_ = book_get_page (_tmp8_, _tmp9_);
				page = _tmp10_;
				_tmp11_ = autosave_manager_PID;
				_tmp12_ = string_to_string (_tmp11_);
				_tmp13_ = g_strconcat ("\n" \
"            UPDATE pages SET page_number = ?5\n" \
"            WHERE process_id = ", _tmp12_, "\n" \
"              AND page_hash = ?2\n" \
"              AND book_hash = ?3\n" \
"              AND book_revision = ?4\n" \
"            ", NULL);
				query = _tmp13_;
				_tmp14_ = self->priv->database_connection;
				_tmp15_ = query;
				_tmp17_ = sqlite3_prepare_v2 (_tmp14_, _tmp15_, -1, &_tmp16_, NULL);
				_sqlite3_finalize0 (stmt);
				stmt = _tmp16_;
				_result_ = _tmp17_;
				_tmp18_ = _result_;
				if (_tmp18_ != SQLITE_OK) {
					gint _tmp19_;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_;
					gchar* _tmp22_ = NULL;
					gchar* _tmp23_;
					_tmp19_ = _result_;
					_tmp20_ = g_strdup_printf ("%i", _tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strconcat ("Error ", _tmp21_, " while preparing query", NULL);
					_tmp23_ = _tmp22_;
					g_warning ("autosave-manager.vala:282: %s", _tmp23_);
					_g_free0 (_tmp23_);
					_g_free0 (_tmp21_);
				}
				_tmp24_ = stmt;
				_tmp25_ = i;
				sqlite3_bind_int64 (_tmp24_, 5, (gint64) _tmp25_);
				_tmp26_ = stmt;
				_tmp27_ = g_direct_hash;
				_tmp28_ = page;
				_tmp29_ = _tmp27_ (_tmp28_);
				sqlite3_bind_int64 (_tmp26_, 2, (gint64) _tmp29_);
				_tmp30_ = stmt;
				_tmp31_ = g_direct_hash;
				_tmp32_ = autosave_manager_get_book (self);
				_tmp33_ = _tmp32_;
				_tmp34_ = _tmp31_ (_tmp33_);
				sqlite3_bind_int64 (_tmp30_, 3, (gint64) _tmp34_);
				_tmp35_ = stmt;
				_tmp36_ = self->priv->cur_book_revision;
				sqlite3_bind_int64 (_tmp35_, 4, (gint64) _tmp36_);
				_tmp37_ = stmt;
				_tmp38_ = sqlite3_step (_tmp37_);
				_result_ = _tmp38_;
				_tmp39_ = _result_;
				if (_tmp39_ != SQLITE_DONE) {
					gint _tmp40_;
					_tmp40_ = _result_;
					g_warning ("autosave-manager.vala:291: Error %d while executing query", _tmp40_);
				}
				_sqlite3_finalize0 (stmt);
				_g_free0 (query);
				_page_unref0 (page);
			}
		}
	}
}


void autosave_manager_on_page_changed (AutosaveManager* self, Page* page) {
	Page* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	autosave_manager_update_page (self, _tmp0_);
}


void autosave_manager_on_needs_saving_changed (AutosaveManager* self, Book* book) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	{
		gint n;
		n = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				Book* _tmp4_;
				guint _tmp5_ = 0U;
				Book* _tmp6_;
				gint _tmp7_;
				Page* _tmp8_ = NULL;
				Page* page;
				Page* _tmp9_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = n;
					n = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = n;
				_tmp4_ = book;
				_tmp5_ = book_get_n_pages (_tmp4_);
				if (!(((guint) _tmp3_) < _tmp5_)) {
					break;
				}
				_tmp6_ = book;
				_tmp7_ = n;
				_tmp8_ = book_get_page (_tmp6_, _tmp7_);
				page = _tmp8_;
				_tmp9_ = page;
				autosave_manager_update_page (self, _tmp9_);
				_page_unref0 (page);
			}
		}
	}
}


void autosave_manager_on_cleared (AutosaveManager* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cur_book_revision;
	self->priv->cur_book_revision = _tmp0_ + 1;
}


static void autosave_manager_insert_page (AutosaveManager* self, Page* page) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* query;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp3_;
	const gchar* _tmp4_;
	sqlite3_stmt* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _result_;
	gint _tmp7_;
	sqlite3_stmt* _tmp13_;
	GHashFunc _tmp14_;
	Page* _tmp15_;
	guint _tmp16_ = 0U;
	sqlite3_stmt* _tmp17_;
	GHashFunc _tmp18_;
	Book* _tmp19_;
	Book* _tmp20_;
	guint _tmp21_ = 0U;
	sqlite3_stmt* _tmp22_;
	gint _tmp23_;
	sqlite3_stmt* _tmp24_;
	gint _tmp25_ = 0;
	gint _tmp26_;
	Page* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	g_debug ("autosave-manager.vala:318: Adding an autosave for a new page");
	_tmp0_ = autosave_manager_PID;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("\n" \
"            INSERT INTO pages\n" \
"                (process_id,\n" \
"                page_hash,\n" \
"                book_hash,\n" \
"                book_revision)\n" \
"                VALUES\n" \
"                (", _tmp1_, ",\n" \
"                ?2,\n" \
"                ?3,\n" \
"                ?4)\n" \
"        ", NULL);
	query = _tmp2_;
	_tmp3_ = self->priv->database_connection;
	_tmp4_ = query;
	_tmp6_ = sqlite3_prepare_v2 (_tmp3_, _tmp4_, -1, &_tmp5_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp5_;
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	if (_tmp7_ != SQLITE_OK) {
		gint _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp8_ = _result_;
		_tmp9_ = g_strdup_printf ("%i", _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat ("Error ", _tmp10_, " while preparing query", NULL);
		_tmp12_ = _tmp11_;
		g_warning ("autosave-manager.vala:334: %s", _tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
	}
	_tmp13_ = stmt;
	_tmp14_ = g_direct_hash;
	_tmp15_ = page;
	_tmp16_ = _tmp14_ (_tmp15_);
	sqlite3_bind_int64 (_tmp13_, 2, (gint64) _tmp16_);
	_tmp17_ = stmt;
	_tmp18_ = g_direct_hash;
	_tmp19_ = autosave_manager_get_book (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp18_ (_tmp20_);
	sqlite3_bind_int64 (_tmp17_, 3, (gint64) _tmp21_);
	_tmp22_ = stmt;
	_tmp23_ = self->priv->cur_book_revision;
	sqlite3_bind_int64 (_tmp22_, 4, (gint64) _tmp23_);
	_tmp24_ = stmt;
	_tmp25_ = sqlite3_step (_tmp24_);
	_result_ = _tmp25_;
	_tmp26_ = _result_;
	if (_tmp26_ != SQLITE_DONE) {
		gint _tmp27_;
		_tmp27_ = _result_;
		g_warning ("autosave-manager.vala:342: Error %d while executing query", _tmp27_);
	}
	_tmp28_ = page;
	autosave_manager_update_page (self, _tmp28_);
	_sqlite3_finalize0 (stmt);
	_g_free0 (query);
}


static void autosave_manager_update_page (AutosaveManager* self, Page* page) {
	gint crop_x = 0;
	gint crop_y = 0;
	gint crop_width = 0;
	gint crop_height = 0;
	Page* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	sqlite3_stmt* stmt = NULL;
	Book* _tmp5_;
	Book* _tmp6_;
	Page* _tmp7_;
	guint _tmp8_ = 0U;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	Page* _tmp11_;
	gint _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	Page* _tmp15_;
	gint _tmp16_ = 0;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	Page* _tmp19_;
	gint _tmp20_ = 0;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	Page* _tmp23_;
	gint _tmp24_ = 0;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	Page* _tmp27_;
	gint _tmp28_ = 0;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	Page* _tmp31_;
	gint _tmp32_ = 0;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_;
	gint _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	gint _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	gint _tmp41_;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	gint _tmp44_;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_;
	Page* _tmp47_;
	ScanDirection _tmp48_ = 0;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_;
	gchar* query;
	sqlite3* _tmp55_;
	const gchar* _tmp56_;
	sqlite3_stmt* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	gint _result_;
	gint _tmp59_;
	sqlite3_stmt* _tmp61_;
	GHashFunc _tmp62_;
	Page* _tmp63_;
	guint _tmp64_ = 0U;
	sqlite3_stmt* _tmp65_;
	GHashFunc _tmp66_;
	Book* _tmp67_;
	Book* _tmp68_;
	guint _tmp69_ = 0U;
	sqlite3_stmt* _tmp70_;
	gint _tmp71_;
	Page* _tmp72_;
	gchar* _tmp73_ = NULL;
	gchar* _tmp74_;
	const gchar* _tmp75_;
	sqlite3_stmt* _tmp77_;
	const gchar* _tmp78_;
	gchar* _tmp79_;
	GDestroyNotify _tmp80_;
	gint _tmp81_ = 0;
	gint _tmp82_;
	Page* _tmp84_;
	gint _tmp85_ = 0;
	guchar* _tmp86_ = NULL;
	sqlite3_stmt* _tmp99_;
	gint _tmp100_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	g_debug ("autosave-manager.vala:349: Updating the autosave for a page");
	_tmp0_ = page;
	page_get_crop (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	crop_x = _tmp1_;
	crop_y = _tmp2_;
	crop_width = _tmp3_;
	crop_height = _tmp4_;
	_tmp5_ = autosave_manager_get_book (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = page;
	_tmp8_ = book_get_page_index (_tmp6_, _tmp7_);
	_tmp9_ = g_strdup_printf ("%u", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = page;
	_tmp12_ = page_get_dpi (_tmp11_);
	_tmp13_ = g_strdup_printf ("%i", _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = page;
	_tmp16_ = page_get_width (_tmp15_);
	_tmp17_ = g_strdup_printf ("%i", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = page;
	_tmp20_ = page_get_height (_tmp19_);
	_tmp21_ = g_strdup_printf ("%i", _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = page;
	_tmp24_ = page_get_depth (_tmp23_);
	_tmp25_ = g_strdup_printf ("%i", _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = page;
	_tmp28_ = page_get_n_channels (_tmp27_);
	_tmp29_ = g_strdup_printf ("%i", _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = page;
	_tmp32_ = page_get_rowstride (_tmp31_);
	_tmp33_ = g_strdup_printf ("%i", _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = crop_x;
	_tmp36_ = g_strdup_printf ("%i", _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = crop_y;
	_tmp39_ = g_strdup_printf ("%i", _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = crop_width;
	_tmp42_ = g_strdup_printf ("%i", _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = crop_height;
	_tmp45_ = g_strdup_printf ("%i", _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = page;
	_tmp48_ = page_get_scan_direction (_tmp47_);
	_tmp49_ = g_strdup_printf ("%i", (gint) _tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = autosave_manager_PID;
	_tmp52_ = string_to_string (_tmp51_);
	_tmp53_ = g_strconcat ("\n" \
"            UPDATE pages\n" \
"                SET\n" \
"                page_number=", _tmp10_, ",\n                dpi=", _tmp14_, ",\n                width=", _tmp18_, ",\n                height=", _tmp22_, ",\n                depth=", _tmp26_, ",\n                n_channels=", _tmp30_, ",\n                rowstride=", _tmp34_, ",\n                crop_x=", _tmp37_, ",\n                crop_y=", _tmp40_, ",\n                crop_width=", _tmp43_, ",\n                crop_height=", _tmp46_, ",\n                scan_direction=", _tmp50_, ",\n" \
"                color_profile=?1,\n" \
"                pixels=?2\n" \
"                WHERE process_id = ", _tmp52_, "\n" \
"                  AND page_hash = ?4\n" \
"                  AND book_hash = ?5\n" \
"                  AND book_revision = ?6\n" \
"            ", NULL);
	_tmp54_ = _tmp53_;
	_g_free0 (_tmp50_);
	_g_free0 (_tmp46_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp40_);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp34_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp10_);
	query = _tmp54_;
	_tmp55_ = self->priv->database_connection;
	_tmp56_ = query;
	_tmp58_ = sqlite3_prepare_v2 (_tmp55_, _tmp56_, -1, &_tmp57_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp57_;
	_result_ = _tmp58_;
	_tmp59_ = _result_;
	if (_tmp59_ != SQLITE_OK) {
		gint _tmp60_;
		_tmp60_ = _result_;
		g_warning ("autosave-manager.vala:384: Error %d while preparing statement", _tmp60_);
		_g_free0 (query);
		_sqlite3_finalize0 (stmt);
		return;
	}
	_tmp61_ = stmt;
	_tmp62_ = g_direct_hash;
	_tmp63_ = page;
	_tmp64_ = _tmp62_ (_tmp63_);
	sqlite3_bind_int64 (_tmp61_, 4, (gint64) _tmp64_);
	_tmp65_ = stmt;
	_tmp66_ = g_direct_hash;
	_tmp67_ = autosave_manager_get_book (self);
	_tmp68_ = _tmp67_;
	_tmp69_ = _tmp66_ (_tmp68_);
	sqlite3_bind_int64 (_tmp65_, 5, (gint64) _tmp69_);
	_tmp70_ = stmt;
	_tmp71_ = self->priv->cur_book_revision;
	sqlite3_bind_int64 (_tmp70_, 6, (gint64) _tmp71_);
	_tmp72_ = page;
	_tmp73_ = page_get_color_profile (_tmp72_);
	_tmp74_ = _tmp73_;
	_tmp75_ = _tmp74_;
	if (_tmp75_ == NULL) {
		gchar* _tmp76_;
		_tmp76_ = g_strdup ("");
		_g_free0 (_tmp74_);
		_tmp74_ = _tmp76_;
	}
	_tmp77_ = stmt;
	_tmp78_ = _tmp74_;
	_tmp79_ = g_strdup (_tmp78_);
	_tmp80_ = g_free;
	_tmp81_ = sqlite3_bind_text (_tmp77_, 1, _tmp79_, -1, _tmp80_);
	_result_ = _tmp81_;
	_tmp82_ = _result_;
	if (_tmp82_ != SQLITE_OK) {
		gint _tmp83_;
		_tmp83_ = _result_;
		g_warning ("autosave-manager.vala:394: Error %d while binding text", _tmp83_);
	}
	_tmp84_ = page;
	_tmp86_ = page_get_pixels (_tmp84_, &_tmp85_);
	if (_tmp86_ != NULL) {
		sqlite3_stmt* _tmp87_;
		Page* _tmp88_;
		gint _tmp89_ = 0;
		guchar* _tmp90_ = NULL;
		Page* _tmp91_;
		gint _tmp92_ = 0;
		guchar* _tmp93_ = NULL;
		gint _tmp94_ = 0;
		gint _tmp95_;
		_tmp87_ = stmt;
		_tmp88_ = page;
		_tmp90_ = page_get_pixels (_tmp88_, &_tmp89_);
		_tmp91_ = page;
		_tmp93_ = page_get_pixels (_tmp91_, &_tmp92_);
		_tmp94_ = sqlite3_bind_blob (_tmp87_, 2, _tmp90_, _tmp92_, (GDestroyNotify) (-1));
		_result_ = _tmp94_;
		_tmp95_ = _result_;
		if (_tmp95_ != SQLITE_OK) {
			gint _tmp96_;
			_tmp96_ = _result_;
			g_warning ("autosave-manager.vala:401: Error %d while binding blob", _tmp96_);
		}
	} else {
		sqlite3_stmt* _tmp97_;
		gint _tmp98_ = 0;
		_tmp97_ = stmt;
		_tmp98_ = sqlite3_bind_null (_tmp97_, 2);
		g_warn_if_fail (_tmp98_ == SQLITE_OK);
	}
	_tmp99_ = stmt;
	_tmp100_ = sqlite3_step (_tmp99_);
	g_warn_if_fail (_tmp100_ == SQLITE_DONE);
	_g_free0 (_tmp74_);
	_g_free0 (query);
	_sqlite3_finalize0 (stmt);
}


static void autosave_manager_recover_book (AutosaveManager* self, Book** book) {
	sqlite3_stmt* stmt = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* query;
	sqlite3* _tmp5_;
	const gchar* _tmp6_;
	sqlite3_stmt* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _result_;
	gint _tmp9_;
	gboolean first;
	gboolean _tmp125_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*book != NULL);
	_tmp0_ = autosave_manager_PID;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = autosave_manager_PID;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat ("\n" \
"            SELECT process_id,\n" \
"                page_hash,\n" \
"                book_hash,\n" \
"                book_revision,\n" \
"                page_number,\n" \
"                dpi,\n" \
"                width,\n" \
"                height,\n" \
"                depth,\n" \
"                n_channels,\n" \
"                rowstride,\n" \
"                color_profile,\n" \
"                crop_x,\n" \
"                crop_y,\n" \
"                crop_width,\n" \
"                crop_height,\n" \
"                scan_direction,\n" \
"                pixels,\n" \
"                id\n" \
"            FROM pages\n" \
"            WHERE process_id = ", _tmp1_, "\n" \
"              AND book_revision = (\n" \
"                  SELECT MAX(book_revision) FROM pages WHERE process_i" \
"d = ", _tmp3_, "\n              )\n            ORDER BY page_number\n        ", NULL);
	query = _tmp4_;
	_tmp5_ = self->priv->database_connection;
	_tmp6_ = query;
	_tmp8_ = sqlite3_prepare_v2 (_tmp5_, _tmp6_, -1, &_tmp7_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp7_;
	_result_ = _tmp8_;
	_tmp9_ = _result_;
	if (_tmp9_ != SQLITE_OK) {
		gint _tmp10_;
		_tmp10_ = _result_;
		g_warning ("autosave-manager.vala:442: Error %d while preparing statement", _tmp10_);
	}
	first = TRUE;
	while (TRUE) {
		sqlite3_stmt* _tmp11_;
		gint _tmp12_ = 0;
		gboolean _tmp13_;
		sqlite3_stmt* _tmp15_;
		gint _tmp16_ = 0;
		gint dpi;
		sqlite3_stmt* _tmp17_;
		gint _tmp18_ = 0;
		gint width;
		sqlite3_stmt* _tmp19_;
		gint _tmp20_ = 0;
		gint height;
		sqlite3_stmt* _tmp21_;
		gint _tmp22_ = 0;
		gint depth;
		sqlite3_stmt* _tmp23_;
		gint _tmp24_ = 0;
		gint n_channels;
		sqlite3_stmt* _tmp25_;
		gint _tmp26_ = 0;
		ScanDirection scan_direction;
		gboolean _tmp27_ = FALSE;
		gint _tmp28_;
		gboolean _tmp30_;
		gint _tmp31_;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		gint _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_;
		Book* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		ScanDirection _tmp43_;
		Page* _tmp44_ = NULL;
		Page* new_page;
		gboolean _tmp45_ = FALSE;
		gint _tmp46_;
		gboolean _tmp48_;
		Page* _tmp64_;
		sqlite3_stmt* _tmp65_;
		const gchar* _tmp66_ = NULL;
		sqlite3_stmt* _tmp67_;
		gint _tmp68_ = 0;
		gint crop_x;
		sqlite3_stmt* _tmp69_;
		gint _tmp70_ = 0;
		gint crop_y;
		sqlite3_stmt* _tmp71_;
		gint _tmp72_ = 0;
		gint crop_width;
		sqlite3_stmt* _tmp73_;
		gint _tmp74_ = 0;
		gint crop_height;
		gboolean _tmp75_ = FALSE;
		gint _tmp76_;
		gboolean _tmp78_;
		sqlite3_stmt* _tmp85_;
		gint _tmp86_ = 0;
		guchar* _tmp87_ = NULL;
		guchar* new_pixels;
		gint new_pixels_length1;
		gint _new_pixels_size_;
		guchar* _tmp88_;
		gint _tmp88__length1;
		sqlite3_stmt* _tmp89_;
		void* _tmp90_ = NULL;
		sqlite3_stmt* _tmp91_;
		gint _tmp92_ = 0;
		Page* _tmp93_;
		guchar* _tmp94_;
		gint _tmp94__length1;
		sqlite3_stmt* _tmp95_;
		gint _tmp96_ = 0;
		gint id;
		gint _tmp97_;
		gchar* _tmp98_ = NULL;
		gchar* _tmp99_;
		gchar* _tmp100_ = NULL;
		sqlite3_stmt* stmt2 = NULL;
		sqlite3* _tmp101_;
		const gchar* _tmp102_;
		sqlite3_stmt* _tmp103_ = NULL;
		gint _tmp104_ = 0;
		gint result2;
		gint _tmp105_;
		sqlite3_stmt* _tmp111_;
		GHashFunc _tmp112_;
		Page* _tmp113_;
		guint _tmp114_ = 0U;
		sqlite3_stmt* _tmp115_;
		GHashFunc _tmp116_;
		Book* _tmp117_;
		guint _tmp118_ = 0U;
		sqlite3_stmt* _tmp119_;
		gint _tmp120_;
		sqlite3_stmt* _tmp121_;
		gint _tmp122_ = 0;
		gint _tmp123_;
		_tmp11_ = stmt;
		_tmp12_ = sqlite3_step (_tmp11_);
		if (!(SQLITE_ROW == _tmp12_)) {
			break;
		}
		g_debug ("autosave-manager.vala:447: Found a page that needs to be recovered");
		_tmp13_ = first;
		if (_tmp13_) {
			Book* _tmp14_;
			_tmp14_ = *book;
			book_clear (_tmp14_);
			first = FALSE;
		}
		_tmp15_ = stmt;
		_tmp16_ = sqlite3_column_int (_tmp15_, 5);
		dpi = _tmp16_;
		_tmp17_ = stmt;
		_tmp18_ = sqlite3_column_int (_tmp17_, 6);
		width = _tmp18_;
		_tmp19_ = stmt;
		_tmp20_ = sqlite3_column_int (_tmp19_, 7);
		height = _tmp20_;
		_tmp21_ = stmt;
		_tmp22_ = sqlite3_column_int (_tmp21_, 8);
		depth = _tmp22_;
		_tmp23_ = stmt;
		_tmp24_ = sqlite3_column_int (_tmp23_, 9);
		n_channels = _tmp24_;
		_tmp25_ = stmt;
		_tmp26_ = sqlite3_column_int (_tmp25_, 16);
		scan_direction = (ScanDirection) _tmp26_;
		_tmp28_ = width;
		if (_tmp28_ <= 0) {
			_tmp27_ = TRUE;
		} else {
			gint _tmp29_;
			_tmp29_ = height;
			_tmp27_ = _tmp29_ <= 0;
		}
		_tmp30_ = _tmp27_;
		if (_tmp30_) {
			continue;
		}
		_tmp31_ = width;
		_tmp32_ = g_strdup_printf ("%i", _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = height;
		_tmp35_ = g_strdup_printf ("%i", _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat ("Restoring a page of size ", _tmp33_, " x ", _tmp36_, NULL);
		_tmp38_ = _tmp37_;
		g_debug ("autosave-manager.vala:463: %s", _tmp38_);
		_g_free0 (_tmp38_);
		_g_free0 (_tmp36_);
		_g_free0 (_tmp33_);
		_tmp39_ = *book;
		_tmp40_ = width;
		_tmp41_ = height;
		_tmp42_ = dpi;
		_tmp43_ = scan_direction;
		_tmp44_ = book_append_page (_tmp39_, _tmp40_, _tmp41_, _tmp42_, _tmp43_);
		new_page = _tmp44_;
		_tmp46_ = depth;
		if (_tmp46_ > 0) {
			gint _tmp47_;
			_tmp47_ = n_channels;
			_tmp45_ = _tmp47_ > 0;
		} else {
			_tmp45_ = FALSE;
		}
		_tmp48_ = _tmp45_;
		if (_tmp48_) {
			ScanPageInfo* _tmp49_;
			ScanPageInfo* info;
			ScanPageInfo* _tmp50_;
			gint _tmp51_;
			ScanPageInfo* _tmp52_;
			gint _tmp53_;
			ScanPageInfo* _tmp54_;
			gint _tmp55_;
			ScanPageInfo* _tmp56_;
			gint _tmp57_;
			ScanPageInfo* _tmp58_;
			gint _tmp59_;
			ScanPageInfo* _tmp60_;
			gchar* _tmp61_;
			Page* _tmp62_;
			ScanPageInfo* _tmp63_;
			_tmp49_ = scan_page_info_new ();
			info = _tmp49_;
			_tmp50_ = info;
			_tmp51_ = width;
			_tmp50_->width = _tmp51_;
			_tmp52_ = info;
			_tmp53_ = height;
			_tmp52_->height = _tmp53_;
			_tmp54_ = info;
			_tmp55_ = depth;
			_tmp54_->depth = _tmp55_;
			_tmp56_ = info;
			_tmp57_ = n_channels;
			_tmp56_->n_channels = _tmp57_;
			_tmp58_ = info;
			_tmp59_ = dpi;
			_tmp58_->dpi = (gdouble) _tmp59_;
			_tmp60_ = info;
			_tmp61_ = g_strdup ("");
			_g_free0 (_tmp60_->device);
			_tmp60_->device = _tmp61_;
			_tmp62_ = new_page;
			_tmp63_ = info;
			page_set_page_info (_tmp62_, _tmp63_);
			_scan_page_info_unref0 (info);
		}
		_tmp64_ = new_page;
		_tmp65_ = stmt;
		_tmp66_ = sqlite3_column_text (_tmp65_, 11);
		page_set_color_profile (_tmp64_, _tmp66_);
		_tmp67_ = stmt;
		_tmp68_ = sqlite3_column_int (_tmp67_, 12);
		crop_x = _tmp68_;
		_tmp69_ = stmt;
		_tmp70_ = sqlite3_column_int (_tmp69_, 13);
		crop_y = _tmp70_;
		_tmp71_ = stmt;
		_tmp72_ = sqlite3_column_int (_tmp71_, 14);
		crop_width = _tmp72_;
		_tmp73_ = stmt;
		_tmp74_ = sqlite3_column_int (_tmp73_, 15);
		crop_height = _tmp74_;
		_tmp76_ = crop_width;
		if (_tmp76_ > 0) {
			gint _tmp77_;
			_tmp77_ = crop_height;
			_tmp75_ = _tmp77_ > 0;
		} else {
			_tmp75_ = FALSE;
		}
		_tmp78_ = _tmp75_;
		if (_tmp78_) {
			Page* _tmp79_;
			gint _tmp80_;
			gint _tmp81_;
			Page* _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			_tmp79_ = new_page;
			_tmp80_ = crop_width;
			_tmp81_ = crop_height;
			page_set_custom_crop (_tmp79_, _tmp80_, _tmp81_);
			_tmp82_ = new_page;
			_tmp83_ = crop_x;
			_tmp84_ = crop_y;
			page_move_crop (_tmp82_, _tmp83_, _tmp84_);
		}
		_tmp85_ = stmt;
		_tmp86_ = sqlite3_column_bytes (_tmp85_, 17);
		_tmp87_ = g_new0 (guchar, _tmp86_);
		new_pixels = _tmp87_;
		new_pixels_length1 = _tmp86_;
		_new_pixels_size_ = new_pixels_length1;
		_tmp88_ = new_pixels;
		_tmp88__length1 = new_pixels_length1;
		_tmp89_ = stmt;
		_tmp90_ = sqlite3_column_blob (_tmp89_, 17);
		_tmp91_ = stmt;
		_tmp92_ = sqlite3_column_bytes (_tmp91_, 17);
		memcpy (_tmp88_, _tmp90_, (gsize) _tmp92_);
		_tmp93_ = new_page;
		_tmp94_ = new_pixels;
		_tmp94__length1 = new_pixels_length1;
		page_set_pixels (_tmp93_, _tmp94_, _tmp94__length1);
		_tmp95_ = stmt;
		_tmp96_ = sqlite3_column_int (_tmp95_, 18);
		id = _tmp96_;
		g_debug ("autosave-manager.vala:494: Updating autosave to point to our new copy " \
"of the page");
		_tmp97_ = id;
		_tmp98_ = g_strdup_printf ("%i", _tmp97_);
		_tmp99_ = _tmp98_;
		_tmp100_ = g_strconcat ("\n" \
"                UPDATE pages\n" \
"                   SET page_hash=?1,\n" \
"                       book_hash=?2,\n" \
"                       book_revision=?3\n" \
"                WHERE id = ", _tmp99_, "\n            ", NULL);
		_g_free0 (query);
		query = _tmp100_;
		_g_free0 (_tmp99_);
		_tmp101_ = self->priv->database_connection;
		_tmp102_ = query;
		_tmp104_ = sqlite3_prepare_v2 (_tmp101_, _tmp102_, -1, &_tmp103_, NULL);
		_sqlite3_finalize0 (stmt2);
		stmt2 = _tmp103_;
		result2 = _tmp104_;
		_tmp105_ = result2;
		if (_tmp105_ != SQLITE_OK) {
			gint _tmp106_;
			gchar* _tmp107_ = NULL;
			gchar* _tmp108_;
			gchar* _tmp109_ = NULL;
			gchar* _tmp110_;
			_tmp106_ = result2;
			_tmp107_ = g_strdup_printf ("%i", _tmp106_);
			_tmp108_ = _tmp107_;
			_tmp109_ = g_strconcat ("Error ", _tmp108_, " while preparing query", NULL);
			_tmp110_ = _tmp109_;
			g_warning ("autosave-manager.vala:506: %s", _tmp110_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp108_);
		}
		_tmp111_ = stmt2;
		_tmp112_ = g_direct_hash;
		_tmp113_ = new_page;
		_tmp114_ = _tmp112_ (_tmp113_);
		sqlite3_bind_int64 (_tmp111_, 1, (gint64) _tmp114_);
		_tmp115_ = stmt2;
		_tmp116_ = g_direct_hash;
		_tmp117_ = *book;
		_tmp118_ = _tmp116_ (_tmp117_);
		sqlite3_bind_int64 (_tmp115_, 2, (gint64) _tmp118_);
		_tmp119_ = stmt2;
		_tmp120_ = self->priv->cur_book_revision;
		sqlite3_bind_int64 (_tmp119_, 3, (gint64) _tmp120_);
		_tmp121_ = stmt2;
		_tmp122_ = sqlite3_step (_tmp121_);
		result2 = _tmp122_;
		_tmp123_ = result2;
		if (_tmp123_ != SQLITE_DONE) {
			gint _tmp124_;
			_tmp124_ = _result_;
			g_warning ("autosave-manager.vala:513: Error %d while executing query", _tmp124_);
		}
		_sqlite3_finalize0 (stmt2);
		new_pixels = (g_free (new_pixels), NULL);
		_page_unref0 (new_page);
	}
	_tmp125_ = first;
	if (_tmp125_) {
		g_debug ("autosave-manager.vala:517: No pages found to recover");
	}
	_g_free0 (query);
	_sqlite3_finalize0 (stmt);
}


Book* autosave_manager_get_book (AutosaveManager* self) {
	Book* result;
	Book* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_book;
	result = _tmp0_;
	return result;
}


static void _autosave_manager_on_page_added_book_page_added (Book* _sender, Page* page, gpointer self) {
	autosave_manager_on_page_added (self, page);
}


static void _autosave_manager_on_page_removed_book_page_removed (Book* _sender, Page* page, gpointer self) {
	autosave_manager_on_page_removed (self, page);
}


static void _autosave_manager_on_reordered_book_reordered (Book* _sender, gpointer self) {
	autosave_manager_on_reordered (self);
}


static void _autosave_manager_on_cleared_book_cleared (Book* _sender, gpointer self) {
	autosave_manager_on_cleared (self);
}


static gpointer _book_ref0 (gpointer self) {
	return self ? book_ref (self) : NULL;
}


void autosave_manager_set_book (AutosaveManager* self, Book* value) {
	Book* _tmp0_;
	Book* _tmp19_;
	Book* _tmp20_;
	Book* _tmp21_;
	Book* _tmp22_;
	Book* _tmp23_;
	Book* _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_book;
	if (_tmp0_ != NULL) {
		Book* _tmp11_;
		guint _tmp12_ = 0U;
		Book* _tmp13_;
		guint _tmp14_ = 0U;
		Book* _tmp15_;
		guint _tmp16_ = 0U;
		Book* _tmp17_;
		guint _tmp18_ = 0U;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp1_;
				_tmp1_ = TRUE;
				while (TRUE) {
					gboolean _tmp2_;
					gint _tmp4_;
					Book* _tmp5_;
					guint _tmp6_ = 0U;
					Book* _tmp7_;
					gint _tmp8_;
					Page* _tmp9_ = NULL;
					Page* page;
					Page* _tmp10_;
					_tmp2_ = _tmp1_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp4_ = i;
					_tmp5_ = self->priv->_book;
					_tmp6_ = book_get_n_pages (_tmp5_);
					if (!(((guint) _tmp4_) < _tmp6_)) {
						break;
					}
					_tmp7_ = self->priv->_book;
					_tmp8_ = i;
					_tmp9_ = book_get_page (_tmp7_, _tmp8_);
					page = _tmp9_;
					_tmp10_ = page;
					autosave_manager_on_page_removed (self, _tmp10_);
					_page_unref0 (page);
				}
			}
		}
		_tmp11_ = self->priv->_book;
		g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp12_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _autosave_manager_on_page_added_book_page_added, self);
		_tmp13_ = self->priv->_book;
		g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp14_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _autosave_manager_on_page_removed_book_page_removed, self);
		_tmp15_ = self->priv->_book;
		g_signal_parse_name ("reordered", TYPE_BOOK, &_tmp16_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _autosave_manager_on_reordered_book_reordered, self);
		_tmp17_ = self->priv->_book;
		g_signal_parse_name ("cleared", TYPE_BOOK, &_tmp18_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp17_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp18_, 0, NULL, (GCallback) _autosave_manager_on_cleared_book_cleared, self);
	}
	_tmp19_ = value;
	_tmp20_ = _book_ref0 (_tmp19_);
	_book_unref0 (self->priv->_book);
	self->priv->_book = _tmp20_;
	_tmp21_ = self->priv->_book;
	g_signal_connect (_tmp21_, "page-added", (GCallback) _autosave_manager_on_page_added_book_page_added, self);
	_tmp22_ = self->priv->_book;
	g_signal_connect (_tmp22_, "page-removed", (GCallback) _autosave_manager_on_page_removed_book_page_removed, self);
	_tmp23_ = self->priv->_book;
	g_signal_connect (_tmp23_, "reordered", (GCallback) _autosave_manager_on_reordered_book_reordered, self);
	_tmp24_ = self->priv->_book;
	g_signal_connect (_tmp24_, "cleared", (GCallback) _autosave_manager_on_cleared_book_cleared, self);
}


static void value_autosave_manager_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_autosave_manager_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		autosave_manager_unref (value->data[0].v_pointer);
	}
}


static void value_autosave_manager_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = autosave_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_autosave_manager_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_autosave_manager_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AutosaveManager* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = autosave_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_autosave_manager_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AutosaveManager** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = autosave_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAutosaveManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AUTOSAVE_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_autosave_manager (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER), NULL);
	return value->data[0].v_pointer;
}


void value_set_autosave_manager (GValue* value, gpointer v_object) {
	AutosaveManager* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUTOSAVE_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		autosave_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		autosave_manager_unref (old);
	}
}


void value_take_autosave_manager (GValue* value, gpointer v_object) {
	AutosaveManager* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUTOSAVE_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		autosave_manager_unref (old);
	}
}


static void autosave_manager_class_init (AutosaveManagerClass * klass) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	pid_t _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	autosave_manager_parent_class = g_type_class_peek_parent (klass);
	AUTOSAVE_MANAGER_CLASS (klass)->finalize = autosave_manager_finalize;
	g_type_class_add_private (klass, sizeof (AutosaveManagerPrivate));
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "simple-scan", "autosaves", NULL);
	autosave_manager_AUTOSAVE_DIR = _tmp1_;
	_tmp2_ = g_strdup ("autosaves");
	autosave_manager_AUTOSAVE_NAME = _tmp2_;
	_tmp3_ = g_strdup (".db");
	autosave_manager_AUTOSAVE_EXT = _tmp3_;
	_tmp4_ = autosave_manager_AUTOSAVE_DIR;
	_tmp5_ = autosave_manager_AUTOSAVE_NAME;
	_tmp6_ = autosave_manager_AUTOSAVE_EXT;
	_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_build_filename (_tmp4_, _tmp8_, NULL);
	autosave_manager_AUTOSAVE_FILENAME = _tmp9_;
	_tmp10_ = getpid ();
	_tmp11_ = g_strdup_printf ("%i", (gint) _tmp10_);
	autosave_manager_PID = _tmp11_;
}


static void autosave_manager_instance_init (AutosaveManager * self) {
	self->priv = AUTOSAVE_MANAGER_GET_PRIVATE (self);
	self->priv->_book = NULL;
	self->priv->cur_book_revision = 0;
	self->ref_count = 1;
}


static void autosave_manager_finalize (AutosaveManager* obj) {
	AutosaveManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AUTOSAVE_MANAGER, AutosaveManager);
	_sqlite3_close0 (self->priv->database_connection);
	_book_unref0 (self->priv->_book);
}


GType autosave_manager_get_type (void) {
	static volatile gsize autosave_manager_type_id__volatile = 0;
	if (g_once_init_enter (&autosave_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_autosave_manager_init, value_autosave_manager_free_value, value_autosave_manager_copy_value, value_autosave_manager_peek_pointer, "p", value_autosave_manager_collect_value, "p", value_autosave_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AutosaveManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) autosave_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AutosaveManager), 0, (GInstanceInitFunc) autosave_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType autosave_manager_type_id;
		autosave_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AutosaveManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&autosave_manager_type_id__volatile, autosave_manager_type_id);
	}
	return autosave_manager_type_id__volatile;
}


gpointer autosave_manager_ref (gpointer instance) {
	AutosaveManager* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void autosave_manager_unref (gpointer instance) {
	AutosaveManager* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AUTOSAVE_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



