/* autosave-manager.c generated by valac 0.20.1, the Vala compiler
 * generated from autosave-manager.vala, do not modify */

/*
 * Copyright (C) 2011 Timo Kluck
 * Author: Timo Kluck <tkluck@infty.nl>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*
 * We store autosaves in a database named
 *    ~/.cache/simple-scan/autosaves/autosaves.db
 * It contains a single table of pages, each containing the process id (pid) of
 * the simple-scan instance that saved it, and a hash of the Book and Page
 * objects corresponding to it. The pixels are saved as a BLOB.
 * Additionally, the autosaves directory contains a number of tiff files that
 * the user can use for manual recovery.
 *
 * At startup, we check whether autosaves.db contains any records
 * with a pid that does not match a current pid for simple-scan. If so, we take
 * ownership by an UPDATE statement changing to our own pid. Then, we
 * recover the book. We're trying our best to avoid the possible race
 * condition if several instances of simple-scan are started simultaneously.
 *
 * At application exit, we delete the records corresponding to our own pid.
 *
 * Important notes:
 *  - We enforce that there is only one AutosaveManager instance in a given
 *    process by using a create function.
 *  - It should be possible to change the book object at runtime, although this
 *    is not used in the current implementation so it has not been tested.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;
typedef struct _AutosaveManagerPrivate AutosaveManagerPrivate;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))
#define _autosave_manager_unref0(var) ((var == NULL) ? NULL : (var = (autosave_manager_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
#define _scan_page_info_unref0(var) ((var == NULL) ? NULL : (var = (scan_page_info_unref (var), NULL)))
typedef struct _ParamSpecAutosaveManager ParamSpecAutosaveManager;

struct _AutosaveManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AutosaveManagerPrivate * priv;
};

struct _AutosaveManagerClass {
	GTypeClass parent_class;
	void (*finalize) (AutosaveManager *self);
};

struct _AutosaveManagerPrivate {
	sqlite3* database_connection;
	Book* _book;
	gint cur_book_revision;
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

struct _ParamSpecAutosaveManager {
	GParamSpec parent_instance;
};


static gpointer autosave_manager_parent_class = NULL;
static gchar* autosave_manager_AUTOSAVE_DIR;
static gchar* autosave_manager_AUTOSAVE_DIR = NULL;
static gchar* autosave_manager_AUTOSAVE_NAME;
static gchar* autosave_manager_AUTOSAVE_NAME = NULL;
static gchar* autosave_manager_AUTOSAVE_EXT;
static gchar* autosave_manager_AUTOSAVE_EXT = NULL;
static gchar* autosave_manager_AUTOSAVE_FILENAME;
static gchar* autosave_manager_AUTOSAVE_FILENAME = NULL;
static gchar* autosave_manager_PID;
static gchar* autosave_manager_PID = NULL;
static gint autosave_manager_number_of_instances;
static gint autosave_manager_number_of_instances = 0;

gpointer autosave_manager_ref (gpointer instance);
void autosave_manager_unref (gpointer instance);
GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_autosave_manager (GValue* value, gpointer v_object);
void value_take_autosave_manager (GValue* value, gpointer v_object);
gpointer value_get_autosave_manager (const GValue* value);
GType autosave_manager_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
#define AUTOSAVE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AUTOSAVE_MANAGER, AutosaveManagerPrivate))
enum  {
	AUTOSAVE_MANAGER_DUMMY_PROPERTY
};
AutosaveManager* autosave_manager_create (Book** book);
static AutosaveManager* autosave_manager_new (void);
static AutosaveManager* autosave_manager_construct (GType object_type);
static sqlite3* autosave_manager_open_database_connection (GError** error);
static void autosave_manager_recover_book (AutosaveManager* self, Book** book);
void autosave_manager_set_book (AutosaveManager* self, Book* value);
guint book_get_n_pages (Book* self);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
Page* book_get_page (Book* self, gint page_number);
static void autosave_manager_on_page_added (AutosaveManager* self, Page* page);
void autosave_manager_cleanup (AutosaveManager* self);
static void autosave_manager_insert_page (AutosaveManager* self, Page* page);
void autosave_manager_on_page_changed (AutosaveManager* self, Page* page);
static void _autosave_manager_on_page_changed_page_size_changed (Page* _sender, gpointer self);
static void _autosave_manager_on_page_changed_page_scan_direction_changed (Page* _sender, gpointer self);
static void _autosave_manager_on_page_changed_page_crop_changed (Page* _sender, gpointer self);
static void _autosave_manager_on_page_changed_page_scan_finished (Page* _sender, gpointer self);
void autosave_manager_on_page_removed (AutosaveManager* self, Page* page);
static void _autosave_manager_on_page_changed_page_pixels_changed (Page* _sender, gpointer self);
Book* autosave_manager_get_book (AutosaveManager* self);
void autosave_manager_on_reordered (AutosaveManager* self);
static void autosave_manager_update_page (AutosaveManager* self, Page* page);
void autosave_manager_on_needs_saving_changed (AutosaveManager* self, Book* book);
void autosave_manager_on_cleared (AutosaveManager* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
guint book_get_page_index (Book* self, Page* page);
gint page_get_dpi (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gint page_get_depth (Page* self);
gint page_get_n_channels (Page* self);
gint page_get_rowstride (Page* self);
GType scan_direction_get_type (void) G_GNUC_CONST;
ScanDirection page_get_scan_direction (Page* self);
gchar* page_get_color_profile (Page* self);
guchar* page_get_pixels (Page* self, int* result_length1);
void book_clear (Book* self);
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
ScanPageInfo* scan_page_info_new (void);
ScanPageInfo* scan_page_info_construct (GType object_type);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
void page_set_page_info (Page* self, ScanPageInfo* info);
void page_set_color_profile (Page* self, const gchar* color_profile);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
void page_set_pixels (Page* self, guchar* new_pixels, int new_pixels_length1);
static void _autosave_manager_on_page_added_book_page_added (Book* _sender, Page* page, gpointer self);
static void _autosave_manager_on_page_removed_book_page_removed (Book* _sender, Page* page, gpointer self);
static void _autosave_manager_on_reordered_book_reordered (Book* _sender, gpointer self);
static void _autosave_manager_on_cleared_book_cleared (Book* _sender, gpointer self);
static void autosave_manager_finalize (AutosaveManager* obj);


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
#line 1085 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1086 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1086 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1087 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1087 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1088 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _result_;
#line 1088 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 267 "autosave-manager.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1274 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1275 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = self;
#line 1275 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 279 "autosave-manager.c"
}


AutosaveManager* autosave_manager_create (Book** book) {
	AutosaveManager* result = NULL;
	gint _tmp0_;
	AutosaveManager* _tmp1_;
	AutosaveManager* man;
	gint _tmp2_;
	gboolean any_pages_recovered;
	AutosaveManager* _tmp51_;
	Book* _tmp52_;
	gboolean _tmp53_;
	GError * _inner_error_ = NULL;
#line 77 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_val_if_fail (*book != NULL, NULL);
#line 84 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp0_ = autosave_manager_number_of_instances;
#line 84 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_tmp0_ > 0) {
#line 85 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_assert_not_reached ();
#line 302 "autosave-manager.c"
	}
#line 87 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp1_ = autosave_manager_new ();
#line 87 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	man = _tmp1_;
#line 88 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp2_ = autosave_manager_number_of_instances;
#line 88 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_number_of_instances = _tmp2_ + 1;
#line 312 "autosave-manager.c"
	{
		sqlite3* _tmp3_ = NULL;
		sqlite3* _tmp4_;
		AutosaveManager* _tmp5_;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp3_ = autosave_manager_open_database_connection (&_inner_error_);
#line 92 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp4_ = _tmp3_;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (_inner_error_ != NULL) {
#line 323 "autosave-manager.c"
			goto __catch23_g_error;
		}
#line 92 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp5_ = man;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_sqlite3_close0 (_tmp5_->priv->database_connection);
#line 92 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp5_->priv->database_connection = _tmp4_;
#line 332 "autosave-manager.c"
	}
	goto __finally23;
	__catch23_g_error:
	{
#line 90 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 90 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 96 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:96: Could not connect to the autosave database; " \
"no autosaves will be kept.");
#line 97 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		result = NULL;
#line 97 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_autosave_manager_unref0 (man);
#line 97 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		return result;
#line 349 "autosave-manager.c"
	}
	__finally23:
#line 90 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_inner_error_ != NULL) {
#line 90 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_autosave_manager_unref0 (man);
#line 90 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 90 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 90 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		return NULL;
#line 362 "autosave-manager.c"
	}
#line 100 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	any_pages_recovered = FALSE;
#line 366 "autosave-manager.c"
	{
		gchar* current_pids = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		sqlite3_stmt* stmt = NULL;
		const gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* query;
		AutosaveManager* _tmp12_;
		sqlite3* _tmp13_;
		const gchar* _tmp14_;
		sqlite3_stmt* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _result_;
		gint _tmp17_;
#line 105 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_spawn_command_line_sync ("pidof simple-scan | sed \"s/ /,/g\"", &_tmp6_, NULL, NULL, &_inner_error_);
#line 105 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (current_pids);
#line 105 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		current_pids = _tmp6_;
#line 105 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (_inner_error_ != NULL) {
#line 105 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_g_free0 (current_pids);
#line 105 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 396 "autosave-manager.c"
				goto __catch24_g_spawn_error;
			}
#line 105 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_g_free0 (current_pids);
#line 105 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_autosave_manager_unref0 (man);
#line 105 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 105 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			g_clear_error (&_inner_error_);
#line 105 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			return NULL;
#line 409 "autosave-manager.c"
		}
#line 106 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp7_ = current_pids;
#line 106 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp8_ = string_strip (_tmp7_);
#line 106 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (current_pids);
#line 106 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		current_pids = _tmp8_;
#line 108 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp9_ = current_pids;
#line 108 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp10_ = string_to_string (_tmp9_);
#line 108 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp11_ = g_strconcat ("\n" \
"                   SELECT process_id, book_hash, book_revision FROM pa" \
"ges\n" \
"                   WHERE NOT process_id IN (", _tmp10_, ")\n                   LIMIT 1\n                ", NULL);
#line 108 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		query = _tmp11_;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp12_ = man;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp13_ = _tmp12_->priv->database_connection;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp14_ = query;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp16_ = sqlite3_prepare_v2 (_tmp13_, _tmp14_, -1, &_tmp15_, NULL);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_sqlite3_finalize0 (stmt);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		stmt = _tmp15_;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_result_ = _tmp16_;
#line 115 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp17_ = _result_;
#line 115 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (_tmp17_ == SQLITE_OK) {
#line 117 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			while (TRUE) {
#line 447 "autosave-manager.c"
				sqlite3_stmt* _tmp18_;
				gint _tmp19_ = 0;
				sqlite3_stmt* _tmp20_;
				gint _tmp21_ = 0;
				gint unowned_pid;
				sqlite3_stmt* _tmp22_;
				gint _tmp23_ = 0;
				gint book_hash;
				sqlite3_stmt* _tmp24_;
				gint _tmp25_ = 0;
				gint book_revision;
				const gchar* _tmp26_;
				const gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				sqlite3_stmt* stmt2 = NULL;
				AutosaveManager* _tmp29_;
				sqlite3* _tmp30_;
				const gchar* _tmp31_;
				sqlite3_stmt* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				gint _tmp34_;
				sqlite3_stmt* _tmp39_;
				gint _tmp40_;
				sqlite3_stmt* _tmp41_;
				gint _tmp42_;
				sqlite3_stmt* _tmp43_;
				gint _tmp44_;
				sqlite3_stmt* _tmp45_;
				gint _tmp46_ = 0;
				gint _tmp47_;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp18_ = stmt;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp19_ = sqlite3_step (_tmp18_);
#line 117 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				if (!(_tmp19_ == SQLITE_ROW)) {
#line 117 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					break;
#line 486 "autosave-manager.c"
				}
#line 119 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				g_debug ("autosave-manager.vala:119: Found at least one autosave page, taking ow" \
"nership");
#line 120 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp20_ = stmt;
#line 120 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp21_ = sqlite3_column_int (_tmp20_, 0);
#line 120 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				unowned_pid = _tmp21_;
#line 121 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp22_ = stmt;
#line 121 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp23_ = sqlite3_column_int (_tmp22_, 1);
#line 121 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				book_hash = _tmp23_;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp24_ = stmt;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp25_ = sqlite3_column_int (_tmp24_, 2);
#line 122 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				book_revision = _tmp25_;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp26_ = autosave_manager_PID;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp27_ = string_to_string (_tmp26_);
#line 129 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp28_ = g_strconcat ("\n" \
"                        UPDATE pages\n" \
"                           SET process_id = ", _tmp27_, "\n" \
"                         WHERE process_id = ?2\n" \
"                           AND book_hash = ?3\n" \
"                           AND book_revision = ?4", NULL);
#line 129 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_g_free0 (query);
#line 129 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				query = _tmp28_;
#line 136 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp29_ = man;
#line 136 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp30_ = _tmp29_->priv->database_connection;
#line 136 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp31_ = query;
#line 136 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp33_ = sqlite3_prepare_v2 (_tmp30_, _tmp31_, -1, &_tmp32_, NULL);
#line 136 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_sqlite3_finalize0 (stmt2);
#line 136 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				stmt2 = _tmp32_;
#line 136 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_result_ = _tmp33_;
#line 137 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp34_ = _result_;
#line 137 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				if (_tmp34_ != SQLITE_OK) {
#line 536 "autosave-manager.c"
					const gchar* _tmp35_;
					const gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					gchar* _tmp38_;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp35_ = query;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp36_ = string_to_string (_tmp35_);
#line 138 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp37_ = g_strconcat ("Error preparing statement: ", _tmp36_, NULL);
#line 138 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp38_ = _tmp37_;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					g_warning ("autosave-manager.vala:138: %s", _tmp38_);
#line 138 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_g_free0 (_tmp38_);
#line 553 "autosave-manager.c"
				}
#line 140 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp39_ = stmt2;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp40_ = unowned_pid;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				sqlite3_bind_int64 (_tmp39_, 2, (gint64) _tmp40_);
#line 141 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp41_ = stmt2;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp42_ = book_hash;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				sqlite3_bind_int64 (_tmp41_, 3, (gint64) _tmp42_);
#line 142 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp43_ = stmt2;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp44_ = book_revision;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				sqlite3_bind_int64 (_tmp43_, 4, (gint64) _tmp44_);
#line 143 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp45_ = stmt2;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp46_ = sqlite3_step (_tmp45_);
#line 143 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_result_ = _tmp46_;
#line 144 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp47_ = _result_;
#line 144 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				if (_tmp47_ == SQLITE_DONE) {
#line 583 "autosave-manager.c"
					AutosaveManager* _tmp48_;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					any_pages_recovered = TRUE;
#line 147 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp48_ = man;
#line 147 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					autosave_manager_recover_book (_tmp48_, book);
#line 591 "autosave-manager.c"
				} else {
					gint _tmp49_;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp49_ = _result_;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					g_warning ("autosave-manager.vala:150: Error %d while executing query", _tmp49_);
#line 598 "autosave-manager.c"
				}
#line 117 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_sqlite3_finalize0 (stmt2);
#line 602 "autosave-manager.c"
			}
		} else {
			gint _tmp50_;
#line 154 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp50_ = _result_;
#line 154 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			g_warning ("autosave-manager.vala:154: Error %d while preparing statement", _tmp50_);
#line 610 "autosave-manager.c"
		}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (query);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_sqlite3_finalize0 (stmt);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (current_pids);
#line 618 "autosave-manager.c"
	}
	goto __finally24;
	__catch24_g_spawn_error:
	{
		GError* e = NULL;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		e = _inner_error_;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:158: Could not obtain current process ids; not r" \
"estoring any autosaves");
#line 101 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 632 "autosave-manager.c"
	}
	__finally24:
#line 101 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_inner_error_ != NULL) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_autosave_manager_unref0 (man);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		return NULL;
#line 645 "autosave-manager.c"
	}
#line 161 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp51_ = man;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp52_ = *book;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_set_book (_tmp51_, _tmp52_);
#line 162 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp53_ = any_pages_recovered;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (!_tmp53_) {
#line 657 "autosave-manager.c"
		{
			gint i;
#line 164 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			i = 0;
#line 662 "autosave-manager.c"
			{
				gboolean _tmp54_;
#line 164 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp54_ = TRUE;
#line 164 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				while (TRUE) {
#line 669 "autosave-manager.c"
					gboolean _tmp55_;
					gint _tmp57_;
					Book* _tmp58_;
					guint _tmp59_ = 0U;
					Book* _tmp60_;
					gint _tmp61_;
					Page* _tmp62_ = NULL;
					Page* page;
					AutosaveManager* _tmp63_;
					Page* _tmp64_;
#line 164 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp55_ = _tmp54_;
#line 164 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					if (!_tmp55_) {
#line 684 "autosave-manager.c"
						gint _tmp56_;
#line 164 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
						_tmp56_ = i;
#line 164 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
						i = _tmp56_ + 1;
#line 690 "autosave-manager.c"
					}
#line 164 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp54_ = FALSE;
#line 164 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp57_ = i;
#line 164 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp58_ = *book;
#line 164 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp59_ = book_get_n_pages (_tmp58_);
#line 164 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					if (!(((guint) _tmp57_) < _tmp59_)) {
#line 164 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
						break;
#line 704 "autosave-manager.c"
					}
#line 166 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp60_ = *book;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp61_ = i;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp62_ = book_get_page (_tmp60_, _tmp61_);
#line 166 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					page = _tmp62_;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp63_ = man;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp64_ = page;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					autosave_manager_on_page_added (_tmp63_, _tmp64_);
#line 164 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_page_unref0 (page);
#line 722 "autosave-manager.c"
				}
			}
		}
	}
#line 171 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	result = man;
#line 171 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	return result;
#line 731 "autosave-manager.c"
}


static AutosaveManager* autosave_manager_construct (GType object_type) {
	AutosaveManager* self = NULL;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	self = (AutosaveManager*) g_type_create_instance (object_type);
#line 174 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	return self;
#line 741 "autosave-manager.c"
}


static AutosaveManager* autosave_manager_new (void) {
#line 174 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	return autosave_manager_construct (TYPE_AUTOSAVE_MANAGER);
#line 748 "autosave-manager.c"
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	const gchar* _tmp0_;
	sqlite3_callback _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint ec;
	const gchar* _tmp6_;
#line 34 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 34 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	g_return_val_if_fail (sql != NULL, 0);
#line 36 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	_tmp0_ = sql;
#line 36 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	_tmp1_ = callback;
#line 36 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	_tmp1__target = callback_target;
#line 36 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
#line 36 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	sqlite_errmsg = _tmp2_;
#line 36 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	ec = _tmp3_;
#line 37 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	if ((&_vala_errmsg) != NULL) {
#line 781 "autosave-manager.c"
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 38 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
		_tmp4_ = sqlite_errmsg;
#line 38 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
		_tmp5_ = g_strdup (_tmp4_);
#line 38 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 38 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
		_vala_errmsg = _tmp5_;
#line 792 "autosave-manager.c"
	}
#line 40 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	_tmp6_ = sqlite_errmsg;
#line 40 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	sqlite3_free ((void*) _tmp6_);
#line 41 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	result = ec;
#line 41 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	if (errmsg) {
#line 41 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
		*errmsg = _vala_errmsg;
#line 804 "autosave-manager.c"
	} else {
#line 41 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 808 "autosave-manager.c"
	}
#line 41 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	return result;
#line 812 "autosave-manager.c"
}


void autosave_manager_cleanup (AutosaveManager* self) {
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gint _tmp5_ = 0;
#line 178 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 180 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:180: Clean exit; deleting autosave records");
#line 181 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp0_ = self->priv->database_connection;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp1_ = autosave_manager_PID;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp2_ = string_to_string (_tmp1_);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp3_ = g_strconcat ("\n            DELETE FROM pages\n                WHERE process_id = ", _tmp2_, "\n        ", NULL);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp4_ = _tmp3_;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp5_ = _sqlite3_exec (_tmp0_, _tmp4_, NULL, NULL, NULL);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_warn_if_fail (_tmp5_ == SQLITE_OK);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (_tmp4_);
#line 843 "autosave-manager.c"
}


static sqlite3* autosave_manager_open_database_connection (GError** error) {
	sqlite3* result = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* autosaves_dir;
	sqlite3* connection = NULL;
	const gchar* _tmp3_;
	sqlite3* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp7_;
	gchar* query;
	sqlite3* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_ = 0;
	gint _result_;
	gint _tmp11_;
	GError * _inner_error_ = NULL;
#line 189 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp0_ = autosave_manager_AUTOSAVE_DIR;
#line 189 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp1_ = g_file_new_for_path (_tmp0_);
#line 189 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosaves_dir = _tmp1_;
#line 870 "autosave-manager.c"
	{
		GFile* _tmp2_;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp2_ = autosaves_dir;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_file_make_directory_with_parents (_tmp2_, NULL, &_inner_error_);
#line 192 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (_inner_error_ != NULL) {
#line 879 "autosave-manager.c"
			goto __catch25_g_error;
		}
	}
	goto __finally25;
	__catch25_g_error:
	{
#line 190 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 190 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 890 "autosave-manager.c"
	}
	__finally25:
#line 190 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_inner_error_ != NULL) {
#line 190 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_propagate_error (error, _inner_error_);
#line 190 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_object_unref0 (autosaves_dir);
#line 190 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		return NULL;
#line 901 "autosave-manager.c"
	}
#line 199 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp3_ = autosave_manager_AUTOSAVE_FILENAME;
#line 199 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp5_ = sqlite3_open (_tmp3_, &_tmp4_);
#line 199 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_sqlite3_close0 (connection);
#line 199 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	connection = _tmp4_;
#line 199 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_tmp5_ != SQLITE_OK) {
#line 913 "autosave-manager.c"
		GError* _tmp6_;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp6_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Could not connect to autosave database");
#line 200 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_inner_error_ = _tmp6_;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_propagate_error (error, _inner_error_);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_sqlite3_close0 (connection);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_object_unref0 (autosaves_dir);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		return NULL;
#line 927 "autosave-manager.c"
	}
#line 201 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp7_ = g_strdup ("\n" \
"            CREATE TABLE IF NOT EXISTS pages (\n" \
"                id integer PRIMARY KEY,\n" \
"                process_id integer,\n" \
"                page_hash integer,\n" \
"                book_hash integer,\n" \
"                book_revision integer,\n" \
"                page_number integer,\n" \
"                dpi integer,\n" \
"                width integer,\n" \
"                height integer,\n" \
"                depth integer,\n" \
"                n_channels integer,\n" \
"                rowstride integer,\n" \
"                color_profile string,\n" \
"                crop_x integer,\n" \
"                crop_y integer,\n" \
"                crop_width integer,\n" \
"                crop_height integer,\n" \
"                scan_direction integer,\n" \
"                pixels binary\n" \
"            )");
#line 201 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	query = _tmp7_;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp8_ = connection;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp9_ = query;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp10_ = _sqlite3_exec (_tmp8_, _tmp9_, NULL, NULL, NULL);
#line 223 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_result_ = _tmp10_;
#line 224 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp11_ = _result_;
#line 224 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_tmp11_ != SQLITE_OK) {
#line 945 "autosave-manager.c"
		gint _tmp12_;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp12_ = _result_;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:225: Error %d while executing query", _tmp12_);
#line 951 "autosave-manager.c"
	}
#line 226 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	result = connection;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (query);
#line 226 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_object_unref0 (autosaves_dir);
#line 226 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	return result;
#line 961 "autosave-manager.c"
}


static void _autosave_manager_on_page_changed_page_size_changed (Page* _sender, gpointer self) {
#line 233 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_on_page_changed (self, _sender);
#line 968 "autosave-manager.c"
}


static void _autosave_manager_on_page_changed_page_scan_direction_changed (Page* _sender, gpointer self) {
#line 234 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_on_page_changed (self, _sender);
#line 975 "autosave-manager.c"
}


static void _autosave_manager_on_page_changed_page_crop_changed (Page* _sender, gpointer self) {
#line 235 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_on_page_changed (self, _sender);
#line 982 "autosave-manager.c"
}


static void _autosave_manager_on_page_changed_page_scan_finished (Page* _sender, gpointer self) {
#line 236 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_on_page_changed (self, _sender);
#line 989 "autosave-manager.c"
}


static void autosave_manager_on_page_added (AutosaveManager* self, Page* page) {
	Page* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
#line 229 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 229 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 231 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp0_ = page;
#line 231 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_insert_page (self, _tmp0_);
#line 233 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp1_ = page;
#line 233 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_connect (_tmp1_, "size-changed", (GCallback) _autosave_manager_on_page_changed_page_size_changed, self);
#line 234 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp2_ = page;
#line 234 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_connect (_tmp2_, "scan-direction-changed", (GCallback) _autosave_manager_on_page_changed_page_scan_direction_changed, self);
#line 235 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp3_ = page;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_connect (_tmp3_, "crop-changed", (GCallback) _autosave_manager_on_page_changed_page_crop_changed, self);
#line 236 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp4_ = page;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_connect (_tmp4_, "scan-finished", (GCallback) _autosave_manager_on_page_changed_page_scan_finished, self);
#line 1023 "autosave-manager.c"
}


static void _autosave_manager_on_page_changed_page_pixels_changed (Page* _sender, gpointer self) {
#line 241 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_on_page_changed (self, _sender);
#line 1030 "autosave-manager.c"
}


void autosave_manager_on_page_removed (AutosaveManager* self, Page* page) {
	Page* _tmp0_;
	guint _tmp1_ = 0U;
	Page* _tmp2_;
	guint _tmp3_ = 0U;
	Page* _tmp4_;
	guint _tmp5_ = 0U;
	Page* _tmp6_;
	guint _tmp7_ = 0U;
	Page* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* query;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp12_;
	const gchar* _tmp13_;
	sqlite3_stmt* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _result_;
	gint _tmp16_;
	sqlite3_stmt* _tmp22_;
	GHashFunc _tmp23_;
	Page* _tmp24_;
	guint _tmp25_ = 0U;
	sqlite3_stmt* _tmp26_;
	GHashFunc _tmp27_;
	Book* _tmp28_;
	Book* _tmp29_;
	guint _tmp30_ = 0U;
	sqlite3_stmt* _tmp31_;
	gint _tmp32_;
	sqlite3_stmt* _tmp33_;
	gint _tmp34_ = 0;
	gint _tmp35_;
#line 239 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 239 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 241 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp0_ = page;
#line 241 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 241 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _autosave_manager_on_page_changed_page_pixels_changed, self);
#line 242 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp2_ = page;
#line 242 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 242 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _autosave_manager_on_page_changed_page_size_changed, self);
#line 243 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp4_ = page;
#line 243 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 243 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _autosave_manager_on_page_changed_page_scan_direction_changed, self);
#line 244 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp6_ = page;
#line 244 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp7_, NULL, FALSE);
#line 244 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _autosave_manager_on_page_changed_page_crop_changed, self);
#line 245 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp8_ = page;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_connect (_tmp8_, "scan-finished", (GCallback) _autosave_manager_on_page_changed_page_scan_finished, self);
#line 247 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp9_ = autosave_manager_PID;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp10_ = string_to_string (_tmp9_);
#line 247 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp11_ = g_strconcat ("\n        DELETE FROM pages\n            WHERE process_id = ", _tmp10_, "\n" \
"              AND page_hash = ?2\n" \
"              AND book_hash = ?3\n" \
"              AND book_revision = ?4\n" \
"        ", NULL);
#line 247 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	query = _tmp11_;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp12_ = self->priv->database_connection;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp13_ = query;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp15_ = sqlite3_prepare_v2 (_tmp12_, _tmp13_, -1, &_tmp14_, NULL);
#line 255 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_sqlite3_finalize0 (stmt);
#line 255 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	stmt = _tmp14_;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_result_ = _tmp15_;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp16_ = _result_;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_tmp16_ != SQLITE_OK) {
#line 1125 "autosave-manager.c"
		gint _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
#line 257 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp17_ = _result_;
#line 257 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp18_ = g_strdup_printf ("%i", _tmp17_);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp19_ = _tmp18_;
#line 257 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp20_ = g_strconcat ("Error ", _tmp19_, " while preparing query", NULL);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp21_ = _tmp20_;
#line 257 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:257: %s", _tmp21_);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (_tmp21_);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (_tmp19_);
#line 1147 "autosave-manager.c"
	}
#line 258 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp22_ = stmt;
#line 258 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp23_ = g_direct_hash;
#line 258 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp24_ = page;
#line 258 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp25_ = _tmp23_ (_tmp24_);
#line 258 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	sqlite3_bind_int64 (_tmp22_, 2, (gint64) _tmp25_);
#line 259 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp26_ = stmt;
#line 259 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp27_ = g_direct_hash;
#line 259 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp28_ = autosave_manager_get_book (self);
#line 259 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp29_ = _tmp28_;
#line 259 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp30_ = _tmp27_ (_tmp29_);
#line 259 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	sqlite3_bind_int64 (_tmp26_, 3, (gint64) _tmp30_);
#line 260 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp31_ = stmt;
#line 260 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp32_ = self->priv->cur_book_revision;
#line 260 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	sqlite3_bind_int64 (_tmp31_, 4, (gint64) _tmp32_);
#line 262 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp33_ = stmt;
#line 262 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp34_ = sqlite3_step (_tmp33_);
#line 262 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_result_ = _tmp34_;
#line 263 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp35_ = _result_;
#line 263 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_tmp35_ != SQLITE_DONE) {
#line 1187 "autosave-manager.c"
		gint _tmp36_;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp36_ = _result_;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:264: Error %d while executing query", _tmp36_);
#line 1193 "autosave-manager.c"
	}
#line 239 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_sqlite3_finalize0 (stmt);
#line 239 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (query);
#line 1199 "autosave-manager.c"
}


void autosave_manager_on_reordered (AutosaveManager* self) {
#line 267 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 1206 "autosave-manager.c"
	{
		gint i;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		i = 0;
#line 1211 "autosave-manager.c"
		{
			gboolean _tmp0_;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp0_ = TRUE;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			while (TRUE) {
#line 1218 "autosave-manager.c"
				gboolean _tmp1_;
				gint _tmp3_;
				Book* _tmp4_;
				Book* _tmp5_;
				guint _tmp6_ = 0U;
				Book* _tmp7_;
				Book* _tmp8_;
				gint _tmp9_;
				Page* _tmp10_ = NULL;
				Page* page;
				const gchar* _tmp11_;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gchar* query;
				sqlite3_stmt* stmt = NULL;
				sqlite3* _tmp14_;
				const gchar* _tmp15_;
				sqlite3_stmt* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gint _result_;
				gint _tmp18_;
				sqlite3_stmt* _tmp24_;
				gint _tmp25_;
				sqlite3_stmt* _tmp26_;
				GHashFunc _tmp27_;
				Page* _tmp28_;
				guint _tmp29_ = 0U;
				sqlite3_stmt* _tmp30_;
				GHashFunc _tmp31_;
				Book* _tmp32_;
				Book* _tmp33_;
				guint _tmp34_ = 0U;
				sqlite3_stmt* _tmp35_;
				gint _tmp36_;
				sqlite3_stmt* _tmp37_;
				gint _tmp38_ = 0;
				gint _tmp39_;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp1_ = _tmp0_;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				if (!_tmp1_) {
#line 1260 "autosave-manager.c"
					gint _tmp2_;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp2_ = i;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					i = _tmp2_ + 1;
#line 1266 "autosave-manager.c"
				}
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp0_ = FALSE;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp3_ = i;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp4_ = autosave_manager_get_book (self);
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp5_ = _tmp4_;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp6_ = book_get_n_pages (_tmp5_);
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				if (!(((guint) _tmp3_) < _tmp6_)) {
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					break;
#line 1282 "autosave-manager.c"
				}
#line 271 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp7_ = autosave_manager_get_book (self);
#line 271 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp8_ = _tmp7_;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp9_ = i;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp10_ = book_get_page (_tmp8_, _tmp9_);
#line 271 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				page = _tmp10_;
#line 272 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp11_ = autosave_manager_PID;
#line 272 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp12_ = string_to_string (_tmp11_);
#line 272 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp13_ = g_strconcat ("\n" \
"            UPDATE pages SET page_number = ?5\n" \
"            WHERE process_id = ", _tmp12_, "\n" \
"              AND page_hash = ?2\n" \
"              AND book_hash = ?3\n" \
"              AND book_revision = ?4\n" \
"            ", NULL);
#line 272 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				query = _tmp13_;
#line 280 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp14_ = self->priv->database_connection;
#line 280 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp15_ = query;
#line 280 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp17_ = sqlite3_prepare_v2 (_tmp14_, _tmp15_, -1, &_tmp16_, NULL);
#line 280 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_sqlite3_finalize0 (stmt);
#line 280 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				stmt = _tmp16_;
#line 280 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_result_ = _tmp17_;
#line 281 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp18_ = _result_;
#line 281 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				if (_tmp18_ != SQLITE_OK) {
#line 1318 "autosave-manager.c"
					gint _tmp19_;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_;
					gchar* _tmp22_ = NULL;
					gchar* _tmp23_;
#line 282 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp19_ = _result_;
#line 282 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp20_ = g_strdup_printf ("%i", _tmp19_);
#line 282 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp21_ = _tmp20_;
#line 282 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp22_ = g_strconcat ("Error ", _tmp21_, " while preparing query", NULL);
#line 282 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp23_ = _tmp22_;
#line 282 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					g_warning ("autosave-manager.vala:282: %s", _tmp23_);
#line 282 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_g_free0 (_tmp23_);
#line 282 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_g_free0 (_tmp21_);
#line 1340 "autosave-manager.c"
				}
#line 284 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp24_ = stmt;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp25_ = i;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				sqlite3_bind_int64 (_tmp24_, 5, (gint64) _tmp25_);
#line 285 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp26_ = stmt;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp27_ = g_direct_hash;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp28_ = page;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp29_ = _tmp27_ (_tmp28_);
#line 285 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				sqlite3_bind_int64 (_tmp26_, 2, (gint64) _tmp29_);
#line 286 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp30_ = stmt;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp31_ = g_direct_hash;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp32_ = autosave_manager_get_book (self);
#line 286 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp33_ = _tmp32_;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp34_ = _tmp31_ (_tmp33_);
#line 286 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				sqlite3_bind_int64 (_tmp30_, 3, (gint64) _tmp34_);
#line 287 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp35_ = stmt;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp36_ = self->priv->cur_book_revision;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				sqlite3_bind_int64 (_tmp35_, 4, (gint64) _tmp36_);
#line 289 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp37_ = stmt;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp38_ = sqlite3_step (_tmp37_);
#line 289 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_result_ = _tmp38_;
#line 290 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp39_ = _result_;
#line 290 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				if (_tmp39_ != SQLITE_DONE) {
#line 1386 "autosave-manager.c"
					gint _tmp40_;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp40_ = _result_;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					g_warning ("autosave-manager.vala:291: Error %d while executing query", _tmp40_);
#line 1392 "autosave-manager.c"
				}
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_sqlite3_finalize0 (stmt);
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_g_free0 (query);
#line 269 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_page_unref0 (page);
#line 1400 "autosave-manager.c"
			}
		}
	}
}


void autosave_manager_on_page_changed (AutosaveManager* self, Page* page) {
	Page* _tmp0_;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 295 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 297 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp0_ = page;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_update_page (self, _tmp0_);
#line 1417 "autosave-manager.c"
}


void autosave_manager_on_needs_saving_changed (AutosaveManager* self, Book* book) {
#line 300 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 300 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (book != NULL);
#line 1426 "autosave-manager.c"
	{
		gint n;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		n = 0;
#line 1431 "autosave-manager.c"
		{
			gboolean _tmp0_;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp0_ = TRUE;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			while (TRUE) {
#line 1438 "autosave-manager.c"
				gboolean _tmp1_;
				gint _tmp3_;
				Book* _tmp4_;
				guint _tmp5_ = 0U;
				Book* _tmp6_;
				gint _tmp7_;
				Page* _tmp8_ = NULL;
				Page* page;
				Page* _tmp9_;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp1_ = _tmp0_;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				if (!_tmp1_) {
#line 1452 "autosave-manager.c"
					gint _tmp2_;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp2_ = n;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					n = _tmp2_ + 1;
#line 1458 "autosave-manager.c"
				}
#line 302 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp0_ = FALSE;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp3_ = n;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp4_ = book;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp5_ = book_get_n_pages (_tmp4_);
#line 302 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				if (!(((guint) _tmp3_) < _tmp5_)) {
#line 302 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					break;
#line 1472 "autosave-manager.c"
				}
#line 304 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp6_ = book;
#line 304 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp7_ = n;
#line 304 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp8_ = book_get_page (_tmp6_, _tmp7_);
#line 304 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				page = _tmp8_;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp9_ = page;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				autosave_manager_update_page (self, _tmp9_);
#line 302 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_page_unref0 (page);
#line 1488 "autosave-manager.c"
			}
		}
	}
}


void autosave_manager_on_cleared (AutosaveManager* self) {
	gint _tmp0_;
#line 311 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 313 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp0_ = self->priv->cur_book_revision;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	self->priv->cur_book_revision = _tmp0_ + 1;
#line 1503 "autosave-manager.c"
}


static void autosave_manager_insert_page (AutosaveManager* self, Page* page) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* query;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp3_;
	const gchar* _tmp4_;
	sqlite3_stmt* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _result_;
	gint _tmp7_;
	sqlite3_stmt* _tmp13_;
	GHashFunc _tmp14_;
	Page* _tmp15_;
	guint _tmp16_ = 0U;
	sqlite3_stmt* _tmp17_;
	GHashFunc _tmp18_;
	Book* _tmp19_;
	Book* _tmp20_;
	guint _tmp21_ = 0U;
	sqlite3_stmt* _tmp22_;
	gint _tmp23_;
	sqlite3_stmt* _tmp24_;
	gint _tmp25_ = 0;
	gint _tmp26_;
	Page* _tmp28_;
#line 316 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 316 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 318 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:318: Adding an autosave for a new page");
#line 319 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp0_ = autosave_manager_PID;
#line 319 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp1_ = string_to_string (_tmp0_);
#line 319 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp2_ = g_strconcat ("\n" \
"            INSERT INTO pages\n" \
"                (process_id,\n" \
"                page_hash,\n" \
"                book_hash,\n" \
"                book_revision)\n" \
"                VALUES\n" \
"                (", _tmp1_, ",\n" \
"                ?2,\n" \
"                ?3,\n" \
"                ?4)\n" \
"        ", NULL);
#line 319 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	query = _tmp2_;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp3_ = self->priv->database_connection;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp4_ = query;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp6_ = sqlite3_prepare_v2 (_tmp3_, _tmp4_, -1, &_tmp5_, NULL);
#line 332 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_sqlite3_finalize0 (stmt);
#line 332 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	stmt = _tmp5_;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_result_ = _tmp6_;
#line 333 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp7_ = _result_;
#line 333 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_tmp7_ != SQLITE_OK) {
#line 1564 "autosave-manager.c"
		gint _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
#line 334 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp8_ = _result_;
#line 334 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp9_ = g_strdup_printf ("%i", _tmp8_);
#line 334 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp10_ = _tmp9_;
#line 334 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp11_ = g_strconcat ("Error ", _tmp10_, " while preparing query", NULL);
#line 334 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp12_ = _tmp11_;
#line 334 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:334: %s", _tmp12_);
#line 334 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (_tmp12_);
#line 334 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (_tmp10_);
#line 1586 "autosave-manager.c"
	}
#line 336 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp13_ = stmt;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp14_ = g_direct_hash;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp15_ = page;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp16_ = _tmp14_ (_tmp15_);
#line 336 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	sqlite3_bind_int64 (_tmp13_, 2, (gint64) _tmp16_);
#line 337 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp17_ = stmt;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp18_ = g_direct_hash;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp19_ = autosave_manager_get_book (self);
#line 337 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp20_ = _tmp19_;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp21_ = _tmp18_ (_tmp20_);
#line 337 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	sqlite3_bind_int64 (_tmp17_, 3, (gint64) _tmp21_);
#line 338 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp22_ = stmt;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp23_ = self->priv->cur_book_revision;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	sqlite3_bind_int64 (_tmp22_, 4, (gint64) _tmp23_);
#line 340 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp24_ = stmt;
#line 340 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp25_ = sqlite3_step (_tmp24_);
#line 340 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_result_ = _tmp25_;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp26_ = _result_;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_tmp26_ != SQLITE_DONE) {
#line 1626 "autosave-manager.c"
		gint _tmp27_;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp27_ = _result_;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:342: Error %d while executing query", _tmp27_);
#line 1632 "autosave-manager.c"
	}
#line 344 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp28_ = page;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_update_page (self, _tmp28_);
#line 316 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_sqlite3_finalize0 (stmt);
#line 316 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (query);
#line 1642 "autosave-manager.c"
}


static void autosave_manager_update_page (AutosaveManager* self, Page* page) {
	gint crop_x = 0;
	gint crop_y = 0;
	gint crop_width = 0;
	gint crop_height = 0;
	Page* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	sqlite3_stmt* stmt = NULL;
	Book* _tmp5_;
	Book* _tmp6_;
	Page* _tmp7_;
	guint _tmp8_ = 0U;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	Page* _tmp11_;
	gint _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	Page* _tmp15_;
	gint _tmp16_ = 0;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	Page* _tmp19_;
	gint _tmp20_ = 0;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	Page* _tmp23_;
	gint _tmp24_ = 0;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	Page* _tmp27_;
	gint _tmp28_ = 0;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	Page* _tmp31_;
	gint _tmp32_ = 0;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_;
	gint _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	gint _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	gint _tmp41_;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	gint _tmp44_;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_;
	Page* _tmp47_;
	ScanDirection _tmp48_ = 0;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_;
	gchar* query;
	sqlite3* _tmp55_;
	const gchar* _tmp56_;
	sqlite3_stmt* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	gint _result_;
	gint _tmp59_;
	sqlite3_stmt* _tmp61_;
	GHashFunc _tmp62_;
	Page* _tmp63_;
	guint _tmp64_ = 0U;
	sqlite3_stmt* _tmp65_;
	GHashFunc _tmp66_;
	Book* _tmp67_;
	Book* _tmp68_;
	guint _tmp69_ = 0U;
	sqlite3_stmt* _tmp70_;
	gint _tmp71_;
	Page* _tmp72_;
	gchar* _tmp73_ = NULL;
	gchar* _tmp74_;
	const gchar* _tmp75_;
	sqlite3_stmt* _tmp77_;
	const gchar* _tmp78_;
	gchar* _tmp79_;
	GDestroyNotify _tmp80_;
	gint _tmp81_ = 0;
	gint _tmp82_;
	Page* _tmp84_;
	gint _tmp85_ = 0;
	guchar* _tmp86_ = NULL;
	sqlite3_stmt* _tmp99_;
	gint _tmp100_ = 0;
#line 347 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 347 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 349 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:349: Updating the autosave for a page");
#line 355 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp0_ = page;
#line 355 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	page_get_crop (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
#line 355 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	crop_x = _tmp1_;
#line 355 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	crop_y = _tmp2_;
#line 355 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	crop_width = _tmp3_;
#line 355 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	crop_height = _tmp4_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp5_ = autosave_manager_get_book (self);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp6_ = _tmp5_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp7_ = page;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp8_ = book_get_page_index (_tmp6_, _tmp7_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp9_ = g_strdup_printf ("%u", _tmp8_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp10_ = _tmp9_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp11_ = page;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp12_ = page_get_dpi (_tmp11_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp13_ = g_strdup_printf ("%i", _tmp12_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp14_ = _tmp13_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp15_ = page;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp16_ = page_get_width (_tmp15_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp17_ = g_strdup_printf ("%i", _tmp16_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp18_ = _tmp17_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp19_ = page;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp20_ = page_get_height (_tmp19_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp21_ = g_strdup_printf ("%i", _tmp20_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp22_ = _tmp21_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp23_ = page;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp24_ = page_get_depth (_tmp23_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp25_ = g_strdup_printf ("%i", _tmp24_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp26_ = _tmp25_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp27_ = page;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp28_ = page_get_n_channels (_tmp27_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp29_ = g_strdup_printf ("%i", _tmp28_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp30_ = _tmp29_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp31_ = page;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp32_ = page_get_rowstride (_tmp31_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp33_ = g_strdup_printf ("%i", _tmp32_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp34_ = _tmp33_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp35_ = crop_x;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp36_ = g_strdup_printf ("%i", _tmp35_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp37_ = _tmp36_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp38_ = crop_y;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp39_ = g_strdup_printf ("%i", _tmp38_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp40_ = _tmp39_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp41_ = crop_width;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp42_ = g_strdup_printf ("%i", _tmp41_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp43_ = _tmp42_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp44_ = crop_height;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp45_ = g_strdup_printf ("%i", _tmp44_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp46_ = _tmp45_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp47_ = page;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp48_ = page_get_scan_direction (_tmp47_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp49_ = g_strdup_printf ("%i", (gint) _tmp48_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp50_ = _tmp49_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp51_ = autosave_manager_PID;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp52_ = string_to_string (_tmp51_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp53_ = g_strconcat ("\n" \
"            UPDATE pages\n" \
"                SET\n" \
"                page_number=", _tmp10_, ",\n                dpi=", _tmp14_, ",\n                width=", _tmp18_, ",\n                height=", _tmp22_, ",\n                depth=", _tmp26_, ",\n                n_channels=", _tmp30_, ",\n                rowstride=", _tmp34_, ",\n                crop_x=", _tmp37_, ",\n                crop_y=", _tmp40_, ",\n                crop_width=", _tmp43_, ",\n                crop_height=", _tmp46_, ",\n                scan_direction=", _tmp50_, ",\n" \
"                color_profile=?1,\n" \
"                pixels=?2\n" \
"                WHERE process_id = ", _tmp52_, "\n" \
"                  AND page_hash = ?4\n" \
"                  AND book_hash = ?5\n" \
"                  AND book_revision = ?6\n" \
"            ", NULL);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp54_ = _tmp53_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (_tmp50_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (_tmp46_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (_tmp43_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (_tmp40_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (_tmp37_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (_tmp34_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (_tmp30_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (_tmp26_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (_tmp22_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (_tmp18_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (_tmp14_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (_tmp10_);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	query = _tmp54_;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp55_ = self->priv->database_connection;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp56_ = query;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp58_ = sqlite3_prepare_v2 (_tmp55_, _tmp56_, -1, &_tmp57_, NULL);
#line 381 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_sqlite3_finalize0 (stmt);
#line 381 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	stmt = _tmp57_;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_result_ = _tmp58_;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp59_ = _result_;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_tmp59_ != SQLITE_OK) {
#line 1900 "autosave-manager.c"
		gint _tmp60_;
#line 384 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp60_ = _result_;
#line 384 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:384: Error %d while preparing statement", _tmp60_);
#line 385 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (query);
#line 385 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_sqlite3_finalize0 (stmt);
#line 385 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		return;
#line 1912 "autosave-manager.c"
	}
#line 388 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp61_ = stmt;
#line 388 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp62_ = g_direct_hash;
#line 388 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp63_ = page;
#line 388 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp64_ = _tmp62_ (_tmp63_);
#line 388 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	sqlite3_bind_int64 (_tmp61_, 4, (gint64) _tmp64_);
#line 389 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp65_ = stmt;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp66_ = g_direct_hash;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp67_ = autosave_manager_get_book (self);
#line 389 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp68_ = _tmp67_;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp69_ = _tmp66_ (_tmp68_);
#line 389 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	sqlite3_bind_int64 (_tmp65_, 5, (gint64) _tmp69_);
#line 390 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp70_ = stmt;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp71_ = self->priv->cur_book_revision;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	sqlite3_bind_int64 (_tmp70_, 6, (gint64) _tmp71_);
#line 391 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp72_ = page;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp73_ = page_get_color_profile (_tmp72_);
#line 391 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp74_ = _tmp73_;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp75_ = _tmp74_;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_tmp75_ == NULL) {
#line 1952 "autosave-manager.c"
		gchar* _tmp76_;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp76_ = g_strdup ("");
#line 391 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (_tmp74_);
#line 391 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp74_ = _tmp76_;
#line 1960 "autosave-manager.c"
	}
#line 391 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp77_ = stmt;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp78_ = _tmp74_;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp79_ = g_strdup (_tmp78_);
#line 391 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp80_ = g_free;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp81_ = sqlite3_bind_text (_tmp77_, 1, _tmp79_, -1, _tmp80_);
#line 391 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_result_ = _tmp81_;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp82_ = _result_;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_tmp82_ != SQLITE_OK) {
#line 1978 "autosave-manager.c"
		gint _tmp83_;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp83_ = _result_;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:394: Error %d while binding text", _tmp83_);
#line 1984 "autosave-manager.c"
	}
#line 396 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp84_ = page;
#line 396 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp86_ = page_get_pixels (_tmp84_, &_tmp85_);
#line 396 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_tmp86_ != NULL) {
#line 1992 "autosave-manager.c"
		sqlite3_stmt* _tmp87_;
		Page* _tmp88_;
		gint _tmp89_ = 0;
		guchar* _tmp90_ = NULL;
		Page* _tmp91_;
		gint _tmp92_ = 0;
		guchar* _tmp93_ = NULL;
		gint _tmp94_ = 0;
		gint _tmp95_;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp87_ = stmt;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp88_ = page;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp90_ = page_get_pixels (_tmp88_, &_tmp89_);
#line 399 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp91_ = page;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp93_ = page_get_pixels (_tmp91_, &_tmp92_);
#line 399 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp94_ = sqlite3_bind_blob (_tmp87_, 2, _tmp90_, _tmp92_, (GDestroyNotify) (-1));
#line 399 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_result_ = _tmp94_;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp95_ = _result_;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (_tmp95_ != SQLITE_OK) {
#line 2020 "autosave-manager.c"
			gint _tmp96_;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp96_ = _result_;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			g_warning ("autosave-manager.vala:401: Error %d while binding blob", _tmp96_);
#line 2026 "autosave-manager.c"
		}
	} else {
		sqlite3_stmt* _tmp97_;
		gint _tmp98_ = 0;
#line 404 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp97_ = stmt;
#line 404 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp98_ = sqlite3_bind_null (_tmp97_, 2);
#line 404 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_warn_if_fail (_tmp98_ == SQLITE_OK);
#line 2037 "autosave-manager.c"
	}
#line 406 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp99_ = stmt;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp100_ = sqlite3_step (_tmp99_);
#line 406 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_warn_if_fail (_tmp100_ == SQLITE_DONE);
#line 347 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (_tmp74_);
#line 347 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (query);
#line 347 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_sqlite3_finalize0 (stmt);
#line 2051 "autosave-manager.c"
}


static void autosave_manager_recover_book (AutosaveManager* self, Book** book) {
	sqlite3_stmt* stmt = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* query;
	sqlite3* _tmp5_;
	const gchar* _tmp6_;
	sqlite3_stmt* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _result_;
	gint _tmp9_;
	gboolean first;
	gboolean _tmp125_;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 409 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (*book != NULL);
#line 412 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp0_ = autosave_manager_PID;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp1_ = string_to_string (_tmp0_);
#line 412 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp2_ = autosave_manager_PID;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp3_ = string_to_string (_tmp2_);
#line 412 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp4_ = g_strconcat ("\n" \
"            SELECT process_id,\n" \
"                page_hash,\n" \
"                book_hash,\n" \
"                book_revision,\n" \
"                page_number,\n" \
"                dpi,\n" \
"                width,\n" \
"                height,\n" \
"                depth,\n" \
"                n_channels,\n" \
"                rowstride,\n" \
"                color_profile,\n" \
"                crop_x,\n" \
"                crop_y,\n" \
"                crop_width,\n" \
"                crop_height,\n" \
"                scan_direction,\n" \
"                pixels,\n" \
"                id\n" \
"            FROM pages\n" \
"            WHERE process_id = ", _tmp1_, "\n" \
"              AND book_revision = (\n" \
"                  SELECT MAX(book_revision) FROM pages WHERE process_i" \
"d = ", _tmp3_, "\n              )\n            ORDER BY page_number\n        ", NULL);
#line 412 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	query = _tmp4_;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp5_ = self->priv->database_connection;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp6_ = query;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp8_ = sqlite3_prepare_v2 (_tmp5_, _tmp6_, -1, &_tmp7_, NULL);
#line 440 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_sqlite3_finalize0 (stmt);
#line 440 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	stmt = _tmp7_;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_result_ = _tmp8_;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp9_ = _result_;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_tmp9_ != SQLITE_OK) {
#line 2103 "autosave-manager.c"
		gint _tmp10_;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp10_ = _result_;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:442: Error %d while preparing statement", _tmp10_);
#line 2109 "autosave-manager.c"
	}
#line 444 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	first = TRUE;
#line 445 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	while (TRUE) {
#line 2115 "autosave-manager.c"
		sqlite3_stmt* _tmp11_;
		gint _tmp12_ = 0;
		gboolean _tmp13_;
		sqlite3_stmt* _tmp15_;
		gint _tmp16_ = 0;
		gint dpi;
		sqlite3_stmt* _tmp17_;
		gint _tmp18_ = 0;
		gint width;
		sqlite3_stmt* _tmp19_;
		gint _tmp20_ = 0;
		gint height;
		sqlite3_stmt* _tmp21_;
		gint _tmp22_ = 0;
		gint depth;
		sqlite3_stmt* _tmp23_;
		gint _tmp24_ = 0;
		gint n_channels;
		sqlite3_stmt* _tmp25_;
		gint _tmp26_ = 0;
		ScanDirection scan_direction;
		gboolean _tmp27_ = FALSE;
		gint _tmp28_;
		gboolean _tmp30_;
		gint _tmp31_;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		gint _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_;
		Book* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		ScanDirection _tmp43_;
		Page* _tmp44_ = NULL;
		Page* new_page;
		gboolean _tmp45_ = FALSE;
		gint _tmp46_;
		gboolean _tmp48_;
		Page* _tmp64_;
		sqlite3_stmt* _tmp65_;
		const gchar* _tmp66_ = NULL;
		sqlite3_stmt* _tmp67_;
		gint _tmp68_ = 0;
		gint crop_x;
		sqlite3_stmt* _tmp69_;
		gint _tmp70_ = 0;
		gint crop_y;
		sqlite3_stmt* _tmp71_;
		gint _tmp72_ = 0;
		gint crop_width;
		sqlite3_stmt* _tmp73_;
		gint _tmp74_ = 0;
		gint crop_height;
		gboolean _tmp75_ = FALSE;
		gint _tmp76_;
		gboolean _tmp78_;
		sqlite3_stmt* _tmp85_;
		gint _tmp86_ = 0;
		guchar* _tmp87_ = NULL;
		guchar* new_pixels;
		gint new_pixels_length1;
		gint _new_pixels_size_;
		guchar* _tmp88_;
		gint _tmp88__length1;
		sqlite3_stmt* _tmp89_;
		void* _tmp90_ = NULL;
		sqlite3_stmt* _tmp91_;
		gint _tmp92_ = 0;
		Page* _tmp93_;
		guchar* _tmp94_;
		gint _tmp94__length1;
		sqlite3_stmt* _tmp95_;
		gint _tmp96_ = 0;
		gint id;
		gint _tmp97_;
		gchar* _tmp98_ = NULL;
		gchar* _tmp99_;
		gchar* _tmp100_ = NULL;
		sqlite3_stmt* stmt2 = NULL;
		sqlite3* _tmp101_;
		const gchar* _tmp102_;
		sqlite3_stmt* _tmp103_ = NULL;
		gint _tmp104_ = 0;
		gint result2;
		gint _tmp105_;
		sqlite3_stmt* _tmp111_;
		GHashFunc _tmp112_;
		Page* _tmp113_;
		guint _tmp114_ = 0U;
		sqlite3_stmt* _tmp115_;
		GHashFunc _tmp116_;
		Book* _tmp117_;
		guint _tmp118_ = 0U;
		sqlite3_stmt* _tmp119_;
		gint _tmp120_;
		sqlite3_stmt* _tmp121_;
		gint _tmp122_ = 0;
		gint _tmp123_;
#line 445 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp11_ = stmt;
#line 445 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp12_ = sqlite3_step (_tmp11_);
#line 445 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (!(SQLITE_ROW == _tmp12_)) {
#line 445 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			break;
#line 2226 "autosave-manager.c"
		}
#line 447 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_debug ("autosave-manager.vala:447: Found a page that needs to be recovered");
#line 448 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp13_ = first;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (_tmp13_) {
#line 2234 "autosave-manager.c"
			Book* _tmp14_;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp14_ = *book;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			book_clear (_tmp14_);
#line 451 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			first = FALSE;
#line 2242 "autosave-manager.c"
		}
#line 453 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp15_ = stmt;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp16_ = sqlite3_column_int (_tmp15_, 5);
#line 453 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		dpi = _tmp16_;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp17_ = stmt;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp18_ = sqlite3_column_int (_tmp17_, 6);
#line 454 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		width = _tmp18_;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp19_ = stmt;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp20_ = sqlite3_column_int (_tmp19_, 7);
#line 455 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		height = _tmp20_;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp21_ = stmt;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp22_ = sqlite3_column_int (_tmp21_, 8);
#line 456 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		depth = _tmp22_;
#line 457 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp23_ = stmt;
#line 457 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp24_ = sqlite3_column_int (_tmp23_, 9);
#line 457 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		n_channels = _tmp24_;
#line 458 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp25_ = stmt;
#line 458 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp26_ = sqlite3_column_int (_tmp25_, 16);
#line 458 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		scan_direction = (ScanDirection) _tmp26_;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp28_ = width;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (_tmp28_ <= 0) {
#line 460 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp27_ = TRUE;
#line 2286 "autosave-manager.c"
		} else {
			gint _tmp29_;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp29_ = height;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp27_ = _tmp29_ <= 0;
#line 2293 "autosave-manager.c"
		}
#line 460 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp30_ = _tmp27_;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (_tmp30_) {
#line 461 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			continue;
#line 2301 "autosave-manager.c"
		}
#line 463 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp31_ = width;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp32_ = g_strdup_printf ("%i", _tmp31_);
#line 463 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp33_ = _tmp32_;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp34_ = height;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp35_ = g_strdup_printf ("%i", _tmp34_);
#line 463 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp36_ = _tmp35_;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp37_ = g_strconcat ("Restoring a page of size ", _tmp33_, " x ", _tmp36_, NULL);
#line 463 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp38_ = _tmp37_;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_debug ("autosave-manager.vala:463: %s", _tmp38_);
#line 463 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (_tmp38_);
#line 463 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (_tmp36_);
#line 463 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (_tmp33_);
#line 464 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp39_ = *book;
#line 464 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp40_ = width;
#line 464 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp41_ = height;
#line 464 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp42_ = dpi;
#line 464 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp43_ = scan_direction;
#line 464 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp44_ = book_append_page (_tmp39_, _tmp40_, _tmp41_, _tmp42_, _tmp43_);
#line 464 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		new_page = _tmp44_;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp46_ = depth;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (_tmp46_ > 0) {
#line 2345 "autosave-manager.c"
			gint _tmp47_;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp47_ = n_channels;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp45_ = _tmp47_ > 0;
#line 2351 "autosave-manager.c"
		} else {
#line 466 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp45_ = FALSE;
#line 2355 "autosave-manager.c"
		}
#line 466 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp48_ = _tmp45_;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (_tmp48_) {
#line 2361 "autosave-manager.c"
			ScanPageInfo* _tmp49_;
			ScanPageInfo* info;
			ScanPageInfo* _tmp50_;
			gint _tmp51_;
			ScanPageInfo* _tmp52_;
			gint _tmp53_;
			ScanPageInfo* _tmp54_;
			gint _tmp55_;
			ScanPageInfo* _tmp56_;
			gint _tmp57_;
			ScanPageInfo* _tmp58_;
			gint _tmp59_;
			ScanPageInfo* _tmp60_;
			gchar* _tmp61_;
			Page* _tmp62_;
			ScanPageInfo* _tmp63_;
#line 468 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp49_ = scan_page_info_new ();
#line 468 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			info = _tmp49_;
#line 469 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp50_ = info;
#line 469 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp51_ = width;
#line 469 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp50_->width = _tmp51_;
#line 470 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp52_ = info;
#line 470 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp53_ = height;
#line 470 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp52_->height = _tmp53_;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp54_ = info;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp55_ = depth;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp54_->depth = _tmp55_;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp56_ = info;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp57_ = n_channels;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp56_->n_channels = _tmp57_;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp58_ = info;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp59_ = dpi;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp58_->dpi = (gdouble) _tmp59_;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp60_ = info;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp61_ = g_strdup ("");
#line 474 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_g_free0 (_tmp60_->device);
#line 474 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp60_->device = _tmp61_;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp62_ = new_page;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp63_ = info;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			page_set_page_info (_tmp62_, _tmp63_);
#line 466 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_scan_page_info_unref0 (info);
#line 2428 "autosave-manager.c"
		}
#line 478 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp64_ = new_page;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp65_ = stmt;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp66_ = sqlite3_column_text (_tmp65_, 11);
#line 478 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		page_set_color_profile (_tmp64_, _tmp66_);
#line 479 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp67_ = stmt;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp68_ = sqlite3_column_int (_tmp67_, 12);
#line 479 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		crop_x = _tmp68_;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp69_ = stmt;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp70_ = sqlite3_column_int (_tmp69_, 13);
#line 480 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		crop_y = _tmp70_;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp71_ = stmt;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp72_ = sqlite3_column_int (_tmp71_, 14);
#line 481 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		crop_width = _tmp72_;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp73_ = stmt;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp74_ = sqlite3_column_int (_tmp73_, 15);
#line 482 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		crop_height = _tmp74_;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp76_ = crop_width;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (_tmp76_ > 0) {
#line 2466 "autosave-manager.c"
			gint _tmp77_;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp77_ = crop_height;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp75_ = _tmp77_ > 0;
#line 2472 "autosave-manager.c"
		} else {
#line 483 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp75_ = FALSE;
#line 2476 "autosave-manager.c"
		}
#line 483 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp78_ = _tmp75_;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (_tmp78_) {
#line 2482 "autosave-manager.c"
			Page* _tmp79_;
			gint _tmp80_;
			gint _tmp81_;
			Page* _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp79_ = new_page;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp80_ = crop_width;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp81_ = crop_height;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			page_set_custom_crop (_tmp79_, _tmp80_, _tmp81_);
#line 486 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp82_ = new_page;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp83_ = crop_x;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp84_ = crop_y;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			page_move_crop (_tmp82_, _tmp83_, _tmp84_);
#line 2505 "autosave-manager.c"
		}
#line 489 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp85_ = stmt;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp86_ = sqlite3_column_bytes (_tmp85_, 17);
#line 489 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp87_ = g_new0 (guchar, _tmp86_);
#line 489 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		new_pixels = _tmp87_;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		new_pixels_length1 = _tmp86_;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_new_pixels_size_ = new_pixels_length1;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp88_ = new_pixels;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp88__length1 = new_pixels_length1;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp89_ = stmt;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp90_ = sqlite3_column_blob (_tmp89_, 17);
#line 490 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp91_ = stmt;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp92_ = sqlite3_column_bytes (_tmp91_, 17);
#line 490 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		memcpy (_tmp88_, _tmp90_, (gsize) _tmp92_);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp93_ = new_page;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp94_ = new_pixels;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp94__length1 = new_pixels_length1;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		page_set_pixels (_tmp93_, _tmp94_, _tmp94__length1);
#line 493 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp95_ = stmt;
#line 493 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp96_ = sqlite3_column_int (_tmp95_, 18);
#line 493 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		id = _tmp96_;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_debug ("autosave-manager.vala:494: Updating autosave to point to our new copy " \
"of the page");
#line 495 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp97_ = id;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp98_ = g_strdup_printf ("%i", _tmp97_);
#line 495 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp99_ = _tmp98_;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp100_ = g_strconcat ("\n" \
"                UPDATE pages\n" \
"                   SET page_hash=?1,\n" \
"                       book_hash=?2,\n" \
"                       book_revision=?3\n" \
"                WHERE id = ", _tmp99_, "\n            ", NULL);
#line 495 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (query);
#line 495 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		query = _tmp100_;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_g_free0 (_tmp99_);
#line 504 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp101_ = self->priv->database_connection;
#line 504 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp102_ = query;
#line 504 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp104_ = sqlite3_prepare_v2 (_tmp101_, _tmp102_, -1, &_tmp103_, NULL);
#line 504 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_sqlite3_finalize0 (stmt2);
#line 504 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		stmt2 = _tmp103_;
#line 504 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		result2 = _tmp104_;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp105_ = result2;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (_tmp105_ != SQLITE_OK) {
#line 2579 "autosave-manager.c"
			gint _tmp106_;
			gchar* _tmp107_ = NULL;
			gchar* _tmp108_;
			gchar* _tmp109_ = NULL;
			gchar* _tmp110_;
#line 506 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp106_ = result2;
#line 506 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp107_ = g_strdup_printf ("%i", _tmp106_);
#line 506 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp108_ = _tmp107_;
#line 506 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp109_ = g_strconcat ("Error ", _tmp108_, " while preparing query", NULL);
#line 506 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp110_ = _tmp109_;
#line 506 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			g_warning ("autosave-manager.vala:506: %s", _tmp110_);
#line 506 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_g_free0 (_tmp110_);
#line 506 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_g_free0 (_tmp108_);
#line 2601 "autosave-manager.c"
		}
#line 507 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp111_ = stmt2;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp112_ = g_direct_hash;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp113_ = new_page;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp114_ = _tmp112_ (_tmp113_);
#line 507 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		sqlite3_bind_int64 (_tmp111_, 1, (gint64) _tmp114_);
#line 508 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp115_ = stmt2;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp116_ = g_direct_hash;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp117_ = *book;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp118_ = _tmp116_ (_tmp117_);
#line 508 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		sqlite3_bind_int64 (_tmp115_, 2, (gint64) _tmp118_);
#line 509 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp119_ = stmt2;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp120_ = self->priv->cur_book_revision;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		sqlite3_bind_int64 (_tmp119_, 3, (gint64) _tmp120_);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp121_ = stmt2;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp122_ = sqlite3_step (_tmp121_);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		result2 = _tmp122_;
#line 512 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp123_ = result2;
#line 512 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (_tmp123_ != SQLITE_DONE) {
#line 2639 "autosave-manager.c"
			gint _tmp124_;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			_tmp124_ = _result_;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			g_warning ("autosave-manager.vala:513: Error %d while executing query", _tmp124_);
#line 2645 "autosave-manager.c"
		}
#line 445 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_sqlite3_finalize0 (stmt2);
#line 445 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		new_pixels = (g_free (new_pixels), NULL);
#line 445 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_page_unref0 (new_page);
#line 2653 "autosave-manager.c"
	}
#line 516 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp125_ = first;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_tmp125_) {
#line 517 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_debug ("autosave-manager.vala:517: No pages found to recover");
#line 2661 "autosave-manager.c"
	}
#line 409 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_g_free0 (query);
#line 409 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_sqlite3_finalize0 (stmt);
#line 2667 "autosave-manager.c"
}


Book* autosave_manager_get_book (AutosaveManager* self) {
	Book* result;
	Book* _tmp0_;
#line 51 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 53 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp0_ = self->priv->_book;
#line 53 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	result = _tmp0_;
#line 53 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	return result;
#line 2682 "autosave-manager.c"
}


static void _autosave_manager_on_page_added_book_page_added (Book* _sender, Page* page, gpointer self) {
#line 64 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_on_page_added (self, page);
#line 2689 "autosave-manager.c"
}


static void _autosave_manager_on_page_removed_book_page_removed (Book* _sender, Page* page, gpointer self) {
#line 65 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_on_page_removed (self, page);
#line 2696 "autosave-manager.c"
}


static void _autosave_manager_on_reordered_book_reordered (Book* _sender, gpointer self) {
#line 66 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_on_reordered (self);
#line 2703 "autosave-manager.c"
}


static void _autosave_manager_on_cleared_book_cleared (Book* _sender, gpointer self) {
#line 67 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_on_cleared (self);
#line 2710 "autosave-manager.c"
}


static gpointer _book_ref0 (gpointer self) {
#line 69 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	return self ? book_ref (self) : NULL;
#line 2717 "autosave-manager.c"
}


void autosave_manager_set_book (AutosaveManager* self, Book* value) {
	Book* _tmp0_;
	Book* _tmp19_;
	Book* _tmp20_;
	Book* _tmp21_;
	Book* _tmp22_;
	Book* _tmp23_;
	Book* _tmp24_;
#line 55 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 57 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp0_ = self->priv->_book;
#line 57 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (_tmp0_ != NULL) {
#line 2735 "autosave-manager.c"
		Book* _tmp11_;
		guint _tmp12_ = 0U;
		Book* _tmp13_;
		guint _tmp14_ = 0U;
		Book* _tmp15_;
		guint _tmp16_ = 0U;
		Book* _tmp17_;
		guint _tmp18_ = 0U;
		{
			gint i;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			i = 0;
#line 2748 "autosave-manager.c"
			{
				gboolean _tmp1_;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				_tmp1_ = TRUE;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
				while (TRUE) {
#line 2755 "autosave-manager.c"
					gboolean _tmp2_;
					gint _tmp4_;
					Book* _tmp5_;
					guint _tmp6_ = 0U;
					Book* _tmp7_;
					gint _tmp8_;
					Page* _tmp9_ = NULL;
					Page* page;
					Page* _tmp10_;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp2_ = _tmp1_;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					if (!_tmp2_) {
#line 2769 "autosave-manager.c"
						gint _tmp3_;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
						_tmp3_ = i;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
						i = _tmp3_ + 1;
#line 2775 "autosave-manager.c"
					}
#line 59 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp1_ = FALSE;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp4_ = i;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp5_ = self->priv->_book;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp6_ = book_get_n_pages (_tmp5_);
#line 59 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					if (!(((guint) _tmp4_) < _tmp6_)) {
#line 59 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
						break;
#line 2789 "autosave-manager.c"
					}
#line 61 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp7_ = self->priv->_book;
#line 61 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp8_ = i;
#line 61 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp9_ = book_get_page (_tmp7_, _tmp8_);
#line 61 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					page = _tmp9_;
#line 62 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_tmp10_ = page;
#line 62 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					autosave_manager_on_page_removed (self, _tmp10_);
#line 59 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
					_page_unref0 (page);
#line 2805 "autosave-manager.c"
				}
			}
		}
#line 64 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp11_ = self->priv->_book;
#line 64 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp12_, NULL, FALSE);
#line 64 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _autosave_manager_on_page_added_book_page_added, self);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp13_ = self->priv->_book;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp14_, NULL, FALSE);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _autosave_manager_on_page_removed_book_page_removed, self);
#line 66 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp15_ = self->priv->_book;
#line 66 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_signal_parse_name ("reordered", TYPE_BOOK, &_tmp16_, NULL, FALSE);
#line 66 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _autosave_manager_on_reordered_book_reordered, self);
#line 67 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		_tmp17_ = self->priv->_book;
#line 67 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_signal_parse_name ("cleared", TYPE_BOOK, &_tmp18_, NULL, FALSE);
#line 67 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp17_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp18_, 0, NULL, (GCallback) _autosave_manager_on_cleared_book_cleared, self);
#line 2833 "autosave-manager.c"
	}
#line 69 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp19_ = value;
#line 69 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp20_ = _book_ref0 (_tmp19_);
#line 69 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_book_unref0 (self->priv->_book);
#line 69 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	self->priv->_book = _tmp20_;
#line 70 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp21_ = self->priv->_book;
#line 70 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_connect (_tmp21_, "page-added", (GCallback) _autosave_manager_on_page_added_book_page_added, self);
#line 71 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp22_ = self->priv->_book;
#line 71 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_connect (_tmp22_, "page-removed", (GCallback) _autosave_manager_on_page_removed_book_page_removed, self);
#line 72 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp23_ = self->priv->_book;
#line 72 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_connect (_tmp23_, "reordered", (GCallback) _autosave_manager_on_reordered_book_reordered, self);
#line 73 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp24_ = self->priv->_book;
#line 73 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_signal_connect (_tmp24_, "cleared", (GCallback) _autosave_manager_on_cleared_book_cleared, self);
#line 2859 "autosave-manager.c"
}


static void value_autosave_manager_init (GValue* value) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	value->data[0].v_pointer = NULL;
#line 2866 "autosave-manager.c"
}


static void value_autosave_manager_free_value (GValue* value) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (value->data[0].v_pointer) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		autosave_manager_unref (value->data[0].v_pointer);
#line 2875 "autosave-manager.c"
	}
}


static void value_autosave_manager_copy_value (const GValue* src_value, GValue* dest_value) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (src_value->data[0].v_pointer) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		dest_value->data[0].v_pointer = autosave_manager_ref (src_value->data[0].v_pointer);
#line 2885 "autosave-manager.c"
	} else {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2889 "autosave-manager.c"
	}
}


static gpointer value_autosave_manager_peek_pointer (const GValue* value) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	return value->data[0].v_pointer;
#line 2897 "autosave-manager.c"
}


static gchar* value_autosave_manager_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (collect_values[0].v_pointer) {
#line 2904 "autosave-manager.c"
		AutosaveManager* object;
		object = collect_values[0].v_pointer;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		if (object->parent_instance.g_class == NULL) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2911 "autosave-manager.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2915 "autosave-manager.c"
		}
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		value->data[0].v_pointer = autosave_manager_ref (object);
#line 2919 "autosave-manager.c"
	} else {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		value->data[0].v_pointer = NULL;
#line 2923 "autosave-manager.c"
	}
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	return NULL;
#line 2927 "autosave-manager.c"
}


static gchar* value_autosave_manager_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AutosaveManager** object_p;
	object_p = collect_values[0].v_pointer;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (!object_p) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2938 "autosave-manager.c"
	}
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (!value->data[0].v_pointer) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		*object_p = NULL;
#line 2944 "autosave-manager.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		*object_p = value->data[0].v_pointer;
#line 2948 "autosave-manager.c"
	} else {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		*object_p = autosave_manager_ref (value->data[0].v_pointer);
#line 2952 "autosave-manager.c"
	}
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	return NULL;
#line 2956 "autosave-manager.c"
}


GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAutosaveManager* spec;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AUTOSAVE_MANAGER), NULL);
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	return G_PARAM_SPEC (spec);
#line 2970 "autosave-manager.c"
}


gpointer value_get_autosave_manager (const GValue* value) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER), NULL);
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	return value->data[0].v_pointer;
#line 2979 "autosave-manager.c"
}


void value_set_autosave_manager (GValue* value, gpointer v_object) {
	AutosaveManager* old;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER));
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	old = value->data[0].v_pointer;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (v_object) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUTOSAVE_MANAGER));
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		value->data[0].v_pointer = v_object;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		autosave_manager_ref (value->data[0].v_pointer);
#line 2999 "autosave-manager.c"
	} else {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		value->data[0].v_pointer = NULL;
#line 3003 "autosave-manager.c"
	}
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (old) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		autosave_manager_unref (old);
#line 3009 "autosave-manager.c"
	}
}


void value_take_autosave_manager (GValue* value, gpointer v_object) {
	AutosaveManager* old;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER));
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	old = value->data[0].v_pointer;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (v_object) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUTOSAVE_MANAGER));
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		value->data[0].v_pointer = v_object;
#line 3028 "autosave-manager.c"
	} else {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		value->data[0].v_pointer = NULL;
#line 3032 "autosave-manager.c"
	}
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (old) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		autosave_manager_unref (old);
#line 3038 "autosave-manager.c"
	}
}


static void autosave_manager_class_init (AutosaveManagerClass * klass) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	pid_t _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	AUTOSAVE_MANAGER_CLASS (klass)->finalize = autosave_manager_finalize;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_type_class_add_private (klass, sizeof (AutosaveManagerPrivate));
#line 38 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp0_ = g_get_user_cache_dir ();
#line 38 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp1_ = g_build_filename (_tmp0_, "simple-scan", "autosaves", NULL);
#line 38 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_AUTOSAVE_DIR = _tmp1_;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp2_ = g_strdup ("autosaves");
#line 39 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_AUTOSAVE_NAME = _tmp2_;
#line 40 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp3_ = g_strdup (".db");
#line 40 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_AUTOSAVE_EXT = _tmp3_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp4_ = autosave_manager_AUTOSAVE_DIR;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp5_ = autosave_manager_AUTOSAVE_NAME;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp6_ = autosave_manager_AUTOSAVE_EXT;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp8_ = _tmp7_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp9_ = g_build_filename (_tmp4_, _tmp8_, NULL);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_AUTOSAVE_FILENAME = _tmp9_;
#line 43 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp10_ = getpid ();
#line 43 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_tmp11_ = g_strdup_printf ("%i", (gint) _tmp10_);
#line 43 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	autosave_manager_PID = _tmp11_;
#line 3096 "autosave-manager.c"
}


static void autosave_manager_instance_init (AutosaveManager * self) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	self->priv = AUTOSAVE_MANAGER_GET_PRIVATE (self);
#line 47 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	self->priv->_book = NULL;
#line 309 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	self->priv->cur_book_revision = 0;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	self->ref_count = 1;
#line 3109 "autosave-manager.c"
}


static void autosave_manager_finalize (AutosaveManager* obj) {
	AutosaveManager * self;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AUTOSAVE_MANAGER, AutosaveManager);
#line 46 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_sqlite3_close0 (self->priv->database_connection);
#line 47 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	_book_unref0 (self->priv->_book);
#line 3121 "autosave-manager.c"
}


GType autosave_manager_get_type (void) {
	static volatile gsize autosave_manager_type_id__volatile = 0;
	if (g_once_init_enter (&autosave_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_autosave_manager_init, value_autosave_manager_free_value, value_autosave_manager_copy_value, value_autosave_manager_peek_pointer, "p", value_autosave_manager_collect_value, "p", value_autosave_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AutosaveManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) autosave_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AutosaveManager), 0, (GInstanceInitFunc) autosave_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType autosave_manager_type_id;
		autosave_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AutosaveManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&autosave_manager_type_id__volatile, autosave_manager_type_id);
	}
	return autosave_manager_type_id__volatile;
}


gpointer autosave_manager_ref (gpointer instance) {
	AutosaveManager* self;
	self = instance;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	g_atomic_int_inc (&self->ref_count);
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	return instance;
#line 3146 "autosave-manager.c"
}


void autosave_manager_unref (gpointer instance) {
	AutosaveManager* self;
	self = instance;
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		AUTOSAVE_MANAGER_GET_CLASS (self)->finalize (self);
#line 36 "/home/bob/bzr/simple-scan/trunk/src/autosave-manager.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3159 "autosave-manager.c"
	}
}



