// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    NumberUpLayout, PageRange, PageSet, PageSetup, PrintPages, PrintSettings, PrintStatus, Printer,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute, ptr};

glib::wrapper! {
    #[doc(alias = "GtkPrintJob")]
    pub struct PrintJob(Object<ffi::GtkPrintJob>);

    match fn {
        type_ => || ffi::gtk_print_job_get_type(),
    }
}

impl PrintJob {
    #[doc(alias = "gtk_print_job_new")]
    pub fn new(
        title: &str,
        printer: &Printer,
        settings: &PrintSettings,
        page_setup: &PageSetup,
    ) -> PrintJob {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gtk_print_job_new(
                title.to_glib_none().0,
                printer.to_glib_none().0,
                settings.to_glib_none().0,
                page_setup.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_print_job_get_collate")]
    #[doc(alias = "get_collate")]
    pub fn is_collate(&self) -> bool {
        unsafe { from_glib(ffi::gtk_print_job_get_collate(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_print_job_get_n_up")]
    #[doc(alias = "get_n_up")]
    pub fn n_up(&self) -> u32 {
        unsafe { ffi::gtk_print_job_get_n_up(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_print_job_get_n_up_layout")]
    #[doc(alias = "get_n_up_layout")]
    pub fn n_up_layout(&self) -> NumberUpLayout {
        unsafe { from_glib(ffi::gtk_print_job_get_n_up_layout(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_print_job_get_num_copies")]
    #[doc(alias = "get_num_copies")]
    pub fn num_copies(&self) -> i32 {
        unsafe { ffi::gtk_print_job_get_num_copies(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_print_job_get_page_ranges")]
    #[doc(alias = "get_page_ranges")]
    pub fn page_ranges(&self) -> Vec<PageRange> {
        unsafe {
            let mut n_ranges = mem::MaybeUninit::uninit();
            let ret = FromGlibContainer::from_glib_none_num(
                ffi::gtk_print_job_get_page_ranges(self.to_glib_none().0, n_ranges.as_mut_ptr()),
                n_ranges.assume_init() as _,
            );
            ret
        }
    }

    #[doc(alias = "gtk_print_job_get_page_set")]
    #[doc(alias = "get_page_set")]
    pub fn page_set(&self) -> PageSet {
        unsafe { from_glib(ffi::gtk_print_job_get_page_set(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_print_job_get_pages")]
    #[doc(alias = "get_pages")]
    pub fn pages(&self) -> PrintPages {
        unsafe { from_glib(ffi::gtk_print_job_get_pages(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_print_job_get_printer")]
    #[doc(alias = "get_printer")]
    pub fn printer(&self) -> Printer {
        unsafe { from_glib_none(ffi::gtk_print_job_get_printer(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_print_job_get_reverse")]
    #[doc(alias = "get_reverse")]
    pub fn is_reverse(&self) -> bool {
        unsafe { from_glib(ffi::gtk_print_job_get_reverse(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_print_job_get_rotate")]
    #[doc(alias = "get_rotate")]
    pub fn is_rotate(&self) -> bool {
        unsafe { from_glib(ffi::gtk_print_job_get_rotate(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_print_job_get_scale")]
    #[doc(alias = "get_scale")]
    pub fn scale(&self) -> f64 {
        unsafe { ffi::gtk_print_job_get_scale(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_print_job_get_settings")]
    #[doc(alias = "get_settings")]
    pub fn settings(&self) -> PrintSettings {
        unsafe { from_glib_none(ffi::gtk_print_job_get_settings(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_print_job_get_status")]
    #[doc(alias = "get_status")]
    pub fn status(&self) -> PrintStatus {
        unsafe { from_glib(ffi::gtk_print_job_get_status(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_print_job_get_surface")]
    #[doc(alias = "get_surface")]
    pub fn surface(&self) -> Result<cairo::Surface, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::gtk_print_job_get_surface(self.to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_none(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gtk_print_job_get_title")]
    #[doc(alias = "get_title")]
    pub fn title(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_print_job_get_title(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_print_job_get_track_print_status")]
    #[doc(alias = "get_track_print_status")]
    pub fn tracks_print_status(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_print_job_get_track_print_status(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_print_job_set_collate")]
    pub fn set_collate(&self, collate: bool) {
        unsafe {
            ffi::gtk_print_job_set_collate(self.to_glib_none().0, collate.into_glib());
        }
    }

    #[doc(alias = "gtk_print_job_set_n_up")]
    pub fn set_n_up(&self, n_up: u32) {
        unsafe {
            ffi::gtk_print_job_set_n_up(self.to_glib_none().0, n_up);
        }
    }

    #[doc(alias = "gtk_print_job_set_n_up_layout")]
    pub fn set_n_up_layout(&self, layout: NumberUpLayout) {
        unsafe {
            ffi::gtk_print_job_set_n_up_layout(self.to_glib_none().0, layout.into_glib());
        }
    }

    #[doc(alias = "gtk_print_job_set_num_copies")]
    pub fn set_num_copies(&self, num_copies: i32) {
        unsafe {
            ffi::gtk_print_job_set_num_copies(self.to_glib_none().0, num_copies);
        }
    }

    #[doc(alias = "gtk_print_job_set_page_ranges")]
    pub fn set_page_ranges(&self, ranges: &[PageRange]) {
        let n_ranges = ranges.len() as _;
        unsafe {
            ffi::gtk_print_job_set_page_ranges(
                self.to_glib_none().0,
                ranges.to_glib_full(),
                n_ranges,
            );
        }
    }

    #[doc(alias = "gtk_print_job_set_page_set")]
    pub fn set_page_set(&self, page_set: PageSet) {
        unsafe {
            ffi::gtk_print_job_set_page_set(self.to_glib_none().0, page_set.into_glib());
        }
    }

    #[doc(alias = "gtk_print_job_set_pages")]
    pub fn set_pages(&self, pages: PrintPages) {
        unsafe {
            ffi::gtk_print_job_set_pages(self.to_glib_none().0, pages.into_glib());
        }
    }

    #[doc(alias = "gtk_print_job_set_reverse")]
    pub fn set_reverse(&self, reverse: bool) {
        unsafe {
            ffi::gtk_print_job_set_reverse(self.to_glib_none().0, reverse.into_glib());
        }
    }

    #[doc(alias = "gtk_print_job_set_rotate")]
    pub fn set_rotate(&self, rotate: bool) {
        unsafe {
            ffi::gtk_print_job_set_rotate(self.to_glib_none().0, rotate.into_glib());
        }
    }

    #[doc(alias = "gtk_print_job_set_scale")]
    pub fn set_scale(&self, scale: f64) {
        unsafe {
            ffi::gtk_print_job_set_scale(self.to_glib_none().0, scale);
        }
    }

    #[doc(alias = "gtk_print_job_set_source_fd")]
    pub fn set_source_fd(&self, fd: i32) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::gtk_print_job_set_source_fd(self.to_glib_none().0, fd, &mut error);
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gtk_print_job_set_source_file")]
    pub fn set_source_file(
        &self,
        filename: impl AsRef<std::path::Path>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::gtk_print_job_set_source_file(
                self.to_glib_none().0,
                filename.as_ref().to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gtk_print_job_set_track_print_status")]
    pub fn set_track_print_status(&self, track_status: bool) {
        unsafe {
            ffi::gtk_print_job_set_track_print_status(
                self.to_glib_none().0,
                track_status.into_glib(),
            );
        }
    }

    #[doc(alias = "page-setup")]
    pub fn page_setup(&self) -> Option<PageSetup> {
        glib::ObjectExt::property(self, "page-setup")
    }

    #[doc(alias = "status-changed")]
    pub fn connect_status_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn status_changed_trampoline<F: Fn(&PrintJob) + 'static>(
            this: *mut ffi::GtkPrintJob,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"status-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    status_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "track-print-status")]
    pub fn connect_track_print_status_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_track_print_status_trampoline<F: Fn(&PrintJob) + 'static>(
            this: *mut ffi::GtkPrintJob,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::track-print-status\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_track_print_status_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for PrintJob {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("PrintJob")
    }
}
