/*
 * wsdl-locate.c: Find an element structure, given a name
 *
 * Authors:
 *	Dick Porter (dick@ximian.com)
 *
 * Copyright (C) 2001, Ximian, Inc.
 */

#include <glib.h>

#include "wsdl-parse.h"
#include "wsdl-locate.h"

wsdl_porttype_operation *wsdl_locate_porttype_operation(guchar *name, wsdl_porttype *porttype)
{
	GSList *iter;

	g_assert(porttype!=NULL);
	
	iter=porttype->operations;
	while(iter!=NULL) {
		wsdl_porttype_operation *op=iter->data;
		
		g_assert(op!=NULL);
		
		if(!g_strcasecmp(op->name, name)) {
			return(op);
		}
		
		iter=iter->next;
	}
	
	return(NULL);
}

wsdl_message_part *wsdl_locate_message_part(guchar *name,
					    wsdl_message *message)
{
	GSList *iter;

	g_assert(message!=NULL);
	
	iter=message->parts;
	while(iter!=NULL) {
		wsdl_message_part *part=iter->data;
		
		g_assert(part!=NULL);
		
		if(!g_strcasecmp(part->name, name)) {
			return(part);
		}
		
		iter=iter->next;
	}
	
	return(NULL);
}

wsdl_message *wsdl_locate_message(guchar *name, wsdl_definitions *definitions)
{
	GSList *iter;

	g_assert(definitions!=NULL);
	
	iter=definitions->messages;
	while(iter!=NULL) {
		wsdl_message *message=iter->data;
		
		g_assert(message!=NULL);
		
		if(!g_strcasecmp(message->name, name)) {
			return(message);
		}
		
		iter=iter->next;
	}
	
	return(NULL);
}

wsdl_porttype *wsdl_locate_porttype(guchar *name,
				    wsdl_definitions *definitions)
{
	GSList *iter;

	g_assert(definitions!=NULL);
	
	iter=definitions->porttypes;
	while(iter!=NULL) {
		wsdl_porttype *binding=iter->data;
		
		g_assert(binding!=NULL);
		
		if(!g_strcasecmp(binding->name, name)) {
			return(binding);
		}
		
		iter=iter->next;
	}
	
	return(NULL);
}

wsdl_binding *wsdl_locate_binding(guchar *name, wsdl_definitions *definitions)
{
	GSList *iter;

	g_assert(definitions!=NULL);
	
	iter=definitions->bindings;
	while(iter!=NULL) {
		wsdl_binding *binding=iter->data;
		
		g_assert(binding!=NULL);
		
		if(!g_strcasecmp(binding->name, name)) {
			return(binding);
		}
		
		iter=iter->next;
	}
	
	return(NULL);
}
