/* sysprof-version.h.in
 *
 * Copyright (C) 2016 Christian Hergert <christian@hergert.me>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SYSPROF_VERSION_H
#define SYSPROF_VERSION_H

#if !defined(SYSPROF_INSIDE) && !defined(SYSPROF_COMPILATION)
# error "Only <sysprof.h> can be included directly."
#endif

/**
 * SECTION:sysprof-version
 * @short_description: sysprof version checking
 *
 * sysprof provides macros to check the version of the library
 * at compile-time
 */

/**
 * SYSPROF_MAJOR_VERSION:
 *
 * sysprof major version component (e.g. 1 if %SYSPROF_VERSION is 1.2.3)
 */
#define SYSPROF_MAJOR_VERSION (3)

/**
 * SYSPROF_MINOR_VERSION:
 *
 * sysprof minor version component (e.g. 2 if %SYSPROF_VERSION is 1.2.3)
 */
#define SYSPROF_MINOR_VERSION (22)

/**
 * SYSPROF_MICRO_VERSION:
 *
 * sysprof micro version component (e.g. 3 if %SYSPROF_VERSION is 1.2.3)
 */
#define SYSPROF_MICRO_VERSION (1)

/**
 * SYSPROF_VERSION
 *
 * sysprof version.
 */
#define SYSPROF_VERSION (3.22.1)

/**
 * SYSPROF_VERSION_S:
 *
 * sysprof version, encoded as a string, useful for printing and
 * concatenation.
 */
#define SYSPROF_VERSION_S "3.22.1"

#define SYSPROF_ENCODE_VERSION(major,minor,micro) \
        ((major) << 24 | (minor) << 16 | (micro) << 8)

/**
 * SYSPROF_VERSION_HEX:
 *
 * sysprof version, encoded as an hexadecimal number, useful for
 * integer comparisons.
 */
#define SYSPROF_VERSION_HEX \
        (SYSPROF_ENCODE_VERSION (SYSPROF_MAJOR_VERSION, SYSPROF_MINOR_VERSION, SYSPROF_MICRO_VERSION))

/**
 * SYSPROF_CHECK_VERSION:
 * @major: required major version
 * @minor: required minor version
 * @micro: required micro version
 *
 * Compile-time version checking. Evaluates to %TRUE if the version
 * of sysprof is greater than the required one.
 */
#define SYSPROF_CHECK_VERSION(major,minor,micro)   \
        (SYSPROF_MAJOR_VERSION > (major) || \
         (SYSPROF_MAJOR_VERSION == (major) && SYSPROF_MINOR_VERSION > (minor)) || \
         (SYSPROF_MAJOR_VERSION == (major) && SYSPROF_MINOR_VERSION == (minor) && \
          SYSPROF_MICRO_VERSION >= (micro)))

#endif /* SYSPROF_VERSION_H */
