/* tracker-sparql-expression.c generated by valac 0.12.1, the Vala compiler
 * generated from tracker-sparql-expression.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <libtracker-data/tracker-property.h>
#include <libtracker-data/tracker-db-interface-sqlite.h>
#include <libtracker-data/tracker-class.h>
#include <libtracker-data/tracker-collation.h>
#include <libtracker-data/tracker-ontologies.h>


#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;
typedef struct _TrackerSparqlExpressionPrivate TrackerSparqlExpressionPrivate;

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))

struct _TrackerSparqlExpression {
	GObject parent_instance;
	TrackerSparqlExpressionPrivate * priv;
};

struct _TrackerSparqlExpressionClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlExpressionPrivate {
	TrackerSparqlQuery* query;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};


static gpointer tracker_sparql_expression_parent_class = NULL;

GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionPrivate))
enum  {
	TRACKER_SPARQL_EXPRESSION_DUMMY_PROPERTY
};
#define TRACKER_SPARQL_EXPRESSION_MAX_VARIABLES_FOR_IN 20
#define TRACKER_SPARQL_EXPRESSION_XSD_NS "http://www.w3.org/2001/XMLSchema#"
#define TRACKER_SPARQL_EXPRESSION_FN_NS "http://www.w3.org/2005/xpath-functions#"
#define TRACKER_SPARQL_EXPRESSION_FTS_NS "http://www.tracker-project.org/ontologies/fts#"
#define TRACKER_SPARQL_EXPRESSION_TRACKER_NS "http://www.tracker-project.org/ontologies/tracker#"
TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query);
TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query);
static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self, GError** error);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self);
static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self, const gchar* msg);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg);
static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static gchar* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self, gint strip);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
static gchar* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self, const gchar* literal);
static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self, TrackerPropertyType type);
static void tracker_sparql_expression_append_collate (TrackerSparqlExpression* self, GString* sql);
static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self, GError** error);
void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error);
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
static void tracker_sparql_expression_convert_expression_to_string (GString* sql, TrackerPropertyType type, glong begin);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value);
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self);
GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state);
GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_if_call (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self, GString* sql, GError** error);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error);
static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self, GString* sql, GError** error);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix);
static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self, GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
gboolean tracker_sparql_query_get_no_cache (TrackerSparqlQuery* self);
void tracker_sparql_query_set_no_cache (TrackerSparqlQuery* self, gboolean value);
static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const gchar* operator, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_in (TrackerSparqlExpression* self, GString* sql, gboolean not, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_finalize (GObject* obj);
static void _vala_tracker_sparql_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query) {
	TrackerSparqlExpression * self = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	self = (TrackerSparqlExpression*) g_object_new (object_type, NULL);
	self->priv->query = query;
	return self;
}


TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query) {
	return tracker_sparql_expression_construct (TRACKER_SPARQL_TYPE_EXPRESSION, query);
}


static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_sparql_query_next (self->priv->query, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = tracker_sparql_query_current (self->priv->query);
	result = _tmp0_;
	return result;
}


static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = tracker_sparql_query_last (self->priv->query);
	result = _tmp0_;
	return result;
}


static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_sparql_query_accept (self->priv->query, type, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self, const gchar* msg) {
	GError* result = NULL;
	GError* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = tracker_sparql_query_get_error (self->priv->query, msg);
	result = _tmp0_;
	return result;
}


static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_sparql_query_expect (self->priv->query, type, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


static gchar* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self, gint strip) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tracker_sparql_query_get_last_string (self->priv->query, strip);
	result = _tmp0_;
	return result;
}


static gchar* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self, const gchar* literal) {
	gchar* result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (literal != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (literal, "'", 0);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	_tmp3_ = g_strjoinv ("''", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("'%s'", _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp6_;
	return result;
}


static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self, TrackerPropertyType type) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (type == TRACKER_PROPERTY_TYPE_INTEGER) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = type == TRACKER_PROPERTY_TYPE_DOUBLE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = type == TRACKER_PROPERTY_TYPE_DATETIME;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == TRACKER_PROPERTY_TYPE_UNKNOWN;
	}
	result = _tmp0_;
	return result;
}


static void tracker_sparql_expression_append_collate (TrackerSparqlExpression* self, GString* sql) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	g_string_append_printf (sql, " COLLATE %s", TRACKER_COLLATION_NAME);
}


static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		TrackerSparqlTokenType _tmp0_;
		_tmp0_ = tracker_sparql_expression_current (self);
		switch (_tmp0_) {
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
			{
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				continue;
			}
			case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS:
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
			{
				break;
			}
			default:
			{
				tracker_sparql_expression_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				continue;
			}
		}
		break;
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	while (TRUE) {
		TrackerSparqlTokenType _tmp0_;
		_tmp0_ = tracker_sparql_expression_current (self);
		switch (_tmp0_) {
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
			{
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				continue;
			}
			case TRACKER_SPARQL_TOKEN_TYPE_FROM:
			case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
			case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
			case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
			case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
			case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
			{
				break;
			}
			default:
			{
				tracker_sparql_expression_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				continue;
			}
		}
		break;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlVariable* variable;
	glong begin;
	TrackerPropertyType type;
	TrackerSparqlTokenType _tmp0_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	variable = NULL;
	begin = (glong) sql->len;
	type = TRACKER_PROPERTY_TYPE_UNKNOWN;
	_tmp0_ = tracker_sparql_expression_current (self);
	if (_tmp0_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
		TrackerPropertyType _tmp1_;
		TrackerPropertyType _tmp2_;
		TrackerSparqlContext* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		TrackerSparqlVariable* _tmp8_ = NULL;
		TrackerSparqlVariable* _tmp9_;
		_tmp1_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				return 0;
			} else {
				_g_object_unref0 (variable);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		type = _tmp2_;
		_tmp3_ = tracker_sparql_expression_get_context (self);
		_tmp4_ = tracker_sparql_expression_get_last_string (self, 0);
		_tmp5_ = _tmp4_;
		_tmp6_ = string_substring (_tmp5_, (glong) 1, (glong) (-1));
		_tmp7_ = _tmp6_;
		_tmp8_ = tracker_sparql_context_get_variable (_tmp3_, _tmp7_);
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (variable);
		variable = _tmp9_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		if (variable->binding == NULL) {
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			GError* _tmp13_ = NULL;
			GError* _tmp14_;
			_tmp10_ = tracker_sparql_variable_get_name (variable);
			_tmp11_ = g_strdup_printf ("use of undefined variable `%s'", _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = tracker_sparql_expression_get_error (self, _tmp12_);
			_tmp14_ = _tmp13_;
			_g_free0 (_tmp12_);
			_inner_error_ = _tmp14_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				return 0;
			} else {
				_g_object_unref0 (variable);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	} else {
		TrackerPropertyType _tmp15_;
		TrackerPropertyType _tmp16_;
		_tmp15_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
		_tmp16_ = _tmp15_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				return 0;
			} else {
				_g_object_unref0 (variable);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		type = _tmp16_;
	}
	if (!subquery) {
		tracker_sparql_expression_convert_expression_to_string (sql, type, begin);
	}
	_tmp17_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
	_tmp18_ = _tmp17_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (variable);
			return 0;
		} else {
			_g_object_unref0 (variable);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp18_) {
		gboolean _tmp19_;
		gboolean _tmp20_;
		const gchar* _tmp33_ = NULL;
		_tmp19_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
		_tmp20_ = _tmp19_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				return 0;
			} else {
				_g_object_unref0 (variable);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp20_) {
			TrackerSparqlContext* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			TrackerSparqlVariable* _tmp24_ = NULL;
			TrackerSparqlVariable* _tmp25_;
			_tmp21_ = tracker_sparql_expression_get_context (self);
			_tmp22_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp23_ = _tmp22_;
			_tmp24_ = tracker_sparql_context_get_variable (_tmp21_, _tmp23_);
			_tmp25_ = _g_object_ref0 (_tmp24_);
			_g_object_unref0 (variable);
			variable = _tmp25_;
			_g_free0 (_tmp23_);
		} else {
			TrackerSparqlContext* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_;
			TrackerSparqlVariable* _tmp31_ = NULL;
			TrackerSparqlVariable* _tmp32_;
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (variable);
					return 0;
				} else {
					_g_object_unref0 (variable);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp26_ = tracker_sparql_expression_get_context (self);
			_tmp27_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp28_ = _tmp27_;
			_tmp29_ = string_substring (_tmp28_, (glong) 1, (glong) (-1));
			_tmp30_ = _tmp29_;
			_tmp31_ = tracker_sparql_context_get_variable (_tmp26_, _tmp30_);
			_tmp32_ = _g_object_ref0 (_tmp31_);
			_g_object_unref0 (variable);
			variable = _tmp32_;
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
		}
		_tmp33_ = tracker_sparql_variable_get_sql_expression (variable);
		g_string_append_printf (sql, " AS %s", _tmp33_);
		if (subquery) {
			TrackerSparqlVariableBinding* _tmp34_ = NULL;
			TrackerSparqlVariableBinding* binding;
			const gchar* _tmp35_ = NULL;
			TrackerSparqlPattern* _tmp36_ = NULL;
			GString* _tmp37_ = NULL;
			GString* _tmp38_;
			_tmp34_ = tracker_sparql_variable_binding_new ();
			binding = _tmp34_;
			((TrackerSparqlDataBinding*) binding)->data_type = type;
			binding->variable = variable;
			_tmp35_ = tracker_sparql_variable_get_sql_expression (variable);
			tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) binding, _tmp35_);
			_tmp36_ = tracker_sparql_expression_get_pattern (self);
			_tmp37_ = g_string_new ("");
			_tmp38_ = _tmp37_;
			tracker_sparql_pattern_add_variable_binding (_tmp36_, _tmp38_, binding, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
			_g_string_free0 (_tmp38_);
			_g_object_unref0 (binding);
		}
	}
	if (variable != NULL) {
		TrackerSparqlContext* _tmp39_ = NULL;
		gconstpointer _tmp40_ = NULL;
		gint state;
		TrackerSparqlContext* _tmp41_ = NULL;
		TrackerSparqlVariable* _tmp42_;
		TrackerSparqlContext* _tmp43_ = NULL;
		TrackerSparqlContext* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_;
		_tmp39_ = tracker_sparql_expression_get_context (self);
		_tmp40_ = g_hash_table_lookup (_tmp39_->var_set, variable);
		state = GPOINTER_TO_INT (_tmp40_);
		if (state == 0) {
			state = (gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND;
		}
		_tmp41_ = tracker_sparql_expression_get_context (self);
		_tmp42_ = _g_object_ref0 (variable);
		g_hash_table_insert (_tmp41_->select_var_set, _tmp42_, GINT_TO_POINTER (state));
		_tmp43_ = tracker_sparql_expression_get_context (self);
		_tmp44_ = tracker_sparql_expression_get_context (self);
		_tmp45_ = tracker_sparql_variable_get_name (variable);
		_tmp46_ = g_strdup (_tmp45_);
		_vala_array_add1 (&TRACKER_SPARQL_SELECT_CONTEXT (_tmp44_)->variable_names, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp44_)->variable_names_length1, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp44_)->_variable_names_size_, _tmp46_);
	} else {
		TrackerSparqlContext* _tmp47_ = NULL;
		TrackerSparqlContext* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		_tmp47_ = tracker_sparql_expression_get_context (self);
		_tmp48_ = tracker_sparql_expression_get_context (self);
		_tmp49_ = g_strdup_printf ("var%d", variable_index + 1);
		_vala_array_add2 (&TRACKER_SPARQL_SELECT_CONTEXT (_tmp48_)->variable_names, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp48_)->variable_names_length1, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp48_)->_variable_names_size_, _tmp49_);
	}
	result = type;
	_g_object_unref0 (variable);
	return result;
}


static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error) {
	glong begin;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	begin = (glong) sql->len;
	_tmp0_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp1_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
		g_string_insert (sql, (gssize) begin, "(SELECT Uri FROM Resource WHERE ID = ");
		g_string_append (sql, ")");
	}
}


void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ASC, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp1_) {
		tracker_sparql_expression_translate_expression_as_order_condition (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		g_string_append (sql, " ASC");
	} else {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DESC, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp3_) {
			tracker_sparql_expression_translate_expression_as_order_condition (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			g_string_append (sql, " DESC");
		} else {
			tracker_sparql_expression_translate_expression_as_order_condition (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BOUND, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, "(");
	tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, " IS NOT NULL)");
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_if_call (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType type;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IF, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	g_string_append (sql, "(CASE ");
	tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	g_string_append (sql, " WHEN 1 THEN ");
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp0_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	type = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	g_string_append (sql, " WHEN 0 THEN ");
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	g_string_append (sql, " ELSE NULL END)");
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = type;
	return result;
}


static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_REGEX, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, "SparqlRegex(");
	tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, ", ");
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = _tmp1_;
	_tmp3_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp2_);
	_tmp4_ = _tmp3_;
	g_string_append (sql, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	g_string_append (sql, ", ");
	_tmp5_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp6_) {
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp7_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp9_ = _tmp8_;
		_tmp10_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp9_);
		_tmp11_ = _tmp10_;
		g_string_append (sql, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	} else {
		g_string_append (sql, "''");
	}
	g_string_append (sql, ")");
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerSparqlPattern* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	g_string_append (sql, "(");
	_tmp0_ = tracker_sparql_expression_get_pattern (self);
	tracker_sparql_pattern_translate_exists (_tmp0_, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, ")");
}


void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type) {
	glong begin;
	g_return_if_fail (sql != NULL);
	g_return_if_fail (expression != NULL);
	begin = (glong) sql->len;
	g_string_append (sql, expression);
	tracker_sparql_expression_convert_expression_to_string (sql, type, begin);
}


static void tracker_sparql_expression_convert_expression_to_string (GString* sql, TrackerPropertyType type, glong begin) {
	g_return_if_fail (sql != NULL);
	switch (type) {
		case TRACKER_PROPERTY_TYPE_STRING:
		case TRACKER_PROPERTY_TYPE_INTEGER:
		{
			break;
		}
		case TRACKER_PROPERTY_TYPE_RESOURCE:
		{
			g_string_insert (sql, (gssize) begin, "(SELECT Uri FROM Resource WHERE ID = ");
			g_string_append (sql, ")");
			break;
		}
		case TRACKER_PROPERTY_TYPE_BOOLEAN:
		{
			g_string_insert (sql, (gssize) begin, "CASE ");
			g_string_append (sql, " WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END");
			break;
		}
		case TRACKER_PROPERTY_TYPE_DATETIME:
		{
			g_string_insert (sql, (gssize) begin, "strftime (\"%Y-%m-%dT%H:%M:%SZ\", ");
			g_string_append (sql, ", \"unixepoch\")");
			break;
		}
		default:
		{
			g_string_insert (sql, (gssize) begin, "CAST (");
			g_string_append (sql, " AS TEXT)");
			break;
		}
	}
}


static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerSparqlTokenType _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = tracker_sparql_expression_current (self);
	switch (_tmp0_) {
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
		{
			TrackerSparqlLiteralBinding* _tmp1_ = NULL;
			TrackerSparqlLiteralBinding* binding;
			gboolean is_var = FALSE;
			TrackerSparqlPattern* _tmp2_ = NULL;
			gboolean _tmp3_;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp1_ = tracker_sparql_literal_binding_new ();
			binding = _tmp1_;
			_tmp2_ = tracker_sparql_expression_get_pattern (self);
			_tmp4_ = tracker_sparql_pattern_parse_var_or_term (_tmp2_, NULL, &_tmp3_, &_inner_error_);
			is_var = _tmp3_;
			_tmp5_ = _tmp4_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (binding);
					return;
				} else {
					_g_object_unref0 (binding);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_g_free0 (binding->literal);
			binding->literal = _tmp5_;
			_tmp6_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			_tmp7_ = _tmp6_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (binding);
					return;
				} else {
					_g_object_unref0 (binding);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (_tmp7_) {
				glong begin;
				TrackerPropertyType _tmp8_;
				TrackerPropertyType type;
				begin = (glong) sql->len;
				_tmp8_ = tracker_sparql_expression_translate_function (self, sql, binding->literal, &_inner_error_);
				type = _tmp8_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (binding);
						return;
					} else {
						_g_object_unref0 (binding);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (binding);
						return;
					} else {
						_g_object_unref0 (binding);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				tracker_sparql_expression_convert_expression_to_string (sql, type, begin);
			} else {
				TrackerSparqlLiteralBinding* _tmp9_;
				g_string_append (sql, "?");
				_tmp9_ = _g_object_ref0 (binding);
				self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp9_);
			}
			_g_object_unref0 (binding);
			break;
		}
		default:
		{
			glong begin;
			TrackerPropertyType _tmp10_;
			TrackerPropertyType type;
			begin = (glong) sql->len;
			_tmp10_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
			type = _tmp10_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			tracker_sparql_expression_convert_expression_to_string (sql, type, begin);
			break;
		}
	}
}


static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_STR, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	TrackerSparqlLiteralBinding* _tmp2_ = NULL;
	TrackerSparqlLiteralBinding* new_binding;
	TrackerSparqlTokenType _tmp3_;
	TrackerSparqlLiteralBinding* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ISURI, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (!_tmp1_) {
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_ISIRI, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, "?");
	_tmp2_ = tracker_sparql_literal_binding_new ();
	new_binding = _tmp2_;
	((TrackerSparqlDataBinding*) new_binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
	_tmp3_ = tracker_sparql_expression_current (self);
	if (_tmp3_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("1");
		_g_free0 (new_binding->literal);
		new_binding->literal = _tmp4_;
		tracker_sparql_expression_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (new_binding);
				return;
			} else {
				_g_object_unref0 (new_binding);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		GString* _tmp5_ = NULL;
		GString* _tmp6_;
		TrackerPropertyType _tmp7_;
		TrackerPropertyType _tmp8_;
		TrackerPropertyType _tmp9_;
		_tmp5_ = g_string_new ("");
		_tmp6_ = _tmp5_;
		_tmp7_ = tracker_sparql_expression_translate_expression (self, _tmp6_, &_inner_error_);
		_tmp8_ = _tmp7_;
		_g_string_free0 (_tmp6_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (new_binding);
				return;
			} else {
				_g_object_unref0 (new_binding);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp9_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("1");
			_g_free0 (new_binding->literal);
			new_binding->literal = _tmp10_;
		} else {
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("0");
			_g_free0 (new_binding->literal);
			new_binding->literal = _tmp11_;
		}
	}
	_tmp12_ = _g_object_ref0 (new_binding);
	self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp12_);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (new_binding);
			return;
		} else {
			_g_object_unref0 (new_binding);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (new_binding);
}


static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* variable_name;
		TrackerSparqlContext* _tmp6_ = NULL;
		TrackerSparqlVariable* _tmp7_ = NULL;
		TrackerSparqlVariable* _tmp8_;
		TrackerSparqlVariable* variable;
		gboolean _tmp14_ = FALSE;
		TrackerSparqlLiteralBinding* _tmp16_ = NULL;
		TrackerSparqlLiteralBinding* new_binding;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		TrackerSparqlLiteralBinding* _tmp19_;
		_tmp2_ = tracker_sparql_expression_get_last_string (self, 0);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) (-1));
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		variable_name = _tmp5_;
		_tmp6_ = tracker_sparql_expression_get_context (self);
		_tmp7_ = tracker_sparql_context_get_variable (_tmp6_, variable_name);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		variable = _tmp8_;
		if (variable->binding == NULL) {
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			GError* _tmp12_ = NULL;
			GError* _tmp13_;
			_tmp9_ = tracker_sparql_variable_get_name (variable);
			_tmp10_ = g_strdup_printf ("`%s' is not a valid variable", _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = tracker_sparql_expression_get_error (self, _tmp11_);
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp11_);
			_inner_error_ = _tmp13_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				_g_free0 (variable_name);
				return;
			} else {
				_g_object_unref0 (variable);
				_g_free0 (variable_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (((TrackerSparqlDataBinding*) variable->binding)->data_type == TRACKER_PROPERTY_TYPE_RESOURCE) {
			_tmp14_ = TRUE;
		} else {
			_tmp14_ = variable->binding->type == NULL;
		}
		if (_tmp14_) {
			GError* _tmp15_ = NULL;
			_tmp15_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
			_inner_error_ = _tmp15_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				_g_free0 (variable_name);
				return;
			} else {
				_g_object_unref0 (variable);
				_g_free0 (variable_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		g_string_append (sql, "(SELECT ID FROM Resource WHERE Uri = ?)");
		_tmp16_ = tracker_sparql_literal_binding_new ();
		new_binding = _tmp16_;
		_tmp17_ = tracker_class_get_uri (variable->binding->type);
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (new_binding->literal);
		new_binding->literal = _tmp18_;
		_tmp19_ = _g_object_ref0 (new_binding);
		self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp19_);
		_g_object_unref0 (new_binding);
		_g_object_unref0 (variable);
		_g_free0 (variable_name);
	} else {
		GError* _tmp20_ = NULL;
		_tmp20_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
		_inner_error_ = _tmp20_;
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	g_return_val_if_fail (uri != NULL, 0);
	if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_XSD_NS "string") == 0) {
		tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = TRACKER_PROPERTY_TYPE_STRING;
		return result;
	} else {
		if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
			g_string_append (sql, "CAST (");
			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, " AS INTEGER)");
			result = TRACKER_PROPERTY_TYPE_INTEGER;
			return result;
		} else {
			if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
				g_string_append (sql, "CAST (");
				tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_append (sql, " AS REAL)");
				result = TRACKER_PROPERTY_TYPE_DOUBLE;
				return result;
			} else {
				if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "case-fold") == 0) {
					g_string_append (sql, "SparqlCaseFold (");
					tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
					g_string_append (sql, ")");
					result = TRACKER_PROPERTY_TYPE_STRING;
					return result;
				} else {
					if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "ascii-lower-case") == 0) {
						g_string_append (sql, "lower (");
						tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						g_string_append (sql, ")");
						result = TRACKER_PROPERTY_TYPE_STRING;
						return result;
					} else {
						if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "lower-case") == 0) {
							g_string_append (sql, "SparqlLowerCase (");
							tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return 0;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							g_string_append (sql, ")");
							result = TRACKER_PROPERTY_TYPE_STRING;
							return result;
						} else {
							if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "contains") == 0) {
								TrackerSparqlLiteralBinding* _tmp0_ = NULL;
								TrackerSparqlLiteralBinding* binding;
								gchar* _tmp1_ = NULL;
								gchar* _tmp2_;
								gchar* _tmp3_;
								gchar* _tmp4_ = NULL;
								TrackerSparqlLiteralBinding* _tmp5_;
								g_string_append (sql, "(");
								tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return 0;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return 0;
									}
								}
								g_string_append (sql, " GLOB ");
								tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return 0;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return 0;
									}
								}
								g_string_append (sql, "?");
								_tmp0_ = tracker_sparql_literal_binding_new ();
								binding = _tmp0_;
								_tmp1_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
								_tmp2_ = _tmp1_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (binding);
										return 0;
									} else {
										_g_object_unref0 (binding);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return 0;
									}
								}
								_tmp3_ = _tmp2_;
								_tmp4_ = g_strdup_printf ("*%s*", _tmp3_);
								_g_free0 (binding->literal);
								binding->literal = _tmp4_;
								_g_free0 (_tmp3_);
								_tmp5_ = _g_object_ref0 (binding);
								self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp5_);
								g_string_append (sql, ")");
								result = TRACKER_PROPERTY_TYPE_BOOLEAN;
								_g_object_unref0 (binding);
								return result;
							} else {
								if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "starts-with") == 0) {
									gchar* _tmp6_ = NULL;
									gchar* prefix;
									TrackerSparqlLiteralBinding* _tmp7_ = NULL;
									TrackerSparqlLiteralBinding* binding;
									gchar* _tmp8_;
									TrackerSparqlLiteralBinding* _tmp9_;
									TrackerSparqlLiteralBinding* _tmp10_ = NULL;
									gchar* _tmp11_ = NULL;
									gchar* _tmp12_;
									gchar* _tmp13_;
									TrackerSparqlLiteralBinding* _tmp14_;
									tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									g_string_append (sql, " BETWEEN ");
									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									_tmp6_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
									prefix = _tmp6_;
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									g_string_append (sql, "?");
									_tmp7_ = tracker_sparql_literal_binding_new ();
									binding = _tmp7_;
									_tmp8_ = g_strdup (prefix);
									_g_free0 (binding->literal);
									binding->literal = _tmp8_;
									_tmp9_ = _g_object_ref0 (binding);
									self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp9_);
									g_string_append (sql, " AND ");
									g_string_append (sql, "?");
									_tmp10_ = tracker_sparql_literal_binding_new ();
									_g_object_unref0 (binding);
									binding = _tmp10_;
									_tmp11_ = g_unichar_to_string (TRACKER_COLLATION_LAST_CHAR);
									_tmp12_ = _tmp11_;
									_tmp13_ = g_strconcat (prefix, _tmp12_, NULL);
									_g_free0 (binding->literal);
									binding->literal = _tmp13_;
									_g_free0 (_tmp12_);
									_tmp14_ = _g_object_ref0 (binding);
									self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp14_);
									result = TRACKER_PROPERTY_TYPE_BOOLEAN;
									_g_object_unref0 (binding);
									_g_free0 (prefix);
									return result;
								} else {
									if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "ends-with") == 0) {
										TrackerSparqlLiteralBinding* _tmp15_ = NULL;
										TrackerSparqlLiteralBinding* binding;
										gchar* _tmp16_ = NULL;
										gchar* _tmp17_;
										gchar* _tmp18_;
										gchar* _tmp19_ = NULL;
										TrackerSparqlLiteralBinding* _tmp20_;
										g_string_append (sql, "(");
										tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return 0;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return 0;
											}
										}
										g_string_append (sql, " GLOB ");
										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return 0;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return 0;
											}
										}
										g_string_append (sql, "?");
										_tmp15_ = tracker_sparql_literal_binding_new ();
										binding = _tmp15_;
										_tmp16_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
										_tmp17_ = _tmp16_;
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												_g_object_unref0 (binding);
												return 0;
											} else {
												_g_object_unref0 (binding);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return 0;
											}
										}
										_tmp18_ = _tmp17_;
										_tmp19_ = g_strdup_printf ("*%s", _tmp18_);
										_g_free0 (binding->literal);
										binding->literal = _tmp19_;
										_g_free0 (_tmp18_);
										_tmp20_ = _g_object_ref0 (binding);
										self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp20_);
										g_string_append (sql, ")");
										result = TRACKER_PROPERTY_TYPE_BOOLEAN;
										_g_object_unref0 (binding);
										return result;
									} else {
										if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "substring") == 0) {
											gboolean _tmp21_;
											gboolean _tmp22_;
											g_string_append (sql, "substr(");
											tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											g_string_append (sql, ", ");
											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											_tmp21_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
											_tmp22_ = _tmp21_;
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											if (_tmp22_) {
												g_string_append (sql, ", ");
												tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return 0;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return 0;
													}
												}
											}
											g_string_append (sql, ")");
											result = TRACKER_PROPERTY_TYPE_STRING;
											return result;
										} else {
											if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "concat") == 0) {
												tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return 0;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return 0;
													}
												}
												g_string_append (sql, "||");
												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return 0;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return 0;
													}
												}
												tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return 0;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return 0;
													}
												}
												while (TRUE) {
													gboolean _tmp23_;
													gboolean _tmp24_;
													_tmp23_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
													_tmp24_ = _tmp23_;
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return 0;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return 0;
														}
													}
													if (!_tmp24_) {
														break;
													}
													g_string_append (sql, "||");
													tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return 0;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return 0;
														}
													}
												}
												result = TRACKER_PROPERTY_TYPE_STRING;
												return result;
											} else {
												if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "string-join") == 0) {
													g_string_append (sql, "SparqlStringJoin(");
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return 0;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return 0;
														}
													}
													tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return 0;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return 0;
														}
													}
													g_string_append (sql, ", ");
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return 0;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return 0;
														}
													}
													tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return 0;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return 0;
														}
													}
													while (TRUE) {
														gboolean _tmp25_;
														gboolean _tmp26_;
														_tmp25_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
														_tmp26_ = _tmp25_;
														if (_inner_error_ != NULL) {
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																g_propagate_error (error, _inner_error_);
																return 0;
															} else {
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																g_clear_error (&_inner_error_);
																return 0;
															}
														}
														if (!_tmp26_) {
															break;
														}
														g_string_append (sql, ", ");
														tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
														if (_inner_error_ != NULL) {
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																g_propagate_error (error, _inner_error_);
																return 0;
															} else {
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																g_clear_error (&_inner_error_);
																return 0;
															}
														}
													}
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return 0;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return 0;
														}
													}
													g_string_append (sql, ",");
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return 0;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return 0;
														}
													}
													tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return 0;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return 0;
														}
													}
													g_string_append (sql, ")");
													result = TRACKER_PROPERTY_TYPE_STRING;
													return result;
												} else {
													if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "year-from-dateTime") == 0) {
														gchar* _tmp27_ = NULL;
														gchar* _tmp28_;
														gchar* _tmp29_ = NULL;
														gchar* _tmp30_;
														gchar* variable_name;
														TrackerSparqlContext* _tmp31_ = NULL;
														TrackerSparqlVariable* _tmp32_ = NULL;
														TrackerSparqlVariable* _tmp33_;
														TrackerSparqlVariable* variable;
														gchar* _tmp34_ = NULL;
														gchar* _tmp35_;
														tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
														if (_inner_error_ != NULL) {
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																g_propagate_error (error, _inner_error_);
																return 0;
															} else {
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																g_clear_error (&_inner_error_);
																return 0;
															}
														}
														_tmp27_ = tracker_sparql_expression_get_last_string (self, 0);
														_tmp28_ = _tmp27_;
														_tmp29_ = string_substring (_tmp28_, (glong) 1, (glong) (-1));
														_tmp30_ = _tmp29_;
														_g_free0 (_tmp28_);
														variable_name = _tmp30_;
														_tmp31_ = tracker_sparql_expression_get_context (self);
														_tmp32_ = tracker_sparql_context_get_variable (_tmp31_, variable_name);
														_tmp33_ = _g_object_ref0 (_tmp32_);
														variable = _tmp33_;
														g_string_append (sql, "strftime (\"%Y\", ");
														_tmp34_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localDate");
														_tmp35_ = _tmp34_;
														g_string_append (sql, _tmp35_);
														_g_free0 (_tmp35_);
														g_string_append (sql, " * 24 * 3600, \"unixepoch\")");
														result = TRACKER_PROPERTY_TYPE_INTEGER;
														_g_object_unref0 (variable);
														_g_free0 (variable_name);
														return result;
													} else {
														if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "month-from-dateTime") == 0) {
															gchar* _tmp36_ = NULL;
															gchar* _tmp37_;
															gchar* _tmp38_ = NULL;
															gchar* _tmp39_;
															gchar* variable_name;
															TrackerSparqlContext* _tmp40_ = NULL;
															TrackerSparqlVariable* _tmp41_ = NULL;
															TrackerSparqlVariable* _tmp42_;
															TrackerSparqlVariable* variable;
															gchar* _tmp43_ = NULL;
															gchar* _tmp44_;
															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
															if (_inner_error_ != NULL) {
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																	g_propagate_error (error, _inner_error_);
																	return 0;
																} else {
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																	g_clear_error (&_inner_error_);
																	return 0;
																}
															}
															_tmp36_ = tracker_sparql_expression_get_last_string (self, 0);
															_tmp37_ = _tmp36_;
															_tmp38_ = string_substring (_tmp37_, (glong) 1, (glong) (-1));
															_tmp39_ = _tmp38_;
															_g_free0 (_tmp37_);
															variable_name = _tmp39_;
															_tmp40_ = tracker_sparql_expression_get_context (self);
															_tmp41_ = tracker_sparql_context_get_variable (_tmp40_, variable_name);
															_tmp42_ = _g_object_ref0 (_tmp41_);
															variable = _tmp42_;
															g_string_append (sql, "strftime (\"%m\", ");
															_tmp43_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localDate");
															_tmp44_ = _tmp43_;
															g_string_append (sql, _tmp44_);
															_g_free0 (_tmp44_);
															g_string_append (sql, " * 24 * 3600, \"unixepoch\")");
															result = TRACKER_PROPERTY_TYPE_INTEGER;
															_g_object_unref0 (variable);
															_g_free0 (variable_name);
															return result;
														} else {
															if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "day-from-dateTime") == 0) {
																gchar* _tmp45_ = NULL;
																gchar* _tmp46_;
																gchar* _tmp47_ = NULL;
																gchar* _tmp48_;
																gchar* variable_name;
																TrackerSparqlContext* _tmp49_ = NULL;
																TrackerSparqlVariable* _tmp50_ = NULL;
																TrackerSparqlVariable* _tmp51_;
																TrackerSparqlVariable* variable;
																gchar* _tmp52_ = NULL;
																gchar* _tmp53_;
																tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		return 0;
																	} else {
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return 0;
																	}
																}
																_tmp45_ = tracker_sparql_expression_get_last_string (self, 0);
																_tmp46_ = _tmp45_;
																_tmp47_ = string_substring (_tmp46_, (glong) 1, (glong) (-1));
																_tmp48_ = _tmp47_;
																_g_free0 (_tmp46_);
																variable_name = _tmp48_;
																_tmp49_ = tracker_sparql_expression_get_context (self);
																_tmp50_ = tracker_sparql_context_get_variable (_tmp49_, variable_name);
																_tmp51_ = _g_object_ref0 (_tmp50_);
																variable = _tmp51_;
																g_string_append (sql, "strftime (\"%d\", ");
																_tmp52_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localDate");
																_tmp53_ = _tmp52_;
																g_string_append (sql, _tmp53_);
																_g_free0 (_tmp53_);
																g_string_append (sql, " * 24 * 3600, \"unixepoch\")");
																result = TRACKER_PROPERTY_TYPE_INTEGER;
																_g_object_unref0 (variable);
																_g_free0 (variable_name);
																return result;
															} else {
																if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "hours-from-dateTime") == 0) {
																	gchar* _tmp54_ = NULL;
																	gchar* _tmp55_;
																	gchar* _tmp56_ = NULL;
																	gchar* _tmp57_;
																	gchar* variable_name;
																	TrackerSparqlContext* _tmp58_ = NULL;
																	TrackerSparqlVariable* _tmp59_ = NULL;
																	TrackerSparqlVariable* _tmp60_;
																	TrackerSparqlVariable* variable;
																	gchar* _tmp61_ = NULL;
																	gchar* _tmp62_;
																	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
																	if (_inner_error_ != NULL) {
																		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																			g_propagate_error (error, _inner_error_);
																			return 0;
																		} else {
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																			g_clear_error (&_inner_error_);
																			return 0;
																		}
																	}
																	_tmp54_ = tracker_sparql_expression_get_last_string (self, 0);
																	_tmp55_ = _tmp54_;
																	_tmp56_ = string_substring (_tmp55_, (glong) 1, (glong) (-1));
																	_tmp57_ = _tmp56_;
																	_g_free0 (_tmp55_);
																	variable_name = _tmp57_;
																	_tmp58_ = tracker_sparql_expression_get_context (self);
																	_tmp59_ = tracker_sparql_context_get_variable (_tmp58_, variable_name);
																	_tmp60_ = _g_object_ref0 (_tmp59_);
																	variable = _tmp60_;
																	g_string_append (sql, "(");
																	_tmp61_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localTime");
																	_tmp62_ = _tmp61_;
																	g_string_append (sql, _tmp62_);
																	_g_free0 (_tmp62_);
																	g_string_append (sql, " / 3600)");
																	result = TRACKER_PROPERTY_TYPE_INTEGER;
																	_g_object_unref0 (variable);
																	_g_free0 (variable_name);
																	return result;
																} else {
																	if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "minutes-from-dateTime") == 0) {
																		gchar* _tmp63_ = NULL;
																		gchar* _tmp64_;
																		gchar* _tmp65_ = NULL;
																		gchar* _tmp66_;
																		gchar* variable_name;
																		TrackerSparqlContext* _tmp67_ = NULL;
																		TrackerSparqlVariable* _tmp68_ = NULL;
																		TrackerSparqlVariable* _tmp69_;
																		TrackerSparqlVariable* variable;
																		gchar* _tmp70_ = NULL;
																		gchar* _tmp71_;
																		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
																		if (_inner_error_ != NULL) {
																			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																				g_propagate_error (error, _inner_error_);
																				return 0;
																			} else {
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																				g_clear_error (&_inner_error_);
																				return 0;
																			}
																		}
																		_tmp63_ = tracker_sparql_expression_get_last_string (self, 0);
																		_tmp64_ = _tmp63_;
																		_tmp65_ = string_substring (_tmp64_, (glong) 1, (glong) (-1));
																		_tmp66_ = _tmp65_;
																		_g_free0 (_tmp64_);
																		variable_name = _tmp66_;
																		_tmp67_ = tracker_sparql_expression_get_context (self);
																		_tmp68_ = tracker_sparql_context_get_variable (_tmp67_, variable_name);
																		_tmp69_ = _g_object_ref0 (_tmp68_);
																		variable = _tmp69_;
																		g_string_append (sql, "(");
																		_tmp70_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localTime");
																		_tmp71_ = _tmp70_;
																		g_string_append (sql, _tmp71_);
																		_g_free0 (_tmp71_);
																		g_string_append (sql, " / 60 % 60)");
																		result = TRACKER_PROPERTY_TYPE_INTEGER;
																		_g_object_unref0 (variable);
																		_g_free0 (variable_name);
																		return result;
																	} else {
																		if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "seconds-from-dateTime") == 0) {
																			gchar* _tmp72_ = NULL;
																			gchar* _tmp73_;
																			gchar* _tmp74_ = NULL;
																			gchar* _tmp75_;
																			gchar* variable_name;
																			TrackerSparqlContext* _tmp76_ = NULL;
																			TrackerSparqlVariable* _tmp77_ = NULL;
																			TrackerSparqlVariable* _tmp78_;
																			TrackerSparqlVariable* variable;
																			gchar* _tmp79_ = NULL;
																			gchar* _tmp80_;
																			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
																			if (_inner_error_ != NULL) {
																				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																					g_propagate_error (error, _inner_error_);
																					return 0;
																				} else {
																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																					g_clear_error (&_inner_error_);
																					return 0;
																				}
																			}
																			_tmp72_ = tracker_sparql_expression_get_last_string (self, 0);
																			_tmp73_ = _tmp72_;
																			_tmp74_ = string_substring (_tmp73_, (glong) 1, (glong) (-1));
																			_tmp75_ = _tmp74_;
																			_g_free0 (_tmp73_);
																			variable_name = _tmp75_;
																			_tmp76_ = tracker_sparql_expression_get_context (self);
																			_tmp77_ = tracker_sparql_context_get_variable (_tmp76_, variable_name);
																			_tmp78_ = _g_object_ref0 (_tmp77_);
																			variable = _tmp78_;
																			g_string_append (sql, "(");
																			_tmp79_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localTime");
																			_tmp80_ = _tmp79_;
																			g_string_append (sql, _tmp80_);
																			_g_free0 (_tmp80_);
																			g_string_append (sql, "% 60)");
																			result = TRACKER_PROPERTY_TYPE_INTEGER;
																			_g_object_unref0 (variable);
																			_g_free0 (variable_name);
																			return result;
																		} else {
																			if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "timezone-from-dateTime") == 0) {
																				gchar* _tmp81_ = NULL;
																				gchar* _tmp82_;
																				gchar* _tmp83_ = NULL;
																				gchar* _tmp84_;
																				gchar* variable_name;
																				TrackerSparqlContext* _tmp85_ = NULL;
																				TrackerSparqlVariable* _tmp86_ = NULL;
																				TrackerSparqlVariable* _tmp87_;
																				TrackerSparqlVariable* variable;
																				gchar* _tmp88_ = NULL;
																				gchar* _tmp89_;
																				gchar* _tmp90_ = NULL;
																				gchar* _tmp91_;
																				const gchar* _tmp92_ = NULL;
																				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
																				if (_inner_error_ != NULL) {
																					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																						g_propagate_error (error, _inner_error_);
																						return 0;
																					} else {
																						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																						g_clear_error (&_inner_error_);
																						return 0;
																					}
																				}
																				_tmp81_ = tracker_sparql_expression_get_last_string (self, 0);
																				_tmp82_ = _tmp81_;
																				_tmp83_ = string_substring (_tmp82_, (glong) 1, (glong) (-1));
																				_tmp84_ = _tmp83_;
																				_g_free0 (_tmp82_);
																				variable_name = _tmp84_;
																				_tmp85_ = tracker_sparql_expression_get_context (self);
																				_tmp86_ = tracker_sparql_context_get_variable (_tmp85_, variable_name);
																				_tmp87_ = _g_object_ref0 (_tmp86_);
																				variable = _tmp87_;
																				g_string_append (sql, "(");
																				_tmp88_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localDate");
																				_tmp89_ = _tmp88_;
																				g_string_append (sql, _tmp89_);
																				_g_free0 (_tmp89_);
																				g_string_append (sql, " * 24 * 3600 + ");
																				_tmp90_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localTime");
																				_tmp91_ = _tmp90_;
																				g_string_append (sql, _tmp91_);
																				_g_free0 (_tmp91_);
																				g_string_append (sql, "- ");
																				_tmp92_ = tracker_sparql_variable_get_sql_expression (variable);
																				g_string_append (sql, _tmp92_);
																				g_string_append (sql, ")");
																				result = TRACKER_PROPERTY_TYPE_INTEGER;
																				_g_object_unref0 (variable);
																				_g_free0 (variable_name);
																				return result;
																			} else {
																				if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FTS_NS "rank") == 0) {
																					gboolean is_var = FALSE;
																					TrackerSparqlPattern* _tmp93_ = NULL;
																					gboolean _tmp94_;
																					gchar* _tmp95_ = NULL;
																					gchar* v;
																					_tmp93_ = tracker_sparql_expression_get_pattern (self);
																					_tmp95_ = tracker_sparql_pattern_parse_var_or_term (_tmp93_, NULL, &_tmp94_, &_inner_error_);
																					is_var = _tmp94_;
																					v = _tmp95_;
																					if (_inner_error_ != NULL) {
																						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																							g_propagate_error (error, _inner_error_);
																							return 0;
																						} else {
																							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																							g_clear_error (&_inner_error_);
																							return 0;
																						}
																					}
																					g_string_append_printf (sql, "\"%s_u_rank\"", v);
																					result = TRACKER_PROPERTY_TYPE_DOUBLE;
																					_g_free0 (v);
																					return result;
																				} else {
																					if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FTS_NS "offsets") == 0) {
																						gboolean is_var = FALSE;
																						TrackerSparqlPattern* _tmp96_ = NULL;
																						gboolean _tmp97_;
																						gchar* _tmp98_ = NULL;
																						gchar* v;
																						_tmp96_ = tracker_sparql_expression_get_pattern (self);
																						_tmp98_ = tracker_sparql_pattern_parse_var_or_term (_tmp96_, NULL, &_tmp97_, &_inner_error_);
																						is_var = _tmp97_;
																						v = _tmp98_;
																						if (_inner_error_ != NULL) {
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																								g_propagate_error (error, _inner_error_);
																								return 0;
																							} else {
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																								g_clear_error (&_inner_error_);
																								return 0;
																							}
																						}
																						g_string_append_printf (sql, "\"%s_u_offsets\"", v);
																						result = TRACKER_PROPERTY_TYPE_STRING;
																						_g_free0 (v);
																						return result;
																					} else {
																						if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "id") == 0) {
																							TrackerPropertyType _tmp99_;
																							TrackerPropertyType type;
																							_tmp99_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																							type = _tmp99_;
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							if (type != TRACKER_PROPERTY_TYPE_RESOURCE) {
																								GError* _tmp100_ = NULL;
																								_tmp100_ = tracker_sparql_expression_get_error (self, "expected resource");
																								_inner_error_ = _tmp100_;
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							result = TRACKER_PROPERTY_TYPE_INTEGER;
																							return result;
																						} else {
																							if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri") == 0) {
																								TrackerPropertyType _tmp101_;
																								TrackerPropertyType type;
																								_tmp101_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																								type = _tmp101_;
																								if (_inner_error_ != NULL) {
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																										g_propagate_error (error, _inner_error_);
																										return 0;
																									} else {
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																										g_clear_error (&_inner_error_);
																										return 0;
																									}
																								}
																								if (type != TRACKER_PROPERTY_TYPE_INTEGER) {
																									GError* _tmp102_ = NULL;
																									_tmp102_ = tracker_sparql_expression_get_error (self, "expected integer ID");
																									_inner_error_ = _tmp102_;
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																										g_propagate_error (error, _inner_error_);
																										return 0;
																									} else {
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																										g_clear_error (&_inner_error_);
																										return 0;
																									}
																								}
																								result = TRACKER_PROPERTY_TYPE_RESOURCE;
																								return result;
																							} else {
																								if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "cartesian-distance") == 0) {
																									g_string_append (sql, "SparqlCartesianDistance(");
																									tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																									g_string_append (sql, ", ");
																									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																									tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																									g_string_append (sql, ", ");
																									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																									tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																									g_string_append (sql, ", ");
																									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																									tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																									g_string_append (sql, ")");
																									result = TRACKER_PROPERTY_TYPE_DOUBLE;
																									return result;
																								} else {
																									if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "haversine-distance") == 0) {
																										g_string_append (sql, "SparqlHaversineDistance(");
																										tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																										g_string_append (sql, ", ");
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																										tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																										g_string_append (sql, ", ");
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																										tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																										g_string_append (sql, ", ");
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																										tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																										g_string_append (sql, ")");
																										result = TRACKER_PROPERTY_TYPE_DOUBLE;
																										return result;
																									} else {
																										if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "coalesce") == 0) {
																											g_string_append (sql, "COALESCE(");
																											tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																											if (_inner_error_ != NULL) {
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																													g_propagate_error (error, _inner_error_);
																													return 0;
																												} else {
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																													g_clear_error (&_inner_error_);
																													return 0;
																												}
																											}
																											g_string_append (sql, ", ");
																											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																											if (_inner_error_ != NULL) {
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																													g_propagate_error (error, _inner_error_);
																													return 0;
																												} else {
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																													g_clear_error (&_inner_error_);
																													return 0;
																												}
																											}
																											tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																											if (_inner_error_ != NULL) {
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																													g_propagate_error (error, _inner_error_);
																													return 0;
																												} else {
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																													g_clear_error (&_inner_error_);
																													return 0;
																												}
																											}
																											while (TRUE) {
																												gboolean _tmp103_;
																												gboolean _tmp104_;
																												_tmp103_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																												_tmp104_ = _tmp103_;
																												if (_inner_error_ != NULL) {
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																														g_propagate_error (error, _inner_error_);
																														return 0;
																													} else {
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																														g_clear_error (&_inner_error_);
																														return 0;
																													}
																												}
																												if (!_tmp104_) {
																													break;
																												}
																												g_string_append (sql, ", ");
																												tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																												if (_inner_error_ != NULL) {
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																														g_propagate_error (error, _inner_error_);
																														return 0;
																													} else {
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																														g_clear_error (&_inner_error_);
																														return 0;
																													}
																												}
																											}
																											g_string_append (sql, ")");
																											result = TRACKER_PROPERTY_TYPE_STRING;
																											return result;
																										} else {
																											if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-parent") == 0) {
																												g_string_append (sql, "SparqlUriIsParent(");
																												tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																												if (_inner_error_ != NULL) {
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																														g_propagate_error (error, _inner_error_);
																														return 0;
																													} else {
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																														g_clear_error (&_inner_error_);
																														return 0;
																													}
																												}
																												g_string_append (sql, ", ");
																												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																												if (_inner_error_ != NULL) {
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																														g_propagate_error (error, _inner_error_);
																														return 0;
																													} else {
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																														g_clear_error (&_inner_error_);
																														return 0;
																													}
																												}
																												tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																												if (_inner_error_ != NULL) {
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																														g_propagate_error (error, _inner_error_);
																														return 0;
																													} else {
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																														g_clear_error (&_inner_error_);
																														return 0;
																													}
																												}
																												g_string_append (sql, ")");
																												result = TRACKER_PROPERTY_TYPE_BOOLEAN;
																												return result;
																											} else {
																												if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-descendant") == 0) {
																													g_string_append (sql, "SparqlUriIsDescendant(");
																													tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																													if (_inner_error_ != NULL) {
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																															g_propagate_error (error, _inner_error_);
																															return 0;
																														} else {
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																															g_clear_error (&_inner_error_);
																															return 0;
																														}
																													}
																													g_string_append (sql, ", ");
																													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																													if (_inner_error_ != NULL) {
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																															g_propagate_error (error, _inner_error_);
																															return 0;
																														} else {
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																															g_clear_error (&_inner_error_);
																															return 0;
																														}
																													}
																													tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																													if (_inner_error_ != NULL) {
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																															g_propagate_error (error, _inner_error_);
																															return 0;
																														} else {
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																															g_clear_error (&_inner_error_);
																															return 0;
																														}
																													}
																													while (TRUE) {
																														gboolean _tmp105_;
																														gboolean _tmp106_;
																														_tmp105_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																														_tmp106_ = _tmp105_;
																														if (_inner_error_ != NULL) {
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																																g_propagate_error (error, _inner_error_);
																																return 0;
																															} else {
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																																g_clear_error (&_inner_error_);
																																return 0;
																															}
																														}
																														if (!_tmp106_) {
																															break;
																														}
																														g_string_append (sql, ", ");
																														tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																														if (_inner_error_ != NULL) {
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																																g_propagate_error (error, _inner_error_);
																																return 0;
																															} else {
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																																g_clear_error (&_inner_error_);
																																return 0;
																															}
																														}
																													}
																													g_string_append (sql, ")");
																													result = TRACKER_PROPERTY_TYPE_BOOLEAN;
																													return result;
																												} else {
																													if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "string-from-filename") == 0) {
																														g_string_append (sql, "SparqlStringFromFilename(");
																														tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																														if (_inner_error_ != NULL) {
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																																g_propagate_error (error, _inner_error_);
																																return 0;
																															} else {
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																																g_clear_error (&_inner_error_);
																																return 0;
																															}
																														}
																														g_string_append (sql, ")");
																														result = TRACKER_PROPERTY_TYPE_STRING;
																														return result;
																													} else {
																														TrackerProperty* _tmp107_ = NULL;
																														TrackerProperty* _tmp108_;
																														TrackerProperty* prop;
																														GString* _tmp110_ = NULL;
																														GString* expr;
																														gchar* _tmp111_;
																														gchar* value_separator;
																														gchar* graph_separator;
																														gboolean _tmp112_;
																														gboolean _tmp113_;
																														gboolean _tmp120_;
																														_tmp107_ = tracker_ontologies_get_property_by_uri (uri);
																														_tmp108_ = _g_object_ref0 (_tmp107_);
																														prop = _tmp108_;
																														if (prop == NULL) {
																															GError* _tmp109_ = NULL;
																															_tmp109_ = tracker_sparql_expression_get_error (self, "Unknown function");
																															_inner_error_ = _tmp109_;
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																																g_propagate_error (error, _inner_error_);
																																_g_object_unref0 (prop);
																																return 0;
																															} else {
																																_g_object_unref0 (prop);
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																																g_clear_error (&_inner_error_);
																																return 0;
																															}
																														}
																														_tmp110_ = g_string_new ("");
																														expr = _tmp110_;
																														tracker_sparql_expression_translate_expression (self, expr, &_inner_error_);
																														if (_inner_error_ != NULL) {
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																																g_propagate_error (error, _inner_error_);
																																_g_string_free0 (expr);
																																_g_object_unref0 (prop);
																																return 0;
																															} else {
																																_g_string_free0 (expr);
																																_g_object_unref0 (prop);
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																																g_clear_error (&_inner_error_);
																																return 0;
																															}
																														}
																														_tmp111_ = g_strdup (",");
																														value_separator = _tmp111_;
																														graph_separator = NULL;
																														_tmp112_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																														_tmp113_ = _tmp112_;
																														if (_inner_error_ != NULL) {
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																																g_propagate_error (error, _inner_error_);
																																_g_free0 (graph_separator);
																																_g_free0 (value_separator);
																																_g_string_free0 (expr);
																																_g_object_unref0 (prop);
																																return 0;
																															} else {
																																_g_free0 (graph_separator);
																																_g_free0 (value_separator);
																																_g_string_free0 (expr);
																																_g_object_unref0 (prop);
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																																g_clear_error (&_inner_error_);
																																return 0;
																															}
																														}
																														if (_tmp113_) {
																															gchar* _tmp114_ = NULL;
																															gchar* _tmp115_;
																															gboolean _tmp116_;
																															gboolean _tmp117_;
																															_tmp114_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
																															_tmp115_ = _tmp114_;
																															if (_inner_error_ != NULL) {
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																																	g_propagate_error (error, _inner_error_);
																																	_g_free0 (graph_separator);
																																	_g_free0 (value_separator);
																																	_g_string_free0 (expr);
																																	_g_object_unref0 (prop);
																																	return 0;
																																} else {
																																	_g_free0 (graph_separator);
																																	_g_free0 (value_separator);
																																	_g_string_free0 (expr);
																																	_g_object_unref0 (prop);
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																																	g_clear_error (&_inner_error_);
																																	return 0;
																																}
																															}
																															_g_free0 (value_separator);
																															value_separator = _tmp115_;
																															_tmp116_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																															_tmp117_ = _tmp116_;
																															if (_inner_error_ != NULL) {
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																																	g_propagate_error (error, _inner_error_);
																																	_g_free0 (graph_separator);
																																	_g_free0 (value_separator);
																																	_g_string_free0 (expr);
																																	_g_object_unref0 (prop);
																																	return 0;
																																} else {
																																	_g_free0 (graph_separator);
																																	_g_free0 (value_separator);
																																	_g_string_free0 (expr);
																																	_g_object_unref0 (prop);
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																																	g_clear_error (&_inner_error_);
																																	return 0;
																																}
																															}
																															if (_tmp117_) {
																																gchar* _tmp118_ = NULL;
																																gchar* _tmp119_;
																																_tmp118_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
																																_tmp119_ = _tmp118_;
																																if (_inner_error_ != NULL) {
																																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																																		g_propagate_error (error, _inner_error_);
																																		_g_free0 (graph_separator);
																																		_g_free0 (value_separator);
																																		_g_string_free0 (expr);
																																		_g_object_unref0 (prop);
																																		return 0;
																																	} else {
																																		_g_free0 (graph_separator);
																																		_g_free0 (value_separator);
																																		_g_string_free0 (expr);
																																		_g_object_unref0 (prop);
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																																		g_clear_error (&_inner_error_);
																																		return 0;
																																	}
																																}
																																_g_free0 (graph_separator);
																																graph_separator = _tmp119_;
																															}
																														}
																														_tmp120_ = tracker_property_get_multiple_values (prop);
																														if (_tmp120_) {
																															glong begin;
																															const gchar* _tmp121_ = NULL;
																															TrackerPropertyType _tmp122_;
																															gchar* _tmp126_ = NULL;
																															gchar* _tmp127_;
																															const gchar* _tmp128_ = NULL;
																															g_string_append (sql, "(SELECT GROUP_CONCAT(");
																															begin = (glong) sql->len;
																															_tmp121_ = tracker_property_get_name (prop);
																															g_string_append_printf (sql, "\"%s\"", _tmp121_);
																															_tmp122_ = tracker_property_get_data_type (prop);
																															tracker_sparql_expression_convert_expression_to_string (sql, _tmp122_, begin);
																															if (graph_separator != NULL) {
																																gchar* _tmp123_ = NULL;
																																gchar* _tmp124_;
																																const gchar* _tmp125_ = NULL;
																																_tmp123_ = tracker_sparql_expression_escape_sql_string_literal (self, graph_separator);
																																_tmp124_ = _tmp123_;
																																_tmp125_ = tracker_property_get_name (prop);
																																g_string_append_printf (sql, " || %s || COALESCE((SELECT Uri FROM Resource WHERE ID = \"%s:graph\")," \
" '')", _tmp124_, _tmp125_);
																																_g_free0 (_tmp124_);
																															}
																															_tmp126_ = tracker_sparql_expression_escape_sql_string_literal (self, value_separator);
																															_tmp127_ = _tmp126_;
																															g_string_append_printf (sql, ",%s)", _tmp127_);
																															_g_free0 (_tmp127_);
																															_tmp128_ = tracker_property_get_table_name (prop);
																															g_string_append_printf (sql, " FROM \"%s\" WHERE ID = %s)", _tmp128_, expr->str);
																															result = TRACKER_PROPERTY_TYPE_STRING;
																															_g_free0 (graph_separator);
																															_g_free0 (value_separator);
																															_g_string_free0 (expr);
																															_g_object_unref0 (prop);
																															return result;
																														} else {
																															if (graph_separator == NULL) {
																																const gchar* _tmp129_ = NULL;
																																const gchar* _tmp130_ = NULL;
																																TrackerPropertyType _tmp131_;
																																TrackerPropertyType _tmp132_;
																																_tmp129_ = tracker_property_get_name (prop);
																																_tmp130_ = tracker_property_get_table_name (prop);
																																g_string_append_printf (sql, "(SELECT \"%s\" FROM \"%s\" WHERE ID = %s)", _tmp129_, _tmp130_, expr->str);
																																_tmp131_ = tracker_property_get_data_type (prop);
																																if (_tmp131_ == TRACKER_PROPERTY_TYPE_STRING) {
																																	tracker_sparql_expression_append_collate (self, sql);
																																}
																																_tmp132_ = tracker_property_get_data_type (prop);
																																result = _tmp132_;
																																_g_free0 (graph_separator);
																																_g_free0 (value_separator);
																																_g_string_free0 (expr);
																																_g_object_unref0 (prop);
																																return result;
																															} else {
																																glong begin;
																																const gchar* _tmp133_ = NULL;
																																TrackerPropertyType _tmp134_;
																																gchar* _tmp135_ = NULL;
																																gchar* _tmp136_;
																																const gchar* _tmp137_ = NULL;
																																const gchar* _tmp138_ = NULL;
																																g_string_append (sql, "(SELECT ");
																																begin = (glong) sql->len;
																																_tmp133_ = tracker_property_get_name (prop);
																																g_string_append_printf (sql, "\"%s\"", _tmp133_);
																																_tmp134_ = tracker_property_get_data_type (prop);
																																tracker_sparql_expression_convert_expression_to_string (sql, _tmp134_, begin);
																																_tmp135_ = tracker_sparql_expression_escape_sql_string_literal (self, graph_separator);
																																_tmp136_ = _tmp135_;
																																_tmp137_ = tracker_property_get_name (prop);
																																g_string_append_printf (sql, " || %s || COALESCE((SELECT Uri FROM Resource WHERE ID = \"%s:graph\")," \
" '')", _tmp136_, _tmp137_);
																																_g_free0 (_tmp136_);
																																_tmp138_ = tracker_property_get_table_name (prop);
																																g_string_append_printf (sql, " FROM \"%s\" WHERE ID = %s)", _tmp138_, expr->str);
																																result = TRACKER_PROPERTY_TYPE_STRING;
																																_g_free0 (graph_separator);
																																_g_free0 (value_separator);
																																_g_string_free0 (expr);
																																_g_object_unref0 (prop);
																																return result;
																															}
																														}
																														_g_free0 (graph_separator);
																														_g_free0 (value_separator);
																														_g_string_free0 (expr);
																														_g_object_unref0 (prop);
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self, GError** error) {
	TrackerPropertyType result = 0;
	gchar* type_iri = NULL;
	TrackerPropertyType type = 0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (type_iri);
			return 0;
		} else {
			_g_free0 (type_iri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		_tmp2_ = tracker_sparql_expression_get_last_string (self, 1);
		_g_free0 (type_iri);
		type_iri = _tmp2_;
	} else {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (type_iri);
				return 0;
			} else {
				_g_free0 (type_iri);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp4_) {
			gchar* _tmp5_ = NULL;
			gchar* ns;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp5_ = tracker_sparql_expression_get_last_string (self, 0);
			ns = _tmp5_;
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					_g_free0 (type_iri);
					return 0;
				} else {
					_g_free0 (ns);
					_g_free0 (type_iri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp6_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp7_ = _tmp6_;
			_tmp8_ = string_substring (_tmp7_, (glong) 1, (glong) (-1));
			_tmp9_ = _tmp8_;
			_tmp10_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp9_, &_inner_error_);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp9_);
			_g_free0 (_tmp7_);
			_tmp12_ = _tmp11_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					_g_free0 (type_iri);
					return 0;
				} else {
					_g_free0 (ns);
					_g_free0 (type_iri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_g_free0 (type_iri);
			type_iri = _tmp12_;
			_g_free0 (ns);
		} else {
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			gchar* _tmp19_;
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (type_iri);
					return 0;
				} else {
					_g_free0 (type_iri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp13_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp14_ = _tmp13_;
			_tmp15_ = string_substring (_tmp14_, (glong) 1, (glong) (-1));
			_tmp16_ = _tmp15_;
			_tmp17_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp16_, &_inner_error_);
			_tmp18_ = _tmp17_;
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
			_tmp19_ = _tmp18_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (type_iri);
					return 0;
				} else {
					_g_free0 (type_iri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_g_free0 (type_iri);
			type_iri = _tmp19_;
		}
	}
	if (g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "boolean") == 0) {
		type = TRACKER_PROPERTY_TYPE_BOOLEAN;
	} else {
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		if (g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
			_tmp31_ = TRUE;
		} else {
			_tmp31_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonPositiveInteger") == 0;
		}
		if (_tmp31_) {
			_tmp30_ = TRUE;
		} else {
			_tmp30_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "negativeInteger") == 0;
		}
		if (_tmp30_) {
			_tmp29_ = TRUE;
		} else {
			_tmp29_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "long") == 0;
		}
		if (_tmp29_) {
			_tmp28_ = TRUE;
		} else {
			_tmp28_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "int") == 0;
		}
		if (_tmp28_) {
			_tmp27_ = TRUE;
		} else {
			_tmp27_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "short") == 0;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			_tmp26_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "byte") == 0;
		}
		if (_tmp26_) {
			_tmp25_ = TRUE;
		} else {
			_tmp25_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonNegativeInteger") == 0;
		}
		if (_tmp25_) {
			_tmp24_ = TRUE;
		} else {
			_tmp24_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedLong") == 0;
		}
		if (_tmp24_) {
			_tmp23_ = TRUE;
		} else {
			_tmp23_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedInt") == 0;
		}
		if (_tmp23_) {
			_tmp22_ = TRUE;
		} else {
			_tmp22_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedShort") == 0;
		}
		if (_tmp22_) {
			_tmp21_ = TRUE;
		} else {
			_tmp21_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedByte") == 0;
		}
		if (_tmp21_) {
			_tmp20_ = TRUE;
		} else {
			_tmp20_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "positiveInteger") == 0;
		}
		if (_tmp20_) {
			type = TRACKER_PROPERTY_TYPE_INTEGER;
		} else {
			if (g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
				type = TRACKER_PROPERTY_TYPE_DOUBLE;
			} else {
				if (g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "date") == 0) {
					type = TRACKER_PROPERTY_TYPE_DATE;
				} else {
					if (g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "dateTime") == 0) {
						type = TRACKER_PROPERTY_TYPE_DATETIME;
					} else {
						type = TRACKER_PROPERTY_TYPE_STRING;
					}
				}
			}
		}
	}
	result = type;
	_g_free0 (type_iri);
	return result;
}


gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error) {
	TrackerPropertyType _type = 0;
	gchar* result = NULL;
	TrackerSparqlTokenType _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	tracker_sparql_expression_next (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = tracker_sparql_expression_last (self);
	switch (_tmp0_) {
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
		{
			GString* _tmp1_ = NULL;
			GString* sb;
			gchar* _tmp2_ = NULL;
			gchar* s;
			const gchar* p;
			gint _tmp3_;
			const gchar* end;
			gboolean _tmp9_;
			gboolean _tmp10_;
			gchar* _tmp12_;
			_tmp1_ = g_string_new ("");
			sb = _tmp1_;
			_tmp2_ = tracker_sparql_expression_get_last_string (self, 1);
			s = _tmp2_;
			p = s;
			_tmp3_ = strlen (s);
			end = p + _tmp3_;
			while (TRUE) {
				const gchar* _tmp4_ = NULL;
				const gchar* q;
				if (!(((glong) p) < ((glong) end))) {
					break;
				}
				_tmp4_ = strchr (p, (gint) '\\');
				q = _tmp4_;
				if (q == NULL) {
					g_string_append_len (sb, p, (gssize) ((glong) (end - p)));
					p = end;
				} else {
					g_string_append_len (sb, p, (gssize) ((glong) (q - p)));
					p = q + 1;
					switch (((gchar*) p)[0]) {
						case '\'':
						case '"':
						case '\\':
						{
							g_string_append_c (sb, ((gchar*) p)[0]);
							break;
						}
						case 'b':
						{
							g_string_append_c (sb, '\b');
							break;
						}
						case 'f':
						{
							g_string_append_c (sb, '\f');
							break;
						}
						case 'n':
						{
							g_string_append_c (sb, '\n');
							break;
						}
						case 'r':
						{
							g_string_append_c (sb, '\r');
							break;
						}
						case 't':
						{
							g_string_append_c (sb, '\t');
							break;
						}
						case 'u':
						{
							gchar* ptr;
							gint _tmp5_;
							gint _tmp6_;
							gint _tmp7_;
							gint _tmp8_;
							gunichar c;
							ptr = ((gchar*) p) + 1;
							_tmp5_ = g_ascii_xdigit_value (ptr[0]);
							_tmp6_ = g_ascii_xdigit_value (ptr[1]);
							_tmp7_ = g_ascii_xdigit_value (ptr[2]);
							_tmp8_ = g_ascii_xdigit_value (ptr[3]);
							c = (((((((gunichar) _tmp5_) * 16) + _tmp6_) * 16) + _tmp7_) * 16) + _tmp8_;
							g_string_append_unichar (sb, c);
							p = p + 4;
							break;
						}
						default:
						break;
					}
					p++;
				}
			}
			_tmp9_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
			_tmp10_ = _tmp9_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (s);
					_g_string_free0 (sb);
					return NULL;
				} else {
					_g_free0 (s);
					_g_string_free0 (sb);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp10_) {
				TrackerPropertyType _tmp11_;
				TrackerPropertyType parsed_type;
				_tmp11_ = tracker_sparql_expression_parse_type_uri (self, &_inner_error_);
				parsed_type = _tmp11_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (s);
						_g_string_free0 (sb);
						return NULL;
					} else {
						_g_free0 (s);
						_g_string_free0 (sb);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				if ((&_type) == NULL) {
				} else {
					_type = parsed_type;
				}
			}
			_tmp12_ = g_strdup (sb->str);
			result = _tmp12_;
			_g_free0 (s);
			_g_string_free0 (sb);
			if (type) {
				*type = _type;
			}
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
		{
			gchar* _tmp13_ = NULL;
			gchar* _result_;
			gboolean _tmp14_;
			gboolean _tmp15_;
			_tmp13_ = tracker_sparql_expression_get_last_string (self, 3);
			_result_ = _tmp13_;
			_tmp14_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
			_tmp15_ = _tmp14_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (_result_);
					return NULL;
				} else {
					_g_free0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp15_) {
				TrackerPropertyType _tmp16_;
				TrackerPropertyType parsed_type;
				_tmp16_ = tracker_sparql_expression_parse_type_uri (self, &_inner_error_);
				parsed_type = _tmp16_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				if ((&_type) == NULL) {
				} else {
					_type = parsed_type;
				}
			}
			result = _result_;
			if (type) {
				*type = _type;
			}
			return result;
		}
		default:
		{
			GError* _tmp17_ = NULL;
			_tmp17_ = tracker_sparql_expression_get_error (self, "expected string literal");
			_inner_error_ = _tmp17_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	if (type) {
		*type = _type;
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	g_return_val_if_fail (uri != NULL, 0);
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp1_) {
		TrackerPropertyType _tmp2_;
		TrackerPropertyType _result_;
		_tmp2_ = tracker_sparql_expression_translate_function (self, sql, uri, &_inner_error_);
		_result_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = _result_;
		return result;
	} else {
		TrackerSparqlLiteralBinding* _tmp3_ = NULL;
		TrackerSparqlLiteralBinding* binding;
		gchar* _tmp4_;
		TrackerSparqlLiteralBinding* _tmp5_;
		g_string_append (sql, "COALESCE((SELECT ID FROM Resource WHERE Uri = ?), 0)");
		_tmp3_ = tracker_sparql_literal_binding_new ();
		binding = _tmp3_;
		_tmp4_ = g_strdup (uri);
		_g_free0 (binding->literal);
		binding->literal = _tmp4_;
		_tmp5_ = _g_object_ref0 (binding);
		self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp5_);
		result = TRACKER_PROPERTY_TYPE_RESOURCE;
		_g_object_unref0 (binding);
		return result;
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType type = 0;
	TrackerSparqlTokenType _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = tracker_sparql_expression_current (self);
	switch (_tmp0_) {
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
		{
			TrackerPropertyType _tmp1_;
			TrackerPropertyType _tmp2_;
			_tmp1_ = tracker_sparql_expression_translate_bracketted_expression (self, sql, &_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp2_;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
		{
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			TrackerPropertyType _tmp5_;
			TrackerPropertyType _tmp6_;
			TrackerPropertyType _tmp7_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp3_ = tracker_sparql_expression_get_last_string (self, 1);
			_tmp4_ = _tmp3_;
			_tmp5_ = tracker_sparql_expression_translate_uri_expression (self, sql, _tmp4_, &_inner_error_);
			_tmp6_ = _tmp5_;
			_g_free0 (_tmp4_);
			_tmp7_ = _tmp6_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp7_;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
		{
			gboolean _tmp8_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp8_ = tracker_sparql_query_get_no_cache (self->priv->query);
			if (_tmp8_) {
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				_tmp9_ = tracker_sparql_expression_get_last_string (self, 0);
				_tmp10_ = _tmp9_;
				g_string_append (sql, _tmp10_);
				_g_free0 (_tmp10_);
			} else {
				TrackerSparqlLiteralBinding* _tmp11_ = NULL;
				TrackerSparqlLiteralBinding* binding;
				gchar* _tmp12_ = NULL;
				TrackerSparqlLiteralBinding* _tmp13_;
				g_string_append (sql, "?");
				_tmp11_ = tracker_sparql_literal_binding_new ();
				binding = _tmp11_;
				_tmp12_ = tracker_sparql_expression_get_last_string (self, 0);
				_g_free0 (binding->literal);
				binding->literal = _tmp12_;
				_tmp13_ = _g_object_ref0 (binding);
				self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp13_);
				_g_object_unref0 (binding);
			}
			result = TRACKER_PROPERTY_TYPE_DOUBLE;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
		{
			gboolean _tmp14_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp14_ = tracker_sparql_query_get_no_cache (self->priv->query);
			if (_tmp14_) {
				g_string_append (sql, "1");
			} else {
				TrackerSparqlLiteralBinding* _tmp15_ = NULL;
				TrackerSparqlLiteralBinding* binding;
				gchar* _tmp16_;
				TrackerSparqlLiteralBinding* _tmp17_;
				g_string_append (sql, "?");
				_tmp15_ = tracker_sparql_literal_binding_new ();
				binding = _tmp15_;
				_tmp16_ = g_strdup ("1");
				_g_free0 (binding->literal);
				binding->literal = _tmp16_;
				((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
				_tmp17_ = _g_object_ref0 (binding);
				self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp17_);
				_g_object_unref0 (binding);
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
		{
			gboolean _tmp18_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp18_ = tracker_sparql_query_get_no_cache (self->priv->query);
			if (_tmp18_) {
				g_string_append (sql, "0");
			} else {
				TrackerSparqlLiteralBinding* _tmp19_ = NULL;
				TrackerSparqlLiteralBinding* binding;
				gchar* _tmp20_;
				TrackerSparqlLiteralBinding* _tmp21_;
				g_string_append (sql, "?");
				_tmp19_ = tracker_sparql_literal_binding_new ();
				binding = _tmp19_;
				_tmp20_ = g_strdup ("0");
				_g_free0 (binding->literal);
				binding->literal = _tmp20_;
				((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
				_tmp21_ = _g_object_ref0 (binding);
				self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp21_);
				_g_object_unref0 (binding);
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
		{
			TrackerPropertyType _tmp22_;
			gchar* _tmp23_ = NULL;
			gchar* literal;
			_tmp23_ = tracker_sparql_expression_parse_string_literal (self, &_tmp22_, &_inner_error_);
			type = _tmp22_;
			literal = _tmp23_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			switch (type) {
				case TRACKER_PROPERTY_TYPE_INTEGER:
				case TRACKER_PROPERTY_TYPE_BOOLEAN:
				case TRACKER_PROPERTY_TYPE_DOUBLE:
				case TRACKER_PROPERTY_TYPE_DATETIME:
				{
					gboolean _tmp24_;
					_tmp24_ = tracker_sparql_query_get_no_cache (self->priv->query);
					if (_tmp24_) {
						gchar* _tmp25_ = NULL;
						gchar* _tmp26_;
						_tmp25_ = tracker_sparql_expression_escape_sql_string_literal (self, literal);
						_tmp26_ = _tmp25_;
						g_string_append (sql, _tmp26_);
						_g_free0 (_tmp26_);
					} else {
						TrackerSparqlLiteralBinding* _tmp27_ = NULL;
						TrackerSparqlLiteralBinding* binding;
						gchar* _tmp28_;
						TrackerSparqlLiteralBinding* _tmp29_;
						_tmp27_ = tracker_sparql_literal_binding_new ();
						binding = _tmp27_;
						_tmp28_ = g_strdup (literal);
						_g_free0 (binding->literal);
						binding->literal = _tmp28_;
						((TrackerSparqlDataBinding*) binding)->data_type = type;
						_tmp29_ = _g_object_ref0 (binding);
						self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp29_);
						g_string_append (sql, "?");
						_g_object_unref0 (binding);
					}
					result = type;
					_g_free0 (literal);
					return result;
				}
				default:
				{
					gboolean _tmp30_;
					_tmp30_ = tracker_sparql_query_get_no_cache (self->priv->query);
					if (_tmp30_) {
						gchar* _tmp31_ = NULL;
						gchar* _tmp32_;
						_tmp31_ = tracker_sparql_expression_escape_sql_string_literal (self, literal);
						_tmp32_ = _tmp31_;
						g_string_append (sql, _tmp32_);
						_g_free0 (_tmp32_);
					} else {
						TrackerSparqlLiteralBinding* _tmp33_ = NULL;
						TrackerSparqlLiteralBinding* binding;
						gchar* _tmp34_;
						TrackerSparqlLiteralBinding* _tmp35_;
						_tmp33_ = tracker_sparql_literal_binding_new ();
						binding = _tmp33_;
						_tmp34_ = g_strdup (literal);
						_g_free0 (binding->literal);
						binding->literal = _tmp34_;
						_tmp35_ = _g_object_ref0 (binding);
						self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp35_);
						g_string_append (sql, "?");
						_g_object_unref0 (binding);
					}
					tracker_sparql_expression_append_collate (self, sql);
					result = TRACKER_PROPERTY_TYPE_STRING;
					_g_free0 (literal);
					return result;
				}
			}
			_g_free0 (literal);
		}
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
		{
			gboolean _tmp36_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp36_ = tracker_sparql_query_get_no_cache (self->priv->query);
			if (_tmp36_) {
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_;
				_tmp37_ = tracker_sparql_expression_get_last_string (self, 0);
				_tmp38_ = _tmp37_;
				g_string_append (sql, _tmp38_);
				_g_free0 (_tmp38_);
			} else {
				TrackerSparqlLiteralBinding* _tmp39_ = NULL;
				TrackerSparqlLiteralBinding* binding;
				gchar* _tmp40_ = NULL;
				TrackerSparqlLiteralBinding* _tmp41_;
				g_string_append (sql, "?");
				_tmp39_ = tracker_sparql_literal_binding_new ();
				binding = _tmp39_;
				_tmp40_ = tracker_sparql_expression_get_last_string (self, 0);
				_g_free0 (binding->literal);
				binding->literal = _tmp40_;
				((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
				_tmp41_ = _g_object_ref0 (binding);
				self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp41_);
				_g_object_unref0 (binding);
			}
			result = TRACKER_PROPERTY_TYPE_INTEGER;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
		{
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_;
			gchar* _tmp44_ = NULL;
			gchar* _tmp45_;
			gchar* variable_name;
			TrackerSparqlContext* _tmp46_ = NULL;
			TrackerSparqlVariable* _tmp47_ = NULL;
			TrackerSparqlVariable* _tmp48_;
			TrackerSparqlVariable* variable;
			const gchar* _tmp49_ = NULL;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp42_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp43_ = _tmp42_;
			_tmp44_ = string_substring (_tmp43_, (glong) 1, (glong) (-1));
			_tmp45_ = _tmp44_;
			_g_free0 (_tmp43_);
			variable_name = _tmp45_;
			_tmp46_ = tracker_sparql_expression_get_context (self);
			_tmp47_ = tracker_sparql_context_get_variable (_tmp46_, variable_name);
			_tmp48_ = _g_object_ref0 (_tmp47_);
			variable = _tmp48_;
			_tmp49_ = tracker_sparql_variable_get_sql_expression (variable);
			g_string_append (sql, _tmp49_);
			if (variable->binding == NULL) {
				result = TRACKER_PROPERTY_TYPE_UNKNOWN;
				_g_object_unref0 (variable);
				_g_free0 (variable_name);
				return result;
			} else {
				if (((TrackerSparqlDataBinding*) variable->binding)->data_type == TRACKER_PROPERTY_TYPE_STRING) {
					tracker_sparql_expression_append_collate (self, sql);
				}
				result = ((TrackerSparqlDataBinding*) variable->binding)->data_type;
				_g_object_unref0 (variable);
				_g_free0 (variable_name);
				return result;
			}
			_g_object_unref0 (variable);
			_g_free0 (variable_name);
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
		{
			tracker_sparql_expression_translate_str (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_STRING;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "''");
			result = TRACKER_PROPERTY_TYPE_STRING;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "0");
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
		{
			tracker_sparql_expression_translate_datatype (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_RESOURCE;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
		{
			tracker_sparql_expression_translate_bound_call (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
		{
			TrackerPropertyType _tmp50_;
			TrackerPropertyType _tmp51_;
			_tmp50_ = tracker_sparql_expression_translate_if_call (self, sql, &_inner_error_);
			_tmp51_ = _tmp50_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp51_;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "(");
			tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, " = ");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, ")");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
		{
			tracker_sparql_expression_translate_isuri (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "0");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
		{
			tracker_sparql_expression_translate_regex (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_query_set_no_cache (self->priv->query, TRUE);
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
		{
			tracker_sparql_expression_translate_exists (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_COUNT:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "COUNT(");
			tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, ")");
			result = TRACKER_PROPERTY_TYPE_INTEGER;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_SUM:
		{
			TrackerPropertyType _tmp52_;
			TrackerPropertyType _tmp53_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "SUM(");
			_tmp52_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			_tmp53_ = _tmp52_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			type = _tmp53_;
			g_string_append (sql, ")");
			result = type;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_AVG:
		{
			TrackerPropertyType _tmp54_;
			TrackerPropertyType _tmp55_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "AVG(");
			_tmp54_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			_tmp55_ = _tmp54_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			type = _tmp55_;
			g_string_append (sql, ")");
			result = type;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_MIN:
		{
			TrackerPropertyType _tmp56_;
			TrackerPropertyType _tmp57_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "MIN(");
			_tmp56_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			_tmp57_ = _tmp56_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			type = _tmp57_;
			g_string_append (sql, ")");
			result = type;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_MAX:
		{
			TrackerPropertyType _tmp58_;
			TrackerPropertyType _tmp59_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "MAX(");
			_tmp58_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			_tmp59_ = _tmp58_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			type = _tmp59_;
			g_string_append (sql, ")");
			result = type;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT:
		{
			gchar* _tmp60_ = NULL;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_ = NULL;
			gchar* _tmp64_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "GROUP_CONCAT(");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, ", ");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp60_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
			_tmp61_ = _tmp60_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp62_ = _tmp61_;
			_tmp63_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp62_);
			_tmp64_ = _tmp63_;
			g_string_append (sql, _tmp64_);
			_g_free0 (_tmp64_);
			_g_free0 (_tmp62_);
			g_string_append (sql, ")");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_STRING;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
		{
			gchar* _tmp65_ = NULL;
			gchar* ns;
			gchar* _tmp66_ = NULL;
			gchar* _tmp67_;
			gchar* _tmp68_ = NULL;
			gchar* _tmp69_;
			gchar* _tmp70_ = NULL;
			gchar* _tmp71_;
			gchar* uri;
			TrackerPropertyType _tmp72_;
			TrackerPropertyType _tmp73_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp65_ = tracker_sparql_expression_get_last_string (self, 0);
			ns = _tmp65_;
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					return 0;
				} else {
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp66_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp67_ = _tmp66_;
			_tmp68_ = string_substring (_tmp67_, (glong) 1, (glong) (-1));
			_tmp69_ = _tmp68_;
			_tmp70_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp69_, &_inner_error_);
			_tmp71_ = _tmp70_;
			_g_free0 (_tmp69_);
			_g_free0 (_tmp67_);
			uri = _tmp71_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					return 0;
				} else {
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp72_ = tracker_sparql_expression_translate_uri_expression (self, sql, uri, &_inner_error_);
			_tmp73_ = _tmp72_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (uri);
					_g_free0 (ns);
					return 0;
				} else {
					_g_free0 (uri);
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp73_;
			_g_free0 (uri);
			_g_free0 (ns);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
		{
			gchar* _tmp74_ = NULL;
			gchar* _tmp75_;
			gchar* _tmp76_ = NULL;
			gchar* _tmp77_;
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_;
			gchar* uri;
			TrackerPropertyType _tmp80_;
			TrackerPropertyType _tmp81_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp74_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp75_ = _tmp74_;
			_tmp76_ = string_substring (_tmp75_, (glong) 1, (glong) (-1));
			_tmp77_ = _tmp76_;
			_tmp78_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp77_, &_inner_error_);
			_tmp79_ = _tmp78_;
			_g_free0 (_tmp77_);
			_g_free0 (_tmp75_);
			uri = _tmp79_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp80_ = tracker_sparql_expression_translate_uri_expression (self, sql, uri, &_inner_error_);
			_tmp81_ = _tmp80_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (uri);
					return 0;
				} else {
					_g_free0 (uri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp81_;
			_g_free0 (uri);
			return result;
		}
		default:
		{
			GError* _tmp82_ = NULL;
			_tmp82_ = tracker_sparql_expression_get_error (self, "expected primary expression");
			_inner_error_ = _tmp82_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	TrackerPropertyType _tmp11_;
	TrackerPropertyType _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp1_) {
		TrackerPropertyType _tmp2_;
		TrackerPropertyType optype;
		g_string_append (sql, "NOT (");
		_tmp2_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
		optype = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		g_string_append (sql, ")");
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			GError* _tmp3_ = NULL;
			_tmp3_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			_inner_error_ = _tmp3_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = TRACKER_PROPERTY_TYPE_BOOLEAN;
		return result;
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp5_) {
			TrackerPropertyType _tmp6_;
			TrackerPropertyType _tmp7_;
			_tmp6_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
			_tmp7_ = _tmp6_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp7_;
			return result;
		} else {
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp8_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
			_tmp9_ = _tmp8_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp9_) {
				TrackerPropertyType _tmp10_;
				TrackerPropertyType optype;
				g_string_append (sql, "-(");
				_tmp10_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
				optype = _tmp10_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_append (sql, ")");
				result = optype;
				return result;
			}
		}
	}
	_tmp11_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
	_tmp12_ = _tmp11_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp12_;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	glong begin;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	begin = (glong) sql->len;
	_tmp0_ = tracker_sparql_expression_translate_unary_expression (self, sql, &_inner_error_);
	optype = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp2_) {
			gboolean _tmp3_;
			TrackerPropertyType _tmp5_;
			TrackerPropertyType _tmp6_;
			gboolean _tmp7_;
			_tmp3_ = tracker_sparql_expression_maybe_numeric (self, optype);
			if (!_tmp3_) {
				GError* _tmp4_ = NULL;
				_tmp4_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
				_inner_error_ = _tmp4_;
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_insert (sql, (gssize) begin, "(");
			g_string_append (sql, " * ");
			_tmp5_ = tracker_sparql_expression_translate_unary_expression (self, sql, &_inner_error_);
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp7_ = tracker_sparql_expression_maybe_numeric (self, _tmp6_);
			if (!_tmp7_) {
				GError* _tmp8_ = NULL;
				_tmp8_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
				_inner_error_ = _tmp8_;
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, ")");
		} else {
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DIV, &_inner_error_);
			_tmp10_ = _tmp9_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp10_) {
				gboolean _tmp11_;
				TrackerPropertyType _tmp13_;
				TrackerPropertyType _tmp14_;
				gboolean _tmp15_;
				_tmp11_ = tracker_sparql_expression_maybe_numeric (self, optype);
				if (!_tmp11_) {
					GError* _tmp12_ = NULL;
					_tmp12_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
					_inner_error_ = _tmp12_;
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_insert (sql, (gssize) begin, "(");
				g_string_append (sql, " / ");
				_tmp13_ = tracker_sparql_expression_translate_unary_expression (self, sql, &_inner_error_);
				_tmp14_ = _tmp13_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				_tmp15_ = tracker_sparql_expression_maybe_numeric (self, _tmp14_);
				if (!_tmp15_) {
					GError* _tmp16_ = NULL;
					_tmp16_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
					_inner_error_ = _tmp16_;
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_append (sql, ")");
			} else {
				break;
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	glong begin;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	begin = (glong) sql->len;
	_tmp0_ = tracker_sparql_expression_translate_multiplicative_expression (self, sql, &_inner_error_);
	optype = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp2_) {
			gboolean _tmp3_;
			TrackerPropertyType _tmp5_;
			TrackerPropertyType _tmp6_;
			gboolean _tmp7_;
			_tmp3_ = tracker_sparql_expression_maybe_numeric (self, optype);
			if (!_tmp3_) {
				GError* _tmp4_ = NULL;
				_tmp4_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
				_inner_error_ = _tmp4_;
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_insert (sql, (gssize) begin, "(");
			g_string_append (sql, " + ");
			_tmp5_ = tracker_sparql_expression_translate_multiplicative_expression (self, sql, &_inner_error_);
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp7_ = tracker_sparql_expression_maybe_numeric (self, _tmp6_);
			if (!_tmp7_) {
				GError* _tmp8_ = NULL;
				_tmp8_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
				_inner_error_ = _tmp8_;
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, ")");
		} else {
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
			_tmp10_ = _tmp9_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp10_) {
				gboolean _tmp11_;
				TrackerPropertyType _tmp13_;
				TrackerPropertyType _tmp14_;
				gboolean _tmp15_;
				_tmp11_ = tracker_sparql_expression_maybe_numeric (self, optype);
				if (!_tmp11_) {
					GError* _tmp12_ = NULL;
					_tmp12_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
					_inner_error_ = _tmp12_;
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_insert (sql, (gssize) begin, "(");
				g_string_append (sql, " - ");
				_tmp13_ = tracker_sparql_expression_translate_multiplicative_expression (self, sql, &_inner_error_);
				_tmp14_ = _tmp13_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				_tmp15_ = tracker_sparql_expression_maybe_numeric (self, _tmp14_);
				if (!_tmp15_) {
					GError* _tmp16_ = NULL;
					_tmp16_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
					_inner_error_ = _tmp16_;
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_append (sql, ")");
			} else {
				break;
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = tracker_sparql_expression_translate_additive_expression (self, sql, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp1_;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const gchar* operator, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType op2type;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	g_return_val_if_fail (operator != NULL, 0);
	g_string_insert (sql, (gssize) begin, "(");
	g_string_append (sql, operator);
	_tmp0_ = tracker_sparql_expression_translate_numeric_expression (self, sql, &_inner_error_);
	op2type = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	g_string_append (sql, ")");
	if (op1type == TRACKER_PROPERTY_TYPE_DATETIME) {
		_tmp2_ = op2type == TRACKER_PROPERTY_TYPE_STRING;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (op1type == TRACKER_PROPERTY_TYPE_STRING) {
			_tmp3_ = op2type == TRACKER_PROPERTY_TYPE_DATETIME;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		guint _tmp4_;
		_tmp4_ = g_list_length (self->priv->query->bindings);
		if (_tmp4_ == (n_bindings + 1)) {
			GList* _tmp5_ = NULL;
			_tmp5_ = g_list_last (self->priv->query->bindings);
			((TrackerSparqlDataBinding*) ((TrackerSparqlLiteralBinding*) _tmp5_->data))->data_type = TRACKER_PROPERTY_TYPE_DATETIME;
		}
	}
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_in (TrackerSparqlExpression* self, GString* sql, gboolean not, GError** error) {
	TrackerPropertyType result = 0;
	gint in_variable_count;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	in_variable_count = 0;
	if (not) {
		g_string_append (sql, " NOT");
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	g_string_append (sql, " IN (");
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (!_tmp1_) {
		in_variable_count++;
		tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		while (TRUE) {
			gboolean _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
			_tmp3_ = _tmp2_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (!_tmp3_) {
				break;
			}
			g_string_append (sql, ", ");
			in_variable_count++;
			if (in_variable_count > TRACKER_SPARQL_EXPRESSION_MAX_VARIABLES_FOR_IN) {
				gboolean _tmp5_;
				_tmp5_ = tracker_sparql_query_get_no_cache (self->priv->query);
				_tmp4_ = !_tmp5_;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				tracker_sparql_query_set_no_cache (self->priv->query, TRUE);
			}
			tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	g_string_append (sql, ")");
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	glong begin;
	guint _tmp0_;
	guint n_bindings;
	TrackerPropertyType _tmp1_;
	TrackerPropertyType optype;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	begin = (glong) sql->len;
	_tmp0_ = g_list_length (self->priv->query->bindings);
	n_bindings = _tmp0_;
	_tmp1_ = tracker_sparql_expression_translate_numeric_expression (self, sql, &_inner_error_);
	optype = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp2_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GE, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp3_) {
		TrackerPropertyType _tmp4_;
		TrackerPropertyType _tmp5_;
		_tmp4_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " >= ", &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = _tmp5_;
		return result;
	} else {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp7_) {
			TrackerPropertyType _tmp8_;
			TrackerPropertyType _tmp9_;
			_tmp8_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " = ", &_inner_error_);
			_tmp9_ = _tmp8_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp9_;
			return result;
		} else {
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp10_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NE, &_inner_error_);
			_tmp11_ = _tmp10_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp11_) {
				TrackerPropertyType _tmp12_;
				TrackerPropertyType _tmp13_;
				_tmp12_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " <> ", &_inner_error_);
				_tmp13_ = _tmp12_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				result = _tmp13_;
				return result;
			} else {
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp14_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LT, &_inner_error_);
				_tmp15_ = _tmp14_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				if (_tmp15_) {
					TrackerPropertyType _tmp16_;
					TrackerPropertyType _tmp17_;
					_tmp16_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " < ", &_inner_error_);
					_tmp17_ = _tmp16_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
					result = _tmp17_;
					return result;
				} else {
					gboolean _tmp18_;
					gboolean _tmp19_;
					_tmp18_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LE, &_inner_error_);
					_tmp19_ = _tmp18_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
					if (_tmp19_) {
						TrackerPropertyType _tmp20_;
						TrackerPropertyType _tmp21_;
						_tmp20_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " <= ", &_inner_error_);
						_tmp21_ = _tmp20_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						result = _tmp21_;
						return result;
					} else {
						gboolean _tmp22_;
						gboolean _tmp23_;
						_tmp22_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GT, &_inner_error_);
						_tmp23_ = _tmp22_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						if (_tmp23_) {
							TrackerPropertyType _tmp24_;
							TrackerPropertyType _tmp25_;
							_tmp24_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " > ", &_inner_error_);
							_tmp25_ = _tmp24_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return 0;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							result = _tmp25_;
							return result;
						} else {
							gboolean _tmp26_;
							gboolean _tmp27_;
							_tmp26_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_IN, &_inner_error_);
							_tmp27_ = _tmp26_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return 0;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							if (_tmp27_) {
								TrackerPropertyType _tmp28_;
								TrackerPropertyType _tmp29_;
								_tmp28_ = tracker_sparql_expression_translate_in (self, sql, FALSE, &_inner_error_);
								_tmp29_ = _tmp28_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return 0;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return 0;
									}
								}
								result = _tmp29_;
								return result;
							} else {
								gboolean _tmp30_;
								gboolean _tmp31_;
								_tmp30_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NOT, &_inner_error_);
								_tmp31_ = _tmp30_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return 0;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return 0;
									}
								}
								if (_tmp31_) {
									TrackerPropertyType _tmp32_;
									TrackerPropertyType _tmp33_;
									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OP_IN, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									_tmp32_ = tracker_sparql_expression_translate_in (self, sql, TRUE, &_inner_error_);
									_tmp33_ = _tmp32_;
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									result = _tmp33_;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = tracker_sparql_expression_translate_relational_expression (self, sql, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp1_;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	glong begin;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	begin = (glong) sql->len;
	_tmp0_ = tracker_sparql_expression_translate_value_logical (self, sql, &_inner_error_);
	optype = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		TrackerPropertyType _tmp4_;
		TrackerPropertyType _tmp5_;
		_tmp1_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_AND, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (!_tmp2_) {
			break;
		}
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			GError* _tmp3_ = NULL;
			_tmp3_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			_inner_error_ = _tmp3_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		g_string_insert (sql, (gssize) begin, "(");
		g_string_append (sql, " AND ");
		_tmp4_ = tracker_sparql_expression_translate_value_logical (self, sql, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		optype = _tmp5_;
		g_string_append (sql, ")");
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			GError* _tmp6_ = NULL;
			_tmp6_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			_inner_error_ = _tmp6_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	glong begin;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	begin = (glong) sql->len;
	_tmp0_ = tracker_sparql_expression_translate_conditional_and_expression (self, sql, &_inner_error_);
	optype = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		TrackerPropertyType _tmp4_;
		TrackerPropertyType _tmp5_;
		_tmp1_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_OR, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (!_tmp2_) {
			break;
		}
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			GError* _tmp3_ = NULL;
			_tmp3_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			_inner_error_ = _tmp3_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		g_string_insert (sql, (gssize) begin, "(");
		g_string_append (sql, " OR ");
		_tmp4_ = tracker_sparql_expression_translate_conditional_and_expression (self, sql, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		optype = _tmp5_;
		g_string_append (sql, ")");
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			GError* _tmp6_ = NULL;
			_tmp6_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			_inner_error_ = _tmp6_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	result = optype;
	return result;
}


TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = tracker_sparql_expression_translate_conditional_or_expression (self, sql, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp1_;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlTokenType _tmp0_;
	TrackerPropertyType _tmp3_;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp0_ = tracker_sparql_expression_current (self);
	if (_tmp0_ == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
		TrackerSparqlPattern* _tmp1_ = NULL;
		TrackerSparqlSelectContext* _tmp2_ = NULL;
		TrackerSparqlSelectContext* select_context;
		g_string_append (sql, "(");
		_tmp1_ = tracker_sparql_expression_get_pattern (self);
		_tmp2_ = tracker_sparql_pattern_translate_select (_tmp1_, sql, TRUE, TRUE, &_inner_error_);
		select_context = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		g_string_append (sql, ")");
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_tracker_sparql_context_unref0 (select_context);
				return 0;
			} else {
				_tracker_sparql_context_unref0 (select_context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = select_context->type;
		_tracker_sparql_context_unref0 (select_context);
		return result;
	}
	_tmp3_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	optype = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	TrackerPropertyType _tmp2_;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp1_) {
		g_string_append (sql, "DISTINCT ");
	}
	_tmp2_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	optype = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = optype;
	return result;
}


TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlTokenType _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = tracker_sparql_expression_current (self);
	switch (_tmp0_) {
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
		{
			TrackerPropertyType _tmp1_;
			TrackerPropertyType _tmp2_;
			_tmp1_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp2_;
			return result;
		}
		default:
		{
			TrackerPropertyType _tmp3_;
			TrackerPropertyType _tmp4_;
			_tmp3_ = tracker_sparql_expression_translate_bracketted_expression (self, sql, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp4_;
			return result;
		}
	}
}


static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self) {
	TrackerSparqlContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->query->context;
	return result;
}


static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self) {
	TrackerSparqlPattern* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->query->pattern;
	return result;
}


static void tracker_sparql_expression_class_init (TrackerSparqlExpressionClass * klass) {
	tracker_sparql_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_expression_get_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_expression_finalize;
}


static void tracker_sparql_expression_instance_init (TrackerSparqlExpression * self) {
	self->priv = TRACKER_SPARQL_EXPRESSION_GET_PRIVATE (self);
}


static void tracker_sparql_expression_finalize (GObject* obj) {
	TrackerSparqlExpression * self;
	self = TRACKER_SPARQL_EXPRESSION (obj);
	G_OBJECT_CLASS (tracker_sparql_expression_parent_class)->finalize (obj);
}


GType tracker_sparql_expression_get_type (void) {
	static volatile gsize tracker_sparql_expression_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlExpression), 0, (GInstanceInitFunc) tracker_sparql_expression_instance_init, NULL };
		GType tracker_sparql_expression_type_id;
		tracker_sparql_expression_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlExpression", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_expression_type_id__volatile, tracker_sparql_expression_type_id);
	}
	return tracker_sparql_expression_type_id__volatile;
}


static void _vala_tracker_sparql_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlExpression * self;
	self = TRACKER_SPARQL_EXPRESSION (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



