/* tracker-view.c generated by valac 0.11.4, the Vala compiler
 * generated from tracker-view.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>


#define TRACKER_TYPE_VIEW (tracker_view_get_type ())
#define TRACKER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_VIEW, TrackerView))
#define TRACKER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_VIEW, TrackerViewClass))
#define TRACKER_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_VIEW))
#define TRACKER_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_VIEW))
#define TRACKER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_VIEW, TrackerViewClass))

typedef struct _TrackerView TrackerView;
typedef struct _TrackerViewClass TrackerViewClass;
typedef struct _TrackerViewPrivate TrackerViewPrivate;

#define TRACKER_VIEW_TYPE_DISPLAY (tracker_view_display_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TRACKER_TYPE_CELL_RENDERER_TEXT (tracker_cell_renderer_text_get_type ())
#define TRACKER_CELL_RENDERER_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_CELL_RENDERER_TEXT, TrackerCellRendererText))
#define TRACKER_CELL_RENDERER_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_CELL_RENDERER_TEXT, TrackerCellRendererTextClass))
#define TRACKER_IS_CELL_RENDERER_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_CELL_RENDERER_TEXT))
#define TRACKER_IS_CELL_RENDERER_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_CELL_RENDERER_TEXT))
#define TRACKER_CELL_RENDERER_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_CELL_RENDERER_TEXT, TrackerCellRendererTextClass))

typedef struct _TrackerCellRendererText TrackerCellRendererText;
typedef struct _TrackerCellRendererTextClass TrackerCellRendererTextClass;

struct _TrackerView {
	GtkScrolledWindow parent_instance;
	TrackerViewPrivate * priv;
};

struct _TrackerViewClass {
	GtkScrolledWindowClass parent_class;
};

typedef enum  {
	TRACKER_VIEW_DISPLAY_NO_RESULTS,
	TRACKER_VIEW_DISPLAY_CATEGORIES,
	TRACKER_VIEW_DISPLAY_FILE_LIST,
	TRACKER_VIEW_DISPLAY_FILE_ICONS
} TrackerViewDisplay;

struct _TrackerViewPrivate {
	TrackerViewDisplay _display;
	GtkListStore* _store;
	GtkWidget* view;
};


static gpointer tracker_view_parent_class = NULL;

GType tracker_view_get_type (void) G_GNUC_CONST;
GType tracker_view_display_get_type (void) G_GNUC_CONST;
#define TRACKER_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_VIEW, TrackerViewPrivate))
enum  {
	TRACKER_VIEW_DUMMY_PROPERTY,
	TRACKER_VIEW_DISPLAY,
	TRACKER_VIEW_STORE
};
TrackerView* tracker_view_new (TrackerViewDisplay* _display, GtkListStore* _store);
TrackerView* tracker_view_construct (GType object_type, TrackerViewDisplay* _display, GtkListStore* _store);
static void tracker_view_set_display (TrackerView* self, TrackerViewDisplay value);
static void tracker_view_set_store (TrackerView* self, GtkListStore* value);
GtkListStore* tracker_view_get_store (TrackerView* self);
TrackerViewDisplay tracker_view_get_display (TrackerView* self);
static void tracker_view_setup_model (TrackerView* self);
TrackerCellRendererText* tracker_cell_renderer_text_new (void);
TrackerCellRendererText* tracker_cell_renderer_text_construct (GType object_type);
GType tracker_cell_renderer_text_get_type (void) G_GNUC_CONST;
void tracker_cell_renderer_text_set_show_fixed_height (TrackerCellRendererText* self, gboolean value);
static void tracker_view_cell_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter);
static void _tracker_view_cell_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void tracker_view_finalize (GObject* obj);
static void _vala_tracker_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType tracker_view_display_get_type (void) {
	static volatile gsize tracker_view_display_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_view_display_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_VIEW_DISPLAY_NO_RESULTS, "TRACKER_VIEW_DISPLAY_NO_RESULTS", "no-results"}, {TRACKER_VIEW_DISPLAY_CATEGORIES, "TRACKER_VIEW_DISPLAY_CATEGORIES", "categories"}, {TRACKER_VIEW_DISPLAY_FILE_LIST, "TRACKER_VIEW_DISPLAY_FILE_LIST", "file-list"}, {TRACKER_VIEW_DISPLAY_FILE_ICONS, "TRACKER_VIEW_DISPLAY_FILE_ICONS", "file-icons"}, {0, NULL, NULL}};
		GType tracker_view_display_type_id;
		tracker_view_display_type_id = g_enum_register_static ("TrackerViewDisplay", values);
		g_once_init_leave (&tracker_view_display_type_id__volatile, tracker_view_display_type_id);
	}
	return tracker_view_display_type_id__volatile;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


TrackerView* tracker_view_construct (GType object_type, TrackerViewDisplay* _display, GtkListStore* _store) {
	TrackerView * self = NULL;
	self = (TrackerView*) g_object_new (object_type, NULL);
	gtk_scrolled_window_set_policy ((GtkScrolledWindow*) self, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	tracker_view_set_display (self, *_display);
	if (_store != NULL) {
		tracker_view_set_store (self, _store);
		g_debug ("tracker-view.vala:49: using store:%p", self->priv->_store);
	} else {
		GtkListStore* _tmp0_ = NULL;
		GtkListStore* _tmp1_;
		_tmp0_ = gtk_list_store_new (10, GDK_TYPE_PIXBUF, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
		_tmp1_ = _tmp0_;
		tracker_view_set_store (self, _tmp1_);
		_g_object_unref0 (_tmp1_);
		g_debug ("tracker-view.vala:63: Creating store:%p", self->priv->_store);
	}
	switch (self->priv->_display) {
		case TRACKER_VIEW_DISPLAY_NO_RESULTS:
		{
			GtkLabel* l;
			GtkLabel* _tmp2_ = NULL;
			GtkLabel* _tmp3_;
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* message;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* markup;
			GtkWidget* _tmp8_;
			GtkWidget* _tmp9_;
			l = NULL;
			_tmp2_ = (GtkLabel*) gtk_label_new ("");
			_tmp3_ = g_object_ref_sink (_tmp2_);
			_g_object_unref0 (l);
			l = _tmp3_;
			_tmp4_ = _ ("No Search Results");
			_tmp5_ = g_strdup (_tmp4_);
			message = _tmp5_;
			_tmp6_ = string_to_string (message);
			_tmp7_ = g_strconcat ("<big>", _tmp6_, "</big>", NULL);
			markup = _tmp7_;
			gtk_label_set_use_markup (l, TRUE);
			gtk_label_set_markup (l, markup);
			_tmp8_ = _g_object_ref0 ((GtkWidget*) l);
			_tmp9_ = _tmp8_;
			_g_object_unref0 (self->priv->view);
			self->priv->view = _tmp9_;
			_g_free0 (markup);
			_g_free0 (message);
			_g_object_unref0 (l);
			break;
		}
		case TRACKER_VIEW_DISPLAY_CATEGORIES:
		case TRACKER_VIEW_DISPLAY_FILE_LIST:
		{
			GtkTreeView* _tmp10_ = NULL;
			GtkWidget* _tmp11_;
			_tmp10_ = (GtkTreeView*) gtk_tree_view_new ();
			_tmp11_ = (GtkWidget*) g_object_ref_sink (_tmp10_);
			_g_object_unref0 (self->priv->view);
			self->priv->view = _tmp11_;
			break;
		}
		case TRACKER_VIEW_DISPLAY_FILE_ICONS:
		{
			GtkIconView* _tmp12_ = NULL;
			GtkWidget* _tmp13_;
			_tmp12_ = (GtkIconView*) gtk_icon_view_new ();
			_tmp13_ = (GtkWidget*) g_object_ref_sink (_tmp12_);
			_g_object_unref0 (self->priv->view);
			self->priv->view = _tmp13_;
			break;
		}
		default:
		break;
	}
	if (self->priv->_display == TRACKER_VIEW_DISPLAY_NO_RESULTS) {
		gtk_scrolled_window_add_with_viewport ((GtkScrolledWindow*) self, self->priv->view);
	} else {
		gtk_container_add ((GtkContainer*) self, self->priv->view);
		tracker_view_setup_model (self);
	}
	GTK_WIDGET_CLASS (tracker_view_parent_class)->show_all ((GtkWidget*) GTK_SCROLLED_WINDOW (self));
	return self;
}


TrackerView* tracker_view_new (TrackerViewDisplay* _display, GtkListStore* _store) {
	return tracker_view_construct (TRACKER_TYPE_VIEW, _display, _store);
}


static void _tracker_view_cell_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	tracker_view_cell_renderer_func (self, cell_layout, cell, tree_model, iter);
}


static void tracker_view_setup_model (TrackerView* self) {
	g_return_if_fail (self != NULL);
	switch (self->priv->_display) {
		case TRACKER_VIEW_DISPLAY_FILE_ICONS:
		{
			{
				GtkIconView* _tmp0_;
				GtkIconView* iv;
				_tmp0_ = _g_object_ref0 (GTK_ICON_VIEW (self->priv->view));
				iv = _tmp0_;
				gtk_icon_view_set_model (iv, (GtkTreeModel*) self->priv->_store);
				gtk_icon_view_set_item_width (iv, 96);
				gtk_icon_view_set_selection_mode (iv, GTK_SELECTION_SINGLE);
				gtk_icon_view_set_pixbuf_column (iv, 1);
				gtk_icon_view_set_text_column (iv, 4);
				_g_object_unref0 (iv);
				break;
			}
		}
		case TRACKER_VIEW_DISPLAY_FILE_LIST:
		{
			{
				GtkTreeViewColumn* col;
				GtkTreeView* _tmp1_;
				GtkTreeView* tv;
				GtkCellRendererPixbuf* _tmp2_ = NULL;
				GtkCellRendererPixbuf* renderer1;
				TrackerCellRendererText* _tmp3_ = NULL;
				TrackerCellRendererText* renderer2;
				GtkTreeViewColumn* _tmp4_ = NULL;
				GtkTreeViewColumn* _tmp5_;
				const gchar* _tmp6_ = NULL;
				TrackerCellRendererText* _tmp7_ = NULL;
				TrackerCellRendererText* renderer3;
				GtkTreeViewColumn* _tmp8_ = NULL;
				GtkTreeViewColumn* _tmp9_;
				const gchar* _tmp10_ = NULL;
				TrackerCellRendererText* _tmp11_ = NULL;
				TrackerCellRendererText* renderer4;
				GtkTreeViewColumn* _tmp12_ = NULL;
				GtkTreeViewColumn* _tmp13_;
				const gchar* _tmp14_ = NULL;
				col = NULL;
				_tmp1_ = _g_object_ref0 (GTK_TREE_VIEW (self->priv->view));
				tv = _tmp1_;
				gtk_tree_view_set_model (tv, (GtkTreeModel*) self->priv->_store);
				gtk_tree_view_set_tooltip_column (tv, 8);
				gtk_tree_view_set_rules_hint (tv, FALSE);
				gtk_tree_view_set_grid_lines (tv, GTK_TREE_VIEW_GRID_LINES_VERTICAL);
				gtk_tree_view_set_headers_visible (tv, TRUE);
				_tmp2_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
				renderer1 = g_object_ref_sink (_tmp2_);
				_tmp3_ = tracker_cell_renderer_text_new ();
				renderer2 = g_object_ref_sink (_tmp3_);
				_tmp4_ = gtk_tree_view_column_new ();
				_tmp5_ = g_object_ref_sink (_tmp4_);
				_g_object_unref0 (col);
				col = _tmp5_;
				gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) renderer1, FALSE);
				gtk_cell_layout_add_attribute ((GtkCellLayout*) col, (GtkCellRenderer*) renderer1, "pixbuf", 0);
				g_object_set ((GtkCellRenderer*) renderer1, "xpad", (guint) 5, NULL);
				g_object_set ((GtkCellRenderer*) renderer1, "ypad", (guint) 5, NULL);
				gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) renderer2, TRUE);
				gtk_cell_layout_add_attribute ((GtkCellLayout*) col, (GtkCellRenderer*) renderer2, "text", 4);
				g_object_set ((GtkCellRendererText*) renderer2, "ellipsize", PANGO_ELLIPSIZE_MIDDLE, NULL);
				tracker_cell_renderer_text_set_show_fixed_height (renderer2, FALSE);
				_tmp6_ = _ ("File");
				gtk_tree_view_column_set_title (col, _tmp6_);
				gtk_tree_view_column_set_resizable (col, TRUE);
				gtk_tree_view_column_set_expand (col, TRUE);
				gtk_tree_view_column_set_sizing (col, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) col, (GtkCellRenderer*) renderer1, _tracker_view_cell_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) col, (GtkCellRenderer*) renderer2, _tracker_view_cell_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				gtk_tree_view_append_column (tv, col);
				_tmp7_ = tracker_cell_renderer_text_new ();
				renderer3 = g_object_ref_sink (_tmp7_);
				_tmp8_ = gtk_tree_view_column_new ();
				_tmp9_ = g_object_ref_sink (_tmp8_);
				_g_object_unref0 (col);
				col = _tmp9_;
				gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) renderer3, TRUE);
				gtk_cell_layout_add_attribute ((GtkCellLayout*) col, (GtkCellRenderer*) renderer3, "text", 6);
				_tmp10_ = _ ("Last Changed");
				gtk_tree_view_column_set_title (col, _tmp10_);
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) col, (GtkCellRenderer*) renderer3, _tracker_view_cell_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				gtk_tree_view_append_column (tv, col);
				_tmp11_ = tracker_cell_renderer_text_new ();
				renderer4 = g_object_ref_sink (_tmp11_);
				_tmp12_ = gtk_tree_view_column_new ();
				_tmp13_ = g_object_ref_sink (_tmp12_);
				_g_object_unref0 (col);
				col = _tmp13_;
				gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) renderer4, TRUE);
				gtk_cell_layout_add_attribute ((GtkCellLayout*) col, (GtkCellRenderer*) renderer4, "text", 7);
				_tmp14_ = _ ("Size");
				gtk_tree_view_column_set_title (col, _tmp14_);
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) col, (GtkCellRenderer*) renderer4, _tracker_view_cell_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				gtk_tree_view_append_column (tv, col);
				_g_object_unref0 (renderer4);
				_g_object_unref0 (renderer3);
				_g_object_unref0 (renderer2);
				_g_object_unref0 (renderer1);
				_g_object_unref0 (tv);
				_g_object_unref0 (col);
				break;
			}
		}
		case TRACKER_VIEW_DISPLAY_CATEGORIES:
		{
			{
				GtkTreeViewColumn* col;
				GtkTreeView* _tmp15_;
				GtkTreeView* tv;
				GtkCellRendererPixbuf* _tmp16_ = NULL;
				GtkCellRendererPixbuf* renderer1;
				TrackerCellRendererText* _tmp17_ = NULL;
				TrackerCellRendererText* renderer2;
				GtkTreeViewColumn* _tmp18_ = NULL;
				GtkTreeViewColumn* _tmp19_;
				const gchar* _tmp20_ = NULL;
				TrackerCellRendererText* _tmp21_ = NULL;
				TrackerCellRendererText* renderer4;
				GtkTreeViewColumn* _tmp22_ = NULL;
				GtkTreeViewColumn* _tmp23_;
				const gchar* _tmp24_ = NULL;
				col = NULL;
				_tmp15_ = _g_object_ref0 (GTK_TREE_VIEW (self->priv->view));
				tv = _tmp15_;
				gtk_tree_view_set_model (tv, (GtkTreeModel*) self->priv->_store);
				gtk_tree_view_set_tooltip_column (tv, 8);
				gtk_tree_view_set_rules_hint (tv, FALSE);
				gtk_tree_view_set_grid_lines (tv, GTK_TREE_VIEW_GRID_LINES_NONE);
				gtk_tree_view_set_headers_visible (tv, FALSE);
				_tmp16_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
				renderer1 = g_object_ref_sink (_tmp16_);
				_tmp17_ = tracker_cell_renderer_text_new ();
				renderer2 = g_object_ref_sink (_tmp17_);
				_tmp18_ = gtk_tree_view_column_new ();
				_tmp19_ = g_object_ref_sink (_tmp18_);
				_g_object_unref0 (col);
				col = _tmp19_;
				gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) renderer1, FALSE);
				gtk_cell_layout_add_attribute ((GtkCellLayout*) col, (GtkCellRenderer*) renderer1, "pixbuf", 0);
				g_object_set ((GtkCellRenderer*) renderer1, "xpad", (guint) 5, NULL);
				g_object_set ((GtkCellRenderer*) renderer1, "ypad", (guint) 5, NULL);
				gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) renderer2, TRUE);
				gtk_cell_layout_add_attribute ((GtkCellLayout*) col, (GtkCellRenderer*) renderer2, "text", 4);
				gtk_cell_layout_add_attribute ((GtkCellLayout*) col, (GtkCellRenderer*) renderer2, "subtext", 5);
				g_object_set ((GtkCellRendererText*) renderer2, "ellipsize", PANGO_ELLIPSIZE_MIDDLE, NULL);
				tracker_cell_renderer_text_set_show_fixed_height (renderer2, TRUE);
				_tmp20_ = _ ("Item");
				gtk_tree_view_column_set_title (col, _tmp20_);
				gtk_tree_view_column_set_resizable (col, TRUE);
				gtk_tree_view_column_set_expand (col, TRUE);
				gtk_tree_view_column_set_sizing (col, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) col, (GtkCellRenderer*) renderer1, _tracker_view_cell_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) col, (GtkCellRenderer*) renderer2, _tracker_view_cell_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				gtk_tree_view_append_column (tv, col);
				_tmp21_ = tracker_cell_renderer_text_new ();
				renderer4 = g_object_ref_sink (_tmp21_);
				_tmp22_ = gtk_tree_view_column_new ();
				_tmp23_ = g_object_ref_sink (_tmp22_);
				_g_object_unref0 (col);
				col = _tmp23_;
				gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) renderer4, TRUE);
				gtk_cell_layout_add_attribute ((GtkCellLayout*) col, (GtkCellRenderer*) renderer4, "text", 7);
				_tmp24_ = _ ("Size");
				gtk_tree_view_column_set_title (col, _tmp24_);
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) col, (GtkCellRenderer*) renderer4, _tracker_view_cell_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				gtk_tree_view_append_column (tv, col);
				_g_object_unref0 (renderer4);
				_g_object_unref0 (renderer2);
				_g_object_unref0 (renderer1);
				_g_object_unref0 (tv);
				_g_object_unref0 (col);
				break;
			}
		}
		default:
		break;
	}
}


static void tracker_view_cell_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter) {
	GdkColor color = {0};
	GtkStyle* style;
	gboolean show_row_hint = FALSE;
	GtkStyle* _tmp0_ = NULL;
	GtkStyle* _tmp1_;
	GtkStyle* _tmp2_;
	gint sum_normal;
	gint sum_selected;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	style = NULL;
	gtk_tree_model_get (tree_model, iter, 9, &show_row_hint, -1, -1);
	_tmp0_ = gtk_widget_get_style (self->priv->view);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (style);
	style = _tmp2_;
	color = style->base[GTK_STATE_SELECTED];
	sum_normal = (gint) ((color.red + color.green) + color.blue);
	color = style->base[GTK_STATE_NORMAL];
	sum_selected = (gint) ((color.red + color.green) + color.blue);
	color = style->text_aa[GTK_STATE_INSENSITIVE];
	if (sum_normal < sum_selected) {
		color.red = (guint16) ((color.red + style->white.red) / 2);
		color.green = (guint16) ((color.green + style->white.green) / 2);
		color.blue = (guint16) ((color.blue + style->white.blue) / 2);
	} else {
		color.red = (guint16) ((color.red + style->black.red) / 2);
		color.green = (guint16) ((color.green + style->black.green) / 2);
		color.blue = (guint16) ((color.blue + style->black.blue) / 2);
	}
	if (show_row_hint) {
		g_object_set ((GObject*) cell, "cell-background-gdk", &color, NULL);
	} else {
		g_object_set ((GObject*) cell, "cell-background-gdk", NULL, NULL);
	}
	_g_object_unref0 (style);
}


TrackerViewDisplay tracker_view_get_display (TrackerView* self) {
	TrackerViewDisplay result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_display;
	return result;
}


static void tracker_view_set_display (TrackerView* self, TrackerViewDisplay value) {
	g_return_if_fail (self != NULL);
	self->priv->_display = value;
	g_object_notify ((GObject *) self, "display");
}


GtkListStore* tracker_view_get_store (TrackerView* self) {
	GtkListStore* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_store;
	return result;
}


static void tracker_view_set_store (TrackerView* self, GtkListStore* value) {
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_store);
	self->priv->_store = _tmp1_;
	g_object_notify ((GObject *) self, "store");
}


static void tracker_view_class_init (TrackerViewClass * klass) {
	tracker_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_VIEW_DISPLAY, g_param_spec_enum ("display", "display", "display", TRACKER_VIEW_TYPE_DISPLAY, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_VIEW_STORE, g_param_spec_object ("store", "store", "store", GTK_TYPE_LIST_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void tracker_view_instance_init (TrackerView * self) {
	self->priv = TRACKER_VIEW_GET_PRIVATE (self);
	self->priv->view = NULL;
}


static void tracker_view_finalize (GObject* obj) {
	TrackerView * self;
	self = TRACKER_VIEW (obj);
	_g_object_unref0 (self->priv->_store);
	_g_object_unref0 (self->priv->view);
	G_OBJECT_CLASS (tracker_view_parent_class)->finalize (obj);
}


GType tracker_view_get_type (void) {
	static volatile gsize tracker_view_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerView), 0, (GInstanceInitFunc) tracker_view_instance_init, NULL };
		GType tracker_view_type_id;
		tracker_view_type_id = g_type_register_static (GTK_TYPE_SCROLLED_WINDOW, "TrackerView", &g_define_type_info, 0);
		g_once_init_leave (&tracker_view_type_id__volatile, tracker_view_type_id);
	}
	return tracker_view_type_id__volatile;
}


static void _vala_tracker_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerView * self;
	self = TRACKER_VIEW (object);
	switch (property_id) {
		case TRACKER_VIEW_DISPLAY:
		g_value_set_enum (value, tracker_view_get_display (self));
		break;
		case TRACKER_VIEW_STORE:
		g_value_set_object (value, tracker_view_get_store (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tracker_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerView * self;
	self = TRACKER_VIEW (object);
	switch (property_id) {
		case TRACKER_VIEW_DISPLAY:
		tracker_view_set_display (self, g_value_get_enum (value));
		break;
		case TRACKER_VIEW_STORE:
		tracker_view_set_store (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



