/* tracker-miner-flickr.c generated by valac 0.11.5, the Vala compiler
 * generated from tracker-miner-flickr.vala, do not modify */

/*
 * Copyright (C) 2010, Adrien Bustany <abustany@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-miner/tracker-miner.h>
#include <gio/gio.h>
#include <rest/rest-proxy.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <rest/rest-proxy-call.h>
#include <rest/rest-xml-parser.h>
#include <float.h>
#include <math.h>
#include <signal.h>
#include <stdio.h>
#include <sys/select.h>


#define TRACKER_TYPE_MINER_FLICKR (tracker_miner_flickr_get_type ())
#define TRACKER_MINER_FLICKR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_MINER_FLICKR, TrackerMinerFlickr))
#define TRACKER_MINER_FLICKR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_MINER_FLICKR, TrackerMinerFlickrClass))
#define TRACKER_IS_MINER_FLICKR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_MINER_FLICKR))
#define TRACKER_IS_MINER_FLICKR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_MINER_FLICKR))
#define TRACKER_MINER_FLICKR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_MINER_FLICKR, TrackerMinerFlickrClass))

typedef struct _TrackerMinerFlickr TrackerMinerFlickr;
typedef struct _TrackerMinerFlickrClass TrackerMinerFlickrClass;
typedef struct _TrackerMinerFlickrPrivate TrackerMinerFlickrPrivate;

#define TRACKER_MINER_FLICKR_TYPE_EXIF_TAG (tracker_miner_flickr_exif_tag_get_type ())

#define TRACKER_MINER_FLICKR_TYPE_EXIF_METERING_MODE (tracker_miner_flickr_exif_metering_mode_get_type ())

#define TRACKER_MINER_FLICKR_TYPE_EXIF_WHITE_BALANCE (tracker_miner_flickr_exif_white_balance_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rest_xml_node_unref0(var) ((var == NULL) ? NULL : (var = (rest_xml_node_unref (var), NULL)))
typedef struct _TrackerMinerFlickrInitPullData TrackerMinerFlickrInitPullData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _TrackerMinerFlickrWritebackPhotoData TrackerMinerFlickrWritebackPhotoData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

typedef void (*TrackerWritebackCallback) (GHashTable* resources, void* user_data);
typedef enum  {
	TRACKER_REST_CALL_ERROR_INVALID_RESPONSE,
	TRACKER_REST_CALL_ERROR_CALL_ERROR
} TrackerRestCallError;
#define TRACKER_REST_CALL_ERROR tracker_rest_call_error_quark ()
struct _TrackerMinerFlickr {
	TrackerMinerWeb parent_instance;
	TrackerMinerFlickrPrivate * priv;
};

struct _TrackerMinerFlickrClass {
	TrackerMinerWebClass parent_class;
};

struct _TrackerMinerFlickrPrivate {
	guint pull_timeout_handle;
	RestProxy* rest;
	gchar* frob;
	gchar* auth_token;
	gchar* user_id;
	gint nmm_photo_id;
};

typedef enum  {
	TRACKER_MINER_FLICKR_EXIF_TAG_CAMERA_MAKE = 271,
	TRACKER_MINER_FLICKR_EXIF_TAG_CAMERA_MODEL = 272,
	TRACKER_MINER_FLICKR_EXIF_TAG_FLASH = 37385,
	TRACKER_MINER_FLICKR_EXIF_TAG_FNUMBER = 33437,
	TRACKER_MINER_FLICKR_EXIF_TAG_FOCAL_LENGTH = 37386,
	TRACKER_MINER_FLICKR_EXIF_TAG_ISO_SPEED = 2,
	TRACKER_MINER_FLICKR_EXIF_TAG_METERING_MODE = 37383,
	TRACKER_MINER_FLICKR_EXIF_TAG_WHITE_BALANCE = 5
} TrackerMinerFlickrExifTag;

typedef enum  {
	TRACKER_MINER_FLICKR_EXIF_METERING_MODE_AVERAGE = 1,
	TRACKER_MINER_FLICKR_EXIF_METERING_MODE_CENTER_WEIGHTED_AVERAGE,
	TRACKER_MINER_FLICKR_EXIF_METERING_MODE_SPOT,
	TRACKER_MINER_FLICKR_EXIF_METERING_MODE_MULTISPOT,
	TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PATTERN,
	TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PARTIAL
} TrackerMinerFlickrExifMeteringMode;

typedef enum  {
	TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_AUTO = 0,
	TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_MANUAL
} TrackerMinerFlickrExifWhiteBalance;

struct _TrackerMinerFlickrInitPullData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerMinerFlickr* self;
	RestProxyCall* albums_call;
	RestXmlNode* photosets_node;
	RestProxyCall* _tmp0_;
	RestProxyCall* _tmp1_;
	RestXmlNode* _tmp2_;
	RestXmlNode* _tmp3_;
	RestXmlNode* _tmp4_;
	GError * call_error;
	gchar* _tmp5_;
	gchar* error_message;
	GError * _inner_error_;
};

struct _TrackerMinerFlickrWritebackPhotoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerMinerFlickr* self;
	gint id;
	TrackerSparqlCursor* cursor;
	gchar* photo_urn;
	gchar* photo_id;
	gchar** _tmp0_;
	gchar** local_tags;
	gint local_tags_length1;
	gint _local_tags_size_;
	GHashTable* _tmp1_;
	GHashTable* flickr_tags;
	gchar** _tmp2_;
	gchar** tags_to_add;
	gint tags_to_add_length1;
	gint _tags_to_add_size_;
	gchar** _tmp3_;
	gchar** tags_to_remove;
	gint tags_to_remove_length1;
	gint _tags_to_remove_size_;
	RestProxyCall* tag_call;
	RestXmlNode* root_node;
	RestXmlNode* tag_node;
	TrackerSparqlConnection* _tmp4_;
	TrackerSparqlConnection* _tmp5_;
	TrackerSparqlConnection* c;
	gchar* _tmp6_;
	gchar* _tmp7_;
	TrackerSparqlCursor* _tmp8_;
	TrackerSparqlCursor* _tmp9_;
	TrackerSparqlCursor* _tmp10_;
	TrackerSparqlCursor* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* s;
	TrackerSparqlCursor* _tmp18_;
	TrackerSparqlCursor* _tmp19_;
	TrackerSparqlCursor* _tmp20_;
	GError * query_error;
	gchar* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GError * cursor_error;
	RestProxyCall* _tmp32_;
	RestProxyCall* _tmp33_;
	RestXmlNode* _tmp34_;
	RestXmlNode* _tmp35_;
	RestXmlNode* _tmp36_;
	GError * get_tags_error;
	gchar* _tmp37_;
	gchar* error_message;
	RestXmlNode* _tmp38_;
	RestXmlNode* _tmp39_;
	RestXmlNode* _tmp40_;
	RestXmlNode* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	RestXmlNode* _tmp46_;
	RestXmlNode* _tmp47_;
	gchar** local_tag_collection;
	int local_tag_collection_length1;
	int local_tag_it;
	gchar* _tmp48_;
	gchar* local_tag;
	gconstpointer _tmp49_;
	gchar* _tmp50_;
	GList* _tmp51_;
	GList* flickr_tag_collection;
	GList* flickr_tag_it;
	const gchar* flickr_tag;
	gint _tmp52_;
	gconstpointer _tmp53_;
	gchar* _tmp54_;
	gchar** tag_collection;
	int tag_collection_length1;
	int tag_it;
	gchar* _tmp55_;
	gchar* tag;
	GError * _inner_error_;
};


static gpointer tracker_miner_flickr_parent_class = NULL;
static GMainLoop* tracker_miner_flickr_main_loop;
static GMainLoop* tracker_miner_flickr_main_loop = NULL;
static gboolean tracker_miner_flickr_in_loop;
static gboolean tracker_miner_flickr_in_loop = FALSE;
static GInitableIface* tracker_miner_flickr_g_initable_parent_iface = NULL;

void tracker_writeback_init (void);
void tracker_writeback_shutdown (void);
guint tracker_writeback_connect (TrackerWritebackCallback callback, void* callback_target, void* user_data);
void tracker_writeback_disconnect (guint handle);
GQuark tracker_rest_call_error_quark (void);
GType tracker_miner_flickr_get_type (void) G_GNUC_CONST;
#define TRACKER_MINER_FLICKR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_MINER_FLICKR, TrackerMinerFlickrPrivate))
enum  {
	TRACKER_MINER_FLICKR_DUMMY_PROPERTY
};
static GType tracker_miner_flickr_exif_tag_get_type (void) G_GNUC_UNUSED;
static GType tracker_miner_flickr_exif_metering_mode_get_type (void) G_GNUC_UNUSED;
static GType tracker_miner_flickr_exif_white_balance_get_type (void) G_GNUC_UNUSED;
#define TRACKER_MINER_FLICKR_MINER_NAME "Flickr"
#define TRACKER_MINER_FLICKR_MINER_DESCRIPTION "Tracker miner for Flickr"
#define TRACKER_MINER_FLICKR_API_KEY "7983269709fa3158c752e3e4d6b3b9e5"
#define TRACKER_MINER_FLICKR_SHARED_SECRET "c0316d1cb4b15e2d"
#define TRACKER_MINER_FLICKR_DATASOURCE_URN "urn:nepomuk:datasource:2208f9fc-3c5b-4e40-ade4-45a0d7b0cf6f"
#define TRACKER_MINER_FLICKR_FLICKR_AUTH_URL "http://api.flickr.com/services/auth/"
#define TRACKER_MINER_FLICKR_FLICKR_REST_URL "http://api.flickr.com/services/rest/"
#define TRACKER_MINER_FLICKR_FLICKR_PHOTOSET_URL "http://www.flickr.com/photos/%s/sets/%s"
#define TRACKER_MINER_FLICKR_FLICKR_PHOTO_URL "http://farm%s.static.flickr.com/%s/%s_%s.jpg"
#define TRACKER_MINER_FLICKR_PULL_INTERVAL ((guint) (5 * 60))
static gboolean tracker_miner_flickr_real_init (GInitable* base, GCancellable* cancellable, GError** error);
void tracker_miner_flickr_writeback (TrackerMinerFlickr* self, GHashTable* properties);
static void _tracker_miner_flickr_writeback_tracker_writeback_callback (GHashTable* resources, gpointer self);
static void tracker_miner_flickr_init_datasource (TrackerMinerFlickr* self);
static void tracker_miner_flickr_load_nmm_photo_id (TrackerMinerFlickr* self);
static void tracker_miner_flickr_association_status_changed (TrackerMinerFlickr* self, GObject* source, GParamSpec* pspec);
static void _tracker_miner_flickr_association_status_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void tracker_miner_flickr_shutdown (TrackerMinerFlickr* self);
static gboolean tracker_miner_flickr_pull_timeout_cb (TrackerMinerFlickr* self);
static gboolean _tracker_miner_flickr_pull_timeout_cb_gsource_func (gpointer self);
static gboolean _lambda1_ (TrackerMinerFlickr* self);
static gboolean __lambda1__gsource_func (gpointer self);
static void tracker_miner_flickr_init_pull (TrackerMinerFlickr* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_miner_flickr_init_pull_finish (TrackerMinerFlickr* self, GAsyncResult* _res_);
static void tracker_miner_flickr_init_pull_data_free (gpointer _data);
static gboolean tracker_miner_flickr_init_pull_co (TrackerMinerFlickrInitPullData* data);
static gboolean _tracker_miner_flickr_init_pull_co_gsource_func (gpointer self);
static RestXmlNode* tracker_miner_flickr_run_call (TrackerMinerFlickr* self, RestProxyCall* call, GError** error);
static void tracker_miner_flickr_insert_photosets (TrackerMinerFlickr* self, RestXmlNode* root_node);
static gchar* tracker_miner_flickr_get_resource (TrackerMinerFlickr* self, const gchar* graph, gchar** types, int types_length1, const gchar* identifier, gboolean* created, GError** error);
static void tracker_miner_flickr_insert_photos (TrackerMinerFlickr* self, RestXmlNode* root_node);
static void tracker_miner_flickr_insert_photo_info (TrackerMinerFlickr* self, RestXmlNode* photo_node, TrackerSparqlBuilder* builder, const gchar* graph, const gchar* urn);
static void tracker_miner_flickr_insert_exif_data (TrackerMinerFlickr* self, RestXmlNode* photo_node, TrackerSparqlBuilder* builder, const gchar* graph, const gchar* urn);
void tracker_miner_flickr_update_triple_string (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const gchar* graph, const gchar* urn, const gchar* property, const gchar* new_value);
void tracker_miner_flickr_update_triple_object (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const gchar* graph, const gchar* urn, const gchar* property, const gchar* new_value);
void tracker_miner_flickr_update_triple_double (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const gchar* graph, const gchar* urn, const gchar* property, gdouble new_value);
static gdouble tracker_miner_flickr_ratio_to_double (TrackerMinerFlickr* self, const gchar* ratio);
void tracker_miner_flickr_update_triple_int64 (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const gchar* graph, const gchar* urn, const gchar* property, gint64 new_value);
static void tracker_miner_flickr_add_tags (TrackerMinerFlickr* self, const gchar* photo_id, gchar** tags, int tags_length1);
static void tracker_miner_flickr_remove_tag (TrackerMinerFlickr* self, const gchar* tag_id);
static void tracker_miner_flickr_writeback_photo_data_free (gpointer _data);
static void tracker_miner_flickr_writeback_photo (TrackerMinerFlickr* self, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_miner_flickr_writeback_photo_finish (TrackerMinerFlickr* self, GAsyncResult* _res_);
static gboolean tracker_miner_flickr_writeback_photo_co (TrackerMinerFlickrWritebackPhotoData* data);
static void _g_free0_ (gpointer var);
static void tracker_miner_flickr_writeback_photo_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static gint tracker_miner_flickr_array_search_str (TrackerMinerFlickr* self, const gchar* needle, gchar** haystack, int haystack_length1);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void tracker_miner_flickr_sign_call (TrackerMinerFlickr* self, RestProxyCall* call);
static GHashTable* tracker_miner_flickr_real_get_association_data (TrackerMinerWeb* base, GError** error);
static void tracker_miner_flickr_real_associate (TrackerMinerWeb* base, GHashTable* association_data, GError** error);
static void tracker_miner_flickr_real_authenticate (TrackerMinerWeb* base, GError** error);
static void tracker_miner_flickr_real_dissociate (TrackerMinerWeb* base, GError** error);
static void _lambda0_ (gint key, GArray* value, TrackerMinerFlickr* self);
static void __lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void tracker_miner_flickr_signal_handler (gint signo);
static void tracker_miner_flickr_init_signals (void);
static void _tracker_miner_flickr_signal_handler_sighandler_t (gint signal);
gint tracker_miner_flickr_main (gchar** args, int args_length1);
TrackerMinerFlickr* tracker_miner_flickr_new (void);
TrackerMinerFlickr* tracker_miner_flickr_construct (GType object_type);
static GObject * tracker_miner_flickr_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void tracker_miner_flickr_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark tracker_rest_call_error_quark (void) {
	return g_quark_from_static_string ("tracker_rest_call_error-quark");
}


static GType tracker_miner_flickr_exif_tag_get_type (void) {
	static volatile gsize tracker_miner_flickr_exif_tag_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_miner_flickr_exif_tag_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_MINER_FLICKR_EXIF_TAG_CAMERA_MAKE, "TRACKER_MINER_FLICKR_EXIF_TAG_CAMERA_MAKE", "camera-make"}, {TRACKER_MINER_FLICKR_EXIF_TAG_CAMERA_MODEL, "TRACKER_MINER_FLICKR_EXIF_TAG_CAMERA_MODEL", "camera-model"}, {TRACKER_MINER_FLICKR_EXIF_TAG_FLASH, "TRACKER_MINER_FLICKR_EXIF_TAG_FLASH", "flash"}, {TRACKER_MINER_FLICKR_EXIF_TAG_FNUMBER, "TRACKER_MINER_FLICKR_EXIF_TAG_FNUMBER", "fnumber"}, {TRACKER_MINER_FLICKR_EXIF_TAG_FOCAL_LENGTH, "TRACKER_MINER_FLICKR_EXIF_TAG_FOCAL_LENGTH", "focal-length"}, {TRACKER_MINER_FLICKR_EXIF_TAG_ISO_SPEED, "TRACKER_MINER_FLICKR_EXIF_TAG_ISO_SPEED", "iso-speed"}, {TRACKER_MINER_FLICKR_EXIF_TAG_METERING_MODE, "TRACKER_MINER_FLICKR_EXIF_TAG_METERING_MODE", "metering-mode"}, {TRACKER_MINER_FLICKR_EXIF_TAG_WHITE_BALANCE, "TRACKER_MINER_FLICKR_EXIF_TAG_WHITE_BALANCE", "white-balance"}, {0, NULL, NULL}};
		GType tracker_miner_flickr_exif_tag_type_id;
		tracker_miner_flickr_exif_tag_type_id = g_enum_register_static ("TrackerMinerFlickrExifTag", values);
		g_once_init_leave (&tracker_miner_flickr_exif_tag_type_id__volatile, tracker_miner_flickr_exif_tag_type_id);
	}
	return tracker_miner_flickr_exif_tag_type_id__volatile;
}


static GType tracker_miner_flickr_exif_metering_mode_get_type (void) {
	static volatile gsize tracker_miner_flickr_exif_metering_mode_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_miner_flickr_exif_metering_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_MINER_FLICKR_EXIF_METERING_MODE_AVERAGE, "TRACKER_MINER_FLICKR_EXIF_METERING_MODE_AVERAGE", "average"}, {TRACKER_MINER_FLICKR_EXIF_METERING_MODE_CENTER_WEIGHTED_AVERAGE, "TRACKER_MINER_FLICKR_EXIF_METERING_MODE_CENTER_WEIGHTED_AVERAGE", "center-weighted-average"}, {TRACKER_MINER_FLICKR_EXIF_METERING_MODE_SPOT, "TRACKER_MINER_FLICKR_EXIF_METERING_MODE_SPOT", "spot"}, {TRACKER_MINER_FLICKR_EXIF_METERING_MODE_MULTISPOT, "TRACKER_MINER_FLICKR_EXIF_METERING_MODE_MULTISPOT", "multispot"}, {TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PATTERN, "TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PATTERN", "pattern"}, {TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PARTIAL, "TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PARTIAL", "partial"}, {0, NULL, NULL}};
		GType tracker_miner_flickr_exif_metering_mode_type_id;
		tracker_miner_flickr_exif_metering_mode_type_id = g_enum_register_static ("TrackerMinerFlickrExifMeteringMode", values);
		g_once_init_leave (&tracker_miner_flickr_exif_metering_mode_type_id__volatile, tracker_miner_flickr_exif_metering_mode_type_id);
	}
	return tracker_miner_flickr_exif_metering_mode_type_id__volatile;
}


static GType tracker_miner_flickr_exif_white_balance_get_type (void) {
	static volatile gsize tracker_miner_flickr_exif_white_balance_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_miner_flickr_exif_white_balance_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_AUTO, "TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_AUTO", "auto"}, {TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_MANUAL, "TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_MANUAL", "manual"}, {0, NULL, NULL}};
		GType tracker_miner_flickr_exif_white_balance_type_id;
		tracker_miner_flickr_exif_white_balance_type_id = g_enum_register_static ("TrackerMinerFlickrExifWhiteBalance", values);
		g_once_init_leave (&tracker_miner_flickr_exif_white_balance_type_id__volatile, tracker_miner_flickr_exif_white_balance_type_id);
	}
	return tracker_miner_flickr_exif_white_balance_type_id__volatile;
}


static void _tracker_miner_flickr_writeback_tracker_writeback_callback (GHashTable* resources, gpointer self) {
	tracker_miner_flickr_writeback (self, resources);
}


static void _tracker_miner_flickr_association_status_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	tracker_miner_flickr_association_status_changed (self, _sender, pspec);
}


static gboolean tracker_miner_flickr_real_init (GInitable* base, GCancellable* cancellable, GError** error) {
	TrackerMinerFlickr * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (TrackerMinerFlickr*) base;
	tracker_miner_flickr_g_initable_parent_iface->init ((GInitable*) TRACKER_MINER_WEB (self), cancellable, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	tracker_writeback_init ();
	tracker_writeback_connect (_tracker_miner_flickr_writeback_tracker_writeback_callback, self, NULL);
	tracker_miner_flickr_init_datasource (self);
	tracker_miner_flickr_load_nmm_photo_id (self);
	g_signal_connect_object ((GObject*) self, "notify::associated", (GCallback) _tracker_miner_flickr_association_status_changed_g_object_notify, self, 0);
	result = TRUE;
	return result;
}


void tracker_miner_flickr_shutdown (TrackerMinerFlickr* self) {
	g_return_if_fail (self != NULL);
	tracker_writeback_shutdown ();
	g_object_set ((TrackerMiner*) self, "status", "Shutting down", NULL);
	g_object_set ((TrackerMinerWeb*) self, "associated", FALSE, NULL);
}


static void tracker_miner_flickr_init_datasource (TrackerMinerFlickr* self) {
	TrackerSparqlConnection* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_miner_get_connection ((TrackerMiner*) self);
	_tmp1_ = g_strdup_printf ("insert { <%s> a nie:DataSource ; nao:identifier \"flickr\" }", TRACKER_MINER_FLICKR_DATASOURCE_URN);
	_tmp2_ = _tmp1_;
	tracker_sparql_connection_update (_tmp0_, _tmp2_, G_PRIORITY_DEFAULT, NULL, &_inner_error_);
	_g_free0 (_tmp2_);
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("tracker-miner-flickr.vala:125: Couldn't init datasource: %s", e->message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void tracker_miner_flickr_load_nmm_photo_id (TrackerMinerFlickr* self) {
	TrackerSparqlCursor* cursor = NULL;
	gchar* _tmp0_;
	gchar* query;
	TrackerSparqlConnection* _tmp1_ = NULL;
	TrackerSparqlCursor* _tmp2_ = NULL;
	TrackerSparqlCursor* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("select tracker:id (nmm:Photo) {}");
	query = _tmp0_;
	self->priv->nmm_photo_id = -1;
	_tmp1_ = tracker_miner_get_connection ((TrackerMiner*) self);
	_tmp2_ = tracker_sparql_connection_query (_tmp1_, query, NULL, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	_tmp4_ = _tmp3_;
	_g_object_unref0 (cursor);
	cursor = _tmp4_;
	_tmp5_ = tracker_sparql_cursor_next (cursor, NULL, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	g_return_if_fail (_tmp6_ == TRUE);
	_tmp7_ = tracker_sparql_cursor_get_string (cursor, 0, NULL);
	_tmp8_ = atoi (_tmp7_);
	self->priv->nmm_photo_id = _tmp8_;
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("tracker-miner-flickr.vala:142: Could not load ID of class nmm:Photo: %" \
"s", e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (query);
		_g_object_unref0 (cursor);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (query);
	_g_object_unref0 (cursor);
}


static gboolean _tracker_miner_flickr_pull_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_miner_flickr_pull_timeout_cb (self);
	return result;
}


static gboolean _lambda1_ (TrackerMinerFlickr* self) {
	gboolean result = FALSE;
	tracker_miner_flickr_pull_timeout_cb (self);
	result = FALSE;
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


static void tracker_miner_flickr_association_status_changed (TrackerMinerFlickr* self, GObject* source, GParamSpec* pspec) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (pspec != NULL);
	if ((g_object_get ((TrackerMinerWeb*) self, "associated", &_tmp0_, NULL), _tmp0_)) {
		guint _tmp1_;
		if (self->priv->pull_timeout_handle != 0) {
			return;
		}
		g_message ("tracker-miner-flickr.vala:151: Miner is now associated. Initiating per" \
"iodic pull.");
		_tmp1_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, TRACKER_MINER_FLICKR_PULL_INTERVAL, _tracker_miner_flickr_pull_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->pull_timeout_handle = _tmp1_;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda1__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		if (self->priv->pull_timeout_handle == 0) {
			return;
		}
		g_source_remove (self->priv->pull_timeout_handle);
	}
}


static gboolean tracker_miner_flickr_pull_timeout_cb (TrackerMinerFlickr* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	tracker_miner_flickr_init_pull (self, NULL, NULL);
	result = TRUE;
	return result;
}


static void tracker_miner_flickr_init_pull_data_free (gpointer _data) {
	TrackerMinerFlickrInitPullData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (TrackerMinerFlickrInitPullData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tracker_miner_flickr_init_pull (TrackerMinerFlickr* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerMinerFlickrInitPullData* _data_;
	_data_ = g_slice_new0 (TrackerMinerFlickrInitPullData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_miner_flickr_init_pull);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_miner_flickr_init_pull_data_free);
	_data_->self = _g_object_ref0 (self);
	tracker_miner_flickr_init_pull_co (_data_);
}


static void tracker_miner_flickr_init_pull_finish (TrackerMinerFlickr* self, GAsyncResult* _res_) {
	TrackerMinerFlickrInitPullData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _tracker_miner_flickr_init_pull_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_miner_flickr_init_pull_co (self);
	return result;
}


static gboolean tracker_miner_flickr_init_pull_co (TrackerMinerFlickrInitPullData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_object_set ((TrackerMiner*) data->self, "status", "Refreshing photo albums", NULL);
	g_object_set ((TrackerMiner*) data->self, "progress", 0.0, NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tracker_miner_flickr_init_pull_co_gsource_func, data, NULL);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	data->_tmp0_ = NULL;
	data->_tmp0_ = rest_proxy_new_call (data->self->priv->rest);
	data->_tmp1_ = data->_tmp0_;
	_g_object_unref0 (data->albums_call);
	data->albums_call = data->_tmp1_;
	rest_proxy_call_add_param (data->albums_call, "method", "flickr.photosets.getList");
	data->_tmp2_ = NULL;
	data->_tmp2_ = tracker_miner_flickr_run_call (data->self, data->albums_call, &data->_inner_error_);
	data->_tmp3_ = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	data->_tmp4_ = data->_tmp3_;
	_rest_xml_node_unref0 (data->photosets_node);
	data->photosets_node = data->_tmp4_;
	tracker_miner_flickr_insert_photosets (data->self, data->photosets_node);
	goto __finally2;
	__catch2_g_error:
	{
		data->call_error = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp5_ = NULL;
		data->_tmp5_ = g_strdup_printf ("Could not get photosets list: %s", data->call_error->message);
		data->error_message = data->_tmp5_;
		g_object_set ((TrackerMiner*) data->self, "status", data->error_message, NULL);
		g_warning ("tracker-miner-flickr.vala:188: %s", data->error_message);
		_g_free0 (data->error_message);
		_g_error_free0 (data->call_error);
	}
	__finally2:
	if (data->_inner_error_ != NULL) {
		_rest_xml_node_unref0 (data->photosets_node);
		_g_object_unref0 (data->albums_call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	g_object_set ((TrackerMiner*) data->self, "status", "Idle", NULL);
	g_object_set ((TrackerMiner*) data->self, "progress", 1.0, NULL);
	g_message ("tracker-miner-flickr.vala:193: Pull finished");
	_rest_xml_node_unref0 (data->photosets_node);
	_g_object_unref0 (data->albums_call);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gpointer _rest_xml_node_ref0 (gpointer self) {
	return self ? rest_xml_node_ref (self) : NULL;
}


static void tracker_miner_flickr_insert_photosets (TrackerMinerFlickr* self, RestXmlNode* root_node) {
	RestXmlNode* photoset_node = NULL;
	RestXmlNode* title_node = NULL;
	RestXmlNode* photos_node = NULL;
	gchar* photoset_url = NULL;
	gchar* photoset_identifier = NULL;
	gboolean resource_created = FALSE;
	gchar* photoset_urn = NULL;
	gchar* delete_query = NULL;
	RestProxyCall* photos_call = NULL;
	TrackerSparqlBuilder* builder = NULL;
	guint n_photosets = 0U;
	guint indexed_photosets;
	RestXmlNode* _tmp0_ = NULL;
	RestXmlNode* _tmp1_;
	RestXmlNode* _tmp2_;
	guint _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_node != NULL);
	indexed_photosets = (guint) 0;
	_tmp0_ = rest_xml_node_find (root_node, "photoset");
	_tmp1_ = _rest_xml_node_ref0 (_tmp0_);
	_tmp2_ = _tmp1_;
	_rest_xml_node_unref0 (photoset_node);
	photoset_node = _tmp2_;
	_tmp3_ = g_hash_table_size (root_node->children);
	n_photosets = _tmp3_;
	while (TRUE) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_ = NULL;
		gchar** _tmp13_;
		gint _tmp13__length1;
		gboolean _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		TrackerSparqlBuilder* _tmp19_ = NULL;
		TrackerSparqlBuilder* _tmp20_;
		RestXmlNode* _tmp24_ = NULL;
		RestXmlNode* _tmp25_;
		RestXmlNode* _tmp26_;
		TrackerSparqlConnection* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		RestProxyCall* _tmp31_ = NULL;
		RestProxyCall* _tmp32_;
		const gchar* _tmp33_ = NULL;
		RestXmlNode* _tmp34_ = NULL;
		RestXmlNode* _tmp35_;
		RestXmlNode* _tmp36_;
		RestXmlNode* _tmp38_;
		RestXmlNode* _tmp39_;
		if (!(photoset_node != NULL)) {
			break;
		}
		_tmp4_ = rest_xml_node_get_attr (photoset_node, "id");
		_tmp5_ = g_strdup_printf (TRACKER_MINER_FLICKR_FLICKR_PHOTOSET_URL, self->priv->user_id, _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (photoset_url);
		photoset_url = _tmp6_;
		_tmp7_ = rest_xml_node_get_attr (photoset_node, "id");
		_tmp8_ = g_strdup_printf ("flickr:photoset:%s", _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (photoset_identifier);
		photoset_identifier = _tmp9_;
		_tmp10_ = g_strdup ("nfo:MediaList");
		_tmp11_ = g_strdup ("nfo:RemoteDataObject");
		_tmp12_ = g_new0 (gchar*, 2 + 1);
		_tmp12_[0] = _tmp10_;
		_tmp12_[1] = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp13__length1 = 2;
		_tmp15_ = tracker_miner_flickr_get_resource (self, photoset_url, _tmp13_, 2, photoset_identifier, &_tmp14_, &_inner_error_);
		resource_created = _tmp14_;
		_tmp17_ = (_tmp16_ = _tmp15_, _tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL), _tmp16_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_tmp18_ = _tmp17_;
		_g_free0 (photoset_urn);
		photoset_urn = _tmp18_;
		g_message ("tracker-miner-flickr.vala:222: Getting photos for album %s", photoset_url);
		_tmp19_ = tracker_sparql_builder_new_update ();
		_tmp20_ = _tmp19_;
		_g_object_unref0 (builder);
		builder = _tmp20_;
		tracker_sparql_builder_insert_open (builder, photoset_url);
		tracker_sparql_builder_subject_iri (builder, photoset_urn);
		if (!resource_created) {
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			TrackerSparqlConnection* _tmp23_ = NULL;
			_tmp21_ = g_strdup_printf ("delete { <%1$s> nie:title ?title }" "where  { <%1$s> nie:title ?title }", photoset_urn);
			_tmp22_ = _tmp21_;
			_g_free0 (delete_query);
			delete_query = _tmp22_;
			_tmp23_ = tracker_miner_get_connection ((TrackerMiner*) self);
			tracker_sparql_connection_update (_tmp23_, delete_query, G_PRIORITY_DEFAULT, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
		} else {
			tracker_sparql_builder_predicate (builder, "nie:dataSource");
			tracker_sparql_builder_object_iri (builder, TRACKER_MINER_FLICKR_DATASOURCE_URN);
			tracker_sparql_builder_predicate (builder, "nie:url");
			tracker_sparql_builder_object_string (builder, photoset_url);
		}
		_tmp24_ = rest_xml_node_find (photoset_node, "title");
		_tmp25_ = _rest_xml_node_ref0 (_tmp24_);
		_tmp26_ = _tmp25_;
		_rest_xml_node_unref0 (title_node);
		title_node = _tmp26_;
		if (title_node != NULL) {
			tracker_sparql_builder_predicate (builder, "nie:title");
			tracker_sparql_builder_object_string (builder, title_node->content);
		}
		tracker_sparql_builder_insert_close (builder);
		_tmp27_ = tracker_miner_get_connection ((TrackerMiner*) self);
		_tmp28_ = tracker_sparql_builder_get_result (builder);
		tracker_sparql_connection_update (_tmp27_, _tmp28_, G_PRIORITY_DEFAULT, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_tmp29_ = g_strdup_printf ("Refresing album \"%s\"", title_node->content);
		_tmp30_ = _tmp29_;
		g_object_set ((TrackerMiner*) self, "status", _tmp30_, NULL);
		_g_free0 (_tmp30_);
		_tmp31_ = rest_proxy_new_call (self->priv->rest);
		_tmp32_ = _tmp31_;
		_g_object_unref0 (photos_call);
		photos_call = _tmp32_;
		_tmp33_ = rest_xml_node_get_attr (photoset_node, "id");
		rest_proxy_call_add_params (photos_call, "method", "flickr.photosets.getPhotos", "photoset_id", _tmp33_, "media", "photos", "extras", "original_format", NULL);
		_tmp34_ = tracker_miner_flickr_run_call (self, photos_call, &_inner_error_);
		_tmp35_ = _tmp34_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_tmp36_ = _tmp35_;
		_rest_xml_node_unref0 (photos_node);
		photos_node = _tmp36_;
		tracker_miner_flickr_insert_photos (self, photos_node);
		goto __finally3;
		__catch3_g_error:
		{
			GError * err;
			gchar* _tmp37_ = NULL;
			gchar* error_message;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp37_ = g_strdup_printf ("Could not list photos for photoset %s: %s", photoset_url, err->message);
			error_message = _tmp37_;
			g_object_set ((TrackerMiner*) self, "status", error_message, NULL);
			g_warning ("tracker-miner-flickr.vala:262: %s", error_message);
			_g_free0 (error_message);
			_g_error_free0 (err);
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (builder);
			_g_object_unref0 (photos_call);
			_g_free0 (delete_query);
			_g_free0 (photoset_urn);
			_g_free0 (photoset_identifier);
			_g_free0 (photoset_url);
			_rest_xml_node_unref0 (photos_node);
			_rest_xml_node_unref0 (title_node);
			_rest_xml_node_unref0 (photoset_node);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp38_ = _rest_xml_node_ref0 (photoset_node->next);
		_tmp39_ = _tmp38_;
		_rest_xml_node_unref0 (photoset_node);
		photoset_node = _tmp39_;
		indexed_photosets++;
		g_object_set ((TrackerMiner*) self, "progress", ((gdouble) indexed_photosets) / n_photosets, NULL);
	}
	_g_object_unref0 (builder);
	_g_object_unref0 (photos_call);
	_g_free0 (delete_query);
	_g_free0 (photoset_urn);
	_g_free0 (photoset_identifier);
	_g_free0 (photoset_url);
	_rest_xml_node_unref0 (photos_node);
	_rest_xml_node_unref0 (title_node);
	_rest_xml_node_unref0 (photoset_node);
}


static void tracker_miner_flickr_insert_photos (TrackerMinerFlickr* self, RestXmlNode* root_node) {
	RestXmlNode* photoset_node = NULL;
	gchar* photoset_url = NULL;
	RestXmlNode* photo_node = NULL;
	gchar* photo_url = NULL;
	gchar* photo_urn = NULL;
	gboolean resource_created = FALSE;
	TrackerSparqlBuilder* builder = NULL;
	RestXmlNode* _tmp0_ = NULL;
	RestXmlNode* _tmp1_;
	RestXmlNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	RestXmlNode* _tmp8_ = NULL;
	RestXmlNode* _tmp9_;
	RestXmlNode* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_node != NULL);
	_tmp0_ = rest_xml_node_find (root_node, "photoset");
	_tmp1_ = _rest_xml_node_ref0 (_tmp0_);
	_tmp2_ = _tmp1_;
	_rest_xml_node_unref0 (photoset_node);
	photoset_node = _tmp2_;
	if (photoset_node == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = rest_xml_node_get_attr (photoset_node, "id");
		_tmp3_ = _tmp4_ == NULL;
	}
	if (_tmp3_) {
		g_warning ("tracker-miner-flickr.vala:282: Malformed response for flickr.photosets" \
".getPhotos");
		_g_object_unref0 (builder);
		_g_free0 (photo_urn);
		_g_free0 (photo_url);
		_rest_xml_node_unref0 (photo_node);
		_g_free0 (photoset_url);
		_rest_xml_node_unref0 (photoset_node);
		return;
	}
	_tmp5_ = rest_xml_node_get_attr (photoset_node, "id");
	_tmp6_ = g_strdup_printf (TRACKER_MINER_FLICKR_FLICKR_PHOTOSET_URL, self->priv->user_id, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (photoset_url);
	photoset_url = _tmp7_;
	g_message ("tracker-miner-flickr.vala:287: Indexing photoset %s", photoset_url);
	_tmp8_ = rest_xml_node_find (root_node, "photo");
	_tmp9_ = _rest_xml_node_ref0 (_tmp8_);
	_tmp10_ = _tmp9_;
	_rest_xml_node_unref0 (photo_node);
	photo_node = _tmp10_;
	while (TRUE) {
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar** _tmp20_ = NULL;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gboolean _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		TrackerSparqlBuilder* _tmp30_ = NULL;
		TrackerSparqlBuilder* _tmp31_;
		TrackerSparqlConnection* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		RestXmlNode* _tmp34_;
		RestXmlNode* _tmp35_;
		if (!(photo_node != NULL)) {
			break;
		}
		_tmp11_ = rest_xml_node_get_attr (photo_node, "farm");
		_tmp12_ = rest_xml_node_get_attr (photo_node, "server");
		_tmp13_ = rest_xml_node_get_attr (photo_node, "id");
		_tmp14_ = rest_xml_node_get_attr (photo_node, "secret");
		_tmp15_ = g_strdup_printf (TRACKER_MINER_FLICKR_FLICKR_PHOTO_URL, _tmp11_, _tmp12_, _tmp13_, _tmp14_);
		_tmp16_ = _tmp15_;
		_g_free0 (photo_url);
		photo_url = _tmp16_;
		_tmp17_ = g_strdup ("nmm:Photo");
		_tmp18_ = g_strdup ("nfo:RemoteDataObject");
		_tmp19_ = g_strdup ("nfo:MediaFileListEntry");
		_tmp20_ = g_new0 (gchar*, 3 + 1);
		_tmp20_[0] = _tmp17_;
		_tmp20_[1] = _tmp18_;
		_tmp20_[2] = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp21__length1 = 3;
		_tmp22_ = rest_xml_node_get_attr (photo_node, "id");
		_tmp23_ = g_strdup_printf ("flickr:photo:%s", _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp26_ = tracker_miner_flickr_get_resource (self, photo_url, _tmp21_, 3, _tmp24_, &_tmp25_, &_inner_error_);
		resource_created = _tmp25_;
		_tmp28_ = (_tmp27_ = _tmp26_, _g_free0 (_tmp24_), _tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL), _tmp27_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_tmp29_ = _tmp28_;
		_g_free0 (photo_urn);
		photo_urn = _tmp29_;
		_tmp30_ = tracker_sparql_builder_new_update ();
		_tmp31_ = _tmp30_;
		_g_object_unref0 (builder);
		builder = _tmp31_;
		if (resource_created) {
			tracker_sparql_builder_insert_open (builder, photo_url);
			tracker_sparql_builder_subject_iri (builder, photo_urn);
			tracker_sparql_builder_predicate (builder, "nie:dataSource");
			tracker_sparql_builder_object_iri (builder, TRACKER_MINER_FLICKR_DATASOURCE_URN);
			tracker_sparql_builder_predicate (builder, "nie:url");
			tracker_sparql_builder_object_string (builder, photo_url);
			tracker_sparql_builder_insert_close (builder);
		}
		tracker_miner_flickr_insert_photo_info (self, photo_node, builder, photo_url, photo_urn);
		tracker_miner_flickr_insert_exif_data (self, photo_node, builder, photo_url, photo_urn);
		_tmp32_ = tracker_miner_get_connection ((TrackerMiner*) self);
		_tmp33_ = tracker_sparql_builder_get_result (builder);
		tracker_sparql_connection_update (_tmp32_, _tmp33_, G_PRIORITY_DEFAULT, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("tracker-miner-flickr.vala:319: Couldn't insert photo %s: %s", photo_url, err->message);
			_g_error_free0 (err);
		}
		__finally4:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (builder);
			_g_free0 (photo_urn);
			_g_free0 (photo_url);
			_rest_xml_node_unref0 (photo_node);
			_g_free0 (photoset_url);
			_rest_xml_node_unref0 (photoset_node);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp34_ = _rest_xml_node_ref0 (photo_node->next);
		_tmp35_ = _tmp34_;
		_rest_xml_node_unref0 (photo_node);
		photo_node = _tmp35_;
	}
	_g_object_unref0 (builder);
	_g_free0 (photo_urn);
	_g_free0 (photo_url);
	_rest_xml_node_unref0 (photo_node);
	_g_free0 (photoset_url);
	_rest_xml_node_unref0 (photoset_node);
}


static void tracker_miner_flickr_insert_photo_info (TrackerMinerFlickr* self, RestXmlNode* photo_node, TrackerSparqlBuilder* builder, const gchar* graph, const gchar* urn) {
	RestProxyCall* _tmp0_ = NULL;
	RestProxyCall* info_call;
	RestXmlNode* root_node = NULL;
	RestXmlNode* title_node = NULL;
	RestXmlNode* description_node = NULL;
	RestXmlNode* tag_node = NULL;
	const gchar* _tmp1_ = NULL;
	RestXmlNode* _tmp2_ = NULL;
	RestXmlNode* _tmp3_;
	RestXmlNode* _tmp4_;
	RestXmlNode* _tmp7_ = NULL;
	RestXmlNode* _tmp8_;
	RestXmlNode* _tmp9_;
	gboolean _tmp10_ = FALSE;
	RestXmlNode* _tmp11_ = NULL;
	RestXmlNode* _tmp12_;
	RestXmlNode* _tmp13_;
	gboolean _tmp14_ = FALSE;
	RestXmlNode* _tmp15_ = NULL;
	RestXmlNode* _tmp16_ = NULL;
	RestXmlNode* _tmp17_;
	RestXmlNode* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo_node != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (graph != NULL);
	g_return_if_fail (urn != NULL);
	_tmp0_ = rest_proxy_new_call (self->priv->rest);
	info_call = _tmp0_;
	_tmp1_ = rest_xml_node_get_attr (photo_node, "id");
	rest_proxy_call_add_params (info_call, "method", "flickr.photos.getInfo", "photo_id", _tmp1_, NULL);
	_tmp2_ = tracker_miner_flickr_run_call (self, info_call, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	_tmp4_ = _tmp3_;
	_rest_xml_node_unref0 (root_node);
	root_node = _tmp4_;
	goto __finally5;
	__catch5_g_error:
	{
		GError * call_error;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* error_message;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = rest_xml_node_get_attr (photo_node, "id");
		_tmp6_ = g_strdup_printf ("Couldn't get info for photo %s: %s", _tmp5_, call_error->message);
		error_message = _tmp6_;
		g_object_set ((TrackerMiner*) self, "status", error_message, NULL);
		g_warning ("tracker-miner-flickr.vala:341: %s", error_message);
		_g_free0 (error_message);
		_g_error_free0 (call_error);
		_rest_xml_node_unref0 (tag_node);
		_rest_xml_node_unref0 (description_node);
		_rest_xml_node_unref0 (title_node);
		_rest_xml_node_unref0 (root_node);
		_g_object_unref0 (info_call);
		return;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_rest_xml_node_unref0 (tag_node);
		_rest_xml_node_unref0 (description_node);
		_rest_xml_node_unref0 (title_node);
		_rest_xml_node_unref0 (root_node);
		_g_object_unref0 (info_call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = rest_xml_node_find (root_node, "title");
	_tmp8_ = _rest_xml_node_ref0 (_tmp7_);
	_tmp9_ = _tmp8_;
	_rest_xml_node_unref0 (title_node);
	title_node = _tmp9_;
	if (title_node != NULL) {
		_tmp10_ = title_node->content != NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		tracker_miner_flickr_update_triple_string (self, builder, graph, urn, "nie:title", title_node->content);
	}
	_tmp11_ = rest_xml_node_find (root_node, "description");
	_tmp12_ = _rest_xml_node_ref0 (_tmp11_);
	_tmp13_ = _tmp12_;
	_rest_xml_node_unref0 (description_node);
	description_node = _tmp13_;
	if (description_node != NULL) {
		_tmp14_ = description_node->content != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		tracker_miner_flickr_update_triple_string (self, builder, graph, urn, "nie:comment", description_node->content);
	}
	_tmp15_ = rest_xml_node_find (root_node, "tags");
	_tmp16_ = rest_xml_node_find (_tmp15_, "tag");
	_tmp17_ = _rest_xml_node_ref0 (_tmp16_);
	_tmp18_ = _tmp17_;
	_rest_xml_node_unref0 (tag_node);
	tag_node = _tmp18_;
	if (tag_node != NULL) {
		tracker_sparql_builder_insert_open (builder, graph);
		tracker_sparql_builder_subject_iri (builder, urn);
		while (TRUE) {
			const gchar* _tmp19_ = NULL;
			RestXmlNode* _tmp20_;
			RestXmlNode* _tmp21_;
			if (!(tag_node != NULL)) {
				break;
			}
			tracker_sparql_builder_predicate (builder, "nao:hasTag");
			tracker_sparql_builder_object_blank_open (builder);
			tracker_sparql_builder_predicate (builder, "a");
			tracker_sparql_builder_object (builder, "nao:Tag");
			tracker_sparql_builder_predicate (builder, "nao:prefLabel");
			_tmp19_ = rest_xml_node_get_attr (tag_node, "raw");
			tracker_sparql_builder_object_string (builder, _tmp19_);
			tracker_sparql_builder_object_blank_close (builder);
			_tmp20_ = _rest_xml_node_ref0 (tag_node->next);
			_tmp21_ = _tmp20_;
			_rest_xml_node_unref0 (tag_node);
			tag_node = _tmp21_;
		}
		tracker_sparql_builder_insert_close (builder);
	}
	_rest_xml_node_unref0 (tag_node);
	_rest_xml_node_unref0 (description_node);
	_rest_xml_node_unref0 (title_node);
	_rest_xml_node_unref0 (root_node);
	_g_object_unref0 (info_call);
}


static void tracker_miner_flickr_insert_exif_data (TrackerMinerFlickr* self, RestXmlNode* photo_node, TrackerSparqlBuilder* builder, const gchar* graph, const gchar* urn) {
	RestProxyCall* _tmp0_ = NULL;
	RestProxyCall* exif_call;
	RestXmlNode* root_node = NULL;
	RestXmlNode* exif_node = NULL;
	gchar* exif_value = NULL;
	gchar* make;
	gchar* model;
	const gchar* _tmp1_ = NULL;
	RestXmlNode* _tmp2_ = NULL;
	RestXmlNode* _tmp3_;
	RestXmlNode* _tmp4_;
	RestXmlNode* _tmp7_ = NULL;
	RestXmlNode* _tmp8_;
	RestXmlNode* _tmp9_;
	gboolean _tmp28_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo_node != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (graph != NULL);
	g_return_if_fail (urn != NULL);
	_tmp0_ = rest_proxy_new_call (self->priv->rest);
	exif_call = _tmp0_;
	make = NULL;
	model = NULL;
	_tmp1_ = rest_xml_node_get_attr (photo_node, "id");
	rest_proxy_call_add_params (exif_call, "method", "flickr.photos.getExif", "photo_id", _tmp1_, NULL);
	_tmp2_ = tracker_miner_flickr_run_call (self, exif_call, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch6_g_error;
	}
	_tmp4_ = _tmp3_;
	_rest_xml_node_unref0 (root_node);
	root_node = _tmp4_;
	goto __finally6;
	__catch6_g_error:
	{
		GError * call_error;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* error_message;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = rest_xml_node_get_attr (photo_node, "id");
		_tmp6_ = g_strdup_printf ("Couldn't get EXIF data for photo %s: %s", _tmp5_, call_error->message);
		error_message = _tmp6_;
		g_object_set ((TrackerMiner*) self, "status", error_message, NULL);
		g_warning ("tracker-miner-flickr.vala:393: %s", error_message);
		_g_free0 (error_message);
		_g_error_free0 (call_error);
		_g_free0 (model);
		_g_free0 (make);
		_g_free0 (exif_value);
		_rest_xml_node_unref0 (exif_node);
		_rest_xml_node_unref0 (root_node);
		_g_object_unref0 (exif_call);
		return;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_free0 (model);
		_g_free0 (make);
		_g_free0 (exif_value);
		_rest_xml_node_unref0 (exif_node);
		_rest_xml_node_unref0 (root_node);
		_g_object_unref0 (exif_call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = rest_xml_node_find (root_node, "exif");
	_tmp8_ = _rest_xml_node_ref0 (_tmp7_);
	_tmp9_ = _tmp8_;
	_rest_xml_node_unref0 (exif_node);
	exif_node = _tmp9_;
	while (TRUE) {
		RestXmlNode* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_;
		RestXmlNode* _tmp26_;
		RestXmlNode* _tmp27_;
		if (!(exif_node != NULL)) {
			break;
		}
		_tmp10_ = rest_xml_node_find (exif_node, "raw");
		_tmp11_ = g_strdup (_tmp10_->content);
		_tmp12_ = _tmp11_;
		_g_free0 (exif_value);
		exif_value = _tmp12_;
		_tmp13_ = rest_xml_node_get_attr (exif_node, "tag");
		_tmp14_ = atoi (_tmp13_);
		switch (_tmp14_) {
			case TRACKER_MINER_FLICKR_EXIF_TAG_CAMERA_MAKE:
			{
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = g_strdup (exif_value);
				_tmp16_ = _tmp15_;
				_g_free0 (make);
				make = _tmp16_;
				break;
			}
			case TRACKER_MINER_FLICKR_EXIF_TAG_CAMERA_MODEL:
			{
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp17_ = g_strdup (exif_value);
				_tmp18_ = _tmp17_;
				_g_free0 (model);
				model = _tmp18_;
				break;
			}
			case TRACKER_MINER_FLICKR_EXIF_TAG_FLASH:
			{
				const gchar* _tmp19_ = NULL;
				gint _tmp20_;
				_tmp20_ = atoi (exif_value);
				if ((_tmp20_ % 2) == 1) {
					_tmp19_ = "nmm:flash-on";
				} else {
					_tmp19_ = "nmm:flash-off";
				}
				tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:flash", _tmp19_);
				break;
			}
			case TRACKER_MINER_FLICKR_EXIF_TAG_FNUMBER:
			{
				gdouble _tmp21_;
				_tmp21_ = tracker_miner_flickr_ratio_to_double (self, exif_value);
				tracker_miner_flickr_update_triple_double (self, builder, graph, urn, "nmm:fnumber", _tmp21_);
				break;
			}
			case TRACKER_MINER_FLICKR_EXIF_TAG_FOCAL_LENGTH:
			{
				gdouble _tmp22_;
				_tmp22_ = tracker_miner_flickr_ratio_to_double (self, exif_value);
				tracker_miner_flickr_update_triple_double (self, builder, graph, urn, "nmm:focalLength", _tmp22_);
				break;
			}
			case TRACKER_MINER_FLICKR_EXIF_TAG_ISO_SPEED:
			{
				gint _tmp23_;
				_tmp23_ = atoi (exif_value);
				tracker_miner_flickr_update_triple_int64 (self, builder, graph, urn, "nmm:isoSpeed", (gint64) _tmp23_);
				break;
			}
			case TRACKER_MINER_FLICKR_EXIF_TAG_METERING_MODE:
			{
				gint _tmp24_;
				_tmp24_ = atoi (exif_value);
				switch (_tmp24_) {
					case TRACKER_MINER_FLICKR_EXIF_METERING_MODE_AVERAGE:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:meteringMode", "nmm:meteringMode-average");
						break;
					}
					case TRACKER_MINER_FLICKR_EXIF_METERING_MODE_CENTER_WEIGHTED_AVERAGE:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:meteringMode", "nmm:meteringMode-center-weighted-average");
						break;
					}
					case TRACKER_MINER_FLICKR_EXIF_METERING_MODE_SPOT:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:meteringMode", "nmm:meteringMode-spot");
						break;
					}
					case TRACKER_MINER_FLICKR_EXIF_METERING_MODE_MULTISPOT:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:meteringMode", "nmm:meteringMode-multispot");
						break;
					}
					case TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PATTERN:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:meteringMode", "nmm:meteringMode-pattern");
						break;
					}
					case TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PARTIAL:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:meteringMode", "nmm:meteringMode-partial");
						break;
					}
					default:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:meteringMode", "nmm:meteringMode-other");
						break;
					}
				}
				break;
			}
			case TRACKER_MINER_FLICKR_EXIF_TAG_WHITE_BALANCE:
			{
				gint _tmp25_;
				_tmp25_ = atoi (exif_value);
				switch (_tmp25_) {
					case TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_AUTO:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:whiteBalance", "nmm:whiteBalance-auto");
						break;
					}
					case TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_MANUAL:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:whiteBalance", "nmm:whiteBalance-manual");
						break;
					}
					default:
					break;
				}
				break;
			}
			default:
			{
				break;
			}
		}
		_tmp26_ = _rest_xml_node_ref0 (exif_node->next);
		_tmp27_ = _tmp26_;
		_rest_xml_node_unref0 (exif_node);
		exif_node = _tmp27_;
	}
	if (make != NULL) {
		_tmp28_ = TRUE;
	} else {
		_tmp28_ = model != NULL;
	}
	if (_tmp28_) {
		gchar* equip_uri = NULL;
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
		if (make != NULL) {
			_tmp29_ = make;
		} else {
			_tmp29_ = "";
		}
		if (model != NULL) {
			_tmp30_ = model;
		} else {
			_tmp30_ = "";
		}
		_tmp31_ = tracker_sparql_escape_uri_printf ("urn:equipment:%s:%s:", _tmp29_, _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		_g_free0 (equip_uri);
		equip_uri = _tmp32_;
		tracker_sparql_builder_insert_open (builder, graph);
		tracker_sparql_builder_subject_iri (builder, equip_uri);
		tracker_sparql_builder_predicate (builder, "a");
		tracker_sparql_builder_object (builder, "nfo:Equipment");
		if (make != NULL) {
			tracker_sparql_builder_predicate (builder, "nfo:manufacturer");
			tracker_sparql_builder_object_unvalidated (builder, make);
		}
		if (model != NULL) {
			tracker_sparql_builder_predicate (builder, "nfo:model");
			tracker_sparql_builder_object_unvalidated (builder, model);
		}
		tracker_sparql_builder_insert_close (builder);
		tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nfo:equipment", equip_uri);
		_g_free0 (equip_uri);
	}
	_g_free0 (model);
	_g_free0 (make);
	_g_free0 (exif_value);
	_rest_xml_node_unref0 (exif_node);
	_rest_xml_node_unref0 (root_node);
	_g_object_unref0 (exif_call);
}


static void tracker_miner_flickr_add_tags (TrackerMinerFlickr* self, const gchar* photo_id, gchar** tags, int tags_length1) {
	RestProxyCall* tag_call = NULL;
	RestProxyCall* _tmp0_ = NULL;
	RestProxyCall* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	RestXmlNode* _tmp4_ = NULL;
	RestXmlNode* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo_id != NULL);
	_tmp0_ = rest_proxy_new_call (self->priv->rest);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (tag_call);
	tag_call = _tmp1_;
	_tmp2_ = g_strjoinv (",", tags);
	_tmp3_ = _tmp2_;
	rest_proxy_call_add_params (tag_call, "method", "flickr.photos.addTags", "photo_id", photo_id, "tags", _tmp3_, NULL);
	_g_free0 (_tmp3_);
	_tmp4_ = tracker_miner_flickr_run_call (self, tag_call, &_inner_error_);
	_tmp5_ = _tmp4_;
	_rest_xml_node_unref0 (_tmp5_);
	if (_inner_error_ != NULL) {
		goto __catch7_g_error;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * call_error;
		gchar* _tmp6_ = NULL;
		gchar* error_message;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = g_strdup_printf ("Couldn't add tags for photo %s: %s", photo_id, call_error->message);
		error_message = _tmp6_;
		g_object_set ((TrackerMiner*) self, "status", error_message, NULL);
		g_warning ("tracker-miner-flickr.vala:503: %s", error_message);
		_g_free0 (error_message);
		_g_error_free0 (call_error);
		_g_object_unref0 (tag_call);
		return;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (tag_call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (tag_call);
}


static void tracker_miner_flickr_remove_tag (TrackerMinerFlickr* self, const gchar* tag_id) {
	RestProxyCall* tag_call = NULL;
	RestProxyCall* _tmp0_ = NULL;
	RestProxyCall* _tmp1_;
	RestXmlNode* _tmp2_ = NULL;
	RestXmlNode* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag_id != NULL);
	_tmp0_ = rest_proxy_new_call (self->priv->rest);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (tag_call);
	tag_call = _tmp1_;
	rest_proxy_call_add_params (tag_call, "method", "flickr.photos.removeTag", "tag_id", tag_id, NULL);
	_tmp2_ = tracker_miner_flickr_run_call (self, tag_call, &_inner_error_);
	_tmp3_ = _tmp2_;
	_rest_xml_node_unref0 (_tmp3_);
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * call_error;
		gchar* _tmp4_ = NULL;
		gchar* error_message;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = g_strdup_printf ("Couldn't remove tag: %s", call_error->message);
		error_message = _tmp4_;
		g_object_set ((TrackerMiner*) self, "status", error_message, NULL);
		g_warning ("tracker-miner-flickr.vala:520: %s", error_message);
		_g_free0 (error_message);
		_g_error_free0 (call_error);
		_g_object_unref0 (tag_call);
		return;
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (tag_call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (tag_call);
}


static void tracker_miner_flickr_writeback_photo_data_free (gpointer _data) {
	TrackerMinerFlickrWritebackPhotoData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (TrackerMinerFlickrWritebackPhotoData, data);
}


static void tracker_miner_flickr_writeback_photo (TrackerMinerFlickr* self, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerMinerFlickrWritebackPhotoData* _data_;
	_data_ = g_slice_new0 (TrackerMinerFlickrWritebackPhotoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_miner_flickr_writeback_photo);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_miner_flickr_writeback_photo_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->id = id;
	tracker_miner_flickr_writeback_photo_co (_data_);
}


static void tracker_miner_flickr_writeback_photo_finish (TrackerMinerFlickr* self, GAsyncResult* _res_) {
	TrackerMinerFlickrWritebackPhotoData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void tracker_miner_flickr_writeback_photo_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerMinerFlickrWritebackPhotoData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_miner_flickr_writeback_photo_co (data);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean tracker_miner_flickr_writeback_photo_co (TrackerMinerFlickrWritebackPhotoData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_new0 (gchar*, 0 + 1);
	data->local_tags = data->_tmp0_;
	data->local_tags_length1 = 0;
	data->_local_tags_size_ = 0;
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_free0_);
	data->flickr_tags = data->_tmp1_;
	data->_tmp2_ = NULL;
	data->_tmp2_ = g_new0 (gchar*, 0 + 1);
	data->tags_to_add = data->_tmp2_;
	data->tags_to_add_length1 = 0;
	data->_tags_to_add_size_ = 0;
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_new0 (gchar*, 0 + 1);
	data->tags_to_remove = data->_tmp3_;
	data->tags_to_remove_length1 = 0;
	data->_tags_to_remove_size_ = 0;
	data->_tmp4_ = NULL;
	data->_tmp4_ = tracker_miner_get_connection ((TrackerMiner*) data->self);
	data->_tmp5_ = _g_object_ref0 (data->_tmp4_);
	data->c = data->_tmp5_;
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_strdup_printf ("select tracker:uri (%d) {}", data->id);
	data->_tmp7_ = data->_tmp6_;
	data->_state_ = 1;
	tracker_sparql_connection_query_async (data->c, data->_tmp7_, NULL, tracker_miner_flickr_writeback_photo_ready, data);
	return FALSE;
	_state_1:
	data->_tmp8_ = NULL;
	data->_tmp8_ = tracker_sparql_connection_query_finish (data->c, data->_res_, &data->_inner_error_);
	data->_tmp10_ = (data->_tmp9_ = data->_tmp8_, _g_free0 (data->_tmp7_), data->_tmp9_);
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->c);
		goto __catch9_g_error;
	}
	data->_tmp11_ = data->_tmp10_;
	_g_object_unref0 (data->cursor);
	data->cursor = data->_tmp11_;
	data->_tmp12_ = tracker_sparql_cursor_next (data->cursor, NULL, &data->_inner_error_);
	data->_tmp13_ = data->_tmp12_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->c);
		goto __catch9_g_error;
	}
	g_return_if_fail (data->_tmp13_ != TRUE);
	data->_tmp14_ = NULL;
	data->_tmp14_ = tracker_sparql_cursor_get_string (data->cursor, 0, NULL);
	data->_tmp15_ = g_strdup (data->_tmp14_);
	data->_tmp16_ = data->_tmp15_;
	_g_free0 (data->photo_urn);
	data->photo_urn = data->_tmp16_;
	data->_tmp17_ = NULL;
	data->_tmp17_ = g_strdup_printf ("select ?photo_id ?tag where { <%s> nie:dataSource <%s> ;" "nao:identifier ?photo_id ;" "nao:hasTag ?t ." "?t nao:prefLabel ?tag }", data->photo_urn, TRACKER_MINER_FLICKR_DATASOURCE_URN);
	data->s = data->_tmp17_;
	data->_state_ = 2;
	tracker_sparql_connection_query_async (data->c, data->s, NULL, tracker_miner_flickr_writeback_photo_ready, data);
	return FALSE;
	_state_2:
	data->_tmp18_ = NULL;
	data->_tmp18_ = tracker_sparql_connection_query_finish (data->c, data->_res_, &data->_inner_error_);
	data->_tmp19_ = data->_tmp18_;
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->s);
		_g_object_unref0 (data->c);
		goto __catch9_g_error;
	}
	data->_tmp20_ = data->_tmp19_;
	_g_object_unref0 (data->cursor);
	data->cursor = data->_tmp20_;
	_g_free0 (data->s);
	_g_object_unref0 (data->c);
	goto __finally9;
	__catch9_g_error:
	{
		data->query_error = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("tracker-miner-flickr.vala:550: Tracker error when doing writeback for " \
"photo %d: %s", data->id, data->query_error->message);
		_g_error_free0 (data->query_error);
		_rest_xml_node_unref0 (data->tag_node);
		_rest_xml_node_unref0 (data->root_node);
		_g_object_unref0 (data->tag_call);
		data->tags_to_remove = (_vala_array_free (data->tags_to_remove, data->tags_to_remove_length1, (GDestroyNotify) g_free), NULL);
		data->tags_to_add = (_vala_array_free (data->tags_to_add, data->tags_to_add_length1, (GDestroyNotify) g_free), NULL);
		_g_hash_table_unref0 (data->flickr_tags);
		data->local_tags = (_vala_array_free (data->local_tags, data->local_tags_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data->photo_id);
		_g_free0 (data->photo_urn);
		_g_object_unref0 (data->cursor);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally9:
	if (data->_inner_error_ != NULL) {
		_rest_xml_node_unref0 (data->tag_node);
		_rest_xml_node_unref0 (data->root_node);
		_g_object_unref0 (data->tag_call);
		data->tags_to_remove = (_vala_array_free (data->tags_to_remove, data->tags_to_remove_length1, (GDestroyNotify) g_free), NULL);
		data->tags_to_add = (_vala_array_free (data->tags_to_add, data->tags_to_add_length1, (GDestroyNotify) g_free), NULL);
		_g_hash_table_unref0 (data->flickr_tags);
		data->local_tags = (_vala_array_free (data->local_tags, data->local_tags_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data->photo_id);
		_g_free0 (data->photo_urn);
		_g_object_unref0 (data->cursor);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp21_ = NULL;
	_g_free0 (data->photo_id);
	data->photo_id = data->_tmp21_;
	while (TRUE) {
		data->_tmp22_ = tracker_sparql_cursor_next (data->cursor, NULL, &data->_inner_error_);
		data->_tmp23_ = data->_tmp22_;
		if (data->_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		if (!data->_tmp23_) {
			break;
		}
		if (data->photo_id == NULL) {
			data->_tmp24_ = NULL;
			data->_tmp24_ = tracker_sparql_cursor_get_string (data->cursor, 0, NULL);
			data->_tmp25_ = g_strdup (data->_tmp24_);
			data->_tmp26_ = data->_tmp25_;
			_g_free0 (data->photo_id);
			data->photo_id = data->_tmp26_;
		}
		data->_tmp27_ = NULL;
		data->_tmp27_ = tracker_sparql_cursor_get_string (data->cursor, 1, NULL);
		data->_tmp28_ = g_strdup (data->_tmp27_);
		_vala_array_add1 (&data->local_tags, &data->local_tags_length1, &data->_local_tags_size_, data->_tmp28_);
	}
	data->_tmp29_ = NULL;
	data->_tmp29_ = tracker_sparql_cursor_get_string (data->cursor, 0, NULL);
	data->_tmp30_ = g_strdup (data->_tmp29_);
	data->_tmp31_ = data->_tmp30_;
	_g_free0 (data->photo_id);
	data->photo_id = data->_tmp31_;
	goto __finally10;
	__catch10_g_error:
	{
		data->cursor_error = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("tracker-miner-flickr.vala:565: Tracker error when getting tags and pho" \
"to ids: %s", data->cursor_error->message);
		_g_error_free0 (data->cursor_error);
	}
	__finally10:
	if (data->_inner_error_ != NULL) {
		_rest_xml_node_unref0 (data->tag_node);
		_rest_xml_node_unref0 (data->root_node);
		_g_object_unref0 (data->tag_call);
		data->tags_to_remove = (_vala_array_free (data->tags_to_remove, data->tags_to_remove_length1, (GDestroyNotify) g_free), NULL);
		data->tags_to_add = (_vala_array_free (data->tags_to_add, data->tags_to_add_length1, (GDestroyNotify) g_free), NULL);
		_g_hash_table_unref0 (data->flickr_tags);
		data->local_tags = (_vala_array_free (data->local_tags, data->local_tags_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data->photo_id);
		_g_free0 (data->photo_urn);
		_g_object_unref0 (data->cursor);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp32_ = NULL;
	data->_tmp32_ = rest_proxy_new_call (data->self->priv->rest);
	data->_tmp33_ = data->_tmp32_;
	_g_object_unref0 (data->tag_call);
	data->tag_call = data->_tmp33_;
	rest_proxy_call_add_params (data->tag_call, "method", "flickr.tags.getListPhoto", "photo_id", data->photo_id, NULL);
	data->_tmp34_ = NULL;
	data->_tmp34_ = tracker_miner_flickr_run_call (data->self, data->tag_call, &data->_inner_error_);
	data->_tmp35_ = data->_tmp34_;
	if (data->_inner_error_ != NULL) {
		goto __catch11_g_error;
	}
	data->_tmp36_ = data->_tmp35_;
	_rest_xml_node_unref0 (data->root_node);
	data->root_node = data->_tmp36_;
	goto __finally11;
	__catch11_g_error:
	{
		data->get_tags_error = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp37_ = NULL;
		data->_tmp37_ = g_strdup_printf ("Couldn't get tags for photo %s: %s", data->photo_urn, data->get_tags_error->message);
		data->error_message = data->_tmp37_;
		g_object_set ((TrackerMiner*) data->self, "status", data->error_message, NULL);
		g_warning ("tracker-miner-flickr.vala:576: %s", data->error_message);
		_g_free0 (data->error_message);
		_g_error_free0 (data->get_tags_error);
		_rest_xml_node_unref0 (data->tag_node);
		_rest_xml_node_unref0 (data->root_node);
		_g_object_unref0 (data->tag_call);
		data->tags_to_remove = (_vala_array_free (data->tags_to_remove, data->tags_to_remove_length1, (GDestroyNotify) g_free), NULL);
		data->tags_to_add = (_vala_array_free (data->tags_to_add, data->tags_to_add_length1, (GDestroyNotify) g_free), NULL);
		_g_hash_table_unref0 (data->flickr_tags);
		data->local_tags = (_vala_array_free (data->local_tags, data->local_tags_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data->photo_id);
		_g_free0 (data->photo_urn);
		_g_object_unref0 (data->cursor);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally11:
	if (data->_inner_error_ != NULL) {
		_rest_xml_node_unref0 (data->tag_node);
		_rest_xml_node_unref0 (data->root_node);
		_g_object_unref0 (data->tag_call);
		data->tags_to_remove = (_vala_array_free (data->tags_to_remove, data->tags_to_remove_length1, (GDestroyNotify) g_free), NULL);
		data->tags_to_add = (_vala_array_free (data->tags_to_add, data->tags_to_add_length1, (GDestroyNotify) g_free), NULL);
		_g_hash_table_unref0 (data->flickr_tags);
		data->local_tags = (_vala_array_free (data->local_tags, data->local_tags_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data->photo_id);
		_g_free0 (data->photo_urn);
		_g_object_unref0 (data->cursor);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp38_ = NULL;
	data->_tmp38_ = rest_xml_node_find (data->root_node, "tags");
	data->_tmp39_ = NULL;
	data->_tmp39_ = rest_xml_node_find (data->_tmp38_, "tag");
	data->_tmp40_ = _rest_xml_node_ref0 (data->_tmp39_);
	data->_tmp41_ = data->_tmp40_;
	_rest_xml_node_unref0 (data->tag_node);
	data->tag_node = data->_tmp41_;
	while (TRUE) {
		if (!(data->tag_node != NULL)) {
			break;
		}
		data->_tmp42_ = NULL;
		data->_tmp42_ = rest_xml_node_get_attr (data->tag_node, "raw");
		data->_tmp43_ = g_strdup (data->_tmp42_);
		data->_tmp44_ = NULL;
		data->_tmp44_ = rest_xml_node_get_attr (data->tag_node, "id");
		data->_tmp45_ = g_strdup (data->_tmp44_);
		g_hash_table_insert (data->flickr_tags, data->_tmp43_, data->_tmp45_);
		data->_tmp46_ = _rest_xml_node_ref0 (data->tag_node->next);
		data->_tmp47_ = data->_tmp46_;
		_rest_xml_node_unref0 (data->tag_node);
		data->tag_node = data->_tmp47_;
	}
	{
		data->local_tag_collection = data->local_tags;
		data->local_tag_collection_length1 = data->local_tags_length1;
		for (data->local_tag_it = 0; data->local_tag_it < data->local_tags_length1; data->local_tag_it = data->local_tag_it + 1) {
			data->_tmp48_ = g_strdup (data->local_tag_collection[data->local_tag_it]);
			data->local_tag = data->_tmp48_;
			{
				data->_tmp49_ = NULL;
				data->_tmp49_ = g_hash_table_lookup (data->flickr_tags, data->local_tag);
				if (((const gchar*) data->_tmp49_) == NULL) {
					data->_tmp50_ = g_strdup (data->local_tag);
					_vala_array_add2 (&data->tags_to_add, &data->tags_to_add_length1, &data->_tags_to_add_size_, data->_tmp50_);
				}
				_g_free0 (data->local_tag);
			}
		}
	}
	data->_tmp51_ = NULL;
	data->_tmp51_ = g_hash_table_get_keys (data->flickr_tags);
	{
		data->flickr_tag_collection = data->_tmp51_;
		for (data->flickr_tag_it = data->flickr_tag_collection; data->flickr_tag_it != NULL; data->flickr_tag_it = data->flickr_tag_it->next) {
			data->flickr_tag = (const gchar*) data->flickr_tag_it->data;
			{
				data->_tmp52_ = tracker_miner_flickr_array_search_str (data->self, data->flickr_tag, data->local_tags, data->local_tags_length1);
				if (data->_tmp52_ == (-1)) {
					data->_tmp53_ = NULL;
					data->_tmp53_ = g_hash_table_lookup (data->flickr_tags, data->flickr_tag);
					data->_tmp54_ = g_strdup ((const gchar*) data->_tmp53_);
					_vala_array_add3 (&data->tags_to_remove, &data->tags_to_remove_length1, &data->_tags_to_remove_size_, data->_tmp54_);
				}
			}
		}
		_g_list_free0 (data->flickr_tag_collection);
	}
	tracker_miner_flickr_add_tags (data->self, data->photo_id, data->tags_to_add, data->tags_to_add_length1);
	{
		data->tag_collection = data->tags_to_remove;
		data->tag_collection_length1 = data->tags_to_remove_length1;
		for (data->tag_it = 0; data->tag_it < data->tags_to_remove_length1; data->tag_it = data->tag_it + 1) {
			data->_tmp55_ = g_strdup (data->tag_collection[data->tag_it]);
			data->tag = data->_tmp55_;
			{
				tracker_miner_flickr_remove_tag (data->self, data->tag);
				_g_free0 (data->tag);
			}
		}
	}
	_rest_xml_node_unref0 (data->tag_node);
	_rest_xml_node_unref0 (data->root_node);
	_g_object_unref0 (data->tag_call);
	data->tags_to_remove = (_vala_array_free (data->tags_to_remove, data->tags_to_remove_length1, (GDestroyNotify) g_free), NULL);
	data->tags_to_add = (_vala_array_free (data->tags_to_add, data->tags_to_add_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (data->flickr_tags);
	data->local_tags = (_vala_array_free (data->local_tags, data->local_tags_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data->photo_id);
	_g_free0 (data->photo_urn);
	_g_object_unref0 (data->cursor);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gdouble tracker_miner_flickr_ratio_to_double (TrackerMinerFlickr* self, const gchar* ratio) {
	gdouble result = 0.0;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (ratio != NULL, 0.0);
	_tmp1_ = _tmp0_ = g_strsplit (ratio, "/", 0);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = _vala_array_length (_tmp0_);
	_tmp2_ = atoi (tokens[1]);
	if (_tmp2_ == 0) {
		g_critical ("tracker-miner-flickr.vala:608: fracToDouble : divide by zero while par" \
"sing ratio '%s'", ratio);
		result = (gdouble) 0;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp3_ = atoi (tokens[0]);
	_tmp4_ = atoi (tokens[1]);
	result = (_tmp3_ * 1.0) / _tmp4_;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gint tracker_miner_flickr_array_search_str (TrackerMinerFlickr* self, const gchar* needle, gchar** haystack, int haystack_length1) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i = i + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < haystack_length1)) {
					break;
				}
				if (g_strcmp0 (haystack[i], needle) == 0) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void tracker_miner_flickr_sign_call (TrackerMinerFlickr* self, RestProxyCall* call) {
	GString* signature = NULL;
	GHashTable* parameters = NULL;
	GList* parameter_names = NULL;
	GString* _tmp0_ = NULL;
	GString* _tmp1_;
	GHashTable* _tmp2_ = NULL;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GList* _tmp5_ = NULL;
	GList* _tmp6_;
	GList* _tmp7_ = NULL;
	GList* _tmp8_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (call != NULL);
	rest_proxy_call_add_param (call, "api_key", TRACKER_MINER_FLICKR_API_KEY);
	if (self->priv->auth_token != NULL) {
		rest_proxy_call_add_param (call, "auth_token", self->priv->auth_token);
	}
	_tmp0_ = g_string_new (TRACKER_MINER_FLICKR_SHARED_SECRET);
	_tmp1_ = _tmp0_;
	_g_string_free0 (signature);
	signature = _tmp1_;
	_tmp2_ = rest_proxy_call_get_params (call);
	_tmp3_ = _g_hash_table_ref0 (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_hash_table_unref0 (parameters);
	parameters = _tmp4_;
	_tmp5_ = g_hash_table_get_keys (parameters);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_list_copy (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_list_free0 (parameter_names);
	parameter_names = _tmp8_;
	_g_list_free0 (_tmp6_);
	parameter_names = g_list_sort (parameter_names, (GCompareFunc) g_strcmp0);
	{
		GList* parameter_collection;
		GList* parameter_it;
		parameter_collection = parameter_names;
		for (parameter_it = parameter_collection; parameter_it != NULL; parameter_it = parameter_it->next) {
			gchar* _tmp9_;
			gchar* parameter;
			_tmp9_ = g_strdup ((const gchar*) parameter_it->data);
			parameter = _tmp9_;
			{
				gconstpointer _tmp10_ = NULL;
				g_string_append (signature, parameter);
				_tmp10_ = g_hash_table_lookup (parameters, parameter);
				g_string_append (signature, (const gchar*) _tmp10_);
				_g_free0 (parameter);
			}
		}
	}
	_tmp11_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, signature->str, (gsize) (-1));
	_tmp12_ = _tmp11_;
	rest_proxy_call_add_param (call, "api_sig", _tmp12_);
	_g_free0 (_tmp12_);
	_g_list_free0 (parameter_names);
	_g_hash_table_unref0 (parameters);
	_g_string_free0 (signature);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static RestXmlNode* tracker_miner_flickr_run_call (TrackerMinerFlickr* self, RestProxyCall* call, GError** error) {
	RestXmlNode* result = NULL;
	RestXmlParser* parser = NULL;
	RestXmlNode* root_node = NULL;
	RestXmlParser* _tmp1_ = NULL;
	RestXmlParser* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gint64 _tmp4_;
	RestXmlNode* _tmp5_ = NULL;
	RestXmlNode* _tmp6_;
	RestXmlNode* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (call != NULL, NULL);
	tracker_miner_flickr_sign_call (self, call);
	rest_proxy_call_run (call, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch12_g_error;
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError * call_error;
		GError* _tmp0_;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = _g_error_copy0 (call_error);
		_inner_error_ = _tmp0_;
		_g_error_free0 (call_error);
		goto __finally12;
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_rest_xml_node_unref0 (root_node);
		_g_object_unref0 (parser);
		return NULL;
	}
	_tmp1_ = rest_xml_parser_new ();
	_tmp2_ = _tmp1_;
	_g_object_unref0 (parser);
	parser = _tmp2_;
	_tmp3_ = rest_proxy_call_get_payload (call);
	_tmp4_ = rest_proxy_call_get_payload_length (call);
	_tmp5_ = rest_xml_parser_parse_from_data (parser, _tmp3_, _tmp4_);
	_tmp6_ = _rest_xml_node_ref0 (_tmp5_);
	_tmp7_ = _tmp6_;
	_rest_xml_node_unref0 (root_node);
	root_node = _tmp7_;
	if (root_node == NULL) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = g_strcmp0 (root_node->name, "rsp") != 0;
	}
	if (_tmp8_) {
		GError* _tmp9_ = NULL;
		_tmp9_ = g_error_new_literal (TRACKER_REST_CALL_ERROR, TRACKER_REST_CALL_ERROR_INVALID_RESPONSE, "Empty payload or root node not \"rsp\"");
		_inner_error_ = _tmp9_;
		g_propagate_error (error, _inner_error_);
		_rest_xml_node_unref0 (root_node);
		_g_object_unref0 (parser);
		return NULL;
	}
	result = root_node;
	_g_object_unref0 (parser);
	return result;
}


static GHashTable* tracker_miner_flickr_real_get_association_data (TrackerMinerWeb* base, GError** error) {
	TrackerMinerFlickr * self;
	GHashTable* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* association_data;
	RestProxyCall* _tmp1_ = NULL;
	RestProxyCall* frob_call;
	RestXmlNode* root_node = NULL;
	RestXmlNode* frob_node = NULL;
	gchar* api_signature = NULL;
	gchar* url = NULL;
	RestXmlNode* _tmp2_ = NULL;
	RestXmlNode* _tmp3_;
	RestXmlNode* _tmp4_;
	RestXmlNode* _tmp6_ = NULL;
	RestXmlNode* _tmp7_;
	RestXmlNode* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GError * _inner_error_ = NULL;
	self = (TrackerMinerFlickr*) base;
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_free0_);
	association_data = _tmp0_;
	_tmp1_ = rest_proxy_new_call (self->priv->rest);
	frob_call = _tmp1_;
	rest_proxy_call_add_param (frob_call, "method", "flickr.auth.getFrob");
	_tmp2_ = tracker_miner_flickr_run_call (self, frob_call, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch13_g_error;
	}
	_tmp4_ = _tmp3_;
	_rest_xml_node_unref0 (root_node);
	root_node = _tmp4_;
	goto __finally13;
	__catch13_g_error:
	{
		GError * call_error;
		GError* _tmp5_ = NULL;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = g_error_new (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_SERVICE, "Error while getting association data: %s", call_error->message);
		_inner_error_ = _tmp5_;
		_g_error_free0 (call_error);
		goto __finally13;
	}
	__finally13:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (url);
			_g_free0 (api_signature);
			_rest_xml_node_unref0 (frob_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (frob_call);
			_g_hash_table_unref0 (association_data);
			return NULL;
		} else {
			_g_free0 (url);
			_g_free0 (api_signature);
			_rest_xml_node_unref0 (frob_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (frob_call);
			_g_hash_table_unref0 (association_data);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = rest_xml_node_find (root_node, "frob");
	_tmp7_ = _rest_xml_node_ref0 (_tmp6_);
	_tmp8_ = _tmp7_;
	_rest_xml_node_unref0 (frob_node);
	frob_node = _tmp8_;
	if (frob_node == NULL) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = frob_node->content == NULL;
	}
	if (_tmp9_) {
		GError* _tmp10_ = NULL;
		_tmp10_ = g_error_new_literal (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_SERVICE, "Malformed XML response while getting frob");
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (url);
			_g_free0 (api_signature);
			_rest_xml_node_unref0 (frob_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (frob_call);
			_g_hash_table_unref0 (association_data);
			return NULL;
		} else {
			_g_free0 (url);
			_g_free0 (api_signature);
			_rest_xml_node_unref0 (frob_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (frob_call);
			_g_hash_table_unref0 (association_data);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = g_strdup (frob_node->content);
	_tmp12_ = _tmp11_;
	_g_free0 (self->priv->frob);
	self->priv->frob = _tmp12_;
	_tmp13_ = g_strconcat (TRACKER_MINER_FLICKR_SHARED_SECRET "api_key" TRACKER_MINER_FLICKR_API_KEY "frob", self->priv->frob, NULL);
	_tmp14_ = g_strconcat (_tmp13_, "permswrite", NULL);
	_tmp15_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp14_, (gsize) (-1));
	_tmp16_ = _tmp15_;
	_g_free0 (api_signature);
	api_signature = _tmp16_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp13_);
	_tmp17_ = g_strconcat (TRACKER_MINER_FLICKR_FLICKR_AUTH_URL "?api_key=" TRACKER_MINER_FLICKR_API_KEY "&perms=write&frob=", self->priv->frob, NULL);
	_tmp18_ = g_strconcat (_tmp17_, "&api_sig=", NULL);
	_tmp19_ = g_strconcat (_tmp18_, api_signature, NULL);
	_g_free0 (url);
	url = _tmp19_;
	_g_free0 (_tmp18_);
	_g_free0 (_tmp17_);
	_tmp20_ = g_strdup ("url");
	_tmp21_ = g_strdup (url);
	g_hash_table_insert (association_data, _tmp20_, _tmp21_);
	result = association_data;
	_g_free0 (url);
	_g_free0 (api_signature);
	_rest_xml_node_unref0 (frob_node);
	_rest_xml_node_unref0 (root_node);
	_g_object_unref0 (frob_call);
	return result;
}


static void tracker_miner_flickr_real_associate (TrackerMinerWeb* base, GHashTable* association_data, GError** error) {
	TrackerMinerFlickr * self;
	TrackerPasswordProvider* _tmp0_ = NULL;
	TrackerPasswordProvider* _tmp1_;
	TrackerPasswordProvider* password_provider;
	RestProxyCall* _tmp2_ = NULL;
	RestProxyCall* token_call;
	RestXmlNode* root_node = NULL;
	RestXmlNode* token_node = NULL;
	RestXmlNode* user_node = NULL;
	RestXmlNode* _tmp3_ = NULL;
	RestXmlNode* _tmp4_;
	RestXmlNode* _tmp5_;
	RestXmlNode* _tmp7_ = NULL;
	RestXmlNode* _tmp8_;
	RestXmlNode* _tmp9_;
	RestXmlNode* _tmp10_ = NULL;
	RestXmlNode* _tmp11_;
	RestXmlNode* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
	self = (TrackerMinerFlickr*) base;
	g_return_if_fail (association_data != NULL);
	_tmp0_ = tracker_password_provider_get ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	password_provider = _tmp1_;
	_tmp2_ = rest_proxy_new_call (self->priv->rest);
	token_call = _tmp2_;
	rest_proxy_call_add_params (token_call, "method", "flickr.auth.getToken", "frob", self->priv->frob, NULL);
	_tmp3_ = tracker_miner_flickr_run_call (self, token_call, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		goto __catch14_g_error;
	}
	_tmp5_ = _tmp4_;
	_rest_xml_node_unref0 (root_node);
	root_node = _tmp5_;
	goto __finally14;
	__catch14_g_error:
	{
		GError * call_error;
		GError* _tmp6_ = NULL;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = g_error_new (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_SERVICE, "Unable to get authentication token: %s", call_error->message);
		_inner_error_ = _tmp6_;
		_g_error_free0 (call_error);
		goto __finally14;
	}
	__finally14:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_rest_xml_node_unref0 (user_node);
			_rest_xml_node_unref0 (token_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (token_call);
			_g_object_unref0 (password_provider);
			return;
		} else {
			_rest_xml_node_unref0 (user_node);
			_rest_xml_node_unref0 (token_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (token_call);
			_g_object_unref0 (password_provider);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp7_ = rest_xml_node_find (root_node, "token");
	_tmp8_ = _rest_xml_node_ref0 (_tmp7_);
	_tmp9_ = _tmp8_;
	_rest_xml_node_unref0 (token_node);
	token_node = _tmp9_;
	_tmp10_ = rest_xml_node_find (root_node, "user");
	_tmp11_ = _rest_xml_node_ref0 (_tmp10_);
	_tmp12_ = _tmp11_;
	_rest_xml_node_unref0 (user_node);
	user_node = _tmp12_;
	if (token_node == NULL) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = token_node->content == NULL;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = user_node == NULL;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp16_ = NULL;
		_tmp16_ = rest_xml_node_get_attr (user_node, "username");
		_tmp13_ = _tmp16_ == NULL;
	}
	if (_tmp13_) {
		GError* _tmp17_ = NULL;
		_tmp17_ = g_error_new_literal (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_SERVICE, "Malformed XML response while getting token");
		_inner_error_ = _tmp17_;
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_rest_xml_node_unref0 (user_node);
			_rest_xml_node_unref0 (token_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (token_call);
			_g_object_unref0 (password_provider);
			return;
		} else {
			_rest_xml_node_unref0 (user_node);
			_rest_xml_node_unref0 (token_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (token_call);
			_g_object_unref0 (password_provider);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp18_ = rest_xml_node_get_attr (user_node, "username");
	tracker_password_provider_store_password (password_provider, TRACKER_MINER_FLICKR_MINER_NAME, TRACKER_MINER_FLICKR_MINER_DESCRIPTION, _tmp18_, token_node->content, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch15_g_error;
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (g_error_matches (e, TRACKER_PASSWORD_PROVIDER_ERROR, TRACKER_PASSWORD_PROVIDER_ERROR_SERVICE)) {
			GError* _tmp19_ = NULL;
			_tmp19_ = g_error_new_literal (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_KEYRING, e->message);
			_inner_error_ = _tmp19_;
			_g_error_free0 (e);
			goto __finally15;
		}
		g_critical ("tracker-miner-flickr.vala:732: Internal error: %s", e->message);
		_g_error_free0 (e);
		_rest_xml_node_unref0 (user_node);
		_rest_xml_node_unref0 (token_node);
		_rest_xml_node_unref0 (root_node);
		_g_object_unref0 (token_call);
		_g_object_unref0 (password_provider);
		return;
	}
	__finally15:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_rest_xml_node_unref0 (user_node);
			_rest_xml_node_unref0 (token_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (token_call);
			_g_object_unref0 (password_provider);
			return;
		} else {
			_rest_xml_node_unref0 (user_node);
			_rest_xml_node_unref0 (token_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (token_call);
			_g_object_unref0 (password_provider);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_rest_xml_node_unref0 (user_node);
	_rest_xml_node_unref0 (token_node);
	_rest_xml_node_unref0 (root_node);
	_g_object_unref0 (token_call);
	_g_object_unref0 (password_provider);
}


static void tracker_miner_flickr_real_authenticate (TrackerMinerWeb* base, GError** error) {
	TrackerMinerFlickr * self;
	TrackerPasswordProvider* password_provider = NULL;
	RestProxyCall* login_call = NULL;
	RestXmlNode* root_node = NULL;
	RestXmlNode* user_node = NULL;
	TrackerPasswordProvider* _tmp0_ = NULL;
	TrackerPasswordProvider* _tmp1_;
	TrackerPasswordProvider* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	RestProxyCall* _tmp8_ = NULL;
	RestProxyCall* _tmp9_;
	RestXmlNode* _tmp10_ = NULL;
	RestXmlNode* _tmp11_;
	RestXmlNode* _tmp12_;
	RestXmlNode* _tmp14_ = NULL;
	RestXmlNode* _tmp15_;
	RestXmlNode* _tmp16_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GError * _inner_error_ = NULL;
	self = (TrackerMinerFlickr*) base;
	_tmp0_ = tracker_password_provider_get ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (password_provider);
	password_provider = _tmp2_;
	g_object_set ((TrackerMinerWeb*) self, "associated", FALSE, NULL);
	_tmp3_ = tracker_password_provider_get_password (password_provider, TRACKER_MINER_FLICKR_MINER_NAME, NULL, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		goto __catch16_g_error;
	}
	_tmp5_ = _tmp4_;
	_g_free0 (self->priv->auth_token);
	self->priv->auth_token = _tmp5_;
	goto __finally16;
	__catch16_g_error:
	{
		GError * e;
		GError* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (g_error_matches (e, TRACKER_PASSWORD_PROVIDER_ERROR, TRACKER_PASSWORD_PROVIDER_ERROR_NOTFOUND)) {
			GError* _tmp6_ = NULL;
			_tmp6_ = g_error_new_literal (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_NO_CREDENTIALS, "Miner is not associated");
			_inner_error_ = _tmp6_;
			_g_error_free0 (e);
			goto __finally16;
		}
		_tmp7_ = g_error_new_literal (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_KEYRING, e->message);
		_inner_error_ = _tmp7_;
		_g_error_free0 (e);
		goto __finally16;
	}
	__finally16:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_rest_xml_node_unref0 (user_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (login_call);
			_g_object_unref0 (password_provider);
			return;
		} else {
			_rest_xml_node_unref0 (user_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (login_call);
			_g_object_unref0 (password_provider);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp8_ = rest_proxy_new_call (self->priv->rest);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (login_call);
	login_call = _tmp9_;
	rest_proxy_call_add_param (login_call, "method", "flickr.auth.checkToken");
	_tmp10_ = tracker_miner_flickr_run_call (self, login_call, &_inner_error_);
	_tmp11_ = _tmp10_;
	if (_inner_error_ != NULL) {
		goto __catch17_g_error;
	}
	_tmp12_ = _tmp11_;
	_rest_xml_node_unref0 (root_node);
	root_node = _tmp12_;
	goto __finally17;
	__catch17_g_error:
	{
		GError * call_error;
		GError* _tmp13_ = NULL;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = g_error_new (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_SERVICE, "Cannot verify login: %s", call_error->message);
		_inner_error_ = _tmp13_;
		_g_error_free0 (call_error);
		goto __finally17;
	}
	__finally17:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_rest_xml_node_unref0 (user_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (login_call);
			_g_object_unref0 (password_provider);
			return;
		} else {
			_rest_xml_node_unref0 (user_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (login_call);
			_g_object_unref0 (password_provider);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = rest_xml_node_find (root_node, "user");
	_tmp15_ = _rest_xml_node_ref0 (_tmp14_);
	_tmp16_ = _tmp15_;
	_rest_xml_node_unref0 (user_node);
	user_node = _tmp16_;
	if (user_node == NULL) {
		_tmp17_ = TRUE;
	} else {
		const gchar* _tmp18_ = NULL;
		_tmp18_ = rest_xml_node_get_attr (user_node, "nsid");
		_tmp17_ = _tmp18_ == NULL;
	}
	if (_tmp17_) {
		GError* _tmp19_ = NULL;
		_tmp19_ = g_error_new_literal (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_WRONG_CREDENTIALS, "Stored authentication token is not valid");
		_inner_error_ = _tmp19_;
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_rest_xml_node_unref0 (user_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (login_call);
			_g_object_unref0 (password_provider);
			return;
		} else {
			_rest_xml_node_unref0 (user_node);
			_rest_xml_node_unref0 (root_node);
			_g_object_unref0 (login_call);
			_g_object_unref0 (password_provider);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp20_ = rest_xml_node_get_attr (user_node, "nsid");
	_tmp21_ = g_strdup (_tmp20_);
	_tmp22_ = _tmp21_;
	_g_free0 (self->priv->user_id);
	self->priv->user_id = _tmp22_;
	g_message ("tracker-miner-flickr.vala:772: Authentication successful");
	g_object_set ((TrackerMinerWeb*) self, "associated", TRUE, NULL);
	_rest_xml_node_unref0 (user_node);
	_rest_xml_node_unref0 (root_node);
	_g_object_unref0 (login_call);
	_g_object_unref0 (password_provider);
}


static void tracker_miner_flickr_real_dissociate (TrackerMinerWeb* base, GError** error) {
	TrackerMinerFlickr * self;
	TrackerPasswordProvider* _tmp0_ = NULL;
	TrackerPasswordProvider* _tmp1_;
	TrackerPasswordProvider* password_provider;
	GError * _inner_error_ = NULL;
	self = (TrackerMinerFlickr*) base;
	_tmp0_ = tracker_password_provider_get ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	password_provider = _tmp1_;
	tracker_password_provider_forget_password (password_provider, TRACKER_MINER_FLICKR_MINER_NAME, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch18_g_error;
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (g_error_matches (e, TRACKER_PASSWORD_PROVIDER_ERROR, TRACKER_PASSWORD_PROVIDER_ERROR_SERVICE)) {
			GError* _tmp2_ = NULL;
			_tmp2_ = g_error_new_literal (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_KEYRING, e->message);
			_inner_error_ = _tmp2_;
			_g_error_free0 (e);
			goto __finally18;
		}
		g_critical ("tracker-miner-flickr.vala:786: Internal error: %s", e->message);
		_g_error_free0 (e);
		_g_object_unref0 (password_provider);
		return;
	}
	__finally18:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (password_provider);
			return;
		} else {
			_g_object_unref0 (password_provider);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_object_set ((TrackerMinerWeb*) self, "associated", FALSE, NULL);
	_g_object_unref0 (password_provider);
}


static void _lambda0_ (gint key, GArray* value, TrackerMinerFlickr* self) {
	gint id;
	GArray* classes;
	id = (gint) key;
	classes = (GArray*) value;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < classes->len)) {
					break;
				}
				_tmp1_ = g_array_index (classes, gint, i);
				if (_tmp1_ == self->priv->nmm_photo_id) {
					tracker_miner_flickr_writeback_photo (self, id, NULL, NULL);
				}
			}
		}
	}
}


static void __lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda0_ (key, value, self);
}


void tracker_miner_flickr_writeback (TrackerMinerFlickr* self, GHashTable* properties) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (properties != NULL);
	g_hash_table_foreach (properties, __lambda0__gh_func, self);
}


static gchar* tracker_miner_flickr_get_resource (TrackerMinerFlickr* self, const gchar* graph, gchar** types, int types_length1, const gchar* identifier, gboolean* created, GError** error) {
	gboolean _created = FALSE;
	gchar* result = NULL;
	gchar* inner_query = NULL;
	gchar* select_query = NULL;
	gchar* insert_query = NULL;
	TrackerSparqlCursor* cursor = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	TrackerSparqlConnection* _tmp13_ = NULL;
	TrackerSparqlCursor* _tmp14_ = NULL;
	TrackerSparqlCursor* _tmp15_;
	TrackerSparqlCursor* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	TrackerSparqlConnection* _tmp25_ = NULL;
	GVariant* _tmp26_ = NULL;
	GVariant* v;
	GVariantIter* iter1 = NULL;
	GVariantIter* iter2 = NULL;
	GVariantIter* iter3 = NULL;
	gchar* key;
	gchar* val;
	GVariantIter* _tmp27_ = NULL;
	GVariantIter* _tmp28_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (identifier != NULL, NULL);
	_tmp0_ = g_strdup ("");
	_tmp1_ = _tmp0_;
	_g_free0 (select_query);
	select_query = _tmp1_;
	_tmp2_ = g_strdup ("");
	_tmp3_ = _tmp2_;
	_g_free0 (inner_query);
	inner_query = _tmp3_;
	_created = FALSE;
	{
		gchar** type_collection;
		int type_collection_length1;
		int type_it;
		type_collection = types;
		type_collection_length1 = types_length1;
		for (type_it = 0; type_it < types_length1; type_it = type_it + 1) {
			gchar* _tmp4_;
			gchar* type;
			_tmp4_ = g_strdup (type_collection[type_it]);
			type = _tmp4_;
			{
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp5_ = g_strdup_printf (" a %s; ", type);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strconcat (inner_query, _tmp6_, NULL);
				_g_free0 (inner_query);
				inner_query = _tmp7_;
				_g_free0 (_tmp6_);
				_g_free0 (type);
			}
		}
	}
	_tmp8_ = g_strdup_printf ("nao:identifier \"%s\"", identifier);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (inner_query, _tmp9_, NULL);
	_g_free0 (inner_query);
	inner_query = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp11_ = g_strdup_printf ("select ?urn where { ?urn %s }", inner_query);
	_tmp12_ = _tmp11_;
	_g_free0 (select_query);
	select_query = _tmp12_;
	_tmp13_ = tracker_miner_get_connection ((TrackerMiner*) self);
	_tmp14_ = tracker_sparql_connection_query (_tmp13_, select_query, NULL, &_inner_error_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		goto __catch19_g_error;
	}
	_tmp16_ = _tmp15_;
	_g_object_unref0 (cursor);
	cursor = _tmp16_;
	_tmp17_ = tracker_sparql_cursor_next (cursor, NULL, &_inner_error_);
	_tmp18_ = _tmp17_;
	if (_inner_error_ != NULL) {
		goto __catch19_g_error;
	}
	if (_tmp18_) {
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		_tmp19_ = tracker_sparql_cursor_get_string (cursor, 0, NULL);
		_tmp20_ = g_strdup (_tmp19_);
		result = _tmp20_;
		_g_object_unref0 (cursor);
		_g_free0 (insert_query);
		_g_free0 (select_query);
		_g_free0 (inner_query);
		if (created) {
			*created = _created;
		}
		return result;
	}
	if (graph == NULL) {
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		_tmp21_ = g_strdup_printf ("insert { _:res %s }", inner_query);
		_tmp22_ = _tmp21_;
		_g_free0 (insert_query);
		insert_query = _tmp22_;
	} else {
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		_tmp23_ = g_strdup_printf ("insert into <%s> { _:res %s }", graph, inner_query);
		_tmp24_ = _tmp23_;
		_g_free0 (insert_query);
		insert_query = _tmp24_;
	}
	_created = TRUE;
	_tmp25_ = tracker_miner_get_connection ((TrackerMiner*) self);
	_tmp26_ = tracker_sparql_connection_update_blank (_tmp25_, insert_query, G_PRIORITY_DEFAULT, NULL, &_inner_error_);
	v = _tmp26_;
	if (_inner_error_ != NULL) {
		goto __catch19_g_error;
	}
	key = NULL;
	val = NULL;
	_tmp27_ = g_variant_iter_new (v);
	_tmp28_ = _tmp27_;
	_g_variant_iter_free0 (iter1);
	iter1 = _tmp28_;
	while (TRUE) {
		gboolean _tmp29_;
		_tmp29_ = g_variant_iter_next (iter1, "aa{ss}", &iter2, NULL);
		if (!_tmp29_) {
			break;
		}
		while (TRUE) {
			gboolean _tmp30_;
			_tmp30_ = g_variant_iter_next (iter2, "a{ss}", &iter3, NULL);
			if (!_tmp30_) {
				break;
			}
			while (TRUE) {
				gboolean _tmp31_;
				_tmp31_ = g_variant_iter_next (iter3, "{ss}", &key, &val, NULL);
				if (!_tmp31_) {
					break;
				}
				break;
			}
		}
	}
	result = val;
	_g_free0 (key);
	_g_variant_iter_free0 (iter3);
	_g_variant_iter_free0 (iter2);
	_g_variant_iter_free0 (iter1);
	_g_variant_unref0 (v);
	_g_object_unref0 (cursor);
	_g_free0 (insert_query);
	_g_free0 (select_query);
	_g_free0 (inner_query);
	if (created) {
		*created = _created;
	}
	return result;
	_g_free0 (val);
	_g_free0 (key);
	_g_variant_iter_free0 (iter3);
	_g_variant_iter_free0 (iter2);
	_g_variant_iter_free0 (iter1);
	_g_variant_unref0 (v);
	goto __finally19;
	__catch19_g_error:
	{
		GError * tracker_error;
		GError* _tmp32_;
		tracker_error = _inner_error_;
		_inner_error_ = NULL;
		_tmp32_ = _g_error_copy0 (tracker_error);
		_inner_error_ = _tmp32_;
		_g_error_free0 (tracker_error);
		goto __finally19;
	}
	__finally19:
	g_propagate_error (error, _inner_error_);
	_g_object_unref0 (cursor);
	_g_free0 (insert_query);
	_g_free0 (select_query);
	_g_free0 (inner_query);
	return NULL;
}


void tracker_miner_flickr_update_triple_string (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const gchar* graph, const gchar* urn, const gchar* property, const gchar* new_value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (graph != NULL);
	g_return_if_fail (urn != NULL);
	g_return_if_fail (property != NULL);
	g_return_if_fail (new_value != NULL);
	tracker_sparql_builder_delete_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object_string (builder, new_value);
	tracker_sparql_builder_delete_close (builder);
	tracker_sparql_builder_insert_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object_string (builder, new_value);
	tracker_sparql_builder_insert_close (builder);
}


void tracker_miner_flickr_update_triple_object (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const gchar* graph, const gchar* urn, const gchar* property, const gchar* new_value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (graph != NULL);
	g_return_if_fail (urn != NULL);
	g_return_if_fail (property != NULL);
	g_return_if_fail (new_value != NULL);
	tracker_sparql_builder_delete_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object (builder, new_value);
	tracker_sparql_builder_delete_close (builder);
	tracker_sparql_builder_insert_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object (builder, new_value);
	tracker_sparql_builder_insert_close (builder);
}


void tracker_miner_flickr_update_triple_double (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const gchar* graph, const gchar* urn, const gchar* property, gdouble new_value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (graph != NULL);
	g_return_if_fail (urn != NULL);
	g_return_if_fail (property != NULL);
	tracker_sparql_builder_delete_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object_double (builder, new_value);
	tracker_sparql_builder_delete_close (builder);
	tracker_sparql_builder_insert_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object_double (builder, new_value);
	tracker_sparql_builder_insert_close (builder);
}


void tracker_miner_flickr_update_triple_int64 (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const gchar* graph, const gchar* urn, const gchar* property, gint64 new_value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (graph != NULL);
	g_return_if_fail (urn != NULL);
	g_return_if_fail (property != NULL);
	tracker_sparql_builder_delete_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object_int64 (builder, new_value);
	tracker_sparql_builder_delete_close (builder);
	tracker_sparql_builder_insert_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object_int64 (builder, new_value);
	tracker_sparql_builder_insert_close (builder);
}


static void tracker_miner_flickr_signal_handler (gint signo) {
	if (tracker_miner_flickr_in_loop) {
		exit (EXIT_FAILURE);
	}
	switch (signo) {
		case SIGINT:
		case SIGTERM:
		{
			tracker_miner_flickr_in_loop = TRUE;
			g_main_loop_quit (tracker_miner_flickr_main_loop);
			break;
		}
		default:
		break;
	}
	fprintf (stdout, "\nReceived signal:%d\n", signo);
}


static void _tracker_miner_flickr_signal_handler_sighandler_t (gint signal) {
	tracker_miner_flickr_signal_handler (signal);
}


static void tracker_miner_flickr_init_signals (void) {
	struct sigaction act = {0};
	sigset_t empty_mask = {0};
	memset (&act, 0, sizeof (struct sigaction));
	memset (&empty_mask, 0, sizeof (sigset_t));
	sigemptyset (&empty_mask);
	act.sa_handler = _tracker_miner_flickr_signal_handler_sighandler_t;
	act.sa_mask = empty_mask;
	act.sa_flags = 0;
	sigaction (SIGTERM, &act, NULL);
	sigaction (SIGINT, &act, NULL);
}


gint tracker_miner_flickr_main (gchar** args, int args_length1) {
	gint result = 0;
	TrackerMinerFlickr* flickr_miner = NULL;
	void* _tmp0_ = NULL;
	void* _tmp1_;
	void* _tmp2_;
	TrackerMinerFlickr* _tmp3_;
	TrackerMinerFlickr* _tmp4_;
	GMainLoop* _tmp5_ = NULL;
	GMainLoop* _tmp6_;
	GError * _inner_error_ = NULL;
	g_set_application_name ("Flickr tracker miner");
	_tmp0_ = g_initable_new (TRACKER_TYPE_MINER_FLICKR, NULL, &_inner_error_, NULL);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch20_g_error;
	}
	_tmp3_ = _g_object_ref0 ((_tmp2_ = _tmp1_, TRACKER_IS_MINER_FLICKR (_tmp2_) ? ((TrackerMinerFlickr*) _tmp2_) : NULL));
	_tmp4_ = _tmp3_;
	_g_object_unref0 (flickr_miner);
	flickr_miner = _tmp4_;
	goto __finally20;
	__catch20_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_printerr ("Couldn't create new Flickr Miner: '%s', exiting...\n", e->message);
		result = -1;
		_g_error_free0 (e);
		_g_object_unref0 (flickr_miner);
		return result;
	}
	__finally20:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (flickr_miner);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	tracker_miner_flickr_init_signals ();
	_tmp5_ = g_main_loop_new (NULL, FALSE);
	_tmp6_ = _tmp5_;
	_g_main_loop_unref0 (tracker_miner_flickr_main_loop);
	tracker_miner_flickr_main_loop = _tmp6_;
	g_main_loop_run (tracker_miner_flickr_main_loop);
	tracker_miner_flickr_shutdown (flickr_miner);
	result = 0;
	_g_object_unref0 (flickr_miner);
	return result;
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return tracker_miner_flickr_main (argv, argc);
}


TrackerMinerFlickr* tracker_miner_flickr_construct (GType object_type) {
	TrackerMinerFlickr * self = NULL;
	self = (TrackerMinerFlickr*) g_object_new (object_type, NULL);
	return self;
}


TrackerMinerFlickr* tracker_miner_flickr_new (void) {
	return tracker_miner_flickr_construct (TRACKER_TYPE_MINER_FLICKR);
}


static GObject * tracker_miner_flickr_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TrackerMinerFlickr * self;
	RestProxy* _tmp0_ = NULL;
	RestProxy* _tmp1_;
	parent_class = G_OBJECT_CLASS (tracker_miner_flickr_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TRACKER_MINER_FLICKR (obj);
	g_object_set ((TrackerMiner*) self, "name", TRACKER_MINER_FLICKR_MINER_NAME, NULL);
	g_object_set ((TrackerMinerWeb*) self, "associated", FALSE, NULL);
	g_object_set ((TrackerMiner*) self, "status", "Not authenticated", NULL);
	g_object_set ((TrackerMiner*) self, "progress", 1.0, NULL);
	_tmp0_ = rest_proxy_new (TRACKER_MINER_FLICKR_FLICKR_REST_URL, FALSE);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->rest);
	self->priv->rest = _tmp1_;
	return obj;
}


static void tracker_miner_flickr_class_init (TrackerMinerFlickrClass * klass) {
	tracker_miner_flickr_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerMinerFlickrPrivate));
	TRACKER_MINER_WEB_CLASS (klass)->get_association_data = tracker_miner_flickr_real_get_association_data;
	TRACKER_MINER_WEB_CLASS (klass)->associate = tracker_miner_flickr_real_associate;
	TRACKER_MINER_WEB_CLASS (klass)->authenticate = tracker_miner_flickr_real_authenticate;
	TRACKER_MINER_WEB_CLASS (klass)->dissociate = tracker_miner_flickr_real_dissociate;
	G_OBJECT_CLASS (klass)->constructor = tracker_miner_flickr_constructor;
	G_OBJECT_CLASS (klass)->finalize = tracker_miner_flickr_finalize;
}


static void tracker_miner_flickr_g_initable_interface_init (GInitableIface * iface) {
	tracker_miner_flickr_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*)(GInitable* ,GCancellable* ,GError**)) tracker_miner_flickr_real_init;
}


static void tracker_miner_flickr_instance_init (TrackerMinerFlickr * self) {
	self->priv = TRACKER_MINER_FLICKR_GET_PRIVATE (self);
}


static void tracker_miner_flickr_finalize (GObject* obj) {
	TrackerMinerFlickr * self;
	self = TRACKER_MINER_FLICKR (obj);
	_g_object_unref0 (self->priv->rest);
	_g_free0 (self->priv->frob);
	_g_free0 (self->priv->auth_token);
	_g_free0 (self->priv->user_id);
	G_OBJECT_CLASS (tracker_miner_flickr_parent_class)->finalize (obj);
}


GType tracker_miner_flickr_get_type (void) {
	static volatile gsize tracker_miner_flickr_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_miner_flickr_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerMinerFlickrClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_miner_flickr_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerMinerFlickr), 0, (GInstanceInitFunc) tracker_miner_flickr_instance_init, NULL };
		static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) tracker_miner_flickr_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tracker_miner_flickr_type_id;
		tracker_miner_flickr_type_id = g_type_register_static (TRACKER_TYPE_MINER_WEB, "TrackerMinerFlickr", &g_define_type_info, 0);
		g_type_add_interface_static (tracker_miner_flickr_type_id, G_TYPE_INITABLE, &g_initable_info);
		g_once_init_leave (&tracker_miner_flickr_type_id__volatile, tracker_miner_flickr_type_id);
	}
	return tracker_miner_flickr_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



