/* test-class-signal.c generated by valac 0.12.0.69-6c49, the Vala compiler
 * generated from test-class-signal.vala, do not modify */

/*
 * Copyright (C) 2008, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gobject/gvaluecollector.h>


#define TYPE_EVENT (event_get_type ())
typedef struct _Event Event;

#define TYPE_RESOURCES (resources_get_type ())
#define RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESOURCES, Resources))
#define IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESOURCES))
#define RESOURCES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_RESOURCES, ResourcesIface))

typedef struct _Resources Resources;
typedef struct _ResourcesIface ResourcesIface;

#define TYPE_RESOURCES_PROXY (resources_proxy_get_type ())
typedef GDBusProxy ResourcesProxy;
typedef GDBusProxyClass ResourcesProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TEST_APP (test_app_get_type ())
#define TEST_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_APP, TestApp))
#define TEST_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_APP, TestAppClass))
#define IS_TEST_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_APP))
#define IS_TEST_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_APP))
#define TEST_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_APP, TestAppClass))

typedef struct _TestApp TestApp;
typedef struct _TestAppClass TestAppClass;
typedef struct _TestAppPrivate TestAppPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _test_app_unref0(var) ((var == NULL) ? NULL : (var = (test_app_unref (var), NULL)))
typedef struct _TestAppOnGraphUpdatedReceivedAsyncData TestAppOnGraphUpdatedReceivedAsyncData;
typedef struct _ParamSpecTestApp ParamSpecTestApp;

struct _Event {
	gint graph_id;
	gint subject_id;
	gint pred_id;
	gint object_id;
};

struct _ResourcesIface {
	GTypeInterface parent_iface;
	void (*sparql_update_async) (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*sparql_update_finish) (Resources* self, GAsyncResult* _res_, GError** error);
};

struct _TestApp {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TestAppPrivate * priv;
};

struct _TestAppClass {
	GTypeClass parent_class;
	void (*finalize) (TestApp *self);
};

struct _TestAppPrivate {
	gint res;
	GMainLoop* loop;
	gboolean initialized;
	TrackerSparqlConnection* signal_con;
	TrackerSparqlConnection* con;
	gint total_signals_seen;
};

struct _TestAppOnGraphUpdatedReceivedAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestApp* self;
	gchar* dels_query;
	gchar* ins_query;
	TrackerSparqlCursor* cursor1;
	TrackerSparqlCursor* cursor2;
	TrackerSparqlCursor* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlCursor* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GError * e;
	GError * _inner_error_;
};

struct _ParamSpecTestApp {
	GParamSpec parent_instance;
};


static gpointer test_app_parent_class = NULL;
static Resources* test_app_resources_object;
static Resources* test_app_resources_object = NULL;

#define max_signals 10
#define title_data "title"
GType event_get_type (void) G_GNUC_CONST;
Event* event_dup (const Event* self);
void event_free (Event* self);
GType resources_proxy_get_type (void) G_GNUC_CONST;
guint resources_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType resources_get_type (void) G_GNUC_CONST;
void resources_sparql_update_async (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
void resources_sparql_update_finish (Resources* self, GAsyncResult* _res_, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_POINTER_INT_POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void resources_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_resources_graph_updated (Resources* self, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void resources_proxy_sparql_update_async_async (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void resources_proxy_sparql_update_async_finish (Resources* self, GAsyncResult* _res_, GError** error);
static void resources_proxy_resources_interface_init (ResourcesIface* iface);
static void _dbus_resources_sparql_update_async (Resources* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_resources_sparql_update_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_resources_graph_updated (GObject* _sender, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1, gpointer* _data);
static void _resources_unregister_object (gpointer user_data);
gpointer test_app_ref (gpointer instance);
void test_app_unref (gpointer instance);
GParamSpec* param_spec_test_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_test_app (GValue* value, gpointer v_object);
void value_take_test_app (GValue* value, gpointer v_object);
gpointer value_get_test_app (const GValue* value);
GType test_app_get_type (void) G_GNUC_CONST;
#define TEST_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEST_APP, TestAppPrivate))
enum  {
	TEST_APP_DUMMY_PROPERTY
};
TestApp* test_app_new (void);
TestApp* test_app_construct (GType object_type);
static void test_app_on_graph_updated_received (TestApp* self, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1);
static void _test_app_on_graph_updated_received_resources_graph_updated (Resources* _sender, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1, gpointer self);
static GString* test_app_build_title_query (TestApp* self, const gchar* class_name, Event* ids, int ids_length1);
static gint test_app_iter_cursor (TestApp* self, const gchar* kind, TrackerSparqlCursor* cursor);
static void test_app_on_graph_updated_received_async_data_free (gpointer _data);
static void test_app_on_graph_updated_received_async (TestApp* self, const gchar* dels_query, const gchar* ins_query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void test_app_on_graph_updated_received_finish (TestApp* self, GAsyncResult* _res_);
static gboolean test_app_on_graph_updated_received_async_co (TestAppOnGraphUpdatedReceivedAsyncData* data);
static void test_app_on_graph_updated_received_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void test_app_insert_data (TestApp* self);
static gboolean test_app_in_mainloop (TestApp* self);
gint test_app_run (TestApp* self);
static gboolean _test_app_in_mainloop_gsource_func (gpointer self);
static void test_app_finalize (TestApp* obj);
gint _vala_main (gchar** args, int args_length1);

static const GDBusArgInfo _resources_dbus_arg_info_sparql_update_async_query = {-1, "query", "s"};
static const GDBusArgInfo * const _resources_dbus_arg_info_sparql_update_async_in[] = {&_resources_dbus_arg_info_sparql_update_async_query, NULL};
static const GDBusArgInfo * const _resources_dbus_arg_info_sparql_update_async_out[] = {NULL};
static const GDBusMethodInfo _resources_dbus_method_info_sparql_update_async = {-1, "SparqlUpdate", (GDBusArgInfo **) (&_resources_dbus_arg_info_sparql_update_async_in), (GDBusArgInfo **) (&_resources_dbus_arg_info_sparql_update_async_out)};
static const GDBusMethodInfo * const _resources_dbus_method_info[] = {&_resources_dbus_method_info_sparql_update_async, NULL};
static const GDBusArgInfo _resources_dbus_arg_info_graph_updated_class_name = {-1, "class_name", "s"};
static const GDBusArgInfo _resources_dbus_arg_info_graph_updated_deletes = {-1, "deletes", "a(iiii)"};
static const GDBusArgInfo _resources_dbus_arg_info_graph_updated_inserts = {-1, "inserts", "a(iiii)"};
static const GDBusArgInfo * const _resources_dbus_arg_info_graph_updated[] = {&_resources_dbus_arg_info_graph_updated_class_name, &_resources_dbus_arg_info_graph_updated_deletes, &_resources_dbus_arg_info_graph_updated_inserts, NULL};
static const GDBusSignalInfo _resources_dbus_signal_info_graph_updated = {-1, "GraphUpdated", (GDBusArgInfo **) (&_resources_dbus_arg_info_graph_updated)};
static const GDBusSignalInfo * const _resources_dbus_signal_info[] = {&_resources_dbus_signal_info_graph_updated, NULL};
static const GDBusPropertyInfo * const _resources_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _resources_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Resources", (GDBusMethodInfo **) (&_resources_dbus_method_info), (GDBusSignalInfo **) (&_resources_dbus_signal_info), (GDBusPropertyInfo **) (&_resources_dbus_property_info)};
static const GDBusInterfaceVTable _resources_dbus_interface_vtable = {resources_dbus_interface_method_call, resources_dbus_interface_get_property, resources_dbus_interface_set_property};

Event* event_dup (const Event* self) {
	Event* dup;
	dup = g_new0 (Event, 1);
	memcpy (dup, self, sizeof (Event));
	return dup;
}


void event_free (Event* self) {
	g_free (self);
}


GType event_get_type (void) {
	static volatile gsize event_type_id__volatile = 0;
	if (g_once_init_enter (&event_type_id__volatile)) {
		GType event_type_id;
		event_type_id = g_boxed_type_register_static ("Event", (GBoxedCopyFunc) event_dup, (GBoxedFreeFunc) event_free);
		g_once_init_leave (&event_type_id__volatile, event_type_id);
	}
	return event_type_id__volatile;
}


void resources_sparql_update_async (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RESOURCES_GET_INTERFACE (self)->sparql_update_async (self, query, _callback_, _user_data_);
}


void resources_sparql_update_finish (Resources* self, GAsyncResult* _res_, GError** error) {
	RESOURCES_GET_INTERFACE (self)->sparql_update_finish (self, _res_, error);
}


static void g_cclosure_user_marshal_VOID__STRING_POINTER_INT_POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_POINTER_INT_POINTER_INT) (gpointer data1, const char* arg_1, gpointer arg_2, gint arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__STRING_POINTER_INT_POINTER_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_POINTER_INT_POINTER_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_int (param_values + 3), g_value_get_pointer (param_values + 4), g_value_get_int (param_values + 5), data2);
}


static void resources_base_init (ResourcesIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("graph_updated", TYPE_RESOURCES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_POINTER_INT_POINTER_INT, G_TYPE_NONE, 5, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_POINTER, G_TYPE_INT);
	}
}


GType resources_get_type (void) {
	static volatile gsize resources_type_id__volatile = 0;
	if (g_once_init_enter (&resources_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ResourcesIface), (GBaseInitFunc) resources_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType resources_type_id;
		resources_type_id = g_type_register_static (G_TYPE_INTERFACE, "Resources", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (resources_type_id, G_TYPE_DBUS_PROXY);
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) resources_proxy_get_type);
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Tracker1.Resources");
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) resources_register_object);
		g_once_init_leave (&resources_type_id__volatile, resources_type_id);
	}
	return resources_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ResourcesProxy, resources_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_RESOURCES, resources_proxy_resources_interface_init) )
static void resources_proxy_class_init (ResourcesProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = resources_proxy_g_signal;
}


static void _dbus_handle_resources_graph_updated (Resources* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* class_name = NULL;
	GVariant* _tmp0_;
	Event* deletes = NULL;
	int deletes_length1;
	GVariant* _tmp1_;
	Event* _tmp2_;
	int _tmp2__length;
	int _tmp2__size;
	int _tmp2__length1;
	GVariantIter _tmp3_;
	GVariant* _tmp4_;
	Event* inserts = NULL;
	int inserts_length1;
	GVariant* _tmp11_;
	Event* _tmp12_;
	int _tmp12__length;
	int _tmp12__size;
	int _tmp12__length1;
	GVariantIter _tmp13_;
	GVariant* _tmp14_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	class_name = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	deletes_length1 = 0;
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp2_ = g_new (Event, 5);
	_tmp2__length = 0;
	_tmp2__size = 4;
	_tmp2__length1 = 0;
	g_variant_iter_init (&_tmp3_, _tmp1_);
	for (; (_tmp4_ = g_variant_iter_next_value (&_tmp3_)) != NULL; _tmp2__length1++) {
		Event _tmp5_;
		GVariantIter _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		if (_tmp2__size == _tmp2__length) {
			_tmp2__size = 2 * _tmp2__size;
			_tmp2_ = g_renew (Event, _tmp2_, _tmp2__size + 1);
		}
		g_variant_iter_init (&_tmp6_, _tmp4_);
		_tmp7_ = g_variant_iter_next_value (&_tmp6_);
		_tmp5_.graph_id = g_variant_get_int32 (_tmp7_);
		g_variant_unref (_tmp7_);
		_tmp8_ = g_variant_iter_next_value (&_tmp6_);
		_tmp5_.subject_id = g_variant_get_int32 (_tmp8_);
		g_variant_unref (_tmp8_);
		_tmp9_ = g_variant_iter_next_value (&_tmp6_);
		_tmp5_.pred_id = g_variant_get_int32 (_tmp9_);
		g_variant_unref (_tmp9_);
		_tmp10_ = g_variant_iter_next_value (&_tmp6_);
		_tmp5_.object_id = g_variant_get_int32 (_tmp10_);
		g_variant_unref (_tmp10_);
		_tmp2_[_tmp2__length++] = _tmp5_;
		g_variant_unref (_tmp4_);
	}
	deletes_length1 = _tmp2__length1;
	deletes = _tmp2_;
	g_variant_unref (_tmp1_);
	inserts_length1 = 0;
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp12_ = g_new (Event, 5);
	_tmp12__length = 0;
	_tmp12__size = 4;
	_tmp12__length1 = 0;
	g_variant_iter_init (&_tmp13_, _tmp11_);
	for (; (_tmp14_ = g_variant_iter_next_value (&_tmp13_)) != NULL; _tmp12__length1++) {
		Event _tmp15_;
		GVariantIter _tmp16_;
		GVariant* _tmp17_;
		GVariant* _tmp18_;
		GVariant* _tmp19_;
		GVariant* _tmp20_;
		if (_tmp12__size == _tmp12__length) {
			_tmp12__size = 2 * _tmp12__size;
			_tmp12_ = g_renew (Event, _tmp12_, _tmp12__size + 1);
		}
		g_variant_iter_init (&_tmp16_, _tmp14_);
		_tmp17_ = g_variant_iter_next_value (&_tmp16_);
		_tmp15_.graph_id = g_variant_get_int32 (_tmp17_);
		g_variant_unref (_tmp17_);
		_tmp18_ = g_variant_iter_next_value (&_tmp16_);
		_tmp15_.subject_id = g_variant_get_int32 (_tmp18_);
		g_variant_unref (_tmp18_);
		_tmp19_ = g_variant_iter_next_value (&_tmp16_);
		_tmp15_.pred_id = g_variant_get_int32 (_tmp19_);
		g_variant_unref (_tmp19_);
		_tmp20_ = g_variant_iter_next_value (&_tmp16_);
		_tmp15_.object_id = g_variant_get_int32 (_tmp20_);
		g_variant_unref (_tmp20_);
		_tmp12_[_tmp12__length++] = _tmp15_;
		g_variant_unref (_tmp14_);
	}
	inserts_length1 = _tmp12__length1;
	inserts = _tmp12_;
	g_variant_unref (_tmp11_);
	g_signal_emit_by_name (self, "graph-updated", class_name, deletes, deletes_length1, inserts, inserts_length1);
	_g_free0 (class_name);
	deletes = (g_free (deletes), NULL);
	inserts = (g_free (inserts), NULL);
}


static void resources_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "GraphUpdated") == 0) {
		_dbus_handle_resources_graph_updated ((Resources*) proxy, parameters);
	}
}


static void resources_proxy_init (ResourcesProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void resources_proxy_sparql_update_async_async (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	TRACKER_SPARQL_ERROR;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Tracker1.Resources", "SparqlUpdate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void resources_proxy_sparql_update_async_finish (Resources* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void resources_proxy_resources_interface_init (ResourcesIface* iface) {
	iface->sparql_update_async = resources_proxy_sparql_update_async_async;
	iface->sparql_update_finish = resources_proxy_sparql_update_async_finish;
}


static void _dbus_resources_sparql_update_async (Resources* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* query = NULL;
	GVariant* _tmp21_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp21_ = g_variant_iter_next_value (&_arguments_iter);
	query = g_variant_dup_string (_tmp21_, NULL);
	g_variant_unref (_tmp21_);
	resources_sparql_update_async (self, query, (GAsyncReadyCallback) _dbus_resources_sparql_update_async_ready, invocation);
	_g_free0 (query);
}


static void _dbus_resources_sparql_update_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	resources_sparql_update_finish ((Resources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SparqlUpdate") == 0) {
		_dbus_resources_sparql_update_async (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_resources_graph_updated (GObject* _sender, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	Event* _tmp22_;
	GVariantBuilder _tmp23_;
	int _tmp24_;
	Event* _tmp26_;
	GVariantBuilder _tmp27_;
	int _tmp28_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (class_name));
	_tmp22_ = deletes;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("a(iiii)"));
	for (_tmp24_ = 0; _tmp24_ < deletes_length1; _tmp24_++) {
		GVariantBuilder _tmp25_;
		g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp25_, g_variant_new_int32 ((*_tmp22_).graph_id));
		g_variant_builder_add_value (&_tmp25_, g_variant_new_int32 ((*_tmp22_).subject_id));
		g_variant_builder_add_value (&_tmp25_, g_variant_new_int32 ((*_tmp22_).pred_id));
		g_variant_builder_add_value (&_tmp25_, g_variant_new_int32 ((*_tmp22_).object_id));
		g_variant_builder_add_value (&_tmp23_, g_variant_builder_end (&_tmp25_));
		_tmp22_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp23_));
	_tmp26_ = inserts;
	g_variant_builder_init (&_tmp27_, G_VARIANT_TYPE ("a(iiii)"));
	for (_tmp28_ = 0; _tmp28_ < inserts_length1; _tmp28_++) {
		GVariantBuilder _tmp29_;
		g_variant_builder_init (&_tmp29_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp29_, g_variant_new_int32 ((*_tmp26_).graph_id));
		g_variant_builder_add_value (&_tmp29_, g_variant_new_int32 ((*_tmp26_).subject_id));
		g_variant_builder_add_value (&_tmp29_, g_variant_new_int32 ((*_tmp26_).pred_id));
		g_variant_builder_add_value (&_tmp29_, g_variant_new_int32 ((*_tmp26_).object_id));
		g_variant_builder_add_value (&_tmp27_, g_variant_builder_end (&_tmp29_));
		_tmp26_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp27_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Resources", "GraphUpdated", _arguments, NULL);
}


guint resources_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_resources_dbus_interface_info), &_resources_dbus_interface_vtable, data, _resources_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "graph-updated", (GCallback) _dbus_resources_graph_updated, data);
	return result;
}


static void _resources_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _test_app_on_graph_updated_received_resources_graph_updated (Resources* _sender, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1, gpointer self) {
	test_app_on_graph_updated_received (self, class_name, deletes, deletes_length1, inserts, inserts_length1);
}


TestApp* test_app_construct (GType object_type) {
	TestApp* self = NULL;
	TrackerSparqlConnection* _tmp0_ = NULL;
	TrackerSparqlConnection* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	Resources* _tmp3_ = NULL;
	Resources* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (TestApp*) g_type_create_instance (object_type);
	g_return_val_if_fail (!self->priv->initialized, NULL);
	_tmp0_ = tracker_sparql_connection_get (NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	_g_object_unref0 (self->priv->con);
	self->priv->con = _tmp1_;
	_tmp2_ = _g_object_ref0 (self->priv->con);
	_g_object_unref0 (self->priv->signal_con);
	self->priv->signal_con = _tmp2_;
	_tmp3_ = g_initable_new (TYPE_RESOURCES_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", "org.freedesktop.Tracker1", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/Tracker1/Resources", "g-interface-name", "org.freedesktop.Tracker1.Resources", NULL);
	_tmp4_ = (Resources*) _tmp3_;
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	_g_object_unref0 (test_app_resources_object);
	test_app_resources_object = _tmp4_;
	g_signal_connect (test_app_resources_object, "graph-updated", (GCallback) _test_app_on_graph_updated_received_resources_graph_updated, self);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("test-class-signal.vala:68: Could not connect to D-Bus service: %s", e->message);
		self->priv->initialized = FALSE;
		self->priv->res = -1;
		_g_error_free0 (e);
		return self;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->initialized = TRUE;
	return self;
}


TestApp* test_app_new (void) {
	return test_app_construct (TYPE_TEST_APP);
}


static GString* test_app_build_title_query (TestApp* self, const gchar* class_name, Event* ids, int ids_length1) {
	GString* result = NULL;
	gboolean first;
	GString* _tmp0_ = NULL;
	GString* builder;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (class_name != NULL, NULL);
	first = TRUE;
	_tmp0_ = g_string_new ("SELECT ?r ?t { ?r a <");
	builder = _tmp0_;
	g_string_append (builder, class_name);
	g_string_append (builder, ">; nie:title ?t . FILTER (tracker:id (?r) IN (");
	{
		Event* event_collection;
		int event_collection_length1;
		int event_it;
		event_collection = ids;
		event_collection_length1 = ids_length1;
		for (event_it = 0; event_it < ids_length1; event_it = event_it + 1) {
			Event event;
			event = event_collection[event_it];
			{
				if (first) {
					g_string_append_printf (builder, "%d", event.subject_id);
				} else {
					g_string_append_printf (builder, " , %d", event.subject_id);
				}
				first = FALSE;
			}
		}
	}
	g_string_append (builder, ")) }");
	result = builder;
	return result;
}


static gint test_app_iter_cursor (TestApp* self, const gchar* kind, TrackerSparqlCursor* cursor) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (kind != NULL, 0);
	g_return_val_if_fail (cursor != NULL, 0);
	while (TRUE) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* resource;
		const gchar* _tmp4_ = NULL;
		_tmp0_ = tracker_sparql_cursor_next (cursor, NULL, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = tracker_sparql_cursor_get_string (cursor, 0, NULL);
		_tmp3_ = g_strdup (_tmp2_);
		resource = _tmp3_;
		_tmp4_ = tracker_sparql_cursor_get_string (cursor, 1, NULL);
		g_print ("%s <%s> nie:title '%s'\n", kind, resource, _tmp4_);
		self->priv->total_signals_seen++;
		if (self->priv->total_signals_seen >= (max_signals * 2)) {
			g_main_loop_quit (self->priv->loop);
		}
		_g_free0 (resource);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("test-class-signal.vala:115: Couldn't iterate query results: %s", e->message);
		self->priv->res = -1;
		result = -1;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


static void test_app_on_graph_updated_received_async_data_free (gpointer _data) {
	TestAppOnGraphUpdatedReceivedAsyncData* data;
	data = _data;
	_g_free0 (data->dels_query);
	_g_free0 (data->ins_query);
	_test_app_unref0 (data->self);
	g_slice_free (TestAppOnGraphUpdatedReceivedAsyncData, data);
}


static gpointer _test_app_ref0 (gpointer self) {
	return self ? test_app_ref (self) : NULL;
}


static void test_app_on_graph_updated_received_async (TestApp* self, const gchar* dels_query, const gchar* ins_query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestAppOnGraphUpdatedReceivedAsyncData* _data_;
	_data_ = g_slice_new0 (TestAppOnGraphUpdatedReceivedAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, test_app_on_graph_updated_received_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_app_on_graph_updated_received_async_data_free);
	_data_->self = _test_app_ref0 (self);
	_data_->dels_query = g_strdup (dels_query);
	_data_->ins_query = g_strdup (ins_query);
	test_app_on_graph_updated_received_async_co (_data_);
}


static void test_app_on_graph_updated_received_finish (TestApp* self, GAsyncResult* _res_) {
	TestAppOnGraphUpdatedReceivedAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void test_app_on_graph_updated_received_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestAppOnGraphUpdatedReceivedAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	test_app_on_graph_updated_received_async_co (data);
}


static gboolean test_app_on_graph_updated_received_async_co (TestAppOnGraphUpdatedReceivedAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	tracker_sparql_connection_query_async (data->self->priv->signal_con, data->dels_query, NULL, test_app_on_graph_updated_received_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_sparql_connection_query_finish (data->self->priv->signal_con, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->cursor2);
		_g_object_unref0 (data->cursor1);
		goto __catch2_g_error;
	}
	_g_object_unref0 (data->cursor1);
	data->cursor1 = data->_tmp1_;
	data->_state_ = 2;
	tracker_sparql_connection_query_async (data->self->priv->signal_con, data->ins_query, NULL, test_app_on_graph_updated_received_async_ready, data);
	return FALSE;
	_state_2:
	data->_tmp2_ = NULL;
	data->_tmp2_ = tracker_sparql_connection_query_finish (data->self->priv->signal_con, data->_res_, &data->_inner_error_);
	data->_tmp3_ = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->cursor2);
		_g_object_unref0 (data->cursor1);
		goto __catch2_g_error;
	}
	_g_object_unref0 (data->cursor2);
	data->cursor2 = data->_tmp3_;
	data->_tmp4_ = test_app_iter_cursor (data->self, "delete of: ", data->cursor1);
	data->self->priv->res = data->_tmp4_;
	if (data->self->priv->res != (-1)) {
		data->_tmp5_ = test_app_iter_cursor (data->self, "insert of: ", data->cursor2);
		data->self->priv->res = data->_tmp5_;
	}
	_g_object_unref0 (data->cursor2);
	_g_object_unref0 (data->cursor1);
	goto __finally2;
	__catch2_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("test-class-signal.vala:134: Couldn't iterate query results: %s", data->e->message);
		data->self->priv->res = -1;
		_g_error_free0 (data->e);
	}
	__finally2:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void test_app_on_graph_updated_received (TestApp* self, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1) {
	GString* _tmp0_ = NULL;
	GString* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* dels_qry;
	GString* _tmp4_ = NULL;
	GString* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* ins_qry;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_name != NULL);
	_tmp0_ = test_app_build_title_query (self, class_name, deletes, deletes_length1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_->str);
	_tmp3_ = _tmp2_;
	_g_string_free0 (_tmp1_);
	dels_qry = _tmp3_;
	_tmp4_ = test_app_build_title_query (self, class_name, deletes, deletes_length1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_->str);
	_tmp7_ = _tmp6_;
	_g_string_free0 (_tmp5_);
	ins_qry = _tmp7_;
	test_app_on_graph_updated_received_async (self, dels_qry, ins_qry, NULL, NULL);
	_g_free0 (ins_qry);
	_g_free0 (dels_qry);
}


static void test_app_insert_data (TestApp* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gchar* _tmp1_ = NULL;
			gchar* upqry;
			if (!_tmp0_) {
				i++;
			}
			_tmp0_ = FALSE;
			if (!(i <= max_signals)) {
				break;
			}
			_tmp1_ = g_strdup_printf ("DELETE { <%d> a rdfs:Resource } INSERT { <%d> a nmm:MusicPiece ; nie:t" \
"itle '%s %d' }", i, i, title_data, i);
			upqry = _tmp1_;
			resources_sparql_update_async (test_app_resources_object, upqry, NULL, NULL);
			_g_free0 (upqry);
		}
	}
}


static gboolean test_app_in_mainloop (TestApp* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	test_app_insert_data (self);
	result = FALSE;
	return result;
}


static gboolean _test_app_in_mainloop_gsource_func (gpointer self) {
	gboolean result;
	result = test_app_in_mainloop (self);
	return result;
}


gint test_app_run (TestApp* self) {
	gint result = 0;
	GMainLoop* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _test_app_in_mainloop_gsource_func, test_app_ref (self), test_app_unref);
	g_main_loop_run (self->priv->loop);
	result = self->priv->res;
	return result;
}


static void value_test_app_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_test_app_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		test_app_unref (value->data[0].v_pointer);
	}
}


static void value_test_app_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = test_app_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_test_app_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_test_app_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TestApp* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = test_app_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_test_app_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TestApp** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = test_app_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_test_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTestApp* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEST_APP), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_test_app (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP), NULL);
	return value->data[0].v_pointer;
}


void value_set_test_app (GValue* value, gpointer v_object) {
	TestApp* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_APP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		test_app_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_app_unref (old);
	}
}


void value_take_test_app (GValue* value, gpointer v_object) {
	TestApp* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_APP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_app_unref (old);
	}
}


static void test_app_class_init (TestAppClass * klass) {
	test_app_parent_class = g_type_class_peek_parent (klass);
	TEST_APP_CLASS (klass)->finalize = test_app_finalize;
	g_type_class_add_private (klass, sizeof (TestAppPrivate));
}


static void test_app_instance_init (TestApp * self) {
	self->priv = TEST_APP_GET_PRIVATE (self);
	self->priv->res = -1;
	self->priv->initialized = FALSE;
	self->priv->total_signals_seen = 0;
	self->ref_count = 1;
}


static void test_app_finalize (TestApp* obj) {
	TestApp * self;
	self = TEST_APP (obj);
	_g_main_loop_unref0 (self->priv->loop);
	_g_object_unref0 (self->priv->signal_con);
	_g_object_unref0 (self->priv->con);
}


GType test_app_get_type (void) {
	static volatile gsize test_app_type_id__volatile = 0;
	if (g_once_init_enter (&test_app_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_test_app_init, value_test_app_free_value, value_test_app_copy_value, value_test_app_peek_pointer, "p", value_test_app_collect_value, "p", value_test_app_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TestAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestApp), 0, (GInstanceInitFunc) test_app_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType test_app_type_id;
		test_app_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TestApp", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&test_app_type_id__volatile, test_app_type_id);
	}
	return test_app_type_id__volatile;
}


gpointer test_app_ref (gpointer instance) {
	TestApp* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void test_app_unref (gpointer instance) {
	TestApp* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEST_APP_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	TestApp* _tmp0_ = NULL;
	TestApp* app;
	gint _tmp1_;
	_tmp0_ = test_app_new ();
	app = _tmp0_;
	_tmp1_ = test_app_run (app);
	result = _tmp1_;
	_test_app_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



