/* tracker-builder.c generated by valac 0.12.0.69-6c49, the Vala compiler
 * generated from tracker-builder.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/**
 * SECTION: tracker-sparql-builder
 * @short_description: Creating insertion/update SPARQL queries.
 * @title: TrackerSparqlBuilder
 * @stability: Stable
 * @include: tracker-sparql.h
 *
 * <para>
 * #TrackerSparqlBuilder is an object what will gather a set of
 * subject/predicate/object triples, together with an optional WHERE clause,
 * in order to create a query that may be issued to tracker-store.
 * </para>
 *
 * <para>
 * When using #TrackerSparqlBuilder, note that you may append several predicates
 * for the same subject, and several objects for the same predicate.
 * </para>
 */
/**
 * TrackerSparqlBuilder:
 *
 * The <structname>TrackerSparqlBuilder</structname> object represents an
 * insertion/update SPARQL query.
 */
/**
 * tracker_sparql_builder_get_result:
 * @self: a #TrackerSparqlBuilder
 *
 * Retrieves a string representation of the constructed SPARQL query.
 *
 * Returns: the created SPARQL query. The string is contained in the
 * #TrackerSparqlBuilder object, and should not be freed by the caller.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_builder_get_length:
 * @self: a #TrackerSparqlBuilder
 *
 * Returns the number of objects added to @self.
 *
 * Returns: the number of objects contained.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_builder_get_state:
 * @self: a #TrackerSparqlBuilder
 *
 * Returns the current state of @self
 *
 * Returns: a #TrackerSparqlBuilderState defining the current state of @self
 *
 * Since: 0.10
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <float.h>
#include <math.h>


#define TRACKER_SPARQL_TYPE_BUILDER (tracker_sparql_builder_get_type ())
#define TRACKER_SPARQL_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilder))
#define TRACKER_SPARQL_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilderClass))
#define TRACKER_SPARQL_IS_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_BUILDER))
#define TRACKER_SPARQL_IS_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_BUILDER))
#define TRACKER_SPARQL_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilderClass))

typedef struct _TrackerSparqlBuilder TrackerSparqlBuilder;
typedef struct _TrackerSparqlBuilderClass TrackerSparqlBuilderClass;
typedef struct _TrackerSparqlBuilderPrivate TrackerSparqlBuilderPrivate;

#define TRACKER_SPARQL_BUILDER_TYPE_STATE (tracker_sparql_builder_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TrackerSparqlBuilder {
	GObject parent_instance;
	TrackerSparqlBuilderPrivate * priv;
};

struct _TrackerSparqlBuilderClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_BUILDER_STATE_UPDATE,
	TRACKER_SPARQL_BUILDER_STATE_INSERT,
	TRACKER_SPARQL_BUILDER_STATE_DELETE,
	TRACKER_SPARQL_BUILDER_STATE_SUBJECT,
	TRACKER_SPARQL_BUILDER_STATE_PREDICATE,
	TRACKER_SPARQL_BUILDER_STATE_OBJECT,
	TRACKER_SPARQL_BUILDER_STATE_BLANK,
	TRACKER_SPARQL_BUILDER_STATE_WHERE,
	TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT,
	TRACKER_SPARQL_BUILDER_STATE_GRAPH
} TrackerSparqlBuilderState;

struct _TrackerSparqlBuilderPrivate {
	gint _length;
	TrackerSparqlBuilderState* states;
	gint states_length1;
	gint _states_size_;
	GString* str;
};


static gpointer tracker_sparql_builder_parent_class = NULL;

GType tracker_sparql_builder_get_type (void) G_GNUC_CONST;
GType tracker_sparql_builder_state_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilderPrivate))
enum  {
	TRACKER_SPARQL_BUILDER_DUMMY_PROPERTY,
	TRACKER_SPARQL_BUILDER_RESULT,
	TRACKER_SPARQL_BUILDER_LENGTH,
	TRACKER_SPARQL_BUILDER_STATE
};
TrackerSparqlBuilder* tracker_sparql_builder_new_update (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct_update (GType object_type);
static void _vala_array_add1 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
TrackerSparqlBuilder* tracker_sparql_builder_new_embedded_insert (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct_embedded_insert (GType object_type);
static void _vala_array_add2 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
static void _vala_array_add3 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
static void _vala_array_add4 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_drop_graph (TrackerSparqlBuilder* self, const gchar* iri);
TrackerSparqlBuilderState tracker_sparql_builder_get_state (TrackerSparqlBuilder* self);
void tracker_sparql_builder_insert_open (TrackerSparqlBuilder* self, const gchar* graph);
static void _vala_array_add5 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_insert_silent_open (TrackerSparqlBuilder* self, const gchar* graph);
static void _vala_array_add6 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_insert_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_delete_open (TrackerSparqlBuilder* self, const gchar* graph);
static void _vala_array_add7 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_delete_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_graph_open (TrackerSparqlBuilder* self, const gchar* graph);
static void _vala_array_add8 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_graph_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_where_open (TrackerSparqlBuilder* self);
static void _vala_array_add9 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_where_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_subject_variable (TrackerSparqlBuilder* self, const gchar* var_name);
void tracker_sparql_builder_subject (TrackerSparqlBuilder* self, const gchar* s);
void tracker_sparql_builder_object_variable (TrackerSparqlBuilder* self, const gchar* var_name);
void tracker_sparql_builder_object (TrackerSparqlBuilder* self, const gchar* s);
void tracker_sparql_builder_subject_iri (TrackerSparqlBuilder* self, const gchar* iri);
static void _vala_array_add10 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_predicate_iri (TrackerSparqlBuilder* self, const gchar* iri);
void tracker_sparql_builder_predicate (TrackerSparqlBuilder* self, const gchar* s);
static void _vala_array_add11 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_object_iri (TrackerSparqlBuilder* self, const gchar* iri);
static void _vala_array_add12 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
gint tracker_sparql_builder_get_length (TrackerSparqlBuilder* self);
static void tracker_sparql_builder_set_length (TrackerSparqlBuilder* self, gint value);
void tracker_sparql_builder_object_string (TrackerSparqlBuilder* self, const gchar* literal);
static void _vala_array_add13 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_object_unvalidated (TrackerSparqlBuilder* self, const gchar* value);
void tracker_sparql_builder_object_boolean (TrackerSparqlBuilder* self, gboolean literal);
void tracker_sparql_builder_object_int64 (TrackerSparqlBuilder* self, gint64 literal);
void tracker_sparql_builder_object_date (TrackerSparqlBuilder* self, time_t* literal);
void tracker_sparql_builder_object_double (TrackerSparqlBuilder* self, gdouble literal);
void tracker_sparql_builder_object_blank_open (TrackerSparqlBuilder* self);
static void _vala_array_add14 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_object_blank_close (TrackerSparqlBuilder* self);
static void _vala_array_add15 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_prepend (TrackerSparqlBuilder* self, const gchar* raw);
void tracker_sparql_builder_append (TrackerSparqlBuilder* self, const gchar* raw);
TrackerSparqlBuilder* tracker_sparql_builder_new (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct (GType object_type);
const gchar* tracker_sparql_builder_get_result (TrackerSparqlBuilder* self);
static void tracker_sparql_builder_finalize (GObject* obj);
static void _vala_tracker_sparql_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_builder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * TrackerSparqlBuilderState:
 * @TRACKER_SPARQL_BUILDER_STATE_UPDATE: Builder is generating an UPDATE
 * @TRACKER_SPARQL_BUILDER_STATE_INSERT: Builder is generating an INSERT
 * @TRACKER_SPARQL_BUILDER_STATE_DELETE: Builder is generating a DELETE
 * @TRACKER_SPARQL_BUILDER_STATE_SUBJECT: Builder is generating the subject of the query
 * @TRACKER_SPARQL_BUILDER_STATE_PREDICATE: Builder is generating the predicate of the query
 * @TRACKER_SPARQL_BUILDER_STATE_OBJECT: Builder is generating the object of the query
 * @TRACKER_SPARQL_BUILDER_STATE_BLANK: Builder is generating a blank node subject
 * @TRACKER_SPARQL_BUILDER_STATE_WHERE: Builder is generating the WHERE clause contents
 * @TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT: Builder is generating an embedded INSERT
 * @TRACKER_SPARQL_BUILDER_STATE_GRAPH: Builder is generating the GRAPH clause contents
 *
 * Enumeration with the possible states of the SPARQL Builder
 */
GType tracker_sparql_builder_state_get_type (void) {
	static volatile gsize tracker_sparql_builder_state_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_builder_state_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_BUILDER_STATE_UPDATE, "TRACKER_SPARQL_BUILDER_STATE_UPDATE", "update"}, {TRACKER_SPARQL_BUILDER_STATE_INSERT, "TRACKER_SPARQL_BUILDER_STATE_INSERT", "insert"}, {TRACKER_SPARQL_BUILDER_STATE_DELETE, "TRACKER_SPARQL_BUILDER_STATE_DELETE", "delete"}, {TRACKER_SPARQL_BUILDER_STATE_SUBJECT, "TRACKER_SPARQL_BUILDER_STATE_SUBJECT", "subject"}, {TRACKER_SPARQL_BUILDER_STATE_PREDICATE, "TRACKER_SPARQL_BUILDER_STATE_PREDICATE", "predicate"}, {TRACKER_SPARQL_BUILDER_STATE_OBJECT, "TRACKER_SPARQL_BUILDER_STATE_OBJECT", "object"}, {TRACKER_SPARQL_BUILDER_STATE_BLANK, "TRACKER_SPARQL_BUILDER_STATE_BLANK", "blank"}, {TRACKER_SPARQL_BUILDER_STATE_WHERE, "TRACKER_SPARQL_BUILDER_STATE_WHERE", "where"}, {TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT, "TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT", "embedded-insert"}, {TRACKER_SPARQL_BUILDER_STATE_GRAPH, "TRACKER_SPARQL_BUILDER_STATE_GRAPH", "graph"}, {0, NULL, NULL}};
		GType tracker_sparql_builder_state_type_id;
		tracker_sparql_builder_state_type_id = g_enum_register_static ("TrackerSparqlBuilderState", values);
		g_once_init_leave (&tracker_sparql_builder_state_type_id__volatile, tracker_sparql_builder_state_type_id);
	}
	return tracker_sparql_builder_state_type_id__volatile;
}


/**
 * tracker_sparql_builder_new_update:
 *
 * Creates an empty #TrackerSparqlBuilder for an update query.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
static void _vala_array_add1 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


TrackerSparqlBuilder* tracker_sparql_builder_construct_update (GType object_type) {
	TrackerSparqlBuilder * self = NULL;
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
	_vala_array_add1 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_UPDATE);
	return self;
}


TrackerSparqlBuilder* tracker_sparql_builder_new_update (void) {
	return tracker_sparql_builder_construct_update (TRACKER_SPARQL_TYPE_BUILDER);
}


/**
 * tracker_sparql_builder_new_embedded_insert:
 *
 * Creates a #TrackerSparqlBuilder ready to be embedded in another query. In embedded
 * inserts, the subject is implied (responsibility of the embedder), so only calls to
 * append predicates and objects for the given subject are allowed.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
static void _vala_array_add2 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add3 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add4 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


TrackerSparqlBuilder* tracker_sparql_builder_construct_embedded_insert (GType object_type) {
	TrackerSparqlBuilder * self = NULL;
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
	_vala_array_add2 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT);
	_vala_array_add3 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
	_vala_array_add4 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_SUBJECT);
	return self;
}


TrackerSparqlBuilder* tracker_sparql_builder_new_embedded_insert (void) {
	return tracker_sparql_builder_construct_embedded_insert (TRACKER_SPARQL_TYPE_BUILDER);
}


/**
 * tracker_sparql_builder_drop_graph:
 * @self: a #TrackerSparqlBuilder
 * @iri: a graph name.
 *
 * Deprecated 0.10.5: There is no replacement for this API.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_drop_graph (TrackerSparqlBuilder* self, const gchar* iri) {
	TrackerSparqlBuilderState _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iri != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail (_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE);
	g_critical ("tracker-builder.vala:203: Use of DROP GRAPH is deprecated");
}


/**
 * tracker_sparql_builder_insert_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens an insertion statement.
 *
 * Since: 0.10
 */
static void _vala_array_add5 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_insert_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail (_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE);
	_vala_array_add5 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
	if (graph != NULL) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_strdup_printf ("INSERT INTO <%s> {\n", graph);
		_tmp2_ = _tmp1_;
		g_string_append (self->priv->str, _tmp2_);
		_g_free0 (_tmp2_);
	} else {
		g_string_append (self->priv->str, "INSERT {\n");
	}
}


/**
 * tracker_sparql_builder_insert_silent_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens a silent insertion statement.
 *
 * Since: 0.10
 */
static void _vala_array_add6 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_insert_silent_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail (_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE);
	_vala_array_add6 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
	if (graph != NULL) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_strdup_printf ("INSERT SILENT INTO <%s> {\n", graph);
		_tmp2_ = _tmp1_;
		g_string_append (self->priv->str, _tmp2_);
		_g_free0 (_tmp2_);
	} else {
		g_string_append (self->priv->str, "INSERT SILENT {\n");
	}
}


/**
 * tracker_sparql_builder_insert_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes an insertion statement opened with tracker_sparql_builder_insert_open().
 *
 * Since: 0.10
 */
void tracker_sparql_builder_insert_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	_tmp1_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail ((_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
	_tmp2_ = tracker_sparql_builder_get_state (self);
	if (_tmp2_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " .\n");
		self->priv->states_length1 = self->priv->states_length1 - 3;
	}
	self->priv->states_length1--;
	_tmp3_ = tracker_sparql_builder_get_state (self);
	if (_tmp3_ != TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT) {
		g_string_append (self->priv->str, "}\n");
	}
}


/**
 * tracker_sparql_builder_delete_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens a DELETE clause. Data triples may be appended in order to prepare
 * a query to delete them.
 *
 * Since: 0.10
 */
static void _vala_array_add7 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_delete_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail (_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE);
	_vala_array_add7 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_DELETE);
	if (graph != NULL) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_strdup_printf ("DELETE FROM <%s> {\n", graph);
		_tmp2_ = _tmp1_;
		g_string_append (self->priv->str, _tmp2_);
		_g_free0 (_tmp2_);
	} else {
		g_string_append (self->priv->str, "DELETE {\n");
	}
}


/**
 * tracker_sparql_builder_delete_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a DELETE clause opened through tracker_sparql_builder_delete_open().
 *
 * Since: 0.10
 */
void tracker_sparql_builder_delete_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	_tmp1_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail ((_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_DELETE) || (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
	_tmp2_ = tracker_sparql_builder_get_state (self);
	if (_tmp2_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " .\n");
		self->priv->states_length1 = self->priv->states_length1 - 3;
	}
	self->priv->states_length1--;
	g_string_append (self->priv->str, "}\n");
}


/**
 * tracker_sparql_builder_graph_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name.
 *
 * Opens a GRAPH clause within INSERT, DELETE, or WHERE.
 *
 * Since: 0.10
 */
static void _vala_array_add8 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_graph_open (TrackerSparqlBuilder* self, const gchar* graph) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (graph != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	_tmp1_ = tracker_sparql_builder_get_state (self);
	_tmp2_ = tracker_sparql_builder_get_state (self);
	_tmp3_ = tracker_sparql_builder_get_state (self);
	_tmp4_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail (((((_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_DELETE)) || (_tmp2_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_WHERE)) || (_tmp4_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH));
	_vala_array_add8 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_GRAPH);
	g_string_append_printf (self->priv->str, "GRAPH <%s> {\n", graph);
}


/**
 * tracker_sparql_builder_graph_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a GRAPH clause opened through tracker_sparql_builder_graph_open().
 *
 * Since: 0.10
 */
void tracker_sparql_builder_graph_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	_tmp1_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail ((_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH) || (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
	_tmp2_ = tracker_sparql_builder_get_state (self);
	if (_tmp2_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " .\n");
		self->priv->states_length1 = self->priv->states_length1 - 3;
	}
	self->priv->states_length1--;
	g_string_append (self->priv->str, "}\n");
}


/**
 * tracker_sparql_builder_where_open:
 * @self: a #TrackerSparqlBuilder
 *
 * Opens a WHERE clause. Data triples may be appended then to narrow the scope
 * to which the update query applies.
 *
 * Since: 0.10
 */
static void _vala_array_add9 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_where_open (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail (_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE);
	_vala_array_add9 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_WHERE);
	g_string_append (self->priv->str, "WHERE {\n");
}


/**
 * tracker_sparql_builder_where_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a WHERE clause opened through tracker_sparql_builder_where_open().
 *
 * Since: 0.10
 */
void tracker_sparql_builder_where_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	_tmp1_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail ((_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_WHERE) || (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
	_tmp2_ = tracker_sparql_builder_get_state (self);
	if (_tmp2_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " .\n");
		self->priv->states_length1 = self->priv->states_length1 - 3;
	}
	self->priv->states_length1--;
	g_string_append (self->priv->str, "}\n");
}


/**
 * tracker_sparql_builder_subject_variable:
 * @self: a #TrackerSparqlBuilder
 * @var_name: variable name, without leading '?'
 *
 * Appends a subject as a SPARQL variable, such as "?urn".
 *
 * Since: 0.10
 */
void tracker_sparql_builder_subject_variable (TrackerSparqlBuilder* self, const gchar* var_name) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (var_name != NULL);
	_tmp0_ = g_strdup_printf ("?%s", var_name);
	_tmp1_ = _tmp0_;
	tracker_sparql_builder_subject (self, _tmp1_);
	_g_free0 (_tmp1_);
}


/**
 * tracker_sparql_builder_object_variable:
 * @self: a #TrackerSparqlBuilder
 * @var_name: variable name, without leading '?'
 *
 * Appends an object as a SparQL variable, such as "?urn".
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_variable (TrackerSparqlBuilder* self, const gchar* var_name) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (var_name != NULL);
	_tmp0_ = g_strdup_printf ("?%s", var_name);
	_tmp1_ = _tmp0_;
	tracker_sparql_builder_object (self, _tmp1_);
	_g_free0 (_tmp1_);
}


/**
 * tracker_sparql_builder_subject_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends a subject as an IRI, such as "&lt;urn:file:1234-5678&gt;". IRIs
 * univocally identify a resource in tracker-store.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_subject_iri (TrackerSparqlBuilder* self, const gchar* iri) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iri != NULL);
	_tmp0_ = g_strdup_printf ("<%s>", iri);
	_tmp1_ = _tmp0_;
	tracker_sparql_builder_subject (self, _tmp1_);
	_g_free0 (_tmp1_);
}


/**
 * tracker_sparql_builder_subject:
 * @self: a #TrackerSparqlBuilder
 * @s: subject string
 *
 * Appends a subject.
 *
 * Since: 0.10
 */
static void _vala_array_add10 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_subject (TrackerSparqlBuilder* self, const gchar* s) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	TrackerSparqlBuilderState _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	_tmp1_ = tracker_sparql_builder_get_state (self);
	_tmp2_ = tracker_sparql_builder_get_state (self);
	_tmp3_ = tracker_sparql_builder_get_state (self);
	_tmp4_ = tracker_sparql_builder_get_state (self);
	_tmp5_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail ((((((_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp2_ == TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT)) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_DELETE)) || (_tmp4_ == TRACKER_SPARQL_BUILDER_STATE_WHERE)) || (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH));
	_tmp6_ = tracker_sparql_builder_get_state (self);
	if (_tmp6_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " .\n");
		self->priv->states_length1 = self->priv->states_length1 - 3;
	}
	g_string_append (self->priv->str, s);
	_vala_array_add10 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_SUBJECT);
}


/**
 * tracker_sparql_builder_predicate_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends a predicate as an IRI.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_predicate_iri (TrackerSparqlBuilder* self, const gchar* iri) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iri != NULL);
	_tmp0_ = g_strdup_printf ("<%s>", iri);
	_tmp1_ = _tmp0_;
	tracker_sparql_builder_predicate (self, _tmp1_);
	_g_free0 (_tmp1_);
}


/**
 * tracker_sparql_builder_predicate:
 * @self: a #TrackerSparqlBuilder
 * @s: predicate string
 *
 * Appends a predicate for the previously appended subject.
 *
 * Since: 0.10
 */
static void _vala_array_add11 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_predicate (TrackerSparqlBuilder* self, const gchar* s) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	_tmp1_ = tracker_sparql_builder_get_state (self);
	_tmp2_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail (((_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_SUBJECT) || (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp2_ == TRACKER_SPARQL_BUILDER_STATE_BLANK));
	_tmp3_ = tracker_sparql_builder_get_state (self);
	if (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " ;\n\t");
		self->priv->states_length1 = self->priv->states_length1 - 2;
	}
	g_string_append (self->priv->str, " ");
	g_string_append (self->priv->str, s);
	_vala_array_add11 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_PREDICATE);
}


/**
 * tracker_sparql_builder_object_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends an object as an IRI.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_iri (TrackerSparqlBuilder* self, const gchar* iri) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iri != NULL);
	_tmp0_ = g_strdup_printf ("<%s>", iri);
	_tmp1_ = _tmp0_;
	tracker_sparql_builder_object (self, _tmp1_);
	_g_free0 (_tmp1_);
}


/**
 * tracker_sparql_builder_object:
 * @self: a #TrackerSparqlBuilder
 * @s: object string
 *
 * Appends a free-form object for the previously appended subject and predicate.
 *
 * Since: 0.10
 */
static void _vala_array_add12 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_object (TrackerSparqlBuilder* self, const gchar* s) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	_tmp1_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail ((_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
	_tmp2_ = tracker_sparql_builder_get_state (self);
	if (_tmp2_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " ,");
		self->priv->states_length1--;
	}
	g_string_append (self->priv->str, " ");
	g_string_append (self->priv->str, s);
	_vala_array_add12 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
	_tmp3_ = self->priv->_length;
	tracker_sparql_builder_set_length (self, _tmp3_ + 1);
}


/**
 * tracker_sparql_builder_object_string:
 * @self: a #TrackerSparqlBuilder
 * @literal: string object
 *
 * Appends an object formatted as an string. @literal will be escaped and surrounded
 * by double quotes.
 *
 * Since: 0.10
 */
static void _vala_array_add13 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_object_string (TrackerSparqlBuilder* self, const gchar* literal) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	gchar* p;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (literal != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	_tmp1_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail ((_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
	_tmp2_ = tracker_sparql_builder_get_state (self);
	if (_tmp2_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " ,");
		self->priv->states_length1--;
	}
	g_string_append (self->priv->str, " \"");
	p = literal;
	while (TRUE) {
		gsize _tmp3_;
		gsize len;
		if (!((*p) != '\0')) {
			break;
		}
		_tmp3_ = strcspn ((const gchar*) p, "\t\n\r\"\\");
		len = _tmp3_;
		g_string_append_len (self->priv->str, (const gchar*) p, (gssize) ((glong) len));
		p = p + len;
		switch (*p) {
			case '\t':
			{
				g_string_append (self->priv->str, "\\t");
				break;
			}
			case '\n':
			{
				g_string_append (self->priv->str, "\\n");
				break;
			}
			case '\r':
			{
				g_string_append (self->priv->str, "\\r");
				break;
			}
			case '"':
			{
				g_string_append (self->priv->str, "\\\"");
				break;
			}
			case '\\':
			{
				g_string_append (self->priv->str, "\\\\");
				break;
			}
			default:
			{
				continue;
			}
		}
		p++;
	}
	g_string_append (self->priv->str, "\"");
	_vala_array_add13 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
	_tmp4_ = self->priv->_length;
	tracker_sparql_builder_set_length (self, _tmp4_ + 1);
}


/**
 * tracker_sparql_builder_object_unvalidated:
 * @self: a #TrackerSparqlBuilder
 * @value: possibly UTF-8 invalid string.
 *
 * Appends a string not validated as UTF-8 as an object.
 *
 * Since: 0.10
 */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


void tracker_sparql_builder_object_unvalidated (TrackerSparqlBuilder* self, const gchar* value) {
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp1_ = g_utf8_validate (value, (gssize) (-1), &_tmp0_);
	end = _tmp0_;
	if (!_tmp1_) {
		if (value != end) {
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			_tmp2_ = string_substring (value, (glong) 0, (glong) (end - ((gchar*) value)));
			_tmp3_ = _tmp2_;
			tracker_sparql_builder_object_string (self, _tmp3_);
			_g_free0 (_tmp3_);
		} else {
			tracker_sparql_builder_object_string (self, "(invalid data)");
		}
		return;
	}
	tracker_sparql_builder_object_string (self, value);
}


/**
 * tracker_sparql_builder_object_boolean:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gboolean
 *
 * Appends a #gboolean value as an object.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_boolean (TrackerSparqlBuilder* self, gboolean literal) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (literal) {
		_tmp0_ = "true";
	} else {
		_tmp0_ = "false";
	}
	tracker_sparql_builder_object (self, _tmp0_);
}


/**
 * tracker_sparql_builder_object_int64:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gint64
 *
 * Appends a #gint64 value as an object.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_object_int64 (TrackerSparqlBuilder* self, gint64 literal) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, literal);
	_tmp1_ = _tmp0_;
	tracker_sparql_builder_object (self, _tmp1_);
	_g_free0 (_tmp1_);
}


/**
 * tracker_sparql_builder_object_date:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #time_t
 *
 * Appends a #time_t value as an object. @literal will be converted
 * to a string in the date format used by tracker-store.
 *
 * Since: 0.10
 */
static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	gmtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


void tracker_sparql_builder_object_date (TrackerSparqlBuilder* self, time_t* literal) {
	struct tm _tmp0_ = {0};
	struct tm _tmp1_ = {0};
	struct tm tm;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_time_gm (*literal, &_tmp0_);
	_tmp1_ = _tmp0_;
	tm = _tmp1_;
	_tmp2_ = g_strdup_printf ("%04d-%02d-%02dT%02d:%02d:%02dZ", tm.tm_year + 1900, tm.tm_mon + 1, tm.tm_mday, tm.tm_hour, tm.tm_min, tm.tm_sec);
	_tmp3_ = _tmp2_;
	tracker_sparql_builder_object_string (self, _tmp3_);
	_g_free0 (_tmp3_);
}


/**
 * tracker_sparql_builder_object_double:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gdouble
 *
 * Appends a #gdouble value as an object.
 *
 * Since: 0.10
 */
static gchar* double_to_string (gdouble self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}


void tracker_sparql_builder_object_double (TrackerSparqlBuilder* self, gdouble literal) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = double_to_string (literal);
	_tmp1_ = _tmp0_;
	tracker_sparql_builder_object (self, _tmp1_);
	_g_free0 (_tmp1_);
}


/**
 * tracker_sparql_builder_object_blank_open:
 * @self: a #TrackerSparqlBuilder
 *
 * Opens an anonymous blank node. In insertions this can be used to create
 * anonymous nodes for not previously known data without the need of a
 * separate insertion.
 *
 * Since: 0.10
 */
static void _vala_array_add14 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_object_blank_open (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	_tmp1_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail ((_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
	_tmp2_ = tracker_sparql_builder_get_state (self);
	if (_tmp2_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " ,");
		self->priv->states_length1--;
	}
	g_string_append (self->priv->str, " [");
	_vala_array_add14 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_BLANK);
}


/**
 * tracker_sparql_builder_object_blank_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes an anomymous blank node opened with tracker_sparql_builder_object_blank_open()
 *
 * Since: 0.10
 */
static void _vala_array_add15 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_object_blank_close (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	_tmp1_ = tracker_sparql_builder_get_state (self);
	g_return_if_fail ((_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) && (self->priv->states[self->priv->states_length1 - 3] == TRACKER_SPARQL_BUILDER_STATE_BLANK));
	g_string_append (self->priv->str, "]");
	self->priv->states_length1 = self->priv->states_length1 - 3;
	_vala_array_add15 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
	_tmp2_ = self->priv->_length;
	tracker_sparql_builder_set_length (self, _tmp2_ + 1);
}


/**
 * tracker_sparql_builder_prepend:
 * @self: a #TrackerSparqlBuilder
 * @raw: raw content to prepend.
 *
 * Prepends raw, unvalidated content to @self.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_prepend (TrackerSparqlBuilder* self, const gchar* raw) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (raw != NULL);
	_tmp0_ = g_strdup_printf ("%s\n", raw);
	_tmp1_ = _tmp0_;
	g_string_prepend (self->priv->str, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->_length;
	tracker_sparql_builder_set_length (self, _tmp2_ + 1);
}


/**
 * tracker_sparql_builder_append:
 * @self: a #TrackerSparqlBuilder
 * @raw: raw content to append.
 *
 * Appends raw, unvalidated content to @self.
 *
 * Since: 0.10
 */
void tracker_sparql_builder_append (TrackerSparqlBuilder* self, const gchar* raw) {
	TrackerSparqlBuilderState _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (raw != NULL);
	_tmp0_ = tracker_sparql_builder_get_state (self);
	if (_tmp0_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " .\n");
		self->priv->states_length1 = self->priv->states_length1 - 3;
	}
	g_string_append (self->priv->str, raw);
	_tmp1_ = self->priv->_length;
	tracker_sparql_builder_set_length (self, _tmp1_ + 1);
}


TrackerSparqlBuilder* tracker_sparql_builder_construct (GType object_type) {
	TrackerSparqlBuilder * self = NULL;
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
	return self;
}


TrackerSparqlBuilder* tracker_sparql_builder_new (void) {
	return tracker_sparql_builder_construct (TRACKER_SPARQL_TYPE_BUILDER);
}


const gchar* tracker_sparql_builder_get_result (TrackerSparqlBuilder* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_warn_if_fail (self->priv->states_length1 == 1);
	result = self->priv->str->str;
	return result;
}


gint tracker_sparql_builder_get_length (TrackerSparqlBuilder* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_length;
	return result;
}


static void tracker_sparql_builder_set_length (TrackerSparqlBuilder* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_length = value;
	g_object_notify ((GObject *) self, "length");
}


TrackerSparqlBuilderState tracker_sparql_builder_get_state (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->states[self->priv->states_length1 - 1];
	return result;
}


static void tracker_sparql_builder_class_init (TrackerSparqlBuilderClass * klass) {
	tracker_sparql_builder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlBuilderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_builder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_builder_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_builder_finalize;
	/**
	 * TrackerSparqlBuilder:result:
	 *
	 * String containing the constructed SPARQL in the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_RESULT, g_param_spec_string ("result", "result", "result", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * TrackerSparqlBuilder:length:
	 *
	 * Number of objects added to the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_LENGTH, g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * TrackerSparqlBuilder:state:
	 *
	 * Current state of the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_STATE, g_param_spec_enum ("state", "state", "state", TRACKER_SPARQL_BUILDER_TYPE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void tracker_sparql_builder_instance_init (TrackerSparqlBuilder * self) {
	GString* _tmp0_ = NULL;
	self->priv = TRACKER_SPARQL_BUILDER_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->priv->str = _tmp0_;
}


static void tracker_sparql_builder_finalize (GObject* obj) {
	TrackerSparqlBuilder * self;
	self = TRACKER_SPARQL_BUILDER (obj);
	self->priv->states = (g_free (self->priv->states), NULL);
	_g_string_free0 (self->priv->str);
	G_OBJECT_CLASS (tracker_sparql_builder_parent_class)->finalize (obj);
}


/**
 * tracker_sparql_builder_new:
 *
 * Creates a stateless #TrackerSparqlBuilder.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
GType tracker_sparql_builder_get_type (void) {
	static volatile gsize tracker_sparql_builder_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_builder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlBuilder), 0, (GInstanceInitFunc) tracker_sparql_builder_instance_init, NULL };
		GType tracker_sparql_builder_type_id;
		tracker_sparql_builder_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlBuilder", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_builder_type_id__volatile, tracker_sparql_builder_type_id);
	}
	return tracker_sparql_builder_type_id__volatile;
}


static void _vala_tracker_sparql_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlBuilder * self;
	self = TRACKER_SPARQL_BUILDER (object);
	switch (property_id) {
		case TRACKER_SPARQL_BUILDER_RESULT:
		g_value_set_string (value, tracker_sparql_builder_get_result (self));
		break;
		case TRACKER_SPARQL_BUILDER_LENGTH:
		g_value_set_int (value, tracker_sparql_builder_get_length (self));
		break;
		case TRACKER_SPARQL_BUILDER_STATE:
		g_value_set_enum (value, tracker_sparql_builder_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tracker_sparql_builder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlBuilder * self;
	self = TRACKER_SPARQL_BUILDER (object);
	switch (property_id) {
		case TRACKER_SPARQL_BUILDER_LENGTH:
		tracker_sparql_builder_set_length (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



