/* tracker-connection.c generated by valac 0.12.0.69-6c49, the Vala compiler
 * generated from tracker-connection.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/**
 * tracker_sparql_connection_get_finish:
 * @_res_: The #GAsyncResult from the callback used to return the #TrackerSparqlConnection
 * @error: The error which occurred or %NULL
 *
 * This function is called from the callback provided for
 * tracker_sparql_connection_get_async() to return the connection requested
 * or an error in cases of failure.
 *
 * Returns: a new #TrackerSparqlConnection. Call g_object_unref() on the
 * object when no longer used.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_get_direct_finish:
 * @_res_: The #GAsyncResult from the callback used to return the #TrackerSparqlConnection
 * @error: The error which occurred or %NULL
 *
 * This function is called from the callback provided for
 * tracker_sparql_connection_get_direct_async() to return the connection
 * requested or an error in cases of failure.
 *
 * Returns: a new #TrackerSparqlConnection. Call g_object_unref() on the
 * object when no longer used.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_query_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous SPARQL query operation.
 *
 * Returns: a #TrackerSparqlCursor if results were found, #NULL otherwise.
 * On error, #NULL is returned and the @error is set accordingly.
 * Call g_object_unref() on the returned cursor when no longer needed.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_update_async:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the asynchronous operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Executes asynchronously a SPARQL update.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_update_array_async:
 * @self: a #TrackerSparqlConnection
 * @sparql: an array of strings containing the SPARQL update queries
 * @sparql_length1: the amount of strings you pass as @sparql
 * @priority: the priority for the asynchronous operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Executes asynchronously an array of SPARQL updates. Each update in the
 * array is its own transaction. This means that update n+1 is not halted
 * due to an error in update n.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_update_blank_async:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the asynchronous operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Executes asynchronously a SPARQL update.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_load_async:
 * @self: a #TrackerSparqlConnection
 * @file: a #GFile
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Loads, asynchronously, a Turtle file (TTL) into the store.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_statistics_async:
 * @self: a #TrackerSparqlConnection
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Retrieves, asynchronously, the statistics from the Store.
 *
 * Since: 0.10
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TRACKER_SPARQL_TYPE_CONNECTION (tracker_sparql_connection_get_type ())
#define TRACKER_SPARQL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection))
#define TRACKER_SPARQL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnectionClass))
#define TRACKER_SPARQL_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONNECTION))
#define TRACKER_SPARQL_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONNECTION))
#define TRACKER_SPARQL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnectionClass))

typedef struct _TrackerSparqlConnection TrackerSparqlConnection;
typedef struct _TrackerSparqlConnectionClass TrackerSparqlConnectionClass;
typedef struct _TrackerSparqlConnectionPrivate TrackerSparqlConnectionPrivate;

#define TRACKER_SPARQL_TYPE_CURSOR (tracker_sparql_cursor_get_type ())
#define TRACKER_SPARQL_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursor))
#define TRACKER_SPARQL_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorClass))
#define TRACKER_SPARQL_IS_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CURSOR))
#define TRACKER_SPARQL_IS_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CURSOR))
#define TRACKER_SPARQL_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorClass))

typedef struct _TrackerSparqlCursor TrackerSparqlCursor;
typedef struct _TrackerSparqlCursorClass TrackerSparqlCursorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TrackerSparqlConnectionUpdateAsyncData TrackerSparqlConnectionUpdateAsyncData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TrackerSparqlConnectionUpdateArrayAsyncData TrackerSparqlConnectionUpdateArrayAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerSparqlConnectionUpdateBlankAsyncData TrackerSparqlConnectionUpdateBlankAsyncData;
typedef struct _TrackerSparqlConnectionLoadAsyncData TrackerSparqlConnectionLoadAsyncData;
typedef struct _TrackerSparqlConnectionStatisticsAsyncData TrackerSparqlConnectionStatisticsAsyncData;

typedef enum  {
	TRACKER_SPARQL_ERROR_PARSE,
	TRACKER_SPARQL_ERROR_UNKNOWN_CLASS,
	TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY,
	TRACKER_SPARQL_ERROR_TYPE,
	TRACKER_SPARQL_ERROR_CONSTRAINT,
	TRACKER_SPARQL_ERROR_NO_SPACE,
	TRACKER_SPARQL_ERROR_INTERNAL,
	TRACKER_SPARQL_ERROR_UNSUPPORTED
} TrackerSparqlError;
#define TRACKER_SPARQL_ERROR tracker_sparql_error_quark ()
struct _TrackerSparqlConnection {
	GObject parent_instance;
	TrackerSparqlConnectionPrivate * priv;
};

struct _TrackerSparqlConnectionClass {
	GObjectClass parent_class;
	TrackerSparqlCursor* (*query) (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error);
	void (*query_async) (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	TrackerSparqlCursor* (*query_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*update) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
	void (*update_async) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*update_array_async) (TrackerSparqlConnection* self, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GPtrArray* (*update_array_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	GVariant* (*update_blank) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
	void (*update_blank_async) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GVariant* (*update_blank_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*load) (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
	void (*load_async) (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*load_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	TrackerSparqlCursor* (*statistics) (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
	void (*statistics_async) (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	TrackerSparqlCursor* (*statistics_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
};

struct _TrackerSparqlConnectionUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlConnection* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
};

struct _TrackerSparqlConnectionUpdateArrayAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlConnection* self;
	gchar** sparql;
	gint sparql_length1;
	gint priority;
	GCancellable* cancellable;
	GPtrArray* result;
};

struct _TrackerSparqlConnectionUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlConnection* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
};

struct _TrackerSparqlConnectionLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlConnection* self;
	GFile* file;
	GCancellable* cancellable;
};

struct _TrackerSparqlConnectionStatisticsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlConnection* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
};


static gpointer tracker_sparql_connection_parent_class = NULL;

#define TRACKER_DBUS_SERVICE "org.freedesktop.Tracker1"
#define TRACKER_DBUS_INTERFACE_RESOURCES TRACKER_DBUS_SERVICE ".Resources"
#define TRACKER_DBUS_OBJECT_RESOURCES "/org/freedesktop/Tracker1/Resources"
#define TRACKER_DBUS_INTERFACE_STATISTICS TRACKER_DBUS_SERVICE ".Statistics"
#define TRACKER_DBUS_OBJECT_STATISTICS "/org/freedesktop/Tracker1/Statistics"
#define TRACKER_DBUS_INTERFACE_STATUS TRACKER_DBUS_SERVICE ".Status"
#define TRACKER_DBUS_OBJECT_STATUS "/org/freedesktop/Tracker1/Status"
#define TRACKER_DBUS_INTERFACE_STEROIDS TRACKER_DBUS_SERVICE ".Steroids"
#define TRACKER_DBUS_OBJECT_STEROIDS "/org/freedesktop/Tracker1/Steroids"
GQuark tracker_sparql_error_quark (void);
GType tracker_sparql_connection_get_type (void) G_GNUC_CONST;
GType tracker_sparql_cursor_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_CONNECTION_DUMMY_PROPERTY
};
void tracker_sparql_connection_get_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get_finish (GAsyncResult* _res_, GError** error);
TrackerSparqlConnection* tracker_sparql_connection_get (GCancellable* cancellable, GError** error);
void tracker_sparql_connection_get_direct_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get_direct_finish (GAsyncResult* _res_, GError** error);
TrackerSparqlConnection* tracker_sparql_connection_get_direct (GCancellable* cancellable, GError** error);
TrackerSparqlCursor* tracker_sparql_connection_query (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error);
static TrackerSparqlCursor* tracker_sparql_connection_real_query (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error);
void tracker_sparql_connection_query_async (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_sparql_connection_query_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
void tracker_sparql_connection_update (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_update (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_update_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_update_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_update_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_update_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_real_update_async_co (TrackerSparqlConnectionUpdateAsyncData* data);
static void tracker_sparql_connection_real_update_array_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_update_array_async (TrackerSparqlConnection* self, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** _vala_array_dup1 (gchar** self, int length);
void tracker_sparql_connection_update_array_async (TrackerSparqlConnection* self, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GPtrArray* tracker_sparql_connection_update_array_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_real_update_array_async_co (TrackerSparqlConnectionUpdateArrayAsyncData* data);
GVariant* tracker_sparql_connection_update_blank (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static GVariant* tracker_sparql_connection_real_update_blank (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_update_blank_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_update_blank_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_update_blank_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_sparql_connection_update_blank_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_real_update_blank_async_co (TrackerSparqlConnectionUpdateBlankAsyncData* data);
void tracker_sparql_connection_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_load_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_load_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_real_load_async_co (TrackerSparqlConnectionLoadAsyncData* data);
TrackerSparqlCursor* tracker_sparql_connection_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
static TrackerSparqlCursor* tracker_sparql_connection_real_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_statistics_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_sparql_connection_statistics_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_real_statistics_async_co (TrackerSparqlConnectionStatisticsAsyncData* data);
TrackerSparqlConnection* tracker_sparql_connection_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusErrorEntry tracker_sparql_error_entries[] = {{TRACKER_SPARQL_ERROR_PARSE, "org.freedesktop.Tracker1.SparqlError.Parse"}, {TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, "org.freedesktop.Tracker1.SparqlError.UnknownClass"}, {TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY, "org.freedesktop.Tracker1.SparqlError.UnknownProperty"}, {TRACKER_SPARQL_ERROR_TYPE, "org.freedesktop.Tracker1.SparqlError.Type"}, {TRACKER_SPARQL_ERROR_CONSTRAINT, "org.freedesktop.Tracker1.SparqlError.Constraint"}, {TRACKER_SPARQL_ERROR_NO_SPACE, "org.freedesktop.Tracker1.SparqlError.NoSpace"}, {TRACKER_SPARQL_ERROR_INTERNAL, "org.freedesktop.Tracker1.SparqlError.Internal"}, {TRACKER_SPARQL_ERROR_UNSUPPORTED, "org.freedesktop.Tracker1.SparqlError.Unsupported"}};

GQuark tracker_sparql_error_quark (void) {
	static volatile gsize tracker_sparql_error_quark_volatile = 0;
	g_dbus_error_register_error_domain ("tracker_sparql_error-quark", &tracker_sparql_error_quark_volatile, tracker_sparql_error_entries, G_N_ELEMENTS (tracker_sparql_error_entries));
	return (GQuark) tracker_sparql_error_quark_volatile;
}


/**
 * tracker_sparql_connection_get:
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * This function is used to give the caller a connection to Tracker they can
 * use for future requests. The best backend available to connect to
 * Tracker is returned. These backends include direct-access (for read-only
 * queries) and D-Bus (for both read and write queries).
 *
 * You can use <link linkend="tracker-overview-environment-variables">
 * environment variables</link> to influence how backends are used. If
 * no environment variables are provided, both backends are loaded and
 * chosen based on their merits. If you try to force a backend for a query
 * which it won't support (i.e. an update for a read-only backend), you will
 * see critical warnings.
 *
 * When calling either tracker_sparql_connection_get(),
 * tracker_sparql_connection_get_direct() or the asynchronous variants of
 * these functions, a mutex is used to protect the loading of backends
 * against potential race conditions. For synchronous calls, this function
 * will always block if a previous connection get method has been called.
 *
 * All backends will call the D-Bus tracker-store API Wait() to make sure
 * the store and databases are in the right state before any user based
 * requests can proceed. There may be a small delay during this call if the
 * databases weren't shutdown cleanly and need to be checked on start up. If
 * the journal needs to be replayed in such an event, the delay may be
 * substantial while data is restored as best as possible.
 *
 * Returns: a new #TrackerSparqlConnection. Call g_object_unref() on the
 * object when no longer used.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_get_direct:
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * This behaves the same way tracker_sparql_connection_get() does, however,
 * the #TrackerSparqlConnection can only be used for read-only requests.
 * The advantage to this API over the tracker_sparql_connection_get()
 * function is that it will use direct-access. This is faster than using
 * D-Bus which may be the case with tracker_sparql_connection_get().
 *
 * Returns: a new #TrackerSparqlConnection. Call g_object_unref() on the
 * object when no longer used.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_query:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL query
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Executes a SPARQL query on. The API call is completely synchronous, so
 * it may block.
 *
 * Returns: a #TrackerSparqlCursor if results were found, #NULL otherwise.
 * On error, #NULL is returned and the @error is set accordingly.
 * Call g_object_unref() on the returned cursor when no longer needed.
 *
 * Since: 0.10
 */
static TrackerSparqlCursor* tracker_sparql_connection_real_query (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_connection_query'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


TrackerSparqlCursor* tracker_sparql_connection_query (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error) {
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->query (self, sparql, cancellable, error);
}


void tracker_sparql_connection_query_async (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->query_async (self, sparql, cancellable, _callback_, _user_data_);
}


TrackerSparqlCursor* tracker_sparql_connection_query_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->query_finish (self, _res_, error);
}


/**
 * tracker_sparql_connection_update:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Executes a SPARQL update. The API call is completely
 * synchronous, so it may block.
 *
 * Since: 0.10
 */
static void tracker_sparql_connection_real_update (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sparql != NULL);
	g_warning ("tracker-connection.vala:265: Interface 'update' not implemented");
}


void tracker_sparql_connection_update (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update (self, sparql, priority, cancellable, error);
}


static void tracker_sparql_connection_real_update_async_data_free (gpointer _data) {
	TrackerSparqlConnectionUpdateAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlConnectionUpdateAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tracker_sparql_connection_real_update_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionUpdateAsyncData* _data_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionUpdateAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_connection_real_update_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_real_update_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_connection_real_update_async_co (_data_);
}


static void tracker_sparql_connection_real_update_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnectionUpdateAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
 * tracker_sparql_connection_update_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous SPARQL update operation.
 *
 * Since: 0.10
 */
static gboolean tracker_sparql_connection_real_update_async_co (TrackerSparqlConnectionUpdateAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_warning ("tracker-connection.vala:294: Interface 'update_async' not implemented");
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void tracker_sparql_connection_update_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_async (self, sparql, priority, cancellable, _callback_, _user_data_);
}


void tracker_sparql_connection_update_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_finish (self, _res_, error);
}


static void tracker_sparql_connection_real_update_array_async_data_free (gpointer _data) {
	TrackerSparqlConnectionUpdateArrayAsyncData* data;
	data = _data;
	data->sparql = (_vala_array_free (data->sparql, data->sparql_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->cancellable);
	_g_ptr_array_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlConnectionUpdateArrayAsyncData, data);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void tracker_sparql_connection_real_update_array_async (TrackerSparqlConnection* self, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionUpdateArrayAsyncData* _data_;
	gchar** _tmp0_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionUpdateArrayAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_connection_real_update_array_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_real_update_array_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = (_tmp0_ = sparql, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup1 (_tmp0_, sparql_length1));
	_data_->sparql_length1 = sparql_length1;
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_connection_real_update_array_async_co (_data_);
}


static GPtrArray* tracker_sparql_connection_real_update_array_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	GPtrArray* result;
	TrackerSparqlConnectionUpdateArrayAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
 * tracker_sparql_connection_update_array_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous SPARQL update_array operation.
 *
 * <example>
 * <programlisting>
 * static void
 * async_update_array_callback (GObject      *source_object,
 *                              GAsyncResult *result,
 *                              gpointer      user_data)
 * {
 *     GError *error = NULL;
 *     GPtrArray *errors;
 *     guint i;
 *
 *     errors = tracker_sparql_connection_update_array_finish (connection, result, &error);
 *     g_assert_no_error (error);
 *
 *     for (i = 0; i < errors->len; i++) {
 *         const GError *e = g_ptr_array_index (errors, i);
 *
 *         ...
 *     }
 *
 *     g_ptr_array_unref (errors);
 * }
 * </programlisting>
 * </example>
 *
 * Returns: a #GPtrArray of size @sparql_length1 with elements that are
 * either NULL or a GError instance. The returned array should be freed with
 * g_ptr_array_unref when no longer used, not with g_ptr_array_free. When
 * you use errors of the array, you must g_error_copy them. Errors inside of
 * the array must be considered as const data and not freed. The index of
 * the error corresponds to the index of the update query in the array that
 * you passed to tracker_sparql_connection_update_array_async.
 *
 * Since: 0.10
 */
static gboolean tracker_sparql_connection_real_update_array_async_co (TrackerSparqlConnectionUpdateArrayAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_warning ("tracker-connection.vala:359: Interface 'update_array_async' not implem" \
"ented");
	data->result = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void tracker_sparql_connection_update_array_async (TrackerSparqlConnection* self, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_array_async (self, sparql, sparql_length1, priority, cancellable, _callback_, _user_data_);
}


GPtrArray* tracker_sparql_connection_update_array_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_array_finish (self, _res_, error);
}


/**
 * tracker_sparql_connection_update_blank:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Executes a SPARQL update and returns the URNs of the generated nodes,
 * if any. The API call is completely synchronous, so it may block.
 *
 * Returns: a #GVariant with the generated URNs, which should be freed with
 * g_variant_unref() when no longer used.
 *
 * Since: 0.10
 */
static GVariant* tracker_sparql_connection_real_update_blank (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	GVariant* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sparql != NULL, NULL);
	g_warning ("tracker-connection.vala:380: Interface 'update_blank' not implemented");
	result = NULL;
	return result;
}


GVariant* tracker_sparql_connection_update_blank (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_blank (self, sparql, priority, cancellable, error);
}


static void tracker_sparql_connection_real_update_blank_async_data_free (gpointer _data) {
	TrackerSparqlConnectionUpdateBlankAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_variant_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlConnectionUpdateBlankAsyncData, data);
}


static void tracker_sparql_connection_real_update_blank_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionUpdateBlankAsyncData* _data_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionUpdateBlankAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_connection_real_update_blank_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_real_update_blank_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_connection_real_update_blank_async_co (_data_);
}


static GVariant* tracker_sparql_connection_real_update_blank_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerSparqlConnectionUpdateBlankAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
 * tracker_sparql_connection_update_blank_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous SPARQL update operation, and returns
 * the URNs of the generated nodes, if any.
 *
 * Returns: a #GVariant with the generated URNs, which should be freed with
 * g_variant_unref() when no longer used.
 *
 * Since: 0.10
 */
static gboolean tracker_sparql_connection_real_update_blank_async_co (TrackerSparqlConnectionUpdateBlankAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_warning ("tracker-connection.vala:414: Interface 'update_blank_async' not implem" \
"ented");
	data->result = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void tracker_sparql_connection_update_blank_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_blank_async (self, sparql, priority, cancellable, _callback_, _user_data_);
}


GVariant* tracker_sparql_connection_update_blank_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_blank_finish (self, _res_, error);
}


/**
 * tracker_sparql_connection_load:
 * @self: a #TrackerSparqlConnection
 * @file: a #GFile
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Loads a Turtle file (TTL) into the store. The API call is completely
 * synchronous, so it may block.
 *
 * Since: 0.10
 */
static void tracker_sparql_connection_real_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_warning ("tracker-connection.vala:431: Interface 'load' not implemented");
}


void tracker_sparql_connection_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->load (self, file, cancellable, error);
}


static void tracker_sparql_connection_real_load_async_data_free (gpointer _data) {
	TrackerSparqlConnectionLoadAsyncData* data;
	data = _data;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlConnectionLoadAsyncData, data);
}


static void tracker_sparql_connection_real_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionLoadAsyncData* _data_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionLoadAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_connection_real_load_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_real_load_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->file = _g_object_ref0 (file);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_connection_real_load_async_co (_data_);
}


static void tracker_sparql_connection_real_load_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnectionLoadAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
 * tracker_sparql_connection_load_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous load of the Turtle file.
 *
 * Since: 0.10
 */
static gboolean tracker_sparql_connection_real_load_async_co (TrackerSparqlConnectionLoadAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_warning ("tracker-connection.vala:459: Interface 'load_async' not implemented");
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void tracker_sparql_connection_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->load_async (self, file, cancellable, _callback_, _user_data_);
}


void tracker_sparql_connection_load_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->load_finish (self, _res_, error);
}


/**
 * tracker_sparql_connection_statistics:
 * @self: a #TrackerSparqlConnection
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Retrieves the statistics from the Store. The API call is completely
 * synchronous, so it may block.
 *
 * Returns: a #TrackerSparqlCursor to iterate the reply if successful, #NULL
 * on error. Call g_object_unref() on the returned cursor when no longer
 * needed.
 *
 * Since: 0.10
 */
static TrackerSparqlCursor* tracker_sparql_connection_real_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error) {
	TrackerSparqlCursor* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_warning ("tracker-connection.vala:478: Interface 'statistics' not implemented");
	result = NULL;
	return result;
}


TrackerSparqlCursor* tracker_sparql_connection_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error) {
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->statistics (self, cancellable, error);
}


static void tracker_sparql_connection_real_statistics_async_data_free (gpointer _data) {
	TrackerSparqlConnectionStatisticsAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlConnectionStatisticsAsyncData, data);
}


static void tracker_sparql_connection_real_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionStatisticsAsyncData* _data_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionStatisticsAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_connection_real_statistics_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_real_statistics_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_connection_real_statistics_async_co (_data_);
}


static TrackerSparqlCursor* tracker_sparql_connection_real_statistics_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlConnectionStatisticsAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
 * tracker_sparql_connection_statistics_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous retrieval of statistics from the Store.
 *
 * Returns: a #TrackerSparqlCursor to iterate the reply if successful, #NULL
 * on error. Call g_object_unref() on the returned cursor when no longer
 * needed.
 *
 * Since: 0.10
 */
static gboolean tracker_sparql_connection_real_statistics_async_co (TrackerSparqlConnectionStatisticsAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_warning ("tracker-connection.vala:510: Interface 'statistics_async' not implemen" \
"ted");
	data->result = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void tracker_sparql_connection_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->statistics_async (self, cancellable, _callback_, _user_data_);
}


TrackerSparqlCursor* tracker_sparql_connection_statistics_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->statistics_finish (self, _res_, error);
}


TrackerSparqlConnection* tracker_sparql_connection_construct (GType object_type) {
	TrackerSparqlConnection * self = NULL;
	self = (TrackerSparqlConnection*) g_object_new (object_type, NULL);
	return self;
}


static void tracker_sparql_connection_class_init (TrackerSparqlConnectionClass * klass) {
	tracker_sparql_connection_parent_class = g_type_class_peek_parent (klass);
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query = tracker_sparql_connection_real_query;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update = tracker_sparql_connection_real_update;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_async = tracker_sparql_connection_real_update_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_finish = tracker_sparql_connection_real_update_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_array_async = tracker_sparql_connection_real_update_array_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_array_finish = tracker_sparql_connection_real_update_array_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank = tracker_sparql_connection_real_update_blank;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_async = tracker_sparql_connection_real_update_blank_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_finish = tracker_sparql_connection_real_update_blank_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load = tracker_sparql_connection_real_load;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_async = tracker_sparql_connection_real_load_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_finish = tracker_sparql_connection_real_load_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics = tracker_sparql_connection_real_statistics;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_async = tracker_sparql_connection_real_statistics_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_finish = tracker_sparql_connection_real_statistics_finish;
}


static void tracker_sparql_connection_instance_init (TrackerSparqlConnection * self) {
}


/**
 * TrackerSparqlConnection:
 *
 * The <structname>TrackerSparqlConnection</structname> object represents a
 * connection with the Tracker store or databases depending on direct or
 * non-direct requests.
 */
GType tracker_sparql_connection_get_type (void) {
	static volatile gsize tracker_sparql_connection_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlConnection), 0, (GInstanceInitFunc) tracker_sparql_connection_instance_init, NULL };
		GType tracker_sparql_connection_type_id;
		tracker_sparql_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlConnection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_sparql_connection_type_id__volatile, tracker_sparql_connection_type_id);
	}
	return tracker_sparql_connection_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



