/* tracker-tags-view.c generated by valac 0.14.0, the Vala compiler
 * generated from tracker-tags-view.vala, do not modify */

/*
 * Copyright (C) 2011, Martyn Russell <martyn@lanedo.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TAG_DATA (tag_data_get_type ())
#define TAG_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_DATA, TagData))
#define TAG_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_DATA, TagDataClass))
#define IS_TAG_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_DATA))
#define IS_TAG_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_DATA))
#define TAG_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_DATA, TagDataClass))

typedef struct _TagData TagData;
typedef struct _TagDataClass TagDataClass;
typedef struct _TagDataPrivate TagDataPrivate;

#define TYPE_TRACKER_TAGS_VIEW (tracker_tags_view_get_type ())
#define TRACKER_TAGS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_TAGS_VIEW, TrackerTagsView))
#define TRACKER_TAGS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewClass))
#define IS_TRACKER_TAGS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_TAGS_VIEW))
#define IS_TRACKER_TAGS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_TAGS_VIEW))
#define TRACKER_TAGS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewClass))

typedef struct _TrackerTagsView TrackerTagsView;
typedef struct _TrackerTagsViewClass TrackerTagsViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecTagData ParamSpecTagData;
typedef struct _TrackerTagsViewPrivate TrackerTagsViewPrivate;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _tag_data_unref0(var) ((var == NULL) ? NULL : (var = (tag_data_unref (var), NULL)))
#define __g_list_free__tag_data_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__tag_data_unref0_ (var), NULL)))

#define TRACKER_TAGS_VIEW_TYPE_COL (tracker_tags_view_col_get_type ())

#define TRACKER_TAGS_VIEW_TYPE_SELECTION (tracker_tags_view_selection_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _TrackerTagsViewModelToggleRowData TrackerTagsViewModelToggleRowData;
typedef struct _Block1Data Block1Data;
typedef struct _TrackerTagsViewRemoveTagData TrackerTagsViewRemoveTagData;
typedef struct _TrackerTagsViewAddTagData TrackerTagsViewAddTagData;
typedef struct _TrackerTagsViewQueryTagsData TrackerTagsViewQueryTagsData;
typedef struct _TrackerTagsViewQueryFilesForTagIdData TrackerTagsViewQueryFilesForTagIdData;

struct _TagData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TagDataPrivate * priv;
	TrackerTagsView* tv;
	GCancellable* cancellable;
	gchar* tag_id;
	GtkTreeIter iter;
	gint items;
	gboolean update;
	gboolean selected;
};

struct _TagDataClass {
	GTypeClass parent_class;
	void (*finalize) (TagData *self);
};

struct _ParamSpecTagData {
	GParamSpec parent_instance;
};

struct _TrackerTagsView {
	GtkVBox parent_instance;
	TrackerTagsViewPrivate * priv;
};

struct _TrackerTagsViewClass {
	GtkVBoxClass parent_class;
};

struct _TrackerTagsViewPrivate {
	TrackerSparqlConnection* connection;
	GCancellable* cancellable;
	GList* tag_data_requests;
	GList* files;
	GtkListStore* store;
	GtkVBox* vbox;
	GtkLabel* label;
	GtkEntry* entry;
	GtkButton* button_add;
	GtkButton* button_remove;
	GtkScrolledWindow* scrolled_window;
	GtkTreeView* view;
};

typedef enum  {
	TRACKER_TAGS_VIEW_COL_SELECTION,
	TRACKER_TAGS_VIEW_COL_TAG_ID,
	TRACKER_TAGS_VIEW_COL_TAG_NAME,
	TRACKER_TAGS_VIEW_COL_TAG_COUNT,
	TRACKER_TAGS_VIEW_COL_TAG_COUNT_VALUE,
	TRACKER_TAGS_VIEW_COL_N_COLUMNS
} TrackerTagsViewCol;

typedef enum  {
	TRACKER_TAGS_VIEW_SELECTION_INCONSISTENT = -1,
	TRACKER_TAGS_VIEW_SELECTION_FALSE = 0,
	TRACKER_TAGS_VIEW_SELECTION_TRUE = 1
} TrackerTagsViewSelection;

struct _TrackerTagsViewModelToggleRowData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerTagsView* self;
	GtkTreePath* path;
	GtkTreeModel* model;
	GtkTreeIter iter;
	gchar* id;
	gchar* tag;
	gint selection;
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreePath* _tmp4_;
	GtkTreeIter _tmp5_;
	gboolean _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeIter _tmp8_;
	TrackerTagsViewSelection _tmp9_;
	gint _tmp10_;
	TrackerTagsViewSelection _tmp11_;
	gint new_value;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* tag_escaped;
	gchar* _tmp14_;
	gchar* filter;
	gchar* query;
	TagData* td;
	gint _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	GtkTreeIter _tmp23_;
	TagData* _tmp24_;
	TagData* _tmp25_;
	TagData* _tmp26_;
	TagData* _tmp27_;
	TrackerSparqlConnection* _tmp28_;
	GtkEntry* _tmp29_;
	const gchar* _tmp30_;
	GtkTreeIter _tmp31_;
	gint _tmp32_;
	TagData* _tmp33_;
	TagData* _tmp34_;
	TagData* _tmp35_;
	TrackerSparqlConnection* _tmp36_;
	const gchar* _tmp37_;
	TagData* _tmp38_;
	GCancellable* _tmp39_;
	TagData* _tmp40_;
	GtkEntry* _tmp41_;
	GError* e;
	GError* _tmp42_;
	const gchar* _tmp43_;
	GError* _tmp44_;
	TagData* _tmp45_;
	GtkEntry* _tmp46_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	TrackerTagsView * self;
	GtkTreeIter found_iter;
	gboolean found;
	gchar* tag;
};

struct _TrackerTagsViewRemoveTagData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerTagsView* self;
	TagData* td;
	TrackerSparqlConnection* _tmp0_;
	TagData* _tmp1_;
	const gchar* _tmp2_;
	TagData* _tmp3_;
	TagData* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* query;
	TrackerSparqlConnection* _tmp7_;
	const gchar* _tmp8_;
	TagData* _tmp9_;
	GCancellable* _tmp10_;
	GtkListStore* _tmp11_;
	TagData* _tmp12_;
	GtkTreeIter _tmp13_;
	GError* e;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _tmp16_;
	TagData* _tmp17_;
	GError * _inner_error_;
};

struct _TrackerTagsViewAddTagData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerTagsView* self;
	gchar* tag;
	gchar* query;
	TrackerSparqlConnection* _tmp0_;
	const gchar* _tmp1_;
	GtkEntry* _tmp2_;
	GList* _tmp3_;
	guint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* filter;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* tag_escaped;
	GList* _tmp9_;
	GList* url_collection;
	GList* url_it;
	gchar* _tmp10_;
	gchar* url;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* tag_label_escaped;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	GList* _tmp30_;
	guint _tmp31_;
	TagData* _tmp32_;
	TagData* td;
	TagData* _tmp33_;
	TagData* _tmp34_;
	TrackerSparqlConnection* _tmp35_;
	const gchar* _tmp36_;
	TagData* _tmp37_;
	GCancellable* _tmp38_;
	TagData* _tmp39_;
	GtkEntry* _tmp40_;
	GError* e;
	GError* _tmp41_;
	const gchar* _tmp42_;
	GError* _tmp43_;
	TagData* _tmp44_;
	GtkEntry* _tmp45_;
	GError * _inner_error_;
};

struct _TrackerTagsViewQueryTagsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerTagsView* self;
	gchar* _tmp0_;
	gchar* query;
	GtkListStore* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	const gchar* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	TrackerSparqlCursor* cursor;
	TrackerSparqlCursor* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	TrackerSparqlCursor* _tmp8_;
	const gchar* _tmp9_;
	const gchar* id;
	TrackerSparqlCursor* _tmp10_;
	const gchar* _tmp11_;
	const gchar* label;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GtkTreeIter iter;
	GtkListStore* _tmp14_;
	GtkTreeIter _tmp15_;
	GtkListStore* _tmp16_;
	GtkTreeIter _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GtkTreeIter _tmp21_;
	TagData* _tmp22_;
	TagData* td;
	TagData* _tmp23_;
	TagData* _tmp24_;
	TagData* _tmp25_;
	GError* e;
	GError* _tmp26_;
	const gchar* _tmp27_;
	GError* _tmp28_;
	GError * _inner_error_;
};

struct _TrackerTagsViewQueryFilesForTagIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerTagsView* self;
	TagData* td;
	TrackerSparqlConnection* _tmp0_;
	TagData* _tmp1_;
	const gchar* _tmp2_;
	TagData* _tmp3_;
	TagData* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* query;
	TrackerSparqlConnection* _tmp7_;
	const gchar* _tmp8_;
	TagData* _tmp9_;
	GCancellable* _tmp10_;
	TrackerSparqlCursor* _tmp11_;
	TrackerSparqlCursor* cursor;
	guint has_tag_in_selection;
	guint files_with_tag;
	GList* _tmp12_;
	guint _tmp13_;
	guint files_selected;
	TrackerSparqlCursor* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	guint _tmp17_;
	GList* _tmp18_;
	GList* url_collection;
	GList* url_it;
	gchar* _tmp19_;
	gchar* url;
	TrackerSparqlCursor* _tmp20_;
	const gchar* _tmp21_;
	const gchar* url_returned;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	guint _tmp29_;
	guint _tmp30_;
	guint _tmp31_;
	GtkListStore* _tmp32_;
	TagData* _tmp33_;
	GtkTreeIter _tmp34_;
	guint _tmp35_;
	guint _tmp36_;
	GtkListStore* _tmp37_;
	TagData* _tmp38_;
	GtkTreeIter _tmp39_;
	GtkListStore* _tmp40_;
	TagData* _tmp41_;
	GtkTreeIter _tmp42_;
	guint _tmp43_;
	gchar* _tmp44_;
	gchar* str;
	GtkListStore* _tmp45_;
	TagData* _tmp46_;
	GtkTreeIter _tmp47_;
	const gchar* _tmp48_;
	guint _tmp49_;
	GError* e;
	GError* _tmp50_;
	const gchar* _tmp51_;
	GError* _tmp52_;
	TagData* _tmp53_;
	GError * _inner_error_;
};


static gpointer tag_data_parent_class = NULL;
static gpointer tracker_tags_view_parent_class = NULL;

gpointer tag_data_ref (gpointer instance);
void tag_data_unref (gpointer instance);
GParamSpec* param_spec_tag_data (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tag_data (GValue* value, gpointer v_object);
void value_take_tag_data (GValue* value, gpointer v_object);
gpointer value_get_tag_data (const GValue* value);
GType tag_data_get_type (void) G_GNUC_CONST;
GType tracker_tags_view_get_type (void) G_GNUC_CONST;
enum  {
	TAG_DATA_DUMMY_PROPERTY
};
TagData* tag_data_new (const gchar* _tag_id, GtkTreeIter* _iter, gboolean _update, gboolean _selected, gint _items, TrackerTagsView* _tv);
TagData* tag_data_construct (GType object_type, const gchar* _tag_id, GtkTreeIter* _iter, gboolean _update, gboolean _selected, gint _items, TrackerTagsView* _tv);
static void tag_data_finalize (TagData* obj);
#define TRACKER_TAGS_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewPrivate))
enum  {
	TRACKER_TAGS_VIEW_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _tag_data_unref0_ (gpointer var);
static void _g_list_free__tag_data_unref0_ (GList* self);
static GType tracker_tags_view_col_get_type (void) G_GNUC_UNUSED;
static GType tracker_tags_view_selection_get_type (void) G_GNUC_UNUSED;
#define TRACKER_TAGS_VIEW_UI_FILE "tracker-needle.ui"
TrackerTagsView* tracker_tags_view_new (GList* _files);
TrackerTagsView* tracker_tags_view_construct (GType object_type, GList* _files);
static void tracker_tags_view_create_ui (TrackerTagsView* self);
static void tracker_tags_view_show_error_dialog (TrackerTagsView* self, GError* e);
void tracker_tags_view_button_remove_clicked_cb (GtkButton* source, TrackerTagsView* self);
static void tracker_tags_view_remove_tag (TrackerTagsView* self, TagData* td, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_tags_view_remove_tag_finish (TrackerTagsView* self, GAsyncResult* _res_);
void tracker_tags_view_button_add_clicked_cb (GtkButton* source, TrackerTagsView* self);
static void tracker_tags_view_add_tag (TrackerTagsView* self, const gchar* tag, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_tags_view_add_tag_finish (TrackerTagsView* self, GAsyncResult* _res_);
void tracker_tags_view_entry_tag_activated_cb (GtkEntry* source, TrackerTagsView* self);
void tracker_tags_view_entry_tag_changed_cb (GtkEditable* source, TrackerTagsView* self);
static gboolean tracker_tags_view_find_tag (TrackerTagsView* self, const gchar* tag, GtkTreeIter* iter);
void tracker_tags_view_treeview_tags_cell_toggled_cb (GtkCellRendererToggle* source, const gchar* path_string, TrackerTagsView* self);
static void tracker_tags_view_model_toggle_row (TrackerTagsView* self, GtkTreePath* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_tags_view_model_toggle_row_finish (TrackerTagsView* self, GAsyncResult* _res_);
void tracker_tags_view_treeview_tags_row_selected_cb (GtkTreeSelection* selection, TrackerTagsView* self);
void tracker_tags_view_treeview_tags_row_activated_cb (GtkTreeView* source, GtkTreePath* path, GtkTreeViewColumn* column, TrackerTagsView* self);
static void tracker_tags_view_treeview_tags_toggle_cell_data_func (GtkCellLayout* layout, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter, TrackerTagsView* self);
static void _tracker_tags_view_entry_tag_changed_cb_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _tracker_tags_view_button_add_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _tracker_tags_view_button_remove_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _tracker_tags_view_treeview_tags_cell_toggled_cb_gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
static void _tracker_tags_view_treeview_tags_toggle_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void _tracker_tags_view_treeview_tags_row_selected_cb_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void _tracker_tags_view_treeview_tags_row_activated_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void tracker_tags_view_query_tags (TrackerTagsView* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_tags_view_query_tags_finish (TrackerTagsView* self, GAsyncResult* _res_);
static void tracker_tags_view_model_toggle_row_data_free (gpointer _data);
static gboolean tracker_tags_view_model_toggle_row_co (TrackerTagsViewModelToggleRowData* _data_);
static gchar* tracker_tags_view_sparql_get_escaped_string (TrackerTagsView* self, const gchar* str);
static gchar* tracker_tags_view_sparql_get_filter_string (TrackerTagsView* self, const gchar* tag);
static void tracker_tags_view_query_files_for_tag_id (TrackerTagsView* self, TagData* td, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_tags_view_query_files_for_tag_id_finish (TrackerTagsView* self, GAsyncResult* _res_);
static void tracker_tags_view_model_toggle_row_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_tags_view_update_tag_data (TrackerTagsView* self, TagData* td);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean __lambda0_ (Block1Data* _data1_, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* foreach_iter);
static gboolean ___lambda0__gtk_tree_model_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void tracker_tags_view_remove_tag_data_free (gpointer _data);
static gboolean tracker_tags_view_remove_tag_co (TrackerTagsViewRemoveTagData* _data_);
static void tracker_tags_view_remove_tag_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_tags_view_add_tag_data_free (gpointer _data);
static gboolean tracker_tags_view_add_tag_co (TrackerTagsViewAddTagData* _data_);
static void tracker_tags_view_add_tag_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_tags_view_query_tags_data_free (gpointer _data);
static gboolean tracker_tags_view_query_tags_co (TrackerTagsViewQueryTagsData* _data_);
static void tracker_tags_view_query_tags_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_tags_view_query_files_for_tag_id_data_free (gpointer _data);
static gboolean tracker_tags_view_query_files_for_tag_id_co (TrackerTagsViewQueryFilesForTagIdData* _data_);
static void tracker_tags_view_query_files_for_tag_id_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_tags_view_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
#line 35 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 515 "tracker-tags-view.c"
}


TagData* tag_data_construct (GType object_type, const gchar* _tag_id, GtkTreeIter* _iter, gboolean _update, gboolean _selected, gint _items, TrackerTagsView* _tv) {
	TagData* self = NULL;
	TrackerTagsView* _tmp0_;
	TrackerTagsView* _tmp1_;
	GCancellable* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GtkTreeIter* _tmp5_;
	gint _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
#line 32 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_val_if_fail (_tv != NULL, NULL);
#line 32 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self = (TagData*) g_type_create_instance (object_type);
#line 33 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_debug ("tracker-tags-view.vala:33: Creating tag data");
#line 35 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = _tv;
#line 35 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 35 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->tv);
#line 35 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->tv = _tmp1_;
#line 36 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp2_ = g_cancellable_new ();
#line 36 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->cancellable);
#line 36 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->cancellable = _tmp2_;
#line 37 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp3_ = _tag_id;
#line 37 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 37 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (self->tag_id);
#line 37 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->tag_id = _tmp4_;
#line 39 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp5_ = _iter;
#line 39 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp5_ != NULL) {
#line 562 "tracker-tags-view.c"
		GtkTreeIter* _tmp6_;
#line 40 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp6_ = _iter;
#line 40 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		self->iter = *_tmp6_;
#line 568 "tracker-tags-view.c"
	}
#line 43 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp7_ = _items;
#line 43 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->items = _tmp7_;
#line 44 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp8_ = _update;
#line 44 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->update = _tmp8_;
#line 45 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp9_ = _selected;
#line 45 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->selected = _tmp9_;
#line 32 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return self;
#line 584 "tracker-tags-view.c"
}


TagData* tag_data_new (const gchar* _tag_id, GtkTreeIter* _iter, gboolean _update, gboolean _selected, gint _items, TrackerTagsView* _tv) {
#line 32 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return tag_data_construct (TYPE_TAG_DATA, _tag_id, _iter, _update, _selected, _items, _tv);
#line 591 "tracker-tags-view.c"
}


static void value_tag_data_init (GValue* value) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	value->data[0].v_pointer = NULL;
#line 598 "tracker-tags-view.c"
}


static void value_tag_data_free_value (GValue* value) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (value->data[0].v_pointer) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tag_data_unref (value->data[0].v_pointer);
#line 607 "tracker-tags-view.c"
	}
}


static void value_tag_data_copy_value (const GValue* src_value, GValue* dest_value) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (src_value->data[0].v_pointer) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		dest_value->data[0].v_pointer = tag_data_ref (src_value->data[0].v_pointer);
#line 617 "tracker-tags-view.c"
	} else {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		dest_value->data[0].v_pointer = NULL;
#line 621 "tracker-tags-view.c"
	}
}


static gpointer value_tag_data_peek_pointer (const GValue* value) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return value->data[0].v_pointer;
#line 629 "tracker-tags-view.c"
}


static gchar* value_tag_data_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (collect_values[0].v_pointer) {
#line 636 "tracker-tags-view.c"
		TagData* object;
		object = collect_values[0].v_pointer;
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (object->parent_instance.g_class == NULL) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 643 "tracker-tags-view.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 647 "tracker-tags-view.c"
		}
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		value->data[0].v_pointer = tag_data_ref (object);
#line 651 "tracker-tags-view.c"
	} else {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		value->data[0].v_pointer = NULL;
#line 655 "tracker-tags-view.c"
	}
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return NULL;
#line 659 "tracker-tags-view.c"
}


static gchar* value_tag_data_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TagData** object_p;
	object_p = collect_values[0].v_pointer;
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (!object_p) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 670 "tracker-tags-view.c"
	}
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (!value->data[0].v_pointer) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		*object_p = NULL;
#line 676 "tracker-tags-view.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		*object_p = value->data[0].v_pointer;
#line 680 "tracker-tags-view.c"
	} else {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		*object_p = tag_data_ref (value->data[0].v_pointer);
#line 684 "tracker-tags-view.c"
	}
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return NULL;
#line 688 "tracker-tags-view.c"
}


GParamSpec* param_spec_tag_data (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTagData* spec;
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TAG_DATA), NULL);
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return G_PARAM_SPEC (spec);
#line 702 "tracker-tags-view.c"
}


gpointer value_get_tag_data (const GValue* value) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TAG_DATA), NULL);
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return value->data[0].v_pointer;
#line 711 "tracker-tags-view.c"
}


void value_set_tag_data (GValue* value, gpointer v_object) {
	TagData* old;
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TAG_DATA));
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	old = value->data[0].v_pointer;
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (v_object) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TAG_DATA));
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		value->data[0].v_pointer = v_object;
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tag_data_ref (value->data[0].v_pointer);
#line 731 "tracker-tags-view.c"
	} else {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		value->data[0].v_pointer = NULL;
#line 735 "tracker-tags-view.c"
	}
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (old) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tag_data_unref (old);
#line 741 "tracker-tags-view.c"
	}
}


void value_take_tag_data (GValue* value, gpointer v_object) {
	TagData* old;
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TAG_DATA));
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	old = value->data[0].v_pointer;
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (v_object) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TAG_DATA));
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		value->data[0].v_pointer = v_object;
#line 760 "tracker-tags-view.c"
	} else {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		value->data[0].v_pointer = NULL;
#line 764 "tracker-tags-view.c"
	}
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (old) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tag_data_unref (old);
#line 770 "tracker-tags-view.c"
	}
}


static void tag_data_class_init (TagDataClass * klass) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tag_data_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	TAG_DATA_CLASS (klass)->finalize = tag_data_finalize;
#line 780 "tracker-tags-view.c"
}


static void tag_data_instance_init (TagData * self) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->ref_count = 1;
#line 787 "tracker-tags-view.c"
}


static void tag_data_finalize (TagData* obj) {
	TagData * self;
	GCancellable* _tmp0_;
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self = TAG_DATA (obj);
#line 49 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = self->cancellable;
#line 49 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp0_ != NULL) {
#line 800 "tracker-tags-view.c"
		GCancellable* _tmp1_;
#line 50 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp1_ = self->cancellable;
#line 50 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_cancellable_cancel (_tmp1_);
#line 51 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_object_unref0 (self->cancellable);
#line 51 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		self->cancellable = NULL;
#line 810 "tracker-tags-view.c"
	}
#line 24 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->tv);
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->cancellable);
#line 26 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (self->tag_id);
#line 818 "tracker-tags-view.c"
}


GType tag_data_get_type (void) {
	static volatile gsize tag_data_type_id__volatile = 0;
	if (g_once_init_enter (&tag_data_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_tag_data_init, value_tag_data_free_value, value_tag_data_copy_value, value_tag_data_peek_pointer, "p", value_tag_data_collect_value, "p", value_tag_data_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TagDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tag_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TagData), 0, (GInstanceInitFunc) tag_data_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tag_data_type_id;
		tag_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TagData", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tag_data_type_id__volatile, tag_data_type_id);
	}
	return tag_data_type_id__volatile;
}


gpointer tag_data_ref (gpointer instance) {
	TagData* self;
	self = instance;
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_atomic_int_inc (&self->ref_count);
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return instance;
#line 843 "tracker-tags-view.c"
}


void tag_data_unref (gpointer instance) {
	TagData* self;
	self = instance;
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		TAG_DATA_GET_CLASS (self)->finalize (self);
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 856 "tracker-tags-view.c"
	}
}


static void _g_free0_ (gpointer var) {
#line 122 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	var = (g_free (var), NULL);
#line 864 "tracker-tags-view.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 122 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 122 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_list_free (self);
#line 873 "tracker-tags-view.c"
}


static gpointer _tag_data_ref0 (gpointer self) {
#line 126 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return self ? tag_data_ref (self) : NULL;
#line 880 "tracker-tags-view.c"
}


static void _tag_data_unref0_ (gpointer var) {
#line 130 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	(var == NULL) ? NULL : (var = (tag_data_unref (var), NULL));
#line 887 "tracker-tags-view.c"
}


static void _g_list_free__tag_data_unref0_ (GList* self) {
#line 130 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_list_foreach (self, (GFunc) _tag_data_unref0_, NULL);
#line 130 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_list_free (self);
#line 896 "tracker-tags-view.c"
}


static GType tracker_tags_view_col_get_type (void) {
	static volatile gsize tracker_tags_view_col_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_tags_view_col_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_TAGS_VIEW_COL_SELECTION, "TRACKER_TAGS_VIEW_COL_SELECTION", "selection"}, {TRACKER_TAGS_VIEW_COL_TAG_ID, "TRACKER_TAGS_VIEW_COL_TAG_ID", "tag-id"}, {TRACKER_TAGS_VIEW_COL_TAG_NAME, "TRACKER_TAGS_VIEW_COL_TAG_NAME", "tag-name"}, {TRACKER_TAGS_VIEW_COL_TAG_COUNT, "TRACKER_TAGS_VIEW_COL_TAG_COUNT", "tag-count"}, {TRACKER_TAGS_VIEW_COL_TAG_COUNT_VALUE, "TRACKER_TAGS_VIEW_COL_TAG_COUNT_VALUE", "tag-count-value"}, {TRACKER_TAGS_VIEW_COL_N_COLUMNS, "TRACKER_TAGS_VIEW_COL_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType tracker_tags_view_col_type_id;
		tracker_tags_view_col_type_id = g_enum_register_static ("TrackerTagsViewCol", values);
		g_once_init_leave (&tracker_tags_view_col_type_id__volatile, tracker_tags_view_col_type_id);
	}
	return tracker_tags_view_col_type_id__volatile;
}


static GType tracker_tags_view_selection_get_type (void) {
	static volatile gsize tracker_tags_view_selection_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_tags_view_selection_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_TAGS_VIEW_SELECTION_INCONSISTENT, "TRACKER_TAGS_VIEW_SELECTION_INCONSISTENT", "inconsistent"}, {TRACKER_TAGS_VIEW_SELECTION_FALSE, "TRACKER_TAGS_VIEW_SELECTION_FALSE", "false"}, {TRACKER_TAGS_VIEW_SELECTION_TRUE, "TRACKER_TAGS_VIEW_SELECTION_TRUE", "true"}, {0, NULL, NULL}};
		GType tracker_tags_view_selection_type_id;
		tracker_tags_view_selection_type_id = g_enum_register_static ("TrackerTagsViewSelection", values);
		g_once_init_leave (&tracker_tags_view_selection_type_id__volatile, tracker_tags_view_selection_type_id);
	}
	return tracker_tags_view_selection_type_id__volatile;
}


TrackerTagsView* tracker_tags_view_construct (GType object_type, GList* _files) {
	TrackerTagsView * self = NULL;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	GList* _tmp6_;
	GList* _tmp7_ = NULL;
	GCancellable* _tmp8_;
	GtkListStore* _tmp9_;
	GError * _inner_error_ = NULL;
#line 90 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = _files;
#line 90 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 90 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_val_if_fail (_tmp1_ > ((guint) 0), NULL);
#line 90 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self = (TrackerTagsView*) g_object_new (object_type, NULL);
#line 941 "tracker-tags-view.c"
	{
		TrackerSparqlConnection* _tmp2_ = NULL;
		TrackerSparqlConnection* _tmp3_;
#line 92 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp2_ = tracker_sparql_connection_get (NULL, &_inner_error_);
#line 92 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp3_ = _tmp2_;
#line 92 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_inner_error_ != NULL) {
#line 951 "tracker-tags-view.c"
			goto __catch15_g_error;
		}
#line 92 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_object_unref0 (self->priv->connection);
#line 92 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		self->priv->connection = _tmp3_;
#line 958 "tracker-tags-view.c"
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 91 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		e = _inner_error_;
#line 91 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_inner_error_ = NULL;
#line 94 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp4_ = e;
#line 94 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp5_ = _tmp4_->message;
#line 94 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_warning ("tracker-tags-view.vala:94: Could not get Sparql connection: %s", _tmp5_);
#line 91 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_error_free0 (e);
#line 978 "tracker-tags-view.c"
	}
	__finally15:
#line 91 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_inner_error_ != NULL) {
#line 91 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 91 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_clear_error (&_inner_error_);
#line 91 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return NULL;
#line 989 "tracker-tags-view.c"
	}
#line 97 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp6_ = _files;
#line 97 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp7_ = g_list_copy (_tmp6_);
#line 97 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	__g_list_free__g_free0_0 (self->priv->files);
#line 97 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->priv->files = _tmp7_;
#line 99 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp8_ = g_cancellable_new ();
#line 99 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 99 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->priv->cancellable = _tmp8_;
#line 101 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp9_ = gtk_list_store_new ((gint) TRACKER_TAGS_VIEW_COL_N_COLUMNS, G_TYPE_INT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT);
#line 101 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->store);
#line 101 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->priv->store = _tmp9_;
#line 108 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_create_ui (self);
#line 90 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return self;
#line 1015 "tracker-tags-view.c"
}


TrackerTagsView* tracker_tags_view_new (GList* _files) {
#line 90 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return tracker_tags_view_construct (TYPE_TRACKER_TAGS_VIEW, _files);
#line 1022 "tracker-tags-view.c"
}


static void tracker_tags_view_show_error_dialog (TrackerTagsView* self, GError* e) {
	const gchar* _tmp0_ = NULL;
	GError* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* str;
	GtkMessageDialog* _tmp8_;
	GtkMessageDialog* _tmp9_;
	GtkMessageDialog* msg;
#line 134 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (self != NULL);
#line 135 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = e;
#line 135 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp2_ = _tmp1_->message;
#line 135 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp2_ != NULL) {
#line 1044 "tracker-tags-view.c"
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 135 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp3_ = e;
#line 135 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp4_ = _tmp3_->message;
#line 135 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp0_ = _tmp4_;
#line 1053 "tracker-tags-view.c"
	} else {
		const gchar* _tmp5_ = NULL;
#line 135 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp5_ = _ ("No error was given");
#line 135 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp0_ = _tmp5_;
#line 1060 "tracker-tags-view.c"
	}
#line 135 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp6_ = _tmp0_;
#line 135 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 135 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	str = _tmp7_;
#line 137 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp8_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", str);
#line 137 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp9_ = g_object_ref_sink (_tmp8_);
#line 137 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	msg = _tmp9_;
#line 143 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_dialog_run ((GtkDialog*) msg);
#line 134 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (msg);
#line 134 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (str);
#line 1080 "tracker-tags-view.c"
}


void tracker_tags_view_button_remove_clicked_cb (GtkButton* source, TrackerTagsView* self) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* selection;
	GtkTreeSelection* _tmp3_;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GtkTreeModel* _tmp7_;
#line 147 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (self != NULL);
#line 147 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (source != NULL);
#line 148 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_debug ("tracker-tags-view.vala:148: Remove clicked");
#line 153 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = self->priv->view;
#line 153 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
#line 153 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 153 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	selection = _tmp2_;
#line 155 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp3_ = selection;
#line 155 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp6_ = gtk_tree_selection_get_selected (_tmp3_, &_tmp4_, &_tmp5_);
#line 155 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (model);
#line 155 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp7_ = _g_object_ref0 (_tmp4_);
#line 155 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	model = _tmp7_;
#line 155 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	iter = _tmp5_;
#line 155 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp6_) {
#line 1124 "tracker-tags-view.c"
		gchar* id = NULL;
		GtkTreeModel* _tmp8_;
		GtkTreeIter _tmp9_;
		const gchar* _tmp10_;
		GtkTreeIter _tmp11_;
		TagData* _tmp12_;
		TagData* td;
		TagData* _tmp13_;
		TagData* _tmp14_;
		TagData* _tmp15_;
#line 158 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp8_ = model;
#line 158 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp9_ = iter;
#line 158 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		gtk_tree_model_get (_tmp8_, &_tmp9_, TRACKER_TAGS_VIEW_COL_TAG_ID, &id, -1, -1);
#line 160 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp10_ = id;
#line 160 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp11_ = iter;
#line 160 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp12_ = tag_data_new (_tmp10_, &_tmp11_, FALSE, TRUE, 1, self);
#line 160 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		td = _tmp12_;
#line 161 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp13_ = td;
#line 161 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp14_ = _tag_data_ref0 (_tmp13_);
#line 161 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		self->priv->tag_data_requests = g_list_prepend (self->priv->tag_data_requests, _tmp14_);
#line 163 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp15_ = td;
#line 163 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_tags_view_remove_tag (self, _tmp15_, NULL, NULL);
#line 155 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tag_data_unref0 (td);
#line 155 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (id);
#line 1163 "tracker-tags-view.c"
	}
#line 147 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (selection);
#line 147 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (model);
#line 1169 "tracker-tags-view.c"
}


void tracker_tags_view_button_add_clicked_cb (GtkButton* source, TrackerTagsView* self) {
	GtkEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* tag;
#line 168 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (self != NULL);
#line 168 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (source != NULL);
#line 169 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_debug ("tracker-tags-view.vala:169: Add clicked");
#line 170 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = self->priv->entry;
#line 170 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 170 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tag = _tmp1_;
#line 171 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_add_tag (self, tag, NULL, NULL);
#line 1191 "tracker-tags-view.c"
}


void tracker_tags_view_entry_tag_activated_cb (GtkEntry* source, TrackerTagsView* self) {
	GtkButton* _tmp0_;
#line 175 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (self != NULL);
#line 175 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (source != NULL);
#line 176 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_debug ("tracker-tags-view.vala:176: Entry activated");
#line 177 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = self->priv->button_add;
#line 177 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_widget_activate (GTK_WIDGET (_tmp0_));
#line 1207 "tracker-tags-view.c"
}


void tracker_tags_view_entry_tag_changed_cb (GtkEditable* source, TrackerTagsView* self) {
	GtkEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* tag;
	GtkTreeIter iter = {0};
	const gchar* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
#line 181 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (self != NULL);
#line 181 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (source != NULL);
#line 182 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_debug ("tracker-tags-view.vala:182: Entry changed");
#line 184 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = self->priv->entry;
#line 184 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 184 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tag = _tmp1_;
#line 187 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp2_ = tag;
#line 187 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp4_ = tracker_tags_view_find_tag (self, _tmp2_, &_tmp3_);
#line 187 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	iter = _tmp3_;
#line 187 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp4_) {
#line 1239 "tracker-tags-view.c"
		GtkButton* _tmp5_;
#line 188 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp5_ = self->priv->button_add;
#line 188 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		gtk_widget_set_sensitive (GTK_WIDGET (_tmp5_), FALSE);
#line 1245 "tracker-tags-view.c"
	} else {
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		GtkButton* _tmp9_;
		gboolean _tmp10_;
#line 190 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp7_ = tag;
#line 190 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_tmp7_ != NULL) {
#line 1255 "tracker-tags-view.c"
			const gchar* _tmp8_;
#line 190 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp8_ = tag;
#line 190 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
#line 1261 "tracker-tags-view.c"
		} else {
#line 190 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp6_ = FALSE;
#line 1265 "tracker-tags-view.c"
		}
#line 190 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp9_ = self->priv->button_add;
#line 190 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp10_ = _tmp6_;
#line 190 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		gtk_widget_set_sensitive (GTK_WIDGET (_tmp9_), _tmp10_);
#line 1273 "tracker-tags-view.c"
	}
}


void tracker_tags_view_treeview_tags_cell_toggled_cb (GtkCellRendererToggle* source, const gchar* path_string, TrackerTagsView* self) {
	const gchar* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* path;
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (self != NULL);
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (source != NULL);
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (path_string != NULL);
#line 196 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_debug ("tracker-tags-view.vala:196: Treeview row cell toggled");
#line 197 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = path_string;
#line 197 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = gtk_tree_path_new_from_string (_tmp0_);
#line 197 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	path = _tmp1_;
#line 198 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_model_toggle_row (self, path, NULL, NULL);
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_gtk_tree_path_free0 (path);
#line 1300 "tracker-tags-view.c"
}


void tracker_tags_view_treeview_tags_row_selected_cb (GtkTreeSelection* selection, TrackerTagsView* self) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	GtkTreeModel* _tmp4_;
#line 202 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (self != NULL);
#line 202 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (selection != NULL);
#line 203 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_debug ("tracker-tags-view.vala:203: Treeview row selected");
#line 208 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = selection;
#line 208 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp3_ = gtk_tree_selection_get_selected (_tmp0_, &_tmp1_, &_tmp2_);
#line 208 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (model);
#line 208 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp4_ = _g_object_ref0 (_tmp1_);
#line 208 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	model = _tmp4_;
#line 208 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	iter = _tmp2_;
#line 208 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp3_) {
#line 1332 "tracker-tags-view.c"
		GtkButton* _tmp5_;
#line 209 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp5_ = self->priv->button_remove;
#line 209 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
#line 1338 "tracker-tags-view.c"
	} else {
		GtkButton* _tmp6_;
#line 211 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp6_ = self->priv->button_remove;
#line 211 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
#line 1345 "tracker-tags-view.c"
	}
#line 202 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (model);
#line 1349 "tracker-tags-view.c"
}


void tracker_tags_view_treeview_tags_row_activated_cb (GtkTreeView* source, GtkTreePath* path, GtkTreeViewColumn* column, TrackerTagsView* self) {
	GtkTreePath* _tmp0_;
#line 216 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (self != NULL);
#line 216 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (source != NULL);
#line 216 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (path != NULL);
#line 216 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (column != NULL);
#line 217 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_debug ("tracker-tags-view.vala:217: Treeview row activated");
#line 218 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = path;
#line 218 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_model_toggle_row (self, _tmp0_, NULL, NULL);
#line 1369 "tracker-tags-view.c"
}


static void tracker_tags_view_treeview_tags_toggle_cell_data_func (GtkCellLayout* layout, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter, TrackerTagsView* self) {
	gint selection = 0;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkCellRenderer* _tmp2_;
	GtkCellRenderer* _tmp3_;
#line 222 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (self != NULL);
#line 222 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (layout != NULL);
#line 222 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (cell != NULL);
#line 222 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (model != NULL);
#line 222 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (iter != NULL);
#line 225 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = model;
#line 225 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = *iter;
#line 225 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_model_get (_tmp0_, &_tmp1_, TRACKER_TAGS_VIEW_COL_SELECTION, &selection, -1, -1);
#line 226 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp2_ = cell;
#line 226 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_cell_renderer_toggle_set_active (GTK_CELL_RENDERER_TOGGLE (_tmp2_), selection == ((gint) TRACKER_TAGS_VIEW_SELECTION_TRUE));
#line 227 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp3_ = cell;
#line 227 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_object_set (GTK_CELL_RENDERER_TOGGLE (_tmp3_), "inconsistent", selection == ((gint) TRACKER_TAGS_VIEW_SELECTION_INCONSISTENT), NULL);
#line 1403 "tracker-tags-view.c"
}


static void _tracker_tags_view_entry_tag_changed_cb_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_entry_tag_changed_cb (_sender, self);
#line 1410 "tracker-tags-view.c"
}


static void _tracker_tags_view_button_add_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 271 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_button_add_clicked_cb (_sender, self);
#line 1417 "tracker-tags-view.c"
}


static void _tracker_tags_view_button_remove_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 272 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_button_remove_clicked_cb (_sender, self);
#line 1424 "tracker-tags-view.c"
}


static void _tracker_tags_view_treeview_tags_cell_toggled_cb_gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_treeview_tags_cell_toggled_cb (_sender, path, self);
#line 1431 "tracker-tags-view.c"
}


static void _tracker_tags_view_treeview_tags_toggle_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
#line 291 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_treeview_tags_toggle_cell_data_func (cell_layout, cell, tree_model, iter, self);
#line 1438 "tracker-tags-view.c"
}


static void _tracker_tags_view_treeview_tags_row_selected_cb_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
#line 328 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_treeview_tags_row_selected_cb (_sender, self);
#line 1445 "tracker-tags-view.c"
}


static void _tracker_tags_view_treeview_tags_row_activated_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
#line 335 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_treeview_tags_row_activated_cb (_sender, path, column, self);
#line 1452 "tracker-tags-view.c"
}


static void tracker_tags_view_create_ui (TrackerTagsView* self) {
	GtkBuilder* _tmp0_;
	GtkBuilder* builder;
	GObject* _tmp6_ = NULL;
	GtkVBox* _tmp7_;
	GObject* _tmp8_ = NULL;
	GtkLabel* _tmp9_;
	GObject* _tmp10_ = NULL;
	GtkEntry* _tmp11_;
	GObject* _tmp12_ = NULL;
	GtkButton* _tmp13_;
	GObject* _tmp14_ = NULL;
	GtkButton* _tmp15_;
	GObject* _tmp16_ = NULL;
	GtkScrolledWindow* _tmp17_;
	GObject* _tmp18_ = NULL;
	GtkTreeView* _tmp19_;
	GList* _tmp20_;
	guint _tmp21_ = 0U;
	const gchar* _tmp22_ = NULL;
	GList* _tmp23_;
	guint _tmp24_ = 0U;
	gchar* _tmp25_ = NULL;
	gchar* str;
	GtkLabel* _tmp26_;
	GtkEntry* _tmp27_;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	GtkTreeViewColumn* col = NULL;
	GtkCellRenderer* renderer = NULL;
	GtkCellRendererToggle* _tmp30_;
	GtkCellRenderer* _tmp31_;
	GtkCellRenderer* _tmp32_;
	GtkCellRenderer* _tmp33_;
	GtkCellRenderer* _tmp34_;
	GtkCellRenderer* _tmp35_;
	GtkTreeViewColumn* _tmp36_;
	GtkTreeViewColumn* _tmp37_;
	GtkTreeViewColumn* _tmp38_;
	GtkTreeViewColumn* _tmp39_;
	GtkTreeViewColumn* _tmp40_;
	GtkTreeViewColumn* _tmp41_;
	GtkTreeViewColumn* _tmp42_;
	GtkCellRenderer* _tmp43_;
	GtkTreeViewColumn* _tmp44_;
	GtkCellRenderer* _tmp45_;
	GtkTreeView* _tmp46_;
	GtkTreeViewColumn* _tmp47_;
	GtkCellRendererText* _tmp48_;
	GtkCellRenderer* _tmp49_;
	GtkCellRenderer* _tmp50_;
	GtkCellRenderer* _tmp51_;
	GtkCellRenderer* _tmp52_;
	GtkCellRenderer* _tmp53_;
	GtkTreeViewColumn* _tmp54_;
	GtkTreeViewColumn* _tmp55_;
	GtkTreeViewColumn* _tmp56_;
	const gchar* _tmp57_ = NULL;
	GtkTreeViewColumn* _tmp58_;
	GtkTreeViewColumn* _tmp59_;
	GtkTreeViewColumn* _tmp60_;
	GtkTreeViewColumn* _tmp61_;
	GtkCellRenderer* _tmp62_;
	GtkTreeViewColumn* _tmp63_;
	GtkCellRenderer* _tmp64_;
	GtkTreeView* _tmp65_;
	GtkTreeViewColumn* _tmp66_;
	GtkCellRendererText* _tmp67_;
	GtkCellRenderer* _tmp68_;
	GtkCellRenderer* _tmp69_;
	GtkCellRenderer* _tmp70_;
	GtkTreeViewColumn* _tmp71_;
	GtkTreeViewColumn* _tmp72_;
	GtkTreeViewColumn* _tmp73_;
	GtkTreeViewColumn* _tmp74_;
	GtkTreeViewColumn* _tmp75_;
	GtkTreeViewColumn* _tmp76_;
	GtkTreeViewColumn* _tmp77_;
	GtkCellRenderer* _tmp78_;
	GtkTreeViewColumn* _tmp79_;
	GtkCellRenderer* _tmp80_;
	GtkTreeView* _tmp81_;
	GtkTreeViewColumn* _tmp82_;
	GtkTreeView* _tmp83_;
	GtkTreeSelection* _tmp84_ = NULL;
	GtkTreeSelection* _tmp85_;
	GtkTreeSelection* selection;
	GtkListStore* _tmp86_;
	GtkTreeModel* _tmp87_;
	GtkTreeModel* model;
	GtkTreeSortable* _tmp88_;
	GtkTreeSortable* sortable;
	GtkTreeView* _tmp89_;
	GtkTreeView* _tmp90_;
	GtkVBox* _tmp91_;
	GError * _inner_error_ = NULL;
#line 230 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (self != NULL);
#line 231 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = gtk_builder_new ();
#line 231 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	builder = _tmp0_;
#line 1558 "tracker-tags-view.c"
	{
#line 234 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_debug ("tracker-tags-view.vala:234: Trying to use UI file:'%s'", SRCDIR TRACKER_TAGS_VIEW_UI_FILE);
#line 235 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		gtk_builder_add_from_file (builder, SRCDIR TRACKER_TAGS_VIEW_UI_FILE, &_inner_error_);
#line 235 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_inner_error_ != NULL) {
#line 1566 "tracker-tags-view.c"
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		e = _inner_error_;
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_inner_error_ = NULL;
#line 1578 "tracker-tags-view.c"
		{
#line 239 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_debug ("tracker-tags-view.vala:239: Trying to use UI file:'%s'", TRACKER_UI_DIR TRACKER_TAGS_VIEW_UI_FILE);
#line 240 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			gtk_builder_add_from_file (builder, TRACKER_UI_DIR TRACKER_TAGS_VIEW_UI_FILE, &_inner_error_);
#line 240 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			if (_inner_error_ != NULL) {
#line 1586 "tracker-tags-view.c"
				goto __catch17_g_error;
			}
		}
		goto __finally17;
		__catch17_g_error:
		{
			GError* e = NULL;
			GError* _tmp1_;
			const gchar* _tmp2_;
			GtkMessageDialog* _tmp3_;
			GtkMessageDialog* _tmp4_;
			GtkMessageDialog* msg;
			GtkMessageDialog* _tmp5_;
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			e = _inner_error_;
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_inner_error_ = NULL;
#line 242 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp1_ = e;
#line 242 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp2_ = _tmp1_->message;
#line 242 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Failed to load UI file, %s\n", _tmp2_);
#line 242 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp4_ = g_object_ref_sink (_tmp3_);
#line 242 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			msg = _tmp4_;
#line 248 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp5_ = msg;
#line 248 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			gtk_dialog_run ((GtkDialog*) _tmp5_);
#line 249 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			gtk_main_quit ();
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_g_object_unref0 (msg);
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_g_error_free0 (e);
#line 1624 "tracker-tags-view.c"
		}
		__finally17:
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_inner_error_ != NULL) {
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_g_error_free0 (e);
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_g_error_free0 (e);
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_g_object_unref0 (builder);
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_clear_error (&_inner_error_);
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			return;
#line 1641 "tracker-tags-view.c"
		}
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_error_free0 (e);
#line 1645 "tracker-tags-view.c"
	}
	__finally16:
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_inner_error_ != NULL) {
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_object_unref0 (builder);
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_clear_error (&_inner_error_);
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return;
#line 1658 "tracker-tags-view.c"
	}
#line 254 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp6_ = gtk_builder_get_object (builder, "vbox_tags");
#line 254 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp7_ = _g_object_ref0 (GTK_IS_VBOX (_tmp6_) ? ((GtkVBox*) _tmp6_) : NULL);
#line 254 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->vbox);
#line 254 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->priv->vbox = _tmp7_;
#line 255 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp8_ = gtk_builder_get_object (builder, "label_tag");
#line 255 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp9_ = _g_object_ref0 (GTK_IS_LABEL (_tmp8_) ? ((GtkLabel*) _tmp8_) : NULL);
#line 255 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->label);
#line 255 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->priv->label = _tmp9_;
#line 256 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp10_ = gtk_builder_get_object (builder, "entry_tag");
#line 256 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp11_ = _g_object_ref0 (GTK_IS_ENTRY (_tmp10_) ? ((GtkEntry*) _tmp10_) : NULL);
#line 256 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->entry);
#line 256 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->priv->entry = _tmp11_;
#line 257 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp12_ = gtk_builder_get_object (builder, "button_add");
#line 257 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp13_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp12_) ? ((GtkButton*) _tmp12_) : NULL);
#line 257 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->button_add);
#line 257 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->priv->button_add = _tmp13_;
#line 258 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp14_ = gtk_builder_get_object (builder, "button_remove");
#line 258 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp15_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp14_) ? ((GtkButton*) _tmp14_) : NULL);
#line 258 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->button_remove);
#line 258 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->priv->button_remove = _tmp15_;
#line 259 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp16_ = gtk_builder_get_object (builder, "scrolled_window_tags");
#line 259 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp17_ = _g_object_ref0 (GTK_IS_SCROLLED_WINDOW (_tmp16_) ? ((GtkScrolledWindow*) _tmp16_) : NULL);
#line 259 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->scrolled_window);
#line 259 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->priv->scrolled_window = _tmp17_;
#line 260 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp18_ = gtk_builder_get_object (builder, "treeview_tags");
#line 260 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp19_ = _g_object_ref0 (GTK_IS_TREE_VIEW (_tmp18_) ? ((GtkTreeView*) _tmp18_) : NULL);
#line 260 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->view);
#line 260 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->priv->view = _tmp19_;
#line 263 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp20_ = self->priv->files;
#line 263 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp21_ = g_list_length (_tmp20_);
#line 263 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp22_ = g_dngettext (NULL, "_Set the tags you want to associate with the %d selected item:", "_Set the tags you want to associate with the %d selected items:", (gulong) _tmp21_);
#line 263 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp23_ = self->priv->files;
#line 263 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp24_ = g_list_length (_tmp23_);
#line 263 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp25_ = g_strdup_printf (_tmp22_, _tmp24_);
#line 263 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	str = _tmp25_;
#line 267 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp26_ = self->priv->label;
#line 267 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_label_set_text_with_mnemonic (_tmp26_, str);
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp27_ = self->priv->entry;
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_signal_connect_object (GTK_EDITABLE (_tmp27_), "changed", (GCallback) _tracker_tags_view_entry_tag_changed_cb_gtk_editable_changed, self, 0);
#line 271 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp28_ = self->priv->button_add;
#line 271 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_signal_connect_object (_tmp28_, "clicked", (GCallback) _tracker_tags_view_button_add_clicked_cb_gtk_button_clicked, self, 0);
#line 272 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp29_ = self->priv->button_remove;
#line 272 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_signal_connect_object (_tmp29_, "clicked", (GCallback) _tracker_tags_view_button_remove_clicked_cb_gtk_button_clicked, self, 0);
#line 279 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp30_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
#line 279 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp31_ = (GtkCellRenderer*) g_object_ref_sink (_tmp30_);
#line 279 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (renderer);
#line 279 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	renderer = _tmp31_;
#line 280 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp32_ = renderer;
#line 280 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_object_set (_tmp32_, "xpad", (guint) 5, NULL);
#line 281 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp33_ = renderer;
#line 281 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_object_set (_tmp33_, "ypad", (guint) 5, NULL);
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp34_ = renderer;
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_signal_connect_object (GTK_CELL_RENDERER_TOGGLE (_tmp34_), "toggled", (GCallback) _tracker_tags_view_treeview_tags_cell_toggled_cb_gtk_cell_renderer_toggle_toggled, self, 0);
#line 283 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp35_ = renderer;
#line 283 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_cell_renderer_toggle_set_radio (GTK_CELL_RENDERER_TOGGLE (_tmp35_), FALSE);
#line 285 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp36_ = gtk_tree_view_column_new ();
#line 285 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp37_ = g_object_ref_sink (_tmp36_);
#line 285 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (col);
#line 285 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	col = _tmp37_;
#line 286 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp38_ = col;
#line 286 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_column_set_title (_tmp38_, "-");
#line 287 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp39_ = col;
#line 287 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_column_set_resizable (_tmp39_, FALSE);
#line 288 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp40_ = col;
#line 288 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_column_set_sizing (_tmp40_, GTK_TREE_VIEW_COLUMN_FIXED);
#line 289 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp41_ = col;
#line 289 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_column_set_fixed_width (_tmp41_, 50);
#line 290 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp42_ = col;
#line 290 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp43_ = renderer;
#line 290 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp42_, _tmp43_, FALSE);
#line 291 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp44_ = col;
#line 291 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp45_ = renderer;
#line 291 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp44_, _tmp45_, _tracker_tags_view_treeview_tags_toggle_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
#line 292 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp46_ = self->priv->view;
#line 292 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp47_ = col;
#line 292 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_append_column (_tmp46_, _tmp47_);
#line 295 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp48_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 295 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp49_ = (GtkCellRenderer*) g_object_ref_sink (_tmp48_);
#line 295 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (renderer);
#line 295 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	renderer = _tmp49_;
#line 296 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp50_ = renderer;
#line 296 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_object_set (_tmp50_, "xpad", (guint) 5, NULL);
#line 297 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp51_ = renderer;
#line 297 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_object_set (_tmp51_, "ypad", (guint) 5, NULL);
#line 298 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp52_ = renderer;
#line 298 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_object_set (GTK_CELL_RENDERER_TEXT (_tmp52_), "ellipsize", PANGO_ELLIPSIZE_END, NULL);
#line 299 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp53_ = renderer;
#line 299 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_object_set (GTK_CELL_RENDERER_TEXT (_tmp53_), "ellipsize-set", TRUE, NULL);
#line 301 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp54_ = gtk_tree_view_column_new ();
#line 301 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp55_ = g_object_ref_sink (_tmp54_);
#line 301 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (col);
#line 301 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	col = _tmp55_;
#line 302 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp56_ = col;
#line 302 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp57_ = _ ("Name");
#line 302 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_column_set_title (_tmp56_, _tmp57_);
#line 303 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp58_ = col;
#line 303 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_column_set_resizable (_tmp58_, TRUE);
#line 304 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp59_ = col;
#line 304 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_column_set_sizing (_tmp59_, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
#line 305 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp60_ = col;
#line 305 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_column_set_expand (_tmp60_, TRUE);
#line 306 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp61_ = col;
#line 306 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp62_ = renderer;
#line 306 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp61_, _tmp62_, TRUE);
#line 307 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp63_ = col;
#line 307 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp64_ = renderer;
#line 307 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp63_, _tmp64_, "text", (gint) TRACKER_TAGS_VIEW_COL_TAG_NAME);
#line 309 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp65_ = self->priv->view;
#line 309 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp66_ = col;
#line 309 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_append_column (_tmp65_, _tmp66_);
#line 312 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp67_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 312 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp68_ = (GtkCellRenderer*) g_object_ref_sink (_tmp67_);
#line 312 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (renderer);
#line 312 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	renderer = _tmp68_;
#line 313 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp69_ = renderer;
#line 313 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_object_set (_tmp69_, "xpad", (guint) 5, NULL);
#line 314 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp70_ = renderer;
#line 314 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_object_set (_tmp70_, "ypad", (guint) 5, NULL);
#line 316 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp71_ = gtk_tree_view_column_new ();
#line 316 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp72_ = g_object_ref_sink (_tmp71_);
#line 316 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (col);
#line 316 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	col = _tmp72_;
#line 317 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp73_ = col;
#line 317 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_column_set_title (_tmp73_, "-");
#line 318 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp74_ = col;
#line 318 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_column_set_resizable (_tmp74_, FALSE);
#line 319 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp75_ = col;
#line 319 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_column_set_sizing (_tmp75_, GTK_TREE_VIEW_COLUMN_FIXED);
#line 320 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp76_ = col;
#line 320 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_column_set_fixed_width (_tmp76_, 50);
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp77_ = col;
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp78_ = renderer;
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp77_, _tmp78_, FALSE);
#line 322 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp79_ = col;
#line 322 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp80_ = renderer;
#line 322 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp79_, _tmp80_, "text", (gint) TRACKER_TAGS_VIEW_COL_TAG_COUNT);
#line 324 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp81_ = self->priv->view;
#line 324 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp82_ = col;
#line 324 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_append_column (_tmp81_, _tmp82_);
#line 327 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp83_ = self->priv->view;
#line 327 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp84_ = gtk_tree_view_get_selection (_tmp83_);
#line 327 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp85_ = _g_object_ref0 (_tmp84_);
#line 327 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	selection = _tmp85_;
#line 328 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_signal_connect_object (selection, "changed", (GCallback) _tracker_tags_view_treeview_tags_row_selected_cb_gtk_tree_selection_changed, self, 0);
#line 331 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp86_ = self->priv->store;
#line 331 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp87_ = _g_object_ref0 (GTK_IS_TREE_MODEL (_tmp86_) ? ((GtkTreeModel*) _tmp86_) : NULL);
#line 331 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	model = _tmp87_;
#line 332 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp88_ = _g_object_ref0 (GTK_IS_TREE_SORTABLE (model) ? ((GtkTreeSortable*) model) : NULL);
#line 332 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	sortable = _tmp88_;
#line 334 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp89_ = self->priv->view;
#line 334 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_view_set_model (_tmp89_, model);
#line 335 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp90_ = self->priv->view;
#line 335 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_signal_connect_object (_tmp90_, "row-activated", (GCallback) _tracker_tags_view_treeview_tags_row_activated_cb_gtk_tree_view_row_activated, self, 0);
#line 336 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_sortable_set_sort_column_id (sortable, 2, GTK_SORT_ASCENDING);
#line 339 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp91_ = self->priv->vbox;
#line 339 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_box_pack_start ((GtkBox*) GTK_VBOX (self), (GtkWidget*) _tmp91_, TRUE, TRUE, (guint) 0);
#line 341 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_query_tags (self, NULL, NULL);
#line 230 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (sortable);
#line 230 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (model);
#line 230 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (selection);
#line 230 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (renderer);
#line 230 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (col);
#line 230 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (str);
#line 230 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (builder);
#line 1988 "tracker-tags-view.c"
}


static void tracker_tags_view_model_toggle_row_data_free (gpointer _data) {
	TrackerTagsViewModelToggleRowData* _data_;
	_data_ = _data;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_gtk_tree_path_free0 (_data_->path);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (_data_->self);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_slice_free (TrackerTagsViewModelToggleRowData, _data_);
#line 2001 "tracker-tags-view.c"
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return self ? gtk_tree_path_copy (self) : NULL;
#line 2008 "tracker-tags-view.c"
}


static void tracker_tags_view_model_toggle_row (TrackerTagsView* self, GtkTreePath* path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerTagsViewModelToggleRowData* _data_;
	TrackerTagsView* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = g_slice_new0 (TrackerTagsViewModelToggleRowData);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_tags_view_model_toggle_row);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_tags_view_model_toggle_row_data_free);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->self = _tmp0_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = path;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp2_ = _gtk_tree_path_copy0 (_tmp1_);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->path = _tmp2_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_model_toggle_row_co (_data_);
#line 2035 "tracker-tags-view.c"
}


static void tracker_tags_view_model_toggle_row_finish (TrackerTagsView* self, GAsyncResult* _res_) {
	TrackerTagsViewModelToggleRowData* _data_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2043 "tracker-tags-view.c"
}


static void tracker_tags_view_model_toggle_row_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerTagsViewModelToggleRowData* _data_;
#line 415 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = _user_data_;
#line 415 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_source_object_ = source_object;
#line 415 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_res_ = _res_;
#line 415 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_model_toggle_row_co (_data_);
#line 2057 "tracker-tags-view.c"
}


static gboolean tracker_tags_view_model_toggle_row_co (TrackerTagsViewModelToggleRowData* _data_) {
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	switch (_data_->_state_) {
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		case 0:
#line 2066 "tracker-tags-view.c"
		goto _state_0;
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		case 1:
#line 2070 "tracker-tags-view.c"
		goto _state_1;
		default:
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_assert_not_reached ();
#line 2075 "tracker-tags-view.c"
	}
	_state_0:
#line 350 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp0_ = _data_->self->priv->view;
#line 350 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp1_ = NULL;
#line 350 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp1_ = gtk_tree_view_get_model (_data_->_tmp0_);
#line 350 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 350 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (_data_->model);
#line 350 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->model = _data_->_tmp2_;
#line 352 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp3_ = _data_->model;
#line 352 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp4_ = _data_->path;
#line 352 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	memset (&_data_->_tmp5_, 0, sizeof (GtkTreeIter));
#line 352 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp6_ = FALSE;
#line 352 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp6_ = gtk_tree_model_get_iter (_data_->_tmp3_, &_data_->_tmp5_, _data_->_tmp4_);
#line 352 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->iter = _data_->_tmp5_;
#line 352 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_tmp6_ == FALSE) {
#line 353 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->tag);
#line 353 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->id);
#line 353 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_object_unref0 (_data_->model);
#line 353 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_data_->_state_ == 0) {
#line 353 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2114 "tracker-tags-view.c"
		} else {
#line 353 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2118 "tracker-tags-view.c"
		}
#line 353 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_object_unref (_data_->_async_result);
#line 353 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 2124 "tracker-tags-view.c"
	}
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp7_ = _data_->model;
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp8_ = _data_->iter;
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_model_get (_data_->_tmp7_, &_data_->_tmp8_, TRACKER_TAGS_VIEW_COL_SELECTION, &_data_->selection, TRACKER_TAGS_VIEW_COL_TAG_ID, &_data_->id, TRACKER_TAGS_VIEW_COL_TAG_NAME, &_data_->tag, -1, -1);
#line 362 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp10_ = _data_->selection;
#line 362 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_tmp10_ == ((gint) TRACKER_TAGS_VIEW_SELECTION_FALSE)) {
#line 362 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp9_ = TRACKER_TAGS_VIEW_SELECTION_TRUE;
#line 2138 "tracker-tags-view.c"
	} else {
#line 362 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp9_ = TRACKER_TAGS_VIEW_SELECTION_FALSE;
#line 2142 "tracker-tags-view.c"
	}
#line 362 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp11_ = _data_->_tmp9_;
#line 362 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->new_value = (gint) _data_->_tmp11_;
#line 364 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp12_ = _data_->tag;
#line 364 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp13_ = NULL;
#line 364 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp13_ = tracker_tags_view_sparql_get_escaped_string (_data_->self, _data_->_tmp12_);
#line 364 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->tag_escaped = _data_->_tmp13_;
#line 365 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp14_ = NULL;
#line 365 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp14_ = tracker_tags_view_sparql_get_filter_string (_data_->self, NULL);
#line 365 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->filter = _data_->_tmp14_;
#line 366 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->query = NULL;
#line 371 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp15_ = _data_->new_value;
#line 371 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_tmp15_ != ((gint) TRACKER_TAGS_VIEW_SELECTION_FALSE)) {
#line 373 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp16_ = _data_->tag_escaped;
#line 373 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp17_ = _data_->filter;
#line 373 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp18_ = NULL;
#line 373 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp18_ = g_strdup_printf ("INSERT {\n" \
"			           ?urn nao:hasTag ?label\n" \
"			         } WHERE {\n" \
"			           ?urn nie:url ?f .\n" \
"			           ?label nao:prefLabel %s .\n" \
"			           %s\n" \
"			         }", _data_->_tmp16_, _data_->_tmp17_);
#line 373 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->query);
#line 373 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->query = _data_->_tmp18_;
#line 2180 "tracker-tags-view.c"
	} else {
#line 382 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp19_ = _data_->tag_escaped;
#line 382 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp20_ = _data_->filter;
#line 382 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp21_ = NULL;
#line 382 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp21_ = g_strdup_printf ("DELETE {\n" \
"			           ?urn nao:hasTag ?label\n" \
"			         } WHERE {\n" \
"			           ?urn nie:url ?f .\n" \
"			           ?label nao:prefLabel %s .\n" \
"			           %s\n" \
"			         }", _data_->_tmp19_, _data_->_tmp20_);
#line 382 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->query);
#line 382 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->query = _data_->_tmp21_;
#line 393 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp22_ = _data_->id;
#line 393 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp23_ = _data_->iter;
#line 393 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp24_ = tag_data_new (_data_->_tmp22_, &_data_->_tmp23_, FALSE, TRUE, 1, _data_->self);
#line 393 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tag_data_unref0 (_data_->td);
#line 393 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->td = _data_->_tmp24_;
#line 394 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp25_ = _data_->td;
#line 394 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp26_ = _tag_data_ref0 (_data_->_tmp25_);
#line 394 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->self->priv->tag_data_requests = g_list_prepend (_data_->self->priv->tag_data_requests, _data_->_tmp26_);
#line 396 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp27_ = _data_->td;
#line 396 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_tags_view_query_files_for_tag_id (_data_->self, _data_->_tmp27_, NULL, NULL);
#line 2214 "tracker-tags-view.c"
	}
#line 399 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (_data_->filter);
#line 399 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->filter = NULL;
#line 400 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (_data_->tag_escaped);
#line 400 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->tag_escaped = NULL;
#line 402 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp28_ = _data_->self->priv->connection;
#line 402 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_tmp28_ == NULL) {
#line 403 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_warning ("tracker-tags-view.vala:403: Can't update tags, no SPARQL connection av" \
"ailable");
#line 404 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tag_data_unref0 (_data_->td);
#line 404 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->query);
#line 404 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->filter);
#line 404 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->tag_escaped);
#line 404 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->tag);
#line 404 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->id);
#line 404 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_object_unref0 (_data_->model);
#line 404 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_data_->_state_ == 0) {
#line 404 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2248 "tracker-tags-view.c"
		} else {
#line 404 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2252 "tracker-tags-view.c"
		}
#line 404 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_object_unref (_data_->_async_result);
#line 404 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 2258 "tracker-tags-view.c"
	}
#line 407 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_debug ("tracker-tags-view.vala:407: Updating tags for uris");
#line 409 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp29_ = _data_->self->priv->entry;
#line 409 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp29_, FALSE);
#line 411 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp30_ = _data_->id;
#line 411 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp31_ = _data_->iter;
#line 411 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp32_ = _data_->new_value;
#line 411 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp33_ = tag_data_new (_data_->_tmp30_, &_data_->_tmp31_, TRUE, _data_->_tmp32_ != ((gint) TRACKER_TAGS_VIEW_SELECTION_FALSE), 1, _data_->self);
#line 411 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tag_data_unref0 (_data_->td);
#line 411 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->td = _data_->_tmp33_;
#line 412 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp34_ = _data_->td;
#line 412 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp35_ = _tag_data_ref0 (_data_->_tmp34_);
#line 412 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->self->priv->tag_data_requests = g_list_prepend (_data_->self->priv->tag_data_requests, _data_->_tmp35_);
#line 2284 "tracker-tags-view.c"
	{
#line 415 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp36_ = _data_->self->priv->connection;
#line 415 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp37_ = _data_->query;
#line 415 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp38_ = _data_->td;
#line 415 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp39_ = _data_->_tmp38_->cancellable;
#line 415 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_state_ = 1;
#line 415 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_sparql_connection_update_async (_data_->_tmp36_, _data_->_tmp37_, G_PRIORITY_DEFAULT, _data_->_tmp39_, tracker_tags_view_model_toggle_row_ready, _data_);
#line 415 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 2300 "tracker-tags-view.c"
		_state_1:
#line 415 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_sparql_connection_update_finish (_data_->_tmp36_, _data_->_res_, &_data_->_inner_error_);
#line 415 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_data_->_inner_error_ != NULL) {
#line 2306 "tracker-tags-view.c"
			goto __catch18_g_error;
		}
#line 417 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_debug ("tracker-tags-view.vala:417: Updated tags");
#line 418 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp40_ = _data_->td;
#line 418 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_tags_view_update_tag_data (_data_->self, _data_->_tmp40_);
#line 420 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp41_ = _data_->self->priv->entry;
#line 420 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		gtk_entry_set_text (_data_->_tmp41_, "");
#line 2319 "tracker-tags-view.c"
	}
	goto __finally18;
	__catch18_g_error:
	{
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->e = _data_->_inner_error_;
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_inner_error_ = NULL;
#line 422 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp42_ = _data_->e;
#line 422 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp43_ = _data_->_tmp42_->message;
#line 422 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_warning ("tracker-tags-view.vala:422: Could not run Sparql update query: %s", _data_->_tmp43_);
#line 423 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp44_ = _data_->e;
#line 423 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_tags_view_show_error_dialog (_data_->self, _data_->_tmp44_);
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_error_free0 (_data_->e);
#line 2340 "tracker-tags-view.c"
	}
	__finally18:
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_inner_error_ != NULL) {
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tag_data_unref0 (_data_->td);
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->query);
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->filter);
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->tag_escaped);
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->tag);
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->id);
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_object_unref0 (_data_->model);
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_clear_error (&_data_->_inner_error_);
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 2365 "tracker-tags-view.c"
	}
#line 426 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp45_ = _data_->td;
#line 426 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->self->priv->tag_data_requests = g_list_remove (_data_->self->priv->tag_data_requests, _data_->_tmp45_);
#line 427 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tag_data_unref0 (_data_->td);
#line 427 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->td = NULL;
#line 429 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp46_ = _data_->self->priv->entry;
#line 429 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp46_, TRUE);
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tag_data_unref0 (_data_->td);
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (_data_->query);
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (_data_->filter);
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (_data_->tag_escaped);
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (_data_->tag);
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (_data_->id);
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (_data_->model);
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_state_ == 0) {
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2397 "tracker-tags-view.c"
	} else {
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2401 "tracker-tags-view.c"
	}
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_object_unref (_data_->_async_result);
#line 344 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return FALSE;
#line 2407 "tracker-tags-view.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 432 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 432 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return _data1_;
#line 2416 "tracker-tags-view.c"
}


static void block1_data_unref (Block1Data* _data1_) {
#line 432 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 432 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_object_unref0 (_data1_->self);
#line 432 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data1_->tag);
#line 432 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_slice_free (Block1Data, _data1_);
#line 2429 "tracker-tags-view.c"
	}
}


static gboolean __lambda0_ (Block1Data* _data1_, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* foreach_iter) {
	TrackerTagsView * self;
	gboolean result = FALSE;
	gchar* foreach_tag = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp6_;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self = _data1_->self;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_val_if_fail (model != NULL, FALSE);
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_val_if_fail (foreach_iter != NULL, FALSE);
#line 447 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = model;
#line 447 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = *foreach_iter;
#line 447 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_model_get (_tmp0_, &_tmp1_, TRACKER_TAGS_VIEW_COL_TAG_NAME, &foreach_tag, -1, -1);
#line 449 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp3_ = foreach_tag;
#line 449 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp3_ != NULL) {
#line 2461 "tracker-tags-view.c"
		const gchar* _tmp4_;
		const gchar* _tmp5_;
#line 449 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp4_ = foreach_tag;
#line 449 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp5_ = _data1_->tag;
#line 449 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
#line 2470 "tracker-tags-view.c"
	} else {
#line 449 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp2_ = FALSE;
#line 2474 "tracker-tags-view.c"
	}
#line 449 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp6_ = _tmp2_;
#line 449 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp6_) {
#line 2480 "tracker-tags-view.c"
		GtkTreeIter _tmp7_;
#line 450 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data1_->found = TRUE;
#line 451 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp7_ = *foreach_iter;
#line 451 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data1_->found_iter = _tmp7_;
#line 452 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		result = TRUE;
#line 452 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (foreach_tag);
#line 452 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return result;
#line 2494 "tracker-tags-view.c"
	}
#line 455 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	result = FALSE;
#line 455 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (foreach_tag);
#line 455 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return result;
#line 2502 "tracker-tags-view.c"
}


static gboolean ___lambda0__gtk_tree_model_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = __lambda0_ (self, model, path, iter);
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return result;
#line 2511 "tracker-tags-view.c"
}


static gboolean tracker_tags_view_find_tag (TrackerTagsView* self, const gchar* tag, GtkTreeIter* iter) {
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	Block1Data* _data1_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkTreeIter _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp7_;
	GtkTreeView* _tmp8_;
	GtkTreeModel* _tmp9_ = NULL;
	GtkTreeModel* _tmp10_;
	GtkTreeModel* model;
	GtkTreeModel* _tmp11_;
	gboolean _tmp12_;
#line 432 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 432 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 432 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 432 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data1_->_ref_count_ = 1;
#line 432 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data1_->self = g_object_ref (self);
#line 432 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = tag;
#line 432 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 432 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data1_->tag = _tmp1_;
#line 433 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp2_.stamp = 0;
#line 433 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data1_->found_iter = _tmp2_;
#line 435 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp3_ = _data1_->found_iter;
#line 435 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_vala_iter = _tmp3_;
#line 437 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp5_ = _data1_->tag;
#line 437 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp5_ == NULL) {
#line 437 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp4_ = TRUE;
#line 2562 "tracker-tags-view.c"
	} else {
		const gchar* _tmp6_;
#line 437 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp6_ = _data1_->tag;
#line 437 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp4_ = g_strcmp0 (_tmp6_, "") == 0;
#line 2569 "tracker-tags-view.c"
	}
#line 437 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp7_ = _tmp4_;
#line 437 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp7_) {
#line 438 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		result = FALSE;
#line 438 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		block1_data_unref (_data1_);
#line 438 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data1_ = NULL;
#line 438 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (iter) {
#line 438 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			*iter = _vala_iter;
#line 2585 "tracker-tags-view.c"
		}
#line 438 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return result;
#line 2589 "tracker-tags-view.c"
	}
#line 441 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp8_ = self->priv->view;
#line 441 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp9_ = gtk_tree_view_get_model (_tmp8_);
#line 441 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 441 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	model = _tmp10_;
#line 442 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data1_->found = FALSE;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp11_ = model;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_tree_model_foreach (_tmp11_, ___lambda0__gtk_tree_model_foreach_func, _data1_);
#line 458 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp12_ = _data1_->found;
#line 458 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp12_ == TRUE) {
#line 2609 "tracker-tags-view.c"
		GtkTreeIter _tmp13_;
#line 459 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp13_ = _data1_->found_iter;
#line 459 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_vala_iter = _tmp13_;
#line 460 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		result = TRUE;
#line 460 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_object_unref0 (model);
#line 460 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		block1_data_unref (_data1_);
#line 460 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data1_ = NULL;
#line 460 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (iter) {
#line 460 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			*iter = _vala_iter;
#line 2627 "tracker-tags-view.c"
		}
#line 460 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return result;
#line 2631 "tracker-tags-view.c"
	}
#line 463 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	result = FALSE;
#line 463 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (model);
#line 463 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	block1_data_unref (_data1_);
#line 463 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data1_ = NULL;
#line 463 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (iter) {
#line 463 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		*iter = _vala_iter;
#line 2645 "tracker-tags-view.c"
	}
#line 463 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return result;
#line 2649 "tracker-tags-view.c"
}


static void tracker_tags_view_remove_tag_data_free (gpointer _data) {
	TrackerTagsViewRemoveTagData* _data_;
	_data_ = _data;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tag_data_unref0 (_data_->td);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (_data_->self);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_slice_free (TrackerTagsViewRemoveTagData, _data_);
#line 2662 "tracker-tags-view.c"
}


static void tracker_tags_view_remove_tag (TrackerTagsView* self, TagData* td, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerTagsViewRemoveTagData* _data_;
	TrackerTagsView* _tmp0_;
	TagData* _tmp1_;
	TagData* _tmp2_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = g_slice_new0 (TrackerTagsViewRemoveTagData);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_tags_view_remove_tag);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_tags_view_remove_tag_data_free);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->self = _tmp0_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = td;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp2_ = _tag_data_ref0 (_tmp1_);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->td = _tmp2_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_remove_tag_co (_data_);
#line 2689 "tracker-tags-view.c"
}


static void tracker_tags_view_remove_tag_finish (TrackerTagsView* self, GAsyncResult* _res_) {
	TrackerTagsViewRemoveTagData* _data_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2697 "tracker-tags-view.c"
}


static void tracker_tags_view_remove_tag_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerTagsViewRemoveTagData* _data_;
#line 477 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = _user_data_;
#line 477 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_source_object_ = source_object;
#line 477 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_res_ = _res_;
#line 477 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_remove_tag_co (_data_);
#line 2711 "tracker-tags-view.c"
}


static gboolean tracker_tags_view_remove_tag_co (TrackerTagsViewRemoveTagData* _data_) {
#line 466 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	switch (_data_->_state_) {
#line 466 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		case 0:
#line 2720 "tracker-tags-view.c"
		goto _state_0;
#line 466 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		case 1:
#line 2724 "tracker-tags-view.c"
		goto _state_1;
		default:
#line 466 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_assert_not_reached ();
#line 2729 "tracker-tags-view.c"
	}
	_state_0:
#line 467 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp0_ = _data_->self->priv->connection;
#line 467 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_tmp0_ == NULL) {
#line 468 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp1_ = _data_->td;
#line 468 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp2_ = _data_->_tmp1_->tag_id;
#line 468 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_warning ("tracker-tags-view.vala:468: Can't remove tag '%s', no SPARQL connectio" \
"n available", _data_->_tmp2_);
#line 469 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp3_ = _data_->td;
#line 469 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->self->priv->tag_data_requests = g_list_remove (_data_->self->priv->tag_data_requests, _data_->_tmp3_);
#line 470 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->td = NULL;
#line 471 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_data_->_state_ == 0) {
#line 471 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2752 "tracker-tags-view.c"
		} else {
#line 471 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2756 "tracker-tags-view.c"
		}
#line 471 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_object_unref (_data_->_async_result);
#line 471 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 2762 "tracker-tags-view.c"
	}
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp4_ = _data_->td;
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp5_ = _data_->_tmp4_->tag_id;
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp6_ = NULL;
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp6_ = g_strdup_printf ("DELETE { <%s> a rdfs:Resource }", _data_->_tmp5_);
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->query = _data_->_tmp6_;
#line 2774 "tracker-tags-view.c"
	{
#line 477 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp7_ = _data_->self->priv->connection;
#line 477 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp8_ = _data_->query;
#line 477 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp9_ = _data_->td;
#line 477 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp10_ = _data_->_tmp9_->cancellable;
#line 477 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_state_ = 1;
#line 477 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_sparql_connection_update_async (_data_->_tmp7_, _data_->_tmp8_, G_PRIORITY_DEFAULT, _data_->_tmp10_, tracker_tags_view_remove_tag_ready, _data_);
#line 477 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 2790 "tracker-tags-view.c"
		_state_1:
#line 477 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_sparql_connection_update_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 477 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_data_->_inner_error_ != NULL) {
#line 2796 "tracker-tags-view.c"
			goto __catch19_g_error;
		}
#line 479 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_debug ("tracker-tags-view.vala:479: Tag removed");
#line 480 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp11_ = _data_->self->priv->store;
#line 480 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp12_ = _data_->td;
#line 480 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp13_ = _data_->_tmp12_->iter;
#line 480 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		gtk_list_store_remove (_data_->_tmp11_, &_data_->_tmp13_);
#line 2809 "tracker-tags-view.c"
	}
	goto __finally19;
	__catch19_g_error:
	{
#line 476 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->e = _data_->_inner_error_;
#line 476 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_inner_error_ = NULL;
#line 482 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp14_ = _data_->e;
#line 482 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp15_ = _data_->_tmp14_->message;
#line 482 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_warning ("tracker-tags-view.vala:482: Could not run Sparql update query: %s", _data_->_tmp15_);
#line 483 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp16_ = _data_->e;
#line 483 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_tags_view_show_error_dialog (_data_->self, _data_->_tmp16_);
#line 476 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_error_free0 (_data_->e);
#line 2830 "tracker-tags-view.c"
	}
	__finally19:
#line 476 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_inner_error_ != NULL) {
#line 476 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->query);
#line 476 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 476 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_clear_error (&_data_->_inner_error_);
#line 476 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 2843 "tracker-tags-view.c"
	}
#line 486 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp17_ = _data_->td;
#line 486 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->self->priv->tag_data_requests = g_list_remove (_data_->self->priv->tag_data_requests, _data_->_tmp17_);
#line 487 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->td = NULL;
#line 466 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (_data_->query);
#line 466 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_state_ == 0) {
#line 466 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2857 "tracker-tags-view.c"
	} else {
#line 466 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2861 "tracker-tags-view.c"
	}
#line 466 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_object_unref (_data_->_async_result);
#line 466 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return FALSE;
#line 2867 "tracker-tags-view.c"
}


static void tracker_tags_view_add_tag_data_free (gpointer _data) {
	TrackerTagsViewAddTagData* _data_;
	_data_ = _data;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (_data_->tag);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (_data_->self);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_slice_free (TrackerTagsViewAddTagData, _data_);
#line 2880 "tracker-tags-view.c"
}


static void tracker_tags_view_add_tag (TrackerTagsView* self, const gchar* tag, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerTagsViewAddTagData* _data_;
	TrackerTagsView* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = g_slice_new0 (TrackerTagsViewAddTagData);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_tags_view_add_tag);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_tags_view_add_tag_data_free);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->self = _tmp0_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = tag;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->tag = _tmp2_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_add_tag_co (_data_);
#line 2907 "tracker-tags-view.c"
}


static void tracker_tags_view_add_tag_finish (TrackerTagsView* self, GAsyncResult* _res_) {
	TrackerTagsViewAddTagData* _data_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2915 "tracker-tags-view.c"
}


static void tracker_tags_view_add_tag_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerTagsViewAddTagData* _data_;
#line 555 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = _user_data_;
#line 555 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_source_object_ = source_object;
#line 555 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_res_ = _res_;
#line 555 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_add_tag_co (_data_);
#line 2929 "tracker-tags-view.c"
}


static gboolean tracker_tags_view_add_tag_co (TrackerTagsViewAddTagData* _data_) {
#line 490 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	switch (_data_->_state_) {
#line 490 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		case 0:
#line 2938 "tracker-tags-view.c"
		goto _state_0;
#line 490 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		case 1:
#line 2942 "tracker-tags-view.c"
		goto _state_1;
		default:
#line 490 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_assert_not_reached ();
#line 2947 "tracker-tags-view.c"
	}
	_state_0:
#line 491 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->query = NULL;
#line 493 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp0_ = _data_->self->priv->connection;
#line 493 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_tmp0_ == NULL) {
#line 494 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp1_ = _data_->tag;
#line 494 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_warning ("tracker-tags-view.vala:494: Can't add tag '%s', no SPARQL connection a" \
"vailable", _data_->_tmp1_);
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->query);
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_data_->_state_ == 0) {
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2966 "tracker-tags-view.c"
		} else {
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2970 "tracker-tags-view.c"
		}
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_object_unref (_data_->_async_result);
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 2976 "tracker-tags-view.c"
	}
#line 498 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp2_ = _data_->self->priv->entry;
#line 498 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp2_, FALSE);
#line 500 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp3_ = _data_->self->priv->files;
#line 500 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp4_ = 0U;
#line 500 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp4_ = g_list_length (_data_->_tmp3_);
#line 500 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_tmp4_ > ((guint) 0)) {
#line 501 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp5_ = g_strdup ("");
#line 501 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->query);
#line 501 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->query = _data_->_tmp5_;
#line 503 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp6_ = NULL;
#line 503 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp6_ = tracker_tags_view_sparql_get_filter_string (_data_->self, NULL);
#line 503 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->filter = _data_->_tmp6_;
#line 504 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp7_ = _data_->tag;
#line 504 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp8_ = NULL;
#line 504 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp8_ = tracker_tags_view_sparql_get_escaped_string (_data_->self, _data_->_tmp7_);
#line 504 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->tag_escaped = _data_->_tmp8_;
#line 506 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp9_ = _data_->self->priv->files;
#line 3012 "tracker-tags-view.c"
		{
#line 506 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->url_collection = _data_->_tmp9_;
#line 506 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->url_it = NULL;
#line 506 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			for (_data_->url_it = _data_->url_collection; _data_->url_it != NULL; _data_->url_it = _data_->url_it->next) {
#line 506 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_data_->_tmp10_ = g_strdup ((const gchar*) _data_->url_it->data);
#line 506 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_data_->url = _data_->_tmp10_;
#line 3024 "tracker-tags-view.c"
				{
#line 507 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_data_->_tmp11_ = _data_->query;
#line 507 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_data_->_tmp12_ = _data_->url;
#line 507 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_data_->_tmp13_ = _data_->url;
#line 507 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_data_->_tmp14_ = NULL;
#line 507 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_data_->_tmp14_ = g_strdup_printf ("INSERT {\n" \
"				            _:file a nie:DataObject ;\n" \
"				             nie:url '%s'\n" \
"				          } WHERE {\n" \
"				            OPTIONAL {\n" \
"				               ?file a nie:DataObject ;\n" \
"				               nie:url '%s'\n" \
"				            } .\n" \
"				            FILTER (!bound(?file))\n" \
"				          }", _data_->_tmp12_, _data_->_tmp13_);
#line 507 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_data_->_tmp15_ = _data_->_tmp14_;
#line 507 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_data_->_tmp16_ = g_strconcat (_data_->_tmp11_, _data_->_tmp15_, NULL);
#line 507 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_g_free0 (_data_->query);
#line 507 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_data_->query = _data_->_tmp16_;
#line 507 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_g_free0 (_data_->_tmp15_);
#line 506 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_g_free0 (_data_->url);
#line 3048 "tracker-tags-view.c"
				}
			}
		}
#line 519 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp17_ = _data_->query;
#line 519 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp18_ = _data_->tag_escaped;
#line 519 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp19_ = _data_->tag_escaped;
#line 519 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp20_ = _data_->tag_escaped;
#line 519 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp21_ = _data_->filter;
#line 519 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp22_ = NULL;
#line 519 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp22_ = g_strdup_printf ("INSERT {\n" \
"			            _:tag a nao:Tag;\n" \
"			            nao:prefLabel %s .\n" \
"			          } WHERE {\n" \
"			            OPTIONAL {\n" \
"			              ?tag a nao:Tag ;\n" \
"			              nao:prefLabel %s\n" \
"			            } .\n" \
"			            FILTER (!bound(?tag))\n" \
"			          }\n" \
"			          INSERT {\n" \
"			            ?urn nao:hasTag ?label\n" \
"			          } WHERE {\n" \
"			            ?urn nie:url ?f .\n" \
"			            ?label nao:prefLabel %s\n" \
"			            %s\n" \
"			          }", _data_->_tmp18_, _data_->_tmp19_, _data_->_tmp20_, _data_->_tmp21_);
#line 519 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp23_ = _data_->_tmp22_;
#line 519 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp24_ = g_strconcat (_data_->_tmp17_, _data_->_tmp23_, NULL);
#line 519 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->query);
#line 519 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->query = _data_->_tmp24_;
#line 519 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->_tmp23_);
#line 500 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->tag_escaped);
#line 500 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->filter);
#line 3080 "tracker-tags-view.c"
	} else {
#line 537 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp25_ = _data_->tag;
#line 537 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp26_ = NULL;
#line 537 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp26_ = tracker_tags_view_sparql_get_escaped_string (_data_->self, _data_->_tmp25_);
#line 537 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->tag_label_escaped = _data_->_tmp26_;
#line 539 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp27_ = _data_->tag_label_escaped;
#line 539 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp28_ = _data_->tag_label_escaped;
#line 539 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp29_ = NULL;
#line 539 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp29_ = g_strdup_printf ("INSERT {\n" \
"			           _:tag a nao:Tag ;\n" \
"			           nao:prefLabel %s .\n" \
"			         } WHERE {\n" \
"			           OPTIONAL {\n" \
"			             ?tag a nao:Tag ;\n" \
"			             nao:prefLabel %s\n" \
"			           } .\n" \
"			           FILTER (!bound(?tag))\n" \
"			         }", _data_->_tmp27_, _data_->_tmp28_);
#line 539 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->query);
#line 539 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->query = _data_->_tmp29_;
#line 500 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->tag_label_escaped);
#line 3104 "tracker-tags-view.c"
	}
#line 551 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp30_ = _data_->self->priv->files;
#line 551 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp31_ = 0U;
#line 551 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp31_ = g_list_length (_data_->_tmp30_);
#line 551 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp32_ = tag_data_new (NULL, NULL, FALSE, TRUE, (gint) _data_->_tmp31_, _data_->self);
#line 551 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->td = _data_->_tmp32_;
#line 552 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp33_ = _data_->td;
#line 552 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp34_ = _tag_data_ref0 (_data_->_tmp33_);
#line 552 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->self->priv->tag_data_requests = g_list_prepend (_data_->self->priv->tag_data_requests, _data_->_tmp34_);
#line 3122 "tracker-tags-view.c"
	{
#line 555 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp35_ = _data_->self->priv->connection;
#line 555 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp36_ = _data_->query;
#line 555 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp37_ = _data_->td;
#line 555 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp38_ = _data_->_tmp37_->cancellable;
#line 555 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_state_ = 1;
#line 555 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_sparql_connection_update_async (_data_->_tmp35_, _data_->_tmp36_, G_PRIORITY_DEFAULT, _data_->_tmp38_, tracker_tags_view_add_tag_ready, _data_);
#line 555 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 3138 "tracker-tags-view.c"
		_state_1:
#line 555 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_sparql_connection_update_finish (_data_->_tmp35_, _data_->_res_, &_data_->_inner_error_);
#line 555 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_data_->_inner_error_ != NULL) {
#line 3144 "tracker-tags-view.c"
			goto __catch20_g_error;
		}
#line 557 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_debug ("tracker-tags-view.vala:557: Updated tags");
#line 558 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp39_ = _data_->td;
#line 558 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_tags_view_update_tag_data (_data_->self, _data_->_tmp39_);
#line 561 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp40_ = _data_->self->priv->entry;
#line 561 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		gtk_entry_set_text (_data_->_tmp40_, "");
#line 3157 "tracker-tags-view.c"
	}
	goto __finally20;
	__catch20_g_error:
	{
#line 554 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->e = _data_->_inner_error_;
#line 554 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_inner_error_ = NULL;
#line 563 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp41_ = _data_->e;
#line 563 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp42_ = _data_->_tmp41_->message;
#line 563 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_warning ("tracker-tags-view.vala:563: Could not run Sparql update query: %s", _data_->_tmp42_);
#line 564 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp43_ = _data_->e;
#line 564 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_tags_view_show_error_dialog (_data_->self, _data_->_tmp43_);
#line 554 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_error_free0 (_data_->e);
#line 3178 "tracker-tags-view.c"
	}
	__finally20:
#line 554 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_inner_error_ != NULL) {
#line 554 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tag_data_unref0 (_data_->td);
#line 554 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->query);
#line 554 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 554 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_clear_error (&_data_->_inner_error_);
#line 554 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 3193 "tracker-tags-view.c"
	}
#line 567 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp44_ = _data_->td;
#line 567 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->self->priv->tag_data_requests = g_list_remove (_data_->self->priv->tag_data_requests, _data_->_tmp44_);
#line 568 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tag_data_unref0 (_data_->td);
#line 568 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->td = NULL;
#line 570 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp45_ = _data_->self->priv->entry;
#line 570 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp45_, TRUE);
#line 490 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tag_data_unref0 (_data_->td);
#line 490 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (_data_->query);
#line 490 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_state_ == 0) {
#line 490 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3215 "tracker-tags-view.c"
	} else {
#line 490 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3219 "tracker-tags-view.c"
	}
#line 490 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_object_unref (_data_->_async_result);
#line 490 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return FALSE;
#line 3225 "tracker-tags-view.c"
}


static void tracker_tags_view_update_tag_data (TrackerTagsView* self, TagData* td) {
	GtkEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* tag;
	TagData* _tmp2_;
	gboolean _tmp3_;
#line 573 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (self != NULL);
#line 573 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_if_fail (td != NULL);
#line 574 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = self->priv->entry;
#line 574 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 574 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tag = _tmp1_;
#line 576 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp2_ = td;
#line 576 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp3_ = _tmp2_->update;
#line 576 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp3_ == FALSE) {
#line 3251 "tracker-tags-view.c"
		GtkTreeIter iter = {0};
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_ = {0};
		GtkListStore* _tmp6_;
		GtkTreeIter _tmp7_;
		TagData* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		TagData* _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		TagData* _tmp15_;
		gint _tmp16_;
#line 579 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_debug ("tracker-tags-view.vala:579: Setting tag selection state to ON (new)");
#line 581 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp4_ = self->priv->store;
#line 581 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		gtk_list_store_append (_tmp4_, &_tmp5_);
#line 581 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		iter = _tmp5_;
#line 582 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp6_ = self->priv->store;
#line 582 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp7_ = iter;
#line 582 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp8_ = td;
#line 582 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp9_ = _tmp8_->tag_id;
#line 582 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp10_ = tag;
#line 582 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp11_ = td;
#line 582 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp12_ = _tmp11_->items;
#line 582 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp13_ = g_strdup_printf ("%d", _tmp12_);
#line 582 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp14_ = _tmp13_;
#line 582 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp15_ = td;
#line 582 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp16_ = _tmp15_->items;
#line 582 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		gtk_list_store_set (_tmp6_, &_tmp7_, TRACKER_TAGS_VIEW_COL_TAG_ID, _tmp9_, TRACKER_TAGS_VIEW_COL_TAG_NAME, _tmp10_, TRACKER_TAGS_VIEW_COL_TAG_COUNT, _tmp14_, TRACKER_TAGS_VIEW_COL_TAG_COUNT_VALUE, _tmp16_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_TRUE, -1, -1);
#line 582 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_tmp14_);
#line 3300 "tracker-tags-view.c"
	} else {
		TagData* _tmp17_;
		gboolean _tmp18_;
#line 589 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp17_ = td;
#line 589 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp18_ = _tmp17_->selected;
#line 589 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_tmp18_ == TRUE) {
#line 3310 "tracker-tags-view.c"
			GtkListStore* _tmp19_;
			TagData* _tmp20_;
			GtkTreeIter _tmp21_;
			TagData* _tmp22_;
			TagData* _tmp23_;
			TagData* _tmp24_;
#line 590 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_debug ("tracker-tags-view.vala:590: Setting tag selection state to ON");
#line 592 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp19_ = self->priv->store;
#line 592 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp20_ = td;
#line 592 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp21_ = _tmp20_->iter;
#line 592 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			gtk_list_store_set (_tmp19_, &_tmp21_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_TRUE, -1, -1);
#line 594 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp22_ = td;
#line 594 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp23_ = _tag_data_ref0 (_tmp22_);
#line 594 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			self->priv->tag_data_requests = g_list_prepend (self->priv->tag_data_requests, _tmp23_);
#line 595 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp24_ = td;
#line 595 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			tracker_tags_view_query_files_for_tag_id (self, _tmp24_, NULL, NULL);
#line 3337 "tracker-tags-view.c"
		} else {
			GtkListStore* _tmp25_;
			TagData* _tmp26_;
			GtkTreeIter _tmp27_;
			TagData* _tmp28_;
			TagData* _tmp29_;
			TagData* _tmp30_;
#line 597 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_debug ("tracker-tags-view.vala:597: Setting tag selection state to FALSE");
#line 599 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp25_ = self->priv->store;
#line 599 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp26_ = td;
#line 599 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp27_ = _tmp26_->iter;
#line 599 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			gtk_list_store_set (_tmp25_, &_tmp27_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_FALSE, -1, -1);
#line 601 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp28_ = td;
#line 601 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp29_ = _tag_data_ref0 (_tmp28_);
#line 601 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			self->priv->tag_data_requests = g_list_prepend (self->priv->tag_data_requests, _tmp29_);
#line 602 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp30_ = td;
#line 602 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			tracker_tags_view_query_files_for_tag_id (self, _tmp30_, NULL, NULL);
#line 3365 "tracker-tags-view.c"
		}
	}
}


static void tracker_tags_view_query_tags_data_free (gpointer _data) {
	TrackerTagsViewQueryTagsData* _data_;
	_data_ = _data;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (_data_->self);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_slice_free (TrackerTagsViewQueryTagsData, _data_);
#line 3378 "tracker-tags-view.c"
}


static void tracker_tags_view_query_tags (TrackerTagsView* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerTagsViewQueryTagsData* _data_;
	TrackerTagsView* _tmp0_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = g_slice_new0 (TrackerTagsViewQueryTagsData);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_tags_view_query_tags);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_tags_view_query_tags_data_free);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->self = _tmp0_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_query_tags_co (_data_);
#line 3397 "tracker-tags-view.c"
}


static void tracker_tags_view_query_tags_finish (TrackerTagsView* self, GAsyncResult* _res_) {
	TrackerTagsViewQueryTagsData* _data_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3405 "tracker-tags-view.c"
}


static void tracker_tags_view_query_tags_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerTagsViewQueryTagsData* _data_;
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = _user_data_;
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_source_object_ = source_object;
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_res_ = _res_;
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_query_tags_co (_data_);
#line 3419 "tracker-tags-view.c"
}


static gboolean tracker_tags_view_query_tags_co (TrackerTagsViewQueryTagsData* _data_) {
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	switch (_data_->_state_) {
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		case 0:
#line 3428 "tracker-tags-view.c"
		goto _state_0;
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		case 1:
#line 3432 "tracker-tags-view.c"
		goto _state_1;
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		case 2:
#line 3436 "tracker-tags-view.c"
		goto _state_2;
		default:
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_assert_not_reached ();
#line 3441 "tracker-tags-view.c"
	}
	_state_0:
#line 608 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp0_ = g_strdup ("SELECT ?urn ?label WHERE { ?urn a nao:Tag ; nao:prefLabel ?label . } O" \
"RDER BY ?label");
#line 608 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->query = _data_->_tmp0_;
#line 610 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_debug ("tracker-tags-view.vala:610: Clearing tags in store");
#line 611 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp1_ = _data_->self->priv->store;
#line 611 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	gtk_list_store_clear (_data_->_tmp1_);
#line 3454 "tracker-tags-view.c"
	{
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp2_ = _data_->self->priv->connection;
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp3_ = _data_->query;
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_state_ = 1;
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_sparql_connection_query_async (_data_->_tmp2_, _data_->_tmp3_, NULL, tracker_tags_view_query_tags_ready, _data_);
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 3466 "tracker-tags-view.c"
		_state_1:
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp4_ = NULL;
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp4_ = tracker_sparql_connection_query_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->cursor = _data_->_tmp4_;
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_data_->_inner_error_ != NULL) {
#line 3476 "tracker-tags-view.c"
			goto __catch21_g_error;
		}
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		while (TRUE) {
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp5_ = _data_->cursor;
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_state_ = 2;
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			tracker_sparql_cursor_next_async (_data_->_tmp5_, NULL, tracker_tags_view_query_tags_ready, _data_);
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			return FALSE;
#line 3489 "tracker-tags-view.c"
			_state_2:
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp6_ = FALSE;
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp6_ = tracker_sparql_cursor_next_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp7_ = _data_->_tmp6_;
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			if (_data_->_inner_error_ != NULL) {
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_g_object_unref0 (_data_->cursor);
#line 3501 "tracker-tags-view.c"
				goto __catch21_g_error;
			}
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			if (!_data_->_tmp7_) {
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				break;
#line 3508 "tracker-tags-view.c"
			}
#line 618 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_debug ("tracker-tags-view.vala:618: Adding all tags...");
#line 620 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp8_ = _data_->cursor;
#line 620 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp9_ = NULL;
#line 620 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp9_ = tracker_sparql_cursor_get_string (_data_->_tmp8_, 0, NULL);
#line 620 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->id = _data_->_tmp9_;
#line 621 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp10_ = _data_->cursor;
#line 621 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp11_ = NULL;
#line 621 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp11_ = tracker_sparql_cursor_get_string (_data_->_tmp10_, 1, NULL);
#line 621 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->label = _data_->_tmp11_;
#line 623 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp12_ = _data_->id;
#line 623 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp13_ = _data_->label;
#line 623 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_debug ("tracker-tags-view.vala:623:   Adding tag id:'%s' with label:'%s' to st" \
"ore", _data_->_tmp12_, _data_->_tmp13_);
#line 626 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp14_ = _data_->self->priv->store;
#line 626 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			memset (&_data_->_tmp15_, 0, sizeof (GtkTreeIter));
#line 626 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			gtk_list_store_append (_data_->_tmp14_, &_data_->_tmp15_);
#line 626 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->iter = _data_->_tmp15_;
#line 628 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp16_ = _data_->self->priv->store;
#line 628 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp17_ = _data_->iter;
#line 628 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp18_ = _data_->id;
#line 628 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp19_ = _data_->label;
#line 628 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			gtk_list_store_set (_data_->_tmp16_, &_data_->_tmp17_, TRACKER_TAGS_VIEW_COL_TAG_ID, _data_->_tmp18_, TRACKER_TAGS_VIEW_COL_TAG_NAME, _data_->_tmp19_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_FALSE, -1, -1);
#line 634 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp20_ = _data_->id;
#line 634 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp21_ = _data_->iter;
#line 634 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp22_ = tag_data_new (_data_->_tmp20_, &_data_->_tmp21_, FALSE, TRUE, 1, _data_->self);
#line 634 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->td = _data_->_tmp22_;
#line 635 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp23_ = _data_->td;
#line 635 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp24_ = _tag_data_ref0 (_data_->_tmp23_);
#line 635 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->self->priv->tag_data_requests = g_list_prepend (_data_->self->priv->tag_data_requests, _data_->_tmp24_);
#line 637 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp25_ = _data_->td;
#line 637 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			tracker_tags_view_query_files_for_tag_id (_data_->self, _data_->_tmp25_, NULL, NULL);
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tag_data_unref0 (_data_->td);
#line 3572 "tracker-tags-view.c"
		}
#line 613 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_object_unref0 (_data_->cursor);
#line 3576 "tracker-tags-view.c"
	}
	goto __finally21;
	__catch21_g_error:
	{
#line 613 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->e = _data_->_inner_error_;
#line 613 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_inner_error_ = NULL;
#line 640 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp26_ = _data_->e;
#line 640 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp27_ = _data_->_tmp26_->message;
#line 640 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_warning ("tracker-tags-view.vala:640: Could not run Sparql query: %s", _data_->_tmp27_);
#line 641 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp28_ = _data_->e;
#line 641 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_tags_view_show_error_dialog (_data_->self, _data_->_tmp28_);
#line 613 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_error_free0 (_data_->e);
#line 3597 "tracker-tags-view.c"
	}
	__finally21:
#line 613 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_inner_error_ != NULL) {
#line 613 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->query);
#line 613 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 613 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_clear_error (&_data_->_inner_error_);
#line 613 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 3610 "tracker-tags-view.c"
	}
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (_data_->query);
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_state_ == 0) {
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3618 "tracker-tags-view.c"
	} else {
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3622 "tracker-tags-view.c"
	}
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_object_unref (_data_->_async_result);
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return FALSE;
#line 3628 "tracker-tags-view.c"
}


static void tracker_tags_view_query_files_for_tag_id_data_free (gpointer _data) {
	TrackerTagsViewQueryFilesForTagIdData* _data_;
	_data_ = _data;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tag_data_unref0 (_data_->td);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (_data_->self);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_slice_free (TrackerTagsViewQueryFilesForTagIdData, _data_);
#line 3641 "tracker-tags-view.c"
}


static void tracker_tags_view_query_files_for_tag_id (TrackerTagsView* self, TagData* td, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerTagsViewQueryFilesForTagIdData* _data_;
	TrackerTagsView* _tmp0_;
	TagData* _tmp1_;
	TagData* _tmp2_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = g_slice_new0 (TrackerTagsViewQueryFilesForTagIdData);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_tags_view_query_files_for_tag_id);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_tags_view_query_files_for_tag_id_data_free);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->self = _tmp0_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = td;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp2_ = _tag_data_ref0 (_tmp1_);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->td = _tmp2_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_query_files_for_tag_id_co (_data_);
#line 3668 "tracker-tags-view.c"
}


static void tracker_tags_view_query_files_for_tag_id_finish (TrackerTagsView* self, GAsyncResult* _res_) {
	TrackerTagsViewQueryFilesForTagIdData* _data_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3676 "tracker-tags-view.c"
}


static void tracker_tags_view_query_files_for_tag_id_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerTagsViewQueryFilesForTagIdData* _data_;
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_ = _user_data_;
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_source_object_ = source_object;
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_res_ = _res_;
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_query_files_for_tag_id_co (_data_);
#line 3690 "tracker-tags-view.c"
}


static gboolean tracker_tags_view_query_files_for_tag_id_co (TrackerTagsViewQueryFilesForTagIdData* _data_) {
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	switch (_data_->_state_) {
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		case 0:
#line 3699 "tracker-tags-view.c"
		goto _state_0;
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		case 1:
#line 3703 "tracker-tags-view.c"
		goto _state_1;
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		case 2:
#line 3707 "tracker-tags-view.c"
		goto _state_2;
		default:
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_assert_not_reached ();
#line 3712 "tracker-tags-view.c"
	}
	_state_0:
#line 646 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp0_ = _data_->self->priv->connection;
#line 646 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_tmp0_ == NULL) {
#line 647 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp1_ = _data_->td;
#line 647 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp2_ = _data_->_tmp1_->tag_id;
#line 647 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_warning ("tracker-tags-view.vala:647: Can't query files for tag id '%s', no SPAR" \
"QL connection available", _data_->_tmp2_);
#line 648 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp3_ = _data_->td;
#line 648 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->self->priv->tag_data_requests = g_list_remove (_data_->self->priv->tag_data_requests, _data_->_tmp3_);
#line 649 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->td = NULL;
#line 650 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_data_->_state_ == 0) {
#line 650 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3735 "tracker-tags-view.c"
		} else {
#line 650 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3739 "tracker-tags-view.c"
		}
#line 650 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_object_unref (_data_->_async_result);
#line 650 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 3745 "tracker-tags-view.c"
	}
#line 653 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp4_ = _data_->td;
#line 653 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp5_ = _data_->_tmp4_->tag_id;
#line 653 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp6_ = NULL;
#line 653 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp6_ = g_strdup_printf ("SELECT ?url WHERE { ?urn a rdfs:Resource ; nie:url ?url ; nao:hasTag <" \
"%s> . }", _data_->_tmp5_);
#line 653 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->query = _data_->_tmp6_;
#line 3757 "tracker-tags-view.c"
	{
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp7_ = _data_->self->priv->connection;
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp8_ = _data_->query;
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp9_ = _data_->td;
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp10_ = _data_->_tmp9_->cancellable;
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_state_ = 1;
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_sparql_connection_query_async (_data_->_tmp7_, _data_->_tmp8_, _data_->_tmp10_, tracker_tags_view_query_files_for_tag_id_ready, _data_);
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 3773 "tracker-tags-view.c"
		_state_1:
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp11_ = NULL;
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp11_ = tracker_sparql_connection_query_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->cursor = _data_->_tmp11_;
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_data_->_inner_error_ != NULL) {
#line 3783 "tracker-tags-view.c"
			goto __catch22_g_error;
		}
#line 658 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->has_tag_in_selection = (guint) 0;
#line 659 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->files_with_tag = (guint) 0;
#line 660 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp12_ = _data_->self->priv->files;
#line 660 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp13_ = 0U;
#line 660 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp13_ = g_list_length (_data_->_tmp12_);
#line 660 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->files_selected = _data_->_tmp13_;
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		while (TRUE) {
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp14_ = _data_->cursor;
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_state_ = 2;
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			tracker_sparql_cursor_next_async (_data_->_tmp14_, NULL, tracker_tags_view_query_files_for_tag_id_ready, _data_);
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			return FALSE;
#line 3808 "tracker-tags-view.c"
			_state_2:
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp15_ = FALSE;
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp15_ = tracker_sparql_cursor_next_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error_);
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp16_ = _data_->_tmp15_;
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			if (_data_->_inner_error_ != NULL) {
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_g_object_unref0 (_data_->cursor);
#line 3820 "tracker-tags-view.c"
				goto __catch22_g_error;
			}
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			if (!_data_->_tmp16_) {
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				break;
#line 3827 "tracker-tags-view.c"
			}
#line 663 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp17_ = _data_->files_with_tag;
#line 663 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->files_with_tag = _data_->_tmp17_ + 1;
#line 665 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp18_ = _data_->self->priv->files;
#line 3835 "tracker-tags-view.c"
			{
#line 665 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_data_->url_collection = _data_->_tmp18_;
#line 665 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_data_->url_it = NULL;
#line 665 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				for (_data_->url_it = _data_->url_collection; _data_->url_it != NULL; _data_->url_it = _data_->url_it->next) {
#line 665 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_data_->_tmp19_ = g_strdup ((const gchar*) _data_->url_it->data);
#line 665 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_data_->url = _data_->_tmp19_;
#line 3847 "tracker-tags-view.c"
					{
#line 666 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
						_data_->_tmp20_ = _data_->cursor;
#line 666 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
						_data_->_tmp21_ = NULL;
#line 666 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
						_data_->_tmp21_ = tracker_sparql_cursor_get_string (_data_->_tmp20_, 0, NULL);
#line 666 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
						_data_->url_returned = _data_->_tmp21_;
#line 668 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
						_data_->_tmp22_ = _data_->url;
#line 668 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
						_data_->_tmp23_ = _data_->url_returned;
#line 668 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
						g_debug ("tracker-tags-view.vala:668: --> '%s' vs '%s'", _data_->_tmp22_, _data_->_tmp23_);
#line 670 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
						_data_->_tmp24_ = _data_->url_returned;
#line 670 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
						if (_data_->_tmp24_ == NULL) {
#line 671 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
							_g_free0 (_data_->url);
#line 671 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
							continue;
#line 3871 "tracker-tags-view.c"
						}
#line 674 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
						_data_->_tmp25_ = _data_->url_returned;
#line 674 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
						_data_->_tmp26_ = _data_->url;
#line 674 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
						if (g_strcmp0 (_data_->_tmp25_, _data_->_tmp26_) == 0) {
#line 675 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
							_data_->_tmp27_ = _data_->has_tag_in_selection;
#line 675 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
							_data_->has_tag_in_selection = _data_->_tmp27_ + 1;
#line 676 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
							_g_free0 (_data_->url);
#line 676 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
							break;
#line 3887 "tracker-tags-view.c"
						}
#line 665 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
						_g_free0 (_data_->url);
#line 3891 "tracker-tags-view.c"
					}
				}
			}
		}
#line 681 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp28_ = _data_->has_tag_in_selection;
#line 681 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp29_ = _data_->files_with_tag;
#line 681 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp30_ = _data_->files_selected;
#line 681 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_debug ("tracker-tags-view.vala:681: Querying files with tag, in selection:%ld," \
" in total:%ld, selected:%ld", (glong) _data_->_tmp28_, (glong) _data_->_tmp29_, (glong) _data_->_tmp30_);
#line 684 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp31_ = _data_->has_tag_in_selection;
#line 684 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		if (_data_->_tmp31_ == ((guint) 0)) {
#line 685 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp32_ = _data_->self->priv->store;
#line 685 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp33_ = _data_->td;
#line 685 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp34_ = _data_->_tmp33_->iter;
#line 685 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			gtk_list_store_set (_data_->_tmp32_, &_data_->_tmp34_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_FALSE, -1, -1);
#line 3916 "tracker-tags-view.c"
		} else {
#line 686 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp35_ = _data_->files_selected;
#line 686 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_data_->_tmp36_ = _data_->has_tag_in_selection;
#line 686 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			if (_data_->_tmp35_ != _data_->_tmp36_) {
#line 687 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_data_->_tmp37_ = _data_->self->priv->store;
#line 687 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_data_->_tmp38_ = _data_->td;
#line 687 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_data_->_tmp39_ = _data_->_tmp38_->iter;
#line 687 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				gtk_list_store_set (_data_->_tmp37_, &_data_->_tmp39_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_INCONSISTENT, -1, -1);
#line 3932 "tracker-tags-view.c"
			} else {
#line 689 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_data_->_tmp40_ = _data_->self->priv->store;
#line 689 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_data_->_tmp41_ = _data_->td;
#line 689 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_data_->_tmp42_ = _data_->_tmp41_->iter;
#line 689 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				gtk_list_store_set (_data_->_tmp40_, &_data_->_tmp42_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_TRUE, -1, -1);
#line 3942 "tracker-tags-view.c"
			}
		}
#line 692 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp43_ = _data_->files_with_tag;
#line 692 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp44_ = NULL;
#line 692 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp44_ = g_strdup_printf ("%ld", (glong) _data_->_tmp43_);
#line 692 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->str = _data_->_tmp44_;
#line 693 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp45_ = _data_->self->priv->store;
#line 693 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp46_ = _data_->td;
#line 693 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp47_ = _data_->_tmp46_->iter;
#line 693 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp48_ = _data_->str;
#line 693 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp49_ = _data_->files_with_tag;
#line 693 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		gtk_list_store_set (_data_->_tmp45_, &_data_->_tmp47_, TRACKER_TAGS_VIEW_COL_TAG_COUNT, _data_->_tmp48_, TRACKER_TAGS_VIEW_COL_TAG_COUNT_VALUE, _data_->_tmp49_, -1, -1);
#line 695 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_debug ("tracker-tags-view.vala:695: Tags for file updated");
#line 655 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->str);
#line 655 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_object_unref0 (_data_->cursor);
#line 3971 "tracker-tags-view.c"
	}
	goto __finally22;
	__catch22_g_error:
	{
#line 655 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->e = _data_->_inner_error_;
#line 655 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_inner_error_ = NULL;
#line 697 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp50_ = _data_->e;
#line 697 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp51_ = _data_->_tmp50_->message;
#line 697 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_warning ("tracker-tags-view.vala:697: Could not run Sparql query: %s", _data_->_tmp51_);
#line 698 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_data_->_tmp52_ = _data_->e;
#line 698 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		tracker_tags_view_show_error_dialog (_data_->self, _data_->_tmp52_);
#line 655 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_error_free0 (_data_->e);
#line 3992 "tracker-tags-view.c"
	}
	__finally22:
#line 655 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_inner_error_ != NULL) {
#line 655 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_data_->query);
#line 655 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 655 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_clear_error (&_data_->_inner_error_);
#line 655 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		return FALSE;
#line 4005 "tracker-tags-view.c"
	}
#line 701 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->_tmp53_ = _data_->td;
#line 701 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->self->priv->tag_data_requests = g_list_remove (_data_->self->priv->tag_data_requests, _data_->_tmp53_);
#line 702 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_data_->td = NULL;
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (_data_->query);
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_data_->_state_ == 0) {
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4019 "tracker-tags-view.c"
	} else {
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4023 "tracker-tags-view.c"
	}
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_object_unref (_data_->_async_result);
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return FALSE;
#line 4029 "tracker-tags-view.c"
}


static gchar* tracker_tags_view_sparql_get_filter_string (TrackerTagsView* self, const gchar* tag) {
	gchar* result = NULL;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	gchar* _tmp2_;
	gchar* filter;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	gboolean first;
	GList* _tmp9_;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_;
	gboolean _tmp22_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
#line 705 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 705 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = self->priv->files;
#line 705 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 705 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_val_if_fail (_tmp1_ > ((guint) 0), NULL);
#line 706 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp2_ = g_strdup ("FILTER (");
#line 706 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	filter = _tmp2_;
#line 708 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp4_ = tag;
#line 708 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp4_ != NULL) {
#line 4065 "tracker-tags-view.c"
		const gchar* _tmp5_;
#line 708 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp5_ = tag;
#line 708 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
#line 4071 "tracker-tags-view.c"
	} else {
#line 708 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp3_ = FALSE;
#line 4075 "tracker-tags-view.c"
	}
#line 708 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp6_ = _tmp3_;
#line 708 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp6_) {
#line 4081 "tracker-tags-view.c"
		const gchar* _tmp7_;
		gchar* _tmp8_;
#line 709 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp7_ = filter;
#line 709 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp8_ = g_strconcat (_tmp7_, "(", NULL);
#line 709 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (filter);
#line 709 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		filter = _tmp8_;
#line 4092 "tracker-tags-view.c"
	}
#line 712 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	first = TRUE;
#line 714 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp9_ = self->priv->files;
#line 4098 "tracker-tags-view.c"
	{
		GList* url_collection = NULL;
		GList* url_it = NULL;
#line 714 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		url_collection = _tmp9_;
#line 714 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		for (url_it = url_collection; url_it != NULL; url_it = url_it->next) {
#line 4106 "tracker-tags-view.c"
			gchar* _tmp10_;
			gchar* url = NULL;
#line 714 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			_tmp10_ = g_strdup ((const gchar*) url_it->data);
#line 714 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			url = _tmp10_;
#line 4113 "tracker-tags-view.c"
			{
				gboolean _tmp11_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				gchar* _tmp18_;
#line 715 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_tmp11_ = first;
#line 715 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				if (!_tmp11_) {
#line 4125 "tracker-tags-view.c"
					const gchar* _tmp12_;
					gchar* _tmp13_;
#line 716 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_tmp12_ = filter;
#line 716 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_tmp13_ = g_strconcat (_tmp12_, " || ", NULL);
#line 716 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_g_free0 (filter);
#line 716 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					filter = _tmp13_;
#line 4136 "tracker-tags-view.c"
				}
#line 719 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_tmp14_ = filter;
#line 719 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_tmp15_ = url;
#line 719 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_tmp16_ = g_strdup_printf ("?f = \"%s\"", _tmp15_);
#line 719 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_tmp17_ = _tmp16_;
#line 719 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
#line 719 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_g_free0 (filter);
#line 719 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				filter = _tmp18_;
#line 719 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_g_free0 (_tmp17_);
#line 720 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				first = FALSE;
#line 714 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_g_free0 (url);
#line 4158 "tracker-tags-view.c"
			}
		}
	}
#line 723 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp20_ = tag;
#line 723 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp20_ != NULL) {
#line 4166 "tracker-tags-view.c"
		const gchar* _tmp21_;
#line 723 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp21_ = tag;
#line 723 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp19_ = g_strcmp0 (_tmp21_, "") != 0;
#line 4172 "tracker-tags-view.c"
	} else {
#line 723 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp19_ = FALSE;
#line 4176 "tracker-tags-view.c"
	}
#line 723 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp22_ = _tmp19_;
#line 723 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp22_) {
#line 4182 "tracker-tags-view.c"
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		gchar* _tmp27_;
#line 724 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp23_ = filter;
#line 724 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp24_ = tag;
#line 724 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp25_ = g_strdup_printf (") && ?t = <%s>", _tmp24_);
#line 724 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp26_ = _tmp25_;
#line 724 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp27_ = g_strconcat (_tmp23_, _tmp26_, NULL);
#line 724 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (filter);
#line 724 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		filter = _tmp27_;
#line 724 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_free0 (_tmp26_);
#line 4204 "tracker-tags-view.c"
	}
#line 727 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp28_ = filter;
#line 727 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp29_ = g_strconcat (_tmp28_, ")", NULL);
#line 727 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (filter);
#line 727 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	filter = _tmp29_;
#line 729 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	result = filter;
#line 729 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return result;
#line 4218 "tracker-tags-view.c"
}


static gchar* tracker_tags_view_sparql_get_escaped_string (TrackerTagsView* self, const gchar* str) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* escaped;
	gchar* _tmp2_ = NULL;
#line 732 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 732 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 733 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = str;
#line 733 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp1_ = tracker_sparql_escape_string (_tmp0_);
#line 733 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	escaped = _tmp1_;
#line 734 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp2_ = g_strdup_printf ("\"%s\"", escaped);
#line 734 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	result = _tmp2_;
#line 734 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_free0 (escaped);
#line 734 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	return result;
#line 4246 "tracker-tags-view.c"
}


static void tracker_tags_view_class_init (TrackerTagsViewClass * klass) {
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	tracker_tags_view_parent_class = g_type_class_peek_parent (klass);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	g_type_class_add_private (klass, sizeof (TrackerTagsViewPrivate));
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_tags_view_finalize;
#line 4257 "tracker-tags-view.c"
}


static void tracker_tags_view_instance_init (TrackerTagsView * self) {
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self->priv = TRACKER_TAGS_VIEW_GET_PRIVATE (self);
#line 4264 "tracker-tags-view.c"
}


static void tracker_tags_view_finalize (GObject* obj) {
	TrackerTagsView * self;
	GCancellable* _tmp0_;
	GList* _tmp2_;
	GList* _tmp5_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	self = TRACKER_TAGS_VIEW (obj);
#line 112 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp0_ = self->priv->cancellable;
#line 112 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp0_ != NULL) {
#line 4279 "tracker-tags-view.c"
		GCancellable* _tmp1_;
#line 113 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp1_ = self->priv->cancellable;
#line 113 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		g_cancellable_cancel (_tmp1_);
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_g_object_unref0 (self->priv->cancellable);
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		self->priv->cancellable = NULL;
#line 4289 "tracker-tags-view.c"
	}
#line 117 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp2_ = self->priv->files;
#line 117 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp2_ != NULL) {
#line 4295 "tracker-tags-view.c"
		GList* _tmp3_;
#line 118 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp3_ = self->priv->files;
#line 4299 "tracker-tags-view.c"
		{
			GList* url_collection = NULL;
			GList* url_it = NULL;
#line 118 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			url_collection = _tmp3_;
#line 118 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			for (url_it = url_collection; url_it != NULL; url_it = url_it->next) {
#line 4307 "tracker-tags-view.c"
				gchar* _tmp4_;
				gchar* url = NULL;
#line 118 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_tmp4_ = g_strdup ((const gchar*) url_it->data);
#line 118 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				url = _tmp4_;
#line 4314 "tracker-tags-view.c"
				{
#line 119 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_g_free0 (url);
#line 119 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					url = NULL;
#line 118 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_g_free0 (url);
#line 4322 "tracker-tags-view.c"
				}
			}
		}
#line 122 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		__g_list_free__g_free0_0 (self->priv->files);
#line 122 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		self->priv->files = NULL;
#line 4330 "tracker-tags-view.c"
	}
#line 125 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_tmp5_ = self->priv->tag_data_requests;
#line 125 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	if (_tmp5_ != NULL) {
#line 4336 "tracker-tags-view.c"
		GList* _tmp6_;
#line 126 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		_tmp6_ = self->priv->tag_data_requests;
#line 4340 "tracker-tags-view.c"
		{
			GList* td_collection = NULL;
			GList* td_it = NULL;
#line 126 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			td_collection = _tmp6_;
#line 126 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
			for (td_it = td_collection; td_it != NULL; td_it = td_it->next) {
#line 4348 "tracker-tags-view.c"
				TagData* _tmp7_;
				TagData* td = NULL;
#line 126 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				_tmp7_ = _tag_data_ref0 ((TagData*) td_it->data);
#line 126 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
				td = _tmp7_;
#line 4355 "tracker-tags-view.c"
				{
#line 127 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_tag_data_unref0 (td);
#line 127 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					td = NULL;
#line 126 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
					_tag_data_unref0 (td);
#line 4363 "tracker-tags-view.c"
				}
			}
		}
#line 130 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		__g_list_free__tag_data_unref0_0 (self->priv->tag_data_requests);
#line 130 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
		self->priv->tag_data_requests = NULL;
#line 4371 "tracker-tags-view.c"
	}
#line 57 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->connection);
#line 58 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 60 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	__g_list_free__tag_data_unref0_0 (self->priv->tag_data_requests);
#line 61 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	__g_list_free__g_free0_0 (self->priv->files);
#line 63 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->store);
#line 67 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->vbox);
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->label);
#line 69 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->entry);
#line 70 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->button_add);
#line 71 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->button_remove);
#line 72 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->scrolled_window);
#line 73 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	_g_object_unref0 (self->priv->view);
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-tags-view.vala"
	G_OBJECT_CLASS (tracker_tags_view_parent_class)->finalize (obj);
#line 4399 "tracker-tags-view.c"
}


GType tracker_tags_view_get_type (void) {
	static volatile gsize tracker_tags_view_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_tags_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerTagsViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_tags_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerTagsView), 0, (GInstanceInitFunc) tracker_tags_view_instance_init, NULL };
		GType tracker_tags_view_type_id;
		tracker_tags_view_type_id = g_type_register_static (GTK_TYPE_VBOX, "TrackerTagsView", &g_define_type_info, 0);
		g_once_init_leave (&tracker_tags_view_type_id__volatile, tracker_tags_view_type_id);
	}
	return tracker_tags_view_type_id__volatile;
}



