/*
 * Copyright (C) 2008-2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-common/tracker-property.h>
#include <libtracker-common/tracker-ontology.h>
#include <libtracker-common/tracker-namespace.h>
#include <libtracker-db/tracker-db-interface.h>
#include <libtracker-data/tracker-data-query.h>
#include <libtracker-data/tracker-data-update.h>
#include <libtracker-db/tracker-db-manager.h>
#include <libtracker-common/tracker-type-utils.h>
#include <libtracker-common/tracker-class.h>
#include <float.h>
#include <math.h>


#define TRACKER_TYPE_SPARQL_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_QUERY, TrackerSparqlQueryClass))
#define TRACKER_IS_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_QUERY))
#define TRACKER_IS_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;

#define TRACKER_SPARQL_QUERY_TYPE_TOKEN_INFO (tracker_sparql_query_token_info_get_type ())

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;
typedef struct _TrackerSparqlQueryTokenInfo TrackerSparqlQueryTokenInfo;

#define TRACKER_SPARQL_QUERY_TYPE_DATA_TABLE (tracker_sparql_query_data_table_get_type ())
#define TRACKER_SPARQL_QUERY_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_QUERY_TYPE_DATA_TABLE, TrackerSparqlQueryDataTable))
#define TRACKER_SPARQL_QUERY_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_QUERY_TYPE_DATA_TABLE, TrackerSparqlQueryDataTableClass))
#define TRACKER_SPARQL_QUERY_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_QUERY_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_QUERY_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_QUERY_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_QUERY_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_QUERY_TYPE_DATA_TABLE, TrackerSparqlQueryDataTableClass))

typedef struct _TrackerSparqlQueryDataTable TrackerSparqlQueryDataTable;
typedef struct _TrackerSparqlQueryDataTableClass TrackerSparqlQueryDataTableClass;

#define TRACKER_SPARQL_QUERY_TYPE_DATA_BINDING (tracker_sparql_query_data_binding_get_type ())
#define TRACKER_SPARQL_QUERY_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_QUERY_TYPE_DATA_BINDING, TrackerSparqlQueryDataBinding))
#define TRACKER_SPARQL_QUERY_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_QUERY_TYPE_DATA_BINDING, TrackerSparqlQueryDataBindingClass))
#define TRACKER_SPARQL_QUERY_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_QUERY_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_QUERY_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_QUERY_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_QUERY_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_QUERY_TYPE_DATA_BINDING, TrackerSparqlQueryDataBindingClass))

typedef struct _TrackerSparqlQueryDataBinding TrackerSparqlQueryDataBinding;
typedef struct _TrackerSparqlQueryDataBindingClass TrackerSparqlQueryDataBindingClass;

#define TRACKER_SPARQL_QUERY_TYPE_LITERAL_BINDING (tracker_sparql_query_literal_binding_get_type ())
#define TRACKER_SPARQL_QUERY_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_QUERY_TYPE_LITERAL_BINDING, TrackerSparqlQueryLiteralBinding))
#define TRACKER_SPARQL_QUERY_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_QUERY_TYPE_LITERAL_BINDING, TrackerSparqlQueryLiteralBindingClass))
#define TRACKER_SPARQL_QUERY_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_QUERY_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_QUERY_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_QUERY_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_QUERY_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_QUERY_TYPE_LITERAL_BINDING, TrackerSparqlQueryLiteralBindingClass))

typedef struct _TrackerSparqlQueryLiteralBinding TrackerSparqlQueryLiteralBinding;
typedef struct _TrackerSparqlQueryLiteralBindingClass TrackerSparqlQueryLiteralBindingClass;

#define TRACKER_SPARQL_QUERY_TYPE_VARIABLE_BINDING (tracker_sparql_query_variable_binding_get_type ())
#define TRACKER_SPARQL_QUERY_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_QUERY_TYPE_VARIABLE_BINDING, TrackerSparqlQueryVariableBinding))
#define TRACKER_SPARQL_QUERY_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_QUERY_TYPE_VARIABLE_BINDING, TrackerSparqlQueryVariableBindingClass))
#define TRACKER_SPARQL_QUERY_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_QUERY_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_QUERY_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_QUERY_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_QUERY_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_QUERY_TYPE_VARIABLE_BINDING, TrackerSparqlQueryVariableBindingClass))

typedef struct _TrackerSparqlQueryVariableBinding TrackerSparqlQueryVariableBinding;
typedef struct _TrackerSparqlQueryVariableBindingClass TrackerSparqlQueryVariableBindingClass;

#define TRACKER_SPARQL_QUERY_TYPE_VARIABLE_BINDING_LIST (tracker_sparql_query_variable_binding_list_get_type ())
#define TRACKER_SPARQL_QUERY_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_QUERY_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlQueryVariableBindingList))
#define TRACKER_SPARQL_QUERY_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_QUERY_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlQueryVariableBindingListClass))
#define TRACKER_SPARQL_QUERY_IS_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_QUERY_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_QUERY_IS_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_QUERY_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_QUERY_VARIABLE_BINDING_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_QUERY_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlQueryVariableBindingListClass))

typedef struct _TrackerSparqlQueryVariableBindingList TrackerSparqlQueryVariableBindingList;
typedef struct _TrackerSparqlQueryVariableBindingListClass TrackerSparqlQueryVariableBindingListClass;

#define TRACKER_SPARQL_QUERY_TYPE_PREDICATE_VARIABLE (tracker_sparql_query_predicate_variable_get_type ())
#define TRACKER_SPARQL_QUERY_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_QUERY_TYPE_PREDICATE_VARIABLE, TrackerSparqlQueryPredicateVariable))
#define TRACKER_SPARQL_QUERY_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_QUERY_TYPE_PREDICATE_VARIABLE, TrackerSparqlQueryPredicateVariableClass))
#define TRACKER_SPARQL_QUERY_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_QUERY_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_QUERY_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_QUERY_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_QUERY_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_QUERY_TYPE_PREDICATE_VARIABLE, TrackerSparqlQueryPredicateVariableClass))

typedef struct _TrackerSparqlQueryPredicateVariable TrackerSparqlQueryPredicateVariable;
typedef struct _TrackerSparqlQueryPredicateVariableClass TrackerSparqlQueryPredicateVariableClass;

#define TRACKER_SPARQL_QUERY_TYPE_VARIABLE_STATE (tracker_sparql_query_variable_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerSparqlQueryDataBindingPrivate TrackerSparqlQueryDataBindingPrivate;
typedef struct _TrackerSparqlQueryLiteralBindingPrivate TrackerSparqlQueryLiteralBindingPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _TrackerSparqlQueryVariableBindingPrivate TrackerSparqlQueryVariableBindingPrivate;
typedef struct _TrackerSparqlQueryDataTablePrivate TrackerSparqlQueryDataTablePrivate;
typedef struct _TrackerSparqlQueryVariableBindingListPrivate TrackerSparqlQueryVariableBindingListPrivate;
typedef struct _TrackerSparqlQueryPredicateVariablePrivate TrackerSparqlQueryPredicateVariablePrivate;

typedef enum  {
	TRACKER_SPARQL_ERROR_PARSE,
	TRACKER_SPARQL_ERROR_UNKNOWN_CLASS,
	TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY,
	TRACKER_SPARQL_ERROR_TYPE,
	TRACKER_SPARQL_ERROR_INTERNAL,
	TRACKER_SPARQL_ERROR_UNSUPPORTED
} TrackerSparqlError;
#define TRACKER_SPARQL_ERROR tracker_sparql_error_quark ()
struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerSparqlQueryTokenInfo {
	TrackerSparqlTokenType type;
	TrackerSourceLocation begin;
	TrackerSourceLocation end;
};

struct _TrackerSparqlQueryPrivate {
	TrackerSparqlScanner* scanner;
	TrackerSparqlQueryTokenInfo* tokens;
	gint tokens_length1;
	gint tokens_size;
	gint index;
	gint size;
	char* query_string;
	gboolean update_extensions;
	char* current_subject;
	gboolean current_subject_is_var;
	char* current_predicate;
	gboolean current_predicate_is_var;
	gint next_table_index;
	GHashTable* prefix_map;
	GList* tables;
	GHashTable* table_map;
	GList* bindings;
	GList* pattern_bindings;
	GHashTable* var_map;
	GList* pattern_variables;
	GHashTable* pattern_var_map;
	GHashTable* subgraph_var_set;
	GHashTable* predicate_variable_map;
	gboolean delete_statements;
	gint counter;
	gint bnodeid;
	guchar* base_uuid;
	gint base_uuid_length1;
	gint base_uuid_size;
};

typedef enum  {
	TRACKER_SPARQL_QUERY_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_QUERY_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_QUERY_VARIABLE_STATE_OPTIONAL
} TrackerSparqlQueryVariableState;

struct _TrackerSparqlQueryDataBinding {
	GObject parent_instance;
	TrackerSparqlQueryDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlQueryDataTable* table;
	char* sql_db_column_name;
};

struct _TrackerSparqlQueryDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlQueryLiteralBinding {
	TrackerSparqlQueryDataBinding parent_instance;
	TrackerSparqlQueryLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	char* literal;
};

struct _TrackerSparqlQueryLiteralBindingClass {
	TrackerSparqlQueryDataBindingClass parent_class;
};

struct _TrackerSparqlQueryVariableBinding {
	TrackerSparqlQueryDataBinding parent_instance;
	TrackerSparqlQueryVariableBindingPrivate * priv;
	char* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	char* type;
};

struct _TrackerSparqlQueryVariableBindingClass {
	TrackerSparqlQueryDataBindingClass parent_class;
};

struct _TrackerSparqlQueryDataTable {
	GObject parent_instance;
	TrackerSparqlQueryDataTablePrivate * priv;
	char* sql_db_tablename;
	char* sql_query_tablename;
	TrackerSparqlQueryPredicateVariable* predicate_variable;
};

struct _TrackerSparqlQueryDataTableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlQueryVariableBindingList {
	GObject parent_instance;
	TrackerSparqlQueryVariableBindingListPrivate * priv;
	GList* list;
};

struct _TrackerSparqlQueryVariableBindingListClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlQueryPredicateVariable {
	GObject parent_instance;
	TrackerSparqlQueryPredicateVariablePrivate * priv;
	char* subject;
	char* object;
	TrackerClass* domain;
};

struct _TrackerSparqlQueryPredicateVariableClass {
	GObjectClass parent_class;
};


static gpointer tracker_sparql_query_data_table_parent_class = NULL;
static gpointer tracker_sparql_query_data_binding_parent_class = NULL;
static gpointer tracker_sparql_query_literal_binding_parent_class = NULL;
static gpointer tracker_sparql_query_variable_binding_parent_class = NULL;
static gpointer tracker_sparql_query_variable_binding_list_parent_class = NULL;
static gpointer tracker_sparql_query_predicate_variable_parent_class = NULL;
static gpointer tracker_sparql_query_parent_class = NULL;

GQuark tracker_sparql_error_quark (void);
GType tracker_sparql_query_get_type (void);
GType tracker_sparql_scanner_get_type (void);
static GType tracker_sparql_query_token_info_get_type (void);
GType tracker_sparql_token_type_get_type (void);
GType tracker_source_location_get_type (void);
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
static TrackerSparqlQueryTokenInfo* tracker_sparql_query_token_info_dup (const TrackerSparqlQueryTokenInfo* self);
static void tracker_sparql_query_token_info_free (TrackerSparqlQueryTokenInfo* self);
static GType tracker_sparql_query_data_table_get_type (void);
static GType tracker_sparql_query_data_binding_get_type (void);
static GType tracker_sparql_query_literal_binding_get_type (void);
static GType tracker_sparql_query_variable_binding_get_type (void);
static GType tracker_sparql_query_variable_binding_list_get_type (void);
static GType tracker_sparql_query_predicate_variable_get_type (void);
#define TRACKER_SPARQL_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_SPARQL_QUERY, TrackerSparqlQueryPrivate))
enum  {
	TRACKER_SPARQL_QUERY_DUMMY_PROPERTY
};
static GType tracker_sparql_query_variable_state_get_type (void);
static void _g_list_free_g_object_unref (GList* self);
static void _g_list_free_g_free (GList* self);
#define TRACKER_SPARQL_QUERY_BUFFER_SIZE 32
#define TRACKER_SPARQL_QUERY_FN_NS "http://www.w3.org/2005/xpath-functions#"
static gboolean tracker_sparql_query_maybe_numeric (TrackerSparqlQuery* self, TrackerPropertyType type);
void uuid_generate (guchar* uuid);
TrackerSparqlQuery* tracker_sparql_query_new (const char* query);
TrackerSparqlQuery* tracker_sparql_query_construct (GType object_type, const char* query);
TrackerSparqlQuery* tracker_sparql_query_new_update (const char* query);
TrackerSparqlQuery* tracker_sparql_query_construct_update (GType object_type, const char* query);
static char* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const char* user_bnodeid);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error);
static inline gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
static inline TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self);
static inline gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const char* msg);
static GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const char* msg);
const char* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);
static gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static inline void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result);
void tracker_sparql_scanner_seek (TrackerSparqlScanner* self, const TrackerSourceLocation* location);
static void tracker_sparql_query_set_location (TrackerSparqlQuery* self, const TrackerSourceLocation* location);
static char* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
static char* tracker_sparql_query_escape_sql_string_literal (TrackerSparqlQuery* self, const char* literal);
static void tracker_sparql_query_parse_prologue (TrackerSparqlQuery* self, GError** error);
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, glong len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, glong len);
static TrackerDBResultSet* tracker_sparql_query_execute_select (TrackerSparqlQuery* self, GError** error);
static TrackerDBResultSet* tracker_sparql_query_execute_ask (TrackerSparqlQuery* self, GError** error);
static void tracker_sparql_query_execute_insert (TrackerSparqlQuery* self, GError** error);
static void tracker_sparql_query_execute_delete (TrackerSparqlQuery* self, GError** error);
static void tracker_sparql_query_execute_drop_graph (TrackerSparqlQuery* self, GError** error);
TrackerDBResultSet* tracker_sparql_query_execute (TrackerSparqlQuery* self, GError** error);
static void tracker_sparql_query_check_binding (TrackerSparqlQuery* self, TrackerSparqlQueryVariableBinding* binding, const char* variable_name, GError** error);
static char* tracker_sparql_query_get_sql_for_variable (TrackerSparqlQuery* self, const char* variable_name, GError** error);
static TrackerDBResultSet* tracker_sparql_query_exec_sql (TrackerSparqlQuery* self, const char* sql, GError** error);
static void tracker_sparql_query_skip_select_variables (TrackerSparqlQuery* self, GError** error);
static void tracker_sparql_query_translate_expression_as_string (TrackerSparqlQuery* self, GString* sql, GError** error);
static char* tracker_sparql_query_parse_string_literal (TrackerSparqlQuery* self, GError** error);
static void tracker_sparql_query_translate_select_expression (TrackerSparqlQuery* self, GString* sql, GError** error);
static void tracker_sparql_query_translate_group_graph_pattern (TrackerSparqlQuery* self, GString* sql, GError** error);
static void tracker_sparql_query_translate_order_condition (TrackerSparqlQuery* self, GString* sql, GError** error);
static TrackerSparqlQueryLiteralBinding* tracker_sparql_query_literal_binding_new (void);
static TrackerSparqlQueryLiteralBinding* tracker_sparql_query_literal_binding_construct (GType object_type);
static TrackerPropertyType tracker_sparql_query_translate_expression (TrackerSparqlQuery* self, GString* sql, GError** error);
static void tracker_sparql_query_translate_expression_as_order_condition (TrackerSparqlQuery* self, GString* sql, GError** error);
static void tracker_sparql_query_execute_update (TrackerSparqlQuery* self, gboolean delete_statements, GError** error);
static void tracker_sparql_query_skip_braces (TrackerSparqlQuery* self, GError** error);
static char* tracker_sparql_query_get_string_for_value (const GValue* value);
static void tracker_sparql_query_parse_construct_triples_block (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
static char* tracker_sparql_query_parse_var_or_term (TrackerSparqlQuery* self, GString* sql, gboolean* is_var, GError** error);
static char* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const char* prefix, const char* local_name, GError** error);
static void tracker_sparql_query_parse_property_list_not_empty (TrackerSparqlQuery* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_query_parse_object (TrackerSparqlQuery* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_query_parse_object_list (TrackerSparqlQuery* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_query_translate_bound_call (TrackerSparqlQuery* self, GString* sql, GError** error);
static void tracker_sparql_query_translate_regex (TrackerSparqlQuery* self, GString* sql, GError** error);
static void tracker_sparql_query_translate_str (TrackerSparqlQuery* self, GString* sql, GError** error);
static void tracker_sparql_query_translate_isuri (TrackerSparqlQuery* self, GString* sql, GError** error);
static void tracker_sparql_query_translate_datatype (TrackerSparqlQuery* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_query_translate_function (TrackerSparqlQuery* self, GString* sql, const char* uri, GError** error);
static TrackerPropertyType tracker_sparql_query_translate_bracketted_expression (TrackerSparqlQuery* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_query_translate_primary_expression (TrackerSparqlQuery* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_query_translate_unary_expression (TrackerSparqlQuery* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_query_translate_multiplicative_expression (TrackerSparqlQuery* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_query_translate_additive_expression (TrackerSparqlQuery* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_query_translate_numeric_expression (TrackerSparqlQuery* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_query_process_relational_expression (TrackerSparqlQuery* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const char* operator, GError** error);
static TrackerPropertyType tracker_sparql_query_translate_relational_expression (TrackerSparqlQuery* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_query_translate_value_logical (TrackerSparqlQuery* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_query_translate_conditional_and_expression (TrackerSparqlQuery* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_query_translate_conditional_or_expression (TrackerSparqlQuery* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_query_translate_constraint (TrackerSparqlQuery* self, GString* sql, GError** error);
static void tracker_sparql_query_translate_filter (TrackerSparqlQuery* self, GString* sql, GError** error);
static void tracker_sparql_query_skip_filter (TrackerSparqlQuery* self, GError** error);
static char* tracker_sparql_query_parse_construct_var_or_term (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
static void tracker_sparql_query_parse_construct_property_list_not_empty (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
static void tracker_sparql_query_parse_construct_object_list (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
static void tracker_sparql_query_parse_construct_object (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
static void tracker_sparql_query_start_triples_block (TrackerSparqlQuery* self, GString* sql, GError** error);
static char* tracker_sparql_query_predicate_variable_get_sql_query (TrackerSparqlQueryPredicateVariable* self, TrackerSparqlQuery* query, GError** error);
static void tracker_sparql_query_end_triples_block (TrackerSparqlQuery* self, GString* sql, gboolean* first_where, gboolean in_group_graph_pattern, GError** error);
static void tracker_sparql_query_parse_triples (TrackerSparqlQuery* self, GString* sql, glong group_graph_pattern_start, gboolean* in_triples_block, gboolean* first_where, gboolean* in_group_graph_pattern, gboolean found_simple_optional, GError** error);
static gboolean tracker_sparql_query_is_simple_optional (TrackerSparqlQuery* self);
static void tracker_sparql_query_translate_group_or_union_graph_pattern (TrackerSparqlQuery* self, GString* sql, GError** error);
static void _vala_array_add1 (TrackerSourceLocation** array, int* length, int* size, const TrackerSourceLocation* value);
static void _vala_array_add2 (GHashTable*** array, int* length, int* size, GHashTable* value);
static void _vala_array_add3 (glong** array, int* length, int* size, glong value);
static void _vala_array_add4 (char*** array, int* length, int* size, char* value);
static TrackerSparqlQueryPredicateVariable* tracker_sparql_query_predicate_variable_new (void);
static TrackerSparqlQueryPredicateVariable* tracker_sparql_query_predicate_variable_construct (GType object_type);
static TrackerSparqlQueryDataTable* tracker_sparql_query_get_table (TrackerSparqlQuery* self, const char* subject, const char* db_table, gboolean share_table, gboolean* newtable);
static TrackerSparqlQueryDataTable* tracker_sparql_query_data_table_new (void);
static TrackerSparqlQueryDataTable* tracker_sparql_query_data_table_construct (GType object_type);
static TrackerSparqlQueryVariableBinding* tracker_sparql_query_variable_binding_new (void);
static TrackerSparqlQueryVariableBinding* tracker_sparql_query_variable_binding_construct (GType object_type);
static TrackerSparqlQueryVariableBindingList* tracker_sparql_query_variable_binding_list_new (void);
static TrackerSparqlQueryVariableBindingList* tracker_sparql_query_variable_binding_list_construct (GType object_type);
enum  {
	TRACKER_SPARQL_QUERY_DATA_TABLE_DUMMY_PROPERTY
};
static void tracker_sparql_query_data_table_finalize (GObject* obj);
enum  {
	TRACKER_SPARQL_QUERY_DATA_BINDING_DUMMY_PROPERTY
};
static TrackerSparqlQueryDataBinding* tracker_sparql_query_data_binding_construct (GType object_type);
static void tracker_sparql_query_data_binding_finalize (GObject* obj);
enum  {
	TRACKER_SPARQL_QUERY_LITERAL_BINDING_DUMMY_PROPERTY
};
static void tracker_sparql_query_literal_binding_finalize (GObject* obj);
enum  {
	TRACKER_SPARQL_QUERY_VARIABLE_BINDING_DUMMY_PROPERTY
};
static void tracker_sparql_query_variable_binding_finalize (GObject* obj);
enum  {
	TRACKER_SPARQL_QUERY_VARIABLE_BINDING_LIST_DUMMY_PROPERTY
};
static void tracker_sparql_query_variable_binding_list_finalize (GObject* obj);
enum  {
	TRACKER_SPARQL_QUERY_PREDICATE_VARIABLE_DUMMY_PROPERTY
};
static void tracker_sparql_query_predicate_variable_finalize (GObject* obj);
static void tracker_sparql_query_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark tracker_sparql_error_quark (void) {
	return g_quark_from_static_string ("tracker_sparql_error-quark");
}



static GType tracker_sparql_query_variable_state_get_type (void) {
	static GType tracker_sparql_query_variable_state_type_id = 0;
	if (G_UNLIKELY (tracker_sparql_query_variable_state_type_id == 0)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_QUERY_VARIABLE_STATE_NONE, "TRACKER_SPARQL_QUERY_VARIABLE_STATE_NONE", "none"}, {TRACKER_SPARQL_QUERY_VARIABLE_STATE_BOUND, "TRACKER_SPARQL_QUERY_VARIABLE_STATE_BOUND", "bound"}, {TRACKER_SPARQL_QUERY_VARIABLE_STATE_OPTIONAL, "TRACKER_SPARQL_QUERY_VARIABLE_STATE_OPTIONAL", "optional"}, {0, NULL, NULL}};
		tracker_sparql_query_variable_state_type_id = g_enum_register_static ("TrackerSparqlQueryVariableState", values);
	}
	return tracker_sparql_query_variable_state_type_id;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static gboolean tracker_sparql_query_maybe_numeric (TrackerSparqlQuery* self, TrackerPropertyType type) {
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = FALSE;
	_tmp1_ = FALSE;
	_tmp2_ = FALSE;
	if (type == TRACKER_PROPERTY_TYPE_INTEGER) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = type == TRACKER_PROPERTY_TYPE_DOUBLE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = type == TRACKER_PROPERTY_TYPE_DATETIME;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == TRACKER_PROPERTY_TYPE_UNKNOWN;
	}
	result = _tmp0_;
	return result;
}


TrackerSparqlQuery* tracker_sparql_query_construct (GType object_type, const char* query) {
	TrackerSparqlQuery * self;
	TrackerSparqlQueryTokenInfo* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	guchar* _tmp3_;
	char* _tmp4_;
	g_return_val_if_fail (query != NULL, NULL);
	self = (TrackerSparqlQuery*) g_object_new (object_type, NULL);
	self->priv->tokens = (_tmp0_ = g_new0 (TrackerSparqlQueryTokenInfo, TRACKER_SPARQL_QUERY_BUFFER_SIZE), self->priv->tokens = (g_free (self->priv->tokens), NULL), self->priv->tokens_length1 = TRACKER_SPARQL_QUERY_BUFFER_SIZE, self->priv->tokens_size = self->priv->tokens_length1, _tmp0_);
	self->priv->prefix_map = (_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free), _g_hash_table_unref0 (self->priv->prefix_map), _tmp1_);
	self->priv->subgraph_var_set = (_tmp2_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL), _g_hash_table_unref0 (self->priv->subgraph_var_set), _tmp2_);
	self->priv->base_uuid = (_tmp3_ = g_new0 (guchar, 16), self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL), self->priv->base_uuid_length1 = 16, self->priv->base_uuid_size = self->priv->base_uuid_length1, _tmp3_);
	uuid_generate (self->priv->base_uuid);
	self->priv->query_string = (_tmp4_ = g_strdup (query), _g_free0 (self->priv->query_string), _tmp4_);
	return self;
}


TrackerSparqlQuery* tracker_sparql_query_new (const char* query) {
	return tracker_sparql_query_construct (TRACKER_TYPE_SPARQL_QUERY, query);
}


TrackerSparqlQuery* tracker_sparql_query_construct_update (GType object_type, const char* query) {
	TrackerSparqlQuery * self;
	g_return_val_if_fail (query != NULL, NULL);
	self = (TrackerSparqlQuery*) tracker_sparql_query_construct (object_type, query);
	self->priv->update_extensions = TRUE;
	return self;
}


TrackerSparqlQuery* tracker_sparql_query_new_update (const char* query) {
	return tracker_sparql_query_construct_update (TRACKER_TYPE_SPARQL_QUERY, query);
}


static char* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const char* user_bnodeid) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (user_bnodeid == NULL) {
		result = g_strdup_printf (":%d", self->priv->bnodeid = self->priv->bnodeid + 1);
		return result;
	} else {
		GChecksum* checksum;
		char* sha1;
		checksum = g_checksum_new (G_CHECKSUM_SHA1);
		g_checksum_update (checksum, self->priv->base_uuid, (gsize) 16);
		g_checksum_update (checksum, (guchar*) user_bnodeid, (gsize) (-1));
		sha1 = g_strdup (g_checksum_get_string (checksum));
		result = g_strdup_printf ("urn:uuid:%.8s-%.4s-%.4s-%.4s-%.12s", sha1, g_utf8_offset_to_pointer (sha1, (glong) 8), g_utf8_offset_to_pointer (sha1, (glong) 12), g_utf8_offset_to_pointer (sha1, (glong) 16), g_utf8_offset_to_pointer (sha1, (glong) 20));
		_g_checksum_free0 (checksum);
		_g_free0 (sha1);
		return result;
	}
}


static inline gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error) {
	gboolean result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	self->priv->index = (self->priv->index + 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
	self->priv->size--;
	if (self->priv->size <= 0) {
		TrackerSourceLocation begin = {0};
		TrackerSourceLocation end = {0};
		TrackerSparqlTokenType type;
		type = tracker_sparql_scanner_read_token (self->priv->scanner, &begin, &end, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		self->priv->tokens[self->priv->index].type = type;
		self->priv->tokens[self->priv->index].begin = begin;
		self->priv->tokens[self->priv->index].end = end;
		self->priv->size = 1;
	}
	result = self->priv->tokens[self->priv->index].type != TRACKER_SPARQL_TOKEN_TYPE_EOF;
	return result;
}


static inline TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self) {
	TrackerSparqlTokenType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->tokens[self->priv->index].type;
	return result;
}


static inline TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self) {
	TrackerSparqlTokenType result;
	gint last_index;
	g_return_val_if_fail (self != NULL, 0);
	last_index = ((self->priv->index + TRACKER_SPARQL_QUERY_BUFFER_SIZE) - 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
	result = self->priv->tokens[last_index].type;
	return result;
}


static inline gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	if (tracker_sparql_query_current (self) == type) {
		tracker_sparql_query_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const char* msg) {
	GError* result;
	char* _tmp0_;
	GError* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	result = (_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, _tmp0_ = g_strdup_printf ("%d.%d: syntax error, %s", self->priv->tokens[self->priv->index].begin.line, self->priv->tokens[self->priv->index].begin.column, msg)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const char* msg) {
	GError* result;
	char* _tmp0_;
	GError* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	result = (_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp0_ = g_strdup_printf ("%d.%d: %s", self->priv->tokens[self->priv->index].begin.line, self->priv->tokens[self->priv->index].begin.column, msg)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result;
	GError * _inner_error_;
	gboolean _tmp0_;
	char* _tmp1_;
	GError* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_accept (self, type, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_inner_error_ = (_tmp2_ = tracker_sparql_query_get_error (self, _tmp1_ = g_strdup_printf ("expected %s", tracker_sparql_token_type_to_string (type))), _g_free0 (_tmp1_), _tmp2_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
}


static inline void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->tokens[self->priv->index].begin;
	return;
}


static void tracker_sparql_query_set_location (TrackerSparqlQuery* self, const TrackerSourceLocation* location) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	tracker_sparql_scanner_seek (self->priv->scanner, &(*location));
	self->priv->size = 0;
	self->priv->index = 0;
	{
		tracker_sparql_query_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch0_tracker_sparql_error;
			}
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_tracker_sparql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("tracker-sparql-query.vala:384: internal error: next in set_location failed");
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static char* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip) {
	char* result;
	gint last_index;
	g_return_val_if_fail (self != NULL, NULL);
	last_index = ((self->priv->index + TRACKER_SPARQL_QUERY_BUFFER_SIZE) - 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
	result = g_strndup ((const char*) (self->priv->tokens[last_index].begin.pos + strip), (self->priv->tokens[last_index].end.pos - self->priv->tokens[last_index].begin.pos) - (2 * strip));
	return result;
}


static char* tracker_sparql_query_escape_sql_string_literal (TrackerSparqlQuery* self, const char* literal) {
	char* result;
	char* _tmp2_;
	gint _tmp1__length1;
	char** _tmp1_;
	char** _tmp0_;
	char* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (literal != NULL, NULL);
	result = (_tmp3_ = g_strdup_printf ("'%s'", _tmp2_ = g_strjoinv ("''", (_tmp1_ = _tmp0_ = g_strsplit (literal, "'", 0), _tmp1__length1 = _vala_array_length (_tmp0_), _tmp1_))), _g_free0 (_tmp2_), _tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL), _tmp3_);
	return result;
}


static void tracker_sparql_query_parse_prologue (TrackerSparqlQuery* self, GError** error) {
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BASE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp0_) {
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp1_;
		char* ns;
		gboolean _tmp2_;
		char* uri;
		_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PREFIX, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (!_tmp1_) {
			break;
		}
		ns = g_strdup ("");
		_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (ns);
				return;
			} else {
				_g_free0 (ns);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp2_) {
			char* _tmp3_;
			ns = (_tmp3_ = tracker_sparql_query_get_last_string (self, 0), _g_free0 (ns), _tmp3_);
		}
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (ns);
				return;
			} else {
				_g_free0 (ns);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (ns);
				return;
			} else {
				_g_free0 (ns);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		uri = tracker_sparql_query_get_last_string (self, 1);
		g_hash_table_insert (self->priv->prefix_map, g_strdup (ns), g_strdup (uri));
		_g_free0 (ns);
		_g_free0 (uri);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


TrackerDBResultSet* tracker_sparql_query_execute (TrackerSparqlQuery* self, GError** error) {
	TrackerDBResultSet* result;
	GError * _inner_error_;
	TrackerSparqlScanner* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	self->priv->scanner = (_tmp0_ = tracker_sparql_scanner_new ((gchar*) self->priv->query_string, (glong) strlen (self->priv->query_string)), _g_object_unref0 (self->priv->scanner), _tmp0_);
	tracker_sparql_query_next (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	g_hash_table_insert (self->priv->prefix_map, g_strdup ("fn"), g_strdup (TRACKER_SPARQL_QUERY_FN_NS));
	{
		TrackerNamespace** _tmp1_;
		TrackerNamespace** ns_collection;
		int ns_collection_length1;
		int ns_it;
		ns_collection = _tmp1_ = tracker_ontology_get_namespaces ();
		ns_collection_length1 = _vala_array_length (_tmp1_);
		for (ns_it = 0; ns_it < _vala_array_length (_tmp1_); ns_it = ns_it + 1) {
			TrackerNamespace* ns;
			ns = _g_object_ref0 (ns_collection[ns_it]);
			{
				g_hash_table_insert (self->priv->prefix_map, g_strdup (tracker_namespace_get_prefix (ns)), g_strdup (tracker_namespace_get_uri (ns)));
				_g_object_unref0 (ns);
			}
		}
	}
	tracker_sparql_query_parse_prologue (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (!self->priv->update_extensions) {
		switch (tracker_sparql_query_current (self)) {
			case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
			{
				TrackerDBResultSet* _tmp2_;
				_tmp2_ = tracker_sparql_query_execute_select (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				}
				result = _tmp2_;
				return result;
			}
			case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
			{
				_inner_error_ = tracker_sparql_query_get_internal_error (self, "CONSTRUCT is not supported");
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				}
			}
			case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
			{
				_inner_error_ = tracker_sparql_query_get_internal_error (self, "DESCRIBE is not supported");
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				}
			}
			case TRACKER_SPARQL_TOKEN_TYPE_ASK:
			{
				TrackerDBResultSet* _tmp3_;
				_tmp3_ = tracker_sparql_query_execute_ask (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				}
				result = _tmp3_;
				return result;
			}
			case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
			case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
			case TRACKER_SPARQL_TOKEN_TYPE_DROP:
			{
				_inner_error_ = tracker_sparql_query_get_error (self, "INSERT and DELETE are not supported in query mode");
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				}
			}
			default:
			{
				_inner_error_ = tracker_sparql_query_get_error (self, "expected SELECT or ASK");
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				}
			}
		}
	} else {
		tracker_data_begin_transaction ();
		{
			while (TRUE) {
				if (!(tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_EOF)) {
					break;
				}
				switch (tracker_sparql_query_current (self)) {
					case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
					{
						tracker_sparql_query_execute_insert (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __finally1;
						}
						break;
					}
					case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
					{
						tracker_sparql_query_execute_delete (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __finally1;
						}
						break;
					}
					case TRACKER_SPARQL_TOKEN_TYPE_DROP:
					{
						tracker_sparql_query_execute_drop_graph (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __finally1;
						}
						break;
					}
					case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
					case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
					case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
					case TRACKER_SPARQL_TOKEN_TYPE_ASK:
					{
						_inner_error_ = tracker_sparql_query_get_error (self, "SELECT, CONSTRUCT, DESCRIBE, and ASK are not supported in update mode");
						if (_inner_error_ != NULL) {
							goto __finally1;
						}
					}
					default:
					{
						_inner_error_ = tracker_sparql_query_get_error (self, "expected INSERT or DELETE");
						if (_inner_error_ != NULL) {
							goto __finally1;
						}
					}
				}
			}
		}
		__finally1:
		{
			tracker_data_commit_transaction ();
		}
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = NULL;
		return result;
	}
}


static void tracker_sparql_query_check_binding (TrackerSparqlQuery* self, TrackerSparqlQueryVariableBinding* binding, const char* variable_name, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variable_name != NULL);
	_inner_error_ = NULL;
	if (binding == NULL) {
		char* _tmp0_;
		GError* _tmp1_;
		_inner_error_ = (_tmp1_ = tracker_sparql_query_get_error (self, _tmp0_ = g_strdup_printf ("`%s' is not a valid variable", variable_name)), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static char* tracker_sparql_query_get_sql_for_variable (TrackerSparqlQuery* self, const char* variable_name, GError** error) {
	char* result;
	GError * _inner_error_;
	TrackerSparqlQueryVariableBinding* binding;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (variable_name != NULL, NULL);
	_inner_error_ = NULL;
	binding = _g_object_ref0 ((TrackerSparqlQueryVariableBinding*) g_hash_table_lookup (self->priv->var_map, variable_name));
	tracker_sparql_query_check_binding (self, binding, variable_name, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (binding);
			return NULL;
		} else {
			_g_object_unref0 (binding);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (((TrackerSparqlQueryDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_RESOURCE) {
		result = g_strdup_printf ("(SELECT Uri FROM \"rdfs:Resource\" WHERE ID = \"%s_u\")", variable_name);
		_g_object_unref0 (binding);
		return result;
	} else {
		if (((TrackerSparqlQueryDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_BOOLEAN) {
			result = g_strdup_printf ("(CASE \"%s_u\" WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END)", variable_name);
			_g_object_unref0 (binding);
			return result;
		} else {
			if (((TrackerSparqlQueryDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_DATETIME) {
				result = g_strdup_printf ("strftime (\"%%Y-%%m-%%dT%%H:%%M:%%SZ\", \"%s_u\", \"unixepoch\")", variable_name);
				_g_object_unref0 (binding);
				return result;
			} else {
				result = g_strdup_printf ("\"%s_u\"", variable_name);
				_g_object_unref0 (binding);
				return result;
			}
		}
	}
	_g_object_unref0 (binding);
}


static TrackerDBResultSet* tracker_sparql_query_exec_sql (TrackerSparqlQuery* self, const char* sql, GError** error) {
	TrackerDBResultSet* result;
	GError * _inner_error_;
	TrackerDBInterface* iface;
	TrackerDBStatement* stmt;
	gint i;
	TrackerDBResultSet* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	_inner_error_ = NULL;
	iface = _g_object_ref0 (tracker_db_manager_get_db_interface ());
	stmt = tracker_db_interface_create_statement (iface, "%s", sql);
	i = 0;
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = self->priv->bindings;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			TrackerSparqlQueryLiteralBinding* binding;
			binding = _g_object_ref0 ((TrackerSparqlQueryLiteralBinding*) binding_it->data);
			{
				if (((TrackerSparqlQueryDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_BOOLEAN) {
					gboolean _tmp0_;
					_tmp0_ = FALSE;
					if (_vala_strcmp0 (binding->literal, "true") == 0) {
						_tmp0_ = TRUE;
					} else {
						_tmp0_ = _vala_strcmp0 (binding->literal, "1") == 0;
					}
					if (_tmp0_) {
						tracker_db_statement_bind_int (stmt, i, 1);
					} else {
						gboolean _tmp1_;
						_tmp1_ = FALSE;
						if (_vala_strcmp0 (binding->literal, "false") == 0) {
							_tmp1_ = TRUE;
						} else {
							_tmp1_ = _vala_strcmp0 (binding->literal, "0") == 0;
						}
						if (_tmp1_) {
							tracker_db_statement_bind_int (stmt, i, 0);
						} else {
							char* _tmp2_;
							GError* _tmp3_;
							_inner_error_ = (_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_TYPE, _tmp2_ = g_strdup_printf ("`%s' is not a valid boolean", binding->literal)), _g_free0 (_tmp2_), _tmp3_);
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (binding);
								_g_object_unref0 (iface);
								_g_object_unref0 (stmt);
								return NULL;
							}
						}
					}
				} else {
					if (((TrackerSparqlQueryDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_DATETIME) {
						tracker_db_statement_bind_int (stmt, i, tracker_string_to_date (binding->literal));
					} else {
						if (((TrackerSparqlQueryDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_INTEGER) {
							tracker_db_statement_bind_int (stmt, i, atoi (binding->literal));
						} else {
							tracker_db_statement_bind_text (stmt, i, binding->literal);
						}
					}
				}
				i++;
				_g_object_unref0 (binding);
			}
		}
	}
	_tmp4_ = tracker_db_statement_execute (stmt, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (iface);
		_g_object_unref0 (stmt);
		return NULL;
	}
	result = _tmp4_;
	_g_object_unref0 (iface);
	_g_object_unref0 (stmt);
	return result;
}


static void tracker_sparql_query_skip_select_variables (TrackerSparqlQuery* self, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	while (TRUE) {
		switch (tracker_sparql_query_current (self)) {
			case TRACKER_SPARQL_TOKEN_TYPE_FROM:
			case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
			case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
			case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
			case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
			case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
			{
				break;
			}
			default:
			{
				tracker_sparql_query_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				continue;
			}
		}
		break;
	}
}


static void tracker_sparql_query_translate_select_expression (TrackerSparqlQuery* self, GString* sql, GError** error) {
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COUNT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp0_) {
		g_string_append (sql, "COUNT(");
		tracker_sparql_query_translate_expression_as_string (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		g_string_append (sql, ")");
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		gboolean _tmp1_;
		_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SUM, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp1_) {
			g_string_append (sql, "SUM(");
			tracker_sparql_query_translate_expression_as_string (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			g_string_append (sql, ")");
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		} else {
			gboolean _tmp2_;
			_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_AVG, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (_tmp2_) {
				g_string_append (sql, "AVG(");
				tracker_sparql_query_translate_expression_as_string (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				g_string_append (sql, ")");
				tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			} else {
				gboolean _tmp3_;
				_tmp3_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MIN, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				if (_tmp3_) {
					g_string_append (sql, "MIN(");
					tracker_sparql_query_translate_expression_as_string (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					g_string_append (sql, ")");
					tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				} else {
					gboolean _tmp4_;
					_tmp4_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MAX, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					if (_tmp4_) {
						g_string_append (sql, "MAX(");
						tracker_sparql_query_translate_expression_as_string (self, sql, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						g_string_append (sql, ")");
						tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					} else {
						gboolean _tmp5_;
						_tmp5_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						if (_tmp5_) {
							char* _tmp6_;
							char* _tmp8_;
							char* _tmp7_;
							g_string_append (sql, "GROUP_CONCAT(");
							tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							tracker_sparql_query_translate_expression_as_string (self, sql, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							g_string_append (sql, ", ");
							tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp6_ = tracker_sparql_query_parse_string_literal (self, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							g_string_append (sql, _tmp8_ = tracker_sparql_query_escape_sql_string_literal (self, _tmp7_ = _tmp6_));
							_g_free0 (_tmp8_);
							_g_free0 (_tmp7_);
							g_string_append (sql, ")");
							tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						} else {
							tracker_sparql_query_translate_expression_as_string (self, sql, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						}
					}
				}
			}
		}
	}
}


static TrackerDBResultSet* tracker_sparql_query_execute_select (TrackerSparqlQuery* self, GError** error) {
	TrackerDBResultSet* result;
	GError * _inner_error_;
	GString* pattern_sql;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GString* sql;
	gboolean _tmp2_;
	TrackerSourceLocation _tmp4_ = {0};
	TrackerSourceLocation select_variables_location;
	gboolean _tmp5_;
	TrackerSourceLocation _tmp6_ = {0};
	TrackerSourceLocation after_where;
	gboolean first;
	gboolean _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp15_;
	gint limit;
	gint offset;
	gboolean _tmp19_;
	TrackerDBResultSet* _tmp31_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	pattern_sql = g_string_new ("");
	self->priv->var_map = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->priv->var_map), _tmp0_);
	self->priv->predicate_variable_map = (_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->priv->predicate_variable_map), _tmp1_);
	sql = g_string_new ("");
	g_string_append (sql, "SELECT ");
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_SELECT, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	if (_tmp2_) {
		g_string_append (sql, "DISTINCT ");
	} else {
		gboolean _tmp3_;
		_tmp3_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_REDUCED, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		}
		if (_tmp3_) {
		}
	}
	select_variables_location = (tracker_sparql_query_get_location (self, &_tmp4_), _tmp4_);
	tracker_sparql_query_skip_select_variables (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	_tmp5_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FROM, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	if (_tmp5_) {
		tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NAMED, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		}
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		}
	}
	tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	tracker_sparql_query_translate_group_graph_pattern (self, pattern_sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	after_where = (tracker_sparql_query_get_location (self, &_tmp6_), _tmp6_);
	tracker_sparql_query_set_location (self, &select_variables_location);
	first = TRUE;
	_tmp7_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	if (_tmp7_) {
		{
			GList* variable_name_collection;
			GList* variable_name_it;
			variable_name_collection = g_hash_table_get_keys (self->priv->var_map);
			for (variable_name_it = variable_name_collection; variable_name_it != NULL; variable_name_it = variable_name_it->next) {
				char* variable_name;
				variable_name = g_strdup ((const char*) variable_name_it->data);
				{
					char* _tmp8_;
					char* _tmp9_;
					if (!first) {
						g_string_append (sql, ", ");
					} else {
						first = FALSE;
					}
					_tmp8_ = tracker_sparql_query_get_sql_for_variable (self, variable_name, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (variable_name);
						_g_list_free0 (variable_name_collection);
						_g_string_free0 (pattern_sql);
						_g_string_free0 (sql);
						return NULL;
					}
					g_string_append (sql, _tmp9_ = _tmp8_);
					_g_free0 (_tmp9_);
					_g_free0 (variable_name);
				}
			}
			_g_list_free0 (variable_name_collection);
		}
	} else {
		while (TRUE) {
			if (!first) {
				g_string_append (sql, ", ");
			} else {
				first = FALSE;
			}
			tracker_sparql_query_translate_select_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_string_free0 (pattern_sql);
				_g_string_free0 (sql);
				return NULL;
			}
			switch (tracker_sparql_query_current (self)) {
				case TRACKER_SPARQL_TOKEN_TYPE_FROM:
				case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
				case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
				case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
				case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
				case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
				case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
				case TRACKER_SPARQL_TOKEN_TYPE_EOF:
				{
					break;
				}
				default:
				{
					continue;
				}
			}
			break;
		}
	}
	g_string_append (sql, " FROM (");
	g_string_append (sql, pattern_sql->str);
	g_string_append (sql, ")");
	tracker_sparql_query_set_location (self, &after_where);
	_tmp10_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GROUP, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	if (_tmp10_) {
		gboolean first_group;
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BY, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		}
		g_string_append (sql, " GROUP BY ");
		first_group = TRUE;
		{
			gboolean _tmp11_;
			_tmp11_ = TRUE;
			while (TRUE) {
				if (!_tmp11_) {
					gboolean _tmp12_;
					gboolean _tmp13_;
					gboolean _tmp14_;
					_tmp12_ = FALSE;
					_tmp13_ = FALSE;
					_tmp14_ = FALSE;
					if (tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_ORDER) {
						_tmp14_ = tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_LIMIT;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						_tmp13_ = tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						_tmp12_ = tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_EOF;
					} else {
						_tmp12_ = FALSE;
					}
					if (!_tmp12_) {
						break;
					}
				}
				_tmp11_ = FALSE;
				if (first_group) {
					first_group = FALSE;
				} else {
					g_string_append (sql, ", ");
				}
				tracker_sparql_query_translate_order_condition (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_string_free0 (pattern_sql);
					_g_string_free0 (sql);
					return NULL;
				}
			}
		}
	}
	_tmp15_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ORDER, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	if (_tmp15_) {
		gboolean first_order;
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BY, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		}
		g_string_append (sql, " ORDER BY ");
		first_order = TRUE;
		{
			gboolean _tmp16_;
			_tmp16_ = TRUE;
			while (TRUE) {
				if (!_tmp16_) {
					gboolean _tmp17_;
					gboolean _tmp18_;
					_tmp17_ = FALSE;
					_tmp18_ = FALSE;
					if (tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_LIMIT) {
						_tmp18_ = tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
					} else {
						_tmp18_ = FALSE;
					}
					if (_tmp18_) {
						_tmp17_ = tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_EOF;
					} else {
						_tmp17_ = FALSE;
					}
					if (!_tmp17_) {
						break;
					}
				}
				_tmp16_ = FALSE;
				if (first_order) {
					first_order = FALSE;
				} else {
					g_string_append (sql, ", ");
				}
				tracker_sparql_query_translate_order_condition (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_string_free0 (pattern_sql);
					_g_string_free0 (sql);
					return NULL;
				}
			}
		}
	}
	limit = -1;
	offset = -1;
	_tmp19_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	if (_tmp19_) {
		char* _tmp20_;
		gboolean _tmp21_;
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		}
		limit = atoi (_tmp20_ = tracker_sparql_query_get_last_string (self, 0));
		_g_free0 (_tmp20_);
		_tmp21_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		}
		if (_tmp21_) {
			char* _tmp22_;
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_string_free0 (pattern_sql);
				_g_string_free0 (sql);
				return NULL;
			}
			offset = atoi (_tmp22_ = tracker_sparql_query_get_last_string (self, 0));
			_g_free0 (_tmp22_);
		}
	} else {
		gboolean _tmp23_;
		_tmp23_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		}
		if (_tmp23_) {
			char* _tmp24_;
			gboolean _tmp25_;
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_string_free0 (pattern_sql);
				_g_string_free0 (sql);
				return NULL;
			}
			offset = atoi (_tmp24_ = tracker_sparql_query_get_last_string (self, 0));
			_g_free0 (_tmp24_);
			_tmp25_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_string_free0 (pattern_sql);
				_g_string_free0 (sql);
				return NULL;
			}
			if (_tmp25_) {
				char* _tmp26_;
				tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_string_free0 (pattern_sql);
					_g_string_free0 (sql);
					return NULL;
				}
				limit = atoi (_tmp26_ = tracker_sparql_query_get_last_string (self, 0));
				_g_free0 (_tmp26_);
			}
		}
	}
	if (limit >= 0) {
		TrackerSparqlQueryLiteralBinding* binding;
		char* _tmp27_;
		g_string_append (sql, " LIMIT ?");
		binding = tracker_sparql_query_literal_binding_new ();
		binding->literal = (_tmp27_ = g_strdup_printf ("%i", limit), _g_free0 (binding->literal), _tmp27_);
		((TrackerSparqlQueryDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
		self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
		if (offset >= 0) {
			TrackerSparqlQueryLiteralBinding* _tmp28_;
			char* _tmp29_;
			g_string_append (sql, " OFFSET ?");
			binding = (_tmp28_ = tracker_sparql_query_literal_binding_new (), _g_object_unref0 (binding), _tmp28_);
			binding->literal = (_tmp29_ = g_strdup_printf ("%i", offset), _g_free0 (binding->literal), _tmp29_);
			((TrackerSparqlQueryDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
		}
		_g_object_unref0 (binding);
	} else {
		if (offset >= 0) {
			TrackerSparqlQueryLiteralBinding* binding;
			char* _tmp30_;
			g_string_append (sql, " LIMIT -1 OFFSET ?");
			binding = tracker_sparql_query_literal_binding_new ();
			binding->literal = (_tmp30_ = g_strdup_printf ("%i", offset), _g_free0 (binding->literal), _tmp30_);
			((TrackerSparqlQueryDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
			_g_object_unref0 (binding);
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_EOF, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	_tmp31_ = tracker_sparql_query_exec_sql (self, sql->str, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	result = _tmp31_;
	_g_string_free0 (pattern_sql);
	_g_string_free0 (sql);
	return result;
}


static void tracker_sparql_query_translate_expression_as_order_condition (TrackerSparqlQuery* self, GString* sql, GError** error) {
	GError * _inner_error_;
	glong begin;
	TrackerPropertyType _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	begin = sql->len;
	_tmp0_ = tracker_sparql_query_translate_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp0_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
		g_string_insert (sql, begin, "(SELECT Uri FROM \"rdfs:Resource\" WHERE ID = ");
		g_string_append (sql, ")");
	}
}


static void tracker_sparql_query_translate_order_condition (TrackerSparqlQuery* self, GString* sql, GError** error) {
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ASC, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp0_) {
		tracker_sparql_query_translate_expression_as_order_condition (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		g_string_append (sql, " ASC");
	} else {
		gboolean _tmp1_;
		_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DESC, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp1_) {
			tracker_sparql_query_translate_expression_as_order_condition (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			g_string_append (sql, " DESC");
		} else {
			tracker_sparql_query_translate_expression_as_order_condition (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static TrackerDBResultSet* tracker_sparql_query_execute_ask (TrackerSparqlQuery* self, GError** error) {
	TrackerDBResultSet* result;
	GError * _inner_error_;
	GString* pattern_sql;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GString* sql;
	TrackerDBResultSet* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	pattern_sql = g_string_new ("");
	self->priv->var_map = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->priv->var_map), _tmp0_);
	self->priv->predicate_variable_map = (_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->priv->predicate_variable_map), _tmp1_);
	sql = g_string_new ("");
	g_string_append (sql, "SELECT ");
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_ASK, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	g_string_append (sql, "COUNT(1) > 0");
	tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	tracker_sparql_query_translate_group_graph_pattern (self, pattern_sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	g_string_append (sql, " FROM (");
	g_string_append (sql, pattern_sql->str);
	g_string_append (sql, ")");
	_tmp2_ = tracker_sparql_query_exec_sql (self, sql->str, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return NULL;
	}
	result = _tmp2_;
	_g_string_free0 (pattern_sql);
	_g_string_free0 (sql);
	return result;
}


static void tracker_sparql_query_execute_insert (TrackerSparqlQuery* self, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INSERT, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	tracker_sparql_query_execute_update (self, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void tracker_sparql_query_execute_delete (TrackerSparqlQuery* self, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DELETE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	tracker_sparql_query_execute_update (self, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void tracker_sparql_query_execute_update (TrackerSparqlQuery* self, gboolean delete_statements, GError** error) {
	GError * _inner_error_;
	GString* pattern_sql;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GString* sql;
	TrackerSourceLocation _tmp2_ = {0};
	TrackerSourceLocation template_location;
	gboolean _tmp3_;
	TrackerSourceLocation _tmp4_ = {0};
	TrackerSourceLocation after_where;
	gboolean first;
	TrackerDBResultSet* result_set;
	GList* _tmp10_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	pattern_sql = g_string_new ("");
	self->priv->var_map = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->priv->var_map), _tmp0_);
	self->priv->predicate_variable_map = (_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->priv->predicate_variable_map), _tmp1_);
	sql = g_string_new ("");
	template_location = (tracker_sparql_query_get_location (self, &_tmp2_), _tmp2_);
	tracker_sparql_query_skip_braces (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return;
	}
	_tmp3_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return;
	}
	if (_tmp3_) {
		tracker_sparql_query_translate_group_graph_pattern (self, pattern_sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return;
		}
	}
	after_where = (tracker_sparql_query_get_location (self, &_tmp4_), _tmp4_);
	g_string_append (sql, "SELECT ");
	first = TRUE;
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = g_hash_table_get_values (self->priv->var_map);
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			TrackerSparqlQueryVariableBinding* binding;
			binding = _g_object_ref0 ((TrackerSparqlQueryVariableBinding*) binding_it->data);
			{
				char* _tmp5_;
				char* _tmp6_;
				if (!first) {
					g_string_append (sql, ", ");
				} else {
					first = FALSE;
				}
				_tmp5_ = tracker_sparql_query_get_sql_for_variable (self, binding->variable, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (binding);
					_g_list_free0 (binding_collection);
					_g_string_free0 (pattern_sql);
					_g_string_free0 (sql);
					return;
				}
				g_string_append (sql, _tmp6_ = _tmp5_);
				_g_free0 (_tmp6_);
				_g_object_unref0 (binding);
			}
		}
		_g_list_free0 (binding_collection);
	}
	if (first) {
		g_string_append (sql, "1");
	} else {
		g_string_append (sql, " FROM (");
		g_string_append (sql, pattern_sql->str);
		g_string_append (sql, ")");
	}
	result_set = tracker_sparql_query_exec_sql (self, sql->str, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (pattern_sql);
		_g_string_free0 (sql);
		return;
	}
	self->priv->delete_statements = delete_statements;
	if (result_set != NULL) {
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				GHashTable* var_value_map;
				gint var_idx;
				if (!_tmp7_) {
					if (!tracker_db_result_set_iter_next (result_set)) {
						break;
					}
				}
				_tmp7_ = FALSE;
				var_value_map = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
				var_idx = 0;
				{
					GList* var_name_collection;
					GList* var_name_it;
					var_name_collection = g_hash_table_get_keys (self->priv->var_map);
					for (var_name_it = var_name_collection; var_name_it != NULL; var_name_it = var_name_it->next) {
						char* var_name;
						var_name = g_strdup ((const char*) var_name_it->data);
						{
							GValue value = {0};
							GValue _tmp9_;
							GValue _tmp8_ = {0};
							_tracker_db_result_set_get_value (result_set, (guint) (var_idx++), &_tmp8_);
							value = (_tmp9_ = _tmp8_, G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp9_);
							g_hash_table_insert (var_value_map, g_strdup (var_name), tracker_sparql_query_get_string_for_value (&value));
							_g_free0 (var_name);
							G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
						}
					}
					_g_list_free0 (var_name_collection);
				}
				tracker_sparql_query_set_location (self, &template_location);
				tracker_sparql_query_parse_construct_triples_block (self, var_value_map, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_hash_table_unref0 (var_value_map);
					_g_string_free0 (pattern_sql);
					_g_string_free0 (sql);
					_g_object_unref0 (result_set);
					return;
				}
				_g_hash_table_unref0 (var_value_map);
			}
		}
	}
	tracker_sparql_query_set_location (self, &after_where);
	tracker_data_update_buffer_flush ();
	self->priv->bindings = (_tmp10_ = NULL, __g_list_free_g_object_unref0 (self->priv->bindings), _tmp10_);
	_g_string_free0 (pattern_sql);
	_g_string_free0 (sql);
	_g_object_unref0 (result_set);
}


static void tracker_sparql_query_execute_drop_graph (TrackerSparqlQuery* self, GError** error) {
	GError * _inner_error_;
	gboolean is_var;
	char* uri;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DROP, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_GRAPH, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	is_var = FALSE;
	uri = tracker_sparql_query_parse_var_or_term (self, NULL, &is_var, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	tracker_data_delete_resource_description (uri);
	_g_free0 (uri);
}


static char* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const char* prefix, const char* local_name, GError** error) {
	char* result;
	GError * _inner_error_;
	char* ns;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	g_return_val_if_fail (local_name != NULL, NULL);
	_inner_error_ = NULL;
	ns = g_strdup ((const char*) g_hash_table_lookup (self->priv->prefix_map, prefix));
	if (ns == NULL) {
		char* _tmp0_;
		GError* _tmp1_;
		_inner_error_ = (_tmp1_ = tracker_sparql_query_get_error (self, _tmp0_ = g_strdup_printf ("use of undefined prefix `%s'", prefix)), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (ns);
				return NULL;
			} else {
				_g_free0 (ns);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = g_strconcat (ns, local_name, NULL);
	_g_free0 (ns);
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static char* tracker_sparql_query_parse_var_or_term (TrackerSparqlQuery* self, GString* sql, gboolean* is_var, GError** error) {
	char* result;
	GError * _inner_error_;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	_result_ = g_strdup ("");
	(*is_var) = FALSE;
	if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
		char* _tmp1_;
		char* _tmp0_;
		(*is_var) = TRUE;
		tracker_sparql_query_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (_result_);
				return NULL;
			} else {
				_g_free0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_result_ = (_tmp1_ = string_substring (_tmp0_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), _g_free0 (_result_), _tmp1_);
		_g_free0 (_tmp0_);
	} else {
		if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
			char* _tmp2_;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (_result_);
					return NULL;
				} else {
					_g_free0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_result_ = (_tmp2_ = tracker_sparql_query_get_last_string (self, 1), _g_free0 (_result_), _tmp2_);
		} else {
			if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
				char* ns;
				char* _tmp4_;
				char* _tmp3_;
				char* _tmp5_;
				char* _tmp6_;
				char* _tmp7_;
				tracker_sparql_query_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				ns = tracker_sparql_query_get_last_string (self, 0);
				tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (ns);
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp6_ = (_tmp5_ = tracker_sparql_query_resolve_prefixed_name (self, ns, _tmp4_ = string_substring (_tmp3_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _tmp5_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (ns);
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_result_ = (_tmp7_ = _tmp6_, _g_free0 (_result_), _tmp7_);
				_g_free0 (ns);
			} else {
				if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
					char* _tmp9_;
					char* _tmp8_;
					char* _tmp10_;
					char* _tmp11_;
					char* _tmp12_;
					tracker_sparql_query_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp11_ = (_tmp10_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp9_ = string_substring (_tmp8_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _tmp10_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_result_ = (_tmp12_ = _tmp11_, _g_free0 (_result_), _tmp12_);
				} else {
					gboolean _tmp13_;
					_tmp13_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					if (_tmp13_) {
						char* _tmp16_;
						char* _tmp15_;
						char* _tmp14_;
						tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (_result_);
								return NULL;
							} else {
								_g_free0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_result_ = (_tmp16_ = tracker_sparql_query_generate_bnodeid (self, _tmp15_ = string_substring (_tmp14_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1)), _g_free0 (_result_), _tmp16_);
						_g_free0 (_tmp15_);
						_g_free0 (_tmp14_);
					} else {
						if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1) {
							char* _tmp17_;
							char* _tmp18_;
							_tmp17_ = tracker_sparql_query_parse_string_literal (self, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (_result_);
									return NULL;
								} else {
									_g_free0 (_result_);
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
							_result_ = (_tmp18_ = _tmp17_, _g_free0 (_result_), _tmp18_);
						} else {
							if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2) {
								char* _tmp19_;
								char* _tmp20_;
								_tmp19_ = tracker_sparql_query_parse_string_literal (self, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (_result_);
										return NULL;
									} else {
										_g_free0 (_result_);
										g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_result_ = (_tmp20_ = _tmp19_, _g_free0 (_result_), _tmp20_);
							} else {
								if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1) {
									char* _tmp21_;
									char* _tmp22_;
									_tmp21_ = tracker_sparql_query_parse_string_literal (self, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											_g_free0 (_result_);
											return NULL;
										} else {
											_g_free0 (_result_);
											g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
									_result_ = (_tmp22_ = _tmp21_, _g_free0 (_result_), _tmp22_);
								} else {
									if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2) {
										char* _tmp23_;
										char* _tmp24_;
										_tmp23_ = tracker_sparql_query_parse_string_literal (self, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												_g_free0 (_result_);
												return NULL;
											} else {
												_g_free0 (_result_);
												g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
												g_clear_error (&_inner_error_);
												return NULL;
											}
										}
										_result_ = (_tmp24_ = _tmp23_, _g_free0 (_result_), _tmp24_);
									} else {
										if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
											char* _tmp25_;
											tracker_sparql_query_next (self, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													_g_free0 (_result_);
													return NULL;
												} else {
													_g_free0 (_result_);
													g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
													g_clear_error (&_inner_error_);
													return NULL;
												}
											}
											_result_ = (_tmp25_ = tracker_sparql_query_get_last_string (self, 0), _g_free0 (_result_), _tmp25_);
										} else {
											if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL) {
												char* _tmp26_;
												tracker_sparql_query_next (self, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														_g_free0 (_result_);
														return NULL;
													} else {
														_g_free0 (_result_);
														g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
												_result_ = (_tmp26_ = tracker_sparql_query_get_last_string (self, 0), _g_free0 (_result_), _tmp26_);
											} else {
												if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE) {
													char* _tmp27_;
													tracker_sparql_query_next (self, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															_g_free0 (_result_);
															return NULL;
														} else {
															_g_free0 (_result_);
															g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
															g_clear_error (&_inner_error_);
															return NULL;
														}
													}
													_result_ = (_tmp27_ = tracker_sparql_query_get_last_string (self, 0), _g_free0 (_result_), _tmp27_);
												} else {
													if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_TRUE) {
														char* _tmp28_;
														tracker_sparql_query_next (self, &_inner_error_);
														if (_inner_error_ != NULL) {
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																g_propagate_error (error, _inner_error_);
																_g_free0 (_result_);
																return NULL;
															} else {
																_g_free0 (_result_);
																g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
																g_clear_error (&_inner_error_);
																return NULL;
															}
														}
														_result_ = (_tmp28_ = g_strdup ("true"), _g_free0 (_result_), _tmp28_);
													} else {
														if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_FALSE) {
															char* _tmp29_;
															tracker_sparql_query_next (self, &_inner_error_);
															if (_inner_error_ != NULL) {
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																	g_propagate_error (error, _inner_error_);
																	_g_free0 (_result_);
																	return NULL;
																} else {
																	_g_free0 (_result_);
																	g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
																	g_clear_error (&_inner_error_);
																	return NULL;
																}
															}
															_result_ = (_tmp29_ = g_strdup ("false"), _g_free0 (_result_), _tmp29_);
														} else {
															if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET) {
																char* _tmp30_;
																char* old_subject;
																gboolean old_subject_is_var;
																char* _tmp31_;
																char* _tmp32_;
																tracker_sparql_query_next (self, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																_result_ = (_tmp30_ = tracker_sparql_query_generate_bnodeid (self, NULL), _g_free0 (_result_), _tmp30_);
																old_subject = g_strdup (self->priv->current_subject);
																old_subject_is_var = self->priv->current_subject_is_var;
																self->priv->current_subject = (_tmp31_ = g_strdup (_result_), _g_free0 (self->priv->current_subject), _tmp31_);
																self->priv->current_subject_is_var = TRUE;
																tracker_sparql_query_parse_property_list_not_empty (self, sql, FALSE, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																self->priv->current_subject = (_tmp32_ = g_strdup (old_subject), _g_free0 (self->priv->current_subject), _tmp32_);
																self->priv->current_subject_is_var = old_subject_is_var;
																(*is_var) = TRUE;
																_g_free0 (old_subject);
															} else {
																_inner_error_ = tracker_sparql_query_get_error (self, "expected variable or term");
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = _result_;
	return result;
}


static void tracker_sparql_query_parse_object_list (TrackerSparqlQuery* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	while (TRUE) {
		gboolean _tmp0_;
		tracker_sparql_query_parse_object (self, sql, in_simple_optional, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp0_) {
			continue;
		}
		break;
	}
}


static void tracker_sparql_query_parse_property_list_not_empty (TrackerSparqlQuery* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	while (TRUE) {
		char* old_predicate;
		gboolean old_predicate_is_var;
		char* _tmp0_;
		char* _tmp15_;
		gboolean _tmp16_;
		old_predicate = g_strdup (self->priv->current_predicate);
		old_predicate_is_var = self->priv->current_predicate_is_var;
		self->priv->current_predicate = (_tmp0_ = NULL, _g_free0 (self->priv->current_predicate), _tmp0_);
		self->priv->current_predicate_is_var = FALSE;
		if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
			char* _tmp2_;
			char* _tmp1_;
			self->priv->current_predicate_is_var = TRUE;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (old_predicate);
					return;
				} else {
					_g_free0 (old_predicate);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			self->priv->current_predicate = (_tmp2_ = string_substring (_tmp1_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), _g_free0 (self->priv->current_predicate), _tmp2_);
			_g_free0 (_tmp1_);
		} else {
			if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
				char* _tmp3_;
				tracker_sparql_query_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_predicate);
						return;
					} else {
						_g_free0 (old_predicate);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				self->priv->current_predicate = (_tmp3_ = tracker_sparql_query_get_last_string (self, 1), _g_free0 (self->priv->current_predicate), _tmp3_);
			} else {
				if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
					char* ns;
					char* _tmp5_;
					char* _tmp4_;
					char* _tmp6_;
					char* _tmp7_;
					char* _tmp8_;
					tracker_sparql_query_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					ns = tracker_sparql_query_get_last_string (self, 0);
					tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (ns);
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp7_ = (_tmp6_ = tracker_sparql_query_resolve_prefixed_name (self, ns, _tmp5_ = string_substring (_tmp4_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _tmp6_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (ns);
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					self->priv->current_predicate = (_tmp8_ = _tmp7_, _g_free0 (self->priv->current_predicate), _tmp8_);
					_g_free0 (ns);
				} else {
					if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
						char* _tmp10_;
						char* _tmp9_;
						char* _tmp11_;
						char* _tmp12_;
						char* _tmp13_;
						tracker_sparql_query_next (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp12_ = (_tmp11_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp10_ = string_substring (_tmp9_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp10_), _g_free0 (_tmp9_), _tmp11_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						self->priv->current_predicate = (_tmp13_ = _tmp12_, _g_free0 (self->priv->current_predicate), _tmp13_);
					} else {
						if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_A) {
							char* _tmp14_;
							tracker_sparql_query_next (self, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (old_predicate);
									return;
								} else {
									_g_free0 (old_predicate);
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							self->priv->current_predicate = (_tmp14_ = g_strdup ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), _g_free0 (self->priv->current_predicate), _tmp14_);
						} else {
							_inner_error_ = tracker_sparql_query_get_error (self, "expected non-empty property list");
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (old_predicate);
									return;
								} else {
									_g_free0 (old_predicate);
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						}
					}
				}
			}
		}
		tracker_sparql_query_parse_object_list (self, sql, in_simple_optional, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_predicate);
				return;
			} else {
				_g_free0 (old_predicate);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		self->priv->current_predicate = (_tmp15_ = g_strdup (old_predicate), _g_free0 (self->priv->current_predicate), _tmp15_);
		self->priv->current_predicate_is_var = old_predicate_is_var;
		_tmp16_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_predicate);
				return;
			} else {
				_g_free0 (old_predicate);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp16_) {
			if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_DOT) {
				_g_free0 (old_predicate);
				break;
			}
			_g_free0 (old_predicate);
			continue;
		}
		_g_free0 (old_predicate);
		break;
	}
}


static void tracker_sparql_query_translate_bound_call (TrackerSparqlQuery* self, GString* sql, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BOUND, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, "(");
	tracker_sparql_query_translate_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, " IS NOT NULL)");
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_query_translate_regex (TrackerSparqlQuery* self, GString* sql, GError** error) {
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_REGEX, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, "SparqlRegex(");
	tracker_sparql_query_translate_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, ", ");
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_query_translate_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, ", ");
	_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp0_) {
		tracker_sparql_query_translate_expression (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		g_string_append (sql, "''");
	}
	g_string_append (sql, ")");
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_query_translate_expression_as_string (TrackerSparqlQuery* self, GString* sql, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	switch (tracker_sparql_query_current (self)) {
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
		{
			TrackerSparqlQueryLiteralBinding* binding;
			gboolean is_var;
			char* _tmp0_;
			char* _tmp1_;
			g_string_append (sql, "?");
			binding = tracker_sparql_query_literal_binding_new ();
			is_var = FALSE;
			_tmp0_ = tracker_sparql_query_parse_var_or_term (self, NULL, &is_var, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (binding);
					return;
				} else {
					_g_object_unref0 (binding);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			binding->literal = (_tmp1_ = _tmp0_, _g_free0 (binding->literal), _tmp1_);
			self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
			_g_object_unref0 (binding);
			break;
		}
		default:
		{
			glong begin;
			TrackerPropertyType _tmp2_;
			begin = sql->len;
			_tmp2_ = tracker_sparql_query_translate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			switch (_tmp2_) {
				case TRACKER_PROPERTY_TYPE_STRING:
				{
					break;
				}
				case TRACKER_PROPERTY_TYPE_RESOURCE:
				{
					g_string_insert (sql, begin, "(SELECT Uri FROM \"rdfs:Resource\" WHERE ID = ");
					g_string_append (sql, ")");
					break;
				}
				case TRACKER_PROPERTY_TYPE_BOOLEAN:
				{
					g_string_insert (sql, begin, "CASE ");
					g_string_append (sql, " WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END");
					break;
				}
				case TRACKER_PROPERTY_TYPE_DATETIME:
				{
					g_string_insert (sql, begin, "strftime (\"%Y-%m-%dT%H:%M:%SZ\", ");
					g_string_append (sql, ", \"unixepoch\")");
					break;
				}
				default:
				{
					g_string_insert (sql, begin, "CAST (");
					g_string_append (sql, " AS TEXT)");
					break;
				}
			}
			break;
		}
	}
}


static void tracker_sparql_query_translate_str (TrackerSparqlQuery* self, GString* sql, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_STR, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_query_translate_expression_as_string (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_query_translate_isuri (TrackerSparqlQuery* self, GString* sql, GError** error) {
	GError * _inner_error_;
	gboolean _tmp0_;
	TrackerSparqlQueryLiteralBinding* new_binding;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ISURI, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (!_tmp0_) {
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_ISIRI, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, "?");
	new_binding = tracker_sparql_query_literal_binding_new ();
	((TrackerSparqlQueryDataBinding*) new_binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
	if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
		char* _tmp1_;
		new_binding->literal = (_tmp1_ = g_strdup ("1"), _g_free0 (new_binding->literal), _tmp1_);
		tracker_sparql_query_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (new_binding);
				return;
			} else {
				_g_object_unref0 (new_binding);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		GString* _tmp2_;
		TrackerPropertyType _tmp3_;
		TrackerPropertyType _tmp4_;
		_tmp4_ = (_tmp3_ = tracker_sparql_query_translate_expression (self, _tmp2_ = g_string_new (""), &_inner_error_), _g_string_free0 (_tmp2_), _tmp3_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (new_binding);
				return;
			} else {
				_g_object_unref0 (new_binding);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp4_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
			char* _tmp5_;
			new_binding->literal = (_tmp5_ = g_strdup ("1"), _g_free0 (new_binding->literal), _tmp5_);
		} else {
			char* _tmp6_;
			new_binding->literal = (_tmp6_ = g_strdup ("0"), _g_free0 (new_binding->literal), _tmp6_);
		}
	}
	self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (new_binding));
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (new_binding);
			return;
		} else {
			_g_object_unref0 (new_binding);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (new_binding);
}


static void tracker_sparql_query_translate_datatype (TrackerSparqlQuery* self, GString* sql, GError** error) {
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp0_) {
		char* _tmp1_;
		char* _tmp2_;
		char* variable_name;
		TrackerSparqlQueryVariableBinding* binding;
		gboolean _tmp3_;
		TrackerSparqlQueryLiteralBinding* new_binding;
		char* _tmp4_;
		variable_name = (_tmp2_ = string_substring (_tmp1_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), _g_free0 (_tmp1_), _tmp2_);
		binding = _g_object_ref0 ((TrackerSparqlQueryVariableBinding*) g_hash_table_lookup (self->priv->var_map, variable_name));
		tracker_sparql_query_check_binding (self, binding, variable_name, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (variable_name);
				_g_object_unref0 (binding);
				return;
			} else {
				_g_free0 (variable_name);
				_g_object_unref0 (binding);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp3_ = FALSE;
		if (((TrackerSparqlQueryDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_RESOURCE) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = binding->type == NULL;
		}
		if (_tmp3_) {
			_inner_error_ = tracker_sparql_query_get_error (self, "Invalid FILTER");
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (variable_name);
					_g_object_unref0 (binding);
					return;
				} else {
					_g_free0 (variable_name);
					_g_object_unref0 (binding);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		g_string_append (sql, "(SELECT ID FROM \"rdfs:Resource\" WHERE Uri = ?)");
		new_binding = tracker_sparql_query_literal_binding_new ();
		new_binding->literal = (_tmp4_ = g_strdup (binding->type), _g_free0 (new_binding->literal), _tmp4_);
		self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (new_binding));
		_g_free0 (variable_name);
		_g_object_unref0 (binding);
		_g_object_unref0 (new_binding);
	} else {
		_inner_error_ = tracker_sparql_query_get_error (self, "Invalid FILTER");
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static TrackerPropertyType tracker_sparql_query_translate_function (TrackerSparqlQuery* self, GString* sql, const char* uri, GError** error) {
	TrackerPropertyType result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	g_return_val_if_fail (uri != NULL, 0);
	_inner_error_ = NULL;
	if (_vala_strcmp0 (uri, TRACKER_SPARQL_QUERY_FN_NS "contains") == 0) {
		TrackerSparqlQueryLiteralBinding* binding;
		char* _tmp0_;
		char* _tmp2_;
		char* _tmp1_;
		g_string_append (sql, "(");
		tracker_sparql_query_translate_expression_as_string (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		g_string_append (sql, " GLOB ");
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		g_string_append (sql, "?");
		binding = tracker_sparql_query_literal_binding_new ();
		_tmp0_ = tracker_sparql_query_parse_string_literal (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (binding);
				return 0;
			} else {
				_g_object_unref0 (binding);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		binding->literal = (_tmp2_ = g_strdup_printf ("*%s*", _tmp1_ = _tmp0_), _g_free0 (binding->literal), _tmp2_);
		_g_free0 (_tmp1_);
		self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
		g_string_append (sql, ")");
		result = TRACKER_PROPERTY_TYPE_BOOLEAN;
		_g_object_unref0 (binding);
		return result;
	} else {
		if (_vala_strcmp0 (uri, TRACKER_SPARQL_QUERY_FN_NS "starts-with") == 0) {
			TrackerSparqlQueryLiteralBinding* binding;
			char* _tmp3_;
			char* _tmp5_;
			char* _tmp4_;
			g_string_append (sql, "(");
			tracker_sparql_query_translate_expression_as_string (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, " GLOB ");
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "?");
			binding = tracker_sparql_query_literal_binding_new ();
			_tmp3_ = tracker_sparql_query_parse_string_literal (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (binding);
					return 0;
				} else {
					_g_object_unref0 (binding);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			binding->literal = (_tmp5_ = g_strdup_printf ("%s*", _tmp4_ = _tmp3_), _g_free0 (binding->literal), _tmp5_);
			_g_free0 (_tmp4_);
			self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
			g_string_append (sql, ")");
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			_g_object_unref0 (binding);
			return result;
		} else {
			if (_vala_strcmp0 (uri, TRACKER_SPARQL_QUERY_FN_NS "ends-with") == 0) {
				TrackerSparqlQueryLiteralBinding* binding;
				char* _tmp6_;
				char* _tmp8_;
				char* _tmp7_;
				g_string_append (sql, "(");
				tracker_sparql_query_translate_expression_as_string (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_append (sql, " GLOB ");
				tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_append (sql, "?");
				binding = tracker_sparql_query_literal_binding_new ();
				_tmp6_ = tracker_sparql_query_parse_string_literal (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (binding);
						return 0;
					} else {
						_g_object_unref0 (binding);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				binding->literal = (_tmp8_ = g_strdup_printf ("*%s", _tmp7_ = _tmp6_), _g_free0 (binding->literal), _tmp8_);
				_g_free0 (_tmp7_);
				self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
				g_string_append (sql, ")");
				result = TRACKER_PROPERTY_TYPE_BOOLEAN;
				_g_object_unref0 (binding);
				return result;
			} else {
				_inner_error_ = tracker_sparql_query_get_error (self, "Unknown function");
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
			}
		}
	}
}


static char* tracker_sparql_query_parse_string_literal (TrackerSparqlQuery* self, GError** error) {
	char* result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_next (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	switch (tracker_sparql_query_last (self)) {
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
		{
			GString* sb;
			char* s;
			const char* p;
			const char* end;
			gboolean _tmp0_;
			sb = g_string_new ("");
			s = tracker_sparql_query_get_last_string (self, 1);
			p = s;
			end = p + strlen (s);
			while (TRUE) {
				const char* q;
				if (!(((glong) p) < ((glong) end))) {
					break;
				}
				q = strchr (p, (gint) '\\');
				if (q == NULL) {
					g_string_append_len (sb, p, (glong) (end - p));
					p = end;
				} else {
					g_string_append_len (sb, p, (glong) (q - p));
					p = q + 1;
					switch (((gchar*) p)[0]) {
						case '\'':
						case '"':
						case '\\':
						{
							g_string_append_c (sb, ((gchar*) p)[0]);
							break;
						}
						case 'b':
						{
							g_string_append_c (sb, '\b');
							break;
						}
						case 'f':
						{
							g_string_append_c (sb, '\f');
							break;
						}
						case 'n':
						{
							g_string_append_c (sb, '\n');
							break;
						}
						case 'r':
						{
							g_string_append_c (sb, '\r');
							break;
						}
						case 't':
						{
							g_string_append_c (sb, '\t');
							break;
						}
					}
					p++;
				}
			}
			_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_string_free0 (sb);
					_g_free0 (s);
					return NULL;
				} else {
					_g_string_free0 (sb);
					_g_free0 (s);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp0_) {
				gboolean _tmp1_;
				_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_string_free0 (sb);
						_g_free0 (s);
						return NULL;
					} else {
						_g_string_free0 (sb);
						_g_free0 (s);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				if (!_tmp1_) {
					tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_string_free0 (sb);
							_g_free0 (s);
							return NULL;
						} else {
							_g_string_free0 (sb);
							_g_free0 (s);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_string_free0 (sb);
							_g_free0 (s);
							return NULL;
						} else {
							_g_string_free0 (sb);
							_g_free0 (s);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
			}
			result = g_strdup (sb->str);
			_g_string_free0 (sb);
			_g_free0 (s);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
		{
			char* _result_;
			gboolean _tmp2_;
			_result_ = tracker_sparql_query_get_last_string (self, 3);
			_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (_result_);
					return NULL;
				} else {
					_g_free0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp2_) {
				gboolean _tmp3_;
				_tmp3_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				if (!_tmp3_) {
					tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
			}
			result = _result_;
			return result;
		}
		default:
		{
			_inner_error_ = tracker_sparql_query_get_error (self, "expected string literal");
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_query_translate_primary_expression (TrackerSparqlQuery* self, GString* sql, GError** error) {
	TrackerPropertyType result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	switch (tracker_sparql_query_current (self)) {
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
		{
			TrackerPropertyType _tmp0_;
			_tmp0_ = tracker_sparql_query_translate_bracketted_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp0_;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
		{
			TrackerSparqlQueryLiteralBinding* binding;
			char* _tmp1_;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "(SELECT ID FROM \"rdfs:Resource\" WHERE Uri = ?)");
			binding = tracker_sparql_query_literal_binding_new ();
			binding->literal = (_tmp1_ = tracker_sparql_query_get_last_string (self, 1), _g_free0 (binding->literal), _tmp1_);
			self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
			result = TRACKER_PROPERTY_TYPE_RESOURCE;
			_g_object_unref0 (binding);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
		{
			TrackerSparqlQueryLiteralBinding* binding;
			char* _tmp2_;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "?");
			binding = tracker_sparql_query_literal_binding_new ();
			binding->literal = (_tmp2_ = tracker_sparql_query_get_last_string (self, 0), _g_free0 (binding->literal), _tmp2_);
			self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
			result = TRACKER_PROPERTY_TYPE_DOUBLE;
			_g_object_unref0 (binding);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
		{
			TrackerSparqlQueryLiteralBinding* binding;
			char* _tmp3_;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "?");
			binding = tracker_sparql_query_literal_binding_new ();
			binding->literal = (_tmp3_ = g_strdup ("1"), _g_free0 (binding->literal), _tmp3_);
			((TrackerSparqlQueryDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			_g_object_unref0 (binding);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
		{
			TrackerSparqlQueryLiteralBinding* binding;
			char* _tmp4_;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "?");
			binding = tracker_sparql_query_literal_binding_new ();
			binding->literal = (_tmp4_ = g_strdup ("0"), _g_free0 (binding->literal), _tmp4_);
			((TrackerSparqlQueryDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			_g_object_unref0 (binding);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
		{
			TrackerSparqlQueryLiteralBinding* binding;
			char* _tmp5_;
			char* _tmp6_;
			g_string_append (sql, "?");
			binding = tracker_sparql_query_literal_binding_new ();
			_tmp5_ = tracker_sparql_query_parse_string_literal (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (binding);
					return 0;
				} else {
					_g_object_unref0 (binding);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			binding->literal = (_tmp6_ = _tmp5_, _g_free0 (binding->literal), _tmp6_);
			self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
			result = TRACKER_PROPERTY_TYPE_STRING;
			_g_object_unref0 (binding);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
		{
			TrackerSparqlQueryLiteralBinding* binding;
			char* _tmp7_;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "?");
			binding = tracker_sparql_query_literal_binding_new ();
			binding->literal = (_tmp7_ = tracker_sparql_query_get_last_string (self, 0), _g_free0 (binding->literal), _tmp7_);
			((TrackerSparqlQueryDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
			result = TRACKER_PROPERTY_TYPE_INTEGER;
			_g_object_unref0 (binding);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
		{
			char* _tmp8_;
			char* _tmp9_;
			char* variable_name;
			TrackerSparqlQueryVariableBinding* binding;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			variable_name = (_tmp9_ = string_substring (_tmp8_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), _g_free0 (_tmp8_), _tmp9_);
			g_string_append_printf (sql, "\"%s_u\"", variable_name);
			binding = _g_object_ref0 ((TrackerSparqlQueryVariableBinding*) g_hash_table_lookup (self->priv->var_map, variable_name));
			if (binding == NULL) {
				result = TRACKER_PROPERTY_TYPE_UNKNOWN;
				_g_free0 (variable_name);
				_g_object_unref0 (binding);
				return result;
			} else {
				result = ((TrackerSparqlQueryDataBinding*) binding)->data_type;
				_g_free0 (variable_name);
				_g_object_unref0 (binding);
				return result;
			}
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
		{
			tracker_sparql_query_translate_str (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_STRING;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
		{
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "''");
			result = TRACKER_PROPERTY_TYPE_STRING;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
		{
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "0");
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
		{
			tracker_sparql_query_translate_datatype (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_RESOURCE;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
		{
			tracker_sparql_query_translate_bound_call (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
		{
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "(");
			tracker_sparql_query_translate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, " = ");
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_query_translate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, ")");
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
		{
			tracker_sparql_query_translate_isuri (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
		{
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "0");
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
		{
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
		{
			tracker_sparql_query_translate_regex (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
		{
			char* ns;
			char* _tmp11_;
			char* _tmp10_;
			char* _tmp12_;
			char* uri;
			gboolean _tmp13_;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			ns = tracker_sparql_query_get_last_string (self, 0);
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					return 0;
				} else {
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			uri = (_tmp12_ = tracker_sparql_query_resolve_prefixed_name (self, ns, _tmp11_ = string_substring (_tmp10_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp11_), _g_free0 (_tmp10_), _tmp12_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					return 0;
				} else {
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp13_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					_g_free0 (uri);
					return 0;
				} else {
					_g_free0 (ns);
					_g_free0 (uri);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp13_) {
				TrackerPropertyType _result_;
				_result_ = tracker_sparql_query_translate_function (self, sql, uri, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (uri);
						return 0;
					} else {
						_g_free0 (ns);
						_g_free0 (uri);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (uri);
						return 0;
					} else {
						_g_free0 (ns);
						_g_free0 (uri);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				result = _result_;
				_g_free0 (ns);
				_g_free0 (uri);
				return result;
			} else {
				TrackerSparqlQueryLiteralBinding* binding;
				char* _tmp14_;
				g_string_append (sql, "(SELECT ID FROM \"rdfs:Resource\" WHERE Uri = ?)");
				binding = tracker_sparql_query_literal_binding_new ();
				binding->literal = (_tmp14_ = g_strdup (uri), _g_free0 (binding->literal), _tmp14_);
				self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
				result = TRACKER_PROPERTY_TYPE_RESOURCE;
				_g_object_unref0 (binding);
				_g_free0 (ns);
				_g_free0 (uri);
				return result;
			}
		}
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
		{
			TrackerSparqlQueryLiteralBinding* binding;
			char* _tmp16_;
			char* _tmp15_;
			char* _tmp17_;
			char* _tmp18_;
			char* _tmp19_;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "(SELECT ID FROM \"rdfs:Resource\" WHERE Uri = ?)");
			binding = tracker_sparql_query_literal_binding_new ();
			_tmp18_ = (_tmp17_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp16_ = string_substring (_tmp15_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp16_), _g_free0 (_tmp15_), _tmp17_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (binding);
					return 0;
				} else {
					_g_object_unref0 (binding);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			binding->literal = (_tmp19_ = _tmp18_, _g_free0 (binding->literal), _tmp19_);
			self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
			result = TRACKER_PROPERTY_TYPE_RESOURCE;
			_g_object_unref0 (binding);
			return result;
		}
		default:
		{
			_inner_error_ = tracker_sparql_query_get_error (self, "expected primary expression");
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_query_translate_unary_expression (TrackerSparqlQuery* self, GString* sql, GError** error) {
	TrackerPropertyType result;
	GError * _inner_error_;
	gboolean _tmp0_;
	TrackerPropertyType _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp0_) {
		TrackerPropertyType optype;
		g_string_append (sql, "NOT (");
		optype = tracker_sparql_query_translate_primary_expression (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		g_string_append (sql, ")");
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			_inner_error_ = tracker_sparql_query_get_error (self, "expected boolean expression");
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
		result = TRACKER_PROPERTY_TYPE_BOOLEAN;
		return result;
	} else {
		gboolean _tmp1_;
		_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp1_) {
			TrackerPropertyType _tmp2_;
			_tmp2_ = tracker_sparql_query_translate_primary_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp2_;
			return result;
		} else {
			gboolean _tmp3_;
			_tmp3_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp3_) {
				TrackerPropertyType optype;
				g_string_append (sql, "-(");
				optype = tracker_sparql_query_translate_primary_expression (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_append (sql, ")");
				result = optype;
				return result;
			}
		}
	}
	_tmp4_ = tracker_sparql_query_translate_primary_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp4_;
	return result;
}


static TrackerPropertyType tracker_sparql_query_translate_multiplicative_expression (TrackerSparqlQuery* self, GString* sql, GError** error) {
	TrackerPropertyType result;
	GError * _inner_error_;
	glong begin;
	TrackerPropertyType optype;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	begin = sql->len;
	optype = tracker_sparql_query_translate_unary_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp0_;
		_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp0_) {
			TrackerPropertyType _tmp1_;
			if (!tracker_sparql_query_maybe_numeric (self, optype)) {
				_inner_error_ = tracker_sparql_query_get_error (self, "expected numeric operand");
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
			}
			g_string_insert (sql, begin, "(");
			g_string_append (sql, " * ");
			_tmp1_ = tracker_sparql_query_translate_unary_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (!tracker_sparql_query_maybe_numeric (self, _tmp1_)) {
				_inner_error_ = tracker_sparql_query_get_error (self, "expected numeric operand");
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
			}
			g_string_append (sql, ")");
		} else {
			gboolean _tmp2_;
			_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DIV, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp2_) {
				TrackerPropertyType _tmp3_;
				if (!tracker_sparql_query_maybe_numeric (self, optype)) {
					_inner_error_ = tracker_sparql_query_get_error (self, "expected numeric operand");
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
				}
				g_string_insert (sql, begin, "(");
				g_string_append (sql, " / ");
				_tmp3_ = tracker_sparql_query_translate_unary_expression (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				if (!tracker_sparql_query_maybe_numeric (self, _tmp3_)) {
					_inner_error_ = tracker_sparql_query_get_error (self, "expected numeric operand");
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
				}
				g_string_append (sql, ")");
			} else {
				break;
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_query_translate_additive_expression (TrackerSparqlQuery* self, GString* sql, GError** error) {
	TrackerPropertyType result;
	GError * _inner_error_;
	glong begin;
	TrackerPropertyType optype;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	begin = sql->len;
	optype = tracker_sparql_query_translate_multiplicative_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp0_;
		_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp0_) {
			TrackerPropertyType _tmp1_;
			if (!tracker_sparql_query_maybe_numeric (self, optype)) {
				_inner_error_ = tracker_sparql_query_get_error (self, "expected numeric operand");
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
			}
			g_string_insert (sql, begin, "(");
			g_string_append (sql, " + ");
			_tmp1_ = tracker_sparql_query_translate_multiplicative_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (!tracker_sparql_query_maybe_numeric (self, _tmp1_)) {
				_inner_error_ = tracker_sparql_query_get_error (self, "expected numeric operand");
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
			}
			g_string_append (sql, ")");
		} else {
			gboolean _tmp2_;
			_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp2_) {
				TrackerPropertyType _tmp3_;
				if (!tracker_sparql_query_maybe_numeric (self, optype)) {
					_inner_error_ = tracker_sparql_query_get_error (self, "expected numeric operand");
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
				}
				g_string_insert (sql, begin, "(");
				g_string_append (sql, " - ");
				_tmp3_ = tracker_sparql_query_translate_multiplicative_expression (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				if (!tracker_sparql_query_maybe_numeric (self, _tmp3_)) {
					_inner_error_ = tracker_sparql_query_get_error (self, "expected numeric operand");
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
				}
				g_string_append (sql, ")");
			} else {
				break;
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_query_translate_numeric_expression (TrackerSparqlQuery* self, GString* sql, GError** error) {
	TrackerPropertyType result;
	GError * _inner_error_;
	TrackerPropertyType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_translate_additive_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp0_;
	return result;
}


static TrackerPropertyType tracker_sparql_query_process_relational_expression (TrackerSparqlQuery* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const char* operator, GError** error) {
	TrackerPropertyType result;
	GError * _inner_error_;
	TrackerPropertyType op2type;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	g_return_val_if_fail (operator != NULL, 0);
	_inner_error_ = NULL;
	g_string_insert (sql, begin, "(");
	g_string_append (sql, operator);
	op2type = tracker_sparql_query_translate_numeric_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	g_string_append (sql, ")");
	_tmp0_ = FALSE;
	_tmp1_ = FALSE;
	if (op1type == TRACKER_PROPERTY_TYPE_DATETIME) {
		_tmp1_ = op2type == TRACKER_PROPERTY_TYPE_STRING;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = FALSE;
		if (op1type == TRACKER_PROPERTY_TYPE_STRING) {
			_tmp2_ = op2type == TRACKER_PROPERTY_TYPE_DATETIME;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		if (g_list_length (self->priv->bindings) == (n_bindings + 1)) {
			((TrackerSparqlQueryDataBinding*) ((TrackerSparqlQueryLiteralBinding*) g_list_last (self->priv->bindings)->data))->data_type = TRACKER_PROPERTY_TYPE_DATETIME;
		}
	}
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
	return result;
}


static TrackerPropertyType tracker_sparql_query_translate_relational_expression (TrackerSparqlQuery* self, GString* sql, GError** error) {
	TrackerPropertyType result;
	GError * _inner_error_;
	glong begin;
	guint n_bindings;
	TrackerPropertyType optype;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	begin = sql->len;
	n_bindings = g_list_length (self->priv->bindings);
	optype = tracker_sparql_query_translate_numeric_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp0_) {
		TrackerPropertyType _tmp1_;
		_tmp1_ = tracker_sparql_query_process_relational_expression (self, sql, begin, n_bindings, optype, " >= ", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = _tmp1_;
		return result;
	} else {
		gboolean _tmp2_;
		_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp2_) {
			TrackerPropertyType _tmp3_;
			_tmp3_ = tracker_sparql_query_process_relational_expression (self, sql, begin, n_bindings, optype, " = ", &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp3_;
			return result;
		} else {
			gboolean _tmp4_;
			_tmp4_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp4_) {
				TrackerPropertyType _tmp5_;
				_tmp5_ = tracker_sparql_query_process_relational_expression (self, sql, begin, n_bindings, optype, " <> ", &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				result = _tmp5_;
				return result;
			} else {
				gboolean _tmp6_;
				_tmp6_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LT, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				if (_tmp6_) {
					TrackerPropertyType _tmp7_;
					_tmp7_ = tracker_sparql_query_process_relational_expression (self, sql, begin, n_bindings, optype, " < ", &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
					result = _tmp7_;
					return result;
				} else {
					gboolean _tmp8_;
					_tmp8_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LE, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
					if (_tmp8_) {
						TrackerPropertyType _tmp9_;
						_tmp9_ = tracker_sparql_query_process_relational_expression (self, sql, begin, n_bindings, optype, " <= ", &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						result = _tmp9_;
						return result;
					} else {
						gboolean _tmp10_;
						_tmp10_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GT, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						if (_tmp10_) {
							TrackerPropertyType _tmp11_;
							_tmp11_ = tracker_sparql_query_process_relational_expression (self, sql, begin, n_bindings, optype, " > ", &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return 0;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							result = _tmp11_;
							return result;
						}
					}
				}
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_query_translate_value_logical (TrackerSparqlQuery* self, GString* sql, GError** error) {
	TrackerPropertyType result;
	GError * _inner_error_;
	TrackerPropertyType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_translate_relational_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp0_;
	return result;
}


static TrackerPropertyType tracker_sparql_query_translate_conditional_and_expression (TrackerSparqlQuery* self, GString* sql, GError** error) {
	TrackerPropertyType result;
	GError * _inner_error_;
	glong begin;
	TrackerPropertyType optype;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	begin = sql->len;
	optype = tracker_sparql_query_translate_value_logical (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp0_;
		TrackerPropertyType _tmp1_;
		_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_AND, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (!_tmp0_) {
			break;
		}
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			_inner_error_ = tracker_sparql_query_get_error (self, "expected boolean expression");
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
		g_string_insert (sql, begin, "(");
		g_string_append (sql, " AND ");
		_tmp1_ = tracker_sparql_query_translate_value_logical (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		optype = _tmp1_;
		g_string_append (sql, ")");
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			_inner_error_ = tracker_sparql_query_get_error (self, "expected boolean expression");
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_query_translate_conditional_or_expression (TrackerSparqlQuery* self, GString* sql, GError** error) {
	TrackerPropertyType result;
	GError * _inner_error_;
	glong begin;
	TrackerPropertyType optype;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	begin = sql->len;
	optype = tracker_sparql_query_translate_conditional_and_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp0_;
		TrackerPropertyType _tmp1_;
		_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_OR, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (!_tmp0_) {
			break;
		}
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			_inner_error_ = tracker_sparql_query_get_error (self, "expected boolean expression");
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
		g_string_insert (sql, begin, "(");
		g_string_append (sql, " OR ");
		_tmp1_ = tracker_sparql_query_translate_conditional_and_expression (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		optype = _tmp1_;
		g_string_append (sql, ")");
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			_inner_error_ = tracker_sparql_query_get_error (self, "expected boolean expression");
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_query_translate_expression (TrackerSparqlQuery* self, GString* sql, GError** error) {
	TrackerPropertyType result;
	GError * _inner_error_;
	TrackerPropertyType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_translate_conditional_or_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp0_;
	return result;
}


static TrackerPropertyType tracker_sparql_query_translate_bracketted_expression (TrackerSparqlQuery* self, GString* sql, GError** error) {
	TrackerPropertyType result;
	GError * _inner_error_;
	TrackerPropertyType optype;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	optype = tracker_sparql_query_translate_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_query_translate_constraint (TrackerSparqlQuery* self, GString* sql, GError** error) {
	TrackerPropertyType result;
	GError * _inner_error_;
	TrackerPropertyType _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	switch (tracker_sparql_query_current (self)) {
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
		{
			TrackerPropertyType _tmp0_;
			_tmp0_ = tracker_sparql_query_translate_primary_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp0_;
			return result;
		}
	}
	_tmp1_ = tracker_sparql_query_translate_bracketted_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp1_;
	return result;
}


static void tracker_sparql_query_translate_filter (TrackerSparqlQuery* self, GString* sql, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_FILTER, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_query_translate_constraint (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_query_skip_filter (TrackerSparqlQuery* self, GError** error) {
	GError * _inner_error_;
	gint n_parens;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_FILTER, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	switch (tracker_sparql_query_current (self)) {
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
		{
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			break;
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	n_parens = 1;
	while (TRUE) {
		gboolean _tmp0_;
		if (!(n_parens > 0)) {
			break;
		}
		_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp0_) {
			n_parens++;
		} else {
			gboolean _tmp1_;
			_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (_tmp1_) {
				n_parens--;
			} else {
				if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
					_inner_error_ = tracker_sparql_query_get_error (self, "unexpected end of query, expected )");
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				} else {
					tracker_sparql_query_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
			}
		}
	}
}


static void tracker_sparql_query_skip_braces (TrackerSparqlQuery* self, GError** error) {
	GError * _inner_error_;
	gint n_braces;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	n_braces = 1;
	while (TRUE) {
		gboolean _tmp0_;
		if (!(n_braces > 0)) {
			break;
		}
		_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp0_) {
			n_braces++;
		} else {
			gboolean _tmp1_;
			_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (_tmp1_) {
				n_braces--;
			} else {
				if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
					_inner_error_ = tracker_sparql_query_get_error (self, "unexpected end of query, expected }");
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				} else {
					tracker_sparql_query_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
			}
		}
	}
}


static void tracker_sparql_query_parse_construct_triples_block (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (var_value_map != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE) {
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				char* _tmp3_;
				char* _tmp4_;
				if (!_tmp0_) {
					gboolean _tmp1_;
					gboolean _tmp2_;
					_tmp1_ = FALSE;
					_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
					if (_inner_error_ != NULL) {
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					if (_tmp2_) {
						_tmp1_ = tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
					} else {
						_tmp1_ = FALSE;
					}
					if (!_tmp1_) {
						break;
					}
				}
				_tmp0_ = FALSE;
				_tmp3_ = tracker_sparql_query_parse_construct_var_or_term (self, var_value_map, &_inner_error_);
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				self->priv->current_subject = (_tmp4_ = _tmp3_, _g_free0 (self->priv->current_subject), _tmp4_);
				tracker_sparql_query_parse_construct_property_list_not_empty (self, var_value_map, &_inner_error_);
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static char* tracker_sparql_query_parse_construct_var_or_term (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	char* result;
	GError * _inner_error_;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (var_value_map != NULL, NULL);
	_inner_error_ = NULL;
	_result_ = g_strdup ("");
	if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
		char* _tmp2_;
		char* _tmp1_;
		char* _tmp0_;
		tracker_sparql_query_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (_result_);
				return NULL;
			} else {
				_g_free0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_result_ = (_tmp2_ = g_strdup ((const char*) g_hash_table_lookup (var_value_map, _tmp1_ = string_substring (_tmp0_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1))), _g_free0 (_result_), _tmp2_);
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_result_ == NULL) {
			_inner_error_ = tracker_sparql_query_get_error (self, "undefined variable");
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (_result_);
					return NULL;
				} else {
					_g_free0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	} else {
		if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
			char* _tmp3_;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (_result_);
					return NULL;
				} else {
					_g_free0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_result_ = (_tmp3_ = tracker_sparql_query_get_last_string (self, 1), _g_free0 (_result_), _tmp3_);
		} else {
			if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
				char* ns;
				char* _tmp5_;
				char* _tmp4_;
				char* _tmp6_;
				char* _tmp7_;
				char* _tmp8_;
				tracker_sparql_query_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				ns = tracker_sparql_query_get_last_string (self, 0);
				tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (ns);
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp7_ = (_tmp6_ = tracker_sparql_query_resolve_prefixed_name (self, ns, _tmp5_ = string_substring (_tmp4_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _tmp6_);
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (ns);
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_result_ = (_tmp8_ = _tmp7_, _g_free0 (_result_), _tmp8_);
				_g_free0 (ns);
			} else {
				if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
					char* _tmp10_;
					char* _tmp9_;
					char* _tmp11_;
					char* _tmp12_;
					char* _tmp13_;
					tracker_sparql_query_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp12_ = (_tmp11_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp10_ = string_substring (_tmp9_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp10_), _g_free0 (_tmp9_), _tmp11_);
					if (_inner_error_ != NULL) {
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_result_ = (_tmp13_ = _tmp12_, _g_free0 (_result_), _tmp13_);
				} else {
					gboolean _tmp14_;
					_tmp14_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
					if (_inner_error_ != NULL) {
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					if (_tmp14_) {
						char* _tmp17_;
						char* _tmp16_;
						char* _tmp15_;
						tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (_result_);
								return NULL;
							} else {
								_g_free0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_result_ = (_tmp17_ = tracker_sparql_query_generate_bnodeid (self, _tmp16_ = string_substring (_tmp15_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1)), _g_free0 (_result_), _tmp17_);
						_g_free0 (_tmp16_);
						_g_free0 (_tmp15_);
					} else {
						if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
							char* _tmp18_;
							tracker_sparql_query_next (self, &_inner_error_);
							if (_inner_error_ != NULL) {
								if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (_result_);
									return NULL;
								} else {
									_g_free0 (_result_);
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
							_result_ = (_tmp18_ = tracker_sparql_query_get_last_string (self, 0), _g_free0 (_result_), _tmp18_);
						} else {
							if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL) {
								char* _tmp19_;
								tracker_sparql_query_next (self, &_inner_error_);
								if (_inner_error_ != NULL) {
									if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (_result_);
										return NULL;
									} else {
										_g_free0 (_result_);
										g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_result_ = (_tmp19_ = tracker_sparql_query_get_last_string (self, 0), _g_free0 (_result_), _tmp19_);
							} else {
								if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE) {
									char* _tmp20_;
									tracker_sparql_query_next (self, &_inner_error_);
									if (_inner_error_ != NULL) {
										if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
											g_propagate_error (error, _inner_error_);
											_g_free0 (_result_);
											return NULL;
										} else {
											_g_free0 (_result_);
											g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
									_result_ = (_tmp20_ = tracker_sparql_query_get_last_string (self, 0), _g_free0 (_result_), _tmp20_);
								} else {
									if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_TRUE) {
										char* _tmp21_;
										tracker_sparql_query_next (self, &_inner_error_);
										if (_inner_error_ != NULL) {
											if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
												g_propagate_error (error, _inner_error_);
												_g_free0 (_result_);
												return NULL;
											} else {
												_g_free0 (_result_);
												g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
												g_clear_error (&_inner_error_);
												return NULL;
											}
										}
										_result_ = (_tmp21_ = g_strdup ("true"), _g_free0 (_result_), _tmp21_);
									} else {
										if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_FALSE) {
											char* _tmp22_;
											tracker_sparql_query_next (self, &_inner_error_);
											if (_inner_error_ != NULL) {
												if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
													g_propagate_error (error, _inner_error_);
													_g_free0 (_result_);
													return NULL;
												} else {
													_g_free0 (_result_);
													g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
													g_clear_error (&_inner_error_);
													return NULL;
												}
											}
											_result_ = (_tmp22_ = g_strdup ("false"), _g_free0 (_result_), _tmp22_);
										} else {
											if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1) {
												char* _tmp23_;
												char* _tmp24_;
												_tmp23_ = tracker_sparql_query_parse_string_literal (self, &_inner_error_);
												if (_inner_error_ != NULL) {
													if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
														g_propagate_error (error, _inner_error_);
														_g_free0 (_result_);
														return NULL;
													} else {
														_g_free0 (_result_);
														g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
												_result_ = (_tmp24_ = _tmp23_, _g_free0 (_result_), _tmp24_);
											} else {
												if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2) {
													char* _tmp25_;
													char* _tmp26_;
													_tmp25_ = tracker_sparql_query_parse_string_literal (self, &_inner_error_);
													if (_inner_error_ != NULL) {
														if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
															g_propagate_error (error, _inner_error_);
															_g_free0 (_result_);
															return NULL;
														} else {
															_g_free0 (_result_);
															g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
															g_clear_error (&_inner_error_);
															return NULL;
														}
													}
													_result_ = (_tmp26_ = _tmp25_, _g_free0 (_result_), _tmp26_);
												} else {
													if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1) {
														char* _tmp27_;
														char* _tmp28_;
														_tmp27_ = tracker_sparql_query_parse_string_literal (self, &_inner_error_);
														if (_inner_error_ != NULL) {
															if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
																g_propagate_error (error, _inner_error_);
																_g_free0 (_result_);
																return NULL;
															} else {
																_g_free0 (_result_);
																g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
																g_clear_error (&_inner_error_);
																return NULL;
															}
														}
														_result_ = (_tmp28_ = _tmp27_, _g_free0 (_result_), _tmp28_);
													} else {
														if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2) {
															char* _tmp29_;
															char* _tmp30_;
															_tmp29_ = tracker_sparql_query_parse_string_literal (self, &_inner_error_);
															if (_inner_error_ != NULL) {
																if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
																	g_propagate_error (error, _inner_error_);
																	_g_free0 (_result_);
																	return NULL;
																} else {
																	_g_free0 (_result_);
																	g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
																	g_clear_error (&_inner_error_);
																	return NULL;
																}
															}
															_result_ = (_tmp30_ = _tmp29_, _g_free0 (_result_), _tmp30_);
														} else {
															if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET) {
																char* _tmp31_;
																char* old_subject;
																gboolean old_subject_is_var;
																char* _tmp32_;
																char* _tmp33_;
																tracker_sparql_query_next (self, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																_result_ = (_tmp31_ = tracker_sparql_query_generate_bnodeid (self, NULL), _g_free0 (_result_), _tmp31_);
																old_subject = g_strdup (self->priv->current_subject);
																old_subject_is_var = self->priv->current_subject_is_var;
																self->priv->current_subject = (_tmp32_ = g_strdup (_result_), _g_free0 (self->priv->current_subject), _tmp32_);
																tracker_sparql_query_parse_construct_property_list_not_empty (self, var_value_map, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																self->priv->current_subject = (_tmp33_ = g_strdup (old_subject), _g_free0 (self->priv->current_subject), _tmp33_);
																self->priv->current_subject_is_var = old_subject_is_var;
																_g_free0 (old_subject);
															} else {
																_inner_error_ = tracker_sparql_query_get_error (self, "expected variable or term");
																if (_inner_error_ != NULL) {
																	if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = _result_;
	return result;
}


static void tracker_sparql_query_parse_construct_property_list_not_empty (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (var_value_map != NULL);
	_inner_error_ = NULL;
	while (TRUE) {
		char* old_predicate;
		char* _tmp0_;
		char* _tmp16_;
		gboolean _tmp17_;
		old_predicate = g_strdup (self->priv->current_predicate);
		self->priv->current_predicate = (_tmp0_ = NULL, _g_free0 (self->priv->current_predicate), _tmp0_);
		if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
			char* _tmp3_;
			char* _tmp2_;
			char* _tmp1_;
			self->priv->current_predicate_is_var = TRUE;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (old_predicate);
					return;
				} else {
					_g_free0 (old_predicate);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			self->priv->current_predicate = (_tmp3_ = g_strdup ((const char*) g_hash_table_lookup (var_value_map, _tmp2_ = string_substring (_tmp1_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1))), _g_free0 (self->priv->current_predicate), _tmp3_);
			_g_free0 (_tmp2_);
			_g_free0 (_tmp1_);
		} else {
			if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
				char* _tmp4_;
				tracker_sparql_query_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_predicate);
						return;
					} else {
						_g_free0 (old_predicate);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				self->priv->current_predicate = (_tmp4_ = tracker_sparql_query_get_last_string (self, 1), _g_free0 (self->priv->current_predicate), _tmp4_);
			} else {
				if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
					char* ns;
					char* _tmp6_;
					char* _tmp5_;
					char* _tmp7_;
					char* _tmp8_;
					char* _tmp9_;
					tracker_sparql_query_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					ns = tracker_sparql_query_get_last_string (self, 0);
					tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
					if (_inner_error_ != NULL) {
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (ns);
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp8_ = (_tmp7_ = tracker_sparql_query_resolve_prefixed_name (self, ns, _tmp6_ = string_substring (_tmp5_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp6_), _g_free0 (_tmp5_), _tmp7_);
					if (_inner_error_ != NULL) {
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (ns);
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					self->priv->current_predicate = (_tmp9_ = _tmp8_, _g_free0 (self->priv->current_predicate), _tmp9_);
					_g_free0 (ns);
				} else {
					if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
						char* _tmp11_;
						char* _tmp10_;
						char* _tmp12_;
						char* _tmp13_;
						char* _tmp14_;
						tracker_sparql_query_next (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp13_ = (_tmp12_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp11_ = string_substring (_tmp10_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp11_), _g_free0 (_tmp10_), _tmp12_);
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						self->priv->current_predicate = (_tmp14_ = _tmp13_, _g_free0 (self->priv->current_predicate), _tmp14_);
					} else {
						if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_A) {
							char* _tmp15_;
							tracker_sparql_query_next (self, &_inner_error_);
							if (_inner_error_ != NULL) {
								if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (old_predicate);
									return;
								} else {
									_g_free0 (old_predicate);
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							self->priv->current_predicate = (_tmp15_ = g_strdup ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), _g_free0 (self->priv->current_predicate), _tmp15_);
						} else {
							_inner_error_ = tracker_sparql_query_get_error (self, "expected non-empty property list");
							if (_inner_error_ != NULL) {
								if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (old_predicate);
									return;
								} else {
									_g_free0 (old_predicate);
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						}
					}
				}
			}
		}
		tracker_sparql_query_parse_construct_object_list (self, var_value_map, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_predicate);
				return;
			} else {
				_g_free0 (old_predicate);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		self->priv->current_predicate = (_tmp16_ = g_strdup (old_predicate), _g_free0 (self->priv->current_predicate), _tmp16_);
		_tmp17_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_predicate);
				return;
			} else {
				_g_free0 (old_predicate);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp17_) {
			_g_free0 (old_predicate);
			continue;
		}
		_g_free0 (old_predicate);
		break;
	}
}


static void tracker_sparql_query_parse_construct_object_list (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (var_value_map != NULL);
	_inner_error_ = NULL;
	while (TRUE) {
		gboolean _tmp0_;
		tracker_sparql_query_parse_construct_object (self, var_value_map, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp0_) {
			continue;
		}
		break;
	}
}


static void tracker_sparql_query_parse_construct_object (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	GError * _inner_error_;
	char* object;
	g_return_if_fail (self != NULL);
	g_return_if_fail (var_value_map != NULL);
	_inner_error_ = NULL;
	object = tracker_sparql_query_parse_construct_var_or_term (self, var_value_map, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (self->priv->delete_statements) {
		tracker_data_delete_statement (self->priv->current_subject, self->priv->current_predicate, object, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (object);
				return;
			} else {
				_g_free0 (object);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		tracker_data_insert_statement (self->priv->current_subject, self->priv->current_predicate, object, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (object);
				return;
			} else {
				_g_free0 (object);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_free0 (object);
}


static void tracker_sparql_query_start_triples_block (TrackerSparqlQuery* self, GString* sql, GError** error) {
	GList* _tmp0_;
	GHashTable* _tmp1_;
	GList* _tmp2_;
	GHashTable* _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	self->priv->tables = (_tmp0_ = NULL, __g_list_free_g_object_unref0 (self->priv->tables), _tmp0_);
	self->priv->table_map = (_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->priv->table_map), _tmp1_);
	self->priv->pattern_variables = (_tmp2_ = NULL, __g_list_free_g_free0 (self->priv->pattern_variables), _tmp2_);
	self->priv->pattern_var_map = (_tmp3_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->priv->pattern_var_map), _tmp3_);
	self->priv->pattern_bindings = (_tmp4_ = NULL, __g_list_free_g_object_unref0 (self->priv->pattern_bindings), _tmp4_);
	g_string_append (sql, "SELECT ");
}


static void tracker_sparql_query_end_triples_block (TrackerSparqlQuery* self, GString* sql, gboolean* first_where, gboolean in_group_graph_pattern, GError** error) {
	GError * _inner_error_;
	gboolean first;
	GList* _tmp7_;
	GHashTable* _tmp8_;
	GList* _tmp9_;
	GHashTable* _tmp10_;
	GList* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	g_string_truncate (sql, (gsize) (sql->len - 2));
	g_string_append (sql, " FROM ");
	first = TRUE;
	{
		GList* table_collection;
		GList* table_it;
		table_collection = self->priv->tables;
		for (table_it = table_collection; table_it != NULL; table_it = table_it->next) {
			TrackerSparqlQueryDataTable* table;
			table = _g_object_ref0 ((TrackerSparqlQueryDataTable*) table_it->data);
			{
				if (!first) {
					g_string_append (sql, ", ");
				} else {
					first = FALSE;
				}
				if (table->sql_db_tablename != NULL) {
					g_string_append_printf (sql, "\"%s\"", table->sql_db_tablename);
				} else {
					char* _tmp0_;
					char* _tmp1_;
					_tmp0_ = tracker_sparql_query_predicate_variable_get_sql_query (table->predicate_variable, self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (table);
							return;
						} else {
							_g_object_unref0 (table);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					g_string_append_printf (sql, "(%s)", _tmp1_ = _tmp0_);
					_g_free0 (_tmp1_);
				}
				g_string_append_printf (sql, " AS \"%s\"", table->sql_query_tablename);
				_g_object_unref0 (table);
			}
		}
	}
	{
		GList* variable_collection;
		GList* variable_it;
		variable_collection = self->priv->pattern_variables;
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
			char* variable;
			variable = g_strdup ((const char*) variable_it->data);
			{
				gboolean maybe_null;
				gboolean in_simple_optional;
				char* last_name;
				gboolean _tmp3_;
				maybe_null = TRUE;
				in_simple_optional = FALSE;
				last_name = NULL;
				{
					GList* binding_collection;
					GList* binding_it;
					binding_collection = ((TrackerSparqlQueryVariableBindingList*) g_hash_table_lookup (self->priv->pattern_var_map, variable))->list;
					for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
						TrackerSparqlQueryVariableBinding* binding;
						binding = _g_object_ref0 ((TrackerSparqlQueryVariableBinding*) binding_it->data);
						{
							char* name;
							char* _tmp2_;
							name = g_strdup_printf ("\"%s\".\"%s\"", ((TrackerSparqlQueryDataBinding*) binding)->table->sql_query_tablename, ((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name);
							if (last_name != NULL) {
								if (!(*first_where)) {
									g_string_append (sql, " AND ");
								} else {
									g_string_append (sql, " WHERE ");
									(*first_where) = FALSE;
								}
								g_string_append (sql, last_name);
								g_string_append (sql, " = ");
								g_string_append (sql, name);
							}
							last_name = (_tmp2_ = g_strdup (name), _g_free0 (last_name), _tmp2_);
							if (!binding->maybe_null) {
								maybe_null = FALSE;
							}
							in_simple_optional = binding->in_simple_optional;
							_g_object_unref0 (binding);
							_g_free0 (name);
						}
					}
				}
				_tmp3_ = FALSE;
				if (maybe_null) {
					_tmp3_ = !in_simple_optional;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					if (!(*first_where)) {
						g_string_append (sql, " AND ");
					} else {
						g_string_append (sql, " WHERE ");
						(*first_where) = FALSE;
					}
					g_string_append_printf (sql, "\"%s_u\" IS NOT NULL", variable);
				}
				_g_free0 (variable);
				_g_free0 (last_name);
			}
		}
	}
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = self->priv->pattern_bindings;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			TrackerSparqlQueryLiteralBinding* binding;
			binding = _g_object_ref0 ((TrackerSparqlQueryLiteralBinding*) binding_it->data);
			{
				if (!(*first_where)) {
					g_string_append (sql, " AND ");
				} else {
					g_string_append (sql, " WHERE ");
					(*first_where) = FALSE;
				}
				g_string_append (sql, "\"");
				g_string_append (sql, ((TrackerSparqlQueryDataBinding*) binding)->table->sql_query_tablename);
				g_string_append (sql, "\".\"");
				g_string_append (sql, ((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name);
				g_string_append (sql, "\"");
				if (binding->is_fts_match) {
					gint _tmp5__length1;
					char** _tmp5_;
					char** _tmp4_;
					char* _tmp6_;
					char* escaped_literal;
					escaped_literal = (_tmp6_ = g_strjoinv ("''", (_tmp5_ = _tmp4_ = g_strsplit (binding->literal, "'", 0), _tmp5__length1 = _vala_array_length (_tmp4_), _tmp5_)), _tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL), _tmp6_);
					g_string_append_printf (sql, " IN (SELECT rowid FROM fts WHERE fts MATCH '%s')", escaped_literal);
					_g_free0 (escaped_literal);
				} else {
					g_string_append (sql, " = ");
					if (((TrackerSparqlQueryDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_RESOURCE) {
						g_string_append (sql, "(SELECT ID FROM \"rdfs:Resource\" WHERE Uri = ?)");
					} else {
						g_string_append (sql, "?");
					}
					self->priv->bindings = g_list_append (self->priv->bindings, _g_object_ref0 (binding));
				}
				_g_object_unref0 (binding);
			}
		}
	}
	if (in_group_graph_pattern) {
		g_string_append (sql, ")");
	}
	self->priv->tables = (_tmp7_ = NULL, __g_list_free_g_object_unref0 (self->priv->tables), _tmp7_);
	self->priv->table_map = (_tmp8_ = NULL, _g_hash_table_unref0 (self->priv->table_map), _tmp8_);
	self->priv->pattern_variables = (_tmp9_ = NULL, __g_list_free_g_free0 (self->priv->pattern_variables), _tmp9_);
	self->priv->pattern_var_map = (_tmp10_ = NULL, _g_hash_table_unref0 (self->priv->pattern_var_map), _tmp10_);
	self->priv->pattern_bindings = (_tmp11_ = NULL, __g_list_free_g_object_unref0 (self->priv->pattern_bindings), _tmp11_);
}


static void tracker_sparql_query_parse_triples (TrackerSparqlQuery* self, GString* sql, glong group_graph_pattern_start, gboolean* in_triples_block, gboolean* first_where, gboolean* in_group_graph_pattern, gboolean found_simple_optional, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	while (TRUE) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		char* _tmp6_;
		char* _tmp7_;
		gboolean _tmp8_;
		_tmp0_ = FALSE;
		_tmp1_ = FALSE;
		_tmp2_ = FALSE;
		_tmp3_ = FALSE;
		if (tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_VAR) {
			_tmp3_ = tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_IRI_REF;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_COLON;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			break;
		}
		_tmp4_ = FALSE;
		_tmp5_ = FALSE;
		if ((*in_triples_block)) {
			_tmp5_ = !(*in_group_graph_pattern);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			_tmp4_ = found_simple_optional;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			tracker_sparql_query_end_triples_block (self, sql, &(*first_where), (*in_group_graph_pattern), &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			(*in_triples_block) = FALSE;
		}
		if (!(*in_triples_block)) {
			if ((*in_group_graph_pattern)) {
				g_string_insert (sql, group_graph_pattern_start, "SELECT * FROM (");
				g_string_append (sql, ") NATURAL INNER JOIN (");
			}
			(*in_triples_block) = TRUE;
			(*first_where) = TRUE;
			tracker_sparql_query_start_triples_block (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		_tmp6_ = tracker_sparql_query_parse_var_or_term (self, sql, &self->priv->current_subject_is_var, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		self->priv->current_subject = (_tmp7_ = _tmp6_, _g_free0 (self->priv->current_subject), _tmp7_);
		tracker_sparql_query_parse_property_list_not_empty (self, sql, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp8_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (!_tmp8_) {
			break;
		}
	}
}


static gboolean tracker_sparql_query_is_simple_optional (TrackerSparqlQuery* self) {
	gboolean result;
	GError * _inner_error_;
	TrackerSourceLocation _tmp0_ = {0};
	TrackerSourceLocation optional_start;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	optional_start = (tracker_sparql_query_get_location (self, &_tmp0_), _tmp0_);
	{
		gboolean _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		char* var_name;
		char* predicate;
		gboolean _tmp4_;
		TrackerProperty* prop;
		gboolean _tmp18_;
		char* _tmp20_;
		char* _tmp19_;
		gboolean _tmp21_;
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch2_tracker_sparql_error;
			}
			goto __finally2;
		}
		_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch2_tracker_sparql_error;
			}
			goto __finally2;
		}
		if (!_tmp1_) {
			result = FALSE;
			{
				tracker_sparql_query_set_location (self, &optional_start);
			}
			return result;
		}
		var_name = (_tmp3_ = string_substring (_tmp2_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), _g_free0 (_tmp2_), _tmp3_);
		if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->subgraph_var_set, var_name)) != TRACKER_SPARQL_QUERY_VARIABLE_STATE_BOUND) {
			result = FALSE;
			{
				tracker_sparql_query_set_location (self, &optional_start);
			}
			_g_free0 (var_name);
			return result;
		}
		predicate = NULL;
		_tmp4_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (var_name);
			_g_free0 (predicate);
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch2_tracker_sparql_error;
			}
			goto __finally2;
		}
		if (_tmp4_) {
			char* _tmp5_;
			predicate = (_tmp5_ = tracker_sparql_query_get_last_string (self, 1), _g_free0 (predicate), _tmp5_);
		} else {
			gboolean _tmp6_;
			_tmp6_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (var_name);
				_g_free0 (predicate);
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					goto __catch2_tracker_sparql_error;
				}
				goto __finally2;
			}
			if (_tmp6_) {
				char* ns;
				char* _tmp8_;
				char* _tmp7_;
				char* _tmp9_;
				char* _tmp10_;
				char* _tmp11_;
				ns = tracker_sparql_query_get_last_string (self, 0);
				tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (ns);
					_g_free0 (var_name);
					_g_free0 (predicate);
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						goto __catch2_tracker_sparql_error;
					}
					goto __finally2;
				}
				_tmp10_ = (_tmp9_ = tracker_sparql_query_resolve_prefixed_name (self, ns, _tmp8_ = string_substring (_tmp7_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp8_), _g_free0 (_tmp7_), _tmp9_);
				if (_inner_error_ != NULL) {
					_g_free0 (ns);
					_g_free0 (var_name);
					_g_free0 (predicate);
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						goto __catch2_tracker_sparql_error;
					}
					goto __finally2;
				}
				predicate = (_tmp11_ = _tmp10_, _g_free0 (predicate), _tmp11_);
				_g_free0 (ns);
			} else {
				gboolean _tmp12_;
				_tmp12_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (var_name);
					_g_free0 (predicate);
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						goto __catch2_tracker_sparql_error;
					}
					goto __finally2;
				}
				if (_tmp12_) {
					char* _tmp14_;
					char* _tmp13_;
					char* _tmp15_;
					char* _tmp16_;
					char* _tmp17_;
					_tmp16_ = (_tmp15_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp14_ = string_substring (_tmp13_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp14_), _g_free0 (_tmp13_), _tmp15_);
					if (_inner_error_ != NULL) {
						_g_free0 (var_name);
						_g_free0 (predicate);
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							goto __catch2_tracker_sparql_error;
						}
						goto __finally2;
					}
					predicate = (_tmp17_ = _tmp16_, _g_free0 (predicate), _tmp17_);
				} else {
					result = FALSE;
					{
						tracker_sparql_query_set_location (self, &optional_start);
					}
					_g_free0 (var_name);
					_g_free0 (predicate);
					return result;
				}
			}
		}
		prop = _g_object_ref0 (tracker_ontology_get_property_by_uri (predicate));
		if (prop == NULL) {
			result = FALSE;
			{
				tracker_sparql_query_set_location (self, &optional_start);
			}
			_g_free0 (var_name);
			_g_free0 (predicate);
			_g_object_unref0 (prop);
			return result;
		}
		if (tracker_property_get_multiple_values (prop)) {
			result = FALSE;
			{
				tracker_sparql_query_set_location (self, &optional_start);
			}
			_g_free0 (var_name);
			_g_free0 (predicate);
			_g_object_unref0 (prop);
			return result;
		}
		_tmp18_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (var_name);
			_g_free0 (predicate);
			_g_object_unref0 (prop);
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch2_tracker_sparql_error;
			}
			goto __finally2;
		}
		if (!_tmp18_) {
			result = FALSE;
			{
				tracker_sparql_query_set_location (self, &optional_start);
			}
			_g_free0 (var_name);
			_g_free0 (predicate);
			_g_object_unref0 (prop);
			return result;
		}
		var_name = (_tmp20_ = string_substring (_tmp19_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), _g_free0 (var_name), _tmp20_);
		_g_free0 (_tmp19_);
		if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->subgraph_var_set, var_name)) != 0) {
			result = FALSE;
			{
				tracker_sparql_query_set_location (self, &optional_start);
			}
			_g_free0 (var_name);
			_g_free0 (predicate);
			_g_object_unref0 (prop);
			return result;
		}
		_tmp21_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (var_name);
			_g_free0 (predicate);
			_g_object_unref0 (prop);
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch2_tracker_sparql_error;
			}
			goto __finally2;
		}
		if (!_tmp21_) {
			result = FALSE;
			{
				tracker_sparql_query_set_location (self, &optional_start);
			}
			_g_free0 (var_name);
			_g_free0 (predicate);
			_g_object_unref0 (prop);
			return result;
		}
		result = TRUE;
		{
			tracker_sparql_query_set_location (self, &optional_start);
		}
		_g_free0 (var_name);
		_g_free0 (predicate);
		_g_object_unref0 (prop);
		return result;
	}
	goto __finally2;
	__catch2_tracker_sparql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			result = FALSE;
			{
				tracker_sparql_query_set_location (self, &optional_start);
			}
			_g_error_free0 (e);
			return result;
		}
	}
	__finally2:
	{
		tracker_sparql_query_set_location (self, &optional_start);
	}
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void _vala_array_add1 (TrackerSourceLocation** array, int* length, int* size, const TrackerSourceLocation* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSourceLocation, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void tracker_sparql_query_translate_group_graph_pattern (TrackerSparqlQuery* self, GString* sql, GError** error) {
	GError * _inner_error_;
	TrackerSourceLocation* _tmp1_;
	gint filters_size;
	gint filters_length1;
	TrackerSourceLocation* _tmp0_;
	TrackerSourceLocation* filters;
	gboolean in_triples_block;
	gboolean in_group_graph_pattern;
	gboolean first_where;
	gboolean found_simple_optional;
	glong group_graph_pattern_start;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = NULL;
	filters = (_tmp1_ = (_tmp0_ = g_new0 (TrackerSourceLocation, 0), _tmp0_), filters_length1 = 0, filters_size = filters_length1, _tmp1_);
	in_triples_block = FALSE;
	in_group_graph_pattern = FALSE;
	first_where = TRUE;
	found_simple_optional = FALSE;
	group_graph_pattern_start = sql->len;
	tracker_sparql_query_parse_triples (self, sql, group_graph_pattern_start, &in_triples_block, &first_where, &in_group_graph_pattern, found_simple_optional, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			filters = (g_free (filters), NULL);
			return;
		} else {
			filters = (g_free (filters), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		gboolean _tmp2_;
		_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				filters = (g_free (filters), NULL);
				return;
			} else {
				filters = (g_free (filters), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp2_) {
			gboolean _tmp3_;
			_tmp3_ = FALSE;
			if (!in_group_graph_pattern) {
				_tmp3_ = tracker_sparql_query_is_simple_optional (self);
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				char* _tmp4_;
				char* _tmp5_;
				found_simple_optional = TRUE;
				tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						return;
					} else {
						filters = (g_free (filters), NULL);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp4_ = tracker_sparql_query_parse_var_or_term (self, sql, &self->priv->current_subject_is_var, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						return;
					} else {
						filters = (g_free (filters), NULL);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				self->priv->current_subject = (_tmp5_ = _tmp4_, _g_free0 (self->priv->current_subject), _tmp5_);
				tracker_sparql_query_parse_property_list_not_empty (self, sql, TRUE, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						return;
					} else {
						filters = (g_free (filters), NULL);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						return;
					} else {
						filters = (g_free (filters), NULL);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			} else {
				gboolean _tmp6_;
				GString* select;
				gint left_index;
				gint right_index;
				GHashTable* old_subgraph_var_set;
				GHashTable* _tmp7_;
				gboolean first;
				gboolean first_common;
				GHashTable* _tmp8_;
				_tmp6_ = FALSE;
				if (!in_triples_block) {
					_tmp6_ = !in_group_graph_pattern;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					g_string_append (sql, "SELECT 1");
				} else {
					if (in_triples_block) {
						tracker_sparql_query_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								filters = (g_free (filters), NULL);
								return;
							} else {
								filters = (g_free (filters), NULL);
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						in_triples_block = FALSE;
					}
				}
				if (!in_group_graph_pattern) {
					in_group_graph_pattern = TRUE;
				}
				select = g_string_new ("SELECT ");
				left_index = self->priv->next_table_index = self->priv->next_table_index + 1;
				right_index = self->priv->next_table_index = self->priv->next_table_index + 1;
				g_string_append_printf (sql, ") AS t%d_g LEFT JOIN (", left_index);
				old_subgraph_var_set = _g_hash_table_ref0 (self->priv->subgraph_var_set);
				self->priv->subgraph_var_set = (_tmp7_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL), _g_hash_table_unref0 (self->priv->subgraph_var_set), _tmp7_);
				tracker_sparql_query_translate_group_graph_pattern (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_string_free0 (select);
						_g_hash_table_unref0 (old_subgraph_var_set);
						filters = (g_free (filters), NULL);
						return;
					} else {
						_g_string_free0 (select);
						_g_hash_table_unref0 (old_subgraph_var_set);
						filters = (g_free (filters), NULL);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				g_string_append_printf (sql, ") AS t%d_g", right_index);
				first = TRUE;
				first_common = TRUE;
				{
					GList* v_collection;
					GList* v_it;
					v_collection = g_hash_table_get_keys (self->priv->subgraph_var_set);
					for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
						char* v;
						v = g_strdup ((const char*) v_it->data);
						{
							gint old_state;
							if (first) {
								first = FALSE;
							} else {
								g_string_append (select, ", ");
							}
							old_state = GPOINTER_TO_INT (g_hash_table_lookup (old_subgraph_var_set, v));
							if (old_state == 0) {
								g_hash_table_insert (old_subgraph_var_set, g_strdup (v), GINT_TO_POINTER ((gint) TRACKER_SPARQL_QUERY_VARIABLE_STATE_OPTIONAL));
								g_string_append_printf (select, "t%d_g.\"%s_u\"", right_index, v);
							} else {
								if (first_common) {
									g_string_append (sql, " ON ");
									first_common = FALSE;
								} else {
									g_string_append (sql, " AND ");
								}
								if (old_state == TRACKER_SPARQL_QUERY_VARIABLE_STATE_BOUND) {
									g_string_append_printf (sql, "t%d_g.\"%s_u\" = t%d_g.\"%s_u\"", left_index, v, right_index, v);
									g_string_append_printf (select, "t%d_g.\"%s_u\"", left_index, v);
								} else {
									if (old_state == TRACKER_SPARQL_QUERY_VARIABLE_STATE_OPTIONAL) {
										g_string_append_printf (sql, "(t%d_g.\"%s_u\" IS NULL OR t%d_g.\"%s_u\" = t%d_g.\"%s_u\")", left_index, v, left_index, v, right_index, v);
										g_string_append_printf (select, "COALESCE (t%d_g.\"%s_u\", t%d_g.\"%s_u\") AS \"%s_u\"", left_index, v, right_index, v, v);
									}
								}
							}
							_g_free0 (v);
						}
					}
					_g_list_free0 (v_collection);
				}
				{
					GList* v_collection;
					GList* v_it;
					v_collection = g_hash_table_get_keys (old_subgraph_var_set);
					for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
						char* v;
						v = g_strdup ((const char*) v_it->data);
						{
							if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->subgraph_var_set, v)) == 0) {
								if (first) {
									first = FALSE;
								} else {
									g_string_append (select, ", ");
								}
								g_string_append_printf (select, "t%d_g.\"%s_u\"", left_index, v);
							}
							_g_free0 (v);
						}
					}
					_g_list_free0 (v_collection);
				}
				if (first) {
					g_string_append (select, "1");
				}
				self->priv->subgraph_var_set = (_tmp8_ = _g_hash_table_ref0 (old_subgraph_var_set), _g_hash_table_unref0 (self->priv->subgraph_var_set), _tmp8_);
				g_string_append (select, " FROM (");
				g_string_insert (sql, group_graph_pattern_start, select->str);
				_g_string_free0 (select);
				_g_hash_table_unref0 (old_subgraph_var_set);
			}
		} else {
			if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE) {
				gboolean _tmp9_;
				_tmp9_ = FALSE;
				if (!in_triples_block) {
					_tmp9_ = !in_group_graph_pattern;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					in_group_graph_pattern = TRUE;
					tracker_sparql_query_translate_group_or_union_graph_pattern (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							filters = (g_free (filters), NULL);
							return;
						} else {
							filters = (g_free (filters), NULL);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				} else {
					if (in_triples_block) {
						tracker_sparql_query_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								filters = (g_free (filters), NULL);
								return;
							} else {
								filters = (g_free (filters), NULL);
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						in_triples_block = FALSE;
					}
					if (!in_group_graph_pattern) {
						in_group_graph_pattern = TRUE;
					}
					g_string_insert (sql, group_graph_pattern_start, "SELECT * FROM (");
					g_string_append (sql, ") NATURAL INNER JOIN (");
					tracker_sparql_query_translate_group_or_union_graph_pattern (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							filters = (g_free (filters), NULL);
							return;
						} else {
							filters = (g_free (filters), NULL);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					g_string_append (sql, ")");
				}
			} else {
				if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_FILTER) {
					TrackerSourceLocation _tmp11_;
					TrackerSourceLocation _tmp10_ = {0};
					_vala_array_add1 (&filters, &filters_length1, &filters_size, (_tmp11_ = (tracker_sparql_query_get_location (self, &_tmp10_), _tmp10_), &_tmp11_));
					tracker_sparql_query_skip_filter (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							filters = (g_free (filters), NULL);
							return;
						} else {
							filters = (g_free (filters), NULL);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				} else {
					break;
				}
			}
		}
		tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				filters = (g_free (filters), NULL);
				return;
			} else {
				filters = (g_free (filters), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		tracker_sparql_query_parse_triples (self, sql, group_graph_pattern_start, &in_triples_block, &first_where, &in_group_graph_pattern, found_simple_optional, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				filters = (g_free (filters), NULL);
				return;
			} else {
				filters = (g_free (filters), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			filters = (g_free (filters), NULL);
			return;
		} else {
			filters = (g_free (filters), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp12_ = FALSE;
	if (!in_triples_block) {
		_tmp12_ = !in_group_graph_pattern;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		g_string_append (sql, "SELECT 1");
	} else {
		if (in_triples_block) {
			tracker_sparql_query_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					filters = (g_free (filters), NULL);
					return;
				} else {
					filters = (g_free (filters), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			in_triples_block = FALSE;
		}
	}
	if (in_group_graph_pattern) {
		first_where = TRUE;
	}
	if (filters_length1 > 0) {
		TrackerSourceLocation _tmp13_ = {0};
		TrackerSourceLocation end;
		end = (tracker_sparql_query_get_location (self, &_tmp13_), _tmp13_);
		{
			TrackerSourceLocation* filter_location_collection;
			int filter_location_collection_length1;
			int filter_location_it;
			filter_location_collection = filters;
			filter_location_collection_length1 = filters_length1;
			for (filter_location_it = 0; filter_location_it < filters_length1; filter_location_it = filter_location_it + 1) {
				TrackerSourceLocation filter_location;
				filter_location = filter_location_collection[filter_location_it];
				{
					if (!first_where) {
						g_string_append (sql, " AND ");
					} else {
						g_string_append (sql, " WHERE ");
						first_where = FALSE;
					}
					tracker_sparql_query_set_location (self, &filter_location);
					tracker_sparql_query_translate_filter (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							filters = (g_free (filters), NULL);
							return;
						} else {
							filters = (g_free (filters), NULL);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
			}
		}
		tracker_sparql_query_set_location (self, &end);
	}
	filters = (g_free (filters), NULL);
}


static void _vala_array_add2 (GHashTable*** array, int* length, int* size, GHashTable* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GHashTable*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (glong** array, int* length, int* size, glong value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (glong, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add4 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void tracker_sparql_query_translate_group_or_union_graph_pattern (TrackerSparqlQuery* self, GString* sql, GError** error) {
	GError * _inner_error_;
	GHashTable* old_subgraph_var_set;
	char** _tmp1_;
	gint all_vars_size;
	gint all_vars_length1;
	char** _tmp0_;
	char** all_vars;
	GHashTable* all_var_set;
	GHashTable** _tmp3_;
	gint var_sets_size;
	gint var_sets_length1;
	GHashTable** _tmp2_;
	GHashTable** var_sets;
	glong* _tmp5_;
	gint offsets_size;
	gint offsets_length1;
	glong* _tmp4_;
	glong* offsets;
	GHashTable* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	old_subgraph_var_set = _g_hash_table_ref0 (self->priv->subgraph_var_set);
	_tmp0_ = NULL;
	all_vars = (_tmp1_ = (_tmp0_ = g_new0 (char*, 0 + 1), _tmp0_), all_vars_length1 = 0, all_vars_size = all_vars_length1, _tmp1_);
	all_var_set = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	_tmp2_ = NULL;
	var_sets = (_tmp3_ = (_tmp2_ = g_new0 (GHashTable*, 0 + 1), _tmp2_), var_sets_length1 = 0, var_sets_size = var_sets_length1, _tmp3_);
	_tmp4_ = NULL;
	offsets = (_tmp5_ = (_tmp4_ = g_new0 (glong, 0), _tmp4_), offsets_length1 = 0, offsets_size = offsets_length1, _tmp5_);
	{
		gboolean _tmp6_;
		_tmp6_ = TRUE;
		while (TRUE) {
			GHashTable* _tmp8_;
			if (!_tmp6_) {
				gboolean _tmp7_;
				_tmp7_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_UNION, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_hash_table_unref0 (old_subgraph_var_set);
						all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_free), NULL);
						_g_hash_table_unref0 (all_var_set);
						var_sets = (_vala_array_free (var_sets, var_sets_length1, (GDestroyNotify) g_hash_table_unref), NULL);
						offsets = (g_free (offsets), NULL);
						return;
					} else {
						_g_hash_table_unref0 (old_subgraph_var_set);
						all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_free), NULL);
						_g_hash_table_unref0 (all_var_set);
						var_sets = (_vala_array_free (var_sets, var_sets_length1, (GDestroyNotify) g_hash_table_unref), NULL);
						offsets = (g_free (offsets), NULL);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				if (!_tmp7_) {
					break;
				}
			}
			_tmp6_ = FALSE;
			self->priv->subgraph_var_set = (_tmp8_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL), _g_hash_table_unref0 (self->priv->subgraph_var_set), _tmp8_);
			_vala_array_add2 (&var_sets, &var_sets_length1, &var_sets_size, _g_hash_table_ref0 (self->priv->subgraph_var_set));
			_vala_array_add3 (&offsets, &offsets_length1, &offsets_size, sql->len);
			tracker_sparql_query_translate_group_graph_pattern (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_hash_table_unref0 (old_subgraph_var_set);
					all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_free), NULL);
					_g_hash_table_unref0 (all_var_set);
					var_sets = (_vala_array_free (var_sets, var_sets_length1, (GDestroyNotify) g_hash_table_unref), NULL);
					offsets = (g_free (offsets), NULL);
					return;
				} else {
					_g_hash_table_unref0 (old_subgraph_var_set);
					all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_free), NULL);
					_g_hash_table_unref0 (all_var_set);
					var_sets = (_vala_array_free (var_sets, var_sets_length1, (GDestroyNotify) g_hash_table_unref), NULL);
					offsets = (g_free (offsets), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	if (var_sets_length1 > 1) {
		glong extra_offset;
		{
			GHashTable** var_set_collection;
			int var_set_collection_length1;
			int var_set_it;
			var_set_collection = var_sets;
			var_set_collection_length1 = var_sets_length1;
			for (var_set_it = 0; var_set_it < var_sets_length1; var_set_it = var_set_it + 1) {
				GHashTable* var_set;
				var_set = _g_hash_table_ref0 (var_set_collection[var_set_it]);
				{
					{
						GList* v_collection;
						GList* v_it;
						v_collection = g_hash_table_get_keys (var_set);
						for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
							char* v;
							v = g_strdup ((const char*) v_it->data);
							{
								if (GPOINTER_TO_INT (g_hash_table_lookup (all_var_set, v)) == 0) {
									_vala_array_add4 (&all_vars, &all_vars_length1, &all_vars_size, g_strdup (v));
									g_hash_table_insert (all_var_set, g_strdup (v), GINT_TO_POINTER ((gint) TRACKER_SPARQL_QUERY_VARIABLE_STATE_BOUND));
									g_hash_table_insert (old_subgraph_var_set, g_strdup (v), GINT_TO_POINTER ((gint) TRACKER_SPARQL_QUERY_VARIABLE_STATE_BOUND));
								}
								_g_free0 (v);
							}
						}
						_g_list_free0 (v_collection);
					}
					_g_hash_table_unref0 (var_set);
				}
			}
		}
		extra_offset = (glong) 0;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp9_;
				_tmp9_ = TRUE;
				while (TRUE) {
					GString* projection;
					if (!_tmp9_) {
						i++;
					}
					_tmp9_ = FALSE;
					if (!(i < var_sets_length1)) {
						break;
					}
					projection = g_string_new ("");
					if (i > 0) {
						g_string_append (projection, ") UNION ALL ");
					}
					g_string_append (projection, "SELECT ");
					{
						char** v_collection;
						int v_collection_length1;
						int v_it;
						v_collection = all_vars;
						v_collection_length1 = all_vars_length1;
						for (v_it = 0; v_it < all_vars_length1; v_it = v_it + 1) {
							char* v;
							v = g_strdup (v_collection[v_it]);
							{
								if (GPOINTER_TO_INT (g_hash_table_lookup (var_sets[i], v)) == 0) {
									g_string_append (projection, "NULL AS ");
								}
								g_string_append_printf (projection, "\"%s_u\", ", v);
								_g_free0 (v);
							}
						}
					}
					g_string_truncate (projection, (gsize) (projection->len - 2));
					g_string_append (projection, " FROM (");
					g_string_insert (sql, offsets[i] + extra_offset, projection->str);
					extra_offset = extra_offset + projection->len;
					_g_string_free0 (projection);
				}
			}
		}
		g_string_append (sql, ")");
	} else {
		{
			GList* key_collection;
			GList* key_it;
			key_collection = g_hash_table_get_keys (self->priv->subgraph_var_set);
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
				char* key;
				key = g_strdup ((const char*) key_it->data);
				{
					g_hash_table_insert (old_subgraph_var_set, g_strdup (key), GINT_TO_POINTER ((gint) TRACKER_SPARQL_QUERY_VARIABLE_STATE_BOUND));
					_g_free0 (key);
				}
			}
			_g_list_free0 (key_collection);
		}
	}
	self->priv->subgraph_var_set = (_tmp10_ = _g_hash_table_ref0 (old_subgraph_var_set), _g_hash_table_unref0 (self->priv->subgraph_var_set), _tmp10_);
	_g_hash_table_unref0 (old_subgraph_var_set);
	all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (all_var_set);
	var_sets = (_vala_array_free (var_sets, var_sets_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	offsets = (g_free (offsets), NULL);
}


static void tracker_sparql_query_parse_object (TrackerSparqlQuery* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_;
	gboolean object_is_var;
	char* object;
	char* db_table;
	gboolean rdftype;
	gboolean share_table;
	gboolean newtable;
	TrackerSparqlQueryDataTable* table;
	TrackerProperty* prop;
	gboolean _tmp49_;
	gboolean _tmp50_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	object_is_var = FALSE;
	object = tracker_sparql_query_parse_var_or_term (self, sql, &object_is_var, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	db_table = NULL;
	rdftype = FALSE;
	share_table = TRUE;
	newtable = FALSE;
	table = NULL;
	prop = NULL;
	if (!self->priv->current_predicate_is_var) {
		TrackerProperty* _tmp0_;
		gboolean _tmp1_;
		TrackerSparqlQueryDataTable* _tmp16_;
		prop = (_tmp0_ = _g_object_ref0 (tracker_ontology_get_property_by_uri (self->priv->current_predicate)), _g_object_unref0 (prop), _tmp0_);
		_tmp1_ = FALSE;
		if (_vala_strcmp0 (self->priv->current_predicate, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type") == 0) {
			_tmp1_ = !object_is_var;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			TrackerClass* cl;
			char* _tmp4_;
			rdftype = TRUE;
			cl = _g_object_ref0 (tracker_ontology_get_class_by_uri (object));
			if (cl == NULL) {
				char* _tmp2_;
				GError* _tmp3_;
				_inner_error_ = (_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, _tmp2_ = g_strdup_printf ("Unknown class `%s'", object)), _g_free0 (_tmp2_), _tmp3_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (cl);
						_g_free0 (object);
						_g_free0 (db_table);
						_g_object_unref0 (table);
						_g_object_unref0 (prop);
						return;
					} else {
						_g_object_unref0 (cl);
						_g_free0 (object);
						_g_free0 (db_table);
						_g_object_unref0 (table);
						_g_object_unref0 (prop);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			db_table = (_tmp4_ = g_strdup (tracker_class_get_name (cl)), _g_free0 (db_table), _tmp4_);
			_g_object_unref0 (cl);
		} else {
			if (prop == NULL) {
				if (_vala_strcmp0 (self->priv->current_predicate, "http://www.tracker-project.org/ontologies/fts#match") == 0) {
					char* _tmp5_;
					db_table = (_tmp5_ = g_strdup ("rdfs:Resource"), _g_free0 (db_table), _tmp5_);
				} else {
					char* _tmp6_;
					GError* _tmp7_;
					_inner_error_ = (_tmp7_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY, _tmp6_ = g_strdup_printf ("Unknown property `%s'", self->priv->current_predicate)), _g_free0 (_tmp6_), _tmp7_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (object);
							_g_free0 (db_table);
							_g_object_unref0 (table);
							_g_object_unref0 (prop);
							return;
						} else {
							_g_free0 (object);
							_g_free0 (db_table);
							_g_object_unref0 (table);
							_g_object_unref0 (prop);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
			} else {
				gboolean _tmp8_;
				gboolean _tmp9_;
				_tmp8_ = FALSE;
				_tmp9_ = FALSE;
				if (_vala_strcmp0 (self->priv->current_predicate, "http://www.w3.org/2000/01/rdf-schema#domain") == 0) {
					_tmp9_ = self->priv->current_subject_is_var;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					_tmp8_ = !object_is_var;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					TrackerClass* domain;
					TrackerSparqlQueryPredicateVariable* pv;
					TrackerClass* _tmp13_;
					domain = _g_object_ref0 (tracker_ontology_get_class_by_uri (object));
					if (domain == NULL) {
						char* _tmp10_;
						GError* _tmp11_;
						_inner_error_ = (_tmp11_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, _tmp10_ = g_strdup_printf ("Unknown class `%s'", object)), _g_free0 (_tmp10_), _tmp11_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (domain);
								_g_free0 (object);
								_g_free0 (db_table);
								_g_object_unref0 (table);
								_g_object_unref0 (prop);
								return;
							} else {
								_g_object_unref0 (domain);
								_g_free0 (object);
								_g_free0 (db_table);
								_g_object_unref0 (table);
								_g_object_unref0 (prop);
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
					pv = _g_object_ref0 ((TrackerSparqlQueryPredicateVariable*) g_hash_table_lookup (self->priv->predicate_variable_map, self->priv->current_subject));
					if (pv == NULL) {
						TrackerSparqlQueryPredicateVariable* _tmp12_;
						pv = (_tmp12_ = tracker_sparql_query_predicate_variable_new (), _g_object_unref0 (pv), _tmp12_);
						g_hash_table_insert (self->priv->predicate_variable_map, g_strdup (self->priv->current_subject), _g_object_ref0 (pv));
					}
					pv->domain = (_tmp13_ = _g_object_ref0 (domain), _g_object_unref0 (pv->domain), _tmp13_);
					_g_object_unref0 (domain);
					_g_object_unref0 (pv);
				}
				if (tracker_property_get_multiple_values (prop)) {
					char* _tmp14_;
					db_table = (_tmp14_ = g_strdup_printf ("%s_%s", tracker_class_get_name (tracker_property_get_domain (prop)), tracker_property_get_name (prop)), _g_free0 (db_table), _tmp14_);
					share_table = FALSE;
				} else {
					char* _tmp15_;
					db_table = (_tmp15_ = g_strdup (tracker_class_get_name (tracker_property_get_domain (prop))), _g_free0 (db_table), _tmp15_);
				}
			}
		}
		table = (_tmp16_ = tracker_sparql_query_get_table (self, self->priv->current_subject, db_table, share_table, &newtable), _g_object_unref0 (table), _tmp16_);
	} else {
		TrackerSparqlQueryDataTable* _tmp17_;
		TrackerSparqlQueryPredicateVariable* _tmp18_;
		char* _tmp23_;
		char* _tmp22_;
		TrackerSparqlQueryVariableBinding* binding;
		char* _tmp24_;
		TrackerSparqlQueryDataTable* _tmp25_;
		char* _tmp26_;
		TrackerSparqlQueryVariableBindingList* binding_list;
		newtable = TRUE;
		table = (_tmp17_ = tracker_sparql_query_data_table_new (), _g_object_unref0 (table), _tmp17_);
		table->predicate_variable = (_tmp18_ = _g_object_ref0 ((TrackerSparqlQueryPredicateVariable*) g_hash_table_lookup (self->priv->predicate_variable_map, self->priv->current_predicate)), _g_object_unref0 (table->predicate_variable), _tmp18_);
		if (table->predicate_variable == NULL) {
			TrackerSparqlQueryPredicateVariable* _tmp19_;
			table->predicate_variable = (_tmp19_ = tracker_sparql_query_predicate_variable_new (), _g_object_unref0 (table->predicate_variable), _tmp19_);
			g_hash_table_insert (self->priv->predicate_variable_map, g_strdup (self->priv->current_predicate), _g_object_ref0 (table->predicate_variable));
		}
		if (!self->priv->current_subject_is_var) {
			char* _tmp20_;
			table->predicate_variable->subject = (_tmp20_ = g_strdup (self->priv->current_subject), _g_free0 (table->predicate_variable->subject), _tmp20_);
		}
		if (!self->priv->current_subject_is_var) {
			char* _tmp21_;
			table->predicate_variable->object = (_tmp21_ = g_strdup (object), _g_free0 (table->predicate_variable->object), _tmp21_);
		}
		table->sql_query_tablename = (_tmp23_ = g_strconcat (self->priv->current_predicate, _tmp22_ = g_strdup_printf ("%i", self->priv->counter = self->priv->counter + 1), NULL), _g_free0 (table->sql_query_tablename), _tmp23_);
		_g_free0 (_tmp22_);
		self->priv->tables = g_list_append (self->priv->tables, _g_object_ref0 (table));
		binding = tracker_sparql_query_variable_binding_new ();
		((TrackerSparqlQueryDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
		binding->variable = (_tmp24_ = g_strdup (self->priv->current_predicate), _g_free0 (binding->variable), _tmp24_);
		((TrackerSparqlQueryDataBinding*) binding)->table = (_tmp25_ = _g_object_ref0 (table), _g_object_unref0 (((TrackerSparqlQueryDataBinding*) binding)->table), _tmp25_);
		((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name = (_tmp26_ = g_strdup ("predicate"), _g_free0 (((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name), _tmp26_);
		binding_list = _g_object_ref0 ((TrackerSparqlQueryVariableBindingList*) g_hash_table_lookup (self->priv->pattern_var_map, binding->variable));
		if (binding_list == NULL) {
			TrackerSparqlQueryVariableBindingList* _tmp27_;
			binding_list = (_tmp27_ = tracker_sparql_query_variable_binding_list_new (), _g_object_unref0 (binding_list), _tmp27_);
			self->priv->pattern_variables = g_list_append (self->priv->pattern_variables, g_strdup (binding->variable));
			g_hash_table_insert (self->priv->pattern_var_map, g_strdup (binding->variable), _g_object_ref0 (binding_list));
			g_string_append_printf (sql, "\"%s\".\"%s\" AS \"%s_u\", ", ((TrackerSparqlQueryDataBinding*) binding)->table->sql_query_tablename, ((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name, binding->variable);
			g_hash_table_insert (self->priv->subgraph_var_set, g_strdup (binding->variable), GINT_TO_POINTER ((gint) TRACKER_SPARQL_QUERY_VARIABLE_STATE_BOUND));
		}
		binding_list->list = g_list_append (binding_list->list, _g_object_ref0 (binding));
		if (((TrackerSparqlQueryVariableBinding*) g_hash_table_lookup (self->priv->var_map, binding->variable)) == NULL) {
			g_hash_table_insert (self->priv->var_map, g_strdup (binding->variable), _g_object_ref0 (binding));
		}
		_g_object_unref0 (binding);
		_g_object_unref0 (binding_list);
	}
	if (newtable) {
		if (self->priv->current_subject_is_var) {
			TrackerSparqlQueryVariableBinding* binding;
			char* _tmp28_;
			TrackerSparqlQueryDataTable* _tmp29_;
			char* _tmp30_;
			TrackerSparqlQueryVariableBindingList* binding_list;
			binding = tracker_sparql_query_variable_binding_new ();
			((TrackerSparqlQueryDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
			binding->variable = (_tmp28_ = g_strdup (self->priv->current_subject), _g_free0 (binding->variable), _tmp28_);
			((TrackerSparqlQueryDataBinding*) binding)->table = (_tmp29_ = _g_object_ref0 (table), _g_object_unref0 (((TrackerSparqlQueryDataBinding*) binding)->table), _tmp29_);
			((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name = (_tmp30_ = g_strdup ("ID"), _g_free0 (((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name), _tmp30_);
			binding_list = _g_object_ref0 ((TrackerSparqlQueryVariableBindingList*) g_hash_table_lookup (self->priv->pattern_var_map, binding->variable));
			if (binding_list == NULL) {
				TrackerSparqlQueryVariableBindingList* _tmp31_;
				binding_list = (_tmp31_ = tracker_sparql_query_variable_binding_list_new (), _g_object_unref0 (binding_list), _tmp31_);
				self->priv->pattern_variables = g_list_append (self->priv->pattern_variables, g_strdup (binding->variable));
				g_hash_table_insert (self->priv->pattern_var_map, g_strdup (binding->variable), _g_object_ref0 (binding_list));
				g_string_append_printf (sql, "\"%s\".\"%s\" AS \"%s_u\", ", ((TrackerSparqlQueryDataBinding*) binding)->table->sql_query_tablename, ((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name, binding->variable);
				g_hash_table_insert (self->priv->subgraph_var_set, g_strdup (binding->variable), GINT_TO_POINTER ((gint) TRACKER_SPARQL_QUERY_VARIABLE_STATE_BOUND));
			}
			binding_list->list = g_list_append (binding_list->list, _g_object_ref0 (binding));
			if (((TrackerSparqlQueryVariableBinding*) g_hash_table_lookup (self->priv->var_map, binding->variable)) == NULL) {
				g_hash_table_insert (self->priv->var_map, g_strdup (binding->variable), _g_object_ref0 (binding));
			}
			_g_object_unref0 (binding);
			_g_object_unref0 (binding_list);
		} else {
			TrackerSparqlQueryLiteralBinding* binding;
			char* _tmp32_;
			TrackerSparqlQueryDataTable* _tmp33_;
			char* _tmp34_;
			binding = tracker_sparql_query_literal_binding_new ();
			((TrackerSparqlQueryDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
			binding->literal = (_tmp32_ = g_strdup (self->priv->current_subject), _g_free0 (binding->literal), _tmp32_);
			((TrackerSparqlQueryDataBinding*) binding)->table = (_tmp33_ = _g_object_ref0 (table), _g_object_unref0 (((TrackerSparqlQueryDataBinding*) binding)->table), _tmp33_);
			((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name = (_tmp34_ = g_strdup ("ID"), _g_free0 (((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name), _tmp34_);
			self->priv->pattern_bindings = g_list_append (self->priv->pattern_bindings, _g_object_ref0 (binding));
			_g_object_unref0 (binding);
		}
	}
	if (!rdftype) {
		if (object_is_var) {
			TrackerSparqlQueryVariableBinding* binding;
			char* _tmp35_;
			TrackerSparqlQueryDataTable* _tmp36_;
			TrackerSparqlQueryVariableBindingList* binding_list;
			binding = tracker_sparql_query_variable_binding_new ();
			binding->variable = (_tmp35_ = g_strdup (object), _g_free0 (binding->variable), _tmp35_);
			((TrackerSparqlQueryDataBinding*) binding)->table = (_tmp36_ = _g_object_ref0 (table), _g_object_unref0 (((TrackerSparqlQueryDataBinding*) binding)->table), _tmp36_);
			if (prop != NULL) {
				char* _tmp37_;
				char* _tmp38_;
				binding->type = (_tmp37_ = g_strdup (tracker_class_get_uri (tracker_property_get_range (prop))), _g_free0 (binding->type), _tmp37_);
				((TrackerSparqlQueryDataBinding*) binding)->data_type = tracker_property_get_data_type (prop);
				((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name = (_tmp38_ = g_strdup (tracker_property_get_name (prop)), _g_free0 (((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name), _tmp38_);
				if (!tracker_property_get_multiple_values (prop)) {
					binding->maybe_null = TRUE;
					binding->in_simple_optional = in_simple_optional;
				}
			} else {
				char* _tmp39_;
				((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name = (_tmp39_ = g_strdup ("object"), _g_free0 (((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name), _tmp39_);
				binding->maybe_null = TRUE;
			}
			binding_list = _g_object_ref0 ((TrackerSparqlQueryVariableBindingList*) g_hash_table_lookup (self->priv->pattern_var_map, binding->variable));
			if (binding_list == NULL) {
				TrackerSparqlQueryVariableBindingList* _tmp40_;
				TrackerSparqlQueryVariableState _tmp41_;
				binding_list = (_tmp40_ = tracker_sparql_query_variable_binding_list_new (), _g_object_unref0 (binding_list), _tmp40_);
				self->priv->pattern_variables = g_list_append (self->priv->pattern_variables, g_strdup (binding->variable));
				g_hash_table_insert (self->priv->pattern_var_map, g_strdup (binding->variable), _g_object_ref0 (binding_list));
				g_string_append_printf (sql, "\"%s\".\"%s\" AS \"%s_u\", ", ((TrackerSparqlQueryDataBinding*) binding)->table->sql_query_tablename, ((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name, binding->variable);
				_tmp41_ = 0;
				if (in_simple_optional) {
					_tmp41_ = TRACKER_SPARQL_QUERY_VARIABLE_STATE_OPTIONAL;
				} else {
					_tmp41_ = TRACKER_SPARQL_QUERY_VARIABLE_STATE_BOUND;
				}
				g_hash_table_insert (self->priv->subgraph_var_set, g_strdup (binding->variable), (gint) _tmp41_);
			}
			binding_list->list = g_list_append (binding_list->list, _g_object_ref0 (binding));
			if (((TrackerSparqlQueryVariableBinding*) g_hash_table_lookup (self->priv->var_map, binding->variable)) == NULL) {
				g_hash_table_insert (self->priv->var_map, g_strdup (binding->variable), _g_object_ref0 (binding));
			}
			_g_object_unref0 (binding);
			_g_object_unref0 (binding_list);
		} else {
			if (_vala_strcmp0 (self->priv->current_predicate, "http://www.tracker-project.org/ontologies/fts#match") == 0) {
				TrackerSparqlQueryLiteralBinding* binding;
				char* _tmp42_;
				TrackerSparqlQueryDataTable* _tmp43_;
				char* _tmp44_;
				binding = tracker_sparql_query_literal_binding_new ();
				binding->is_fts_match = TRUE;
				binding->literal = (_tmp42_ = g_strdup (object), _g_free0 (binding->literal), _tmp42_);
				((TrackerSparqlQueryDataBinding*) binding)->table = (_tmp43_ = _g_object_ref0 (table), _g_object_unref0 (((TrackerSparqlQueryDataBinding*) binding)->table), _tmp43_);
				((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name = (_tmp44_ = g_strdup ("ID"), _g_free0 (((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name), _tmp44_);
				self->priv->pattern_bindings = g_list_append (self->priv->pattern_bindings, _g_object_ref0 (binding));
				_g_object_unref0 (binding);
			} else {
				TrackerSparqlQueryLiteralBinding* binding;
				char* _tmp45_;
				TrackerSparqlQueryDataTable* _tmp46_;
				binding = tracker_sparql_query_literal_binding_new ();
				binding->literal = (_tmp45_ = g_strdup (object), _g_free0 (binding->literal), _tmp45_);
				((TrackerSparqlQueryDataBinding*) binding)->table = (_tmp46_ = _g_object_ref0 (table), _g_object_unref0 (((TrackerSparqlQueryDataBinding*) binding)->table), _tmp46_);
				if (prop != NULL) {
					char* _tmp47_;
					((TrackerSparqlQueryDataBinding*) binding)->data_type = tracker_property_get_data_type (prop);
					((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name = (_tmp47_ = g_strdup (tracker_property_get_name (prop)), _g_free0 (((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name), _tmp47_);
				} else {
					char* _tmp48_;
					((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name = (_tmp48_ = g_strdup ("object"), _g_free0 (((TrackerSparqlQueryDataBinding*) binding)->sql_db_column_name), _tmp48_);
				}
				self->priv->pattern_bindings = g_list_append (self->priv->pattern_bindings, _g_object_ref0 (binding));
				_g_object_unref0 (binding);
			}
		}
	}
	_tmp49_ = FALSE;
	_tmp50_ = FALSE;
	if (!self->priv->current_subject_is_var) {
		_tmp50_ = !self->priv->current_predicate_is_var;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		_tmp49_ = !object_is_var;
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		g_string_append (sql, "1, ");
	}
	_g_free0 (object);
	_g_free0 (db_table);
	_g_object_unref0 (table);
	_g_object_unref0 (prop);
}


static TrackerSparqlQueryDataTable* tracker_sparql_query_get_table (TrackerSparqlQuery* self, const char* subject, const char* db_table, gboolean share_table, gboolean* newtable) {
	TrackerSparqlQueryDataTable* result;
	char* tablestring;
	TrackerSparqlQueryDataTable* table;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subject != NULL, NULL);
	g_return_val_if_fail (db_table != NULL, NULL);
	tablestring = g_strdup_printf ("%s.%s", subject, db_table);
	table = NULL;
	(*newtable) = FALSE;
	if (share_table) {
		TrackerSparqlQueryDataTable* _tmp0_;
		table = (_tmp0_ = _g_object_ref0 ((TrackerSparqlQueryDataTable*) g_hash_table_lookup (self->priv->table_map, tablestring)), _g_object_unref0 (table), _tmp0_);
	}
	if (table == NULL) {
		TrackerSparqlQueryDataTable* _tmp1_;
		char* _tmp2_;
		char* _tmp4_;
		char* _tmp3_;
		(*newtable) = TRUE;
		table = (_tmp1_ = tracker_sparql_query_data_table_new (), _g_object_unref0 (table), _tmp1_);
		table->sql_db_tablename = (_tmp2_ = g_strdup (db_table), _g_free0 (table->sql_db_tablename), _tmp2_);
		table->sql_query_tablename = (_tmp4_ = g_strconcat (db_table, _tmp3_ = g_strdup_printf ("%i", self->priv->counter = self->priv->counter + 1), NULL), _g_free0 (table->sql_query_tablename), _tmp4_);
		_g_free0 (_tmp3_);
		self->priv->tables = g_list_append (self->priv->tables, _g_object_ref0 (table));
		g_hash_table_insert (self->priv->table_map, g_strdup (tablestring), _g_object_ref0 (table));
	}
	result = table;
	_g_free0 (tablestring);
	return result;
}


static char* double_to_string (double self) {
	char* result;
	gint _tmp0__length1;
	gchar* _tmp0_;
	char* _tmp1_;
	result = (_tmp1_ = g_strdup (g_ascii_dtostr ((_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE), _tmp0__length1 = G_ASCII_DTOSTR_BUF_SIZE, _tmp0_), G_ASCII_DTOSTR_BUF_SIZE, self)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


static char* tracker_sparql_query_get_string_for_value (const GValue* value) {
	char* result;
	if (G_VALUE_TYPE (&(*value)) == G_TYPE_INT) {
		result = g_strdup_printf ("%i", g_value_get_int (&(*value)));
		return result;
	} else {
		if (G_VALUE_TYPE (&(*value)) == G_TYPE_DOUBLE) {
			result = double_to_string (g_value_get_double (&(*value)));
			return result;
		} else {
			if (G_VALUE_TYPE (&(*value)) == G_TYPE_STRING) {
				result = g_strdup (g_value_get_string (&(*value)));
				return result;
			} else {
				result = NULL;
				return result;
			}
		}
	}
}


static TrackerSparqlQueryDataTable* tracker_sparql_query_data_table_construct (GType object_type) {
	TrackerSparqlQueryDataTable * self;
	self = (TrackerSparqlQueryDataTable*) g_object_new (object_type, NULL);
	return self;
}


static TrackerSparqlQueryDataTable* tracker_sparql_query_data_table_new (void) {
	return tracker_sparql_query_data_table_construct (TRACKER_SPARQL_QUERY_TYPE_DATA_TABLE);
}


static void tracker_sparql_query_data_table_class_init (TrackerSparqlQueryDataTableClass * klass) {
	tracker_sparql_query_data_table_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_query_data_table_finalize;
}


static void tracker_sparql_query_data_table_instance_init (TrackerSparqlQueryDataTable * self) {
}


static void tracker_sparql_query_data_table_finalize (GObject* obj) {
	TrackerSparqlQueryDataTable * self;
	self = TRACKER_SPARQL_QUERY_DATA_TABLE (obj);
	_g_free0 (self->sql_db_tablename);
	_g_free0 (self->sql_query_tablename);
	_g_object_unref0 (self->predicate_variable);
	G_OBJECT_CLASS (tracker_sparql_query_data_table_parent_class)->finalize (obj);
}


static GType tracker_sparql_query_data_table_get_type (void) {
	static GType tracker_sparql_query_data_table_type_id = 0;
	if (tracker_sparql_query_data_table_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlQueryDataTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_query_data_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlQueryDataTable), 0, (GInstanceInitFunc) tracker_sparql_query_data_table_instance_init, NULL };
		tracker_sparql_query_data_table_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlQueryDataTable", &g_define_type_info, 0);
	}
	return tracker_sparql_query_data_table_type_id;
}


static TrackerSparqlQueryDataBinding* tracker_sparql_query_data_binding_construct (GType object_type) {
	TrackerSparqlQueryDataBinding * self;
	self = (TrackerSparqlQueryDataBinding*) g_object_new (object_type, NULL);
	return self;
}


static void tracker_sparql_query_data_binding_class_init (TrackerSparqlQueryDataBindingClass * klass) {
	tracker_sparql_query_data_binding_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_query_data_binding_finalize;
}


static void tracker_sparql_query_data_binding_instance_init (TrackerSparqlQueryDataBinding * self) {
}


static void tracker_sparql_query_data_binding_finalize (GObject* obj) {
	TrackerSparqlQueryDataBinding * self;
	self = TRACKER_SPARQL_QUERY_DATA_BINDING (obj);
	_g_object_unref0 (self->table);
	_g_free0 (self->sql_db_column_name);
	G_OBJECT_CLASS (tracker_sparql_query_data_binding_parent_class)->finalize (obj);
}


static GType tracker_sparql_query_data_binding_get_type (void) {
	static GType tracker_sparql_query_data_binding_type_id = 0;
	if (tracker_sparql_query_data_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlQueryDataBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_query_data_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlQueryDataBinding), 0, (GInstanceInitFunc) tracker_sparql_query_data_binding_instance_init, NULL };
		tracker_sparql_query_data_binding_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlQueryDataBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return tracker_sparql_query_data_binding_type_id;
}


static TrackerSparqlQueryLiteralBinding* tracker_sparql_query_literal_binding_construct (GType object_type) {
	TrackerSparqlQueryLiteralBinding * self;
	self = (TrackerSparqlQueryLiteralBinding*) tracker_sparql_query_data_binding_construct (object_type);
	return self;
}


static TrackerSparqlQueryLiteralBinding* tracker_sparql_query_literal_binding_new (void) {
	return tracker_sparql_query_literal_binding_construct (TRACKER_SPARQL_QUERY_TYPE_LITERAL_BINDING);
}


static void tracker_sparql_query_literal_binding_class_init (TrackerSparqlQueryLiteralBindingClass * klass) {
	tracker_sparql_query_literal_binding_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_query_literal_binding_finalize;
}


static void tracker_sparql_query_literal_binding_instance_init (TrackerSparqlQueryLiteralBinding * self) {
}


static void tracker_sparql_query_literal_binding_finalize (GObject* obj) {
	TrackerSparqlQueryLiteralBinding * self;
	self = TRACKER_SPARQL_QUERY_LITERAL_BINDING (obj);
	_g_free0 (self->literal);
	G_OBJECT_CLASS (tracker_sparql_query_literal_binding_parent_class)->finalize (obj);
}


static GType tracker_sparql_query_literal_binding_get_type (void) {
	static GType tracker_sparql_query_literal_binding_type_id = 0;
	if (tracker_sparql_query_literal_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlQueryLiteralBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_query_literal_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlQueryLiteralBinding), 0, (GInstanceInitFunc) tracker_sparql_query_literal_binding_instance_init, NULL };
		tracker_sparql_query_literal_binding_type_id = g_type_register_static (TRACKER_SPARQL_QUERY_TYPE_DATA_BINDING, "TrackerSparqlQueryLiteralBinding", &g_define_type_info, 0);
	}
	return tracker_sparql_query_literal_binding_type_id;
}


static TrackerSparqlQueryVariableBinding* tracker_sparql_query_variable_binding_construct (GType object_type) {
	TrackerSparqlQueryVariableBinding * self;
	self = (TrackerSparqlQueryVariableBinding*) tracker_sparql_query_data_binding_construct (object_type);
	return self;
}


static TrackerSparqlQueryVariableBinding* tracker_sparql_query_variable_binding_new (void) {
	return tracker_sparql_query_variable_binding_construct (TRACKER_SPARQL_QUERY_TYPE_VARIABLE_BINDING);
}


static void tracker_sparql_query_variable_binding_class_init (TrackerSparqlQueryVariableBindingClass * klass) {
	tracker_sparql_query_variable_binding_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_query_variable_binding_finalize;
}


static void tracker_sparql_query_variable_binding_instance_init (TrackerSparqlQueryVariableBinding * self) {
}


static void tracker_sparql_query_variable_binding_finalize (GObject* obj) {
	TrackerSparqlQueryVariableBinding * self;
	self = TRACKER_SPARQL_QUERY_VARIABLE_BINDING (obj);
	_g_free0 (self->variable);
	_g_free0 (self->type);
	G_OBJECT_CLASS (tracker_sparql_query_variable_binding_parent_class)->finalize (obj);
}


static GType tracker_sparql_query_variable_binding_get_type (void) {
	static GType tracker_sparql_query_variable_binding_type_id = 0;
	if (tracker_sparql_query_variable_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlQueryVariableBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_query_variable_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlQueryVariableBinding), 0, (GInstanceInitFunc) tracker_sparql_query_variable_binding_instance_init, NULL };
		tracker_sparql_query_variable_binding_type_id = g_type_register_static (TRACKER_SPARQL_QUERY_TYPE_DATA_BINDING, "TrackerSparqlQueryVariableBinding", &g_define_type_info, 0);
	}
	return tracker_sparql_query_variable_binding_type_id;
}


static TrackerSparqlQueryVariableBindingList* tracker_sparql_query_variable_binding_list_construct (GType object_type) {
	TrackerSparqlQueryVariableBindingList * self;
	self = (TrackerSparqlQueryVariableBindingList*) g_object_new (object_type, NULL);
	return self;
}


static TrackerSparqlQueryVariableBindingList* tracker_sparql_query_variable_binding_list_new (void) {
	return tracker_sparql_query_variable_binding_list_construct (TRACKER_SPARQL_QUERY_TYPE_VARIABLE_BINDING_LIST);
}


static void tracker_sparql_query_variable_binding_list_class_init (TrackerSparqlQueryVariableBindingListClass * klass) {
	tracker_sparql_query_variable_binding_list_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_query_variable_binding_list_finalize;
}


static void tracker_sparql_query_variable_binding_list_instance_init (TrackerSparqlQueryVariableBindingList * self) {
}


static void tracker_sparql_query_variable_binding_list_finalize (GObject* obj) {
	TrackerSparqlQueryVariableBindingList * self;
	self = TRACKER_SPARQL_QUERY_VARIABLE_BINDING_LIST (obj);
	__g_list_free_g_object_unref0 (self->list);
	G_OBJECT_CLASS (tracker_sparql_query_variable_binding_list_parent_class)->finalize (obj);
}


static GType tracker_sparql_query_variable_binding_list_get_type (void) {
	static GType tracker_sparql_query_variable_binding_list_type_id = 0;
	if (tracker_sparql_query_variable_binding_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlQueryVariableBindingListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_query_variable_binding_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlQueryVariableBindingList), 0, (GInstanceInitFunc) tracker_sparql_query_variable_binding_list_instance_init, NULL };
		tracker_sparql_query_variable_binding_list_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlQueryVariableBindingList", &g_define_type_info, 0);
	}
	return tracker_sparql_query_variable_binding_list_type_id;
}


static char* tracker_sparql_query_predicate_variable_get_sql_query (TrackerSparqlQueryPredicateVariable* self, TrackerSparqlQuery* query, GError** error) {
	char* result;
	GError * _inner_error_;
	GString* sql;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_inner_error_ = NULL;
	sql = g_string_new ("");
	if (self->subject != NULL) {
		gint subject_id;
		TrackerDBResultSet* result_set;
		subject_id = tracker_data_query_resource_id (self->subject);
		result_set = NULL;
		if (subject_id > 0) {
			TrackerDBInterface* iface;
			TrackerDBStatement* stmt;
			TrackerDBResultSet* _tmp0_;
			TrackerDBResultSet* _tmp1_;
			iface = _g_object_ref0 (tracker_db_manager_get_db_interface ());
			stmt = tracker_db_interface_create_statement (iface, "SELECT (SELECT Uri FROM \"rdfs:Resource\" WHERE ID = \"rdf:type\") FROM \"rdfs:Resource_rdf:type\" WHERE ID = ?");
			tracker_db_statement_bind_int (stmt, 0, subject_id);
			_tmp0_ = tracker_db_statement_execute (stmt, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (iface);
				_g_object_unref0 (stmt);
				_g_object_unref0 (result_set);
				_g_string_free0 (sql);
				return NULL;
			}
			result_set = (_tmp1_ = _tmp0_, _g_object_unref0 (result_set), _tmp1_);
			_g_object_unref0 (iface);
			_g_object_unref0 (stmt);
		}
		if (result_set != NULL) {
			gboolean first;
			first = TRUE;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					GValue value = {0};
					GValue _tmp4_;
					GValue _tmp3_ = {0};
					TrackerClass* domain;
					if (!_tmp2_) {
						if (!tracker_db_result_set_iter_next (result_set)) {
							break;
						}
					}
					_tmp2_ = FALSE;
					_tracker_db_result_set_get_value (result_set, (guint) 0, &_tmp3_);
					value = (_tmp4_ = _tmp3_, G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp4_);
					domain = _g_object_ref0 (tracker_ontology_get_class_by_uri (g_value_get_string (&value)));
					{
						TrackerProperty** _tmp5_;
						TrackerProperty** prop_collection;
						int prop_collection_length1;
						int prop_it;
						prop_collection = _tmp5_ = tracker_ontology_get_properties ();
						prop_collection_length1 = _vala_array_length (_tmp5_);
						for (prop_it = 0; prop_it < _vala_array_length (_tmp5_); prop_it = prop_it + 1) {
							TrackerProperty* prop;
							prop = _g_object_ref0 (prop_collection[prop_it]);
							{
								if (tracker_property_get_domain (prop) == domain) {
									TrackerSparqlQueryLiteralBinding* binding;
									char* _tmp7_;
									if (first) {
										first = FALSE;
									} else {
										g_string_append (sql, " UNION ALL ");
									}
									g_string_append_printf (sql, "SELECT ID, (SELECT ID FROM \"rdfs:Resource\" WHERE Uri = '%s') AS \"predicate\", ", tracker_property_get_uri (prop));
									if (tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_RESOURCE) {
										g_string_append_printf (sql, "(SELECT Uri FROM \"rdfs:Resource\" WHERE ID = \"%s\")", tracker_property_get_name (prop));
									} else {
										gboolean _tmp6_;
										_tmp6_ = FALSE;
										if (tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_INTEGER) {
											_tmp6_ = TRUE;
										} else {
											_tmp6_ = tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_DOUBLE;
										}
										if (_tmp6_) {
											g_string_append_printf (sql, "CAST (\"%s\" AS TEXT)", tracker_property_get_name (prop));
										} else {
											if (tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_BOOLEAN) {
												g_string_append_printf (sql, "CASE \"%s\" WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END", tracker_property_get_name (prop));
											} else {
												if (tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_DATETIME) {
													g_string_append_printf (sql, "strftime (\"%%Y-%%m-%%dT%%H:%%M:%%SZ\", \"%s\", \"unixepoch\")", tracker_property_get_name (prop));
												} else {
													g_string_append_printf (sql, "\"%s\"", tracker_property_get_name (prop));
												}
											}
										}
									}
									g_string_append (sql, " AS \"object\" FROM ");
									if (tracker_property_get_multiple_values (prop)) {
										g_string_append_printf (sql, "\"%s_%s\"", tracker_class_get_name (tracker_property_get_domain (prop)), tracker_property_get_name (prop));
									} else {
										g_string_append_printf (sql, "\"%s\"", tracker_class_get_name (tracker_property_get_domain (prop)));
									}
									g_string_append (sql, " WHERE ID = ?");
									binding = tracker_sparql_query_literal_binding_new ();
									binding->literal = (_tmp7_ = g_strdup_printf ("%i", subject_id), _g_free0 (binding->literal), _tmp7_);
									((TrackerSparqlQueryDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
									query->priv->bindings = g_list_append (query->priv->bindings, _g_object_ref0 (binding));
									_g_object_unref0 (binding);
								}
								_g_object_unref0 (prop);
							}
						}
					}
					G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
					_g_object_unref0 (domain);
				}
			}
		} else {
			g_string_append (sql, "SELECT NULL AS ID, NULL AS \"predicate\", NULL AS \"object\"");
		}
		_g_object_unref0 (result_set);
	} else {
		if (self->object != NULL) {
			gint object_id;
			TrackerDBInterface* iface;
			TrackerDBStatement* stmt;
			TrackerDBResultSet* result_set;
			gboolean first;
			object_id = tracker_data_query_resource_id (self->object);
			iface = _g_object_ref0 (tracker_db_manager_get_db_interface ());
			stmt = tracker_db_interface_create_statement (iface, "SELECT (SELECT Uri FROM \"rdfs:Resource\" WHERE ID = \"rdf:type\") FROM \"rdfs:Resource_rdf:type\" WHERE ID = ?");
			tracker_db_statement_bind_int (stmt, 0, object_id);
			result_set = tracker_db_statement_execute (stmt, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (iface);
				_g_object_unref0 (stmt);
				_g_string_free0 (sql);
				return NULL;
			}
			first = TRUE;
			if (result_set != NULL) {
				{
					gboolean _tmp8_;
					_tmp8_ = TRUE;
					while (TRUE) {
						GValue value = {0};
						GValue _tmp10_;
						GValue _tmp9_ = {0};
						TrackerClass* range;
						if (!_tmp8_) {
							if (!tracker_db_result_set_iter_next (result_set)) {
								break;
							}
						}
						_tmp8_ = FALSE;
						_tracker_db_result_set_get_value (result_set, (guint) 0, &_tmp9_);
						value = (_tmp10_ = _tmp9_, G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp10_);
						range = _g_object_ref0 (tracker_ontology_get_class_by_uri (g_value_get_string (&value)));
						{
							TrackerProperty** _tmp11_;
							TrackerProperty** prop_collection;
							int prop_collection_length1;
							int prop_it;
							prop_collection = _tmp11_ = tracker_ontology_get_properties ();
							prop_collection_length1 = _vala_array_length (_tmp11_);
							for (prop_it = 0; prop_it < _vala_array_length (_tmp11_); prop_it = prop_it + 1) {
								TrackerProperty* prop;
								prop = _g_object_ref0 (prop_collection[prop_it]);
								{
									if (tracker_property_get_range (prop) == range) {
										if (first) {
											first = FALSE;
										} else {
											g_string_append (sql, " UNION ALL ");
										}
										g_string_append_printf (sql, "SELECT ID, (SELECT ID FROM \"rdfs:Resource\" WHERE Uri = '%s') AS \"predicate\", ", tracker_property_get_uri (prop));
										if (tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_RESOURCE) {
											g_string_append_printf (sql, "(SELECT Uri FROM \"rdfs:Resource\" WHERE ID = \"%s\")", tracker_property_get_name (prop));
										} else {
											gboolean _tmp12_;
											_tmp12_ = FALSE;
											if (tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_INTEGER) {
												_tmp12_ = TRUE;
											} else {
												_tmp12_ = tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_DOUBLE;
											}
											if (_tmp12_) {
												g_string_append_printf (sql, "CAST (\"%s\" AS TEXT)", tracker_property_get_name (prop));
											} else {
												if (tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_BOOLEAN) {
													g_string_append_printf (sql, "CASE \"%s\" WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END", tracker_property_get_name (prop));
												} else {
													if (tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_DATETIME) {
														g_string_append_printf (sql, "strftime (\"%%Y-%%m-%%dT%%H:%%M:%%SZ\", \"%s\", \"unixepoch\")", tracker_property_get_name (prop));
													} else {
														g_string_append_printf (sql, "\"%s\"", tracker_property_get_name (prop));
													}
												}
											}
										}
										g_string_append (sql, " AS \"object\" FROM ");
										if (tracker_property_get_multiple_values (prop)) {
											g_string_append_printf (sql, "\"%s_%s\"", tracker_class_get_name (tracker_property_get_domain (prop)), tracker_property_get_name (prop));
										} else {
											g_string_append_printf (sql, "\"%s\"", tracker_class_get_name (tracker_property_get_domain (prop)));
										}
									}
									_g_object_unref0 (prop);
								}
							}
						}
						G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
						_g_object_unref0 (range);
					}
				}
			} else {
				g_string_append (sql, "SELECT NULL AS ID, NULL AS \"predicate\", NULL AS \"object\"");
			}
			_g_object_unref0 (iface);
			_g_object_unref0 (stmt);
			_g_object_unref0 (result_set);
		} else {
			if (self->domain != NULL) {
				gboolean first;
				first = TRUE;
				{
					TrackerProperty** _tmp13_;
					TrackerProperty** prop_collection;
					int prop_collection_length1;
					int prop_it;
					prop_collection = _tmp13_ = tracker_ontology_get_properties ();
					prop_collection_length1 = _vala_array_length (_tmp13_);
					for (prop_it = 0; prop_it < _vala_array_length (_tmp13_); prop_it = prop_it + 1) {
						TrackerProperty* prop;
						prop = _g_object_ref0 (prop_collection[prop_it]);
						{
							if (tracker_property_get_domain (prop) == self->domain) {
								if (first) {
									first = FALSE;
								} else {
									g_string_append (sql, " UNION ALL ");
								}
								g_string_append_printf (sql, "SELECT ID, (SELECT ID FROM \"rdfs:Resource\" WHERE Uri = '%s') AS \"predicate\", ", tracker_property_get_uri (prop));
								if (tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_RESOURCE) {
									g_string_append_printf (sql, "(SELECT Uri FROM \"rdfs:Resource\" WHERE ID = \"%s\")", tracker_property_get_name (prop));
								} else {
									gboolean _tmp14_;
									_tmp14_ = FALSE;
									if (tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_INTEGER) {
										_tmp14_ = TRUE;
									} else {
										_tmp14_ = tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_DOUBLE;
									}
									if (_tmp14_) {
										g_string_append_printf (sql, "CAST (\"%s\" AS TEXT)", tracker_property_get_name (prop));
									} else {
										if (tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_BOOLEAN) {
											g_string_append_printf (sql, "CASE \"%s\" WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END", tracker_property_get_name (prop));
										} else {
											if (tracker_property_get_data_type (prop) == TRACKER_PROPERTY_TYPE_DATETIME) {
												g_string_append_printf (sql, "strftime (\"%%Y-%%m-%%dT%%H:%%M:%%SZ\", \"%s\", \"unixepoch\")", tracker_property_get_name (prop));
											} else {
												g_string_append_printf (sql, "\"%s\"", tracker_property_get_name (prop));
											}
										}
									}
								}
								g_string_append (sql, " AS \"object\" FROM ");
								if (tracker_property_get_multiple_values (prop)) {
									g_string_append_printf (sql, "\"%s_%s\"", tracker_class_get_name (tracker_property_get_domain (prop)), tracker_property_get_name (prop));
								} else {
									g_string_append_printf (sql, "\"%s\"", tracker_class_get_name (tracker_property_get_domain (prop)));
								}
							}
							_g_object_unref0 (prop);
						}
					}
				}
			} else {
				_inner_error_ = tracker_sparql_query_get_internal_error (query, "Unrestricted predicate variables not supported");
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_string_free0 (sql);
					return NULL;
				}
			}
		}
	}
	result = g_strdup (sql->str);
	_g_string_free0 (sql);
	return result;
}


static TrackerSparqlQueryPredicateVariable* tracker_sparql_query_predicate_variable_construct (GType object_type) {
	TrackerSparqlQueryPredicateVariable * self;
	self = (TrackerSparqlQueryPredicateVariable*) g_object_new (object_type, NULL);
	return self;
}


static TrackerSparqlQueryPredicateVariable* tracker_sparql_query_predicate_variable_new (void) {
	return tracker_sparql_query_predicate_variable_construct (TRACKER_SPARQL_QUERY_TYPE_PREDICATE_VARIABLE);
}


static void tracker_sparql_query_predicate_variable_class_init (TrackerSparqlQueryPredicateVariableClass * klass) {
	tracker_sparql_query_predicate_variable_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_query_predicate_variable_finalize;
}


static void tracker_sparql_query_predicate_variable_instance_init (TrackerSparqlQueryPredicateVariable * self) {
}


static void tracker_sparql_query_predicate_variable_finalize (GObject* obj) {
	TrackerSparqlQueryPredicateVariable * self;
	self = TRACKER_SPARQL_QUERY_PREDICATE_VARIABLE (obj);
	_g_free0 (self->subject);
	_g_free0 (self->object);
	_g_object_unref0 (self->domain);
	G_OBJECT_CLASS (tracker_sparql_query_predicate_variable_parent_class)->finalize (obj);
}


static GType tracker_sparql_query_predicate_variable_get_type (void) {
	static GType tracker_sparql_query_predicate_variable_type_id = 0;
	if (tracker_sparql_query_predicate_variable_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlQueryPredicateVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_query_predicate_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlQueryPredicateVariable), 0, (GInstanceInitFunc) tracker_sparql_query_predicate_variable_instance_init, NULL };
		tracker_sparql_query_predicate_variable_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlQueryPredicateVariable", &g_define_type_info, 0);
	}
	return tracker_sparql_query_predicate_variable_type_id;
}


static TrackerSparqlQueryTokenInfo* tracker_sparql_query_token_info_dup (const TrackerSparqlQueryTokenInfo* self) {
	TrackerSparqlQueryTokenInfo* dup;
	dup = g_new0 (TrackerSparqlQueryTokenInfo, 1);
	memcpy (dup, self, sizeof (TrackerSparqlQueryTokenInfo));
	return dup;
}


static void tracker_sparql_query_token_info_free (TrackerSparqlQueryTokenInfo* self) {
	g_free (self);
}


static GType tracker_sparql_query_token_info_get_type (void) {
	static GType tracker_sparql_query_token_info_type_id = 0;
	if (tracker_sparql_query_token_info_type_id == 0) {
		tracker_sparql_query_token_info_type_id = g_boxed_type_register_static ("TrackerSparqlQueryTokenInfo", (GBoxedCopyFunc) tracker_sparql_query_token_info_dup, (GBoxedFreeFunc) tracker_sparql_query_token_info_free);
	}
	return tracker_sparql_query_token_info_type_id;
}


static void tracker_sparql_query_class_init (TrackerSparqlQueryClass * klass) {
	tracker_sparql_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlQueryPrivate));
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_query_finalize;
}


static void tracker_sparql_query_instance_init (TrackerSparqlQuery * self) {
	self->priv = TRACKER_SPARQL_QUERY_GET_PRIVATE (self);
	self->priv->bnodeid = 0;
}


static void tracker_sparql_query_finalize (GObject* obj) {
	TrackerSparqlQuery * self;
	self = TRACKER_SPARQL_QUERY (obj);
	_g_object_unref0 (self->priv->scanner);
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
	_g_free0 (self->priv->query_string);
	_g_free0 (self->priv->current_subject);
	_g_free0 (self->priv->current_predicate);
	_g_hash_table_unref0 (self->priv->prefix_map);
	__g_list_free_g_object_unref0 (self->priv->tables);
	_g_hash_table_unref0 (self->priv->table_map);
	__g_list_free_g_object_unref0 (self->priv->bindings);
	__g_list_free_g_object_unref0 (self->priv->pattern_bindings);
	_g_hash_table_unref0 (self->priv->var_map);
	__g_list_free_g_free0 (self->priv->pattern_variables);
	_g_hash_table_unref0 (self->priv->pattern_var_map);
	_g_hash_table_unref0 (self->priv->subgraph_var_set);
	_g_hash_table_unref0 (self->priv->predicate_variable_map);
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
	G_OBJECT_CLASS (tracker_sparql_query_parent_class)->finalize (obj);
}


GType tracker_sparql_query_get_type (void) {
	static GType tracker_sparql_query_type_id = 0;
	if (tracker_sparql_query_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlQuery), 0, (GInstanceInitFunc) tracker_sparql_query_instance_init, NULL };
		tracker_sparql_query_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlQuery", &g_define_type_info, 0);
	}
	return tracker_sparql_query_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




