
#ifndef __TRACKER_SPARQL_BUILDER_H__
#define __TRACKER_SPARQL_BUILDER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

G_BEGIN_DECLS


#define TRACKER_TYPE_SPARQL_BUILDER (tracker_sparql_builder_get_type ())
#define TRACKER_SPARQL_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_BUILDER, TrackerSparqlBuilder))
#define TRACKER_SPARQL_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_BUILDER, TrackerSparqlBuilderClass))
#define TRACKER_IS_SPARQL_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_BUILDER))
#define TRACKER_IS_SPARQL_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_BUILDER))
#define TRACKER_SPARQL_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_BUILDER, TrackerSparqlBuilderClass))

typedef struct _TrackerSparqlBuilder TrackerSparqlBuilder;
typedef struct _TrackerSparqlBuilderClass TrackerSparqlBuilderClass;
typedef struct _TrackerSparqlBuilderPrivate TrackerSparqlBuilderPrivate;

#define TRACKER_TYPE_TURTLE_WRITER (tracker_turtle_writer_get_type ())
#define TRACKER_TURTLE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_TURTLE_WRITER, TrackerTurtleWriter))
#define TRACKER_TURTLE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_TURTLE_WRITER, TrackerTurtleWriterClass))
#define TRACKER_IS_TURTLE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_TURTLE_WRITER))
#define TRACKER_IS_TURTLE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_TURTLE_WRITER))
#define TRACKER_TURTLE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_TURTLE_WRITER, TrackerTurtleWriterClass))

typedef struct _TrackerTurtleWriter TrackerTurtleWriter;
typedef struct _TrackerTurtleWriterClass TrackerTurtleWriterClass;
typedef struct _TrackerTurtleWriterPrivate TrackerTurtleWriterPrivate;

struct _TrackerSparqlBuilder {
	GObject parent_instance;
	TrackerSparqlBuilderPrivate * priv;
};

struct _TrackerSparqlBuilderClass {
	GObjectClass parent_class;
};

struct _TrackerTurtleWriter {
	GObject parent_instance;
	TrackerTurtleWriterPrivate * priv;
};

struct _TrackerTurtleWriterClass {
	GObjectClass parent_class;
};


GType tracker_sparql_builder_get_type (void);
TrackerSparqlBuilder* tracker_sparql_builder_new_update (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct_update (GType object_type);
TrackerSparqlBuilder* tracker_sparql_builder_new_embedded_insert (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct_embedded_insert (GType object_type);
void tracker_sparql_builder_drop_graph (TrackerSparqlBuilder* self, const char* iri);
void tracker_sparql_builder_insert_open (TrackerSparqlBuilder* self, const char* graph);
void tracker_sparql_builder_insert_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_delete_open (TrackerSparqlBuilder* self, const char* graph);
void tracker_sparql_builder_delete_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_where_open (TrackerSparqlBuilder* self);
void tracker_sparql_builder_where_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_subject_variable (TrackerSparqlBuilder* self, const char* var_name);
void tracker_sparql_builder_object_variable (TrackerSparqlBuilder* self, const char* var_name);
void tracker_sparql_builder_subject_iri (TrackerSparqlBuilder* self, const char* iri);
void tracker_sparql_builder_subject (TrackerSparqlBuilder* self, const char* s);
void tracker_sparql_builder_predicate_iri (TrackerSparqlBuilder* self, const char* iri);
void tracker_sparql_builder_predicate (TrackerSparqlBuilder* self, const char* s);
void tracker_sparql_builder_object_iri (TrackerSparqlBuilder* self, const char* iri);
void tracker_sparql_builder_object (TrackerSparqlBuilder* self, const char* s);
void tracker_sparql_builder_object_string (TrackerSparqlBuilder* self, const char* literal);
void tracker_sparql_builder_object_boolean (TrackerSparqlBuilder* self, gboolean literal);
void tracker_sparql_builder_object_int64 (TrackerSparqlBuilder* self, gint64 literal);
void tracker_sparql_builder_object_date (TrackerSparqlBuilder* self, time_t* literal);
void tracker_sparql_builder_object_double (TrackerSparqlBuilder* self, double literal);
void tracker_sparql_builder_object_blank_open (TrackerSparqlBuilder* self);
void tracker_sparql_builder_object_blank_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_prepend (TrackerSparqlBuilder* self, const char* raw);
void tracker_sparql_builder_append (TrackerSparqlBuilder* self, const char* raw);
TrackerSparqlBuilder* tracker_sparql_builder_new (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct (GType object_type);
const char* tracker_sparql_builder_get_result (TrackerSparqlBuilder* self);
gint tracker_sparql_builder_get_length (TrackerSparqlBuilder* self);
GType tracker_turtle_writer_get_type (void);
TrackerTurtleWriter* tracker_turtle_writer_new (GOutputStream* stream);
TrackerTurtleWriter* tracker_turtle_writer_construct (GType object_type, GOutputStream* stream);
void tracker_turtle_writer_subject_iri (TrackerTurtleWriter* self, const char* iri);
void tracker_turtle_writer_subject (TrackerTurtleWriter* self, const char* s);
void tracker_turtle_writer_predicate_iri (TrackerTurtleWriter* self, const char* iri);
void tracker_turtle_writer_predicate (TrackerTurtleWriter* self, const char* s);
void tracker_turtle_writer_object_iri (TrackerTurtleWriter* self, const char* iri);
void tracker_turtle_writer_object (TrackerTurtleWriter* self, const char* s);
void tracker_turtle_writer_object_string (TrackerTurtleWriter* self, const char* literal);
void tracker_turtle_writer_object_boolean (TrackerTurtleWriter* self, gboolean literal);
void tracker_turtle_writer_object_int64 (TrackerTurtleWriter* self, gint64 literal);
void tracker_turtle_writer_object_date (TrackerTurtleWriter* self, time_t* literal);
void tracker_turtle_writer_object_blank_open (TrackerTurtleWriter* self);
void tracker_turtle_writer_object_blank_close (TrackerTurtleWriter* self);
void tracker_turtle_writer_close (TrackerTurtleWriter* self, GError** error);


G_END_DECLS

#endif
