
#ifndef __TRACKER_TURTLE_WRITER_H__
#define __TRACKER_TURTLE_WRITER_H__

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

G_BEGIN_DECLS


#define TRACKER_TYPE_TURTLE_WRITER (tracker_turtle_writer_get_type ())
#define TRACKER_TURTLE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_TURTLE_WRITER, TrackerTurtleWriter))
#define TRACKER_TURTLE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_TURTLE_WRITER, TrackerTurtleWriterClass))
#define TRACKER_IS_TURTLE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_TURTLE_WRITER))
#define TRACKER_IS_TURTLE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_TURTLE_WRITER))
#define TRACKER_TURTLE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_TURTLE_WRITER, TrackerTurtleWriterClass))

typedef struct _TrackerTurtleWriter TrackerTurtleWriter;
typedef struct _TrackerTurtleWriterClass TrackerTurtleWriterClass;
typedef struct _TrackerTurtleWriterPrivate TrackerTurtleWriterPrivate;

struct _TrackerTurtleWriter {
	GObject parent_instance;
	TrackerTurtleWriterPrivate * priv;
};

struct _TrackerTurtleWriterClass {
	GObjectClass parent_class;
};


GType tracker_turtle_writer_get_type (void);
TrackerTurtleWriter* tracker_turtle_writer_new (GOutputStream* stream);
TrackerTurtleWriter* tracker_turtle_writer_construct (GType object_type, GOutputStream* stream);
void tracker_turtle_writer_subject_iri (TrackerTurtleWriter* self, const char* iri);
void tracker_turtle_writer_subject (TrackerTurtleWriter* self, const char* s);
void tracker_turtle_writer_predicate_iri (TrackerTurtleWriter* self, const char* iri);
void tracker_turtle_writer_predicate (TrackerTurtleWriter* self, const char* s);
void tracker_turtle_writer_object_iri (TrackerTurtleWriter* self, const char* iri);
void tracker_turtle_writer_object (TrackerTurtleWriter* self, const char* s);
void tracker_turtle_writer_object_string (TrackerTurtleWriter* self, const char* literal);
void tracker_turtle_writer_object_boolean (TrackerTurtleWriter* self, gboolean literal);
void tracker_turtle_writer_object_int64 (TrackerTurtleWriter* self, gint64 literal);
void tracker_turtle_writer_object_date (TrackerTurtleWriter* self, time_t* literal);
void tracker_turtle_writer_object_blank_open (TrackerTurtleWriter* self);
void tracker_turtle_writer_object_blank_close (TrackerTurtleWriter* self);
void tracker_turtle_writer_close (TrackerTurtleWriter* self, GError** error);


G_END_DECLS

#endif
