/* tracker-direct.c generated by valac 0.9.5.4-19a5, the Vala compiler
 * generated from tracker-direct.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <tracker-sparql.h>
#include <stdlib.h>
#include <libtracker-data/tracker-data-manager.h>
#include <libtracker-data/tracker-db-manager.h>
#include <tracker-sparql-query.h>
#include <libtracker-data/tracker-db-interface.h>
#include <libtracker-common/tracker-date-time.h>
#include <gio/gio.h>


#define TRACKER_DIRECT_TYPE_STATUS (tracker_direct_status_get_type ())
#define TRACKER_DIRECT_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_DIRECT_TYPE_STATUS, TrackerDirectStatus))
#define TRACKER_DIRECT_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_DIRECT_TYPE_STATUS))
#define TRACKER_DIRECT_STATUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TRACKER_DIRECT_TYPE_STATUS, TrackerDirectStatusIface))

typedef struct _TrackerDirectStatus TrackerDirectStatus;
typedef struct _TrackerDirectStatusIface TrackerDirectStatusIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
typedef struct _TrackerDirectStatusDBusProxy TrackerDirectStatusDBusProxy;
typedef DBusGProxyClass TrackerDirectStatusDBusProxyClass;

#define TRACKER_DIRECT_TYPE_CONNECTION (tracker_direct_connection_get_type ())
#define TRACKER_DIRECT_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnection))
#define TRACKER_DIRECT_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnectionClass))
#define TRACKER_DIRECT_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_DIRECT_TYPE_CONNECTION))
#define TRACKER_DIRECT_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_DIRECT_TYPE_CONNECTION))
#define TRACKER_DIRECT_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnectionClass))

typedef struct _TrackerDirectConnection TrackerDirectConnection;
typedef struct _TrackerDirectConnectionClass TrackerDirectConnectionClass;
typedef struct _TrackerDirectConnectionPrivate TrackerDirectConnectionPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerDirectConnectionQueryAsyncData TrackerDirectConnectionQueryAsyncData;

struct _TrackerDirectStatusIface {
	GTypeInterface parent_iface;
	void (*wait) (TrackerDirectStatus* self, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _TrackerDirectStatusDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _TrackerDirectConnection {
	TrackerSparqlConnection parent_instance;
	TrackerDirectConnectionPrivate * priv;
};

struct _TrackerDirectConnectionClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerDirectConnectionQueryAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerDirectConnection* self;
	char* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* _tmp0_;
	GError * _inner_error_;
};


static gboolean tracker_direct_connection_initialized;
static gboolean tracker_direct_connection_initialized = FALSE;
static gpointer tracker_direct_connection_parent_class = NULL;

TrackerDirectStatus* tracker_direct_status_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType tracker_direct_status_get_type (void) G_GNUC_CONST;
void tracker_direct_status_wait (TrackerDirectStatus* self, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void tracker_direct_status_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _tracker_direct_status_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult tracker_direct_status_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_tracker_direct_status_introspect (TrackerDirectStatus* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_direct_status_property_get_all (TrackerDirectStatus* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_direct_status_wait (TrackerDirectStatus* self, DBusConnection* connection, DBusMessage* message);
GType tracker_direct_status_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult tracker_direct_status_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	TRACKER_DIRECT_STATUS_DBUS_PROXY_DUMMY_PROPERTY
};
static void tracker_direct_status_dbus_proxy_wait (TrackerDirectStatus* self, GError** error);
static void tracker_direct_status_dbus_proxy_tracker_direct_status__interface_init (TrackerDirectStatusIface* iface);
static void tracker_direct_status_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_direct_status_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType tracker_direct_connection_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_DIRECT_CONNECTION_DUMMY_PROPERTY
};
TrackerDirectConnection* tracker_direct_connection_new (GError** error);
TrackerDirectConnection* tracker_direct_connection_construct (GType object_type, GError** error);
static TrackerSparqlCursor* tracker_direct_connection_real_query (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GError** error);
static void tracker_direct_connection_real_query_async_data_free (gpointer _data);
static void tracker_direct_connection_real_query_async (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_direct_connection_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_direct_connection_real_query_async_co (TrackerDirectConnectionQueryAsyncData* data);
static void tracker_direct_connection_finalize (GObject* obj);
TrackerSparqlConnection* module_init (void);

static const DBusObjectPathVTable _tracker_direct_status_dbus_path_vtable = {_tracker_direct_status_dbus_unregister, tracker_direct_status_dbus_message};
static const _DBusObjectVTable _tracker_direct_status_dbus_vtable = {tracker_direct_status_dbus_register_object};


void tracker_direct_status_wait (TrackerDirectStatus* self, GError** error) {
	TRACKER_DIRECT_STATUS_GET_INTERFACE (self)->wait (self, error);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _tracker_direct_status_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_tracker_direct_status_introspect (TrackerDirectStatus* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Status\">\n  <method name=\"Wait\">\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_direct_status_property_get_all (TrackerDirectStatus* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Status") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_direct_status_wait (TrackerDirectStatus* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	tracker_direct_status_wait (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult tracker_direct_status_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_tracker_direct_status_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_tracker_direct_status_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Status", "Wait")) {
		result = _dbus_tracker_direct_status_wait (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void tracker_direct_status_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_tracker_direct_status_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void tracker_direct_status_base_init (TrackerDirectStatusIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TRACKER_DIRECT_TYPE_STATUS, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_tracker_direct_status_dbus_vtable));
	}
}


GType tracker_direct_status_get_type (void) {
	static volatile gsize tracker_direct_status_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_direct_status_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerDirectStatusIface), (GBaseInitFunc) tracker_direct_status_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType tracker_direct_status_type_id;
		tracker_direct_status_type_id = g_type_register_static (G_TYPE_INTERFACE, "TrackerDirectStatus", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (tracker_direct_status_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (tracker_direct_status_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &tracker_direct_status_dbus_proxy_get_type);
		g_once_init_leave (&tracker_direct_status_type_id__volatile, tracker_direct_status_type_id);
	}
	return tracker_direct_status_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (TrackerDirectStatusDBusProxy, tracker_direct_status_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TRACKER_DIRECT_TYPE_STATUS, tracker_direct_status_dbus_proxy_tracker_direct_status__interface_init) );
TrackerDirectStatus* tracker_direct_status_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	TrackerDirectStatus* self;
	self = g_object_new (tracker_direct_status_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Status", NULL);
	return self;
}


static GObject* tracker_direct_status_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (tracker_direct_status_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), tracker_direct_status_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult tracker_direct_status_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void tracker_direct_status_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((TrackerDirectStatusDBusProxy*) self)->disposed) {
		return;
	}
	((TrackerDirectStatusDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), tracker_direct_status_dbus_proxy_filter, self);
	G_OBJECT_CLASS (tracker_direct_status_dbus_proxy_parent_class)->dispose (self);
}


static void tracker_direct_status_dbus_proxy_class_init (TrackerDirectStatusDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = tracker_direct_status_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = tracker_direct_status_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = tracker_direct_status_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_direct_status_dbus_proxy_set_property;
}


static void tracker_direct_status_dbus_proxy_init (TrackerDirectStatusDBusProxy* self) {
}


static void tracker_direct_status_dbus_proxy_wait (TrackerDirectStatus* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((TrackerDirectStatusDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Status", "Wait");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, 2147483647, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp1_;
			_edomain = DBUS_GERROR;
			_tmp1_ = _dbus_error.name + 27;
			if (strcmp (_tmp1_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp1_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp1_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp1_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp1_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp1_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp1_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp1_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp1_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp1_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp1_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp1_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp1_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp1_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp1_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp1_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp1_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp1_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp1_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp1_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp1_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp1_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp1_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp1_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp1_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp1_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp1_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp1_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp1_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp1_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp1_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp1_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp1_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void tracker_direct_status_dbus_proxy_tracker_direct_status__interface_init (TrackerDirectStatusIface* iface) {
	iface->wait = tracker_direct_status_dbus_proxy_wait;
}


static void tracker_direct_status_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void tracker_direct_status_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


TrackerDirectConnection* tracker_direct_connection_construct (GType object_type, GError** error) {
	GError * _inner_error_;
	TrackerDirectConnection * self;
	guint select_cache_size;
	char* env_cache_size;
	_inner_error_ = NULL;
	g_return_val_if_fail (!tracker_direct_connection_initialized, NULL);
	self = (TrackerDirectConnection*) tracker_sparql_connection_construct (object_type);
	select_cache_size = (guint) 100;
	{
		DBusGConnection* connection;
		TrackerDirectStatus* status;
		connection = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		status = tracker_direct_status_dbus_proxy_new (connection, TRACKER_DBUS_SERVICE, TRACKER_DBUS_OBJECT_STATUS);
		tracker_direct_status_wait (status, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (status);
			_dbus_g_connection_unref0 (connection);
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			_g_object_unref0 (status);
			_dbus_g_connection_unref0 (connection);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (status);
		_dbus_g_connection_unref0 (connection);
	}
	goto __finally0;
	__catch0_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, "Unable to initialize database");
			{
				_g_error_free0 (e);
				goto __finally0;
			}
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	env_cache_size = g_strdup (g_getenv ("TRACKER_SPARQL_CACHE_SIZE"));
	if (env_cache_size != NULL) {
		select_cache_size = (guint) atoi (env_cache_size);
	}
	if (!tracker_data_manager_init (TRACKER_DB_MANAGER_READONLY, NULL, NULL, FALSE, select_cache_size, (guint) 0, NULL, NULL, NULL)) {
		_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, "Unable to initialize database");
		{
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (env_cache_size);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (env_cache_size);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	tracker_direct_connection_initialized = TRUE;
	_g_free0 (env_cache_size);
	return self;
}


TrackerDirectConnection* tracker_direct_connection_new (GError** error) {
	return tracker_direct_connection_construct (TRACKER_DIRECT_TYPE_CONNECTION, error);
}


static TrackerSparqlCursor* tracker_direct_connection_real_query (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GError** error) {
	TrackerDirectConnection * self;
	TrackerSparqlCursor* result = NULL;
	GError * _inner_error_;
	self = (TrackerDirectConnection*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	_inner_error_ = NULL;
	{
		TrackerSparqlQuery* query_object;
		TrackerDBCursor* cursor;
		query_object = tracker_sparql_query_new (sparql);
		cursor = tracker_sparql_query_execute_cursor (query_object, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (query_object);
			if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
				goto __catch1_tracker_db_interface_error;
			}
			if (_inner_error_->domain == TRACKER_DATE_ERROR) {
				goto __catch1_tracker_date_error;
			}
			goto __finally1;
		}
		tracker_sparql_cursor_set_connection ((TrackerSparqlCursor*) cursor, (TrackerSparqlConnection*) self);
		result = (TrackerSparqlCursor*) cursor;
		_g_object_unref0 (query_object);
		return result;
	}
	goto __finally1;
	__catch1_tracker_db_interface_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
			{
				_g_error_free0 (e);
				goto __finally1;
			}
			_g_error_free0 (e);
		}
	}
	goto __finally1;
	__catch1_tracker_date_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, e->message);
			{
				_g_error_free0 (e);
				goto __finally1;
			}
			_g_error_free0 (e);
		}
	}
	__finally1:
	{
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


static void tracker_direct_connection_real_query_async_data_free (gpointer _data) {
	TrackerDirectConnectionQueryAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TrackerDirectConnectionQueryAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tracker_direct_connection_real_query_async (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerDirectConnection * self;
	TrackerDirectConnectionQueryAsyncData* _data_;
	self = (TrackerDirectConnection*) base;
	_data_ = g_slice_new0 (TrackerDirectConnectionQueryAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_direct_connection_real_query_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_direct_connection_real_query_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->sparql = g_strdup (sparql);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_direct_connection_real_query_async_co (_data_);
}


static TrackerSparqlCursor* tracker_direct_connection_real_query_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerDirectConnectionQueryAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_direct_connection_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerDirectConnectionQueryAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_direct_connection_real_query_async_co (data);
}


static gboolean tracker_direct_connection_real_query_async_co (TrackerDirectConnectionQueryAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_tmp0_ = tracker_sparql_connection_query ((TrackerSparqlConnection*) data->self, data->sparql, data->cancellable, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		data->result = data->_tmp0_;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tracker_direct_connection_class_init (TrackerDirectConnectionClass * klass) {
	tracker_direct_connection_parent_class = g_type_class_peek_parent (klass);
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query = tracker_direct_connection_real_query;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_async = tracker_direct_connection_real_query_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_finish = tracker_direct_connection_real_query_finish;
	G_OBJECT_CLASS (klass)->finalize = tracker_direct_connection_finalize;
}


static void tracker_direct_connection_instance_init (TrackerDirectConnection * self) {
}


static void tracker_direct_connection_finalize (GObject* obj) {
	TrackerDirectConnection * self;
	self = TRACKER_DIRECT_CONNECTION (obj);
	{
		if (tracker_direct_connection_initialized) {
			tracker_data_manager_shutdown ();
			tracker_direct_connection_initialized = FALSE;
		}
	}
	G_OBJECT_CLASS (tracker_direct_connection_parent_class)->finalize (obj);
}


GType tracker_direct_connection_get_type (void) {
	static volatile gsize tracker_direct_connection_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_direct_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerDirectConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_direct_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerDirectConnection), 0, (GInstanceInitFunc) tracker_direct_connection_instance_init, NULL };
		GType tracker_direct_connection_type_id;
		tracker_direct_connection_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerDirectConnection", &g_define_type_info, 0);
		g_once_init_leave (&tracker_direct_connection_type_id__volatile, tracker_direct_connection_type_id);
	}
	return tracker_direct_connection_type_id__volatile;
}


TrackerSparqlConnection* module_init (void) {
	TrackerSparqlConnection* result = NULL;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		TrackerSparqlConnection* plugin;
		plugin = (TrackerSparqlConnection*) tracker_direct_connection_new (&_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch2_tracker_sparql_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = plugin;
		return result;
	}
	goto __finally2;
	__catch2_tracker_sparql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally2:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}




