/* tracker-utils.c generated by valac 0.9.5.4-19a5, the Vala compiler
 * generated from tracker-utils.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))



char* tracker_sparql_escape_uri_vprintf (const char* format, va_list args);
char* tracker_sparql_escape_uri_printf (const char* format, ...);
char* tracker_sparql_escape_string (const char* literal);



/**
 * SECTION: tracker-misc
 * @short_description: General purpose utilities provided by the library
 * @title: Utilities
 * @stability: Stable
 * @include: tracker-sparql.h
 *
 * <para>
 * The libtracker-sparql utilities help in the creation of proper SPARQL queries.
 * </para>
 */
/**
 * tracker_sparql_escape_string:
 * @literal: a string to escape
 *
 * Escapes a string so that it can be used in a SPARQL query.
 *
 * Returns: a newly-allocated string with the escaped version of @literal.
 * The returned string should be freed with g_free() when no longer needed.
 *
 * Since: 0.10
 */
char* tracker_sparql_escape_string (const char* literal) {
	char* result = NULL;
	GString* str;
	gchar* p;
	g_return_val_if_fail (literal != NULL, NULL);
	str = g_string_new ("");
	p = literal;
	while (TRUE) {
		gsize len;
		if (!((*p) != '\0')) {
			break;
		}
		len = strcspn ((const char*) p, "\t\n\r\b\f\"\\");
		g_string_append_len (str, (const char*) p, (gssize) ((glong) len));
		p = p + len;
		switch (*p) {
			case '\t':
			{
				g_string_append (str, "\\t");
				break;
			}
			case '\n':
			{
				g_string_append (str, "\\n");
				break;
			}
			case '\r':
			{
				g_string_append (str, "\\r");
				break;
			}
			case '\b':
			{
				g_string_append (str, "\\b");
				break;
			}
			case '\f':
			{
				g_string_append (str, "\\f");
				break;
			}
			case '"':
			{
				g_string_append (str, "\\\"");
				break;
			}
			case '\\':
			{
				g_string_append (str, "\\\\");
				break;
			}
			default:
			{
				continue;
			}
		}
		p++;
	}
	result = g_strdup (str->str);
	_g_string_free0 (str);
	return result;
}




