/* tracker-utils.c generated by valac 0.10.0, the Vala compiler
 * generated from tracker-utils.gs, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <float.h>
#include <math.h>


#define TYPE_CATEGORIES (categories_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))

typedef enum  {
	CATEGORIES_Application,
	CATEGORIES_Contact,
	CATEGORIES_Email,
	CATEGORIES_EmailAttachment,
	CATEGORIES_File,
	CATEGORIES_Folder,
	CATEGORIES_Audio,
	CATEGORIES_Video,
	CATEGORIES_Image,
	CATEGORIES_Document,
	CATEGORIES_Text,
	CATEGORIES_Development,
	CATEGORIES_Web,
	CATEGORIES_WebHistory
} Categories;



GType categories_get_type (void) G_GNUC_CONST;
char* tracker_utils_EscapeSparql (const char* sparql, gboolean add_wildcard);
gboolean tracker_utils_LaunchApp (const char* uri);
gboolean tracker_utils_OpenUri (const char* uri, gboolean is_dir);
GdkPixbuf* tracker_utils_GetThemePixbufByName (const char* icon_name, gint size, GdkScreen* screen);
GdkPixbuf* tracker_utils_GetThemeIconPixbuf (GIcon* icon, gint size, GdkScreen* screen);
GdkPixbuf* tracker_utils_GetThumbNail (GFileInfo* info, gint thumb_size, gint icon_size, GdkScreen* screen);
char* tracker_utils_FormatFileSize (gint64 size);



GType categories_get_type (void) {
	static volatile gsize categories_type_id__volatile = 0;
	if (g_once_init_enter (&categories_type_id__volatile)) {
		static const GEnumValue values[] = {{CATEGORIES_Application, "CATEGORIES_Application", "application"}, {CATEGORIES_Contact, "CATEGORIES_Contact", "contact"}, {CATEGORIES_Email, "CATEGORIES_Email", "email"}, {CATEGORIES_EmailAttachment, "CATEGORIES_EmailAttachment", "emailattachment"}, {CATEGORIES_File, "CATEGORIES_File", "file"}, {CATEGORIES_Folder, "CATEGORIES_Folder", "folder"}, {CATEGORIES_Audio, "CATEGORIES_Audio", "audio"}, {CATEGORIES_Video, "CATEGORIES_Video", "video"}, {CATEGORIES_Image, "CATEGORIES_Image", "image"}, {CATEGORIES_Document, "CATEGORIES_Document", "document"}, {CATEGORIES_Text, "CATEGORIES_Text", "text"}, {CATEGORIES_Development, "CATEGORIES_Development", "development"}, {CATEGORIES_Web, "CATEGORIES_Web", "web"}, {CATEGORIES_WebHistory, "CATEGORIES_WebHistory", "webhistory"}, {0, NULL, NULL}};
		GType categories_type_id;
		categories_type_id = g_enum_register_static ("Categories", values);
		g_once_init_leave (&categories_type_id__volatile, categories_type_id);
	}
	return categories_type_id__volatile;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
#line 1170 "glib-2.0.vapi"
	return result;
#line 75 "tracker-utils.c"
}


#line 54 "tracker-utils.gs"
char* tracker_utils_EscapeSparql (const char* sparql, gboolean add_wildcard) {
#line 81 "tracker-utils.c"
	char* result = NULL;
	GString* str;
	glong len;
	gchar* p;
#line 54 "tracker-utils.gs"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 55 "tracker-utils.gs"
	str = g_string_new ("");
#line 57 "tracker-utils.gs"
	if (sparql == NULL) {
#line 92 "tracker-utils.c"
		result = g_strdup ("");
		_g_string_free0 (str);
#line 58 "tracker-utils.gs"
		return result;
#line 97 "tracker-utils.c"
	}
#line 60 "tracker-utils.gs"
	len = string_get_length (sparql);
#line 62 "tracker-utils.gs"
	if (len < 3) {
#line 103 "tracker-utils.c"
		result = g_strdup (sparql);
		_g_string_free0 (str);
#line 63 "tracker-utils.gs"
		return result;
#line 108 "tracker-utils.c"
	}
#line 65 "tracker-utils.gs"
	p = sparql;
#line 67 "tracker-utils.gs"
	while (TRUE) {
#line 67 "tracker-utils.gs"
		if (!((*p) != '\0')) {
#line 67 "tracker-utils.gs"
			break;
#line 118 "tracker-utils.c"
		}
#line 68 "tracker-utils.gs"
		if ((*p) == '"') {
#line 69 "tracker-utils.gs"
			g_string_append (str, "\\\"");
#line 124 "tracker-utils.c"
		} else {
#line 70 "tracker-utils.gs"
			if ((*p) == '\\') {
#line 71 "tracker-utils.gs"
				g_string_append (str, "\\\\");
#line 130 "tracker-utils.c"
			} else {
#line 73 "tracker-utils.gs"
				g_string_append_c (str, *p);
#line 134 "tracker-utils.c"
			}
		}
#line 74 "tracker-utils.gs"
		p++;
#line 139 "tracker-utils.c"
	}
#line 76 "tracker-utils.gs"
	if (add_wildcard) {
#line 77 "tracker-utils.gs"
		p--;
#line 78 "tracker-utils.gs"
		if ((*p) != ' ') {
#line 79 "tracker-utils.gs"
			g_string_append_c (str, '*');
#line 149 "tracker-utils.c"
		}
	}
	result = g_strdup (str->str);
	_g_string_free0 (str);
#line 82 "tracker-utils.gs"
	return result;
#line 156 "tracker-utils.c"
}


#line 86 "tracker-utils.gs"
gboolean tracker_utils_LaunchApp (const char* uri) {
#line 162 "tracker-utils.c"
	gboolean result = FALSE;
	GAppInfo* app_info;
	GAppLaunchContext* context;
	GFile* file;
	char* _tmp0_;
	GAppInfo* _tmp1_;
	GAppLaunchContext* _tmp2_;
	GError * _inner_error_ = NULL;
#line 86 "tracker-utils.gs"
	g_return_val_if_fail (uri != NULL, FALSE);
#line 173 "tracker-utils.c"
	app_info = NULL;
	context = NULL;
#line 90 "tracker-utils.gs"
	file = g_file_new_for_uri (uri);
#line 92 "tracker-utils.gs"
	app_info = (_tmp1_ = (GAppInfo*) g_desktop_app_info_new_from_filename (_tmp0_ = g_file_get_path (file)), _g_object_unref0 (app_info), _tmp1_);
#line 180 "tracker-utils.c"
	_g_free0 (_tmp0_);
#line 93 "tracker-utils.gs"
	if (app_info == NULL) {
#line 184 "tracker-utils.c"
		result = tracker_utils_OpenUri (uri, FALSE);
		_g_object_unref0 (file);
		_g_object_unref0 (context);
		_g_object_unref0 (app_info);
#line 94 "tracker-utils.gs"
		return result;
#line 191 "tracker-utils.c"
	}
#line 96 "tracker-utils.gs"
	context = (_tmp2_ = (GAppLaunchContext*) gdk_app_launch_context_new (), _g_object_unref0 (context), _tmp2_);
#line 195 "tracker-utils.c"
	{
#line 98 "tracker-utils.gs"
		g_app_info_launch (app_info, NULL, context, &_inner_error_);
#line 199 "tracker-utils.c"
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* msg;
#line 100 "tracker-utils.gs"
			msg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, N_ ("Could not launch \"%s\"\nError: %s\n"), g_app_info_get_display_name (app_info), e->message));
#line 102 "tracker-utils.gs"
			gtk_dialog_run ((GtkDialog*) msg);
#line 216 "tracker-utils.c"
			result = FALSE;
			_g_object_unref0 (msg);
			_g_error_free0 (e);
			_g_object_unref0 (file);
			_g_object_unref0 (context);
			_g_object_unref0 (app_info);
#line 103 "tracker-utils.gs"
			return result;
#line 225 "tracker-utils.c"
		}
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_object_unref0 (context);
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	_g_object_unref0 (file);
	_g_object_unref0 (context);
	_g_object_unref0 (app_info);
#line 105 "tracker-utils.gs"
	return result;
#line 243 "tracker-utils.c"
}


#line 108 "tracker-utils.gs"
gboolean tracker_utils_OpenUri (const char* uri, gboolean is_dir) {
#line 249 "tracker-utils.c"
	gboolean result = FALSE;
	GAppInfo* app_info;
	GFile* file;
	GError * _inner_error_ = NULL;
#line 108 "tracker-utils.gs"
	g_return_val_if_fail (uri != NULL, FALSE);
#line 256 "tracker-utils.c"
	app_info = NULL;
#line 111 "tracker-utils.gs"
	file = g_file_new_for_uri (uri);
#line 260 "tracker-utils.c"
	{
		GAppInfo* _tmp0_;
		GAppInfo* _tmp1_;
#line 114 "tracker-utils.gs"
		_tmp0_ = g_file_query_default_handler (file, NULL, &_inner_error_);
#line 266 "tracker-utils.c"
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
#line 114 "tracker-utils.gs"
		app_info = (_tmp1_ = _tmp0_, _g_object_unref0 (app_info), _tmp1_);
#line 272 "tracker-utils.c"
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* msg;
#line 116 "tracker-utils.gs"
			msg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, N_ ("Could not get application info for %s\nError: %s\n"), uri, e->message));
#line 118 "tracker-utils.gs"
			gtk_dialog_run ((GtkDialog*) msg);
#line 286 "tracker-utils.c"
			result = FALSE;
			_g_object_unref0 (msg);
			_g_error_free0 (e);
			_g_object_unref0 (file);
			_g_object_unref0 (app_info);
#line 119 "tracker-utils.gs"
			return result;
#line 294 "tracker-utils.c"
		}
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	{
#line 122 "tracker-utils.gs"
		g_app_info_launch_default_for_uri (uri, NULL, &_inner_error_);
#line 308 "tracker-utils.c"
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* msg;
#line 124 "tracker-utils.gs"
			msg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, N_ ("Could not lauch %s\nError: %s\n"), uri, e->message));
#line 126 "tracker-utils.gs"
			gtk_dialog_run ((GtkDialog*) msg);
#line 325 "tracker-utils.c"
			result = FALSE;
			_g_object_unref0 (msg);
			_g_error_free0 (e);
			_g_object_unref0 (file);
			_g_object_unref0 (app_info);
#line 127 "tracker-utils.gs"
			return result;
#line 333 "tracker-utils.c"
		}
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	_g_object_unref0 (file);
	_g_object_unref0 (app_info);
#line 129 "tracker-utils.gs"
	return result;
#line 349 "tracker-utils.c"
}


#line 132 "tracker-utils.gs"
inline GdkPixbuf* tracker_utils_GetThemePixbufByName (const char* icon_name, gint size, GdkScreen* screen) {
#line 355 "tracker-utils.c"
	GdkPixbuf* result = NULL;
	GThemedIcon* icon;
#line 132 "tracker-utils.gs"
	g_return_val_if_fail (icon_name != NULL, NULL);
#line 132 "tracker-utils.gs"
	g_return_val_if_fail (screen != NULL, NULL);
#line 134 "tracker-utils.gs"
	icon = (GThemedIcon*) g_themed_icon_new (icon_name);
#line 364 "tracker-utils.c"
	result = tracker_utils_GetThemeIconPixbuf ((GIcon*) icon, size, screen);
	_g_object_unref0 (icon);
#line 136 "tracker-utils.gs"
	return result;
#line 369 "tracker-utils.c"
}


#line 139 "tracker-utils.gs"
GdkPixbuf* tracker_utils_GetThumbNail (GFileInfo* info, gint thumb_size, gint icon_size, GdkScreen* screen) {
#line 375 "tracker-utils.c"
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf;
	GError * _inner_error_ = NULL;
#line 139 "tracker-utils.gs"
	g_return_val_if_fail (info != NULL, NULL);
#line 139 "tracker-utils.gs"
	g_return_val_if_fail (screen != NULL, NULL);
#line 141 "tracker-utils.gs"
	pixbuf = NULL;
#line 385 "tracker-utils.c"
	{
		char* thumbpath;
#line 144 "tracker-utils.gs"
		thumbpath = g_strdup (g_file_info_get_attribute_byte_string (info, G_FILE_ATTRIBUTE_THUMBNAIL_PATH));
#line 146 "tracker-utils.gs"
		if (thumbpath != NULL) {
#line 392 "tracker-utils.c"
			GdkPixbuf* _tmp0_;
			GdkPixbuf* _tmp1_;
#line 147 "tracker-utils.gs"
			_tmp0_ = gdk_pixbuf_new_from_file_at_size (thumbpath, thumb_size, thumb_size, &_inner_error_);
#line 397 "tracker-utils.c"
			if (_inner_error_ != NULL) {
				_g_free0 (thumbpath);
				goto __catch13_g_error;
			}
#line 147 "tracker-utils.gs"
			pixbuf = (_tmp1_ = _tmp0_, _g_object_unref0 (pixbuf), _tmp1_);
#line 404 "tracker-utils.c"
		}
		_g_free0 (thumbpath);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			;
			_g_error_free0 (e);
		}
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 151 "tracker-utils.gs"
	if (pixbuf == NULL) {
#line 428 "tracker-utils.c"
		GdkPixbuf* _tmp2_;
#line 152 "tracker-utils.gs"
		pixbuf = (_tmp2_ = tracker_utils_GetThemeIconPixbuf (g_file_info_get_icon (info), icon_size, screen), _g_object_unref0 (pixbuf), _tmp2_);
#line 432 "tracker-utils.c"
	}
#line 154 "tracker-utils.gs"
	if (pixbuf == NULL) {
#line 436 "tracker-utils.c"
		GdkPixbuf* _tmp3_;
#line 155 "tracker-utils.gs"
		pixbuf = (_tmp3_ = tracker_utils_GetThemePixbufByName ("text-x-generic", icon_size, screen), _g_object_unref0 (pixbuf), _tmp3_);
#line 440 "tracker-utils.c"
	}
	result = pixbuf;
#line 157 "tracker-utils.gs"
	return result;
#line 445 "tracker-utils.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 160 "tracker-utils.gs"
GdkPixbuf* tracker_utils_GetThemeIconPixbuf (GIcon* icon, gint size, GdkScreen* screen) {
#line 456 "tracker-utils.c"
	GdkPixbuf* result = NULL;
	GtkIconInfo* icon_info;
	GtkIconTheme* theme;
	GtkIconInfo* _tmp0_;
	GError * _inner_error_ = NULL;
#line 160 "tracker-utils.gs"
	g_return_val_if_fail (icon != NULL, NULL);
#line 160 "tracker-utils.gs"
	g_return_val_if_fail (screen != NULL, NULL);
#line 466 "tracker-utils.c"
	icon_info = NULL;
#line 164 "tracker-utils.gs"
	theme = _g_object_ref0 (gtk_icon_theme_get_for_screen (screen));
#line 166 "tracker-utils.gs"
	icon_info = (_tmp0_ = gtk_icon_theme_lookup_by_gicon (theme, icon, size, GTK_ICON_LOOKUP_USE_BUILTIN), _gtk_icon_info_free0 (icon_info), _tmp0_);
#line 472 "tracker-utils.c"
	{
		GdkPixbuf* _tmp1_;
#line 169 "tracker-utils.gs"
		_tmp1_ = gtk_icon_info_load_icon (icon_info, &_inner_error_);
#line 477 "tracker-utils.c"
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
		result = _tmp1_;
		_g_object_unref0 (theme);
		_gtk_icon_info_free0 (icon_info);
#line 169 "tracker-utils.gs"
		return result;
#line 486 "tracker-utils.c"
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			result = NULL;
			_g_error_free0 (e);
			_g_object_unref0 (theme);
			_gtk_icon_info_free0 (icon_info);
#line 171 "tracker-utils.gs"
			return result;
#line 501 "tracker-utils.c"
		}
	}
	__finally14:
	{
		_g_object_unref0 (theme);
		_gtk_icon_info_free0 (icon_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (theme);
	_gtk_icon_info_free0 (icon_info);
}


#line 175 "tracker-utils.gs"
char* tracker_utils_FormatFileSize (gint64 size) {
#line 519 "tracker-utils.c"
	char* result = NULL;
	double displayed_size = 0.0;
#line 178 "tracker-utils.gs"
	if (size < 1024) {
#line 524 "tracker-utils.c"
		result = g_strdup_printf ("%u bytes", (guint) size);
#line 179 "tracker-utils.gs"
		return result;
#line 528 "tracker-utils.c"
	}
#line 181 "tracker-utils.gs"
	if (size < 1048576) {
#line 182 "tracker-utils.gs"
		displayed_size = ((double) size) / 1024;
#line 534 "tracker-utils.c"
		result = g_strdup_printf ("%.1f KB", displayed_size);
#line 183 "tracker-utils.gs"
		return result;
#line 538 "tracker-utils.c"
	}
#line 185 "tracker-utils.gs"
	if (size < 1073741824) {
#line 186 "tracker-utils.gs"
		displayed_size = ((double) size) / 1048576;
#line 544 "tracker-utils.c"
		result = g_strdup_printf ("%.1f MB", displayed_size);
#line 187 "tracker-utils.gs"
		return result;
#line 548 "tracker-utils.c"
	}
#line 189 "tracker-utils.gs"
	displayed_size = ((double) size) / 1073741824;
#line 552 "tracker-utils.c"
	result = g_strdup_printf ("%.1f GB", displayed_size);
#line 190 "tracker-utils.gs"
	return result;
#line 556 "tracker-utils.c"
}




