/* test-busy-handling.c generated by valac 0.11.4, the Vala compiler
 * generated from test-busy-handling.vala, do not modify */

/*
 * Copyright (C) 2008, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/* To run this test:*/
/* -===-------------*/
/**/
/* tracker-control -k*/
/* rm ~/.cache/tracker/meta.db*/
/* export TRACKER_DEBUG_MAKE_JOURNAL_READER_GO_VERY_SLOW=yes*/
/* tracker-store*/
/* ./busy-handling-test*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_RESOURCES (resources_get_type ())
#define RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESOURCES, Resources))
#define IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESOURCES))
#define RESOURCES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_RESOURCES, ResourcesIface))

typedef struct _Resources Resources;
typedef struct _ResourcesIface ResourcesIface;

#define TYPE_RESOURCES_PROXY (resources_proxy_get_type ())
typedef GDBusProxy ResourcesProxy;
typedef GDBusProxyClass ResourcesProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_STATUS (status_get_type ())
#define STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS, Status))
#define IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS))
#define STATUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_STATUS, StatusIface))

typedef struct _Status Status;
typedef struct _StatusIface StatusIface;

#define TYPE_STATUS_PROXY (status_proxy_get_type ())
typedef GDBusProxy StatusProxy;
typedef GDBusProxyClass StatusProxyClass;

#define TYPE_TEST_APP (test_app_get_type ())
#define TEST_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_APP, TestApp))
#define TEST_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_APP, TestAppClass))
#define IS_TEST_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_APP))
#define IS_TEST_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_APP))
#define TEST_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_APP, TestAppClass))

typedef struct _TestApp TestApp;
typedef struct _TestAppClass TestAppClass;
typedef struct _TestAppPrivate TestAppPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _test_app_unref0(var) ((var == NULL) ? NULL : (var = (test_app_unref (var), NULL)))
typedef struct _TestAppDoQueryTestsAsyncData TestAppDoQueryTestsAsyncData;
typedef struct _TestAppDoAsyncQueryTestsData TestAppDoAsyncQueryTestsData;
typedef struct _TestAppJumperAsyncData TestAppJumperAsyncData;
typedef struct _ParamSpecTestApp ParamSpecTestApp;

struct _ResourcesIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*sparql_query_finish) (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _StatusIface {
	GTypeInterface parent_iface;
	gdouble (*get_progress) (Status* self, GError** error);
	gchar* (*get_status) (Status* self, GError** error);
};

struct _TestApp {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TestAppPrivate * priv;
};

struct _TestAppClass {
	GTypeClass parent_class;
	void (*finalize) (TestApp *self);
};

struct _TestAppPrivate {
	gint res;
	gint users;
	GMainLoop* loop;
	gboolean initialized;
	gboolean ready;
};

struct _TestAppDoQueryTestsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestApp* self;
	gchar* test_name;
	gint cnt;
	gint _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint results_length1;
	gint results_length2;
	gchar** _tmp3_;
	gchar** results;
	gchar** res_collection;
	int res_collection_length1;
	int res_it;
	gchar* _tmp4_;
	gchar* res;
	GError * e;
	GError * _inner_error_;
};

struct _TestAppDoAsyncQueryTestsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestApp* self;
};

struct _TestAppJumperAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestApp* self;
};

struct _ParamSpecTestApp {
	GParamSpec parent_instance;
};


static gpointer test_app_parent_class = NULL;
static Resources* test_app_resources_object;
static Resources* test_app_resources_object = NULL;
static Status* test_app_status_object;
static Status* test_app_status_object = NULL;

GType resources_proxy_get_type (void) G_GNUC_CONST;
guint resources_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType resources_get_type (void) G_GNUC_CONST;
void resources_sparql_query (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** resources_sparql_query_finish (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void resources_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void resources_proxy_sparql_query_async (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** resources_proxy_sparql_query_finish (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void resources_proxy_resources_interface_init (ResourcesIface* iface);
static void _dbus_resources_sparql_query (Resources* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_resources_sparql_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _resources_unregister_object (gpointer user_data);
GType status_proxy_get_type (void) G_GNUC_CONST;
guint status_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType status_get_type (void) G_GNUC_CONST;
gdouble status_get_progress (Status* self, GError** error);
gchar* status_get_status (Status* self, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void status_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_status_progress (Status* self, GVariant* parameters);
static gdouble status_proxy_get_progress (Status* self, GError** error);
static gchar* status_proxy_get_status (Status* self, GError** error);
static void status_proxy_status_interface_init (StatusIface* iface);
static void _dbus_status_get_progress (Status* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_status_get_status (Status* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void status_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* status_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean status_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_status_progress (GObject* _sender, const gchar* status, gdouble progress, gpointer* _data);
static void _status_unregister_object (gpointer user_data);
gpointer test_app_ref (gpointer instance);
void test_app_unref (gpointer instance);
GParamSpec* param_spec_test_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_test_app (GValue* value, gpointer v_object);
void value_take_test_app (GValue* value, gpointer v_object);
gpointer value_get_test_app (const GValue* value);
GType test_app_get_type (void) G_GNUC_CONST;
#define TEST_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEST_APP, TestAppPrivate))
enum  {
	TEST_APP_DUMMY_PROPERTY
};
TestApp* test_app_new (void);
TestApp* test_app_construct (GType object_type);
static void test_app_on_status_cb (TestApp* self, const gchar* status, gdouble progress);
static void _test_app_on_status_cb_status_progress (Status* _sender, const gchar* status, gdouble progress, gpointer self);
static void test_app_do_query_tests_async_data_free (gpointer _data);
static void test_app_do_query_tests_async (TestApp* self, const gchar* test_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void test_app_do_query_tests_finish (TestApp* self, GAsyncResult* _res_);
static gboolean test_app_do_query_tests_async_co (TestAppDoQueryTestsAsyncData* data);
static void test_app_do_query_tests_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void test_app_check_shutdown (TestApp* self);
static void test_app_do_async_query_tests_data_free (gpointer _data);
static void test_app_do_async_query_tests (TestApp* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void test_app_do_async_query_tests_finish (TestApp* self, GAsyncResult* _res_);
static gboolean test_app_do_async_query_tests_co (TestAppDoAsyncQueryTestsData* data);
static void test_app_do_async_query_tests_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void test_app_jumper_async_data_free (gpointer _data);
static void test_app_jumper_async (TestApp* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void test_app_jumper_finish (TestApp* self, GAsyncResult* _res_);
static gboolean test_app_jumper_async_co (TestAppJumperAsyncData* data);
static void test_app_jumper_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean test_app_test_ready (TestApp* self);
static gboolean test_app_in_mainloop (TestApp* self);
static gboolean _test_app_test_ready_gsource_func (gpointer self);
gint test_app_run (TestApp* self);
static gboolean _test_app_in_mainloop_gsource_func (gpointer self);
static void test_app_finalize (TestApp* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _resources_dbus_arg_info_sparql_query_query = {-1, "query", "s"};
static const GDBusArgInfo _resources_dbus_arg_info_sparql_query_result = {-1, "result", "aas"};
static const GDBusArgInfo * const _resources_dbus_arg_info_sparql_query_in[] = {&_resources_dbus_arg_info_sparql_query_query, NULL};
static const GDBusArgInfo * const _resources_dbus_arg_info_sparql_query_out[] = {&_resources_dbus_arg_info_sparql_query_result, NULL};
static const GDBusMethodInfo _resources_dbus_method_info_sparql_query = {-1, "SparqlQuery", (GDBusArgInfo **) (&_resources_dbus_arg_info_sparql_query_in), (GDBusArgInfo **) (&_resources_dbus_arg_info_sparql_query_out)};
static const GDBusMethodInfo * const _resources_dbus_method_info[] = {&_resources_dbus_method_info_sparql_query, NULL};
static const GDBusSignalInfo * const _resources_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _resources_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _resources_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Resources", (GDBusMethodInfo **) (&_resources_dbus_method_info), (GDBusSignalInfo **) (&_resources_dbus_signal_info), (GDBusPropertyInfo **) (&_resources_dbus_property_info)};
static const GDBusInterfaceVTable _resources_dbus_interface_vtable = {resources_dbus_interface_method_call, resources_dbus_interface_get_property, resources_dbus_interface_set_property};
static const GDBusArgInfo _status_dbus_arg_info_get_progress_result = {-1, "result", "d"};
static const GDBusArgInfo * const _status_dbus_arg_info_get_progress_in[] = {NULL};
static const GDBusArgInfo * const _status_dbus_arg_info_get_progress_out[] = {&_status_dbus_arg_info_get_progress_result, NULL};
static const GDBusMethodInfo _status_dbus_method_info_get_progress = {-1, "GetProgress", (GDBusArgInfo **) (&_status_dbus_arg_info_get_progress_in), (GDBusArgInfo **) (&_status_dbus_arg_info_get_progress_out)};
static const GDBusArgInfo _status_dbus_arg_info_get_status_result = {-1, "result", "s"};
static const GDBusArgInfo * const _status_dbus_arg_info_get_status_in[] = {NULL};
static const GDBusArgInfo * const _status_dbus_arg_info_get_status_out[] = {&_status_dbus_arg_info_get_status_result, NULL};
static const GDBusMethodInfo _status_dbus_method_info_get_status = {-1, "GetStatus", (GDBusArgInfo **) (&_status_dbus_arg_info_get_status_in), (GDBusArgInfo **) (&_status_dbus_arg_info_get_status_out)};
static const GDBusMethodInfo * const _status_dbus_method_info[] = {&_status_dbus_method_info_get_progress, &_status_dbus_method_info_get_status, NULL};
static const GDBusArgInfo _status_dbus_arg_info_progress_status = {-1, "status", "s"};
static const GDBusArgInfo _status_dbus_arg_info_progress_progress = {-1, "progress", "d"};
static const GDBusArgInfo * const _status_dbus_arg_info_progress[] = {&_status_dbus_arg_info_progress_status, &_status_dbus_arg_info_progress_progress, NULL};
static const GDBusSignalInfo _status_dbus_signal_info_progress = {-1, "Progress", (GDBusArgInfo **) (&_status_dbus_arg_info_progress)};
static const GDBusSignalInfo * const _status_dbus_signal_info[] = {&_status_dbus_signal_info_progress, NULL};
static const GDBusPropertyInfo * const _status_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _status_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Status", (GDBusMethodInfo **) (&_status_dbus_method_info), (GDBusSignalInfo **) (&_status_dbus_signal_info), (GDBusPropertyInfo **) (&_status_dbus_property_info)};
static const GDBusInterfaceVTable _status_dbus_interface_vtable = {status_dbus_interface_method_call, status_dbus_interface_get_property, status_dbus_interface_set_property};

void resources_sparql_query (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RESOURCES_GET_INTERFACE (self)->sparql_query (self, query, _callback_, _user_data_);
}


gchar** resources_sparql_query_finish (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	return RESOURCES_GET_INTERFACE (self)->sparql_query_finish (self, _res_, result_length1, result_length2, error);
}


static void resources_base_init (ResourcesIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType resources_get_type (void) {
	static volatile gsize resources_type_id__volatile = 0;
	if (g_once_init_enter (&resources_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ResourcesIface), (GBaseInitFunc) resources_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType resources_type_id;
		resources_type_id = g_type_register_static (G_TYPE_INTERFACE, "Resources", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (resources_type_id, G_TYPE_DBUS_PROXY);
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) resources_proxy_get_type);
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Tracker1.Resources");
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) resources_register_object);
		g_once_init_leave (&resources_type_id__volatile, resources_type_id);
	}
	return resources_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ResourcesProxy, resources_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_RESOURCES, resources_proxy_resources_interface_init) );
static void resources_proxy_class_init (ResourcesProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = resources_proxy_g_signal;
}


static void resources_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void resources_proxy_init (ResourcesProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void resources_proxy_sparql_query_async (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Tracker1.Resources", "SparqlQuery");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static gchar** resources_proxy_sparql_query_finish (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result;
	int _result_length1;
	int _result_length2;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		int _tmp1__length2;
		GVariantIter _tmp4_;
		GVariant* _tmp5_;
		_tmp1__length2 = 0;
		g_variant_iter_init (&_tmp4_, _tmp3_);
		for (; (_tmp5_ = g_variant_iter_next_value (&_tmp4_)) != NULL; _tmp1__length2++) {
			if (_tmp1__size == _tmp1__length) {
				_tmp1__size = 2 * _tmp1__size;
				_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
			}
			_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp5_, NULL);
			g_variant_unref (_tmp5_);
		}
		_result_length2 = _tmp1__length2;
		g_variant_unref (_tmp3_);
	}
	_result_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_result = _tmp1_;
	g_variant_unref (_tmp0_);
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	g_object_unref (_reply_message);
	return _result;
}


static void resources_proxy_resources_interface_init (ResourcesIface* iface) {
	iface->sparql_query = resources_proxy_sparql_query_async;
	iface->sparql_query_finish = resources_proxy_sparql_query_finish;
}


static void _dbus_resources_sparql_query (Resources* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* query = NULL;
	GVariant* _tmp6_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	query = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	resources_sparql_query (self, query, (GAsyncReadyCallback) _dbus_resources_sparql_query_ready, invocation);
	_g_free0 (query);
}


static void _dbus_resources_sparql_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	int result_length2 = 0;
	gchar** _tmp7_;
	GVariantBuilder _tmp8_;
	int _tmp9_;
	invocation = _user_data_;
	result = resources_sparql_query_finish ((Resources*) source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp7_ = result;
	g_variant_builder_init (&_tmp8_, G_VARIANT_TYPE ("aas"));
	for (_tmp9_ = 0; _tmp9_ < result_length1; _tmp9_++) {
		GVariantBuilder _tmp10_;
		int _tmp11_;
		g_variant_builder_init (&_tmp10_, G_VARIANT_TYPE ("aas"));
		for (_tmp11_ = 0; _tmp11_ < result_length2; _tmp11_++) {
			g_variant_builder_add_value (&_tmp10_, g_variant_new_string (*_tmp7_));
			_tmp7_++;
		}
		g_variant_builder_add_value (&_tmp8_, g_variant_builder_end (&_tmp10_));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp8_));
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SparqlQuery") == 0) {
		_dbus_resources_sparql_query (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint resources_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_resources_dbus_interface_info), &_resources_dbus_interface_vtable, data, _resources_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _resources_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


gdouble status_get_progress (Status* self, GError** error) {
	return STATUS_GET_INTERFACE (self)->get_progress (self, error);
}


gchar* status_get_status (Status* self, GError** error) {
	return STATUS_GET_INTERFACE (self)->get_status (self, error);
}


static void g_cclosure_user_marshal_VOID__STRING_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_DOUBLE) (gpointer data1, const char* arg_1, gdouble arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_double (param_values + 2), data2);
}


static void status_base_init (StatusIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("progress", TYPE_STATUS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_DOUBLE, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_DOUBLE);
	}
}


GType status_get_type (void) {
	static volatile gsize status_type_id__volatile = 0;
	if (g_once_init_enter (&status_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StatusIface), (GBaseInitFunc) status_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType status_type_id;
		status_type_id = g_type_register_static (G_TYPE_INTERFACE, "Status", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (status_type_id, G_TYPE_DBUS_PROXY);
		g_type_set_qdata (status_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) status_proxy_get_type);
		g_type_set_qdata (status_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Tracker1.Status");
		g_type_set_qdata (status_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) status_register_object);
		g_once_init_leave (&status_type_id__volatile, status_type_id);
	}
	return status_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (StatusProxy, status_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_STATUS, status_proxy_status_interface_init) );
static void status_proxy_class_init (StatusProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = status_proxy_g_signal;
}


static void _dbus_handle_status_progress (Status* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* status = NULL;
	GVariant* _tmp12_;
	gdouble progress = 0.0;
	GVariant* _tmp13_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	status = g_variant_dup_string (_tmp12_, NULL);
	g_variant_unref (_tmp12_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	progress = g_variant_get_double (_tmp13_);
	g_variant_unref (_tmp13_);
	g_signal_emit_by_name (self, "progress", status, progress);
	_g_free0 (status);
}


static void status_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Progress") == 0) {
		_dbus_handle_status_progress (proxy, parameters);
	}
}


static void status_proxy_init (StatusProxy* self) {
}


static gdouble status_proxy_get_progress (Status* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gdouble _result;
	GVariant* _tmp14_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Tracker1.Status", "GetProgress");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return 0.0;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return 0.0;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp14_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_double (_tmp14_);
	g_variant_unref (_tmp14_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* status_proxy_get_status (Status* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp15_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Tracker1.Status", "GetStatus");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp15_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp15_, NULL);
	g_variant_unref (_tmp15_);
	g_object_unref (_reply_message);
	return _result;
}


static void status_proxy_status_interface_init (StatusIface* iface) {
	iface->get_progress = status_proxy_get_progress;
	iface->get_status = status_proxy_get_status;
}


static void _dbus_status_get_progress (Status* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gdouble result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = status_get_progress (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_double (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_status_get_status (Status* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = status_get_status (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void status_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetProgress") == 0) {
		_dbus_status_get_progress (object, parameters, invocation);
	} else if (strcmp (method_name, "GetStatus") == 0) {
		_dbus_status_get_status (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* status_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean status_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_status_progress (GObject* _sender, const gchar* status, gdouble progress, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (status));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (progress));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Status", "Progress", _arguments, NULL);
}


guint status_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_status_dbus_interface_info), &_status_dbus_interface_vtable, data, _status_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "progress", (GCallback) _dbus_status_progress, data);
	return result;
}


static void _status_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _test_app_on_status_cb_status_progress (Status* _sender, const gchar* status, gdouble progress, gpointer self) {
	test_app_on_status_cb (self, status, progress);
}


TestApp* test_app_construct (GType object_type) {
	TestApp* self = NULL;
	gdouble progress = 0.0;
	gchar* status;
	Resources* _tmp0_ = NULL;
	Resources* _tmp1_;
	Resources* _tmp2_;
	Status* _tmp3_ = NULL;
	Status* _tmp4_;
	Status* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (TestApp*) g_type_create_instance (object_type);
	g_return_val_if_fail (!self->priv->initialized, NULL);
	status = NULL;
	_tmp0_ = g_initable_new (TYPE_RESOURCES_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", "org.freedesktop.Tracker1", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/Tracker1/Resources", "g-interface-name", "org.freedesktop.Tracker1.Resources", NULL);
	_tmp1_ = (Resources*) _tmp0_;
	if (_inner_error_ != NULL) {
		_g_free0 (status);
		goto __catch0_g_error;
	}
	_tmp2_ = _tmp1_;
	_g_object_unref0 (test_app_resources_object);
	test_app_resources_object = _tmp2_;
	_tmp3_ = g_initable_new (TYPE_STATUS_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", "org.freedesktop.Tracker1", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/Tracker1/Status", "g-interface-name", "org.freedesktop.Tracker1.Status", NULL);
	_tmp4_ = (Status*) _tmp3_;
	if (_inner_error_ != NULL) {
		_g_free0 (status);
		goto __catch0_g_error;
	}
	_tmp5_ = _tmp4_;
	_g_object_unref0 (test_app_status_object);
	test_app_status_object = _tmp5_;
	g_signal_connect (test_app_status_object, "progress", (GCallback) _test_app_on_status_cb_status_progress, self);
	_tmp6_ = status_get_progress (test_app_status_object, &_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		_g_free0 (status);
		goto __catch0_g_error;
	}
	progress = _tmp7_;
	_tmp8_ = status_get_status (test_app_status_object, &_inner_error_);
	_tmp9_ = _tmp8_;
	if (_inner_error_ != NULL) {
		_g_free0 (status);
		goto __catch0_g_error;
	}
	_tmp10_ = _tmp9_;
	_g_free0 (status);
	status = _tmp10_;
	if (progress == 1.0) {
		_tmp11_ = g_strcmp0 (status, "Idle") == 0;
	} else {
		_tmp11_ = FALSE;
	}
	self->priv->ready = _tmp11_;
	_g_free0 (status);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("test-busy-handling.vala:74: Could not connect to D-Bus service: %s", e->message);
		self->priv->initialized = FALSE;
		self->priv->res = -1;
		_g_error_free0 (e);
		return self;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->initialized = TRUE;
	return self;
}


TestApp* test_app_new (void) {
	return test_app_construct (TYPE_TEST_APP);
}


static void test_app_on_status_cb (TestApp* self, const gchar* status, gdouble progress) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (status != NULL);
	g_print ("%s: %f\n", status, progress);
	if (progress == 1.0) {
		self->priv->ready = TRUE;
	}
}


static void test_app_do_query_tests_async_data_free (gpointer _data) {
	TestAppDoQueryTestsAsyncData* data;
	data = _data;
	_g_free0 (data->test_name);
	_test_app_unref0 (data->self);
	g_slice_free (TestAppDoQueryTestsAsyncData, data);
}


static gpointer _test_app_ref0 (gpointer self) {
	return self ? test_app_ref (self) : NULL;
}


static void test_app_do_query_tests_async (TestApp* self, const gchar* test_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestAppDoQueryTestsAsyncData* _data_;
	_data_ = g_slice_new0 (TestAppDoQueryTestsAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, test_app_do_query_tests_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_app_do_query_tests_async_data_free);
	_data_->self = _test_app_ref0 (self);
	_data_->test_name = g_strdup (test_name);
	test_app_do_query_tests_async_co (_data_);
}


static void test_app_do_query_tests_finish (TestApp* self, GAsyncResult* _res_) {
	TestAppDoQueryTestsAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void test_app_do_query_tests_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestAppDoQueryTestsAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	test_app_do_query_tests_async_co (data);
}


static gboolean test_app_do_query_tests_async_co (TestAppDoQueryTestsAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->cnt = 0;
	data->_state_ = 1;
	resources_sparql_query (test_app_resources_object, "SELECT ?u { ?u a rdfs:Resource }", test_app_do_query_tests_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp2_ = NULL;
	data->_tmp2_ = resources_sparql_query_finish (test_app_resources_object, data->_res_, &data->_tmp0_, &data->_tmp1_, &data->_inner_error_);
	data->_tmp3_ = data->_tmp2_;
	data->results_length1 = data->_tmp0_;
	data->results_length2 = data->_tmp1_;
	data->results = data->_tmp3_;
	if (data->_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	{
		data->res_collection = data->results;
		data->res_collection_length1 = data->results_length1 * data->results_length2;
		for (data->res_it = 0; data->res_it < (data->results_length1 * data->results_length2); data->res_it = data->res_it + 1) {
			data->_tmp4_ = g_strdup (data->res_collection[data->res_it]);
			data->res = data->_tmp4_;
			{
				data->cnt++;
				_g_free0 (data->res);
			}
		}
	}
	g_print ("%s: Saw %d strings in result\n", data->test_name, data->cnt);
	data->results = (_vala_array_free (data->results, data->results_length1 * data->results_length2, (GDestroyNotify) g_free), NULL);
	goto __finally1;
	__catch1_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_print ("Fail: %s\n", data->e->message);
		data->self->priv->res = -1;
		_g_error_free0 (data->e);
	}
	__finally1:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void test_app_check_shutdown (TestApp* self) {
	g_return_if_fail (self != NULL);
	self->priv->users--;
	if (self->priv->users == 0) {
		g_print ("Async tests done, now I can quit the mainloop\n");
		g_main_loop_quit (self->priv->loop);
	}
}


static void test_app_do_async_query_tests_data_free (gpointer _data) {
	TestAppDoAsyncQueryTestsData* data;
	data = _data;
	_test_app_unref0 (data->self);
	g_slice_free (TestAppDoAsyncQueryTestsData, data);
}


static void test_app_do_async_query_tests (TestApp* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestAppDoAsyncQueryTestsData* _data_;
	_data_ = g_slice_new0 (TestAppDoAsyncQueryTestsData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, test_app_do_async_query_tests);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_app_do_async_query_tests_data_free);
	_data_->self = _test_app_ref0 (self);
	test_app_do_async_query_tests_co (_data_);
}


static void test_app_do_async_query_tests_finish (TestApp* self, GAsyncResult* _res_) {
	TestAppDoAsyncQueryTestsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void test_app_do_async_query_tests_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestAppDoAsyncQueryTestsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	test_app_do_async_query_tests_co (data);
}


static gboolean test_app_do_async_query_tests_co (TestAppDoAsyncQueryTestsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_print ("Test 1: Just launch the query and let it wait\n" \
"Test 1: query launches immediately\n");
	data->self->priv->users++;
	data->_state_ = 1;
	test_app_do_query_tests_async (data->self, "Test 1", test_app_do_async_query_tests_ready, data);
	return FALSE;
	_state_1:
	test_app_do_query_tests_finish (data->self, data->_res_);
	test_app_check_shutdown (data->self);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void test_app_jumper_async_data_free (gpointer _data) {
	TestAppJumperAsyncData* data;
	data = _data;
	_test_app_unref0 (data->self);
	g_slice_free (TestAppJumperAsyncData, data);
}


static void test_app_jumper_async (TestApp* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestAppJumperAsyncData* _data_;
	_data_ = g_slice_new0 (TestAppJumperAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, test_app_jumper_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_app_jumper_async_data_free);
	_data_->self = _test_app_ref0 (self);
	test_app_jumper_async_co (_data_);
}


static void test_app_jumper_finish (TestApp* self, GAsyncResult* _res_) {
	TestAppJumperAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void test_app_jumper_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestAppJumperAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	test_app_jumper_async_co (data);
}


static gboolean test_app_jumper_async_co (TestAppJumperAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	test_app_do_query_tests_async (data->self, "Test 2", test_app_jumper_async_ready, data);
	return FALSE;
	_state_1:
	test_app_do_query_tests_finish (data->self, data->_res_);
	test_app_check_shutdown (data->self);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean test_app_test_ready (TestApp* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->ready) {
		g_print ("Test 2: query launches now\n");
		test_app_jumper_async (self, NULL, NULL);
	}
	result = !self->priv->ready;
	return result;
}


static gboolean _test_app_test_ready_gsource_func (gpointer self) {
	gboolean result;
	result = test_app_test_ready (self);
	return result;
}


static gboolean test_app_in_mainloop (TestApp* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	test_app_do_async_query_tests (self, NULL, NULL);
	g_print ("Test 2: Wait for the status signal to indicate readyness\n");
	self->priv->users++;
	if (!self->priv->ready) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1, _test_app_test_ready_gsource_func, test_app_ref (self), test_app_unref);
	} else {
		test_app_test_ready (self);
	}
	result = FALSE;
	return result;
}


static gboolean _test_app_in_mainloop_gsource_func (gpointer self) {
	gboolean result;
	result = test_app_in_mainloop (self);
	return result;
}


gint test_app_run (TestApp* self) {
	gint result = 0;
	GMainLoop* _tmp0_ = NULL;
	GMainLoop* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_tmp1_ = _tmp0_;
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp1_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _test_app_in_mainloop_gsource_func, test_app_ref (self), test_app_unref);
	g_main_loop_run (self->priv->loop);
	result = self->priv->res;
	return result;
}


static void value_test_app_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_test_app_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		test_app_unref (value->data[0].v_pointer);
	}
}


static void value_test_app_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = test_app_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_test_app_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_test_app_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TestApp* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = test_app_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_test_app_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TestApp** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = test_app_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_test_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTestApp* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEST_APP), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_test_app (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP), NULL);
	return value->data[0].v_pointer;
}


void value_set_test_app (GValue* value, gpointer v_object) {
	TestApp* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_APP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		test_app_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_app_unref (old);
	}
}


void value_take_test_app (GValue* value, gpointer v_object) {
	TestApp* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_APP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_app_unref (old);
	}
}


static void test_app_class_init (TestAppClass * klass) {
	test_app_parent_class = g_type_class_peek_parent (klass);
	TEST_APP_CLASS (klass)->finalize = test_app_finalize;
	g_type_class_add_private (klass, sizeof (TestAppPrivate));
}


static void test_app_instance_init (TestApp * self) {
	self->priv = TEST_APP_GET_PRIVATE (self);
	self->priv->res = -1;
	self->priv->users = 0;
	self->priv->initialized = FALSE;
	self->priv->ready = FALSE;
	self->ref_count = 1;
}


static void test_app_finalize (TestApp* obj) {
	TestApp * self;
	self = TEST_APP (obj);
	_g_main_loop_unref0 (self->priv->loop);
}


GType test_app_get_type (void) {
	static volatile gsize test_app_type_id__volatile = 0;
	if (g_once_init_enter (&test_app_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_test_app_init, value_test_app_free_value, value_test_app_copy_value, value_test_app_peek_pointer, "p", value_test_app_collect_value, "p", value_test_app_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TestAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestApp), 0, (GInstanceInitFunc) test_app_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType test_app_type_id;
		test_app_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TestApp", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&test_app_type_id__volatile, test_app_type_id);
	}
	return test_app_type_id__volatile;
}


gpointer test_app_ref (gpointer instance) {
	TestApp* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void test_app_unref (gpointer instance) {
	TestApp* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEST_APP_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	TestApp* _tmp0_ = NULL;
	TestApp* app;
	gint _tmp1_;
	_tmp0_ = test_app_new ();
	app = _tmp0_;
	_tmp1_ = test_app_run (app);
	result = _tmp1_;
	_test_app_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



