/* tracker-store.c generated by valac 0.34.0.138-14ca, the Vala compiler
 * generated from tracker-store.vala, do not modify */

/*
 * Copyright (C) 2009-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Philip Van Hoof <philip@codeminded.be>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-data/tracker-db-manager.h"
#include "libtracker-data/tracker-db-interface-sqlite.h"
#include "tracker-store/tracker-events.h"
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_STORE (tracker_store_get_type ())
#define TRACKER_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STORE, TrackerStore))
#define TRACKER_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STORE, TrackerStoreClass))
#define TRACKER_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STORE))
#define TRACKER_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STORE))
#define TRACKER_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STORE, TrackerStoreClass))

typedef struct _TrackerStore TrackerStore;
typedef struct _TrackerStoreClass TrackerStoreClass;
typedef struct _TrackerStorePrivate TrackerStorePrivate;

#define TRACKER_STORE_TYPE_PRIORITY (tracker_store_priority_get_type ())

#define TRACKER_STORE_TYPE_TASK_TYPE (tracker_store_task_type_get_type ())

#define TRACKER_STORE_TYPE_TASK (tracker_store_task_get_type ())
#define TRACKER_STORE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_TASK, TrackerStoreTask))
#define TRACKER_STORE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_TASK, TrackerStoreTaskClass))
#define TRACKER_STORE_IS_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_TASK))
#define TRACKER_STORE_IS_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_TASK))
#define TRACKER_STORE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_TASK, TrackerStoreTaskClass))

typedef struct _TrackerStoreTask TrackerStoreTask;
typedef struct _TrackerStoreTaskClass TrackerStoreTaskClass;
#define _tracker_store_task_unref0(var) ((var == NULL) ? NULL : (var = (tracker_store_task_unref (var), NULL)))

#define TRACKER_STORE_TYPE_QUERY_TASK (tracker_store_query_task_get_type ())
#define TRACKER_STORE_QUERY_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask))
#define TRACKER_STORE_QUERY_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTaskClass))
#define TRACKER_STORE_IS_QUERY_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_QUERY_TASK))
#define TRACKER_STORE_IS_QUERY_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_QUERY_TASK))
#define TRACKER_STORE_QUERY_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTaskClass))

typedef struct _TrackerStoreQueryTask TrackerStoreQueryTask;
typedef struct _TrackerStoreQueryTaskClass TrackerStoreQueryTaskClass;
typedef struct _Block7Data Block7Data;
typedef struct _TrackerStoreTaskPrivate TrackerStoreTaskPrivate;
typedef struct _TrackerStoreQueryTaskPrivate TrackerStoreQueryTaskPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TRACKER_STORE_TYPE_UPDATE_TASK (tracker_store_update_task_get_type ())
#define TRACKER_STORE_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask))
#define TRACKER_STORE_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTaskClass))
#define TRACKER_STORE_IS_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_UPDATE_TASK))
#define TRACKER_STORE_IS_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_UPDATE_TASK))
#define TRACKER_STORE_UPDATE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTaskClass))

typedef struct _TrackerStoreUpdateTask TrackerStoreUpdateTask;
typedef struct _TrackerStoreUpdateTaskClass TrackerStoreUpdateTaskClass;
typedef struct _TrackerStoreUpdateTaskPrivate TrackerStoreUpdateTaskPrivate;
typedef struct _Block8Data Block8Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TRACKER_STORE_TYPE_TURTLE_TASK (tracker_store_turtle_task_get_type ())
#define TRACKER_STORE_TURTLE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTask))
#define TRACKER_STORE_TURTLE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTaskClass))
#define TRACKER_STORE_IS_TURTLE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_TURTLE_TASK))
#define TRACKER_STORE_IS_TURTLE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_TURTLE_TASK))
#define TRACKER_STORE_TURTLE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTaskClass))

typedef struct _TrackerStoreTurtleTask TrackerStoreTurtleTask;
typedef struct _TrackerStoreTurtleTaskClass TrackerStoreTurtleTaskClass;
typedef struct _TrackerStoreTurtleTaskPrivate TrackerStoreTurtleTaskPrivate;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define __g_queue_free__tracker_store_task_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__tracker_store_task_unref0_ (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
typedef struct _TrackerStoreSparqlQueryData TrackerStoreSparqlQueryData;
typedef struct _TrackerStoreSparqlUpdateData TrackerStoreSparqlUpdateData;
typedef struct _TrackerStoreSparqlUpdateBlankData TrackerStoreSparqlUpdateBlankData;
typedef struct _TrackerStoreQueueTurtleImportData TrackerStoreQueueTurtleImportData;
typedef struct _TrackerStorePauseData TrackerStorePauseData;
typedef struct _TrackerStoreParamSpecTask TrackerStoreParamSpecTask;
typedef struct _TrackerParamSpecStore TrackerParamSpecStore;

struct _TrackerStore {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStorePrivate * priv;
};

struct _TrackerStoreClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStore *self);
};

typedef enum  {
	TRACKER_STORE_PRIORITY_HIGH,
	TRACKER_STORE_PRIORITY_LOW,
	TRACKER_STORE_PRIORITY_TURTLE,
	TRACKER_STORE_PRIORITY_N_PRIORITIES
} TrackerStorePriority;

typedef enum  {
	TRACKER_STORE_TASK_TYPE_QUERY,
	TRACKER_STORE_TASK_TYPE_UPDATE,
	TRACKER_STORE_TASK_TYPE_UPDATE_BLANK,
	TRACKER_STORE_TASK_TYPE_TURTLE
} TrackerStoreTaskType;

struct _Block7Data {
	int _ref_count_;
	TrackerStoreQueryTask* query_task;
};

struct _TrackerStoreTask {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStoreTaskPrivate * priv;
	TrackerStoreTaskType type;
	gchar* client_id;
	GError* error;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _TrackerStoreTaskClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStoreTask *self);
};

typedef void (*TrackerStoreSparqlQueryInThread) (TrackerDBCursor* cursor, void* user_data, GError** error);
struct _TrackerStoreQueryTask {
	TrackerStoreTask parent_instance;
	TrackerStoreQueryTaskPrivate * priv;
	gchar* query;
	GCancellable* cancellable;
	guint watchdog_id;
	TrackerStoreSparqlQueryInThread in_thread;
	gpointer in_thread_target;
};

struct _TrackerStoreQueryTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _TrackerStoreUpdateTask {
	TrackerStoreTask parent_instance;
	TrackerStoreUpdateTaskPrivate * priv;
	gchar* query;
	GVariant* blank_nodes;
	TrackerStorePriority priority;
};

struct _TrackerStoreUpdateTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _Block8Data {
	int _ref_count_;
	TrackerStoreTask* task;
};

struct _TrackerStoreTurtleTask {
	TrackerStoreTask parent_instance;
	TrackerStoreTurtleTaskPrivate * priv;
	gchar* path;
};

struct _TrackerStoreTurtleTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _TrackerStoreSparqlQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* sparql;
	TrackerStorePriority priority;
	TrackerStoreSparqlQueryInThread in_thread;
	gpointer in_thread_target;
	gchar* client_id;
	TrackerStoreQueryTask* task;
	TrackerStoreQueryTask* _tmp0_;
	TrackerStoreQueryTask* _tmp1_;
	TrackerStoreQueryTask* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreQueryTask* _tmp5_;
	GCancellable* _tmp6_;
	TrackerStoreQueryTask* _tmp7_;
	TrackerStoreSparqlQueryInThread _tmp8_;
	void* _tmp8__target;
	TrackerStoreQueryTask* _tmp9_;
	TrackerStoreQueryTask* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	TrackerStorePriority _tmp13_;
	GQueue* _tmp14_;
	TrackerStoreQueryTask* _tmp15_;
	TrackerStoreTask* _tmp16_;
	TrackerStoreQueryTask* _tmp17_;
	GError* _tmp18_;
	TrackerStoreQueryTask* _tmp19_;
	GError* _tmp20_;
	GError* _tmp21_;
	GError * _inner_error_;
};

struct _TrackerStoreSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* sparql;
	TrackerStorePriority priority;
	gchar* client_id;
	TrackerStoreUpdateTask* task;
	TrackerStoreUpdateTask* _tmp0_;
	TrackerStoreUpdateTask* _tmp1_;
	TrackerStoreUpdateTask* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreUpdateTask* _tmp5_;
	TrackerStorePriority _tmp6_;
	TrackerStoreUpdateTask* _tmp7_;
	TrackerStoreUpdateTask* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	TrackerStorePriority _tmp11_;
	GQueue* _tmp12_;
	TrackerStoreUpdateTask* _tmp13_;
	TrackerStoreTask* _tmp14_;
	TrackerStoreUpdateTask* _tmp15_;
	GError* _tmp16_;
	TrackerStoreUpdateTask* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	GError * _inner_error_;
};

struct _TrackerStoreSparqlUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* sparql;
	TrackerStorePriority priority;
	gchar* client_id;
	GVariant* result;
	TrackerStoreUpdateTask* task;
	TrackerStoreUpdateTask* _tmp0_;
	TrackerStoreUpdateTask* _tmp1_;
	TrackerStoreUpdateTask* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreUpdateTask* _tmp5_;
	TrackerStorePriority _tmp6_;
	TrackerStoreUpdateTask* _tmp7_;
	TrackerStoreUpdateTask* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	TrackerStorePriority _tmp11_;
	GQueue* _tmp12_;
	TrackerStoreUpdateTask* _tmp13_;
	TrackerStoreTask* _tmp14_;
	TrackerStoreUpdateTask* _tmp15_;
	GError* _tmp16_;
	TrackerStoreUpdateTask* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	TrackerStoreUpdateTask* _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	GError * _inner_error_;
};

struct _TrackerStoreQueueTurtleImportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* file;
	gchar* client_id;
	TrackerStoreTurtleTask* task;
	TrackerStoreTurtleTask* _tmp0_;
	TrackerStoreTurtleTask* _tmp1_;
	TrackerStoreTurtleTask* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreTurtleTask* _tmp5_;
	TrackerStoreTurtleTask* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GQueue* _tmp9_;
	TrackerStoreTurtleTask* _tmp10_;
	TrackerStoreTask* _tmp11_;
	TrackerStoreTurtleTask* _tmp12_;
	GError* _tmp13_;
	TrackerStoreTurtleTask* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError * _inner_error_;
};

struct _TrackerStorePauseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gboolean _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	GThreadPool* _tmp4_;
	GThreadPool* _tmp5_;
	GThreadPool* _tmp6_;
	GError* e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	GError * _inner_error_;
};

struct _TrackerStoreParamSpecTask {
	GParamSpec parent_instance;
};

struct _TrackerParamSpecStore {
	GParamSpec parent_instance;
};


static gpointer tracker_store_parent_class = NULL;
static GQueue* tracker_store_query_queues[3];
static GQueue* tracker_store_query_queues[3] = {0};
static GQueue* tracker_store_update_queues[3];
static GQueue* tracker_store_update_queues[3] = {0};
static gint tracker_store_n_queries_running;
static gint tracker_store_n_queries_running = 0;
static gboolean tracker_store_update_running;
static gboolean tracker_store_update_running = FALSE;
static GThreadPool* tracker_store_update_pool;
static GThreadPool* tracker_store_update_pool = NULL;
static GThreadPool* tracker_store_query_pool;
static GThreadPool* tracker_store_query_pool = NULL;
static GThreadPool* tracker_store_checkpoint_pool;
static GThreadPool* tracker_store_checkpoint_pool = NULL;
static GPtrArray* tracker_store_running_tasks;
static GPtrArray* tracker_store_running_tasks = NULL;
static gint tracker_store_max_task_time;
static gint tracker_store_max_task_time = 0;
static gboolean tracker_store_active;
static gboolean tracker_store_active = FALSE;
static GSourceFunc tracker_store_active_callback;
static gpointer tracker_store_active_callback_target;
static GDestroyNotify tracker_store_active_callback_target_destroy_notify;
static GSourceFunc tracker_store_active_callback = NULL;
static gpointer tracker_store_active_callback_target = NULL;
static GDestroyNotify tracker_store_active_callback_target_destroy_notify = NULL;
static gint tracker_store_checkpointing;
static gint tracker_store_checkpointing = 0;
static gpointer tracker_store_task_parent_class = NULL;
static gpointer tracker_store_query_task_parent_class = NULL;
static gpointer tracker_store_update_task_parent_class = NULL;
static gpointer tracker_store_turtle_task_parent_class = NULL;

gpointer tracker_store_ref (gpointer instance);
void tracker_store_unref (gpointer instance);
GParamSpec* tracker_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_store (GValue* value, gpointer v_object);
void tracker_value_take_store (GValue* value, gpointer v_object);
gpointer tracker_value_get_store (const GValue* value);
GType tracker_store_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_STORE_DUMMY_PROPERTY
};
GType tracker_store_priority_get_type (void) G_GNUC_CONST;
static GType tracker_store_task_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gpointer tracker_store_task_ref (gpointer instance);
static void tracker_store_task_unref (gpointer instance);
static GParamSpec* tracker_store_param_spec_task (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void tracker_store_value_set_task (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void tracker_store_value_take_task (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer tracker_store_value_get_task (const GValue* value) G_GNUC_UNUSED;
static GType tracker_store_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_STORE_MAX_CONCURRENT_QUERIES 2
#define TRACKER_STORE_MAX_TASK_TIME 30
static void tracker_store_sched (void);
static GType tracker_store_query_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean ____lambda4_ (Block7Data* _data7_);
static gboolean _____lambda4__gsource_func (gpointer self);
static TrackerDataCommitType tracker_store_commit_type (TrackerStoreTask* task);
static GType tracker_store_update_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean tracker_store_task_finish_cb (TrackerStoreTask* task);
static void tracker_store_pool_dispatch_cb (TrackerStoreTask* task);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void tracker_store_wal_hook (gint n_pages);
static void _tracker_store_wal_hook_tracker_db_wal_callback (gint n_pages);
static GType tracker_store_turtle_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean __lambda5_ (Block8Data* _data8_);
static gboolean ___lambda5__gsource_func (gpointer self);
void tracker_store_wal_checkpoint (void);
static void tracker_store_checkpoint_dispatch_cb (gboolean task);
void tracker_store_init (void);
static void _tracker_store_task_unref0_ (gpointer var);
static void _g_queue_free__tracker_store_task_unref0_ (GQueue* self);
static void _tracker_store_pool_dispatch_cb_gfunc (gpointer data, gpointer self);
static void _tracker_store_checkpoint_dispatch_cb_gfunc (gpointer data, gpointer self);
void tracker_store_shutdown (void);
static void tracker_store_sparql_query_data_free (gpointer _data);
void tracker_store_sparql_query (const gchar* sparql, TrackerStorePriority priority, TrackerStoreSparqlQueryInThread in_thread, void* in_thread_target, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_query_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* _data_);
static TrackerStoreQueryTask* tracker_store_query_task_new (void);
static TrackerStoreQueryTask* tracker_store_query_task_construct (GType object_type);
static gboolean _tracker_store_sparql_query_co_gsource_func (gpointer self);
static void tracker_store_sparql_update_data_free (gpointer _data);
void tracker_store_sparql_update (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_update_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* _data_);
static TrackerStoreUpdateTask* tracker_store_update_task_new (void);
static TrackerStoreUpdateTask* tracker_store_update_task_construct (GType object_type);
static gboolean _tracker_store_sparql_update_co_gsource_func (gpointer self);
static void tracker_store_sparql_update_blank_data_free (gpointer _data);
void tracker_store_sparql_update_blank (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* _data_);
static gboolean _tracker_store_sparql_update_blank_co_gsource_func (gpointer self);
static void tracker_store_queue_turtle_import_data_free (gpointer _data);
void tracker_store_queue_turtle_import (GFile* file, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* _data_);
static TrackerStoreTurtleTask* tracker_store_turtle_task_new (void);
static TrackerStoreTurtleTask* tracker_store_turtle_task_construct (GType object_type);
static gboolean _tracker_store_queue_turtle_import_co_gsource_func (gpointer self);
guint tracker_store_get_queue_size (TrackerStore* self);
void tracker_store_unreg_batches (const gchar* client_id);
static void tracker_store_pause_data_free (gpointer _data);
void tracker_store_pause (GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_pause_finish (GAsyncResult* _res_);
static gboolean tracker_store_pause_co (TrackerStorePauseData* _data_);
static gboolean _tracker_store_pause_co_gsource_func (gpointer self);
void tracker_store_resume (void);
TrackerStore* tracker_store_new (void);
TrackerStore* tracker_store_construct (GType object_type);
enum  {
	TRACKER_STORE_TASK_DUMMY_PROPERTY
};
static TrackerStoreTask* tracker_store_task_construct (GType object_type);
static void tracker_store_task_finalize (TrackerStoreTask * obj);
enum  {
	TRACKER_STORE_QUERY_TASK_DUMMY_PROPERTY
};
static void tracker_store_query_task_finalize (TrackerStoreTask * obj);
enum  {
	TRACKER_STORE_UPDATE_TASK_DUMMY_PROPERTY
};
static void tracker_store_update_task_finalize (TrackerStoreTask * obj);
enum  {
	TRACKER_STORE_TURTLE_TASK_DUMMY_PROPERTY
};
static void tracker_store_turtle_task_finalize (TrackerStoreTask * obj);
static void tracker_store_finalize (TrackerStore * obj);


GType tracker_store_priority_get_type (void) {
	static volatile gsize tracker_store_priority_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_priority_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_STORE_PRIORITY_HIGH, "TRACKER_STORE_PRIORITY_HIGH", "high"}, {TRACKER_STORE_PRIORITY_LOW, "TRACKER_STORE_PRIORITY_LOW", "low"}, {TRACKER_STORE_PRIORITY_TURTLE, "TRACKER_STORE_PRIORITY_TURTLE", "turtle"}, {TRACKER_STORE_PRIORITY_N_PRIORITIES, "TRACKER_STORE_PRIORITY_N_PRIORITIES", "n-priorities"}, {0, NULL, NULL}};
		GType tracker_store_priority_type_id;
		tracker_store_priority_type_id = g_enum_register_static ("TrackerStorePriority", values);
		g_once_init_leave (&tracker_store_priority_type_id__volatile, tracker_store_priority_type_id);
	}
	return tracker_store_priority_type_id__volatile;
}


static GType tracker_store_task_type_get_type (void) {
	static volatile gsize tracker_store_task_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_task_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_STORE_TASK_TYPE_QUERY, "TRACKER_STORE_TASK_TYPE_QUERY", "query"}, {TRACKER_STORE_TASK_TYPE_UPDATE, "TRACKER_STORE_TASK_TYPE_UPDATE", "update"}, {TRACKER_STORE_TASK_TYPE_UPDATE_BLANK, "TRACKER_STORE_TASK_TYPE_UPDATE_BLANK", "update-blank"}, {TRACKER_STORE_TASK_TYPE_TURTLE, "TRACKER_STORE_TASK_TYPE_TURTLE", "turtle"}, {0, NULL, NULL}};
		GType tracker_store_task_type_type_id;
		tracker_store_task_type_type_id = g_enum_register_static ("TrackerStoreTaskType", values);
		g_once_init_leave (&tracker_store_task_type_type_id__volatile, tracker_store_task_type_type_id);
	}
	return tracker_store_task_type_type_id__volatile;
}


static gpointer _tracker_store_task_ref0 (gpointer self) {
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? tracker_store_task_ref (self) : NULL;
#line 529 "tracker-store.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return _data7_;
#line 538 "tracker-store.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data7_->query_task);
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_slice_free (Block7Data, _data7_);
#line 551 "tracker-store.c"
	}
}


static gboolean ____lambda4_ (Block7Data* _data7_) {
	gboolean result = FALSE;
	TrackerStoreQueryTask* _tmp0_;
	GCancellable* _tmp1_;
	TrackerStoreQueryTask* _tmp2_;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = _data7_->query_task;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tmp0_->cancellable;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_cancellable_cancel (_tmp1_);
#line 109 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = _data7_->query_task;
#line 109 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_->watchdog_id = (guint) 0;
#line 110 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 110 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 575 "tracker-store.c"
}


static gboolean _____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda4_ (self);
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 584 "tracker-store.c"
}


static void tracker_store_sched (void) {
	TrackerStoreTask* task;
	gboolean _tmp0_;
	gboolean _tmp23_;
	GError * _inner_error_ = NULL;
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	task = NULL;
#line 88 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = tracker_store_active;
#line 88 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!_tmp0_) {
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (task);
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 603 "tracker-store.c"
	}
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	while (TRUE) {
#line 607 "tracker-store.c"
		gint _tmp1_;
		TrackerStoreTask* _tmp9_;
		GPtrArray* _tmp10_;
		TrackerStoreTask* _tmp11_;
		TrackerStoreTask* _tmp12_;
		gint _tmp13_;
		gint _tmp19_;
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = tracker_store_n_queries_running;
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (!(_tmp1_ < TRACKER_STORE_MAX_CONCURRENT_QUERIES)) {
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			break;
#line 621 "tracker-store.c"
		}
		{
			gint i;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			i = 0;
#line 627 "tracker-store.c"
			{
				gboolean _tmp2_;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = TRUE;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 634 "tracker-store.c"
					gint _tmp4_;
					gint _tmp5_;
					GQueue* _tmp6_;
					gpointer _tmp7_;
					TrackerStoreTask* _tmp8_;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!_tmp2_) {
#line 642 "tracker-store.c"
						gint _tmp3_;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp3_ = i;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						i = _tmp3_ + 1;
#line 648 "tracker-store.c"
					}
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp2_ = FALSE;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp4_ = i;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp4_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 658 "tracker-store.c"
					}
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp5_ = i;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp6_ = tracker_store_query_queues[_tmp5_];
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp7_ = g_queue_pop_head (_tmp6_);
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (task);
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp7_;
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp8_ = task;
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp8_ != NULL) {
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 676 "tracker-store.c"
					}
				}
			}
		}
#line 99 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp9_ = task;
#line 99 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp9_ == NULL) {
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			break;
#line 687 "tracker-store.c"
		}
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp10_ = tracker_store_running_tasks;
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp11_ = task;
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp12_ = _tracker_store_task_ref0 (_tmp11_);
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_ptr_array_add (_tmp10_, _tmp12_);
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp13_ = tracker_store_max_task_time;
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp13_ != 0) {
#line 701 "tracker-store.c"
			Block7Data* _data7_;
			TrackerStoreTask* _tmp14_;
			TrackerStoreQueryTask* _tmp15_;
			TrackerStoreQueryTask* _tmp16_;
			gint _tmp17_;
			guint _tmp18_;
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_ = g_slice_new0 (Block7Data);
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_->_ref_count_ = 1;
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp14_ = task;
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp15_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask));
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_->query_task = _tmp15_;
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_ = _data7_->query_task;
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_ = tracker_store_max_task_time;
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp18_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp17_, _____lambda4__gsource_func, block7_data_ref (_data7_), block7_data_unref);
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_->watchdog_id = _tmp18_;
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			block7_data_unref (_data7_);
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_ = NULL;
#line 730 "tracker-store.c"
		}
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp19_ = tracker_store_n_queries_running;
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_n_queries_running = _tmp19_ + 1;
#line 736 "tracker-store.c"
		{
			GThreadPool* _tmp20_;
			TrackerStoreTask* _tmp21_;
			TrackerStoreTask* _tmp22_;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp20_ = tracker_store_query_pool;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp21_ = task;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp22_ = _tracker_store_task_ref0 (_tmp21_);
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_thread_pool_push (_tmp20_, _tmp22_, &_inner_error_);
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 751 "tracker-store.c"
				goto __catch18_g_error;
			}
		}
		goto __finally18;
		__catch18_g_error:
		{
			GError* e = NULL;
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			e = _inner_error_;
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_inner_error_ = NULL;
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (e);
#line 765 "tracker-store.c"
		}
		__finally18:
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tracker_store_task_unref0 (task);
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_clear_error (&_inner_error_);
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return;
#line 778 "tracker-store.c"
		}
	}
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp23_ = tracker_store_update_running;
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!_tmp23_) {
#line 785 "tracker-store.c"
		TrackerStoreTask* _tmp31_;
		{
			gint i;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			i = 0;
#line 791 "tracker-store.c"
			{
				gboolean _tmp24_;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp24_ = TRUE;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 798 "tracker-store.c"
					gint _tmp26_;
					gint _tmp27_;
					GQueue* _tmp28_;
					gpointer _tmp29_;
					TrackerStoreTask* _tmp30_;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!_tmp24_) {
#line 806 "tracker-store.c"
						gint _tmp25_;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp25_ = i;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						i = _tmp25_ + 1;
#line 812 "tracker-store.c"
					}
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp24_ = FALSE;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp26_ = i;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp26_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 822 "tracker-store.c"
					}
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp27_ = i;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_ = tracker_store_update_queues[_tmp27_];
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_ = g_queue_pop_head (_tmp28_);
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (task);
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp29_;
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp30_ = task;
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp30_ != NULL) {
#line 126 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 840 "tracker-store.c"
					}
				}
			}
		}
#line 129 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp31_ = task;
#line 129 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp31_ != NULL) {
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_update_running = TRUE;
#line 851 "tracker-store.c"
			{
				GThreadPool* _tmp32_;
				TrackerStoreTask* _tmp33_;
				TrackerStoreTask* _tmp34_;
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp32_ = tracker_store_update_pool;
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp33_ = task;
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp34_ = _tracker_store_task_ref0 (_tmp33_);
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_thread_pool_push (_tmp32_, _tmp34_, &_inner_error_);
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 866 "tracker-store.c"
					goto __catch19_g_error;
				}
			}
			goto __finally19;
			__catch19_g_error:
			{
				GError* e = NULL;
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				e = _inner_error_;
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_inner_error_ = NULL;
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (e);
#line 880 "tracker-store.c"
			}
			__finally19:
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (task);
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_clear_error (&_inner_error_);
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return;
#line 893 "tracker-store.c"
			}
		}
	}
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (task);
#line 899 "tracker-store.c"
}


static TrackerDataCommitType tracker_store_commit_type (TrackerStoreTask* task) {
	TrackerDataCommitType result = 0;
	TrackerStoreTask* _tmp0_;
	TrackerStoreTaskType _tmp1_;
#line 140 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (task != NULL, 0);
#line 141 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = task;
#line 141 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tmp0_->type;
#line 141 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_tmp1_) {
#line 141 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_UPDATE:
#line 141 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_UPDATE_BLANK:
#line 919 "tracker-store.c"
		{
			TrackerStoreTask* _tmp2_;
			TrackerStorePriority _tmp3_;
#line 144 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp2_ = task;
#line 144 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask)->priority;
#line 144 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp3_ == TRACKER_STORE_PRIORITY_HIGH) {
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_REGULAR;
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 933 "tracker-store.c"
			} else {
				GQueue* _tmp4_;
				guint _tmp5_;
#line 146 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_LOW];
#line 146 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = g_queue_get_length (_tmp4_);
#line 146 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp5_ > ((guint) 0)) {
#line 147 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					result = TRACKER_DATA_COMMIT_BATCH;
#line 147 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					return result;
#line 947 "tracker-store.c"
				} else {
#line 149 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					result = TRACKER_DATA_COMMIT_BATCH_LAST;
#line 149 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					return result;
#line 953 "tracker-store.c"
				}
			}
		}
#line 141 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_TURTLE:
#line 959 "tracker-store.c"
		{
			GQueue* _tmp6_;
			guint _tmp7_;
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_TURTLE];
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp7_ = g_queue_get_length (_tmp6_);
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp7_ > ((guint) 0)) {
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_BATCH;
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 973 "tracker-store.c"
			} else {
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_BATCH_LAST;
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 979 "tracker-store.c"
			}
		}
		default:
		{
#line 158 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_warn_if_reached ();
#line 159 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			result = TRACKER_DATA_COMMIT_REGULAR;
#line 159 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return result;
#line 990 "tracker-store.c"
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_error_copy (self) : NULL;
#line 999 "tracker-store.c"
}


static gboolean tracker_store_task_finish_cb (TrackerStoreTask* task) {
	gboolean result = FALSE;
	TrackerStoreTask* _tmp0_;
	TrackerStoreTaskType _tmp1_;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gint _tmp40_;
	GError * _inner_error_ = NULL;
#line 163 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (task != NULL, FALSE);
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = task;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tmp0_->type;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp1_ == TRACKER_STORE_TASK_TYPE_QUERY) {
#line 1019 "tracker-store.c"
		TrackerStoreQueryTask* query_task;
		TrackerStoreTask* _tmp2_;
		TrackerStoreQueryTask* _tmp3_;
		TrackerStoreTask* _tmp4_;
		GError* _tmp5_;
		TrackerStoreTask* _tmp11_;
		GSourceFunc _tmp12_;
		void* _tmp12__target;
		TrackerStoreTask* _tmp13_;
		GPtrArray* _tmp14_;
		TrackerStoreTask* _tmp15_;
		gint _tmp16_;
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp2_ = task;
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp3_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask));
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		query_task = _tmp3_;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp4_ = task;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp5_ = _tmp4_->error;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp5_ == NULL) {
#line 1044 "tracker-store.c"
			{
				TrackerStoreQueryTask* _tmp6_;
				GCancellable* _tmp7_;
#line 169 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = query_task;
#line 169 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = _tmp6_->cancellable;
#line 169 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_cancellable_set_error_if_cancelled (_tmp7_, &_inner_error_);
#line 169 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1056 "tracker-store.c"
					goto __catch20_g_error;
				}
			}
			goto __finally20;
			__catch20_g_error:
			{
				GError* e = NULL;
				TrackerStoreTask* _tmp8_;
				GError* _tmp9_;
				GError* _tmp10_;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				e = _inner_error_;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_inner_error_ = NULL;
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = task;
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = e;
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp10_ = _g_error_copy0 (_tmp9_);
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (_tmp8_->error);
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_->error = _tmp10_;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (e);
#line 1083 "tracker-store.c"
			}
			__finally20:
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (query_task);
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_clear_error (&_inner_error_);
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return FALSE;
#line 1096 "tracker-store.c"
			}
		}
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp11_ = task;
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp12_ = _tmp11_->callback;
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp12__target = _tmp11_->callback_target;
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp12_ (_tmp12__target);
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp13_ = task;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (_tmp13_->error);
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp13_->error = NULL;
#line 178 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp14_ = tracker_store_running_tasks;
#line 178 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp15_ = task;
#line 178 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_ptr_array_remove (_tmp14_, _tmp15_);
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp16_ = tracker_store_n_queries_running;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_n_queries_running = _tmp16_ - 1;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (query_task);
#line 1125 "tracker-store.c"
	} else {
		gboolean _tmp17_ = FALSE;
		TrackerStoreTask* _tmp18_;
		TrackerStoreTaskType _tmp19_;
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp18_ = task;
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp19_ = _tmp18_->type;
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp19_ == TRACKER_STORE_TASK_TYPE_UPDATE) {
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_ = TRUE;
#line 1138 "tracker-store.c"
		} else {
			TrackerStoreTask* _tmp20_;
			TrackerStoreTaskType _tmp21_;
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp20_ = task;
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp21_ = _tmp20_->type;
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_ = _tmp21_ == TRACKER_STORE_TASK_TYPE_UPDATE_BLANK;
#line 1148 "tracker-store.c"
		}
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp17_) {
#line 1152 "tracker-store.c"
			TrackerStoreTask* _tmp22_;
			GError* _tmp23_;
			TrackerStoreTask* _tmp26_;
			GSourceFunc _tmp27_;
			void* _tmp27__target;
			TrackerStoreTask* _tmp28_;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp22_ = task;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp23_ = _tmp22_->error;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp23_ == NULL) {
#line 1165 "tracker-store.c"
				TrackerStoreTask* _tmp24_;
				TrackerDataCommitType _tmp25_;
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp24_ = task;
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp25_ = tracker_store_commit_type (_tmp24_);
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_data_notify_transaction (_tmp25_);
#line 1174 "tracker-store.c"
			}
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp26_ = task;
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp27_ = _tmp26_->callback;
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp27__target = _tmp26_->callback_target;
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp27_ (_tmp27__target);
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp28_ = task;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (_tmp28_->error);
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp28_->error = NULL;
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_update_running = FALSE;
#line 1192 "tracker-store.c"
		} else {
			TrackerStoreTask* _tmp29_;
			TrackerStoreTaskType _tmp30_;
#line 189 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp29_ = task;
#line 189 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp30_ = _tmp29_->type;
#line 189 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp30_ == TRACKER_STORE_TASK_TYPE_TURTLE) {
#line 1202 "tracker-store.c"
				TrackerStoreTask* _tmp31_;
				GError* _tmp32_;
				TrackerStoreTask* _tmp35_;
				GSourceFunc _tmp36_;
				void* _tmp36__target;
				TrackerStoreTask* _tmp37_;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp31_ = task;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp32_ = _tmp31_->error;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp32_ == NULL) {
#line 1215 "tracker-store.c"
					TrackerStoreTask* _tmp33_;
					TrackerDataCommitType _tmp34_;
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp33_ = task;
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp34_ = tracker_store_commit_type (_tmp33_);
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					tracker_data_notify_transaction (_tmp34_);
#line 1224 "tracker-store.c"
				}
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp35_ = task;
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp36_ = _tmp35_->callback;
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp36__target = _tmp35_->callback_target;
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp36_ (_tmp36__target);
#line 195 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp37_ = task;
#line 195 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (_tmp37_->error);
#line 195 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp37_->error = NULL;
#line 197 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_running = FALSE;
#line 1242 "tracker-store.c"
			}
		}
	}
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp40_ = tracker_store_n_queries_running;
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp40_ == 0) {
#line 1250 "tracker-store.c"
		gboolean _tmp41_;
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp41_ = tracker_store_update_running;
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp39_ = !_tmp41_;
#line 1256 "tracker-store.c"
	} else {
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp39_ = FALSE;
#line 1260 "tracker-store.c"
	}
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp39_) {
#line 1264 "tracker-store.c"
		GSourceFunc _tmp42_;
		void* _tmp42__target;
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp42_ = tracker_store_active_callback;
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp42__target = tracker_store_active_callback_target;
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp38_ = _tmp42_ != NULL;
#line 1273 "tracker-store.c"
	} else {
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp38_ = FALSE;
#line 1277 "tracker-store.c"
	}
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp38_) {
#line 1281 "tracker-store.c"
		GSourceFunc _tmp43_;
		void* _tmp43__target;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp43_ = tracker_store_active_callback;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp43__target = tracker_store_active_callback_target;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp43_ (_tmp43__target);
#line 1290 "tracker-store.c"
	}
#line 204 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 206 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 206 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1298 "tracker-store.c"
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return _data8_;
#line 1307 "tracker-store.c"
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data8_->task);
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_slice_free (Block8Data, _data8_);
#line 1320 "tracker-store.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 218 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 1328 "tracker-store.c"
}


static void _tracker_store_wal_hook_tracker_db_wal_callback (gint n_pages) {
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_wal_hook (n_pages);
#line 1335 "tracker-store.c"
}


static gboolean __lambda5_ (Block8Data* _data8_) {
	gboolean result = FALSE;
	TrackerStoreTask* _tmp0_;
#line 247 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = _data8_->task;
#line 247 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_task_finish_cb (_tmp0_);
#line 248 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 248 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1350 "tracker-store.c"
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ (self);
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1359 "tracker-store.c"
}


static void tracker_store_pool_dispatch_cb (TrackerStoreTask* task) {
	Block8Data* _data8_;
	TrackerStoreTask* _tmp0_;
	GError * _inner_error_ = NULL;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (task != NULL);
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_->_ref_count_ = 1;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = task;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data8_->task);
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_->task = _tmp0_;
#line 1379 "tracker-store.c"
	{
		TrackerStoreTask* _tmp1_;
		TrackerStoreTaskType _tmp2_;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = _data8_->task;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp2_ = _tmp1_->type;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp2_ == TRACKER_STORE_TASK_TYPE_QUERY) {
#line 1389 "tracker-store.c"
			TrackerStoreQueryTask* query_task;
			TrackerStoreTask* _tmp3_;
			TrackerStoreQueryTask* _tmp4_;
			TrackerDBCursor* cursor;
			TrackerStoreQueryTask* _tmp5_;
			const gchar* _tmp6_;
			TrackerDBCursor* _tmp7_;
			TrackerStoreQueryTask* _tmp8_;
			TrackerStoreSparqlQueryInThread _tmp9_;
			void* _tmp9__target;
			TrackerDBCursor* _tmp10_;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp3_ = _data8_->task;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp4_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask));
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			query_task = _tmp4_;
#line 214 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp5_ = query_task;
#line 214 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = _tmp5_->query;
#line 214 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp7_ = tracker_data_query_sparql_cursor (_tmp6_, &_inner_error_);
#line 214 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			cursor = _tmp7_;
#line 214 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 214 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (query_task);
#line 1419 "tracker-store.c"
				goto __catch21_g_error;
			}
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp8_ = query_task;
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp9_ = _tmp8_->in_thread;
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp9__target = _tmp8_->in_thread_target;
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp10_ = cursor;
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp9_ (_tmp10_, _tmp9__target, &_inner_error_);
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_object_unref0 (cursor);
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (query_task);
#line 1438 "tracker-store.c"
				goto __catch21_g_error;
			}
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (cursor);
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tracker_store_task_unref0 (query_task);
#line 1445 "tracker-store.c"
		} else {
			TrackerDBInterface* iface;
			TrackerDBInterface* _tmp11_;
			TrackerDBInterface* _tmp12_;
			TrackerDBInterface* _tmp13_;
			TrackerStoreTask* _tmp14_;
			TrackerStoreTaskType _tmp15_;
#line 218 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp11_ = tracker_db_manager_get_db_interface ();
#line 218 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp12_ = _g_object_ref0 (_tmp11_);
#line 218 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			iface = _tmp12_;
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp13_ = iface;
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_db_interface_sqlite_wal_hook (_tmp13_, _tracker_store_wal_hook_tracker_db_wal_callback);
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp14_ = _data8_->task;
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp15_ = _tmp14_->type;
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp15_ == TRACKER_STORE_TASK_TYPE_UPDATE) {
#line 1469 "tracker-store.c"
				TrackerStoreUpdateTask* update_task;
				TrackerStoreTask* _tmp16_;
				TrackerStoreUpdateTask* _tmp17_;
				TrackerStoreUpdateTask* _tmp18_;
				const gchar* _tmp19_;
#line 222 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp16_ = _data8_->task;
#line 222 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp17_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask));
#line 222 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				update_task = _tmp17_;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp18_ = update_task;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp19_ = _tmp18_->query;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_data_update_sparql (_tmp19_, &_inner_error_);
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (update_task);
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_object_unref0 (iface);
#line 1493 "tracker-store.c"
					goto __catch21_g_error;
				}
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (update_task);
#line 1498 "tracker-store.c"
			} else {
				TrackerStoreTask* _tmp20_;
				TrackerStoreTaskType _tmp21_;
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp20_ = _data8_->task;
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp21_ = _tmp20_->type;
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp21_ == TRACKER_STORE_TASK_TYPE_UPDATE_BLANK) {
#line 1508 "tracker-store.c"
					TrackerStoreUpdateTask* update_task;
					TrackerStoreTask* _tmp22_;
					TrackerStoreUpdateTask* _tmp23_;
					GVariant* _tmp24_;
					TrackerStoreUpdateTask* _tmp25_;
					const gchar* _tmp26_;
					GVariant* _tmp27_;
					TrackerStoreUpdateTask* _tmp28_;
					GVariant* _tmp29_;
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp22_ = _data8_->task;
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp23_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask));
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					update_task = _tmp23_;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp25_ = update_task;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp26_ = _tmp25_->query;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp27_ = tracker_data_update_sparql_blank (_tmp26_, &_inner_error_);
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp24_ = _tmp27_;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tracker_store_task_unref0 (update_task);
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_object_unref0 (iface);
#line 1538 "tracker-store.c"
						goto __catch21_g_error;
					}
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_ = update_task;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_ = _tmp24_;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp24_ = NULL;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_variant_unref0 (_tmp28_->blank_nodes);
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_->blank_nodes = _tmp29_;
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_variant_unref0 (_tmp24_);
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (update_task);
#line 1555 "tracker-store.c"
				} else {
					TrackerStoreTask* _tmp30_;
					TrackerStoreTaskType _tmp31_;
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp30_ = _data8_->task;
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp31_ = _tmp30_->type;
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp31_ == TRACKER_STORE_TASK_TYPE_TURTLE) {
#line 1565 "tracker-store.c"
						TrackerStoreTurtleTask* turtle_task;
						TrackerStoreTask* _tmp32_;
						TrackerStoreTurtleTask* _tmp33_;
						GFile* file;
						TrackerStoreTurtleTask* _tmp34_;
						const gchar* _tmp35_;
						GFile* _tmp36_;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp32_ = _data8_->task;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp33_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTask));
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						turtle_task = _tmp33_;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp34_ = turtle_task;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp35_ = _tmp34_->path;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp36_ = g_file_new_for_path (_tmp35_);
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						file = _tmp36_;
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						tracker_events_freeze ();
#line 1589 "tracker-store.c"
						{
							GFile* _tmp37_;
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_tmp37_ = file;
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							tracker_data_load_turtle_file (_tmp37_, &_inner_error_);
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1598 "tracker-store.c"
								goto __finally22;
							}
						}
						__finally22:
						{
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							tracker_events_reset_pending ();
#line 1606 "tracker-store.c"
						}
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_g_object_unref0 (file);
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_tracker_store_task_unref0 (turtle_task);
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_g_object_unref0 (iface);
#line 1616 "tracker-store.c"
							goto __catch21_g_error;
						}
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_object_unref0 (file);
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tracker_store_task_unref0 (turtle_task);
#line 1623 "tracker-store.c"
					}
				}
			}
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (iface);
#line 1629 "tracker-store.c"
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		TrackerStoreTask* _tmp38_;
		GError* _tmp39_;
		GError* _tmp40_;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp38_ = _data8_->task;
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp39_ = e;
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp40_ = _g_error_copy0 (_tmp39_);
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (_tmp38_->error);
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp38_->error = _tmp40_;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 1655 "tracker-store.c"
	}
	__finally21:
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		block8_data_unref (_data8_);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data8_ = NULL;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 1670 "tracker-store.c"
	}
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, block8_data_ref (_data8_), block8_data_unref);
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	block8_data_unref (_data8_);
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_ = NULL;
#line 1678 "tracker-store.c"
}


void tracker_store_wal_checkpoint (void) {
	GError * _inner_error_ = NULL;
	{
		TrackerDBInterface* iface;
		TrackerDBInterface* _tmp0_;
		TrackerDBInterface* _tmp1_;
#line 254 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_debug ("Checkpointing database...");
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp0_ = tracker_db_manager_get_db_interface ();
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		iface = _tmp1_;
#line 256 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_db_interface_execute_query (iface, &_inner_error_, "PRAGMA wal_checkpoint");
#line 256 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 256 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (iface);
#line 1702 "tracker-store.c"
			goto __catch23_g_error;
		}
#line 257 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_debug ("Checkpointing complete...");
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_object_unref0 (iface);
#line 1709 "tracker-store.c"
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp2_ = e;
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp3_ = _tmp2_->message;
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_warning ("%s", _tmp3_);
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 1729 "tracker-store.c"
	}
	__finally23:
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 1740 "tracker-store.c"
	}
}


static void tracker_store_wal_hook (gint n_pages) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
#line 268 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = n_pages;
#line 268 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_debug ("WAL: %d pages", _tmp0_);
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = n_pages;
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp1_ >= 10000) {
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_wal_checkpoint ();
#line 1759 "tracker-store.c"
	} else {
		gint _tmp2_;
#line 274 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp2_ = n_pages;
#line 274 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp2_ >= 1000) {
#line 1766 "tracker-store.c"
			gboolean _tmp3_;
#line 275 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp3_ = g_atomic_int_compare_and_exchange ((volatile gint *) (&tracker_store_checkpointing), 0, 1);
#line 275 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp3_) {
#line 1772 "tracker-store.c"
				{
					GThreadPool* _tmp4_;
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp4_ = tracker_store_checkpoint_pool;
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_thread_pool_push (_tmp4_, (gpointer) ((gintptr) TRUE), &_inner_error_);
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1781 "tracker-store.c"
						goto __catch24_g_error;
					}
				}
				goto __finally24;
				__catch24_g_error:
				{
					GError* e = NULL;
					GError* _tmp5_;
					const gchar* _tmp6_;
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					e = _inner_error_;
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_inner_error_ = NULL;
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp5_ = e;
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp6_ = _tmp5_->message;
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_warning ("%s", _tmp6_);
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_atomic_int_set ((volatile gint *) (&tracker_store_checkpointing), 0);
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_error_free0 (e);
#line 1805 "tracker-store.c"
				}
				__finally24:
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_clear_error (&_inner_error_);
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					return;
#line 1816 "tracker-store.c"
				}
			}
		}
	}
}


static void tracker_store_checkpoint_dispatch_cb (gboolean task) {
#line 290 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_wal_checkpoint ();
#line 291 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_set ((volatile gint *) (&tracker_store_checkpointing), 0);
#line 1829 "tracker-store.c"
}


static void _tracker_store_task_unref0_ (gpointer var) {
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(var == NULL) ? NULL : (var = (tracker_store_task_unref (var), NULL));
#line 1836 "tracker-store.c"
}


static void _g_queue_free__tracker_store_task_unref0_ (GQueue* self) {
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_foreach (self, (GFunc) _tracker_store_task_unref0_, NULL);
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_free (self);
#line 1845 "tracker-store.c"
}


static void _tracker_store_pool_dispatch_cb_gfunc (gpointer data, gpointer self) {
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_pool_dispatch_cb ((TrackerStoreTask*) data);
#line 1852 "tracker-store.c"
}


static void _tracker_store_checkpoint_dispatch_cb_gfunc (gpointer data, gpointer self) {
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_checkpoint_dispatch_cb ((gboolean) ((gintptr) data));
#line 1859 "tracker-store.c"
}


void tracker_store_init (void) {
	gchar* max_task_time_env;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GPtrArray* _tmp5_;
	GError * _inner_error_ = NULL;
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = g_getenv ("TRACKER_STORE_MAX_TASK_TIME");
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	max_task_time_env = _tmp1_;
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = max_task_time_env;
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp2_ != NULL) {
#line 1880 "tracker-store.c"
		const gchar* _tmp3_;
		gint _tmp4_;
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp3_ = max_task_time_env;
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp4_ = atoi (_tmp3_);
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_max_task_time = _tmp4_;
#line 1889 "tracker-store.c"
	} else {
#line 299 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_max_task_time = TRACKER_STORE_MAX_TASK_TIME;
#line 1893 "tracker-store.c"
	}
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp5_ = g_ptr_array_new_full ((guint) 0, _tracker_store_task_unref0_);
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_ptr_array_unref0 (tracker_store_running_tasks);
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_running_tasks = _tmp5_;
#line 1901 "tracker-store.c"
	{
		gint i;
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 1906 "tracker-store.c"
		{
			gboolean _tmp6_;
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = TRUE;
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 1913 "tracker-store.c"
				gint _tmp8_;
				gint _tmp9_;
				GQueue* _tmp10_;
				GQueue* _tmp11_;
				gint _tmp12_;
				GQueue* _tmp13_;
				GQueue* _tmp14_;
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp6_) {
#line 1923 "tracker-store.c"
					gint _tmp7_;
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp7_ = i;
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp7_ + 1;
#line 1929 "tracker-store.c"
				}
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = FALSE;
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = i;
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp8_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 1939 "tracker-store.c"
				}
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = i;
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp10_ = g_queue_new ();
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_query_queues[_tmp9_]);
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_query_queues[_tmp9_] = _tmp10_;
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp11_ = tracker_store_query_queues[_tmp9_];
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp12_ = i;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp13_ = g_queue_new ();
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_update_queues[_tmp12_]);
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_queues[_tmp12_] = _tmp13_;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp14_ = tracker_store_update_queues[_tmp12_];
#line 1961 "tracker-store.c"
			}
		}
	}
	{
		GThreadPool* _tmp15_;
		GThreadPool* _tmp16_;
		GThreadPool* _tmp17_;
		GThreadPool* _tmp18_;
		GThreadPool* _tmp19_;
		GThreadPool* _tmp20_;
		GThreadPool* _tmp21_;
		GThreadPool* _tmp22_;
		GThreadPool* _tmp23_;
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp16_ = g_thread_pool_new (_tracker_store_pool_dispatch_cb_gfunc, NULL, 1, TRUE, &_inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp15_ = _tmp16_;
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1981 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp17_ = _tmp15_;
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp15_ = NULL;
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_update_pool);
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_update_pool = _tmp17_;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp19_ = g_thread_pool_new (_tracker_store_pool_dispatch_cb_gfunc, NULL, TRACKER_STORE_MAX_CONCURRENT_QUERIES, TRUE, &_inner_error_);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp18_ = _tmp19_;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_tmp15_);
#line 2000 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp20_ = _tmp18_;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp18_ = NULL;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_query_pool);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_query_pool = _tmp20_;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp22_ = g_thread_pool_new (_tracker_store_checkpoint_dispatch_cb_gfunc, NULL, 1, TRUE, &_inner_error_);
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp21_ = _tmp22_;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_tmp18_);
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_tmp15_);
#line 2021 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp23_ = _tmp21_;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp21_ = NULL;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_checkpoint_pool = _tmp23_;
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (_tmp21_);
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (_tmp18_);
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (_tmp15_);
#line 2038 "tracker-store.c"
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp24_ = e;
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp25_ = _tmp24_->message;
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_warning ("%s", _tmp25_);
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 2058 "tracker-store.c"
	}
	__finally25:
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_free (max_task_time_env);
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2071 "tracker-store.c"
	}
#line 320 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_thread_pool_set_max_idle_time ((guint) (15 * 1000));
#line 321 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_thread_pool_set_max_unused_threads (2);
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (max_task_time_env);
#line 2079 "tracker-store.c"
}


void tracker_store_shutdown (void) {
#line 325 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_query_pool);
#line 325 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_query_pool = NULL;
#line 326 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_update_pool);
#line 326 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_update_pool = NULL;
#line 327 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 327 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_checkpoint_pool = NULL;
#line 2096 "tracker-store.c"
	{
		gint i;
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 2101 "tracker-store.c"
		{
			gboolean _tmp0_;
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 2108 "tracker-store.c"
				gint _tmp2_;
				gint _tmp3_;
				GQueue* _tmp4_;
				gint _tmp5_;
				GQueue* _tmp6_;
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp0_) {
#line 2116 "tracker-store.c"
					gint _tmp1_;
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp1_ = i;
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp1_ + 1;
#line 2122 "tracker-store.c"
				}
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = i;
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp2_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 2132 "tracker-store.c"
				}
#line 330 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = i;
#line 330 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_query_queues[_tmp3_]);
#line 330 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_query_queues[_tmp3_] = NULL;
#line 330 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = tracker_store_query_queues[_tmp3_];
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = i;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_update_queues[_tmp5_]);
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_queues[_tmp5_] = NULL;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = tracker_store_update_queues[_tmp5_];
#line 2150 "tracker-store.c"
			}
		}
	}
}


static void tracker_store_sparql_query_data_free (gpointer _data) {
	TrackerStoreSparqlQueryData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlQueryData, _data_);
#line 2166 "tracker-store.c"
}


void tracker_store_sparql_query (const gchar* sparql, TrackerStorePriority priority, TrackerStoreSparqlQueryInThread in_thread, void* in_thread_target, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlQueryData* _data_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	TrackerStorePriority _tmp2_;
	TrackerStoreSparqlQueryInThread _tmp3_;
	void* _tmp3__target;
	const gchar* _tmp4_;
	gchar* _tmp5_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlQueryData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_query_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = sparql;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = priority;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = in_thread;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3__target = in_thread_target;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->in_thread = _tmp3_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->in_thread_target = _tmp3__target;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = client_id;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp5_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_query_co (_data_);
#line 2215 "tracker-store.c"
}


void tracker_store_sparql_query_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreSparqlQueryData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2227 "tracker-store.c"
	}
}


static gboolean _tracker_store_sparql_query_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_query_co (self);
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2237 "tracker-store.c"
}


static gboolean tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* _data_) {
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2246 "tracker-store.c"
		goto _state_0;
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2250 "tracker-store.c"
		goto _state_1;
		default:
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2255 "tracker-store.c"
	}
	_state_0:
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_query_task_new ();
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_QUERY;
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->sparql;
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->_tmp2_->query);
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp4_;
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = g_cancellable_new ();
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->_tmp5_->cancellable);
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_->cancellable = _data_->_tmp6_;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->task;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->in_thread;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8__target = _data_->in_thread_target;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_->in_thread = _data_->_tmp8_;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_->in_thread_target = _data_->_tmp8__target;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _data_->task;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp9_)->callback_target), NULL);
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback = NULL;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target = NULL;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify = NULL;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback = _tracker_store_sparql_query_co_gsource_func;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target = _data_;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify = NULL;
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = _data_->task;
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _data_->client_id;
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (((TrackerStoreTask*) _data_->_tmp10_)->client_id);
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp10_)->client_id = _data_->_tmp12_;
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _data_->priority;
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = tracker_store_query_queues[_data_->_tmp13_];
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = _data_->task;
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp15_);
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp14_, _data_->_tmp16_);
#line 346 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 348 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 348 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2336 "tracker-store.c"
	_state_1:
	;
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp17_ = _data_->task;
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp18_ = ((TrackerStoreTask*) _data_->_tmp17_)->error;
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp18_ != NULL) {
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp19_ = _data_->task;
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp20_ = ((TrackerStoreTask*) _data_->_tmp19_)->error;
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp21_ = _g_error_copy0 (_data_->_tmp20_);
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp21_;
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2361 "tracker-store.c"
	}
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2373 "tracker-store.c"
		}
	}
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2380 "tracker-store.c"
}


static void tracker_store_sparql_update_data_free (gpointer _data) {
	TrackerStoreSparqlUpdateData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlUpdateData, _data_);
#line 2393 "tracker-store.c"
}


void tracker_store_sparql_update (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlUpdateData* _data_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	TrackerStorePriority _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_update_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = sparql;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = priority;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = client_id;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_update_co (_data_);
#line 2432 "tracker-store.c"
}


void tracker_store_sparql_update_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreSparqlUpdateData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2444 "tracker-store.c"
	}
}


static gboolean _tracker_store_sparql_update_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_update_co (self);
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2454 "tracker-store.c"
}


static gboolean tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* _data_) {
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2463 "tracker-store.c"
		goto _state_0;
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2467 "tracker-store.c"
		goto _state_1;
		default:
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2472 "tracker-store.c"
	}
	_state_0:
#line 356 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_update_task_new ();
#line 356 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_UPDATE;
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->sparql;
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->_tmp2_->query);
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp4_;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->priority;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_->priority = _data_->_tmp6_;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->task;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp7_)->callback_target), NULL);
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = NULL;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = NULL;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = _tracker_store_sparql_update_co_gsource_func;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = _data_;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->task;
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _data_->client_id;
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (((TrackerStoreTask*) _data_->_tmp8_)->client_id);
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp8_)->client_id = _data_->_tmp10_;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _data_->priority;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = tracker_store_update_queues[_data_->_tmp11_];
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _data_->task;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp13_);
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp12_, _data_->_tmp14_);
#line 365 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2541 "tracker-store.c"
	_state_1:
	;
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = _data_->task;
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = ((TrackerStoreTask*) _data_->_tmp15_)->error;
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp16_ != NULL) {
#line 370 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp17_ = _data_->task;
#line 370 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp18_ = ((TrackerStoreTask*) _data_->_tmp17_)->error;
#line 370 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp19_ = _g_error_copy0 (_data_->_tmp18_);
#line 370 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp19_;
#line 370 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 370 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 370 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 370 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2566 "tracker-store.c"
	}
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2578 "tracker-store.c"
		}
	}
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2585 "tracker-store.c"
}


static void tracker_store_sparql_update_blank_data_free (gpointer _data) {
	TrackerStoreSparqlUpdateBlankData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_variant_unref0 (_data_->result);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlUpdateBlankData, _data_);
#line 2600 "tracker-store.c"
}


void tracker_store_sparql_update_blank (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlUpdateBlankData* _data_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	TrackerStorePriority _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateBlankData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_update_blank_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = sparql;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = priority;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = client_id;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_update_blank_co (_data_);
#line 2639 "tracker-store.c"
}


GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerStoreSparqlUpdateBlankData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return NULL;
#line 2652 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = _data_->result;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->result = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2660 "tracker-store.c"
}


static gboolean _tracker_store_sparql_update_blank_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_update_blank_co (self);
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2669 "tracker-store.c"
}


static gpointer _g_variant_ref0 (gpointer self) {
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_variant_ref (self) : NULL;
#line 2676 "tracker-store.c"
}


static gboolean tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* _data_) {
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2685 "tracker-store.c"
		goto _state_0;
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2689 "tracker-store.c"
		goto _state_1;
		default:
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2694 "tracker-store.c"
	}
	_state_0:
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_update_task_new ();
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_UPDATE_BLANK;
#line 377 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 377 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->sparql;
#line 377 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 377 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->_tmp2_->query);
#line 377 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp4_;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->priority;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_->priority = _data_->_tmp6_;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->task;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp7_)->callback_target), NULL);
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = NULL;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = NULL;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = _tracker_store_sparql_update_blank_co_gsource_func;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = _data_;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 380 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->task;
#line 380 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _data_->client_id;
#line 380 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
#line 380 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (((TrackerStoreTask*) _data_->_tmp8_)->client_id);
#line 380 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp8_)->client_id = _data_->_tmp10_;
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _data_->priority;
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = tracker_store_update_queues[_data_->_tmp11_];
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _data_->task;
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp13_);
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp12_, _data_->_tmp14_);
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 386 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 386 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2763 "tracker-store.c"
	_state_1:
	;
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = _data_->task;
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = ((TrackerStoreTask*) _data_->_tmp15_)->error;
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp16_ != NULL) {
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp17_ = _data_->task;
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp18_ = ((TrackerStoreTask*) _data_->_tmp17_)->error;
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp19_ = _g_error_copy0 (_data_->_tmp18_);
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp19_;
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2788 "tracker-store.c"
	}
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp20_ = _data_->task;
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp21_ = _data_->_tmp20_->blank_nodes;
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp22_ = _g_variant_ref0 (_data_->_tmp21_);
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->result = _data_->_tmp22_;
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2808 "tracker-store.c"
		}
	}
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2825 "tracker-store.c"
		}
	}
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2832 "tracker-store.c"
}


static void tracker_store_queue_turtle_import_data_free (gpointer _data) {
	TrackerStoreQueueTurtleImportData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->file);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreQueueTurtleImportData, _data_);
#line 2845 "tracker-store.c"
}


void tracker_store_queue_turtle_import (GFile* file, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreQueueTurtleImportData* _data_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreQueueTurtleImportData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_queue_turtle_import_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = file;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->file);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->file = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = client_id;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp3_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_queue_turtle_import_co (_data_);
#line 2879 "tracker-store.c"
}


void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreQueueTurtleImportData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2891 "tracker-store.c"
	}
}


static gboolean _tracker_store_queue_turtle_import_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_queue_turtle_import_co (self);
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2901 "tracker-store.c"
}


static gboolean tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* _data_) {
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2910 "tracker-store.c"
		goto _state_0;
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2914 "tracker-store.c"
		goto _state_1;
		default:
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2919 "tracker-store.c"
	}
	_state_0:
#line 396 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_turtle_task_new ();
#line 396 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_TURTLE;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->file;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_file_get_path (_data_->_tmp3_);
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (_data_->_tmp2_->path);
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->path = _data_->_tmp4_;
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp5_)->callback_target), NULL);
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback = NULL;
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target = NULL;
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify = NULL;
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback = _tracker_store_queue_turtle_import_co_gsource_func;
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target = _data_;
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify = NULL;
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->task;
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->client_id;
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (((TrackerStoreTask*) _data_->_tmp6_)->client_id);
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp6_)->client_id = _data_->_tmp8_;
#line 402 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_TURTLE];
#line 402 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = _data_->task;
#line 402 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp10_);
#line 402 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp9_, _data_->_tmp11_);
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2980 "tracker-store.c"
	_state_1:
	;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = _data_->task;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = ((TrackerStoreTask*) _data_->_tmp12_)->error;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp13_ != NULL) {
#line 409 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp14_ = _data_->task;
#line 409 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp15_ = ((TrackerStoreTask*) _data_->_tmp14_)->error;
#line 409 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
#line 409 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp16_;
#line 409 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 409 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 409 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 409 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 3005 "tracker-store.c"
	}
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3017 "tracker-store.c"
		}
	}
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 3024 "tracker-store.c"
}


guint tracker_store_get_queue_size (TrackerStore* self) {
	guint result = 0U;
	guint _result_;
#line 413 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 414 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_result_ = (guint) 0;
#line 3035 "tracker-store.c"
	{
		gint i;
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3040 "tracker-store.c"
		{
			gboolean _tmp0_;
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3047 "tracker-store.c"
				gint _tmp2_;
				guint _tmp3_;
				gint _tmp4_;
				GQueue* _tmp5_;
				guint _tmp6_;
				guint _tmp7_;
				gint _tmp8_;
				GQueue* _tmp9_;
				guint _tmp10_;
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp0_) {
#line 3059 "tracker-store.c"
					gint _tmp1_;
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp1_ = i;
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp1_ + 1;
#line 3065 "tracker-store.c"
				}
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = i;
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp2_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3075 "tracker-store.c"
				}
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = _result_;
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = i;
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = tracker_store_query_queues[_tmp4_];
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = g_queue_get_length (_tmp5_);
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_result_ = _tmp3_ + _tmp6_;
#line 418 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = _result_;
#line 418 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = i;
#line 418 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = tracker_store_update_queues[_tmp8_];
#line 418 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp10_ = g_queue_get_length (_tmp9_);
#line 418 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_result_ = _tmp7_ + _tmp10_;
#line 3097 "tracker-store.c"
			}
		}
	}
#line 420 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = _result_;
#line 420 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 3105 "tracker-store.c"
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
#line 4926 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 4926 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = self->len;
#line 4926 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 4926 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 3120 "tracker-store.c"
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
#line 4927 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 4927 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = value;
#line 4927 "/home/carlos/Build/gnome/share/vala-0.36/vapi/glib-2.0.vapi"
	g_ptr_array_set_size (self, _tmp0_);
#line 3132 "tracker-store.c"
}


void tracker_store_unreg_batches (const gchar* client_id) {
	GList* list = NULL;
	GList* cur = NULL;
	GQueue* queue = NULL;
#line 423 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (client_id != NULL);
#line 3142 "tracker-store.c"
	{
		gint i;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3147 "tracker-store.c"
		{
			gboolean _tmp0_;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3154 "tracker-store.c"
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				TrackerStoreQueryTask* task;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				TrackerStoreTask* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				TrackerStoreQueryTask* _tmp12_;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp0_) {
#line 3169 "tracker-store.c"
					gint _tmp1_;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp1_ = i;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp1_ + 1;
#line 3175 "tracker-store.c"
				}
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = i;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = tracker_store_running_tasks;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = _tmp4_;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3191 "tracker-store.c"
				}
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = tracker_store_running_tasks;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = i;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = (TrackerStoreTask*) _tmp8_;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				task = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TRACKER_STORE_TYPE_QUERY_TASK) ? ((TrackerStoreQueryTask*) _tmp9_) : NULL;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp12_ = task;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp12_ != NULL) {
#line 3207 "tracker-store.c"
					TrackerStoreQueryTask* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp13_ = task;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp14_ = ((TrackerStoreTask*) _tmp13_)->client_id;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp15_ = client_id;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp11_ = g_strcmp0 (_tmp14_, _tmp15_) == 0;
#line 3219 "tracker-store.c"
				} else {
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp11_ = FALSE;
#line 3223 "tracker-store.c"
				}
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp11_) {
#line 3227 "tracker-store.c"
					TrackerStoreQueryTask* _tmp16_;
					GCancellable* _tmp17_;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp16_ = task;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp17_ = _tmp16_->cancellable;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp10_ = _tmp17_ != NULL;
#line 3236 "tracker-store.c"
				} else {
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp10_ = FALSE;
#line 3240 "tracker-store.c"
				}
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp10_) {
#line 3244 "tracker-store.c"
					TrackerStoreQueryTask* _tmp18_;
					GCancellable* _tmp19_;
#line 430 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp18_ = task;
#line 430 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp19_ = _tmp18_->cancellable;
#line 430 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_cancellable_cancel (_tmp19_);
#line 3253 "tracker-store.c"
				}
			}
		}
	}
	{
		gint i;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3262 "tracker-store.c"
		{
			gboolean _tmp20_;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp20_ = TRUE;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3269 "tracker-store.c"
				gint _tmp22_;
				gint _tmp23_;
				GQueue* _tmp24_;
				GQueue* _tmp25_;
				GList* _tmp26_;
				gint _tmp44_;
				GQueue* _tmp45_;
				GQueue* _tmp46_;
				GList* _tmp47_;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp20_) {
#line 3281 "tracker-store.c"
					gint _tmp21_;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp21_ = i;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp21_ + 1;
#line 3287 "tracker-store.c"
				}
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp20_ = FALSE;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp22_ = i;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp22_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3297 "tracker-store.c"
				}
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp23_ = i;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp24_ = tracker_store_query_queues[_tmp23_];
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				queue = _tmp24_;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp25_ = queue;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp26_ = _tmp25_->head;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				list = _tmp26_;
#line 437 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 3313 "tracker-store.c"
					GList* _tmp27_;
					GList* _tmp28_;
					GList* _tmp29_;
					GList* _tmp30_;
					TrackerStoreTask* task;
					GList* _tmp31_;
					gconstpointer _tmp32_;
					gboolean _tmp33_ = FALSE;
					TrackerStoreTask* _tmp34_;
#line 437 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp27_ = list;
#line 437 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp27_ != NULL)) {
#line 437 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 3329 "tracker-store.c"
					}
#line 438 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_ = list;
#line 438 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					cur = _tmp28_;
#line 439 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_ = list;
#line 439 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp30_ = _tmp29_->next;
#line 439 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					list = _tmp30_;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp31_ = cur;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp32_ = _tmp31_->data;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp32_;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp34_ = task;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp34_ != NULL) {
#line 3351 "tracker-store.c"
						TrackerStoreTask* _tmp35_;
						const gchar* _tmp36_;
						const gchar* _tmp37_;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp35_ = task;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp36_ = _tmp35_->client_id;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp37_ = client_id;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp33_ = g_strcmp0 (_tmp36_, _tmp37_) == 0;
#line 3363 "tracker-store.c"
					} else {
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp33_ = FALSE;
#line 3367 "tracker-store.c"
					}
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp33_) {
#line 3371 "tracker-store.c"
						GQueue* _tmp38_;
						GList* _tmp39_;
						TrackerStoreTask* _tmp40_;
						GError* _tmp41_;
						TrackerStoreTask* _tmp42_;
						GSourceFunc _tmp43_;
						void* _tmp43__target;
#line 443 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp38_ = queue;
#line 443 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp39_ = cur;
#line 443 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						g_queue_delete_link (_tmp38_, _tmp39_);
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp40_ = task;
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp41_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Client disappeared");
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_error_free0 (_tmp40_->error);
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp40_->error = _tmp41_;
#line 446 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp42_ = task;
#line 446 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp43_ = _tmp42_->callback;
#line 446 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp43__target = _tmp42_->callback_target;
#line 446 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp43_ (_tmp43__target);
#line 3401 "tracker-store.c"
					}
				}
#line 450 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp44_ = i;
#line 450 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp45_ = tracker_store_update_queues[_tmp44_];
#line 450 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				queue = _tmp45_;
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp46_ = queue;
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp47_ = _tmp46_->head;
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				list = _tmp47_;
#line 452 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 3418 "tracker-store.c"
					GList* _tmp48_;
					GList* _tmp49_;
					GList* _tmp50_;
					GList* _tmp51_;
					TrackerStoreTask* task;
					GList* _tmp52_;
					gconstpointer _tmp53_;
					gboolean _tmp54_ = FALSE;
					TrackerStoreTask* _tmp55_;
#line 452 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp48_ = list;
#line 452 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp48_ != NULL)) {
#line 452 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 3434 "tracker-store.c"
					}
#line 453 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp49_ = list;
#line 453 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					cur = _tmp49_;
#line 454 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp50_ = list;
#line 454 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp51_ = _tmp50_->next;
#line 454 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					list = _tmp51_;
#line 455 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp52_ = cur;
#line 455 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp53_ = _tmp52_->data;
#line 455 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp53_;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp55_ = task;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp55_ != NULL) {
#line 3456 "tracker-store.c"
						TrackerStoreTask* _tmp56_;
						const gchar* _tmp57_;
						const gchar* _tmp58_;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp56_ = task;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp57_ = _tmp56_->client_id;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp58_ = client_id;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp54_ = g_strcmp0 (_tmp57_, _tmp58_) == 0;
#line 3468 "tracker-store.c"
					} else {
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp54_ = FALSE;
#line 3472 "tracker-store.c"
					}
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp54_) {
#line 3476 "tracker-store.c"
						GQueue* _tmp59_;
						GList* _tmp60_;
						TrackerStoreTask* _tmp61_;
						GError* _tmp62_;
						TrackerStoreTask* _tmp63_;
						GSourceFunc _tmp64_;
						void* _tmp64__target;
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp59_ = queue;
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp60_ = cur;
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						g_queue_delete_link (_tmp59_, _tmp60_);
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp61_ = task;
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp62_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Client disappeared");
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_error_free0 (_tmp61_->error);
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp61_->error = _tmp62_;
#line 461 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp63_ = task;
#line 461 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp64_ = _tmp63_->callback;
#line 461 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp64__target = _tmp63_->callback_target;
#line 461 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp64_ (_tmp64__target);
#line 3506 "tracker-store.c"
					}
				}
			}
		}
	}
#line 466 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 3514 "tracker-store.c"
}


static void tracker_store_pause_data_free (gpointer _data) {
	TrackerStorePauseData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStorePauseData, _data_);
#line 3523 "tracker-store.c"
}


void tracker_store_pause (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStorePauseData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStorePauseData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_pause_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_pause_co (_data_);
#line 3537 "tracker-store.c"
}


void tracker_store_pause_finish (GAsyncResult* _res_) {
	TrackerStorePauseData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3545 "tracker-store.c"
}


static gboolean _tracker_store_pause_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_pause_co (self);
#line 473 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 3554 "tracker-store.c"
}


static gboolean tracker_store_pause_co (TrackerStorePauseData* _data_) {
#line 469 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 469 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 3563 "tracker-store.c"
		goto _state_0;
#line 469 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 3567 "tracker-store.c"
		goto _state_1;
		default:
#line 469 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 3572 "tracker-store.c"
	}
	_state_0:
#line 470 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_active = FALSE;
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = tracker_store_n_queries_running;
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp1_ > 0) {
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp0_ = TRUE;
#line 3583 "tracker-store.c"
	} else {
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp2_ = tracker_store_update_running;
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp0_ = _data_->_tmp2_;
#line 3589 "tracker-store.c"
	}
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp0_) {
#line 473 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		(tracker_store_active_callback_target_destroy_notify == NULL) ? NULL : (tracker_store_active_callback_target_destroy_notify (tracker_store_active_callback_target), NULL);
#line 473 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 473 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 473 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 473 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = _tracker_store_pause_co_gsource_func;
#line 473 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = _data_;
#line 473 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 474 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_state_ = 1;
#line 474 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 3611 "tracker-store.c"
		_state_1:
		;
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		(tracker_store_active_callback_target_destroy_notify == NULL) ? NULL : (tracker_store_active_callback_target_destroy_notify (tracker_store_active_callback_target), NULL);
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 3628 "tracker-store.c"
	}
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = g_atomic_int_get ((volatile gint *) (&tracker_store_checkpointing));
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp3_ != 0) {
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_checkpoint_pool = NULL;
#line 3638 "tracker-store.c"
		{
#line 482 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp5_ = g_thread_pool_new (_tracker_store_checkpoint_dispatch_cb_gfunc, NULL, 1, TRUE, &_data_->_inner_error_);
#line 482 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp4_ = _data_->_tmp5_;
#line 482 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 3646 "tracker-store.c"
				goto __catch26_g_error;
			}
#line 482 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp6_ = _data_->_tmp4_;
#line 482 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp4_ = NULL;
#line 482 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 482 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_checkpoint_pool = _data_->_tmp6_;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_data_->_tmp4_);
#line 3659 "tracker-store.c"
		}
		goto __finally26;
		__catch26_g_error:
		{
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->e = _data_->_inner_error_;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_inner_error_ = NULL;
#line 484 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp7_ = _data_->e;
#line 484 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp8_ = _data_->_tmp7_->message;
#line 484 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_warning ("%s", _data_->_tmp8_);
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (_data_->e);
#line 3676 "tracker-store.c"
		}
		__finally26:
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_clear_error (&_data_->_inner_error_);
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return FALSE;
#line 3687 "tracker-store.c"
		}
	}
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = tracker_store_active;
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp9_) {
#line 489 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_sched ();
#line 3696 "tracker-store.c"
	}
#line 469 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 469 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 469 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 469 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3706 "tracker-store.c"
		}
	}
#line 469 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 469 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 3713 "tracker-store.c"
}


void tracker_store_resume (void) {
#line 494 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_active = TRUE;
#line 496 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 3722 "tracker-store.c"
}


TrackerStore* tracker_store_construct (GType object_type) {
	TrackerStore* self = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStore*) g_type_create_instance (object_type);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 3732 "tracker-store.c"
}


TrackerStore* tracker_store_new (void) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_construct (TRACKER_TYPE_STORE);
#line 3739 "tracker-store.c"
}


static TrackerStoreTask* tracker_store_task_construct (GType object_type) {
	TrackerStoreTask* self = NULL;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreTask*) g_type_create_instance (object_type);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 3749 "tracker-store.c"
}


static void tracker_store_value_task_init (GValue* value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	value->data[0].v_pointer = NULL;
#line 3756 "tracker-store.c"
}


static void tracker_store_value_task_free_value (GValue* value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (value->data[0].v_pointer) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (value->data[0].v_pointer);
#line 3765 "tracker-store.c"
	}
}


static void tracker_store_value_task_copy_value (const GValue* src_value, GValue* dest_value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (src_value->data[0].v_pointer) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = tracker_store_task_ref (src_value->data[0].v_pointer);
#line 3775 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3779 "tracker-store.c"
	}
}


static gpointer tracker_store_value_task_peek_pointer (const GValue* value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 3787 "tracker-store.c"
}


static gchar* tracker_store_value_task_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (collect_values[0].v_pointer) {
#line 3794 "tracker-store.c"
		TrackerStoreTask * object;
		object = collect_values[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (object->parent_instance.g_class == NULL) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3801 "tracker-store.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3805 "tracker-store.c"
		}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = tracker_store_task_ref (object);
#line 3809 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 3813 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 3817 "tracker-store.c"
}


static gchar* tracker_store_value_task_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerStoreTask ** object_p;
	object_p = collect_values[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!object_p) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3828 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!value->data[0].v_pointer) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = NULL;
#line 3834 "tracker-store.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = value->data[0].v_pointer;
#line 3838 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = tracker_store_task_ref (value->data[0].v_pointer);
#line 3842 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 3846 "tracker-store.c"
}


static GParamSpec* tracker_store_param_spec_task (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerStoreParamSpecTask* spec;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_STORE_TYPE_TASK), NULL);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return G_PARAM_SPEC (spec);
#line 3860 "tracker-store.c"
}


static gpointer tracker_store_value_get_task (const GValue* value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK), NULL);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 3869 "tracker-store.c"
}


static void tracker_store_value_set_task (GValue* value, gpointer v_object) {
	TrackerStoreTask * old;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_ref (value->data[0].v_pointer);
#line 3889 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 3893 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (old);
#line 3899 "tracker-store.c"
	}
}


static void tracker_store_value_take_task (GValue* value, gpointer v_object) {
	TrackerStoreTask * old;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 3918 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 3922 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (old);
#line 3928 "tracker-store.c"
	}
}


static void tracker_store_task_class_init (TrackerStoreTaskClass * klass) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_task_parent_class = g_type_class_peek_parent (klass);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTaskClass *) klass)->finalize = tracker_store_task_finalize;
#line 3938 "tracker-store.c"
}


static void tracker_store_task_instance_init (TrackerStoreTask * self) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->ref_count = 1;
#line 3945 "tracker-store.c"
}


static void tracker_store_task_finalize (TrackerStoreTask * obj) {
	TrackerStoreTask * self;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_TASK, TrackerStoreTask);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_signal_handlers_destroy (self);
#line 57 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (self->client_id);
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_error_free0 (self->error);
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->callback = NULL;
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->callback_target = NULL;
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->callback_target_destroy_notify = NULL;
#line 3967 "tracker-store.c"
}


static GType tracker_store_task_get_type (void) {
	static volatile gsize tracker_store_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_task_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_store_value_task_init, tracker_store_value_task_free_value, tracker_store_value_task_copy_value, tracker_store_value_task_peek_pointer, "p", tracker_store_value_task_collect_value, "p", tracker_store_value_task_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreTask), 0, (GInstanceInitFunc) tracker_store_task_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_store_task_type_id;
		tracker_store_task_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStoreTask", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_store_task_type_id__volatile, tracker_store_task_type_id);
	}
	return tracker_store_task_type_id__volatile;
}


static gpointer tracker_store_task_ref (gpointer instance) {
	TrackerStoreTask * self;
	self = instance;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&self->ref_count);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return instance;
#line 3992 "tracker-store.c"
}


static void tracker_store_task_unref (gpointer instance) {
	TrackerStoreTask * self;
	self = instance;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		TRACKER_STORE_TASK_GET_CLASS (self)->finalize (self);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4005 "tracker-store.c"
	}
}


static TrackerStoreQueryTask* tracker_store_query_task_construct (GType object_type) {
	TrackerStoreQueryTask* self = NULL;
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreQueryTask*) tracker_store_task_construct (object_type);
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4016 "tracker-store.c"
}


static TrackerStoreQueryTask* tracker_store_query_task_new (void) {
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_query_task_construct (TRACKER_STORE_TYPE_QUERY_TASK);
#line 4023 "tracker-store.c"
}


static void tracker_store_query_task_class_init (TrackerStoreQueryTaskClass * klass) {
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_query_task_parent_class = g_type_class_peek_parent (klass);
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTaskClass *) klass)->finalize = tracker_store_query_task_finalize;
#line 4032 "tracker-store.c"
}


static void tracker_store_query_task_instance_init (TrackerStoreQueryTask * self) {
}


static void tracker_store_query_task_finalize (TrackerStoreTask * obj) {
	TrackerStoreQueryTask * self;
	guint _tmp0_;
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask);
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = self->watchdog_id;
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp0_ > ((guint) 0)) {
#line 4049 "tracker-store.c"
		guint _tmp1_;
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = self->watchdog_id;
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_source_remove (_tmp1_);
#line 4055 "tracker-store.c"
	}
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (self->query);
#line 64 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (self->cancellable);
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_query_task_parent_class)->finalize (obj);
#line 4063 "tracker-store.c"
}


static GType tracker_store_query_task_get_type (void) {
	static volatile gsize tracker_store_query_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_query_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreQueryTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_query_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreQueryTask), 0, (GInstanceInitFunc) tracker_store_query_task_instance_init, NULL };
		GType tracker_store_query_task_type_id;
		tracker_store_query_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreQueryTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_query_task_type_id__volatile, tracker_store_query_task_type_id);
	}
	return tracker_store_query_task_type_id__volatile;
}


static TrackerStoreUpdateTask* tracker_store_update_task_construct (GType object_type) {
	TrackerStoreUpdateTask* self = NULL;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreUpdateTask*) tracker_store_task_construct (object_type);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4085 "tracker-store.c"
}


static TrackerStoreUpdateTask* tracker_store_update_task_new (void) {
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_update_task_construct (TRACKER_STORE_TYPE_UPDATE_TASK);
#line 4092 "tracker-store.c"
}


static void tracker_store_update_task_class_init (TrackerStoreUpdateTaskClass * klass) {
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_update_task_parent_class = g_type_class_peek_parent (klass);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTaskClass *) klass)->finalize = tracker_store_update_task_finalize;
#line 4101 "tracker-store.c"
}


static void tracker_store_update_task_instance_init (TrackerStoreUpdateTask * self) {
}


static void tracker_store_update_task_finalize (TrackerStoreTask * obj) {
	TrackerStoreUpdateTask * self;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask);
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (self->query);
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_variant_unref0 (self->blank_nodes);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_update_task_parent_class)->finalize (obj);
#line 4119 "tracker-store.c"
}


static GType tracker_store_update_task_get_type (void) {
	static volatile gsize tracker_store_update_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_update_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreUpdateTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_update_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreUpdateTask), 0, (GInstanceInitFunc) tracker_store_update_task_instance_init, NULL };
		GType tracker_store_update_task_type_id;
		tracker_store_update_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreUpdateTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_update_task_type_id__volatile, tracker_store_update_task_type_id);
	}
	return tracker_store_update_task_type_id__volatile;
}


static TrackerStoreTurtleTask* tracker_store_turtle_task_construct (GType object_type) {
	TrackerStoreTurtleTask* self = NULL;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreTurtleTask*) tracker_store_task_construct (object_type);
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4141 "tracker-store.c"
}


static TrackerStoreTurtleTask* tracker_store_turtle_task_new (void) {
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_turtle_task_construct (TRACKER_STORE_TYPE_TURTLE_TASK);
#line 4148 "tracker-store.c"
}


static void tracker_store_turtle_task_class_init (TrackerStoreTurtleTaskClass * klass) {
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_turtle_task_parent_class = g_type_class_peek_parent (klass);
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTaskClass *) klass)->finalize = tracker_store_turtle_task_finalize;
#line 4157 "tracker-store.c"
}


static void tracker_store_turtle_task_instance_init (TrackerStoreTurtleTask * self) {
}


static void tracker_store_turtle_task_finalize (TrackerStoreTask * obj) {
	TrackerStoreTurtleTask * self;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTask);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_free (self->path);
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_turtle_task_parent_class)->finalize (obj);
#line 4173 "tracker-store.c"
}


static GType tracker_store_turtle_task_get_type (void) {
	static volatile gsize tracker_store_turtle_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_turtle_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreTurtleTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_turtle_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreTurtleTask), 0, (GInstanceInitFunc) tracker_store_turtle_task_instance_init, NULL };
		GType tracker_store_turtle_task_type_id;
		tracker_store_turtle_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreTurtleTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_turtle_task_type_id__volatile, tracker_store_turtle_task_type_id);
	}
	return tracker_store_turtle_task_type_id__volatile;
}


static void tracker_value_store_init (GValue* value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	value->data[0].v_pointer = NULL;
#line 4192 "tracker-store.c"
}


static void tracker_value_store_free_value (GValue* value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (value->data[0].v_pointer) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (value->data[0].v_pointer);
#line 4201 "tracker-store.c"
	}
}


static void tracker_value_store_copy_value (const GValue* src_value, GValue* dest_value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = tracker_store_ref (src_value->data[0].v_pointer);
#line 4211 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4215 "tracker-store.c"
	}
}


static gpointer tracker_value_store_peek_pointer (const GValue* value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 4223 "tracker-store.c"
}


static gchar* tracker_value_store_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (collect_values[0].v_pointer) {
#line 4230 "tracker-store.c"
		TrackerStore * object;
		object = collect_values[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4237 "tracker-store.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4241 "tracker-store.c"
		}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = tracker_store_ref (object);
#line 4245 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4249 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 4253 "tracker-store.c"
}


static gchar* tracker_value_store_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerStore ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!object_p) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4264 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!value->data[0].v_pointer) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = NULL;
#line 4270 "tracker-store.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = value->data[0].v_pointer;
#line 4274 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = tracker_store_ref (value->data[0].v_pointer);
#line 4278 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 4282 "tracker-store.c"
}


GParamSpec* tracker_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecStore* spec;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_STORE), NULL);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return G_PARAM_SPEC (spec);
#line 4296 "tracker-store.c"
}


gpointer tracker_value_get_store (const GValue* value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE), NULL);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 4305 "tracker-store.c"
}


void tracker_value_set_store (GValue* value, gpointer v_object) {
	TrackerStore * old;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_ref (value->data[0].v_pointer);
#line 4325 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4329 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (old);
#line 4335 "tracker-store.c"
	}
}


void tracker_value_take_store (GValue* value, gpointer v_object) {
	TrackerStore * old;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 4354 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4358 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (old);
#line 4364 "tracker-store.c"
	}
}


static void tracker_store_class_init (TrackerStoreClass * klass) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreClass *) klass)->finalize = tracker_store_finalize;
#line 4374 "tracker-store.c"
}


static void tracker_store_instance_init (TrackerStore * self) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->ref_count = 1;
#line 4381 "tracker-store.c"
}


static void tracker_store_finalize (TrackerStore * obj) {
	TrackerStore * self;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_STORE, TrackerStore);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_signal_handlers_destroy (self);
#line 4391 "tracker-store.c"
}


GType tracker_store_get_type (void) {
	static volatile gsize tracker_store_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_store_init, tracker_value_store_free_value, tracker_value_store_copy_value, tracker_value_store_peek_pointer, "p", tracker_value_store_collect_value, "p", tracker_value_store_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStore), 0, (GInstanceInitFunc) tracker_store_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_store_type_id;
		tracker_store_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStore", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_store_type_id__volatile, tracker_store_type_id);
	}
	return tracker_store_type_id__volatile;
}


gpointer tracker_store_ref (gpointer instance) {
	TrackerStore * self;
	self = instance;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return instance;
#line 4416 "tracker-store.c"
}


void tracker_store_unref (gpointer instance) {
	TrackerStore * self;
	self = instance;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		TRACKER_STORE_GET_CLASS (self)->finalize (self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4429 "tracker-store.c"
	}
}



