/* tracker-status.c generated by valac 0.36.3, the Vala compiler
 * generated from tracker-status.vala, do not modify */

/*
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Authors:
 *  Philip Van Hoof <philip@codeminded.be>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-data/tracker-data-update.h"


#define TRACKER_TYPE_STATUS (tracker_status_get_type ())
#define TRACKER_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATUS, TrackerStatus))
#define TRACKER_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATUS, TrackerStatusClass))
#define TRACKER_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATUS))
#define TRACKER_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATUS))
#define TRACKER_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATUS, TrackerStatusClass))

typedef struct _TrackerStatus TrackerStatus;
typedef struct _TrackerStatusClass TrackerStatusClass;
typedef struct _TrackerStatusPrivate TrackerStatusPrivate;

#define TRACKER_STATUS_TYPE_WAIT_CONTEXT (tracker_status_wait_context_get_type ())
#define TRACKER_STATUS_WAIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STATUS_TYPE_WAIT_CONTEXT, TrackerStatusWaitContext))
#define TRACKER_STATUS_WAIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STATUS_TYPE_WAIT_CONTEXT, TrackerStatusWaitContextClass))
#define TRACKER_STATUS_IS_WAIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STATUS_TYPE_WAIT_CONTEXT))
#define TRACKER_STATUS_IS_WAIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STATUS_TYPE_WAIT_CONTEXT))
#define TRACKER_STATUS_WAIT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STATUS_TYPE_WAIT_CONTEXT, TrackerStatusWaitContextClass))

typedef struct _TrackerStatusWaitContext TrackerStatusWaitContext;
typedef struct _TrackerStatusWaitContextClass TrackerStatusWaitContextClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _TrackerStatusWaitContextPrivate TrackerStatusWaitContextPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TrackerStatusWaitData TrackerStatusWaitData;
enum  {
	TRACKER_STATUS_PROGRESS_SIGNAL,
	TRACKER_STATUS_LAST_SIGNAL
};
static guint tracker_status_signals[TRACKER_STATUS_LAST_SIGNAL] = {0};

struct _TrackerStatus {
	GObject parent_instance;
	TrackerStatusPrivate * priv;
};

struct _TrackerStatusClass {
	GObjectClass parent_class;
};

struct _TrackerStatusPrivate {
	gdouble _progress;
	gchar* status;
	guint timer_id;
	GList* wait_list;
};

struct _TrackerStatusWaitContext {
	GObject parent_instance;
	TrackerStatusWaitContextPrivate * priv;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _TrackerStatusWaitContextClass {
	GObjectClass parent_class;
};

struct _TrackerStatusWaitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerStatus* self;
	gdouble _tmp0_;
	TrackerStatusWaitContext* context;
	TrackerStatusWaitContext* _tmp1_;
	TrackerStatusWaitContext* _tmp2_;
	TrackerStatusWaitContext* _tmp3_;
	TrackerStatusWaitContext* _tmp4_;
};


static gpointer tracker_status_parent_class = NULL;
static gboolean tracker_status_first_time;
static gboolean tracker_status_first_time = TRUE;
static gpointer tracker_status_wait_context_parent_class = NULL;

GType tracker_status_get_type (void) G_GNUC_CONST;
guint tracker_status_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
static GType tracker_status_wait_context_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_STATUS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_STATUS, TrackerStatusPrivate))
enum  {
	TRACKER_STATUS_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define TRACKER_STATUS_PATH "/org/freedesktop/Tracker1/Status"
#define TRACKER_STATUS_PROGRESS_TIMEOUT_S 5
static gboolean tracker_status_busy_notification_timeout (TrackerStatus* self);
static void tracker_status_callback (TrackerStatus* self, const gchar* status, gdouble progress);
static gboolean _tracker_status_busy_notification_timeout_gsource_func (gpointer self);
TrackerBusyCallback tracker_status_get_callback (TrackerStatus* self, void** result_target, GDestroyNotify* result_target_destroy_notify);
static void _tracker_status_callback_tracker_busy_callback (const gchar* status, gdouble progress, gpointer self);
gdouble tracker_status_get_progress (TrackerStatus* self);
gchar* tracker_status_get_status (TrackerStatus* self);
static void tracker_status_wait_data_free (gpointer _data);
void tracker_status_wait (TrackerStatus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_status_wait_finish (TrackerStatus* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_status_wait_co (TrackerStatusWaitData* _data_);
static TrackerStatusWaitContext* tracker_status_wait_context_new (void);
static TrackerStatusWaitContext* tracker_status_wait_context_construct (GType object_type);
static gboolean _tracker_status_wait_co_gsource_func (gpointer self);
TrackerStatus* tracker_status_new (void);
TrackerStatus* tracker_status_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__STRING_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
enum  {
	TRACKER_STATUS_WAIT_CONTEXT_DUMMY_PROPERTY
};
static void tracker_status_wait_context_finalize (GObject * obj);
static void tracker_status_finalize (GObject * obj);
static void _dbus_tracker_status_get_progress (TrackerStatus* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_status_get_status (TrackerStatus* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_status_wait (TrackerStatus* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_status_wait_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void tracker_status_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* tracker_status_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean tracker_status_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_tracker_status_progress (GObject* _sender, const gchar* status, gdouble progres, gpointer* _data);
static void _tracker_status_unregister_object (gpointer user_data);

static const GDBusArgInfo _tracker_status_dbus_arg_info_get_progress_result = {-1, "result", "d"};
static const GDBusArgInfo * const _tracker_status_dbus_arg_info_get_progress_in[] = {NULL};
static const GDBusArgInfo * const _tracker_status_dbus_arg_info_get_progress_out[] = {&_tracker_status_dbus_arg_info_get_progress_result, NULL};
static const GDBusMethodInfo _tracker_status_dbus_method_info_get_progress = {-1, "GetProgress", (GDBusArgInfo **) (&_tracker_status_dbus_arg_info_get_progress_in), (GDBusArgInfo **) (&_tracker_status_dbus_arg_info_get_progress_out)};
static const GDBusArgInfo _tracker_status_dbus_arg_info_get_status_result = {-1, "result", "s"};
static const GDBusArgInfo * const _tracker_status_dbus_arg_info_get_status_in[] = {NULL};
static const GDBusArgInfo * const _tracker_status_dbus_arg_info_get_status_out[] = {&_tracker_status_dbus_arg_info_get_status_result, NULL};
static const GDBusMethodInfo _tracker_status_dbus_method_info_get_status = {-1, "GetStatus", (GDBusArgInfo **) (&_tracker_status_dbus_arg_info_get_status_in), (GDBusArgInfo **) (&_tracker_status_dbus_arg_info_get_status_out)};
static const GDBusArgInfo * const _tracker_status_dbus_arg_info_wait_in[] = {NULL};
static const GDBusArgInfo * const _tracker_status_dbus_arg_info_wait_out[] = {NULL};
static const GDBusMethodInfo _tracker_status_dbus_method_info_wait = {-1, "Wait", (GDBusArgInfo **) (&_tracker_status_dbus_arg_info_wait_in), (GDBusArgInfo **) (&_tracker_status_dbus_arg_info_wait_out)};
static const GDBusMethodInfo * const _tracker_status_dbus_method_info[] = {&_tracker_status_dbus_method_info_get_progress, &_tracker_status_dbus_method_info_get_status, &_tracker_status_dbus_method_info_wait, NULL};
static const GDBusArgInfo _tracker_status_dbus_arg_info_progress_status = {-1, "status", "s"};
static const GDBusArgInfo _tracker_status_dbus_arg_info_progress_progres = {-1, "progres", "d"};
static const GDBusArgInfo * const _tracker_status_dbus_arg_info_progress[] = {&_tracker_status_dbus_arg_info_progress_status, &_tracker_status_dbus_arg_info_progress_progres, NULL};
static const GDBusSignalInfo _tracker_status_dbus_signal_info_progress = {-1, "Progress", (GDBusArgInfo **) (&_tracker_status_dbus_arg_info_progress)};
static const GDBusSignalInfo * const _tracker_status_dbus_signal_info[] = {&_tracker_status_dbus_signal_info_progress, NULL};
static const GDBusPropertyInfo * const _tracker_status_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _tracker_status_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Status", (GDBusMethodInfo **) (&_tracker_status_dbus_method_info), (GDBusSignalInfo **) (&_tracker_status_dbus_signal_info), (GDBusPropertyInfo **) (&_tracker_status_dbus_property_info)};
static const GDBusInterfaceVTable _tracker_status_dbus_interface_vtable = {tracker_status_dbus_interface_method_call, tracker_status_dbus_interface_get_property, tracker_status_dbus_interface_set_property};

static void _g_object_unref0_ (gpointer var) {
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 183 "tracker-status.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_list_free (self);
#line 192 "tracker-status.c"
}


static gboolean tracker_status_busy_notification_timeout (TrackerStatus* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gdouble _tmp1_;
#line 57 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp0_ = self->priv->status;
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp1_ = self->priv->_progress;
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_signal_emit (self, tracker_status_signals[TRACKER_STATUS_PROGRESS_SIGNAL], 0, _tmp0_, _tmp1_);
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	self->priv->timer_id = (guint) 0;
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	result = FALSE;
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	return result;
#line 214 "tracker-status.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	return self ? g_object_ref (self) : NULL;
#line 221 "tracker-status.c"
}


static gboolean _tracker_status_busy_notification_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_status_busy_notification_timeout ((TrackerStatus*) self);
#line 88 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	return result;
#line 230 "tracker-status.c"
}


static void tracker_status_callback (TrackerStatus* self, const gchar* status, gdouble progress) {
	gdouble _tmp0_;
	gboolean _tmp1_ = FALSE;
	gdouble _tmp2_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	guint _tmp12_;
#line 68 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_return_if_fail (status != NULL);
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp0_ = progress;
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	self->priv->_progress = _tmp0_;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp2_ = progress;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	if (_tmp2_ == ((gdouble) 1)) {
#line 253 "tracker-status.c"
		GList* _tmp3_;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_tmp3_ = self->priv->wait_list;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_tmp1_ = _tmp3_ != NULL;
#line 259 "tracker-status.c"
	} else {
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_tmp1_ = FALSE;
#line 263 "tracker-status.c"
	}
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	if (_tmp1_) {
#line 267 "tracker-status.c"
		GList* _tmp4_;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		self->priv->wait_list = g_list_reverse (self->priv->wait_list);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_tmp4_ = self->priv->wait_list;
#line 273 "tracker-status.c"
		{
			GList* context_collection = NULL;
			GList* context_it = NULL;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
			context_collection = _tmp4_;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
			for (context_it = context_collection; context_it != NULL; context_it = context_it->next) {
#line 281 "tracker-status.c"
				TrackerStatusWaitContext* _tmp5_;
				TrackerStatusWaitContext* context = NULL;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
				_tmp5_ = _g_object_ref0 ((TrackerStatusWaitContext*) context_it->data);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
				context = _tmp5_;
#line 288 "tracker-status.c"
				{
					TrackerStatusWaitContext* _tmp6_;
					GSourceFunc _tmp7_;
					void* _tmp7__target;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
					_tmp6_ = context;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
					_tmp7_ = _tmp6_->callback;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
					_tmp7__target = _tmp6_->callback_target;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
					_tmp7_ (_tmp7__target);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
					_g_object_unref0 (context);
#line 303 "tracker-status.c"
				}
			}
		}
#line 79 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		__g_list_free__g_object_unref0_0 (self->priv->wait_list);
#line 79 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		self->priv->wait_list = NULL;
#line 311 "tracker-status.c"
	}
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp8_ = status;
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp9_ = self->priv->status;
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	if (g_strcmp0 (_tmp8_, _tmp9_) != 0) {
#line 319 "tracker-status.c"
		const gchar* _tmp10_;
		gchar* _tmp11_;
#line 83 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_tmp10_ = status;
#line 83 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 83 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_g_free0 (self->priv->status);
#line 83 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		self->priv->status = _tmp11_;
#line 330 "tracker-status.c"
	}
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp12_ = self->priv->timer_id;
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	if (_tmp12_ == ((guint) 0)) {
#line 336 "tracker-status.c"
		gboolean _tmp13_;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_tmp13_ = tracker_status_first_time;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		if (_tmp13_) {
#line 342 "tracker-status.c"
			guint _tmp14_;
#line 88 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
			_tmp14_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tracker_status_busy_notification_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 88 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
			self->priv->timer_id = _tmp14_;
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
			tracker_status_first_time = FALSE;
#line 350 "tracker-status.c"
		} else {
			guint _tmp15_;
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
			_tmp15_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) TRACKER_STATUS_PROGRESS_TIMEOUT_S, _tracker_status_busy_notification_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
			self->priv->timer_id = _tmp15_;
#line 357 "tracker-status.c"
		}
	}
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	while (TRUE) {
#line 362 "tracker-status.c"
		GMainContext* _tmp16_;
		gboolean _tmp17_;
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_tmp16_ = g_main_context_default ();
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_tmp17_ = g_main_context_iteration (_tmp16_, FALSE);
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		if (!_tmp17_) {
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
			break;
#line 373 "tracker-status.c"
		}
	}
}


static void _tracker_status_callback_tracker_busy_callback (const gchar* status, gdouble progress, gpointer self) {
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	tracker_status_callback ((TrackerStatus*) self, status, progress);
#line 382 "tracker-status.c"
}


TrackerBusyCallback tracker_status_get_callback (TrackerStatus* self, void** result_target, GDestroyNotify* result_target_destroy_notify) {
	TrackerBusyCallback result = NULL;
	TrackerBusyCallback _tmp0_;
	void* _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
#line 100 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp0_ = _tracker_status_callback_tracker_busy_callback;
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp0__target = g_object_ref (self);
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp0__target_destroy_notify = g_object_unref;
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	*result_target = _tmp0__target;
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	*result_target_destroy_notify = _tmp0__target_destroy_notify;
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	result = _tmp0_;
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	return result;
#line 407 "tracker-status.c"
}


gdouble tracker_status_get_progress (TrackerStatus* self) {
	gdouble result = 0.0;
	gdouble _tmp0_;
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp0_ = self->priv->_progress;
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	result = _tmp0_;
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	return result;
#line 422 "tracker-status.c"
}


gchar* tracker_status_get_status (TrackerStatus* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 109 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp0_ = self->priv->status;
#line 109 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 109 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	result = _tmp1_;
#line 109 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	return result;
#line 440 "tracker-status.c"
}


static void tracker_status_wait_data_free (gpointer _data) {
	TrackerStatusWaitData* _data_;
	_data_ = _data;
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_g_object_unref0 (_data_->self);
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_slice_free (TrackerStatusWaitData, _data_);
#line 451 "tracker-status.c"
}


void tracker_status_wait (TrackerStatus* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStatusWaitData* _data_;
	TrackerStatus* _tmp0_;
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_data_ = g_slice_new0 (TrackerStatusWaitData);
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_status_wait_data_free);
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_data_->self = _tmp0_;
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	tracker_status_wait_co (_data_);
#line 470 "tracker-status.c"
}


void tracker_status_wait_finish (TrackerStatus* self, GAsyncResult* _res_, GError** error) {
	TrackerStatusWaitData* _data_;
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	if (NULL == _data_) {
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		return;
#line 482 "tracker-status.c"
	}
}


static gboolean _tracker_status_wait_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_status_wait_co (self);
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	return result;
#line 492 "tracker-status.c"
}


static gboolean tracker_status_wait_co (TrackerStatusWaitData* _data_) {
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	switch (_data_->_state_) {
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		case 0:
#line 501 "tracker-status.c"
		goto _state_0;
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		case 1:
#line 505 "tracker-status.c"
		goto _state_1;
		default:
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		g_assert_not_reached ();
#line 510 "tracker-status.c"
	}
	_state_0:
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_data_->_tmp0_ = _data_->self->priv->_progress;
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	if (_data_->_tmp0_ == ((gdouble) 1)) {
#line 517 "tracker-status.c"
	} else {
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_data_->_tmp1_ = tracker_status_wait_context_new ();
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_data_->context = _data_->_tmp1_;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_data_->_tmp2_ = _data_->context;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		(_data_->_tmp2_->callback_target_destroy_notify == NULL) ? NULL : (_data_->_tmp2_->callback_target_destroy_notify (_data_->_tmp2_->callback_target), NULL);
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_data_->_tmp2_->callback = NULL;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_data_->_tmp2_->callback_target = NULL;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_data_->_tmp2_->callback_target_destroy_notify = NULL;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_data_->_tmp2_->callback = _tracker_status_wait_co_gsource_func;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_data_->_tmp2_->callback_target = _data_;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_data_->_tmp2_->callback_target_destroy_notify = NULL;
#line 118 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_data_->_tmp3_ = _data_->context;
#line 118 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
#line 118 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_data_->self->priv->wait_list = g_list_prepend (_data_->self->priv->wait_list, _data_->_tmp4_);
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_data_->_state_ = 1;
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		return FALSE;
#line 549 "tracker-status.c"
		_state_1:
		;
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_g_object_unref0 (_data_->context);
#line 554 "tracker-status.c"
	}
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	if (_data_->_state_ != 0) {
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 564 "tracker-status.c"
		}
	}
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_object_unref (_data_->_async_result);
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	return FALSE;
#line 571 "tracker-status.c"
}


TrackerStatus* tracker_status_construct (GType object_type) {
	TrackerStatus * self = NULL;
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	self = (TrackerStatus*) g_object_new (object_type, NULL);
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	return self;
#line 581 "tracker-status.c"
}


TrackerStatus* tracker_status_new (void) {
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	return tracker_status_construct (TRACKER_TYPE_STATUS);
#line 588 "tracker-status.c"
}


static void g_cclosure_user_marshal_VOID__STRING_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_DOUBLE) (gpointer data1, const char* arg_1, gdouble arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_return_if_fail (n_param_values == 3);
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		data1 = closure->data;
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		data2 = param_values->data[0].v_pointer;
#line 607 "tracker-status.c"
	} else {
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		data1 = param_values->data[0].v_pointer;
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		data2 = closure->data;
#line 613 "tracker-status.c"
	}
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	callback = (GMarshalFunc_VOID__STRING_DOUBLE) (marshal_data ? marshal_data : cc->callback);
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_double (param_values + 2), data2);
#line 619 "tracker-status.c"
}


static TrackerStatusWaitContext* tracker_status_wait_context_construct (GType object_type) {
	TrackerStatusWaitContext * self = NULL;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	self = (TrackerStatusWaitContext*) g_object_new (object_type, NULL);
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	return self;
#line 629 "tracker-status.c"
}


static TrackerStatusWaitContext* tracker_status_wait_context_new (void) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	return tracker_status_wait_context_construct (TRACKER_STATUS_TYPE_WAIT_CONTEXT);
#line 636 "tracker-status.c"
}


static void tracker_status_wait_context_class_init (TrackerStatusWaitContextClass * klass) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	tracker_status_wait_context_parent_class = g_type_class_peek_parent (klass);
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_status_wait_context_finalize;
#line 645 "tracker-status.c"
}


static void tracker_status_wait_context_instance_init (TrackerStatusWaitContext * self) {
}


static void tracker_status_wait_context_finalize (GObject * obj) {
	TrackerStatusWaitContext * self;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STATUS_TYPE_WAIT_CONTEXT, TrackerStatusWaitContext);
#line 30 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
#line 30 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	self->callback = NULL;
#line 30 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	self->callback_target = NULL;
#line 30 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	self->callback_target_destroy_notify = NULL;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	G_OBJECT_CLASS (tracker_status_wait_context_parent_class)->finalize (obj);
#line 667 "tracker-status.c"
}


static GType tracker_status_wait_context_get_type (void) {
	static volatile gsize tracker_status_wait_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_status_wait_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStatusWaitContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_status_wait_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStatusWaitContext), 0, (GInstanceInitFunc) tracker_status_wait_context_instance_init, NULL };
		GType tracker_status_wait_context_type_id;
		tracker_status_wait_context_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerStatusWaitContext", &g_define_type_info, 0);
		g_once_init_leave (&tracker_status_wait_context_type_id__volatile, tracker_status_wait_context_type_id);
	}
	return tracker_status_wait_context_type_id__volatile;
}


static void tracker_status_class_init (TrackerStatusClass * klass) {
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	tracker_status_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	g_type_class_add_private (klass, sizeof (TrackerStatusPrivate));
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_status_finalize;
#line 690 "tracker-status.c"
	/**
	 * TrackerStatus::progress:
	 * @notifier: the TrackerStatus
	 * @status: store status
	 * @progress: a #gdouble indicating store progress, from 0 to 1.
	 *
	 * the ::progress signal will be emitted by TrackerStatus
	 * to indicate progress about the store process. @status will
	 * contain a translated string with the current status and @progress
	 * will indicate how much has been processed so far.
	 **/
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	tracker_status_signals[TRACKER_STATUS_PROGRESS_SIGNAL] = g_signal_new ("progress", TRACKER_TYPE_STATUS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_DOUBLE, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_DOUBLE);
#line 704 "tracker-status.c"
}


static void tracker_status_instance_init (TrackerStatus * self) {
	gchar* _tmp0_;
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	self->priv = TRACKER_STATUS_GET_PRIVATE (self);
#line 34 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp0_ = g_strdup ("Idle");
#line 34 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	self->priv->status = _tmp0_;
#line 716 "tracker-status.c"
}


static void tracker_status_finalize (GObject * obj) {
	TrackerStatus * self;
	guint _tmp0_;
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_STATUS, TrackerStatus);
#line 52 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_tmp0_ = self->priv->timer_id;
#line 52 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 729 "tracker-status.c"
		guint _tmp1_;
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		_tmp1_ = self->priv->timer_id;
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
		g_source_remove (_tmp1_);
#line 735 "tracker-status.c"
	}
#line 34 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	_g_free0 (self->priv->status);
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	__g_list_free__g_object_unref0_0 (self->priv->wait_list);
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-status.vala"
	G_OBJECT_CLASS (tracker_status_parent_class)->finalize (obj);
#line 743 "tracker-status.c"
}


GType tracker_status_get_type (void) {
	static volatile gsize tracker_status_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_status_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStatusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_status_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStatus), 0, (GInstanceInitFunc) tracker_status_instance_init, NULL };
		GType tracker_status_type_id;
		tracker_status_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerStatus", &g_define_type_info, 0);
		g_type_set_qdata (tracker_status_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) tracker_status_register_object);
		g_once_init_leave (&tracker_status_type_id__volatile, tracker_status_type_id);
	}
	return tracker_status_type_id__volatile;
}


static void _dbus_tracker_status_get_progress (TrackerStatus* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gdouble result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = tracker_status_get_progress (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_double (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_status_get_status (TrackerStatus* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = tracker_status_get_status (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_status_wait (TrackerStatus* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	tracker_status_wait (self, (GAsyncReadyCallback) _dbus_tracker_status_wait_ready, invocation);
}


static void _dbus_tracker_status_wait_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_status_wait_finish ((TrackerStatus*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void tracker_status_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetProgress") == 0) {
		_dbus_tracker_status_get_progress (object, parameters, invocation);
	} else if (strcmp (method_name, "GetStatus") == 0) {
		_dbus_tracker_status_get_status (object, parameters, invocation);
	} else if (strcmp (method_name, "Wait") == 0) {
		_dbus_tracker_status_wait (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* tracker_status_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean tracker_status_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_tracker_status_progress (GObject* _sender, const gchar* status, gdouble progres, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (status));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (progres));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Status", "Progress", _arguments, NULL);
}


guint tracker_status_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_tracker_status_dbus_interface_info), &_tracker_status_dbus_interface_vtable, data, _tracker_status_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "progress", (GCallback) _dbus_tracker_status_progress, data);
	return result;
}


static void _tracker_status_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_tracker_status_progress, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



