/* tracker-store.c generated by valac 0.36.3, the Vala compiler
 * generated from tracker-store.vala, do not modify */

/*
 * Copyright (C) 2009-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Philip Van Hoof <philip@codeminded.be>
 */

#include <glib.h>
#include <glib-object.h>
#include "libtracker-data/tracker-db-interface.h"
#include <stdlib.h>
#include <string.h>
#include "libtracker-data/tracker-data-manager.h"
#include <gio/gio.h>
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-data/tracker-db-interface-sqlite.h"
#include "tracker-store/tracker-events.h"
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_STORE (tracker_store_get_type ())
#define TRACKER_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STORE, TrackerStore))
#define TRACKER_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STORE, TrackerStoreClass))
#define TRACKER_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STORE))
#define TRACKER_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STORE))
#define TRACKER_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STORE, TrackerStoreClass))

typedef struct _TrackerStore TrackerStore;
typedef struct _TrackerStoreClass TrackerStoreClass;
typedef struct _TrackerStorePrivate TrackerStorePrivate;

#define TRACKER_STORE_TYPE_PRIORITY (tracker_store_priority_get_type ())

#define TRACKER_STORE_TYPE_TASK_TYPE (tracker_store_task_type_get_type ())

#define TRACKER_STORE_TYPE_TASK (tracker_store_task_get_type ())
#define TRACKER_STORE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_TASK, TrackerStoreTask))
#define TRACKER_STORE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_TASK, TrackerStoreTaskClass))
#define TRACKER_STORE_IS_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_TASK))
#define TRACKER_STORE_IS_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_TASK))
#define TRACKER_STORE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_TASK, TrackerStoreTaskClass))

typedef struct _TrackerStoreTask TrackerStoreTask;
typedef struct _TrackerStoreTaskClass TrackerStoreTaskClass;
#define _tracker_store_task_unref0(var) ((var == NULL) ? NULL : (var = (tracker_store_task_unref (var), NULL)))

#define TRACKER_STORE_TYPE_QUERY_TASK (tracker_store_query_task_get_type ())
#define TRACKER_STORE_QUERY_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask))
#define TRACKER_STORE_QUERY_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTaskClass))
#define TRACKER_STORE_IS_QUERY_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_QUERY_TASK))
#define TRACKER_STORE_IS_QUERY_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_QUERY_TASK))
#define TRACKER_STORE_QUERY_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTaskClass))

typedef struct _TrackerStoreQueryTask TrackerStoreQueryTask;
typedef struct _TrackerStoreQueryTaskClass TrackerStoreQueryTaskClass;
typedef struct _Block7Data Block7Data;
typedef struct _TrackerStoreTaskPrivate TrackerStoreTaskPrivate;
typedef struct _TrackerStoreQueryTaskPrivate TrackerStoreQueryTaskPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TRACKER_STORE_TYPE_UPDATE_TASK (tracker_store_update_task_get_type ())
#define TRACKER_STORE_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask))
#define TRACKER_STORE_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTaskClass))
#define TRACKER_STORE_IS_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_UPDATE_TASK))
#define TRACKER_STORE_IS_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_UPDATE_TASK))
#define TRACKER_STORE_UPDATE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTaskClass))

typedef struct _TrackerStoreUpdateTask TrackerStoreUpdateTask;
typedef struct _TrackerStoreUpdateTaskClass TrackerStoreUpdateTaskClass;
typedef struct _TrackerStoreUpdateTaskPrivate TrackerStoreUpdateTaskPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TRACKER_STORE_TYPE_TURTLE_TASK (tracker_store_turtle_task_get_type ())
#define TRACKER_STORE_TURTLE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTask))
#define TRACKER_STORE_TURTLE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTaskClass))
#define TRACKER_STORE_IS_TURTLE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_TURTLE_TASK))
#define TRACKER_STORE_IS_TURTLE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_TURTLE_TASK))
#define TRACKER_STORE_TURTLE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTaskClass))

typedef struct _TrackerStoreTurtleTask TrackerStoreTurtleTask;
typedef struct _TrackerStoreTurtleTaskClass TrackerStoreTurtleTaskClass;
typedef struct _TrackerStoreTurtleTaskPrivate TrackerStoreTurtleTaskPrivate;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define __g_queue_free__tracker_store_task_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__tracker_store_task_unref0_ (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerStoreSparqlQueryData TrackerStoreSparqlQueryData;
typedef struct _TrackerStoreSparqlUpdateData TrackerStoreSparqlUpdateData;
typedef struct _TrackerStoreSparqlUpdateBlankData TrackerStoreSparqlUpdateBlankData;
typedef struct _TrackerStoreQueueTurtleImportData TrackerStoreQueueTurtleImportData;
typedef struct _TrackerStorePauseData TrackerStorePauseData;
typedef struct _TrackerStoreParamSpecTask TrackerStoreParamSpecTask;
typedef struct _TrackerParamSpecStore TrackerParamSpecStore;

struct _TrackerStore {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStorePrivate * priv;
};

struct _TrackerStoreClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStore *self);
};

typedef enum  {
	TRACKER_STORE_PRIORITY_HIGH,
	TRACKER_STORE_PRIORITY_LOW,
	TRACKER_STORE_PRIORITY_TURTLE,
	TRACKER_STORE_PRIORITY_N_PRIORITIES
} TrackerStorePriority;

typedef enum  {
	TRACKER_STORE_TASK_TYPE_QUERY,
	TRACKER_STORE_TASK_TYPE_UPDATE,
	TRACKER_STORE_TASK_TYPE_UPDATE_BLANK,
	TRACKER_STORE_TASK_TYPE_TURTLE
} TrackerStoreTaskType;

struct _Block7Data {
	int _ref_count_;
	TrackerStoreQueryTask* query_task;
};

struct _TrackerStoreTask {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStoreTaskPrivate * priv;
	TrackerStoreTaskType type;
	gchar* client_id;
	GError* error;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	TrackerDataManager* data_manager;
};

struct _TrackerStoreTaskClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStoreTask *self);
};

typedef void (*TrackerStoreSparqlQueryInThread) (TrackerDBCursor* cursor, void* user_data, GError** error);
struct _TrackerStoreQueryTask {
	TrackerStoreTask parent_instance;
	TrackerStoreQueryTaskPrivate * priv;
	gchar* query;
	GCancellable* cancellable;
	guint watchdog_id;
	TrackerStoreSparqlQueryInThread in_thread;
	gpointer in_thread_target;
};

struct _TrackerStoreQueryTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _TrackerStoreUpdateTask {
	TrackerStoreTask parent_instance;
	TrackerStoreUpdateTaskPrivate * priv;
	gchar* query;
	GVariant* blank_nodes;
	TrackerStorePriority priority;
};

struct _TrackerStoreUpdateTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _Block8Data {
	int _ref_count_;
	TrackerStoreTask* task;
};

struct _TrackerStoreTurtleTask {
	TrackerStoreTask parent_instance;
	TrackerStoreTurtleTaskPrivate * priv;
	gchar* path;
};

struct _TrackerStoreTurtleTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _TrackerStoreSparqlQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDataManager* manager;
	gchar* sparql;
	TrackerStorePriority priority;
	TrackerStoreSparqlQueryInThread in_thread;
	gpointer in_thread_target;
	gchar* client_id;
	TrackerStoreQueryTask* task;
	TrackerStoreQueryTask* _tmp0_;
	TrackerStoreQueryTask* _tmp1_;
	TrackerStoreQueryTask* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreQueryTask* _tmp5_;
	GCancellable* _tmp6_;
	TrackerStoreQueryTask* _tmp7_;
	TrackerStoreSparqlQueryInThread _tmp8_;
	void* _tmp8__target;
	TrackerStoreQueryTask* _tmp9_;
	TrackerStoreQueryTask* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	TrackerStoreQueryTask* _tmp13_;
	TrackerDataManager* _tmp14_;
	TrackerDataManager* _tmp15_;
	TrackerStorePriority _tmp16_;
	GQueue* _tmp17_;
	TrackerStoreQueryTask* _tmp18_;
	TrackerStoreTask* _tmp19_;
	TrackerStoreQueryTask* _tmp20_;
	GError* _tmp21_;
	TrackerStoreQueryTask* _tmp22_;
	GError* _tmp23_;
	GError* _tmp24_;
	GError * _inner_error_;
};

struct _TrackerStoreSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDataManager* manager;
	gchar* sparql;
	TrackerStorePriority priority;
	gchar* client_id;
	TrackerStoreUpdateTask* task;
	TrackerStoreUpdateTask* _tmp0_;
	TrackerStoreUpdateTask* _tmp1_;
	TrackerStoreUpdateTask* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreUpdateTask* _tmp5_;
	TrackerStorePriority _tmp6_;
	TrackerStoreUpdateTask* _tmp7_;
	TrackerStoreUpdateTask* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	TrackerStoreUpdateTask* _tmp11_;
	TrackerDataManager* _tmp12_;
	TrackerDataManager* _tmp13_;
	TrackerStorePriority _tmp14_;
	GQueue* _tmp15_;
	TrackerStoreUpdateTask* _tmp16_;
	TrackerStoreTask* _tmp17_;
	TrackerStoreUpdateTask* _tmp18_;
	GError* _tmp19_;
	TrackerStoreUpdateTask* _tmp20_;
	GError* _tmp21_;
	GError* _tmp22_;
	GError * _inner_error_;
};

struct _TrackerStoreSparqlUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDataManager* manager;
	gchar* sparql;
	TrackerStorePriority priority;
	gchar* client_id;
	GVariant* result;
	TrackerStoreUpdateTask* task;
	TrackerStoreUpdateTask* _tmp0_;
	TrackerStoreUpdateTask* _tmp1_;
	TrackerStoreUpdateTask* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreUpdateTask* _tmp5_;
	TrackerStorePriority _tmp6_;
	TrackerStoreUpdateTask* _tmp7_;
	TrackerStoreUpdateTask* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	TrackerStoreUpdateTask* _tmp11_;
	TrackerDataManager* _tmp12_;
	TrackerDataManager* _tmp13_;
	TrackerStorePriority _tmp14_;
	GQueue* _tmp15_;
	TrackerStoreUpdateTask* _tmp16_;
	TrackerStoreTask* _tmp17_;
	TrackerStoreUpdateTask* _tmp18_;
	GError* _tmp19_;
	TrackerStoreUpdateTask* _tmp20_;
	GError* _tmp21_;
	GError* _tmp22_;
	TrackerStoreUpdateTask* _tmp23_;
	GVariant* _tmp24_;
	GVariant* _tmp25_;
	GError * _inner_error_;
};

struct _TrackerStoreQueueTurtleImportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDataManager* manager;
	GFile* file;
	gchar* client_id;
	TrackerStoreTurtleTask* task;
	TrackerStoreTurtleTask* _tmp0_;
	TrackerStoreTurtleTask* _tmp1_;
	TrackerStoreTurtleTask* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreTurtleTask* _tmp5_;
	TrackerStoreTurtleTask* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	TrackerStoreTurtleTask* _tmp9_;
	TrackerDataManager* _tmp10_;
	TrackerDataManager* _tmp11_;
	GQueue* _tmp12_;
	TrackerStoreTurtleTask* _tmp13_;
	TrackerStoreTask* _tmp14_;
	TrackerStoreTurtleTask* _tmp15_;
	GError* _tmp16_;
	TrackerStoreTurtleTask* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	GError * _inner_error_;
};

struct _TrackerStorePauseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gboolean _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	GThreadPool* _tmp4_;
	GThreadPool* _tmp5_;
	GThreadPool* _tmp6_;
	GError* e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	GError * _inner_error_;
};

struct _TrackerStoreParamSpecTask {
	GParamSpec parent_instance;
};

struct _TrackerParamSpecStore {
	GParamSpec parent_instance;
};


static gpointer tracker_store_parent_class = NULL;
static GQueue* tracker_store_query_queues[3];
static GQueue* tracker_store_query_queues[3] = {0};
static GQueue* tracker_store_update_queues[3];
static GQueue* tracker_store_update_queues[3] = {0};
static gint tracker_store_n_queries_running;
static gint tracker_store_n_queries_running = 0;
static gboolean tracker_store_update_running;
static gboolean tracker_store_update_running = FALSE;
static GThreadPool* tracker_store_update_pool;
static GThreadPool* tracker_store_update_pool = NULL;
static GThreadPool* tracker_store_query_pool;
static GThreadPool* tracker_store_query_pool = NULL;
static GThreadPool* tracker_store_checkpoint_pool;
static GThreadPool* tracker_store_checkpoint_pool = NULL;
static GPtrArray* tracker_store_running_tasks;
static GPtrArray* tracker_store_running_tasks = NULL;
static gint tracker_store_max_task_time;
static gint tracker_store_max_task_time = 0;
static gboolean tracker_store_active;
static gboolean tracker_store_active = FALSE;
static GSourceFunc tracker_store_active_callback;
static gpointer tracker_store_active_callback_target;
static GDestroyNotify tracker_store_active_callback_target_destroy_notify;
static GSourceFunc tracker_store_active_callback = NULL;
static gpointer tracker_store_active_callback_target = NULL;
static GDestroyNotify tracker_store_active_callback_target_destroy_notify = NULL;
static gint tracker_store_checkpointing;
static gint tracker_store_checkpointing = 0;
static gpointer tracker_store_task_parent_class = NULL;
static gpointer tracker_store_query_task_parent_class = NULL;
static gpointer tracker_store_update_task_parent_class = NULL;
static gpointer tracker_store_turtle_task_parent_class = NULL;

gpointer tracker_store_ref (gpointer instance);
void tracker_store_unref (gpointer instance);
GParamSpec* tracker_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_store (GValue* value, gpointer v_object);
void tracker_value_take_store (GValue* value, gpointer v_object);
gpointer tracker_value_get_store (const GValue* value);
GType tracker_store_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_STORE_DUMMY_PROPERTY
};
GType tracker_store_priority_get_type (void) G_GNUC_CONST;
static GType tracker_store_task_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gpointer tracker_store_task_ref (gpointer instance);
static void tracker_store_task_unref (gpointer instance);
static GParamSpec* tracker_store_param_spec_task (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void tracker_store_value_set_task (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void tracker_store_value_take_task (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer tracker_store_value_get_task (const GValue* value) G_GNUC_UNUSED;
static GType tracker_store_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_STORE_MAX_CONCURRENT_QUERIES 2
#define TRACKER_STORE_MAX_TASK_TIME 30
static void tracker_store_sched (void);
static GType tracker_store_query_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean ____lambda6_ (Block7Data* _data7_);
static gboolean _____lambda6__gsource_func (gpointer self);
static TrackerDataCommitType tracker_store_commit_type (TrackerStoreTask* task);
static GType tracker_store_update_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean tracker_store_task_finish_cb (TrackerStoreTask* task);
static void tracker_store_pool_dispatch_cb (TrackerStoreTask* task);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void tracker_store_wal_hook (TrackerDBInterface* iface, gint n_pages);
static void _tracker_store_wal_hook_tracker_db_wal_callback (TrackerDBInterface* iface, gint n_pages);
static GType tracker_store_turtle_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean __lambda7_ (Block8Data* _data8_);
static gboolean ___lambda7__gsource_func (gpointer self);
void tracker_store_wal_checkpoint (TrackerDBInterface* iface, gboolean blocking);
static void tracker_store_checkpoint_dispatch_cb (TrackerDBInterface* iface);
void tracker_store_init (void);
static void _tracker_store_task_unref0_ (gpointer var);
static void _g_queue_free__tracker_store_task_unref0_ (GQueue* self);
static void _tracker_store_pool_dispatch_cb_gfunc (gpointer data, gpointer self);
static void _tracker_store_checkpoint_dispatch_cb_gfunc (gconstpointer data, gpointer self);
void tracker_store_shutdown (void);
static void tracker_store_sparql_query_data_free (gpointer _data);
void tracker_store_sparql_query (TrackerDataManager* manager, const gchar* sparql, TrackerStorePriority priority, TrackerStoreSparqlQueryInThread in_thread, void* in_thread_target, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_query_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* _data_);
static TrackerStoreQueryTask* tracker_store_query_task_new (void);
static TrackerStoreQueryTask* tracker_store_query_task_construct (GType object_type);
static gboolean _tracker_store_sparql_query_co_gsource_func (gpointer self);
static void tracker_store_sparql_update_data_free (gpointer _data);
void tracker_store_sparql_update (TrackerDataManager* manager, const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_update_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* _data_);
static TrackerStoreUpdateTask* tracker_store_update_task_new (void);
static TrackerStoreUpdateTask* tracker_store_update_task_construct (GType object_type);
static gboolean _tracker_store_sparql_update_co_gsource_func (gpointer self);
static void tracker_store_sparql_update_blank_data_free (gpointer _data);
void tracker_store_sparql_update_blank (TrackerDataManager* manager, const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* _data_);
static gboolean _tracker_store_sparql_update_blank_co_gsource_func (gpointer self);
static void tracker_store_queue_turtle_import_data_free (gpointer _data);
void tracker_store_queue_turtle_import (TrackerDataManager* manager, GFile* file, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* _data_);
static TrackerStoreTurtleTask* tracker_store_turtle_task_new (void);
static TrackerStoreTurtleTask* tracker_store_turtle_task_construct (GType object_type);
static gboolean _tracker_store_queue_turtle_import_co_gsource_func (gpointer self);
guint tracker_store_get_queue_size (TrackerStore* self);
void tracker_store_unreg_batches (const gchar* client_id);
static void tracker_store_pause_data_free (gpointer _data);
void tracker_store_pause (GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_pause_finish (GAsyncResult* _res_);
static gboolean tracker_store_pause_co (TrackerStorePauseData* _data_);
static gboolean _tracker_store_pause_co_gsource_func (gpointer self);
void tracker_store_resume (void);
TrackerStore* tracker_store_new (void);
TrackerStore* tracker_store_construct (GType object_type);
enum  {
	TRACKER_STORE_TASK_DUMMY_PROPERTY
};
static TrackerStoreTask* tracker_store_task_construct (GType object_type);
static void tracker_store_task_finalize (TrackerStoreTask * obj);
enum  {
	TRACKER_STORE_QUERY_TASK_DUMMY_PROPERTY
};
static void tracker_store_query_task_finalize (TrackerStoreTask * obj);
enum  {
	TRACKER_STORE_UPDATE_TASK_DUMMY_PROPERTY
};
static void tracker_store_update_task_finalize (TrackerStoreTask * obj);
enum  {
	TRACKER_STORE_TURTLE_TASK_DUMMY_PROPERTY
};
static void tracker_store_turtle_task_finalize (TrackerStoreTask * obj);
static void tracker_store_finalize (TrackerStore * obj);


GType tracker_store_priority_get_type (void) {
	static volatile gsize tracker_store_priority_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_priority_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_STORE_PRIORITY_HIGH, "TRACKER_STORE_PRIORITY_HIGH", "high"}, {TRACKER_STORE_PRIORITY_LOW, "TRACKER_STORE_PRIORITY_LOW", "low"}, {TRACKER_STORE_PRIORITY_TURTLE, "TRACKER_STORE_PRIORITY_TURTLE", "turtle"}, {TRACKER_STORE_PRIORITY_N_PRIORITIES, "TRACKER_STORE_PRIORITY_N_PRIORITIES", "n-priorities"}, {0, NULL, NULL}};
		GType tracker_store_priority_type_id;
		tracker_store_priority_type_id = g_enum_register_static ("TrackerStorePriority", values);
		g_once_init_leave (&tracker_store_priority_type_id__volatile, tracker_store_priority_type_id);
	}
	return tracker_store_priority_type_id__volatile;
}


static GType tracker_store_task_type_get_type (void) {
	static volatile gsize tracker_store_task_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_task_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_STORE_TASK_TYPE_QUERY, "TRACKER_STORE_TASK_TYPE_QUERY", "query"}, {TRACKER_STORE_TASK_TYPE_UPDATE, "TRACKER_STORE_TASK_TYPE_UPDATE", "update"}, {TRACKER_STORE_TASK_TYPE_UPDATE_BLANK, "TRACKER_STORE_TASK_TYPE_UPDATE_BLANK", "update-blank"}, {TRACKER_STORE_TASK_TYPE_TURTLE, "TRACKER_STORE_TASK_TYPE_TURTLE", "turtle"}, {0, NULL, NULL}};
		GType tracker_store_task_type_type_id;
		tracker_store_task_type_type_id = g_enum_register_static ("TrackerStoreTaskType", values);
		g_once_init_leave (&tracker_store_task_type_type_id__volatile, tracker_store_task_type_type_id);
	}
	return tracker_store_task_type_type_id__volatile;
}


static gpointer _tracker_store_task_ref0 (gpointer self) {
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? tracker_store_task_ref (self) : NULL;
#line 547 "tracker-store.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return _data7_;
#line 556 "tracker-store.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data7_->query_task);
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_slice_free (Block7Data, _data7_);
#line 569 "tracker-store.c"
	}
}


static gboolean ____lambda6_ (Block7Data* _data7_) {
	gboolean result = FALSE;
	TrackerStoreQueryTask* _tmp0_;
	GCancellable* _tmp1_;
	TrackerStoreQueryTask* _tmp2_;
#line 109 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = _data7_->query_task;
#line 109 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tmp0_->cancellable;
#line 109 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_cancellable_cancel (_tmp1_);
#line 110 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = _data7_->query_task;
#line 110 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_->watchdog_id = (guint) 0;
#line 111 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 111 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 593 "tracker-store.c"
}


static gboolean _____lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda6_ (self);
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 602 "tracker-store.c"
}


static void tracker_store_sched (void) {
	TrackerStoreTask* task = NULL;
	gboolean _tmp0_;
	gboolean _tmp23_;
	GError * _inner_error_ = NULL;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	task = NULL;
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = tracker_store_active;
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!_tmp0_) {
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (task);
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 621 "tracker-store.c"
	}
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	while (TRUE) {
#line 625 "tracker-store.c"
		gint _tmp1_;
		TrackerStoreTask* _tmp9_;
		GPtrArray* _tmp10_;
		TrackerStoreTask* _tmp11_;
		TrackerStoreTask* _tmp12_;
		gint _tmp13_;
		gint _tmp19_;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = tracker_store_n_queries_running;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (!(_tmp1_ < TRACKER_STORE_MAX_CONCURRENT_QUERIES)) {
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			break;
#line 639 "tracker-store.c"
		}
		{
			gint i = 0;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			i = 0;
#line 645 "tracker-store.c"
			{
				gboolean _tmp2_ = FALSE;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = TRUE;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 652 "tracker-store.c"
					gint _tmp4_;
					gint _tmp5_;
					GQueue* _tmp6_;
					gpointer _tmp7_;
					TrackerStoreTask* _tmp8_;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!_tmp2_) {
#line 660 "tracker-store.c"
						gint _tmp3_;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp3_ = i;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						i = _tmp3_ + 1;
#line 666 "tracker-store.c"
					}
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp2_ = FALSE;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp4_ = i;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp4_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 676 "tracker-store.c"
					}
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp5_ = i;
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp6_ = tracker_store_query_queues[_tmp5_];
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp7_ = g_queue_pop_head (_tmp6_);
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (task);
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp7_;
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp8_ = task;
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp8_ != NULL) {
#line 97 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 694 "tracker-store.c"
					}
				}
			}
		}
#line 100 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp9_ = task;
#line 100 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp9_ == NULL) {
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			break;
#line 705 "tracker-store.c"
		}
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp10_ = tracker_store_running_tasks;
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp11_ = task;
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp12_ = _tracker_store_task_ref0 (_tmp11_);
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_ptr_array_add (_tmp10_, _tmp12_);
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp13_ = tracker_store_max_task_time;
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp13_ != 0) {
#line 719 "tracker-store.c"
			Block7Data* _data7_;
			TrackerStoreTask* _tmp14_;
			TrackerStoreQueryTask* _tmp15_;
			TrackerStoreQueryTask* _tmp16_;
			gint _tmp17_;
			guint _tmp18_;
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_ = g_slice_new0 (Block7Data);
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_->_ref_count_ = 1;
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp14_ = task;
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp15_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask));
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_->query_task = _tmp15_;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_ = _data7_->query_task;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_ = tracker_store_max_task_time;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp18_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp17_, _____lambda6__gsource_func, block7_data_ref (_data7_), block7_data_unref);
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_->watchdog_id = _tmp18_;
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			block7_data_unref (_data7_);
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_ = NULL;
#line 748 "tracker-store.c"
		}
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp19_ = tracker_store_n_queries_running;
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_n_queries_running = _tmp19_ + 1;
#line 754 "tracker-store.c"
		{
			GThreadPool* _tmp20_;
			TrackerStoreTask* _tmp21_;
			TrackerStoreTask* _tmp22_;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp20_ = tracker_store_query_pool;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp21_ = task;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp22_ = _tracker_store_task_ref0 (_tmp21_);
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_thread_pool_push (_tmp20_, _tmp22_, &_inner_error_);
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 769 "tracker-store.c"
				goto __catch19_g_error;
			}
		}
		goto __finally19;
		__catch19_g_error:
		{
			GError* e = NULL;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			e = _inner_error_;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_inner_error_ = NULL;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (e);
#line 783 "tracker-store.c"
		}
		__finally19:
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tracker_store_task_unref0 (task);
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_clear_error (&_inner_error_);
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return;
#line 796 "tracker-store.c"
		}
	}
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp23_ = tracker_store_update_running;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!_tmp23_) {
#line 803 "tracker-store.c"
		TrackerStoreTask* _tmp31_;
		{
			gint i = 0;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			i = 0;
#line 809 "tracker-store.c"
			{
				gboolean _tmp24_ = FALSE;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp24_ = TRUE;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 816 "tracker-store.c"
					gint _tmp26_;
					gint _tmp27_;
					GQueue* _tmp28_;
					gpointer _tmp29_;
					TrackerStoreTask* _tmp30_;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!_tmp24_) {
#line 824 "tracker-store.c"
						gint _tmp25_;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp25_ = i;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						i = _tmp25_ + 1;
#line 830 "tracker-store.c"
					}
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp24_ = FALSE;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp26_ = i;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp26_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 840 "tracker-store.c"
					}
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp27_ = i;
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_ = tracker_store_update_queues[_tmp27_];
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_ = g_queue_pop_head (_tmp28_);
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (task);
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp29_;
#line 126 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp30_ = task;
#line 126 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp30_ != NULL) {
#line 127 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 858 "tracker-store.c"
					}
				}
			}
		}
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp31_ = task;
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp31_ != NULL) {
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_update_running = TRUE;
#line 869 "tracker-store.c"
			{
				GThreadPool* _tmp32_;
				TrackerStoreTask* _tmp33_;
				TrackerStoreTask* _tmp34_;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp32_ = tracker_store_update_pool;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp33_ = task;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp34_ = _tracker_store_task_ref0 (_tmp33_);
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_thread_pool_push (_tmp32_, _tmp34_, &_inner_error_);
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 884 "tracker-store.c"
					goto __catch20_g_error;
				}
			}
			goto __finally20;
			__catch20_g_error:
			{
				GError* e = NULL;
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				e = _inner_error_;
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_inner_error_ = NULL;
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (e);
#line 898 "tracker-store.c"
			}
			__finally20:
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (task);
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_clear_error (&_inner_error_);
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return;
#line 911 "tracker-store.c"
			}
		}
	}
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (task);
#line 917 "tracker-store.c"
}


static TrackerDataCommitType tracker_store_commit_type (TrackerStoreTask* task) {
	TrackerDataCommitType result = 0;
	TrackerStoreTask* _tmp0_;
	TrackerStoreTaskType _tmp1_;
#line 141 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (task != NULL, 0);
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = task;
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tmp0_->type;
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_tmp1_) {
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_UPDATE:
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_UPDATE_BLANK:
#line 937 "tracker-store.c"
		{
			TrackerStoreTask* _tmp2_;
			TrackerStorePriority _tmp3_;
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp2_ = task;
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask)->priority;
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp3_ == TRACKER_STORE_PRIORITY_HIGH) {
#line 146 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_REGULAR;
#line 146 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 951 "tracker-store.c"
			} else {
				GQueue* _tmp4_;
				guint _tmp5_;
#line 147 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_LOW];
#line 147 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = g_queue_get_length (_tmp4_);
#line 147 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp5_ > ((guint) 0)) {
#line 148 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					result = TRACKER_DATA_COMMIT_BATCH;
#line 148 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					return result;
#line 965 "tracker-store.c"
				} else {
#line 150 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					result = TRACKER_DATA_COMMIT_BATCH_LAST;
#line 150 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					return result;
#line 971 "tracker-store.c"
				}
			}
		}
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_TURTLE:
#line 977 "tracker-store.c"
		{
			GQueue* _tmp6_;
			guint _tmp7_;
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_TURTLE];
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp7_ = g_queue_get_length (_tmp6_);
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp7_ > ((guint) 0)) {
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_BATCH;
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 991 "tracker-store.c"
			} else {
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_BATCH_LAST;
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 997 "tracker-store.c"
			}
		}
		default:
		{
#line 159 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_warn_if_reached ();
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			result = TRACKER_DATA_COMMIT_REGULAR;
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return result;
#line 1008 "tracker-store.c"
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 1017 "tracker-store.c"
}


static gboolean tracker_store_task_finish_cb (TrackerStoreTask* task) {
	gboolean result = FALSE;
	TrackerData* data = NULL;
	TrackerStoreTask* _tmp0_;
	TrackerDataManager* _tmp1_;
	TrackerData* _tmp2_;
	TrackerData* _tmp3_;
	TrackerStoreTask* _tmp4_;
	TrackerStoreTaskType _tmp5_;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	gint _tmp50_;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (task != NULL, FALSE);
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = task;
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tmp0_->data_manager;
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = tracker_data_manager_get_data (_tmp1_);
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	data = _tmp3_;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = task;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp5_ = _tmp4_->type;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp5_ == TRACKER_STORE_TASK_TYPE_QUERY) {
#line 1051 "tracker-store.c"
		TrackerStoreQueryTask* query_task = NULL;
		TrackerStoreTask* _tmp6_;
		TrackerStoreQueryTask* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		TrackerStoreTask* _tmp10_;
		GError* _tmp11_;
		TrackerStoreTask* _tmp19_;
		GSourceFunc _tmp20_;
		void* _tmp20__target;
		TrackerStoreTask* _tmp21_;
		GPtrArray* _tmp22_;
		TrackerStoreTask* _tmp23_;
		gint _tmp24_;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp6_ = task;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp7_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask));
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		query_task = _tmp7_;
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp10_ = task;
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp11_ = _tmp10_->error;
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp11_ == NULL) {
#line 1078 "tracker-store.c"
			TrackerStoreQueryTask* _tmp12_;
			GCancellable* _tmp13_;
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp12_ = query_task;
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp13_ = _tmp12_->cancellable;
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp9_ = _tmp13_ != NULL;
#line 1087 "tracker-store.c"
		} else {
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp9_ = FALSE;
#line 1091 "tracker-store.c"
		}
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp9_) {
#line 1095 "tracker-store.c"
			TrackerStoreQueryTask* _tmp14_;
			GCancellable* _tmp15_;
			gboolean _tmp16_;
#line 172 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp14_ = query_task;
#line 172 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp15_ = _tmp14_->cancellable;
#line 172 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_ = g_cancellable_is_cancelled (_tmp15_);
#line 172 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp8_ = _tmp16_;
#line 1107 "tracker-store.c"
		} else {
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp8_ = FALSE;
#line 1111 "tracker-store.c"
		}
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp8_) {
#line 1115 "tracker-store.c"
			TrackerStoreTask* _tmp17_;
			GError* _tmp18_;
#line 173 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_ = task;
#line 173 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp18_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 173 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (_tmp17_->error);
#line 173 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_->error = _tmp18_;
#line 1126 "tracker-store.c"
		}
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp19_ = task;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp20_ = _tmp19_->callback;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp20__target = _tmp19_->callback_target;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp20_ (_tmp20__target);
#line 177 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp21_ = task;
#line 177 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (_tmp21_->error);
#line 177 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp21_->error = NULL;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp22_ = tracker_store_running_tasks;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp23_ = task;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_ptr_array_remove (_tmp22_, _tmp23_);
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp24_ = tracker_store_n_queries_running;
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_n_queries_running = _tmp24_ - 1;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (query_task);
#line 1154 "tracker-store.c"
	} else {
		gboolean _tmp25_ = FALSE;
		TrackerStoreTask* _tmp26_;
		TrackerStoreTaskType _tmp27_;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp26_ = task;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp27_ = _tmp26_->type;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp27_ == TRACKER_STORE_TASK_TYPE_UPDATE) {
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp25_ = TRUE;
#line 1167 "tracker-store.c"
		} else {
			TrackerStoreTask* _tmp28_;
			TrackerStoreTaskType _tmp29_;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp28_ = task;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp29_ = _tmp28_->type;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp25_ = _tmp29_ == TRACKER_STORE_TASK_TYPE_UPDATE_BLANK;
#line 1177 "tracker-store.c"
		}
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp25_) {
#line 1181 "tracker-store.c"
			TrackerStoreTask* _tmp30_;
			GError* _tmp31_;
			TrackerStoreTask* _tmp35_;
			GSourceFunc _tmp36_;
			void* _tmp36__target;
			TrackerStoreTask* _tmp37_;
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp30_ = task;
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp31_ = _tmp30_->error;
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp31_ == NULL) {
#line 1194 "tracker-store.c"
				TrackerData* _tmp32_;
				TrackerStoreTask* _tmp33_;
				TrackerDataCommitType _tmp34_;
#line 183 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp32_ = data;
#line 183 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp33_ = task;
#line 183 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp34_ = tracker_store_commit_type (_tmp33_);
#line 183 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_data_notify_transaction (_tmp32_, _tmp34_);
#line 1206 "tracker-store.c"
			}
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp35_ = task;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp36_ = _tmp35_->callback;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp36__target = _tmp35_->callback_target;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp36_ (_tmp36__target);
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp37_ = task;
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (_tmp37_->error);
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp37_->error = NULL;
#line 189 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_update_running = FALSE;
#line 1224 "tracker-store.c"
		} else {
			TrackerStoreTask* _tmp38_;
			TrackerStoreTaskType _tmp39_;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp38_ = task;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp39_ = _tmp38_->type;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp39_ == TRACKER_STORE_TASK_TYPE_TURTLE) {
#line 1234 "tracker-store.c"
				TrackerStoreTask* _tmp40_;
				GError* _tmp41_;
				TrackerStoreTask* _tmp45_;
				GSourceFunc _tmp46_;
				void* _tmp46__target;
				TrackerStoreTask* _tmp47_;
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp40_ = task;
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp41_ = _tmp40_->error;
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp41_ == NULL) {
#line 1247 "tracker-store.c"
					TrackerData* _tmp42_;
					TrackerStoreTask* _tmp43_;
					TrackerDataCommitType _tmp44_;
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp42_ = data;
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp43_ = task;
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp44_ = tracker_store_commit_type (_tmp43_);
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					tracker_data_notify_transaction (_tmp42_, _tmp44_);
#line 1259 "tracker-store.c"
				}
#line 195 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp45_ = task;
#line 195 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp46_ = _tmp45_->callback;
#line 195 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp46__target = _tmp45_->callback_target;
#line 195 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp46_ (_tmp46__target);
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp47_ = task;
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (_tmp47_->error);
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp47_->error = NULL;
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_running = FALSE;
#line 1277 "tracker-store.c"
			}
		}
	}
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp50_ = tracker_store_n_queries_running;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp50_ == 0) {
#line 1285 "tracker-store.c"
		gboolean _tmp51_;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp51_ = tracker_store_update_running;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp49_ = !_tmp51_;
#line 1291 "tracker-store.c"
	} else {
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp49_ = FALSE;
#line 1295 "tracker-store.c"
	}
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp49_) {
#line 1299 "tracker-store.c"
		GSourceFunc _tmp52_;
		void* _tmp52__target;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp52_ = tracker_store_active_callback;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp52__target = tracker_store_active_callback_target;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp48_ = _tmp52_ != NULL;
#line 1308 "tracker-store.c"
	} else {
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp48_ = FALSE;
#line 1312 "tracker-store.c"
	}
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp48_) {
#line 1316 "tracker-store.c"
		GSourceFunc _tmp53_;
		void* _tmp53__target;
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp53_ = tracker_store_active_callback;
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp53__target = tracker_store_active_callback_target;
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp53_ (_tmp53__target);
#line 1325 "tracker-store.c"
	}
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (data);
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1335 "tracker-store.c"
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return _data8_;
#line 1344 "tracker-store.c"
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data8_->task);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_slice_free (Block8Data, _data8_);
#line 1357 "tracker-store.c"
	}
}


static void _tracker_store_wal_hook_tracker_db_wal_callback (TrackerDBInterface* iface, gint n_pages) {
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_wal_hook (iface, n_pages);
#line 1365 "tracker-store.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_error_copy (self) : NULL;
#line 1372 "tracker-store.c"
}


static gboolean __lambda7_ (Block8Data* _data8_) {
	gboolean result = FALSE;
	TrackerStoreTask* _tmp0_;
#line 249 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = _data8_->task;
#line 249 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_task_finish_cb (_tmp0_);
#line 250 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 250 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1387 "tracker-store.c"
}


static gboolean ___lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda7_ (self);
#line 248 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1396 "tracker-store.c"
}


static void tracker_store_pool_dispatch_cb (TrackerStoreTask* task) {
	Block8Data* _data8_;
	TrackerStoreTask* _tmp0_;
	GError * _inner_error_ = NULL;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (task != NULL);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_->_ref_count_ = 1;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = task;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data8_->task);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_->task = _tmp0_;
#line 1416 "tracker-store.c"
	{
		TrackerStoreTask* _tmp1_;
		TrackerStoreTaskType _tmp2_;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = _data8_->task;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp2_ = _tmp1_->type;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp2_ == TRACKER_STORE_TASK_TYPE_QUERY) {
#line 1426 "tracker-store.c"
			TrackerStoreQueryTask* query_task = NULL;
			TrackerStoreTask* _tmp3_;
			TrackerStoreQueryTask* _tmp4_;
			TrackerDBCursor* cursor = NULL;
			TrackerStoreTask* _tmp5_;
			TrackerDataManager* _tmp6_;
			TrackerStoreQueryTask* _tmp7_;
			const gchar* _tmp8_;
			TrackerDBCursor* _tmp9_;
			TrackerStoreQueryTask* _tmp10_;
			TrackerStoreSparqlQueryInThread _tmp11_;
			void* _tmp11__target;
			TrackerDBCursor* _tmp12_;
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp3_ = _data8_->task;
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp4_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask));
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			query_task = _tmp4_;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp5_ = _data8_->task;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = _tmp5_->data_manager;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp7_ = query_task;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp8_ = _tmp7_->query;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp9_ = tracker_data_query_sparql_cursor (_tmp6_, _tmp8_, &_inner_error_);
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			cursor = _tmp9_;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (query_task);
#line 1462 "tracker-store.c"
				goto __catch21_g_error;
			}
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp10_ = query_task;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp11_ = _tmp10_->in_thread;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp11__target = _tmp10_->in_thread_target;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp12_ = cursor;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp11_ (_tmp12_, _tmp11__target, &_inner_error_);
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_object_unref0 (cursor);
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (query_task);
#line 1481 "tracker-store.c"
				goto __catch21_g_error;
			}
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (cursor);
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tracker_store_task_unref0 (query_task);
#line 1488 "tracker-store.c"
		} else {
			TrackerData* data = NULL;
			TrackerStoreTask* _tmp13_;
			TrackerDataManager* _tmp14_;
			TrackerData* _tmp15_;
			TrackerData* _tmp16_;
			TrackerDBInterface* iface = NULL;
			TrackerStoreTask* _tmp17_;
			TrackerDataManager* _tmp18_;
			TrackerDBInterface* _tmp19_;
			TrackerDBInterface* _tmp20_;
			TrackerDBInterface* _tmp21_;
			TrackerStoreTask* _tmp22_;
			TrackerStoreTaskType _tmp23_;
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp13_ = _data8_->task;
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp14_ = _tmp13_->data_manager;
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp15_ = tracker_data_manager_get_data (_tmp14_);
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_ = _g_object_ref0 (_tmp15_);
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			data = _tmp16_;
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_ = _data8_->task;
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp18_ = _tmp17_->data_manager;
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp19_ = tracker_data_manager_get_writable_db_interface (_tmp18_);
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp20_ = _g_object_ref0 (_tmp19_);
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			iface = _tmp20_;
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp21_ = iface;
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_db_interface_sqlite_wal_hook (_tmp21_, _tracker_store_wal_hook_tracker_db_wal_callback);
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp22_ = _data8_->task;
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp23_ = _tmp22_->type;
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp23_ == TRACKER_STORE_TASK_TYPE_UPDATE) {
#line 1533 "tracker-store.c"
				TrackerStoreUpdateTask* update_task = NULL;
				TrackerStoreTask* _tmp24_;
				TrackerStoreUpdateTask* _tmp25_;
				TrackerData* _tmp26_;
				TrackerStoreUpdateTask* _tmp27_;
				const gchar* _tmp28_;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp24_ = _data8_->task;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp25_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask));
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				update_task = _tmp25_;
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp26_ = data;
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp27_ = update_task;
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp28_ = _tmp27_->query;
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_data_update_sparql (_tmp26_, _tmp28_, &_inner_error_);
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (update_task);
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_object_unref0 (iface);
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_object_unref0 (data);
#line 1562 "tracker-store.c"
					goto __catch21_g_error;
				}
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (update_task);
#line 1567 "tracker-store.c"
			} else {
				TrackerStoreTask* _tmp29_;
				TrackerStoreTaskType _tmp30_;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp29_ = _data8_->task;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp30_ = _tmp29_->type;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp30_ == TRACKER_STORE_TASK_TYPE_UPDATE_BLANK) {
#line 1577 "tracker-store.c"
					TrackerStoreUpdateTask* update_task = NULL;
					TrackerStoreTask* _tmp31_;
					TrackerStoreUpdateTask* _tmp32_;
					GVariant* _tmp33_ = NULL;
					TrackerData* _tmp34_;
					TrackerStoreUpdateTask* _tmp35_;
					const gchar* _tmp36_;
					GVariant* _tmp37_;
					TrackerStoreUpdateTask* _tmp38_;
					GVariant* _tmp39_;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp31_ = _data8_->task;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp32_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask));
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					update_task = _tmp32_;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp34_ = data;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp35_ = update_task;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp36_ = _tmp35_->query;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp37_ = tracker_data_update_sparql_blank (_tmp34_, _tmp36_, &_inner_error_);
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp33_ = _tmp37_;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tracker_store_task_unref0 (update_task);
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_object_unref0 (iface);
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_object_unref0 (data);
#line 1612 "tracker-store.c"
						goto __catch21_g_error;
					}
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp38_ = update_task;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp39_ = _tmp33_;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp33_ = NULL;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_variant_unref0 (_tmp38_->blank_nodes);
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp38_->blank_nodes = _tmp39_;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_variant_unref0 (_tmp33_);
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (update_task);
#line 1629 "tracker-store.c"
				} else {
					TrackerStoreTask* _tmp40_;
					TrackerStoreTaskType _tmp41_;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp40_ = _data8_->task;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp41_ = _tmp40_->type;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp41_ == TRACKER_STORE_TASK_TYPE_TURTLE) {
#line 1639 "tracker-store.c"
						TrackerStoreTurtleTask* turtle_task = NULL;
						TrackerStoreTask* _tmp42_;
						TrackerStoreTurtleTask* _tmp43_;
						GFile* file = NULL;
						TrackerStoreTurtleTask* _tmp44_;
						const gchar* _tmp45_;
						GFile* _tmp46_;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp42_ = _data8_->task;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp43_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTask));
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						turtle_task = _tmp43_;
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp44_ = turtle_task;
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp45_ = _tmp44_->path;
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp46_ = g_file_new_for_path (_tmp45_);
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						file = _tmp46_;
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						tracker_events_freeze ();
#line 1663 "tracker-store.c"
						{
							TrackerData* _tmp47_;
							GFile* _tmp48_;
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_tmp47_ = data;
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_tmp48_ = file;
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							tracker_data_load_turtle_file (_tmp47_, _tmp48_, &_inner_error_);
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1675 "tracker-store.c"
								goto __finally22;
							}
						}
						__finally22:
						{
#line 240 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							tracker_events_reset_pending ();
#line 1683 "tracker-store.c"
						}
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_g_object_unref0 (file);
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_tracker_store_task_unref0 (turtle_task);
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_g_object_unref0 (iface);
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_g_object_unref0 (data);
#line 1695 "tracker-store.c"
							goto __catch21_g_error;
						}
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_object_unref0 (file);
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tracker_store_task_unref0 (turtle_task);
#line 1702 "tracker-store.c"
					}
				}
			}
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (iface);
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (data);
#line 1710 "tracker-store.c"
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		TrackerStoreTask* _tmp49_;
		GError* _tmp50_;
		GError* _tmp51_;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp49_ = _data8_->task;
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp50_ = e;
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp51_ = _g_error_copy0 (_tmp50_);
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (_tmp49_->error);
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp49_->error = _tmp51_;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 1736 "tracker-store.c"
	}
	__finally21:
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		block8_data_unref (_data8_);
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data8_ = NULL;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 1751 "tracker-store.c"
	}
#line 248 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda7__gsource_func, block8_data_ref (_data8_), block8_data_unref);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	block8_data_unref (_data8_);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_ = NULL;
#line 1759 "tracker-store.c"
}


void tracker_store_wal_checkpoint (TrackerDBInterface* iface, gboolean blocking) {
	GError * _inner_error_ = NULL;
#line 254 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (iface != NULL);
#line 1767 "tracker-store.c"
	{
		TrackerDBInterface* _tmp0_;
		gboolean _tmp1_;
#line 256 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_debug ("Checkpointing database...");
#line 257 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp0_ = iface;
#line 257 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = blocking;
#line 257 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_db_interface_sqlite_wal_checkpoint (_tmp0_, _tmp1_, &_inner_error_);
#line 257 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1781 "tracker-store.c"
			goto __catch23_g_error;
		}
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_debug ("Checkpointing complete...");
#line 1786 "tracker-store.c"
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 260 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp2_ = e;
#line 260 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp3_ = _tmp2_->message;
#line 260 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_warning ("%s", _tmp3_);
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 1806 "tracker-store.c"
	}
	__finally23:
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 1817 "tracker-store.c"
	}
}


static void tracker_store_wal_hook (TrackerDBInterface* iface, gint n_pages) {
	TrackerDataManager* manager = NULL;
	TrackerDBInterface* _tmp0_;
	GObject* _tmp1_;
	TrackerDataManager* _tmp2_;
	TrackerDBInterface* wal_iface = NULL;
	TrackerDataManager* _tmp3_;
	TrackerDBInterface* _tmp4_;
	TrackerDBInterface* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GError * _inner_error_ = NULL;
#line 266 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (iface != NULL);
#line 268 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = iface;
#line 268 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = tracker_db_interface_get_user_data (_tmp0_);
#line 268 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TRACKER_TYPE_DATA_MANAGER, TrackerDataManager));
#line 268 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	manager = _tmp2_;
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = manager;
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = tracker_data_manager_get_wal_db_interface (_tmp3_);
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	wal_iface = _tmp5_;
#line 271 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp6_ = n_pages;
#line 271 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_debug ("WAL: %d pages", _tmp6_);
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp7_ = n_pages;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp7_ >= 10000) {
#line 1860 "tracker-store.c"
		TrackerDBInterface* _tmp8_;
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp8_ = wal_iface;
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_wal_checkpoint (_tmp8_, TRUE);
#line 1866 "tracker-store.c"
	} else {
		gboolean _tmp9_ = FALSE;
		gint _tmp10_;
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp10_ = n_pages;
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp10_ >= 1000) {
#line 1874 "tracker-store.c"
			GThreadPool* _tmp11_;
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp11_ = tracker_store_checkpoint_pool;
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp9_ = _tmp11_ != NULL;
#line 1880 "tracker-store.c"
		} else {
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp9_ = FALSE;
#line 1884 "tracker-store.c"
		}
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp9_) {
#line 1888 "tracker-store.c"
			gboolean _tmp12_;
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp12_ = g_atomic_int_compare_and_exchange ((volatile gint *) (&tracker_store_checkpointing), 0, 1);
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp12_) {
#line 1894 "tracker-store.c"
				{
					GThreadPool* _tmp13_;
					TrackerDBInterface* _tmp14_;
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp13_ = tracker_store_checkpoint_pool;
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp14_ = wal_iface;
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_thread_pool_push (_tmp13_, _tmp14_, &_inner_error_);
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1906 "tracker-store.c"
						goto __catch24_g_error;
					}
				}
				goto __finally24;
				__catch24_g_error:
				{
					GError* e = NULL;
					GError* _tmp15_;
					const gchar* _tmp16_;
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					e = _inner_error_;
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_inner_error_ = NULL;
#line 283 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp15_ = e;
#line 283 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp16_ = _tmp15_->message;
#line 283 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_warning ("%s", _tmp16_);
#line 284 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_atomic_int_set ((volatile gint *) (&tracker_store_checkpointing), 0);
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_error_free0 (e);
#line 1930 "tracker-store.c"
				}
				__finally24:
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_object_unref0 (wal_iface);
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_object_unref0 (manager);
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_clear_error (&_inner_error_);
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					return;
#line 1945 "tracker-store.c"
				}
			}
		}
	}
#line 266 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (wal_iface);
#line 266 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (manager);
#line 1954 "tracker-store.c"
}


static void tracker_store_checkpoint_dispatch_cb (TrackerDBInterface* iface) {
	TrackerDBInterface* _tmp0_;
#line 290 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (iface != NULL);
#line 292 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = iface;
#line 292 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_wal_checkpoint (_tmp0_, FALSE);
#line 293 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_set ((volatile gint *) (&tracker_store_checkpointing), 0);
#line 1968 "tracker-store.c"
}


static void _tracker_store_task_unref0_ (gpointer var) {
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(var == NULL) ? NULL : (var = (tracker_store_task_unref (var), NULL));
#line 1975 "tracker-store.c"
}


static void _g_queue_free__tracker_store_task_unref0_ (GQueue* self) {
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_foreach (self, (GFunc) _tracker_store_task_unref0_, NULL);
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_free (self);
#line 1984 "tracker-store.c"
}


static void _tracker_store_pool_dispatch_cb_gfunc (gpointer data, gpointer self) {
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_pool_dispatch_cb ((TrackerStoreTask*) data);
#line 1991 "tracker-store.c"
}


static void _tracker_store_checkpoint_dispatch_cb_gfunc (gconstpointer data, gpointer self) {
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_checkpoint_dispatch_cb ((TrackerDBInterface*) data);
#line 1998 "tracker-store.c"
}


void tracker_store_init (void) {
	gchar* max_task_time_env = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GPtrArray* _tmp5_;
	GError * _inner_error_ = NULL;
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = g_getenv ("TRACKER_STORE_MAX_TASK_TIME");
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	max_task_time_env = _tmp1_;
#line 298 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = max_task_time_env;
#line 298 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp2_ != NULL) {
#line 2019 "tracker-store.c"
		const gchar* _tmp3_;
		gint _tmp4_;
#line 299 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp3_ = max_task_time_env;
#line 299 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp4_ = atoi (_tmp3_);
#line 299 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_max_task_time = _tmp4_;
#line 2028 "tracker-store.c"
	} else {
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_max_task_time = TRACKER_STORE_MAX_TASK_TIME;
#line 2032 "tracker-store.c"
	}
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp5_ = g_ptr_array_new_full ((guint) 0, _tracker_store_task_unref0_);
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_ptr_array_unref0 (tracker_store_running_tasks);
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_running_tasks = _tmp5_;
#line 2040 "tracker-store.c"
	{
		gint i = 0;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 2045 "tracker-store.c"
		{
			gboolean _tmp6_ = FALSE;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = TRUE;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 2052 "tracker-store.c"
				gint _tmp8_;
				gint _tmp9_;
				GQueue* _tmp10_;
				GQueue* _tmp11_;
				gint _tmp12_;
				GQueue* _tmp13_;
				GQueue* _tmp14_;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp6_) {
#line 2062 "tracker-store.c"
					gint _tmp7_;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp7_ = i;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp7_ + 1;
#line 2068 "tracker-store.c"
				}
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = FALSE;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = i;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp8_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 2078 "tracker-store.c"
				}
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = i;
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp10_ = g_queue_new ();
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_query_queues[_tmp9_]);
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_query_queues[_tmp9_] = _tmp10_;
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp11_ = tracker_store_query_queues[_tmp9_];
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp12_ = i;
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp13_ = g_queue_new ();
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_update_queues[_tmp12_]);
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_queues[_tmp12_] = _tmp13_;
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp14_ = tracker_store_update_queues[_tmp12_];
#line 2100 "tracker-store.c"
			}
		}
	}
	{
		GThreadPool* _tmp15_ = NULL;
		GThreadPool* _tmp16_;
		GThreadPool* _tmp17_;
		GThreadPool* _tmp18_ = NULL;
		GThreadPool* _tmp19_;
		GThreadPool* _tmp20_;
		GThreadPool* _tmp21_ = NULL;
		GThreadPool* _tmp22_;
		GThreadPool* _tmp23_;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp16_ = g_thread_pool_new (_tracker_store_pool_dispatch_cb_gfunc, NULL, 1, TRUE, &_inner_error_);
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp15_ = _tmp16_;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2120 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp17_ = _tmp15_;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp15_ = NULL;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_update_pool);
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_update_pool = _tmp17_;
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp19_ = g_thread_pool_new (_tracker_store_pool_dispatch_cb_gfunc, NULL, TRACKER_STORE_MAX_CONCURRENT_QUERIES, TRUE, &_inner_error_);
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp18_ = _tmp19_;
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_tmp15_);
#line 2139 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp20_ = _tmp18_;
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp18_ = NULL;
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_query_pool);
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_query_pool = _tmp20_;
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp22_ = g_thread_pool_new (_tracker_store_checkpoint_dispatch_cb_gfunc, NULL, 1, TRUE, &_inner_error_);
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp21_ = _tmp22_;
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_tmp18_);
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_tmp15_);
#line 2160 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp23_ = _tmp21_;
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp21_ = NULL;
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_checkpoint_pool = _tmp23_;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (_tmp21_);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (_tmp18_);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (_tmp15_);
#line 2177 "tracker-store.c"
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp24_ = e;
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp25_ = _tmp24_->message;
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_warning ("%s", _tmp25_);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 2197 "tracker-store.c"
	}
	__finally25:
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_free0 (max_task_time_env);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2210 "tracker-store.c"
	}
#line 322 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_thread_pool_set_max_idle_time ((guint) (15 * 1000));
#line 323 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_thread_pool_set_max_unused_threads (2);
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (max_task_time_env);
#line 2218 "tracker-store.c"
}


void tracker_store_shutdown (void) {
#line 327 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_query_pool);
#line 327 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_query_pool = NULL;
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_update_pool);
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_update_pool = NULL;
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_checkpoint_pool = NULL;
#line 2235 "tracker-store.c"
	{
		gint i = 0;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 2240 "tracker-store.c"
		{
			gboolean _tmp0_ = FALSE;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 2247 "tracker-store.c"
				gint _tmp2_;
				gint _tmp3_;
				GQueue* _tmp4_;
				gint _tmp5_;
				GQueue* _tmp6_;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp0_) {
#line 2255 "tracker-store.c"
					gint _tmp1_;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp1_ = i;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp1_ + 1;
#line 2261 "tracker-store.c"
				}
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = i;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp2_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 2271 "tracker-store.c"
				}
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = i;
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_query_queues[_tmp3_]);
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_query_queues[_tmp3_] = NULL;
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = tracker_store_query_queues[_tmp3_];
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = i;
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_update_queues[_tmp5_]);
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_queues[_tmp5_] = NULL;
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = tracker_store_update_queues[_tmp5_];
#line 2289 "tracker-store.c"
			}
		}
	}
}


static void tracker_store_sparql_query_data_free (gpointer _data) {
	TrackerStoreSparqlQueryData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlQueryData, _data_);
#line 2307 "tracker-store.c"
}


void tracker_store_sparql_query (TrackerDataManager* manager, const gchar* sparql, TrackerStorePriority priority, TrackerStoreSparqlQueryInThread in_thread, void* in_thread_target, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlQueryData* _data_;
	TrackerDataManager* _tmp0_;
	TrackerDataManager* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	TrackerStorePriority _tmp4_;
	TrackerStoreSparqlQueryInThread _tmp5_;
	void* _tmp5__target;
	const gchar* _tmp6_;
	gchar* _tmp7_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlQueryData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_query_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = manager;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->manager = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = sparql;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp3_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = priority;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp5_ = in_thread;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp5__target = in_thread_target;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->in_thread = _tmp5_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->in_thread_target = _tmp5__target;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp6_ = client_id;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp7_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_query_co (_data_);
#line 2366 "tracker-store.c"
}


void tracker_store_sparql_query_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreSparqlQueryData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2378 "tracker-store.c"
	}
}


static gboolean _tracker_store_sparql_query_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_query_co (self);
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2388 "tracker-store.c"
}


static gboolean tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* _data_) {
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2397 "tracker-store.c"
		goto _state_0;
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2401 "tracker-store.c"
		goto _state_1;
		default:
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2406 "tracker-store.c"
	}
	_state_0:
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_query_task_new ();
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_QUERY;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->sparql;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->query);
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp4_;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = g_cancellable_new ();
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->_tmp5_->cancellable);
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_->cancellable = _data_->_tmp6_;
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->task;
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->in_thread;
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8__target = _data_->in_thread_target;
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_->in_thread = _data_->_tmp8_;
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_->in_thread_target = _data_->_tmp8__target;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _data_->task;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp9_)->callback_target), NULL);
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback = NULL;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target = NULL;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify = NULL;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback = _tracker_store_sparql_query_co_gsource_func;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target = _data_;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify = NULL;
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = _data_->task;
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _data_->client_id;
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp10_)->client_id);
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp10_)->client_id = _data_->_tmp12_;
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _data_->task;
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = _data_->manager;
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = _g_object_ref0 (_data_->_tmp14_);
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (((TrackerStoreTask*) _data_->_tmp13_)->data_manager);
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp13_)->data_manager = _data_->_tmp15_;
#line 347 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = _data_->priority;
#line 347 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp17_ = tracker_store_query_queues[_data_->_tmp16_];
#line 347 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp18_ = _data_->task;
#line 347 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp19_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp18_);
#line 347 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp17_, _data_->_tmp19_);
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2497 "tracker-store.c"
	_state_1:
	;
#line 353 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp20_ = _data_->task;
#line 353 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp21_ = ((TrackerStoreTask*) _data_->_tmp20_)->error;
#line 353 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp21_ != NULL) {
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp22_ = _data_->task;
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp23_ = ((TrackerStoreTask*) _data_->_tmp22_)->error;
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp24_ = _g_error_copy0 (_data_->_tmp23_);
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp24_;
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2522 "tracker-store.c"
	}
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2534 "tracker-store.c"
		}
	}
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2541 "tracker-store.c"
}


static void tracker_store_sparql_update_data_free (gpointer _data) {
	TrackerStoreSparqlUpdateData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlUpdateData, _data_);
#line 2556 "tracker-store.c"
}


void tracker_store_sparql_update (TrackerDataManager* manager, const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlUpdateData* _data_;
	TrackerDataManager* _tmp0_;
	TrackerDataManager* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	TrackerStorePriority _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_update_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = manager;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->manager = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = sparql;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp3_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = priority;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp5_ = client_id;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp6_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_update_co (_data_);
#line 2605 "tracker-store.c"
}


void tracker_store_sparql_update_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreSparqlUpdateData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2617 "tracker-store.c"
	}
}


static gboolean _tracker_store_sparql_update_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_update_co (self);
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2627 "tracker-store.c"
}


static gboolean tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* _data_) {
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2636 "tracker-store.c"
		goto _state_0;
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2640 "tracker-store.c"
		goto _state_1;
		default:
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2645 "tracker-store.c"
	}
	_state_0:
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_update_task_new ();
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_UPDATE;
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->sparql;
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->query);
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp4_;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->priority;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_->priority = _data_->_tmp6_;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->task;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp7_)->callback_target), NULL);
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = NULL;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = NULL;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = _tracker_store_sparql_update_co_gsource_func;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = _data_;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->task;
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _data_->client_id;
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp8_)->client_id);
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp8_)->client_id = _data_->_tmp10_;
#line 365 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _data_->task;
#line 365 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = _data_->manager;
#line 365 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _g_object_ref0 (_data_->_tmp12_);
#line 365 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (((TrackerStoreTask*) _data_->_tmp11_)->data_manager);
#line 365 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp11_)->data_manager = _data_->_tmp13_;
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = _data_->priority;
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = tracker_store_update_queues[_data_->_tmp14_];
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = _data_->task;
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp17_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp16_);
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp15_, _data_->_tmp17_);
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 371 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 371 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2724 "tracker-store.c"
	_state_1:
	;
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp18_ = _data_->task;
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp19_ = ((TrackerStoreTask*) _data_->_tmp18_)->error;
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp19_ != NULL) {
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp20_ = _data_->task;
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp21_ = ((TrackerStoreTask*) _data_->_tmp20_)->error;
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp22_ = _g_error_copy0 (_data_->_tmp21_);
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp22_;
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2749 "tracker-store.c"
	}
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2761 "tracker-store.c"
		}
	}
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2768 "tracker-store.c"
}


static void tracker_store_sparql_update_blank_data_free (gpointer _data) {
	TrackerStoreSparqlUpdateBlankData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_variant_unref0 (_data_->result);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlUpdateBlankData, _data_);
#line 2785 "tracker-store.c"
}


void tracker_store_sparql_update_blank (TrackerDataManager* manager, const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlUpdateBlankData* _data_;
	TrackerDataManager* _tmp0_;
	TrackerDataManager* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	TrackerStorePriority _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateBlankData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_update_blank_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = manager;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->manager = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = sparql;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp3_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = priority;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp5_ = client_id;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp6_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_update_blank_co (_data_);
#line 2834 "tracker-store.c"
}


GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerStoreSparqlUpdateBlankData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return NULL;
#line 2847 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = _data_->result;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->result = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2855 "tracker-store.c"
}


static gboolean _tracker_store_sparql_update_blank_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_update_blank_co (self);
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2864 "tracker-store.c"
}


static gpointer _g_variant_ref0 (gpointer self) {
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_variant_ref (self) : NULL;
#line 2871 "tracker-store.c"
}


static gboolean tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* _data_) {
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2880 "tracker-store.c"
		goto _state_0;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2884 "tracker-store.c"
		goto _state_1;
		default:
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2889 "tracker-store.c"
	}
	_state_0:
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_update_task_new ();
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 380 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 380 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_UPDATE_BLANK;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->sparql;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->query);
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp4_;
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->priority;
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_->priority = _data_->_tmp6_;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->task;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp7_)->callback_target), NULL);
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = NULL;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = NULL;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = _tracker_store_sparql_update_blank_co_gsource_func;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = _data_;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->task;
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _data_->client_id;
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp8_)->client_id);
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp8_)->client_id = _data_->_tmp10_;
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _data_->task;
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = _data_->manager;
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _g_object_ref0 (_data_->_tmp12_);
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (((TrackerStoreTask*) _data_->_tmp11_)->data_manager);
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp11_)->data_manager = _data_->_tmp13_;
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = _data_->priority;
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = tracker_store_update_queues[_data_->_tmp14_];
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = _data_->task;
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp17_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp16_);
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp15_, _data_->_tmp17_);
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2968 "tracker-store.c"
	_state_1:
	;
#line 393 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp18_ = _data_->task;
#line 393 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp19_ = ((TrackerStoreTask*) _data_->_tmp18_)->error;
#line 393 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp19_ != NULL) {
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp20_ = _data_->task;
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp21_ = ((TrackerStoreTask*) _data_->_tmp20_)->error;
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp22_ = _g_error_copy0 (_data_->_tmp21_);
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp22_;
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2993 "tracker-store.c"
	}
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp23_ = _data_->task;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp24_ = _data_->_tmp23_->blank_nodes;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp25_ = _g_variant_ref0 (_data_->_tmp24_);
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->result = _data_->_tmp25_;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3013 "tracker-store.c"
		}
	}
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 3020 "tracker-store.c"
}


static void tracker_store_queue_turtle_import_data_free (gpointer _data) {
	TrackerStoreQueueTurtleImportData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->file);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreQueueTurtleImportData, _data_);
#line 3035 "tracker-store.c"
}


void tracker_store_queue_turtle_import (TrackerDataManager* manager, GFile* file, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreQueueTurtleImportData* _data_;
	TrackerDataManager* _tmp0_;
	TrackerDataManager* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreQueueTurtleImportData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_queue_turtle_import_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = manager;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->manager = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = file;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->file);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->file = _tmp3_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = client_id;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp5_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_queue_turtle_import_co (_data_);
#line 3079 "tracker-store.c"
}


void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreQueueTurtleImportData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 3091 "tracker-store.c"
	}
}


static gboolean _tracker_store_queue_turtle_import_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_queue_turtle_import_co (self);
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 3101 "tracker-store.c"
}


static gboolean tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* _data_) {
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 3110 "tracker-store.c"
		goto _state_0;
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 3114 "tracker-store.c"
		goto _state_1;
		default:
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 3119 "tracker-store.c"
	}
	_state_0:
#line 401 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_turtle_task_new ();
#line 401 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 402 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 402 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_TURTLE;
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->file;
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_file_get_path (_data_->_tmp3_);
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->path);
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->path = _data_->_tmp4_;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp5_)->callback_target), NULL);
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback = NULL;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target = NULL;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify = NULL;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback = _tracker_store_queue_turtle_import_co_gsource_func;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target = _data_;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify = NULL;
#line 405 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->task;
#line 405 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->client_id;
#line 405 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
#line 405 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp6_)->client_id);
#line 405 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp6_)->client_id = _data_->_tmp8_;
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _data_->task;
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = _data_->manager;
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _g_object_ref0 (_data_->_tmp10_);
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (((TrackerStoreTask*) _data_->_tmp9_)->data_manager);
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->data_manager = _data_->_tmp11_;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_TURTLE];
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _data_->task;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp13_);
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp12_, _data_->_tmp14_);
#line 410 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 412 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 412 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 3190 "tracker-store.c"
	_state_1:
	;
#line 414 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = _data_->task;
#line 414 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = ((TrackerStoreTask*) _data_->_tmp15_)->error;
#line 414 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp16_ != NULL) {
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp17_ = _data_->task;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp18_ = ((TrackerStoreTask*) _data_->_tmp17_)->error;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp19_ = _g_error_copy0 (_data_->_tmp18_);
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp19_;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 3215 "tracker-store.c"
	}
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3227 "tracker-store.c"
		}
	}
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 3234 "tracker-store.c"
}


guint tracker_store_get_queue_size (TrackerStore* self) {
	guint result = 0U;
	guint _result_ = 0U;
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 420 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_result_ = (guint) 0;
#line 3245 "tracker-store.c"
	{
		gint i = 0;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3250 "tracker-store.c"
		{
			gboolean _tmp0_ = FALSE;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3257 "tracker-store.c"
				gint _tmp2_;
				guint _tmp3_;
				gint _tmp4_;
				GQueue* _tmp5_;
				guint _tmp6_;
				guint _tmp7_;
				gint _tmp8_;
				GQueue* _tmp9_;
				guint _tmp10_;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp0_) {
#line 3269 "tracker-store.c"
					gint _tmp1_;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp1_ = i;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp1_ + 1;
#line 3275 "tracker-store.c"
				}
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = i;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp2_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3285 "tracker-store.c"
				}
#line 423 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = _result_;
#line 423 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = i;
#line 423 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = tracker_store_query_queues[_tmp4_];
#line 423 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = g_queue_get_length (_tmp5_);
#line 423 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_result_ = _tmp3_ + _tmp6_;
#line 424 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = _result_;
#line 424 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = i;
#line 424 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = tracker_store_update_queues[_tmp8_];
#line 424 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp10_ = g_queue_get_length (_tmp9_);
#line 424 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_result_ = _tmp7_ + _tmp10_;
#line 3307 "tracker-store.c"
			}
		}
	}
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = _result_;
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 3315 "tracker-store.c"
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
#line 4968 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 4968 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = self->len;
#line 4968 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 4968 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 3330 "tracker-store.c"
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
#line 4969 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 4969 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = value;
#line 4969 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_ptr_array_set_size (self, _tmp0_);
#line 3342 "tracker-store.c"
}


void tracker_store_unreg_batches (const gchar* client_id) {
	GList* list = NULL;
	GList* cur = NULL;
	GQueue* queue = NULL;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (client_id != NULL);
#line 3352 "tracker-store.c"
	{
		gint i = 0;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3357 "tracker-store.c"
		{
			gboolean _tmp0_ = FALSE;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3364 "tracker-store.c"
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				TrackerStoreQueryTask* task = NULL;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				TrackerStoreTask* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				TrackerStoreQueryTask* _tmp12_;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp0_) {
#line 3379 "tracker-store.c"
					gint _tmp1_;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp1_ = i;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp1_ + 1;
#line 3385 "tracker-store.c"
				}
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = i;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = tracker_store_running_tasks;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = _tmp4_;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3401 "tracker-store.c"
				}
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = tracker_store_running_tasks;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = i;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = (TrackerStoreTask*) _tmp8_;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				task = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TRACKER_STORE_TYPE_QUERY_TASK) ? ((TrackerStoreQueryTask*) _tmp9_) : NULL;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp12_ = task;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp12_ != NULL) {
#line 3417 "tracker-store.c"
					TrackerStoreQueryTask* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp13_ = task;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp14_ = ((TrackerStoreTask*) _tmp13_)->client_id;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp15_ = client_id;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp11_ = g_strcmp0 (_tmp14_, _tmp15_) == 0;
#line 3429 "tracker-store.c"
				} else {
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp11_ = FALSE;
#line 3433 "tracker-store.c"
				}
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp11_) {
#line 3437 "tracker-store.c"
					TrackerStoreQueryTask* _tmp16_;
					GCancellable* _tmp17_;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp16_ = task;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp17_ = _tmp16_->cancellable;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp10_ = _tmp17_ != NULL;
#line 3446 "tracker-store.c"
				} else {
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp10_ = FALSE;
#line 3450 "tracker-store.c"
				}
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp10_) {
#line 3454 "tracker-store.c"
					TrackerStoreQueryTask* _tmp18_;
					GCancellable* _tmp19_;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp18_ = task;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp19_ = _tmp18_->cancellable;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_cancellable_cancel (_tmp19_);
#line 3463 "tracker-store.c"
				}
			}
		}
	}
	{
		gint i = 0;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3472 "tracker-store.c"
		{
			gboolean _tmp20_ = FALSE;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp20_ = TRUE;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3479 "tracker-store.c"
				gint _tmp22_;
				gint _tmp23_;
				GQueue* _tmp24_;
				GQueue* _tmp25_;
				GList* _tmp26_;
				gint _tmp44_;
				GQueue* _tmp45_;
				GQueue* _tmp46_;
				GList* _tmp47_;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp20_) {
#line 3491 "tracker-store.c"
					gint _tmp21_;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp21_ = i;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp21_ + 1;
#line 3497 "tracker-store.c"
				}
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp20_ = FALSE;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp22_ = i;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp22_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3507 "tracker-store.c"
				}
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp23_ = i;
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp24_ = tracker_store_query_queues[_tmp23_];
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				queue = _tmp24_;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp25_ = queue;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp26_ = _tmp25_->head;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				list = _tmp26_;
#line 443 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 3523 "tracker-store.c"
					GList* _tmp27_;
					GList* _tmp28_;
					GList* _tmp29_;
					GList* _tmp30_;
					TrackerStoreTask* task = NULL;
					GList* _tmp31_;
					gconstpointer _tmp32_;
					gboolean _tmp33_ = FALSE;
					TrackerStoreTask* _tmp34_;
#line 443 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp27_ = list;
#line 443 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp27_ != NULL)) {
#line 443 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 3539 "tracker-store.c"
					}
#line 444 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_ = list;
#line 444 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					cur = _tmp28_;
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_ = list;
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp30_ = _tmp29_->next;
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					list = _tmp30_;
#line 446 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp31_ = cur;
#line 446 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp32_ = _tmp31_->data;
#line 446 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp32_;
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp34_ = task;
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp34_ != NULL) {
#line 3561 "tracker-store.c"
						TrackerStoreTask* _tmp35_;
						const gchar* _tmp36_;
						const gchar* _tmp37_;
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp35_ = task;
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp36_ = _tmp35_->client_id;
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp37_ = client_id;
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp33_ = g_strcmp0 (_tmp36_, _tmp37_) == 0;
#line 3573 "tracker-store.c"
					} else {
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp33_ = FALSE;
#line 3577 "tracker-store.c"
					}
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp33_) {
#line 3581 "tracker-store.c"
						GQueue* _tmp38_;
						GList* _tmp39_;
						TrackerStoreTask* _tmp40_;
						GError* _tmp41_;
						TrackerStoreTask* _tmp42_;
						GSourceFunc _tmp43_;
						void* _tmp43__target;
#line 449 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp38_ = queue;
#line 449 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp39_ = cur;
#line 449 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						g_queue_delete_link (_tmp38_, _tmp39_);
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp40_ = task;
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp41_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Client disappeared");
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_error_free0 (_tmp40_->error);
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp40_->error = _tmp41_;
#line 452 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp42_ = task;
#line 452 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp43_ = _tmp42_->callback;
#line 452 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp43__target = _tmp42_->callback_target;
#line 452 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp43_ (_tmp43__target);
#line 3611 "tracker-store.c"
					}
				}
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp44_ = i;
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp45_ = tracker_store_update_queues[_tmp44_];
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				queue = _tmp45_;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp46_ = queue;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp47_ = _tmp46_->head;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				list = _tmp47_;
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 3628 "tracker-store.c"
					GList* _tmp48_;
					GList* _tmp49_;
					GList* _tmp50_;
					GList* _tmp51_;
					TrackerStoreTask* task = NULL;
					GList* _tmp52_;
					gconstpointer _tmp53_;
					gboolean _tmp54_ = FALSE;
					TrackerStoreTask* _tmp55_;
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp48_ = list;
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp48_ != NULL)) {
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 3644 "tracker-store.c"
					}
#line 459 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp49_ = list;
#line 459 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					cur = _tmp49_;
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp50_ = list;
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp51_ = _tmp50_->next;
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					list = _tmp51_;
#line 461 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp52_ = cur;
#line 461 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp53_ = _tmp52_->data;
#line 461 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp53_;
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp55_ = task;
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp55_ != NULL) {
#line 3666 "tracker-store.c"
						TrackerStoreTask* _tmp56_;
						const gchar* _tmp57_;
						const gchar* _tmp58_;
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp56_ = task;
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp57_ = _tmp56_->client_id;
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp58_ = client_id;
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp54_ = g_strcmp0 (_tmp57_, _tmp58_) == 0;
#line 3678 "tracker-store.c"
					} else {
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp54_ = FALSE;
#line 3682 "tracker-store.c"
					}
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp54_) {
#line 3686 "tracker-store.c"
						GQueue* _tmp59_;
						GList* _tmp60_;
						TrackerStoreTask* _tmp61_;
						GError* _tmp62_;
						TrackerStoreTask* _tmp63_;
						GSourceFunc _tmp64_;
						void* _tmp64__target;
#line 464 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp59_ = queue;
#line 464 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp60_ = cur;
#line 464 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						g_queue_delete_link (_tmp59_, _tmp60_);
#line 466 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp61_ = task;
#line 466 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp62_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Client disappeared");
#line 466 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_error_free0 (_tmp61_->error);
#line 466 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp61_->error = _tmp62_;
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp63_ = task;
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp64_ = _tmp63_->callback;
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp64__target = _tmp63_->callback_target;
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp64_ (_tmp64__target);
#line 3716 "tracker-store.c"
					}
				}
			}
		}
	}
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 3724 "tracker-store.c"
}


static void tracker_store_pause_data_free (gpointer _data) {
	TrackerStorePauseData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStorePauseData, _data_);
#line 3733 "tracker-store.c"
}


void tracker_store_pause (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStorePauseData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStorePauseData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_pause_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_pause_co (_data_);
#line 3747 "tracker-store.c"
}


void tracker_store_pause_finish (GAsyncResult* _res_) {
	TrackerStorePauseData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3755 "tracker-store.c"
}


static gboolean _tracker_store_pause_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_pause_co (self);
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 3764 "tracker-store.c"
}


static gboolean tracker_store_pause_co (TrackerStorePauseData* _data_) {
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 3773 "tracker-store.c"
		goto _state_0;
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 3777 "tracker-store.c"
		goto _state_1;
		default:
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 3782 "tracker-store.c"
	}
	_state_0:
#line 476 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_active = FALSE;
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = tracker_store_n_queries_running;
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp1_ > 0) {
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp0_ = TRUE;
#line 3793 "tracker-store.c"
	} else {
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp2_ = tracker_store_update_running;
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp0_ = _data_->_tmp2_;
#line 3799 "tracker-store.c"
	}
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp0_) {
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		(tracker_store_active_callback_target_destroy_notify == NULL) ? NULL : (tracker_store_active_callback_target_destroy_notify (tracker_store_active_callback_target), NULL);
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = _tracker_store_pause_co_gsource_func;
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = _data_;
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_state_ = 1;
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 3821 "tracker-store.c"
		_state_1:
		;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		(tracker_store_active_callback_target_destroy_notify == NULL) ? NULL : (tracker_store_active_callback_target_destroy_notify (tracker_store_active_callback_target), NULL);
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 3838 "tracker-store.c"
	}
#line 484 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = g_atomic_int_get ((volatile gint *) (&tracker_store_checkpointing));
#line 484 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp3_ != 0) {
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_checkpoint_pool = NULL;
#line 3848 "tracker-store.c"
		{
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp5_ = g_thread_pool_new (_tracker_store_checkpoint_dispatch_cb_gfunc, NULL, 1, TRUE, &_data_->_inner_error_);
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp4_ = _data_->_tmp5_;
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 3856 "tracker-store.c"
				goto __catch26_g_error;
			}
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp6_ = _data_->_tmp4_;
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp4_ = NULL;
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_checkpoint_pool = _data_->_tmp6_;
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_data_->_tmp4_);
#line 3869 "tracker-store.c"
		}
		goto __finally26;
		__catch26_g_error:
		{
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->e = _data_->_inner_error_;
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_inner_error_ = NULL;
#line 490 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp7_ = _data_->e;
#line 490 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp8_ = _data_->_tmp7_->message;
#line 490 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_warning ("%s", _data_->_tmp8_);
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (_data_->e);
#line 3886 "tracker-store.c"
		}
		__finally26:
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_clear_error (&_data_->_inner_error_);
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_object_unref (_data_->_async_result);
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return FALSE;
#line 3899 "tracker-store.c"
		}
	}
#line 494 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = tracker_store_active;
#line 494 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp9_) {
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_sched ();
#line 3908 "tracker-store.c"
	}
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3918 "tracker-store.c"
		}
	}
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 3925 "tracker-store.c"
}


void tracker_store_resume (void) {
#line 500 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_active = TRUE;
#line 502 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 3934 "tracker-store.c"
}


TrackerStore* tracker_store_construct (GType object_type) {
	TrackerStore* self = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStore*) g_type_create_instance (object_type);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 3944 "tracker-store.c"
}


TrackerStore* tracker_store_new (void) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_construct (TRACKER_TYPE_STORE);
#line 3951 "tracker-store.c"
}


static TrackerStoreTask* tracker_store_task_construct (GType object_type) {
	TrackerStoreTask* self = NULL;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreTask*) g_type_create_instance (object_type);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 3961 "tracker-store.c"
}


static void tracker_store_value_task_init (GValue* value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	value->data[0].v_pointer = NULL;
#line 3968 "tracker-store.c"
}


static void tracker_store_value_task_free_value (GValue* value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (value->data[0].v_pointer) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (value->data[0].v_pointer);
#line 3977 "tracker-store.c"
	}
}


static void tracker_store_value_task_copy_value (const GValue* src_value, GValue* dest_value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (src_value->data[0].v_pointer) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = tracker_store_task_ref (src_value->data[0].v_pointer);
#line 3987 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3991 "tracker-store.c"
	}
}


static gpointer tracker_store_value_task_peek_pointer (const GValue* value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 3999 "tracker-store.c"
}


static gchar* tracker_store_value_task_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (collect_values[0].v_pointer) {
#line 4006 "tracker-store.c"
		TrackerStoreTask * object;
		object = collect_values[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (object->parent_instance.g_class == NULL) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4013 "tracker-store.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4017 "tracker-store.c"
		}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = tracker_store_task_ref (object);
#line 4021 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4025 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 4029 "tracker-store.c"
}


static gchar* tracker_store_value_task_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerStoreTask ** object_p;
	object_p = collect_values[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!object_p) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4040 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!value->data[0].v_pointer) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = NULL;
#line 4046 "tracker-store.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = value->data[0].v_pointer;
#line 4050 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = tracker_store_task_ref (value->data[0].v_pointer);
#line 4054 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 4058 "tracker-store.c"
}


static GParamSpec* tracker_store_param_spec_task (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerStoreParamSpecTask* spec;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_STORE_TYPE_TASK), NULL);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return G_PARAM_SPEC (spec);
#line 4072 "tracker-store.c"
}


static gpointer tracker_store_value_get_task (const GValue* value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK), NULL);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 4081 "tracker-store.c"
}


static void tracker_store_value_set_task (GValue* value, gpointer v_object) {
	TrackerStoreTask * old;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_ref (value->data[0].v_pointer);
#line 4101 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4105 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (old);
#line 4111 "tracker-store.c"
	}
}


static void tracker_store_value_take_task (GValue* value, gpointer v_object) {
	TrackerStoreTask * old;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 4130 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4134 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (old);
#line 4140 "tracker-store.c"
	}
}


static void tracker_store_task_class_init (TrackerStoreTaskClass * klass) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_task_parent_class = g_type_class_peek_parent (klass);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTaskClass *) klass)->finalize = tracker_store_task_finalize;
#line 4150 "tracker-store.c"
}


static void tracker_store_task_instance_init (TrackerStoreTask * self) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->ref_count = 1;
#line 4157 "tracker-store.c"
}


static void tracker_store_task_finalize (TrackerStoreTask * obj) {
	TrackerStoreTask * self;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_TASK, TrackerStoreTask);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_signal_handlers_destroy (self);
#line 57 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->client_id);
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_error_free0 (self->error);
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->callback = NULL;
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->callback_target = NULL;
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->callback_target_destroy_notify = NULL;
#line 60 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (self->data_manager);
#line 4181 "tracker-store.c"
}


static GType tracker_store_task_get_type (void) {
	static volatile gsize tracker_store_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_task_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_store_value_task_init, tracker_store_value_task_free_value, tracker_store_value_task_copy_value, tracker_store_value_task_peek_pointer, "p", tracker_store_value_task_collect_value, "p", tracker_store_value_task_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreTask), 0, (GInstanceInitFunc) tracker_store_task_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_store_task_type_id;
		tracker_store_task_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStoreTask", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_store_task_type_id__volatile, tracker_store_task_type_id);
	}
	return tracker_store_task_type_id__volatile;
}


static gpointer tracker_store_task_ref (gpointer instance) {
	TrackerStoreTask * self;
	self = instance;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&self->ref_count);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return instance;
#line 4206 "tracker-store.c"
}


static void tracker_store_task_unref (gpointer instance) {
	TrackerStoreTask * self;
	self = instance;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		TRACKER_STORE_TASK_GET_CLASS (self)->finalize (self);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4219 "tracker-store.c"
	}
}


static TrackerStoreQueryTask* tracker_store_query_task_construct (GType object_type) {
	TrackerStoreQueryTask* self = NULL;
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreQueryTask*) tracker_store_task_construct (object_type);
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4230 "tracker-store.c"
}


static TrackerStoreQueryTask* tracker_store_query_task_new (void) {
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_query_task_construct (TRACKER_STORE_TYPE_QUERY_TASK);
#line 4237 "tracker-store.c"
}


static void tracker_store_query_task_class_init (TrackerStoreQueryTaskClass * klass) {
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_query_task_parent_class = g_type_class_peek_parent (klass);
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTaskClass *) klass)->finalize = tracker_store_query_task_finalize;
#line 4246 "tracker-store.c"
}


static void tracker_store_query_task_instance_init (TrackerStoreQueryTask * self) {
}


static void tracker_store_query_task_finalize (TrackerStoreTask * obj) {
	TrackerStoreQueryTask * self;
	guint _tmp0_;
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask);
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = self->watchdog_id;
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp0_ > ((guint) 0)) {
#line 4263 "tracker-store.c"
		guint _tmp1_;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = self->watchdog_id;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_source_remove (_tmp1_);
#line 4269 "tracker-store.c"
	}
#line 64 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->query);
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (self->cancellable);
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_query_task_parent_class)->finalize (obj);
#line 4277 "tracker-store.c"
}


static GType tracker_store_query_task_get_type (void) {
	static volatile gsize tracker_store_query_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_query_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreQueryTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_query_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreQueryTask), 0, (GInstanceInitFunc) tracker_store_query_task_instance_init, NULL };
		GType tracker_store_query_task_type_id;
		tracker_store_query_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreQueryTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_query_task_type_id__volatile, tracker_store_query_task_type_id);
	}
	return tracker_store_query_task_type_id__volatile;
}


static TrackerStoreUpdateTask* tracker_store_update_task_construct (GType object_type) {
	TrackerStoreUpdateTask* self = NULL;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreUpdateTask*) tracker_store_task_construct (object_type);
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4299 "tracker-store.c"
}


static TrackerStoreUpdateTask* tracker_store_update_task_new (void) {
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_update_task_construct (TRACKER_STORE_TYPE_UPDATE_TASK);
#line 4306 "tracker-store.c"
}


static void tracker_store_update_task_class_init (TrackerStoreUpdateTaskClass * klass) {
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_update_task_parent_class = g_type_class_peek_parent (klass);
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTaskClass *) klass)->finalize = tracker_store_update_task_finalize;
#line 4315 "tracker-store.c"
}


static void tracker_store_update_task_instance_init (TrackerStoreUpdateTask * self) {
}


static void tracker_store_update_task_finalize (TrackerStoreTask * obj) {
	TrackerStoreUpdateTask * self;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask);
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->query);
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_variant_unref0 (self->blank_nodes);
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_update_task_parent_class)->finalize (obj);
#line 4333 "tracker-store.c"
}


static GType tracker_store_update_task_get_type (void) {
	static volatile gsize tracker_store_update_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_update_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreUpdateTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_update_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreUpdateTask), 0, (GInstanceInitFunc) tracker_store_update_task_instance_init, NULL };
		GType tracker_store_update_task_type_id;
		tracker_store_update_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreUpdateTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_update_task_type_id__volatile, tracker_store_update_task_type_id);
	}
	return tracker_store_update_task_type_id__volatile;
}


static TrackerStoreTurtleTask* tracker_store_turtle_task_construct (GType object_type) {
	TrackerStoreTurtleTask* self = NULL;
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreTurtleTask*) tracker_store_task_construct (object_type);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4355 "tracker-store.c"
}


static TrackerStoreTurtleTask* tracker_store_turtle_task_new (void) {
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_turtle_task_construct (TRACKER_STORE_TYPE_TURTLE_TASK);
#line 4362 "tracker-store.c"
}


static void tracker_store_turtle_task_class_init (TrackerStoreTurtleTaskClass * klass) {
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_turtle_task_parent_class = g_type_class_peek_parent (klass);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTaskClass *) klass)->finalize = tracker_store_turtle_task_finalize;
#line 4371 "tracker-store.c"
}


static void tracker_store_turtle_task_instance_init (TrackerStoreTurtleTask * self) {
}


static void tracker_store_turtle_task_finalize (TrackerStoreTask * obj) {
	TrackerStoreTurtleTask * self;
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTask);
#line 83 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->path);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_turtle_task_parent_class)->finalize (obj);
#line 4387 "tracker-store.c"
}


static GType tracker_store_turtle_task_get_type (void) {
	static volatile gsize tracker_store_turtle_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_turtle_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreTurtleTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_turtle_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreTurtleTask), 0, (GInstanceInitFunc) tracker_store_turtle_task_instance_init, NULL };
		GType tracker_store_turtle_task_type_id;
		tracker_store_turtle_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreTurtleTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_turtle_task_type_id__volatile, tracker_store_turtle_task_type_id);
	}
	return tracker_store_turtle_task_type_id__volatile;
}


static void tracker_value_store_init (GValue* value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	value->data[0].v_pointer = NULL;
#line 4406 "tracker-store.c"
}


static void tracker_value_store_free_value (GValue* value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (value->data[0].v_pointer) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (value->data[0].v_pointer);
#line 4415 "tracker-store.c"
	}
}


static void tracker_value_store_copy_value (const GValue* src_value, GValue* dest_value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = tracker_store_ref (src_value->data[0].v_pointer);
#line 4425 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4429 "tracker-store.c"
	}
}


static gpointer tracker_value_store_peek_pointer (const GValue* value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 4437 "tracker-store.c"
}


static gchar* tracker_value_store_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (collect_values[0].v_pointer) {
#line 4444 "tracker-store.c"
		TrackerStore * object;
		object = collect_values[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4451 "tracker-store.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4455 "tracker-store.c"
		}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = tracker_store_ref (object);
#line 4459 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4463 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 4467 "tracker-store.c"
}


static gchar* tracker_value_store_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerStore ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!object_p) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4478 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!value->data[0].v_pointer) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = NULL;
#line 4484 "tracker-store.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = value->data[0].v_pointer;
#line 4488 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = tracker_store_ref (value->data[0].v_pointer);
#line 4492 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 4496 "tracker-store.c"
}


GParamSpec* tracker_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecStore* spec;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_STORE), NULL);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return G_PARAM_SPEC (spec);
#line 4510 "tracker-store.c"
}


gpointer tracker_value_get_store (const GValue* value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE), NULL);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 4519 "tracker-store.c"
}


void tracker_value_set_store (GValue* value, gpointer v_object) {
	TrackerStore * old;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_ref (value->data[0].v_pointer);
#line 4539 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4543 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (old);
#line 4549 "tracker-store.c"
	}
}


void tracker_value_take_store (GValue* value, gpointer v_object) {
	TrackerStore * old;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 4568 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4572 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (old);
#line 4578 "tracker-store.c"
	}
}


static void tracker_store_class_init (TrackerStoreClass * klass) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreClass *) klass)->finalize = tracker_store_finalize;
#line 4588 "tracker-store.c"
}


static void tracker_store_instance_init (TrackerStore * self) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->ref_count = 1;
#line 4595 "tracker-store.c"
}


static void tracker_store_finalize (TrackerStore * obj) {
	TrackerStore * self;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_STORE, TrackerStore);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_signal_handlers_destroy (self);
#line 4605 "tracker-store.c"
}


GType tracker_store_get_type (void) {
	static volatile gsize tracker_store_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_store_init, tracker_value_store_free_value, tracker_value_store_copy_value, tracker_value_store_peek_pointer, "p", tracker_value_store_collect_value, "p", tracker_value_store_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStore), 0, (GInstanceInitFunc) tracker_store_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_store_type_id;
		tracker_store_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStore", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_store_type_id__volatile, tracker_store_type_id);
	}
	return tracker_store_type_id__volatile;
}


gpointer tracker_store_ref (gpointer instance) {
	TrackerStore * self;
	self = instance;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return instance;
#line 4630 "tracker-store.c"
}


void tracker_store_unref (gpointer instance) {
	TrackerStore * self;
	self = instance;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		TRACKER_STORE_GET_CLASS (self)->finalize (self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4643 "tracker-store.c"
	}
}



