/* tracker-store.c generated by valac 0.40.6, the Vala compiler
 * generated from tracker-store.vala, do not modify */

/*
 * Copyright (C) 2009-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Philip Van Hoof <philip@codeminded.be>
 */


#include <glib.h>
#include <glib-object.h>
#include "libtracker-data/tracker-db-interface.h"
#include <stdlib.h>
#include <string.h>
#include "libtracker-data/tracker-data-manager.h"
#include <gio/gio.h>
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-data/tracker-db-interface-sqlite.h"
#include "tracker-store/tracker-events.h"
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_STORE (tracker_store_get_type ())
#define TRACKER_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STORE, TrackerStore))
#define TRACKER_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STORE, TrackerStoreClass))
#define TRACKER_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STORE))
#define TRACKER_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STORE))
#define TRACKER_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STORE, TrackerStoreClass))

typedef struct _TrackerStore TrackerStore;
typedef struct _TrackerStoreClass TrackerStoreClass;
typedef struct _TrackerStorePrivate TrackerStorePrivate;

#define TRACKER_STORE_TYPE_PRIORITY (tracker_store_priority_get_type ())

#define TRACKER_STORE_TYPE_TASK_TYPE (tracker_store_task_type_get_type ())

#define TRACKER_STORE_TYPE_TASK (tracker_store_task_get_type ())
#define TRACKER_STORE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_TASK, TrackerStoreTask))
#define TRACKER_STORE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_TASK, TrackerStoreTaskClass))
#define TRACKER_STORE_IS_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_TASK))
#define TRACKER_STORE_IS_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_TASK))
#define TRACKER_STORE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_TASK, TrackerStoreTaskClass))

typedef struct _TrackerStoreTask TrackerStoreTask;
typedef struct _TrackerStoreTaskClass TrackerStoreTaskClass;
#define _tracker_store_task_unref0(var) ((var == NULL) ? NULL : (var = (tracker_store_task_unref (var), NULL)))

#define TRACKER_STORE_TYPE_QUERY_TASK (tracker_store_query_task_get_type ())
#define TRACKER_STORE_QUERY_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask))
#define TRACKER_STORE_QUERY_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTaskClass))
#define TRACKER_STORE_IS_QUERY_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_QUERY_TASK))
#define TRACKER_STORE_IS_QUERY_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_QUERY_TASK))
#define TRACKER_STORE_QUERY_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTaskClass))

typedef struct _TrackerStoreQueryTask TrackerStoreQueryTask;
typedef struct _TrackerStoreQueryTaskClass TrackerStoreQueryTaskClass;
typedef struct _Block7Data Block7Data;
typedef struct _TrackerStoreTaskPrivate TrackerStoreTaskPrivate;
typedef struct _TrackerStoreQueryTaskPrivate TrackerStoreQueryTaskPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TRACKER_STORE_TYPE_UPDATE_TASK (tracker_store_update_task_get_type ())
#define TRACKER_STORE_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask))
#define TRACKER_STORE_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTaskClass))
#define TRACKER_STORE_IS_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_UPDATE_TASK))
#define TRACKER_STORE_IS_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_UPDATE_TASK))
#define TRACKER_STORE_UPDATE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTaskClass))

typedef struct _TrackerStoreUpdateTask TrackerStoreUpdateTask;
typedef struct _TrackerStoreUpdateTaskClass TrackerStoreUpdateTaskClass;
typedef struct _TrackerStoreUpdateTaskPrivate TrackerStoreUpdateTaskPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TRACKER_STORE_TYPE_TURTLE_TASK (tracker_store_turtle_task_get_type ())
#define TRACKER_STORE_TURTLE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTask))
#define TRACKER_STORE_TURTLE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTaskClass))
#define TRACKER_STORE_IS_TURTLE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_TURTLE_TASK))
#define TRACKER_STORE_IS_TURTLE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_TURTLE_TASK))
#define TRACKER_STORE_TURTLE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTaskClass))

typedef struct _TrackerStoreTurtleTask TrackerStoreTurtleTask;
typedef struct _TrackerStoreTurtleTaskClass TrackerStoreTurtleTaskClass;
typedef struct _TrackerStoreTurtleTaskPrivate TrackerStoreTurtleTaskPrivate;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define __g_queue_free__tracker_store_task_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__tracker_store_task_unref0_ (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerStoreSparqlQueryData TrackerStoreSparqlQueryData;
typedef struct _TrackerStoreSparqlUpdateData TrackerStoreSparqlUpdateData;
typedef struct _TrackerStoreSparqlUpdateBlankData TrackerStoreSparqlUpdateBlankData;
typedef struct _TrackerStoreQueueTurtleImportData TrackerStoreQueueTurtleImportData;
typedef struct _TrackerStorePauseData TrackerStorePauseData;
typedef struct _TrackerStoreParamSpecTask TrackerStoreParamSpecTask;
typedef struct _TrackerParamSpecStore TrackerParamSpecStore;

struct _TrackerStore {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStorePrivate * priv;
};

struct _TrackerStoreClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStore *self);
};

typedef enum  {
	TRACKER_STORE_PRIORITY_HIGH,
	TRACKER_STORE_PRIORITY_LOW,
	TRACKER_STORE_PRIORITY_TURTLE,
	TRACKER_STORE_PRIORITY_N_PRIORITIES
} TrackerStorePriority;

typedef enum  {
	TRACKER_STORE_TASK_TYPE_QUERY,
	TRACKER_STORE_TASK_TYPE_UPDATE,
	TRACKER_STORE_TASK_TYPE_UPDATE_BLANK,
	TRACKER_STORE_TASK_TYPE_TURTLE
} TrackerStoreTaskType;

struct _Block7Data {
	int _ref_count_;
	TrackerStoreQueryTask* query_task;
};

struct _TrackerStoreTask {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStoreTaskPrivate * priv;
	TrackerStoreTaskType type;
	gchar* client_id;
	GError* error;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	TrackerDataManager* data_manager;
};

struct _TrackerStoreTaskClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStoreTask *self);
};

typedef void (*TrackerStoreSparqlQueryInThread) (TrackerDBCursor* cursor, void* user_data, GError** error);
struct _TrackerStoreQueryTask {
	TrackerStoreTask parent_instance;
	TrackerStoreQueryTaskPrivate * priv;
	gchar* query;
	GCancellable* cancellable;
	guint watchdog_id;
	TrackerStoreSparqlQueryInThread in_thread;
	gpointer in_thread_target;
};

struct _TrackerStoreQueryTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _TrackerStoreUpdateTask {
	TrackerStoreTask parent_instance;
	TrackerStoreUpdateTaskPrivate * priv;
	gchar* query;
	GVariant* blank_nodes;
	TrackerStorePriority priority;
};

struct _TrackerStoreUpdateTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _Block8Data {
	int _ref_count_;
	TrackerStoreTask* task;
};

struct _TrackerStoreTurtleTask {
	TrackerStoreTask parent_instance;
	TrackerStoreTurtleTaskPrivate * priv;
	gchar* path;
};

struct _TrackerStoreTurtleTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _TrackerStoreSparqlQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDataManager* manager;
	gchar* sparql;
	TrackerStorePriority priority;
	TrackerStoreSparqlQueryInThread in_thread;
	gpointer in_thread_target;
	gchar* client_id;
	TrackerStoreQueryTask* task;
	TrackerStoreQueryTask* _tmp0_;
	TrackerStoreQueryTask* _tmp1_;
	TrackerStoreQueryTask* _tmp2_;
	gchar* _tmp3_;
	TrackerStoreQueryTask* _tmp4_;
	GCancellable* _tmp5_;
	TrackerStoreQueryTask* _tmp6_;
	TrackerStoreQueryTask* _tmp7_;
	TrackerStoreQueryTask* _tmp8_;
	gchar* _tmp9_;
	TrackerStoreQueryTask* _tmp10_;
	TrackerDataManager* _tmp11_;
	GQueue* _tmp12_;
	TrackerStoreQueryTask* _tmp13_;
	TrackerStoreTask* _tmp14_;
	TrackerStoreQueryTask* _tmp15_;
	GError* _tmp16_;
	TrackerStoreQueryTask* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	GError * _inner_error_;
};

struct _TrackerStoreSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDataManager* manager;
	gchar* sparql;
	TrackerStorePriority priority;
	gchar* client_id;
	TrackerStoreUpdateTask* task;
	TrackerStoreUpdateTask* _tmp0_;
	TrackerStoreUpdateTask* _tmp1_;
	TrackerStoreUpdateTask* _tmp2_;
	gchar* _tmp3_;
	TrackerStoreUpdateTask* _tmp4_;
	TrackerStoreUpdateTask* _tmp5_;
	TrackerStoreUpdateTask* _tmp6_;
	gchar* _tmp7_;
	TrackerStoreUpdateTask* _tmp8_;
	TrackerDataManager* _tmp9_;
	GQueue* _tmp10_;
	TrackerStoreUpdateTask* _tmp11_;
	TrackerStoreTask* _tmp12_;
	TrackerStoreUpdateTask* _tmp13_;
	GError* _tmp14_;
	TrackerStoreUpdateTask* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GError * _inner_error_;
};

struct _TrackerStoreSparqlUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDataManager* manager;
	gchar* sparql;
	TrackerStorePriority priority;
	gchar* client_id;
	GVariant* result;
	TrackerStoreUpdateTask* task;
	TrackerStoreUpdateTask* _tmp0_;
	TrackerStoreUpdateTask* _tmp1_;
	TrackerStoreUpdateTask* _tmp2_;
	gchar* _tmp3_;
	TrackerStoreUpdateTask* _tmp4_;
	TrackerStoreUpdateTask* _tmp5_;
	TrackerStoreUpdateTask* _tmp6_;
	gchar* _tmp7_;
	TrackerStoreUpdateTask* _tmp8_;
	TrackerDataManager* _tmp9_;
	GQueue* _tmp10_;
	TrackerStoreUpdateTask* _tmp11_;
	TrackerStoreTask* _tmp12_;
	TrackerStoreUpdateTask* _tmp13_;
	GError* _tmp14_;
	TrackerStoreUpdateTask* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	TrackerStoreUpdateTask* _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	GError * _inner_error_;
};

struct _TrackerStoreQueueTurtleImportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDataManager* manager;
	GFile* file;
	gchar* client_id;
	TrackerStoreTurtleTask* task;
	TrackerStoreTurtleTask* _tmp0_;
	TrackerStoreTurtleTask* _tmp1_;
	TrackerStoreTurtleTask* _tmp2_;
	gchar* _tmp3_;
	TrackerStoreTurtleTask* _tmp4_;
	TrackerStoreTurtleTask* _tmp5_;
	gchar* _tmp6_;
	TrackerStoreTurtleTask* _tmp7_;
	TrackerDataManager* _tmp8_;
	GQueue* _tmp9_;
	TrackerStoreTurtleTask* _tmp10_;
	TrackerStoreTask* _tmp11_;
	TrackerStoreTurtleTask* _tmp12_;
	GError* _tmp13_;
	TrackerStoreTurtleTask* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError * _inner_error_;
};

struct _TrackerStorePauseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gboolean _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	GThreadPool* _tmp4_;
	GThreadPool* _tmp5_;
	GThreadPool* _tmp6_;
	GError* e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	GError * _inner_error_;
};

struct _TrackerStoreParamSpecTask {
	GParamSpec parent_instance;
};

struct _TrackerParamSpecStore {
	GParamSpec parent_instance;
};


static gpointer tracker_store_parent_class = NULL;
static GQueue* tracker_store_query_queues[3];
static GQueue* tracker_store_query_queues[3] = {0};
static GQueue* tracker_store_update_queues[3];
static GQueue* tracker_store_update_queues[3] = {0};
static gint tracker_store_n_queries_running;
static gint tracker_store_n_queries_running = 0;
static gboolean tracker_store_update_running;
static gboolean tracker_store_update_running = FALSE;
static GThreadPool* tracker_store_update_pool;
static GThreadPool* tracker_store_update_pool = NULL;
static GThreadPool* tracker_store_query_pool;
static GThreadPool* tracker_store_query_pool = NULL;
static GThreadPool* tracker_store_checkpoint_pool;
static GThreadPool* tracker_store_checkpoint_pool = NULL;
static GPtrArray* tracker_store_running_tasks;
static GPtrArray* tracker_store_running_tasks = NULL;
static gint tracker_store_max_task_time;
static gint tracker_store_max_task_time = 0;
static gboolean tracker_store_active;
static gboolean tracker_store_active = FALSE;
static GSourceFunc tracker_store_active_callback;
static gpointer tracker_store_active_callback_target;
static GDestroyNotify tracker_store_active_callback_target_destroy_notify;
static GSourceFunc tracker_store_active_callback = NULL;
static gpointer tracker_store_active_callback_target = NULL;
static GDestroyNotify tracker_store_active_callback_target_destroy_notify = NULL;
static gint tracker_store_checkpointing;
static gint tracker_store_checkpointing = 0;
static gpointer tracker_store_task_parent_class = NULL;
static gpointer tracker_store_query_task_parent_class = NULL;
static gpointer tracker_store_update_task_parent_class = NULL;
static gpointer tracker_store_turtle_task_parent_class = NULL;

gpointer tracker_store_ref (gpointer instance);
void tracker_store_unref (gpointer instance);
GParamSpec* tracker_param_spec_store (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void tracker_value_set_store (GValue* value,
                              gpointer v_object);
void tracker_value_take_store (GValue* value,
                               gpointer v_object);
gpointer tracker_value_get_store (const GValue* value);
GType tracker_store_get_type (void) G_GNUC_CONST;
GType tracker_store_priority_get_type (void) G_GNUC_CONST;
static GType tracker_store_task_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gpointer tracker_store_task_ref (gpointer instance);
static void tracker_store_task_unref (gpointer instance);
static GParamSpec* tracker_store_param_spec_task (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags) G_GNUC_UNUSED;
static void tracker_store_value_set_task (GValue* value,
                                   gpointer v_object) G_GNUC_UNUSED;
static void tracker_store_value_take_task (GValue* value,
                                    gpointer v_object) G_GNUC_UNUSED;
static gpointer tracker_store_value_get_task (const GValue* value) G_GNUC_UNUSED;
static GType tracker_store_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_STORE_MAX_CONCURRENT_QUERIES 2
#define TRACKER_STORE_MAX_TASK_TIME 30
static void tracker_store_sched (void);
static GType tracker_store_query_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean ____lambda6_ (Block7Data* _data7_);
static gboolean _____lambda6__gsource_func (gpointer self);
static TrackerDataCommitType tracker_store_commit_type (TrackerStoreTask* task);
static GType tracker_store_update_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean tracker_store_task_finish_cb (TrackerStoreTask* task);
static void tracker_store_pool_dispatch_cb (TrackerStoreTask* task);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void tracker_store_wal_hook (TrackerDBInterface* iface,
                             gint n_pages);
static void _tracker_store_wal_hook_tracker_db_wal_callback (TrackerDBInterface* iface,
                                                      gint n_pages);
static GType tracker_store_turtle_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean __lambda7_ (Block8Data* _data8_);
static gboolean ___lambda7__gsource_func (gpointer self);
void tracker_store_wal_checkpoint (TrackerDBInterface* iface,
                                   gboolean blocking);
static void tracker_store_checkpoint_dispatch_cb (TrackerDBInterface* iface);
void tracker_store_init (void);
static void _tracker_store_task_unref0_ (gpointer var);
static inline void _g_queue_free__tracker_store_task_unref0_ (GQueue* self);
static void _tracker_store_pool_dispatch_cb_gfunc (gpointer data,
                                            gpointer self);
static void _tracker_store_checkpoint_dispatch_cb_gfunc (gconstpointer data,
                                                  gpointer self);
void tracker_store_shutdown (void);
static void tracker_store_sparql_query_data_free (gpointer _data);
void tracker_store_sparql_query (TrackerDataManager* manager,
                                 const gchar* sparql,
                                 TrackerStorePriority priority,
                                 TrackerStoreSparqlQueryInThread in_thread,
                                 void* in_thread_target,
                                 const gchar* client_id,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
void tracker_store_sparql_query_finish (GAsyncResult* _res_,
                                        GError** error);
static gboolean tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* _data_);
static TrackerStoreQueryTask* tracker_store_query_task_new (void);
static TrackerStoreQueryTask* tracker_store_query_task_construct (GType object_type);
static gboolean _tracker_store_sparql_query_co_gsource_func (gpointer self);
static void tracker_store_sparql_update_data_free (gpointer _data);
void tracker_store_sparql_update (TrackerDataManager* manager,
                                  const gchar* sparql,
                                  TrackerStorePriority priority,
                                  const gchar* client_id,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
void tracker_store_sparql_update_finish (GAsyncResult* _res_,
                                         GError** error);
static gboolean tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* _data_);
static TrackerStoreUpdateTask* tracker_store_update_task_new (void);
static TrackerStoreUpdateTask* tracker_store_update_task_construct (GType object_type);
static gboolean _tracker_store_sparql_update_co_gsource_func (gpointer self);
static void tracker_store_sparql_update_blank_data_free (gpointer _data);
void tracker_store_sparql_update_blank (TrackerDataManager* manager,
                                        const gchar* sparql,
                                        TrackerStorePriority priority,
                                        const gchar* client_id,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_,
                                                    GError** error);
static gboolean tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* _data_);
static gboolean _tracker_store_sparql_update_blank_co_gsource_func (gpointer self);
static void tracker_store_queue_turtle_import_data_free (gpointer _data);
void tracker_store_queue_turtle_import (TrackerDataManager* manager,
                                        GFile* file,
                                        const gchar* client_id,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_,
                                               GError** error);
static gboolean tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* _data_);
static TrackerStoreTurtleTask* tracker_store_turtle_task_new (void);
static TrackerStoreTurtleTask* tracker_store_turtle_task_construct (GType object_type);
static gboolean _tracker_store_queue_turtle_import_co_gsource_func (gpointer self);
guint tracker_store_get_queue_size (TrackerStore* self);
void tracker_store_unreg_batches (const gchar* client_id);
static void tracker_store_pause_data_free (gpointer _data);
void tracker_store_pause (GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
void tracker_store_pause_finish (GAsyncResult* _res_);
static gboolean tracker_store_pause_co (TrackerStorePauseData* _data_);
static gboolean _tracker_store_pause_co_gsource_func (gpointer self);
void tracker_store_resume (void);
TrackerStore* tracker_store_new (void);
TrackerStore* tracker_store_construct (GType object_type);
static TrackerStoreTask* tracker_store_task_construct (GType object_type);
static void tracker_store_task_finalize (TrackerStoreTask * obj);
static void tracker_store_query_task_finalize (TrackerStoreTask * obj);
static void tracker_store_update_task_finalize (TrackerStoreTask * obj);
static void tracker_store_turtle_task_finalize (TrackerStoreTask * obj);
static void tracker_store_finalize (TrackerStore * obj);


GType
tracker_store_priority_get_type (void)
{
	static volatile gsize tracker_store_priority_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_priority_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_STORE_PRIORITY_HIGH, "TRACKER_STORE_PRIORITY_HIGH", "high"}, {TRACKER_STORE_PRIORITY_LOW, "TRACKER_STORE_PRIORITY_LOW", "low"}, {TRACKER_STORE_PRIORITY_TURTLE, "TRACKER_STORE_PRIORITY_TURTLE", "turtle"}, {TRACKER_STORE_PRIORITY_N_PRIORITIES, "TRACKER_STORE_PRIORITY_N_PRIORITIES", "n-priorities"}, {0, NULL, NULL}};
		GType tracker_store_priority_type_id;
		tracker_store_priority_type_id = g_enum_register_static ("TrackerStorePriority", values);
		g_once_init_leave (&tracker_store_priority_type_id__volatile, tracker_store_priority_type_id);
	}
	return tracker_store_priority_type_id__volatile;
}


static GType
tracker_store_task_type_get_type (void)
{
	static volatile gsize tracker_store_task_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_task_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_STORE_TASK_TYPE_QUERY, "TRACKER_STORE_TASK_TYPE_QUERY", "query"}, {TRACKER_STORE_TASK_TYPE_UPDATE, "TRACKER_STORE_TASK_TYPE_UPDATE", "update"}, {TRACKER_STORE_TASK_TYPE_UPDATE_BLANK, "TRACKER_STORE_TASK_TYPE_UPDATE_BLANK", "update-blank"}, {TRACKER_STORE_TASK_TYPE_TURTLE, "TRACKER_STORE_TASK_TYPE_TURTLE", "turtle"}, {0, NULL, NULL}};
		GType tracker_store_task_type_type_id;
		tracker_store_task_type_type_id = g_enum_register_static ("TrackerStoreTaskType", values);
		g_once_init_leave (&tracker_store_task_type_type_id__volatile, tracker_store_task_type_type_id);
	}
	return tracker_store_task_type_type_id__volatile;
}


static gpointer
_tracker_store_task_ref0 (gpointer self)
{
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? tracker_store_task_ref (self) : NULL;
#line 563 "tracker-store.c"
}


static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return _data7_;
#line 574 "tracker-store.c"
}


static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data7_->query_task);
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_slice_free (Block7Data, _data7_);
#line 589 "tracker-store.c"
	}
}


static gboolean
____lambda6_ (Block7Data* _data7_)
{
	gboolean result = FALSE;
	TrackerStoreQueryTask* _tmp0_;
	GCancellable* _tmp1_;
	TrackerStoreQueryTask* _tmp2_;
#line 109 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = _data7_->query_task;
#line 109 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tmp0_->cancellable;
#line 109 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_cancellable_cancel (_tmp1_);
#line 110 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = _data7_->query_task;
#line 110 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_->watchdog_id = (guint) 0;
#line 111 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 111 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 615 "tracker-store.c"
}


static gboolean
_____lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda6_ (self);
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 626 "tracker-store.c"
}


static void
tracker_store_sched (void)
{
	TrackerStoreTask* task = NULL;
	gboolean _tmp0_;
	gboolean _tmp22_;
	GError * _inner_error_ = NULL;
#line 87 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	task = NULL;
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = tracker_store_active;
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!_tmp0_) {
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (task);
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 647 "tracker-store.c"
	}
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	while (TRUE) {
#line 651 "tracker-store.c"
		gint _tmp1_;
		TrackerStoreTask* _tmp9_;
		GPtrArray* _tmp10_;
		TrackerStoreTask* _tmp11_;
		TrackerStoreTask* _tmp12_;
		gint _tmp13_;
		gint _tmp18_;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = tracker_store_n_queries_running;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (!(_tmp1_ < TRACKER_STORE_MAX_CONCURRENT_QUERIES)) {
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			break;
#line 665 "tracker-store.c"
		}
		{
			gint i = 0;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			i = 0;
#line 671 "tracker-store.c"
			{
				gboolean _tmp2_ = FALSE;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = TRUE;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 678 "tracker-store.c"
					gint _tmp4_;
					gint _tmp5_;
					GQueue* _tmp6_;
					gpointer _tmp7_;
					TrackerStoreTask* _tmp8_;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!_tmp2_) {
#line 686 "tracker-store.c"
						gint _tmp3_;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp3_ = i;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						i = _tmp3_ + 1;
#line 692 "tracker-store.c"
					}
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp2_ = FALSE;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp4_ = i;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp4_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 702 "tracker-store.c"
					}
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp5_ = i;
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp6_ = tracker_store_query_queues[_tmp5_];
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp7_ = g_queue_pop_head (_tmp6_);
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (task);
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp7_;
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp8_ = task;
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp8_ != NULL) {
#line 97 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 720 "tracker-store.c"
					}
				}
			}
		}
#line 100 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp9_ = task;
#line 100 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp9_ == NULL) {
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			break;
#line 731 "tracker-store.c"
		}
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp10_ = tracker_store_running_tasks;
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp11_ = task;
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp12_ = _tracker_store_task_ref0 (_tmp11_);
#line 104 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_ptr_array_add (_tmp10_, _tmp12_);
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp13_ = tracker_store_max_task_time;
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp13_ != 0) {
#line 745 "tracker-store.c"
			Block7Data* _data7_;
			TrackerStoreTask* _tmp14_;
			TrackerStoreQueryTask* _tmp15_;
			TrackerStoreQueryTask* _tmp16_;
			gint _tmp17_;
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_ = g_slice_new0 (Block7Data);
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_->_ref_count_ = 1;
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp14_ = task;
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp15_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask));
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_->query_task = _tmp15_;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_ = _data7_->query_task;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_ = tracker_store_max_task_time;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_->watchdog_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp17_, _____lambda6__gsource_func, block7_data_ref (_data7_), block7_data_unref);
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			block7_data_unref (_data7_);
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_ = NULL;
#line 771 "tracker-store.c"
		}
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp18_ = tracker_store_n_queries_running;
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_n_queries_running = _tmp18_ + 1;
#line 777 "tracker-store.c"
		{
			GThreadPool* _tmp19_;
			TrackerStoreTask* _tmp20_;
			TrackerStoreTask* _tmp21_;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp19_ = tracker_store_query_pool;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp20_ = task;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp21_ = _tracker_store_task_ref0 (_tmp20_);
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_thread_pool_push (_tmp19_, _tmp21_, &_inner_error_);
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 792 "tracker-store.c"
				goto __catch19_g_error;
			}
		}
		goto __finally19;
		__catch19_g_error:
		{
			GError* e = NULL;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			e = _inner_error_;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_inner_error_ = NULL;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (e);
#line 806 "tracker-store.c"
		}
		__finally19:
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tracker_store_task_unref0 (task);
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_clear_error (&_inner_error_);
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return;
#line 819 "tracker-store.c"
		}
	}
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp22_ = tracker_store_update_running;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!_tmp22_) {
#line 826 "tracker-store.c"
		TrackerStoreTask* _tmp30_;
		{
			gint i = 0;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			i = 0;
#line 832 "tracker-store.c"
			{
				gboolean _tmp23_ = FALSE;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp23_ = TRUE;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 839 "tracker-store.c"
					gint _tmp25_;
					gint _tmp26_;
					GQueue* _tmp27_;
					gpointer _tmp28_;
					TrackerStoreTask* _tmp29_;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!_tmp23_) {
#line 847 "tracker-store.c"
						gint _tmp24_;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp24_ = i;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						i = _tmp24_ + 1;
#line 853 "tracker-store.c"
					}
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp23_ = FALSE;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp25_ = i;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp25_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 863 "tracker-store.c"
					}
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp26_ = i;
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp27_ = tracker_store_update_queues[_tmp26_];
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_ = g_queue_pop_head (_tmp27_);
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (task);
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp28_;
#line 126 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_ = task;
#line 126 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp29_ != NULL) {
#line 127 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 881 "tracker-store.c"
					}
				}
			}
		}
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp30_ = task;
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp30_ != NULL) {
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_update_running = TRUE;
#line 892 "tracker-store.c"
			{
				GThreadPool* _tmp31_;
				TrackerStoreTask* _tmp32_;
				TrackerStoreTask* _tmp33_;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp31_ = tracker_store_update_pool;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp32_ = task;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp33_ = _tracker_store_task_ref0 (_tmp32_);
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_thread_pool_push (_tmp31_, _tmp33_, &_inner_error_);
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 907 "tracker-store.c"
					goto __catch20_g_error;
				}
			}
			goto __finally20;
			__catch20_g_error:
			{
				GError* e = NULL;
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				e = _inner_error_;
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_inner_error_ = NULL;
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (e);
#line 921 "tracker-store.c"
			}
			__finally20:
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (task);
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_clear_error (&_inner_error_);
#line 132 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return;
#line 934 "tracker-store.c"
			}
		}
	}
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (task);
#line 940 "tracker-store.c"
}


static TrackerDataCommitType
tracker_store_commit_type (TrackerStoreTask* task)
{
	TrackerDataCommitType result = 0;
	TrackerStoreTaskType _tmp0_;
#line 141 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (task != NULL, 0);
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = task->type;
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_tmp0_) {
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_UPDATE:
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_UPDATE_BLANK:
#line 959 "tracker-store.c"
		{
			TrackerStorePriority _tmp1_;
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (task, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask)->priority;
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp1_ == TRACKER_STORE_PRIORITY_HIGH) {
#line 146 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_REGULAR;
#line 146 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 970 "tracker-store.c"
			} else {
				GQueue* _tmp2_;
#line 147 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_LOW];
#line 147 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (g_queue_get_length (_tmp2_) > ((guint) 0)) {
#line 148 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					result = TRACKER_DATA_COMMIT_BATCH;
#line 148 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					return result;
#line 981 "tracker-store.c"
				} else {
#line 150 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					result = TRACKER_DATA_COMMIT_BATCH_LAST;
#line 150 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					return result;
#line 987 "tracker-store.c"
				}
			}
		}
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_TURTLE:
#line 993 "tracker-store.c"
		{
			GQueue* _tmp3_;
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp3_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_TURTLE];
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (g_queue_get_length (_tmp3_) > ((guint) 0)) {
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_BATCH;
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 1004 "tracker-store.c"
			} else {
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_BATCH_LAST;
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 1010 "tracker-store.c"
			}
		}
		default:
		{
#line 159 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_warn_if_reached ();
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			result = TRACKER_DATA_COMMIT_REGULAR;
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return result;
#line 1021 "tracker-store.c"
		}
	}
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 1032 "tracker-store.c"
}


static gboolean
tracker_store_task_finish_cb (TrackerStoreTask* task)
{
	gboolean result = FALSE;
	TrackerData* data = NULL;
	TrackerDataManager* _tmp0_;
	TrackerData* _tmp1_;
	TrackerData* _tmp2_;
	TrackerStoreTaskType _tmp3_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gint _tmp28_;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (task != NULL, FALSE);
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = task->data_manager;
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = tracker_data_manager_get_data (_tmp0_);
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	data = _tmp2_;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = task->type;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp3_ == TRACKER_STORE_TASK_TYPE_QUERY) {
#line 1062 "tracker-store.c"
		TrackerStoreQueryTask* query_task = NULL;
		TrackerStoreQueryTask* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		GError* _tmp7_;
		GSourceFunc _tmp13_;
		void* _tmp13__target;
		GPtrArray* _tmp14_;
		gint _tmp15_;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp4_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (task, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask));
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		query_task = _tmp4_;
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp7_ = task->error;
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp7_ == NULL) {
#line 1080 "tracker-store.c"
			TrackerStoreQueryTask* _tmp8_;
			GCancellable* _tmp9_;
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp8_ = query_task;
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp9_ = _tmp8_->cancellable;
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = _tmp9_ != NULL;
#line 1089 "tracker-store.c"
		} else {
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = FALSE;
#line 1093 "tracker-store.c"
		}
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp6_) {
#line 1097 "tracker-store.c"
			TrackerStoreQueryTask* _tmp10_;
			GCancellable* _tmp11_;
#line 172 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp10_ = query_task;
#line 172 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp11_ = _tmp10_->cancellable;
#line 172 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp5_ = g_cancellable_is_cancelled (_tmp11_);
#line 1106 "tracker-store.c"
		} else {
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp5_ = FALSE;
#line 1110 "tracker-store.c"
		}
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp5_) {
#line 1114 "tracker-store.c"
			GError* _tmp12_;
#line 173 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp12_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 173 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (task->error);
#line 173 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			task->error = _tmp12_;
#line 1122 "tracker-store.c"
		}
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp13_ = task->callback;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp13__target = task->callback_target;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp13_ (_tmp13__target);
#line 177 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (task->error);
#line 177 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		task->error = NULL;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp14_ = tracker_store_running_tasks;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_ptr_array_remove (_tmp14_, task);
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp15_ = tracker_store_n_queries_running;
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_n_queries_running = _tmp15_ - 1;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (query_task);
#line 1144 "tracker-store.c"
	} else {
		gboolean _tmp16_ = FALSE;
		TrackerStoreTaskType _tmp17_;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp17_ = task->type;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp17_ == TRACKER_STORE_TASK_TYPE_UPDATE) {
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_ = TRUE;
#line 1154 "tracker-store.c"
		} else {
			TrackerStoreTaskType _tmp18_;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp18_ = task->type;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_ = _tmp18_ == TRACKER_STORE_TASK_TYPE_UPDATE_BLANK;
#line 1161 "tracker-store.c"
		}
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp16_) {
#line 1165 "tracker-store.c"
			GError* _tmp19_;
			GSourceFunc _tmp21_;
			void* _tmp21__target;
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp19_ = task->error;
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp19_ == NULL) {
#line 1173 "tracker-store.c"
				TrackerData* _tmp20_;
#line 183 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp20_ = data;
#line 183 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_data_notify_transaction (_tmp20_, tracker_store_commit_type (task));
#line 1179 "tracker-store.c"
			}
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp21_ = task->callback;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp21__target = task->callback_target;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp21_ (_tmp21__target);
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (task->error);
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			task->error = NULL;
#line 189 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_update_running = FALSE;
#line 1193 "tracker-store.c"
		} else {
			TrackerStoreTaskType _tmp22_;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp22_ = task->type;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp22_ == TRACKER_STORE_TASK_TYPE_TURTLE) {
#line 1200 "tracker-store.c"
				GError* _tmp23_;
				GSourceFunc _tmp25_;
				void* _tmp25__target;
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp23_ = task->error;
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp23_ == NULL) {
#line 1208 "tracker-store.c"
					TrackerData* _tmp24_;
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp24_ = data;
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					tracker_data_notify_transaction (_tmp24_, tracker_store_commit_type (task));
#line 1214 "tracker-store.c"
				}
#line 195 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp25_ = task->callback;
#line 195 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp25__target = task->callback_target;
#line 195 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp25_ (_tmp25__target);
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (task->error);
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				task->error = NULL;
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_running = FALSE;
#line 1228 "tracker-store.c"
			}
		}
	}
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp28_ = tracker_store_n_queries_running;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp28_ == 0) {
#line 1236 "tracker-store.c"
		gboolean _tmp29_;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp29_ = tracker_store_update_running;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp27_ = !_tmp29_;
#line 1242 "tracker-store.c"
	} else {
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp27_ = FALSE;
#line 1246 "tracker-store.c"
	}
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp27_) {
#line 1250 "tracker-store.c"
		GSourceFunc _tmp30_;
		void* _tmp30__target;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp30_ = tracker_store_active_callback;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp30__target = tracker_store_active_callback_target;
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp26_ = _tmp30_ != NULL;
#line 1259 "tracker-store.c"
	} else {
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp26_ = FALSE;
#line 1263 "tracker-store.c"
	}
#line 201 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp26_) {
#line 1267 "tracker-store.c"
		GSourceFunc _tmp31_;
		void* _tmp31__target;
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp31_ = tracker_store_active_callback;
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp31__target = tracker_store_active_callback_target;
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp31_ (_tmp31__target);
#line 1276 "tracker-store.c"
	}
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (data);
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1286 "tracker-store.c"
}


static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return _data8_;
#line 1297 "tracker-store.c"
}


static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data8_->task);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_slice_free (Block8Data, _data8_);
#line 1312 "tracker-store.c"
	}
}


static void
_tracker_store_wal_hook_tracker_db_wal_callback (TrackerDBInterface* iface,
                                                 gint n_pages)
{
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_wal_hook (iface, n_pages);
#line 1323 "tracker-store.c"
}


static gpointer
_g_error_copy0 (gpointer self)
{
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_error_copy (self) : NULL;
#line 1332 "tracker-store.c"
}


static gboolean
__lambda7_ (Block8Data* _data8_)
{
	gboolean result = FALSE;
#line 249 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_task_finish_cb (_data8_->task);
#line 250 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 250 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1346 "tracker-store.c"
}


static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ (self);
#line 248 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1357 "tracker-store.c"
}


static void
tracker_store_pool_dispatch_cb (TrackerStoreTask* task)
{
	Block8Data* _data8_;
	GError * _inner_error_ = NULL;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (task != NULL);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_->_ref_count_ = 1;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data8_->task);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_->task = task;
#line 1376 "tracker-store.c"
	{
		TrackerStoreTaskType _tmp0_;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp0_ = _data8_->task->type;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp0_ == TRACKER_STORE_TASK_TYPE_QUERY) {
#line 1383 "tracker-store.c"
			TrackerStoreQueryTask* query_task = NULL;
			TrackerStoreQueryTask* _tmp1_;
			TrackerDBCursor* cursor = NULL;
			TrackerDataManager* _tmp2_;
			TrackerStoreQueryTask* _tmp3_;
			const gchar* _tmp4_;
			TrackerDBCursor* _tmp5_;
			TrackerStoreQueryTask* _tmp6_;
			TrackerStoreSparqlQueryInThread _tmp7_;
			void* _tmp7__target;
			TrackerDBCursor* _tmp8_;
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp1_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data8_->task, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask));
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			query_task = _tmp1_;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp2_ = _data8_->task->data_manager;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp3_ = query_task;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp4_ = _tmp3_->query;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp5_ = tracker_data_query_sparql_cursor (_tmp2_, _tmp4_, &_inner_error_);
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			cursor = _tmp5_;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (query_task);
#line 1413 "tracker-store.c"
				goto __catch21_g_error;
			}
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = query_task;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp7_ = _tmp6_->in_thread;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp7__target = _tmp6_->in_thread_target;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp8_ = cursor;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp7_ (_tmp8_, _tmp7__target, &_inner_error_);
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_object_unref0 (cursor);
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (query_task);
#line 1432 "tracker-store.c"
				goto __catch21_g_error;
			}
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (cursor);
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tracker_store_task_unref0 (query_task);
#line 1439 "tracker-store.c"
		} else {
			TrackerData* data = NULL;
			TrackerDataManager* _tmp9_;
			TrackerData* _tmp10_;
			TrackerData* _tmp11_;
			TrackerDBInterface* iface = NULL;
			TrackerDataManager* _tmp12_;
			TrackerDBInterface* _tmp13_;
			TrackerDBInterface* _tmp14_;
			TrackerDBInterface* _tmp15_;
			TrackerStoreTaskType _tmp16_;
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp9_ = _data8_->task->data_manager;
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp10_ = tracker_data_manager_get_data (_tmp9_);
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp11_ = _g_object_ref0 (_tmp10_);
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			data = _tmp11_;
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp12_ = _data8_->task->data_manager;
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp13_ = tracker_data_manager_get_writable_db_interface (_tmp12_);
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp14_ = _g_object_ref0 (_tmp13_);
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			iface = _tmp14_;
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp15_ = iface;
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_db_interface_sqlite_wal_hook (_tmp15_, _tracker_store_wal_hook_tracker_db_wal_callback);
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_ = _data8_->task->type;
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp16_ == TRACKER_STORE_TASK_TYPE_UPDATE) {
#line 1475 "tracker-store.c"
				TrackerStoreUpdateTask* update_task = NULL;
				TrackerStoreUpdateTask* _tmp17_;
				TrackerData* _tmp18_;
				TrackerStoreUpdateTask* _tmp19_;
				const gchar* _tmp20_;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp17_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data8_->task, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask));
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				update_task = _tmp17_;
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp18_ = data;
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp19_ = update_task;
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp20_ = _tmp19_->query;
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_data_update_sparql (_tmp18_, _tmp20_, &_inner_error_);
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (update_task);
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_object_unref0 (iface);
#line 226 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_object_unref0 (data);
#line 1501 "tracker-store.c"
					goto __catch21_g_error;
				}
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (update_task);
#line 1506 "tracker-store.c"
			} else {
				TrackerStoreTaskType _tmp21_;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp21_ = _data8_->task->type;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp21_ == TRACKER_STORE_TASK_TYPE_UPDATE_BLANK) {
#line 1513 "tracker-store.c"
					TrackerStoreUpdateTask* update_task = NULL;
					TrackerStoreUpdateTask* _tmp22_;
					GVariant* _tmp23_ = NULL;
					TrackerData* _tmp24_;
					TrackerStoreUpdateTask* _tmp25_;
					const gchar* _tmp26_;
					GVariant* _tmp27_;
					TrackerStoreUpdateTask* _tmp28_;
					GVariant* _tmp29_;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp22_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data8_->task, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask));
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					update_task = _tmp22_;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp24_ = data;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp25_ = update_task;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp26_ = _tmp25_->query;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp27_ = tracker_data_update_sparql_blank (_tmp24_, _tmp26_, &_inner_error_);
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp23_ = _tmp27_;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tracker_store_task_unref0 (update_task);
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_object_unref0 (iface);
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_object_unref0 (data);
#line 1545 "tracker-store.c"
						goto __catch21_g_error;
					}
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_ = update_task;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_ = _tmp23_;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp23_ = NULL;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_variant_unref0 (_tmp28_->blank_nodes);
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_->blank_nodes = _tmp29_;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_variant_unref0 (_tmp23_);
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (update_task);
#line 1562 "tracker-store.c"
				} else {
					TrackerStoreTaskType _tmp30_;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp30_ = _data8_->task->type;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp30_ == TRACKER_STORE_TASK_TYPE_TURTLE) {
#line 1569 "tracker-store.c"
						TrackerStoreTurtleTask* turtle_task = NULL;
						TrackerStoreTurtleTask* _tmp31_;
						GFile* file = NULL;
						TrackerStoreTurtleTask* _tmp32_;
						const gchar* _tmp33_;
						GFile* _tmp34_;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp31_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data8_->task, TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTask));
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						turtle_task = _tmp31_;
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp32_ = turtle_task;
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp33_ = _tmp32_->path;
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp34_ = g_file_new_for_path (_tmp33_);
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						file = _tmp34_;
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						tracker_events_freeze ();
#line 1590 "tracker-store.c"
						{
							TrackerData* _tmp35_;
							GFile* _tmp36_;
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_tmp35_ = data;
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_tmp36_ = file;
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							tracker_data_load_turtle_file (_tmp35_, _tmp36_, &_inner_error_);
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1602 "tracker-store.c"
								goto __finally22;
							}
						}
						__finally22:
						{
#line 240 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							tracker_events_reset_pending ();
#line 1610 "tracker-store.c"
						}
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_g_object_unref0 (file);
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_tracker_store_task_unref0 (turtle_task);
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_g_object_unref0 (iface);
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_g_object_unref0 (data);
#line 1622 "tracker-store.c"
							goto __catch21_g_error;
						}
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_object_unref0 (file);
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tracker_store_task_unref0 (turtle_task);
#line 1629 "tracker-store.c"
					}
				}
			}
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (iface);
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (data);
#line 1637 "tracker-store.c"
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GError* _tmp37_;
		GError* _tmp38_;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp37_ = e;
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp38_ = _g_error_copy0 (_tmp37_);
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (_data8_->task->error);
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data8_->task->error = _tmp38_;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 1660 "tracker-store.c"
	}
	__finally21:
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		block8_data_unref (_data8_);
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data8_ = NULL;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 1675 "tracker-store.c"
	}
#line 248 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda7__gsource_func, block8_data_ref (_data8_), block8_data_unref);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	block8_data_unref (_data8_);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_ = NULL;
#line 1683 "tracker-store.c"
}


void
tracker_store_wal_checkpoint (TrackerDBInterface* iface,
                              gboolean blocking)
{
	GError * _inner_error_ = NULL;
#line 254 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (iface != NULL);
#line 1694 "tracker-store.c"
	{
#line 256 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_debug ("Checkpointing database...");
#line 257 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_db_interface_sqlite_wal_checkpoint (iface, blocking, &_inner_error_);
#line 257 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1702 "tracker-store.c"
			goto __catch23_g_error;
		}
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_debug ("Checkpointing complete...");
#line 1707 "tracker-store.c"
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 260 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp0_ = e;
#line 260 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = _tmp0_->message;
#line 260 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_warning ("%s", _tmp1_);
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 1727 "tracker-store.c"
	}
	__finally23:
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 1738 "tracker-store.c"
	}
}


static void
tracker_store_wal_hook (TrackerDBInterface* iface,
                        gint n_pages)
{
	TrackerDataManager* manager = NULL;
	GObject* _tmp0_;
	TrackerDataManager* _tmp1_;
	TrackerDBInterface* wal_iface = NULL;
	TrackerDataManager* _tmp2_;
	TrackerDBInterface* _tmp3_;
	TrackerDBInterface* _tmp4_;
	GError * _inner_error_ = NULL;
#line 266 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (iface != NULL);
#line 268 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = tracker_db_interface_get_user_data (iface);
#line 268 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TRACKER_TYPE_DATA_MANAGER, TrackerDataManager));
#line 268 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	manager = _tmp1_;
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = manager;
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = tracker_data_manager_get_wal_db_interface (_tmp2_);
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	wal_iface = _tmp4_;
#line 271 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_debug ("WAL: %d pages", n_pages);
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (n_pages >= 10000) {
#line 1775 "tracker-store.c"
		TrackerDBInterface* _tmp5_;
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp5_ = wal_iface;
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_wal_checkpoint (_tmp5_, TRUE);
#line 1781 "tracker-store.c"
	} else {
		gboolean _tmp6_ = FALSE;
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (n_pages >= 1000) {
#line 1786 "tracker-store.c"
			GThreadPool* _tmp7_;
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp7_ = tracker_store_checkpoint_pool;
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = _tmp7_ != NULL;
#line 1792 "tracker-store.c"
		} else {
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = FALSE;
#line 1796 "tracker-store.c"
		}
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp6_) {
#line 1800 "tracker-store.c"
			gboolean _tmp8_;
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp8_ = g_atomic_int_compare_and_exchange ((volatile gint *) (&tracker_store_checkpointing), 0, 1);
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp8_) {
#line 1806 "tracker-store.c"
				{
					GThreadPool* _tmp9_;
					TrackerDBInterface* _tmp10_;
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp9_ = tracker_store_checkpoint_pool;
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp10_ = wal_iface;
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_thread_pool_push (_tmp9_, _tmp10_, &_inner_error_);
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1818 "tracker-store.c"
						goto __catch24_g_error;
					}
				}
				goto __finally24;
				__catch24_g_error:
				{
					GError* e = NULL;
					GError* _tmp11_;
					const gchar* _tmp12_;
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					e = _inner_error_;
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_inner_error_ = NULL;
#line 283 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp11_ = e;
#line 283 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp12_ = _tmp11_->message;
#line 283 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_warning ("%s", _tmp12_);
#line 284 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_atomic_int_set ((volatile gint *) (&tracker_store_checkpointing), 0);
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_error_free0 (e);
#line 1842 "tracker-store.c"
				}
				__finally24:
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_object_unref0 (wal_iface);
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_object_unref0 (manager);
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_clear_error (&_inner_error_);
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					return;
#line 1857 "tracker-store.c"
				}
			}
		}
	}
#line 266 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (wal_iface);
#line 266 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (manager);
#line 1866 "tracker-store.c"
}


static void
tracker_store_checkpoint_dispatch_cb (TrackerDBInterface* iface)
{
#line 290 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (iface != NULL);
#line 292 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_wal_checkpoint (iface, FALSE);
#line 293 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_set ((volatile gint *) (&tracker_store_checkpointing), 0);
#line 1879 "tracker-store.c"
}


static void
_tracker_store_task_unref0_ (gpointer var)
{
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(var == NULL) ? NULL : (var = (tracker_store_task_unref (var), NULL));
#line 1888 "tracker-store.c"
}


static inline void
_g_queue_free__tracker_store_task_unref0_ (GQueue* self)
{
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_free_full (self, (GDestroyNotify) _tracker_store_task_unref0_);
#line 1897 "tracker-store.c"
}


static void
_tracker_store_pool_dispatch_cb_gfunc (gpointer data,
                                       gpointer self)
{
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_pool_dispatch_cb ((TrackerStoreTask*) data);
#line 1907 "tracker-store.c"
}


static void
_tracker_store_checkpoint_dispatch_cb_gfunc (gconstpointer data,
                                             gpointer self)
{
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_checkpoint_dispatch_cb ((TrackerDBInterface*) data);
#line 1917 "tracker-store.c"
}


void
tracker_store_init (void)
{
	gchar* max_task_time_env = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GPtrArray* _tmp4_;
	GError * _inner_error_ = NULL;
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = g_getenv ("TRACKER_STORE_MAX_TASK_TIME");
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	max_task_time_env = _tmp1_;
#line 298 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = max_task_time_env;
#line 298 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp2_ != NULL) {
#line 1940 "tracker-store.c"
		const gchar* _tmp3_;
#line 299 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp3_ = max_task_time_env;
#line 299 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_max_task_time = atoi (_tmp3_);
#line 1946 "tracker-store.c"
	} else {
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_max_task_time = TRACKER_STORE_MAX_TASK_TIME;
#line 1950 "tracker-store.c"
	}
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = g_ptr_array_new_full ((guint) 0, _tracker_store_task_unref0_);
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_ptr_array_unref0 (tracker_store_running_tasks);
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_running_tasks = _tmp4_;
#line 1958 "tracker-store.c"
	{
		gint i = 0;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 1963 "tracker-store.c"
		{
			gboolean _tmp5_ = FALSE;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp5_ = TRUE;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 1970 "tracker-store.c"
				gint _tmp7_;
				gint _tmp8_;
				GQueue* _tmp9_;
				GQueue* _tmp10_;
				gint _tmp11_;
				GQueue* _tmp12_;
				GQueue* _tmp13_;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp5_) {
#line 1980 "tracker-store.c"
					gint _tmp6_;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp6_ = i;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp6_ + 1;
#line 1986 "tracker-store.c"
				}
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = FALSE;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = i;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp7_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 1996 "tracker-store.c"
				}
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = i;
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = g_queue_new ();
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_query_queues[_tmp8_]);
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_query_queues[_tmp8_] = _tmp9_;
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp10_ = tracker_store_query_queues[_tmp8_];
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp11_ = i;
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp12_ = g_queue_new ();
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_update_queues[_tmp11_]);
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_queues[_tmp11_] = _tmp12_;
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp13_ = tracker_store_update_queues[_tmp11_];
#line 2018 "tracker-store.c"
			}
		}
	}
	{
		GThreadPool* _tmp14_ = NULL;
		GThreadPool* _tmp15_;
		GThreadPool* _tmp16_;
		GThreadPool* _tmp17_ = NULL;
		GThreadPool* _tmp18_;
		GThreadPool* _tmp19_;
		GThreadPool* _tmp20_ = NULL;
		GThreadPool* _tmp21_;
		GThreadPool* _tmp22_;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp15_ = g_thread_pool_new (_tracker_store_pool_dispatch_cb_gfunc, NULL, 1, TRUE, &_inner_error_);
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp14_ = _tmp15_;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2038 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp16_ = _tmp14_;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp14_ = NULL;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_update_pool);
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_update_pool = _tmp16_;
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp18_ = g_thread_pool_new (_tracker_store_pool_dispatch_cb_gfunc, NULL, TRACKER_STORE_MAX_CONCURRENT_QUERIES, TRUE, &_inner_error_);
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp17_ = _tmp18_;
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_tmp14_);
#line 2057 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp19_ = _tmp17_;
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp17_ = NULL;
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_query_pool);
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_query_pool = _tmp19_;
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp21_ = g_thread_pool_new (_tracker_store_checkpoint_dispatch_cb_gfunc, NULL, 1, TRUE, &_inner_error_);
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp20_ = _tmp21_;
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_tmp17_);
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_tmp14_);
#line 2078 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp22_ = _tmp20_;
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp20_ = NULL;
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_checkpoint_pool = _tmp22_;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (_tmp20_);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (_tmp17_);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (_tmp14_);
#line 2095 "tracker-store.c"
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp23_ = e;
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp24_ = _tmp23_->message;
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_warning ("%s", _tmp24_);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 2115 "tracker-store.c"
	}
	__finally25:
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_free0 (max_task_time_env);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2128 "tracker-store.c"
	}
#line 322 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_thread_pool_set_max_idle_time ((guint) (15 * 1000));
#line 323 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_thread_pool_set_max_unused_threads (2);
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (max_task_time_env);
#line 2136 "tracker-store.c"
}


void
tracker_store_shutdown (void)
{
#line 327 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_query_pool);
#line 327 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_query_pool = NULL;
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_update_pool);
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_update_pool = NULL;
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_checkpoint_pool = NULL;
#line 2155 "tracker-store.c"
	{
		gint i = 0;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 2160 "tracker-store.c"
		{
			gboolean _tmp0_ = FALSE;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 2167 "tracker-store.c"
				gint _tmp2_;
				gint _tmp3_;
				GQueue* _tmp4_;
				gint _tmp5_;
				GQueue* _tmp6_;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp0_) {
#line 2175 "tracker-store.c"
					gint _tmp1_;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp1_ = i;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp1_ + 1;
#line 2181 "tracker-store.c"
				}
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = i;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp2_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 2191 "tracker-store.c"
				}
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = i;
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_query_queues[_tmp3_]);
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_query_queues[_tmp3_] = NULL;
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = tracker_store_query_queues[_tmp3_];
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = i;
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_update_queues[_tmp5_]);
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_queues[_tmp5_] = NULL;
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = tracker_store_update_queues[_tmp5_];
#line 2209 "tracker-store.c"
			}
		}
	}
}


static void
tracker_store_sparql_query_data_free (gpointer _data)
{
	TrackerStoreSparqlQueryData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlQueryData, _data_);
#line 2229 "tracker-store.c"
}


void
tracker_store_sparql_query (TrackerDataManager* manager,
                            const gchar* sparql,
                            TrackerStorePriority priority,
                            TrackerStoreSparqlQueryInThread in_thread,
                            void* in_thread_target,
                            const gchar* client_id,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	TrackerStoreSparqlQueryData* _data_;
	TrackerDataManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlQueryData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_query_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = _g_object_ref0 (manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->manager = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = priority;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->in_thread = in_thread;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->in_thread_target = in_thread_target;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = g_strdup (client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_query_co (_data_);
#line 2279 "tracker-store.c"
}


void
tracker_store_sparql_query_finish (GAsyncResult* _res_,
                                   GError** error)
{
	TrackerStoreSparqlQueryData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2294 "tracker-store.c"
	}
}


static gboolean
_tracker_store_sparql_query_co_gsource_func (gpointer self)
{
	gboolean result;
	result = tracker_store_sparql_query_co (self);
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2306 "tracker-store.c"
}


static gboolean
tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* _data_)
{
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2317 "tracker-store.c"
		goto _state_0;
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2321 "tracker-store.c"
		goto _state_1;
		default:
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2326 "tracker-store.c"
	}
	_state_0:
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_query_task_new ();
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_QUERY;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = g_strdup (_data_->sparql);
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->query);
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp3_;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = _data_->task;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = g_cancellable_new ();
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->_tmp4_->cancellable);
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_->cancellable = _data_->_tmp5_;
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->task;
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_->in_thread = _data_->in_thread;
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_->in_thread_target = _data_->in_thread_target;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->task;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp7_)->callback_target), NULL);
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = NULL;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = NULL;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = _tracker_store_sparql_query_co_gsource_func;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = _data_;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->task;
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = g_strdup (_data_->client_id);
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp8_)->client_id);
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp8_)->client_id = _data_->_tmp9_;
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = _data_->task;
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _g_object_ref0 (_data_->manager);
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (((TrackerStoreTask*) _data_->_tmp10_)->data_manager);
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp10_)->data_manager = _data_->_tmp11_;
#line 347 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = tracker_store_query_queues[_data_->priority];
#line 347 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _data_->task;
#line 347 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp13_);
#line 347 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp12_, _data_->_tmp14_);
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2405 "tracker-store.c"
	_state_1:
	;
#line 353 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = _data_->task;
#line 353 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = ((TrackerStoreTask*) _data_->_tmp15_)->error;
#line 353 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp16_ != NULL) {
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp17_ = _data_->task;
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp18_ = ((TrackerStoreTask*) _data_->_tmp17_)->error;
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp19_ = _g_error_copy0 (_data_->_tmp18_);
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp19_;
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2430 "tracker-store.c"
	}
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2442 "tracker-store.c"
		}
	}
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2449 "tracker-store.c"
}


static void
tracker_store_sparql_update_data_free (gpointer _data)
{
	TrackerStoreSparqlUpdateData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlUpdateData, _data_);
#line 2466 "tracker-store.c"
}


void
tracker_store_sparql_update (TrackerDataManager* manager,
                             const gchar* sparql,
                             TrackerStorePriority priority,
                             const gchar* client_id,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	TrackerStoreSparqlUpdateData* _data_;
	TrackerDataManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_update_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = _g_object_ref0 (manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->manager = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = priority;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = g_strdup (client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_update_co (_data_);
#line 2510 "tracker-store.c"
}


void
tracker_store_sparql_update_finish (GAsyncResult* _res_,
                                    GError** error)
{
	TrackerStoreSparqlUpdateData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2525 "tracker-store.c"
	}
}


static gboolean
_tracker_store_sparql_update_co_gsource_func (gpointer self)
{
	gboolean result;
	result = tracker_store_sparql_update_co (self);
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2537 "tracker-store.c"
}


static gboolean
tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* _data_)
{
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2548 "tracker-store.c"
		goto _state_0;
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2552 "tracker-store.c"
		goto _state_1;
		default:
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2557 "tracker-store.c"
	}
	_state_0:
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_update_task_new ();
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_UPDATE;
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = g_strdup (_data_->sparql);
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->query);
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp3_;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = _data_->task;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_->priority = _data_->priority;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp5_)->callback_target), NULL);
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback = NULL;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target = NULL;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify = NULL;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback = _tracker_store_sparql_update_co_gsource_func;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target = _data_;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify = NULL;
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->task;
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = g_strdup (_data_->client_id);
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp6_)->client_id);
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp6_)->client_id = _data_->_tmp7_;
#line 365 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->task;
#line 365 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _g_object_ref0 (_data_->manager);
#line 365 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (((TrackerStoreTask*) _data_->_tmp8_)->data_manager);
#line 365 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp8_)->data_manager = _data_->_tmp9_;
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = tracker_store_update_queues[_data_->priority];
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _data_->task;
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp11_);
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp10_, _data_->_tmp12_);
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 371 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 371 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2626 "tracker-store.c"
	_state_1:
	;
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _data_->task;
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = ((TrackerStoreTask*) _data_->_tmp13_)->error;
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp14_ != NULL) {
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp15_ = _data_->task;
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp16_ = ((TrackerStoreTask*) _data_->_tmp15_)->error;
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp17_ = _g_error_copy0 (_data_->_tmp16_);
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp17_;
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2651 "tracker-store.c"
	}
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2663 "tracker-store.c"
		}
	}
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2670 "tracker-store.c"
}


static void
tracker_store_sparql_update_blank_data_free (gpointer _data)
{
	TrackerStoreSparqlUpdateBlankData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_variant_unref0 (_data_->result);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlUpdateBlankData, _data_);
#line 2689 "tracker-store.c"
}


void
tracker_store_sparql_update_blank (TrackerDataManager* manager,
                                   const gchar* sparql,
                                   TrackerStorePriority priority,
                                   const gchar* client_id,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	TrackerStoreSparqlUpdateBlankData* _data_;
	TrackerDataManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateBlankData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_update_blank_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = _g_object_ref0 (manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->manager = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = priority;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = g_strdup (client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_update_blank_co (_data_);
#line 2733 "tracker-store.c"
}


GVariant*
tracker_store_sparql_update_blank_finish (GAsyncResult* _res_,
                                          GError** error)
{
	GVariant* result;
	TrackerStoreSparqlUpdateBlankData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return NULL;
#line 2749 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = _data_->result;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->result = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2757 "tracker-store.c"
}


static gboolean
_tracker_store_sparql_update_blank_co_gsource_func (gpointer self)
{
	gboolean result;
	result = tracker_store_sparql_update_blank_co (self);
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2768 "tracker-store.c"
}


static gpointer
_g_variant_ref0 (gpointer self)
{
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_variant_ref (self) : NULL;
#line 2777 "tracker-store.c"
}


static gboolean
tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* _data_)
{
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2788 "tracker-store.c"
		goto _state_0;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2792 "tracker-store.c"
		goto _state_1;
		default:
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2797 "tracker-store.c"
	}
	_state_0:
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_update_task_new ();
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 380 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 380 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_UPDATE_BLANK;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = g_strdup (_data_->sparql);
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->query);
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp3_;
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = _data_->task;
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_->priority = _data_->priority;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp5_)->callback_target), NULL);
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback = NULL;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target = NULL;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify = NULL;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback = _tracker_store_sparql_update_blank_co_gsource_func;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target = _data_;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify = NULL;
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->task;
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = g_strdup (_data_->client_id);
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp6_)->client_id);
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp6_)->client_id = _data_->_tmp7_;
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->task;
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _g_object_ref0 (_data_->manager);
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (((TrackerStoreTask*) _data_->_tmp8_)->data_manager);
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp8_)->data_manager = _data_->_tmp9_;
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = tracker_store_update_queues[_data_->priority];
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _data_->task;
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp11_);
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp10_, _data_->_tmp12_);
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2866 "tracker-store.c"
	_state_1:
	;
#line 393 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _data_->task;
#line 393 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = ((TrackerStoreTask*) _data_->_tmp13_)->error;
#line 393 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp14_ != NULL) {
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp15_ = _data_->task;
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp16_ = ((TrackerStoreTask*) _data_->_tmp15_)->error;
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp17_ = _g_error_copy0 (_data_->_tmp16_);
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp17_;
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2891 "tracker-store.c"
	}
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp18_ = _data_->task;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp19_ = _data_->_tmp18_->blank_nodes;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp20_ = _g_variant_ref0 (_data_->_tmp19_);
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->result = _data_->_tmp20_;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2911 "tracker-store.c"
		}
	}
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2918 "tracker-store.c"
}


static void
tracker_store_queue_turtle_import_data_free (gpointer _data)
{
	TrackerStoreQueueTurtleImportData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->file);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreQueueTurtleImportData, _data_);
#line 2935 "tracker-store.c"
}


void
tracker_store_queue_turtle_import (TrackerDataManager* manager,
                                   GFile* file,
                                   const gchar* client_id,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	TrackerStoreQueueTurtleImportData* _data_;
	TrackerDataManager* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreQueueTurtleImportData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_queue_turtle_import_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = _g_object_ref0 (manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->manager = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _g_object_ref0 (file);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->file);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->file = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = g_strdup (client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_queue_turtle_import_co (_data_);
#line 2976 "tracker-store.c"
}


void
tracker_store_queue_turtle_import_finish (GAsyncResult* _res_,
                                          GError** error)
{
	TrackerStoreQueueTurtleImportData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2991 "tracker-store.c"
	}
}


static gboolean
_tracker_store_queue_turtle_import_co_gsource_func (gpointer self)
{
	gboolean result;
	result = tracker_store_queue_turtle_import_co (self);
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 3003 "tracker-store.c"
}


static gboolean
tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* _data_)
{
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 3014 "tracker-store.c"
		goto _state_0;
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 3018 "tracker-store.c"
		goto _state_1;
		default:
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 3023 "tracker-store.c"
	}
	_state_0:
#line 401 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_turtle_task_new ();
#line 401 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 402 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 402 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_TURTLE;
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = g_file_get_path (_data_->file);
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->path);
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->path = _data_->_tmp3_;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = _data_->task;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp4_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp4_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp4_)->callback_target), NULL);
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp4_)->callback = NULL;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp4_)->callback_target = NULL;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp4_)->callback_target_destroy_notify = NULL;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp4_)->callback = _tracker_store_queue_turtle_import_co_gsource_func;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp4_)->callback_target = _data_;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp4_)->callback_target_destroy_notify = NULL;
#line 405 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 405 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = g_strdup (_data_->client_id);
#line 405 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp5_)->client_id);
#line 405 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->client_id = _data_->_tmp6_;
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->task;
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _g_object_ref0 (_data_->manager);
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (((TrackerStoreTask*) _data_->_tmp7_)->data_manager);
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->data_manager = _data_->_tmp8_;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_TURTLE];
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = _data_->task;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp10_);
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp9_, _data_->_tmp11_);
#line 410 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 412 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 412 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 3088 "tracker-store.c"
	_state_1:
	;
#line 414 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = _data_->task;
#line 414 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = ((TrackerStoreTask*) _data_->_tmp12_)->error;
#line 414 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp13_ != NULL) {
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp14_ = _data_->task;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp15_ = ((TrackerStoreTask*) _data_->_tmp14_)->error;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp16_;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 3113 "tracker-store.c"
	}
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3125 "tracker-store.c"
		}
	}
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 3132 "tracker-store.c"
}


guint
tracker_store_get_queue_size (TrackerStore* self)
{
	guint result = 0U;
	guint _result_ = 0U;
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 420 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_result_ = (guint) 0;
#line 3145 "tracker-store.c"
	{
		gint i = 0;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3150 "tracker-store.c"
		{
			gboolean _tmp0_ = FALSE;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3157 "tracker-store.c"
				gint _tmp2_;
				guint _tmp3_;
				gint _tmp4_;
				GQueue* _tmp5_;
				guint _tmp6_;
				gint _tmp7_;
				GQueue* _tmp8_;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp0_) {
#line 3167 "tracker-store.c"
					gint _tmp1_;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp1_ = i;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp1_ + 1;
#line 3173 "tracker-store.c"
				}
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = i;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp2_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3183 "tracker-store.c"
				}
#line 423 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = _result_;
#line 423 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = i;
#line 423 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = tracker_store_query_queues[_tmp4_];
#line 423 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_result_ = _tmp3_ + g_queue_get_length (_tmp5_);
#line 424 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = _result_;
#line 424 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = i;
#line 424 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = tracker_store_update_queues[_tmp7_];
#line 424 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_result_ = _tmp6_ + g_queue_get_length (_tmp8_);
#line 3201 "tracker-store.c"
			}
		}
	}
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = _result_;
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 3209 "tracker-store.c"
}


static gint
g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	guint _tmp0_;
#line 5005 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 5005 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = self->len;
#line 5005 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 5005 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 3226 "tracker-store.c"
}


static void
g_ptr_array_set_length (GPtrArray* self,
                        gint value)
{
#line 5006 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 5006 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_ptr_array_set_size (self, value);
#line 3238 "tracker-store.c"
}


void
tracker_store_unreg_batches (const gchar* client_id)
{
	GList* list = NULL;
	GList* cur = NULL;
	GQueue* queue = NULL;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (client_id != NULL);
#line 3250 "tracker-store.c"
	{
		gint i = 0;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3255 "tracker-store.c"
		{
			gboolean _tmp0_ = FALSE;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3262 "tracker-store.c"
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				TrackerStoreQueryTask* task = NULL;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				TrackerStoreTask* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				TrackerStoreQueryTask* _tmp12_;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp0_) {
#line 3277 "tracker-store.c"
					gint _tmp1_;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp1_ = i;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp1_ + 1;
#line 3283 "tracker-store.c"
				}
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = i;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = tracker_store_running_tasks;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = _tmp4_;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3299 "tracker-store.c"
				}
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = tracker_store_running_tasks;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = i;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = (TrackerStoreTask*) _tmp8_;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				task = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TRACKER_STORE_TYPE_QUERY_TASK) ? ((TrackerStoreQueryTask*) _tmp9_) : NULL;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp12_ = task;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp12_ != NULL) {
#line 3315 "tracker-store.c"
					TrackerStoreQueryTask* _tmp13_;
					const gchar* _tmp14_;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp13_ = task;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp14_ = ((TrackerStoreTask*) _tmp13_)->client_id;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp11_ = g_strcmp0 (_tmp14_, client_id) == 0;
#line 3324 "tracker-store.c"
				} else {
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp11_ = FALSE;
#line 3328 "tracker-store.c"
				}
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp11_) {
#line 3332 "tracker-store.c"
					TrackerStoreQueryTask* _tmp15_;
					GCancellable* _tmp16_;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp15_ = task;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp16_ = _tmp15_->cancellable;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp10_ = _tmp16_ != NULL;
#line 3341 "tracker-store.c"
				} else {
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp10_ = FALSE;
#line 3345 "tracker-store.c"
				}
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp10_) {
#line 3349 "tracker-store.c"
					TrackerStoreQueryTask* _tmp17_;
					GCancellable* _tmp18_;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp17_ = task;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp18_ = _tmp17_->cancellable;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_cancellable_cancel (_tmp18_);
#line 3358 "tracker-store.c"
				}
			}
		}
	}
	{
		gint i = 0;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3367 "tracker-store.c"
		{
			gboolean _tmp19_ = FALSE;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp19_ = TRUE;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3374 "tracker-store.c"
				gint _tmp21_;
				gint _tmp22_;
				GQueue* _tmp23_;
				GQueue* _tmp24_;
				GList* _tmp25_;
				gint _tmp42_;
				GQueue* _tmp43_;
				GQueue* _tmp44_;
				GList* _tmp45_;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp19_) {
#line 3386 "tracker-store.c"
					gint _tmp20_;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp20_ = i;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp20_ + 1;
#line 3392 "tracker-store.c"
				}
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp19_ = FALSE;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp21_ = i;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp21_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3402 "tracker-store.c"
				}
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp22_ = i;
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp23_ = tracker_store_query_queues[_tmp22_];
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				queue = _tmp23_;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp24_ = queue;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp25_ = _tmp24_->head;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				list = _tmp25_;
#line 443 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 3418 "tracker-store.c"
					GList* _tmp26_;
					GList* _tmp27_;
					GList* _tmp28_;
					GList* _tmp29_;
					TrackerStoreTask* task = NULL;
					GList* _tmp30_;
					gconstpointer _tmp31_;
					gboolean _tmp32_ = FALSE;
					TrackerStoreTask* _tmp33_;
#line 443 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp26_ = list;
#line 443 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp26_ != NULL)) {
#line 443 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 3434 "tracker-store.c"
					}
#line 444 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp27_ = list;
#line 444 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					cur = _tmp27_;
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_ = list;
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_ = _tmp28_->next;
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					list = _tmp29_;
#line 446 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp30_ = cur;
#line 446 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp31_ = _tmp30_->data;
#line 446 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp31_;
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp33_ = task;
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp33_ != NULL) {
#line 3456 "tracker-store.c"
						TrackerStoreTask* _tmp34_;
						const gchar* _tmp35_;
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp34_ = task;
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp35_ = _tmp34_->client_id;
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp32_ = g_strcmp0 (_tmp35_, client_id) == 0;
#line 3465 "tracker-store.c"
					} else {
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp32_ = FALSE;
#line 3469 "tracker-store.c"
					}
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp32_) {
#line 3473 "tracker-store.c"
						GQueue* _tmp36_;
						GList* _tmp37_;
						TrackerStoreTask* _tmp38_;
						GError* _tmp39_;
						TrackerStoreTask* _tmp40_;
						GSourceFunc _tmp41_;
						void* _tmp41__target;
#line 449 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp36_ = queue;
#line 449 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp37_ = cur;
#line 449 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						g_queue_delete_link (_tmp36_, _tmp37_);
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp38_ = task;
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp39_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Client disappeared");
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_error_free0 (_tmp38_->error);
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp38_->error = _tmp39_;
#line 452 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp40_ = task;
#line 452 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp41_ = _tmp40_->callback;
#line 452 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp41__target = _tmp40_->callback_target;
#line 452 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp41_ (_tmp41__target);
#line 3503 "tracker-store.c"
					}
				}
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp42_ = i;
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp43_ = tracker_store_update_queues[_tmp42_];
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				queue = _tmp43_;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp44_ = queue;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp45_ = _tmp44_->head;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				list = _tmp45_;
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 3520 "tracker-store.c"
					GList* _tmp46_;
					GList* _tmp47_;
					GList* _tmp48_;
					GList* _tmp49_;
					TrackerStoreTask* task = NULL;
					GList* _tmp50_;
					gconstpointer _tmp51_;
					gboolean _tmp52_ = FALSE;
					TrackerStoreTask* _tmp53_;
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp46_ = list;
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp46_ != NULL)) {
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 3536 "tracker-store.c"
					}
#line 459 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp47_ = list;
#line 459 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					cur = _tmp47_;
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp48_ = list;
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp49_ = _tmp48_->next;
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					list = _tmp49_;
#line 461 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp50_ = cur;
#line 461 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp51_ = _tmp50_->data;
#line 461 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp51_;
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp53_ = task;
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp53_ != NULL) {
#line 3558 "tracker-store.c"
						TrackerStoreTask* _tmp54_;
						const gchar* _tmp55_;
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp54_ = task;
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp55_ = _tmp54_->client_id;
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp52_ = g_strcmp0 (_tmp55_, client_id) == 0;
#line 3567 "tracker-store.c"
					} else {
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp52_ = FALSE;
#line 3571 "tracker-store.c"
					}
#line 463 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp52_) {
#line 3575 "tracker-store.c"
						GQueue* _tmp56_;
						GList* _tmp57_;
						TrackerStoreTask* _tmp58_;
						GError* _tmp59_;
						TrackerStoreTask* _tmp60_;
						GSourceFunc _tmp61_;
						void* _tmp61__target;
#line 464 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp56_ = queue;
#line 464 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp57_ = cur;
#line 464 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						g_queue_delete_link (_tmp56_, _tmp57_);
#line 466 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp58_ = task;
#line 466 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp59_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Client disappeared");
#line 466 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_error_free0 (_tmp58_->error);
#line 466 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp58_->error = _tmp59_;
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp60_ = task;
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp61_ = _tmp60_->callback;
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp61__target = _tmp60_->callback_target;
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp61_ (_tmp61__target);
#line 3605 "tracker-store.c"
					}
				}
			}
		}
	}
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 3613 "tracker-store.c"
}


static void
tracker_store_pause_data_free (gpointer _data)
{
	TrackerStorePauseData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStorePauseData, _data_);
#line 3624 "tracker-store.c"
}


void
tracker_store_pause (GAsyncReadyCallback _callback_,
                     gpointer _user_data_)
{
	TrackerStorePauseData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStorePauseData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_pause_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_pause_co (_data_);
#line 3641 "tracker-store.c"
}


void
tracker_store_pause_finish (GAsyncResult* _res_)
{
	TrackerStorePauseData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3651 "tracker-store.c"
}


static gboolean
_tracker_store_pause_co_gsource_func (gpointer self)
{
	gboolean result;
	result = tracker_store_pause_co (self);
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 3662 "tracker-store.c"
}


static gboolean
tracker_store_pause_co (TrackerStorePauseData* _data_)
{
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 3673 "tracker-store.c"
		goto _state_0;
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 3677 "tracker-store.c"
		goto _state_1;
		default:
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 3682 "tracker-store.c"
	}
	_state_0:
#line 476 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_active = FALSE;
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = tracker_store_n_queries_running;
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp1_ > 0) {
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp0_ = TRUE;
#line 3693 "tracker-store.c"
	} else {
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp2_ = tracker_store_update_running;
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp0_ = _data_->_tmp2_;
#line 3699 "tracker-store.c"
	}
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp0_) {
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		(tracker_store_active_callback_target_destroy_notify == NULL) ? NULL : (tracker_store_active_callback_target_destroy_notify (tracker_store_active_callback_target), NULL);
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = _tracker_store_pause_co_gsource_func;
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = _data_;
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_state_ = 1;
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 3721 "tracker-store.c"
		_state_1:
		;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		(tracker_store_active_callback_target_destroy_notify == NULL) ? NULL : (tracker_store_active_callback_target_destroy_notify (tracker_store_active_callback_target), NULL);
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 3738 "tracker-store.c"
	}
#line 484 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = g_atomic_int_get ((volatile gint *) (&tracker_store_checkpointing));
#line 484 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp3_ != 0) {
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_checkpoint_pool = NULL;
#line 3748 "tracker-store.c"
		{
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp5_ = g_thread_pool_new (_tracker_store_checkpoint_dispatch_cb_gfunc, NULL, 1, TRUE, &_data_->_inner_error_);
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp4_ = _data_->_tmp5_;
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 3756 "tracker-store.c"
				goto __catch26_g_error;
			}
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp6_ = _data_->_tmp4_;
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp4_ = NULL;
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_checkpoint_pool = _data_->_tmp6_;
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_data_->_tmp4_);
#line 3769 "tracker-store.c"
		}
		goto __finally26;
		__catch26_g_error:
		{
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->e = _data_->_inner_error_;
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_inner_error_ = NULL;
#line 490 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp7_ = _data_->e;
#line 490 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp8_ = _data_->_tmp7_->message;
#line 490 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_warning ("%s", _data_->_tmp8_);
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (_data_->e);
#line 3786 "tracker-store.c"
		}
		__finally26:
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_clear_error (&_data_->_inner_error_);
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_object_unref (_data_->_async_result);
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return FALSE;
#line 3799 "tracker-store.c"
		}
	}
#line 494 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = tracker_store_active;
#line 494 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp9_) {
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_sched ();
#line 3808 "tracker-store.c"
	}
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3818 "tracker-store.c"
		}
	}
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 3825 "tracker-store.c"
}


void
tracker_store_resume (void)
{
#line 500 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_active = TRUE;
#line 502 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 3836 "tracker-store.c"
}


TrackerStore*
tracker_store_construct (GType object_type)
{
	TrackerStore* self = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStore*) g_type_create_instance (object_type);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 3848 "tracker-store.c"
}


TrackerStore*
tracker_store_new (void)
{
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_construct (TRACKER_TYPE_STORE);
#line 3857 "tracker-store.c"
}


static TrackerStoreTask*
tracker_store_task_construct (GType object_type)
{
	TrackerStoreTask* self = NULL;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreTask*) g_type_create_instance (object_type);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 3869 "tracker-store.c"
}


static void
tracker_store_value_task_init (GValue* value)
{
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	value->data[0].v_pointer = NULL;
#line 3878 "tracker-store.c"
}


static void
tracker_store_value_task_free_value (GValue* value)
{
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (value->data[0].v_pointer) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (value->data[0].v_pointer);
#line 3889 "tracker-store.c"
	}
}


static void
tracker_store_value_task_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (src_value->data[0].v_pointer) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = tracker_store_task_ref (src_value->data[0].v_pointer);
#line 3902 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3906 "tracker-store.c"
	}
}


static gpointer
tracker_store_value_task_peek_pointer (const GValue* value)
{
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 3916 "tracker-store.c"
}


static gchar*
tracker_store_value_task_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (collect_values[0].v_pointer) {
#line 3928 "tracker-store.c"
		TrackerStoreTask * object;
		object = collect_values[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (object->parent_instance.g_class == NULL) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3935 "tracker-store.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3939 "tracker-store.c"
		}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = tracker_store_task_ref (object);
#line 3943 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 3947 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 3951 "tracker-store.c"
}


static gchar*
tracker_store_value_task_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	TrackerStoreTask ** object_p;
	object_p = collect_values[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!object_p) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3967 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!value->data[0].v_pointer) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = NULL;
#line 3973 "tracker-store.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = value->data[0].v_pointer;
#line 3977 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = tracker_store_task_ref (value->data[0].v_pointer);
#line 3981 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 3985 "tracker-store.c"
}


static GParamSpec*
tracker_store_param_spec_task (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	TrackerStoreParamSpecTask* spec;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_STORE_TYPE_TASK), NULL);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return G_PARAM_SPEC (spec);
#line 4005 "tracker-store.c"
}


static gpointer
tracker_store_value_get_task (const GValue* value)
{
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK), NULL);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 4016 "tracker-store.c"
}


static void
tracker_store_value_set_task (GValue* value,
                              gpointer v_object)
{
	TrackerStoreTask * old;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_ref (value->data[0].v_pointer);
#line 4039 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4043 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (old);
#line 4049 "tracker-store.c"
	}
}


static void
tracker_store_value_take_task (GValue* value,
                               gpointer v_object)
{
	TrackerStoreTask * old;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 4071 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4075 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (old);
#line 4081 "tracker-store.c"
	}
}


static void
tracker_store_task_class_init (TrackerStoreTaskClass * klass)
{
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_task_parent_class = g_type_class_peek_parent (klass);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTaskClass *) klass)->finalize = tracker_store_task_finalize;
#line 4093 "tracker-store.c"
}


static void
tracker_store_task_instance_init (TrackerStoreTask * self)
{
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->ref_count = 1;
#line 4102 "tracker-store.c"
}


static void
tracker_store_task_finalize (TrackerStoreTask * obj)
{
	TrackerStoreTask * self;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_TASK, TrackerStoreTask);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_signal_handlers_destroy (self);
#line 57 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->client_id);
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_error_free0 (self->error);
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->callback = NULL;
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->callback_target = NULL;
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->callback_target_destroy_notify = NULL;
#line 60 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (self->data_manager);
#line 4128 "tracker-store.c"
}


static GType
tracker_store_task_get_type (void)
{
	static volatile gsize tracker_store_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_task_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_store_value_task_init, tracker_store_value_task_free_value, tracker_store_value_task_copy_value, tracker_store_value_task_peek_pointer, "p", tracker_store_value_task_collect_value, "p", tracker_store_value_task_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreTask), 0, (GInstanceInitFunc) tracker_store_task_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_store_task_type_id;
		tracker_store_task_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStoreTask", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_store_task_type_id__volatile, tracker_store_task_type_id);
	}
	return tracker_store_task_type_id__volatile;
}


static gpointer
tracker_store_task_ref (gpointer instance)
{
	TrackerStoreTask * self;
	self = instance;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&self->ref_count);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return instance;
#line 4157 "tracker-store.c"
}


static void
tracker_store_task_unref (gpointer instance)
{
	TrackerStoreTask * self;
	self = instance;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		TRACKER_STORE_TASK_GET_CLASS (self)->finalize (self);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4172 "tracker-store.c"
	}
}


static TrackerStoreQueryTask*
tracker_store_query_task_construct (GType object_type)
{
	TrackerStoreQueryTask* self = NULL;
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreQueryTask*) tracker_store_task_construct (object_type);
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4185 "tracker-store.c"
}


static TrackerStoreQueryTask*
tracker_store_query_task_new (void)
{
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_query_task_construct (TRACKER_STORE_TYPE_QUERY_TASK);
#line 4194 "tracker-store.c"
}


static void
tracker_store_query_task_class_init (TrackerStoreQueryTaskClass * klass)
{
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_query_task_parent_class = g_type_class_peek_parent (klass);
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTaskClass *) klass)->finalize = tracker_store_query_task_finalize;
#line 4205 "tracker-store.c"
}


static void
tracker_store_query_task_instance_init (TrackerStoreQueryTask * self)
{
}


static void
tracker_store_query_task_finalize (TrackerStoreTask * obj)
{
	TrackerStoreQueryTask * self;
	guint _tmp0_;
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask);
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = self->watchdog_id;
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp0_ > ((guint) 0)) {
#line 4226 "tracker-store.c"
		guint _tmp1_;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = self->watchdog_id;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_source_remove (_tmp1_);
#line 4232 "tracker-store.c"
	}
#line 64 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->query);
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (self->cancellable);
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_query_task_parent_class)->finalize (obj);
#line 4240 "tracker-store.c"
}


static GType
tracker_store_query_task_get_type (void)
{
	static volatile gsize tracker_store_query_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_query_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreQueryTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_query_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreQueryTask), 0, (GInstanceInitFunc) tracker_store_query_task_instance_init, NULL };
		GType tracker_store_query_task_type_id;
		tracker_store_query_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreQueryTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_query_task_type_id__volatile, tracker_store_query_task_type_id);
	}
	return tracker_store_query_task_type_id__volatile;
}


static TrackerStoreUpdateTask*
tracker_store_update_task_construct (GType object_type)
{
	TrackerStoreUpdateTask* self = NULL;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreUpdateTask*) tracker_store_task_construct (object_type);
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4266 "tracker-store.c"
}


static TrackerStoreUpdateTask*
tracker_store_update_task_new (void)
{
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_update_task_construct (TRACKER_STORE_TYPE_UPDATE_TASK);
#line 4275 "tracker-store.c"
}


static void
tracker_store_update_task_class_init (TrackerStoreUpdateTaskClass * klass)
{
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_update_task_parent_class = g_type_class_peek_parent (klass);
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTaskClass *) klass)->finalize = tracker_store_update_task_finalize;
#line 4286 "tracker-store.c"
}


static void
tracker_store_update_task_instance_init (TrackerStoreUpdateTask * self)
{
}


static void
tracker_store_update_task_finalize (TrackerStoreTask * obj)
{
	TrackerStoreUpdateTask * self;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask);
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->query);
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_variant_unref0 (self->blank_nodes);
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_update_task_parent_class)->finalize (obj);
#line 4308 "tracker-store.c"
}


static GType
tracker_store_update_task_get_type (void)
{
	static volatile gsize tracker_store_update_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_update_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreUpdateTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_update_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreUpdateTask), 0, (GInstanceInitFunc) tracker_store_update_task_instance_init, NULL };
		GType tracker_store_update_task_type_id;
		tracker_store_update_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreUpdateTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_update_task_type_id__volatile, tracker_store_update_task_type_id);
	}
	return tracker_store_update_task_type_id__volatile;
}


static TrackerStoreTurtleTask*
tracker_store_turtle_task_construct (GType object_type)
{
	TrackerStoreTurtleTask* self = NULL;
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreTurtleTask*) tracker_store_task_construct (object_type);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4334 "tracker-store.c"
}


static TrackerStoreTurtleTask*
tracker_store_turtle_task_new (void)
{
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_turtle_task_construct (TRACKER_STORE_TYPE_TURTLE_TASK);
#line 4343 "tracker-store.c"
}


static void
tracker_store_turtle_task_class_init (TrackerStoreTurtleTaskClass * klass)
{
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_turtle_task_parent_class = g_type_class_peek_parent (klass);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTaskClass *) klass)->finalize = tracker_store_turtle_task_finalize;
#line 4354 "tracker-store.c"
}


static void
tracker_store_turtle_task_instance_init (TrackerStoreTurtleTask * self)
{
}


static void
tracker_store_turtle_task_finalize (TrackerStoreTask * obj)
{
	TrackerStoreTurtleTask * self;
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTask);
#line 83 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->path);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_turtle_task_parent_class)->finalize (obj);
#line 4374 "tracker-store.c"
}


static GType
tracker_store_turtle_task_get_type (void)
{
	static volatile gsize tracker_store_turtle_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_turtle_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreTurtleTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_turtle_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreTurtleTask), 0, (GInstanceInitFunc) tracker_store_turtle_task_instance_init, NULL };
		GType tracker_store_turtle_task_type_id;
		tracker_store_turtle_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreTurtleTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_turtle_task_type_id__volatile, tracker_store_turtle_task_type_id);
	}
	return tracker_store_turtle_task_type_id__volatile;
}


static void
tracker_value_store_init (GValue* value)
{
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	value->data[0].v_pointer = NULL;
#line 4397 "tracker-store.c"
}


static void
tracker_value_store_free_value (GValue* value)
{
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (value->data[0].v_pointer) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (value->data[0].v_pointer);
#line 4408 "tracker-store.c"
	}
}


static void
tracker_value_store_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = tracker_store_ref (src_value->data[0].v_pointer);
#line 4421 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4425 "tracker-store.c"
	}
}


static gpointer
tracker_value_store_peek_pointer (const GValue* value)
{
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 4435 "tracker-store.c"
}


static gchar*
tracker_value_store_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (collect_values[0].v_pointer) {
#line 4447 "tracker-store.c"
		TrackerStore * object;
		object = collect_values[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4454 "tracker-store.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4458 "tracker-store.c"
		}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = tracker_store_ref (object);
#line 4462 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4466 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 4470 "tracker-store.c"
}


static gchar*
tracker_value_store_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	TrackerStore ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!object_p) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4486 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!value->data[0].v_pointer) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = NULL;
#line 4492 "tracker-store.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = value->data[0].v_pointer;
#line 4496 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = tracker_store_ref (value->data[0].v_pointer);
#line 4500 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 4504 "tracker-store.c"
}


GParamSpec*
tracker_param_spec_store (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	TrackerParamSpecStore* spec;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_STORE), NULL);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return G_PARAM_SPEC (spec);
#line 4524 "tracker-store.c"
}


gpointer
tracker_value_get_store (const GValue* value)
{
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE), NULL);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 4535 "tracker-store.c"
}


void
tracker_value_set_store (GValue* value,
                         gpointer v_object)
{
	TrackerStore * old;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_ref (value->data[0].v_pointer);
#line 4558 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4562 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (old);
#line 4568 "tracker-store.c"
	}
}


void
tracker_value_take_store (GValue* value,
                          gpointer v_object)
{
	TrackerStore * old;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 4590 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4594 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (old);
#line 4600 "tracker-store.c"
	}
}


static void
tracker_store_class_init (TrackerStoreClass * klass)
{
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreClass *) klass)->finalize = tracker_store_finalize;
#line 4612 "tracker-store.c"
}


static void
tracker_store_instance_init (TrackerStore * self)
{
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->ref_count = 1;
#line 4621 "tracker-store.c"
}


static void
tracker_store_finalize (TrackerStore * obj)
{
	TrackerStore * self;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_STORE, TrackerStore);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_signal_handlers_destroy (self);
#line 4633 "tracker-store.c"
}


GType
tracker_store_get_type (void)
{
	static volatile gsize tracker_store_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_store_init, tracker_value_store_free_value, tracker_value_store_copy_value, tracker_value_store_peek_pointer, "p", tracker_value_store_collect_value, "p", tracker_value_store_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStore), 0, (GInstanceInitFunc) tracker_store_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_store_type_id;
		tracker_store_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStore", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_store_type_id__volatile, tracker_store_type_id);
	}
	return tracker_store_type_id__volatile;
}


gpointer
tracker_store_ref (gpointer instance)
{
	TrackerStore * self;
	self = instance;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return instance;
#line 4662 "tracker-store.c"
}


void
tracker_store_unref (gpointer instance)
{
	TrackerStore * self;
	self = instance;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		TRACKER_STORE_GET_CLASS (self)->finalize (self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4677 "tracker-store.c"
	}
}



