/* tracker-dbus.c generated by valac 0.40.6, the Vala compiler
 * generated from tracker-dbus.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-common/tracker-common.h"
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_DBUS (tracker_dbus_get_type ())
#define TRACKER_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_DBUS, TrackerDBus))
#define TRACKER_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_DBUS, TrackerDBusClass))
#define TRACKER_IS_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_DBUS))
#define TRACKER_IS_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_DBUS))
#define TRACKER_DBUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_DBUS, TrackerDBusClass))

typedef struct _TrackerDBus TrackerDBus;
typedef struct _TrackerDBusClass TrackerDBusClass;
typedef struct _TrackerDBusPrivate TrackerDBusPrivate;

#define TRACKER_TYPE_STATISTICS (tracker_statistics_get_type ())
#define TRACKER_STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATISTICS, TrackerStatistics))
#define TRACKER_STATISTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATISTICS, TrackerStatisticsClass))
#define TRACKER_IS_STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATISTICS))
#define TRACKER_IS_STATISTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATISTICS))
#define TRACKER_STATISTICS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATISTICS, TrackerStatisticsClass))

typedef struct _TrackerStatistics TrackerStatistics;
typedef struct _TrackerStatisticsClass TrackerStatisticsClass;

#define TRACKER_TYPE_RESOURCES (tracker_resources_get_type ())
#define TRACKER_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESOURCES, TrackerResources))
#define TRACKER_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))
#define TRACKER_IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESOURCES))
#define TRACKER_IS_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESOURCES))
#define TRACKER_RESOURCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))

typedef struct _TrackerResources TrackerResources;
typedef struct _TrackerResourcesClass TrackerResourcesClass;

#define TRACKER_TYPE_STEROIDS (tracker_steroids_get_type ())
#define TRACKER_STEROIDS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STEROIDS, TrackerSteroids))
#define TRACKER_STEROIDS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STEROIDS, TrackerSteroidsClass))
#define TRACKER_IS_STEROIDS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STEROIDS))
#define TRACKER_IS_STEROIDS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STEROIDS))
#define TRACKER_STEROIDS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STEROIDS, TrackerSteroidsClass))

typedef struct _TrackerSteroids TrackerSteroids;
typedef struct _TrackerSteroidsClass TrackerSteroidsClass;

#define TRACKER_TYPE_STATUS (tracker_status_get_type ())
#define TRACKER_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATUS, TrackerStatus))
#define TRACKER_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATUS, TrackerStatusClass))
#define TRACKER_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATUS))
#define TRACKER_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATUS))
#define TRACKER_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATUS, TrackerStatusClass))

typedef struct _TrackerStatus TrackerStatus;
typedef struct _TrackerStatusClass TrackerStatusClass;

#define TRACKER_TYPE_BACKUP (tracker_backup_get_type ())
#define TRACKER_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_BACKUP, TrackerBackup))
#define TRACKER_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_BACKUP, TrackerBackupClass))
#define TRACKER_IS_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_BACKUP))
#define TRACKER_IS_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_BACKUP))
#define TRACKER_BACKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_BACKUP, TrackerBackupClass))

typedef struct _TrackerBackup TrackerBackup;
typedef struct _TrackerBackupClass TrackerBackupClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TrackerParamSpecDBus TrackerParamSpecDBus;

struct _TrackerDBus {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerDBusPrivate * priv;
};

struct _TrackerDBusClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerDBus *self);
};

struct _TrackerParamSpecDBus {
	GParamSpec parent_instance;
};


static gpointer tracker_dbus_parent_class = NULL;
static GDBusConnection* tracker_dbus_connection;
static GDBusConnection* tracker_dbus_connection = NULL;
static guint tracker_dbus_name_owner_changed_id;
static guint tracker_dbus_name_owner_changed_id = 0U;
static TrackerStatistics* tracker_dbus_statistics;
static TrackerStatistics* tracker_dbus_statistics = NULL;
static guint tracker_dbus_statistics_id;
static guint tracker_dbus_statistics_id = 0U;
static TrackerResources* tracker_dbus_resources;
static TrackerResources* tracker_dbus_resources = NULL;
static guint tracker_dbus_resources_id;
static guint tracker_dbus_resources_id = 0U;
static TrackerSteroids* tracker_dbus_steroids;
static TrackerSteroids* tracker_dbus_steroids = NULL;
static guint tracker_dbus_steroids_id;
static guint tracker_dbus_steroids_id = 0U;
static TrackerStatus* tracker_dbus_notifier;
static TrackerStatus* tracker_dbus_notifier = NULL;
static guint tracker_dbus_notifier_id;
static guint tracker_dbus_notifier_id = 0U;
static TrackerBackup* tracker_dbus_backup;
static TrackerBackup* tracker_dbus_backup = NULL;
static guint tracker_dbus_backup_id;
static guint tracker_dbus_backup_id = 0U;
static guint tracker_dbus_domain_watch_id;
static guint tracker_dbus_domain_watch_id = 0U;
static GMainLoop* tracker_dbus_watch_main_loop;
static GMainLoop* tracker_dbus_watch_main_loop = NULL;

gpointer tracker_dbus_ref (gpointer instance);
void tracker_dbus_unref (gpointer instance);
GParamSpec* tracker_param_spec_dbus (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
void tracker_value_set_dbus (GValue* value,
                             gpointer v_object);
void tracker_value_take_dbus (GValue* value,
                              gpointer v_object);
gpointer tracker_value_get_dbus (const GValue* value);
GType tracker_dbus_get_type (void) G_GNUC_CONST;
GType tracker_statistics_get_type (void) G_GNUC_CONST;
guint tracker_statistics_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
GType tracker_resources_get_type (void) G_GNUC_CONST;
guint tracker_resources_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
GType tracker_steroids_get_type (void) G_GNUC_CONST;
guint tracker_steroids_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
GType tracker_status_get_type (void) G_GNUC_CONST;
guint tracker_status_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
GType tracker_backup_get_type (void) G_GNUC_CONST;
guint tracker_backup_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
#define TRACKER_DBUS_SERVICE "org.freedesktop.Tracker1"
static gboolean tracker_dbus_dbus_register_service (const gchar* name);
static guint tracker_dbus_register_object (GType t_type,
                                    GBoxedCopyFunc t_dup_func,
                                    GDestroyNotify t_destroy_func,
                                    GDBusConnection* lconnection,
                                    gconstpointer object,
                                    const gchar* path);
static guint _vala_g_dbus_connection_register_object (GType type,
                                               void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
gboolean tracker_dbus_register_names (const gchar* domain);
void tracker_dbus_on_domain_name_disappeared (GDBusConnection* connection,
                                              const gchar* name);
void tracker_status_wait (TrackerStatus* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
void tracker_status_wait_finish (TrackerStatus* self,
                                 GAsyncResult* _res_,
                                 GError** error);
void tracker_dbus_watch_domain (const gchar* domain,
                                GMainLoop* main_loop);
static void _tracker_dbus_on_domain_name_disappeared_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                           const gchar* name,
                                                                           gpointer self);
gboolean tracker_dbus_init (void);
static void tracker_dbus_name_owner_changed_cb (GDBusConnection* connection,
                                         const gchar* sender_name,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
void tracker_resources_unreg_batches (TrackerResources* self,
                                      const gchar* old_owner);
static void tracker_dbus_set_available (gboolean available);
gboolean tracker_dbus_register_objects (void);
void tracker_dbus_shutdown (void);
TrackerStatus* tracker_dbus_register_notifier (void);
TrackerStatus* tracker_status_new (void);
TrackerStatus* tracker_status_construct (GType object_type);
#define TRACKER_STATUS_PATH "/org/freedesktop/Tracker1/Status"
TrackerStatistics* tracker_statistics_new (void);
TrackerStatistics* tracker_statistics_construct (GType object_type);
#define TRACKER_STATISTICS_PATH "/org/freedesktop/Tracker1/Statistics"
TrackerResources* tracker_resources_new (GDBusConnection* connection);
TrackerResources* tracker_resources_construct (GType object_type,
                                               GDBusConnection* connection);
static void _tracker_dbus_name_owner_changed_cb_gd_bus_signal_callback (GDBusConnection* connection,
                                                                 const gchar* sender_name,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* signal_name,
                                                                 GVariant* parameters,
                                                                 gpointer self);
#define TRACKER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
TrackerSteroids* tracker_steroids_new (void);
TrackerSteroids* tracker_steroids_construct (GType object_type);
#define TRACKER_STEROIDS_PATH "/org/freedesktop/Tracker1/Steroids"
TrackerBackup* tracker_backup_new (void);
TrackerBackup* tracker_backup_construct (GType object_type);
#define TRACKER_BACKUP_PATH "/org/freedesktop/Tracker1/Backup"
gboolean tracker_dbus_register_prepare_class_signal (void);
void tracker_store_enable_signals (void);
GObject* tracker_dbus_get_object (GType type);
TrackerDBus* tracker_dbus_new (void);
TrackerDBus* tracker_dbus_construct (GType object_type);
static void tracker_dbus_finalize (TrackerDBus * obj);


static gboolean
tracker_dbus_dbus_register_service (const gchar* name)
{
	gboolean result = FALSE;
	gboolean _tmp9_ = FALSE;
	GError * _inner_error_ = NULL;
#line 40 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 41 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_message ("Registering D-Bus service...\n  Name:'%s'", name);
#line 267 "tracker-dbus.c"
	{
		GVariant* reply = NULL;
		GDBusConnection* _tmp0_;
		GVariant* _tmp1_;
		GVariant* _tmp2_;
		GVariant* _tmp3_;
		GVariant* _tmp4_;
		guint _result_ = 0U;
		GVariant* _tmp5_;
		guint _tmp6_;
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp0_ = tracker_dbus_connection;
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = g_variant_new ("(su)", name, 1 << 2, NULL);
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_variant_ref_sink (_tmp1_);
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp2_ = _tmp1_;
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp3_ = g_dbus_connection_call_sync (_tmp0_, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "RequestName", _tmp2_, (const GVariantType*) "(u)", 0, -1, NULL, &_inner_error_);
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp4_ = _tmp3_;
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_variant_unref0 (_tmp2_);
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		reply = _tmp4_;
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 296 "tracker-dbus.c"
			goto __catch2_g_error;
		}
#line 52 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp5_ = reply;
#line 52 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_variant_get (_tmp5_, "(u)", &_result_, NULL);
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp6_ = _result_;
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (_tmp6_ != ((guint) 1)) {
#line 54 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			g_critical ("D-Bus service name:'%s' is already taken, " "perhaps the daemon is already running?", name);
#line 57 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			result = FALSE;
#line 57 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_g_variant_unref0 (reply);
#line 57 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			return result;
#line 315 "tracker-dbus.c"
		}
#line 60 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = TRUE;
#line 60 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_variant_unref0 (reply);
#line 60 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 323 "tracker-dbus.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		e = _inner_error_;
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_inner_error_ = NULL;
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp7_ = e;
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp8_ = _tmp7_->message;
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("Could not aquire name:'%s', %s", name, _tmp8_);
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = FALSE;
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_error_free0 (e);
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 347 "tracker-dbus.c"
	}
	__finally2:
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_clear_error (&_inner_error_);
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return _tmp9_;
#line 356 "tracker-dbus.c"
}


static guint
_vala_g_dbus_connection_register_object (GType type,
                                         void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error)
{
	void *func;
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	func = g_type_get_qdata (type, g_quark_from_static_string ("vala-dbus-register-object"));
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (!func) {
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_set_error_literal (error, G_IO_ERROR, G_IO_ERROR_FAILED, "The specified type does not support D-Bus registration");
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return 0;
#line 376 "tracker-dbus.c"
	}
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return ((guint (*) (void *, GDBusConnection *, const gchar *, GError **)) func) (object, connection, path, error);
#line 380 "tracker-dbus.c"
}


static guint
tracker_dbus_register_object (GType t_type,
                              GBoxedCopyFunc t_dup_func,
                              GDestroyNotify t_destroy_func,
                              GDBusConnection* lconnection,
                              gconstpointer object,
                              const gchar* path)
{
	guint result = 0U;
	const gchar* _tmp0_;
	guint _tmp4_ = 0U;
	GError * _inner_error_ = NULL;
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_val_if_fail (lconnection != NULL, 0U);
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_val_if_fail (path != NULL, 0U);
#line 68 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_message ("Registering D-Bus object...");
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_message ("  Path:'%s'", path);
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = g_type_name (t_type);
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_message ("  Type:'%s'", _tmp0_);
#line 408 "tracker-dbus.c"
	{
		guint id = 0U;
		guint _tmp1_;
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = _vala_g_dbus_connection_register_object (t_type, object, lconnection, path, &_inner_error_);
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		id = _tmp1_;
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 418 "tracker-dbus.c"
			goto __catch3_g_error;
		}
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = id;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 425 "tracker-dbus.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 72 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		e = _inner_error_;
#line 72 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_inner_error_ = NULL;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp2_ = e;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp3_ = _tmp2_->message;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("Could not register D-Bus object: %s", _tmp3_);
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = (guint) 0;
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_error_free0 (e);
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 449 "tracker-dbus.c"
	}
	__finally3:
#line 72 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 72 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_clear_error (&_inner_error_);
#line 72 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return _tmp4_;
#line 458 "tracker-dbus.c"
}


gboolean
tracker_dbus_register_names (const gchar* domain)
{
	gboolean result = FALSE;
	gchar* service_name = NULL;
	const gchar* _tmp2_;
#line 84 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (domain != NULL) {
#line 470 "tracker-dbus.c"
		gchar* _tmp0_;
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp0_ = g_strdup (domain);
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_free0 (service_name);
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		service_name = _tmp0_;
#line 478 "tracker-dbus.c"
	} else {
		gchar* _tmp1_;
#line 88 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = g_strdup (TRACKER_DBUS_SERVICE);
#line 88 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_free0 (service_name);
#line 88 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		service_name = _tmp1_;
#line 487 "tracker-dbus.c"
	}
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp2_ = service_name;
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	result = tracker_dbus_dbus_register_service (_tmp2_);
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_g_free0 (service_name);
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return result;
#line 497 "tracker-dbus.c"
}


void
tracker_dbus_on_domain_name_disappeared (GDBusConnection* connection,
                                         const gchar* name)
{
	TrackerStatus* _tmp0_;
	GMainLoop* _tmp1_;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (connection != NULL);
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (name != NULL);
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = tracker_dbus_notifier;
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_status_wait (_tmp0_, NULL, NULL);
#line 97 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp1_ = tracker_dbus_watch_main_loop;
#line 97 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_main_loop_quit (_tmp1_);
#line 519 "tracker-dbus.c"
}


static gpointer
_g_main_loop_ref0 (gpointer self)
{
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return self ? g_main_loop_ref (self) : NULL;
#line 528 "tracker-dbus.c"
}


static void
_tracker_dbus_on_domain_name_disappeared_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                      const gchar* name,
                                                                      gpointer self)
{
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_on_domain_name_disappeared (connection, name);
#line 539 "tracker-dbus.c"
}


void
tracker_dbus_watch_domain (const gchar* domain,
                           GMainLoop* main_loop)
{
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
#line 100 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (main_loop != NULL);
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp1_ = tracker_dbus_domain_watch_id;
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp0_ = domain != NULL;
#line 557 "tracker-dbus.c"
	} else {
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp0_ = FALSE;
#line 561 "tracker-dbus.c"
	}
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_) {
#line 565 "tracker-dbus.c"
		GMainLoop* _tmp2_;
		GDBusConnection* _tmp3_;
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp2_ = _g_main_loop_ref0 (main_loop);
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_main_loop_unref0 (tracker_dbus_watch_main_loop);
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_watch_main_loop = _tmp2_;
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp3_ = tracker_dbus_connection;
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_domain_watch_id = g_bus_watch_name_on_connection_with_closures (_tmp3_, domain, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((_tracker_dbus_on_domain_name_disappeared_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _tracker_dbus_on_domain_name_disappeared_gbus_name_vanished_callback, NULL, (GClosureNotify) NULL)));
#line 578 "tracker-dbus.c"
	}
}


gboolean
tracker_dbus_init (void)
{
	gboolean result = FALSE;
	GDBusConnection* _tmp0_;
	GError * _inner_error_ = NULL;
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = tracker_dbus_connection;
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_ != NULL) {
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = TRUE;
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 597 "tracker-dbus.c"
	}
	{
		GDBusConnection* _tmp1_ = NULL;
		GDBusConnection* _tmp2_;
		GDBusConnection* _tmp3_;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp2_ = g_bus_get_sync (tracker_ipc_bus (), NULL, &_inner_error_);
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = _tmp2_;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 609 "tracker-dbus.c"
			goto __catch4_g_error;
		}
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp3_ = _tmp1_;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = NULL;
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_object_unref0 (tracker_dbus_connection);
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_connection = _tmp3_;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_object_unref0 (_tmp1_);
#line 622 "tracker-dbus.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		e = _inner_error_;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_inner_error_ = NULL;
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp4_ = e;
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp5_ = _tmp4_->message;
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("Could not connect to the D-Bus session bus, %s", _tmp5_);
#line 120 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = FALSE;
#line 120 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_error_free0 (e);
#line 120 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 646 "tracker-dbus.c"
	}
	__finally4:
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 651 "tracker-dbus.c"
		gboolean _tmp6_ = FALSE;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_clear_error (&_inner_error_);
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return _tmp6_;
#line 659 "tracker-dbus.c"
	}
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	result = TRUE;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return result;
#line 665 "tracker-dbus.c"
}


static void
tracker_dbus_name_owner_changed_cb (GDBusConnection* connection,
                                    const gchar* sender_name,
                                    const gchar* object_path,
                                    const gchar* interface_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
	const gchar* name = NULL;
	const gchar* old_owner = NULL;
	const gchar* new_owner = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
#line 126 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (connection != NULL);
#line 126 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (sender_name != NULL);
#line 126 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (object_path != NULL);
#line 126 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (interface_name != NULL);
#line 126 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (signal_name != NULL);
#line 126 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (parameters != NULL);
#line 129 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_variant_get (parameters, "(&s&s&s)", &name, &old_owner, &new_owner, NULL);
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp1_ = old_owner;
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (g_strcmp0 (_tmp1_, "") != 0) {
#line 700 "tracker-dbus.c"
		const gchar* _tmp2_;
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp2_ = new_owner;
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
#line 706 "tracker-dbus.c"
	} else {
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp0_ = FALSE;
#line 710 "tracker-dbus.c"
	}
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_) {
#line 714 "tracker-dbus.c"
		TrackerResources* _tmp3_;
		const gchar* _tmp4_;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp3_ = tracker_dbus_resources;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp4_ = old_owner;
#line 133 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_resources_unreg_batches (_tmp3_, _tmp4_);
#line 723 "tracker-dbus.c"
	}
}


static void
tracker_dbus_set_available (gboolean available)
{
#line 138 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (available) {
#line 733 "tracker-dbus.c"
		guint _tmp0_;
#line 139 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp0_ = tracker_dbus_resources_id;
#line 139 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (_tmp0_ == ((guint) 0)) {
#line 140 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			tracker_dbus_register_objects ();
#line 741 "tracker-dbus.c"
		}
	} else {
		guint _tmp1_;
#line 143 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = tracker_dbus_resources_id;
#line 143 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (_tmp1_ != ((guint) 0)) {
#line 749 "tracker-dbus.c"
			GDBusConnection* _tmp2_;
			guint _tmp3_;
			GDBusConnection* _tmp4_;
			guint _tmp5_;
			GDBusConnection* _tmp6_;
			guint _tmp7_;
#line 144 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_tmp2_ = tracker_dbus_connection;
#line 144 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_tmp3_ = tracker_dbus_name_owner_changed_id;
#line 144 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			g_dbus_connection_signal_unsubscribe (_tmp2_, _tmp3_);
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			tracker_dbus_name_owner_changed_id = (guint) 0;
#line 147 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_tmp4_ = tracker_dbus_connection;
#line 147 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_tmp5_ = tracker_dbus_resources_id;
#line 147 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			g_dbus_connection_unregister_object (_tmp4_, _tmp5_);
#line 148 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_g_object_unref0 (tracker_dbus_resources);
#line 148 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			tracker_dbus_resources = NULL;
#line 149 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			tracker_dbus_resources_id = (guint) 0;
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_tmp6_ = tracker_dbus_connection;
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_tmp7_ = tracker_dbus_steroids_id;
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			g_dbus_connection_unregister_object (_tmp6_, _tmp7_);
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			_g_object_unref0 (tracker_dbus_steroids);
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			tracker_dbus_steroids = NULL;
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			tracker_dbus_steroids_id = (guint) 0;
#line 788 "tracker-dbus.c"
		}
	}
}


void
tracker_dbus_shutdown (void)
{
	TrackerBackup* _tmp0_;
	TrackerStatus* _tmp3_;
	guint _tmp6_;
#line 159 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_set_available (FALSE);
#line 161 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = tracker_dbus_backup;
#line 161 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_ != NULL) {
#line 806 "tracker-dbus.c"
		GDBusConnection* _tmp1_;
		guint _tmp2_;
#line 162 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = tracker_dbus_connection;
#line 162 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp2_ = tracker_dbus_backup_id;
#line 162 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_dbus_connection_unregister_object (_tmp1_, _tmp2_);
#line 163 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_object_unref0 (tracker_dbus_backup);
#line 163 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_backup = NULL;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_backup_id = (guint) 0;
#line 821 "tracker-dbus.c"
	}
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp3_ = tracker_dbus_notifier;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp3_ != NULL) {
#line 827 "tracker-dbus.c"
		GDBusConnection* _tmp4_;
		guint _tmp5_;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp4_ = tracker_dbus_connection;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp5_ = tracker_dbus_notifier_id;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_dbus_connection_unregister_object (_tmp4_, _tmp5_);
#line 169 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_object_unref0 (tracker_dbus_notifier);
#line 169 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_notifier = NULL;
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_notifier_id = (guint) 0;
#line 842 "tracker-dbus.c"
	}
#line 173 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp6_ = tracker_dbus_domain_watch_id;
#line 173 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp6_ != ((guint) 0)) {
#line 848 "tracker-dbus.c"
		guint _tmp7_;
#line 174 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp7_ = tracker_dbus_domain_watch_id;
#line 174 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_bus_unwatch_name (_tmp7_);
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_domain_watch_id = (guint) 0;
#line 856 "tracker-dbus.c"
	}
#line 178 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_g_object_unref0 (tracker_dbus_connection);
#line 178 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_connection = NULL;
#line 862 "tracker-dbus.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return self ? g_object_ref (self) : NULL;
#line 871 "tracker-dbus.c"
}


TrackerStatus*
tracker_dbus_register_notifier (void)
{
	TrackerStatus* result = NULL;
	GDBusConnection* _tmp0_;
	TrackerStatus* _tmp1_;
	TrackerStatus* _tmp2_;
	GDBusConnection* _tmp3_;
	TrackerStatus* _tmp4_;
	TrackerStatus* _tmp5_;
	TrackerStatus* _tmp6_;
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = tracker_dbus_connection;
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_ == NULL) {
#line 183 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("D-Bus support must be initialized before registering objects!");
#line 184 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = NULL;
#line 184 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 896 "tracker-dbus.c"
	}
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp1_ = tracker_status_new ();
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_g_object_unref0 (tracker_dbus_notifier);
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_notifier = _tmp1_;
#line 189 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp2_ = tracker_dbus_notifier;
#line 189 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp2_ == NULL) {
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("Could not create TrackerStatus object to register");
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = NULL;
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 914 "tracker-dbus.c"
	}
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp3_ = tracker_dbus_connection;
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp4_ = tracker_dbus_notifier;
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_notifier_id = tracker_dbus_register_object (TRACKER_TYPE_STATUS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_, _tmp4_, TRACKER_STATUS_PATH);
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp5_ = tracker_dbus_notifier;
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	result = _tmp6_;
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return result;
#line 930 "tracker-dbus.c"
}


static void
_tracker_dbus_name_owner_changed_cb_gd_bus_signal_callback (GDBusConnection* connection,
                                                            const gchar* sender_name,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* signal_name,
                                                            GVariant* parameters,
                                                            gpointer self)
{
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_name_owner_changed_cb (connection, sender_name, object_path, interface_name, signal_name, parameters);
#line 945 "tracker-dbus.c"
}


gboolean
tracker_dbus_register_objects (void)
{
	gboolean result = FALSE;
	GDBusConnection* _tmp0_;
	TrackerStatistics* _tmp1_;
	TrackerStatistics* _tmp2_;
	GDBusConnection* _tmp3_;
	TrackerStatistics* _tmp4_;
	GDBusConnection* _tmp5_;
	TrackerResources* _tmp6_;
	TrackerResources* _tmp7_;
	GDBusConnection* _tmp8_;
	GDBusConnection* _tmp9_;
	TrackerResources* _tmp10_;
	TrackerSteroids* _tmp11_;
	TrackerSteroids* _tmp12_;
	GDBusConnection* _tmp13_;
	TrackerSteroids* _tmp14_;
	TrackerBackup* _tmp15_;
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = tracker_dbus_connection;
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_ == NULL) {
#line 203 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("D-Bus support must be initialized before registering objects!");
#line 204 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = FALSE;
#line 204 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 979 "tracker-dbus.c"
	}
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp1_ = tracker_statistics_new ();
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_g_object_unref0 (tracker_dbus_statistics);
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_statistics = _tmp1_;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp2_ = tracker_dbus_statistics;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp2_ == NULL) {
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("Could not create TrackerStatistics object to register");
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = FALSE;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 997 "tracker-dbus.c"
	}
#line 214 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp3_ = tracker_dbus_connection;
#line 214 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp4_ = tracker_dbus_statistics;
#line 214 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_statistics_id = tracker_dbus_register_object (TRACKER_TYPE_STATISTICS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_, _tmp4_, TRACKER_STATISTICS_PATH);
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp5_ = tracker_dbus_connection;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp6_ = tracker_resources_new (_tmp5_);
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_g_object_unref0 (tracker_dbus_resources);
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_resources = _tmp6_;
#line 218 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp7_ = tracker_dbus_resources;
#line 218 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp7_ == NULL) {
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("Could not create TrackerResources object to register");
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = FALSE;
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 1023 "tracker-dbus.c"
	}
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp8_ = tracker_dbus_connection;
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_name_owner_changed_id = g_dbus_connection_signal_subscribe (_tmp8_, "org.freedesktop.DBus", "org.freedesktop.DBus", "NameOwnerChanged", "/org/freedesktop/DBus", NULL, 0, _tracker_dbus_name_owner_changed_cb_gd_bus_signal_callback, NULL, NULL);
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp9_ = tracker_dbus_connection;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp10_ = tracker_dbus_resources;
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_resources_id = tracker_dbus_register_object (TRACKER_TYPE_RESOURCES, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp9_, _tmp10_, TRACKER_RESOURCES_PATH);
#line 233 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp11_ = tracker_steroids_new ();
#line 233 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_g_object_unref0 (tracker_dbus_steroids);
#line 233 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_steroids = _tmp11_;
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp12_ = tracker_dbus_steroids;
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp12_ == NULL) {
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_critical ("Could not create TrackerSteroids object to register");
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = FALSE;
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 1051 "tracker-dbus.c"
	}
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp13_ = tracker_dbus_connection;
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp14_ = tracker_dbus_steroids;
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_steroids_id = tracker_dbus_register_object (TRACKER_TYPE_STEROIDS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp13_, _tmp14_, TRACKER_STEROIDS_PATH);
#line 241 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp15_ = tracker_dbus_backup;
#line 241 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp15_ == NULL) {
#line 1063 "tracker-dbus.c"
		TrackerBackup* _tmp16_;
		TrackerBackup* _tmp17_;
		GDBusConnection* _tmp18_;
		TrackerBackup* _tmp19_;
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp16_ = tracker_backup_new ();
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_g_object_unref0 (tracker_dbus_backup);
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_backup = _tmp16_;
#line 244 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp17_ = tracker_dbus_backup;
#line 244 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (_tmp17_ == NULL) {
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			g_critical ("Could not create TrackerBackup object to register");
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			result = FALSE;
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			return result;
#line 1084 "tracker-dbus.c"
		}
#line 250 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp18_ = tracker_dbus_connection;
#line 250 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp19_ = tracker_dbus_backup;
#line 250 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_backup_id = tracker_dbus_register_object (TRACKER_TYPE_BACKUP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp18_, _tmp19_, TRACKER_BACKUP_PATH);
#line 1092 "tracker-dbus.c"
	}
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	result = TRUE;
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return result;
#line 1098 "tracker-dbus.c"
}


gboolean
tracker_dbus_register_prepare_class_signal (void)
{
	gboolean result = FALSE;
	TrackerResources* _tmp0_;
#line 257 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	_tmp0_ = tracker_dbus_resources;
#line 257 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (_tmp0_ == NULL) {
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_message ("Error during initialization, Resources DBus object not available");
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = FALSE;
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 1117 "tracker-dbus.c"
	}
#line 262 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_store_enable_signals ();
#line 264 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	result = TRUE;
#line 264 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return result;
#line 1125 "tracker-dbus.c"
}


GObject*
tracker_dbus_get_object (GType type)
{
	GObject* result = NULL;
#line 268 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (type == TRACKER_TYPE_RESOURCES) {
#line 1135 "tracker-dbus.c"
		TrackerResources* _tmp0_;
		GObject* _tmp1_;
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp0_ = tracker_dbus_resources;
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp1_ = _g_object_ref0 ((GObject*) _tmp0_);
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = _tmp1_;
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 1146 "tracker-dbus.c"
	}
#line 272 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (type == TRACKER_TYPE_STEROIDS) {
#line 1150 "tracker-dbus.c"
		TrackerSteroids* _tmp2_;
		GObject* _tmp3_;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp2_ = tracker_dbus_steroids;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp3_ = _g_object_ref0 ((GObject*) _tmp2_);
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = _tmp3_;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 1161 "tracker-dbus.c"
	}
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (type == TRACKER_TYPE_STATUS) {
#line 1165 "tracker-dbus.c"
		TrackerStatus* _tmp4_;
		GObject* _tmp5_;
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp4_ = tracker_dbus_notifier;
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp5_ = _g_object_ref0 ((GObject*) _tmp4_);
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = _tmp5_;
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 1176 "tracker-dbus.c"
	}
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (type == TRACKER_TYPE_BACKUP) {
#line 1180 "tracker-dbus.c"
		TrackerBackup* _tmp6_;
		GObject* _tmp7_;
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp6_ = tracker_dbus_backup;
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		_tmp7_ = _g_object_ref0 ((GObject*) _tmp6_);
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		result = _tmp7_;
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return result;
#line 1191 "tracker-dbus.c"
	}
#line 284 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	result = NULL;
#line 284 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return result;
#line 1197 "tracker-dbus.c"
}


TrackerDBus*
tracker_dbus_construct (GType object_type)
{
	TrackerDBus* self = NULL;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	self = (TrackerDBus*) g_type_create_instance (object_type);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return self;
#line 1209 "tracker-dbus.c"
}


TrackerDBus*
tracker_dbus_new (void)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return tracker_dbus_construct (TRACKER_TYPE_DBUS);
#line 1218 "tracker-dbus.c"
}


static void
tracker_value_dbus_init (GValue* value)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	value->data[0].v_pointer = NULL;
#line 1227 "tracker-dbus.c"
}


static void
tracker_value_dbus_free_value (GValue* value)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (value->data[0].v_pointer) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_unref (value->data[0].v_pointer);
#line 1238 "tracker-dbus.c"
	}
}


static void
tracker_value_dbus_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		dest_value->data[0].v_pointer = tracker_dbus_ref (src_value->data[0].v_pointer);
#line 1251 "tracker-dbus.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1255 "tracker-dbus.c"
	}
}


static gpointer
tracker_value_dbus_peek_pointer (const GValue* value)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return value->data[0].v_pointer;
#line 1265 "tracker-dbus.c"
}


static gchar*
tracker_value_dbus_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (collect_values[0].v_pointer) {
#line 1277 "tracker-dbus.c"
		TrackerDBus * object;
		object = collect_values[0].v_pointer;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1284 "tracker-dbus.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1288 "tracker-dbus.c"
		}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		value->data[0].v_pointer = tracker_dbus_ref (object);
#line 1292 "tracker-dbus.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		value->data[0].v_pointer = NULL;
#line 1296 "tracker-dbus.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return NULL;
#line 1300 "tracker-dbus.c"
}


static gchar*
tracker_value_dbus_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	TrackerDBus ** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (!object_p) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1316 "tracker-dbus.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (!value->data[0].v_pointer) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		*object_p = NULL;
#line 1322 "tracker-dbus.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		*object_p = value->data[0].v_pointer;
#line 1326 "tracker-dbus.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		*object_p = tracker_dbus_ref (value->data[0].v_pointer);
#line 1330 "tracker-dbus.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return NULL;
#line 1334 "tracker-dbus.c"
}


GParamSpec*
tracker_param_spec_dbus (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	TrackerParamSpecDBus* spec;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_DBUS), NULL);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return G_PARAM_SPEC (spec);
#line 1354 "tracker-dbus.c"
}


gpointer
tracker_value_get_dbus (const GValue* value)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_DBUS), NULL);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return value->data[0].v_pointer;
#line 1365 "tracker-dbus.c"
}


void
tracker_value_set_dbus (GValue* value,
                        gpointer v_object)
{
	TrackerDBus * old;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_DBUS));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (v_object) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_DBUS));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		value->data[0].v_pointer = v_object;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_ref (value->data[0].v_pointer);
#line 1388 "tracker-dbus.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		value->data[0].v_pointer = NULL;
#line 1392 "tracker-dbus.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (old) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_unref (old);
#line 1398 "tracker-dbus.c"
	}
}


void
tracker_value_take_dbus (GValue* value,
                         gpointer v_object)
{
	TrackerDBus * old;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_DBUS));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (v_object) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_DBUS));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		value->data[0].v_pointer = v_object;
#line 1420 "tracker-dbus.c"
	} else {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		value->data[0].v_pointer = NULL;
#line 1424 "tracker-dbus.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (old) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		tracker_dbus_unref (old);
#line 1430 "tracker-dbus.c"
	}
}


static void
tracker_dbus_class_init (TrackerDBusClass * klass)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	tracker_dbus_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	((TrackerDBusClass *) klass)->finalize = tracker_dbus_finalize;
#line 1442 "tracker-dbus.c"
}


static void
tracker_dbus_instance_init (TrackerDBus * self)
{
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	self->ref_count = 1;
#line 1451 "tracker-dbus.c"
}


static void
tracker_dbus_finalize (TrackerDBus * obj)
{
	TrackerDBus * self;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_DBUS, TrackerDBus);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_signal_handlers_destroy (self);
#line 1463 "tracker-dbus.c"
}


GType
tracker_dbus_get_type (void)
{
	static volatile gsize tracker_dbus_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_dbus_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_dbus_init, tracker_value_dbus_free_value, tracker_value_dbus_copy_value, tracker_value_dbus_peek_pointer, "p", tracker_value_dbus_collect_value, "p", tracker_value_dbus_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerDBusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_dbus_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerDBus), 0, (GInstanceInitFunc) tracker_dbus_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_dbus_type_id;
		tracker_dbus_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerDBus", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_dbus_type_id__volatile, tracker_dbus_type_id);
	}
	return tracker_dbus_type_id__volatile;
}


gpointer
tracker_dbus_ref (gpointer instance)
{
	TrackerDBus * self;
	self = instance;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	return instance;
#line 1492 "tracker-dbus.c"
}


void
tracker_dbus_unref (gpointer instance)
{
	TrackerDBus * self;
	self = instance;
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		TRACKER_DBUS_GET_CLASS (self)->finalize (self);
#line 21 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-dbus.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1507 "tracker-dbus.c"
	}
}



