/* valaarraylengthfield.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaarraylengthfield.h"
#include <stdlib.h>
#include <string.h>
#include <vala/valasourcereference.h>
#include <vala/valatypereference.h>
#include <vala/valamemberaccessibility.h>
#include <vala/valasourcefile.h>
#include <vala/valacodecontext.h>
#include <vala/valasymbol.h>
#include <vala/valadatatype.h>

struct _ValaArrayLengthFieldPrivate {
};
#define VALA_ARRAY_LENGTH_FIELD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_LENGTH_FIELD, ValaArrayLengthFieldPrivate))
enum  {
	VALA_ARRAY_LENGTH_FIELD_DUMMY_PROPERTY,
};
static GObject * vala_array_length_field_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_array_length_field_parent_class = NULL;


/**
 * Creates a new array length field.
 *
 * @return newly created field
 */
ValaArrayLengthField* vala_array_length_field_new (ValaSourceReference* source)
{
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 3);
	GParameter * __params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, "length"), __params_it++);
	ValaTypeReference* __temp0 = NULL;
	(__params_it->name = "type-reference", g_value_init (&__params_it->value, VALA_TYPE_TYPE_REFERENCE), g_value_set_object (&__params_it->value, (__temp0 = vala_type_reference_new ())), __params_it++);
	(__temp0 == NULL ? NULL : (__temp0 = (g_object_unref (__temp0), NULL)));
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaArrayLengthField * self = g_object_newv (VALA_TYPE_ARRAY_LENGTH_FIELD, __params_it - __params, __params);
	return self;
}


static GObject * vala_array_length_field_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties)
{
	GObject * obj;
	ValaArrayLengthFieldClass * klass;
	GObjectClass * parent_class;
	klass = VALA_ARRAY_LENGTH_FIELD_CLASS (g_type_class_peek (VALA_TYPE_ARRAY_LENGTH_FIELD));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	ValaArrayLengthField * self = VALA_ARRAY_LENGTH_FIELD (obj);
	{
		VALA_FIELD (self)->access = VALA_MEMBER_ACCESSIBILITY_PUBLIC;
		ValaSymbol* root_symbol = vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (self)))));
		ValaSymbol* __temp1 = NULL;
		(vala_type_reference_set_data_type (vala_field_get_type_reference (VALA_FIELD (self)), VALA_DATA_TYPE (vala_symbol_get_node ((__temp1 = vala_symbol_lookup (root_symbol, "int"))))), vala_type_reference_get_data_type (vala_field_get_type_reference (VALA_FIELD (self))));
		(__temp1 == NULL ? NULL : (__temp1 = (g_object_unref (__temp1), NULL)));
		(root_symbol = (g_object_unref (root_symbol), NULL));
	}
	return obj;
}


static void vala_array_length_field_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaArrayLengthField * self = VALA_ARRAY_LENGTH_FIELD (object);
	switch (property_id) {
	}
}


static void vala_array_length_field_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaArrayLengthField * self = VALA_ARRAY_LENGTH_FIELD (object);
	switch (property_id) {
	}
}


static void vala_array_length_field_class_init (ValaArrayLengthFieldClass * klass)
{
	vala_array_length_field_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = vala_array_length_field_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_array_length_field_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_array_length_field_constructor;
}


static void vala_array_length_field_init (ValaArrayLengthField * self)
{
}


GType vala_array_length_field_get_type ()
{
	static GType vala_array_length_field_type_id = 0;
	if (G_UNLIKELY (vala_array_length_field_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayLengthFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_length_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayLengthField), 0, (GInstanceInitFunc) vala_array_length_field_init };
		vala_array_length_field_type_id = g_type_register_static (VALA_TYPE_FIELD, "ValaArrayLengthField", &g_define_type_info, 0);
	}
	return vala_array_length_field_type_id;
}




