/* valaattributeprocessor.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaattributeprocessor.h"
#include <vala/valaattributeprocessor.h>

struct _ValaAttributeProcessorPrivate {
};
#define VALA_ATTRIBUTE_PROCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ATTRIBUTE_PROCESSOR, ValaAttributeProcessorPrivate))
enum  {
	VALA_ATTRIBUTE_PROCESSOR_DUMMY_PROPERTY,
};
static void vala_attribute_processor_real_visit_begin_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_attribute_processor_real_visit_begin_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_attribute_processor_real_visit_begin_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_attribute_processor_real_visit_begin_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_attribute_processor_real_visit_begin_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_attribute_processor_real_visit_begin_flags (ValaCodeVisitor* base, ValaFlags* fl);
static void vala_attribute_processor_real_visit_begin_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_attribute_processor_real_visit_begin_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_attribute_processor_real_visit_begin_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_attribute_processor_real_visit_begin_callback (ValaCodeVisitor* base, ValaCallback* cb);
static void vala_attribute_processor_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_attribute_processor_real_visit_begin_signal (ValaCodeVisitor* base, ValaSignal* sig);
static gpointer vala_attribute_processor_parent_class = NULL;


/**
 * Process all attributes found in specified code context.
 *
 * @param context a code context
 */
void vala_attribute_processor_process (ValaAttributeProcessor* self, ValaCodeContext* context)
{
	g_return_if_fail (VALA_IS_ATTRIBUTE_PROCESSOR (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	vala_code_context_accept (context, VALA_CODE_VISITOR (self));
}


static void vala_attribute_processor_real_visit_begin_namespace (ValaCodeVisitor* base, ValaNamespace* ns)
{
	ValaAttributeProcessor * self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (VALA_IS_NAMESPACE (ns));
	vala_namespace_process_attributes (ns);
}


static void vala_attribute_processor_real_visit_begin_class (ValaCodeVisitor* base, ValaClass* cl)
{
	ValaAttributeProcessor * self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	vala_class_process_attributes (cl);
}


static void vala_attribute_processor_real_visit_begin_struct (ValaCodeVisitor* base, ValaStruct* st)
{
	ValaAttributeProcessor * self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	vala_struct_process_attributes (st);
}


static void vala_attribute_processor_real_visit_begin_interface (ValaCodeVisitor* base, ValaInterface* iface)
{
	ValaAttributeProcessor * self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	vala_interface_process_attributes (iface);
}


static void vala_attribute_processor_real_visit_begin_enum (ValaCodeVisitor* base, ValaEnum* en)
{
	ValaAttributeProcessor * self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (VALA_IS_ENUM (en));
	vala_enum_process_attributes (en);
}


static void vala_attribute_processor_real_visit_begin_flags (ValaCodeVisitor* base, ValaFlags* fl)
{
	ValaAttributeProcessor * self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (VALA_IS_FLAGS (fl));
	vala_flags_process_attributes (fl);
}


static void vala_attribute_processor_real_visit_begin_method (ValaCodeVisitor* base, ValaMethod* m)
{
	ValaAttributeProcessor * self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (VALA_IS_METHOD (m));
	vala_method_process_attributes (m);
}


static void vala_attribute_processor_real_visit_begin_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m)
{
	ValaAttributeProcessor * self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (VALA_IS_CREATION_METHOD (m));
	vala_method_process_attributes (VALA_METHOD (m));
}


static void vala_attribute_processor_real_visit_begin_property (ValaCodeVisitor* base, ValaProperty* prop)
{
	ValaAttributeProcessor * self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (VALA_IS_PROPERTY (prop));
	vala_property_process_attributes (prop);
}


static void vala_attribute_processor_real_visit_begin_callback (ValaCodeVisitor* base, ValaCallback* cb)
{
	ValaAttributeProcessor * self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (VALA_IS_CALLBACK (cb));
	vala_callback_process_attributes (cb);
}


static void vala_attribute_processor_real_visit_field (ValaCodeVisitor* base, ValaField* f)
{
	ValaAttributeProcessor * self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (VALA_IS_FIELD (f));
	vala_field_process_attributes (f);
}


static void vala_attribute_processor_real_visit_begin_signal (ValaCodeVisitor* base, ValaSignal* sig)
{
	ValaAttributeProcessor * self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (VALA_IS_SIGNAL (sig));
	vala_signal_process_attributes (sig);
}


static void vala_attribute_processor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaAttributeProcessor * self = VALA_ATTRIBUTE_PROCESSOR (object);
	switch (property_id) {
	}
}


static void vala_attribute_processor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaAttributeProcessor * self = VALA_ATTRIBUTE_PROCESSOR (object);
	switch (property_id) {
	}
}


static void vala_attribute_processor_class_init (ValaAttributeProcessorClass * klass)
{
	vala_attribute_processor_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = vala_attribute_processor_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_attribute_processor_set_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_namespace = vala_attribute_processor_real_visit_begin_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_class = vala_attribute_processor_real_visit_begin_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_struct = vala_attribute_processor_real_visit_begin_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_interface = vala_attribute_processor_real_visit_begin_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_enum = vala_attribute_processor_real_visit_begin_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_flags = vala_attribute_processor_real_visit_begin_flags;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_method = vala_attribute_processor_real_visit_begin_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_creation_method = vala_attribute_processor_real_visit_begin_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_property = vala_attribute_processor_real_visit_begin_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_callback = vala_attribute_processor_real_visit_begin_callback;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_attribute_processor_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_signal = vala_attribute_processor_real_visit_begin_signal;
}


static void vala_attribute_processor_init (ValaAttributeProcessor * self)
{
}


GType vala_attribute_processor_get_type ()
{
	static GType vala_attribute_processor_type_id = 0;
	if (G_UNLIKELY (vala_attribute_processor_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAttributeProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_attribute_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAttributeProcessor), 0, (GInstanceInitFunc) vala_attribute_processor_init };
		vala_attribute_processor_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaAttributeProcessor", &g_define_type_info, 0);
	}
	return vala_attribute_processor_type_id;
}




