/* valafield.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valafield.h"
#include <vala/valatypereference.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valafield.h>
#include <vala/valacodevisitor.h>
#include <vala/valasymbol.h>
#include <vala/valadatatype.h>
#include <vala/valaattribute.h>
#include <vala/valacallback.h>

struct _ValaFieldPrivate {
	char* _name;
	ValaTypeReference* _type_reference;
	ValaExpression* _initializer;
	gboolean _no_array_length;
	char* cname;
	gboolean _instance;
	gboolean lock_used;
};
#define VALA_FIELD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FIELD, ValaFieldPrivate))
enum  {
	VALA_FIELD_DUMMY_PROPERTY,
	VALA_FIELD_NAME,
	VALA_FIELD_TYPE_REFERENCE,
	VALA_FIELD_INITIALIZER,
	VALA_FIELD_INSTANCE,
	VALA_FIELD_NO_ARRAY_LENGTH,
};
static void vala_field_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_field_set_cname (ValaField* self, const char* cname);
static void vala_field_process_ccode_attribute (ValaField* self, ValaAttribute* a);
static GList* vala_field_real_get_parameters (ValaInvokable* base);
static ValaTypeReference* vala_field_real_get_return_type (ValaInvokable* base);
static gboolean vala_field_real_is_invokable (ValaInvokable* base);
static gboolean vala_field_real_get_lock_used (ValaLockable* base);
static void vala_field_real_set_lock_used (ValaLockable* base, gboolean used);
static gpointer vala_field_parent_class = NULL;
static ValaInvokableIface* vala_field_vala_invokable_parent_iface = NULL;
static ValaLockableIface* vala_field_vala_lockable_parent_iface = NULL;
static void vala_field_dispose (GObject * obj);


/**
 * Creates a new field.
 *
 * @param name   field name
 * @param type   field type
 * @param init   initializer expression
 * @param source reference to source code
 * @return       newly created field
 */
ValaField* vala_field_new (const char* _name, ValaTypeReference* type, ValaExpression* init, ValaSourceReference* source)
{
	g_return_val_if_fail (_name != NULL, NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	g_return_val_if_fail (init == NULL || VALA_IS_EXPRESSION (init), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 4);
	GParameter * __params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, _name), __params_it++);
	(__params_it->name = "type-reference", g_value_init (&__params_it->value, VALA_TYPE_TYPE_REFERENCE), g_value_set_object (&__params_it->value, type), __params_it++);
	(__params_it->name = "initializer", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, init), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaField * self = g_object_newv (VALA_TYPE_FIELD, __params_it - __params, __params);
	return self;
}


static void vala_field_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaField * self = VALA_FIELD (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_member (visitor, VALA_MEMBER (self));
	vala_code_node_accept (VALA_CODE_NODE (vala_field_get_type_reference (self)), visitor);
	if (vala_field_get_initializer (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_field_get_initializer (self)), visitor);
	}
	vala_code_visitor_visit_field (visitor, self);
}


/**
 * Returns the name of this field as it is used in C code.
 *
 * @return the name to be used in C code
 */
char* vala_field_get_cname (ValaField* self)
{
	g_return_val_if_fail (VALA_IS_FIELD (self), NULL);
	if (self->priv->cname == NULL) {
		if (!vala_field_get_instance (self) && VALA_IS_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (self)))))) {
			ValaDataType* __temp0 = NULL;
			ValaDataType* t = (__temp0 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (self))))), (__temp0 == NULL ? NULL : g_object_ref (__temp0)));
			char* __temp2 = NULL;
			char* __temp1 = NULL;
			self->priv->cname = (__temp2 = g_strdup_printf ("%s_%s", (__temp1 = vala_data_type_get_lower_case_cname (t, NULL)), vala_field_get_name (self)), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp2);
			(__temp1 = (g_free (__temp1), NULL));
			(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
		} else {
			char* __temp3 = NULL;
			self->priv->cname = (__temp3 = g_strdup (vala_field_get_name (self)), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp3);
		}
	}
	const char* __temp4 = NULL;
	return (__temp4 = self->priv->cname, (__temp4 == NULL ? NULL : g_strdup (__temp4)));
}


static void vala_field_set_cname (ValaField* self, const char* cname)
{
	g_return_if_fail (VALA_IS_FIELD (self));
	g_return_if_fail (cname != NULL);
	char* __temp6 = NULL;
	self->priv->cname = (__temp6 = g_strdup (cname), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp6);
}


static void vala_field_process_ccode_attribute (ValaField* self, ValaAttribute* a)
{
	g_return_if_fail (VALA_IS_FIELD (self));
	g_return_if_fail (VALA_IS_ATTRIBUTE (a));
	if (vala_attribute_has_argument (a, "cname")) {
		char* __temp7 = NULL;
		vala_field_set_cname (self, (__temp7 = vala_attribute_get_string (a, "cname")));
		(__temp7 = (g_free (__temp7), NULL));
	}
}


/**
 * Process all associated attributes.
 */
void vala_field_process_attributes (ValaField* self)
{
	g_return_if_fail (VALA_IS_FIELD (self));
	{
		GList* __temp8 = NULL;
		__temp8 = VALA_CODE_NODE (self)->attributes;
		GList* a_it;
		for (a_it = __temp8; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* a = a_it->data;
			{
				if (g_utf8_collate (vala_attribute_get_name (a), "CCode") == 0) {
					vala_field_process_ccode_attribute (self, a);
				} else {
					if (g_utf8_collate (vala_attribute_get_name (a), "NoArrayLength") == 0) {
						(vala_field_set_no_array_length (self, TRUE), vala_field_get_no_array_length (self));
					}
				}
			}
		}
	}
}


static GList* vala_field_real_get_parameters (ValaInvokable* base)
{
	ValaField * self = VALA_FIELD (base);
	if (!vala_invokable_is_invokable (VALA_INVOKABLE (self))) {
		return NULL;
	}
	ValaCallback* __temp10 = NULL;
	ValaCallback* cb = (__temp10 = VALA_CALLBACK (vala_type_reference_get_data_type (vala_field_get_type_reference (self))), (__temp10 == NULL ? NULL : g_object_ref (__temp10)));
	GList* __temp11 = NULL;
	return (__temp11 = vala_callback_get_parameters (cb), (cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL))), __temp11);
	(cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL)));
}


static ValaTypeReference* vala_field_real_get_return_type (ValaInvokable* base)
{
	ValaField * self = VALA_FIELD (base);
	if (!vala_invokable_is_invokable (VALA_INVOKABLE (self))) {
		return VALA_TYPE_REFERENCE (NULL);
	}
	ValaCallback* __temp13 = NULL;
	ValaCallback* cb = (__temp13 = VALA_CALLBACK (vala_type_reference_get_data_type (vala_field_get_type_reference (self))), (__temp13 == NULL ? NULL : g_object_ref (__temp13)));
	ValaTypeReference* __temp14 = NULL;
	ValaTypeReference* __temp15 = NULL;
	return (__temp15 = (__temp14 = vala_callback_get_return_type (cb), (__temp14 == NULL ? NULL : g_object_ref (__temp14))), (cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL))), __temp15);
	(cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL)));
}


static gboolean vala_field_real_is_invokable (ValaInvokable* base)
{
	ValaField * self = VALA_FIELD (base);
	return (VALA_IS_CALLBACK (vala_type_reference_get_data_type (vala_field_get_type_reference (self))));
}


static gboolean vala_field_real_get_lock_used (ValaLockable* base)
{
	ValaField * self = VALA_FIELD (base);
	return self->priv->lock_used;
}


static void vala_field_real_set_lock_used (ValaLockable* base, gboolean used)
{
	ValaField * self = VALA_FIELD (base);
	self->priv->lock_used = used;
}


char* vala_field_get_name (ValaField* self)
{
	g_return_val_if_fail (VALA_IS_FIELD (self), NULL);
	return self->priv->_name;
}


void vala_field_set_name (ValaField* self, const char* value)
{
	g_return_if_fail (VALA_IS_FIELD (self));
	char* __temp19 = NULL;
	self->priv->_name = (__temp19 = g_strdup (value), (self->priv->_name = (g_free (self->priv->_name), NULL)), __temp19);
}


ValaTypeReference* vala_field_get_type_reference (ValaField* self)
{
	g_return_val_if_fail (VALA_IS_FIELD (self), NULL);
	return self->priv->_type_reference;
}


void vala_field_set_type_reference (ValaField* self, ValaTypeReference* value)
{
	g_return_if_fail (VALA_IS_FIELD (self));
	ValaTypeReference* __temp21 = NULL;
	self->priv->_type_reference = (__temp21 = g_object_ref (value), (self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL))), __temp21);
}


ValaExpression* vala_field_get_initializer (ValaField* self)
{
	g_return_val_if_fail (VALA_IS_FIELD (self), NULL);
	return self->priv->_initializer;
}


void vala_field_set_initializer (ValaField* self, ValaExpression* value)
{
	g_return_if_fail (VALA_IS_FIELD (self));
	ValaExpression* __temp24 = NULL;
	ValaExpression* __temp23 = NULL;
	self->priv->_initializer = (__temp24 = (__temp23 = value, (__temp23 == NULL ? NULL : g_object_ref (__temp23))), (self->priv->_initializer == NULL ? NULL : (self->priv->_initializer = (g_object_unref (self->priv->_initializer), NULL))), __temp24);
}


gboolean vala_field_get_instance (ValaField* self)
{
	g_return_val_if_fail (VALA_IS_FIELD (self), FALSE);
	return self->priv->_instance;
}


void vala_field_set_instance (ValaField* self, gboolean value)
{
	g_return_if_fail (VALA_IS_FIELD (self));
	self->priv->_instance = value;
}


gboolean vala_field_get_no_array_length (ValaField* self)
{
	g_return_val_if_fail (VALA_IS_FIELD (self), FALSE);
	return self->priv->_no_array_length;
}


void vala_field_set_no_array_length (ValaField* self, gboolean value)
{
	g_return_if_fail (VALA_IS_FIELD (self));
	self->priv->_no_array_length = value;
}


static void vala_field_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaField * self = VALA_FIELD (object);
	switch (property_id) {
		case VALA_FIELD_NAME:
		g_value_set_string (value, vala_field_get_name (self));
		break;
		case VALA_FIELD_TYPE_REFERENCE:
		g_value_set_object (value, vala_field_get_type_reference (self));
		break;
		case VALA_FIELD_INITIALIZER:
		g_value_set_object (value, vala_field_get_initializer (self));
		break;
		case VALA_FIELD_INSTANCE:
		g_value_set_boolean (value, vala_field_get_instance (self));
		break;
		case VALA_FIELD_NO_ARRAY_LENGTH:
		g_value_set_boolean (value, vala_field_get_no_array_length (self));
		break;
	}
}


static void vala_field_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaField * self = VALA_FIELD (object);
	switch (property_id) {
		case VALA_FIELD_NAME:
		vala_field_set_name (self, g_value_get_string (value));
		break;
		case VALA_FIELD_TYPE_REFERENCE:
		vala_field_set_type_reference (self, g_value_get_object (value));
		break;
		case VALA_FIELD_INITIALIZER:
		vala_field_set_initializer (self, g_value_get_object (value));
		break;
		case VALA_FIELD_INSTANCE:
		vala_field_set_instance (self, g_value_get_boolean (value));
		break;
		case VALA_FIELD_NO_ARRAY_LENGTH:
		vala_field_set_no_array_length (self, g_value_get_boolean (value));
		break;
	}
}


static void vala_field_class_init (ValaFieldClass * klass)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaFieldPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_field_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_field_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_field_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_field_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FIELD_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FIELD_TYPE_REFERENCE, g_param_spec_object ("type-reference", "foo", "bar", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FIELD_INITIALIZER, g_param_spec_object ("initializer", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FIELD_INSTANCE, g_param_spec_boolean ("instance", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FIELD_NO_ARRAY_LENGTH, g_param_spec_boolean ("no-array-length", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_field_vala_invokable_interface_init (ValaInvokableIface * iface)
{
	vala_field_vala_invokable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_parameters = vala_field_real_get_parameters;
	iface->get_return_type = vala_field_real_get_return_type;
	iface->is_invokable = vala_field_real_is_invokable;
}


static void vala_field_vala_lockable_interface_init (ValaLockableIface * iface)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_field_real_get_lock_used;
	iface->set_lock_used = vala_field_real_set_lock_used;
}


static void vala_field_init (ValaField * self)
{
	self->priv = VALA_FIELD_GET_PRIVATE (self);
	self->priv->_instance = TRUE;
	self->priv->lock_used = FALSE;
}


static void vala_field_dispose (GObject * obj)
{
	ValaField * self = VALA_FIELD (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL)));
	(self->priv->_initializer == NULL ? NULL : (self->priv->_initializer = (g_object_unref (self->priv->_initializer), NULL)));
	(self->priv->cname = (g_free (self->priv->cname), NULL));
	ValaFieldClass * klass;
	GObjectClass * parent_class;
	klass = VALA_FIELD_CLASS (g_type_class_peek (VALA_TYPE_FIELD));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_field_get_type ()
{
	static GType vala_field_type_id = 0;
	if (G_UNLIKELY (vala_field_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_init };
		vala_field_type_id = g_type_register_static (VALA_TYPE_MEMBER, "ValaField", &g_define_type_info, 0);
		static const GInterfaceInfo vala_invokable_info = { (GInterfaceInitFunc) vala_field_vala_invokable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		g_type_add_interface_static (vala_field_type_id, VALA_TYPE_INVOKABLE, &vala_invokable_info);
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
	}
	return vala_field_type_id;
}




