/* valaflags.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaflags.h"
#include <vala/valasourcereference.h>
#include <vala/valaflagsvalue.h>
#include <vala/valaflags.h>
#include <vala/valacodevisitor.h>
#include <vala/valanamespace.h>
#include <vala/valaattribute.h>

struct _ValaFlagsPrivate {
	GList* values;
	char* cname;
	char* cprefix;
};
#define VALA_FLAGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FLAGS, ValaFlagsPrivate))
enum  {
	VALA_FLAGS_DUMMY_PROPERTY,
};
static void vala_flags_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_flags_real_get_cname (ValaDataType* base, gboolean const_type);
static char* vala_flags_real_get_upper_case_cname (ValaDataType* base, const char* infix);
static gboolean vala_flags_real_is_reference_type (ValaDataType* base);
static void vala_flags_set_cname (ValaFlags* self, const char* cname);
static void vala_flags_process_ccode_attribute (ValaFlags* self, ValaAttribute* a);
static char* vala_flags_real_get_type_id (ValaDataType* base);
static char* vala_flags_real_get_marshaller_type_name (ValaDataType* base);
static char* vala_flags_real_get_get_value_function (ValaDataType* base);
static char* vala_flags_real_get_set_value_function (ValaDataType* base);
static char* vala_flags_real_get_default_value (ValaDataType* base);
static gpointer vala_flags_parent_class = NULL;
static void vala_flags_dispose (GObject * obj);


/**
 * Creates a new flags.
 *
 * @param name   type name
 * @param source reference to source code
 * @return       newly created flags
 */
ValaFlags* vala_flags_new (const char* name, ValaSourceReference* source_reference)
{
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	GParameter * __params = g_new0 (GParameter, 2);
	GParameter * __params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, name), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source_reference), __params_it++);
	ValaFlags * self = g_object_newv (VALA_TYPE_FLAGS, __params_it - __params, __params);
	return self;
}


/**
 * Appends the specified flags value to the list of values.
 *
 * @param value a flags value
 */
void vala_flags_add_value (ValaFlags* self, ValaFlagsValue* value)
{
	g_return_if_fail (VALA_IS_FLAGS (self));
	g_return_if_fail (VALA_IS_FLAGS_VALUE (value));
	self->priv->values = g_list_append (self->priv->values, g_object_ref (value));
}


static void vala_flags_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaFlags * self = VALA_FLAGS (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_begin_flags (visitor, self);
	{
		GList* __temp0 = NULL;
		__temp0 = self->priv->values;
		GList* value_it;
		for (value_it = __temp0; value_it != NULL; value_it = value_it->next) {
			ValaFlagsValue* value = value_it->data;
			{
				vala_code_node_accept (VALA_CODE_NODE (value), visitor);
			}
		}
	}
	vala_code_visitor_visit_end_flags (visitor, self);
}


static char* vala_flags_real_get_cname (ValaDataType* base, gboolean const_type)
{
	ValaFlags * self = VALA_FLAGS (base);
	if (self->priv->cname == NULL) {
		char* __temp2 = NULL;
		char* __temp1 = NULL;
		self->priv->cname = (__temp2 = g_strdup_printf ("%s%s", (__temp1 = vala_namespace_get_cprefix (VALA_DATA_TYPE (self)->namespace)), vala_data_type_get_name (VALA_DATA_TYPE (self))), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp2);
		(__temp1 = (g_free (__temp1), NULL));
	}
	const char* __temp3 = NULL;
	return (__temp3 = self->priv->cname, (__temp3 == NULL ? NULL : g_strdup (__temp3)));
}


static char* vala_flags_real_get_upper_case_cname (ValaDataType* base, const char* infix)
{
	ValaFlags * self = VALA_FLAGS (base);
	char* __temp7 = NULL;
	char* __temp6 = NULL;
	char* __temp5 = NULL;
	char* __temp8 = NULL;
	return (__temp8 = g_utf8_strup ((__temp7 = g_strdup_printf ("%s%s", (__temp5 = vala_namespace_get_lower_case_cprefix (VALA_DATA_TYPE (self)->namespace)), (__temp6 = vala_namespace_camel_case_to_lower_case (vala_data_type_get_name (VALA_DATA_TYPE (self)))))), -1), (__temp7 = (g_free (__temp7), NULL)), (__temp6 = (g_free (__temp6), NULL)), (__temp5 = (g_free (__temp5), NULL)), __temp8);
}


static gboolean vala_flags_real_is_reference_type (ValaDataType* base)
{
	ValaFlags * self = VALA_FLAGS (base);
	return FALSE;
}


static void vala_flags_set_cname (ValaFlags* self, const char* cname)
{
	g_return_if_fail (VALA_IS_FLAGS (self));
	g_return_if_fail (cname != NULL);
	char* __temp11 = NULL;
	self->priv->cname = (__temp11 = g_strdup (cname), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp11);
}


/**
 * Returns the string to be prepended to the name of members of this
 * enum when used in C code.
 *
 * @return the prefix to be used in C code
 */
char* vala_flags_get_cprefix (ValaFlags* self)
{
	g_return_val_if_fail (VALA_IS_FLAGS (self), NULL);
	if (self->priv->cprefix == NULL) {
		char* __temp13 = NULL;
		char* __temp12 = NULL;
		self->priv->cprefix = (__temp13 = g_strdup_printf ("%s_", (__temp12 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (self), NULL))), (self->priv->cprefix = (g_free (self->priv->cprefix), NULL)), __temp13);
		(__temp12 = (g_free (__temp12), NULL));
	}
	const char* __temp14 = NULL;
	return (__temp14 = self->priv->cprefix, (__temp14 == NULL ? NULL : g_strdup (__temp14)));
}


/**
 * Sets the string to be prepended to the name of members of this enum
 * when used in C code.
 *
 * @param cprefix the prefix to be used in C code
 */
void vala_flags_set_cprefix (ValaFlags* self, const char* cprefix)
{
	g_return_if_fail (VALA_IS_FLAGS (self));
	g_return_if_fail (cprefix != NULL);
	char* __temp16 = NULL;
	self->priv->cprefix = (__temp16 = g_strdup (cprefix), (self->priv->cprefix = (g_free (self->priv->cprefix), NULL)), __temp16);
}


static void vala_flags_process_ccode_attribute (ValaFlags* self, ValaAttribute* a)
{
	g_return_if_fail (VALA_IS_FLAGS (self));
	g_return_if_fail (VALA_IS_ATTRIBUTE (a));
	if (vala_attribute_has_argument (a, "cname")) {
		char* __temp17 = NULL;
		vala_flags_set_cname (self, (__temp17 = vala_attribute_get_string (a, "cname")));
		(__temp17 = (g_free (__temp17), NULL));
	}
	if (vala_attribute_has_argument (a, "cprefix")) {
		char* __temp18 = NULL;
		vala_flags_set_cprefix (self, (__temp18 = vala_attribute_get_string (a, "cprefix")));
		(__temp18 = (g_free (__temp18), NULL));
	}
	if (vala_attribute_has_argument (a, "cheader_filename")) {
		char* val = vala_attribute_get_string (a, "cheader_filename");
		{
			char** __temp19 = NULL;
			__temp19 = g_strsplit (val, ",", 0);
			char** filename_it;
			for (filename_it = __temp19; *filename_it != NULL; filename_it = filename_it + 1) {
				char* filename = *filename_it;
				{
					vala_data_type_add_cheader_filename (VALA_DATA_TYPE (self), filename);
				}
			}
			(__temp19 = (g_free (__temp19), NULL));
		}
		(val = (g_free (val), NULL));
	}
}


/**
 * Process all associated attributes.
 */
void vala_flags_process_attributes (ValaFlags* self)
{
	g_return_if_fail (VALA_IS_FLAGS (self));
	{
		GList* __temp20 = NULL;
		__temp20 = VALA_CODE_NODE (self)->attributes;
		GList* a_it;
		for (a_it = __temp20; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* a = a_it->data;
			{
				if (g_utf8_collate (vala_attribute_get_name (a), "CCode") == 0) {
					vala_flags_process_ccode_attribute (self, a);
				}
			}
		}
	}
}


static char* vala_flags_real_get_type_id (ValaDataType* base)
{
	ValaFlags * self = VALA_FLAGS (base);
	return g_strdup ("G_TYPE_INT");
}


/* FIXME: use GType-registered flags*/
static char* vala_flags_real_get_marshaller_type_name (ValaDataType* base)
{
	ValaFlags * self = VALA_FLAGS (base);
	return g_strdup ("FLAGS");
}


static char* vala_flags_real_get_get_value_function (ValaDataType* base)
{
	ValaFlags * self = VALA_FLAGS (base);
	return g_strdup ("g_value_get_flags");
}


static char* vala_flags_real_get_set_value_function (ValaDataType* base)
{
	ValaFlags * self = VALA_FLAGS (base);
	return g_strdup ("g_value_set_flags");
}


static char* vala_flags_real_get_default_value (ValaDataType* base)
{
	ValaFlags * self = VALA_FLAGS (base);
	return g_strdup ("0");
}


static void vala_flags_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaFlags * self = VALA_FLAGS (object);
	switch (property_id) {
	}
}


static void vala_flags_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaFlags * self = VALA_FLAGS (object);
	switch (property_id) {
	}
}


static void vala_flags_class_init (ValaFlagsClass * klass)
{
	vala_flags_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaFlagsPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_flags_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_flags_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_flags_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_flags_real_accept;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_flags_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_upper_case_cname = vala_flags_real_get_upper_case_cname;
	VALA_DATA_TYPE_CLASS (klass)->is_reference_type = vala_flags_real_is_reference_type;
	VALA_DATA_TYPE_CLASS (klass)->get_type_id = vala_flags_real_get_type_id;
	VALA_DATA_TYPE_CLASS (klass)->get_marshaller_type_name = vala_flags_real_get_marshaller_type_name;
	VALA_DATA_TYPE_CLASS (klass)->get_get_value_function = vala_flags_real_get_get_value_function;
	VALA_DATA_TYPE_CLASS (klass)->get_set_value_function = vala_flags_real_get_set_value_function;
	VALA_DATA_TYPE_CLASS (klass)->get_default_value = vala_flags_real_get_default_value;
}


static void vala_flags_init (ValaFlags * self)
{
	self->priv = VALA_FLAGS_GET_PRIVATE (self);
}


static void vala_flags_dispose (GObject * obj)
{
	ValaFlags * self = VALA_FLAGS (obj);
	(self->priv->values == NULL ? NULL : (self->priv->values = (g_list_foreach (self->priv->values, (GFunc) g_object_unref, NULL), g_list_free (self->priv->values), NULL)));
	(self->priv->cname = (g_free (self->priv->cname), NULL));
	(self->priv->cprefix = (g_free (self->priv->cprefix), NULL));
	ValaFlagsClass * klass;
	GObjectClass * parent_class;
	klass = VALA_FLAGS_CLASS (g_type_class_peek (VALA_TYPE_FLAGS));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_flags_get_type ()
{
	static GType vala_flags_type_id = 0;
	if (G_UNLIKELY (vala_flags_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFlagsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_flags_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFlags), 0, (GInstanceInitFunc) vala_flags_init };
		vala_flags_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaFlags", &g_define_type_info, 0);
	}
	return vala_flags_type_id;
}




